<?php
    use App\Models\Role;
?>
@extends('layouts.app')

@section('title', 'Add Roles')

@section('content')

<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Roles</h1>
        <a href="{{route('roles.index')}}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                class="fas fa-arrow-left fa-sm text-white-50"></i> Back</a>
    </div>

    {{-- Alert Messages --}}
    @include('common.alert')

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Add New Role</h6>
        </div>
        <form method="POST" action="{{route('roles.store')}}">
            @csrf
            <div class="card-body">
                <div class="form-group row">

                    <div class="col-sm-6 mb-3 mt-3 mb-sm-0">
                        <span style="color:red;">*</span>Role Name</label>
                        <input
                            type="text"
                            class="form-control form-control-user @error('role_name') is-invalid @enderror"
                            id="exampleFirstName"
                            placeholder="Role Name"
                            name="role_name"
                            value="{{ old('role_name') }}">

                        @error('role_name')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>

                    {{-- Role --}}
                    {{--  <div class="col-sm-6 mb-3 mt-3 mb-sm-0">
                        <span style="color:red;">*</span>Role</label>
                        <select class="form-control form-control-user @error('role_id') is-invalid @enderror" name="role_id">
                            <option selected disabled>Select Role</option>
                            @foreach ($roles as $role)
                                <option value="{{$role->id}}">{{$role->name}}</option>
                            @endforeach
                        </select>
                        @error('role_id')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>  --}}

                    {{-- Status --}}
                    <div class="col-sm-6 mb-3 mt-3 mb-sm-0">
                        <span style="color:red;">*</span>Status</label>
                        <select class="form-control form-control-user @error('status') is-invalid @enderror" name="status">
                            <option selected disabled>Select Status</option>
                            <option value="1" selected>Active</option>
                            <option value="0">Inactive</option>
                        </select>
                        @error('status')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    
                    <div class="col-sm-6 mb-3 mt-3 mb-sm-0">
                        <span style="color:red;">*</span>App Login</label>
                        <select class="form-control form-control-user @error('app_login') is-invalid @enderror" name="app_login">
                            <option selected disabled>Select Option</option>
                            <option value="1" selected>Yes</option>
                            <option value="0">No</option>
                        </select>
                        @error('app_login')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    
                    <div class="col-sm-6 mb-3 mt-3 mb-sm-0">
                        <span style="color:red;">*</span>Anexure Approval</label>
                        <select class="form-control form-control-user @error('anexure_approval') is-invalid @enderror" name="anexure_approval">
                            <option selected disabled>Select Option</option>
                            <option value="1" selected>Yes</option>
                            <option value="0">No</option>
                        </select>
                        @error('anexure_approval')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>

                </div>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    <div class="table-responsive">
                        <table class="table table-striped" cellspacing="0" width="100%">
                            <thead>
                            <tr>
                                <th>
                                    <div class="checkbox c-checkbox ">
                                        <label class="needsclick" data-toggle="tooltip" data-placement="top"
                                               title="select all permission">
                                            <strong>Permission</strong>
                                        </label>
                                    </div>
                                </th>
                                <th>
                                    <div class="checkbox c-checkbox ">
                                        <label class="needsclick" data-toggle="tooltip" data-placement="top"
                                               title="Listing">
                                            <strong>Listing</strong>
                                        </label>
                                    </div>
                                </th>
                                <th>
                                    <div class="checkbox c-checkbox ">
                                        <label class="needsclick" data-toggle="tooltip" data-placement="top"
                                               title="Create">
                                            <strong>Create</strong>
                                        </label>
                                    </div>
                                </th>
                                <th>
                                    <div class="checkbox c-checkbox ">
                                        <label class="needsclick" data-toggle="tooltip" data-placement="top"
                                               title="Update">
                                            <strong>Update</strong>
                                        </label>
                                    </div>
                                </th>
                                <th>
                                    <div class="checkbox c-checkbox ">
                                        <label class="needsclick" data-toggle="tooltip" data-placement="top"
                                               title="Delete">
                                            <strong>Delete</strong>
                                        </label>
                                    </div>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $menu_info = DB::table('tbl_menu')->where('status', '1')->orderBy('sort')->get();
                            foreach ($menu_info as $items) {
                                $menu['parents'][$items->parent][] = $items;
                            }
                            
                            $all_menus = isset($menu) && $menu ? Role::buildChild(0, $menu) : [];
                            if (!empty($all_menus)) {
                                foreach ($all_menus as $parent => $v_parent) {
                                    if (is_array($v_parent)) { // if this have child
                                        if (!empty($v_parent)) {
                                            foreach ($v_parent as $parent_id => $v_child) { ?>
                                                <style type="text/css">
                                                    .plus {
                                                        background: url('{{ asset('asset/img/icon_plus.png') }}') no-repeat 4px 5px;
                                                        background-size: 8px 8px;
                                                    }
        
                                                    .minus {
                                                        background: url('{{ asset('asset/img/icon_minus.png') }}') no-repeat 4px 8px;
                                                        background-size: 8px 2px;
                                                    }
        
                                                    .parent {
                                                        width: 4%;
                                                        margin-top: 6px;
                                                        cursor: pointer;
                                                    }
        
                                                    .parent span {
                                                        visibility: hidden;
                                                    }
        
                                                    .child {
                                                        display: none
                                                    }
                                                </style>
                                                <tr style="background: #e2e2e2;">
                                                    <th>
                                                        <div id="parent_{{ $parent_id }}" class="parent plus pull-left"></div>
                                                        <div class="checkbox c-checkbox pull-left">
                                                            <label class="needsclick " data-toggle="tooltip"
                                                                   data-placement="top"
                                                                   title="select all">
                                                                <strong>{{ $parent }}</strong>
                                                            </label>
                                                        </div>
                                                    </th>
                                                    <th>
                                                        <div class="checkbox c-checkbox ">
                                                            <label class="needsclick view" data-toggle="tooltip"
                                                                   data-placement="top"
                                                                   title="select all">
                                                                <input id="all_view_<?php if (!empty($parent_id)) {
                                                                    echo $parent_id;
                                                                } ?>" class="<?php if (!empty($parent_id)) {
                                                                    echo $parent_id;
                                                                } ?>" type="checkbox" name="view_{{ $parent_id }}"
                                                                       value="1">
                                                                
                                                            </label>
                                                        </div>
                                                    </th>
                                                    <th>
                                                        <div class="checkbox c-checkbox ">
                                                            <label class="needsclick create" data-toggle="tooltip"
                                                                   data-placement="top"
                                                                   title="select all">
                                                                <input id="all_create_<?php if (!empty($parent_id)) {
                                                                    echo $parent_id;
                                                                } ?>" class="<?php if (!empty($parent_id)) {
                                                                    echo $parent_id;
                                                                } ?>" type="checkbox" name="created_{{ $parent_id }}"
                                                                       value="1">
                                                                
                                                            </label>
                                                        </div>
                                                    </th>
                                                    <th>
                                                        <div class="checkbox c-checkbox">
                                                            <label class="needsclick edit" data-toggle="tooltip"
                                                                   data-placement="top"
                                                                   title="select all">
                                                                <input id="all_edit_<?php if (!empty($parent_id)) {
                                                                    echo $parent_id;
                                                                } ?>" class="<?php if (!empty($parent_id)) {
                                                                    echo $parent_id;
                                                                } ?>" type="checkbox" name="edited_{{ $parent_id }}"
                                                                       value="1">
                                                                
                                                            </label>
                                                        </div>
                                                    </th>
                                                    <th>
                                                        <div class="checkbox c-checkbox">
                                                            <label class="needsclick delete" data-toggle="tooltip"
                                                                   data-placement="top"
                                                                   title="select all">
                                                                <input id="all_delete_<?php if (!empty($parent_id)) {
                                                                    echo $parent_id;
                                                                } ?>" class="<?php if (!empty($parent_id)) {
                                                                    echo $parent_id;
                                                                } ?>" type="checkbox" name="deleted_{{ $parent_id }}"
                                                                       value="1">
                                                                
                                                            </label>
                                                        </div>
                                                    </th>
                                                </tr>
                                                <?php
                                                if (!empty($v_child)) {
                                                    foreach ($v_child as $child => $v_sub_child) {
                                                        if (is_array($v_sub_child)) {
                                                            foreach ($v_sub_child as $sub_chld => $v_sub_chld) { ?>
                                                                <tr style="background: #eeeeee">
                                                                    <td style="display: block;padding-left: 35px;">
                                                                        <div id="parent_{{ $sub_chld; }}"
                                                                             class="parent plus pull-left"></div>
                                                                        <div class="checkbox c-checkbox pull-left">
                                                                            <label class="needsclick " data-toggle="tooltip"
                                                                                   data-placement="top"
                                                                                   title="select all">
                                                                                <input <?php
                                                                                if (!empty($roll[$sub_chld])) {
                                                                                    echo $roll[$sub_chld] ? 'checked' : '';
                                                                                }
                                                                                ?> class="{{ $parent_id; }}"
                                                                                   id="{{ $sub_chld; }}" type="checkbox"
                                                                                   name="menu[]" value="1">
                                                                                
                                                                                <strong>{{ $child }}</strong>
                                                                            </label>
                                                                        </div>
                                                                    </td>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td></td>
                                                                </tr>
                                                                <?php
                                                                foreach ($v_sub_chld as $sub_chld_name => $sub_chld_id) {
                                                                    if (is_array($sub_chld_id)) {
                                                                        foreach ($sub_chld_id as $sub_chld_1 => $v_sub_chld_1) { ?>
                                                                            <tr style="background: #e2e2e2">
                                                                                <td style="display: block;padding-left: 60px;">
                                                                                    <div id="parent_{{ $sub_chld_1; }}"
                                                                                         class="parent plus pull-left"></div>
                                                                                    <div class="checkbox c-checkbox pull-left">
                                                                                        <label class="needsclick "
                                                                                               data-toggle="tooltip"
                                                                                               data-placement="top"
                                                                                               title="select all">
                                                                                            <input
                                                                                                <?php
                                                                                                if (!empty($roll[$sub_chld_1])) {
                                                                                                    echo $roll[$sub_chld_1] ? 'checked' : '';
                                                                                                }
                                                                                                ?>
                                                                                                class="{{ $parent_id . ' ' . $sub_chld; }}"
                                                                                                id="{{ $sub_chld_1; }}"
                                                                                                type="checkbox" name="menu[]"
                                                                                                value="1">
                                                                                            
                                                                                            <strong>{{ $sub_chld_name }}</strong>
                                                                                        </label>
                                                                                    </div>
                                                                                </td>
                                                                                <td></td>
                                                                                <td></td>
                                                                                <td></td>
                                                                            </tr>
                                                                            <?php
                                                                            foreach ($v_sub_chld_1 as $sub_chld_name_1 => $v_sub_chld_2) {
                                                                                if (is_array($v_sub_chld_2)) {
                                                                                    foreach ($v_sub_chld_2 as $sub_chld_name_2 => $v_sub_chld_3) {
                                                                                        ?>
                                                                                        <tr style="background: #eeeeee">
                                                                                            <td style="display: block;padding-left: 85px;">
                                                                                                <div
                                                                                                    id="parent_<?= $sub_chld_name_2; ?>"
                                                                                                    class="parent plus pull-left">
                                                                                                    <span>X</span></div>
                                                                                                <div
                                                                                                    class="checkbox c-checkbox pull-left">
                                                                                                    <label class="needsclick "
                                                                                                           data-toggle="tooltip"
                                                                                                           data-placement="top"
                                                                                                           title="select all">
                                                                                                        <input
                                                                                                            <?php if (!empty($roll[$sub_chld_name_2])) {
                                                                                                                echo $roll[$sub_chld_name_2] ? 'checked' : '';
                                                                                                            }
                                                                                                            ?>
                                                                                                            class="{{ $parent_id . ' ' . $sub_chld . ' ' . $sub_chld_1; }}"
                                                                                                            id="{{ $sub_chld_name_2; }}"
                                                                                                            type="checkbox"
                                                                                                            name="menu[]"
                                                                                                            value="1">
                                                                                                <span
                                                                                                    class="fa fa-check"></span>
                                                                                                        <strong>{{ $sub_chld_name_1 }}</strong>
                                                                                                    </label>
                                                                                                </div>
                                                                                            </td>
                                                                                            <td></td>
                                                                                            <td></td>
                                                                                            <td></td>
                                                                                        </tr>
                                                                                        <?php
                                                                                        foreach ($v_sub_chld_3 as $sub_chld_name_3 => $v_sub_chld_4) {
                                                                                            if (is_array($v_sub_chld_4)) {
        
                                                                                            } else {
                                                                                                ?>
                                                                                                <tr class="child c_<?= $sub_chld_name_2; ?>">
                                                                                                    <td style="display: block;padding-left: 110px">
                                                                                                        <div
                                                                                                            class="checkbox c-checkbox">
                                                                                                            <label
                                                                                                                class="needsclick "
                                                                                                                data-toggle="tooltip"
                                                                                                                data-placement="top"
                                                                                                                title="select">
                                                                                                                <input <?php if (!empty($roll[$v_sub_chld_4])) {
                                                                                                                    echo $roll[$v_sub_chld_4] ? 'checked' : '';
                                                                                                                }
                                                                                                                ?> id="{{ $v_sub_chld_4; }}"
                                                                                                                   class="{{ $parent_id . ' ' . $sub_chld . ' ' . $sub_chld_name_2 . ' ' . $sub_chld_1; }}"
                                                                                                                   type="checkbox"
                                                                                                                   name="menu[]"
                                                                                                                   value="1">
                                                                                                        <span
                                                                                                            class="fa fa-check"></span>
                                                                                                                <strong>{{ $sub_chld_name_3 }}</strong>
                                                                                                            </label>
                                                                                                        </div>
                                                                                                    </td>
                                                                                                    <td>
                                                                                                        <div
                                                                                                            class="checkbox c-checkbox ">
                                                                                                            <label
                                                                                                                class="needsclick view"
                                                                                                                data-toggle="tooltip"
                                                                                                                data-placement="top"
                                                                                                                title="View Help">
                                                                                                                <input
                                                                                                                    <?php if (!empty($roll[$v_sub_chld_4])) {
                                                                                                                        echo $roll[$v_sub_chld_4] ? 'checked' : '';
                                                                                                                    }
                                                                                                                    ?>
                                                                                                                    class="{{ $sub_chld . ' ' . $v_sub_chld_4 . ' ' . $sub_chld_name_2 . ' ' . $parent_id . ' ' . $sub_chld_1; }}"
                                                                                                                    type="checkbox"
                                                                                                                    name="view_{{ $v_sub_chld_4 }}"
                                                                                                                    value="1">
                                                                                                        <span
                                                                                                            class="fa fa-check"></span>
                                                                                                            </label>
                                                                                                        </div>
                                                                                                    </td>
                                                                                                    <td>
                                                                                                        <div
                                                                                                            class="checkbox c-checkbox ">
                                                                                                            <label
                                                                                                                class="needsclick create"
                                                                                                                data-toggle="tooltip"
                                                                                                                data-placement="top"
                                                                                                                title="can create">
                                                                                                                <input
                                                                                                                    <?php if (!empty($roll[$v_sub_chld_4])) {
                                                                                                                        echo $roll[$v_sub_chld_4]->created == $v_sub_chld_4 ? 'checked' : '';
                                                                                                                    }
                                                                                                                    ?>class="{{ $sub_chld . ' ' . $v_sub_chld_4 . ' ' . $sub_chld_name_2 . ' ' . $parent_id . ' ' . $sub_chld_1; }}"
                                                                                                                    type="checkbox"
                                                                                                                    name="created_{{ $v_sub_chld_4; }}"
                                                                                                                    value="1">
                                                                                                        <span
                                                                                                            class="fa fa-check"></span>
                                                                                                            </label>
                                                                                                        </div>
                                                                                                    </td>
                                                                                                    <td>
                                                                                                        <div
                                                                                                            class="checkbox c-checkbox">
                                                                                                            <label
                                                                                                                class="needsclick edit"
                                                                                                                data-toggle="tooltip"
                                                                                                                data-placement="top"
                                                                                                                title="can edit">
                                                                                                                <input <?php
                                                                                                                if (!empty($roll[$v_sub_chld_4])) {
                                                                                                                    echo $roll[$v_sub_chld_4]->edited == $v_sub_chld_4 ? 'checked' : '';
                                                                                                                }
                                                                                                                ?>
                                                                                                                    class="{{ $sub_chld . ' ' . $v_sub_chld_4 . ' ' . $sub_chld_name_2 . ' ' . $parent_id . ' ' . $sub_chld_1; }}"
                                                                                                                    type="checkbox"
                                                                                                                    name="edited_{{ $v_sub_chld_4 }}"
                                                                                                                    value="1">
                                                                                                        <span
                                                                                                            class="fa fa-check"></span>
                                                                                                            </label>
                                                                                                        </div>
                                                                                                    </td>
                                                                                                    <td>
                                                                                                        <div
                                                                                                            class="checkbox c-checkbox">
                                                                                                            <label
                                                                                                                class="needsclick delete"
                                                                                                                data-toggle="tooltip"
                                                                                                                data-placement="top"
                                                                                                                title="can delete">
                                                                                                                <input <?php
                                                                                                                if (!empty($roll[$v_sub_chld_4])) {
                                                                                                                    echo $roll[$v_sub_chld_4]->deleted == $v_sub_chld_4 ? 'checked' : '';
                                                                                                                }
                                                                                                                ?> class="{{ $sub_chld . ' ' . $v_sub_chld_4 . ' ' . $sub_chld_name_2 . ' ' . $parent_id . ' ' . $sub_chld_1; }}"
                                                                                                                   type="checkbox"
                                                                                                                   name="deleted_{{ $v_sub_chld_4; }}"
                                                                                                                   value="1">
                                                                                                        <span
                                                                                                            class="fa fa-check"></span>
                                                                                                            </label>
                                                                                                        </div>
                                                                                                    </td>
                                                                                                </tr>
                                                                                                <?php
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                } else { ?>
                                                                                    <tr class="child c_{{ $sub_chld_1; }}">
                                                                                        <td style="display: block;padding-left: 85px">
                                                                                            <div class="checkbox c-checkbox ">
                                                                                                <label class="needsclick "
                                                                                                       data-toggle="tooltip"
                                                                                                       data-placement="top"
                                                                                                       title="select">
                                                                                                    <input <?php if (!empty($roll[$v_sub_chld_2])) {
                                                                                                        echo $roll[$v_sub_chld_2] ? 'checked' : '';
                                                                                                    }
                                                                                                    ?> id="{{ $v_sub_chld_2; }}"
                                                                                                       class="{{ $parent_id . ' ' . $sub_chld . ' ' . $sub_chld_1; }}"
                                                                                                       type="checkbox"
                                                                                                       name="menu[]"
                                                                                                       value="1">
                                                                                                <span
                                                                                                    class="fa fa-check"></span>
                                                                                                    <strong>{{ $sub_chld_name_1 }}</strong>
                                                                                                </label>
                                                                                            </div>
                                                                                        </td>
                                                                                        <td>
                                                                                            <div class="checkbox c-checkbox ">
                                                                                                <label class="needsclick view"
                                                                                                       data-toggle="tooltip"
                                                                                                       data-placement="top"
                                                                                                       title="View Help">
                                                                                                    <input <?php if (!empty($roll[$v_sub_chld_2])) {
                                                                                                        echo $roll[$v_sub_chld_2] ? 'checked' : '';
                                                                                                    }
                                                                                                    ?>
                                                                                                        class="{{ $sub_chld . ' ' . $parent_id . ' ' . $v_sub_chld_2 . ' ' . $sub_chld_1; }}"
                                                                                                        type="checkbox"
                                                                                                        name="view_{{ $v_sub_chld_2 }}"
                                                                                                        value="1">
                                                                                                <span
                                                                                                    class="fa fa-check"></span>
                                                                                                </label>
                                                                                            </div>
                                                                                        </td>
                                                                                        <td>
                                                                                            <div class="checkbox c-checkbox ">
                                                                                                <label class="needsclick create"
                                                                                                       data-toggle="tooltip"
                                                                                                       data-placement="top"
                                                                                                       title="can create">
                                                                                                    <input <?php if (!empty($roll[$v_sub_chld_2])) {
                                                                                                        echo $roll[$v_sub_chld_2]->created == $v_sub_chld_2 ? 'checked' : '';
                                                                                                    } ?>
                                                                                                        class="{{ $sub_chld . ' ' . $parent_id . ' ' . $v_sub_chld_2 . ' ' . $sub_chld_1; }}"
                                                                                                        type="checkbox"
                                                                                                        name="created_{{ $v_sub_chld_2 }}"
                                                                                                        value="1">
                                                                                                <span
                                                                                                    class="fa fa-check"></span>
                                                                                                </label>
                                                                                            </div>
                                                                                        </td>
                                                                                        <td>
                                                                                            <div class="checkbox c-checkbox">
                                                                                                <label class="needsclick edit"
                                                                                                       data-toggle="tooltip"
                                                                                                       data-placement="top"
                                                                                                       title="can edit">
                                                                                                    <input <?php
                                                                                                    if (!empty($roll[$v_sub_chld_2])) {
                                                                                                        echo $roll[$v_sub_chld_2]->edited == $v_sub_chld_2 ? 'checked' : '';
                                                                                                    }
                                                                                                    ?> class="{{ $sub_chld_1 . ' ' . $sub_chld . ' ' . $v_sub_chld_2 . ' ' . $parent_id; }}"
                                                                                                       type="checkbox"
                                                                                                       name="edited_{{ $v_sub_chld_2; }}"
                                                                                                       value="1">
                                                                                                <span
                                                                                                    class="fa fa-check"></span>
                                                                                                </label>
                                                                                            </div>
                                                                                        </td>
                                                                                        <td>
                                                                                            <div class="checkbox c-checkbox">
                                                                                                <label class="needsclick delete"
                                                                                                       data-toggle="tooltip"
                                                                                                       data-placement="top"
                                                                                                       title="can delete">
                                                                                                    <input <?php
                                                                                                    if (!empty($roll[$v_sub_chld_2])) {
                                                                                                        echo $roll[$v_sub_chld_2]->deleted == $v_sub_chld_2 ? 'checked' : '';
                                                                                                    }
                                                                                                    ?>
                                                                                                        class="{{ $sub_chld_1 . ' ' . $sub_chld . ' ' . $v_sub_chld_2 . ' ' . $parent_id; }}"
                                                                                                        type="checkbox"
                                                                                                        name="deleted_{{ $v_sub_chld_2 }}"
                                                                                                        value="1">
                                                                                                <span
                                                                                                    class="fa fa-check"></span>
                                                                                                </label>
                                                                                            </div>
                                                                                        </td>
                                                                                    </tr>
                                                                                    <?php
                                                                                }
                                                                            }
                                                                        }
                                                                    } else { ?>
                                                                        <tr class="child c_<?= $sub_chld; ?>">
                                                                            <td style="display: block;padding-left: 60px">
                                                                                <div class="checkbox c-checkbox ">
                                                                                    <label class="needsclick "
                                                                                           data-toggle="tooltip"
                                                                                           data-placement="top"
                                                                                           title="select">
                                                                                        <input <?php
                                                                                        if (!empty($roll[$sub_chld_id])) {
                                                                                            echo $roll[$sub_chld_id] ? 'checked' : '';
                                                                                        }
                                                                                        ?> id="{{ $sub_chld_id }}"
                                                                                           class="{{ $parent_id . ' ' . $sub_chld }}"
                                                                                           type="checkbox"
                                                                                           name="menu[]"
                                                                                           value="1">
                                                                                        
                                                                                        <strong>{{ $sub_chld_name }}</strong>
                                                                                    </label>
                                                                                </div>
                                                                            </td>
                                                                            <td>
                                                                                <div class="checkbox c-checkbox ">
                                                                                    <label class="needsclick view"
                                                                                           data-toggle="tooltip"
                                                                                           data-placement="top"
                                                                                           title="View Help">
                                                                                        <input <?php
                                                                                        if (!empty($roll[$sub_chld_id])) {
                                                                                            echo $roll[$sub_chld_id] ? 'checked' : '';
                                                                                        }
                                                                                        ?> class="{{ $sub_chld . ' ' . $sub_chld_id . ' ' . $parent_id }}"
                                                                                           type="checkbox"
                                                                                           name="view_{{ $sub_chld_id }}"
                                                                                           value="1">
                                                                                        
                                                                                    </label>
                                                                                </div>
                                                                            </td>
                                                                            <td>
                                                                                <div class="checkbox c-checkbox ">
                                                                                    <label class="needsclick create"
                                                                                           data-toggle="tooltip"
                                                                                           data-placement="top"
                                                                                           title="can create">
                                                                                        <input <?php
                                                                                        if (!empty($roll[$sub_chld_id])) {
                                                                                            echo $roll[$sub_chld_id]->created == $sub_chld_id ? 'checked' : '';
                                                                                        }
                                                                                        ?>
                                                                                            class="{{ $sub_chld . ' ' . $sub_chld_id . ' ' . $parent_id }}"
                                                                                            type="checkbox"
                                                                                            name="created_{{ $sub_chld_id }}"
                                                                                            value="1">
                                                                                        
                                                                                    </label>
                                                                                </div>
                                                                            </td>
                                                                            <td>
                                                                                <div class="checkbox c-checkbox">
                                                                                    <label class="needsclick edit"
                                                                                           data-toggle="tooltip"
                                                                                           data-placement="top"
                                                                                           title="can edit">
                                                                                        <input <?php
                                                                                        if (!empty($roll[$sub_chld_id])) {
                                                                                            echo $roll[$sub_chld_id]->edited == $sub_chld_id ? 'checked' : '';
                                                                                        }
                                                                                        ?>
                                                                                            class="{{ $sub_chld . ' ' . $sub_chld_id . ' ' . $parent_id }}"
                                                                                            type="checkbox"
                                                                                            name="edited_{{ $sub_chld_id }}"
                                                                                            value="1">
                                                                                        
                                                                                    </label>
                                                                                </div>
                                                                            </td>
                                                                            <td>
                                                                                <div class="checkbox c-checkbox">
                                                                                    <label class="needsclick delete"
                                                                                           data-toggle="tooltip"
                                                                                           data-placement="top"
                                                                                           title="can delete">
                                                                                        <input <?php
                                                                                        if (!empty($roll[$sub_chld_id])) {
                                                                                            echo $roll[$sub_chld_id]->deleted == $sub_chld_id ? 'checked' : '';
                                                                                        }
                                                                                        ?>
                                                                                            class="{{ $sub_chld . ' ' . $sub_chld_id . ' ' . $parent_id }}"
                                                                                            type="checkbox"
                                                                                            name="deleted_{{ $sub_chld_id }}"
                                                                                            value="1">
                                                                                        
                                                                                    </label>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                        <?php
                                                                    }
                                                                }
                                                            }
                                                        } else { ?>
                                                            <tr class="child c_<?= $parent_id; ?>">
                                                                <td style="display: block;padding-left: 35px;">
                                                                    <div class="checkbox c-checkbox ">
                                                                        <label class="needsclick " data-toggle="tooltip"
                                                                               data-placement="top"
                                                                               title="select">
                                                                            <strong>{{ $child }}</strong>
                                                                        </label>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="checkbox c-checkbox ">
                                                                        <label class="needsclick view" data-toggle="tooltip"
                                                                               data-placement="top"
                                                                               title="View Help">
                                                                            <input <?php
                                                                            if (!empty($roll[$v_sub_child])) {
                                                                                echo $roll[$v_sub_child] ? 'checked' : '';
                                                                            }
                                                                            ?> class="{{ $parent_id . ' ' . $v_sub_child }}"
                                                                               type="checkbox"
                                                                               name="view_{{ $v_sub_child }}"
                                                                               value="1">
                                                                        </label>
                                                                    </div>
                                                                </td>
                                                                <!--<td>-->
                                                                <!--    <div class="checkbox c-checkbox ">-->
                                                                <!--        <label class="needsclick create" data-toggle="tooltip"-->
                                                                <!--               data-placement="top"-->
                                                                <!--               title="can create">-->
                                                                <!--            <input class="{{ $parent_id . ' ' . $v_sub_child }}"-->
                                                                <!--               type="checkbox"-->
                                                                <!--               name="created_{{ $v_sub_child }}"-->
                                                                <!--               value="1">-->
                                                                <!--        </label>-->
                                                                <!--    </div>-->
                                                                <!--</td>-->
                                                                <!--<td>-->
                                                                <!--    <div class="checkbox c-checkbox">-->
                                                                <!--        <label class="needsclick edit" data-toggle="tooltip"-->
                                                                <!--               data-placement="top"-->
                                                                <!--               title="can edit">-->
                                                                <!--            <input-->
                                                                <!--                class="{{ $parent_id . ' ' . $v_sub_child }}"-->
                                                                <!--                type="checkbox"-->
                                                                <!--                name="edited_{{ $v_sub_child }}"-->
                                                                <!--                value="1">-->
                                                                <!--        </label>-->
                                                                <!--    </div>-->
                                                                <!--</td>-->
                                                                <!--<td>-->
                                                                <!--    <div class="checkbox c-checkbox">-->
                                                                <!--        <label class="needsclick delete" data-toggle="tooltip"-->
                                                                <!--               data-placement="top"-->
                                                                <!--               title="can delete">-->
                                                                <!--            <input class="{{ $parent_id . ' ' . $v_sub_child }}"-->
                                                                <!--               type="checkbox"-->
                                                                <!--               name="deleted_{{ $v_sub_child }}"-->
                                                                <!--               value="1">-->
                                                                            
                                                                <!--        </label>-->
                                                                <!--    </div>-->
                                                                <!--</td>-->
                                                            </tr>
                                                        <?php }
                                                    }
                                                } ?>
        
                                            <?php }
                                        }
                                    } else { ?>
                                        <tr>
                                            <td>
                                                <div class="checkbox c-checkbox ">
                                                    <label class="needsclick " data-toggle="tooltip" data-placement="top"
                                                           title="select">
                                                        <strong>{{ $parent }}</strong>
                                                    </label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="checkbox c-checkbox ">
                                                    <label class="needsclick view" data-toggle="tooltip"
                                                           data-placement="top"
                                                           title="View Help">
                                                        <input id="{{ $v_parent }}"
                                                            <?php
                                                            if (!empty($roll[$v_parent])) {
                                                                echo $roll[$v_parent] ? 'checked' : '';
                                                            }
                                                            ?>
                                                               class="{{ $v_parent }}" type="checkbox"
                                                               name="view_{{ $v_parent }}"
                                                               value="1">
                                                        
                                                    </label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="checkbox c-checkbox ">
                                                    <label class="needsclick create" data-toggle="tooltip"
                                                           data-placement="top"
                                                           title="can create">
                                                        <input
                                                            <?php
                                                            if (!empty($roll[$v_parent])) {
                                                                echo $roll[$v_parent]->created == $v_parent ? 'checked' : '';
                                                            }
                                                            ?>
                                                            class="{{ $v_parent }}" type="checkbox"
                                                            name="created_{{ $v_parent }}"
                                                            value="1">
                                                        
                                                    </label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="checkbox c-checkbox">
                                                    <label class="needsclick edit" data-toggle="tooltip"
                                                           data-placement="top"
                                                           title="can edit">
                                                        <input <?php
                                                        if (!empty($roll[$v_parent])) {
                                                            echo $roll[$v_parent]->edited == $v_parent ? 'checked' : '';
                                                        }
                                                        ?> class="{{ $v_parent }}" type="checkbox"
                                                           name="edited_{{ $v_parent }}"
                                                           value="1">
                                                        
                                                    </label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="checkbox c-checkbox">
                                                    <label class="needsclick delete" data-toggle="tooltip"
                                                           data-placement="top"
                                                           title="can delete">
                                                        <input <?php
                                                        if (!empty($roll[$v_parent])) {
                                                            echo $roll[$v_parent]->deleted == $v_parent ? 'checked' : '';
                                                        }
                                                        ?> class="{{ $v_parent }}" type="checkbox"
                                                           name="deleted_{{ $v_parent }}"
                                                           value="1">
                                                        
                                                    </label>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php }
                                }
                            }
                            ?>
        
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-success btn-user float-right mb-3">Save</button>
                <a class="btn btn-primary float-right mr-3 mb-3" href="{{ route('roles.index') }}">Cancel</a>
            </div>
        </form>
    </div>

</div>


@endsection
