<?php
    use App\Models\HectareMeasurement;
    use App\Models\User;
    use Illuminate\Support\Collection;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
    
    
    $loggedInTeamLeaderId = $userDetail->team_leader_id;    
    
    
    $uniqueUserIds = $data->pluck('user_id')->unique();
    $hectareMaster = HectareMeasurement::all();
    $targetTeamLeaderId = $hectareMaster->pluck('user_id')->filter()->unique()->values();
    $userData = User::all();
    
    $filteredUsers = $userData->filter(function ($user) use ($targetTeamLeaderId) {
        
        return $targetTeamLeaderId->contains($user->team_leader_id);
    });
    
    
    $userId = $filteredUsers->pluck('id')->filter()->unique()->values();
    
    $filteredCollection = $hectareMaster->filter(function ($item) use ($targetTeamLeaderId) {
        return $targetTeamLeaderId->contains($item->user_id);
    });
    // $filteredCollection = $hectareMaster->filter(function ($item) use ($loggedInTeamLeaderId) {
    //     return $item->user_id === $loggedInTeamLeaderId;
    // });
    
    // $landMeas = $hectareMaster->filter(function ($item) use ($userDetail) {
    //     return $item->user_id === $userDetail->id;
    // });
    
    $hectare_master_unit = 'hectare';
   
    foreach ($data as $entry1) 
    {
        $user_id = $entry1->user_id; 
        if(isset($targetTeamLeaderId[0])){
            $teamLeadArray = (array)$targetTeamLeaderId[0] ?? [];
        }else{
            $teamLeadArray = [];
        }
        
       
        if(in_array($entry1->team_leader_id, $teamLeadArray)){
               
                foreach ($filteredCollection as $entry2){
                    // $filteredUsers = User::where('id',$user_id)->whereIn('team_leader_id', $targetTeamLeaderId)->get();
                    
                    // $filteredUsers = $filteredUsers->first(function ($user) use ($user_id) {
                    //     return $user->id === $user_id;
                    // });
                    
                       
                        if($entry1->total_cultivable_unit == $entry2->unit && is_numeric($entry1->total_cultivable)){
                            $entry1->total_cultivable_unit = $hectare_master_unit;
                            $entry1->total_cultivable = number_format($entry1->total_cultivable/$entry2->value,3);
                        }
        
                        if($entry1->land_holding_size_unit == $entry2->unit && is_numeric( $entry1->land_holding_size)){
                          $entry1->land_holding_size_unit = $hectare_master_unit;
                          $entry1->land_holding_size = number_format($entry1->land_holding_size/$entry2->value,3);
                        }
                        
                        if($entry1->crop_area_unit == $entry2->unit && is_numeric( $entry1->crop_area)){
                            $entry1->crop_area_unit = $hectare_master_unit;
                            $entry1->crop_area = number_format($entry1->crop_area/$entry2->value,3);
                        }
                        
                        if($entry1->hired_animal_unit == $entry2->unit && is_numeric($entry1->hired_animal_unit)){
                            $entry1->hired_animal_unit = $hectare_master_unit;
                            $entry1->hired_animal_hrs = number_format($entry1->hired_animal_unit/$entry2->value,3);
                        }
                        
                        if($entry1->owned_animal_unit == $entry2->unit && is_numeric($entry1->owned_animal_hrs)){
                            $entry1->owned_animal_unit = $hectare_master_unit;
                            $entry1->owned_animal_hrs = number_format($entry1->owned_animal_hrs/$entry2->value,3);
                        }
                        
                        if($entry1->hired_irrigation_machine_unit == $entry2->unit  && is_numeric($entry1->hired_irrigation_machine_hrs)){
                            $entry1->hired_irrigation_machine_unit = $hectare_master_unit;
                            $entry1->hired_irrigation_machine_hrs = number_format($entry1->hired_irrigation_machine_hrs/$entry2->value,3);
                        }
                        
                        if($entry1->owned_irrigation_machine_unit == $entry2->unit && is_numeric($entry1->owned_irrigation_machine_hrs)){
                            $entry1->owned_irrigation_machine_unit = $hectare_master_unit;
                            $entry1->owned_irrigation_machine_hrs = number_format($entry1->owned_irrigation_machine_hrs/$entry2->value,3);
                        }
                        
                        if($entry1->land_holding_taken_lease_unit == $entry2->unit && is_numeric($entry1->land_holding_taken_lease)){
                            $entry1->land_holding_taken_lease_unit = $hectare_master_unit;
                            $entry1->land_holding_taken_lease = number_format($entry1->land_holding_taken_lease/$entry2->value,3);
                        }
                        
                        if($entry1->land_given_lease_unit == $entry2->unit && is_numeric($entry1->land_given_lease)){
                            $entry1->land_given_lease_unit = $hectare_master_unit;
                            $entry1->land_given_lease = number_format($entry1->land_given_lease/$entry2->value,3);
                        }
                    
                }
      }

    }
    
    
    
    // $list = $data;
    // $filter = [];
    // $data = [];
    // foreach($list as $item){
    //     if (!in_array($item->farmerId, $filter)) {
    //         $filter[] = $item->farmerId; 
    //         $data[] = $item; 
    //     }
    // }
    

        $unitArr = [];
        foreach($data as $unites){
          $val = $unites->insecticide_unit !== null ? json_decode($unites->insecticide_unit, true) : [];
          if(count($val) > count($unitArr)){
             $unitArr = $val; 
          }
          
        }
        
        $otherferArr = [];
        foreach($data as $otherferunit){
          $val = $otherferunit->other_fertiliser_name !== null ? json_decode($otherferunit->other_fertiliser_name, true) : [];
          if(count($val) > count($otherferArr)){
             $otherferArr = $val; 
          }
        }
        
        
        $prother = [];
        foreach($data as $proOther){
          $val = $proOther->production_outputs_other !== null ? json_decode($proOther->production_outputs_other, true) : [];
          if(count($val) > count($prother)){
             $prother = $val; 
          }
        }
        
?>


<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-3">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
             <?php if($deshboard == 1): ?>
        
                <?php else: ?>
            <div class="col-lg-9">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    
                    <a href="<?php echo e(route('anexure.one')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.one.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            <?php endif; ?>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Farm Input and Output</h1>
        </div>
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">

        <?php if($deshboard == 1): ?>
        
        <?php else: ?>
         <?php if((isset($rolePermission) && $rolePermission->edit == 1) || $loginUserId == 1): ?>
        <tr>
            <td>
                
            </td>
            <td>
                Status Actionacre	
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php if($status->status == 0): ?>
                <a href="<?php echo e(route('anexure.one.status', ['crop_id' => $status->id, 'status' => 1])); ?>"
                    class="btn btn-success m-2">
                    <i class="fa fa-check">Approve</i>
                </a>
                <?php elseif($status->status == 1): ?>
                <a href="<?php echo e(route('anexure.one.status', ['crop_id' => $status->id, 'status' => 0])); ?>"
                    class="btn btn-danger m-2">
                    <i class="fa fa-ban">Reject</i>
                </a>
                <?php endif; ?>
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                
            </td>
            <td>
                Status 
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php if($status->status == 0): ?>
                    <span class="badge badge-danger">Rejected</span>
                <?php elseif($status->status == 1): ?>
                    <span class="badge badge-success">Approved</span>
                <?php endif; ?>
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <?php endif; ?>
        <?php endif; ?>
        <tr>
            <td>
                A
            </td>
            <td>
                FARMER CODE
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($farmer->farmer_code); ?> 
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
              <td>
                B
            </td>
            <td>
                Farmer Name
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($farmer_name->farmer_first_name == 'null' ? '' : $farmer_name->farmer_first_name.' '.$farmer_name->farmer_last_name); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                C
            </td>
            <td>
               S/O or W/O
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $father_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e(isset($father_name->farmer_husband_father_name) && $father_name->farmer_husband_father_name ? $father_name->farmer_husband_father_name : ''); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                D
            </td>
            <td>
               Village
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_village): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($farmer_village->user_village == 'null' ? '' : $farmer_village->user_village); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                E
            </td>
           <td>
              State
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($farmer_state->farmer_state_name == 'null' ? '' : $farmer_state->farmer_state_name); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                F
            </td>
           <td>
              District
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_dis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($farmer_dis->farmer_district_name == 'null' ? '' : $farmer_dis->farmer_district_name); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                G
            </td>
            <td>
               Block
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($farmer_block->farmer_block == 'null' ? '' : $farmer_block->farmer_block); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                H
            </td>
            <td>
                Mobile Number
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobile_number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($mobile_number->farmer_mobile_number == 'null' ? '' : $mobile_number->farmer_mobile_number); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                I
            </td>
            <td>
                Kcc Limit
            </td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kcc_limit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($kcc_limit->kcc_limit == 'null' ? '' : $kcc_limit->kcc_limit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                J
            </td>
            <td>
                Land Type
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $land_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($land_type->land_type == 'null' ? '' : $land_type->land_type); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                K
            </td>
            <td>
                Soil Health Card
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $soilHealthCard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                
                
                <?php echo e($soilHealthCard->soil_health_card == 'null' ? '' : $soilHealthCard->soil_health_card); ?>

                
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                L
            </td>
            <td>
                Soil Health Card Remark
            </td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $soilHealthCardRemark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($soilHealthCardRemark->soil_health_card_remark == 'null' ? '' : $soilHealthCardRemark->soil_health_card_remark); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                M
            </td>
            <td>
                Land Holding Size Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $landHoldSizeUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($landHoldSizeUnit->land_holding_size_unit == 'null' ? '' : $landHoldSizeUnit->land_holding_size_unit); ?>


            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                N
            </td>
            <td>
                Land Holding (Area)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $land_holding_size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               
               
                <?php echo e($land_holding_size->land_holding_size == 'null' ? '' : $land_holding_size->land_holding_size); ?>

                
               
                
                
               
                
                
               
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                O
            </td>
            <td>
                Land Given Lease Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $landGivenLeaseUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($landGivenLeaseUnit->land_given_lease_unit == 'null' ? '' : $landGivenLeaseUnit->land_given_lease_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
         <tr>
            <td>
                P
            </td>
            <td>
                Land Given Lease (Area)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $landGivenLease): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                
                
                <?php echo e($landGivenLease->land_given_lease == 'null' ? '' : $landGivenLease->land_given_lease); ?>

               
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                Q
            </td>
            <td>
                Land Holding Taken Lease Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $landHoldTakenLeaseUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($landHoldTakenLeaseUnit->land_holding_taken_lease_unit == 'null' ? '' : $landHoldTakenLeaseUnit->land_holding_taken_lease_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                R
            </td>
            <td>
                Land Holding taken Lease (Area)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $land_holding_taken_lease): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                
                
                <?php echo e($land_holding_taken_lease->land_holding_taken_lease == 'null' ? '' : $land_holding_taken_lease->land_holding_taken_lease); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                S
            </td>
            <td>
                Total Cultivable Area Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $totalCultiUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($totalCultiUnit->total_cultivable_unit == 'null' ? '' : $totalCultiUnit->total_cultivable_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                T
            </td>
            <td>
                Total Cultivable (Area)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total_cultivable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                
                
                 <?php echo e($total_cultivable->total_cultivable == 'null' ? '' : $total_cultivable->total_cultivable); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                U
            </td>
            <td>
                CROPPING PATTERN
            </td>
             <?php
                $counter = [];
            ?>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crop_patt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $farmerId = $crop_patt->farmer_id;
                $counter[$farmerId] = isset($counter[$farmerId]) ? $counter[$farmerId] + 1 : 1;
                $romanCount = int_to_roman($counter[$farmerId]);
            ?>
            <td>
                CROP <?php echo e($romanCount); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php
                function int_to_roman($num) 
                {
                    $n = intval($num);
                    $result = '';
                    
                    $roman_numerals = array(
                        'M' => 1000,
                        'CM' => 900,
                        'D' => 500,
                        'CD' => 400,
                        'C' => 100,
                        'XC' => 90,
                        'L' => 50,
                        'XL' => 40,
                        'X' => 10,
                        'IX' => 9,
                        'V' => 5,
                        'IV' => 4,
                        'I' => 1
                    );
                    
                    foreach ($roman_numerals as $roman => $value) {
                        $matches = intval($n / $value);
                        $result .= str_repeat($roman, $matches);
                        $n = $n % $value;
                    }
                    
                    return $result;
                }
            ?>
        </tr>
        <tr>
            <td>
                1
            </td>
            <td>
                Season
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($season->season == 'null' ? '' : $season->season); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                2
            </td>
            <td>
                Crop Name
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crop_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($crop_name->crop_name == 'null' ? '' : $crop_name->crop_name); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                3
            </td>
            <td>
                Total Cultivatable  Area Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crop_area_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($crop_area_unit->crop_area_unit == 'null' ? '' : $crop_area_unit->crop_area_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                4
            </td>
            <td>
                Total Cultivatable Crop Area
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crop_area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                
                
                <?php echo e($crop_area->crop_area == 'null' ? '' : $crop_area->crop_area); ?>

                
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                5
            </td>
            <td>
                Irrigated Area
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $irr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <!--<?php if(isset($irr->irrigated_area) && strtolower($irr->irrigated_area) == 'yes'): ?>-->
                <!--    1-->
                <!--<?php else: ?>-->
                <!--    0-->
                <!--<?php endif; ?>-->
               <?php echo e($irr->irrigated_area == 'null' ? '' : $irr->irrigated_area); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                V
            </td>
            <th colspan="50">
                CULTIVATION  COST  
            </th>
        </tr>
        <tr>
            <td>
                1
            </td>
            <td>
                Family Labour Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php if(isset($fl->family_labour_unit) && $fl->family_labour_unit == 'mandays'): ?>
                    Mandays
                <?php elseif(isset($fl->family_labour_unit) && $fl->family_labour_unit == 'hours'): ?>
                    Hours
                <?php else: ?>
                    <?php echo e($fl->family_labour_unit == 'null' ? '' : $fl->family_labour_unit); ?>

                <?php endif; ?>
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                2
            </td>
            <td>
                Family Labour
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($fl->family_labour_hrs == 'null' ? '' : $fl->family_labour_hrs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                3
            </td>
            <td>
                Family Labour Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $familyLabourUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($familyLabourUnitPrice->family_labour_unit_price == 'null' ? '' : $familyLabourUnitPrice->family_labour_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                4
            </td>
            <td>
                Family Labour (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($flr->family_labour_rs == 'null' ? '' : $flr->family_labour_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                5
            </td>
            <td>
                Family Labour Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $familyLabourRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($familyLabourRemarks->family_labour_remarks == 'null' ? '' : $familyLabourRemarks->family_labour_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                6
            </td>
            <td>
                Attached Labour Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php if(isset($fl->attached_labour_unit) && $fl->attached_labour_unit == 'mandays'): ?>
                    Mandays
                <?php elseif(isset($fl->attached_labour_unit) && $fl->attached_labour_unit == 'hours'): ?>
                    Hours
                <?php else: ?>
                    <?php echo e($fl->attached_labour_unit == 'null' ? '' : $fl->attached_labour_unit); ?>

                <?php endif; ?>
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
         <tr>
            <td>
                7
            </td>
            <td>
                Attached Labour Duration
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attached_labour_duration): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($attached_labour_duration->attached_labour_duration == 'null' ? '' : $attached_labour_duration->attached_labour_duration); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                8
            </td>
            <td>
                Attached Labour 
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attached_labour_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($attached_labour_hrs->attached_labour_hrs == 'null' ? '' : $attached_labour_hrs->attached_labour_hrs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                9
            </td>
            <td>
                Attached Labour Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachedLabourUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($attachedLabourUnitPrice->attached_labour_unit_price == 'null' ? '' : $attachedLabourUnitPrice->attached_labour_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                10
            </td>
            <td>
                Attached Labour (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attached_labour_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($attached_labour_rs->attached_labour_rs == 'null' ? '' : $attached_labour_rs->attached_labour_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               11
            </td>
            <td>
                Attached Labour Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachedLabourRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($attachedLabourRemarks->attached_labour_remarks == 'null' ? '' : $attachedLabourRemarks->attached_labour_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                12
            </td>
            <td>
                Casual Labour Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php if(isset($fl->casual_labour_unit) && $fl->casual_labour_unit == 'mandays'): ?>
                    Mandays
                <?php elseif(isset($fl->casual_labour_unit) && $fl->casual_labour_unit == 'hours'): ?>
                    Hours
                <?php else: ?>
                    <?php echo e($fl->casual_labour_unit == 'null' ? '' : $fl->casual_labour_unit); ?>

                <?php endif; ?>
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                13
            </td>
            <td>
                Casual Labour 
            </td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $casual_labour_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($casual_labour_hrs->casual_labour_hrs == 'null' ? '' : $casual_labour_hrs->casual_labour_hrs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                14
            </td>
            <td>
                Casual Labour Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $casualLabourUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($casualLabourUnitPrice->casual_labour_unit_price == 'null' ? '' : $casualLabourUnitPrice->casual_labour_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                15
            </td>
            <td>
                Casual Labour (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $casual_labour_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($casual_labour_rs->casual_labour_rs == 'null' ? '' : $casual_labour_rs->casual_labour_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               16
            </td>
            <td>
                Casual Labour Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $casualLabourRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($casualLabourRemarks->casual_labour_remarks == 'null' ? '' : $casualLabourRemarks->casual_labour_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                17
            </td>
            <td>
                Hired Animal Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_animal_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($hired_animal_unit->hired_animal_unit == 'null' ? '' : $hired_animal_unit->hired_animal_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                18
            </td>
            <td>
                Hired Animal 
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredAnimalHrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php if(isset($hiredAnimalHrs->hired_animal_unit) && $hiredAnimalHrs->hired_animal_unit == $entry1->hired_animal_unit): ?>
                    <?php echo e($entry1->hired_animal_hrs == 'null' ? '' : $entry1->hired_animal_hrs); ?>

                <?php else: ?>
                    <?php echo e($hiredAnimalHrs->hired_animal_hrs == 'null' ? '' : $hiredAnimalHrs->hired_animal_hrs); ?>

                <?php endif; ?>
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                19
            </td>
            <td>
                Hired Animal Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredAnimalUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($hiredAnimalUnitPrice->hired_animal_unit_price == 'null' ? '' : $hiredAnimalUnitPrice->hired_animal_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                20
            </td>
            <td>
                Hired Animal (Rs)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredAnimalRs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($hiredAnimalRs->hired_animal_rs == 'null' ? '' : $hiredAnimalRs->hired_animal_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               21
            </td>
            <td>
                Hired Animal Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredAnimalRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($hiredAnimalRemarks->hired_animal_remarks == 'null' ? '' : $hiredAnimalRemarks->hired_animal_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
         <tr>
            <td>
               22
            </td>
            <td>
                Owned Animal Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedAnimalUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($ownedAnimalUnit->owned_animal_unit == 'null' ? '' : $ownedAnimalUnit->owned_animal_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                23
            </td>
            <td>
                Owned Animal 
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owned_animal_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                 
                
                <?php echo e($owned_animal_hrs->owned_animal_hrs == 'null' ? '' : $owned_animal_hrs->owned_animal_hrs); ?>

                
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               24
            </td>
            <td>
                Owned Animal Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedAnimalUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($ownedAnimalUnitPrice->owned_animal_unit_price == 'null' ? '' : $ownedAnimalUnitPrice->owned_animal_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                25
            </td>
            <td>
                Owned Animal Labour (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owned_animal_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($owned_animal_rs->owned_animal_rs == 'null' ? '' : $owned_animal_rs->owned_animal_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               26
            </td>
            <td>
                Owned Animal Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedAnimalRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($ownedAnimalRemarks->owned_animal_remarks == 'null' ? '' : $ownedAnimalRemarks->owned_animal_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
      
        
        <tr>
            <td>
                27
            </td>
            <td>
                Hired Machine Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_machhine_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($hired_machhine_unit->hired_machhine_unit == 'null' ? '' : $hired_machhine_unit->hired_machhine_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                28
            </td>
            <td>
                Hired Machine 
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_machhine_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($hired_machhine_hrs->hired_machhine_hrs == 'null' ? '' : $hired_machhine_hrs->hired_machhine_hrs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        

        <tr>
            <td>
                29
            </td>
            <td>
                Hired Machine Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredMachhineUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($hiredMachhineUnitPrice->hired_machhine_unit_price == 'null' ? '' : $hiredMachhineUnitPrice->hired_machhine_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                30
            </td>
            <td>
                Hired Machine (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_machhine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($hired_machhine_rs->hired_machhine_rs == 'null' ? '' : $hired_machhine_rs->hired_machhine_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                31
            </td>
            <td>
                Hired Machine Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredMachhineRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($hiredMachhineRemarks->hired_machhine_remarks == 'null' ? '' : $hiredMachhineRemarks->hired_machhine_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                32
            </td>
            <td>
                Own Machine Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownMachineUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($ownMachineUnit->own_machine_unit == 'null' ? '' : $ownMachineUnit->own_machine_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
         <tr>
            <td>
                33
            </td>
            <td>
                Own Machine
            </td>
             <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $own_machine_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($own_machine_hrs->own_machine_hrs == 'null' ? '' : $own_machine_hrs->own_machine_hrs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                34
            </td>
            <td>
                Own Machine Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownMachineUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($ownMachineUnitPrice->own_machine_unit_price == 'null' ? '' : $ownMachineUnitPrice->own_machine_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                35
            </td>
            <td>
                Own Machine (Rs.)
            </td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $own_machine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($own_machine_rs->own_machine_rs == 'null' ? '' : $own_machine_rs->own_machine_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               36
            </td>
            <td>
                Own Machine Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownMachineRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($ownMachineRemarks->own_machine_remarks == 'null' ? '' : $ownMachineRemarks->own_machine_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               37
            </td>
            <td>
                Hired Irrigation Machine Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredIrrigationMachineUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($hiredIrrigationMachineUnit->hired_irrigation_machine_unit == 'null' ? '' : $hiredIrrigationMachineUnit->hired_irrigation_machine_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                38
            </td>
            <td>
                Hired Irrigation Machine 
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                 
                
                <?php echo e($hired_irrigation_machine_hrs->hired_irrigation_machine_hrs == 'null' ? '' : $hired_irrigation_machine_hrs->hired_irrigation_machine_hrs); ?>

                
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                39
            </td>
            <td>
            Hired Irrigation Machine Unit Price
            </td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_unit_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price == 'null' ? '' : $hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                40
            </td>
            <td>
           Hired Irrigation Machine (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($hired_irrigation_machine_rs->hired_irrigation_machine_rs == 'null' ? '' : $hired_irrigation_machine_rs->hired_irrigation_machine_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                41
            </td>
            <td>
           Hired Irrigation Machine Remarks
            </td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_remarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($hired_irrigation_machine_remarks->hired_irrigation_machine_remarks == 'null' ? '' : $hired_irrigation_machine_remarks->hired_irrigation_machine_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           
        </tr>
        
        <tr>
            <td>
               42
            </td>
            <td>
                Owned Irrigation Machine Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedIrrigationMachineUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($ownedIrrigationMachineUnit->owned_irrigation_machine_unit == 'null' ? '' : $ownedIrrigationMachineUnit->owned_irrigation_machine_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                43
            </td>
            <td>
                Owned Irrigation Machine 
            </td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owned_irrigation_machine_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                
                
                <?php echo e($owned_irrigation_machine_hrs->owned_irrigation_machine_hrs == 'null' ? '' : $owned_irrigation_machine_hrs->owned_irrigation_machine_hrs); ?>

                
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               44
            </td>
            <td>
                Owned Irrigation Machine Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedIrrigationMachineUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price == 'null' ? '' : $ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                45
            </td>
            <td>
          Owned Irrigation Machine (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owned_irrigation_machine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($owned_irrigation_machine_rs->owned_irrigation_machine_rs == 'null' ? '' : $owned_irrigation_machine_rs->owned_irrigation_machine_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               46
            </td>
            <td>
                Owned Irrigation Machine Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedIrrigationMachineRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($ownedIrrigationMachineRemarks->owned_irrigation_machine_remarks == 'null' ? '' : $ownedIrrigationMachineRemarks->owned_irrigation_machine_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
    <!--Seed    -->
        <tr>
            <td>
               47
            </td>
            <td>
                Source of Seed / Plantlets
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($seedType->seed_type == 'null' ? '' : $seedType->seed_type); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
         <tr>
            <td>
               48
            </td>
            <td>
             Seed Standard
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seed_standard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($seed_standard->seed_standard == 'null' ? '' : $seed_standard->seed_standard); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               49
            </td>
            <td>
             Seed Standard Remark
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seed_standard_remark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($seed_standard_remark->seed_standard_remark == 'null' ? '' : $seed_standard_remark->seed_standard_remark); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               50
            </td>
            <td>
                Seed Variety
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedVariety): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($seedVariety->seed_variety == 'null' ? '' : $seedVariety->seed_variety); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        
         <tr>
            <td>
               51
            </td>
            <td>
                Seed Qty Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($seedQtyUnit->seed_qty_unit == 'null' ? '' : $seedQtyUnit->seed_qty_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                52
            </td>
            <td>
                Seed / Plantlets Quanity
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seed_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($seed_qty->seed_qty == 'null' ? '' : $seed_qty->seed_qty); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
       
        <tr>
            <td>
               53
            </td>
            <td>
                Seed Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($seedUnitPrice->seed_unit_price == 'null' ? '' : $seedUnitPrice->seed_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
         <tr>
            <td>
                54
            </td>
            <td>
            Seed Value (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seed_value_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php
                    $value = $seed_value_rs->seed_value_rs === 'null' || $seed_value_rs->seed_value_rs === null 
                        ? '' 
                        : number_format((float)$seed_value_rs->seed_value_rs, 2);  
                ?>
                <?php echo e($value); ?>

            </td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tr>

         <tr>
            <td>
               55
            </td>
            <td>
                Seed Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($seedRemarks->seed_remarks == 'null' ? '' : $seedRemarks->seed_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
    
    <!--Fertiliser (N)-->
        <tr>
            <td>
               56
            </td>
            <td>
                Fertiliser (N) Qty Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserNQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliserNQtyUnit->fertiliser_n_qty_unit == 'null' ? '' : $fertiliserNQtyUnit->fertiliser_n_qty_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                57
            </td>
            <td>
                Fertiliser (N) Quantity
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_n_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliser_n_qty->fertiliser_n_qty == 'null' ? '' : $fertiliser_n_qty->fertiliser_n_qty); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               58
            </td>
            <td>
                Fertiliser (N) Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserNUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliserNUnitPrice->fertiliser_n_unit_price == 'null' ? '' : $fertiliserNUnitPrice->fertiliser_n_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>

         <tr>
            <td>
                59
            </td>
            <td>
            Fertiliser (N) (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_n_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliser_n_rs->fertiliser_n_rs == 'null' ? '' : $fertiliser_n_rs->fertiliser_n_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        
        <tr>
            <td>
               60
            </td>
            <td>
                Fertiliser (N) Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserNRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliserNRemarks->fertiliser_n_remarks == 'null' ? '' : $fertiliserNRemarks->fertiliser_n_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        
        
        <tr>
            <td>
               61
            </td>
            <td>
                Fertiliser (P) Qty Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserPQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliserPQtyUnit->fertiliser_p_qty_unit == 'null' ? '' : $fertiliserPQtyUnit->fertiliser_p_qty_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                62
            </td>
            <td>
                Fertiliser (P) Quanity
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_p_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliser_p_qty->fertiliser_p_qty == 'null' ? '' : $fertiliser_p_qty->fertiliser_p_qty); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               63
            </td>
            <td>
                Fertiliser (P) Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserPUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliserPUnitPrice->fertiliser_p_unit_price == 'null' ? '' : $fertiliserPUnitPrice->fertiliser_p_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                64
            </td>
            <td>
            Fertiliser (P) (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_p_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliser_p_rs->fertiliser_p_rs == 'null' ? '' : $fertiliser_p_rs->fertiliser_p_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>

        <tr>
            <td>
               64
            </td>
            <td>
                Fertiliser (P) Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserPRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliserPRemarks->fertiliser_p_remarks == 'null' ? '' : $fertiliserPRemarks->fertiliser_p_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        
        <tr>
            <td>
               65
            </td>
            <td>
                Fertiliser (K) Qty Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserKQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliserKQtyUnit->fertiliser_k_qty_unit == 'null' ? '' : $fertiliserKQtyUnit->fertiliser_k_qty_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                66
            </td>
            <td>
                Fertiliser (K) Quanity
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_k_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliser_k_qty->fertiliser_k_qty == 'null' ? '' : $fertiliser_k_qty->fertiliser_k_qty); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               67
            </td>
            <td>
                Fertiliser (K) Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserKUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliserKUnitPrice->fertiliser_k_unit_price == 'null' ? '' : $fertiliserKUnitPrice->fertiliser_k_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                68
            </td>
            <td>
            Fertiliser (K) (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_k_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliser_k_rs->fertiliser_k_rs == 'null' ? '' : $fertiliser_k_rs->fertiliser_k_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>

         <tr>
            <td>
               69
            </td>
            <td>
                Fertiliser (K) Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserKRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($fertiliserKRemarks->fertiliser_k_remarks == 'null' ? '' : $fertiliserKRemarks->fertiliser_k_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <!--other Fertiliser Unit-->
        
      <?php $__empty_1 = true; $__currentLoopData = $otherferArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td>70</td>
            <td>Other Fertiliser Name</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php
                    $decoded = $other_fertiliser_name->other_fertiliser_name !== null ? json_decode($other_fertiliser_name->other_fertiliser_name, true) : [];
                ?>
                <?php echo e($decoded[$t] ?? null); ?>

            </td>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>71</td>
            <td>Other Fertiliser Qty Unit</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
              <?php
                $decoded = $otherFertiliserQtyUnit->other_fertiliser_qty_unit !== null ? json_decode($otherFertiliserQtyUnit->other_fertiliser_qty_unit, true) : [];
              ?>
                <?php echo e($decoded[$t] ?? null); ?>

            </td>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>72</td>
            <td>Other Fertiliser Qty</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php
                 $decoded = $other_fertiliser_qty->other_fertiliser_qty !== null ? json_decode($other_fertiliser_qty->other_fertiliser_qty, true) : [];
                ?>
                 <?php echo e($decoded[$t] ?? null); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>73</td>
            <td>Other Fertiliser Unit Price</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
             <td>
                <?php
                    $decoded = $otherFertiliserUnitPrice->other_fertiliser_unit_price !== null ? json_decode($otherFertiliserUnitPrice->other_fertiliser_unit_price, true) : [];
                ?>
                <?php echo e($decoded[$t] ?? null); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
          <td>74</td>
          <td>Other Fertiliser (Rs.)</td>
           <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php
                    $decoded = $other_fertiliser_rs->other_fertiliser_rs !== null ? json_decode($other_fertiliser_rs->other_fertiliser_rs, true) : [];
                ?>
               <?php echo e($decoded[$t] ?? null); ?>

            </td>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>75</td>
            <td>Other Fertiliser Remarks</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php
                    $decoded = $otherFertiliserRemarks->other_fertiliser_remarks !== null 
                        ? json_decode($otherFertiliserRemarks->other_fertiliser_remarks, true) 
                        : [];
                ?>
                <?php echo e($decoded[$t] ?? null); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
            <td>70</td>
            <td>Other Fertiliser Name</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php
                    $decoded = $other_fertiliser_name->other_fertiliser_name !== null ? json_decode($other_fertiliser_name->other_fertiliser_name, true) : [];
                    $value = is_array($decoded) ? implode(',', $decoded) : ($decoded ?: '');
                ?>
                <?php echo $value; ?>

            </td>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
    
        <tr>
            <td>
               71
            </td>
            <td>
                Other Fertiliser Qty Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               
                 <?php
                    $decoded = $otherFertiliserQtyUnit->other_fertiliser_qty_unit !== null ? json_decode($otherFertiliserQtyUnit->other_fertiliser_qty_unit, true) : [];
                    $value = is_array($decoded) ? implode(',', $decoded) : ($decoded ?: '');
                ?>
                <?php echo $value; ?>

                
            </td>
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
                72
            </td>
            <td>
            Other Fertiliser Qty
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
            <td>
                
                 <?php
                    $decoded = $other_fertiliser_qty->other_fertiliser_qty !== null ? json_decode($other_fertiliser_qty->other_fertiliser_qty, true) : [];
                    $value = is_array($decoded) ? implode(',', $decoded) : ($decoded ?: '');
                ?>
                <?php echo $value; ?>

                
            </td>
            
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               73
            </td>
            <td>
                Other Fertiliser Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
             <td>
               
                <?php
                    $decoded = $otherFertiliserUnitPrice->other_fertiliser_unit_price !== null ? json_decode($otherFertiliserUnitPrice->other_fertiliser_unit_price, true) : [];
                    $value = is_array($decoded) ? implode(',', $decoded) : ($decoded ?: '');
                ?>
                <?php echo $value; ?>

                
            </td>
           
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
         <tr>
            <td>
                74
            </td>
            <td>
            Other Fertiliser (Rs.)
            </td>
            
           <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               
                <?php
                    $decoded = $other_fertiliser_rs->other_fertiliser_rs !== null ? json_decode($other_fertiliser_rs->other_fertiliser_rs, true) : [];
                    $value = is_array($decoded) ? implode(',', $decoded) : ($decoded ?: '');
                ?>
                <?php echo $value; ?>

                
            </td>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tr>
        
        <tr>
            <td>
               75
            </td>
            <td>
                Other Fertiliser Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php
                    $decoded = $otherFertiliserRemarks->other_fertiliser_remarks !== null 
                        ? json_decode($otherFertiliserRemarks->other_fertiliser_remarks, true) 
                        : [];
                    $filtered = array_filter($decoded);
                    $value = !empty($filtered) 
                        ? implode(',', $filtered) 
                        : '';
                ?>
                <?php echo $value; ?>

            </td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tr>
        
      <?php endif; ?>
  
    <!--other Fertiliser Unit-->

        
        <tr>
            <td>
               76
            </td>
            <td>
                DAP Qty Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dapQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($dapQtyUnit->dap_qty_unit == 'null' ? '' : $dapQtyUnit->dap_qty_unit == 'other' ? $dapQtyUnit->dap_unit_remarks : $dapQtyUnit->dap_qty_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
       
        <!--<tr>-->
        <!--    <td>-->
        <!--        73-->
        <!--    </td>-->
        <!--    <td>-->
        <!--    DAP (Kg)-->
        <!--    </td>-->
            
        <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dap_kg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
        <!--    <td>-->
        <!--       <?php echo e($dap_kg->dap_kg == 'null' ? '' : $dap_kg->dap_kg); ?>-->
        <!--    </td>-->
        <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
        <!--</tr>-->
        
        <tr>
            <td>
               77
            </td>
            <td>
                DAP Qty
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dapQty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($dapQty->dap_qty == 'null' ? '' : $dapQty->dap_qty); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               78
            </td>
            <td>
                DAP Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dapUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($dapUnitPrice->dap_unit_price == 'null' ? '' : $dapUnitPrice->dap_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
         <tr>
            <td>
                79
            </td>
            <td>
                DAP (Rs)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dap_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($dap_rs->dap_rs == 'null' ? '' : $dap_rs->dap_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <!--<tr>-->
        <!--    <td>-->
        <!--       78-->
        <!--    </td>-->
        <!--    <td>-->
        <!--        DAP Unit Remarks-->
        <!--    </td>-->
            
        <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dapUnitRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
        <!--    <td>-->
        <!--       <?php echo e($dapUnitRemarks->dap_unit_remarks == 'null' ? '' : $dapUnitRemarks->dap_unit_remarks); ?>-->
        <!--    </td>-->
        <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
        <!--</tr>-->
        
        <tr>
            <td>
               80
            </td>
            <td>
                DAP Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dapRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($dapRemarks->dap_remarks == 'null' ? '' : $dapRemarks->dap_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               81
            </td>
            <td>
                NPK Qty Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npkQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>

               <?php echo e($npkQtyUnit->npk_qty_unit == 'null' ? '' :$npkQtyUnit->npk_qty_unit == 'other' ? $npkQtyUnit->npk_qty_unit_remarks : $npkQtyUnit->npk_qty_unit); ?>


            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <!--<tr>-->
        <!--    <td>-->
        <!--       79-->
        <!--    </td>-->
        <!--    <td>-->
        <!--        Npk Qty Unit Remarks-->
        <!--    </td>-->
            
        <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npkQtyUnitRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
        <!--    <td>-->
        <!--       <?php echo e($npkQtyUnitRemarks->npk_qty_unit_remarks == 'null' ? '' : $npkQtyUnitRemarks->npk_qty_unit_remarks); ?>-->
        <!--    </td>-->
        <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
        <!--</tr>-->
        <!--<tr>-->
        <!--    <td>-->
        <!--        80-->
        <!--    </td>-->
        <!--    <td>-->
        <!--        NPK (Kg)-->
        <!--    </td>-->
            
        <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npk_kg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
        <!--    <td>-->
        <!--       <?php echo e($npk_kg->npk_kg == 'null' ? '' : $npk_kg->npk_kg); ?>-->
        <!--    </td>-->
        <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
        <!--</tr>-->
        
        <tr>
            <td>
               82
            </td>
            <td>
                NPK Qty
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npkQty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($npkQty->npk_qty == 'null' ? '' : $npkQty->npk_qty); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>

        <tr>
            <td>
               83
            </td>
            <td>
                NPK Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npkUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($npkUnitPrice->npk_unit_price == 'null' ? '' : $npkUnitPrice->npk_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
         <tr>
            <td>
                84
            </td>
            <td>
                NPK (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npk_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($npk_rs->npk_rs == 'null' ? '' : $npk_rs->npk_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>

        <tr>
            <td>
               85
            </td>
            <td>
                NPK Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npkRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($npkRemarks->npk_remarks == 'null' ? '' : $npkRemarks->npk_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        
        <tr>
            <td>
               86
            </td>
            <td>
                Manure Qty Unit
            </td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manureQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>

            <?php echo e($manureQtyUnit->manure_qty_unit == 'null' ? '' : $manureQtyUnit->manure_qty_unit == 'other' ? $manureQtyUnit->manure_qty_unit_remarks : $manureQtyUnit->manure_qty_unit); ?>


            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>

        

        <tr>
            <td>
               87
            </td>
            <td>
                Manure Qty
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manureQty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($manureQty->manure_qty == 'null' ? '' : $manureQty->manure_qty); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>

        <tr>
            <td>
               88
            </td>
            <td>
                Manure Unit Price
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manureUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($manureUnitPrice->manure_unit_price == 'null' ? '' : $manureUnitPrice->manure_unit_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
         <tr>
            <td>
                89
            </td>
            <td>
            Manure (Rs.) FYM
            </td>
          
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manure_rs_fym): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($manure_rs_fym->manure_rs_fym == 'null' ? '' : $manure_rs_fym->manure_rs_fym); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           
         
        </tr>
        <tr>
            <td>
               90
            </td>
            <td>
                Manure Remarks
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manureRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($manureRemarks->manure_remarks == 'null' ? '' : $manureRemarks->manure_remarks); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
     <!--Insecticide-->

    <?php $__empty_1 = true; $__currentLoopData = $unitArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td>91</td>
            <td>Insecticide Unit</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td>
                <?php
                  $decoded = $insecticideUnit->insecticide_unit !== null ? json_decode($insecticideUnit->insecticide_unit, true) : [];
                ?>
                <?php echo e($decoded[$k] ?? null); ?>

                </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        <tr>
            
        <tr>
            <td>92</td>
            <td>Plant Protection Name</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insticideName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td>
                    <?php
                        $decoded = $insticideName->insticide_name !== null ? json_decode($insticideName->insticide_name, true) : [];
                       
                    ?>
                    <?php echo e($decoded[$k] ?? null); ?>

                </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
     <tr>
        <td>93</td>
        <td>Plant Protection Qty</td>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideQty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <td>
            <?php
                $decoded = $insecticideQty->insecticide_qty !== null ? json_decode($insecticideQty->insecticide_qty, true) : [];
            ?>
             <?php echo e($decoded[$k] ?? null); ?>

        </td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
     </tr>
    
     <tr>
       <td>94</td>
        <td>Plant Protection Unit Price</td>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <td>
             <?php
                $decoded = $insecticideUnitPrice->insecticide_unit_price !== null ? json_decode($insecticideUnitPrice->insecticide_unit_price, true) : [];
            ?>
            <?php echo e($decoded[$k] ?? null); ?>

        </td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
     </tr>
    
     <tr>
        <td>95</td>
        <td>Plant Protection (Rs.)</td>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticide_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <td>
            <?php
                $decoded = $insecticide_rs->insecticide_rs !== null ? json_decode($insecticide_rs->insecticide_rs, true) : [];
            ?>
            <?php echo e($decoded[$k] ?? null); ?>

        </td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
     </tr>
     
      <tr>
        <td>96</td>
        <td>Plant Protection Remarks</td>
       <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <td>
            <?php
                $decoded = $insecticideRemarks->insecticide_remarks !== null ? json_decode($insecticideRemarks->insecticide_remarks, true) : [];
            ?>
            <?php echo e($decoded[$k] ?? null); ?>

        </td>
       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <tr>
     
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    
        <tr>
            <td>91</td>
            <td>Insecticide Unit</td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td>
                <?php
                  $decoded = $insecticideUnit->insecticide_unit !== null ? json_decode($insecticideUnit->insecticide_unit, true) : [];
                ?>
                <?php echo e($decoded[0] ?? null); ?>

                </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        
        <tr>
            <td>92</td>
            <td>Plant Protection Name</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insticideName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td>
                    <?php
                        $decoded = $insticideName->insticide_name !== null ? json_decode($insticideName->insticide_name, true) : [];
                    ?>
                    <?php echo e($decoded[0] ?? null); ?>

                </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>

     <tr>
        <td>93</td>
        <td>Plant Protection Qty</td>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideQty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <td>
            <?php
                $decoded = $insecticideQty->insecticide_qty !== null ? json_decode($insecticideQty->insecticide_qty, true) : [];
            ?>
           <?php echo e($decoded[0] ?? null); ?>

        </td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
     </tr>

     <tr>
       <td>94</td>
        <td>Plant Protection Unit Price</td>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <td>
             <?php
                $decoded = $insecticideUnitPrice->insecticide_unit_price !== null ? json_decode($insecticideUnitPrice->insecticide_unit_price, true) : [];
            ?>
           <?php echo e($decoded[0] ?? null); ?>

        </td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
     </tr>
        
        
     <tr>
        <td>95</td>
        <td>Plant Protection (Rs.)</td>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticide_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <td>
            <?php
                $decoded = $insecticide_rs->insecticide_rs !== null ? json_decode($insecticide_rs->insecticide_rs, true) : [];
            ?>
            <?php echo e($decoded[0] ?? null); ?>

        </td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
     </tr>

        <tr>
            <td>96</td>
            <td>Plant Protection Remarks</td>
           <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php
                    $decoded = $insecticideRemarks->insecticide_remarks !== null 
                        ? json_decode($insecticideRemarks->insecticide_remarks, true) 
                        : [];
                ?>
               <?php echo e($decoded[0] ?? null); ?>

            </td>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
    <?php endif; ?>

 <!--Insecticide-->
           
        </tr>
       <tr>
            <td>
               97
            </td>
            <td>
                Canal / other Irrigation Charges (Rs)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $canalOtherCharges): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($canalOtherCharges->canal_other_charges == 'null' ? '' : $canalOtherCharges->canal_other_charges); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
                98
            </td>
            <td>
            Crop Insurance (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crop_insurance_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($crop_insurance_rs->crop_insurance_rs == 'null' ? '' : $crop_insurance_rs->crop_insurance_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
         <tr>
            <td>
                99
            </td>
            <td>
            Miscelaneous Cost (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $miscelaneous_cost_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($miscelaneous_cost_rs->miscelaneous_cost_rs == 'null' ? '' : $miscelaneous_cost_rs->miscelaneous_cost_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
         <tr>
            <td>
               100
            </td>
            <td>
            Land Revenue (Rs.) LAGAN
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $land_revenue_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($land_revenue_rs->land_revenue_rs == 'null' ? '' : $land_revenue_rs->land_revenue_rs); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
         <tr>
            <td>
                101
            </td>
            <td>
            Rent Paid for Leased in Land (Rs.)
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rent_paid_leased_land): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($rent_paid_leased_land->rent_paid_leased_land == 'null' ? '' : $rent_paid_leased_land->rent_paid_leased_land); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               102
            </td>
            <td>
            Interest on working capital rate(%) KCC
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interest_kcc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($interest_kcc->interest_kcc == 'null' ? '' : $interest_kcc->interest_kcc); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               103
            </td>
            <td>
                Depericiation of Farm Assets
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $depericiation_farm_assets): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($depericiation_farm_assets->depericiation_farm_assets == 'null' ? '' : $depericiation_farm_assets->depericiation_farm_assets); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               104
            </td>
            <td>
                Interest on Capital Assests
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interest_capital_assets): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($interest_capital_assets->interest_capital_assets == 'null' ? '' : $interest_capital_assets->interest_capital_assets); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
        </tr>
        
        <tr>
            <td>105</td>
            <td>Other Fixed Cost</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fix_cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($other_fix_cost->other_fix_cost == 'null' ? '' : $other_fix_cost->other_fix_cost); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
      <tr>
    <td></td>
        

    <td>Total Cost Of Cultivation</td>
    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <td>
            <?php
                // Calculate the total cost of cultivation
                $sumOfAllValue = $item->rent_paid_leased_land +
                                 $item->land_revenue_rs +
                                 $item->miscelaneous_cost_rs +
                                 $item->crop_insurance_rs +
                                 $item->canal_other_charges +
                                 $item->manure_rs +
                                 $item->npk_rs +
                                 $item->other_fix_cost +
                                 $item->dap_rs;

                                // Extract and process insecticide_rs
                                $insecticide_rs = $item->insecticide_rs;
                                $value = $insecticide_rs === 'null' ? '' : json_decode($insecticide_rs, true);
                
                                if (is_array($value)) {
                                    $value = implode(', ', $value);
                                }
                
                                // Add the value to the sum if it's numeric
                                if (is_numeric($value)) {
                                    $sumOfAllValue += $value;
                                }
                
                                // Extract and process other_fertiliser_rs
                                $other_fertiliser_rs = $item->other_fertiliser_rs;
                                $value = $other_fertiliser_rs === 'null' ? '' : json_decode($other_fertiliser_rs, true);
                
                                if (is_array($value)) {
                                    $value = implode(', ', $value);
                                }
                
                                // Add the value to the sum if it's numeric
                                if (is_numeric($value)) {
                                    $sumOfAllValue += $value;
                                }

                // Continue with other calculations
                $sumOfAllValue += $item->fertiliser_k_rs +
                                 $item->fertiliser_p_rs +
                                 $item->fertiliser_n_rs +
                                 $item->seed_value_rs +
                                 $item->owned_irrigation_machine_rs +
                                 $item->hired_irrigation_machine_rs +
                                 $item->own_machine_rs +
                                 $item->hired_machhine_rs +
                                 $item->owned_animal_rs +
                                 $item->hired_animal_rs +
                                 $item->casual_labour_rs +
                                 $item->attached_labour_rs +
                                 $item->family_labour_rs;
            ?>
            <?php echo e($sumOfAllValue); ?>

        </td>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tr>
        
        
        
        <tr>
            <td>
              W
            </td>
            <th colspan="50">
                Farm Output
            </th>
        </tr>
        <tr>
            <td>
               1
            </td>
            <td>
                Total Production Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $totalProductionUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($totalProductionUnit->total_production_unit == 'null' ? '' : $totalProductionUnit->total_production_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
         <tr>
            <td>
               2
            </td>
            <td>
               Total Production Qty
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total_production): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($total_production->total_production == 'null' ? '' : $total_production->total_production); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               3
            </td>
            <td>
                Sold Main Product Unit
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $soldMainProductUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               RS / <?php echo e($soldMainProductUnit->sold_main_product_unit == 'null' ? '' : $soldMainProductUnit->sold_main_product_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               4
            </td>
            <td>
              Sold Main Product Qty
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $totalMainProductSold): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($totalMainProductSold->total_main_product_sold == 'null' ? '' : $totalMainProductSold->total_main_product_sold); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               5
            </td>
            <td>
                Total Value of Main Product Sold
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $totalValueMainProductSold): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                
               <?php echo e($totalValueMainProductSold->total_value_main_product_sold == 'null' ? '' : $totalValueMainProductSold->total_value_main_product_sold); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               6
            </td>
            <td>
             Selling Price of main products
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling_price_main_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($selling_price_main_product->selling_price_main_product == 'null' ? '' : $selling_price_main_product->selling_price_main_product); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        
        
        <tr>
            <td>
               7
            </td>
            <td>
             Minimum Price 
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main_min_sell_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($main_min_sell_price->main_min_sell_price == 'null' ? '' : $main_min_sell_price->main_min_sell_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           
        </tr>
        
        <tr>
            <td>
               8
            </td>
            <td>
             Maximum Price 
            </td>
            
           <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main_max_sell_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($main_max_sell_price->main_max_sell_price == 'null' ? '' : $main_max_sell_price->main_max_sell_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           
        </tr>
        
        <tr>
            <td>
               9
            </td>
            <td>
             By-Product Name 
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $by_product_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($by_product_name->by_product_name == 'null' ? '' : $by_product_name->by_product_name); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           
        </tr>
        
        <tr>
            <td>
               10
            </td>
            <td>
             By-Product Unit 
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $by_product_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($by_product_unit->by_product_unit == 'null' ? '' : $by_product_unit->by_product_unit); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           
        </tr>
        
        
        <tr>
            <td>
               11
            </td>
            <td>
            By-Product Value
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $by_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($by_product->by_product == 'null' ? '' : $by_product->by_product); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        
        <tr>
            <td>
               12
            </td>
            <td>
             Selling  Price of By-products
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling_price_by_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($selling_price_by_product->selling_price_by_product == 'null' ? '' : $selling_price_by_product->selling_price_by_product); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               13
            </td>
            <td>
             Minimum Price
            </td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $by_min_sell_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($by_min_sell_price->by_min_sell_price == 'null' ? '' : $by_min_sell_price->by_min_sell_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        <tr>
            <td>
               14
            </td>
            <td>
             Maximum Price
            </td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $by_max_sell_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($by_max_sell_price->by_max_sell_price == 'null' ? '' : $by_max_sell_price->by_max_sell_price); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        
        
        
        
         <tr>
            <td>
                X
            </td>
            <th colspan="3">
                Whom to sold
            </th>
        </tr>
        <tr>
            <td>
               10
            </td>
            <td>
            Village Trader
            </td>
         <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $village_trader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($village_trader->village_trader == 'null' ? '' : $village_trader->village_trader); ?>

            </td>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tr>
        
         <tr>
            <td>
               11
            </td>
            <td>
            Wholesaler
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wholesaler): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($wholesaler->wholesaler == 'null' ? '' : $wholesaler->wholesaler); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
         <tr>
            <td>
               12
            </td>
            <td>
           MANDI
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mandi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($mandi->mandi == 'null' ? '' : $mandi->mandi); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               13
            </td>
            <td>
           Processor
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $processor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($processor->processor == 'null' ? '' : $processor->processor); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               14
            </td>
            <td>
         Retailer
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $retailer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($retailer->retailer == 'null' ? '' : $retailer->retailer); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               15
            </td>
            <td>
          Consumer
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $consumer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php echo e($consumer->consumer == 'null' ? '' : $consumer->consumer); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               16
            </td>
            <td>
                Company
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
               <?php echo e($company->company == 'null' ? '' : $company->company); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <tr>
            <td>
               17
            </td>
            <td>
                Commission Agent
            </td>
            
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commissionAgent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                 <?php echo e($commissionAgent->commission_agent == 'null' ? '' : $commissionAgent->commission_agent); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
     <?php $__empty_1 = true; $__currentLoopData = $prother; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pk=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td>18</td>
            <td>Other</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production_outputs_other): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php
                 $value = ($production_outputs_other->production_outputs_other === 'null') ? [] : json_decode($production_outputs_other->production_outputs_other, true);
                ?>
                <?php echo e($value[$pk] ?? null); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
            <td>18</td>
            <td>Other</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production_outputs_other): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <?php
                    $value = $production_outputs_other->production_outputs_other === 'null' ? '' 
                        : json_decode($production_outputs_other->production_outputs_other, true);
                    if (is_array($value)) {
                        $value = implode(', ', $value);  
                    }
                ?>
                <?php echo e($value); ?>

            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        <?php endif; ?>
       
            <!--data removie start-->
 
            
            <!--data removie end-->
       
            </table>
        </form>
    </div>
 </div>
 <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
 <script>
    $(document).ready(function() {
        function submitForm(id,farmerId) {
            
            $('#data_id').val(id); 
            $('#farmer_id').val(farmerId); 
            $('#dataForm').submit();
            
        }

        $('.btn-primary').on('click', function() {
            let id = $(this).data('id'); 
            let farmerId = $(this).data('farmer'); 
             
            $('#dataForm').find('table input[name]').each(function() {
                        if($(this).val()!=''){
                            // console.log($(this).val())
                             var inputString = $(this).attr('name');
                             const parts = inputString.split(/_(?=\d)/);
                             const other_infrastructure = parts[0];
                             if(other_infrastructure+'_'+id+'_'+farmerId!=inputString){
                                $(this).removeAttr('name')
                             }
                        }else{
                            $(this).removeAttr('name')
                        }
                       
                        
            })
            submitForm(id,farmerId); 
        });
    });
</script>
<?php $__env->stopSection(); ?>      
     
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-one.blade.php ENDPATH**/ ?>