<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
     <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            <?php if($deshboard == 1): ?>
        
            <?php else: ?>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.seven')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.seven.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
           <?php endif; ?>
        </div>
         <br>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">VILLAGE TEDER / TRADER / WHOLESALER</h1>
           
        </div>
         <h2>A. Infrastructure and Support Service</h2>

    <?php if($data->isNotEmpty()): ?> 
        <?php
            $sid = 1;
        ?>
    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
     <table class="table table-bordered ">
        <thead>
          <tr>
              
            <td><?php echo e($sid++); ?></td>
           <td><?php echo e($datas->farmer_code_id ?? ''); ?></td>
            <td><?php echo e($datas->first_name ?? ''); ?> <?php echo e($datas->last_name ?? ''); ?></td>

            <th>Infrastructure and Support Service</th>
            <th>Unit</th>
            <th>Unit Rate</th>
             <th>Amt (Rs.)</th>
             <th>Annulised Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
            
            <tr>
               <?php
                 $shop_permanent = $datas->cost_of_establishment_permanent ? json_decode($datas->cost_of_establishment_permanent, true) : [];
                ?>
            <td>1</td>
             <td></td>
            <td></td>
            <td>Cost of Establishment Permanent</td>
           <td><?php echo e($shop_permanent['unit'] ?? ''); ?></td>
            <td><?php echo e($shop_permanent['unitRate'] ?? ''); ?></td>
            <td><?php echo e($shop_permanent['amount'] ?? ''); ?></td>
            
            <?php
                $annualizedcostPer = isset($shop_permanent['amount']) && isset($perYear->year) && $perYear->year != 0 
                    ? $shop_permanent['amount'] / $perYear->year 
                    : null;
            ?>
            <td><?php echo e($annualizedcostPer ?? ''); ?></td>
            
            <td><?php echo e($shop_permanent['remark'] ?? ''); ?></td>
         </tr>
         
         <tr>
           <?php
             $shop_temporary = $datas->cost_of_establishment_temporary ? json_decode($datas->cost_of_establishment_temporary, true) : [];
            ?>
            <td>1</td>
            <td></td>
            <td></td>
            <td>Cost of Establishment Temporary</td>
           <td><?php echo e($shop_temporary['unit'] ?? ''); ?></td>
            <td><?php echo e($shop_temporary['unitRate'] ?? ''); ?></td>
            <td><?php echo e($shop_temporary['amount'] ?? ''); ?></td>
            
            <?php
                $annualizedcosttemp = isset($shop_temporary['amount']) && isset($tempYear->year) && $tempYear->year != 0 
                    ? $shop_temporary['amount'] / $tempYear->year 
                    : null;
            ?>
            
            <td><?php echo e($annualizedcosttemp ?? ''); ?></td>
            
            <td><?php echo e($shop_temporary['remark'] ?? ''); ?></td>
         </tr>
            
           
         
         <tr>
             <?php
             $sidata = json_decode($datas->storage_structure_for_procurement, true);
            ?>
            <td>2</td>
             <td></td>
            <td></td>
            <td>Cost Storage Structure for Procurement</td>
            <td><?php echo e($sidata['unit'] ?? ''); ?></td>
            <td><?php echo e($sidata['unitRate'] ?? ''); ?></td>
            <td><?php echo e($sidata['amount'] ?? ''); ?></td>
            <td><?php echo e($sidata['annualCost'] ?? ''); ?></td>
            <td><?php echo e($sidata['remark'] ?? ''); ?></td>
         </tr>
         
          <tr>
             <?php
             $ss = json_decode($datas->monthly_expenses_on_electricity, true);
            ?>
            <td>3</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
             <td><?php echo e($ss['unit'] ?? ''); ?></td>
            <td><?php echo e($ss['unitRate'] ?? ''); ?></td>
            <td><?php echo e($ss['amount'] ?? ''); ?></td>
            <td><?php echo e($ss['annualCost'] ?? ''); ?></td>
            <td><?php echo e($ss['remark'] ?? ''); ?></td>
         </tr>  
         
          <tr>
              <?php
             $mem = json_decode($datas->monthly_expenses_on_manpower, true);
            ?>
            <td>4</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Manpower</td>
            <td><?php echo e($mem['unit'] ?? ''); ?></td>
            <td><?php echo e($mem['unitRate'] ?? ''); ?></td>
            <td><?php echo e($mem['amount'] ?? ''); ?></td>
            <td><?php echo e($mem['annualCost'] ?? ''); ?></td>
            <td><?php echo e($mem['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <?php
             $monthly_rent = json_decode($datas->monthly_rent, true);
            ?>
            <td>5</td>
             <td></td>
            <td></td>
            <td >Monthly rent ( If Shop is on rent)</td>
            <td><?php echo e($monthly_rent['unit'] ?? ''); ?></td>
            <td><?php echo e($monthly_rent['unitRate'] ?? ''); ?></td>
            <td><?php echo e($monthly_rent['amount'] ?? ''); ?></td>
            <td><?php echo e($monthly_rent['annualCost'] ?? ''); ?></td>
            <td><?php echo e($monthly_rent['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
             <?php
             $mte = json_decode($datas->monthly_travelling_expense, true);
            ?> 
            <td>6</td>
             <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td><?php echo e($mte['unit'] ?? ''); ?></td>
            <td><?php echo e($mte['unitRate'] ?? ''); ?></td>
            <td><?php echo e($mte['amount'] ?? ''); ?></td>
            <td><?php echo e($mte['annualCost'] ?? ''); ?></td>
            <td><?php echo e($mte['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
             <?php
             $aicc = json_decode($datas->annual_Interest_cost_on_capital, true);
            ?>     
            <td>7</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on Capital  </td>
            <td><?php echo e($aicc['unit'] ?? ''); ?></td>
            <td><?php echo e($aicc['unitRate'] ?? ''); ?></td>
            <td><?php echo e($aicc['amount'] ?? ''); ?></td>
            <td><?php echo e($aicc['annualCost'] ?? ''); ?></td>
            <td><?php echo e($aicc['remark'] ?? ''); ?></td>
         </tr> 
         
           <?php
            $sumfixdata = 
                ($shop_permanent['amount'] ?? 0) + 
                ($shop_temporary['amount'] ?? 0) + 
                ($sidata['amount'] ?? 0) + 
                ($ss['amount'] ?? 0) + 
                ($mem['amount'] ?? 0) +     
                ($monthly_rent['amount'] ?? 0) + 
                ($mte['amount'] ?? 0) + 
                ($aicc['amount'] ?? 0);
            ?>
         
        <tr>
            <td>8</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Any other fixed cost</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;"><?php echo e($sumfixdata); ?></td>
            <td></td>
            <td></td>
         </tr> 
         
         
       
         
            <tr>
            <td></td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of Trader / Trader / Wholesaler</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
             <?php
            $aintco = json_decode($datas->annual_intt_cost_on_working_capital, true);
            ?>
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on working capital </td>
            <td><?php echo e($aintco['unit'] ?? ''); ?></td>
            <td><?php echo e($aintco['unitRate'] ?? ''); ?></td>
            <td><?php echo e($aintco['amount'] ?? ''); ?></td>
            <td><?php echo e($aintco['annualCost'] ?? ''); ?></td>
            <td><?php echo e($aintco['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <?php
            $atfar = json_decode($datas->purchase_from_farmer_at_village, true);
            ?>
            <td>10</td>
             <td></td>
            <td></td>
            <td >Purchase from farmer at village Level / Farm Gate ?</td>
             <td><?php echo e($atfar['unit'] ?? ''); ?></td>
            <td><?php echo e($atfar['unitRate'] ?? ''); ?></td>
            <td><?php echo e($atfar['amount'] ?? ''); ?></td>
            <td><?php echo e($atfar['annualCost'] ?? ''); ?></td>
            <td><?php echo e($atfar['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <?php
            $farmer_local_mandi = json_decode($datas->farmer_local_mandi, true);
            ?>
            <td>11</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi ?</td>
            <td><?php echo e($farmer_local_mandi['unit'] ?? ''); ?></td>
            <td><?php echo e($farmer_local_mandi['unitRate'] ?? ''); ?></td>
            <td><?php echo e($farmer_local_mandi['amount'] ?? ''); ?></td>
            <td><?php echo e($farmer_local_mandi['annualCost'] ?? ''); ?></td>
            <td><?php echo e($farmer_local_mandi['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
             <?php
            $commission_agent = json_decode($datas->commission_agent, true);
            ?>
            <td>12</td>
             <td></td>
            <td></td>
            <td>Purchase from Commission Agent ?</td>
            <td><?php echo e($commission_agent['unit'] ?? ''); ?></td>
            <td><?php echo e($commission_agent['unitRate'] ?? ''); ?></td>
            <td><?php echo e($commission_agent['amount'] ?? ''); ?></td>
            <td><?php echo e($commission_agent['annualCost'] ?? ''); ?></td>
            <td><?php echo e($commission_agent['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              <?php
                $any_other_channel = json_decode($datas->any_other_channel, true);
                ?>
            <td>13</td>
             <td></td>
            <td></td>
            <td>Any other channel</td>
            <td><?php echo e($any_other_channel['unit'] ?? ''); ?></td>
            <td><?php echo e($any_other_channel['unitRate'] ?? ''); ?></td>
            <td><?php echo e($any_other_channel['amount'] ?? ''); ?></td>
            <td><?php echo e($any_other_channel['annualCost'] ?? ''); ?></td>
            <td><?php echo e($any_other_channel['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              <?php
                $most_prevalent_purchase_mechanism = json_decode($datas->most_prevalent_purchase_mechanism, true);
                ?>
            <td>14</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism ( 10/11/12/13 )?</td>
            <td><?php echo e($most_prevalent_purchase_mechanism['unit'] ?? ''); ?></td>
            <td><?php echo e($most_prevalent_purchase_mechanism['unitRate'] ?? ''); ?></td>
            <td><?php echo e($most_prevalent_purchase_mechanism['amount'] ?? ''); ?></td>
            <td><?php echo e($most_prevalent_purchase_mechanism['annualCost'] ?? ''); ?></td>
            <td><?php echo e($most_prevalent_purchase_mechanism['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
              <?php
            $duration_of_purchase_on_credit = json_decode($datas->duration_of_purchase_on_credit, true);
            ?>
            <td>15</td>
             <td></td>
            <td></td>
            <td>Duration of purchase on credit</td>
             <td><?php echo e($duration_of_purchase_on_credit['unit'] ?? ''); ?></td>
            <td><?php echo e($duration_of_purchase_on_credit['unitRate'] ?? ''); ?></td>
            <td><?php echo e($duration_of_purchase_on_credit['amount'] ?? ''); ?></td>
            <td><?php echo e($duration_of_purchase_on_credit['annualCost'] ?? ''); ?></td>
            <td><?php echo e($duration_of_purchase_on_credit['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              <?php
                $duration_of_sale_on_credit = json_decode($datas->duration_of_sale_on_credit, true);
                ?>
            <td>16</td>
             <td></td>
            <td></td>
            <td>Duration of Sale on credit</td>
            <td><?php echo e($duration_of_sale_on_credit['unit'] ?? ''); ?></td>
            <td><?php echo e($duration_of_sale_on_credit['unitRate'] ?? ''); ?></td>
            <td><?php echo e($duration_of_sale_on_credit['amount'] ?? ''); ?></td>
            <td><?php echo e($duration_of_sale_on_credit['annualCost'] ?? ''); ?></td>
            <td><?php echo e($duration_of_sale_on_credit['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
               <?php
                $advance_credit_to_producer = json_decode($datas->advance_credit_to_producer, true);
                ?>
            <td>17</td>
            <td></td>
            <td></td>
            <td>Input / advance credit to producer (% of the estimated sale)</td>
            <td><?php echo e($advance_credit_to_producer['unit'] ?? ''); ?></td>
            <td><?php echo e($advance_credit_to_producer['unitRate'] ?? ''); ?></td>
            <td><?php echo e($advance_credit_to_producer['amount'] ?? ''); ?></td>
            <td><?php echo e($advance_credit_to_producer['annualCost'] ?? ''); ?></td>
            <td><?php echo e($advance_credit_to_producer['remark'] ?? ''); ?></td>
         </tr> 
         
         
        <tr>
             <?php
            $any_other_infor = json_decode($datas->any_other_infor, true);
            ?>
            <td>18</td>
             <td></td>
            <td></td>
            <td>Any other information</td>
             <td><?php echo e($any_other_infor['unit'] ?? ''); ?></td>
            <td><?php echo e($any_other_infor['unitRate'] ?? ''); ?></td>
            <td><?php echo e($any_other_infor['amount'] ?? ''); ?></td>
            <td><?php echo e($any_other_infor['annualCost'] ?? ''); ?></td>
            <td><?php echo e($any_other_infor['remark'] ?? ''); ?></td>
         </tr> 
         
        </tbody>
  </table>
    </div>
    <div class="table-responsive" style="margin-top:40px;">
     <h1 class="h3 mb-0 text-gray-800">B . Business parameters</h1>
      <br>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars of Inputs</th>
            <th>Name of Product</th>
            <th>Unit (quantity)</th>
            <th>Average Rate (Rs./Unit Quantity)</th>
            <th>Min Rate (Rs./Unit Quantity)</th>
            <th>Max Rate (Rs./Unit Quantity)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><?php echo e($sid++); ?></td>
             <td><?php echo e($datas->farmer_code_id ?? ''); ?></td>
             <td><?php echo e($datas->first_name ?? ''); ?> <?php echo e($datas->last_name ?? ''); ?></td>

            <td style="font-weight:700;">Average Purchase Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
         </tr>   
         
         <tr>
             <?php
                $average_purchase_a = json_decode($datas->average_purchase_a, true);
            ?>
            <td></td>
             <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td><?php echo e($average_purchase_a['name'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_a['unit'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_a['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_a['min_variation'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_a['max_variation'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_a['remarks'] ?? ''); ?></td>
         </tr>
         
           <tr>
            <?php
                $average_purchase_b = json_decode($datas->average_purchase_b, true);
            ?>
            <td></td>
            <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
            <td><?php echo e($average_purchase_b['name'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_b['unit'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_b['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_b['min_variation'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_b['max_variation'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_b['remarks'] ?? ''); ?></td>
         </tr>
         
           <tr>
               <?php
                $average_purchase_c = json_decode($datas->average_purchase_c, true);
            ?>
            <td></td> 
            <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
             <td><?php echo e($average_purchase_c['name'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_c['unit'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_c['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_c['min_variation'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_c['max_variation'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_c['remarks'] ?? ''); ?></td>
         </tr>
         
        <tr>
             <?php
                $average_purchase_d = json_decode($datas->average_purchase_d, true);
            ?>
            <td></td>  
            <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
             <td><?php echo e($average_purchase_d['name'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_d['unit'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_d['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_d['min_variation'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_d['max_variation'] ?? ''); ?></td>
            <td><?php echo e($average_purchase_d['remarks'] ?? ''); ?></td>
         </tr>
         
         
          <tr>
               
            <td>II</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Cost of Value Addition</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         
           <tr>
               <?php
                $harvesting_cost = json_decode($datas->harvesting_cost, true);
                ?>
            <td>a</td>
            <td></td>
            <td></td>
            <td>Harvesting Cost</td>
           <td><?php echo e($harvesting_cost['name'] ?? ''); ?></td>
            <td><?php echo e($harvesting_cost['unit'] ?? ''); ?></td>
            <td><?php echo e($harvesting_cost['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($harvesting_cost['min_variation'] ?? ''); ?></td>
            <td><?php echo e($harvesting_cost['max_variation'] ?? ''); ?></td>
            <td><?php echo e($harvesting_cost['remarks'] ?? ''); ?></td>
         </tr> 
         
           <tr>
                 <?php
                $transportation_cost = json_decode($datas->transportation_cost, true);
                ?>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Transportation Cost</td>
            <td><?php echo e($transportation_cost['name'] ?? ''); ?></td>
            <td><?php echo e($transportation_cost['unit'] ?? ''); ?></td>
            <td><?php echo e($transportation_cost['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($transportation_cost['min_variation'] ?? ''); ?></td>
            <td><?php echo e($transportation_cost['max_variation'] ?? ''); ?></td>
            <td><?php echo e($transportation_cost['remarks'] ?? ''); ?></td>
         </tr> 
         
         
         <tr>
             <?php
            $loading_and_unloading_charges = json_decode($datas->loading_and_unloading_charges, true);
            ?>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Loading and Unloading Charges</td>
           <td><?php echo e($loading_and_unloading_charges['name'] ?? ''); ?></td>
            <td><?php echo e($loading_and_unloading_charges['unit'] ?? ''); ?></td>
            <td><?php echo e($loading_and_unloading_charges['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($loading_and_unloading_charges['min_variation'] ?? ''); ?></td>
            <td><?php echo e($loading_and_unloading_charges['max_variation'] ?? ''); ?></td>
            <td><?php echo e($loading_and_unloading_charges['remarks'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <?php
            $primary_processing_cost = json_decode($datas->primary_processing_cost, true);
            ?>
            <td>d</td>
               <td></td>
            <td></td>
            <td>Primary Processing Cost</td>
           <td><?php echo e($primary_processing_cost['name'] ?? ''); ?></td>
            <td><?php echo e($primary_processing_cost['unit'] ?? ''); ?></td>
            <td><?php echo e($primary_processing_cost['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($primary_processing_cost['min_variation'] ?? ''); ?></td>
            <td><?php echo e($primary_processing_cost['max_variation'] ?? ''); ?></td>
            <td><?php echo e($primary_processing_cost['remarks'] ?? ''); ?></td>
         </tr> 
         
          <tr>
                <?php
                $drying_Loss_any_other_loss = json_decode($datas->drying_Loss_any_other_loss, true);
                ?>
            <td>e</td>
             <td></td>
            <td></td>
            <td>Drying Loss or any other loss</td>
                <td><?php echo e($drying_Loss_any_other_loss['name'] ?? ''); ?></td>
                <td><?php echo e($drying_Loss_any_other_loss['unit'] ?? ''); ?></td>
                <td><?php echo e($drying_Loss_any_other_loss['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($drying_Loss_any_other_loss['min_variation'] ?? ''); ?></td>
                <td><?php echo e($drying_Loss_any_other_loss['max_variation'] ?? ''); ?></td>
                <td><?php echo e($drying_Loss_any_other_loss['remarks'] ?? ''); ?></td>
         </tr> 
         
        <tr>
             <?php
            $value_establishment_cost = json_decode($datas->value_establishment_cost, true);
            ?>
            <td>f</td>
             <td></td>
            <td></td>
            <td>Establishment Cost</td>
              <td><?php echo e($value_establishment_cost['name'] ?? ''); ?></td>
                <td><?php echo e($value_establishment_cost['unit'] ?? ''); ?></td>
                <td><?php echo e($value_establishment_cost['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($value_establishment_cost['min_variation'] ?? ''); ?></td>
                <td><?php echo e($value_establishment_cost['max_variation'] ?? ''); ?></td>
                <td><?php echo e($value_establishment_cost['remarks'] ?? ''); ?></td>
         </tr> 
         
         <tr>
             <?php
            $marketing_cost = json_decode($datas->marketing_cost, true);
            ?>
            <td>g</td>
            <td></td>
            <td></td>
            <td>Marketing Cost</td>
             <td><?php echo e($marketing_cost['name'] ?? ''); ?></td>
            <td><?php echo e($marketing_cost['unit'] ?? ''); ?></td>
            <td><?php echo e($marketing_cost['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($marketing_cost['min_variation'] ?? ''); ?></td>
            <td><?php echo e($marketing_cost['max_variation'] ?? ''); ?></td>
            <td><?php echo e($marketing_cost['remarks'] ?? ''); ?></td>
         </tr> 
         
          <tr>
                  <?php
                $storage_cost = json_decode($datas->storage_cost, true);
                ?>
            <td>h</td>
               <td></td>
            <td></td>
            <td>Storage Cost</td>
              <td><?php echo e($storage_cost['name'] ?? ''); ?></td>
            <td><?php echo e($storage_cost['unit'] ?? ''); ?></td>
            <td><?php echo e($storage_cost['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($storage_cost['min_variation'] ?? ''); ?></td>
            <td><?php echo e($storage_cost['max_variation'] ?? ''); ?></td>
            <td><?php echo e($storage_cost['remarks'] ?? ''); ?></td>
         </tr> 
         </tr> 
         
          <tr>
               <?php
                $any_other_cost = json_decode($datas->any_other_cost, true);
                ?>
            <td>i</td>
               <td></td>
            <td></td>
            <td>Any other cost</td>
            <td><?php echo e($any_other_cost['name'] ?? ''); ?></td>
            <td><?php echo e($any_other_cost['unit'] ?? ''); ?></td>
            <td><?php echo e($any_other_cost['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($any_other_cost['min_variation'] ?? ''); ?></td>
            <td><?php echo e($any_other_cost['max_variation'] ?? ''); ?></td>
            <td><?php echo e($any_other_cost['remarks'] ?? ''); ?></td>
         </tr> 
         </tr> 
         
         <tr>
            <td>j</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>k</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>III</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Selling Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
         
        <tr>
             <?php
            $selling_price_a = json_decode($datas->selling_price_a, true);
            ?>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td><?php echo e($selling_price_a['name'] ?? ''); ?></td>
                <td><?php echo e($selling_price_a['unit'] ?? ''); ?></td>
                <td><?php echo e($selling_price_a['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($selling_price_a['min_variation'] ?? ''); ?></td>
                <td><?php echo e($selling_price_a['max_variation'] ?? ''); ?></td>
                <td><?php echo e($selling_price_a['remarks'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              <?php
            $selling_price_b = json_decode($datas->selling_price_b, true);
            ?>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
             <td><?php echo e($selling_price_a['name'] ?? ''); ?></td>
                 <td><?php echo e($selling_price_b['unit'] ?? ''); ?></td>
                <td><?php echo e($selling_price_b['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($selling_price_b['min_variation'] ?? ''); ?></td>
                <td><?php echo e($selling_price_b['max_variation'] ?? ''); ?></td>
                <td><?php echo e($selling_price_b['remarks'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <?php
            $selling_price_c = json_decode($datas->selling_price_c, true);
            ?>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
                <td><?php echo e($selling_price_a['name'] ?? ''); ?></td>
                 <td><?php echo e($selling_price_c['unit'] ?? ''); ?></td>
                <td><?php echo e($selling_price_c['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($selling_price_c['min_variation'] ?? ''); ?></td>
                <td><?php echo e($selling_price_c['max_variation'] ?? ''); ?></td>
                <td><?php echo e($selling_price_c['remarks'] ?? ''); ?></td>
         </tr> 
         
         <tr>
             <?php
            $selling_price_d = json_decode($datas->selling_price_d, true);
            ?>
            <td></td>
            <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
            <td><?php echo e($selling_price_a['name'] ?? ''); ?></td>
             <td><?php echo e($selling_price_d['unit'] ?? ''); ?></td>
            <td><?php echo e($selling_price_d['averate_rate'] ?? ''); ?></td>
            <td><?php echo e($selling_price_d['min_variation'] ?? ''); ?></td>
            <td><?php echo e($selling_price_d['max_variation'] ?? ''); ?></td>
            <td><?php echo e($selling_price_d['remarks'] ?? ''); ?></td>
         </tr> 
         
        <tr>
            <td>IV</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Any other Cost Parameter</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Quantum Handled in a year (weight)</td>
            <td></td>
             <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
            <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Purchase and selling prices fluctuation during the whole marketing season</td>
            <td></td>
             <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
        </tbody>
  </table>

    </div>
    <div class="table-responsive" style="margin-top:40px">
        
     <h1 class="h3 mb-0 text-gray-800">C . Indicative Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
        <br>
      <table class="table table-bordered ">
        <thead>
          <tr>
            <th>1</th>
            <td>Farmer ID</td>
            <td>Farmer Name</td>
            <th>Issues / Constraints</th>
            <th></th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
              <?php
                    $issues_constraints_a =  json_decode($datas->issues_constraints_a, true);
                ?>
            <td>a</td>
           <td><?php echo e($datas->farmer_code_id ?? ''); ?></td>
            <td><?php echo e($datas->first_name ?? ''); ?> <?php echo e($datas->last_name ?? ''); ?></td>
            <td>Marketing problem ( rate fluctuation and more storage time due to lack of end market )</td>
            <td><?php echo e($issues_constraints_a['value'] ?? ''); ?></td>
            <td><?php echo e($issues_constraints_a['remark'] ?? ''); ?></td>
         </tr>   
         
         <tr>
             <?php
                $issues_constraints_b = json_decode($datas->issues_constraints_b, true);
                ?>
            <td>b</td>
            <td></td>
            <td></td>
            <td>Credit taken agents will not  supply agreed quantity of  produce </td>
            <td><?php echo e($issues_constraints_b['value'] ?? ''); ?></td>
            <td><?php echo e($issues_constraints_b['remark'] ?? ''); ?></td>
         </tr>
         
         
         <tr>
                <?php
                $issues_constraints_c = json_decode($datas->issues_constraints_c, true);
                ?>
            <td>c</td>
            <td></td>
            <td></td>
            <td>Needs to give Credit to farmers through  the channel of commission agents</td>
            <td><?php echo e($issues_constraints_c['value'] ?? ''); ?></td>
            <td><?php echo e($issues_constraints_c['remark'] ?? ''); ?></td>
         </tr>  
         
           
         
          <tr>
            <td style="font-weight:700;">2</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Challenge</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
             <?php
            $challenges_a = json_decode($datas->challenges_a, true);
            ?>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Transportation and storage  losses ( average extent of losses (%) ? ) </td>
            <td><?php echo e($challenges_a['value'] ?? ''); ?></td>
            <td><?php echo e($challenges_a['remark'] ?? ''); ?></td>
         </tr> 
         
           <tr>
           <?php
            $challenges_b = json_decode($datas->challenges_b, true);
            ?>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Manpower availability during the procurement and transportation</td>
            <td><?php echo e($challenges_b['value'] ?? ''); ?></td>
            <td><?php echo e($challenges_b['remark'] ?? ''); ?></td>
         </tr> 
         
          
         <tr>
            <td style="font-weight:700;">3</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Risk</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
             <?php
            $risk_a = json_decode($datas->risk_a, true);
            ?>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Business is purely depends on local weather conditions</td>
            <td><?php echo e($risk_a['value'] ?? ''); ?></td>
            <td><?php echo e($risk_a['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
               <?php
            $risk_b = json_decode($datas->risk_b, true);
            ?>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Credits to commission agents ( How much credit needs to be given and duration of the credit outstanding: ? )</td>
             <td><?php echo e($risk_b['value'] ?? ''); ?></td>
            <td><?php echo e($risk_b['remark'] ?? ''); ?></td>
         </tr>
         
          <tr>
            <?php
            $risk_c = json_decode($datas->risk_c, true);
            ?>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Supply of produce from regular agents due to competition</td>
             <td><?php echo e($risk_c['value'] ?? ''); ?></td>
            <td><?php echo e($risk_c['remark'] ?? ''); ?></td>
         </tr>
         
          <tr>
            <td style="font-weight:700;">4</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Prospects</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
             <?php
            $prospects_a = json_decode($datas->prospects_a, true);
            ?>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Godowns supply on subsidy basis by govt.</td>
           <td><?php echo e($prospects_a['value'] ?? ''); ?></td>
            <td><?php echo e($prospects_a['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
            <?php
            $prospects_b = json_decode($datas->prospects_b, true);
            ?>
            <td>b</td>
            <td></td>
            <td></td>
            <td>Insurance for storage</td>
           <td><?php echo e($prospects_b['value'] ?? ''); ?></td>
            <td><?php echo e($prospects_b['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <?php
            $prospects_c = json_decode($datas->prospects_c, true);
            ?>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Policy regulation on market prices </td>
            <td><?php echo e($prospects_c['value'] ?? ''); ?></td>
            <td><?php echo e($prospects_c['remark'] ?? ''); ?></td>
         </tr> 
         
       
         
        </tbody>
  </table>
  
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
    <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Infrastructure and Support Service</th>
            <th>Unit</th>
            <th>Unit Rate</th>
             <th>Amt (Rs.)</th>
             <th>Annulised Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
             <td></td>
            <td></td>
            <td>Cost of Establishment Permanent</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>1</td>
             <td></td>
            <td></td>
            <td>Cost of Establishment Temporary</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>2</td>
             <td></td>
            <td></td>
            <td>Cost Storage Structure for Procurement</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>3</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>  
         
          <tr>
            <td>4</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Manpower</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>5</td>
             <td></td>
            <td></td>
            <td >Monthly rent ( If Shop is on rent)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>6</td>
             <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>7</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on Capital  </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>8</td>
             <td></td>
            <td></td>
            <td>Any other fixed cost</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
       
         
            <tr>
            <td></td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of Trader / Trader / Wholesaler</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on working capital </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>10</td>
             <td></td>
            <td></td>
            <td >Purchase from farmer at village Level / Farm Gate ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>11</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>12</td>
             <td></td>
            <td></td>
            <td>Purchase from Commission Agent ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>13</td>
             <td></td>
            <td></td>
            <td>Any other channel</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>14</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism ( 10/11/12/13 )?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>15</td>
             <td></td>
            <td></td>
            <td>Duration of purchase on credit</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>16</td>
             <td></td>
            <td></td>
            <td>Duration of Sale on credit</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>17</td>
             <td></td>
            <td></td>
            <td>Input / advance credit to producer (% of the estimated sale)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
        <tr>
            <td>18</td>
             <td></td>
            <td></td>
            <td>Any other information</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        </tbody>
  </table>
    </div>
    <div class="table-responsive" style="margin-top:40px;">
     <h1 class="h3 mb-0 text-gray-800">B . Business parameters</h1>
      <br>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars of Inputs</th>
            <th>Name of Product</th>
            <th>Unit (quantity)</th>
            <th>Average Rate (Rs./Unit Quantity)</th>
            <th>Min Rate (Rs./Unit Quantity)</th>
            <th>Max Rate (Rs./Unit Quantity)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>I</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Average Purchase Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
           <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
           <tr>
            <td></td>   <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
        <tr>
            <td></td>  
            <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
         
          <tr>
            <td>II</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Cost of Value Addition</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         
           <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Harvesting Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Transportation Cost</td>
            <td></td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Loading and Unloading Charges</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>d</td>
               <td></td>
            <td></td>
            <td>Primary Processing Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>e</td>
             <td></td>
            <td></td>
            <td>Drying Loss or any other loss</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>f</td>
             <td></td>
            <td></td>
            <td>Establishment Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>g</td>
               <td></td>
            <td></td>
            <td>Marketing Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>h</td>
               <td></td>
            <td></td>
            <td>Storage Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>i</td>
               <td></td>
            <td></td>
            <td>Any other cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
         <tr>
            <td>j</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>k</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>III</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Selling Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
         
        <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>IV</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Any other Cost Parameter</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Quantum Handled in a year (weight)</td>
            <td></td>
             <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
            <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Purchase and selling prices fluctuation during the whole marketing season</td>
            <td></td>
             <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
        </tbody>
  </table>

    </div>
    <div class="table-responsive" style="margin-top:40px">
        
     <h1 class="h3 mb-0 text-gray-800">C . Indicative Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
        <br>
      <table class="table table-bordered ">
        <thead>
          <tr>
            <th>1</th>
            <td>Farmer ID</td>
            <td>Farmer Name</td>
            <th>Issues / Constraints</th>
            <th></th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>a</td>
            <td></td>
            <td></td>
            <td>Marketing problem ( rate fluctuation and more storage time due to lack of end market )</td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td>b</td>
            <td></td>
            <td></td>
            <td>Credit taken agents will not  supply agreed quantity of  produce </td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>c</td>
            <td></td>
            <td></td>
            <td>Needs to give Credit to farmers through  the channel of commission agents</td>
            <td></td>
            <td></td>
         </tr>  
         
           
         
          <tr>
            <td style="font-weight:700;">2</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Challenge</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Transportation and storage  losses ( average extent of losses (%) ? ) </td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Manpower availability during the procurement and transportation</td>
            <td></td>
            <td></td>
         </tr> 
         
          
         <tr>
            <td style="font-weight:700;">3</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Risk</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Business is purely depends on local weather conditions</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Credits to commission agents ( How much credit needs to be given and duration of the credit outstanding: ? )</td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Supply of produce from regular agents due to competition</td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td style="font-weight:700;">4</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Prospects</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Godowns supply on subsidy basis by govt.</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Insurance for storage</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Policy regulation on market prices </td>
            <td></td>
            <td></td>
         </tr> 
         
       
         
        </tbody>
  </table>
  
    </div>
    <?php endif; ?>
    
</div>

    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-seven.blade.php ENDPATH**/ ?>