<?php
    use App\Models\HectareMeasurement;
    use App\Models\User;
    use Illuminate\Support\Collection;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
    
    
    $loggedInTeamLeaderId = $userDetail->team_leader_id;
    
    
    $uniqueUserIds = $data->pluck('user_id')->unique();
    $hectareMaster = HectareMeasurement::all();
    $targetTeamLeaderId = $hectareMaster->pluck('user_id')->filter()->unique()->values();
    $userData = User::all();
    
    $filteredUsers = $userData->filter(function ($user) use ($targetTeamLeaderId) {
        return $targetTeamLeaderId->contains($user->team_leader_id);
    });
    
    $userId = $filteredUsers->pluck('id')->filter()->unique()->values();
    
    $filteredCollection = $hectareMaster->filter(function ($item) use ($targetTeamLeaderId) {
        return $targetTeamLeaderId->contains($item->user_id);
    });
    
    // $filteredCollection = $hectareMaster->filter(function ($item) use ($loggedInTeamLeaderId) {
    //     return $item->user_id === $loggedInTeamLeaderId;
    // });
    
    $landMeas = $hectareMaster->filter(function ($item) use ($userDetail) {
        return $item->user_id === $userDetail->id;
    });
    
    $hectare_master_unit = 'hectare';
    foreach ($data as $entry1){
        $user_id = $entry1->user_id; 
        if(isset($targetTeamLeaderId[0])){
            $teamLeadArray = (array)$targetTeamLeaderId[0] ?? [];
        }else{
            $teamLeadArray = [];
        }
        
        if(in_array($entry1->team_leader_id, $teamLeadArray)){
                foreach ($filteredCollection as $entry2) {
  
                        if($entry1->total_cultivable_unit == $entry2->unit && is_numeric($entry1->total_cultivable)){
                            $entry1->total_cultivable_unit = $hectare_master_unit;
                            $entry1->total_cultivable = number_format($entry1->total_cultivable/$entry2->value,3);
                        }
        
                        if($entry1->land_holding_size_unit == $entry2->unit && is_numeric( $entry1->land_holding_size)){
                          $entry1->land_holding_size_unit = $hectare_master_unit;
                          $entry1->land_holding_size = number_format($entry1->land_holding_size/$entry2->value,3);
                        }
                        
                        if($entry1->crop_area_unit == $entry2->unit && is_numeric( $entry1->crop_area)){
                            $entry1->crop_area_unit = $hectare_master_unit;
                            $entry1->crop_area = number_format($entry1->crop_area/$entry2->value,3);
                        }
                        
                        if($entry1->hired_animal_unit == $entry2->unit && is_numeric($entry1->hired_animal_unit)){
                            $entry1->hired_animal_unit = $hectare_master_unit;
                            $entry1->hired_animal_hrs = number_format($entry1->hired_animal_unit/$entry2->value,3);
                        }
                        
                        if($entry1->owned_animal_unit == $entry2->unit && is_numeric($entry1->owned_animal_hrs)){
                            $entry1->owned_animal_unit = $hectare_master_unit;
                            $entry1->owned_animal_hrs = number_format($entry1->owned_animal_hrs/$entry2->value,3);
                        }
                        
                        if($entry1->hired_irrigation_machine_unit == $entry2->unit  && is_numeric($entry1->hired_irrigation_machine_hrs)){
                            $entry1->hired_irrigation_machine_unit = $hectare_master_unit;
                            $entry1->hired_irrigation_machine_hrs = number_format($entry1->hired_irrigation_machine_hrs/$entry2->value,3);
                        }
                        
                        if($entry1->owned_irrigation_machine_unit == $entry2->unit && is_numeric($entry1->owned_irrigation_machine_hrs)){
                            $entry1->owned_irrigation_machine_unit = $hectare_master_unit;
                            $entry1->owned_irrigation_machine_hrs = number_format($entry1->owned_irrigation_machine_hrs/$entry2->value,3);
                        }
                        
                        if($entry1->land_holding_taken_lease_unit == $entry2->unit && is_numeric($entry1->land_holding_taken_lease)){
                            $entry1->land_holding_taken_lease_unit = $hectare_master_unit;
                            $entry1->land_holding_taken_lease = number_format($entry1->land_holding_taken_lease/$entry2->value,3);
                        }
                        
                        if($entry1->land_given_lease_unit == $entry2->unit && is_numeric($entry1->land_given_lease)){
                            $entry1->land_given_lease_unit = $hectare_master_unit;
                            $entry1->land_given_lease = number_format($entry1->land_given_lease/$entry2->value,3);
                        }
                }
        }
    }
    
    $unitArr = [];
     foreach($data as $unites){
      $val = $unites->insecticide_unit !== null ? json_decode($unites->insecticide_unit, true) : [];
      if(count($val) > count($unitArr)){
         $unitArr = $val; 
      }
    }
    
    $otherferArr = [];
        foreach($data as $otherferunit){
          $val = $otherferunit->other_fertiliser_name !== null ? json_decode($otherferunit->other_fertiliser_name, true) : [];
          if(count($val) > count($otherferArr)){
             $otherferArr = $val; 
          }
    }
   
    $prother = [];
        foreach($data as $proOther){
          $val = $proOther->production_outputs_other !== null ? json_decode($proOther->production_outputs_other, true) : [];
          if(count($val) > count($prother)){
             $prother = $val; 
          }
    }

?>


<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>



<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-3">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            
            <div class="col-lg-9">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.one.update')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <a href="<?php echo e(route('anexure.one')); ?>" class="btn btn-primary btn-sm">Back</a>
                </form>
            </div>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Anexure List One</h1>
        </div>
        
        <form id="dataForm" action="<?php echo e(route('anexure.one.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="data_id" id="data_id" value="">
            <input type="hidden" name="farmer_id" id="farmer_id" value="">

            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <tr>
                    <td>
                        A
                    </td>
                    <td>
                        FARMER CODE
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="" disabled value="<?php echo e($farmer->farmer_code); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        B
                    </td>
                    <td>
                        Farmer Name
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_first_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       
                        <input type="text" name="" disabled 
                        value="<?php echo e($farmer_first_name->farmer_first_name == 'null' ? '' : $farmer_first_name->farmer_first_name); ?> <?php echo e($farmer_first_name->farmer_last_name == 'null' ? '' : $farmer_first_name->farmer_last_name); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                       
                       
                        
                        
                    
                </tr>
                <!--<tr>-->
                <!--    <td>-->
                <!--        B-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Farmer Last Name-->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_last_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--        <input type="text" name="" disabled value="<?php echo e($farmer_last_name->farmer_last_name == 'null' ? '' : $farmer_last_name->farmer_last_name); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                <tr>
                    <td>
                        C
                    </td>
                    <td>
                       S/O or W/O
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $father_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="" disabled value="<?php echo e(isset($father_name->farmer_husband_father_name) && $father_name->farmer_husband_father_name ? $father_name->farmer_husband_father_name : ''); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        D
                    </td>
                    <td>
                       Village
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_village): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="" disabled value="<?php echo e($farmer_village->user_village == 'null' ? '' : $farmer_village->user_village); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        E
                    </td>
                   <td>
                      State
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="" disabled value="<?php echo e($farmer_state->farmer_state_name == 'null' ? '' : $farmer_state->farmer_state_name); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        F
                    </td>
                   <td>
                      District
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_dis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="" disabled value="<?php echo e($farmer_dis->farmer_district_name == 'null' ? '' : $farmer_dis->farmer_district_name); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        G
                    </td>
                    <td>
                       Block
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer_block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="" disabled value="<?php echo e($farmer_block->farmer_block == 'null' ? '' : $farmer_block->farmer_block); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        H
                    </td>
                    <td>
                        Mobile Number
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobile_number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="" disabled value="<?php echo e($mobile_number->farmer_mobile_number == 'null' ? '' : $mobile_number->farmer_mobile_number); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        I
                    </td>
                    <td>
                        Kcc Limit
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kcc_limit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" 
                        name="kcc_limit_<?php echo e(isset($kcc_limit->id) && $kcc_limit->id ? $kcc_limit->id : ''); ?>_<?php echo e(isset($kcc_limit->farmerId) && $kcc_limit->farmerId ? $kcc_limit->farmerId : ''); ?>" value="<?php echo e($kcc_limit->kcc_limit == 'null' ? '' : $kcc_limit->kcc_limit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        J
                    </td>
                    <td>
                        Land Type
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $land_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" 
                        name="land_type_<?php echo e(isset($land_type->id) && $land_type->id ? $land_type->id : ''); ?>_<?php echo e(isset($land_type->farmerId) && $land_type->farmerId ? $land_type->farmerId : ''); ?>" value="<?php echo e($land_type->land_type == 'null' ? '' : $land_type->land_type); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        K
                    </td>
                    <td>
                        Soil Health Card
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $soilHealthCard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" 
                        name="soil_health_card_<?php echo e(isset($soilHealthCard->id) && $soilHealthCard->id ? $soilHealthCard->id : ''); ?>_<?php echo e(isset($soilHealthCard->farmerId) && $soilHealthCard->farmerId ? $soilHealthCard->farmerId : ''); ?>" value="<?php echo e($soilHealthCard->soil_health_card == 'null' ? '' : $soilHealthCard->soil_health_card); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        L
                    </td>
                    <td>
                        Soil Health Card Remark
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $soilHealthCardRemark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" 
                        name="soil_health_card_remark_<?php echo e(isset($soilHealthCardRemark->farmerId) && $soilHealthCardRemark->farmerId ? $soilHealthCardRemark->farmerId : ''); ?>_<?php echo e(isset($soilHealthCardRemark->id) && $soilHealthCardRemark->id ? $soilHealthCardRemark->id : ''); ?>" value="<?php echo e($soilHealthCardRemark->soil_health_card_remark == 'null' ? '' : $soilHealthCardRemark->soil_health_card_remark); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        M
                    </td>
                    <td>
                        Land Holding Size Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $landHoldSizeUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" 
                        name="land_holding_size_unit_<?php echo e(isset($landHoldSizeUnit->id) && $landHoldSizeUnit->id ? $landHoldSizeUnit->id : ''); ?>_<?php echo e(isset($landHoldSizeUnit->farmerId) && $landHoldSizeUnit->farmerId ? $landHoldSizeUnit->farmerId : ''); ?>" value="<?php echo e($landHoldSizeUnit->land_holding_size_unit == 'null' ? '' : $landHoldSizeUnit->land_holding_size_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        N
                    </td>
                    <td>
                        Land Holding (Area)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $land_holding_size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                      
                   
                   
                    
                    <input type="text" 
                        name="land_holding_size_<?php echo e(isset($land_holding_size->id) && $land_holding_size->id ? $land_holding_size->id : ''); ?>_<?php echo e(isset($land_holding_size->farmerId) && $land_holding_size->farmerId ? $land_holding_size->farmerId : ''); ?>" 
                        value=" <?php echo e($land_holding_size->land_holding_size == 'null' ? '' : $land_holding_size->land_holding_size); ?>">
                        
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        O
                    </td>
                    <td>
                        Land Given Lease Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $landGivenLeaseUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" 
                        name="land_given_lease_unit_<?php echo e(isset($landGivenLeaseUnit->id) && $landGivenLeaseUnit->id ? $landGivenLeaseUnit->id : ''); ?>_<?php echo e(isset($landGivenLeaseUnit->farmerId) && $landGivenLeaseUnit->farmerId ? $landGivenLeaseUnit->farmerId : ''); ?>" value="<?php echo e($landGivenLeaseUnit->land_given_lease_unit == 'null' ? '' : $landGivenLeaseUnit->land_given_lease_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                 <tr>
                    <td>
                        P
                    </td>
                    <td>
                        Land Given Lease (Area)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $landGivenLease): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       
                               
                    
                    <input type="text" name="land_given_lease_<?php echo e(isset($landGivenLease->id) && $landGivenLease->id ? $landGivenLease->id : ''); ?>" 
                            value="<?php echo e($landGivenLease->land_given_lease == 'null' ? '' : $landGivenLease->land_given_lease); ?>">
                        
                        
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        Q
                    </td>
                    <td>
                        Land Holding Taken Lease Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $landHoldTakenLeaseUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="land_holding_taken_lease_unit_<?php echo e(isset($landHoldTakenLeaseUnit->id) && $landHoldTakenLeaseUnit->id ? $landHoldTakenLeaseUnit->id : ''); ?>" value="<?php echo e($landHoldTakenLeaseUnit->land_holding_taken_lease_unit == 'null' ? '' : $landHoldTakenLeaseUnit->land_holding_taken_lease_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        R
                    </td>
                    <td>
                        Land Holding taken Lease (Area)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $land_holding_taken_lease): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       
                        
                        <input type="text" name="land_holding_taken_lease_<?php echo e(isset($land_holding_taken_lease->id) && $land_holding_taken_lease->id ? $land_holding_taken_lease->id : ''); ?>" 
                        value="">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        S
                    </td>
                    <td>
                        Total Cultivable Area Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $totalCultiUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="total_cultivable_unit_<?php echo e(isset($totalCultiUnit->id) && $totalCultiUnit->id ? $totalCultiUnit->id : ''); ?>" value="<?php echo e($totalCultiUnit->total_cultivable_unit == 'null' ? '' : $totalCultiUnit->total_cultivable_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        T
                    </td>
                    <td>
                        Total Cultivable (Area)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total_cultivable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                   
                    
                    <input type="text" name="total_cultivable_<?php echo e(isset($total_cultivable->id) && $total_cultivable->id ? $total_cultivable->id : ''); ?>" 
                    value="<?php echo e($totalCultiUnit->total_cultivable_unit == 'null' ? '' : $totalCultiUnit->total_cultivable_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        U
                    </td>
                   <td>
                        CROPPING PATTERN
                    </td>
                     <?php
                        $counter = [];
                    ?>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crop_patt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <?php
                            $farmerId = $crop_patt->farmer_id;
                            $counter[$farmerId] = isset($counter[$farmerId]) ? $counter[$farmerId] + 1 : 1;
                             $romanCount = int_to_roman($counter[$farmerId]);
                        ?>
                    <td>
                       CROP <?php echo e($romanCount); ?>

                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php
                            function int_to_roman($num) {
                                $n = intval($num);
                                $result = '';
                                
                                $roman_numerals = array(
                                    'M' => 1000,
                                    'CM' => 900,
                                    'D' => 500,
                                    'CD' => 400,
                                    'C' => 100,
                                    'XC' => 90,
                                    'L' => 50,
                                    'XL' => 40,
                                    'X' => 10,
                                    'IX' => 9,
                                    'V' => 5,
                                    'IV' => 4,
                                    'I' => 1
                                );
                                
                                foreach ($roman_numerals as $roman => $value) {
                                    $matches = intval($n / $value);
                                    $result .= str_repeat($roman, $matches);
                                    $n = $n % $value;
                                }
                                
                                return $result;
                            }
                        ?>
                </tr>
                <tr>
                    <td>
                        1
                    </td>
                    <td>
                        Season
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" 
                        name="season_<?php echo e(isset($season->id) && $season->id ? $season->id : ''); ?>_<?php echo e(isset($season->farmerId) && $season->farmerId ? $season->farmerId : ''); ?>" value="<?php echo e($season->season == 'null' ? '' : $season->season); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        2
                    </td>
                    <td>
                        Crop Name
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crop_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="crop_name_<?php echo e(isset($crop_name->id) && $crop_name->id ? $crop_name->id : ''); ?>_<?php echo e(isset($crop_name->farmerId) && $crop_name->farmerId ? $crop_name->farmerId : ''); ?>" value="<?php echo e($crop_name->crop_name == 'null' ? '' : $crop_name->crop_name); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        3
                    </td>
                    <td>
                        Total Cultivatable  Area Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crop_area_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="crop_area_unit_<?php echo e(isset($crop_area_unit->id) && $crop_area_unit->id ? $crop_area_unit->id : ''); ?>_<?php echo e(isset($crop_area_unit->farmerId) && $crop_area_unit->farmerId ? $crop_area_unit->farmerId : ''); ?>" value="<?php echo e($crop_area_unit->crop_area_unit == 'null' ? '' : $crop_area_unit->crop_area_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        4
                    </td>
                    <td>
                        Total Cultivatable Crop Area
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crop_area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                   
                    <input type="text" name="crop_area_<?php echo e(isset($crop_area->id) && $crop_area->id ? $crop_area->id : ''); ?>_<?php echo e(isset($crop_area->farmerId) && $crop_area->farmerId ? $crop_area->farmerId : ''); ?>" 
                    value="<?php echo e($crop_area->crop_area == 'null' ? '' : $crop_area->crop_area); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                </tr>
                <tr>
                    <td>
                        5
                    </td>
                    <td>
                        Irrigated Area
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $irr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="irrigated_area_<?php echo e(isset($irr->id) && $irr->id ? $irr->id : ''); ?>_<?php echo e(isset($irr->farmerId) && $irr->farmerId ? $irr->farmerId : ''); ?>" value="<?php echo e($irr->irrigated_area == 'null' ? '' : $irr->irrigated_area); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        V
                    </td>
                    <th colspan="50">
                        CULTIVATION  COST 
                    </td>
                       
                </tr>
                
                <tr>
                    <td>
                        1
                    </td>
                    <td>
                        Family Labour Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="family_labour_unit_<?php echo e(isset($fl->id) && $fl->id ? $fl->id : ''); ?>_<?php echo e(isset($fl->farmerId) && $fl->farmerId ? $fl->farmerId : ''); ?>"
                        
                        <?php if(isset($fl->family_labour_unit) && $fl->family_labour_unit == 'mandays'): ?>
                            value="Mandays"
                        <?php elseif(isset($fl->family_labour_unit) && $fl->family_labour_unit == 'hours'): ?>
                           value="Hours" 
                        <?php else: ?>
                            value="<?php echo e($fl->family_labour_unit == 'null' ? '' : $fl->family_labour_unit); ?>"
                        <?php endif; ?>
                        >
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        2
                    </td>
                    <td>
                        Family Labour
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="family_labour_hrs_<?php echo e(isset($fl->id) && $fl->id ? $fl->id : ''); ?>_<?php echo e(isset($fl->farmerId) && $fl->farmerId ? $fl->farmerId : ''); ?>" value="<?php echo e($fl->family_labour_hrs == 'null' ? '' : $fl->family_labour_hrs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        3
                    </td>
                    <td>
                        Family Labour Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $familyLabourUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="family_labour_unit_price_<?php echo e(isset($familyLabourUnitPrice->id) && $familyLabourUnitPrice->id ? $familyLabourUnitPrice->id : ''); ?>_<?php echo e(isset($familyLabourUnitPrice->farmerId) && $familyLabourUnitPrice->farmerId ? $familyLabourUnitPrice->farmerId : ''); ?>" value="<?php echo e($familyLabourUnitPrice->family_labour_unit_price == 'null' ? '' : $familyLabourUnitPrice->family_labour_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        4
                    </td>
                    <td>
                        Family Labour (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="family_labour_rs_<?php echo e(isset($flr->id) && $flr->id ? $flr->id : ''); ?>_<?php echo e(isset($flr->farmerId) && $flr->farmerId ? $flr->farmerId : ''); ?>" value="<?php echo e($flr->family_labour_rs == 'null' ? '' : $flr->family_labour_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        5
                    </td>
                    <td>
                        Family Labour Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $familyLabourRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="family_labour_remarks_<?php echo e(isset($familyLabourRemarks->id) && $familyLabourRemarks->id ? $familyLabourRemarks->id : ''); ?>_<?php echo e(isset($familyLabourRemarks->farmerId) && $familyLabourRemarks->farmerId ? $familyLabourRemarks->farmerId : ''); ?>" value="<?php echo e($familyLabourRemarks->family_labour_remarks == 'null' ? '' : $familyLabourRemarks->family_labour_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        6
                    </td>
                    <td>
                        Attached Labour Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="attached_labour_unit_<?php echo e(isset($fl->id) && $fl->id ? $fl->id : ''); ?>_<?php echo e(isset($fl->farmerId) && $fl->farmerId ? $fl->farmerId : ''); ?>" value="<?php echo e($fl->attached_labour_unit == 'null' ? '' : $fl->attached_labour_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        6
                    </td>
                    <td>
                        Attached Labour Duration
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attached_labour_duration): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="attached_labour_duration_<?php echo e(isset($attached_labour_duration->id) && $attached_labour_duration->id ? $attached_labour_duration->id : ''); ?>_<?php echo e(isset($attached_labour_duration->farmerId) && $attached_labour_duration->farmerId ? $attached_labour_duration->farmerId : ''); ?>" value="<?php echo e($attached_labour_duration->attached_labour_duration == 'null' ? '' : $attached_labour_duration->attached_labour_duration); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        7
                    </td>
                    <td>
                        Attached Labour
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attached_labour_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="attached_labour_hrs_<?php echo e(isset($attached_labour_hrs->id) && $attached_labour_hrs->id ? $attached_labour_hrs->id : ''); ?>_<?php echo e(isset($attached_labour_hrs->farmerId) && $attached_labour_hrs->farmerId ? $attached_labour_hrs->farmerId : ''); ?>" value="<?php echo e($attached_labour_hrs->attached_labour_hrs == 'null' ? '' : $attached_labour_hrs->attached_labour_hrs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        8
                    </td>
                    <td>
                        Attached Labour Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachedLabourUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="attached_labour_unit_price_<?php echo e(isset($attachedLabourUnitPrice->id) && $attachedLabourUnitPrice->id ? $attachedLabourUnitPrice->id : ''); ?>_<?php echo e(isset($attachedLabourUnitPrice->farmerId) && $attachedLabourUnitPrice->farmerId ? $attachedLabourUnitPrice->farmerId : ''); ?>" value="<?php echo e($attachedLabourUnitPrice->attached_labour_unit_price == 'null' ? '' : $attachedLabourUnitPrice->attached_labour_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
        
                <tr>
                    <td>
                        9
                    </td>
                    <td>
                        Attached Labour (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attached_labour_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="attached_labour_rs_<?php echo e(isset($attached_labour_rs->id) && $attached_labour_rs->id ? $attached_labour_rs->id : ''); ?>_<?php echo e(isset($attached_labour_rs->farmerId) && $attached_labour_rs->farmerId ? $attached_labour_rs->farmerId : ''); ?>" value="<?php echo e($attached_labour_rs->attached_labour_rs == 'null' ? '' : $attached_labour_rs->attached_labour_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                       10
                    </td>
                    <td>
                        Attached Labour Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachedLabourRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="attached_labour_remarks_<?php echo e(isset($attachedLabourRemarks->id) && $attachedLabourRemarks->id ? $attachedLabourRemarks->id : ''); ?>_<?php echo e(isset($attachedLabourRemarks->farmerId) && $attachedLabourRemarks->farmerId ? $attachedLabourRemarks->farmerId : ''); ?>" value="<?php echo e($attachedLabourRemarks->attached_labour_remarks == 'null' ? '' : $attachedLabourRemarks->attached_labour_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        11
                    </td>
                    <td>
                        Casual Labour Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="casual_labour_unit_<?php echo e(isset($fl->id) && $fl->id ? $fl->id : ''); ?>_<?php echo e(isset($fl->farmerId) && $fl->farmerId ? $fl->farmerId : ''); ?>" value="<?php echo e($fl->casual_labour_unit == 'null' ? '' : $fl->casual_labour_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <!--<tr>-->
                <!--    <td>-->
                <!--        12-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Casual Labour (Rs.)-->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $casual_labour_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--        <input type="text" name="casual_labour_rs_<?php echo e(isset($casual_labour_rs->id) && $casual_labour_rs->id ? $casual_labour_rs->id : ''); ?>" value="<?php echo e($casual_labour_rs->casual_labour_rs == 'null' ? '' : $casual_labour_rs->casual_labour_rs); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
            
                <tr>
                    <td>
                        12
                    </td>
                    <td>
                        Casual Labour
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $casual_labour_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="casual_labour_hrs_<?php echo e(isset($casual_labour_hrs->id) && $casual_labour_hrs->id ? $casual_labour_hrs->id : ''); ?>_<?php echo e(isset($casual_labour_hrs->farmerId) && $casual_labour_hrs->farmerId ? $casual_labour_hrs->farmerId : ''); ?>" value="<?php echo e($casual_labour_hrs->casual_labour_hrs == 'null' ? '' : $casual_labour_hrs->casual_labour_hrs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        13
                    </td>
                    <td>
                        Casual Labour Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $casualLabourUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="casual_labour_unit_price_<?php echo e(isset($casualLabourUnitPrice->id) && $casualLabourUnitPrice->id ? $casualLabourUnitPrice->id : ''); ?>_<?php echo e(isset($casualLabourUnitPrice->farmerId) && $casualLabourUnitPrice->farmerId ? $casualLabourUnitPrice->farmerId : ''); ?>" value="<?php echo e($casualLabourUnitPrice->casual_labour_unit_price == 'null' ? '' : $casualLabourUnitPrice->casual_labour_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                 <tr>
                    <td>
                        14
                    </td>
                    <td>
                        Casual Labour (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $casual_labour_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="casual_labour_rs_<?php echo e(isset($casual_labour_rs->id) && $casual_labour_rs->id ? $casual_labour_rs->id : ''); ?>_<?php echo e(isset($casual_labour_rs->farmerId) && $casual_labour_rs->farmerId ? $casual_labour_rs->farmerId : ''); ?>" value="<?php echo e($casual_labour_rs->casual_labour_rs == 'null' ? '' : $casual_labour_rs->casual_labour_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                       15
                    </td>
                    <td>
                        Casual Labour Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $casualLabourRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="casual_labour_remarks_<?php echo e(isset($casualLabourRemarks->id) && $casualLabourRemarks->id ? $casualLabourRemarks->id : ''); ?>_<?php echo e(isset($casualLabourRemarks->farmerId) && $casualLabourRemarks->farmerId ? $casualLabourRemarks->farmerId : ''); ?>" value="<?php echo e($casualLabourRemarks->casual_labour_remarks == 'null' ? '' : $casualLabourRemarks->casual_labour_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        16
                    </td>
                    <td>
                        Hired Animal Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_animal_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="hired_animal_unit_<?php echo e(isset($hired_animal_unit->id) && $hired_animal_unit->id ? $hired_animal_unit->id : ''); ?>_<?php echo e(isset($hired_animal_unit->farmerId) && $hired_animal_unit->farmerId ? $hired_animal_unit->farmerId : ''); ?>" value="<?php echo e($hired_animal_unit->hired_animal_unit == 'null' ? '' : $hired_animal_unit->hired_animal_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <!--<tr>-->
                <!--    <td>-->
                <!--        17-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Animal Labour-->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_animal_labour_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--        <input type="text" name="hired_animal_labour_rs_<?php echo e(isset($hired_animal_labour_rs->id) && $hired_animal_labour_rs->id ? $hired_animal_labour_rs->id : ''); ?>" value="<?php echo e($hired_animal_labour_rs->hired_animal_labour_rs == 'null' ? '' : $hired_animal_labour_rs->hired_animal_labour_rs); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                
                <tr>
                    <td>
                        17
                    </td>
                    <td>
                        Hired Animal 
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredAnimalHrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        
                         <input type="text" name="hiredAnimalHrs_<?php echo e(isset($hiredAnimalHrs->id) && $hiredAnimalHrs->id ? $hiredAnimalHrs->id : ''); ?>_<?php echo e(isset($hiredAnimalHrs->farmerId) && $hiredAnimalHrs->farmerId ? $hiredAnimalHrs->farmerId : ''); ?>" 
                         value="<?php echo e($hiredAnimalHrs->hired_animal_hrs == 'null' ? '' : $hiredAnimalHrs->hired_animal_hrs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        18
                    </td>
                    <td>
                        Hired Animal Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredAnimalUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="hired_animal_unit_price_<?php echo e(isset($hiredAnimalUnitPrice->id) && $hiredAnimalUnitPrice->id ? $hiredAnimalUnitPrice->id : ''); ?>_<?php echo e(isset($hiredAnimalUnitPrice->farmerId) && $hiredAnimalUnitPrice->farmerId ? $hiredAnimalUnitPrice->farmerId : ''); ?>" value="<?php echo e($hiredAnimalUnitPrice->hired_animal_unit_price == 'null' ? '' : $hiredAnimalUnitPrice->hired_animal_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <!--<tr>-->
                <!--    <td>-->
                <!--        18-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Animal Labour -->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_animal_labour_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--        <input type="text" name="hired_animal_labour_hrs_<?php echo e(isset($hired_animal_labour_hrs->id) && $hired_animal_labour_hrs->id ? $hired_animal_labour_hrs->id : ''); ?>" value="<?php echo e($hired_animal_labour_hrs->hired_animal_labour_hrs == 'null' ? '' : $hired_animal_labour_hrs->hired_animal_labour_hrs); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                
                <tr>
                    <td>
                        19
                    </td>
                    <td>
                        Hired Animal (Rs)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredAnimalRs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        
                        <input type="text" name="hiredAnimalRs_<?php echo e(isset($hiredAnimalRs->id) && $hiredAnimalRs->id ? $hiredAnimalRs->id : ''); ?>_<?php echo e(isset($hiredAnimalRs->farmerId) && $hiredAnimalRs->farmerId ? $hiredAnimalRs->farmerId : ''); ?>"
                        value="<?php echo e($hiredAnimalRs->hired_animal_rs == 'null' ? '' : $hiredAnimalRs->hired_animal_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
        
                <tr>
                    <td>
                       20
                    </td>
                    <td>
                        Hired Animal Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredAnimalRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="hired_animal_remarks_<?php echo e(isset($hiredAnimalRemarks->id) && $hiredAnimalRemarks->id ? $hiredAnimalRemarks->id : ''); ?>_<?php echo e(isset($hiredAnimalRemarks->farmerId) && $hiredAnimalRemarks->farmerId ? $hiredAnimalRemarks->farmerId : ''); ?>" value="<?php echo e($hiredAnimalRemarks->hired_animal_remarks == 'null' ? '' : $hiredAnimalRemarks->hired_animal_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       21
                    </td>
                    <td>
                        Owned Animal Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedAnimalUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="owned_animal_unit_<?php echo e(isset($ownedAnimalUnit->id) && $ownedAnimalUnit->id ? $ownedAnimalUnit->id : ''); ?>_<?php echo e(isset($ownedAnimalUnit->farmerId) && $ownedAnimalUnit->farmerId ? $ownedAnimalUnit->farmerId : ''); ?>" value="<?php echo e($ownedAnimalUnit->owned_animal_unit == 'null' ? '' : $ownedAnimalUnit->owned_animal_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        22
                    </td>
                    <td>
                        Owned Animal  
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owned_animal_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="owned_animal_hrs_<?php echo e(isset($owned_animal_hrs->id) && $owned_animal_hrs->id ? $owned_animal_hrs->id : ''); ?>_<?php echo e(isset($owned_animal_hrs->farmerId) && $owned_animal_hrs->farmerId ? $owned_animal_hrs->farmerId : ''); ?>" value="<?php echo e($owned_animal_hrs->owned_animal_hrs == 'null' ? '' : $owned_animal_hrs->owned_animal_hrs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       23
                    </td>
                    <td>
                        Owned Animal Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedAnimalUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="owned_animal_unit_price_<?php echo e(isset($ownedAnimalUnitPrice->id) && $ownedAnimalUnitPrice->id ? $ownedAnimalUnitPrice->id : ''); ?>_<?php echo e(isset($ownedAnimalUnitPrice->farmerId) && $ownedAnimalUnitPrice->farmerId ? $ownedAnimalUnitPrice->farmerId : ''); ?>" value="<?php echo e($ownedAnimalUnitPrice->owned_animal_unit_price == 'null' ? '' : $ownedAnimalUnitPrice->owned_animal_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        24
                    </td>
                    <td>
                        Owned Animal Labour (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owned_animal_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="owned_animal_rs_<?php echo e(isset($owned_animal_rs->id) && $owned_animal_rs->id ? $owned_animal_rs->id : ''); ?>_<?php echo e(isset($owned_animal_rs->farmerId) && $owned_animal_rs->farmerId ? $owned_animal_rs->farmerId : ''); ?>" value="<?php echo e($owned_animal_rs->owned_animal_rs == 'null' ? '' : $owned_animal_rs->owned_animal_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       25
                    </td>
                    <td>
                        Owned Animal Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedAnimalRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="owned_animal_remarks_<?php echo e(isset($ownedAnimalRemarks->id) && $ownedAnimalRemarks->id ? $ownedAnimalRemarks->id : ''); ?>_<?php echo e(isset($ownedAnimalRemarks->farmerId) && $ownedAnimalRemarks->farmerId ? $ownedAnimalRemarks->farmerId : ''); ?>" value="<?php echo e($ownedAnimalRemarks->owned_animal_remarks == 'null' ? '' : $ownedAnimalRemarks->owned_animal_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        26
                    </td>
                    <td>
                        Hired Machine Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_machhine_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="hired_machhine_unit_<?php echo e(isset($hired_machhine_unit->id) && $hired_machhine_unit->id ? $hired_machhine_unit->id : ''); ?>_<?php echo e(isset($hired_machhine_unit->farmerId) && $hired_machhine_unit->farmerId ? $hired_machhine_unit->farmerId : ''); ?>"
                        value="<?php echo e($hired_machhine_unit->hired_machhine_unit == 'null' ? '' : $hired_machhine_unit->hired_machhine_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        27
                    </td>
                    <td>
                        Hired Machine 
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_machhine_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="hired_machhine_hrs_<?php echo e(isset($hired_machhine_hrs->id) && $hired_machhine_hrs->id ? $hired_machhine_hrs->id : ''); ?>_<?php echo e(isset($hired_machhine_hrs->farmerId) && $hired_machhine_hrs->farmerId ? $hired_machhine_hrs->farmerId : ''); ?>" value="<?php echo e($hired_machhine_hrs->hired_machhine_hrs == 'null' ? '' : $hired_machhine_hrs->hired_machhine_hrs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        28
                    </td>
                    <td>
                        Hired Machhine Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredMachhineUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="hired_machhine_unit_price_<?php echo e(isset($hiredMachhineUnitPrice->id) && $hiredMachhineUnitPrice->id ? $hiredMachhineUnitPrice->id : ''); ?>_<?php echo e(isset($hiredMachhineUnitPrice->farmerId) && $hiredMachhineUnitPrice->farmerId ? $hiredMachhineUnitPrice->farmerId : ''); ?>" value="<?php echo e($hiredMachhineUnitPrice->hired_machhine_unit_price == 'null' ? '' : $hiredMachhineUnitPrice->hired_machhine_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        29
                    </td>
                    <td>
                        Hired Machine (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_machhine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="hired_machhine_rs_<?php echo e(isset($hired_machhine_rs->id) && $hired_machhine_rs->id ? $hired_machhine_rs->id : ''); ?>_<?php echo e(isset($hired_machhine_rs->farmerId) && $hired_machhine_rs->farmerId ? $hired_machhine_rs->farmerId : ''); ?>" value="<?php echo e($hired_machhine_rs->hired_machhine_rs == 'null' ? '' : $hired_machhine_rs->hired_machhine_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        30
                    </td>
                    <td>
                        Hired Machine Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredMachhineRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="hired_machhine_remarks_<?php echo e(isset($hiredMachhineRemarks->id) && $hiredMachhineRemarks->id ? $hiredMachhineRemarks->id : ''); ?>_<?php echo e(isset($hiredMachhineRemarks->farmerId) && $hiredMachhineRemarks->farmerId ? $hiredMachhineRemarks->farmerId : ''); ?>" value="<?php echo e($hiredMachhineRemarks->hired_machhine_remarks == 'null' ? '' : $hiredMachhineRemarks->hired_machhine_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        31
                    </td>
                    <td>
                        Own Machine Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownMachineUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="own_machine_unit_<?php echo e(isset($ownMachineUnit->id) && $ownMachineUnit->id ? $ownMachineUnit->id : ''); ?>_<?php echo e(isset($ownMachineUnit->farmerId) && $ownMachineUnit->farmerId ? $ownMachineUnit->farmerId : ''); ?>" value="<?php echo e($ownMachineUnit->own_machine_unit == 'null' ? '' : $ownMachineUnit->own_machine_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        32
                    </td>
                    <td>
                        Own Machine 
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $own_machine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="own_machine_rs_<?php echo e(isset($own_machine_rs->id) && $own_machine_rs->id ? $own_machine_rs->id : ''); ?>_<?php echo e(isset($own_machine_rs->farmerId) && $own_machine_rs->farmerId ? $own_machine_rs->farmerId : ''); ?>" value="<?php echo e($own_machine_rs->own_machine_rs == 'null' ? '' : $own_machine_rs->own_machine_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        33
                    </td>
                    <td>
                        Own Machine Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownMachineUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="own_machine_unit_price_<?php echo e(isset($ownMachineUnitPrice->id) && $ownMachineUnitPrice->id ? $ownMachineUnitPrice->id : ''); ?>_<?php echo e(isset($ownMachineUnitPrice->farmerId) && $ownMachineUnitPrice->farmerId ? $ownMachineUnitPrice->farmerId : ''); ?>" value="<?php echo e($ownMachineUnitPrice->own_machine_unit_price == 'null' ? '' : $ownMachineUnitPrice->own_machine_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        34
                    </td>
                    <td>
                        Own Machine (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $own_machine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="own_machine_rs_<?php echo e(isset($own_machine_rs->id) && $own_machine_rs->id ? $own_machine_rs->id : ''); ?>_<?php echo e(isset($own_machine_rs->farmerId) && $own_machine_rs->farmerId ? $own_machine_rs->farmerId : ''); ?>" 
                        value="<?php echo e($own_machine_rs->own_machine_rs == 'null' ? '' : $own_machine_rs->own_machine_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       35
                    </td>
                    <td>
                        Own Machine Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownMachineRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="own_machine_remarks_<?php echo e(isset($ownMachineRemarks->id) && $ownMachineRemarks->id ? $ownMachineRemarks->id : ''); ?>_<?php echo e(isset($ownMachineRemarks->farmerId) && $ownMachineRemarks->farmerId ? $ownMachineRemarks->farmerId : ''); ?>" value="<?php echo e($ownMachineRemarks->own_machine_remarks == 'null' ? '' : $ownMachineRemarks->own_machine_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                <!--<tr>-->
                <!--    <td>-->
                <!--       36-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Irrigation Machine Unit-->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredIrrigationMachineUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--       <input type="text" name="hired_irrigation_machine_unit_<?php echo e(isset($hiredIrrigationMachineUnit->id) && $hiredIrrigationMachineUnit->id ? $hiredIrrigationMachineUnit->id : ''); ?>" value="<?php echo e($hiredIrrigationMachineUnit->hired_irrigation_machine_unit == 'null' ? '' : $hiredIrrigationMachineUnit->hired_irrigation_machine_unit); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        37-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Irrigation Machine -->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--        <input type="text" name="hired_irrigation_machine_hrs_<?php echo e(isset($hired_irrigation_machine_hrs->id) && $hired_irrigation_machine_hrs->id ? $hired_irrigation_machine_hrs->id : ''); ?>" value="<?php echo e($hired_irrigation_machine_hrs->hired_irrigation_machine_hrs == 'null' ? '' : $hired_irrigation_machine_hrs->hired_irrigation_machine_hrs); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        38-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Irrigation Machine Unit Price-->
                <!--    </td>-->
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_unit_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--       <input type="text" name="hired_irrigation_machine_unit_price_<?php echo e(isset($hired_irrigation_machine_unit_price->id) && $hired_irrigation_machine_unit_price->id ? $hired_irrigation_machine_unit_price->id : ''); ?>" value="<?php echo e($hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price == 'null' ? '' : $hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        39-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Irrigation Machine (Rs.)-->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--        <input type="text" name="hired_irrigation_machine_rs_<?php echo e(isset($hired_irrigation_machine_rs->id) && $hired_irrigation_machine_rs->id ? $hired_irrigation_machine_rs->id : ''); ?>" value="<?php echo e($hired_irrigation_machine_rs->hired_irrigation_machine_rs == 'null' ? '' : $hired_irrigation_machine_rs->hired_irrigation_machine_rs); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        40-->
                <!--    </td>-->
                <!--    <td>-->
                <!--   Hired Irrigation Machine Remarks-->
                <!--    </td>-->
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_remarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--       <input type="text" name="hired_irrigation_machine_remarks_<?php echo e(isset($hired_irrigation_machine_remarks->id) && $hired_irrigation_machine_remarks->id ? $hired_irrigation_machine_remarks->id : ''); ?>" value="<?php echo e($hired_irrigation_machine_remarks->hired_irrigation_machine_remarks == 'null' ? '' : $hired_irrigation_machine_remarks->hired_irrigation_machine_remarks); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                   
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--       41-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Owned Irrigation Machine Unit-->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedIrrigationMachineUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--       <input type="text" name="owned_irrigation_machine_unit_<?php echo e(isset($ownedIrrigationMachineUnit->id) && $ownedIrrigationMachineUnit->id ? $ownedIrrigationMachineUnit->id : ''); ?>" -->
                <!--       value="<?php echo e($ownedIrrigationMachineUnit->owned_irrigation_machine_unit == 'null' ? '' : $ownedIrrigationMachineUnit->owned_irrigation_machine_unit); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        42-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Owned Irrigation Machine -->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owned_irrigation_machine_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--        <input type="text" name="owned_irrigation_machine_hrs_<?php echo e(isset($owned_irrigation_machine_hrs->id) && $owned_irrigation_machine_hrs->id ? $owned_irrigation_machine_hrs->id : ''); ?>" -->
                <!--        value="<?php echo e($owned_irrigation_machine_hrs->owned_irrigation_machine_hrs); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--       43-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Owned Irrigation Machine Unit Price-->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedIrrigationMachineUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--       <input type="text" name="owned_irrigation_machine_unit_price_<?php echo e(isset($ownedIrrigationMachineUnitPrice->id) && $ownedIrrigationMachineUnitPrice->id ? $ownedIrrigationMachineUnitPrice->id : ''); ?>" value="<?php echo e($ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price == 'null' ? '' : $ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        44-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Owned Irrigation Machine (Rs.)-->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owned_irrigation_machine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--        <input type="text" name="owned_irrigation_machine_rs_<?php echo e(isset($owned_irrigation_machine_rs->id) && $owned_irrigation_machine_rs->id ? $owned_irrigation_machine_rs->id : ''); ?>" value="<?php echo e($owned_irrigation_machine_rs->owned_irrigation_machine_rs); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--       45-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Owned Irrigation Machine Remarks-->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedIrrigationMachineRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--       <input type="text" name="owned_irrigation_machine_remarks_<?php echo e(isset($ownedIrrigationMachineRemarks->id) && $ownedIrrigationMachineRemarks->id ? $ownedIrrigationMachineRemarks->id : ''); ?>" value="<?php echo e($ownedIrrigationMachineRemarks->owned_irrigation_machine_remarks); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--       46-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Source of Seed / Plantlets-->
                <!--    </td>-->
                    
                <!--    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                <!--    <td>-->
                <!--       <input type="text" name="seed_type_<?php echo e(isset($seedType->id) && $seedType->id ? $seedType->id : ''); ?>" value="<?php echo e($seedType->seed_type); ?>">-->
                <!--    </td>-->
                <!--    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                <!--</tr>-->
                
                <tr>
                    <td>
                       36
                    </td>
                    <td>
                        Hired Irrigation Machine Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiredIrrigationMachineUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="hired_irrigation_machine_unit_<?php echo e(isset($hiredIrrigationMachineUnit->id) && $hiredIrrigationMachineUnit->id ? $hiredIrrigationMachineUnit->id : ''); ?>_<?php echo e(isset($hiredIrrigationMachineUnit->farmerId) && $hiredIrrigationMachineUnit->farmerId ? $hiredIrrigationMachineUnit->farmerId : ''); ?>" value="<?php echo e($hiredIrrigationMachineUnit->hired_irrigation_machine_unit == 'null' ? '' : $hiredIrrigationMachineUnit->hired_irrigation_machine_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        37
                    </td>
                    <td>
                        Hired Irrigation Machine 
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="hired_irrigation_machine_hrs_<?php echo e(isset($hired_irrigation_machine_hrs->id) && $hired_irrigation_machine_hrs->id ? $hired_irrigation_machine_hrs->id : ''); ?>_<?php echo e(isset($hired_irrigation_machine_hrs->farmerId) && $hired_irrigation_machine_hrs->farmerId ? $hired_irrigation_machine_hrs->farmerId : ''); ?>" value="<?php echo e($hired_irrigation_machine_hrs->hired_irrigation_machine_hrs == 'null' ? '' : $hired_irrigation_machine_hrs->hired_irrigation_machine_hrs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        38
                    </td>
                    <td>
                        Hired Irrigation Machine Unit Price
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_unit_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="hired_irrigation_machine_unit_price_<?php echo e(isset($hired_irrigation_machine_unit_price->id) && $hired_irrigation_machine_unit_price->id ? $hired_irrigation_machine_unit_price->id : ''); ?>_<?php echo e(isset($hired_irrigation_machine_unit_price->farmerId) && $hired_irrigation_machine_unit_price->farmerId ? $hired_irrigation_machine_unit_price->farmerId : ''); ?>" value="<?php echo e($hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price == 'null' ? '' : $hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        39
                    </td>
                    <td>
                        Hired Irrigation Machine (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="hired_irrigation_machine_rs_<?php echo e(isset($hired_irrigation_machine_rs->id) && $hired_irrigation_machine_rs->id ? $hired_irrigation_machine_rs->id : ''); ?>_<?php echo e(isset($hired_irrigation_machine_rs->farmerId) && $hired_irrigation_machine_rs->farmerId ? $hired_irrigation_machine_rs->farmerId : ''); ?>" value="<?php echo e($hired_irrigation_machine_rs->hired_irrigation_machine_rs == 'null' ? '' : $hired_irrigation_machine_rs->hired_irrigation_machine_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        40
                    </td>
                    <td>
                   Hired Irrigation Machine Remarks
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hired_irrigation_machine_remarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="hired_irrigation_machine_remarks_<?php echo e(isset($hired_irrigation_machine_remarks->id) && $hired_irrigation_machine_remarks->id ? $hired_irrigation_machine_remarks->id : ''); ?>_<?php echo e(isset($hired_irrigation_machine_remarks->farmerId) && $hired_irrigation_machine_remarks->farmerId ? $hired_irrigation_machine_remarks->farmerId : ''); ?>" value="<?php echo e($hired_irrigation_machine_remarks->hired_irrigation_machine_remarks == 'null' ? '' : $hired_irrigation_machine_remarks->hired_irrigation_machine_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   
                </tr>
                <tr>
                    <td>
                       41
                    </td>
                    <td>
                        Owned Irrigation Machine Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedIrrigationMachineUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="owned_irrigation_machine_unit_<?php echo e(isset($ownedIrrigationMachineUnit->id) && $ownedIrrigationMachineUnit->id ? $ownedIrrigationMachineUnit->id : ''); ?>_<?php echo e(isset($ownedIrrigationMachineUnit->farmerId) && $ownedIrrigationMachineUnit->farmerId ? $ownedIrrigationMachineUnit->farmerId : ''); ?>" 
                       value="<?php echo e($ownedIrrigationMachineUnit->owned_irrigation_machine_unit == 'null' ? '' : $ownedIrrigationMachineUnit->owned_irrigation_machine_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        42
                    </td>
                    <td>
                        Owned Irrigation Machine 
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owned_irrigation_machine_hrs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="owned_irrigation_machine_hrs_<?php echo e(isset($owned_irrigation_machine_hrs->id) && $owned_irrigation_machine_hrs->id ? $owned_irrigation_machine_hrs->id : ''); ?>_<?php echo e(isset($owned_irrigation_machine_hrs->farmerId) && $owned_irrigation_machine_hrs->farmerId ? $owned_irrigation_machine_hrs->farmerId : ''); ?>" 
                        value="<?php echo e($owned_irrigation_machine_hrs->owned_irrigation_machine_hrs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       43
                    </td>
                    <td>
                        Owned Irrigation Machine Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedIrrigationMachineUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text"
                        name="owned_irrigation_machine_unit_price_<?php echo e(isset($ownedIrrigationMachineUnitPrice->id) && $ownedIrrigationMachineUnitPrice->id ? $ownedIrrigationMachineUnitPrice->id : ''); ?>_<?php echo e(isset($ownedIrrigationMachineUnitPrice->farmerId) && $ownedIrrigationMachineUnitPrice->farmerId ? $ownedIrrigationMachineUnitPrice->farmerId : ''); ?>" value="<?php echo e($ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price == 'null' ? '' : $ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        44
                    </td>
                    <td>
                        Owned Irrigation Machine (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owned_irrigation_machine_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="owned_irrigation_machine_rs_<?php echo e(isset($owned_irrigation_machine_rs->id) && $owned_irrigation_machine_rs->id ? $owned_irrigation_machine_rs->id : ''); ?>_<?php echo e(isset($owned_irrigation_machine_rs->farmerId) && $owned_irrigation_machine_rs->farmerId ? $owned_irrigation_machine_rs->farmerId : ''); ?>" value="<?php echo e($owned_irrigation_machine_rs->owned_irrigation_machine_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       45
                    </td>
                    <td>
                        Owned Irrigation Machine Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ownedIrrigationMachineRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="owned_irrigation_machine_remarks_<?php echo e(isset($ownedIrrigationMachineRemarks->id) && $ownedIrrigationMachineRemarks->id ? $ownedIrrigationMachineRemarks->id : ''); ?>_<?php echo e(isset($ownedIrrigationMachineRemarks->farmerId) && $ownedIrrigationMachineRemarks->farmerId ? $ownedIrrigationMachineRemarks->farmerId : ''); ?>" value="<?php echo e($ownedIrrigationMachineRemarks->owned_irrigation_machine_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                       46
                    </td>
                    <td>
                        Source of Seed / Plantlets
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="seed_type_<?php echo e(isset($seedType->id) && $seedType->id ? $seedType->id : ''); ?>_<?php echo e(isset($seedType->farmerId) && $seedType->farmerId ? $seedType->farmerId : ''); ?>" value="<?php echo e($seedType->seed_type); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>47</td>
                    <td>Seed Standard</td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seed_standard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="$seed_standard_<?php echo e(isset($seed_standard->id) && $seed_standard->id ? $seed_standard->id : ''); ?>_<?php echo e(isset($seed_standard->farmerId) && $seed_standard->farmerId ? $seed_standard->farmerId : ''); ?>" value="<?php echo e($seed_standard->seed_standard); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>48</td>
                    <td>Seed Standard Remark</td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seed_standard_remark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="$seed_standard_remark_<?php echo e(isset($seed_standard_remark->id) && $seed_standard_remark->id ? $seed_standard_remark->id : ''); ?>_<?php echo e(isset($seed_standard_remark->farmerId) && $seed_standard_remark->farmerId ? $seed_standard_remark->farmerId : ''); ?>" value="<?php echo e($seed_standard_remark->seed_standard_remark); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                <tr>
                    <td>
                       49
                    </td>
                    <td>
                        Seed Variety
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedVariety): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="seed_variety_<?php echo e(isset($seedVariety->id) && $seedVariety->id ? $seedVariety->id : ''); ?>_<?php echo e(isset($seedVariety->farmerId) && $seedVariety->farmerId ? $seedVariety->farmerId : ''); ?>" value="<?php echo e($seedVariety->seed_variety); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       48
                    </td>
                    <td>
                        Seed Qty Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="seed_qty_unit_<?php echo e(isset($seedQtyUnit->id) && $seedQtyUnit->id ? $seedQtyUnit->id : ''); ?>_<?php echo e(isset($seedQtyUnit->farmerId) && $seedQtyUnit->farmerId ? $seedQtyUnit->farmerId : ''); ?>" value="<?php echo e($seedQtyUnit->seed_qty_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        49
                    </td>
                    <td>
                        Seed / Plantlets Quanity
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seed_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="seed_qty_<?php echo e(isset($seed_qty->id) && $seed_qty->id ? $seed_qty->id : ''); ?>_<?php echo e(isset($seed_qty->farmerId) && $seed_qty->farmerId ? $seed_qty->farmerId : ''); ?>" value="<?php echo e($seed_qty->seed_qty); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       50
                    </td>
                    <td>
                        Seed Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="seed_unit_price_<?php echo e(isset($seedUnitPrice->id) && $seedUnitPrice->id ? $seedUnitPrice->id : ''); ?>_<?php echo e(isset($seedUnitPrice->farmerId) && $seedUnitPrice->farmerId ? $seedUnitPrice->farmerId : ''); ?>" value="<?php echo e($seedUnitPrice->seed_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        51
                    </td>
                    <td>
                        Seed Value (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seed_value_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="seed_value_rs_<?php echo e(isset($seed_value_rs->id) && $seed_value_rs->id ? $seed_value_rs->id : ''); ?>_<?php echo e(isset($seed_value_rs->farmerId) && $seed_value_rs->farmerId ? $seed_value_rs->farmerId : ''); ?>" value="<?php echo e($seed_value_rs->seed_value_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        52
                    </td>
                    <td>
                        Seed Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seedRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="seed_remarks_<?php echo e(isset($seedRemarks->id) && $seedRemarks->id ? $seedRemarks->id : ''); ?>_<?php echo e(isset($seedRemarks->farmerId) && $seedRemarks->farmerId ? $seedRemarks->farmerId : ''); ?>" value="<?php echo e($seedRemarks->seed_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        53
                    </td>
                    <td>
                        Fertiliser (N) Qty Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserNQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_n_qty_unit_<?php echo e(isset($fertiliserNQtyUnit->id) && $fertiliserNQtyUnit->id ? $fertiliserNQtyUnit->id : ''); ?>_<?php echo e(isset($fertiliserNQtyUnit->farmerId) && $fertiliserNQtyUnit->farmerId ? $fertiliserNQtyUnit->farmerId : ''); ?>" value="<?php echo e($fertiliserNQtyUnit->fertiliser_n_qty_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        54
                    </td>
                    <td>
                        Fertiliser (N) Quantity
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_n_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_n_qty_<?php echo e(isset($fertiliser_n_qty->id) && $fertiliser_n_qty->id ? $fertiliser_n_qty->id : ''); ?>_<?php echo e(isset($fertiliser_n_qty->farmerId) && $fertiliser_n_qty->farmerId ? $fertiliser_n_qty->farmerId : ''); ?>" value="<?php echo e($fertiliser_n_qty->fertiliser_n_qty); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        55
                    </td>
                    <td>
                        Fertiliser (N) Unit Price
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserNUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_n_unit_price_<?php echo e(isset($fertiliserNUnitPrice->id) && $fertiliserNUnitPrice->id ? $fertiliserNUnitPrice->id : ''); ?>_<?php echo e(isset($fertiliserNUnitPrice->farmerId) && $fertiliserNUnitPrice->farmerId ? $fertiliserNUnitPrice->farmerId : ''); ?>" value="<?php echo e($fertiliserNUnitPrice->fertiliser_n_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        56
                    </td>
                    <td>
                    Fertiliser (N) (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_n_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_n_rs_<?php echo e(isset($fertiliser_n_rs->id) && $fertiliser_n_rs->id ? $fertiliser_n_rs->id : ''); ?>_<?php echo e(isset($fertiliser_n_rs->farmerId) && $fertiliser_n_rs->farmerId ? $fertiliser_n_rs->farmerId : ''); ?>" value="<?php echo e($fertiliser_n_rs->fertiliser_n_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                
                <tr>
                    <td>
                       57
                    </td>
                    <td>
                        Fertiliser (N) Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserNRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="fertiliser_n_remarks_<?php echo e(isset($fertiliserNRemarks->id) && $fertiliserNRemarks->id ? $fertiliserNRemarks->id : ''); ?>_<?php echo e(isset($fertiliserNRemarks->farmerId) && $fertiliserNRemarks->farmerId ? $fertiliserNRemarks->farmerId : ''); ?>" value="<?php echo e($fertiliserNRemarks->fertiliser_n_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       58
                    </td>
                    <td>
                        Fertiliser (P) Qty Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserPQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_p_qty_unit_<?php echo e(isset($fertiliserPQtyUnit->id) && $fertiliserPQtyUnit->id ? $fertiliserPQtyUnit->id : ''); ?>_<?php echo e(isset($fertiliserPQtyUnit->farmerId) && $fertiliserPQtyUnit->farmerId ? $fertiliserPQtyUnit->farmerId : ''); ?>" value="<?php echo e($fertiliserPQtyUnit->fertiliser_p_qty_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        59
                    </td>
                    <td>
                        Fertiliser (P) Quanity
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_p_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_p_qty_<?php echo e(isset($fertiliser_p_qty->id) && $fertiliser_p_qty->id ? $fertiliser_p_qty->id : ''); ?>_<?php echo e(isset($fertiliser_p_qty->farmerId) && $fertiliser_p_qty->farmerId ? $fertiliser_p_qty->farmerId : ''); ?>" value="<?php echo e($fertiliser_p_qty->fertiliser_p_qty); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       60
                    </td>
                    <td>
                        Fertiliser (P) Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserPUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_p_unit_price_<?php echo e(isset($fertiliserPUnitPrice->id) && $fertiliserPUnitPrice->id ? $fertiliserPUnitPrice->id : ''); ?>_<?php echo e(isset($fertiliserPUnitPrice->farmerId) && $fertiliserPUnitPrice->farmerId ? $fertiliserPUnitPrice->farmerId : ''); ?>" value="<?php echo e($fertiliserPUnitPrice->fertiliser_p_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        61
                    </td>
                    <td>
                    Fertiliser (P) (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_p_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_p_rs_<?php echo e(isset($fertiliser_p_rs->id) && $fertiliser_p_rs->id ? $fertiliser_p_rs->id : ''); ?>_<?php echo e(isset($fertiliser_p_rs->farmerId) && $fertiliser_p_rs->farmerId ? $fertiliser_p_rs->farmerId : ''); ?>" value="<?php echo e($fertiliser_p_rs->fertiliser_p_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       62
                    </td>
                    <td>
                        Fertiliser (P) Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserPRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_p_remarks_<?php echo e(isset($fertiliserPRemarks->id) && $fertiliserPRemarks->id ? $fertiliserPRemarks->id : ''); ?>_<?php echo e(isset($fertiliserPRemarks->farmerId) && $fertiliserPRemarks->farmerId ? $fertiliserPRemarks->farmerId : ''); ?>" value="<?php echo e($fertiliserPRemarks->fertiliser_p_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       63
                    </td>
                    <td>
                        Fertiliser (K) Qty Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserKQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_k_qty_unit_<?php echo e(isset($fertiliserKQtyUnit->id) && $fertiliserKQtyUnit->id ? $fertiliserKQtyUnit->id : ''); ?>_<?php echo e(isset($fertiliserKQtyUnit->farmerId) && $fertiliserKQtyUnit->farmerId ? $fertiliserKQtyUnit->farmerId : ''); ?>" value="<?php echo e($fertiliserKQtyUnit->fertiliser_k_qty_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        64
                    </td>
                    <td>
                        Fertiliser (K) Quanity
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_k_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_k_qty_<?php echo e(isset($fertiliser_k_qty->id) && $fertiliser_k_qty->id ? $fertiliser_k_qty->id : ''); ?>_<?php echo e(isset($fertiliser_k_qty->farmerId) && $fertiliser_k_qty->farmerId ? $fertiliser_k_qty->farmerId : ''); ?>" value="<?php echo e($fertiliser_k_qty->fertiliser_k_qty); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       65
                    </td>
                    <td>
                        Fertiliser (K) Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserKUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_k_unit_price_<?php echo e(isset($fertiliserKUnitPrice->id) && $fertiliserKUnitPrice->id ? $fertiliserKUnitPrice->id : ''); ?>_<?php echo e(isset($fertiliserKUnitPrice->farmerId) && $fertiliserKUnitPrice->farmerId ? $fertiliserKUnitPrice->farmerId : ''); ?>" value="<?php echo e($fertiliserKUnitPrice->fertiliser_k_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        66
                    </td>
                    <td>
                    Fertiliser (K) (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliser_k_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_k_rs_<?php echo e(isset($fertiliser_k_rs->id) && $fertiliser_k_rs->id ? $fertiliser_k_rs->id : ''); ?>_<?php echo e(isset($fertiliser_k_rs->farmerId) && $fertiliser_k_rs->farmerId ? $fertiliser_k_rs->farmerId : ''); ?>" value="<?php echo e($fertiliser_k_rs->fertiliser_k_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       67
                    </td>
                    <td>
                        Fertiliser (K) Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fertiliserKRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="fertiliser_k_remarks_<?php echo e(isset($fertiliserKRemarks->id) && $fertiliserKRemarks->id ? $fertiliserKRemarks->id : ''); ?>_<?php echo e(isset($fertiliserKRemarks->farmerId) && $fertiliserKRemarks->farmerId ? $fertiliserKRemarks->farmerId : ''); ?>" value="<?php echo e($fertiliserKRemarks->fertiliser_k_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <!--other Fertiliser Unit-->
                
                <?php $__empty_1 = true; $__currentLoopData = $otherferArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                
                
                <tr>
                    <td>67</td>
                    <td>Other Fertiliser Name</td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $other_fertiliser_name->other_fertiliser_name !== null ? json_decode($other_fertiliser_name->other_fertiliser_name, true) : [];
                        ?>
                       <input type="text" name="other_fertiliser_name_<?php echo e(isset($other_fertiliser_name->id) && $other_fertiliser_name->id ? $other_fertiliser_name->id : ''); ?>_<?php echo e(isset($other_fertiliser_name->farmerId) && $other_fertiliser_name->farmerId ? $other_fertiliser_name->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                <tr>
                    <td>
                       68
                    </td>
                    <td>
                        Other Fertiliser Qty Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                        $decoded = $otherFertiliserQtyUnit->other_fertiliser_qty_unit !== null ? json_decode($otherFertiliserQtyUnit->other_fertiliser_qty_unit, true) : [];
                        ?>
                       <input type="text" name="other_fertiliser_qty_unit_<?php echo e(isset($otherFertiliserQtyUnit->id) && $otherFertiliserQtyUnit->id ? $otherFertiliserQtyUnit->id : ''); ?>_<?php echo e(isset($otherFertiliserQtyUnit->farmerId) && $otherFertiliserQtyUnit->farmerId ? $otherFertiliserQtyUnit->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        69
                    </td>
                    <td>
                        Other Fertiliser Qty
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                         $decoded = $other_fertiliser_qty->other_fertiliser_qty !== null ? json_decode($other_fertiliser_qty->other_fertiliser_qty, true) : [];
                        ?>
                       <input type="text" name="other_fertiliser_qty_<?php echo e(isset($other_fertiliser_qty->id) && $other_fertiliser_qty->id ? $other_fertiliser_qty->id : ''); ?>_<?php echo e(isset($other_fertiliser_qty->farmerId) && $other_fertiliser_qty->farmerId ? $other_fertiliser_qty->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       70
                    </td>
                    <td>
                        Other Fertiliser Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $otherFertiliserUnitPrice->other_fertiliser_unit_price !== null ? json_decode($otherFertiliserUnitPrice->other_fertiliser_unit_price, true) : [];
                        ?>
                
                       <input type="text" name="other_fertiliser_unit_price_<?php echo e(isset($otherFertiliserUnitPrice->id) && $otherFertiliserUnitPrice->id ? $otherFertiliserUnitPrice->id : ''); ?>_<?php echo e(isset($otherFertiliserUnitPrice->farmerId) && $otherFertiliserUnitPrice->farmerId ? $otherFertiliserUnitPrice->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        71
                    </td>
                    <td>
                    Other Fertiliser (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                         <?php
                            $decoded = $other_fertiliser_rs->other_fertiliser_rs !== null ? json_decode($other_fertiliser_rs->other_fertiliser_rs, true) : [];
                        ?>
                       
                       <input type="text" name="other_fertiliser_rs_<?php echo e(isset($other_fertiliser_rs->id) && $other_fertiliser_rs->id ? $other_fertiliser_rs->id : ''); ?>_<?php echo e(isset($other_fertiliser_rs->farmerId) && $other_fertiliser_rs->farmerId ? $other_fertiliser_rs->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       72
                    </td>
                    <td>
                        Other Fertiliser Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $otherFertiliserRemarks->other_fertiliser_remarks !== null 
                                ? json_decode($otherFertiliserRemarks->other_fertiliser_remarks, true) 
                                : [];
                        ?>
                       <input type="text" name="other_fertiliser_remarks_<?php echo e(isset($otherFertiliserRemarks->id) && $otherFertiliserRemarks->id ? $otherFertiliserRemarks->id : ''); ?>_<?php echo e(isset($otherFertiliserRemarks->farmerId) && $otherFertiliserRemarks->farmerId ? $otherFertiliserRemarks->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
             
             <tr>
                 
                <tr>
                    <td>67</td>
                    <td>Other Fertiliser Name</td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $other_fertiliser_name->other_fertiliser_name !== null ? json_decode($other_fertiliser_name->other_fertiliser_name, true) : [];
                        ?>
                       <input type="text" name="other_fertiliser_name_<?php echo e(isset($other_fertiliser_name->id) && $other_fertiliser_name->id ? $other_fertiliser_name->id : ''); ?>_<?php echo e(isset($other_fertiliser_name->farmerId) && $other_fertiliser_name->farmerId ? $other_fertiliser_name->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                 
                 
                    <td>
                       68
                    </td>
                    <td>
                        Other Fertiliser Qty Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                        $decoded = $otherFertiliserQtyUnit->other_fertiliser_qty_unit !== null ? json_decode($otherFertiliserQtyUnit->other_fertiliser_qty_unit, true) : [];
                        ?>
                       <input type="text" name="other_fertiliser_qty_unit_<?php echo e(isset($otherFertiliserQtyUnit->id) && $otherFertiliserQtyUnit->id ? $otherFertiliserQtyUnit->id : ''); ?>_<?php echo e(isset($otherFertiliserQtyUnit->farmerId) && $otherFertiliserQtyUnit->farmerId ? $otherFertiliserQtyUnit->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        69
                    </td>
                    <td>
                        Other Fertiliser Qty
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                         $decoded = $other_fertiliser_qty->other_fertiliser_qty !== null ? json_decode($other_fertiliser_qty->other_fertiliser_qty, true) : [];
                        ?>
                       <input type="text" name="other_fertiliser_qty_<?php echo e(isset($other_fertiliser_qty->id) && $other_fertiliser_qty->id ? $other_fertiliser_qty->id : ''); ?>_<?php echo e(isset($other_fertiliser_qty->farmerId) && $other_fertiliser_qty->farmerId ? $other_fertiliser_qty->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       70
                    </td>
                    <td>
                        Other Fertiliser Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $otherFertiliserUnitPrice->other_fertiliser_unit_price !== null ? json_decode($otherFertiliserUnitPrice->other_fertiliser_unit_price, true) : [];
                        ?>
                
                       <input type="text" name="other_fertiliser_unit_price_<?php echo e(isset($otherFertiliserUnitPrice->id) && $otherFertiliserUnitPrice->id ? $otherFertiliserUnitPrice->id : ''); ?>_<?php echo e(isset($otherFertiliserUnitPrice->farmerId) && $otherFertiliserUnitPrice->farmerId ? $otherFertiliserUnitPrice->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        71
                    </td>
                    <td>
                    Other Fertiliser (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fertiliser_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                         <?php
                            $decoded = $other_fertiliser_rs->other_fertiliser_rs !== null ? json_decode($other_fertiliser_rs->other_fertiliser_rs, true) : [];
                        ?>
                       
                       <input type="text" name="other_fertiliser_rs_<?php echo e(isset($other_fertiliser_rs->id) && $other_fertiliser_rs->id ? $other_fertiliser_rs->id : ''); ?>_<?php echo e(isset($other_fertiliser_rs->farmerId) && $other_fertiliser_rs->farmerId ? $other_fertiliser_rs->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       72
                    </td>
                    <td>
                        Other Fertiliser Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherFertiliserRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $otherFertiliserRemarks->other_fertiliser_remarks !== null 
                                ? json_decode($otherFertiliserRemarks->other_fertiliser_remarks, true) 
                                : [];
                        ?>
                       <input type="text" name="other_fertiliser_remarks_<?php echo e(isset($otherFertiliserRemarks->id) && $otherFertiliserRemarks->id ? $otherFertiliserRemarks->id : ''); ?>_<?php echo e(isset($otherFertiliserRemarks->farmerId) && $otherFertiliserRemarks->farmerId ? $otherFertiliserRemarks->farmerId : ''); ?>" value="<?php echo e($decoded[$t] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
             
             <?php endif; ?>
                <!--other Fertiliser Unit-->
                
                <tr>
                    <td>
                       73
                    </td>
                    <td>
                        DAP Qty Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dapQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="dap_qty_unit_<?php echo e(isset($dapQtyUnit->id) && $dapQtyUnit->id ? $dapQtyUnit->id : ''); ?>_<?php echo e(isset($dapQtyUnit->farmerId) && $dapQtyUnit->farmerId ? $dapQtyUnit->farmerId : ''); ?>" value="<?php echo e($dapQtyUnit->dap_qty_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       74
                    </td>
                    <td>
                        DAP Qty
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dapQty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="dap_qty_<?php echo e(isset($dapQty->id) && $dapQty->id ? $dapQty->id : ''); ?>_<?php echo e(isset($dapQty->farmerId) && $dapQty->farmerId ? $dapQty->farmerId : ''); ?>" value="<?php echo e($dapQty->dap_qty); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       75
                    </td>
                    <td>
                        DAP Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dapUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                      
                       <input type="text" name="dap_unit_price_<?php echo e(isset($dapUnitPrice->id) && $dapUnitPrice->id ? $dapUnitPrice->id : ''); ?>_<?php echo e(isset($dapUnitPrice->farmerId) && $dapUnitPrice->farmerId ? $dapUnitPrice->farmerId : ''); ?>" value="<?php echo e($dapUnitPrice->dap_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                 <tr>
                    <td>
                        76
                    </td>
                    <td>
                        DAP (Rs)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dap_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="dap_rs_<?php echo e(isset($dap_rs->id) && $dap_rs->id ? $dap_rs->id : ''); ?>_<?php echo e(isset($dap_rs->farmerId) && $dap_rs->farmerId ? $dap_rs->farmerId : ''); ?>" value="<?php echo e($dap_rs->dap_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       77
                    </td>
                    <td>
                        DAP Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dapRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="dap_remarks_<?php echo e(isset($dapRemarks->id) && $dapRemarks->id ? $dapRemarks->id : ''); ?>_<?php echo e(isset($dapRemarks->farmerId) && $dapRemarks->farmerId ? $dapRemarks->farmerId : ''); ?>" value="<?php echo e($dapRemarks->dap_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       78
                    </td>
                    <td>
                        NPK Qty Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npkQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="npk_qty_unit_<?php echo e(isset($npkQtyUnit->id) && $npkQtyUnit->id ? $npkQtyUnit->id : ''); ?>_<?php echo e(isset($npkQtyUnit->farmerId) && $npkQtyUnit->farmerId ? $npkQtyUnit->farmerId : ''); ?>" value="<?php echo e($npkQtyUnit->npk_qty_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                <tr>
                    <td>
                       79
                    </td>
                    <td>
                        NPK Qty
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npkQty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="npk_qty_<?php echo e(isset($npkQty->id) && $npkQty->id ? $npkQty->id : ''); ?>_<?php echo e(isset($npkQty->farmerId) && $npkQty->farmerId ? $npkQty->farmerId : ''); ?>" value="<?php echo e($npkQty->npk_qty); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        80
                    </td>
                    <td>
                        NPK Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npkUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="npk_unit_price_<?php echo e(isset($npkUnitPrice->id) && $npkUnitPrice->id ? $npkUnitPrice->id : ''); ?>_<?php echo e(isset($npkUnitPrice->farmerId) && $npkUnitPrice->farmerId ? $npkUnitPrice->farmerId : ''); ?>" value="<?php echo e($npkUnitPrice->npk_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        81
                    </td>
                    <td>
                        NPK (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npk_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="npk_rs_<?php echo e(isset($npk_rs->id) && $npk_rs->id ? $npk_rs->id : ''); ?>_<?php echo e(isset($npk_rs->farmerId) && $npk_rs->farmerId ? $npk_rs->farmerId : ''); ?>" value="<?php echo e($npk_rs->npk_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                       82
                    </td>
                    <td>
                        NPK Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $npkRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="npk_remarks_<?php echo e(isset($npkRemarks->id) && $npkRemarks->id ? $npkRemarks->id : ''); ?>_<?php echo e(isset($npkRemarks->farmerId) && $npkRemarks->farmerId ? $npkRemarks->farmerId : ''); ?>" value="<?php echo e($npkRemarks->npk_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                       83
                    </td>
                    <td>
                        Manure Qty Unit
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manureQtyUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="manure_qty_unit_<?php echo e(isset($manureQtyUnit->id) && $manureQtyUnit->id ? $manureQtyUnit->id : ''); ?>_<?php echo e(isset($manureQtyUnit->farmerId) && $manureQtyUnit->farmerId ? $manureQtyUnit->farmerId : ''); ?>" value="<?php echo e($manureQtyUnit->manure_qty_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       84
                    </td>
                    <td>
                        Manure Qty
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manureQty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="manure_qty_<?php echo e(isset($manureQty->id) && $manureQty->id ? $manureQty->id : ''); ?>_<?php echo e(isset($manureQty->farmerId) && $manureQty->farmerId ? $manureQty->farmerId : ''); ?>" value="<?php echo e($manureQty->manure_qty); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
              
                
                
                <tr>
                    <td>
                        85
                    </td>
                    <td>
                        Manure Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manureUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" 
                        name="manure_unit_price_<?php echo e(isset($manureUnitPrice->id) && $manureUnitPrice->id ? $manureUnitPrice->id : ''); ?>_<?php echo e(isset($manureUnitPrice->farmerId) && $manureUnitPrice->farmerId ? $manureUnitPrice->farmerId : ''); ?>" value="<?php echo e($manureUnitPrice->manure_unit_price); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        86
                    </td>
                    <td>
                        Manure (Rs.) FYM
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manure_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="manure_rs_<?php echo e(isset($manure_rs->id) && $manure_rs->id ? $manure_rs->id : ''); ?>_<?php echo e(isset($manure_rs->farmerId) && $manure_rs->farmerId ? $manure_rs->farmerId : ''); ?>" value="<?php echo e($manure_rs->manure_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       87
                    </td>
                    <td>
                        Manure Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manureRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="manure_remarks_<?php echo e(isset($manureRemarks->id) && $manureRemarks->id ? $manureRemarks->id : ''); ?>_<?php echo e(isset($manureRemarks->farmerId) && $manureRemarks->farmerId ? $manureRemarks->farmerId : ''); ?>" value="<?php echo e($manureRemarks->manure_remarks); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <!--Insecticide-->  
                
               <?php $__empty_1 = true; $__currentLoopData = $unitArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?> 
                <tr>
                    <td>
                       88
                    </td>
                    <td>
                        Insecticide Unit
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                          $decoded = $insecticideUnit->insecticide_unit !== null ? json_decode($insecticideUnit->insecticide_unit, true) : [];
                        ?>
                        <input type="text" name="insecticide_unit_<?php echo e(isset($insecticideUnit->id) && $insecticideUnit->id ? $insecticideUnit->id : ''); ?>_<?php echo e(isset($insecticideUnit->farmerId) && $insecticideUnit->farmerId ? $insecticideUnit->farmerId : ''); ?>" value="<?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       89
                    </td>
                    <td>
                        Plant Protection Name
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insticideName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $insticideName->insticide_name !== null ? json_decode($insticideName->insticide_name, true) : [];
                        ?>
                       <input type="text" name="insticide_name_<?php echo e(isset($insticideName->id) && $insticideName->id ? $insticideName->id : ''); ?>_<?php echo e(isset($insticideName->farmerId) && $insticideName->farmerId ? $insticideName->farmerId : ''); ?>" value="<?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                <tr>
                    <td>
                        90
                    </td>
                    <td>
                        Plant Protection Qty
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideQty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $insecticideQty->insecticide_qty !== null ? json_decode($insecticideQty->insecticide_qty, true) : [];
                        ?>
                       <input type="text" name="insecticide_qty_<?php echo e(isset($insecticideQty->id) && $insecticideQty->id ? $insecticideQty->id : ''); ?>_<?php echo e(isset($insecticideQty->farmerId) && $insecticideQty->farmerId ? $insecticideQty->farmerId : ''); ?>" value=" <?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
        
                <tr>
                    <td>
                       91
                    </td>
                    <td>
                        Plant Protection Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $insecticideUnitPrice->insecticide_unit_price !== null ? json_decode($insecticideUnitPrice->insecticide_unit_price, true) : [];
                        ?>
                       <input type="text" name="insecticide_unit_price_<?php echo e(isset($insecticideUnitPrice->id) && $insecticideUnitPrice->id ? $insecticideUnitPrice->id : ''); ?>_{isset($insecticideUnitPrice->farmerId) && $insecticideUnitPrice->farmerId ? $insecticideUnitPrice->farmerId : ''}}" value=" <?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        92
                    </td>
                    <td>
                        Plant Protection (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticide_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $insecticide_rs->insecticide_rs !== null ? json_decode($insecticide_rs->insecticide_rs, true) : [];
                        ?>
                       <input type="text" name="insecticide_rs_<?php echo e(isset($insecticide_rs->id) && $insecticide_rs->id ? $insecticide_rs->id : ''); ?>_<?php echo e(isset($insecticide_rs->farmerId) && $insecticide_rs->farmerId ? $insecticide_rs->farmerId : ''); ?>" value="<?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        93
                    </td>
                    <td>
                        Plant Protection Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $insecticideRemarks->insecticide_remarks !== null ? json_decode($insecticideRemarks->insecticide_remarks, true) : [];
                        ?>
                        <input type="text" name="insecticide_remarks_<?php echo e(isset($insecticideRemarks->id) && $insecticideRemarks->id ? $insecticideRemarks->id : ''); ?>_<?php echo e(isset($insecticideRemarks->farmerId) && $insecticideRemarks->farmerId ? $insecticideRemarks->farmerId : ''); ?>" value="<?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                
                <tr>
                    <td>
                       88
                    </td>
                    <td>
                        Insecticide Unit
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                          $decoded = $insecticideUnit->insecticide_unit !== null ? json_decode($insecticideUnit->insecticide_unit, true) : [];
                        ?>
                        <input type="text" name="insecticide_unit_<?php echo e(isset($insecticideUnit->id) && $insecticideUnit->id ? $insecticideUnit->id : ''); ?>_<?php echo e(isset($insecticideUnit->farmerId) && $insecticideUnit->farmerId ? $insecticideUnit->farmerId : ''); ?>" value="<?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       89
                    </td>
                    <td>
                        Plant Protection Name
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insticideName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $insticideName->insticide_name !== null ? json_decode($insticideName->insticide_name, true) : [];
                        ?>
                       <input type="text" name="insticide_name_<?php echo e(isset($insticideName->id) && $insticideName->id ? $insticideName->id : ''); ?>_<?php echo e(isset($insticideName->farmerId) && $insticideName->farmerId ? $insticideName->farmerId : ''); ?>" value="<?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                <tr>
                    <td>
                        90
                    </td>
                    <td>
                        Plant Protection Qty
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideQty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $insecticideQty->insecticide_qty !== null ? json_decode($insecticideQty->insecticide_qty, true) : [];
                        ?>
                       <input type="text" name="insecticide_qty_<?php echo e(isset($insecticideQty->id) && $insecticideQty->id ? $insecticideQty->id : ''); ?>_<?php echo e(isset($insecticideQty->farmerId) && $insecticideQty->farmerId ? $insecticideQty->farmerId : ''); ?>" value=" <?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
        
                <tr>
                    <td>
                       91
                    </td>
                    <td>
                        Plant Protection Unit Price
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideUnitPrice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $insecticideUnitPrice->insecticide_unit_price !== null ? json_decode($insecticideUnitPrice->insecticide_unit_price, true) : [];
                        ?>
                       <input type="text" name="insecticide_unit_price_<?php echo e(isset($insecticideUnitPrice->id) && $insecticideUnitPrice->id ? $insecticideUnitPrice->id : ''); ?>_{isset($insecticideUnitPrice->farmerId) && $insecticideUnitPrice->farmerId ? $insecticideUnitPrice->farmerId : ''}}" value=" <?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        92
                    </td>
                    <td>
                        Plant Protection (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticide_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $insecticide_rs->insecticide_rs !== null ? json_decode($insecticide_rs->insecticide_rs, true) : [];
                        ?>
                       <input type="text" name="insecticide_rs_<?php echo e(isset($insecticide_rs->id) && $insecticide_rs->id ? $insecticide_rs->id : ''); ?>_<?php echo e(isset($insecticide_rs->farmerId) && $insecticide_rs->farmerId ? $insecticide_rs->farmerId : ''); ?>" value="<?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        93
                    </td>
                    <td>
                        Plant Protection Remarks
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insecticideRemarks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php
                            $decoded = $insecticideRemarks->insecticide_remarks !== null ? json_decode($insecticideRemarks->insecticide_remarks, true) : [];
                        ?>
                        <input type="text" name="insecticide_remarks_<?php echo e(isset($insecticideRemarks->id) && $insecticideRemarks->id ? $insecticideRemarks->id : ''); ?>_<?php echo e(isset($insecticideRemarks->farmerId) && $insecticideRemarks->farmerId ? $insecticideRemarks->farmerId : ''); ?>" value="<?php echo e($decoded[$k] ?? null); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <?php endif; ?>
                
                <!--Insecticide-->
                
               <tr>
                    <td>
                       94
                    </td>
                    <td>
                        Canal / other Irrigation Charges (Rs)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $canalOtherCharges): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="canal_other_charges_<?php echo e(isset($canalOtherCharges->id) && $canalOtherCharges->id ? $canalOtherCharges->id : ''); ?>_<?php echo e(isset($canalOtherCharges->farmerId) && $canalOtherCharges->farmerId ? $canalOtherCharges->farmerId : ''); ?>" value="<?php echo e($canalOtherCharges->canal_other_charges); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        95
                    </td>
                    <td>
                    Crop Insurance (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crop_insurance_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="crop_insurance_rs_<?php echo e(isset($crop_insurance_rs->id) && $crop_insurance_rs->id ? $crop_insurance_rs->id : ''); ?>_<?php echo e(isset($crop_insurance_rs->farmerId) && $crop_insurance_rs->farmerId ? $crop_insurance_rs->farmerId : ''); ?>" value="<?php echo e($crop_insurance_rs->crop_insurance_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                 <tr>
                    <td>
                        96
                    </td>
                    <td>
                    Miscelaneous Cost (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $miscelaneous_cost_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="miscelaneous_cost_rs_<?php echo e(isset($miscelaneous_cost_rs->id) && $miscelaneous_cost_rs->id ? $miscelaneous_cost_rs->id : ''); ?>_{isset($miscelaneous_cost_rs->farmerId) && $miscelaneous_cost_rs->farmerId ? $miscelaneous_cost_rs->farmerId : ''}}" value="<?php echo e($miscelaneous_cost_rs->miscelaneous_cost_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                 <tr>
                    <td>
                        97
                    </td>
                    <td>
                        Land Revenue (Rs.) LAGAN
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $land_revenue_rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="land_revenue_rs_<?php echo e(isset($land_revenue_rs->id) && $land_revenue_rs->id ? $land_revenue_rs->id : ''); ?>_<?php echo e(isset($land_revenue_rs->farmerId) && $land_revenue_rs->farmerId ? $land_revenue_rs->farmerId : ''); ?>" value="<?php echo e($land_revenue_rs->land_revenue_rs); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                 <tr>
                    <td>
                        98
                    </td>
                    <td>
                        Rent Paid for Leased in Land (Rs.)
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rent_paid_leased_land): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="rent_paid_leased_land_<?php echo e(isset($rent_paid_leased_land->id) && $rent_paid_leased_land->id ? $rent_paid_leased_land->id : ''); ?>_<?php echo e(isset($rent_paid_leased_land->farmerId) && $rent_paid_leased_land->farmerId ? $rent_paid_leased_land->farmerId : ''); ?>" value="<?php echo e($rent_paid_leased_land->rent_paid_leased_land); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                        99
                    </td>
                    <td>
                        Interest on working capital rate(%) KCC
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interest_kcc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="interest_kcc_<?php echo e(isset($interest_kcc->id) && $interest_kcc->id ? $interest_kcc->id : ''); ?>_<?php echo e(isset($interest_kcc->farmerId) && $interest_kcc->farmerId ? $interest_kcc->farmerId : ''); ?>" value="<?php echo e($interest_kcc->interest_kcc); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                        100
                    </td>
                    <td>
                        Depericiation of Farm Assets
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $depericiation_farm_assets): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="depericiation_farm_assets_<?php echo e(isset($depericiation_farm_assets->id) && $depericiation_farm_assets->id ? $depericiation_farm_assets->id : ''); ?>_<?php echo e(isset($depericiation_farm_assets->farmerId) && $depericiation_farm_assets->farmerId ? $depericiation_farm_assets->farmerId : ''); ?>" value="<?php echo e($depericiation_farm_assets->depericiation_farm_assets); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
    <td>
        101
    </td>
    <td>
        Interest on Capital Assests
    </td>
    
    
    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $int_cap): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
                <input type="text" name="int_cap" value="" />
            </td>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
</tr>
                
        <!--<tr>-->
        <!--    <td>102</td>-->
        <!--    <td>Marketing Cost of Producers</td>-->
        <!--    <td></td>-->
        <!--</tr>-->
        
        <tr>
            <td>102</td>
            <td>Other Fixed Cost</td>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_fix_cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <td>
             <input type="text" name="other_fix_cost_<?php echo e(isset($other_fix_cost->id) && $other_fix_cost->id ? $other_fix_cost->id : ''); ?>_<?php echo e($other_fix_cost->farmerId ?? ''); ?>" value="<?php echo e($other_fix_cost->other_fix_cost == 'null' ? '' : $other_fix_cost->other_fix_cost); ?>">
            </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        
        
        
                
                <tr>
                    <td>
                       W
                    </td>
                    <th colspan="50">
                         Farm Output
                    </td>
                </tr>
                
                <tr>
                    <td>
                       1
                    </td>
                    <td>
                        Total Production Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $totalProductionUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       
                       <input type="text" disabled
                       name="total_production_<?php echo e(isset($totalProductionUnit->id) && $totalProductionUnit->id ? $totalProductionUnit->id : ''); ?>_<?php echo e($totalProductionUnit->farmerId ?? ''); ?>" value="<?php echo e($totalProductionUnit->total_production_unit == 'null' ? '' : $totalProductionUnit->total_production_unit); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                       2
                    </td>
                    <td>
                       Total Production Qty
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total_production): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="total_production_<?php echo e(isset($total_production->id) && $total_production->id ? $total_production->id : ''); ?>_<?php echo e($total_production->farmerId ?? ''); ?>" value="<?php echo e($total_production->total_production == 'null' ? '' : $total_production->total_production); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                       3
                    </td>
                    <td>
                        Sold Main Product Unit
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $soldMainProductUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="soldMainProductUnit_<?php echo e(isset($soldMainProductUnit->id) && $soldMainProductUnit->id ? $soldMainProductUnit->id : ''); ?>_<?php echo e($soldMainProductUnit->farmerId ?? ''); ?>" value="<?php echo e($soldMainProductUnit->sold_main_product_unit == 'null' ? '' : $soldMainProductUnit->sold_main_product_unit); ?>" />
                    </td>$
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                       4
                    </td>
                    <td> 
                      Sold Main Product Qty
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sold_main_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="sold_main_product_<?php echo e(isset($sold_main_product->id) && $sold_main_product->id ? $sold_main_product->id : ''); ?>_<?php echo e($sold_main_product->farmerId ?? ''); ?>" value="<?php echo e($sold_main_product->sold_main_product == 'null' ? '' : $sold_main_product->sold_main_product); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                       5
                    </td>
                    <td>
                        Total Value of Main Product Sold
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $totalMainProductSold): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       
                       <input type="text" name="totalMainProductSold_<?php echo e(isset($totalMainProductSold->id) && $totalMainProductSold->id ? $totalMainProductSold->id : ''); ?>_<?php echo e($totalMainProductSold->farmerId ?? ''); ?>" value="<?php echo e($totalMainProductSold->total_main_product_sold == 'null' ? '' : $totalMainProductSold->total_main_product_sold); ?>" />
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>
                       6
                    </td>
                    <td>
                     Selling Price of main products
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling_price_main_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="selling_price_main_product_<?php echo e(isset($selling_price_main_product->id) && $selling_price_main_product->id ? $selling_price_main_product->id : ''); ?>_<?php echo e($selling_price_main_product->farmerId ?? ''); ?>" value="<?php echo e($selling_price_main_product->selling_price_main_product == 'null' ? '' : $selling_price_main_product->selling_price_main_product); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>7</td>
                    <td>Minimum Price </td>
                     <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main_min_sell_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <td>
                      <input type="text" name="main_min_sell_price" value="<?php echo e($main_min_sell_price->main_min_sell_price == 'null' ? '' : $main_min_sell_price->main_min_sell_price); ?>" />
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>8</td>
                    <td>Maximum Price </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main_max_sell_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                      <input type="text" name="main_max_sell_price" value="<?php echo e($main_max_sell_price->main_max_sell_price == 'null' ? '' : $main_max_sell_price->main_max_sell_price); ?>" />
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                <tr>
                    <td>9</td>
                    <td>By-Product Name</td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $by_product_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                      <input type="text" name="by_product_name" value="<?php echo e($by_product_name->by_product_name == 'null' ? '' : $by_product_name->by_product_name); ?>" />
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                
                
                <tr>
                    <td>
                        10
                    </td>
                    <td>
                        By-Product Unit 
                    </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <input type="text" name="prod_unit" value="<?php echo e($prod_unit->by_product_unit == 'null' ? '' : $prod_unit->by_product_unit); ?>" />
                            </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                </tr>
                
                
                
                
                <tr>
                    <td>
                       11
                    </td>
                    <td>
                        By-Product Value
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $by_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="by_product_<?php echo e(isset($by_product->id) && $by_product->id ? $by_product->id : ''); ?>_<?php echo e($by_product->farmerId ?? ''); ?>" value="<?php echo e($by_product->by_product == 'null' ? '' : $by_product->by_product); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       12
                    </td>
                    <td>
                        Selling  Price of By-products
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selling_price_by_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" 
                        name="selling_price_by_product_<?php echo e(isset($selling_price_by_product->id) && $selling_price_by_product->id ? $selling_price_by_product->id : ''); ?>_<?php echo e($selling_price_by_product->farmerId ?? ''); ?>" value="<?php echo e($selling_price_by_product->selling_price_by_product == 'null' ? '' : $selling_price_by_product->selling_price_by_product); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>13</td>
                    <td>Minimum Price </td>
                     <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $by_min_sell_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <td>
                      <input type="text" name="by_min_sell_price" value="<?php echo e($by_min_sell_price->by_min_sell_price == 'null' ? '' : $by_min_sell_price->by_min_sell_price); ?>" />
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                <tr>
                    <td>14</td>
                    <td>Maximum Price </td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $by_max_sell_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                      <input type="text" name="by_max_sell_price" value="<?php echo e($by_max_sell_price->by_max_sell_price == 'null' ? '' : $by_max_sell_price->by_max_sell_price); ?>" />
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                
                 <tr>
                    <td>
                        X
                    </td>
                    <th colspan="50">
                        Whom to sold
                    </th>
                </tr>
                
                
                <tr>
                    <td>
                       10
                    </td>
                    <td>
                        Village Trader
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $village_trader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="village_trader_<?php echo e(isset($village_trader->id) && $village_trader->id ? $village_trader->id : ''); ?>_<?php echo e($village_trader->farmerId ?? ''); ?>" value="<?php echo e($village_trader->village_trader == 'null' ? '' : $village_trader->village_trader); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                      11
                    </td>
                    <td>
                        Wholesaler
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wholesaler): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="wholesaler_<?php echo e(isset($wholesaler->id) && $wholesaler->id ? $wholesaler->id : ''); ?>_<?php echo e($wholesaler->farmerId ?? ''); ?>" value="<?php echo e($wholesaler->wholesaler == 'null' ? '' : $wholesaler->wholesaler); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       12
                    </td>
                    <td>
                        MANDI
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mandi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="mandi_<?php echo e(isset($mandi->id) && $mandi->id ? $mandi->id : ''); ?>_<?php echo e($mandi->farmerId ?? ''); ?>" value="<?php echo e($mandi->mandi == 'null' ? '' : $mandi->mandi); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       13
                    </td>
                    <td>
                        Processor
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $processor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="processor_<?php echo e(isset($processor->id) && $processor->id ? $processor->id : ''); ?>_<?php echo e($processor->farmerId ?? ''); ?>" value="<?php echo e($processor->processor == 'null' ? '' : $processor->processor); ?>">  
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       14
                    </td>
                    <td>
                        Retailer
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $retailer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="retailer_<?php echo e(isset($retailer->id) && $retailer->id ? $retailer->id : ''); ?>_<?php echo e($retailer->farmerId ?? ''); ?>" value="<?php echo e($retailer->retailer == 'null' ? '' : $retailer->retailer); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       15
                    </td>
                    <td>
                        Consumer
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $consumer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <input type="text" name="consumer_<?php echo e(isset($consumer->id) && $consumer->id ? $consumer->id : ''); ?>_<?php echo e($consumer->farmerId ?? ''); ?>" value="<?php echo e($consumer->consumer == 'null' ? '' : $consumer->consumer); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
                 <tr>
                    <td>
                       16
                    </td>
                    <td>
                        Company
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       <input type="text" name="company_<?php echo e(isset($company->id) && $company->id ? $company->id : ''); ?>_<?php echo e($company->farmerId ?? ''); ?>"
                       value="<?php echo e($company->company == 'null' ? '' : $company->company); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <td>
                       17
                    </td>
                    <td>
                        Commission Agent
                    </td>
                    
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commissionAgent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td>
                       
                       <input type="text" name="commissionAgent_<?php echo e(isset($commissionAgent->id) && $commissionAgent->id ? $commissionAgent->id : ''); ?>_<?php echo e($commissionAgent->farmerId ?? ''); ?>"
                       value="<?php echo e($commissionAgent->commission_agent == 'null' ? '' : $commissionAgent->commission_agent); ?>">
                    </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                
               <?php $__empty_1 = true; $__currentLoopData = $prother; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pk => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>18</td>
                    <td>Other</td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production_outputs_other): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            // Decode JSON, handling 'null' cases
                            $value = ($production_outputs_other->production_outputs_other === 'null') 
                                     ? [] 
                                     : json_decode($production_outputs_other->production_outputs_other, true);
                        ?>
                        <td>
                            <input type="text" name="production_outputs_other_<?php echo e($production_outputs_other->id ?? ''); ?>_<?php echo e($production_outputs_other->farmerId ?? ''); ?>"
                                   value="<?php echo e($value[$pk] ?? null); ?>">
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td>18</td>
                    <td>Other</td>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production_outputs_other): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            // Decode JSON, handling 'null' cases
                            $value = ($production_outputs_other->production_outputs_other === 'null') 
                                     ? [] 
                                     : json_decode($production_outputs_other->production_outputs_other, true);
                        ?>
                        <td>
                            <input type="text" name="production_outputs_other_<?php echo e($production_outputs_other->id ?? ''); ?>_<?php echo e($production_outputs_other->farmerId ?? ''); ?>"
                                   value="<?php echo e($value[0] ?? null); ?>">
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            <?php endif; ?>

         
        <tr>
            <td></td>
            <td></td>
             <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    
                    <td style="text-align:center;">
                        <button type="button" class="btn btn-primary fardwardbtn" data-farmer="<?php echo e($id->farmerId); ?>" data-id="<?php echo e($id->id); ?>">Submit Data</button>
                    </td>                 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>             
        </tr>
 
                
            </table>
    </form>
    </div>
 </div>
 <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
        function submitForm(id,farmerId) {
            
            $('#data_id').val(id); 
            $('#farmer_id').val(farmerId); 
            $('#dataForm').submit();
            
        }

        $('.btn-primary').on('click', function() {
            let id = $(this).data('id'); 
            let farmerId = $(this).data('farmer'); 
            $('#dataForm').find('table input[name]').each(function() {
                        if($(this).val()!=''){
                            // console.log($(this).val())
                             var inputString = $(this).attr('name');
                             const parts = inputString.split(/_(?=\d)/);
                             const other_infrastructure = parts[0];
                             if(other_infrastructure+'_'+id+'_'+farmerId!=inputString){
                                $(this).removeAttr('name')
                             }
                        }else{
                            $(this).removeAttr('name')
                        }
            })
            submitForm(id,farmerId); 
        });
    });
 </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-one-update.blade.php ENDPATH**/ ?>