<?php
    use App\Models\User;
    use Illuminate\Support\Facades\Auth;
    $userId = Auth::user()->id;
    $user = User::find($userId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $user->role_id)->get();
    $addUserPermission = $permissions->firstWhere('menu_id', 16);
?>


<?php $__env->startSection('title', 'Users List'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Users</h1>
            <div class="row">
                <?php if(isset($addUserPermission) && isset($addUserPermission) && $addUserPermission->created == 1 || $userId == 1): ?>
                <div class="col-md-12">
                    <a href="<?php echo e(route('users.create')); ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add New
                    </a>
                </div>
                <?php endif; ?>
                

            </div>

        </div>

        
        <?php echo $__env->make('common.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- DataTales Example -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">All Users</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="110%" cellspacing="0">
                        <thead>
                            <tr>
                                <th width="20%">Name</th>
                                <th width="15%">Email</th>
                                <th width="10%">Mobile</th>
                                <th width="10%">Role</th>
                                <th width="10%">Farmer Code</th>
                                <th width="10%">Password</th>
                                <th width="15%">FPO Name</th>
                                <th width="10%">Status</th>
                                <th width="10%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($user->full_name); ?></td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td><?php echo e($user->mobile_number); ?></td>
                                    <td><?php echo e($user->role_name ? $user->role_name : ''); ?></td>
                                    <td><?php echo e($user->farmer_code_id ? $user->farmer_code_id : ''); ?></td>
                                    <td><?php echo e($user->decrypt_password ? $user->decrypt_password : ''); ?></td>
                                    <td><?php echo e($user->team_first_name ? Str::limit($user->team_first_name,10).' '.Str::limit($user->team_last_name,5) : ''); ?></td>
                                    <td>
                                        <?php if($user->status == 0): ?>
                                            <span class="badge badge-danger">Inactive</span>
                                        <?php elseif($user->status == 1): ?>
                                            <span class="badge badge-success">Active</span>
                                        <?php endif; ?>
                                    </td>
                                    <td style="display: flex">
                                        
                                        <?php if(isset($user->id) && $user->id == 1): ?>
                                            <a href="javascript:;"
                                                class="btn btn-danger m-2">
                                                <i class="fa fa-ban"></i>
                                            </a>
                                        <?php else: ?>
                                            <?php if($user->status == 0): ?>
                                                <?php if(isset($addUserPermission) && isset($addUserPermission) && $addUserPermission->edit == 1 || $userId == 1): ?>
                                                    <?php if(isset($userId) && $userId != $user->id): ?>
                                                        <a href="<?php echo e(route('users.status', ['user_id' => $user->id, 'status' => 1])); ?>"
                                                            class="btn btn-success m-2">
                                                            <i class="fa fa-check"></i>
                                                        </a>
                                                    <?php else: ?>
                                                        <a href="javascript:;"
                                                            class="btn btn-success m-2">
                                                            <i class="fa fa-check"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <a href="javascript:;"
                                                        class="btn btn-success m-2">
                                                        <i class="fa fa-check"></i>
                                                    </a>
                                                <?php endif; ?>
                                            <?php elseif($user->status == 1): ?>
                                                <?php if(isset($addUserPermission) && isset($addUserPermission) && $addUserPermission->edit == 1 || $userId == 1): ?>
                                                    <?php if(isset($userId) && $userId != $user->id): ?>
                                                        <a href="<?php echo e(route('users.status', ['user_id' => $user->id, 'status' => 0])); ?>"
                                                            class="btn btn-danger m-2">
                                                            <i class="fa fa-ban"></i>
                                                        </a>
                                                    <?php else: ?>
                                                        <a href="javascript:;"
                                                            class="btn btn-danger m-2">
                                                            <i class="fa fa-ban"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <a href="javascript:;"
                                                        class="btn btn-danger m-2">
                                                        <i class="fa fa-ban"></i>
                                                    </a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <a href="<?php echo e(route('users.view', ['user' => $user->id])); ?>"
                                            class="btn btn-success m-2">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        <?php if(isset($addUserPermission) && isset($addUserPermission) && $addUserPermission->edit == 1 || $userId == 1): ?>
                                        <a href="<?php echo e(route('users.edit', ['user' => $user->id])); ?>"
                                            class="btn btn-primary m-2">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if(isset($addUserPermission) && isset($addUserPermission) && $addUserPermission->deleted == 1 || $userId == 1): ?>
                                            <?php if(isset($user->id) && $user->id == 1): ?>
                                                <a class="btn btn-danger m-2" href="javascript:;" >
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                            <?php else: ?>
                                                <?php if(isset($userId) && $userId == $user->id): ?>
                                                    <a class="btn btn-danger m-2" href="javascript:;" >
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <a class="btn btn-danger m-2" href="<?php echo e(route('users.destroy', ['user' => $user->id])); ?>" >
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($users->links()); ?>

                </div>
            </div>
        </div>

    </div>
    
    <?php echo $__env->make('users.delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/users/index.blade.php ENDPATH**/ ?>