<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
    
   function splitUnit($txt) {
    if (strtolower(trim($txt)) === 'null') {
        return [null, ''];
    }

    if (preg_match('/^null\s*(.*)/i', $txt, $matches)) {
        $textPart = isset($matches[1]) ? $matches[1] : '';
        return [null, trim($textPart)];
    }

    // Use regular expression to split the string into numbers (including decimals) and text
    preg_match('/([\d\.]+)\s*(.*)/', $txt, $matches);
    
    // Extract the numeric part as a float and the text part, if available
    $numericPart = isset($matches[1]) ? (float)$matches[1] : null; // Cast to float
    $textPart = isset($matches[2]) ? trim($matches[2]) : '';
    
    return [$numericPart, $textPart];
}
?>

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>


<div class="container-fluid">
    <div class="table-responsive">
         <?php if(Session::has('success')): ?>
        <p class="alert alert-success"><?php echo e(Session::get('success')); ?></p>
        <?php endif; ?>
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            <?php if($deshboard == 1): ?>
        
            <?php else: ?>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.three')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.four.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            <?php endif; ?>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Allied Agriculture</h1>
        </div>
        <?php if($data->isNotEmpty()): ?>    
        <?php
            $si = 1;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <form id="dataForm_<?php echo e($data->id); ?>" action="<?php echo e(route('anexure.four.update')); ?>" method="POST">
          <?php echo csrf_field(); ?>
          <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Animal Name</th>
            </tr>
           
          </thead>
         
            <tr>
                <td style="text-align:center;">
                    <?php echo e($si++); ?>

                </td>
                <td><?php echo e($data->farmer_code_id); ?></td>
                <td><?php echo e($data->farmer_first_name); ?> <?php echo e($data->farmer_last_name); ?></td>
                  <td>
                    Number
                </td>
                <td>
                   <input type="text" class="form-control" name="number" value="<?php echo e($data->number); ?>">
                </td>
               
                <td>
                   <select class="form-control" name="animal_name">
                     <option value="Cow (deshi)" <?php echo e($data->animal_name == 'Cow (deshi)' ? 'selected' : ''); ?>>Cow (deshi)</option>
                     <option value="Cow (Cross Breed)" <?php echo e($data->animal_name == 'Cow (Cross Breed)' ? 'selected' : ''); ?>>Cow (Cross Breed)</option>
                     <option value="Bufallow" <?php echo e($data->animal_name == 'Bufallow' ? 'selected' : ''); ?>>Bufallow</option>
                    <option value="Goat" <?php echo e($data->animal_name == 'Goat' ? 'selected' : ''); ?>>Goat</option>
                    <option value="Sheep" <?php echo e($data->animal_name == 'Sheep' ? 'selected' : ''); ?>>Sheep</option>
                    <option value="Poultry (Meet)" <?php echo e($data->animal_name == 'Poultry (Meet)' ? 'selected' : ''); ?>>Poultry (Meet)</option>
                    <option value="Poultry (Egg)" <?php echo e($data->animal_name == 'Poultry (Egg)' ? 'selected' : ''); ?>>Poultry (Egg)</option>
                    <option value="Duck" <?php echo e($data->animal_name == 'Duck' ? 'selected' : ''); ?>>Duck</option>
                    <option value="Other" <?php echo e($data->animal_name == 'Other' ? 'selected' : ''); ?>>Other</option>
                  </select>
                </td>
            </tr>
            
            <input type="text" class="form-control" name="rs" value="Rs" hidden>
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
              
                <td></td>
                <td></td>
                  <td>
                    Breed
                </td>
                <td>
                   
                </td>
                
                <td><input type="text" class="form-control" name="breed" value="<?php echo e($data->breed); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                <td></td>
                <td></td>
                 <td>
                    Generation ( First / Second / Third / Fourth/Fifth)
                </td>
                <td>
                   
                </td>
             
                <td>
                    <select class="form-control" name="generation" >
                     <option value="First" <?php echo e($data->generation == 'First' ? 'selected' : ''); ?>>First</option>
                     <option value="Second" <?php echo e($data->generation == 'Second' ? 'selected' : ''); ?>>Second</option>
                     <option value="Third" <?php echo e($data->generation == 'Third' ? 'selected' : ''); ?>>Third</option>
                     <option value="Fourth" <?php echo e($data->generation == 'Fourth' ? 'selected' : ''); ?>>Fourth</option>
                     <option value="Fifth" <?php echo e($data->generation == 'Fifth' ? 'selected' : ''); ?>>Fifth</option>
                  </select>
                </td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
            
                <td></td>
                <td></td>
                    <td style="font-weight:700;">
                   Green Feed 
                </td>
                <td>
                  
                </td>
                
                <td>
                    <div class="d-flex">
                        <div class="form-check">
                          <input class="green_fodder" type="radio" name="green_fodder" id="green_fodder" value="Yes" <?php echo e($data->green_fodder == 'Yes' ? 'checked' : ''); ?>>
                          <label class="form-check-label" for="green_fodder">Yes</label>
                        </div>
                        <div class="form-check">
                          <input class="green_fodder" type="radio" name="green_fodder" id="green_fodder" value="No" <?php echo e($data->green_fodder == 'No' ? 'checked' : ''); ?>>
                          <label class="form-check-label" for="green_fodder">No</label>
                        </div>
                    </div>
                </td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                <td></td>
                <td></td>
                
                <td>
                    Quantity of Green Fodder
                </td>
                <td>
                    <div class="d-flex">
                        <div class="form-check">
                            <input class="green_fodder_quantity" type="radio" name="green_fodder_quantity_unit" id="green_fodder_quantity_kg" value="Kg"
                                   <?php echo e(splitUnit($data->green_fodder_quantity)[1] == 'Kg' ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="green_fodder_quantity_kg">Kg</label>
                        </div>
                        <div class="form-check">
                            <input class="green_fodder_quantity" type="radio" name="green_fodder_quantity_unit" id="green_fodder_quantity_quintal" value="Quintal"
                                   <?php echo e(splitUnit($data->green_fodder_quantity)[1] == 'Quintal' ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="green_fodder_quantity_quintal">Quintal</label>
                        </div>
                        <div class="form-check">
                            <input class="green_fodder_quantity" type="radio" name="green_fodder_quantity_unit" id="green_fodder_quantity_bag" value="Bag"
                                   <?php echo e(splitUnit($data->green_fodder_quantity)[1] == 'Bag' ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="green_fodder_quantity_bag">Bag</label>
                        </div>
                        <div class="form-check">
                            <input class="green_fodder_quantity" type="radio" name="green_fodder_quantity_unit" id="green_fodder_quantity_other" value="Other"
                                   <?php echo e(splitUnit($data->green_fodder_quantity)[1] == 'Other' ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="green_fodder_quantity_other">Other</label>
                        </div>
                    </div>
                </td>
                
                <td>
                    <input type="text" class="form-control" name="green_fodder_quantity_value" id="green_fodder_quantity_value" value="<?php echo e(splitUnit($data->green_fodder_quantity)[0]); ?>">
                </td>

                
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Expenses on Greed Fodder
                </td>
                
                <td>
                    <?php echo e(splitUnit($data->green_fodder_expenses)[1]); ?>

                </td>
               
                <td>
                    <input type="text" class="form-control" name="green_fodder_expenses_value" value="<?php echo e(splitUnit($data->green_fodder_expenses)[0]); ?>">
                </td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    c
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Total Expenses on Green Fodder
                </td>
                
                <?php
                    $totalExpenses = (splitUnit($data->green_fodder_quantity == null ? '' : $data->green_fodder_quantity)[0] ) * (splitUnit($data->green_fodder_expenses == null ? '' : $data->green_fodder_expenses)[0]);
                ?>
                
                <td>
                    <?php echo e(splitUnit($data->green_fodder_expenses == null ? '' : $data->green_fodder_expenses)[1]); ?>

                </td>
               
                <td>
                    <?php echo e($totalExpenses); ?>

                </td>
            </tr>
            
            <tr>
                <td style="text-align:center;">5</td>
                <td></td>
                <td></td>
                 <td style="font-weight:700;">Dry Feed</td>
                <td></td>
                <td>
                 <div class="d-flex">
                    <div class="form-check">
                      <input class="form-check-input dry_feed" type="radio" name="dry_feed" id="dry_feed" value="Yes" <?php echo e($data->dry_feed == 'Yes' ? 'checked' : ''); ?>>
                      <label class="form-check-label" for="dry_feed">Yes</label>
                    </div>
                    
                    <div class="form-check">
                      <input class="form-check-input dry_feed" type="radio" name="dry_feed" id="dry_feed" value="No" <?php echo e($data->dry_feed == 'No' ? 'checked' : ''); ?>>
                      <label class="form-check-label" for="dry_feed">No</label>
                    </div>
                 </div>
                </td>
            </tr>
            
           
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                <td></td>
                <td></td>
                <td>Quantity of Dry Fodder</td>
                
                <td>
                 <select class="form-control" name="dry_fodder_quantity_unit">
                    <option value="Kg" <?php echo e(splitUnit($data->dry_fodder_quantity)[1] == 'Kg' ? 'selected' : ''); ?>>Kg</option>
                    <option value="Quintal" <?php echo e(splitUnit($data->dry_fodder_quantity)[1] == 'Quintal' ? 'selected' : ''); ?>>Quintal</option>
                    <option value="Bag" <?php echo e(splitUnit($data->dry_fodder_quantity)[1] == 'Bag' ? 'selected' : ''); ?>>Bag</option>
                    <option value="Other" <?php echo e(splitUnit($data->dry_fodder_quantity)[1] == 'Other' ? 'selected' : ''); ?>>Other</option>
                </select>
                    
                    
                </td>
                <td><input type="text" class="form-control" name="dry_fodder_quantity_value" value="<?php echo e(splitUnit($data->dry_fodder_quantity)[0]); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Expenses on Dry Fodder
                </td>
                <td>
                 <?php echo e(splitUnit($data->dry_fodder_expenses == null ? '' : $data->dry_fodder_expenses)[1]); ?>

                 
                </td>
               
                <td><input type="text" class="form-control" name="dry_fodder_expenses" value="<?php echo e(splitUnit($data->dry_fodder_expenses)[0]); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Total Expenses on Dry Fodder
                </td>
                
              <?php
                $dryFodderQuantity = $data->dry_fodder_quantity === null ? '' : splitUnit($data->dry_fodder_quantity)[0];
                $dryFodderExpenses = $data->dry_fodder_expenses === null ? '' : splitUnit($data->dry_fodder_expenses)[0];
                $totalExDrFodd = $dryFodderQuantity * $dryFodderExpenses;
              ?>

                
                <td>
                 <?php echo e(splitUnit($data->dry_fodder_expenses == null ? '' : $data->dry_fodder_expenses)[1]); ?>

                </td>
               
                <td><?php echo e($totalExDrFodd); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    6
                </td>
                
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                 Conventional Feed
                </td>
                <td>
                </td>
                
                <td><?php echo e($data->conventional_feed == 'null' ? '' : $data->conventional_feed); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td><td>
                </td>
                <td></td>
                 <td>
                 Quantity of Conventional Feed 
                </td>
                
                <?php if(splitUnit($data->conventional_feed_quantity)[0] == null): ?>
                <th></th>
                <th></th>
                <?php else: ?>
                <td>
                    <select class="form-control" name="conventional_feed_quantity_unit">
                        <option value="Kg" <?php echo e(splitUnit($data->conventional_feed_quantity)[1] == 'Kg' ? 'selected' : ''); ?>>Kg</option>
                        <option value="Quintal" <?php echo e(splitUnit($data->conventional_feed_quantity)[1] == 'Quintal' ? 'selected' : ''); ?>>Quintal</option>
                        <option value="Bag" <?php echo e(splitUnit($data->conventional_feed_quantity)[1] == 'Bag' ? 'selected' : ''); ?>>Bag</option>
                        <option value="Other" <?php echo e(splitUnit($data->conventional_feed_quantity)[1] == 'Other' ? 'selected' : ''); ?>>Other</option>
                    </select>
                </td>
                
                <td><input type="text" class="form-control" name="conventional_feed_quantity_value" value="<?php echo e(splitUnit($data->conventional_feed_quantity)[0]); ?>"></td>
                <?php endif; ?>
            </tr>
            
            <tr>
                <td style="text-align:center;">b</td>
                <td></td>
                <td></td>
                 <td>Expenditure on Conventional Feed </td>
                <?php if(splitUnit($data->conventional_feed_expenditure)[0] == null): ?>
                <th></th>
                <th></th>
                <?php else: ?>
                <td><?php echo e(splitUnit($data->conventional_feed_expenditure == null ? '' : $data->conventional_feed_expenditure)[1]); ?></td>
                <td><input type="text" class="form-control" name="conventional_feed_expenditure" value="<?php echo e(splitUnit($data->conventional_feed_expenditure)[0]); ?>"></td>
                 <?php endif; ?>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">c</td>
                <td></td>
                <td></td>
                 <td>Total Expenditure on Conventional Feed</td>
                  <?php
                    $Expenditures = $data->conventional_feed_quantity === null ? '' : splitUnit($data->conventional_feed_quantity)[0];
                    $Expendituredat = $data->conventional_feed_expenditure === null ? '' : splitUnit($data->conventional_feed_expenditure)[0];
                    $totalExpenditure= $Expenditures * $Expendituredat;
                  ?>
                 
                <?php if(splitUnit($data->conventional_feed_expenditure)[0] == null): ?> 
                <td></td>
                <?php else: ?>
                <td><?php echo e(splitUnit($data->conventional_feed_expenditure == null ? '' : $data->conventional_feed_expenditure)[1]); ?></td>
                <?php endif; ?>
               
                <?php if($totalExpenditure == 0): ?>
                <td></td>
                <?php else: ?>
                <td><?php echo e($totalExpenditure); ?></td>
                <?php endif; ?>
            </tr>
            
            
            
             <tr>
                <td style="text-align:center;">
                    7
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                 Commercial Feed
                </td>
                <td>
                
                </td>
               
                <td><input type="text" class="form-control" name="commercial_feed" value="<?php echo e($data->commercial_feed); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                <td></td>
                <td></td>
                 <td>
                 Quantity of Commercial Feed 
                </td>
                <td>

                     <select class="form-control" name="commercial_feed_quantity_unit">
                        <option value="Kg" <?php echo e(splitUnit($data->commercial_feed_quantity)[1] == 'Kg' ? 'selected' : ''); ?>>Kg</option>
                        <option value="Quintal" <?php echo e(splitUnit($data->commercial_feed_quantity)[1] == 'Quintal' ? 'selected' : ''); ?>>Quintal</option>
                        <option value="Bag" <?php echo e(splitUnit($data->commercial_feed_quantity)[1] == 'Bag' ? 'selected' : ''); ?>>Bag</option>
                        <option value="Other" <?php echo e(splitUnit($data->commercial_feed_quantity)[1] == 'Other' ? 'selected' : ''); ?>>Other</option>
                    </select>
                    
                </td>

                <td><input type="text" class="form-control" name="commercial_feed_quantity_value" value="<?php echo e(splitUnit($data->commercial_feed_quantity)[0]); ?>"></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Expenses of Commercial Feed 
                </td>
                <td>
                 <?php echo e(splitUnit($data->commercial_feed_expenses == null ? '' : $data->commercial_feed_expenses)[1]); ?>

                </td>
            
                <td><input type="text" class="form-control" name="commercial_feed_expenses" value="<?php echo e(splitUnit($data->commercial_feed_expenses)[0]); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
                <td></td>
                <td></td>
                 <td>Total Expenses of Commercial Feed</td>
                 
               <?php
                $comfeedQ = $data->commercial_feed_quantity === null ? '' : splitUnit($data->commercial_feed_quantity)[0];
                $comfeedexp = $data->commercial_feed_expenses === null ? '' : splitUnit($data->commercial_feed_expenses)[0];
                $totalExpe = $comfeedQ * $comfeedexp;
              ?>
                 
                 
                <td><?php echo e(splitUnit($data->commercial_feed_expenses == null ? '' : $data->commercial_feed_expenses)[1]); ?></td>
                
                <td><?php echo e($totalExpe); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Local
                </td>
                <td>
                 
                </td>
          
                <td><input type="text" class="form-control" name="local" value="<?php echo e($data->local); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    e
                </td>
                <td></td>
                <td></td>
                <td>
                 Branded
                </td>
                <td>
                </td>
                <td><input type="text" class="form-control" name="branded" value="<?php echo e($data->branded); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Expenditure on Health / Veterinary Services
                </td>
                <td>
                 <select class="form-control" name="health_expenditure_unit">
                    <option value="per month" <?php echo e(splitUnit($data->health_expenditure)[1] == 'per month' ? 'selected' : ''); ?>>Per Month</option>
                    <option value="per year" <?php echo e(splitUnit($data->health_expenditure)[1] == 'per year' ? 'selected' : ''); ?>>Per Year</option>
                </select>
                    
                </td>
                
                <td><input type="text" class="form-control" name="health_expenditure" value="<?php echo e(splitUnit($data->health_expenditure)[0]); ?>"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    9
                </td>
                
                <td></td>
                <td></td>
                <td>
                Distance of Veterinary Services
                </td>
                <td>

                  <select class="form-control" name="veterinary_distance_unit">
                    <option value="meters" <?php echo e(splitUnit($data->health_expenditure)[1] == 'meters' ? 'selected' : ''); ?>>Meters</option>
                    <option value="kilometers" <?php echo e(splitUnit($data->health_expenditure)[1] == 'kilometers' ? 'selected' : ''); ?>>kilometers</option>
                  </select>
                  
                </td>
             
                <td><input type="text" class="form-control" name="veterinary_distance_value" value="<?php echo e(splitUnit($data->veterinary_distance)[0]); ?>"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    10
                </td>
                
                <td></td>
                <td></td>
                <td>
                Quality Of Veterinary Services
                </td>
                <td>
                 
                </td>
              
                <td><input type="text" class="form-control" name="veterinary_quality" value="<?php echo e($data->veterinary_quality); ?>"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    11
                </td>
              
                <td></td>
                <td></td>
                  <td style="font-weight:700;">
               Main Product (Milk/Ghee, Curd/Meat/Egg etc.)
                </td>
                <td>
                </td>
               
                <td><input type="text" class="form-control" name="product" value="<?php echo e($data->product); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
             
                <td></td>
                <td></td>
                   <td>
                  Total Production of Main Product
                </td>
                <td>
                  <select class="form-control" name="main_product_production_unit">
                    <option value="kg" <?php echo e(splitUnit($data->main_product_production)[1] == 'meters' ? 'selected' : ''); ?>>Kg</option>
                    <option value="ltr" <?php echo e(splitUnit($data->main_product_production)[1] == 'kilometers' ? 'selected' : ''); ?>>Ltr</option>
                    <option value="nos" <?php echo e(splitUnit($data->main_product_production)[1] == 'meters' ? 'selected' : ''); ?>>Nos</option>
                    <option value="other" <?php echo e(splitUnit($data->main_product_production)[1] == 'kilometers' ? 'selected' : ''); ?>>other</option>
                  </select>
                </td>
              
                <td><input type="text" class="form-control" name="main_product_production_value" value="<?php echo e(splitUnit($data->main_product_production)[0]); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Quantity Sold
                </td>
                <td>
                   <select class="form-control" name="quantity_selling_market_unit">
                    <option value="kg" <?php echo e(splitUnit($data->quantity_selling_market)[1] == 'meters' ? 'selected' : ''); ?>>Kg</option>
                    <option value="ltr" <?php echo e(splitUnit($data->quantity_selling_market)[1] == 'kilometers' ? 'selected' : ''); ?>>Ltr</option>
                    <option value="nos" <?php echo e(splitUnit($data->quantity_selling_market)[1] == 'meters' ? 'selected' : ''); ?>>Nos</option>
                    <option value="other" <?php echo e(splitUnit($data->quantity_selling_market)[1] == 'kilometers' ? 'selected' : ''); ?>>other</option>
                  </select>
                  
                </td>
               
                <td><input type="text" class="form-control" name="quantity_selling_market_value" value="<?php echo e(splitUnit($data->quantity_selling_market)[0]); ?>"></td>
            </tr>
            
           
            
            
            
            <tr>
                <td style="text-align:center;">
                c
                </td>
                <td></td>
                <td></td>
                  <td>
                 Average Selling Price
                </td>
                <td><?php echo e(splitUnit($data->average_selling_price == null ? '' : $data->average_selling_price)[1]); ?></td>
                
                <td><input type="text" class="form-control" name="average_selling_price" value="<?php echo e(splitUnit($data->average_selling_price)[0]); ?>"></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">d</td>
                <td></td>
                <td></td>
                <td>Total Selling Price</td>
                <td><?php echo e(splitUnit($data->quantity_selling_market == null ? '' : $data->quantity_selling_market)[1]); ?></td>
             <?php
                $s = $data->quantity_selling_market === null ? '' : splitUnit($data->quantity_selling_market)[0];
                $t = $data->average_selling_price === null ? '' : splitUnit($data->average_selling_price)[0];
                $totalavgs = $s * $t;
              ?>
                <td><?php echo e($totalavgs); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                e
                </td>
                <td></td>
                <td></td>
                <td>
                 Total Production of By-Product
                </td>
                
                <td>
                 <input type="text" class="form-control" name="other_product_production" value="<?php echo e($data->other_product_production); ?>">
                </td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                f
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Quantity of By-products solds
                </td>
                <td>
                 <?php echo e(splitUnit($data->quantity_selling_other == null ? '' : $data->quantity_selling_other)[1]); ?>

                </td>
              
                <td><input type="text" class="form-control" name="other_product_production" value="<?php echo e(splitUnit($data->quantity_selling_other)[0]); ?>"></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                 g
                </td>
                <td></td>
                <td></td>
                <td>
                Average Selling Price of By-products
                </td>
                <td> <?php echo e(splitUnit($data->average_selling_other == null ? '' : $data->average_selling_other)[1]); ?></td>
                <td><input type="text" class="form-control" name="average_selling_other" value="<?php echo e(splitUnit($data->average_selling_other)[0]); ?>"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">h</td>
                <td></td>
                <td></td>
                <td>Total Selling Price of By-products</td>
                <td></td>
                
                <?php
                    $st = $data->quantity_selling_other === null ? '' : splitUnit($data->quantity_selling_other)[0];
                    $tk = $data->average_selling_other === null ? '' : splitUnit($data->average_selling_other)[0];
                    $totalsellingpri = $st * $tk;
                ?>
                
                <td><?php echo e($totalsellingpri); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                i
                </td>
                <td></td>
                <td></td>
                  <td>
                  Avarage Lactetation period
                </td>
                
                <td><input type="text" class="form-control" name="avarage_lactetation_period_unit" value="<?php echo e($data->avarage_lactetation_period_unit); ?>"></td>
                <td><input type="text" class="form-control" name="avarage_lactetation_period" value="<?php echo e($data->avarage_lactetation_period); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                j
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Place of first sale
                </td>
                <td>
                 
                </td>
                
                <td><input type="text"  class="form-control" name="first_sale_place" value="<?php echo e($data->first_sale_place); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                12
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                Product/s Sold to
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                a
                </td>

                <td></td>
                <td></td>
                <td>
               Sold to villagers
                </td>
                <td>
                 
                </td>
              
                <td><input type="text" class="form-control" name="sold_to_villagers" value="<?php echo e($data->sold_to_villagers); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
                
                <td></td>
                <td></td>
                <td>
                Sold to Milkman
                </td>
                <td>
                 
                </td>
               
                <td><input type="text" class="form-control" name="sold_to_milkman" value="<?php echo e($data->sold_to_milkman); ?>"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                c
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Sold to Local Dairy Unit
                </td>
                <td>
                 
                </td>
                
                <td><input type="text" class="form-control" name="sold_to_local_dairy_unit" value="<?php echo e($data->sold_to_local_dairy_unit); ?>"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                d
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Milk Processing Company
                </td>
                <td>
                 
                </td>
                
                <td><input type="text" class="form-control" name="milk_processing_company" value="<?php echo e($data->milk_processing_company); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                e
                </td>
              
                <td></td>
                <td></td>
                  <td>
               Milk Cooperative Society
                </td>
                <td>
                
                </td>
               
                <td><input type="text" class="form-control" name="milk_cooperative_society" value="<?php echo e($data->milk_cooperative_society); ?>"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                f
                </td>
                
                <td></td>
                <td></td>
                <td>
               Direct Selling to consumer in local market
                </td>
                <td>
                
                </td>
                
              <td><input type="text" class="form-control" name="direct_sel_loc_mark" value="<?php echo e($data->direct_sel_loc_mark); ?>"></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                g
                </td>

                <td></td>
                <td></td>
                <td>
               Sold to other
                </td>
                <td>
                
                </td>
               
              <td><input type="text" class="form-control" name="sold_to_other" value="<?php echo e($data->sold_to_other); ?>"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                13
                </td>
               
                <td></td>
                <td></td>
                 <td>
               Extent of underweighting (%)
                </td>
                <td>
                 Percent
                </td>
               
                <td><input type="text" class="form-control" name="under_weighing" value="<?php echo e($data->under_weighing); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                14
                </td>

                <td></td>
                <td></td>
                 <td>
              Extent of trader’s default (%)
                </td>
                <td>
                 Percent
                </td>
                
                <td><input type="text" class="form-control" name="trader_default" value="<?php echo e($data->trader_default); ?>"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                15
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Post-Production Losses
                </td>
                <td>
                 
                </td>
               
                <td><input type="text" class="form-control" name="post_production_losses" value="<?php echo e($data->post_production_losses); ?>"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                16
                </td>
                <td>
                </td>
                <td></td>
                <td>
                 Any Other factors
                </td>
                <td></td>
                <td><input type="text" class="form-control" name="any_other_factors" value="<?php echo e($data->any_other_factors); ?>"></td>
            </tr>
                <input type="text" name="id"  value="<?php echo e($data->id); ?>" hidden>
               <input type="text" name="farmarid" value="<?php echo e($data->farmer_id); ?>" hidden>
            <tr>
             <td colspan="6"><button type="button" class="btn btn-primary" data-id="<?php echo e($data->id); ?>" data-farmerid="<?php echo e($data->farmer_id); ?>">Update</button></td>
            </tr>
             
        </table>
         </form>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       <?php else: ?>
       <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Animal Name</th>
            </tr>
           
          </thead>
         
            <tr>
                <td style="text-align:center;">
                    1
                </td>
                <td></td>
                <td></td>
                  <td>
                    Number
                </td>
                <td>
                </td>
               
                <td>
                </td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
              
                <td></td>
                <td></td>
                  <td>
                    Breed
                </td>
                <td>
                   
                </td>
                
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                <td></td>
                <td></td>
                 <td>
                    Generation ( First / Second / Third / Fourth/Fifth)
                </td>
                <td>
                   
                </td>
             
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
            
                <td></td>
                <td></td>
                    <td style="font-weight:700;">
                   Green Feed 
                </td>
                <td>
                  
                </td>
                
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                <td></td>
                <td></td>
                 <td>
                   Quantity of Green Fodder
                </td>
                <td>
                </td>
             
                <td>
                </td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Expenses on Greed Fodder
                </td>
                
                <td>
                </td>
               
                <td>
                </td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    5
                </td>

                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                  Dry Feed
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>

                <td></td>
                <td></td>
                <td>
                 Quantity of Dry Fodder
                </td>
                <td>
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Expenses on Dry Fodder
                </td>
                <td>
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    6
                </td>
                
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                 Conventional Feed
                </td>
                <td>
                </td>
                
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                <td>
                 
                </td>
                <td></td>
                 <td>
                 Quantity of Conventional Feed 
                </td>
              
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
             
                <td></td>
                <td></td>
                   <td>
                 Expenditure on Conventional Feed 
                </td>
                <td>
                </td>

                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    7
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                 Commercial Feed
                </td>
                <td>
                
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Quantity of Commercial Feed 
                </td>
                <td>
                </td>

                <td></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Expenses of Commercial Feed 
                </td>
                <td>
                </td>
            
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Local
                </td>
                <td>
                 
                </td>
          
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>

                <td></td>
                <td></td>
                <td>
                 Branded
                </td>
                <td>

                </td>
             
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Expenditure on Health / Veterinary Services
                </td>
                <td>
                </td>
                
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    9
                </td>
                
                <td></td>
                <td></td>
                <td>
                Distance of Veterinary Services
                </td>
                <td>
                </td>
             
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    10
                </td>
                
                <td></td>
                <td></td>
                <td>
                Quality Of Veterinary Services
                </td>
                <td>
                 
                </td>
              
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    11
                </td>
              
                <td></td>
                <td></td>
                  <td style="font-weight:700;">
               Main Product (Milk/Ghee, Curd/Meat/Egg etc.)
                </td>
                <td>
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
             
                <td></td>
                <td></td>
                   <td>
                  Total Production of Main Product
                </td>
                <td>
                </td>
              
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Quantity Sold
                </td>
                <td>
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                c
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Average Selling Price
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                d
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Total Production of By-Product
                </td>
                <td>
                </td>
            
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                e
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Quantity of By-products solds
                </td>
                <td>
                </td>
              
                <td></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                f
                </td>
                
                <td></td>
                <td></td>
                <td>
                Average Selling Price of By-products
                </td>
                <td>
                 
                </td>
             
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                g
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Place of first sale
                </td>
                <td>
                 
                </td>
                
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                12
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                Product/s Sold to
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                a
                </td>

                <td></td>
                <td></td>
                <td>
               Sold to villagers
                </td>
                <td>
                 
                </td>
              
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
                
                <td></td>
                <td></td>
                <td>
                Sold to Milkman
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                c
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Sold to Local Dairy Unit
                </td>
                <td>
                 
                </td>
                
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                d
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Milk Processing Company
                </td>
                <td>
                 
                </td>
                
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                e
                </td>
              
                <td></td>
                <td></td>
                  <td>
               Milk Cooperative Society
                </td>
                <td>
                
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                f
                </td>
                
                <td></td>
                <td></td>
                <td>
               Direct Selling to consumer in local market
                </td>
                <td>
                
                </td>
                <td></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                g
                </td>

                <td></td>
                <td></td>
                <td>
               Sold to other
                </td>
                <td>
                
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                13
                </td>
               
                <td></td>
                <td></td>
                 <td>
               Extent of underweighting (%)
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                14
                </td>

                <td></td>
                <td></td>
                                <td>
              Extent of trader’s default (%)
                </td>
                <td>
                 
                </td>
                
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                15
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Post-Production Losses
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                16
                </td>
              
                <td>
                 
                </td>
                <td></td>
                <td>
                 Any Other factors
                </td>
                <td></td>
                  
                <td></td>
               
            </tr>
            
        </table>
       <?php endif; ?>
    </div>
</div>
<script>
  function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
</script>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <script>
        $(document).ready(function() {
        function submitForm(id, farmerid) {
            var form = $('#dataForm_' + id);
            if (form.length) {
                form.submit();
            }
            $('#data_id').val(id); 
            $('#farmerid').val(farmerid); 
        }
            $('.btn-primary').on('click', function() {
                var id = $(this).data('id');
                var farmerid = $(this).data('farmerid');
                submitForm(id, farmerid);
            });
        });
        
       
    </script>
    
    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-four-update.blade.php ENDPATH**/ ?>