<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
             <?php if($deshboard == 1): ?>
        
            <?php else: ?>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.four')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.f.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            <?php endif; ?>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Forward Linkages</h1>
        </div>
        
        <?php if($data->isNotEmpty()): ?>
        <?php
            $si = 1;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Farm Gate</th>
              <th>Procurement Centre through MSP</th>
              <th>Village Trader</th>
              <th>Mandi (Wholesaler) </th>
              <th>Processor</th>
              <th>Distributor</th>
              <th>Retailer </th>
              <th>Consumer</th>
              <th>Any other Institution </th>
          </thead>
          
          
         
            <tr>
                <td style="text-align:center;">
                    <?php echo e($si++); ?>

                </td>

                <td><?php echo e($datas->farmer_code_id); ?> </td>
                <td> <?php echo e($datas->farmer_first_name == 'null' ? '' : $datas->farmer_first_name.' '.$datas->farmer_last_name); ?></td>
                <td>
                    Marketing channel (Purchaser)
                </td>
                <?php
                $marketingchannel = json_decode($datas->marketing_channel, true);
                ?>
                <td><?php echo e($marketingchannel['unit'] ?? ''); ?></td>
                <td><?php echo e($marketingchannel['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($marketingchannel['msp'] ?? ''); ?></td>
                <td><?php echo e($marketingchannel['village_trader'] ?? ''); ?></td>
                <td><?php echo e($marketingchannel['mandi'] ?? ''); ?></td>
                <td><?php echo e($marketingchannel['processor'] ?? ''); ?></td>
                <td><?php echo e($marketingchannel['distributor'] ?? ''); ?></td>
                <td><?php echo e($marketingchannel['retailer'] ?? ''); ?></td>
                <td><?php echo e($marketingchannel['consumer'] ?? ''); ?></td>
                <td><?php echo e($marketingchannel['any_others'] ?? ''); ?></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
              
                <td></td>
                <td></td>
                  <td>
                   Distance of marketing channel from farm gate
                </td>
                <?php
                $marketingchanneldistance = json_decode($datas->marketing_channel_distance, true);
                ?>
                 <td><?php echo e($marketingchanneldistance['unit'] ?? ''); ?></td>
                <td><?php echo e($marketingchanneldistance['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($marketingchanneldistance['msp'] ?? ''); ?></td>
                <td><?php echo e($marketingchanneldistance['village_trader'] ?? ''); ?></td>
                <td><?php echo e($marketingchanneldistance['mandi'] ?? ''); ?></td>
                <td><?php echo e($marketingchanneldistance['processor'] ?? ''); ?></td>
                <td><?php echo e($marketingchanneldistance['distributor'] ?? ''); ?></td>
                <td><?php echo e($marketingchanneldistance['retailer'] ?? ''); ?></td>
                <td><?php echo e($marketingchanneldistance['consumer'] ?? ''); ?></td>
                <td><?php echo e($marketingchanneldistance['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                <td></td>
                <td></td>
                 <td>
                    Transportation 
                </td>
                
                <?php
                $transportationmethod = json_decode($datas->transportation_method, true);
                ?>
                 <td><?php echo e($transportationmethod['unit'] ?? ''); ?></td>
                <td><?php echo e($transportationmethod['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($transportationmethod['msp'] ?? ''); ?></td>
                <td><?php echo e($transportationmethod['village_trader'] ?? ''); ?></td>
                <td><?php echo e($transportationmethod['mandi'] ?? ''); ?></td>
                <td><?php echo e($transportationmethod['processor'] ?? ''); ?></td>
                <td><?php echo e($transportationmethod['distributor'] ?? ''); ?></td>
                <td><?php echo e($transportationmethod['retailer'] ?? ''); ?></td>
                <td><?php echo e($transportationmethod['consumer'] ?? ''); ?></td>
                <td><?php echo e($transportationmethod['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
                
                <td></td>
                <td></td>
                <td>
                   Transport through
                </td>
                <?php
                $transportby = json_decode($datas->transport_by, true);
                ?>
                 <td><?php echo e($transportby['unit'] ?? ''); ?></td>
                <td><?php echo e($transportby['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($transportby['msp'] ?? ''); ?></td>
                <td><?php echo e($transportby['village_trader'] ?? ''); ?></td>
                <td><?php echo e($transportby['mandi'] ?? ''); ?></td>
                <td><?php echo e($transportby['processor'] ?? ''); ?></td>
                <td><?php echo e($transportby['distributor'] ?? ''); ?></td>
                <td><?php echo e($transportby['retailer'] ?? ''); ?></td>
                <td><?php echo e($transportby['consumer'] ?? ''); ?></td>
                <td><?php echo e($transportby['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    5
                </td>

                <td></td>
                <td></td>
                <td>
                  Transport Expenses / Charges 
                </td>
                
                <?php
                $transportexpenses = json_decode($datas->transport_expenses, true);
                ?>
                 <td><?php echo e($transportexpenses['unit'] ?? ''); ?></td>
                <td><?php echo e($transportexpenses['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($transportexpenses['msp'] ?? ''); ?></td>
                <td><?php echo e($transportexpenses['village_trader'] ?? ''); ?></td>
                <td><?php echo e($transportexpenses['mandi'] ?? ''); ?></td>
                <td><?php echo e($transportexpenses['processor'] ?? ''); ?></td>
                <td><?php echo e($transportexpenses['distributor'] ?? ''); ?></td>
                <td><?php echo e($transportexpenses['retailer'] ?? ''); ?></td>
                <td><?php echo e($transportexpenses['consumer'] ?? ''); ?></td>
                <td><?php echo e($transportexpenses['any_others'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    6
                </td>
              
                <td></td>
                <td></td>
                  <td>
                  Who undertake primary Processing (Cleaning, Grading & Sorting)
                </td>
                 <?php
                $primaryprocessing = json_decode($datas->primary_processing, true);
                ?>
                 <td><?php echo e($primaryprocessing['unit'] ?? ''); ?></td>
                <td><?php echo e($primaryprocessing['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($primaryprocessing['msp'] ?? ''); ?></td>
                <td><?php echo e($primaryprocessing['village_trader'] ?? ''); ?></td>
                <td><?php echo e($primaryprocessing['mandi'] ?? ''); ?></td>
                <td><?php echo e($primaryprocessing['processor'] ?? ''); ?></td>
                <td><?php echo e($primaryprocessing['distributor'] ?? ''); ?></td>
                <td><?php echo e($primaryprocessing['retailer'] ?? ''); ?></td>
                <td><?php echo e($primaryprocessing['consumer'] ?? ''); ?></td>
                <td><?php echo e($primaryprocessing['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    7
                </td>
                
                
                <td></td>
                <td></td>
                <td>
                 Whether any assured buyer/institution present?
                </td>
                 <?php
                 $buyerinstitutionpresent = json_decode($datas->buyer_institution_present, true);
                ?>
                 <td><?php echo e($buyerinstitutionpresent['unit'] ?? ''); ?></td>
                <td><?php echo e($buyerinstitutionpresent['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($buyerinstitutionpresent['msp'] ?? ''); ?></td>
                <td><?php echo e($buyerinstitutionpresent['village_trader'] ?? ''); ?></td>
                <td><?php echo e($buyerinstitutionpresent['mandi'] ?? ''); ?></td>
                <td><?php echo e($buyerinstitutionpresent['processor'] ?? ''); ?></td>
                <td><?php echo e($buyerinstitutionpresent['distributor'] ?? ''); ?></td>
                <td><?php echo e($buyerinstitutionpresent['retailer'] ?? ''); ?></td>
                <td><?php echo e($buyerinstitutionpresent['consumer'] ?? ''); ?></td>
                <td><?php echo e($buyerinstitutionpresent['any_others'] ?? ''); ?></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Whether any form of formal or informal contract farming is being practiced by the farmer? 
                </td>
               <?php
                 $formalinformalcontract = json_decode($datas->formal_informal_contract, true);
                ?>
                 <td><?php echo e($formalinformalcontract['unit'] ?? ''); ?></td>
                <td><?php echo e($formalinformalcontract['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($formalinformalcontract['msp'] ?? ''); ?></td>
                <td><?php echo e($formalinformalcontract['village_trader'] ?? ''); ?></td>
                <td><?php echo e($formalinformalcontract['mandi'] ?? ''); ?></td>
                <td><?php echo e($formalinformalcontract['processor'] ?? ''); ?></td>
                <td><?php echo e($formalinformalcontract['distributor'] ?? ''); ?></td>
                <td><?php echo e($formalinformalcontract['retailer'] ?? ''); ?></td>
                <td><?php echo e($formalinformalcontract['consumer'] ?? ''); ?></td>
                <td><?php echo e($formalinformalcontract['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    9
                </td>
            
                <td></td>
                <td></td>
                <td>
                  Presence of Niche Market (big hotels/residential institutions near the farm gate). 
                </td>
                 <?php
                 $nichemarket = json_decode($datas->niche_market, true);
                 ?>
                 <td><?php echo e($nichemarket['unit'] ?? ''); ?></td>
                <td><?php echo e($nichemarket['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($nichemarket['msp'] ?? ''); ?></td>
                <td><?php echo e($nichemarket['village_trader'] ?? ''); ?></td>
                <td><?php echo e($nichemarket['mandi'] ?? ''); ?></td>
                <td><?php echo e($nichemarket['processor'] ?? ''); ?></td>
                <td><?php echo e($nichemarket['distributor'] ?? ''); ?></td>
                <td><?php echo e($nichemarket['retailer'] ?? ''); ?></td>
                <td><?php echo e($nichemarket['consumer'] ?? ''); ?></td>
                <td><?php echo e($nichemarket['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    10
                </td>

                <td></td>
                <td></td>
                <td style="font-weight:700;">
                Whether secondary processing being undertaken presently (value addition, packaging, marketing, etc.)
                </td>
                 <?php
                 $secondaryprocessing = json_decode($datas->secondary_processing, true);
                ?>
                 <td><?php echo e($secondaryprocessing['unit'] ?? ''); ?></td>
                <td><?php echo e($secondaryprocessing['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($secondaryprocessing['msp'] ?? ''); ?></td>
                <td><?php echo e($secondaryprocessing['village_trader'] ?? ''); ?></td>
                <td><?php echo e($secondaryprocessing['mandi'] ?? ''); ?></td>
                <td><?php echo e($secondaryprocessing['processor'] ?? ''); ?></td>
                <td><?php echo e($secondaryprocessing['distributor'] ?? ''); ?></td>
                <td><?php echo e($secondaryprocessing['retailer'] ?? ''); ?></td>
                <td><?php echo e($secondaryprocessing['consumer'] ?? ''); ?></td>
                <td><?php echo e($secondaryprocessing['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    11
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Presence of any processing plant or food enterprise in the vicinity of farm gate
                </td>
                 <?php
                 $processinginvicinity = json_decode($datas->processing_in_vicinity, true);
                ?>
                 <td><?php echo e($processinginvicinity['unit'] ?? ''); ?></td>
                <td><?php echo e($processinginvicinity['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($processinginvicinity['msp'] ?? ''); ?></td>
                <td><?php echo e($processinginvicinity['village_trader'] ?? ''); ?></td>
                <td><?php echo e($processinginvicinity['mandi'] ?? ''); ?></td>
                <td><?php echo e($processinginvicinity['processor'] ?? ''); ?></td>
                <td><?php echo e($processinginvicinity['distributor'] ?? ''); ?></td>
                <td><?php echo e($processinginvicinity['retailer'] ?? ''); ?></td>
                <td><?php echo e($processinginvicinity['consumer'] ?? ''); ?></td>
                <td><?php echo e($processinginvicinity['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    12
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Whether Storage facility available?
                </td>
                 <?php
                 $storagefacility = json_decode($datas->storage_facility, true);
                ?>
                 <td><?php echo e($storagefacility['unit'] ?? ''); ?></td>
                <td><?php echo e($storagefacility['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($storagefacility['msp'] ?? ''); ?></td>
                <td><?php echo e($storagefacility['village_trader'] ?? ''); ?></td>
                <td><?php echo e($storagefacility['mandi'] ?? ''); ?></td>
                <td><?php echo e($storagefacility['processor'] ?? ''); ?></td>
                <td><?php echo e($storagefacility['distributor'] ?? ''); ?></td>
                <td><?php echo e($storagefacility['retailer'] ?? ''); ?></td>
                <td><?php echo e($storagefacility['consumer'] ?? ''); ?></td>
                <td><?php echo e($storagefacility['any_others'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    13
                </td>
               
               
                <td></td>
                <td></td>
                 <td>
                 Grain Storage / Cold Storage / Controlled Atmospheric Storage
                </td>
                 <?php
                 $storage = json_decode($datas->storage, true);
                ?>
                <td><?php echo e($storage['unit'] ?? ''); ?></td>
                <td><?php echo e($storage['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($storage['msp'] ?? ''); ?></td>
                <td><?php echo e($storage['village_trader'] ?? ''); ?></td>
                <td><?php echo e($storage['mandi'] ?? ''); ?></td>
                <td><?php echo e($storage['processor'] ?? ''); ?></td>
                <td><?php echo e($storage['distributor'] ?? ''); ?></td>
                <td><?php echo e($storage['retailer'] ?? ''); ?></td>
                <td><?php echo e($storage['consumer'] ?? ''); ?></td>
                <td><?php echo e($storage['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    14
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 If yes, capacity of the facility?
                </td>
                
                <?php
                 $facilitycapacity = json_decode($datas->facility_capacity, true);
                ?>
                <td><?php echo e($facilitycapacity['unit'] ?? ''); ?></td>
                <td><?php echo e($facilitycapacity['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($facilitycapacity['msp'] ?? ''); ?></td>
                <td><?php echo e($facilitycapacity['village_trader'] ?? ''); ?></td>
                <td><?php echo e($facilitycapacity['mandi'] ?? ''); ?></td>
                <td><?php echo e($facilitycapacity['processor'] ?? ''); ?></td>
                <td><?php echo e($facilitycapacity['distributor'] ?? ''); ?></td>
                <td><?php echo e($facilitycapacity['retailer'] ?? ''); ?></td>
                <td><?php echo e($facilitycapacity['consumer'] ?? ''); ?></td>
                <td><?php echo e($facilitycapacity['any_others'] ?? ''); ?></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    15
                </td>

               
                <td></td>
                <td></td>
                 <td>
                 Charges for storage / cold storage / bulk cooling system / any other preservation system   
                </td>
                <?php
                 $storagecharges = json_decode($datas->storage_charges, true);
                ?>
                <td><?php echo e($storagecharges['unit'] ?? ''); ?></td>
                <td><?php echo e($storagecharges['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($storagecharges['msp'] ?? ''); ?></td>
                <td><?php echo e($storagecharges['village_trader'] ?? ''); ?></td>
                <td><?php echo e($storagecharges['mandi'] ?? ''); ?></td>
                <td><?php echo e($storagecharges['processor'] ?? ''); ?></td>
                <td><?php echo e($storagecharges['distributor'] ?? ''); ?></td>
                <td><?php echo e($storagecharges['retailer'] ?? ''); ?></td>
                <td><?php echo e($storagecharges['consumer'] ?? ''); ?></td>
                <td><?php echo e($storagecharges['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    16
                </td>
            
                <td></td>
                <td></td>
                
                <td>
                 Storage Duration 
                </td>
              <?php
                $storage_duretion = json_decode($datas->storage_duretion, true);
                ?>
                <td><?php echo e($storage_duretion['unit'] ?? ''); ?></td>
                <td><?php echo e($storage_duretion['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($storage_duretion['msp'] ?? ''); ?></td>
                <td><?php echo e($storage_duretion['village_trader'] ?? ''); ?></td>
                <td><?php echo e($storage_duretion['mandi'] ?? ''); ?></td>
                <td><?php echo e($storage_duretion['processor'] ?? ''); ?></td>
                <td><?php echo e($storage_duretion['distributor'] ?? ''); ?></td>
                <td><?php echo e($storage_duretion['retailer'] ?? ''); ?></td>
                <td><?php echo e($storage_duretion['consumer'] ?? ''); ?></td>
                <td><?php echo e($storage_duretion['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    17
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Time of sale of produce after harvesting
                </td>
                
                <?php
                 $timeofsale = json_decode($datas->time_of_sale, true);
                ?>
                <td><?php echo e($timeofsale['unit'] ?? ''); ?></td>
                <td><?php echo e($timeofsale['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($timeofsale['msp'] ?? ''); ?></td>
                <td><?php echo e($timeofsale['village_trader'] ?? ''); ?></td>
                <td><?php echo e($timeofsale['mandi'] ?? ''); ?></td>
                <td><?php echo e($timeofsale['processor'] ?? ''); ?></td>
                <td><?php echo e($timeofsale['distributor'] ?? ''); ?></td>
                <td><?php echo e($timeofsale['retailer'] ?? ''); ?></td>
                <td><?php echo e($timeofsale['consumer'] ?? ''); ?></td>
                <td><?php echo e($timeofsale['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                18
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Type of road connectivity to farm gate 
                </td>
                
                <?php
                 $roadconnectivity = json_decode($datas->road_connectivity, true);
                ?>
                <td><?php echo e($roadconnectivity['unit'] ?? ''); ?></td>
                <td><?php echo e($roadconnectivity['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($roadconnectivity['msp'] ?? ''); ?></td>
                <td><?php echo e($roadconnectivity['village_trader'] ?? ''); ?></td>
                <td><?php echo e($roadconnectivity['mandi'] ?? ''); ?></td>
                <td><?php echo e($roadconnectivity['processor'] ?? ''); ?></td>
                <td><?php echo e($roadconnectivity['distributor'] ?? ''); ?></td>
                <td><?php echo e($roadconnectivity['retailer'] ?? ''); ?></td>
                <td><?php echo e($roadconnectivity['consumer'] ?? ''); ?></td>
                <td><?php echo e($roadconnectivity['any_others'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    19
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Payment of sale proceed
                </td>
                 <?php
                 $paymentofsale = json_decode($datas->payment_of_sale, true);
                ?>
                <td><?php echo e($paymentofsale['unit'] ?? ''); ?></td>
                <td><?php echo e($paymentofsale['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($paymentofsale['msp'] ?? ''); ?></td>
                <td><?php echo e($paymentofsale['village_trader'] ?? ''); ?></td>
                <td><?php echo e($paymentofsale['mandi'] ?? ''); ?></td>
                <td><?php echo e($paymentofsale['processor'] ?? ''); ?></td>
                <td><?php echo e($paymentofsale['distributor'] ?? ''); ?></td>
                <td><?php echo e($paymentofsale['retailer'] ?? ''); ?></td>
                <td><?php echo e($paymentofsale['consumer'] ?? ''); ?></td>
                <td><?php echo e($paymentofsale['any_others'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    20
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Extent of default of Payment of total sale value
                </td>
               
               <?php
                 $totalsalevalue = json_decode($datas->total_sale_value, true);
                ?>
                <td><?php echo e($totalsalevalue['unit'] ?? ''); ?></td>
                <td><?php echo e($totalsalevalue['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($totalsalevalue['msp'] ?? ''); ?></td>
                <td><?php echo e($totalsalevalue['village_trader'] ?? ''); ?></td>
                <td><?php echo e($totalsalevalue['mandi'] ?? ''); ?></td>
                <td><?php echo e($totalsalevalue['processor'] ?? ''); ?></td>
                <td><?php echo e($totalsalevalue['distributor'] ?? ''); ?></td>
                <td><?php echo e($totalsalevalue['retailer'] ?? ''); ?></td>
                <td><?php echo e($totalsalevalue['consumer'] ?? ''); ?></td>
                <td><?php echo e($totalsalevalue['any_others'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    21
                </td>
               
              
                <td></td>
                <td></td>
                  <td>
                    Weighing Method
                </td>
                 <?php
                 $weighingmethod = json_decode($datas->weighing_method, true);
                ?>
                <td><?php echo e($weighingmethod['unit'] ?? ''); ?></td>
                <td><?php echo e($weighingmethod['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($weighingmethod['msp'] ?? ''); ?></td>
                <td><?php echo e($weighingmethod['village_trader'] ?? ''); ?></td>
                <td><?php echo e($weighingmethod['mandi'] ?? ''); ?></td>
                <td><?php echo e($weighingmethod['processor'] ?? ''); ?></td>
                <td><?php echo e($weighingmethod['distributor'] ?? ''); ?></td>
                <td><?php echo e($weighingmethod['retailer'] ?? ''); ?></td>
                <td><?php echo e($weighingmethod['consumer'] ?? ''); ?></td>
                <td><?php echo e($weighingmethod['any_others'] ?? ''); ?></td>
            </tr>
            
         
            
             <tr>
                <td style="text-align:center;">
                22
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Extent of under weighing of whole proceed
                </td>
                <?php
                 $extentofunderweighing = json_decode($datas->extent_of_under_weighing, true);
                ?>
                <td><?php echo e($extentofunderweighing['unit'] ?? ''); ?></td>
                <td><?php echo e($extentofunderweighing['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($extentofunderweighing['msp'] ?? ''); ?></td>
                <td><?php echo e($extentofunderweighing['village_trader'] ?? ''); ?></td>
                <td><?php echo e($extentofunderweighing['mandi'] ?? ''); ?></td>
                <td><?php echo e($extentofunderweighing['processor'] ?? ''); ?></td>
                <td><?php echo e($extentofunderweighing['distributor'] ?? ''); ?></td>
                <td><?php echo e($extentofunderweighing['retailer'] ?? ''); ?></td>
                <td><?php echo e($extentofunderweighing['consumer'] ?? ''); ?></td>
                <td><?php echo e($extentofunderweighing['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                23
                </td>
                
                <td></td>
                <td></td>
                <td>
               Source of Market Information (Demand / Price etc.)
                </td>
                 <?php
                 $source_of_market_info = json_decode($datas->source_of_market_info, true);
                ?>
                <td><?php echo e($source_of_market_info['unit'] ?? ''); ?></td>
                <td><?php echo e($source_of_market_info['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($source_of_market_info['msp'] ?? ''); ?></td>
                <td><?php echo e($source_of_market_info['village_trader'] ?? ''); ?></td>
                <td><?php echo e($source_of_market_info['mandi'] ?? ''); ?></td>
                <td><?php echo e($source_of_market_info['processor'] ?? ''); ?></td>
                <td><?php echo e($source_of_market_info['distributor'] ?? ''); ?></td>
                <td><?php echo e($source_of_market_info['retailer'] ?? ''); ?></td>
                <td><?php echo e($source_of_market_info['consumer'] ?? ''); ?></td>
                <td><?php echo e($source_of_market_info['any_others'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                24  
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Percentage of sale of total marketable surplus through MSP
                </td>
               
                 <?php
                 $totalmarketablesurplus = json_decode($datas->total_marketable_surplus, true);
                ?>
                <td><?php echo e($totalmarketablesurplus['unit'] ?? ''); ?></td>
                <td><?php echo e($totalmarketablesurplus['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($totalmarketablesurplus['msp'] ?? ''); ?></td>
                <td><?php echo e($totalmarketablesurplus['village_trader'] ?? ''); ?></td>
                <td><?php echo e($totalmarketablesurplus['mandi'] ?? ''); ?></td>
                <td><?php echo e($totalmarketablesurplus['processor'] ?? ''); ?></td>
                <td><?php echo e($totalmarketablesurplus['distributor'] ?? ''); ?></td>
                <td><?php echo e($totalmarketablesurplus['retailer'] ?? ''); ?></td>
                <td><?php echo e($totalmarketablesurplus['consumer'] ?? ''); ?></td>
                <td><?php echo e($totalmarketablesurplus['any_others'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                25
                </td>
            
                <td></td>
                <td></td>
                    <td>
               Is producer directly selling to MSP procurement agency or through mediator
                </td>
                 <?php
                 $sellingonmsp = json_decode($datas->selling_on_msp, true);
                ?>
                <td><?php echo e($sellingonmsp['unit'] ?? ''); ?></td>
                <td><?php echo e($sellingonmsp['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($sellingonmsp['msp'] ?? ''); ?></td>
                <td><?php echo e($sellingonmsp['village_trader'] ?? ''); ?></td>
                <td><?php echo e($sellingonmsp['mandi'] ?? ''); ?></td>
                <td><?php echo e($sellingonmsp['processor'] ?? ''); ?></td>
                <td><?php echo e($sellingonmsp['distributor'] ?? ''); ?></td>
                <td><?php echo e($sellingonmsp['retailer'] ?? ''); ?></td>
                <td><?php echo e($sellingonmsp['consumer'] ?? ''); ?></td>
                <td><?php echo e($sellingonmsp['any_others'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                26
                </td>
               
                <td></td>
                <td></td>
                 <td>
               If No, extent of getting MSP price
                </td>
               <?php
                 $extentofmspprice = json_decode($datas->extent_of_msp_price, true);
                ?>
                <td><?php echo e($extentofmspprice['unit'] ?? ''); ?></td>
                <td><?php echo e($extentofmspprice['farm_gate'] ?? ''); ?></td>
                <td><?php echo e($extentofmspprice['msp'] ?? ''); ?></td>
                <td><?php echo e($extentofmspprice['village_trader'] ?? ''); ?></td>
                <td><?php echo e($extentofmspprice['mandi'] ?? ''); ?></td>
                <td><?php echo e($extentofmspprice['processor'] ?? ''); ?></td>
                <td><?php echo e($extentofmspprice['distributor'] ?? ''); ?></td>
                <td><?php echo e($extentofmspprice['retailer'] ?? ''); ?></td>
                <td><?php echo e($extentofmspprice['consumer'] ?? ''); ?></td>
                <td><?php echo e($extentofmspprice['any_others'] ?? ''); ?></td>
            </tr>
            
        </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
         <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Farm Gate</th>
              <th>Procurement Centre through MSP</th>
              <th>Village Trader</th>
              <th>Mandi (Wholesaler) </th>
              <th>Processor</th>
              <th>Distributor</th>
              <th>Retailer </th>
              <th>Consumer</th>
              <th>Any other Institution </th>
          </thead>
          
          
         
            <tr>
                <td style="text-align:center;">
                    1
                </td>

                <td> </td>
                <td> </td>
                <td>
                    Marketing channel (Purchaser)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
              
                <td></td>
                <td></td>
                  <td>
                   Distance of marketing channel from farm gate
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                <td></td>
                <td></td>
                 <td>
                    Transportation 
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
                
                <td></td>
                <td></td>
                <td>
                   Transport through
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    5
                </td>

                <td></td>
                <td></td>
                <td>
                  Transport Expenses / Charges 
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    6
                </td>
              
                <td></td>
                <td></td>
                  <td>
                  Who undertake primary Processing (Cleaning, Grading & Sorting)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    7
                </td>
                
                
                <td></td>
                <td></td>
                <td>
                 Whether any assured buyer/institution present?
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Whether any form of formal or informal contract farming is being practiced by the farmer? 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    9
                </td>
            
                <td></td>
                <td></td>
                    <td>
               Presence of Niche Market big hotels/residential institutions near the farm gate. 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    10
                </td>

                <td></td>
                <td></td>
                <td style="font-weight:700;">
                Whether secondary processing being undertaken presently (value addition, packaging, marketing, etc.)
                </td>
                Presence of Niche Market big hotels/residential institutions near the farm gate. 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    11
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Presence of any processing plant or food enterprise in the vicinity of farm gate
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    12
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Whether Storage facility available?
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    13
                </td>
               
               
                <td></td>
                <td></td>
                 <td>
                 Grain Storage / Cold Storage / Controlled Atmospheric Storage
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    14
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 If yes, capacity of the facility?
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    15
                </td>

               
                <td></td>
                <td></td>
                 <td>
                 Charges for storage / cold storage / bulk cooling system / any other preservation system   
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    16
                </td>
            
                <td></td>
                <td></td>
                    <td>
                 Storage Duration 
                </td>
                
                <td>
                 Day/ Month / Year
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    17
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Time of sale of produce after harvesting
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                18
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Type of road connectivity to farm gate 
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    19
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Payment of sale proceed
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    20
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Extent of default of Payment of total sale value
                </td>
               
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    21
                </td>
               
              
                <td></td>
                <td></td>
                  <td>
                    Weighing Method
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
         
            
             <tr>
                <td style="text-align:center;">
                22
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Extent of under weighing of whole proceed
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                23
                </td>
                
                <td></td>
                <td></td>
                <td>
               Source of Market Information (Demand / Price etc.)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                24  
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Percentage of sale of total marketable surplus through MSP
                </td>
               
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                25
                </td>
            
                <td></td>
                <td></td>
                    <td>
               Is producer directly selling to MSP procurement agency or through mediator
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                26
                </td>
               
                <td></td>
                <td></td>
                 <td>
               If No, extent of getting MSP price
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
        </table>
         
       <?php endif; ?>


    </div>


    <div class="table-responsive mt-5">
        
       
        
    </div>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-f.blade.php ENDPATH**/ ?>