<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<?php
$userId = Auth::user()->id;
?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Dashboard </h1>

    </div>

    <div class="row">
        <div class="col-md-12">
            <h2 class="text-center mb-3"></h2>
        </div>
    </div>

    <!-- Content Row -->
    <div class="row">

        <!-- Earnings (Monthly) Card Example -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Users</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php
                                $count = \App\Models\User::where('id','!=', 1)->count();
                                ?>
                                <?php echo e($count); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Earnings (Monthly) Card Example -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active Users</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"> <?php
                                $count1 = \App\Models\User::where('id','!=', 1)->where('status','=',1)->count();

                                ?>
                                <?php echo e($count1); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        
    </div>

    <form method="get" action="<?php echo e(url('annex-filter')); ?>">

        <div class="card">
            <div class="card-body">
                <div class="d-flex">
                    <div class="col-md-3">
                        <label for="start_date">Start Date</label>
                        <input type="text" class="date form-control" id="start_date" name="start_date"
                            placeholder="DD/MM/YYYY">
                    </div>

                    <div class="col-md-3 ml-2">
                        <label for="end_date">End Date</label>
                        <input type="text" class="date form-control" id="end_date" name="end_date"
                            placeholder="DD/MM/YYYY">
                    </div>

                    <div class="col-md-4">
                        <label for="start_date">Anexure Data</label>
                        <select class="select2 form-control custom-select" id="annexSelect"
                            style="width: 100%; height:36px;" name="annexure">
                            <option value="0">Select Anexure</option>
                            
                            <?php if(isset($anexuerOnePer) && isset($anexuerOnePer) && $anexuerOnePer->view == 1 || $userId
                            == 1): ?>
                            <option value="1">Farm Input and Output (1A)</option>
                            <?php endif; ?>
                            
                            <?php if(isset($anexuerTwoPer) && isset($anexuerTwoPer) && $anexuerTwoPer->view == 1 || $userId
                            == 1): ?>
                            <option value="2">Infrastructure and Support Services (1B)</option>
                            <?php endif; ?>
                            
                            <?php if(isset($anexuerThreePer) && isset($anexuerThreePer) && $anexuerThreePer->view == 1 ||
                            $userId == 1): ?>
                            <option value="3">CAP & Marketed Surplus (1C)</option>
                            <?php endif; ?>
                            <?php if(isset($anexuerFourPer) && isset($anexuerFourPer) && $anexuerFourPer->view == 1 ||
                            $userId == 1): ?>
                            <option value="4">Allied Agriculture (1D)</option>
                            <?php endif; ?>
                            
                           
                            <option value="9">Backward Linkages (1E)</option>
                            
                            <option value="10">Forward Linkages (1F)</option>

                            <?php if(isset($anexuerSixPer) && isset($anexuerSixPer) && $anexuerSixPer->view == 1 || $userId
                            == 1): ?>
                            <option value="6">Anexure CAPHFARM III</option>
                            <?php endif; ?>
                            
                            <?php if(isset($anexuerFivePer) && isset($anexuerFivePer) && $anexuerFivePer->view == 1 ||
                            $userId == 1): ?>
                            <option value="5">Anexure Supplier II</option>
                            <?php endif; ?>
                            
                           
                            
                            <?php if(isset($anexuerSevenPer) && isset($anexuerSevenPer) && $anexuerSevenPer->view == 1 ||
                            $userId == 1): ?>
                            <option value="7">Anexure TRDFARM IV</option>
                            <?php endif; ?>
                            
                            <?php if(isset($anexuerEightPer) && isset($anexuerEightPer) && $anexuerEightPer->view == 1 ||
                            $userId == 1): ?>
                            <option value="8">Anexure VAFARM V</option>
                            <?php endif; ?>
                            
                            <option value="11">Business Economics of Distributor/ Retailer</option>
                            
                            <option value="12"> Resource Mapping of FPO </option>
                            
                            <option value="13"> Capabilities Mapping of FPO </option>
                            
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label for="start_date">FPO</label>
                        <br>
                        <select class="select2 form-control fpo_id custom-select" data-url="<?php echo e(url('')); ?>" id="fpo"
                            style="width: 40%; height:36px;" name="fpo_id">
                            <option value="" selected disabled>Select FPO</option>
                            <?php $__currentLoopData = $fpo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fpos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($fpos->id); ?>"><?php echo e($fpos->first_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <br>
                <?php
                  $crops = array("Alsi","Any other","Barseem","Brow Lentils (masoor)","Cultivation of Babycorn",
                  "Grams","Kusum","Mushroom farming","Peas","Paddy","Rabi Maize","Rajma","Rye Mustard","Wheat","Yellow Mustard");
                ?>
                <div class="row" id="annexField">
                    
                    <div class="form-group d-none" id="state">
                        <div class="col-md-9">
                            <span class="reqFieldAsterisk validateStateAsterisk"
                                style="color:red; display:none;">*</span><label>State</label>
                            <select id="state_id" data-url="<?php echo e(url('')); ?>"
                                class="form-control validateState requiredFieldAction form-control-user "
                                name="state_id">
                                <option value="" selected disabled>Nothing Selected</option>
                                <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($state->id); ?>"><?php echo e($state->state_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group d-none" id="city">
                        <label class="col-md-8 m-t-15">City</label>
                        <div class="col-md-9">
                            <select id="district_id" data-url="<?php echo e(route('users.fetchExistingCodess')); ?>"
                                class="form-control validateDistrict requiredFieldAction form-control-user <?php $__errorArgs = ['district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select_district"
                                name="district_id">
                                <option value="" selected disabled>Nothing Selected</option>
                            </select>
                        </div>
                    </div>

                    <!--<div class="form-group d-none" id="village">-->
                    <!--    <label class="col-md-8 m-t-15">Village</label>-->
                    <!--    <div class="col-md-9">-->
                    <!--        <input type="text" placeholder="Enter village" name="village" class="form-control" />-->
                    <!--    </div>-->
                    <!--</div>-->
                    
                    <div class="form-group d-none" id="village">
                        <label class="col-md-12 m-t-15">Village</label>
                        <div class="col-md-9">
                            <select class="form-control" name="village" id="village_id">
                                <option value="" selected disabled>Nothing Selected</option>
                            </select>
                        </div>
                    </div>
                    
                    
                    <div class="form-group d-none" id="block">
                        <label class="col-md-12 m-t-15">Block</label>
                        <div class="col-md-9">
                            <select class="form-control" name="block" id="block_id">
                                <option value="" selected disabled>Nothing Selected</option>
                                
                            </select>
                        </div>
                    </div>
                    

                    
                    <div class="form-group d-none" id="crop">
                        <label class="col-md-8 m-t-15">Crop</label>
                        <div class="col-md-9">
                            <select id="crop_id" class="form-control" name="crop_name">
                                <option value="" selected disabled>Nothing Selected</option>
                                <?php $__currentLoopData = $crops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option><?php echo e($val); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    

                    <div class="form-group d-none" id="from-hectare">
                        <label class="col-md-8 m-t-15">From Hectare</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="Enter From hectare" name="from_hectare"
                                class="form-control" />
                        </div>
                    </div>

                    <div class="form-group d-none" id="to-hectare">
                        <label class="col-md-8 m-t-15">To Hectare</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="Enter To hectare" name="to_hectare" class="form-control" />
                        </div>
                    </div>





                    <?php
                      $whomsold = array("Consumer","Company","Commission Agent","Mandi","Processor","Retailer","Village Trader","Wholesaler",
                      "Other");
                    ?>
                    <div class="form-group d-none" id="whom_to_sold">
                        <label class="col-md-12 m-t-15">Whom to Sold</label>
                        <div class="col-md-9">
                            <select class="form-control" name="whom_to_sold">
                                <option value="" selected disabled>Nothing Selected</option>
                                <?php $__currentLoopData = $whomsold; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>"><?php echo e($val); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <?php
                      $farmerslandwise = array("Marginal: Less than 1 hectare","Small: 1–2 hectares","Semi-medium: 2–4 hectares","Medium: 4–10 hectares","Large: More than 10 hectares");
                    ?>
                    <div class="form-group d-none" id="farmers_land_wise">
                        <label class="col-md-12 m-t-15">Farmers Land Wise</label>
                        <div class="col-md-9">
                            <select class="form-control" name="farmers_land_wise">
                                <option value="" selected disabled>Nothing Selected</option>
                                <?php $__currentLoopData = $farmerslandwise; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>"><?php echo e($val); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group d-none" id="animal_name">
                        <label class="col-md-12 m-t-15">Animal Name</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="Enter animal name" name="animal_name"
                                class="form-control" />
                        </div>
                    </div>

                    <div class="form-group d-none" id="breed">
                        <label class="col-md-8 m-t-15">Breed</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="Enter breed" name="breed" class="form-control" />
                        </div>
                    </div>

                    <div class="form-group d-none" id="whom_purchased">
                        <label class="col-md-12 m-t-15">Whom purchased</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="Enter whom purchased" name="whom_purchased"
                                class="form-control" />
                        </div>
                    </div>

                    <!--<div class="form-group d-none" id="supplier">-->
                    <!--    <label class="col-md-8 m-t-15">Supplier</label>-->
                    <!--    <div class="col-md-9">-->
                    <!--        <input type="text" placeholder="Enter supplier" name="supplier" class="form-control"/>-->
                    <!--    </div>-->
                    <!--</div>-->

                </div>
            </div>
            <div class="border-top">
                <div class="card-body">
                    <button type="submit" class="btn btn-primary chartbutton">Search</button>
                </div>
            </div>
        </div>
    </form>

    <div class="col-md-4">
        <canvas id="myChart" class="myChart"></canvas>
    </div>

</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
$(document).ready(function() {
    const ctx = document.getElementById('myChart');

    new Chart(ctx, {
        type: 'pie',
        data: {
            labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple', 'Orange'],
            datasets: [{
                label: '# of Votes',
                data: [12, 19, 3, 5, 2, 3],
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    flatpickr(".date", {
        dateFormat: "d/m/Y",
    });

    let annex = {
        0: [],
        1: ['crop', 'from-hectare', 'state', 'city', 'village', 'whom_to_sold', 'to-hectare',
            'farmers_land_wise' , 'block'
        ],
        21: ['animal_name', 'breed', 'whom_purchased', 'supplier'],
        2: [],
        3: [],
        4: [],
        5: [],
        6: []
    }

    $('#annexSelect').change(function() {
        let annexId = $(this).val();
        $('#annexField .form-group').each(function() {
            let id = $(this).attr('id')
            if (annexId && annex[annexId].includes(id)) {
                $(this).removeClass('d-none')
            } else {
                $(this).addClass('d-none')
            }
        })
    })

    //state base city
    $('body').on('change', '#state_id', function() {
        var state_id = $(this).val();
        var url = $(this).attr('data-url');
        $('#district_id').empty();
        $.ajax({
            url: url + '/users/get-districts/' + state_id,
            type: 'get',
            success: function(resp) {
                $('#district_id').html(resp.html);
                $('#district_id').selectpicker('refresh');
            }
        });
    });
    

    
   
   
    //fpo search data
    
    $('#fpo').change(function() {
    var fpo = $(this).val();
    var url = $(this).attr('data-url');
    $.ajax({
        url: url + '/users/get-fpo/' + fpo,
        type: 'get',
        success: function(resp) {
            if (resp.status === 'success') {
                var addedState = new Set();
                var addedDistrict = new Set();
                var addedBlocks = new Set();
                var addedVillage = new Set();
                
                var state = '';
                var district = '';
                var block = '';
                var village = '';

                $.each(resp.data, function(index, item) {
                    if (item.state_name && !addedState.has(item.state_name)) {
                        state += '<option value="' + item.state_id + '">' + item.state_name + '</option>';
                        addedState.add(item.state_name);
                    }

                    if (item.district_name && !addedDistrict.has(item.district_name)) {
                        district += '<option value="' + item.district_id + '">' + item.district_name + '</option>';
                        addedDistrict.add(item.district_name);
                    }

                    if (item.block && !addedBlocks.has(item.block)) {
                        block += '<option value="' + item.block + '">' + item.block + '</option>';
                        addedBlocks.add(item.block);
                    }

                    if (item.village && !addedVillage.has(item.village)) {
                        village += '<option value="' + item.village + '">' + item.village + '</option>';
                        addedVillage.add(item.village);
                    }
                });

                $('#state_id').html(state);
                $('#district_id').html(district);
                $('#block_id').html(block);
                $('#village_id').html(village);
            } else {
                console.log('Error fetching data.');
            }
        },
        error: function() {
            console.log('AJAX error.');
        }
    });
});
 




})

// document.addEventListener('DOMContentLoaded', function () {});
</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/home.blade.php ENDPATH**/ ?>