<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
             <?php if($deshboard == 1): ?>
        
            <?php else: ?>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.e')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.e.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            <?php endif; ?>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Backward Linkages</h1>
        </div>
        <?php if($data->isNotEmpty()): ?>
         <?php
            $si = 1;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Name of the input supplier / supporting value chain actor</th>
              <th>Adequacy</th>
              <th>quality</th>
              <th>Timely supply</th>
              <th>Effectiveness</th>
              <th>As per scientific recommendation (SOP) </th>
              <th>Price reasonability </th>
              <th>Is inputs on credit  </th>
              <th>Difference in input price under with or without credit (%) </th>
              <th>Remark</th>
          </thead>
          
           <tr>
                <td colspan="5">
                </td>
               
                <td>Name</td>
                <td colspan="6" style="text-align:center; background-color:yellow; color:black; font-weight:700;">Rating as per given below matrix</td>
                <td>Y/N</td>
                <td>%</td>
               <td></td>
            </tr>
         
            <tr>
                <td style="text-align:center;">
                    <?php echo e($si++); ?>

                </td>
                <td><?php echo e($data->farmer_code_id); ?></td>
                <td><?php echo e($data->farmer_first_name); ?> <?php echo e($data->farmer_last_name); ?></td>
                <td>
                    Seed
                </td>
                 <?php
                    $seedData = json_decode($data->seed, true);
                ?>
                
                <td>
                    <?php echo e($seedData['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($seedData['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($seedData['adequacy'] ?? ''); ?></td>
                <td><?php echo e($seedData['quality'] ?? ''); ?></td>
                <td><?php echo e($seedData['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($seedData['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($seedData['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($seedData['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($seedData['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($seedData['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($seedData['remark'] ?? ''); ?></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
                
                <td>
                </td>
                <td></td>
                <td>
                   Plantlets
                </td>
                <?php
                $plantletsData = json_decode($data->plantlets, true);
                ?>
                
                <td>
                    <?php echo e($plantletsData['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($plantletsData['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($plantletsData['adequacy'] ?? ''); ?></td>
                <td><?php echo e($plantletsData['quality'] ?? ''); ?></td>
                <td><?php echo e($plantletsData['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($plantletsData['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($plantletsData['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($plantletsData['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($plantletsData['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($plantletsData['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($plantletsData['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
              
                <td>
                   
                </td>
                <td></td>
                  <td>
                    Fingerling (fishery)
                </td>
              <?php
                $fingerlingData = json_decode($data->fingerling_fishery, true);
                ?>
                
                <td>
                    <?php echo e($fingerlingData['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($fingerlingData['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($fingerlingData['adequacy'] ?? ''); ?></td>
                <td><?php echo e($fingerlingData['quality'] ?? ''); ?></td>
                <td><?php echo e($fingerlingData['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($fingerlingData['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($fingerlingData['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($fingerlingData['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($fingerlingData['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($fingerlingData['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($fingerlingData['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
               
                <td></td>
                <td></td>
                 <td>
                   day old chick (Poultry)
                </td>
                <?php
                $daychickData = json_decode($data->day_old_chick, true);
                ?>
                
                <td>
                    <?php echo e($daychickData['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($daychickData['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($daychickData['adequacy'] ?? ''); ?></td>
                <td><?php echo e($daychickData['quality'] ?? ''); ?></td>
                <td><?php echo e($daychickData['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($daychickData['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($daychickData['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($daychickData['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($daychickData['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($daychickData['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($daychickData['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    5
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Feed 
                </td>
               <?php
                $feedData = json_decode($data->feed, true);
                ?>
                
                <td>
                    <?php echo e($feedData['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($feedData['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($feedData['adequacy'] ?? ''); ?></td>
                <td><?php echo e($feedData['quality'] ?? ''); ?></td>
                <td><?php echo e($feedData['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($feedData['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($feedData['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($feedData['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($feedData['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($feedData['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($feedData['remark'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    6
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Fertilizer
                </td>
               <?php
                $fertilizerData = json_decode($data->fertilizer, true);
                ?>
                
                <td>
                    <?php echo e($fertilizerData['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($fertilizerData['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($fertilizerData['adequacy'] ?? ''); ?></td>
                <td><?php echo e($fertilizerData['quality'] ?? ''); ?></td>
                <td><?php echo e($fertilizerData['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($fertilizerData['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($fertilizerData['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($fertilizerData['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($fertilizerData['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($fertilizerData['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($fertilizerData['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    7
                </td>
                
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                  Pesticides / Insecticide / Herbicides
                </td>
                <?php
                $pesticideData = json_decode($data->pesticides_insec_her, true);
                ?>
                
                <td>
                    <?php echo e($pesticideData['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($pesticideData['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($pesticideData['adequacy'] ?? ''); ?></td>
                <td><?php echo e($pesticideData['quality'] ?? ''); ?></td>
                <td><?php echo e($pesticideData['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($pesticideData['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($pesticideData['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($pesticideData['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($pesticideData['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($pesticideData['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($pesticideData['remark'] ?? ''); ?></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Nutrients
                </td>
                <?php
                $nutrientsdata = json_decode($data->nutrients, true);
                ?>
                
                <td>
                    <?php echo e($nutrientsdata['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($nutrientsdata['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($nutrientsdata['adequacy'] ?? ''); ?></td>
                <td><?php echo e($nutrientsdata['quality'] ?? ''); ?></td>
                <td><?php echo e($nutrientsdata['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($nutrientsdata['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($nutrientsdata['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($nutrientsdata['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($nutrientsdata['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($nutrientsdata['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($nutrientsdata['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    9
                </td>
              
                <td></td>
                <td></td>
                  <td>
               Medicine
                </td>
                <?php
                $medicinedata = json_decode($data->medicine, true);
                ?>
                
                <td>
                    <?php echo e($medicinedata['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($medicinedata['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($medicinedata['adequacy'] ?? ''); ?></td>
                <td><?php echo e($medicinedata['quality'] ?? ''); ?></td>
                <td><?php echo e($medicinedata['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($medicinedata['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($medicinedata['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($medicinedata['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($medicinedata['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($medicinedata['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($medicinedata['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    10
                </td>
             
                <td></td>
                <td></td>
                   <td style="font-weight:700;">
                 Labour
                </td>
               <?php
                $labourdata = json_decode($data->labour, true);
                ?>
                
                <td>
                    <?php echo e($labourdata['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($labourdata['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($labourdata['adequacy'] ?? ''); ?></td>
                <td><?php echo e($labourdata['quality'] ?? ''); ?></td>
                <td><?php echo e($labourdata['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($labourdata['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($labourdata['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($labourdata['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($labourdata['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($labourdata['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($labourdata['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    11
                </td>
             
                <td></td>
                <td></td>
                   <td>
                Supply of diesel fuel / electricity
                </td>
               <?php
                $supplydata = json_decode($data->supply_of_diesel_fuel_electricity, true);
                ?>
                
                <td>
                    <?php echo e($supplydata['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($supplydata['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($supplydata['adequacy'] ?? ''); ?></td>
                <td><?php echo e($supplydata['quality'] ?? ''); ?></td>
                <td><?php echo e($supplydata['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($supplydata['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($supplydata['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($supplydata['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($supplydata['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($supplydata['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($supplydata['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    12
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Technology Transfer 
                </td>
               <?php
                $techdata = json_decode($data->technology_transfer, true);
                ?>
                
                <td>
                    <?php echo e($techdata['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($techdata['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($techdata['adequacy'] ?? ''); ?></td>
                <td><?php echo e($techdata['quality'] ?? ''); ?></td>
                <td><?php echo e($techdata['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($techdata['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($techdata['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($techdata['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($techdata['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($techdata['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($techdata['remark'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    13
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                 FM-Custom Hire Services
                </td>
                <?php
                $fmdata = json_decode($data->fm_custom_hire_services, true);
                ?>
                
                <td>
                    <?php echo e($fmdata['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($fmdata['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($fmdata['adequacy'] ?? ''); ?></td>
                <td><?php echo e($fmdata['quality'] ?? ''); ?></td>
                <td><?php echo e($fmdata['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($fmdata['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($fmdata['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($fmdata['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($fmdata['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($fmdata['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($fmdata['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    14
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Irrigation on Custom and Hiring
                </td>
                
                 <?php
                $irga = json_decode($data->irrigation_on_custom_and_hiring, true);
                ?>
                
                <td>
                    <?php echo e($irga['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($irga['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($irga['adequacy'] ?? ''); ?></td>
                <td><?php echo e($irga['quality'] ?? ''); ?></td>
                <td><?php echo e($irga['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($irga['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($irga['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($irga['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($irga['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($irga['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($irga['remark'] ?? ''); ?></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    15
                </td>
                
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                Source of Credit
                </td>
               <?php
                $sourcece = json_decode($data->source_of_credit, true);
                ?>
                
                <td>
                    <?php echo e($sourcece['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($sourcece['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($sourcece['adequacy'] ?? ''); ?></td>
                <td><?php echo e($sourcece['quality'] ?? ''); ?></td>
                <td><?php echo e($sourcece['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($sourcece['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($sourcece['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($sourcece['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($sourcece['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($sourcece['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($sourcece['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Input Credit
                </td>
                <?php
                $inputcre = json_decode($data->input_credit, true);
                ?>
                
                <td>
                    <?php echo e($inputcre['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($inputcre['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($inputcre['adequacy'] ?? ''); ?></td>
                <td><?php echo e($inputcre['quality'] ?? ''); ?></td>
                <td><?php echo e($inputcre['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($inputcre['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($inputcre['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($inputcre['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($inputcre['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($inputcre['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($inputcre['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>
                
                <td></td>
                <td></td>
                <td>
                Supply Credit
                </td>
               <?php
                $supplycre = json_decode($data->supply_credit, true);
                ?>
                
                <td>
                    <?php echo e($supplycre['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($supplycre['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($supplycre['adequacy'] ?? ''); ?></td>
                <td><?php echo e($supplycre['quality'] ?? ''); ?></td>
                <td><?php echo e($supplycre['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($supplycre['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($supplycre['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($supplycre['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($supplycre['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($supplycre['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($supplycre['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                c
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Credit from NBSC
                </td>
               <?php
                $nbsc = json_decode($data->credit_from_nbsc, true);
                ?>
                
                <td>
                    <?php echo e($nbsc['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($nbsc['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($nbsc['adequacy'] ?? ''); ?></td>
                <td><?php echo e($nbsc['quality'] ?? ''); ?></td>
                <td><?php echo e($nbsc['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($nbsc['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($nbsc['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($nbsc['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($nbsc['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($nbsc['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($nbsc['remark'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    d
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Credit from Banks
                </td>
                <?php
                $bankcre = json_decode($data->credit_from_banks, true);
                ?>
                
                <td>
                    <?php echo e($bankcre['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($bankcre['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($bankcre['adequacy'] ?? ''); ?></td>
                <td><?php echo e($bankcre['quality'] ?? ''); ?></td>
                <td><?php echo e($bankcre['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($bankcre['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($bankcre['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($bankcre['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($bankcre['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($bankcre['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($bankcre['remark'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    e
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Other source/s
                </td>
               <?php
                $othersource = json_decode($data->other_source, true);
                ?>
                
                <td>
                    <?php echo e($othersource['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($othersource['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($othersource['adequacy'] ?? ''); ?></td>
                <td><?php echo e($othersource['quality'] ?? ''); ?></td>
                <td><?php echo e($othersource['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($othersource['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($othersource['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($othersource['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($othersource['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($othersource['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($othersource['remark'] ?? ''); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    16
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
               Any Other Information
                </td>
               <?php
                $anyotherin = json_decode($data->any_other_information, true);
                ?>
                
                <td>
                    <?php echo e($anyotherin['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($anyotherin['input_supplier_name'] ?? ''); ?></td>
                <td><?php echo e($anyotherin['adequacy'] ?? ''); ?></td>
                <td><?php echo e($anyotherin['quality'] ?? ''); ?></td>
                <td><?php echo e($anyotherin['timely_supply'] ?? ''); ?></td>
                <td><?php echo e($anyotherin['effectiveness'] ?? ''); ?></td>
                <td><?php echo e($anyotherin['as_consultancy_service'] ?? ''); ?></td>
                <td><?php echo e($anyotherin['price_reasonability'] ?? ''); ?></td>
                <td><?php echo e($anyotherin['with_or_without_credit'] ?? ''); ?></td>
                <td><?php echo e($anyotherin['diff_in_price_with_without_credit'] ?? ''); ?></td>
                <td><?php echo e($anyotherin['remark'] ?? ''); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700; background-color:#efefef;">
                 Rating
                </td>
                
                <td style="font-weight:700;background-color:#efefef;">
                 Assigned Number for filling rating
                </td>
                
                <td></td>
                
                <td style="font-weight:700;background-color:#efefef;">
                 Adequacy  
                </td>
                
                <td style="font-weight:700;background-color:#efefef;">
                 quality  
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
                
                <td></td>
                <td></td>
                <td style="background-color: green;color:white">
                  Strongly Agree
                </td>
                <td style="background-color: green;color:white">
                 3
                </td>
                <td></td>
                
                <td style="background-color: green;color:white">
                  Strongly Agree
                </td>
                <td>
                 9
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
                
                <td></td>
                <td></td>
                <td style="background-color: #66971b; color:white;">
                 Agree
                </td>
                <td style="background-color: #66971b; color:white;">
                 2
                </td>
                <td></td>
                
                <td style="background-color: #66971b; color:white;">
                 Agree
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                
                </td>
               
                <td></td>
                <td></td>
                 <td style="background-color:yellow; color:black">
                 Satisfactory
                </td>
                <td style="background-color:yellow; color:black">
                 1
                </td>
                <td></td>
                
                <td style="background-color:yellow; color:black">
                 Satisfactory
                </td>
                
                <td>10</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
               
                <td></td>
                <td></td>
                 <td style="background-color:#ff7300; color:white">
               Disagree
                </td>
                <td style="background-color:#ff7300; color:white">
                 -2
                </td>
                <td></td>
                <td style="background-color:#ff7300; color:white">
                 Disagree
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                
                </td>
                <td>
                </td>
                <td>
                 
                </td>
                  <td style="background-color:red; color:white">
               Strongly Disagree
                </td>
                <td style="background-color:red; color:white">
                 -3
                </td>
                <td></td>
               
                 <td style="background-color:red; color:white">
               Strongly Disagree
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
               
                <td></td>
                <td></td>
                 <td>
               Can not say
                </td>
                <td>
                 0
                </td>
                <td></td>
                <td>
               Can not say
                </td>
                <td>1</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                S. No.
                </td>
                <td style="font-weight:700;">
                Particulars
                </td>
                <td>
                 Unit
                </td>
                <td>Indicator</td>
                <td>Remark</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                1
                </td>
                <td>
                Type of seed used
                </td>
                <td>
                 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                a
                </td>
                <td>
               Foundation Seed
                </td>
                
               <?php
                $foundsed = json_decode($data->foundation_seed, true);
                ?>
                
                <td>
                    <?php echo e($foundsed['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($foundsed['indicator'] ?? ''); ?></td>
                <td><?php echo e($foundsed['remark'] ?? ''); ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                b   
                </td>
                <td>
               Breeder Seed
                </td>
                <?php
                $breedseed = json_decode($data->breeder_seed, true);
                ?>
                
                <td>
                    <?php echo e($breedseed['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($breedseed['indicator'] ?? ''); ?></td>
                <td><?php echo e($breedseed['remark'] ?? ''); ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                c
                </td>
                <td>
               Certified Seed
                </td>
                <?php
                $cer_seed = json_decode($data->certified_seed, true);
                ?>
                
                <td>
                    <?php echo e($cer_seed['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($cer_seed['indicator'] ?? ''); ?></td>
                <td><?php echo e($cer_seed['remark'] ?? ''); ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                d
                </td>
                <td>
              Other Seed
                </td>
               <?php
                $otherseed = json_decode($data->other_seed, true);
                ?>
                
                <td>
                    <?php echo e($otherseed['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($otherseed['indicator'] ?? ''); ?></td>
                <td><?php echo e($otherseed['remark'] ?? ''); ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                e
                </td>
                <td>
                Brand of Seed
                </td>
                <?php
                $brand_of_seed = json_decode($data->brand_of_seed, true);
                ?>
                
                <td>
                    <?php echo e($brand_of_seed['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($brand_of_seed['indicator'] ?? ''); ?></td>
                <td><?php echo e($brand_of_seed['remark'] ?? ''); ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                2
                </td>
                <td style="font-weight:700;">
               Source of Seed
                </td>
                <td>
                 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                a
                </td>
                <td>
              Own Seed
                </td>
                <?php
            $own_seed = json_decode($data->own_seed, true);
            ?>
            
            <td>
                <?php echo e($own_seed['unit'] ?? ''); ?>

            </td>
            <td><?php echo e($own_seed['indicator'] ?? ''); ?></td>
            <td><?php echo e($own_seed['remark'] ?? ''); ?></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
                <td>
                Seed Purchase from Market
                </td>
                <?php
                $seed_purchase_from_market = json_decode($data->seed_purchase_from_market, true);
                ?>
                
                <td>
                    <?php echo e($seed_purchase_from_market['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($seed_purchase_from_market['indicator'] ?? ''); ?></td>
                <td><?php echo e($seed_purchase_from_market['remark'] ?? ''); ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                c
                </td>
                <td>
                Any other source
                </td>
                <?php
                $any_other_source = json_decode($data->any_other_source, true);
                ?>
                
                <td>
                    <?php echo e($any_other_source['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($any_other_source['indicator'] ?? ''); ?></td>
                <td><?php echo e($any_other_source['remark'] ?? ''); ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                3
                </td>
                <td>
                Source : Distance from farm (KM) 
                </td>
               <?php
                $source_distance_km = json_decode($data->source_distance_km, true);
                ?>
                
                <td>
                    <?php echo e($source_distance_km['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($source_distance_km['indicator'] ?? ''); ?></td>
                <td><?php echo e($source_distance_km['remark'] ?? ''); ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                4
                </td>
                <td>
                Any Other 
                </td>
               <?php
                $any_other = json_decode($data->any_other, true);
                ?>
                
                <td>
                    <?php echo e($any_other['unit'] ?? ''); ?>

                </td>
                <td><?php echo e($any_other['indicator'] ?? ''); ?></td>
                <td><?php echo e($any_other['remark'] ?? ''); ?></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
        </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
         
         <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
    <thead>
        <tr>
            <th>S. No</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Name of the input supplier / supporting value chain actor</th>
            <th>Adequacy</th>
            <th>quality</th>
            <th>Timely supply</th>
            <th>Effectiveness</th>
            <th>As per scientific recommendation (SOP) </th>
            <th>Price reasonability </th>
            <th>Is inputs on credit </th>
            <th>Difference in input price under with or without credit (%) </th>
            <th>Remark</th>
    </thead>

    <tr>
        <td colspan="5">
        </td>

        <td>Name</td>
        <td colspan="6" style="text-align:center; background-color:yellow; color:black; font-weight:700;">Rating as per
            given below matrix</td>
        <td>Y/N</td>
        <td>%</td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            1
        </td>
        <td></td>
        <td></td>
        <td>
            Seed
        </td>
       
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>


    <tr>
        <td style="text-align:center;">
            2
        </td>

        <td>
        </td>
        <td></td>
        <td>
            Plantlets
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            3
        </td>

        <td>

        </td>
        <td></td>
        <td>
            Fingerling (fishery)
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            4
        </td>

        <td></td>
        <td></td>
        <td>
            day old chick (Poultry)
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            5
        </td>

        <td></td>
        <td></td>
        <td>
            Feed
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            6
        </td>

        <td></td>
        <td></td>
        <td>
            Fertilizer
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            7
        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            Pesticides / Insecticide / Herbicides
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>


    <tr>
        <td style="text-align:center;">
            8
        </td>

        <td></td>
        <td></td>
        <td>
            Nutrients
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            9
        </td>

        <td></td>
        <td></td>
        <td>
            Medicine
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            10
        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            Labour
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            11
        </td>

        <td></td>
        <td></td>
        <td>
            Supply of diesel fuel / electricity
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            12
        </td>

        <td></td>
        <td></td>
        <td>
            Technology Transfer
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            13
        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            FM-Custom Hire Services
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            14
        </td>

        <td></td>
        <td></td>
        <td>
            Irrigation on Custom and Hiring
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>


    <tr>
        <td style="text-align:center;">
            15
        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            Source of Credit
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            a
        </td>

        <td></td>
        <td></td>
        <td>
            Input Credit
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            d
        </td>

        <td></td>
        <td></td>
        <td>
            Supply Credit
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            c
        </td>

        <td></td>
        <td></td>
        <td>
            Credit from NBSC
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            d
        </td>

        <td></td>
        <td></td>
        <td>
            Credit from Banks
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            e
        </td>

        <td></td>
        <td></td>
        <td>
            Other source/s
        </td>
        <td>
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            16
        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            Any Other Information
        </td>
        <td>
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            Rating
        </td>
        <td style="font-weight:700;">
            Assigned Number for filling rating
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td style="background-color: green;color:white">
            Strongly Agree
        </td>
        <td style="background-color: green;color:white">
            3
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td style="background-color: #66971b; color:white;">
            Agree
        </td>
        <td style="background-color: #66971b; color:white;">
            2
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td style="background-color:yellow; color:black">
            Satisfactory
        </td>
        <td style="background-color:yellow; color:black">
            1
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td style="background-color:#ff7300; color:white">
            Disagree
        </td>
        <td style="background-color:#ff7300; color:white">
            -2
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>

    </tr>

    <tr>
        <td style="text-align:center;">

        </td>
        <td>
        </td>
        <td>

        </td>
        <td style="background-color:red; color:white">
            Strongly Disagree
        </td>
        <td style="background-color:red; color:white">
            -3
        </td>
        <td></td>

        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td>
            Can not say
        </td>
        <td>
            0
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            S. No.
        </td>
        <td style="font-weight:700;">
            Particulars
        </td>
        <td>
            Unit
        </td>
        <td>Indicator</td>
        <td>Remark</td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            1
        </td>
        <td>
            Type of seed used
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            a
        </td>
        <td>
            Foundation Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            b
        </td>
        <td>
            Breeder Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            c
        </td>
        <td>
            Certified Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            d
        </td>
        <td>
            Other Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            e
        </td>
        <td>
            Brand of Seed
        </td>
        <td>
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            2
        </td>
        <td style="font-weight:700;">
            Source of Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            a
        </td>
        <td>
            Own Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            b
        </td>
        <td>
            Seed Purchase from Market
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            c
        </td>
        <td>
            Any other source
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            3
        </td>
        <td>
            Source : Distance from farm (KM)
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            4
        </td>
        <td>
            Any Other
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

</table>

        <?php endif; ?>
    </div>


    <div class="table-responsive mt-5">
        
       
        
    </div>

</div>
<script>
        document.getElementById('filterBtn').addEventListener('click', function() {
            var selectedMonth = document.getElementById('month').value;
            var selectedYear = document.getElementById('year').value;
            var dataUrl = document.getElementById('filterBtn').getAttribute('data-url'); 
            var url = dataUrl;
            if (selectedMonth) {
                url += "?month=" + selectedMonth;
                if (selectedYear) {
                    url += "&year=" + selectedYear;
                }
            } else if (selectedYear) {
                url += "?year=" + selectedYear;
            }
            window.location.href = url;
        });
    </script>
    
    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-e.blade.php ENDPATH**/ ?>