<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            <?php if($deshboard == 1): ?>

            <?php else: ?>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date"
                        value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date"
                        placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>"
                        name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.four')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.f.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>"
                        class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            <?php endif; ?>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Forward Linkages</h1>
        </div>

        <?php if($data->isNotEmpty()): ?>
        <?php
        $si = 1;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
         <form>
        <?php echo csrf_field(); ?>
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
            <thead>
                <tr>
                    <th>S. No</th>
                    <th>FARMER ID</th>
                    <th>Farmer Name</th>
                    <th>Particulars</th>
                    <th>Unit</th>
                    <th>Farm Gate</th>
                    <th>Procurement Centre through MSP</th>
                    <th>Village Trader</th>
                    <th>Mandi (Wholesaler) </th>
                    <th>Processor</th>
                    <th>Distributor</th>
                    <th>Retailer </th>
                    <th>Consumer</th>
                    <th>Any other Institution </th>
            </thead>



            <tr>
                <td style="text-align:center;">
                    <?php echo e($si++); ?>

                </td>
                <td><?php echo e($datas->farmer_code_id); ?> </td>
                <td> <?php echo e($datas->farmer_first_name == 'null' ? '' : $datas->farmer_first_name.' '.$datas->farmer_last_name); ?>

                </td>
                <td>
                    Marketing channel (Purchaser)
                </td>
                <?php
                $marketingchannel = json_decode($datas->marketing_channel, true);
                ?>

                <td><input class=""
                        id="marketing_channel_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($marketingchannel['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $farm_gateValue = $marketingchannel['farm_gate'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $mspValue = $marketingchannel['msp'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($mspValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($mspValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $village_traderValue = $marketingchannel['village_trader'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($village_traderValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($village_traderValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $mandiValue = $marketingchannel['mandi'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($mandiValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($mandiValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $processorValue = $marketingchannel['processor'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($processorValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($processorValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $distributorValue = $marketingchannel['distributor'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($distributorValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($distributorValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $retailerValue = $marketingchannel['retailer'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($retailerValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($retailerValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $consumerValue = $marketingchannel['consumer'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($consumerValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($consumerValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="marketing_channel_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($marketingchannel['any_others'] ?? ''); ?>"></td>
            </tr>


            <tr>
                <td style="text-align:center;">
                    2
                </td>

                <td></td>
                <td></td>
                <td>
                    Distance of marketing channel from farm gate
                </td>
                <?php
                $marketingchanneldistance = json_decode($datas->marketing_channel_distance, true);
                ?>

                <td><input class=""
                        id="marketing_channel_distance_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($marketingchanneldistance['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $disfarm_gateValue = $marketingchanneldistance['farm_gate'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_distance_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($disfarm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($disfarm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $marketing_channel_distanceValue = $marketingchanneldistance['msp'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_distance_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($marketing_channel_distanceValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($marketing_channel_distanceValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $mavillage_trader = $marketingchanneldistance['village_trader'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_distance_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($mavillage_trader == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($mavillage_trader == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $distancemandi = $marketingchanneldistance['mandi'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_distance_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($distancemandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($distancemandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $distanceprocessor = $marketingchanneldistance['processor'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_distance_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($distanceprocessor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($distanceprocessor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>


                <td>
                    <?php
                    $distancedistributor = $marketingchanneldistance['distributor'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_distance_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($distancedistributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($distancedistributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $distanceretailer = $marketingchanneldistance['retailer'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_distance_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($distanceretailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($distanceretailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $distanconsumer = $marketingchanneldistance['consumer'] ?? '';
                    ?>
                    <select
                        id="marketing_channel_distance_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($distanconsumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($distanconsumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td><input class=""
                        id="marketing_channel_distance_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($marketingchanneldistance['any_others'] ?? ''); ?>"></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    3
                </td>

                <td></td>
                <td></td>
                <td>
                    Transportation
                </td>

                <?php
                $transportationmethod = json_decode($datas->transportation_method, true);
                ?>


                <td><input class=""
                        id="transportation_method_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($transportationmethod['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $tranfarm_gateValue = $transportationmethod['farm_gate'] ?? '';
                    ?>
                    <select
                        id="transportation_method_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($tranfarm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($tranfarm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $tranmspValue = $transportationmethod['msp'] ?? '';
                    ?>
                    <select
                        id="transportation_method_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($tranmspValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($tranmspValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $tranvillage_traderValue = $transportationmethod['village_trader'] ?? '';
                    ?>
                    <select
                        id="transportation_method_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($tranvillage_traderValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($tranvillage_traderValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>


                <td>
                    <?php
                    $tranmandiValue = $transportationmethod['mandi'] ?? '';
                    ?>
                    <select
                        id="transportation_method_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($tranmandiValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($tranmandiValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $tranprocessorValue = $transportationmethod['processor'] ?? '';
                    ?>
                    <select
                        id="transportation_method_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($tranprocessorValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($tranprocessorValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $trandistributorValue = $transportationmethod['distributor'] ?? '';
                    ?>
                    <select
                        id="transportation_method_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($trandistributorValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($trandistributorValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $tranretailerValue = $transportationmethod['retailer'] ?? '';
                    ?>
                    <select
                        id="transportation_method_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($tranretailerValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($tranretailerValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $tranconsumerValue = $transportationmethod['consumer'] ?? '';
                    ?>
                    <select
                        id="transportation_method_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($tranconsumerValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($tranconsumerValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td><input class=""
                        id="transportation_method_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($transportationmethod['any_others'] ?? ''); ?>"></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    4
                </td>

                <td></td>
                <td></td>
                <td>
                    Transport through
                </td>
                <?php
                $transportby = json_decode($datas->transport_by, true);
                ?>


                <td><input class=""
                        id="transport_by_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($transportby['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $transport_by_farm_gateValue = $transportby['farm_gate'] ?? '';
                    ?>
                    <select
                        id="transport_by_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_by_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_by_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_by_msp_Value = $transportby['msp'] ?? '';
                    ?>
                    <select
                        id="transport_by_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_by_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_by_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_by_village_trader_Value = $transportby['village_trader'] ?? '';
                    ?>
                    <select
                        id="transport_by_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_by_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($transport_by_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_by_mandi = $transportby['mandi'] ?? '';
                    ?>
                    <select
                        id="transport_by_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_by_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_by_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_by_processor = $transportby['processor'] ?? '';
                    ?>
                    <select
                        id="transport_by_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_by_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_by_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_by_distributor = $transportby['distributor'] ?? '';
                    ?>
                    <select
                        id="transport_by_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_by_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_by_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_by_retailer = $transportby['retailer'] ?? '';
                    ?>
                    <select
                        id="transport_by_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_by_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_by_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_by_consumer = $transportby['consumer'] ?? '';
                    ?>
                    <select
                        id="transport_by_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_by_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_by_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="transport_by_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($transportby['any_others'] ?? ''); ?>"></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    5
                </td>

                <td></td>
                <td></td>
                <td>
                    Transport Expenses / Charges
                </td>

                <?php
                $transportexpenses = json_decode($datas->transport_expenses, true);
                ?>
                <td><input class=""
                        id="transport_expenses_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($transportexpenses['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $transport_expenses_farm_gateValue = $transportexpenses['farm_gate'] ?? '';
                    ?>
                    <select
                        id="transport_expenses_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_expenses_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($transport_expenses_farm_gateValue == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_expenses_msp_Value = $transportexpenses['msp'] ?? '';
                    ?>
                    <select
                        id="transport_expenses_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_expenses_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_expenses_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_expenses_village_trader_Value = $transportexpenses['village_trader'] ?? '';
                    ?>
                    <select
                        id="transport_expenses_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_expenses_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>
                            Yes</option>
                        <option value="No" <?php echo e($transport_expenses_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_expenses_mandi = $transportexpenses['mandi'] ?? '';
                    ?>
                    <select
                        id="transport_expenses_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_expenses_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_expenses_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_expenses_processor = $transportexpenses['processor'] ?? '';
                    ?>
                    <select
                        id="transport_expenses_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_expenses_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_expenses_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_expenses_distributor = $transportexpenses['distributor'] ?? '';
                    ?>
                    <select
                        id="transport_expenses_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_expenses_distributor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($transport_expenses_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_expenses_retailer = $transportexpenses['retailer'] ?? '';
                    ?>
                    <select
                        id="transport_expenses_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_expenses_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_expenses_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $transport_expenses_consumer = $transportexpenses['consumer'] ?? '';
                    ?>
                    <select
                        id="transport_expenses_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($transport_expenses_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($transport_expenses_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="transport_expenses_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($transportexpenses['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    6
                </td>

                <td></td>
                <td></td>
                <td>
                    Who undertake primary Processing (Cleaning, Grading & Sorting)
                </td>
                <?php
                $primaryprocessing = json_decode($datas->primary_processing, true);
                ?>


                <td><input class=""
                        id="primary_processing_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($primaryprocessing['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $primary_processing_farm_gateValue = $primaryprocessing['farm_gate'] ?? '';
                    ?>
                    <select
                        id="primary_processing_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($primary_processing_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($primary_processing_farm_gateValue == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $primary_processing_msp_Value = $primaryprocessing['msp'] ?? '';
                    ?>
                    <select
                        id="primary_processing_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($primary_processing_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($primary_processing_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $primary_processing_village_trader_Value = $primaryprocessing['village_trader'] ?? '';
                    ?>
                    <select
                        id="primary_processing_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($primary_processing_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>
                            Yes</option>
                        <option value="No" <?php echo e($primary_processing_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $primary_processing_mandi = $primaryprocessing['mandi'] ?? '';
                    ?>
                    <select
                        id="primary_processing_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($primary_processing_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($primary_processing_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $primary_processing_processor = $primaryprocessing['processor'] ?? '';
                    ?>
                    <select
                        id="primary_processing_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($primary_processing_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($primary_processing_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $primary_processing_distributor = $primaryprocessing['distributor'] ?? '';
                    ?>
                    <select
                        id="primary_processing_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($primary_processing_distributor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($primary_processing_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $primary_processing_retailer = $primaryprocessing['retailer'] ?? '';
                    ?>
                    <select
                        id="primary_processing_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($primary_processing_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($primary_processing_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $primary_processing_consumer = $primaryprocessing['consumer'] ?? '';
                    ?>
                    <select
                        id="primary_processing_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($primary_processing_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($primary_processing_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="primary_processing_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($primaryprocessing['any_others'] ?? ''); ?>"></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    7
                </td>


                <td></td>
                <td></td>
                <td>
                    Whether any assured buyer/institution present?
                </td>
                <?php
                $buyerinstitutionpresent = json_decode($datas->buyer_institution_present, true);
                ?>


                <td><input class=""
                        id="buyer_institution_present_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($buyerinstitutionpresent['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $buyer_institution_present_farm_gateValue = $buyerinstitutionpresent['farm_gate'] ?? '';
                    ?>
                    <select
                        id="buyer_institution_present_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($buyer_institution_present_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>
                            Yes</option>
                        <option value="No" <?php echo e($buyer_institution_present_farm_gateValue == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $buyer_institution_present_msp_Value = $buyerinstitutionpresent['msp'] ?? '';
                    ?>
                    <select
                        id="buyer_institution_present_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($buyer_institution_present_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($buyer_institution_present_msp_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $buyer_institution_present_village_trader_Value = $buyerinstitutionpresent['village_trader'] ?? '';
                    ?>
                    <select
                        id="buyer_institution_present_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes"
                            <?php echo e($buyer_institution_present_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No"
                            <?php echo e($buyer_institution_present_village_trader_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $buyer_institution_present_mandi = $buyerinstitutionpresent['mandi'] ?? '';
                    ?>
                    <select
                        id="buyer_institution_present_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($buyer_institution_present_mandi == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($buyer_institution_present_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $buyer_institution_present_processor = $buyerinstitutionpresent['processor'] ?? '';
                    ?>
                    <select
                        id="buyer_institution_present_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($buyer_institution_present_processor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($buyer_institution_present_processor == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $buyer_institution_present_distributor = $buyerinstitutionpresent['distributor'] ?? '';
                    ?>
                    <select
                        id="buyer_institution_present_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($buyer_institution_present_distributor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($buyer_institution_present_distributor == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $buyer_institution_present_retailer = $buyerinstitutionpresent['retailer'] ?? '';
                    ?>
                    <select
                        id="buyer_institution_present_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($buyer_institution_present_retailer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($buyer_institution_present_retailer == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $buyer_institution_present_consumer = $buyerinstitutionpresent['consumer'] ?? '';
                    ?>
                    <select
                        id="buyer_institution_present_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($buyer_institution_present_consumer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($buyer_institution_present_consumer == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>
                <td><input class=""
                        id="buyer_institution_present_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($buyerinstitutionpresent['any_others'] ?? ''); ?>"></td>
            </tr>


            <tr>
                <td style="text-align:center;">
                    8
                </td>

                <td></td>
                <td></td>
                <td>
                    Whether any form of formal or informal contract farming is being practiced by the farmer?
                </td>
                <?php
                $formalinformalcontract = json_decode($datas->formal_informal_contract, true);
                ?>


                <td><input class=""
                        id="formal_informal_contract_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($formalinformalcontract['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $formal_informal_contract_farm_gateValue = $formalinformalcontract['farm_gate'] ?? '';
                    ?>
                    <select
                        id="formal_informal_contract_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($formal_informal_contract_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>
                            Yes</option>
                        <option value="No" <?php echo e($formal_informal_contract_farm_gateValue == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $formal_informal_contract_msp_Value = $formalinformalcontract['msp'] ?? '';
                    ?>
                    <select
                        id="formal_informal_contract_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($formal_informal_contract_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($formal_informal_contract_msp_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $formal_informal_contract_village_trader_Value = $formalinformalcontract['village_trader'] ?? '';
                    ?>
                    <select
                        id="formal_informal_contract_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes"
                            <?php echo e($formal_informal_contract_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No"
                            <?php echo e($formal_informal_contract_village_trader_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $formal_informal_contract_mandi = $formalinformalcontract['mandi'] ?? '';
                    ?>
                    <select
                        id="formal_informal_contract_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($formal_informal_contract_mandi == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($formal_informal_contract_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $formal_informal_contract_processor = $formalinformalcontract['processor'] ?? '';
                    ?>
                    <select
                        id="formal_informal_contract_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($formal_informal_contract_processor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($formal_informal_contract_processor == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $formal_informal_contract_distributor = $formalinformalcontract['distributor'] ?? '';
                    ?>
                    <select
                        id="formal_informal_contract_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($formal_informal_contract_distributor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($formal_informal_contract_distributor == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $formal_informal_contract_retailer = $formalinformalcontract['retailer'] ?? '';
                    ?>
                    <select
                        id="formal_informal_contract_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($formal_informal_contract_retailer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($formal_informal_contract_retailer == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $formal_informal_contract_consumer = $formalinformalcontract['consumer'] ?? '';
                    ?>
                    <select
                        id="formal_informal_contract_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($formal_informal_contract_consumer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($formal_informal_contract_consumer == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>
                <td><input class=""
                        id="formal_informal_contract_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($formalinformalcontract['any_others'] ?? ''); ?>"></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    9
                </td>

                <td></td>
                <td></td>
                <td>
                    Presence of Niche Market (big hotels/residential institutions near the farm gate).
                </td>
                <?php
                $nichemarket = json_decode($datas->niche_market, true);
                ?>


                <td><input class=""
                        id="niche_market_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($nichemarket['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $niche_market_farm_gateValue = $nichemarket['farm_gate'] ?? '';
                    ?>
                    <select
                        id="niche_market_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($niche_market_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($niche_market_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $niche_market_msp_Value = $nichemarket['msp'] ?? '';
                    ?>
                    <select
                        id="niche_market_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($niche_market_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($niche_market_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $niche_market_village_trader_Value = $nichemarket['village_trader'] ?? '';
                    ?>
                    <select
                        id="niche_market_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($niche_market_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($niche_market_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $niche_market_mandi = $nichemarket['mandi'] ?? '';
                    ?>
                    <select
                        id="niche_market_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($niche_market_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($niche_market_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $niche_market_processor = $nichemarket['processor'] ?? '';
                    ?>
                    <select
                        id="niche_market_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($niche_market_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($niche_market_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $niche_market_distributor = $nichemarket['distributor'] ?? '';
                    ?>
                    <select
                        id="niche_market_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($niche_market_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($niche_market_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $niche_market_retailer = $nichemarket['retailer'] ?? '';
                    ?>
                    <select
                        id="niche_market_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($niche_market_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($niche_market_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $niche_market_consumer = $nichemarket['consumer'] ?? '';
                    ?>
                    <select
                        id="niche_market_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($niche_market_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($niche_market_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="niche_market_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($nichemarket['any_others'] ?? ''); ?>"></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    10
                </td>

                <td></td>
                <td></td>
                <td style="font-weight:700;">
                    Whether secondary processing being undertaken presently (value addition, packaging, marketing, etc.)
                </td>
                <?php
                $secondaryprocessing = json_decode($datas->secondary_processing, true);
                ?>
               

                <td><input class=""
                        id="secondary_processing_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($secondaryprocessing['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $secondary_processing_farm_gateValue = $secondaryprocessing['farm_gate'] ?? '';
                    ?>
                    <select
                        id="secondary_processing_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($secondary_processing_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($secondary_processing_farm_gateValue == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $secondary_processing_msp_Value = $secondaryprocessing['msp'] ?? '';
                    ?>
                    <select
                        id="secondary_processing_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($secondary_processing_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($secondary_processing_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $secondary_processing_village_trader_Value = $secondaryprocessing['village_trader'] ?? '';
                    ?>
                    <select
                        id="secondary_processing_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($secondary_processing_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>
                            Yes</option>
                        <option value="No" <?php echo e($secondary_processing_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $secondary_processing_mandi = $secondaryprocessing['mandi'] ?? '';
                    ?>
                    <select
                        id="secondary_processing_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($secondary_processing_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($secondary_processing_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $secondary_processing_processor = $secondaryprocessing['processor'] ?? '';
                    ?>
                    <select
                        id="secondary_processing_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($secondary_processing_processor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($secondary_processing_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $secondary_processing_distributor = $secondaryprocessing['distributor'] ?? '';
                    ?>
                    <select
                        id="secondary_processing_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($secondary_processing_distributor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($secondary_processing_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $secondary_processing_retailer = $secondaryprocessing['retailer'] ?? '';
                    ?>
                    <select
                        id="secondary_processing_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($secondary_processing_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($secondary_processing_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $secondary_processing_consumer = $secondaryprocessing['consumer'] ?? '';
                    ?>
                    <select
                        id="secondary_processing_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($secondary_processing_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($secondary_processing_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="secondary_processing_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($secondaryprocessing['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    11
                </td>

                <td></td>
                <td></td>
                <td>
                    Presence of any processing plant or food enterprise in the vicinity of farm gate
                </td>
                <?php
                $processinginvicinity = json_decode($datas->processing_in_vicinity, true);
                ?>


                <td><input class=""
                        id="processing_in_vicinity_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($processinginvicinity['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $processing_in_vicinity_farm_gateValue = $processinginvicinity['farm_gate'] ?? '';
                    ?>
                    <select
                        id="processing_in_vicinity_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($processing_in_vicinity_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($processing_in_vicinity_farm_gateValue == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $processing_in_vicinity_msp_Value = $processinginvicinity['msp'] ?? '';
                    ?>
                    <select
                        id="processing_in_vicinity_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($processing_in_vicinity_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($processing_in_vicinity_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $processing_in_vicinity_village_trader_Value = $processinginvicinity['village_trader'] ?? '';
                    ?>
                    <select
                        id="processing_in_vicinity_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes"
                            <?php echo e($processing_in_vicinity_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($processing_in_vicinity_village_trader_Value == 'No' ? 'selected' : ''); ?>>
                            No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $processing_in_vicinity_mandi = $processinginvicinity['mandi'] ?? '';
                    ?>
                    <select
                        id="processing_in_vicinity_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($processing_in_vicinity_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($processing_in_vicinity_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $processing_in_vicinity_processor = $processinginvicinity['processor'] ?? '';
                    ?>
                    <select
                        id="processing_in_vicinity_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($processing_in_vicinity_processor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($processing_in_vicinity_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $processing_in_vicinity_distributor = $processinginvicinity['distributor'] ?? '';
                    ?>
                    <select
                        id="processing_in_vicinity_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($processing_in_vicinity_distributor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($processing_in_vicinity_distributor == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $processing_in_vicinity_retailer = $processinginvicinity['retailer'] ?? '';
                    ?>
                    <select
                        id="processing_in_vicinity_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($processing_in_vicinity_retailer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($processing_in_vicinity_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $processing_in_vicinity_consumer = $processinginvicinity['consumer'] ?? '';
                    ?>
                    <select
                        id="processing_in_vicinity_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($processing_in_vicinity_consumer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($processing_in_vicinity_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="processing_in_vicinity_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($processinginvicinity['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    12
                </td>

                <td></td>
                <td></td>
                <td>
                    Whether Storage facility available?
                </td>
                <?php
                $storagefacility = json_decode($datas->storage_facility, true);
                ?>


                <td><input class=""
                        id="storage_facility_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($storagefacility['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $storage_facility_farm_gateValue = $storagefacility['farm_gate'] ?? '';
                    ?>
                    <select
                        id="storage_facility_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_facility_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($storage_facility_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_facility_msp_Value = $storagefacility['msp'] ?? '';
                    ?>
                    <select
                        id="storage_facility_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_facility_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_facility_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_facility_village_trader_Value = $storagefacility['village_trader'] ?? '';
                    ?>
                    <select
                        id="storage_facility_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_facility_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($storage_facility_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_facility_mandi = $storagefacility['mandi'] ?? '';
                    ?>
                    <select
                        id="storage_facility_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_facility_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_facility_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_facility_processor = $storagefacility['processor'] ?? '';
                    ?>
                    <select
                        id="storage_facility_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_facility_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_facility_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_facility_distributor = $storagefacility['distributor'] ?? '';
                    ?>
                    <select
                        id="storage_facility_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_facility_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_facility_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_facility_retailer = $storagefacility['retailer'] ?? '';
                    ?>
                    <select
                        id="storage_facility_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_facility_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_facility_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_facility_consumer = $storagefacility['consumer'] ?? '';
                    ?>
                    <select
                        id="storage_facility_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_facility_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_facility_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="storage_facility_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($storagefacility['any_others'] ?? ''); ?>"></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    13
                </td>


                <td></td>
                <td></td>
                <td>
                    Grain Storage / Cold Storage / Controlled Atmospheric Storage
                </td>
                <?php
                $storage = json_decode($datas->storage, true);
                ?>
                <td><input class=""
                        id="storage_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($storage['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $storage_farm_gateValue = $storage['farm_gate'] ?? '';
                    ?>
                    <select
                        id="storage_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_msp_Value = $storage['msp'] ?? '';
                    ?>
                    <select
                        id="storage_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_village_trader_Value = $storage['village_trader'] ?? '';
                    ?>
                    <select
                        id="storage_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_village_trader_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_mandi = $storage['mandi'] ?? '';
                    ?>
                    <select
                        id="storage_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_processor = $storage['processor'] ?? '';
                    ?>
                    <select
                        id="storage_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_distributor = $storage['distributor'] ?? '';
                    ?>
                    <select
                        id="storage_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_retailer = $storage['retailer'] ?? '';
                    ?>
                    <select
                        id="storage_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_consumer = $storage['consumer'] ?? '';
                    ?>
                    <select
                        id="storage_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="storage_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($storage['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    14
                </td>

                <td></td>
                <td></td>
                <td>
                    If yes, capacity of the facility?
                </td>

                <?php
                $facilitycapacitydd = json_decode($datas->facility_capacity, true);
                ?>
                <td><input class=""
                        id="facility_capacity_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($facilitycapacitydd['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $facility_capacity_farm_gateValued = $facilitycapacitydd['farm_gate'] ?? '';
                    ?>
                    <select
                        id="facility_capacity_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($facility_capacity_farm_gateValued == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($facility_capacity_farm_gateValued == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $facility_capacity_msp_Value = $facilitycapacitydd['msp'] ?? '';
                    ?>
                    <select
                        id="facility_capacity_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($facility_capacity_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($facility_capacity_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $facility_capacity_village_trader_Value = $facilitycapacitydd['village_trader'] ?? '';
                    ?>
                    <select
                        id="facility_capacity_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($facility_capacity_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($facility_capacity_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $facility_capacity_mandi = $facilitycapacitydd['mandi'] ?? '';
                    ?>
                    <select
                        id="facility_capacity_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($facility_capacity_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($facility_capacity_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $facility_capacity_processor = $facilitycapacitydd['processor'] ?? '';
                    ?>
                    <select
                        id="facility_capacity_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($facility_capacity_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($facility_capacity_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $facility_capacity_distributor = $facilitycapacitydd['distributor'] ?? '';
                    ?>
                    <select
                        id="facility_capacity_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($facility_capacity_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($facility_capacity_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $facility_capacity_retailer = $facilitycapacitydd['retailer'] ?? '';
                    ?>
                    <select
                        id="facility_capacity_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($facility_capacity_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($facility_capacity_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $facility_capacity_consumer = $facilitycapacitydd['consumer'] ?? '';
                    ?>
                    <select
                        id="facility_capacity_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($facility_capacity_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($facility_capacity_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="facility_capacity_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($facilitycapacitydd['any_others'] ?? ''); ?>"></td>
            </tr>


            <tr>
                <td style="text-align:center;">
                    15
                </td>


                <td></td>
                <td></td>
                <td>
                    Charges for storage / cold storage / bulk cooling system / any other preservation system
                </td>
                <?php
                $storagecharges = json_decode($datas->storage_charges, true);
                ?>
                <td><input class=""
                        id="storage_charges_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($storagecharges['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $storage_charges_farm_gateValue = $storagecharges['farm_gate'] ?? '';
                    ?>
                    <select
                        id="storage_charges_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_charges_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($storage_charges_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_charges_msp_Value = $storagecharges['msp'] ?? '';
                    ?>
                    <select
                        id="storage_charges_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_charges_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_charges_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_charges_village_trader_Value = $storagecharges['village_trader'] ?? '';
                    ?>
                    <select
                        id="storage_charges_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_charges_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($storage_charges_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_charges_mandi = $storagecharges['mandi'] ?? '';
                    ?>
                    <select
                        id="storage_charges_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_charges_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_charges_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_charges_processor = $storagecharges['processor'] ?? '';
                    ?>
                    <select
                        id="storage_charges_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_charges_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_charges_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_charges_distributor = $storagecharges['distributor'] ?? '';
                    ?>
                    <select
                        id="storage_charges_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_charges_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_charges_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_charges_retailer = $storagecharges['retailer'] ?? '';
                    ?>
                    <select
                        id="storage_charges_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_charges_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_charges_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_charges_consumer = $storagecharges['consumer'] ?? '';
                    ?>
                    <select
                        id="storage_charges_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_charges_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_charges_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="storage_charges_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($storagecharges['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    16
                </td>

                <td></td>
                <td></td>

                <td>
                    Storage Duration
                </td>
                <?php
                $storage_duretion = json_decode($datas->storage_duretion, true);
                ?>
                <td><input class=""
                        id="storage_duretion_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($storage_duretion['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $storage_duretion_farm_gateValue = $storage_duretion['farm_gate'] ?? '';
                    ?>
                    <select
                        id="storage_duretion_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_duretion_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($storage_duretion_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_duretion_msp_Value = $storage_duretion['msp'] ?? '';
                    ?>
                    <select
                        id="storage_duretion_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_duretion_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_duretion_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_duretion_village_trader_Value = $storage_duretion['village_trader'] ?? '';
                    ?>
                    <select
                        id="storage_duretion_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_duretion_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($storage_duretion_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_duretion_mandi = $storage_duretion['mandi'] ?? '';
                    ?>
                    <select
                        id="storage_duretion_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_duretion_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_duretion_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_duretion_processor = $storage_duretion['processor'] ?? '';
                    ?>
                    <select
                        id="storage_duretion_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_duretion_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_duretion_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_duretion_distributor = $storage_duretion['distributor'] ?? '';
                    ?>
                    <select
                        id="storage_duretion_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_duretion_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_duretion_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_duretion_retailer = $storage_duretion['retailer'] ?? '';
                    ?>
                    <select
                        id="storage_duretion_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_duretion_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_duretion_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $storage_duretion_consumer = $storage_duretion['consumer'] ?? '';
                    ?>
                    <select
                        id="storage_duretion_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($storage_duretion_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($storage_duretion_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="storage_duretion_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($storage_duretion['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    17
                </td>

                <td></td>
                <td></td>
                <td>
                    Time of sale of produce after harvesting
                </td>

                <?php
                $timeofsale = json_decode($datas->time_of_sale, true);
                ?>
                <td><input class=""
                        id="time_of_sale_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($timeofsale['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $time_of_sale_farm_gateValue = $timeofsale['farm_gate'] ?? '';
                    ?>
                    <select
                        id="time_of_sale_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($time_of_sale_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($time_of_sale_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $time_of_sale_msp_Value = $timeofsale['msp'] ?? '';
                    ?>
                    <select
                        id="time_of_sale_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($time_of_sale_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($time_of_sale_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $time_of_sale_village_trader_Value = $timeofsale['village_trader'] ?? '';
                    ?>
                    <select
                        id="time_of_sale_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($time_of_sale_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($time_of_sale_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $time_of_sale_mandi = $timeofsale['mandi'] ?? '';
                    ?>
                    <select
                        id="time_of_sale_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($time_of_sale_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($time_of_sale_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $time_of_sale_processor = $timeofsale['processor'] ?? '';
                    ?>
                    <select
                        id="time_of_sale_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($time_of_sale_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($time_of_sale_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $time_of_sale_distributor = $timeofsale['distributor'] ?? '';
                    ?>
                    <select
                        id="time_of_sale_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($time_of_sale_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($time_of_sale_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $time_of_sale_retailer = $timeofsale['retailer'] ?? '';
                    ?>
                    <select
                        id="time_of_sale_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($time_of_sale_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($time_of_sale_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $time_of_sale_consumer = $timeofsale['consumer'] ?? '';
                    ?>
                    <select
                        id="time_of_sale_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($time_of_sale_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($time_of_sale_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="time_of_sale_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($timeofsale['any_others'] ?? ''); ?>"></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    18
                </td>

                <td></td>
                <td></td>
                <td>
                    Type of road connectivity to farm gate
                </td>

                <?php
                $roadconnectivity = json_decode($datas->road_connectivity, true);
                ?>
                <td><input class=""
                        id="road_connectivity_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($roadconnectivity['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $road_connectivity_farm_gateValue = $roadconnectivity['farm_gate'] ?? '';
                    ?>
                    <select
                        id="road_connectivity_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($road_connectivity_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($road_connectivity_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $road_connectivity_msp_Value = $roadconnectivity['msp'] ?? '';
                    ?>
                    <select
                        id="road_connectivity_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($road_connectivity_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($road_connectivity_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $road_connectivity_village_trader_Value = $roadconnectivity['village_trader'] ?? '';
                    ?>
                    <select
                        id="road_connectivity_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($road_connectivity_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($road_connectivity_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $road_connectivity_mandi = $roadconnectivity['mandi'] ?? '';
                    ?>
                    <select
                        id="road_connectivity_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($road_connectivity_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($road_connectivity_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $road_connectivity_processor = $roadconnectivity['processor'] ?? '';
                    ?>
                    <select
                        id="road_connectivity_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($road_connectivity_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($road_connectivity_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $road_connectivity_distributor = $roadconnectivity['distributor'] ?? '';
                    ?>
                    <select
                        id="road_connectivity_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($road_connectivity_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($road_connectivity_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $road_connectivity_retailer = $roadconnectivity['retailer'] ?? '';
                    ?>
                    <select
                        id="road_connectivity_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($road_connectivity_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($road_connectivity_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $road_connectivity_consumer = $roadconnectivity['consumer'] ?? '';
                    ?>
                    <select
                        id="road_connectivity_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($road_connectivity_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($road_connectivity_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="road_connectivity_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($roadconnectivity['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    19
                </td>

                <td></td>
                <td></td>
                <td>
                    Payment of sale proceed
                </td>
                <?php
                $paymentofsale = json_decode($datas->payment_of_sale, true);
                ?>
                <td><input class=""
                        id="payment_of_sale_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($paymentofsale['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $payment_of_sale_farm_gateValue = $paymentofsale['farm_gate'] ?? '';
                    ?>
                    <select
                        id="payment_of_sale_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($payment_of_sale_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($payment_of_sale_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $payment_of_sale_msp_Value = $paymentofsale['msp'] ?? '';
                    ?>
                    <select
                        id="payment_of_sale_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($payment_of_sale_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($payment_of_sale_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $payment_of_sale_village_trader_Value = $paymentofsale['village_trader'] ?? '';
                    ?>
                    <select
                        id="payment_of_sale_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($payment_of_sale_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($payment_of_sale_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $payment_of_sale_mandi = $paymentofsale['mandi'] ?? '';
                    ?>
                    <select
                        id="payment_of_sale_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($payment_of_sale_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($payment_of_sale_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $payment_of_sale_processor = $paymentofsale['processor'] ?? '';
                    ?>
                    <select
                        id="payment_of_sale_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($payment_of_sale_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($payment_of_sale_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $payment_of_sale_distributor = $paymentofsale['distributor'] ?? '';
                    ?>
                    <select
                        id="payment_of_sale_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($payment_of_sale_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($payment_of_sale_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $payment_of_sale_retailer = $paymentofsale['retailer'] ?? '';
                    ?>
                    <select
                        id="payment_of_sale_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($payment_of_sale_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($payment_of_sale_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $payment_of_sale_consumer = $paymentofsale['consumer'] ?? '';
                    ?>
                    <select
                        id="payment_of_sale_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($payment_of_sale_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($payment_of_sale_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="payment_of_sale_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($paymentofsale['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    20
                </td>

                <td></td>
                <td></td>
                <td>
                    Extent of default of Payment of total sale value
                </td>

                <?php
                $totalsalevalue = json_decode($datas->total_sale_value, true);
                ?>
                <td><input class=""
                        id="total_sale_value_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($totalsalevalue['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $total_sale_value_farm_gateValue = $totalsalevalue['farm_gate'] ?? '';
                    ?>
                    <select
                        id="total_sale_value_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_sale_value_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($total_sale_value_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_sale_value_msp_Value = $totalsalevalue['msp'] ?? '';
                    ?>
                    <select
                        id="total_sale_value_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_sale_value_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($total_sale_value_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_sale_value_village_trader_Value = $totalsalevalue['village_trader'] ?? '';
                    ?>
                    <select
                        id="total_sale_value_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_sale_value_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($total_sale_value_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_sale_value_mandi = $totalsalevalue['mandi'] ?? '';
                    ?>
                    <select
                        id="total_sale_value_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_sale_value_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($total_sale_value_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_sale_value_processor = $totalsalevalue['processor'] ?? '';
                    ?>
                    <select
                        id="total_sale_value_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_sale_value_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($total_sale_value_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_sale_value_distributor = $totalsalevalue['distributor'] ?? '';
                    ?>
                    <select
                        id="total_sale_value_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_sale_value_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($total_sale_value_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_sale_value_retailer = $totalsalevalue['retailer'] ?? '';
                    ?>
                    <select
                        id="total_sale_value_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_sale_value_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($total_sale_value_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_sale_value_consumer = $totalsalevalue['consumer'] ?? '';
                    ?>
                    <select
                        id="total_sale_value_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_sale_value_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($total_sale_value_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="total_sale_value_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($totalsalevalue['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    21
                </td>


                <td></td>
                <td></td>
                <td>
                    Weighing Method
                </td>
                <?php
                $weighingmethod = json_decode($datas->weighing_method, true);
                ?>
                <td><input class=""
                        id="weighing_method_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($weighingmethod['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $weighing_method_farm_gateValue = $weighingmethod['farm_gate'] ?? '';
                    ?>
                    <select
                        id="weighing_method_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($weighing_method_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($weighing_method_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $weighing_method_msp_Value = $weighingmethod['msp'] ?? '';
                    ?>
                    <select
                        id="weighing_method_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($weighing_method_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($weighing_method_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $weighing_method_village_trader_Value = $weighingmethod['village_trader'] ?? '';
                    ?>
                    <select
                        id="weighing_method_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($weighing_method_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($weighing_method_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $weighing_method_mandi = $weighingmethod['mandi'] ?? '';
                    ?>
                    <select
                        id="weighing_method_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($weighing_method_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($weighing_method_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $weighing_method_processor = $weighingmethod['processor'] ?? '';
                    ?>
                    <select
                        id="weighing_method_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($weighing_method_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($weighing_method_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $weighing_method_distributor = $weighingmethod['distributor'] ?? '';
                    ?>
                    <select
                        id="weighing_method_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($weighing_method_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($weighing_method_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $weighing_method_retailer = $weighingmethod['retailer'] ?? '';
                    ?>
                    <select
                        id="weighing_method_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($weighing_method_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($weighing_method_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $weighing_method_consumer = $weighingmethod['consumer'] ?? '';
                    ?>
                    <select
                        id="weighing_method_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($weighing_method_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($weighing_method_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="weighing_method_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($weighingmethod['any_others'] ?? ''); ?>"></td>

            </tr>



            <tr>
                <td style="text-align:center;">
                    22
                </td>

                <td></td>
                <td></td>
                <td>
                    Extent of under weighing of whole proceed
                </td>
                <?php
                $extentofunderweighing = json_decode($datas->extent_of_under_weighing, true);
                ?>
                <td><input class=""
                        id="extent_of_under_weighing_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($extentofunderweighing['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $extent_of_under_weighing_farm_gateValue = $extentofunderweighing['farm_gate'] ?? '';
                    ?>
                    <select
                        id="extent_of_under_weighing_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_under_weighing_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>
                            Yes</option>
                        <option value="No" <?php echo e($extent_of_under_weighing_farm_gateValue == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_under_weighing_msp_Value = $extentofunderweighing['msp'] ?? '';
                    ?>
                    <select
                        id="extent_of_under_weighing_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_under_weighing_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($extent_of_under_weighing_msp_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_under_weighing_village_trader_Value = $extentofunderweighing['village_trader'] ?? '';
                    ?>
                    <select
                        id="extent_of_under_weighing_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes"
                            <?php echo e($extent_of_under_weighing_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No"
                            <?php echo e($extent_of_under_weighing_village_trader_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_under_weighing_mandi = $extentofunderweighing['mandi'] ?? '';
                    ?>
                    <select
                        id="extent_of_under_weighing_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_under_weighing_mandi == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($extent_of_under_weighing_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_under_weighing_processor = $extentofunderweighing['processor'] ?? '';
                    ?>
                    <select
                        id="extent_of_under_weighing_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_under_weighing_processor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($extent_of_under_weighing_processor == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_under_weighing_distributor = $extentofunderweighing['distributor'] ?? '';
                    ?>
                    <select
                        id="extent_of_under_weighing_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_under_weighing_distributor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($extent_of_under_weighing_distributor == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_under_weighing_retailer = $extentofunderweighing['retailer'] ?? '';
                    ?>
                    <select
                        id="extent_of_under_weighing_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_under_weighing_retailer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($extent_of_under_weighing_retailer == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_under_weighing_consumer = $extentofunderweighing['consumer'] ?? '';
                    ?>
                    <select
                        id="extent_of_under_weighing_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_under_weighing_consumer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($extent_of_under_weighing_consumer == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>
                <td><input class=""
                        id="extent_of_under_weighing_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($extentofunderweighing['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    23
                </td>

                <td></td>
                <td></td>
                <td>
                    Source of Market Information (Demand / Price etc.)
                </td>
                <?php
                $source_of_market_info = json_decode($datas->source_of_market_info, true);
                ?>
                <td><input class=""
                        id="source_of_market_info_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($source_of_market_info['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $source_of_market_info_farm_gateValue = $source_of_market_info['farm_gate'] ?? '';
                    ?>
                    <select
                        id="source_of_market_info_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($source_of_market_info_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($source_of_market_info_farm_gateValue == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $source_of_market_info_msp_Value = $source_of_market_info['msp'] ?? '';
                    ?>
                    <select
                        id="source_of_market_info_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($source_of_market_info_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($source_of_market_info_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $source_of_market_info_village_trader_Value = $source_of_market_info['village_trader'] ?? '';
                    ?>
                    <select
                        id="source_of_market_info_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes"
                            <?php echo e($source_of_market_info_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($source_of_market_info_village_trader_Value == 'No' ? 'selected' : ''); ?>>
                            No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $source_of_market_info_mandi = $source_of_market_info['mandi'] ?? '';
                    ?>
                    <select
                        id="source_of_market_info_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($source_of_market_info_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($source_of_market_info_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $source_of_market_info_processor = $source_of_market_info['processor'] ?? '';
                    ?>
                    <select
                        id="source_of_market_info_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($source_of_market_info_processor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($source_of_market_info_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $source_of_market_info_distributor = $source_of_market_info['distributor'] ?? '';
                    ?>
                    <select
                        id="source_of_market_info_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($source_of_market_info_distributor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($source_of_market_info_distributor == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $source_of_market_info_retailer = $source_of_market_info['retailer'] ?? '';
                    ?>
                    <select
                        id="source_of_market_info_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($source_of_market_info_retailer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($source_of_market_info_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $source_of_market_info_consumer = $source_of_market_info['consumer'] ?? '';
                    ?>
                    <select
                        id="source_of_market_info_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($source_of_market_info_consumer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($source_of_market_info_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="source_of_market_info_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($source_of_market_info['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    24
                </td>

                <td></td>
                <td></td>
                <td>
                    Percentage of sale of total marketable surplus through MSP
                </td>

                <?php
                $totalmarketablesurplus = json_decode($datas->total_marketable_surplus, true);
                ?>
                <td><input class=""
                        id="total_marketable_surplus_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($totalmarketablesurplus['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $total_marketable_surplus_farm_gateValue = $totalmarketablesurplus['farm_gate'] ?? '';
                    ?>
                    <select
                        id="total_marketable_surplus_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_marketable_surplus_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>
                            Yes</option>
                        <option value="No" <?php echo e($total_marketable_surplus_farm_gateValue == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_marketable_surplus_msp_Value = $totalmarketablesurplus['msp'] ?? '';
                    ?>
                    <select
                        id="total_marketable_surplus_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_marketable_surplus_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($total_marketable_surplus_msp_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_marketable_surplus_village_trader_Value = $totalmarketablesurplus['village_trader'] ?? '';
                    ?>
                    <select
                        id="total_marketable_surplus_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes"
                            <?php echo e($total_marketable_surplus_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No"
                            <?php echo e($total_marketable_surplus_village_trader_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_marketable_surplus_mandi = $totalmarketablesurplus['mandi'] ?? '';
                    ?>
                    <select
                        id="total_marketable_surplus_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_marketable_surplus_mandi == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($total_marketable_surplus_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_marketable_surplus_processor = $totalmarketablesurplus['processor'] ?? '';
                    ?>
                    <select
                        id="total_marketable_surplus_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_marketable_surplus_processor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($total_marketable_surplus_processor == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_marketable_surplus_distributor = $totalmarketablesurplus['distributor'] ?? '';
                    ?>
                    <select
                        id="total_marketable_surplus_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_marketable_surplus_distributor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($total_marketable_surplus_distributor == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_marketable_surplus_retailer = $totalmarketablesurplus['retailer'] ?? '';
                    ?>
                    <select
                        id="total_marketable_surplus_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_marketable_surplus_retailer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($total_marketable_surplus_retailer == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $total_marketable_surplus_consumer = $totalmarketablesurplus['consumer'] ?? '';
                    ?>
                    <select
                        id="total_marketable_surplus_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($total_marketable_surplus_consumer == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($total_marketable_surplus_consumer == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>
                <td><input class=""
                        id="total_marketable_surplus_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($totalmarketablesurplus['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    25
                </td>

                <td></td>
                <td></td>
                <td>
                    Is producer directly selling to MSP procurement agency or through mediator
                </td>
                <?php
                $sellingonmsp = json_decode($datas->selling_on_msp, true);
                ?>
                <td><input class=""
                        id="selling_on_msp_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($sellingonmsp['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $selling_on_msp_farm_gateValue = $sellingonmsp['farm_gate'] ?? '';
                    ?>
                    <select
                        id="selling_on_msp_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($selling_on_msp_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($selling_on_msp_farm_gateValue == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $selling_on_msp_msp_Value = $sellingonmsp['msp'] ?? '';
                    ?>
                    <select
                        id="selling_on_msp_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($selling_on_msp_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($selling_on_msp_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $selling_on_msp_village_trader_Value = $sellingonmsp['village_trader'] ?? '';
                    ?>
                    <select
                        id="selling_on_msp_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($selling_on_msp_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($selling_on_msp_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $selling_on_msp_mandi = $sellingonmsp['mandi'] ?? '';
                    ?>
                    <select
                        id="selling_on_msp_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($selling_on_msp_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($selling_on_msp_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $selling_on_msp_processor = $sellingonmsp['processor'] ?? '';
                    ?>
                    <select
                        id="selling_on_msp_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($selling_on_msp_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($selling_on_msp_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $selling_on_msp_distributor = $sellingonmsp['distributor'] ?? '';
                    ?>
                    <select
                        id="selling_on_msp_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($selling_on_msp_distributor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($selling_on_msp_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $selling_on_msp_retailer = $sellingonmsp['retailer'] ?? '';
                    ?>
                    <select
                        id="selling_on_msp_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($selling_on_msp_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($selling_on_msp_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $selling_on_msp_consumer = $sellingonmsp['consumer'] ?? '';
                    ?>
                    <select
                        id="selling_on_msp_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($selling_on_msp_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($selling_on_msp_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="selling_on_msp_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($sellingonmsp['any_others'] ?? ''); ?>"></td>

            </tr>

            <tr>
                <td style="text-align:center;">
                    26
                </td>

                <td></td>
                <td></td>
                <td>
                    If No, extent of getting MSP price
                </td>
                <?php
                $extentofmspprice = json_decode($datas->extent_of_msp_price, true);
                ?>
                <td><input class=""
                        id="extent_of_msp_price_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($extentofmspprice['unit'] ?? ''); ?>"></td>

                <td>
                    <?php
                    $extent_of_msp_price_farm_gateValue = $extentofmspprice['farm_gate'] ?? '';
                    ?>
                    <select
                        id="extent_of_msp_price_farm_gate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_msp_price_farm_gateValue == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($extent_of_msp_price_farm_gateValue == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_msp_price_msp_Value = $extentofmspprice['msp'] ?? '';
                    ?>
                    <select
                        id="extent_of_msp_price_map_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_msp_price_msp_Value == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($extent_of_msp_price_msp_Value == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_msp_price_village_trader_Value = $extentofmspprice['village_trader'] ?? '';
                    ?>
                    <select
                        id="extent_of_msp_price_village_trader_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_msp_price_village_trader_Value == 'Yes' ? 'selected' : ''); ?>>
                            Yes</option>
                        <option value="No" <?php echo e($extent_of_msp_price_village_trader_Value == 'No' ? 'selected' : ''); ?>>No
                        </option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_msp_price_mandi = $extentofmspprice['mandi'] ?? '';
                    ?>
                    <select
                        id="extent_of_msp_price_mandi_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_msp_price_mandi == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($extent_of_msp_price_mandi == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_msp_price_processor = $extentofmspprice['processor'] ?? '';
                    ?>
                    <select
                        id="extent_of_msp_price_processor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_msp_price_processor == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($extent_of_msp_price_processor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_msp_price_distributor = $extentofmspprice['distributor'] ?? '';
                    ?>
                    <select
                        id="extent_of_msp_price_distributor_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_msp_price_distributor == 'Yes' ? 'selected' : ''); ?>>Yes
                        </option>
                        <option value="No" <?php echo e($extent_of_msp_price_distributor == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_msp_price_retailer = $extentofmspprice['retailer'] ?? '';
                    ?>
                    <select
                        id="extent_of_msp_price_retailer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_msp_price_retailer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($extent_of_msp_price_retailer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>

                <td>
                    <?php
                    $extent_of_msp_price_consumer = $extentofmspprice['consumer'] ?? '';
                    ?>
                    <select
                        id="extent_of_msp_price_consumer_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>">
                        <option value="">Select</option>
                        <option value="Yes" <?php echo e($extent_of_msp_price_consumer == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e($extent_of_msp_price_consumer == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </td>
                <td><input class=""
                        id="extent_of_msp_price_any_others_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"
                        value="<?php echo e($extentofmspprice['any_others'] ?? ''); ?>"></td>

            </tr>
            <td colspan="10"><button type="button" id="submitBtn" class="btn btn-primary submitBtn" data-id="<?php echo e($datas->id); ?>" data-farmerid="<?php echo e($datas->farmer_id); ?>">Update</button></td>

        </table>
        </form>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
            <thead>
                <tr>
                    <th>S. No</th>
                    <th>FARMER ID</th>
                    <th>Farmer Name</th>
                    <th>Particulars</th>
                    <th>Unit</th>
                    <th>Farm Gate</th>
                    <th>Procurement Centre through MSP</th>
                    <th>Village Trader</th>
                    <th>Mandi (Wholesaler) </th>
                    <th>Processor</th>
                    <th>Distributor</th>
                    <th>Retailer </th>
                    <th>Consumer</th>
                    <th>Any other Institution </th>
            </thead>



            <tr>
                <td style="text-align:center;">
                    1
                </td>

                <td> </td>
                <td> </td>
                <td>
                    Marketing channel (Purchaser)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>


            <tr>
                <td style="text-align:center;">
                    2
                </td>

                <td></td>
                <td></td>
                <td>
                    Distance of marketing channel from farm gate
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    3
                </td>

                <td></td>
                <td></td>
                <td>
                    Transportation
                </td>

                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    4
                </td>

                <td></td>
                <td></td>
                <td>
                    Transport through
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    5
                </td>

                <td></td>
                <td></td>
                <td>
                    Transport Expenses / Charges
                </td>

                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    6
                </td>

                <td></td>
                <td></td>
                <td>
                    Who undertake primary Processing (Cleaning, Grading & Sorting)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    7
                </td>


                <td></td>
                <td></td>
                <td>
                    Whether any assured buyer/institution present?
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>


            <tr>
                <td style="text-align:center;">
                    8
                </td>

                <td></td>
                <td></td>
                <td>
                    Whether any form of formal or informal contract farming is being practiced by the farmer?
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    9
                </td>

                <td></td>
                <td></td>
                <td>
                    Presence of Niche Market big hotels/residential institutions near the farm gate.
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    10
                </td>

                <td></td>
                <td></td>
                <td style="font-weight:700;">
                    Whether secondary processing being undertaken presently (value addition, packaging, marketing, etc.)
                </td>
                Presence of Niche Market big hotels/residential institutions near the farm gate.
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    11
                </td>

                <td></td>
                <td></td>
                <td>
                    Presence of any processing plant or food enterprise in the vicinity of farm gate
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    12
                </td>

                <td></td>
                <td></td>
                <td>
                    Whether Storage facility available?
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    13
                </td>


                <td></td>
                <td></td>
                <td>
                    Grain Storage / Cold Storage / Controlled Atmospheric Storage
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    14
                </td>

                <td></td>
                <td></td>
                <td>
                    If yes, capacity of the facility?
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>


            <tr>
                <td style="text-align:center;">
                    15
                </td>


                <td></td>
                <td></td>
                <td>
                    Charges for storage / cold storage / bulk cooling system / any other preservation system
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    16
                </td>

                <td></td>
                <td></td>
                <td>
                    Storage Duration
                </td>

                <td>
                    Day/ Month / Year
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    17
                </td>

                <td></td>
                <td></td>
                <td>
                    Time of sale of produce after harvesting
                </td>

                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    18
                </td>

                <td></td>
                <td></td>
                <td>
                    Type of road connectivity to farm gate
                </td>

                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    19
                </td>

                <td></td>
                <td></td>
                <td>
                    Payment of sale proceed
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    20
                </td>

                <td></td>
                <td></td>
                <td>
                    Extent of default of Payment of total sale value
                </td>

                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    21
                </td>


                <td></td>
                <td></td>
                <td>
                    Weighing Method
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>



            <tr>
                <td style="text-align:center;">
                    22
                </td>

                <td></td>
                <td></td>
                <td>
                    Extent of under weighing of whole proceed
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    23
                </td>

                <td></td>
                <td></td>
                <td>
                    Source of Market Information (Demand / Price etc.)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    24
                </td>

                <td></td>
                <td></td>
                <td>
                    Percentage of sale of total marketable surplus through MSP
                </td>

                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    25
                </td>

                <td></td>
                <td></td>
                <td>
                    Is producer directly selling to MSP procurement agency or through mediator
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    26
                </td>

                <td></td>
                <td></td>
                <td>
                    If No, extent of getting MSP price
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>

        </table>

        <?php endif; ?>


    </div>


    <div class="table-responsive mt-5">



    </div>

</div>


  <!--edit get data-->
<script>
 document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll('.submitBtn').forEach(button => {
        button.addEventListener('click', function () {
           
            const id = this.getAttribute('data-id');
            const farmerId = this.getAttribute('data-farmerId');
            
            const marketing_channel = {
                unit: document.getElementById(`marketing_channel_unit_${id}_${farmerId}`).value,
                farm_gate: document.getElementById(`marketing_channel_farm_gate_${id}_${farmerId}`).value,
                msp: document.getElementById(`marketing_channel_map_${id}_${farmerId}`).value,
                village_trader: document.getElementById(`marketing_channel_village_trader_${id}_${farmerId}`).value,
                mandi: document.getElementById(`marketing_channel_mandi_${id}_${farmerId}`).value,
                processor: document.getElementById(`marketing_channel_processor_${id}_${farmerId}`).value,
                distributor: document.getElementById(`marketing_channel_distributor_${id}_${farmerId}`).value,
                retailer: document.getElementById(`marketing_channel_retailer_${id}_${farmerId}`).value,
                consumer:document.getElementById(`marketing_channel_consumer_${id}_${farmerId}`).value,
                any_others: document.getElementById(`marketing_channel_any_others_${id}_${farmerId}`).value,
            };
            
            const marketing_channel_distance = {
            unit: document.getElementById(`marketing_channel_distance_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`marketing_channel_distance_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`marketing_channel_distance_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`marketing_channel_distance_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`marketing_channel_distance_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`marketing_channel_distance_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`marketing_channel_distance_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`marketing_channel_distance_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`marketing_channel_distance_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`marketing_channel_distance_any_others_${id}_${farmerId}`).value,
            };
            
            const transportation_method = {
            unit: document.getElementById(`transportation_method_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`transportation_method_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`transportation_method_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`transportation_method_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`transportation_method_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`transportation_method_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`transportation_method_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`transportation_method_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`transportation_method_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`transportation_method_any_others_${id}_${farmerId}`).value,
            };
            
            const transport_by = {
            unit: document.getElementById(`transport_by_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`transport_by_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`transport_by_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`transport_by_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`transport_by_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`transport_by_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`transport_by_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`transport_by_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`transport_by_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`transport_by_any_others_${id}_${farmerId}`).value,
            };
            
            const transport_expenses = {
            unit: document.getElementById(`transport_expenses_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`transport_expenses_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`transport_expenses_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`transport_expenses_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`transport_expenses_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`transport_expenses_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`transport_expenses_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`transport_expenses_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`transport_expenses_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`transport_expenses_any_others_${id}_${farmerId}`).value,
            };
           
            const primary_processing = {
            unit: document.getElementById(`primary_processing_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`primary_processing_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`primary_processing_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`primary_processing_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`primary_processing_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`primary_processing_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`primary_processing_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`primary_processing_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`primary_processing_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`primary_processing_any_others_${id}_${farmerId}`).value,
            };
            
            const buyer_institution_present = {
            unit: document.getElementById(`buyer_institution_present_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`buyer_institution_present_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`buyer_institution_present_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`buyer_institution_present_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`buyer_institution_present_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`buyer_institution_present_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`buyer_institution_present_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`buyer_institution_present_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`buyer_institution_present_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`buyer_institution_present_any_others_${id}_${farmerId}`).value,
            }; 
            
            const formal_informal_contract = {
            unit: document.getElementById(`formal_informal_contract_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`formal_informal_contract_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`formal_informal_contract_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`formal_informal_contract_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`formal_informal_contract_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`formal_informal_contract_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`formal_informal_contract_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`formal_informal_contract_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`formal_informal_contract_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`formal_informal_contract_any_others_${id}_${farmerId}`).value,
            };
            
            const niche_market = {
                unit: document.getElementById(`niche_market_unit_${id}_${farmerId}`).value,
                farm_gate: document.getElementById(`niche_market_farm_gate_${id}_${farmerId}`).value,
                msp: document.getElementById(`niche_market_map_${id}_${farmerId}`).value,
                village_trader: document.getElementById(`niche_market_village_trader_${id}_${farmerId}`).value,
                mandi: document.getElementById(`niche_market_mandi_${id}_${farmerId}`).value,
                processor: document.getElementById(`niche_market_processor_${id}_${farmerId}`).value,
                distributor: document.getElementById(`niche_market_distributor_${id}_${farmerId}`).value,
                retailer: document.getElementById(`niche_market_retailer_${id}_${farmerId}`).value,
                consumer:document.getElementById(`niche_market_consumer_${id}_${farmerId}`).value,
                any_others: document.getElementById(`niche_market_any_others_${id}_${farmerId}`).value,
            };
            
            
            const secondary_processing = {
            unit: document.getElementById(`secondary_processing_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`secondary_processing_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`secondary_processing_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`secondary_processing_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`secondary_processing_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`secondary_processing_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`secondary_processing_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`secondary_processing_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`secondary_processing_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`secondary_processing_any_others_${id}_${farmerId}`).value,
            };
            
            const processing_in_vicinity = {
            unit: document.getElementById(`processing_in_vicinity_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`processing_in_vicinity_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`processing_in_vicinity_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`processing_in_vicinity_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`processing_in_vicinity_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`processing_in_vicinity_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`processing_in_vicinity_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`processing_in_vicinity_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`processing_in_vicinity_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`processing_in_vicinity_any_others_${id}_${farmerId}`).value,
            }; 
            
            const storage_facility = {
            unit: document.getElementById(`storage_facility_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`storage_facility_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`storage_facility_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`storage_facility_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`storage_facility_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`storage_facility_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`storage_facility_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`storage_facility_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`storage_facility_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`storage_facility_any_others_${id}_${farmerId}`).value,
            };
            
            const storage = {
            unit: document.getElementById(`storage_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`storage_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`storage_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`storage_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`storage_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`storage_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`storage_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`storage_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`storage_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`storage_any_others_${id}_${farmerId}`).value,
            };  
            
            const facility_capacity = {
            unit: document.getElementById(`facility_capacity_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`facility_capacity_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`facility_capacity_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`facility_capacity_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`facility_capacity_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`facility_capacity_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`facility_capacity_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`facility_capacity_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`facility_capacity_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`facility_capacity_any_others_${id}_${farmerId}`).value,
            };
            
            const storage_charges = {
                unit: document.getElementById(`storage_charges_unit_${id}_${farmerId}`).value,
                farm_gate: document.getElementById(`storage_charges_farm_gate_${id}_${farmerId}`).value,
                msp: document.getElementById(`storage_charges_map_${id}_${farmerId}`).value,
                village_trader: document.getElementById(`storage_charges_village_trader_${id}_${farmerId}`).value,
                mandi: document.getElementById(`storage_charges_mandi_${id}_${farmerId}`).value,
                processor: document.getElementById(`storage_charges_processor_${id}_${farmerId}`).value,
                distributor: document.getElementById(`storage_charges_distributor_${id}_${farmerId}`).value,
                retailer: document.getElementById(`storage_charges_retailer_${id}_${farmerId}`).value,
                consumer:document.getElementById(`storage_charges_consumer_${id}_${farmerId}`).value,
                any_others: document.getElementById(`storage_charges_any_others_${id}_${farmerId}`).value,
            }; 
            
            const storage_duretion = {
            unit: document.getElementById(`storage_duretion_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`storage_duretion_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`storage_duretion_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`storage_duretion_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`storage_duretion_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`storage_duretion_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`storage_duretion_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`storage_duretion_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`storage_duretion_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`storage_duretion_any_others_${id}_${farmerId}`).value,
            };
            
            const time_of_sale = {
            unit: document.getElementById(`time_of_sale_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`time_of_sale_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`time_of_sale_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`time_of_sale_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`time_of_sale_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`time_of_sale_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`time_of_sale_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`time_of_sale_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`time_of_sale_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`time_of_sale_any_others_${id}_${farmerId}`).value,
            };
            
            const road_connectivity = {
                unit: document.getElementById(`road_connectivity_unit_${id}_${farmerId}`).value,
                farm_gate: document.getElementById(`road_connectivity_farm_gate_${id}_${farmerId}`).value,
                msp: document.getElementById(`road_connectivity_map_${id}_${farmerId}`).value,
                village_trader: document.getElementById(`road_connectivity_village_trader_${id}_${farmerId}`).value,
                mandi: document.getElementById(`road_connectivity_mandi_${id}_${farmerId}`).value,
                processor: document.getElementById(`road_connectivity_processor_${id}_${farmerId}`).value,
                distributor: document.getElementById(`road_connectivity_distributor_${id}_${farmerId}`).value,
                retailer: document.getElementById(`road_connectivity_retailer_${id}_${farmerId}`).value,
                consumer:document.getElementById(`road_connectivity_consumer_${id}_${farmerId}`).value,
                any_others: document.getElementById(`road_connectivity_any_others_${id}_${farmerId}`).value,
            };
            
            const payment_of_sale = {
            unit: document.getElementById(`payment_of_sale_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`payment_of_sale_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`payment_of_sale_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`payment_of_sale_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`payment_of_sale_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`payment_of_sale_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`payment_of_sale_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`payment_of_sale_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`payment_of_sale_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`payment_of_sale_any_others_${id}_${farmerId}`).value,
            };  
            
            const total_sale_value = {
            unit: document.getElementById(`total_sale_value_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`total_sale_value_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`total_sale_value_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`total_sale_value_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`total_sale_value_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`total_sale_value_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`total_sale_value_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`total_sale_value_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`total_sale_value_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`total_sale_value_any_others_${id}_${farmerId}`).value,
            }; 
            
            const weighing_method = {
            unit: document.getElementById(`weighing_method_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`weighing_method_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`weighing_method_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`weighing_method_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`weighing_method_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`weighing_method_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`weighing_method_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`weighing_method_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`weighing_method_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`weighing_method_any_others_${id}_${farmerId}`).value,
            };
            
            const extent_of_under_weighing = {
            unit: document.getElementById(`extent_of_under_weighing_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`extent_of_under_weighing_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`extent_of_under_weighing_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`extent_of_under_weighing_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`extent_of_under_weighing_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`extent_of_under_weighing_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`extent_of_under_weighing_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`extent_of_under_weighing_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`extent_of_under_weighing_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`extent_of_under_weighing_any_others_${id}_${farmerId}`).value,
            };
                
            const source_of_market_info = {
            unit: document.getElementById(`source_of_market_info_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`source_of_market_info_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`source_of_market_info_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`source_of_market_info_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`source_of_market_info_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`source_of_market_info_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`source_of_market_info_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`source_of_market_info_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`source_of_market_info_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`source_of_market_info_any_others_${id}_${farmerId}`).value,
            }; 
            
            const total_marketable_surplus = {
            unit: document.getElementById(`total_marketable_surplus_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`total_marketable_surplus_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`total_marketable_surplus_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`total_marketable_surplus_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`total_marketable_surplus_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`total_marketable_surplus_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`total_marketable_surplus_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`total_marketable_surplus_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`total_marketable_surplus_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`total_marketable_surplus_any_others_${id}_${farmerId}`).value,
            }; 
            
            const selling_on_msp = {
            unit: document.getElementById(`selling_on_msp_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`selling_on_msp_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`selling_on_msp_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`selling_on_msp_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`selling_on_msp_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`selling_on_msp_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`selling_on_msp_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`selling_on_msp_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`selling_on_msp_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`selling_on_msp_any_others_${id}_${farmerId}`).value,
            };
            
            const extent_of_msp_price = {
            unit: document.getElementById(`extent_of_msp_price_unit_${id}_${farmerId}`).value,
            farm_gate: document.getElementById(`extent_of_msp_price_farm_gate_${id}_${farmerId}`).value,
            msp: document.getElementById(`extent_of_msp_price_map_${id}_${farmerId}`).value,
            village_trader: document.getElementById(`extent_of_msp_price_village_trader_${id}_${farmerId}`).value,
            mandi: document.getElementById(`extent_of_msp_price_mandi_${id}_${farmerId}`).value,
            processor: document.getElementById(`extent_of_msp_price_processor_${id}_${farmerId}`).value,
            distributor: document.getElementById(`extent_of_msp_price_distributor_${id}_${farmerId}`).value,
            retailer: document.getElementById(`extent_of_msp_price_retailer_${id}_${farmerId}`).value,
            consumer:document.getElementById(`extent_of_msp_price_consumer_${id}_${farmerId}`).value,
            any_others: document.getElementById(`extent_of_msp_price_any_others_${id}_${farmerId}`).value,
            };
          
            const data = {id, farmer_id: farmerId, marketing_channel , marketing_channel_distance , transportation_method , transport_by , transport_expenses ,
             primary_processing , buyer_institution_present , formal_informal_contract , niche_market , secondary_processing , processing_in_vicinity , storage_facility , 
             storage , facility_capacity , storage_charges , storage_duretion , time_of_sale , road_connectivity , payment_of_sale , total_sale_value , weighing_method ,
             extent_of_under_weighing , source_of_market_info , total_marketable_surplus , selling_on_msp , extent_of_msp_price
            };

            console.log(data);

            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

           fetch('<?php echo e(route("anexure.f.update")); ?>', {
                method: 'POST', 
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                body: JSON.stringify(data)
            })
            .then(response => response.json())
            .then(data => {
                alert('Success! ' + JSON.stringify(data));
            })
            .catch(error => console.error('Error:', error));
        });
    });
});
 </script>
  
  <!--end edit data-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-f-update.blade.php ENDPATH**/ ?>