<?php
    use App\Models\HectareMeasurement;
    use Illuminate\Support\Collection;
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
    
    $loggedInTeamLeaderId = $userDetail->team_leader_id;
    
    $uniqueUserIds = $data->pluck('user_id')->unique();
    $hectareMaster = HectareMeasurement::all();
    $targetTeamLeaderId = $hectareMaster->pluck('user_id')->filter()->unique()->values();
    $filteredCollection = $hectareMaster->filter(function ($item) use ($targetTeamLeaderId) {
        return $targetTeamLeaderId->contains($item->user_id);
    });
    
    
    
    
    // 18-11-2024
    // $hectare_master_unit = 'hectare';
    // foreach ($data as $entry1) {
    //     $user_id = $entry1->id; 
    //     if(isset($targetTeamLeaderId[0])){
    //         $teamLeadArray = (array)$targetTeamLeaderId[0] ?? [];
    //     }else{
    //         $teamLeadArray = [];
    //     }
       
    //     if(in_array($entry1->team_leader_id, $teamLeadArray)){
            
    //         foreach ($filteredCollection as $entry2){
          
    //             if($entry1->first_year_area_unit == $entry2->unit){
    //                 $entry1->first_year_area_unit = $hectare_master_unit;
    //                 $entry1->first_year_area = number_format($entry1->first_year_area/$entry2->value,3);
    //             }
                
    //             if($entry1->second_year_area_unit == $entry2->unit){
    //                 $entry1->second_year_area_unit = $hectare_master_unit;
    //                 $entry1->second_year_area = number_format($entry1->second_year_area/$entry2->value,3);
    //             }
                
    //             if($entry1->third_year_area_unit == $entry2->unit){
    //                 $entry1->third_year_area_unit = $hectare_master_unit;
    //                 $entry1->third_year_area = number_format($entry1->third_year_area/$entry2->value,3);
    //             }
                
    //             if($entry1->first_year_production_unit == $entry2->unit){
    //                 $entry1->first_year_production_unit = $hectare_master_unit;
    //                 $entry1->first_year_production = number_format($entry1->first_year_production/$entry2->value,3);
    //             }
                
    //             if($entry1->second_year_production_unit == $entry2->unit){
    //                 $entry1->second_year_production_unit = $hectare_master_unit;
    //                 $entry1->second_year_production = number_format($entry1->second_year_production/$entry2->value,3);
    //             }
                
    //             if($entry1->third_year_production_unit == $entry2->unit){
    //                 $entry1->third_year_production_unit = $hectare_master_unit;
    //                 $entry1->third_year_production = number_format($entry1->third_year_production/$entry2->value,3);
    //             }
            
    //         }
    //     }
    // }

?>


<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
             <br>
            <?php if($deshboard == 1): ?>
        
                <?php else: ?>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.three')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.three.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            <?php endif; ?>
           
         <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Cropping pattern, Area and Production & Marketed Surplus</h1>
        </div>
        <?php if($data->isNotEmpty()): ?>    
        <?php
            $si = 1;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <table class="table table-bordered">
          <thead>
            <tr>
                <?php
                $currentYear = date("Y");
                $previousYear = $currentYear - 1;
                $previoustwoYear = $currentYear - 2;
                $previousthreeYear = $currentYear - 3;
                ?>
              <th colspan="6" ></th>
              <th colspan="3" style="text-align:center;"><?php echo $previousthreeYear . "-" . $previoustwoYear; ?></th>
              <th colspan="3" style="text-align:center;"><?php echo $previoustwoYear . "-" . $previousYear; ?></th>
              <th colspan="11" style="text-align:center;"><?php echo $previousYear . "-" . $currentYear; ?></th>
            </tr>
            <tr>
              <th>Season</th>
              <th>S. No.</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Name of the Crop</th>
              <th>Variety</th>
              
              <th>Area</th>
               <th>Area (Unit)</th>
              <th>Production QTL</th>
              <th>Production (Unit)</th>
              <th>Productivity (Unit)/QTL</th>
              
              <th>Area</th>
              <th>Area (Unit)</th>
              <th>Production QTL</th>
              <th>Production (Unit)</th>
              <th>Productivity (Unit)/QTL</th>
              
              <th>Area</th>
              <th>Area (Unit)</th>
              <th>Production QTL</th>
              <th>Production (Unit)</th>
              <th>Productivity (Unit)/QTL</th>
              
              <th>AGR(Avarage Growth Rate)</th>
              <th>CAGR </th>
              
              <th>Marketed Surplus (Unit)/QTL</th>
              <th>Average Price of Selling </th>
              <th>Minimum Price</th>
              <th>Maximum Price</th>
              
              <th>NET  AREA UNDER NEXT SEASON  </th>
              <th>PROJECTED PRODUCTION</th>
              <th>PROJECTED MARKETED SURPLUS</th>
              
              <th>Remark</th>
            </tr>
          </thead>
          <tbody>

            <!--<tr>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--  <td><?php echo e($datas->first_year_area_unit); ?></td>-->
            <!--  <td></td>-->
            <!--    <td></td>-->
            <!--  <td></td>-->
            <!--  <td><?php echo e($datas->second_year_area_unit); ?></td>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--   <td><?php echo e($datas->third_year_area_unit); ?></td>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--  <td></td>-->
            <!--</tr>-->

            <tr>
              <td style="font-weight:700;"rowspan="3"> <?php echo e($datas->season); ?></td>
              <td><?php echo e($si++); ?></td>
              <td> <?php echo e($datas->farmer_code_id); ?></td>
              <td><?php echo e($datas->farmer_first_name); ?> <?php echo e($datas->farmer_last_name); ?></td>
              <td> <?php echo e($datas->crop_name); ?></td>
              <td><?php echo e($datas->variety); ?></td>
              
              <td><?php echo e($datas->first_year_area == 'null' ? '' : $datas->first_year_area); ?></td>
              
              <td><?php echo e($datas->first_year_area_unit); ?> </td>
              
              <td><?php echo e($datas->first_year_production); ?> </td>
              
              <td><?php echo e($datas->first_year_production_unit); ?></td>
              
               <?php
                $first_year_area = $datas->first_year_area === 'null' ? 0 : $datas->first_year_area;
                $first_year_production = $datas->first_year_production ?? 0;
                $firstYproduct = $first_year_area > 0 ? ($first_year_production / $first_year_area) : 0;
                $firstYproduct = number_format($firstYproduct, 2);
               ?>
            
              
              <td><?php echo e($firstYproduct); ?></td>
              
              
              <td>
                 <?php echo e($datas->second_year_area == 'null' ? '' : $datas->second_year_area); ?>

              </td>
              <td><?php echo e($datas->second_year_area_unit); ?></td>
              
              <td> <?php echo e($datas->second_year_production); ?></td>
              
              <td> <?php echo e($datas->second_year_production_unit); ?></td>
              
              <?php
                $second_year_area = $datas->second_year_area === 'null' ? 0 : $datas->second_year_area;
                $second_year_production = $datas->second_year_production ?? 0;
                $secondYproduct = $second_year_area > 0 ? ($second_year_production / $second_year_area) : 0;
                $secondYproduct = number_format($secondYproduct, 2);
               ?>
              
              
              <td> <?php echo e($secondYproduct); ?></td>
              
              <td>
                  <?php echo e($datas->third_year_area == 'null' ? '' : $datas->third_year_area); ?>

              </td>
               <td><?php echo e($datas->third_year_area_unit); ?></td>
              <td><?php echo e($datas->third_year_production); ?></td>
               <td><?php echo e($datas->third_year_production_unit); ?></td>
               <?php
                $third_year_area = $datas->third_year_area === 'null' ? 0 : $datas->third_year_area;
                $third_year_production = $datas->third_year_production ?? 0;
                $thirdYproduct = $third_year_area > 0 ? ($third_year_production / $third_year_area) : 0;
                $thirdYproduct = number_format($thirdYproduct, 2);
               ?>
              
              <td><?php echo e($thirdYproduct); ?></td>
              
              <!--update agr formula-->
              
                  <?php
                    $ma = $thirdYproduct; 
                    $ja = $secondYproduct; 
                    $ga = $firstYproduct;  
                    $ma = is_numeric($ma) ? (float) $ma : 0;
                    $ja = is_numeric($ja) ? (float) $ja : 0;
                    $ga = is_numeric($ga) ? (float) $ga : 0;
                    if ($ja != 0 && $ga != 0) { 
                        $agr = ((($ma - $ja) / $ja + ($ja - $ga) / $ga) / 2);
                    } else {
                        $agr = 0; 
                    }
                    $agr = $agr * 100;
                    $agr = number_format($agr, 2);
                 ?>
                
                  <th><?php echo e($agr); ?> %</th>

              
              <!--update agr formula-->
              
               <?php
                    $lc = is_numeric($datas->third_year_production) ? (float) $datas->third_year_production : 0;
                    $fc = is_numeric($datas->first_year_production) ? (float) $datas->first_year_production : 0;
                
                    if ($fc != 0) {
                        $cagr = pow(($lc / $fc), (1 / 3)) - 1; 
                    } else {
                        $cagr = 0;  
                    }
                    $cagr = $cagr * 100;
                    $cagr = number_format($cagr, 2);
                ?>
                
                <th><?php echo e($cagr); ?> %</th>

              
              <td><?php echo e($datas->marketed_surplus == 'null' ? '' : $datas->marketed_surplus); ?></td>
              <td><?php echo e($datas->average_price_selling); ?></td>
              <td> <?php echo e($datas->min_rate); ?></td>
              <td><?php echo e($datas->max_rate); ?></td>
              
               <td> <?php echo e($datas->net_area_under_nest_season); ?></td>
               
               
               
              <!--PROJECTED PRODUCTION -->
              
               <?php
                // Ensure each variable is treated as a number (integer or float)
                $t7 = is_numeric($datas->net_area_under_nest_season) ? (float) $datas->net_area_under_nest_season : 0; 
                
                // Convert percentage values to decimals (divide by 100)
                $n7 = is_numeric($agr) ? (float) $agr / 100 : 0; 
                $m7 = is_numeric($thirdYproduct) ? (float) $thirdYproduct : 0;
                $o7 = is_numeric($cagr) ? (float) $cagr / 100 : 0; 
                
                // Calculate projectPro with the numeric values
                $projectPro = $t7 * $m7 * (1 + min($n7, $o7));
                $projectPro1 = number_format($projectPro, 2);
               ?>
            
              <td><?php echo e($projectPro1); ?></td>
              
              
              
             <?php
                $u7 = is_numeric($projectPro1) ? (float) $projectPro1 : 0;
                $p7 = is_numeric($datas->marketed_surplus) ? (float) $datas->marketed_surplus : 0;
                $l7 = is_numeric($datas->third_year_production) ? (float) $datas->third_year_production : 0;
                
                if ($l7 != 0) {
                    $projectmar = ($u7 * $p7) / $l7;
                } else {
                    $projectmar = 0;
                }
                $projectmar = number_format($projectmar, 2);
            ?>
            
            <td><?php echo e($projectmar); ?></td>

              
              <!--PROJECTED MARKETED SURPLUS -->
              
              <td><?php echo e($datas->remark); ?></td>
              
            </tr>
            
          </tbody>
        </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <table class="table table-bordered">
          <thead>
              
            <tr>
                <?php
                $currentYear = date("Y");
                $previousYear = $currentYear - 1;
                $previoustwoYear = $currentYear - 2;
                $previousthreeYear = $currentYear - 3;
                ?>
              <th colspan="6" ></th>
              <th colspan="3" style="text-align:center;"><?php echo $previousthreeYear . "-" . $previoustwoYear; ?></th>
              <th colspan="3" style="text-align:center;"><?php echo $previoustwoYear . "-" . $previousYear; ?></th>
              <th colspan="11" style="text-align:center;"><?php echo $previousYear . "-" . $currentYear; ?></th>
            </tr>
            
            <tr>
              <th>Season</th>
              <th>S. No.</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Name of the Crop</th>
              <th>Variety</th>
              <th>Area (Unit)</th>
              <th>Production (Unit)/QTL</th>
              <th>Productivity (Unit)/QTL</th>
              <th>Area (Unit)</th>
              <th>Production (Unit)/QTL</th>
              <th>Productivity (Unit)/QTL</th>
              <th>Area (Unit)</th>
              <th>Production (Unit)/QTL</th>
              <th>Productivity (Unit)/QTL</th>
              <th>AGR(Avarage Growth Rate)</th>
              <th>CAGR </th>
              <th>Marketed Surplus (Unit)/QTL</th>
              <th>Average Price of Selling </th>
              <th>Minimum Price</th>
              <th>Maximum Price</th>
                <th>NET  AREA UNDER NEXT SEASON  </th>
              <th>PROJECTED PRODUCTION</th>
              <th>PROJECTED MARKETED SURPLUS</th>
              <th>Remark</th>
            </tr>
            
          </thead>
          <tbody>

            <tr>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
               <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
                 <td></td>
              <td></td>
              <td></td>
            </tr>

            <tr>
              <td style="font-weight:700;"rowspan="3"> Season</td>
             <td>1</td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td>
                  
              </td>
               <th></th>
              <th></th>
              <td></td>
              <td></td>
              <td>
                  
              </td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td> </td>
              <td></td>
              <td></td>
              </tr><tr>
            <td></td>
              <td></td>
              <td></td>
            </tr>
            
          </tbody>
        </table>
        <?php endif; ?>
        
        </div>
    </div>
    
    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-three.blade.php ENDPATH**/ ?>