<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
    
   function splitUnit($txt) {
    if (strtolower(trim($txt)) === 'null') {
        return [null, ''];
    }

    if (preg_match('/^null\s*(.*)/i', $txt, $matches)) {
        $textPart = isset($matches[1]) ? $matches[1] : '';
        return [null, trim($textPart)];
    }

    // Use regular expression to split the string into numbers (including decimals) and text
    preg_match('/([\d\.]+)\s*(.*)/', $txt, $matches);
    
    // Extract the numeric part as a float and the text part, if available
    $numericPart = isset($matches[1]) ? (float)$matches[1] : null; // Cast to float
    $textPart = isset($matches[2]) ? trim($matches[2]) : '';
    
    return [$numericPart, $textPart];
}
?>

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>







<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            <?php if($deshboard == 1): ?>
        
            <?php else: ?>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.three')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.four.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            <?php endif; ?>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Allied Agriculture</h1>
        </div>
        <?php if($data->isNotEmpty()): ?>    
        <?php
            $si = 1;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
       <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Animal Name</th>
            </tr>
           
          </thead>
         
            <tr>
                <td style="text-align:center;">
                    <?php echo e($si++); ?>

                </td>
                <td><?php echo e($data->farmer_code_id); ?></td>
                <td><?php echo e($data->farmer_first_name); ?> <?php echo e($data->farmer_last_name); ?></td>
                  <td>
                    Number
                </td>
                <td>
                    
                   <?php echo e($data->number == 'null' ? '' : $data->number); ?>

                </td>
               
                <td>
                <?php echo e($data->animal_name == 'null' ? '' : $data->animal_name); ?>

                </td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
              
                <td></td>
                <td></td>
                  <td>
                    Breed
                </td>
                <td>
                   
                </td>
                
                <td><?php echo e($data->breed == 'null' ? '' : $data->breed); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                <td></td>
                <td></td>
                 <td>
                    Generation ( First / Second / Third / Fourth/Fifth)
                </td>
                <td>
                   
                </td>
             
                <td><?php echo e($data->generation == 'null' ? '' : $data->generation); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
            
                <td></td>
                <td></td>
                    <td style="font-weight:700;">
                   Green Feed 
                </td>
                <td>
                  
                </td>
                
                <td><?php echo e($data->green_fodder == 'null' ? '' : $data->green_fodder); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                <td></td>
                <td></td>
                 <td>
                   Quantity of Green Fodder
                </td>
                <td>
                  <?php echo e(splitUnit($data->green_fodder_quantity == null ? '' : $data->green_fodder_quantity)[1]); ?>

                </td>
             
                <td>
                    <?php echo e(splitUnit($data->green_fodder_quantity == null ? '' : $data->green_fodder_quantity)[0]); ?>

                </td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Expenses on Greed Fodder
                </td>
                
                <td>
                    <?php echo e(splitUnit($data->green_fodder_expenses == null ? '' : $data->green_fodder_expenses)[1]); ?>

                </td>
               
                <td>
                    <?php echo e(splitUnit($data->green_fodder_expenses == null ? '' : $data->green_fodder_expenses)[0]); ?>

                </td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    c
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Total Expenses on Green Fodder
                </td>
                
                <?php
                    $totalExpenses = (splitUnit($data->green_fodder_quantity == null ? '' : $data->green_fodder_quantity)[0] ) * (splitUnit($data->green_fodder_expenses == null ? '' : $data->green_fodder_expenses)[0]);
                ?>
                
                <td>
                    <?php echo e(splitUnit($data->green_fodder_expenses == null ? '' : $data->green_fodder_expenses)[1]); ?>

                </td>
               
                <td>
                    <?php echo e($totalExpenses); ?>

                </td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    5
                </td>

                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                  Dry Feed
                </td>
                <td>
                </td>
               
                <td><?php echo e($data->dry_feed == 'null' ? '' : $data->dry_feed); ?></td>
            </tr>
            
           
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                <td></td>
                <td></td>
                <td>Quantity of Dry Fodder</td>
                <td><?php echo e(splitUnit($data->dry_fodder_quantity == null ? '' : $data->dry_fodder_quantity)[1]); ?></td>
                <td><?php echo e(splitUnit($data->dry_fodder_quantity == null ? '' : $data->dry_fodder_quantity)[0]); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Expenses on Dry Fodder
                </td>
                <td>
                 <?php echo e(splitUnit($data->dry_fodder_expenses == null ? '' : $data->dry_fodder_expenses)[1]); ?>

                </td>
               
                <td><?php echo e(splitUnit($data->dry_fodder_expenses == null ? '' : $data->dry_fodder_expenses)[0]); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Total Expenses on Dry Fodder
                </td>
                
              <?php
                $dryFodderQuantity = $data->dry_fodder_quantity === null ? '' : splitUnit($data->dry_fodder_quantity)[0];
                $dryFodderExpenses = $data->dry_fodder_expenses === null ? '' : splitUnit($data->dry_fodder_expenses)[0];
                $totalExDrFodd = $dryFodderQuantity * $dryFodderExpenses;
              ?>

                
                <td>
                 <?php echo e(splitUnit($data->dry_fodder_expenses == null ? '' : $data->dry_fodder_expenses)[1]); ?>

                </td>
               
                <td><?php echo e($totalExDrFodd); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    6
                </td>
                
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                 Conventional Feed
                </td>
                <td>
                </td>
                
                <td><?php echo e($data->conventional_feed == 'null' ? '' : $data->conventional_feed); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td><td>
                </td>
                <td></td>
                 <td>
                 Quantity of Conventional Feed 
                </td>
                


               
                <?php if(splitUnit($data->conventional_feed_quantity)[0] == null): ?>
                <th></th>
                <th></th>
                <?php else: ?>
                <td><?php echo e(splitUnit($data->conventional_feed_quantity == null ? '' : $data->conventional_feed_quantity)[1]); ?></td>
                <td><?php echo e(splitUnit($data->conventional_feed_quantity == null ? '' : $data->conventional_feed_quantity)[0]); ?></td>
                <?php endif; ?>
            </tr>
            
            <tr>
                <td style="text-align:center;">b</td>
                <td></td>
                <td></td>
                 <td>Expenditure on Conventional Feed </td>
                <?php if(splitUnit($data->conventional_feed_expenditure)[0] == null): ?>
                <th></th>
                <th></th>
                <?php else: ?>
                <td><?php echo e(splitUnit($data->conventional_feed_expenditure == null ? '' : $data->conventional_feed_expenditure)[1]); ?></td>
                <td><?php echo e(splitUnit($data->conventional_feed_expenditure == null ? '' : $data->conventional_feed_expenditure)[0]); ?></td>
                 <?php endif; ?>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">c</td>
                <td></td>
                <td></td>
                 <td>Total Expenditure on Conventional Feed</td>
                  <?php
                    $Expenditures = $data->conventional_feed_quantity === null ? '' : splitUnit($data->conventional_feed_quantity)[0];
                    $Expendituredat = $data->conventional_feed_expenditure === null ? '' : splitUnit($data->conventional_feed_expenditure)[0];
                    $totalExpenditure= $Expenditures * $Expendituredat;
                  ?>
                 
                <?php if(splitUnit($data->conventional_feed_expenditure)[0] == null): ?> 
                <td></td>
                <?php else: ?>
                <td><?php echo e(splitUnit($data->conventional_feed_expenditure == null ? '' : $data->conventional_feed_expenditure)[1]); ?></td>
                <?php endif; ?>
               
                <?php if($totalExpenditure == 0): ?>
                <td></td>
                <?php else: ?>
                <td><?php echo e($totalExpenditure); ?></td>
                <?php endif; ?>
            </tr>
            
            
            
             <tr>
                <td style="text-align:center;">
                    7
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                 Commercial Feed
                </td>
                <td>
                
                </td>
               
                <td><?php echo e($data->commercial_feed == 'null' ? '' : $data->commercial_feed); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                <td></td>
                <td></td>
                 <td>
                 Quantity of Commercial Feed 
                </td>
                <td>
                    <?php echo e(splitUnit($data->commercial_feed_quantity == null ? '' : $data->commercial_feed_quantity)[1]); ?>

                </td>

                <td><?php echo e(splitUnit($data->commercial_feed_quantity == null ? '' : $data->commercial_feed_quantity)[0]); ?></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Expenses of Commercial Feed 
                </td>
                <td>
                 <?php echo e(splitUnit($data->commercial_feed_expenses == null ? '' : $data->commercial_feed_expenses)[1]); ?>

                </td>
            
                <td><?php echo e(splitUnit($data->commercial_feed_expenses == null ? '' : $data->commercial_feed_expenses)[0]); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
                <td></td>
                <td></td>
                 <td>Total Expenses of Commercial Feed</td>
                 
               <?php
                $comfeedQ = $data->commercial_feed_quantity === null ? '' : splitUnit($data->commercial_feed_quantity)[0];
                $comfeedexp = $data->commercial_feed_expenses === null ? '' : splitUnit($data->commercial_feed_expenses)[0];
                $totalExpe = $comfeedQ * $comfeedexp;
              ?>
                 
                 
                <td><?php echo e(splitUnit($data->commercial_feed_expenses == null ? '' : $data->commercial_feed_expenses)[1]); ?></td>
                
                <td><?php echo e($totalExpe); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Local
                </td>
                <td>
                 
                </td>
          
                <td><?php echo e($data->local == 'null' ? '' : $data->local); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    e
                </td>

                <td></td>
                <td></td>
                <td>
                 Branded
                </td>
                <td>

                </td>
             
                <td><?php echo e($data->branded == 'null' ? '' : $data->branded); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Expenditure on Health / Veterinary Services
                </td>
                <td>
                    <?php echo e(splitUnit($data->health_expenditure == null ? '' : $data->health_expenditure)[1]); ?>

                </td>
                
                <td><?php echo e(splitUnit($data->health_expenditure == null ? '' : $data->health_expenditure)[0]); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    9
                </td>
                
                <td></td>
                <td></td>
                <td>
                Distance of Veterinary Services
                </td>
                <td>
                  <?php echo e(splitUnit($data->veterinary_distance == null ? '' : $data->veterinary_distance)[1]); ?>

                </td>
             
                <td><?php echo e(splitUnit($data->veterinary_distance == null ? '' : $data->veterinary_distance)[0]); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    10
                </td>
                
                <td></td>
                <td></td>
                <td>
                Quality Of Veterinary Services
                </td>
                <td>
                 
                </td>
              
                <td><?php echo e($data->veterinary_quality == 'null' ? '' : $data->veterinary_quality); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    11
                </td>
              
                <td></td>
                <td></td>
                  <td style="font-weight:700;">
               Main Product (Milk/Ghee, Curd/Meat/Egg etc.)
                </td>
                <td>
                </td>
               
                <td><?php echo e($data->product == 'null' ? '' : $data->product); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
             
                <td></td>
                <td></td>
                   <td>
                  Total Production of Main Product
                </td>
                <td>
                    <?php echo e(splitUnit($data->main_product_production == null ? '' : $data->main_product_production)[1]); ?>

                </td>
              
                <td><?php echo e(splitUnit($data->main_product_production == null ? '' : $data->main_product_production)[0]); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Quantity Sold
                </td>
                <td>
                 <?php echo e(splitUnit($data->quantity_selling_market == null ? '' : $data->quantity_selling_market)[1]); ?>

                </td>
               
                <td><?php echo e(splitUnit($data->quantity_selling_market == null ? '' : $data->quantity_selling_market)[0]); ?></td>
            </tr>
            
           
            
            
            
            <tr>
                <td style="text-align:center;">
                c
                </td>
                <td></td>
                <td></td>
                  <td>
                 Average Selling Price
                </td>
                <td><?php echo e(splitUnit($data->average_selling_price == null ? '' : $data->average_selling_price)[1]); ?></td>
                <td><?php echo e(splitUnit($data->average_selling_price == null ? '' : $data->average_selling_price)[0]); ?></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">d</td>
                <td></td>
                <td></td>
                <td>Total Selling Price</td>
                <td><?php echo e(splitUnit($data->quantity_selling_market == null ? '' : $data->quantity_selling_market)[1]); ?></td>
             <?php
                $s = $data->quantity_selling_market === null ? '' : splitUnit($data->quantity_selling_market)[0];
                $t = $data->average_selling_price === null ? '' : splitUnit($data->average_selling_price)[0];
                $totalavgs = $s * $t;
              ?>
                <td><?php echo e($totalavgs); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                e
                </td>
                <td></td>
                <td></td>
                <td>
                 Total Production of By-Product
                </td>
                
                <td>
                 <?php echo e($data->other_product_production == null ? '' : $data->other_product_production); ?>

                </td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                f
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Quantity of By-products solds
                </td>
                <td>
                 <?php echo e(splitUnit($data->quantity_selling_other == null ? '' : $data->quantity_selling_other)[1]); ?>

                </td>
              
                <td><?php echo e(splitUnit($data->quantity_selling_other == null ? '' : $data->quantity_selling_other)[0]); ?></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                 g
                </td>
                <td></td>
                <td></td>
                <td>
                Average Selling Price of By-products
                </td>
                <td> <?php echo e(splitUnit($data->average_selling_other == null ? '' : $data->average_selling_other)[1]); ?></td>
                <td><?php echo e(splitUnit($data->average_selling_other == null ? '' : $data->average_selling_other)[0]); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">h</td>
                <td></td>
                <td></td>
                <td>Total Selling Price of By-products</td>
                <td></td>
                
                <?php
                    $st = $data->quantity_selling_other === null ? '' : splitUnit($data->quantity_selling_other)[0];
                    $tk = $data->average_selling_other === null ? '' : splitUnit($data->average_selling_other)[0];
                    $totalsellingpri = $st * $tk;
                ?>
                
                <td><?php echo e($totalsellingpri); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                i
                </td>
                <td></td>
                <td></td>
                  <td>
                  Avarage Lactetation period
                </td>
                <td><?php echo e($data->avarage_lactetation_period_unit == null ? '' : $data->avarage_lactetation_period_unit); ?></td>
                
                <td><?php echo e($data->avarage_lactetation_period_days == null ? '' : $data->avarage_lactetation_period_days); ?> days, 
                    <?php echo e($data->avarage_lactetation_period_month == null ? '' : $data->avarage_lactetation_period_month); ?> Months ,
                    <?php echo e($data->avarage_lactetation_period_year == null ? '' : $data->avarage_lactetation_period_year); ?> Years
                </td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                j
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Place of first sale
                </td>
                <td>
                 
                </td>
                
                <td><?php echo e($data->first_sale_place == null ? '' : $data->first_sale_place); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                12
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                Product/s Sold to
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                a
                </td>

                <td></td>
                <td></td>
                <td>
               Sold to villagers
                </td>
                <td>
                 
                </td>
              
                <td><?php echo e($data->sold_to_villagers == null ? '' : $data->sold_to_villagers == 1 ? 'Y' : 'N'); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
                
                <td></td>
                <td></td>
                <td>
                Sold to Milkman
                </td>
                <td>
                 
                </td>
               
                <td><?php echo e($data->sold_to_milkman == null ? '' : $data->sold_to_milkman); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                c
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Sold to Local Dairy Unit
                </td>
                <td>
                 
                </td>
                
                <td><?php echo e($data->sold_to_local_dairy_unit == null ? '' : $data->sold_to_local_dairy_unit); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                d
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Milk Processing Company
                </td>
                <td>
                 
                </td>
                
                <td><?php echo e($data->milk_processing_company == null ? '' : $data->milk_processing_company); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                e
                </td>
              
                <td></td>
                <td></td>
                  <td>
               Milk Cooperative Society
                </td>
                <td>
                
                </td>
               
                <td><?php echo e($data->milk_cooperative_society == null ? '' : $data->milk_cooperative_society); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                f
                </td>
                
                <td></td>
                <td></td>
                <td>
               Direct Selling to consumer in local market
                </td>
                <td>
                
                </td>
                
              <td><?php echo e($data->direct_sel_loc_mark == null ? '' : $data->direct_sel_loc_mark); ?></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                g
                </td>

                <td></td>
                <td></td>
                <td>
               Sold to other
                </td>
                <td>
                
                </td>
               
              <td><?php echo e($data->sold_to_other == null ? '' : $data->sold_to_other); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                13
                </td>
               
                <td></td>
                <td></td>
                 <td>
               Extent of underweighting (%)
                </td>
                <td>
                 Percent
                </td>
               
                <td><?php echo e($data->under_weighing == 'null' ? '' : $data->under_weighing); ?></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                14
                </td>

                <td></td>
                <td></td>
                                <td>
              Extent of trader’s default (%)
                </td>
                <td>
                 Percent
                </td>
                
                <td><?php echo e($data->trader_default == 'null' ? '' : $data->trader_default); ?></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                15
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Post-Production Losses
                </td>
                <td>
                 
                </td>
               
                <td><?php echo e($data->post_production_losses == 'null' ? '' : $data->post_production_losses); ?></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                16
                </td>
              
                <td>
                 
                </td>
                <td></td>
                <td>
                 Any Other factors
                </td>
                <td></td>
                  
                <td><?php echo e($data->any_other_factors == 'null' ? '' : $data->any_other_factors); ?></td>
               
            </tr>
            
        </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       <?php else: ?>
       <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Animal Name</th>
            </tr>
           
          </thead>
         
            <tr>
                <td style="text-align:center;">
                    1
                </td>
                <td></td>
                <td></td>
                  <td>
                    Number
                </td>
                <td>
                </td>
               
                <td>
                </td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
              
                <td></td>
                <td></td>
                  <td>
                    Breed
                </td>
                <td>
                   
                </td>
                
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                <td></td>
                <td></td>
                 <td>
                    Generation ( First / Second / Third / Fourth/Fifth)
                </td>
                <td>
                   
                </td>
             
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
            
                <td></td>
                <td></td>
                    <td style="font-weight:700;">
                   Green Feed 
                </td>
                <td>
                  
                </td>
                
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                <td></td>
                <td></td>
                 <td>
                   Quantity of Green Fodder
                </td>
                <td>
                </td>
             
                <td>
                </td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Expenses on Greed Fodder
                </td>
                
                <td>
                </td>
               
                <td>
                </td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    5
                </td>

                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                  Dry Feed
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>

                <td></td>
                <td></td>
                <td>
                 Quantity of Dry Fodder
                </td>
                <td>
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Expenses on Dry Fodder
                </td>
                <td>
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    6
                </td>
                
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                 Conventional Feed
                </td>
                <td>
                </td>
                
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                <td>
                 
                </td>
                <td></td>
                 <td>
                 Quantity of Conventional Feed 
                </td>
              
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
             
                <td></td>
                <td></td>
                   <td>
                 Expenditure on Conventional Feed 
                </td>
                <td>
                </td>

                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    7
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                 Commercial Feed
                </td>
                <td>
                
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Quantity of Commercial Feed 
                </td>
                <td>
                </td>

                <td></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Expenses of Commercial Feed 
                </td>
                <td>
                </td>
            
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Local
                </td>
                <td>
                 
                </td>
          
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>

                <td></td>
                <td></td>
                <td>
                 Branded
                </td>
                <td>

                </td>
             
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Expenditure on Health / Veterinary Services
                </td>
                <td>
                </td>
                
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    9
                </td>
                
                <td></td>
                <td></td>
                <td>
                Distance of Veterinary Services
                </td>
                <td>
                </td>
             
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    10
                </td>
                
                <td></td>
                <td></td>
                <td>
                Quality Of Veterinary Services
                </td>
                <td>
                 
                </td>
              
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    11
                </td>
              
                <td></td>
                <td></td>
                  <td style="font-weight:700;">
               Main Product (Milk/Ghee, Curd/Meat/Egg etc.)
                </td>
                <td>
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
             
                <td></td>
                <td></td>
                   <td>
                  Total Production of Main Product
                </td>
                <td>
                </td>
              
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Quantity Sold
                </td>
                <td>
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                c
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Average Selling Price
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                d
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Total Production of By-Product
                </td>
                <td>
                </td>
            
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                e
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Quantity of By-products solds
                </td>
                <td>
                </td>
              
                <td></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                f
                </td>
                
                <td></td>
                <td></td>
                <td>
                Average Selling Price of By-products
                </td>
                <td>
                 
                </td>
             
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                g
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Place of first sale
                </td>
                <td>
                 
                </td>
                
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                12
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                Product/s Sold to
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                a
                </td>

                <td></td>
                <td></td>
                <td>
               Sold to villagers
                </td>
                <td>
                 
                </td>
              
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
                
                <td></td>
                <td></td>
                <td>
                Sold to Milkman
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                c
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Sold to Local Dairy Unit
                </td>
                <td>
                 
                </td>
                
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                d
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Milk Processing Company
                </td>
                <td>
                 
                </td>
                
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                e
                </td>
              
                <td></td>
                <td></td>
                  <td>
               Milk Cooperative Society
                </td>
                <td>
                
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                f
                </td>
                
                <td></td>
                <td></td>
                <td>
               Direct Selling to consumer in local market
                </td>
                <td>
                
                </td>
                <td></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                g
                </td>

                <td></td>
                <td></td>
                <td>
               Sold to other
                </td>
                <td>
                
                </td>
               
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                13
                </td>
               
                <td></td>
                <td></td>
                 <td>
               Extent of underweighting (%)
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                14
                </td>

                <td></td>
                <td></td>
                                <td>
              Extent of trader’s default (%)
                </td>
                <td>
                 
                </td>
                
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                15
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Post-Production Losses
                </td>
                <td>
                 
                </td>
               
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                16
                </td>
              
                <td>
                 
                </td>
                <td></td>
                <td>
                 Any Other factors
                </td>
                <td></td>
                  
                <td></td>
               
            </tr>
            
        </table>
       <?php endif; ?>
    </div>
</div>
<script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-four.blade.php ENDPATH**/ ?>