
<?php $__env->startSection('title', 'Add Hectare Masters'); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Hectare Masters</h1>
        <a href="<?php echo e(route('hectareMaster.index')); ?>" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
        <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back</a>
    </div>
    
    <?php echo $__env->make('common.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Add New Hectare Masters</h6>
        </div>
        <form method="POST" action="<?php echo e(route('hectareMaster.store')); ?>">
            <?php echo csrf_field(); ?>
            <div class="card-body">
                <div class="form-group row">
                    <div class="col-sm-6 mb-3 mt-3 mb-sm-0">
                        <span style="color:red;">*</span>Role</label>
                        <select class="form-control form-control-user <?php $__errorArgs = ['role_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="roleSelect" name="role_id">
                            <option selected disabled>Select Role</option>
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role->id); ?>"><?php echo e($role->role_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['role_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-sm-6 mb-3 mt-3 mb-sm-0">
                        <span style="color:red;">*</span><label>User</label>
                        <select class="form-control form-control-user <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="userSelect" name="user_id" required>
                            <option selected disabled>Select User</option>
                        </select>
                        <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="col-sm-6 mb-3 mt-3 mb-sm-0"><label>Status</label>
                        <select class="form-control form-control-user <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="status">
                            <option selected disabled>Select Status</option>
                            <option value="1" selected>Active</option>
                            <option value="0">Inactive</option>
                        </select>
                        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="form-group row">
                    <div class="col-sm-12 mb-6 mt-6 mb-sm-0">
                        <div id="addMoreContainer">
                            <!-- Initial section or input fields -->
                            <div class="added-section" style="margin-bottom: 10px;">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <label>1 Hectare : </label>
                                    </div>
                                    <div class="col-sm-3">
                                        <input type="text" class="form-control" placeholder="Value" name="hectare[0][value]">
                                    </div>
                                    <div class="col-sm-3">
                                        <input type="text" class="form-control" placeholder="Unit" name="hectare[0][unit]">
                                    </div>
                                    <div class="col-sm-3">
                                        <a href="#" class="btn btn-danger  remove-section" style="margin-right: 10px;">Remove</a>
                                        <a href="#" id="addMoreButton" class="btn btn-primary" style="margin-right: 10px;">Add</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-success btn-user float-right mb-3">Save</button>
                <a class="btn btn-primary float-right mr-3 mb-3" href="<?php echo e(route('roles.index')); ?>">Cancel</a>
            </div>
        </form>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        $('body').on('change','#roleSelect',function() {
            var roleId = $(this).val();
            if (roleId) {
                $.ajax({
                    url: '<?php echo e(route("hectareMaster.getUsersByRole", ":roleId")); ?>'.replace(':roleId', roleId),
                    type: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        var users = response.users;
                        var userSelect = $('#userSelect');
                        userSelect.find('option').not(':first').remove();
                        $.each(users, function(index, user) {
                            if(user.last_name == null){
                                user.last_name = '';
                            }
                            userSelect.append('<option value="' + user.id + '">' + user.first_name +' '+ user.last_name +'</option>');
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            }
        });
    });
    
    $('#roleSelect').change(function() {
        var roleId = $(this).val(); 
        if (roleId) {
            fetchUsers(roleId);
        } else {
            $('#userSelect').empty().append('<option selected disabled>Select User</option>');
        }
    });
    
    $(document).ready(function() {
        var sectionIndex = 1; 
        
        $('#addMoreContainer').on('click', '#addMoreButton', function(e) 
        {
            e.preventDefault();
            var clonedSection = $('.added-section:first').clone();
            clonedSection.find('input[type="text"]').val('');
            clonedSection.find('input[type="text"]').each(function() 
            {
                var currentName = $(this).attr('name');
                $(this).attr('name', currentName.replace(/\[\d+\]/, '[' + sectionIndex + ']'));
            });
            
            $('#addMoreContainer').append(clonedSection);
            if ($('#addMoreContainer .added-section').length > 1) 
            {
                clonedSection.find('.remove-section').show();
            } else {
                clonedSection.find('.remove-section').hide();
            }
            sectionIndex++; 
        });
        
        $('#addMoreContainer').on('click', '.remove-section', function(e) 
        {
            e.preventDefault();
            $(this).closest('.added-section').remove();
            $('#addMoreContainer .added-section').each(function(index) 
            {
                $(this).find('input[type="text"]').each(function() {
                    var currentName = $(this).attr('name');
                    $(this).attr('name', currentName.replace(/\[\d+\]/, '[' + index + ']'));
                });
                
                if ($('#addMoreContainer .added-section').length > 1)
                {
                    $(this).find('.remove-section').show();
                } else {
                    $(this).find('.remove-section').hide();
                }
            });
            sectionIndex--; 
        });
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/hectareMaster/add.blade.php ENDPATH**/ ?>