<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
     <div class="table-responsive">
       <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            <?php if($deshboard == 1): ?>
        
            <?php else: ?>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.fpo_a')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.six.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            <?php endif; ?>
        </div>
         <br>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Format VII-A : Resource Mapping of FPO value chain actor of concerned cluster</h1>
           
        </div>
        
        <?php if($data->isNotEmpty()): ?>    
        <?php
            $si = 1;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Resources of FPO</th>
            <th>Unit (Wherever Applicable) </th>
            <th>Quantitative / Qualitative Indicator</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
          <tr>
          
            <td><?php echo e($si++); ?></td>
             <td><?php echo e($datas->farmer_code_id); ?></td>
            <td><?php echo e($datas->first_name == 'null' ? '' : $datas->first_name.' '.$datas->last_name); ?></td>
            <td style="font-weight:700;" colspan="4">Physical Resources</td>
          
         </tr>   
         
         <tr>
            <?php
             $potential = json_decode($datas->potential_marketable_and_marketed_surplus, true);
            ?> 
            <td>a</td>
             <td></td>
            <td></td>
            <td>Potential marketable and marketed surplus single or multiple commodities</td>
            <td><?php echo e($potential['unit'] ?? ''); ?></td>
           <td><?php echo e($potential['indicator'] ?? ''); ?></td>
           <td><?php echo e($potential['remark'] ?? ''); ?></td>
         </tr>
         
          <tr>
              <?php
                $extent = json_decode($datas->extent_and_status_allied_agriculture_sector, true);
                ?>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Extent and status of allied agriculture sector</td>
             <td><?php echo e($extent['unit'] ?? ''); ?></td>
             <td><?php echo e($extent['indicator'] ?? ''); ?></td>
             <td><?php echo e($extent['remark'] ?? ''); ?></td>
         </tr>  
         
          <tr>
            <td>2</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;" colspan="4">Financial Resources</td>
           
         </tr> 
         
          <tr>
                <?php
                $equity_share = json_decode($datas->equity_share, true);
                ?>
            <td>a</td>
             <td></td>
            <td></td>
            <td >Equity share</td>
            <td><?php echo e($equity_share['unit'] ?? ''); ?></td>
            <td><?php echo e($equity_share['indicator'] ?? ''); ?></td>
            <td><?php echo e($equity_share['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
                <?php
                $equity_grant = json_decode($datas->equity_grant, true);
                ?>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Equity grant</td>
             <td><?php echo e($equity_grant['unit'] ?? ''); ?></td>
            <td><?php echo e($equity_grant['indicator'] ?? ''); ?></td>
            <td><?php echo e($equity_grant['remark'] ?? ''); ?></td>
         </tr> 
         
        <tr>
             <?php
            $promotional_and_development = json_decode($datas->promotional_and_development, true);
            ?>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Promotional and development support </td>
           <td><?php echo e($promotional_and_development['unit'] ?? ''); ?></td>
            <td><?php echo e($promotional_and_development['indicator'] ?? ''); ?></td>
            <td><?php echo e($promotional_and_development['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
              <?php
        $interest_and_capital_subsidies = json_decode($datas->interest_and_capital_subsidies, true);
        ?>
            <td>d</td>
             <td></td>
            <td></td>
            <td>Interest and capital subsidies</td>
            <td><?php echo e($interest_and_capital_subsidies['unit'] ?? ''); ?></td>
            <td><?php echo e($interest_and_capital_subsidies['indicator'] ?? ''); ?></td>
            <td><?php echo e($interest_and_capital_subsidies['remark'] ?? ''); ?></td>
         </tr> 
          
         
         <tr>
              <?php
            $csr_fund = json_decode($datas->csr_fund, true);
            ?>
            <td>e</td>
             <td></td>
            <td></td>
            <td>CSR fund</td>
              <td><?php echo e($csr_fund['unit'] ?? ''); ?></td>
            <td><?php echo e($csr_fund['indicator'] ?? ''); ?></td>
            <td><?php echo e($csr_fund['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <?php
            $donations_awards = json_decode($datas->donations_awards, true);
            ?>
            <td>f</td>
             <td></td>
            <td></td>
            <td >Donations / Awards</td>
          <td><?php echo e($donations_awards['unit'] ?? ''); ?></td>
          <td><?php echo e($donations_awards['indicator'] ?? ''); ?></td>
          <td><?php echo e($donations_awards['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <?php
            $supply_credit = json_decode($datas->supply_credit, true);
            ?>
            <td>g</td>
             <td></td>
            <td></td>
            <td>Supply Credit</td>
            <td><?php echo e($supply_credit['unit'] ?? ''); ?></td>
            <td><?php echo e($supply_credit['indicator'] ?? ''); ?></td>
            <td><?php echo e($supply_credit['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
                <?php
                $input_credit = json_decode($datas->input_credit, true);
                ?>
            <td>h</td>
             <td></td>
            <td></td>
            <td>Input Credit </td>
           <td><?php echo e($input_credit['unit'] ?? ''); ?></td>
            <td><?php echo e($input_credit['indicator'] ?? ''); ?></td>
            <td><?php echo e($input_credit['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
                 <?php
                $director_member_debt = json_decode($datas->director_member_debt, true);
                ?>
            <td>i</td>
             <td></td>
            <td></td>
            <td>Director / Member debt</td>
              <td><?php echo e($director_member_debt['unit'] ?? ''); ?></td>
            <td><?php echo e($director_member_debt['indicator'] ?? ''); ?></td>
            <td><?php echo e($director_member_debt['remark'] ?? ''); ?></td>
         </tr> 
         
         
         
         <tr>
               <?php
                $reserve_and_surplus_form_busi = json_decode($datas->reserve_and_surplus_form_busi, true);
                ?>
            <td>j</td>
             <td></td>
            <td></td>
            <td>Reserve and surplus from business operations</td>
           <td><?php echo e($reserve_and_surplus_form_busi['unit'] ?? ''); ?></td>
          <td><?php echo e($reserve_and_surplus_form_busi['indicator'] ?? ''); ?></td>
          <td><?php echo e($reserve_and_surplus_form_busi['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
               <?php
                $loan_and_advances = json_decode($datas->loan_and_advances, true);
                ?>
            <td>k</td>
             <td></td>
            <td></td>
            <td>Loan and advances</td>
            <td><?php echo e($loan_and_advances['unit'] ?? ''); ?></td>
            <td><?php echo e($loan_and_advances['indicator'] ?? ''); ?></td>
            <td><?php echo e($loan_and_advances['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            
            <td style="font-weight:700;">3</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;" colspan="4">Level of Skilled Human Resources</td>
           
         </tr> 
         
         
        <tr>
             <?php
            $bdos = json_decode($datas->bdos, true);
            ?>
            <td>a</td>
             <td></td>
            <td></td>
            <td>BODs</td>
            <td><?php echo e($bdos['unit'] ?? ''); ?></td>
            <td><?php echo e($bdos['indicator'] ?? ''); ?></td>
            <td><?php echo e($bdos['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
                 <?php
                $ceo = json_decode($datas->ceo, true);
                ?>
            <td>b</td>
             <td></td>
            <td></td>
            <td>CEO</td>
             <td><?php echo e($ceo['unit'] ?? ''); ?></td>
            <td><?php echo e($ceo['indicator'] ?? ''); ?></td>
            <td><?php echo e($ceo['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
                <?php
                $managers = json_decode($datas->managers, true);
                ?>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Managers</td>
          <td><?php echo e($managers['unit'] ?? ''); ?></td>
            <td><?php echo e($managers['indicator'] ?? ''); ?></td>
            <td><?php echo e($managers['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
             <?php
                $accountant = json_decode($datas->accountant, true);
                ?>
            <td>d</td>
             <td></td>
            <td></td>
            <td>Accountant</td>
              <td><?php echo e($accountant['unit'] ?? ''); ?></td>
            <td><?php echo e($accountant['indicator'] ?? ''); ?></td>
            <td><?php echo e($accountant['remark'] ?? ''); ?></td>
                 </tr> 
         
           <tr>
                <?php
        $supporting_staff = json_decode($datas->supporting_staff, true);
        ?>
            <td>e</td>
             <td></td>
            <td></td>
            <td>Supporting staff </td>
             <td><?php echo e($supporting_staff['unit'] ?? ''); ?></td>
    <td><?php echo e($supporting_staff['indicator'] ?? ''); ?></td>
    <td><?php echo e($supporting_staff['remark'] ?? ''); ?></td>
         </tr> 
         
        <tr>
            <td style="font-weight:700;">4</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;" colspan="4">Technological Resources</td>
           
         </tr> 
         
          <tr>
            <?php
            $technologies_before_the_farm_link = json_decode($datas->technologies_before_the_farm_link, true);
            ?>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Technologies before the farm link</td>
           <td><?php echo e($technologies_before_the_farm_link['unit'] ?? ''); ?></td>
            <td><?php echo e($technologies_before_the_farm_link['indicator'] ?? ''); ?></td>
            <td><?php echo e($technologies_before_the_farm_link['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              <?php
            $technologies_farm_and_producer_link = json_decode($datas->technologies_farm_and_producer_link, true);
            ?>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Technologies farm and producer link</td>
              <td><?php echo e($technologies_farm_and_producer_link['unit'] ?? ''); ?></td>
            <td><?php echo e($technologies_farm_and_producer_link['indicator'] ?? ''); ?></td>
            <td><?php echo e($technologies_farm_and_producer_link['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              <?php
            $technologies_after_farm_link = json_decode($datas->technologies_after_farm_link, true);
            ?>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Technologies after farm link</td>
             <td><?php echo e($technologies_after_farm_link['unit'] ?? ''); ?></td>
            <td><?php echo e($technologies_after_farm_link['indicator'] ?? ''); ?></td>
            <td><?php echo e($technologies_after_farm_link['remark'] ?? ''); ?></td>
         </tr> 
         
           <tr>
            <td style="font-weight:700;">5</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Informational Resources</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
             <?php
            $flow_informat_on_and_knowledge_across = json_decode($datas->flow_informat_on_and_knowledge_across, true);
            ?>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Flow of information and knowledge across the value chains</td>
              <td><?php echo e($flow_informat_on_and_knowledge_across['unit'] ?? ''); ?></td>
                <td><?php echo e($flow_informat_on_and_knowledge_across['indicator'] ?? ''); ?></td>
                <td><?php echo e($flow_informat_on_and_knowledge_across['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
               <?php
                $flow_of_information_of_actors = json_decode($datas->flow_of_information_of_actors, true);
                ?>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Flow of information of actors and factors</td>
           <td><?php echo e($flow_of_information_of_actors['unit'] ?? ''); ?></td>
            <td><?php echo e($flow_of_information_of_actors['indicator'] ?? ''); ?></td>
            <td><?php echo e($flow_of_information_of_actors['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">6</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;" colspan="4">Intangible Resources</td>
           
         </tr> 
         
          <tr>
             <?php
            $brand_development_process_innovation_patent_gI_Indicator = json_decode($datas->brand_development_process_innovation_patent_gI_Indicator, true);
            ?>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Brand Development / Process innovation / Patent / GI Indicator</td>
            <td><?php echo e($brand_development_process_innovation_patent_gI_Indicator['unit'] ?? ''); ?></td>
            <td><?php echo e($brand_development_process_innovation_patent_gI_Indicator['indicator'] ?? ''); ?></td>
            <td><?php echo e($brand_development_process_innovation_patent_gI_Indicator['remark'] ?? ''); ?></td>
         </tr> 
         
         
          <tr>
            <td style="font-weight:700;">7</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;" colspan="4">Trade Contract / collaboration</td>
           
         </tr> 
         
          <tr>
                <?php
                $b2b_b2c_fpos = json_decode($datas->b2b_b2c_fpos, true);
                ?>
            <td>a</td>
             <td></td>
            <td></td>
            <td>B2B and B2C networks and federations of FPOs</td>
            <td><?php echo e($b2b_b2c_fpos['unit'] ?? ''); ?></td>
            <td><?php echo e($b2b_b2c_fpos['indicator'] ?? ''); ?></td>
            <td><?php echo e($b2b_b2c_fpos['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              <?php
                $corporate_linkages = json_decode($datas->corporate_linkages, true);
                ?>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Corporate linkages</td>
             <td><?php echo e($corporate_linkages['unit'] ?? ''); ?></td>
            <td><?php echo e($corporate_linkages['indicator'] ?? ''); ?></td>
            <td><?php echo e($corporate_linkages['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              <?php
            $future_marketing = json_decode($datas->future_marketing, true);
            ?>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Future Marketing</td>
            <td><?php echo e($future_marketing['unit'] ?? ''); ?></td>
            <td><?php echo e($future_marketing['indicator'] ?? ''); ?></td>
            <td><?php echo e($future_marketing['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
               <?php
                $contract_farming = json_decode($datas->contract_farming, true);
                ?>
            <td>d</td>
             <td></td>
            <td></td>
            <td>Contract Farming  </td>
              <td><?php echo e($contract_farming['unit'] ?? ''); ?></td>
            <td><?php echo e($contract_farming['indicator'] ?? ''); ?></td>
            <td><?php echo e($contract_farming['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              <?php
            $fpo_federation = json_decode($datas->fpo_federation, true);
            ?>
            <td>e</td>
             <td></td>
            <td></td>
            <td>FPO federation </td>
             <td><?php echo e($fpo_federation['unit'] ?? ''); ?></td>
            <td><?php echo e($fpo_federation['indicator'] ?? ''); ?></td>
            <td><?php echo e($fpo_federation['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">8</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;" colspan="4">Infrastructure and Support services</td>
         </tr> 
         
          <tr>
               <?php
                $inbound_infrastructure_and_services = json_decode($datas->inbound_infrastructure_and_services, true);
                ?>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Inbound Infrastructure and services</td>
                <td><?php echo e($inbound_infrastructure_and_services['unit'] ?? ''); ?></td>
            <td><?php echo e($inbound_infrastructure_and_services['indicator'] ?? ''); ?></td>
            <td><?php echo e($inbound_infrastructure_and_services['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
               <?php
                $processing_infrastructure = json_decode($datas->processing_infrastructure, true);
                ?>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Processing Infrastructure</td>
            <td><?php echo e($processing_infrastructure['unit'] ?? ''); ?></td>
            <td><?php echo e($processing_infrastructure['indicator'] ?? ''); ?></td>
            <td><?php echo e($processing_infrastructure['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
               <?php
                $outbound_infrastructure_and_services = json_decode($datas->outbound_infrastructure_and_services, true);
                ?>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Outbound infrastructure and services</td>
           <td><?php echo e($outbound_infrastructure_and_services['unit'] ?? ''); ?></td>
            <td><?php echo e($outbound_infrastructure_and_services['indicator'] ?? ''); ?></td>
            <td><?php echo e($outbound_infrastructure_and_services['remark'] ?? ''); ?></td>
         </tr> 
         
        </tbody>
  </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Resources of FPO</th>
            <th>Unit (Wherever Applicable) </th>
            <th>Quantitative / Qualitative Indicator</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
             <td></td>
            <td></td>
            <td>Physical Resources</td>
            <td></td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Potential marketable and marketed surplus single or multiple commodities</td>
            <td></td>
            <td></td>
             <td></td>
         </tr>
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Extent and status of allied agriculture sector</td>
            <td></td>
            <td></td>
             <td></td>
         </tr>  
         
          <tr>
            <td>2</td>
             <td></td>
            <td></td>
            <td>Financial Resources</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td >Equity share</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Equity grant</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
           <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Promotional and development support </td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
           <tr>
            <td>d</td>
             <td></td>
            <td></td>
            <td>Interest and capital subsidies</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
          
         
         <tr>
            <td>e</td>
             <td></td>
            <td></td>
            <td>CSR fund</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td>f</td>
             <td></td>
            <td></td>
            <td >Donations / Awards</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td>g</td>
             <td></td>
            <td></td>
            <td>Supply Credit</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         <tr>
            <td>h</td>
             <td></td>
            <td></td>
            <td>Input Credit </td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td>i</td>
             <td></td>
            <td></td>
            <td>Director / Member debt</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         
         
         <tr>
            <td>j</td>
             <td></td>
            <td></td>
            <td>Reserve and surplus from business operations</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td>k</td>
             <td></td>
            <td></td>
            <td>Loan and advances</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">3</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Level of Skilled Human Resources</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         
        <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>BODs</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>CEO</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Managers</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>d</td>
             <td></td>
            <td></td>
            <td>Accountant</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>e</td>
             <td></td>
            <td></td>
            <td>Supporting staff </td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td style="font-weight:700;">4</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Technological Resources</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Technologies before the farm link</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Technologies farm and producer link</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Technologies after farm link</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td style="font-weight:700;">5</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Informational Resources</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Flow of information and knowledge across the value chains</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Flow of information of actors and factors</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">6</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Intangible Resources</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Brand Development / Process innovation / Patent / GI Indicator</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
          <tr>
            <td style="font-weight:700;">7</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Trade Contract / collaboration</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>B2B and B2C networks and federations of FPOs</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Corporate linkages</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Future Marketing</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>d</td>
             <td></td>
            <td></td>
            <td>Contract Farming  </td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>e</td>
             <td></td>
            <td></td>
            <td>FPO federation </td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">8</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Infrastructure and Support services</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Inbound Infrastructure and services</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Processing Infrastructure</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Outbound infrastructure and services</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        </tbody>
  </table>
        <?php endif; ?>

    </div>
    
</div>

    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/fpo-a.blade.php ENDPATH**/ ?>