<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            <?php if($deshboard == 1): ?>
        
            <?php else: ?>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.five')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.five.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            <?php endif; ?>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Quantitative Data from Input suppliers</h1>
        </div>

    <?php if($data->isNotEmpty()): ?> 
        <?php
            $si = 1;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="table-responsive">
           <h3>A  . Infrastructure and Support Services</h3>
        <table class="table table-bordered">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Unit Rate</th>
            <th>Amt (Rs.)</th>
            <th>Annualized Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
            <tr>
               <?php
                 $shop_permanent= json_decode($datas->cost_of_establishment_of_input_shop_permanent, true);
                ?>
            <td><?php echo e($si++); ?></td>
            <td><?php echo e($datas->farmer_code_id); ?></td>
            <td><?php echo e($datas->first_name); ?> <?php echo e($datas->last_name); ?></td>
            <td>Cost of establishment of Input Shop Permanent</td>
           <td><?php echo e($shop_permanent['unit'] ?? ''); ?></td>
            <td><?php echo e($shop_permanent['unitRate'] ?? ''); ?></td>
            <td><?php echo e($shop_permanent['amount'] ?? ''); ?></td>
    
            <?php
                $annualizedcostPer = isset($shop_permanent['amount']) && isset($perYear->year) && $perYear->year != 0 
                    ? $shop_permanent['amount'] / $perYear->year 
                    : null;
            ?>
            
            <td><?php echo e($annualizedcostPer !== null ? number_format($annualizedcostPer, 2) : ''); ?></td>
            <!--<td><?php echo e($annualizedcostPer ?? ''); ?></td>-->
            
            <td><?php echo e($shop_permanent['remark'] ?? ''); ?></td>
          </tr>
          
          <tr>
               <?php
                 $shop_temporary= json_decode($datas->cost_of_establishment_of_input_shop_temporary, true);
                ?>
            <td><?php echo e($si++); ?></td>
            <td></td>
            <td></td>
            <td>Cost of establishment of Input Shop Temporary</td>
           <td><?php echo e($shop_temporary['unit'] ?? ''); ?></td>
            <td><?php echo e($shop_temporary['unitRate'] ?? ''); ?></td>
            <td><?php echo e($shop_temporary['amount'] ?? ''); ?></td>
            
            
           <?php
                $annualizedcosttemp = isset($shop_temporary['amount']) && isset($tempYear->year) && $tempYear->year != 0 
                    ? $shop_temporary['amount'] / $tempYear->year 
                    : null;
            ?>
            
            <td><?php echo e($annualizedcosttemp ?? ''); ?></td>
            
            
            <td><?php echo e($shop_temporary['remark'] ?? ''); ?></td>
          </tr>
            
        
          
          <tr>
              <?php
             $sidd = json_decode($datas->storage_structure_of_input, true);
            ?>
            <td>2</td>
            <td></td>
            <td></td>
            <td>Cost Storage Structure for Inputs</td>
            <td><?php echo e($sidd['unit'] ?? ''); ?></td>
            <td><?php echo e($sidd['unitRate'] ?? ''); ?></td>
            
            <!--<td><?php echo e($sidd['amount'] ?? ''); ?></td>-->
            
             <td><?php echo e(isset($sidd['unitRate']) ? $sidd['unitRate'] * 500 : null); ?></td>
             
            <?php
            $storagestc = isset($sidd['unitRate']) && isset($stogest->year) && $stogest->year != 0 
                ? ($sidd['unitRate'] * 500) / $stogest->year 
                : null;
            ?> 
    
            <td><?php echo e($storagestc ?? ''); ?></td> 
            
            <td><?php echo e($sidd['remark'] ?? ''); ?></td>
          </tr>
          
          <tr>
            <?php
             $ss = json_decode($datas->other_infrastructure_input, true);
            ?>
            <td>3</td>
            <td></td>
            <td></td>
            <td>Cost other Infrastructure for Inputs</td>
            <td><?php echo e($ss['unit'] ?? ''); ?></td>
            <td><?php echo e($ss['unitRate'] ?? ''); ?></td>
            <td><?php echo e($ss['amount'] ?? ''); ?></td>
            <td><?php echo e($ss['annualCost'] ?? ''); ?></td>
            <td><?php echo e($ss['remark'] ?? ''); ?></td>
           </tr>
            
         <tr>
               <?php
             $me = json_decode($datas->monthly_expenses_on_electricity, true);
            ?>
            <td>4</td>
            <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td><?php echo e($me['unit'] ?? ''); ?></td>
            <td><?php echo e($me['unitRate'] ?? ''); ?></td>
            <td><?php echo e($me['amount'] ?? ''); ?></td>
            
            <?php
                $monthelectricdata = isset($me['amount']) && isset($monthElectricity->year) && $monthElectricity->year != 0 
                    ? $me['amount'] / $monthElectricity->year 
                    : null;
            ?>
            
            <td><?php echo e($monthelectricdata ?? ''); ?></td>
            
            <td><?php echo e($me['remark'] ?? ''); ?></td>
          </tr>
          
          
          <tr>
               <?php
             $mem = json_decode($datas->monthly_expenses_on_manpower, true);
            ?>
            <td>5</td>
            <td></td>
            <td></td>
            <td>Monthly Expenses on Manpower</td>
            <td><?php echo e($mem['unit'] ?? ''); ?></td>
            <td><?php echo e($mem['unitRate'] ?? ''); ?></td>
            <td><?php echo e($mem['amount'] ?? ''); ?></td>
            <td><?php echo e($mem['annualCost'] ?? ''); ?></td>
            <td><?php echo e($mem['remark'] ?? ''); ?></td>
           </tr>
          
           <tr>
           <?php
             $mr = json_decode($datas->monthly_rent, true);
            ?>
            <td>6</td>
            <td></td>
            <td></td>
            <td>Monthly rent ( If shop is on rent)</td>
             <td><?php echo e($mr['unit'] ?? ''); ?></td>
            <td><?php echo e($mr['unitRate'] ?? ''); ?></td>
            <td><?php echo e($mr['amount'] ?? ''); ?></td>
            <td><?php echo e($mr['annualCost'] ?? ''); ?></td>
            <td><?php echo e($mr['remark'] ?? ''); ?></td>
           </tr>
           
            <tr>
                 <?php
             $mte = json_decode($datas->monthly_travelling_expense, true);
            ?>
            <td>7</td>
            <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td><?php echo e($mte['unit'] ?? ''); ?></td>
            <td><?php echo e($mte['unitRate'] ?? ''); ?></td>
            <td><?php echo e($mte['amount'] ?? ''); ?></td>
            <td><?php echo e($mte['annualCost'] ?? ''); ?></td>
            <td><?php echo e($mte['remark'] ?? ''); ?></td>
           </tr>
           
          
           
           <tr>
            <?php
             $cea_data = json_decode($datas->computer_electronic_assoceris, true);
            ?>
            <td>8</td>
            <td></td>
            <td></td>
            <td>Computer Electronic Assoceris </td>
            <td><?php echo e($cea_data['unit'] ?? ''); ?></td>
            <td><?php echo e($cea_data['unitRate'] ?? ''); ?></td>
            <td><?php echo e($cea_data['amount'] ?? ''); ?></td>
            
             <?php
                $compdata = isset($cea_data['amount']) && isset($computerasso->year) && $computerasso->year != 0 
                    ? $cea_data['amount'] / $computerasso->year 
                    : null;
            ?>
            
            <!--<td><?php echo e($compdata ?? ''); ?></td>-->
            <td><?php echo e($compdata !== null ? number_format($compdata, 2) : ''); ?></td>
            <td><?php echo e($cea_data['remark'] ?? ''); ?></td>
           </tr>
           
          <tr>
            <?php
             $plant_machinary = json_decode($datas->plant_machinary, true);
            ?>
            <td>9</td>
            <td></td>
            <td></td>
            <td>Plant Machinary </td>
            <td><?php echo e($plant_machinary['unit'] ?? ''); ?></td>
            <td><?php echo e($plant_machinary['unitRate'] ?? ''); ?></td>
            <td><?php echo e($plant_machinary['amount'] ?? ''); ?></td>
            
            <?php
                $plantdata = isset($plant_machinary['amount']) && isset($plant->year) && $plant->year != 0 
                    ? $plant_machinary['amount'] / $plant->year 
                    : null;
            ?>
            
            <td><?php echo e($plantdata !== null ? number_format($plantdata, 2) : ''); ?></td>
            <td><?php echo e($plant_machinary['remark'] ?? ''); ?></td>
           </tr>
           
           <tr>
            <?php
             $electric_moter = json_decode($datas->electric_moter, true);
            ?>
            <td>10</td>
            <td></td>
            <td></td>
            <td>ELECTRIC MOTOR</td>
            <td><?php echo e($electric_moter['unit'] ?? ''); ?></td>
            <td><?php echo e($electric_moter['unitRate'] ?? ''); ?></td>
            <td><?php echo e($electric_moter['amount'] ?? ''); ?></td>
            
            <?php
                $electricdata = isset($electric_moter['amount']) && isset($electricmoter->year) && $electricmoter->year != 0 
                    ? $electric_moter['amount'] / $electricmoter->year 
                    : null;
            ?>
            
            <td><?php echo e($electricdata ?? ''); ?></td>
            <td><?php echo e($electric_moter['remark'] ?? ''); ?></td>
           </tr>
           
           
            <tr>
            <?php
             $diseal_engine = json_decode($datas->diseal_engine, true);
            ?>
            <td>10</td>
            <td></td>
            <td></td>
            <td>Diseal Engine </td>
            <td><?php echo e($diseal_engine['unit'] ?? ''); ?></td>
            <td><?php echo e($diseal_engine['unitRate'] ?? ''); ?></td>
            <td><?php echo e($diseal_engine['amount'] ?? ''); ?></td>
            
            <?php
                $disealdata = isset($diseal_engine['amount']) && isset($disealengine->year) && $disealengine->year != 0 
                    ? $diseal_engine['amount'] / $disealengine->year 
                    : null;
            ?>
            
            <td><?php echo e($disealdata ?? ''); ?></td>
            <td><?php echo e($diseal_engine['remark'] ?? ''); ?></td>
           </tr>
           
          <tr>
            <?php
             $tractor = json_decode($datas->tractor, true);
            ?>
            <td>10</td>
            <td></td>
            <td></td>
            <td>Tractor </td>
            <td><?php echo e($tractor['unit'] ?? ''); ?></td>
            <td><?php echo e($tractor['unitRate'] ?? ''); ?></td>
            <td><?php echo e($tractor['amount'] ?? ''); ?></td>
            
             <?php
                $tractordatas = isset($tractor['amount']) && isset($tractorda->year) && $tractorda->year != 0 
                    ? $tractor['amount'] / $tractorda->year 
                    : null;
            ?>
            
            <td><?php echo e($tractordatas ?? ''); ?></td>
            
            <td><?php echo e($tractor['remark'] ?? ''); ?></td>
           </tr>
           
          
           
           
            <tr>
            <?php
             $any_ot = json_decode($datas->any_other, true);
            ?>
            <td>8</td>
            <td></td>
            <td></td>
            <td>Any Other</td>
            <td><?php echo e($any_ot['unit'] ?? ''); ?></td>
            <td><?php echo e($any_ot['unitRate'] ?? ''); ?></td>
            <td><?php echo e($any_ot['amount'] ?? ''); ?></td>
            <td><?php echo e($any_ot['annualCost'] ?? ''); ?></td>
            <td><?php echo e($any_ot['remark'] ?? ''); ?></td>
           </tr>
           
          <!-- Continue adding rows -->
          
            <?php
                $sumOfannual = 
                    ($shop_permanent['amount'] ?? 0) + 
                    ($shop_temporary['amount'] ?? 0) + 
                    (isset($sidd['unitRate']) ? $sidd['unitRate'] * 500 : 0) +
                    ($ss['amount'] ?? 0) + 
                    ($me['amount'] ?? 0) + 
                    ($mem['amount'] ?? 0) + 
                    ($mr['amount'] ?? 0) + 
                    ($mte['amount'] ?? 0) + 
                    ($cea_data['amount'] ?? 0) + 
                    ($plant_machinary['amount'] ?? 0) + 
                    ($electric_moter['amount'] ?? 0) + 
                    ($diseal_engine['amount'] ?? 0) + 
                    ($tractor['amount'] ?? 0) + 
                    ($any_ot['amount'] ?? 0);
            ?>

          
          <tr>
            <td>9</td>
            <td></td>
            <td></td>
            <td>Annual Intt. on Capital Investment</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;"><?php echo e($sumOfannual); ?></td>
            <td></td>
            <td></td>
          </tr>
          <tr>
            <td colspan="7" class=" text-center" style="font-weight:700;">Total Fixed Cost of Input Supplier</td>
          </tr>
          
          <tr>
               <?php
             $awc = json_decode($datas->annual_intt_on_working_capital, true);
            ?>
            <td>11</td>
            <td></td>
            <td></td>
            <td>Annual Intt. on Working Capital</td>
            <td><?php echo e($awc['unit'] ?? ''); ?></td>
            <td><?php echo e($awc['unitRate'] ?? ''); ?></td>
            <td><?php echo e($awc['amount'] ?? ''); ?></td>
            <td><?php echo e($awc['annualCost'] ?? ''); ?></td>
            <td><?php echo e($awc['remark'] ?? ''); ?></td>
          </tr>
          
         <tr>
               <?php
                $picf = json_decode($datas->percentage_of_input_on_credit_farmer, true);
                ?>
            <td>12</td>
            <td></td>
            <td></td>
            <td>Percentage of Inputs on credit to farmer</td>
            <td><?php echo e($picf['unit'] ?? ''); ?></td>
            <td><?php echo e($picf['unitRate'] ?? ''); ?></td>
            <td><?php echo e($picf['amount'] ?? ''); ?></td>
            <td><?php echo e($picf['annualCost'] ?? ''); ?></td>
            <td><?php echo e($picf['remark'] ?? ''); ?></td>
          </tr>
          
           <tr>
            <?php
            $doicf = json_decode($datas->duration_of_input_on_credit_farmer, true);
            ?>
            <td>13</td>
            <td></td>
            <td></td>
            <td>Duration of Inputs on credit to farmer</td>
            <td><?php echo e($doicf['unit'] ?? ''); ?></td>
            <td><?php echo e($doicf['unitRate'] ?? ''); ?></td>
            <td><?php echo e($doicf['amount'] ?? ''); ?></td>
            <td><?php echo e($doicf['annualCost'] ?? ''); ?></td>
            <td><?php echo e($doicf['remark'] ?? ''); ?></td>
          </tr>
          
           <tr>
            <?php
            $eocd = json_decode($datas->extent_of_credit_default, true);
            ?>
            <td>14</td>
            <td></td>
            <td></td>
            <td>Extent of Credit Default</td>
            <td><?php echo e($eocd['unit'] ?? ''); ?></td>
            <td><?php echo e($eocd['unitRate'] ?? ''); ?></td>
            <td><?php echo e($eocd['amount'] ?? ''); ?></td>
            <td><?php echo e($eocd['annualCost'] ?? ''); ?></td>
            <td><?php echo e($eocd['remark'] ?? ''); ?></td>
          </tr>
          
           <tr>
            <?php
             $tec_advi = json_decode($datas->techincal_advisory, true);
            ?>
            <td>15</td>
            <td></td>
            <td></td>
            <td>Technical Advisory services ( Y/N)</td>
           <td><?php echo e($tec_advi['unit'] ?? ''); ?></td>
            <td><?php echo e($tec_advi['unitRate'] ?? ''); ?></td>
            <td><?php echo e($tec_advi['amount'] ?? ''); ?></td>
            <td><?php echo e($tec_advi['annualCost'] ?? ''); ?></td>
            <td><?php echo e($tec_advi['remark'] ?? ''); ?></td>
          </tr>
          
          <!-- Continue adding rows for other data points -->
          <tr>
            <?php
             $any_other_info = json_decode($datas->any_other_information, true);
            ?>
            <td>16</td>
            <td></td>
            <td></td>
            <td>Any other Information</td>
            <td><?php echo e($any_other_info['unit'] ?? ''); ?></td>
            <td><?php echo e($any_other_info['unitRate'] ?? ''); ?></td>
            <td><?php echo e($any_other_info['amount'] ?? ''); ?></td>
            <td><?php echo e($any_other_info['annualCost'] ?? ''); ?></td>
            <td><?php echo e($any_other_info['remark'] ?? ''); ?></td>
          </tr>
        </tbody>
  </table>
        </div>
        </div>
    
        <div class="table-responsive" style="margin-top:40px;">
        <h3>B . Business Economics</h3>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Type of inputs</th>
            <th>Unit</th>
            <th>Average Cost of purchase</th>
            <th>Average Cost of value addition</th>
            <th>Average Sale Price</th>
            <th>Operational Margins (min & Max)</th>
            <th>Seasonal quantum of sale </th>
            <th>Extent of credit default</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
          <tr>
              <?php
             $seed = json_decode($datas->seed, true);
            ?>
               <td>1</td>
            <td><?php echo e($datas->farmer_code_id); ?></td>
            <td><?php echo e($datas->first_name); ?> <?php echo e($datas->last_name); ?></td>
            <td>Seed</td>
            <td><?php echo e($seed['purchase_average_cost_unit'] ?? ''); ?></td>
            <td><?php echo e($seed['purchase_average_cost'] ?? ''); ?></td>
            <td><?php echo e($seed['value_addition_average_cost'] ?? ''); ?></td>
            <td><?php echo e($seed['avrage_sale_price'] ?? ''); ?></td>
            <td>min- <?php echo e($seed['min_operational_margins'] ?? ''); ?> & max- <?php echo e($seed['max_operational_margins'] ?? ''); ?></td>
            <td><?php echo e($seed['seasonal_quantum'] ?? ''); ?></td>
            <td><?php echo e($seed['credit_extent'] ?? ''); ?></td>
            <td><?php echo e($seed['remarks'] ?? ''); ?></td>
          </tr>
          
          <tr>
             <?php
            $fertilizer = json_decode($datas->fertilizer, true);
            ?>
            <td>2</td>
            <td></td>
            <td></td>
            <td>Fertilizer</td>
           <td><?php echo e($fertilizer['purchase_average_cost_unit'] ?? ''); ?></td>
            <td><?php echo e($fertilizer['purchase_average_cost'] ?? ''); ?></td>
            <td><?php echo e($fertilizer['value_addition_average_cost'] ?? ''); ?></td>
            <td><?php echo e($fertilizer['avrage_sale_price'] ?? ''); ?></td>
            <td>min- <?php echo e($fertilizer['min_operational_margins'] ?? ''); ?> & max- <?php echo e($fertilizer['max_operational_margins'] ?? ''); ?></td>
            <td><?php echo e($fertilizer['seasonal_quantum'] ?? ''); ?></td>
            <td><?php echo e($fertilizer['credit_extent'] ?? ''); ?></td>
            <td><?php echo e($fertilizer['remarks'] ?? ''); ?></td>
          </tr>
          <tr>
             <?php
            $nutrients = json_decode($datas->nutrients, true);
            ?>
            <td>3</td>
            <td></td>
            <td></td>
            <td>Nutrients</td>
             <td><?php echo e($nutrients['purchase_average_cost_unit'] ?? ''); ?></td>
                <td><?php echo e($nutrients['purchase_average_cost'] ?? ''); ?></td>
                <td><?php echo e($nutrients['value_addition_average_cost'] ?? ''); ?></td>
                <td><?php echo e($nutrients['avrage_sale_price'] ?? ''); ?></td>
                <td>min- <?php echo e($nutrients['min_operational_margins'] ?? ''); ?> & max- <?php echo e($nutrients['max_operational_margins'] ?? ''); ?></td>
                <td><?php echo e($nutrients['seasonal_quantum'] ?? ''); ?></td>
                <td><?php echo e($nutrients['credit_extent'] ?? ''); ?></td>
                <td><?php echo e($nutrients['remarks'] ?? ''); ?></td>
          </tr>
       
          <tr>
               <?php
                $insecticide_pesticides_herbicides = json_decode($datas->insecticide_pesticides_herbicides, true);
                ?>
            <td>4</td>
            <td></td>
            <td></td>
            <td>Insecticide / Pesticides / Herbicides</td>
             <td><?php echo e($insecticide_pesticides_herbicides['purchase_average_cost_unit'] ?? ''); ?></td>
            <td><?php echo e($insecticide_pesticides_herbicides['purchase_average_cost'] ?? ''); ?></td>
            <td><?php echo e($insecticide_pesticides_herbicides['value_addition_average_cost'] ?? ''); ?></td>
            <td><?php echo e($insecticide_pesticides_herbicides['avrage_sale_price'] ?? ''); ?></td>
            <td>min- <?php echo e($insecticide_pesticides_herbicides['min_operational_margins'] ?? ''); ?> & max- <?php echo e($insecticide_pesticides_herbicides['max_operational_margins'] ?? ''); ?></td>
            <td><?php echo e($insecticide_pesticides_herbicides['seasonal_quantum'] ?? ''); ?></td>
            <td><?php echo e($insecticide_pesticides_herbicides['credit_extent'] ?? ''); ?></td>
            <td><?php echo e($insecticide_pesticides_herbicides['remarks'] ?? ''); ?></td>
          </tr>
          
        <tr>
            <?php
            $fm_custom_hiring_service = json_decode($datas->fm_custom_hiring_service, true);
            ?>
            <td>5</td>
            <td></td>
            <td></td>
            <td>FM- Custom and Hiring Services</td>
              <td><?php echo e($fm_custom_hiring_service['purchase_average_cost_unit'] ?? ''); ?></td>
            <td><?php echo e($fm_custom_hiring_service['purchase_average_cost'] ?? ''); ?></td>
            <td><?php echo e($fm_custom_hiring_service['value_addition_average_cost'] ?? ''); ?></td>
            <td><?php echo e($fm_custom_hiring_service['avrage_sale_price'] ?? ''); ?></td>
            <td>min- <?php echo e($fm_custom_hiring_service['min_operational_margins'] ?? ''); ?> & max- <?php echo e($fm_custom_hiring_service['max_operational_margins'] ?? ''); ?></td>
            <td><?php echo e($fm_custom_hiring_service['seasonal_quantum'] ?? ''); ?></td>
            <td><?php echo e($fm_custom_hiring_service['credit_extent'] ?? ''); ?></td>
            <td><?php echo e($fm_custom_hiring_service['remarks'] ?? ''); ?></td>
          </tr>
          
          <tr>
               <?php
            $fingerling = json_decode($datas->fingerling, true);
            ?>
            <td>6</td>
            <td></td>
            <td></td>
            <td>Fingerling (fishery)</td>
             <td><?php echo e($fingerling['purchase_average_cost_unit'] ?? ''); ?></td>
            <td><?php echo e($fingerling['purchase_average_cost'] ?? ''); ?></td>
            <td><?php echo e($fingerling['value_addition_average_cost'] ?? ''); ?></td>
            <td><?php echo e($fingerling['avrage_sale_price'] ?? ''); ?></td>
            <td>min- <?php echo e($fingerling['min_operational_margins'] ?? ''); ?> & max- <?php echo e($fingerling['max_operational_margins'] ?? ''); ?></td>
            <td><?php echo e($fingerling['seasonal_quantum'] ?? ''); ?></td>
            <td><?php echo e($fingerling['credit_extent'] ?? ''); ?></td>
            <td><?php echo e($fingerling['remarks'] ?? ''); ?></td>
          </tr>
          
           <tr>
            <?php
            $poultry = json_decode($datas->poultry, true);
            ?>
            <td>7</td>
            <td></td>
            <td></td>
            <td>DOCs (Poultry)</td>
             <td><?php echo e($poultry['purchase_average_cost_unit'] ?? ''); ?></td>
            <td><?php echo e($poultry['purchase_average_cost'] ?? ''); ?></td>
            <td><?php echo e($poultry['value_addition_average_cost'] ?? ''); ?></td>
            <td><?php echo e($poultry['avrage_sale_price'] ?? ''); ?></td>
            <td>min- <?php echo e($poultry['min_operational_margins'] ?? ''); ?> & max- <?php echo e($poultry['max_operational_margins'] ?? ''); ?></td>
            <td><?php echo e($poultry['seasonal_quantum'] ?? ''); ?></td>
            <td><?php echo e($poultry['credit_extent'] ?? ''); ?></td>
            <td><?php echo e($poultry['remarks'] ?? ''); ?></td>
          </tr>
          
           <tr>
                <?php
                $plantlets = json_decode($datas->plantlets, true);
                ?>
            <td>8</td>
            <td></td>
            <td></td>
            <td>Plantlets (Horticulture)</td>
             <td><?php echo e($plantlets['purchase_average_cost_unit'] ?? ''); ?></td>
            <td><?php echo e($plantlets['purchase_average_cost'] ?? ''); ?></td>
            <td><?php echo e($plantlets['value_addition_average_cost'] ?? ''); ?></td>
            <td><?php echo e($plantlets['avrage_sale_price'] ?? ''); ?></td>
            <td>min- <?php echo e($plantlets['min_operational_margins'] ?? ''); ?> & max- <?php echo e($plantlets['max_operational_margins'] ?? ''); ?></td>
            <td><?php echo e($plantlets['seasonal_quantum'] ?? ''); ?></td>
            <td><?php echo e($plantlets['credit_extent'] ?? ''); ?></td>
            <td><?php echo e($plantlets['remarks'] ?? ''); ?></td>
          </tr>
          
           <tr>
                <?php
    $feeds_supply = json_decode($datas->feeds_supply, true);
    ?>
            <td>9</td>
            <td></td>
            <td></td>
            <td>Feeds supply</td>
            <td><?php echo e($feeds_supply['purchase_average_cost_unit'] ?? ''); ?></td>
    <td><?php echo e($feeds_supply['purchase_average_cost'] ?? ''); ?></td>
    <td><?php echo e($feeds_supply['value_addition_average_cost'] ?? ''); ?></td>
    <td><?php echo e($feeds_supply['avrage_sale_price'] ?? ''); ?></td>
    <td>min- <?php echo e($feeds_supply['min_operational_margins'] ?? ''); ?> & max- <?php echo e($feeds_supply['max_operational_margins'] ?? ''); ?></td>
    <td><?php echo e($feeds_supply['seasonal_quantum'] ?? ''); ?></td>
    <td><?php echo e($feeds_supply['credit_extent'] ?? ''); ?></td>
    <td><?php echo e($feeds_supply['remarks'] ?? ''); ?></td>
          </tr>
          
           <tr>
                <?php
    $medicines = json_decode($datas->medicines, true);
    ?>
            <td>10</td>
            <td></td>
            <td></td>
            <td>Medicines</td>
            <td><?php echo e($medicines['purchase_average_cost_unit'] ?? ''); ?></td>
    <td><?php echo e($medicines['purchase_average_cost'] ?? ''); ?></td>
    <td><?php echo e($medicines['value_addition_average_cost'] ?? ''); ?></td>
    <td><?php echo e($medicines['avrage_sale_price'] ?? ''); ?></td>
    <td>min- <?php echo e($medicines['min_operational_margins'] ?? ''); ?> & max- <?php echo e($medicines['max_operational_margins'] ?? ''); ?></td>
    <td><?php echo e($medicines['seasonal_quantum'] ?? ''); ?></td>
    <td><?php echo e($medicines['credit_extent'] ?? ''); ?></td>
    <td><?php echo e($medicines['remarks'] ?? ''); ?></td>
          </tr>
          
            <tr>
                 <?php
                $consultancy = json_decode($datas->consultancy, true);
                ?>
            <td>11</td>
            <td></td>
            <td></td>
            <td>Consultancy</td>
            <td><?php echo e($consultancy['purchase_average_cost_unit'] ?? ''); ?></td>
            <td><?php echo e($consultancy['purchase_average_cost'] ?? ''); ?></td>
            <td><?php echo e($consultancy['value_addition_average_cost'] ?? ''); ?></td>
            <td><?php echo e($consultancy['avrage_sale_price'] ?? ''); ?></td>
            <td>min- <?php echo e($consultancy['min_operational_margins'] ?? ''); ?> & max- <?php echo e($consultancy['max_operational_margins'] ?? ''); ?></td>
            <td><?php echo e($consultancy['seasonal_quantum'] ?? ''); ?></td>
            <td><?php echo e($consultancy['credit_extent'] ?? ''); ?></td>
            <td><?php echo e($consultancy['remarks'] ?? ''); ?></td>
          </tr>
          
        </tbody>
  </table>
    </div>

        <div class="table-responsive" style="margin-top:40px;">
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">C . Other Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
        </div>
        
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Indicative / Illustrative Issues / Constraints*</th>
            <th>Quantitative / Qualitative Indicators</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
            <td><?php echo e($datas->farmer_code_id); ?></td>
            <td><?php echo e($datas->first_name); ?> <?php echo e($datas->last_name); ?></td>
            <td style="font-weight:700;">General</td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
              <?php
                $Issues_constraints_a = json_decode($datas->Issues_constraints_a, true);
                ?>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Farmer who has taken inputs on Credit, next time they will purchase inputs in other shops</td>
             <td><?php echo e($Issues_constraints_a['value'] ?? ''); ?></td>
            <td><?php echo e($Issues_constraints_a['remark'] ?? ''); ?></td>
         </tr>
         
          <tr>
              <?php
                $Issues_constraints_b = json_decode($datas->Issues_constraints_b, true);
                ?>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Delay in collection of credits if farmer produce rates are very low</td>
            <td><?php echo e($Issues_constraints_b['value'] ?? ''); ?></td>
            <td><?php echo e($Issues_constraints_b['remark'] ?? ''); ?></td>
         </tr>  
         
          <tr>
              <?php
                $Issues_constraints_c = json_decode($datas->Issues_constraints_c, true);
              ?>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Transportation losses</td>
            <td><?php echo e($Issues_constraints_c['value'] ?? ''); ?></td>
            <td><?php echo e($Issues_constraints_c['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              
            <td>2</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Challenge</td>
           <td></td>
            <td></td>
         </tr> 
         
         <tr>
              <?php
                $challenges_a = json_decode($datas->challenges_a, true);
              ?>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Prise variations compare to other shops</td>
             <td><?php echo e($challenges_a['value'] ?? ''); ?></td>
            <td><?php echo e($challenges_a['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
               <?php
    $challenges_b = json_decode($datas->challenges_b, true);
    ?>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Farmers will purchase based on results</td>
           <td><?php echo e($challenges_b['value'] ?? ''); ?></td>
    <td><?php echo e($challenges_b['remark'] ?? ''); ?></td>
         </tr> 
         
           <tr>
                <?php
    $challenges_c = json_decode($datas->challenges_c, true);
    ?>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Marketing of new products launched by company</td>
                  <td><?php echo e($challenges_c['value'] ?? ''); ?></td>
    <td><?php echo e($challenges_c['remark'] ?? ''); ?></td>
         </tr> 
         
         
         <tr>
              <?php
            $challenges_d = json_decode($datas->challenges_d, true);
            ?>
            <td>d</td>
               <td></td>
            <td></td>
            <td>Credit business compulsory</td>
             <td><?php echo e($challenges_d['value'] ?? ''); ?></td>
             <td><?php echo e($challenges_d['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
               
            <td>3</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Risk</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
               <?php
            $risk_a = json_decode($datas->risk_a, true);
            ?>
            <td>a</td>
               <td></td>
            <td></td>
            <td>100% credits collection not possible</td>
          <td><?php echo e($risk_a['value'] ?? ''); ?></td>
         <td><?php echo e($risk_a['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
              <?php
            $risk_b = json_decode($datas->risk_b, true);
            ?>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Same company will give inputs on cash basis</td>
             <td><?php echo e($risk_b['value'] ?? ''); ?></td>
            <td><?php echo e($risk_b['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
              <?php
            $risk_c = json_decode($datas->risk_c, true);
            ?>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Competition on Product Prise variations compare to other shops</td>
           <td><?php echo e($risk_c['value'] ?? ''); ?></td>
            <td><?php echo e($risk_c['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
               <?php
            $risk_d = json_decode($datas->risk_d, true);
            ?>
            <td>d</td>
               <td></td>
            <td></td>
            <td>Farmers will purchase inputs next time  based on results he will get in his field</td>
            <td><?php echo e($risk_d['value'] ?? ''); ?></td>
            <td><?php echo e($risk_d['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
             <?php
            $risk_e = json_decode($datas->risk_e, true);
            ?>
            <td>e</td>
               <td></td>
            <td></td>
            <td>Extent of expiry of inputs</td>
             <td><?php echo e($risk_e['value'] ?? ''); ?></td>
            <td><?php echo e($risk_e['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <?php
            $risk_f = json_decode($datas->risk_f, true);
            ?>
            <td>f</td>
               <td></td>
            <td></td>
            <td>Any other</td>
           <td><?php echo e($risk_f['value'] ?? ''); ?></td>
            <td><?php echo e($risk_f['remark'] ?? ''); ?></td>
         </tr> 
         
          <tr>
            <td>4</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Prospects</td>
            <td></td>
            <td></td>
         </tr> 
         
         
        <tr>
             <?php
            $prospects_a = json_decode($datas->prospects_a, true);
            ?>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Timely/Regular  supply of inputs from company</td>
            <td><?php echo e($prospects_a['value'] ?? ''); ?></td>
            <td><?php echo e($prospects_a['remark'] ?? ''); ?></td>
         </tr> 
         
        <tr>
            <?php
            $prospects_b = json_decode($datas->prospects_b, true);
            ?>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Cash and carry business</td>
            <td><?php echo e($prospects_b['value'] ?? ''); ?></td>
            <td><?php echo e($prospects_b['remark'] ?? ''); ?></td>
         </tr> 
         
         <tr>
             <?php
            $prospects_c = json_decode($datas->prospects_c, true);
            ?>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Policy support on market rates </td>
            <td><?php echo e($prospects_c['value'] ?? ''); ?></td>
            <td><?php echo e($prospects_c['remark'] ?? ''); ?></td>
         </tr> 
         
        </tbody>
  </table>
  
        
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <div class="table-responsive">
           <h3>A  . Infrastructure and Support Services</h3>
        <table class="table table-bordered">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Unit Rate</th>
            <th>Amt (Rs.)</th>
            <th>Annualized Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
            <td></td>
            <td></td>
            <td>Cost of establishment of Input Shop</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
          </tr>
          <tr>
            <td>2</td>
            <td></td>
            <td></td>
                        <td>Cost Storage Structure for Inputs</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>3</td>
            <td></td>
            <td></td>
            <td>Cost other Infrastructure for Inputs</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
           </tr>
            
         <tr>
            <td>4</td>
            <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
          </tr>
          
          
          <tr>
            <td>5</td>
            <td></td>
            <td></td>
            <td>Monthly Expenses on Manpower</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
           </tr>
          
           <tr>
            <td>6</td>
            <td></td>
            <td></td>
            <td>Monthly rent ( If shop is on rent)</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
           </tr>
           
            <tr>
            <td>7</td>
            <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
           </tr>
           
            <tr>
            <td>8</td>
            <td></td>
            <td></td>
            <td>Any Other</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
           </tr>
           
          <!-- Continue adding rows -->
          <tr>
            <td>9</td>
            <td></td>
            <td></td>
            <td>Annual Intt. on Capital Investment</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          <tr>
            <td colspan="7" class=" text-center" style="font-weight:700;">Total Fixed Cost of Input Supplier</td>
          </tr>
          <tr>
            <td>11</td>
            <td></td>
            <td></td>
            <td>Annual Intt. on Working Capital</td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
          
         <tr>
            <td>12</td>
            <td></td>
            <td></td>
            <td>Percentage of Inputs on credit to farmer</td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>13</td>
            <td></td>
            <td></td>
            <td>Duration of Inputs on credit to farmer</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>14</td>
            <td></td>
            <td></td>
            <td>Extent of Credit Default</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>15</td>
            <td></td>
            <td></td>
            <td>Technical Advisory services ( Y/N)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
          
          <!-- Continue adding rows for other data points -->
          <tr>
            <td>16</td>
            <td></td>
            <td></td>
            <td>Any other Information</td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
        </tbody>
  </table>
        </div>
        </div>
    
        <div class="table-responsive" style="margin-top:40px;">
        <h3>B . Business Economics</h3>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Type of inputs</th>
            <th>Unit</th>
            <th>Average Cost of purchase</th>
            <th>Average Cost of value addition</th>
            <th>Average Sale Price</th>
            <th>Operational Margins (min & Max)</th>
            <th>Seasonal quantum of sale </th>
            <th>Extent of credit default</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
            <td></td>
            <td></td>
            <td>Seed</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
              <td></td>
               <td></td>
          </tr>
          <tr>
            <td>2</td>
            <td></td>
            <td></td>
            <td>Fertilizer</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
              <td></td>
            <td></td>
            <td></td>
          </tr>
          <tr>
            <td>3</td>
            <td></td>
            <td></td>
            <td>Nutrients</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
       
          <tr>
            <td>4</td>
            <td></td>
            <td></td>
            <td>Insecticide / Pesticides / Herbicides</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
        <tr>
            <td>5</td>
            <td></td>
            <td></td>
            <td>FM- Custom and Hiring Services</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
          <tr>
            <td>6</td>
            <td></td>
            <td></td>
            <td>Fingerling (fishery)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>7</td>
            <td></td>
            <td></td>
            <td>DOCs (Poultry)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>8</td>
            <td></td>
            <td></td>
            <td>Plantlets (Horticulture)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>9</td>
            <td></td>
            <td></td>
            <td>Feeds supply</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>10</td>
            <td></td>
            <td></td>
            <td>Medicines</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
            <tr>
            <td>11</td>
            <td></td>
            <td></td>
            <td>Consultancy</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
        </tbody>
  </table>
    </div>

        <div class="table-responsive" style="margin-top:40px;">
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">C . Other Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
        </div>
        
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
               <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Indicative / Illustrative Issues / Constraints*</th>
            <th>Quantitative / Qualitative Indicators</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">General</td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Farmer who has taken inputs on Credit, next time they will purchase inputs in other shops</td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Delay in collection of credits if farmer produce rates are very low</td>
            <td></td>
            <td></td>
         </tr>  
         
          <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Transportation losses</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>2</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Challenge</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Prise variations compare to other shops</td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Farmers will purchase based on results</td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Marketing of new products launched by company</td>
            <td></td>
            <td></td>
         </tr> 
         
         
         <tr>
            <td>d</td>
               <td></td>
            <td></td>
            <td>Credit business compulsory</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>3</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Risk</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>100% credits collection not possible</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Same company will give inputs on cash basis</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Competition on Product Prise variations compare to other shops</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>d</td>
               <td></td>
            <td></td>
            <td>Farmers will purchase inputs next time  based on results he will get in his field</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>e</td>
               <td></td>
            <td></td>
            <td>Extent of expiry of inputs</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>f</td>
               <td></td>
            <td></td>
            <td>Any other</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>4</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Prospects</td>
            <td></td>
            <td></td>
         </tr> 
         
         
        <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Timely/Regular  supply of inputs from company</td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Cash and carry business</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Policy support on market rates </td>
            <td></td>
            <td></td>
         </tr> 
         
        </tbody>
  </table>
  
        
    </div>
    <?php endif; ?>
    
    
</div>

    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-five.blade.php ENDPATH**/ ?>