<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            <?php if($deshboard == 1): ?>
        
            <?php else: ?>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="<?php echo e(isset($_GET['start_date']) ? $_GET['start_date'] : ''); ?>" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="<?php echo e(isset($_GET['end_date']) ? $_GET['end_date'] : ''); ?>" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="<?php echo e(route('anexure.six')); ?>" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="<?php echo e(route('anexure.six.update', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            <?php endif; ?>
        </div>
        
        <?php if($data->isNotEmpty()): ?> 
        <?php
            $si = 1;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">A . Infrastructure and Support Services</h1>
        </div>
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Unit Rate</th>
             <th>Amt (Rs.)</th>
             <th>Annulised Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
        <tr>
            <?php
             $shop_permanent = json_decode($datas->cost_of_establishment_of_input_shop_permanent, true);
            ?>
            <td><?php echo e($si++); ?></td>
            <td><?php echo e($datas->farmer_code_id ?? ''); ?></td>
            <td><?php echo e($datas->first_name ?? ''); ?> <?php echo e($datas->last_name ?? ''); ?></td>
            <td>Cost of establishment of Input Shop Permanent</td>
            
            <td><input type="text" class="" id="shop_permanent_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($shop_permanent['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="shop_permanent_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($shop_permanent['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="shop_permanent_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($shop_permanent['amount'] ?? ''); ?>"></td>
            
            <?php
                $annualizedcostPer = isset($shop_permanent['amount']) && isset($perYear->year) && $perYear->year != 0 
                    ? $shop_permanent['amount'] / $perYear->year 
                    : null;
            ?>
            <td><?php echo e($annualizedcostPer ?? ''); ?></td>
            
            
            <td><input type="text" class="" value="<?php echo e($shop_permanent['remark'] ?? ''); ?>" id="shop_permanent_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>"></td>
         </tr>
            
         <tr>
            <?php
             $shop_temporary = json_decode($datas->cost_of_establishment_of_input_shop_temporary, true);
            ?>
            <td>2</td>
            <td></td>
            <td></td>
            <td>Cost of establishment of Input Shop Temporary</td>
            
            <td><input type="text" class="" id="shop_temporary_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($shop_temporary['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="shop_temporary_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($shop_temporary['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="shop_temporary_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($shop_temporary['amount'] ?? ''); ?>"></td>
            
            <?php
                $annualizedcosttemp = isset($shop_temporary['amount']) && isset($tempYear->year) && $tempYear->year != 0 
                    ? $shop_temporary['amount'] / $tempYear->year 
                    : null;
            ?>
            
            <td><?php echo e($annualizedcosttemp ?? ''); ?></td>
            
            <td><input type="text" class="" id="shop_temporary_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($shop_temporary['remark'] ?? ''); ?>"></td>
         </tr> 
         
         
         <tr>
            <?php
             $stostri = json_decode($datas->storage_structure_of_input, true);
            ?>
            <td>2</td>
            <td></td>
            <td></td>
            <td>Cost Storage Structure for Inputs</td>
            
            <td><input type="text" class="" id="stostri_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($stostri['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="stostri_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($stostri['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="stostri_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($stostri['amount'] ?? ''); ?>"></td>
            
            <?php
                $coststrogedata = isset($stostri['amount']) && isset($coststorage->year) && $coststorage->year != 0 
                    ? $stostri['amount'] / $coststorage->year 
                    : null;
            ?>
            
            <td><?php echo e($coststrogedata ?? ''); ?></td>
            
            <td><input type="text" class="" id="stostri_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($stostri['remark'] ?? ''); ?>"></td>
         </tr>
         
          <tr>
             <?php
             $ss = json_decode($datas->other_infrastructure_input, true);
            ?>
            <td>3</td>
            <td></td>
            <td></td>
            <td>Cost other Infrastructure for Inputs</td>
            <td><input type="text" class="" id="ss_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($ss['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="ss_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($ss['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="ss_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($ss['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="ss_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($ss['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="ss_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($ss['remark'] ?? ''); ?>"></td>
         </tr>  
         
          <tr>
            <?php
             $me = json_decode($datas->monthly_expenses_on_electricity, true);
            ?>
            <td>4</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td><input type="text" class="" id="me_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($me['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="me_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($me['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="me_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($me['amount'] ?? ''); ?>"></td>
            
            <?php
                $monthelectricdata = isset($me['amount']) && isset($monthElectricity->year) && $monthElectricity->year != 0 
                    ? $me['amount'] / $monthElectricity->year 
                    : null;
            ?>
            
            <td><?php echo e($monthelectricdata ?? ''); ?></td>
            
            <td><input type="text" class="" id="me_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($me['remark'] ?? ''); ?>"></td>
         </tr> 
         
          <tr>
              <?php
             $mem = json_decode($datas->monthly_expenses_on_manpower, true);
            ?>
            <td>5</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Monthly Expenses on Manpower</td>
            <td><input type="text" class="" id="mem_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mem['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="me_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mem['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="me_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mem['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="me_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mem['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="me_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mem['remark'] ?? ''); ?>"></td>
         </tr> 
         
         <tr>
              <?php
             $mr = json_decode($datas->monthly_rent, true);
            ?>
            <td>6</td>
            <td></td>
            <td></td>
            <td>Monthly rent ( If shop is on rent)</td>
            <td><input type="text" class="" id="mr_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mr['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="mr_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mr['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="mr_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mr['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="mr_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mr['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="mr_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mr['remark'] ?? ''); ?>"></td>
         </tr> 
         
           <tr>
             <?php
             $mte = json_decode($datas->monthly_travelling_expense, true);
            ?>
            <td>7</td>
             <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
           <td><input type="text" class="" id="mte_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mte['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="mte_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mte['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="mte_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mte['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="mte_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mte['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="mte_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($mte['remark'] ?? ''); ?>"></td>
         </tr> 
         
           <tr>
            <?php
             $any_ot = json_decode($datas->any_other, true);
            ?>
            <td>8</td>
             <td></td>
            <td></td>
            <td>Any Other</td>
            <td><input type="text" class="" id="any_ot_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($any_ot['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="any_ot_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($any_ot['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="any_ot_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($any_ot['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="any_ot_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($any_ot['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="any_ot_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($any_ot['remark'] ?? ''); ?>"></td>
         </tr> 
         
         
         <tr>
            <?php
             $aici = json_decode($datas->annual_intt_on_capital_investment, true);
            ?>
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Intt on Capital Investment</td>
            <td><input type="text" class="" id="aici_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($aici['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="aici_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($aici['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="aici_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($aici['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="aici_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($aici['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="aici_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($aici['remark'] ?? ''); ?>"></td>
         </tr> 
         
          <?php
            $sumOfannualdata = 
                ($shop_permanent['amount'] ?? 0) + 
                ($shop_temporary['amount'] ?? 0) + 
                ($stostri['amount'] ?? 0) + 
                ($ss['amount'] ?? 0) + 
                ($me['amount'] ?? 0) + 
                ($mem['amount'] ?? 0) +     
                ($mr['amount'] ?? 0) + 
                ($mte['amount'] ?? 0) + 
                ($any_ot['amount'] ?? 0) + 
                ($aici['amount'] ?? 0);
            ?>
         
         
         <tr>
            <td></td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of CA / PHC</td>
            <td></td>
            <td></td>
             <td style="font-weight:700;"><?php echo e($sumOfannualdata); ?></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <?php
             $awc = json_decode($datas->annual_intt_on_working_capital, true);
            ?>
            <td>10</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Annual Intt on Working Capital</td>
            
            <td><input type="text" class="" id="awc_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($awc['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="awc_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($awc['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="awc_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($awc['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="awc_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($awc['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="awc_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($awc['remark'] ?? ''); ?>"></td>
         </tr> 
         
          <tr>
            <?php
             $pfv = json_decode($datas->purchase_from_farmer_at_village, true);
            ?>
            <td>11</td>
            <td></td>
            <td></td>
            <td>Purchase from farmer at village/ Farm Gate Level ?</td>
            <td><input type="text" class="" id="pfv_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($pfv['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="pfv_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($pfv['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="pfv_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($pfv['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="pfv_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($pfv['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="pfv_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($pfv['remark'] ?? ''); ?>"></td>
         </tr> 
         
         <tr>
             <?php
             $localMandi = json_decode($datas->local_mandi, true);
            ?>
            <td>12</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi ?</td>
            <td><input type="text" class="" id="localMandi_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($localMandi['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="localMandi_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($localMandi['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="localMandi_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($localMandi['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="localMandi_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($localMandi['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="localMandi_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($localMandi['remark'] ?? ''); ?>"></td>
         </tr> 
         
          <tr>
             <?php
             $preMech = json_decode($datas->prevalent_purchase_mechanism, true);
            ?>
            <td>13</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism ( Village Level/ local Mandi/ APMC)</td>
            <td><input type="text" class="" id="preMech_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($preMech['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="preMech_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($preMech['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="preMech_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($preMech['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="preMech_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($preMech['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="preMech_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($preMech['remark'] ?? ''); ?>"></td>
         </tr> 
         
          <tr>
            <td>14</td>
             <td></td>
            <td></td>
            <td colspan="6">Any Other Channel</td>
         </tr> 
         
         <tr>
            <?php
             $dopc = json_decode($datas->duration_of_purchase_on_credit, true);
            ?>
            <td>15</td> 
            <td></td>
            <td></td>
            <td>Duration of purchase on credit</td>
            <td><input type="text" class="" id="dopc_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($dopc['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="dopc_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($dopc['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="dopc_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($dopc['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="dopc_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($dopc['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="dopc_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($dopc['remark'] ?? ''); ?>"></td>
         </tr> 
         
          <tr>
              <?php
             $dsc = json_decode($datas->duration_sale_credit, true);
            ?>
            <td>16</td>
             <td></td>
            <td></td>
            <td>Duration of Sale credit</td>
            <td><input type="text" class="" id="dsc_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($dsc['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="dsc_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($dsc['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="dsc_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($dsc['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="dsc_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($dsc['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="dsc_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($dsc['remark'] ?? ''); ?>"></td>
         </tr> 
         
          <tr>
            <?php
             $iacp = json_decode($datas->input_advance_credit_producer, true);
            ?>
            <td>17</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Input / advance credit to producer (% of the estimated sale)</td>
            <td><input type="text" class="" id="iacp_unit_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($iacp['unit'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="iacp_unitRate_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($iacp['unitRate'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="iacp_amount_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($iacp['amount'] ?? ''); ?>"></td>
            <td><input type="number" class="" id="iacp_annualCost_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($iacp['annualCost'] ?? ''); ?>"></td>
            <td><input type="text" class="" id="iacp_remark_<?php echo e($datas->id); ?>_<?php echo e(isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''); ?>" value="<?php echo e($iacp['remark'] ?? ''); ?>"></td>
         </tr> 
         
         
        <tr>
            <?php
             $anyinfo = json_decode($datas->any_other_information, true);
            ?>
            <td>18</td>
            <td></td>
            <td></td>
            <td>Any Other Information</td>
            <td><?php echo e($anyinfo['unit'] ?? ''); ?></td>
            <td><?php echo e($anyinfo['unitRate'] ?? ''); ?></td>
            <td><?php echo e($anyinfo['amount'] ?? ''); ?></td>
            <td><?php echo e($anyinfo['annualCost'] ?? ''); ?></td>
            <td><?php echo e($anyinfo['remark'] ?? ''); ?></td>
         </tr> 
         
        </tbody>
  </table>
        
        <br>
       
        <div class="table-responsive">
          <h1 class="h3 mb-0 text-gray-800">B . Business parameters</h1>
          <br>
         <table class="table table-bordered ">
            <thead>
              <tr>
                <th>S. No.</th>
                <th>FARMER ID</th>
                <th>Farmer Name</th>
    
                <th>Particulars of Inputs</th>
                <th>Unit</th>
                <th>Name of Product</th>
                <th>Unit (quantity)</th>
                <th>Average Rate (Rs./Unit Quantity)</th>
                <th>Min Rate (Rs./Unit Quantity)</th>
                <th>Max Rate (Rs./Unit Quantity)</th>
                <th>Remark</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>I</td>
                
                <td><?php echo e($datas->farmer_code_id); ?></td>
                <td><?php echo e($datas->first_name); ?> <?php echo e($datas->last_name); ?></td>
                <td style="font-weight:700;">Average Purchase Price</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>   
             
            <tr>
                 <?php
                    $apa = json_decode($datas->averag_purchase_a, true);
                 ?>
                <td></td>
                <td></td>
                <td></td>
                <td>Grade A (mention applicable grade specification)</td>
                 <td></td>
                 <td><?php echo e($apa['name'] ?? ''); ?></td>
                 <td> <?php echo e($apa['unit'] ?? ''); ?></td>
                 <td><?php echo e($apa['averate_rate'] ?? ''); ?></td>
                 <td><?php echo e($apa['min_variation'] ?? ''); ?></td>
                <td><?php echo e($apa['max_variation'] ?? ''); ?></td>
                <td><?php echo e($apa['remarks'] ?? ''); ?></td>
             </tr>
             
               <tr>
                   <?php
                    $apb = json_decode($datas->averag_purchase_b, true);
                 ?>
                <td></td>
                <td></td>
                <td></td>
                <td>Grade B (mention applicable grade specification)</td>
               <td></td>
                 <td><?php echo e($apb['name'] ?? ''); ?></td>
                 <td> <?php echo e($apb['unit'] ?? ''); ?></td>
                 <td><?php echo e($apb['averate_rate'] ?? ''); ?></td>
                 <td><?php echo e($apb['min_variation'] ?? ''); ?></td>
                <td><?php echo e($apb['max_variation'] ?? ''); ?></td>
                <td><?php echo e($apb['remarks'] ?? ''); ?></td>
             </tr>
             
               <tr>
                   <?php
                    $apc = json_decode($datas->averag_purchase_c, true);
                 ?>
                <td></td>  
                <td></td>
                <td></td>
                <td>Grade C (mention applicable grade specification)</td>
                <td></td>
                <td><?php echo e($apc['name'] ?? ''); ?></td>
                 <td> <?php echo e($apc['unit'] ?? ''); ?></td>
                 <td><?php echo e($apc['averate_rate'] ?? ''); ?></td>
                 <td><?php echo e($apc['min_variation'] ?? ''); ?></td>
                <td><?php echo e($apc['max_variation'] ?? ''); ?></td>
                <td><?php echo e($apc['remarks'] ?? ''); ?></td>
             </tr>
             
              <tr>
                   <?php
                    $apd = json_decode($datas->averag_purchase_d, true);
                 ?>
                <td></td>  
                <td></td>
                <td></td>
                <td>Grade D (mention applicable grade specification)</td>
                <td></td>
               <td><?php echo e($apd['name'] ?? ''); ?></td>
                 <td> <?php echo e($apd['unit'] ?? ''); ?></td>
                 <td><?php echo e($apd['averate_rate'] ?? ''); ?></td>
                 <td><?php echo e($apd['min_variation'] ?? ''); ?></td>
                <td><?php echo e($apd['max_variation'] ?? ''); ?></td>
                <td><?php echo e($apd['remarks'] ?? ''); ?></td>
             </tr>
             
             
             
              <tr>
                <td>II</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Cost of Value Addition</td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                   <?php
                    $phc = json_decode($datas->pre_harvesting_contractor_cost, true);
                 ?>
                <td>a</td>
                <td></td>
                <td></td>
                <td>Pre-Harvesting Contractor Cost</td>
                <td></td>
                <td><?php echo e($phc['name'] ?? ''); ?></td>
                 <td> <?php echo e($phc['unit'] ?? ''); ?></td>
                 <td><?php echo e($phc['averate_rate'] ?? ''); ?></td>
                 <td><?php echo e($phc['min_variation'] ?? ''); ?></td>
                <td><?php echo e($phc['max_variation'] ?? ''); ?></td>
                <td><?php echo e($phc['remarks'] ?? ''); ?></td>
             </tr> 
             
              <tr>
                   <?php
                    $hc = json_decode($datas->harvesting_cost, true);
                 ?>
                <td>b</td>
                   <td></td>
                <td></td>
                <td>Harvesting Cost</td>
                <td></td>
                <td><?php echo e($hc['name'] ?? ''); ?></td>
                 <td> <?php echo e($hc['unit'] ?? ''); ?></td>
                 <td><?php echo e($hc['averate_rate'] ?? ''); ?></td>
                 <td><?php echo e($hc['min_variation'] ?? ''); ?></td>
                <td><?php echo e($hc['max_variation'] ?? ''); ?></td>
                <td><?php echo e($hc['remarks'] ?? ''); ?></td>
             </tr> 
             
               <tr>
                <?php
                    $tran_cost = json_decode($datas->transportation_cost, true);
                 ?>
                <td>c</td>
                   <td></td>
                <td></td>
                <td>Transportation Cost</td>
                <td></td>
                <td><?php echo e($tran_cost['name'] ?? ''); ?></td>
                 <td> <?php echo e($tran_cost['unit'] ?? ''); ?></td>
                 <td><?php echo e($tran_cost['averate_rate'] ?? ''); ?></td>
                 <td><?php echo e($tran_cost['min_variation'] ?? ''); ?></td>
                <td><?php echo e($tran_cost['max_variation'] ?? ''); ?></td>
                <td><?php echo e($tran_cost['remarks'] ?? ''); ?></td>
             </tr> 
             
             
             <tr>
                  <?php
                    $lauc = json_decode($datas->loading_and_unloading_charges, true);
                 ?>
                <td>d</td>
                   <td></td>
                <td></td>
                <td>Loading and Unloading Charges</td>
                <td></td>
                <td><?php echo e($lauc['name'] ?? ''); ?></td>
                 <td> <?php echo e($lauc['unit'] ?? ''); ?></td>
                 <td><?php echo e($lauc['averate_rate'] ?? ''); ?></td>
                 <td><?php echo e($lauc['min_variation'] ?? ''); ?></td>
                <td><?php echo e($lauc['max_variation'] ?? ''); ?></td>
                <td><?php echo e($lauc['remarks'] ?? ''); ?></td>
             </tr> 
             
              <tr>
                  <?php
                    $prmary_proCost = json_decode($datas->primary_processing_cost, true);
                    ?>
                <td>e</td>
                   <td></td>
                <td></td>
                <td>Primary Processing Cost</td>
                <td></td>
                <td><?php echo e($prmary_proCost['name'] ?? ''); ?></td>
                <td> <?php echo e($prmary_proCost['unit'] ?? ''); ?></td>
                <td><?php echo e($prmary_proCost['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($prmary_proCost['min_variation'] ?? ''); ?></td>
                <td><?php echo e($prmary_proCost['max_variation'] ?? ''); ?></td>
                <td><?php echo e($prmary_proCost['remarks'] ?? ''); ?></td>
             </tr> 
             
              <tr>
                   <?php
                $dry_loss = json_decode($datas->drying_loss_or_any_other_loss, true);
                ?>
                <td>f</td>
                <td></td>
                <td></td>
                <td>Drying Loss or any other loss</td>
                <td></td>
              <td><?php echo e($dry_loss['name'] ?? ''); ?></td>
                <td> <?php echo e($dry_loss['unit'] ?? ''); ?></td>
                <td><?php echo e($dry_loss['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($dry_loss['min_variation'] ?? ''); ?></td>
                <td><?php echo e($dry_loss['max_variation'] ?? ''); ?></td>
                <td><?php echo e($dry_loss['remarks'] ?? ''); ?></td>
             </tr> 
             
             <tr>
                  <?php
                $mandi_fees = json_decode($datas->mandi_fees, true);
                ?>
                <td>g</td>
                <td></td>
                <td></td>
                <td>Mandi fees /Tax/ Commission</td>
                <td></td>
                 <td><?php echo e($mandi_fees['name'] ?? ''); ?></td>
                <td> <?php echo e($mandi_fees['unit'] ?? ''); ?></td>
                <td><?php echo e($mandi_fees['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($mandi_fees['min_variation'] ?? ''); ?></td>
                <td><?php echo e($mandi_fees['max_variation'] ?? ''); ?></td>
                <td><?php echo e($mandi_fees['remarks'] ?? ''); ?></td>
             </tr> 
             
              <tr>
                   <?php
                    $packingex = json_decode($datas->packaging_expenses, true);
                    ?>
                <td>h</td>
                <td></td>
                <td></td>
                <td>Packaging expenses</td>
                <td></td>
                 <td><?php echo e($packingex['name'] ?? ''); ?></td>
                <td> <?php echo e($packingex['unit'] ?? ''); ?></td>
                <td><?php echo e($packingex['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($packingex['min_variation'] ?? ''); ?></td>
                <td><?php echo e($packingex['max_variation'] ?? ''); ?></td>
                <td><?php echo e($packingex['remarks'] ?? ''); ?></td>
             </tr> 
             </tr> 
             
              <tr>
                   <?php
                    $anyother_marCost = json_decode($datas->any_other_marketing_cost, true);
                    ?>
                <td>i</td>
                <td></td>
                <td></td>
                <td>Any other Marketing Cost</td>
                <td></td>
                <td><?php echo e($anyother_marCost['name'] ?? ''); ?></td>
                <td> <?php echo e($anyother_marCost['unit'] ?? ''); ?></td>
                <td><?php echo e($anyother_marCost['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($anyother_marCost['min_variation'] ?? ''); ?></td>
                <td><?php echo e($anyother_marCost['max_variation'] ?? ''); ?></td>
                <td><?php echo e($anyother_marCost['remarks'] ?? ''); ?></td>
             </tr> 
             </tr> 
             
             <tr>
                <td>j</td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                  <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
              <tr>
                <td>k</td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
              <tr>
                <td>III</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Selling Price</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
             
            <tr>
                <?php
                $sellingPriceA = json_decode($datas->selling_price_a, true);
                ?>
                <td></td>
                 <td></td>
                <td></td>
                <td>Grade A (mention applicable grade specification)</td>
                <td></td>
                <td><?php echo e($sellingPriceA['name'] ?? ''); ?></td>
                <td> <?php echo e($sellingPriceA['unit'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceA['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceA['min_variation'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceA['max_variation'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceA['remarks'] ?? ''); ?></td>
             </tr> 
             
              <tr>
                   <?php
                $sellingPriceB = json_decode($datas->selling_price_b, true);
                ?>
                <td></td>
                   <td></td>
                <td></td>
                <td>Grade B (mention applicable grade specification)</td>
                <td></td>
                <td><?php echo e($sellingPriceB['name'] ?? ''); ?></td>
                <td> <?php echo e($sellingPriceB['unit'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceB['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceB['min_variation'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceB['max_variation'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceB['remarks'] ?? ''); ?></td>
             </tr> 
             
              <tr>
                <?php
                $sellingPriceC = json_decode($datas->selling_price_c, true);
                ?>
                <td></td>
                   <td></td>
                <td></td>
                <td>Grade C (mention applicable grade specification)</td>
                <td></td>
               <td><?php echo e($sellingPriceC['name'] ?? ''); ?></td>
                <td> <?php echo e($sellingPriceC['unit'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceC['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceC['min_variation'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceC['max_variation'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceC['remarks'] ?? ''); ?></td>
             </tr> 
             
             <tr>
                <?php
                $sellingPriceD = json_decode($datas->selling_price_d, true);
                ?>
                <td></td>
                <td></td>
                <td></td>
                <td>Grade D (mention applicable grade specification)</td>
                <td></td>
                 <td><?php echo e($sellingPriceD['name'] ?? ''); ?></td>
                <td> <?php echo e($sellingPriceD['unit'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceD['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceD['min_variation'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceD['max_variation'] ?? ''); ?></td>
                <td><?php echo e($sellingPriceD['remarks'] ?? ''); ?></td>
             </tr> 
             
            <tr>
                <td>IV</td>
                   <td></td>
                <td></td>
                <td style="font-weight:700;">Any other Cost Parameter</td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                 <td></td>
                <td></td>
                 <td></td>
             </tr> 
             
             <tr>
                  <?php
                $QUAN = json_decode($datas->quantum_handled_year, true);
                ?>
                <td></td>
                   <td></td>
                <td></td>
                <td>Quantum Handled in a year (weight)</td>
                <td></td>
                <td><?php echo e($QUAN['name'] ?? ''); ?></td>
                <td> <?php echo e($QUAN['unit'] ?? ''); ?></td>
                <td><?php echo e($QUAN['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($QUAN['min_variation'] ?? ''); ?></td>
                <td><?php echo e($QUAN['max_variation'] ?? ''); ?></td>
                <td><?php echo e($QUAN['remarks'] ?? ''); ?></td>
             </tr> 
             
            <tr>
                  <?php
                $pspf = json_decode($datas->purchase_selling_prices_fluctuation, true);
                ?>
                <td></td>
                   <td></td>
                <td></td>
                <td>Purchase and selling prices fluctuation during the whole marketing season</td>
                <td></td>
                <td><?php echo e($pspf['name'] ?? ''); ?></td>
                <td> <?php echo e($pspf['unit'] ?? ''); ?></td>
                <td><?php echo e($pspf['averate_rate'] ?? ''); ?></td>
                <td><?php echo e($pspf['min_variation'] ?? ''); ?></td>
                <td><?php echo e($pspf['max_variation'] ?? ''); ?></td>
                <td><?php echo e($pspf['remarks'] ?? ''); ?></td>
             </tr> 
             
            </tbody>
      </table>
        </div>
        <br>
          <div class="table-responsive">
            <h1 class="h3 mb-0 text-gray-800">C . Indicative Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
            <br>
          <table class="table table-bordered ">
            <thead>
              <tr>
                <th>1</th>
                  <td>Farmer ID</td>
                <td>Farmer Name</td>
                <th>IIssues / Constraints</th>
                <th>Quantitative / Qualitative Indicators</th>
                <th>Remark</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                  <?php
                    $ica = json_decode($datas->issues_constraints_a, true);
                    ?>
                <td></td>
                <td><?php echo e($datas->farmer_code_id); ?></td>
                <td><?php echo e($datas->first_name); ?> <?php echo e($datas->last_name); ?></td>
                <td>a) Quantity reduction due to moisture content during the procurement</td>
                <td><?php echo e($ica['value'] ?? ''); ?></td>
                <td> <?php echo e($ica['remark'] ?? ''); ?></td>
             </tr>   
             
             <tr>
                 <?php
                    $icb = json_decode($datas->issues_constraints_b, true);
                    ?>
                <td></td>
                <td></td>
                <td></td>
                <td>b) We will not get same quality produce every time</td>
               <td><?php echo e($icb['value'] ?? ''); ?></td>
                <td> <?php echo e($icb['remark'] ?? ''); ?></td>
             </tr>
             
              <tr>
                   <?php
                    $icc = json_decode($datas->issues_constraints_c, true);
                    ?>
                <td></td>
                <td></td>
                <td></td>
                <td>c) Licence issues during the transportation</td>
                <td><?php echo e($icc['value'] ?? ''); ?></td>
                <td> <?php echo e($icc['remark'] ?? ''); ?></td>
             </tr>  
             
               
             
              <tr>
                <td style="font-weight:700;">2</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Challenges</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                  <?php
                    $ca = json_decode($datas->challenges_a, true);
                    ?>
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Credit -Higher interest rates from financing persons</td>
                <td><?php echo e($ca['value'] ?? ''); ?></td>
                <td> <?php echo e($ca['remark'] ?? ''); ?></td>
             </tr> 
             
              <tr>
                   <?php
                    $ca = json_decode($datas->challenges_b, true);
                    ?>
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Market rates will be up and down</td>
                 <td><?php echo e($cb['value'] ?? ''); ?></td>
                <td> <?php echo e($cb['remark'] ?? ''); ?></td>
             </tr> 
             
               <tr>
                    <?php
                    $cc = json_decode($datas->challenges_c, true);
                    ?>
                <td></td>
                 <td></td>
                <td></td>
                <td>c)Production will depends on weather</td>
                <td><?php echo e($cc['value'] ?? ''); ?></td>
                <td> <?php echo e($cc['remark'] ?? ''); ?></td>
             </tr> 
             
             <tr>
                <td style="font-weight:700;">3</td>
                 <td></td>
                <td></td>
                <td style="font-weight:700;">Risk</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                  <?php
                    $ra = json_decode($datas->risk_a, true);
                    ?>
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Credit basis supply to wholesaler</td>
                  <td><?php echo e($ra['value'] ?? ''); ?></td>
                <td> <?php echo e($ra['remark'] ?? ''); ?></td>
             </tr> 
             
              <tr>
                    <?php
                    $rb = json_decode($datas->risk_b, true);
                    ?>
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Farmer will take advance from one marketing agent will sell to other marketing agent</td>
                <td><?php echo e($rb['value'] ?? ''); ?></td>
                <td> <?php echo e($rb['remark'] ?? ''); ?></td>
             </tr>
             
              <tr>
                  <?php
                    $rc = json_decode($datas->rsk_c, true);
                    ?>
                <td></td>
                 <td></td>
                <td></td>
                <td>c) Storage loss during the storage in godowns if market price is not good</td>
                 <td><?php echo e($rc['value'] ?? ''); ?></td>
                <td> <?php echo e($rc['remark'] ?? ''); ?></td>
             </tr>
             
              <tr>
                <td style="font-weight:700;">4</td>
                 <td></td>
                <td></td>
                <td style="font-weight:700;">Prospects</td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                    <?php
                    $pa = json_decode($datas->prospects_a, true);
                    ?>
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Loans on low interest rates from banks</td>
               <td><?php echo e($pa['value'] ?? ''); ?></td>
                <td> <?php echo e($pa['remark'] ?? ''); ?></td>
             </tr> 
             
             <tr>
                    <?php
                    $pb = json_decode($datas->prospects_b, true);
                    ?>
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Godown for storage</td>
                  <td><?php echo e($pb['value'] ?? ''); ?></td>
                <td> <?php echo e($pb['remark'] ?? ''); ?></td>
             </tr> 
             
              <tr>
                    <?php
                    $pc = json_decode($datas->prospects_c, true);
                    ?>
                <td></td>
                 <td></td>
                <td></td>
                <td>c) Getting licences  easily </td>
                <td><?php echo e($pc['value'] ?? ''); ?></td>
                <td> <?php echo e($pc['remark'] ?? ''); ?></td>
             </tr> 
             
           
             
            </tbody>
      </table>
         </div>
        
     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
     <?php else: ?>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">A . Infrastructure and Support Services</h1>
        </div>
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Unit Rate</th>
             <th>Amt (Rs.)</th>
             <th>Annulised Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
        <tr>
            <td>1</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Cost of establishment of Input Shop Permanent</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>2</td>
            <td></td>
            <td></td>
            <td>Cost of establishment of Input Shop Temporary</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            
            <td>4</td>
            <td></td>
            <td></td>
            <td>Cost Storage Structure for Inputs</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>5</td>
             <td></td>
            <td></td>
            <td>Cost other Infrastructure for Inputs</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>  
         
          <tr>
            <td>6</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>7</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Monthly Expenses on Manpower</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>8</td>
             <td></td>
            <td></td>
            <td>Monthly rent ( If shop is on rent)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>9</td>
             <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>8</td>
             <td></td>
            <td></td>
            <td>Any Other</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         <tr>
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Intt on Capital Investment</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td></td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of CA / PHC</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>10</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Annual Intt on Working Capital</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>11</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at village/ Farm Gate Level ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>12</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>13</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism ( Village Level/ local Mandi/ APMC)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>14</td>
             <td></td>
            <td></td>
            <td>Any Other Channel</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>15</td>
             <td></td>
            <td></td>
            <td>Duration of purchase on credit</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>16</td>
             <td></td>
            <td></td>
            <td>Duration of Sale credit</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>17</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Input / advance credit to producer (% of the estimated sale)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
        <tr>
            <td>18</td>
             <td></td>
            <td></td>
            <td>Any Other Information</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        </tbody>
  </table>
        </div>  
        <br>
        <div class="table-responsive">
          <h1 class="h3 mb-0 text-gray-800">B . Business parameters</h1>
          <br>
         <table class="table table-bordered ">
            <thead>
              <tr>
                <th>S. No.</th>
                <th>FARMER ID</th>
                <th>Farmer Name</th>
    
                <th>Particulars of Inputs</th>
                <th>Unit</th>
                <th>Name of Product</th>
                <th>Unit (quantity)</th>
                <th>Average Rate (Rs./Unit Quantity)</th>
                <th>Min Rate (Rs./Unit Quantity)</th>
                <th>Max Rate (Rs./Unit Quantity)</th>
                <th>Remark</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>I</td>
                
               <td></td>
                <td></td>
                <td style="font-weight:700;">Average Purchase Price</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>   
             
             <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>Grade A (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>
             
               <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>Grade B (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>
             
               <tr>
                <td></td>  
                <td></td>
                <td></td>
                <td>Grade C (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>
             
              <tr>
                <td></td>  
                <td></td>
                <td></td>
                <td>Grade D (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>
             
             
             
              <tr>
                <td>II</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Cost of Value Addition</td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td>a</td>
                   <td></td>
                <td></td>
                <td>Pre-Harvesting Contractor Cost</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
               <tr>
                <td>b</td>
                   <td></td>
                <td></td>
                <td>Harvesting Cost</td>
                <td></td>
                <td></td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
               <tr>
                <td>c</td>
                   <td></td>
                <td></td>
                <td>Transportation Cost</td>
                <td></td>
                <td></td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
             
             <tr>
                <td>d</td>
                   <td></td>
                <td></td>
                <td>Loading and Unloading Charges</td>
                <td></td>
                <td></td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td>e</td>
                   <td></td>
                <td></td>
                <td>Primary Processing Cost</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td>f</td>
                   <td></td>
                <td></td>
                <td>Drying Loss or any other loss</td>
                <td></td>
                <td></td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td>g</td>
                   <td></td>
                <td></td>
                <td>Mandi fees /Tax/ Commission</td>
                <td></td>
                <td></td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td>h</td>
                   <td></td>
                <td></td>
                <td>Packaging expenses</td>
                <td></td>
                <td></td>
                  <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
              <tr>
                <td>i</td>
                   <td></td>
                <td></td>
                <td>Any other Marketing Cost</td>
                <td></td>
                <td></td>
                  <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
             <tr>
                <td>j</td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                  <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
              <tr>
                <td>k</td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
              <tr>
                <td>III</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Selling Price</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
             
            <tr>
                <td></td>
                   <td></td>
                <td></td>
                <td>Grade A (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td></td>
                   <td></td>
                <td></td>
                <td>Grade B (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td></td>
                   <td></td>
                <td></td>
                <td>Grade C (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>Grade D (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
            <tr>
                <td>IV</td>
                   <td></td>
                <td></td>
                <td style="font-weight:700;">Any other Cost Parameter</td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                 <td></td>
                <td></td>
                 <td></td>
             </tr> 
             
             <tr>
                <td></td>
                   <td></td>
                <td></td>
                <td>Quantum Handled in a year (weight)</td>
                <td></td>
                <td></td>
                 <td></td>
                 <td></td>
                 <td></td>
                <td></td>
                 <td></td>
             </tr> 
             
                <tr>
                <td></td>
                   <td></td>
                <td></td>
                <td>Purchase and selling prices fluctuation during the whole marketing season</td>
                <td></td>
                <td></td>
                 <td></td>
                 <td></td>
                 <td></td>
                <td></td>
                 <td></td>
             </tr> 
             
            </tbody>
      </table>
        </div>
        <br>
          <div class="table-responsive">
            <h1 class="h3 mb-0 text-gray-800">C . Indicative Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
            <br>
          <table class="table table-bordered ">
            <thead>
              <tr>
                <th>1</th>
                  <td>Farmer ID</td>
                <td>Farmer Name</td>
                <th>IIssues / Constraints</th>
                <th>Quantitative / Qualitative Indicators</th>
                <th>Remark</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>a) Quantity reduction due to moisture content during the procurement</td>
                <td></td>
                <td></td>
             </tr>   
             
             <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>b) We will not get same quality produce every time</td>
                <td></td>
                <td></td>
             </tr>
             
              <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>c) Licence issues during the transportation</td>
                <td></td>
                <td></td>
             </tr>  
             
               
             
              <tr>
                <td style="font-weight:700;">2</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Challenges</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Credit -Higher interest rates from financing persons</td>
                <td></td>
                <td></td>
             </tr> 
             
               <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Market rates will be up and down</td>
                <td></td>
                <td></td>
             </tr> 
             
               <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>c)Production will depends on weather</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td style="font-weight:700;">3</td>
                 <td></td>
                <td></td>
                <td style="font-weight:700;">Risk</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Credit basis supply to wholesaler</td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Farmer will take advance from one marketing agent will sell to other marketing agent</td>
                <td></td>
                <td></td>
             </tr>
             
              <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>c) Storage loss during the storage in godowns if market price is not good</td>
                <td></td>
                <td></td>
             </tr>
             
              <tr>
                <td style="font-weight:700;">4</td>
                 <td></td>
                <td></td>
                <td style="font-weight:700;">Prospects</td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Loans on low interest rates from banks</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Godown for storage</td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>c) Getting licences  easily </td>
                <td></td>
                <td></td>
             </tr> 
             
           
             
            </tbody>
      </table>
         </div>
     <?php endif; ?>
     
   
</div>

    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/Anexure/anexure-six-update.blade.php ENDPATH**/ ?>