<?php
    use App\Models\User;
    use Illuminate\Support\Facades\Auth;
    $userId = Auth::user()->id;
    $user = User::find($userId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $user->role_id)->get();
    $addRolePermission = $permissions->firstWhere('menu_id', 20);
?>

<?php $__env->startSection('title', 'Hectare Masters List'); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Hectare Masters</h1>
            <div class="row">
                <?php if(isset($addRolePermission) && isset($addRolePermission) && $addRolePermission->created == 1 || $userId == 1): ?>
                <div class="col-md-12">
                    <a href="<?php echo e(route('hectareMaster.create')); ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add New
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php echo $__env->make('common.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- DataTales Example -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">All Hectare Masters</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th width="20%">Role Name</th>
                                <th width="15%">User Name</th>
                                <th width="15%">Status</th>
                                <th width="10%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $hectareMaster; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hM): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($hM->role_name); ?></td>
                                    <td><?php echo e($hM->first_name.' '.$hM->last_name); ?></td>
                                    <td>
                                        <?php if($hM->status == 0): ?>
                                            <span class="badge badge-danger">Inactive</span>
                                        <?php elseif($hM->status == 1): ?>
                                            <span class="badge badge-success">Active</span>
                                        <?php endif; ?>
                                    </td>
                                    <td style="display: flex">
                                        <?php if($hM->status == 0): ?>
                                            <?php if(isset($addRolePermission) && isset($addRolePermission) && $addRolePermission->edit == 1 || $userId == 1): ?>
                                            <a href="<?php echo e(route('hectareMaster.status', ['id' => $hM->id, 'status' => 1])); ?>"
                                                class="btn btn-success m-2">
                                                <i class="fa fa-check"></i>
                                            </a>
                                            <?php else: ?>
                                            <a href="javascript:;"
                                                class="btn btn-success m-2">
                                                <i class="fa fa-check"></i>
                                            </a>
                                            <?php endif; ?>
                                        <?php elseif($hM->status == 1): ?>
                                            <?php if(isset($addRolePermission) && isset($addRolePermission) && $addRolePermission->edit == 1 || $userId == 1): ?>
                                            <a href="<?php echo e(route('hectareMaster.status', ['id' => $hM->id, 'status' => 0])); ?>"
                                                class="btn btn-danger m-2">
                                                <i class="fa fa-ban"></i>
                                            </a>
                                            <?php else: ?>
                                            <a href="javascript:;"
                                                class="btn btn-danger m-2">
                                                <i class="fa fa-ban"></i>
                                            </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                            <a href="<?php echo e(route('hectareMaster.view', ['id' => $hM->id])); ?>" class="btn btn-secondary m-2">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        <?php if(isset($addRolePermission) && isset($addRolePermission) && $addRolePermission->edit == 1 || $userId == 1): ?>
                                            <a href="<?php echo e(route('hectareMaster.edit', ['id' => $hM->id])); ?>"
                                                class="btn btn-primary m-2">
                                                <i class="fa fa-pen"></i>
                                            </a>
                                        <?php endif; ?>
                                        <?php if(isset($addRolePermission) && isset($addRolePermission) && $addRolePermission->deleted == 1 || $userId == 1): ?>
                                            <a class="btn btn-danger m-2" href="<?php echo e(route('hectareMaster.destroy', ['id' => $hM->id])); ?>"
                                               onclick="return confirm('Are you sure you want to delete this item?');">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($hectareMaster->links()); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/temeshink/public_html/surveyapp/resources/views/hectareMaster/index.blade.php ENDPATH**/ ?>