<?php

use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\RolesController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AnexureController;
use App\Http\Controllers\HectareMasterController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
});

Route::post('/forgot-password', [ForgotPasswordController::class, 'forgotpassword'])->name('forgot.password');
Route::get('/reset-password', [ForgotPasswordController::class, 'resetpassword'])->name('reset.password');
Route::post('/reset-password', [ForgotPasswordController::class, 'updatepassword'])->name('update.password');

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/annex-filter', [App\Http\Controllers\HomeController::class, 'filter'])->name('filter');

// Profile Routes
Route::prefix('profile')->name('profile.')->middleware('auth')->group(function()
{
    Route::get('/', [HomeController::class, 'getProfile'])->name('detail');
    Route::post('/update', [HomeController::class, 'updateProfile'])->name('update');
    Route::post('/change-password', [HomeController::class, 'changePassword'])->name('change-password');
});


// Users
Route::middleware('auth')->prefix('users')->name('users.')->group(function()
{
    Route::get('/', [UserController::class, 'index'])->name('index');
    Route::get('/create', [UserController::class, 'create'])->name('create');
    Route::post('/store', [UserController::class, 'store'])->name('store');
    Route::get('/edit/{user}', [UserController::class, 'edit'])->name('edit');
    Route::get('/view/{user}', [UserController::class, 'view'])->name('view');
    Route::post('/update/{user}', [UserController::class, 'update'])->name('update');
    Route::get('/delete/{user}', [UserController::class, 'delete'])->name('destroy');
    Route::get('/update/status/{user_id}/{status}', [UserController::class, 'updateStatus'])->name('status');
    Route::get('/import-users', [UserController::class, 'importUsers'])->name('import');
    Route::post('/upload-users', [UserController::class, 'uploadUsers'])->name('upload');
    Route::get('export/', [UserController::class, 'export'])->name('export');
    Route::get('/get-districts/{state}', [UserController::class, 'getDistrict'])->name('get-districts');
    Route::get('/fetch-existing-codes', [UserController::class, 'fetchExistingCodes'])->name('fetchExistingCodess');
    Route::get('/get-fpo/{fpo}', [UserController::class, 'getFpo'])->name('get-fpo');
});

// Roles
Route::middleware('auth')->prefix('roles')->name('roles.')->group(function()
{
    Route::get('/', [RolesController::class, 'index'])->name('index');
    Route::get('/create', [RolesController::class, 'create'])->name('create');
    Route::post('/store', [RolesController::class, 'store'])->name('store');
    Route::get('/edit/{role}', [RolesController::class, 'edit'])->name('edit');
    Route::put('/update/{role}', [RolesController::class, 'update'])->name('update');
    Route::get('/delete/{role}', [RolesController::class, 'delete'])->name('destroy');
    Route::get('/update/status/{role_id}/{status}', [RolesController::class, 'updateStatus'])->name('status');
});

// Hectare Master
Route::middleware('auth')->prefix('hectare-master')->name('hectareMaster.')->group(function()
{
    Route::get('/', [HectareMasterController::class, 'index'])->name('index');
    Route::get('/create', [HectareMasterController::class, 'create'])->name('create');
    Route::post('/store', [HectareMasterController::class, 'store'])->name('store');
    Route::get('/edit/{id}', [HectareMasterController::class, 'edit'])->name('edit');
    Route::put('/update/{id}', [HectareMasterController::class, 'update'])->name('update');
    Route::get('/delete/{id}', [HectareMasterController::class, 'delete'])->name('destroy');
    Route::get('/view/{id}', [HectareMasterController::class, 'view'])->name('view');
    Route::get('/update/status/{id}/{status}', [HectareMasterController::class, 'updateStatus'])->name('status');
    Route::get('/users-data/{role_id}', [HectareMasterController::class, 'getUsersByRoleId'])->name('getUsersByRole');
});

// Anexure
Route::middleware('auth')->prefix('anexure')->name('anexure.')->group(function()
{
    Route::get('/anexure-list-one', [AnexureController::class, 'one_list'])->name('one');
    
    // Route::match(['get','post'],'/anexure-one-update/{value?}', [AnexureController::class, 'anexureOneUpdate'])->name('one.update');
    Route::match(['get','post'],'/anexure-one-update', [AnexureController::class, 'anexureOneUpdate'])->name('one.update');
    
    Route::get('/anexure-list-two', [AnexureController::class, 'two_list'])->name('two');
    
    Route::match(['get','post'],'/anexure-two-update', [AnexureController::class, 'anexureTwoUpdate'])->name('two.update');
    
    Route::get('/anexure-list-three', [AnexureController::class, 'three_list'])->name('three');
    Route::match(['get','post'],'/anexure-three-update', [AnexureController::class, 'anexureThreeUpdate'])->name('three.update');
    Route::get('/anexure-list-four', [AnexureController::class, 'four_list'])->name('four');
    
    Route::get('/anexure-list-e', [AnexureController::class, 'e_list'])->name('e');
    
    Route::match(['get','post'],'/anexure-e-update', [AnexureController::class, 'anexureEUpdate'])->name('e.update');


    Route::get('/anexure-list-f', [AnexureController::class, 'f_list'])->name('f');
    Route::match(['get','post'],'/anexure-f-update', [AnexureController::class, 'anexureFUpdate'])->name('f.update');
    
    
    Route::get('/anexure-distributor', [AnexureController::class, 'anexure_distributor'])->name('distributor');
    
    Route::get('/anexure-fpo-a', [AnexureController::class, 'fpo_a'])->name('fpo_a');
    
    Route::get('/anexure-fpo-b', [AnexureController::class, 'fpo_b'])->name('fpo_b');

    
    Route::match(['get','post'],'/anexure-four-update', [AnexureController::class, 'anexureFourUpdate'])->name('four.update');
    Route::get('/anexure-list-five', [AnexureController::class, 'five_list'])->name('five');
    Route::match(['get','post'],'/anexure-five-update', [AnexureController::class, 'anexureFiveUpdate'])->name('five.update');
    Route::get('/anexure-list-six', [AnexureController::class, 'six_list'])->name('six');
    Route::match(['get','post'],'/anexure-six-update', [AnexureController::class, 'anexureSixUpdate'])->name('six.update');
    Route::get('/anexure-list-seven', [AnexureController::class, 'seven_list'])->name('seven');
    Route::match(['get','post'],'/anexure-seven-update', [AnexureController::class, 'anexureSevenUpdate'])->name('seven.update');
    Route::get('/anexure-list-eight', [AnexureController::class, 'eight_list'])->name('eight');
    Route::match(['get','post'],'/anexure-eight-update', [AnexureController::class, 'anexureEightUpdate'])->name('eight.update');
    Route::get('/update/annexure-one-status/{crop_id}/{status}', [AnexureController::class, 'updateAnnexureOneStatus'])->name('one.status');
    Route::get('/update/annexure-two-status/{last_year_id}/{status}', [AnexureController::class, 'updateAnnexureTwoStatus'])->name('two.status');
    Route::get('/update/annexure-three-status/{agri_act_id}/{status}', [AnexureController::class, 'updateAnnexureThreeStatus'])->name('three.status');
    Route::get('/update/annexure-four-one-status/{backward_link_id}/{status}', [AnexureController::class, 'updateAnnexureFour1Status'])->name('four.one.status');
    Route::get('/update/annexure-four-two-status/{forward_link_id}/{status}', [AnexureController::class, 'updateAnnexureFour2Status'])->name('four.two.status');
    Route::get('/update/annexure-five-status/{input_supp_id}/{status}', [AnexureController::class, 'updateAnnexureFiveStatus'])->name('five.status');
    Route::get('/update/annexure-six-status/{caph_farms_id}/{status}', [AnexureController::class, 'updateAnnexureSixStatus'])->name('six.status');
    Route::get('/update/annexure-seven-status/{caph_farms_id}/{status}', [AnexureController::class, 'updateAnnexureSevenStatus'])->name('seven.status');
    Route::get('/update/annexure-eight-one-status/{va_one_farms_id}/{status}', [AnexureController::class, 'updateAnnexureEightOneStatus'])->name('eight.one.status');
    Route::get('/update/annexure-eight-two-status/{va_two_farms_id}/{status}', [AnexureController::class, 'updateAnnexureEightTwoStatus'])->name('eight.two.status');
    Route::get('/update/annexure-eight-three-status/{va_three_farms_id}/{status}', [AnexureController::class, 'updateAnnexureEightThreeStatus'])->name('eight.three.status');
});


// Report
Route::middleware('auth')->prefix('report')->name('report.')->group(function()
{
    Route::get('/report-list', [ReportController::class, 'report'])->name('report');
    Route::get('/aa-combine', [ReportController::class, 'aacombine_list'])->name('aacombine_list');
    Route::get('/aaa-combine', [ReportController::class, 'aaacombine_list'])->name('aaacombine_list');
    Route::get('/iab-combine', [ReportController::class, 'iabcombine_list'])->name('iabcombine_list');
});

