<?php

use App\Http\Controllers\Api\AgricultureController;
use App\Http\Controllers\Api\GetController;
use App\Http\Controllers\Api\AppController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::post('/auth/login-user', [AppController::class, 'loginUser']);



Route::middleware(['auth:sanctum'])->group(function () {
        Route::get('farmer-profile', [AppController::class, 'farmerProfile'])->name('farmer.profile');
        Route::post('update/farmer-profile', [AppController::class, 'updateFarmerProfile'])->name('update.farmer.profile');
        Route::post('update/farmer-data', [AppController::class, 'farmerDataUpdate'])->name('update.farmer.data');
        Route::post('create-farmer', [AppController::class, 'createFarmer'])->name('create.farmer');
        Route::post('create-crop', [AppController::class, 'createCrop'])->name('create.crop');
        Route::post('crop-cultivation/one', [AppController::class, 'cropCultivation'])->name('crop.cultivation.one');
        Route::post('crop-cultivation/two', [AppController::class, 'cropCultivation'])->name('crop.cultivation.two');
        Route::post('crop-cultivation/three', [AppController::class, 'cropCultivation'])->name('crop.cultivation.three');
        Route::post('crop-cultivation/four', [AppController::class, 'cropCultivation'])->name('crop.cultivation.four');
        Route::post('crop-cultivation/five', [AppController::class, 'cropCultivation'])->name('crop.cultivation.five');
        Route::post('crop-cultivation/six', [AppController::class, 'cropCultivation'])->name('crop.cultivation.six');
        Route::post('production-output', [AppController::class, 'productionOutput'])->name('production.output');
        
        Route::post('infrastructure/one', [AppController::class, 'infrastructure'])->name('infrastructure.one');
        
        Route::post('infrastructure/two', [AppController::class, 'infrastructure'])->name('infrastructure.two');
        Route::post('infrastructure/three', [AppController::class, 'infrastructure'])->name('infrastructure.three');
        Route::post('infrastructure/four', [AppController::class, 'infrastructure'])->name('infrastructure.four');
        Route::post('infrastructure/five', [AppController::class, 'infrastructure'])->name('infrastructure.five');
        Route::post('infrastructure/six', [AppController::class, 'infrastructure'])->name('infrastructure.six');
        Route::post('infrastructure/seven', [AppController::class, 'infrastructure'])->name('infrastructure.seven');
        
        Route::post('three_year_production', [AppController::class, 'threeYearProduction'])->name('production.years');
        
        Route::match(['get','post'],'agriculture_activities/one', [AgricultureController::class, 'agriculture_activities'])->name('agriculture.one.activities');
        Route::match(['get','post'],'agriculture_activities/two', [AgricultureController::class, 'agriculture_activities'])->name('agriculture.two.activities');
        // Route::post('backward_linkage', [AgricultureController::class, 'backward_linkage'])->name('backward.linkage');
        
        Route::post('backward_linkage/one', [AgricultureController::class, 'backward_linkage'])->name('backward.linkage');
        
        Route::post('backward_linkage/two', [AgricultureController::class, 'backward_linkage'])->name('backward.linkage');
        
        
        Route::post('forward_linkage/one', [AgricultureController::class, 'forward_linkage_data'])->name('forward.one.linkage');
        Route::post('forward_linkage/two', [AgricultureController::class, 'forward_linkage_data'])->name('forward.two.linkage');
        
        Route::post('input-supplier', [AgricultureController::class, 'input_upplier'])->name('input.suplier');
        
        Route::post('caph-farm', [AgricultureController::class, 'caph_farm'])->name('caph.farm');
        
        Route::post('trd-farm', [AgricultureController::class, 'trd_farm'])->name('trd.farm');
        
        Route::match(['get','post'],'va-farm-one', [AgricultureController::class, 'va_farm_one'])->name('va.farm.one');
        
        Route::match(['get','post'],'va-farm-two', [AgricultureController::class, 'va_farm_two'])->name('va.farm.two');
        
        Route::match(['get','post'],'va-farm-three', [AgricultureController::class, 'va_farm_three'])->name('va.farm.three');
        
        Route::post('distributor', [AgricultureController::class, 'distributor'])->name('distributor');
        
        Route::post('fpo-a', [AgricultureController::class, 'fpoA'])->name('fpo-a');
        
        Route::post('fpo-b', [AgricultureController::class, 'fpoB'])->name('fpo-b');

         //|/|/|/|/|/|/|/|/|/|/|/|/|/get/|/|/|/|/|/|/|/|/|/|/|/|/|//
        Route::get('get_farmers', [GetController::class, 'getFarmer'])->name('get_farmer');
      
    });


