<?php
    use App\Models\User;
    use Illuminate\Support\Facades\Auth;
    $userId = Auth::user()->id;
    $user = User::find($userId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $user->role_id)->get();
    $addUserPermission = $permissions->firstWhere('menu_id', 16);
?>
@extends('layouts.app')

@section('title', 'Users List')

@section('content')
    <div class="container-fluid">

        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Users</h1>
            <div class="row">
                @if(isset($addUserPermission) && isset($addUserPermission) && $addUserPermission->created == 1 || $userId == 1)
                <div class="col-md-12">
                    <a href="{{ route('users.create') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add New
                    </a>
                </div>
                @endif
                {{--  <div class="col-md-6">
                    <a href="{{ route('users.export') }}" class="btn btn-sm btn-success">
                        <i class="fas fa-check"></i> Export To Excel
                    </a>
                </div>  --}}

            </div>

        </div>

        {{-- Alert Messages --}}
        @include('common.alert')

        <!-- DataTales Example -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">All Users</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="110%" cellspacing="0">
                        <thead>
                            <tr>
                                <th width="20%">Name</th>
                                <th width="15%">Email</th>
                                <th width="10%">Mobile</th>
                                <th width="10%">Role</th>
                                <th width="10%">Farmer Code</th>
                                <th width="10%">Password</th>
                                <th width="15%">FPO Name</th>
                                <th width="10%">Status</th>
                                <th width="10%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($users as $user)
                                <tr>
                                    <td>{{ $user->full_name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>{{ $user->mobile_number }}</td>
                                    <td>{{ $user->role_name ? $user->role_name : '' }}</td>
                                    <td>{{ $user->farmer_code_id ? $user->farmer_code_id : '' }}</td>
                                    <td>{{ $user->decrypt_password ? $user->decrypt_password : '' }}</td>
                                    <td>{{ $user->team_first_name ? Str::limit($user->team_first_name,10).' '.Str::limit($user->team_last_name,5) : '' }}</td>
                                    <td>
                                        @if ($user->status == 0)
                                            <span class="badge badge-danger">Inactive</span>
                                        @elseif ($user->status == 1)
                                            <span class="badge badge-success">Active</span>
                                        @endif
                                    </td>
                                    <td style="display: flex">
                                        
                                        @if(isset($user->id) && $user->id == 1)
                                            <a href="javascript:;"
                                                class="btn btn-danger m-2">
                                                <i class="fa fa-ban"></i>
                                            </a>
                                        @else
                                            @if ($user->status == 0)
                                                @if(isset($addUserPermission) && isset($addUserPermission) && $addUserPermission->edit == 1 || $userId == 1)
                                                    @if(isset($userId) && $userId != $user->id)
                                                        <a href="{{ route('users.status', ['user_id' => $user->id, 'status' => 1]) }}"
                                                            class="btn btn-success m-2">
                                                            <i class="fa fa-check"></i>
                                                        </a>
                                                    @else
                                                        <a href="javascript:;"
                                                            class="btn btn-success m-2">
                                                            <i class="fa fa-check"></i>
                                                        </a>
                                                    @endif
                                                @else
                                                    <a href="javascript:;"
                                                        class="btn btn-success m-2">
                                                        <i class="fa fa-check"></i>
                                                    </a>
                                                @endif
                                            @elseif ($user->status == 1)
                                                @if(isset($addUserPermission) && isset($addUserPermission) && $addUserPermission->edit == 1 || $userId == 1)
                                                    @if(isset($userId) && $userId != $user->id)
                                                        <a href="{{ route('users.status', ['user_id' => $user->id, 'status' => 0]) }}"
                                                            class="btn btn-danger m-2">
                                                            <i class="fa fa-ban"></i>
                                                        </a>
                                                    @else
                                                        <a href="javascript:;"
                                                            class="btn btn-danger m-2">
                                                            <i class="fa fa-ban"></i>
                                                        </a>
                                                    @endif
                                                @else
                                                    <a href="javascript:;"
                                                        class="btn btn-danger m-2">
                                                        <i class="fa fa-ban"></i>
                                                    </a>
                                                @endif
                                            @endif
                                        @endif
                                        <a href="{{ route('users.view', ['user' => $user->id]) }}"
                                            class="btn btn-success m-2">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        @if(isset($addUserPermission) && isset($addUserPermission) && $addUserPermission->edit == 1 || $userId == 1)
                                        <a href="{{ route('users.edit', ['user' => $user->id]) }}"
                                            class="btn btn-primary m-2">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                        @endif
                                        @if(isset($addUserPermission) && isset($addUserPermission) && $addUserPermission->deleted == 1 || $userId == 1)
                                            @if(isset($user->id) && $user->id == 1)
                                                <a class="btn btn-danger m-2" href="javascript:;" >
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                            @else
                                                @if(isset($userId) && $userId == $user->id)
                                                    <a class="btn btn-danger m-2" href="javascript:;" >
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                @else
                                                    <a class="btn btn-danger m-2" href="{{ route('users.destroy', ['user' => $user->id]) }}" >
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                @endif
                                            @endif
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $users->links() }}
                </div>
            </div>
        </div>

    </div>
    
    @include('users.delete-modal')

@endsection

@section('scripts')

@endsection
