
<!DOCTYPE html>
<html lang="en">

{{-- Include Head --}}
@include('common.head')

<link rel="stylesheet" href="https://cdn.datatables.net/2.0.4/css/dataTables.dataTables.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/3.0.2/css/buttons.dataTables.css">

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        @include('common.sidebar')
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                @include('common.header')
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                @yield('content')
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            @include('common.footer')
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    @include('common.logout-modal')

    <!-- Bootstrap core JavaScript-->
    <script src="{{asset('js/app.js')}}"></script>
    
    <!-- Custom scripts for all pages-->
    <script src="{{asset('admin/js/sb-admin-2.min.js')}}"></script>

    @yield('scripts')
    
    
    <script>
        // function exportTableData() {
        //     var table = document.getElementById("dataTable");
        //     var csv = [];
        //     var rows = table.getElementsByTagName("tr");
            
        //     for (var i = 0; i < rows.length; i++) {
        //         var row = [], cols = rows[i].getElementsByTagName("td");
            
        //         for (var j = 0; j < cols.length; j++) {
        //             row.push(cols[j].innerText);
        //         }
        //         csv.push(row.join(","));
        //     }
            
        //     var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
        //     var link = document.createElement("a");
        //     link.href = window.URL.createObjectURL(csvData);
        //     link.download = "table_data.csv";
        //     link.style.display = "none";
            
        //     document.body.appendChild(link);
        //     link.click();
            
        //     document.body.removeChild(link);
        // }
        
        // function exportTableData() {
        //     var tables = document.querySelectorAll("table"); 
        //     var csv = [];
        
        //     tables.forEach(function(table) {
        //         var rows = table.getElementsByTagName("tr");
                
        //         for (var i = 0; i < rows.length; i++) {
        //             var row = [], cols = rows[i].getElementsByTagName("td");
                
        //             for (var j = 0; j < cols.length; j++) {
        //                 row.push(cols[j].innerText);
        //             }
        //             csv.push(row.join(","));
        //         }
        
        //         csv.push("");
        //     });
            
        //     var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
        //     var link = document.createElement("a");
        //     link.href = window.URL.createObjectURL(csvData);
        //     link.download = "table_data.csv";
        //     link.style.display = "none";
            
        //     document.body.appendChild(link);
        //     link.click();
            
        //     document.body.removeChild(link);
        // }
        
        function exportTableData() {
            var tables = document.querySelectorAll("table");
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
        
                for (var i = 0; i < rows.length; i++) {
                    var row = [],
                        cols = rows[i].querySelectorAll("th, td"); // Select both th and td
        
                    for (var j = 0; j < cols.length; j++) {
                        var cellText = cols[j].innerText.trim().replace(/"/g, '""'); // Handle double quotes in data
        
                        // Check if current cell is th or td
                        if (cols[j].tagName.toLowerCase() === "th") {
                            // Treat <th> differently if needed (e.g., preserve case, formatting)
                            row.push('"' + cellText + '"'); // Enclose in quotes to ensure Excel treats as text
                        } else {
                            row.push('"' + cellText + '"'); // Enclose in quotes to ensure Excel treats as text
                        }
                    }
                    csv.push(row.join(","));
                }
        
                csv.push(""); // Add a blank line between tables
            });
        
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
        
            document.body.appendChild(link);
            link.click();
        
            document.body.removeChild(link);
        }


    </script>
    
    <script>
        document.getElementById('filterBtn').addEventListener('click', function() {
            var selectedMonth = document.getElementById('month').value;
            var selectedYear = document.getElementById('year').value;
            var dataUrl = document.getElementById('filterBtn').getAttribute('data-url'); 
            var url = dataUrl;
        
            if (selectedMonth) {
                url += "?month=" + selectedMonth;
                if (selectedYear) {
                    url += "&year=" + selectedYear;
                }
            } else if (selectedYear) {
                url += "?year=" + selectedYear;
            }
        
            window.location.href = url;
        });

    </script>
</body>

</html>