@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')
<?php
$userId = Auth::user()->id;
?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Dashboard </h1>

    </div>

    <div class="row">
        <div class="col-md-12">
            <h2 class="text-center mb-3"></h2>
        </div>
    </div>

    <!-- Content Row -->
    <div class="row">

        <!-- Earnings (Monthly) Card Example -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Users</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                @php
                                $count = \App\Models\User::where('id','!=', 1)->count();
                                @endphp
                                {{ $count }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Earnings (Monthly) Card Example -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active Users</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"> @php
                                $count1 = \App\Models\User::where('id','!=', 1)->where('status','=',1)->count();

                                @endphp
                                {{ $count1 }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{--
        <!-- Earnings (Monthly) Card Example -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Tasks
                            </div>
                            <div class="row no-gutters align-items-center">
                                <div class="col-auto">
                                    <div class="h5 mb-0 mr-3 font-weight-bold text-gray-800">50%</div>
                                </div>
                                <div class="col">
                                    <div class="progress progress-sm mr-2">
                                        <div class="progress-bar bg-info" role="progressbar" style="width: 50%"
                                            aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pending Requests Card Example -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Pending Requests</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">18</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-comments fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div> --}}
    </div>

    <form method="get" action="{{url('annex-filter')}}">

        <div class="card">
            <div class="card-body">
                <div class="d-flex">
                    <div class="col-md-3">
                        <label for="start_date">Start Date</label>
                        <input type="text" class="date form-control" id="start_date" name="start_date"
                            placeholder="DD/MM/YYYY">
                    </div>

                    <div class="col-md-3 ml-2">
                        <label for="end_date">End Date</label>
                        <input type="text" class="date form-control" id="end_date" name="end_date"
                            placeholder="DD/MM/YYYY">
                    </div>

                    <div class="col-md-4">
                        <label for="start_date">Anexure Data</label>
                        <select class="select2 form-control custom-select" id="annexSelect"
                            style="width: 100%; height:36px;" name="annexure">
                            <option value="0">Select Anexure</option>
                            
                            @if(isset($anexuerOnePer) && isset($anexuerOnePer) && $anexuerOnePer->view == 1 || $userId
                            == 1)
                            <option value="1">Farm Input and Output (1A)</option>
                            @endif
                            
                            @if(isset($anexuerTwoPer) && isset($anexuerTwoPer) && $anexuerTwoPer->view == 1 || $userId
                            == 1)
                            <option value="2">Infrastructure and Support Services (1B)</option>
                            @endif
                            
                            @if(isset($anexuerThreePer) && isset($anexuerThreePer) && $anexuerThreePer->view == 1 ||
                            $userId == 1)
                            <option value="3">CAP & Marketed Surplus (1C)</option>
                            @endif
                            @if(isset($anexuerFourPer) && isset($anexuerFourPer) && $anexuerFourPer->view == 1 ||
                            $userId == 1)
                            <option value="4">Allied Agriculture (1D)</option>
                            @endif
                            
                           
                            <option value="9">Backward Linkages (1E)</option>
                            
                            <option value="10">Forward Linkages (1F)</option>

                            @if(isset($anexuerSixPer) && isset($anexuerSixPer) && $anexuerSixPer->view == 1 || $userId
                            == 1)
                            <option value="6">Anexure CAPHFARM III</option>
                            @endif
                            
                            @if(isset($anexuerFivePer) && isset($anexuerFivePer) && $anexuerFivePer->view == 1 ||
                            $userId == 1)
                            <option value="5">Anexure Supplier II</option>
                            @endif
                            
                           
                            
                            @if(isset($anexuerSevenPer) && isset($anexuerSevenPer) && $anexuerSevenPer->view == 1 ||
                            $userId == 1)
                            <option value="7">Anexure TRDFARM IV</option>
                            @endif
                            
                            @if(isset($anexuerEightPer) && isset($anexuerEightPer) && $anexuerEightPer->view == 1 ||
                            $userId == 1)
                            <option value="8">Anexure VAFARM V</option>
                            @endif
                            
                            <option value="11">Business Economics of Distributor/ Retailer</option>
                            
                            <option value="12"> Resource Mapping of FPO </option>
                            
                            <option value="13"> Capabilities Mapping of FPO </option>
                            
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label for="start_date">FPO</label>
                        <br>
                        <select class="select2 form-control fpo_id custom-select" data-url="{{url('')}}" id="fpo"
                            style="width: 40%; height:36px;" name="fpo_id">
                            <option value="" selected disabled>Select FPO</option>
                            @foreach($fpo as $fpos)
                            <option value="{{$fpos->id}}">{{$fpos->first_name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <br>
                <?php
                  $crops = array("Alsi","Any other","Barseem","Brow Lentils (masoor)","Cultivation of Babycorn",
                  "Grams","Kusum","Mushroom farming","Peas","Paddy","Rabi Maize","Rajma","Rye Mustard","Wheat","Yellow Mustard");
                ?>
                <div class="row" id="annexField">
                    
                    <div class="form-group d-none" id="state">
                        <div class="col-md-9">
                            <span class="reqFieldAsterisk validateStateAsterisk"
                                style="color:red; display:none;">*</span><label>State</label>
                            <select id="state_id" data-url="{{url('')}}"
                                class="form-control validateState requiredFieldAction form-control-user "
                                name="state_id">
                                <option value="" selected disabled>Nothing Selected</option>
                                @foreach ($states as $state)
                                <option value="{{$state->id}}">{{$state->state_name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group d-none" id="city">
                        <label class="col-md-8 m-t-15">City</label>
                        <div class="col-md-9">
                            <select id="district_id" data-url="{{route('users.fetchExistingCodess')}}"
                                class="form-control validateDistrict requiredFieldAction form-control-user @error('district_id') is-invalid @enderror select_district"
                                name="district_id">
                                <option value="" selected disabled>Nothing Selected</option>
                            </select>
                        </div>
                    </div>

                    <!--<div class="form-group d-none" id="village">-->
                    <!--    <label class="col-md-8 m-t-15">Village</label>-->
                    <!--    <div class="col-md-9">-->
                    <!--        <input type="text" placeholder="Enter village" name="village" class="form-control" />-->
                    <!--    </div>-->
                    <!--</div>-->
                    
                    <div class="form-group d-none" id="village">
                        <label class="col-md-12 m-t-15">Village</label>
                        <div class="col-md-9">
                            <select class="form-control" name="village" id="village_id">
                                <option value="" selected disabled>Nothing Selected</option>
                            </select>
                        </div>
                    </div>
                    
                    
                    <div class="form-group d-none" id="block">
                        <label class="col-md-12 m-t-15">Block</label>
                        <div class="col-md-9">
                            <select class="form-control" name="block" id="block_id">
                                <option value="" selected disabled>Nothing Selected</option>
                                
                            </select>
                        </div>
                    </div>
                    

                    
                    <div class="form-group d-none" id="crop">
                        <label class="col-md-8 m-t-15">Crop</label>
                        <div class="col-md-9">
                            <select id="crop_id" class="form-control" name="crop_name">
                                <option value="" selected disabled>Nothing Selected</option>
                                @foreach($crops as $val)
                                <option>{{$val}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    

                    <div class="form-group d-none" id="from-hectare">
                        <label class="col-md-8 m-t-15">From Hectare</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="Enter From hectare" name="from_hectare"
                                class="form-control" />
                        </div>
                    </div>

                    <div class="form-group d-none" id="to-hectare">
                        <label class="col-md-8 m-t-15">To Hectare</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="Enter To hectare" name="to_hectare" class="form-control" />
                        </div>
                    </div>





                    <?php
                      $whomsold = array("Consumer","Company","Commission Agent","Mandi","Processor","Retailer","Village Trader","Wholesaler",
                      "Other");
                    ?>
                    <div class="form-group d-none" id="whom_to_sold">
                        <label class="col-md-12 m-t-15">Whom to Sold</label>
                        <div class="col-md-9">
                            <select class="form-control" name="whom_to_sold">
                                <option value="" selected disabled>Nothing Selected</option>
                                @foreach($whomsold as $val)
                                <option value="{{$val}}">{{$val}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <?php
                      $farmerslandwise = array("Marginal: Less than 1 hectare","Small: 1–2 hectares","Semi-medium: 2–4 hectares","Medium: 4–10 hectares","Large: More than 10 hectares");
                    ?>
                    <div class="form-group d-none" id="farmers_land_wise">
                        <label class="col-md-12 m-t-15">Farmers Land Wise</label>
                        <div class="col-md-9">
                            <select class="form-control" name="farmers_land_wise">
                                <option value="" selected disabled>Nothing Selected</option>
                                @foreach($farmerslandwise as $val)
                                <option value="{{$val}}">{{$val}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group d-none" id="animal_name">
                        <label class="col-md-12 m-t-15">Animal Name</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="Enter animal name" name="animal_name"
                                class="form-control" />
                        </div>
                    </div>

                    <div class="form-group d-none" id="breed">
                        <label class="col-md-8 m-t-15">Breed</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="Enter breed" name="breed" class="form-control" />
                        </div>
                    </div>

                    <div class="form-group d-none" id="whom_purchased">
                        <label class="col-md-12 m-t-15">Whom purchased</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="Enter whom purchased" name="whom_purchased"
                                class="form-control" />
                        </div>
                    </div>

                    <!--<div class="form-group d-none" id="supplier">-->
                    <!--    <label class="col-md-8 m-t-15">Supplier</label>-->
                    <!--    <div class="col-md-9">-->
                    <!--        <input type="text" placeholder="Enter supplier" name="supplier" class="form-control"/>-->
                    <!--    </div>-->
                    <!--</div>-->

                </div>
            </div>
            <div class="border-top">
                <div class="card-body">
                    <button type="submit" class="btn btn-primary chartbutton">Search</button>
                </div>
            </div>
        </div>
    </form>

    <div class="col-md-4">
        <canvas id="myChart" class="myChart"></canvas>
    </div>

</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
$(document).ready(function() {
    const ctx = document.getElementById('myChart');

    new Chart(ctx, {
        type: 'pie',
        data: {
            labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple', 'Orange'],
            datasets: [{
                label: '# of Votes',
                data: [12, 19, 3, 5, 2, 3],
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    flatpickr(".date", {
        dateFormat: "d/m/Y",
    });

    let annex = {
        0: [],
        1: ['crop', 'from-hectare', 'state', 'city', 'village', 'whom_to_sold', 'to-hectare',
            'farmers_land_wise' , 'block'
        ],
        21: ['animal_name', 'breed', 'whom_purchased', 'supplier'],
        2: [],
        3: [],
        4: [],
        5: [],
        6: []
    }

    $('#annexSelect').change(function() {
        let annexId = $(this).val();
        $('#annexField .form-group').each(function() {
            let id = $(this).attr('id')
            if (annexId && annex[annexId].includes(id)) {
                $(this).removeClass('d-none')
            } else {
                $(this).addClass('d-none')
            }
        })
    })

    //state base city
    $('body').on('change', '#state_id', function() {
        var state_id = $(this).val();
        var url = $(this).attr('data-url');
        $('#district_id').empty();
        $.ajax({
            url: url + '/users/get-districts/' + state_id,
            type: 'get',
            success: function(resp) {
                $('#district_id').html(resp.html);
                $('#district_id').selectpicker('refresh');
            }
        });
    });
    

    
   
   
    //fpo search data
    
    $('#fpo').change(function() {
    var fpo = $(this).val();
    var url = $(this).attr('data-url');
    $.ajax({
        url: url + '/users/get-fpo/' + fpo,
        type: 'get',
        success: function(resp) {
            if (resp.status === 'success') {
                var addedState = new Set();
                var addedDistrict = new Set();
                var addedBlocks = new Set();
                var addedVillage = new Set();
                
                var state = '';
                var district = '';
                var block = '';
                var village = '';

                $.each(resp.data, function(index, item) {
                    if (item.state_name && !addedState.has(item.state_name)) {
                        state += '<option value="' + item.state_id + '">' + item.state_name + '</option>';
                        addedState.add(item.state_name);
                    }

                    if (item.district_name && !addedDistrict.has(item.district_name)) {
                        district += '<option value="' + item.district_id + '">' + item.district_name + '</option>';
                        addedDistrict.add(item.district_name);
                    }

                    if (item.block && !addedBlocks.has(item.block)) {
                        block += '<option value="' + item.block + '">' + item.block + '</option>';
                        addedBlocks.add(item.block);
                    }

                    if (item.village && !addedVillage.has(item.village)) {
                        village += '<option value="' + item.village + '">' + item.village + '</option>';
                        addedVillage.add(item.village);
                    }
                });

                $('#state_id').html(state);
                $('#district_id').html(district);
                $('#block_id').html(block);
                $('#village_id').html(village);
            } else {
                console.log('Error fetching data.');
            }
        },
        error: function() {
            console.log('AJAX error.');
        }
    });
});
 




})

// document.addEventListener('DOMContentLoaded', function () {});
</script>



@endsection