@extends('layouts.app')
@section('title', 'View Hectare Masters')
@section('content')

<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">View Hectare Masters</h1>
        <a href="{{route('hectareMaster.index')}}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
        <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back</a>
    </div>
    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">View Hectare Masters</h6>
        </div>
        <div class="container mt-4" style="margin-bottom: 20px;">
            <div class="card">
                <div class="card-header">
                    Data Details
                </div>
                <table class="table table-bordered">
                    <tbody>
                        <tr>
                            <td>Role Name</td>
                            <td>{{isset($hectareMaster->role_name) && $hectareMaster->role_name ? $hectareMaster->role_name : ''}}</td>
                        </tr>
                        <tr>
                            <td>User Name</td>
                            <td>{{isset($hectareMaster->first_name) && $hectareMaster->first_name ? $hectareMaster->first_name.' '.$hectareMaster->last_name : ''}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            @if(isset($hectareMeasurement) && $hectareMeasurement)
            <div class="card">
                <div class="card-header">
                    Hectare Measurement
                </div>
                <table class="table table-bordered">
                    <tbody>
                        @foreach($hectareMeasurement as $hM)
                        <tr>
                            <td>1 Hectare :</td>
                            <td>{{isset($hM->value) && $hM->value ? $hM->value.' '.$hM->unit : ''}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @endif
        </div>
    </div>
</div>

@endsection
