<?php
    use App\Models\User;
    use Illuminate\Support\Facades\Auth;
    $userId = Auth::user()->id;
    $user = User::find($userId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $user->role_id)->get();
    $addRolePermission = $permissions->firstWhere('menu_id', 20);
?>
@extends('layouts.app')
@section('title', 'Hectare Masters List')
@section('content')
    <div class="container-fluid">
        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Hectare Masters</h1>
            <div class="row">
                @if(isset($addRolePermission) && isset($addRolePermission) && $addRolePermission->created == 1 || $userId == 1)
                <div class="col-md-12">
                    <a href="{{ route('hectareMaster.create') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add New
                    </a>
                </div>
                @endif
            </div>
        </div>
        @include('common.alert')
        <!-- DataTales Example -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">All Hectare Masters</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th width="20%">Role Name</th>
                                <th width="15%">User Name</th>
                                <th width="15%">Status</th>
                                <th width="10%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($hectareMaster as $hM)
                                <tr>
                                    <td>{{ $hM->role_name }}</td>
                                    <td>{{ $hM->first_name.' '.$hM->last_name }}</td>
                                    <td>
                                        @if ($hM->status == 0)
                                            <span class="badge badge-danger">Inactive</span>
                                        @elseif ($hM->status == 1)
                                            <span class="badge badge-success">Active</span>
                                        @endif
                                    </td>
                                    <td style="display: flex">
                                        @if ($hM->status == 0)
                                            @if(isset($addRolePermission) && isset($addRolePermission) && $addRolePermission->edit == 1 || $userId == 1)
                                            <a href="{{ route('hectareMaster.status', ['id' => $hM->id, 'status' => 1]) }}"
                                                class="btn btn-success m-2">
                                                <i class="fa fa-check"></i>
                                            </a>
                                            @else
                                            <a href="javascript:;"
                                                class="btn btn-success m-2">
                                                <i class="fa fa-check"></i>
                                            </a>
                                            @endif
                                        @elseif ($hM->status == 1)
                                            @if(isset($addRolePermission) && isset($addRolePermission) && $addRolePermission->edit == 1 || $userId == 1)
                                            <a href="{{ route('hectareMaster.status', ['id' => $hM->id, 'status' => 0]) }}"
                                                class="btn btn-danger m-2">
                                                <i class="fa fa-ban"></i>
                                            </a>
                                            @else
                                            <a href="javascript:;"
                                                class="btn btn-danger m-2">
                                                <i class="fa fa-ban"></i>
                                            </a>
                                            @endif
                                        @endif
                                            <a href="{{ route('hectareMaster.view', ['id' => $hM->id]) }}" class="btn btn-secondary m-2">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        @if(isset($addRolePermission) && isset($addRolePermission) && $addRolePermission->edit == 1 || $userId == 1)
                                            <a href="{{ route('hectareMaster.edit', ['id' => $hM->id]) }}"
                                                class="btn btn-primary m-2">
                                                <i class="fa fa-pen"></i>
                                            </a>
                                        @endif
                                        @if(isset($addRolePermission) && isset($addRolePermission) && $addRolePermission->deleted == 1 || $userId == 1)
                                            <a class="btn btn-danger m-2" href="{{ route('hectareMaster.destroy', ['id' => $hM->id]) }}"
                                               onclick="return confirm('Are you sure you want to delete this item?');">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $hectareMaster->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

@endsection
