<?php
    use App\Models\User;
    use Illuminate\Support\Facades\Auth;
    $userId = Auth::user()->id;
    $user = User::find($userId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $user->role_id)->get();
     
    $dashboardPermission = $permissions->firstWhere('menu_id', 1);
    $dataPermission = $permissions->firstWhere('menu_id', 2);
    $anexuerOnePer = $permissions->firstWhere('menu_id', 3);
     
    $anexuerTwoPer = $permissions->firstWhere('menu_id', 4);
    $anexuerThreePer = $permissions->firstWhere('menu_id', 5);
    $anexuerFourPer = $permissions->firstWhere('menu_id', 6);
    $anexuerFivePer = $permissions->firstWhere('menu_id', 7);
    $anexuerSixPer = $permissions->firstWhere('menu_id', 8);
    $anexuerSevenPer = $permissions->firstWhere('menu_id', 9);
    $anexuerEightPer = $permissions->firstWhere('menu_id', 10);
    
    $anexuerNinePer = $permissions->firstWhere('menu_id', 22);
   
    $anexuerTenPer = $permissions->firstWhere('menu_id', 23);
    $anexuerElevenPer = $permissions->firstWhere('menu_id', 24);
    $anexuerTwPer = $permissions->firstWhere('menu_id', 25);
    $anexuerThirteenPer = $permissions->firstWhere('menu_id', 26);

    $reportPermission = $permissions->firstWhere('menu_id', 11);
    $reportListPer = $permissions->firstWhere('menu_id', 12);
    $aaPermission = $permissions->firstWhere('menu_id', 13);
    $aaaPermission = $permissions->firstWhere('menu_id', 14);
    $iabPermission = $permissions->firstWhere('menu_id', 15);
    
    $userPermission = $permissions->firstWhere('menu_id', 16);
    $rolesPermission = $permissions->firstWhere('menu_id', 19);
    $hectareMasterPermission = $permissions->firstWhere('menu_id', 20);
?>
<ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

    <!-- Sidebar - Brand -->
    <a class="sidebar-brand d-flex align-items-center justify-content-center" href="index.html">
        <div class="sidebar-brand-icon rotate-n-15">
            <i class="fas fa-university"></i>
        </div>
        <div class="sidebar-brand-text mx-3">Survey App</div>
    </a>

    <!-- Divider -->
    <hr class="sidebar-divider my-0">

    <!-- Nav Item - Dashboard -->
    @if(isset($dashboardPermission) && isset($dashboardPermission) && $dashboardPermission->view == 1 || $userId == 1)
    <li class="nav-item active">
        <a class="nav-link" href="{{ route('home') }}">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            <span>Dashboard</span></a>
    </li>
    @endif

    <!-- Divider -->
    <hr class="sidebar-divider">
    @if(isset($dataPermission) && isset($dataPermission) && $dataPermission->view == 1 || $userId == 1)
    <!-- Heading -->
    <div class="sidebar-heading">
        Report Data
    </div>
    
    <!-- Nav Item - Pages Collapse Menu -->
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#taTpDropDown"
            aria-expanded="true" aria-controls="taTpDropDown">
            <i class="fa fa-bar-chart"></i>
            <span>Value Chain Mapping </span>
        </a>
        <div id="taTpDropDown" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Anexure Data :</h6>
                
                
                
                @if(isset($anexuerOnePer) && isset($anexuerOnePer) && $anexuerOnePer->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('anexure.one') }}" style="word-wrap: break-word; white-space: normal;">Farm Input and Output (1A)</a>
                @endif
                
                @if(isset($anexuerTwoPer) && isset($anexuerTwoPer) && $anexuerTwoPer->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('anexure.two') }}" style="word-wrap: break-word; white-space: normal;">Infrastructure and Support Services (1B)</a>
                @endif
                
                @if(isset($anexuerThreePer) && isset($anexuerThreePer) && $anexuerThreePer->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('anexure.three') }}" style="word-wrap: break-word; white-space: normal;">CAP & Marketed Surplus (1C)</a>
                @endif
                
                @if(isset($anexuerFourPer) && isset($anexuerFourPer) && $anexuerFourPer->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('anexure.four') }}">Allied Agriculture (1D)</a>
                @endif
                
                @if(isset($anexuerFivePer) && isset($anexuerFivePer) && $anexuerFivePer->view == 1 || $userId == 1)
                <a class="collapse-item" href="{{ route('anexure.e') }}">Backward Linkages (1E)</a>
                @endif
                
                @if(isset($anexuerSixPer) && isset($anexuerSixPer) && $anexuerSixPer->view == 1 || $userId == 1)
                <a class="collapse-item" href="{{ route('anexure.f') }}">Forward Linkages (1F)</a>
                @endif
                
                @if(isset($anexuerSevenPer) && isset($anexuerSevenPer) && $anexuerSevenPer->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('anexure.six') }}">Anexure CAPHFARM III</a>
                @endif
                  
                @if(isset($anexuerEightPer) && isset($anexuerEightPer) && $anexuerEightPer->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('anexure.five') }}">Anexure Supplier II</a>
                @endif
                
               
                
                @if(isset($anexuerNinePer) && isset($anexuerNinePer) && $anexuerNinePer->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('anexure.seven') }}">Anexure TRDFARM IV</a>
                @endif
                
                @if(isset($anexuerTenPer) && isset($anexuerTenPer) && $anexuerTenPer->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('anexure.eight') }}">Anexure VAFARM V</a>
                @endif
                
                @if(isset($anexuerElevenPer) && isset($anexuerElevenPer) && $anexuerElevenPer->view == 1 || $userId == 1)
                <a class="collapse-item" href="{{ route('anexure.distributor') }}" style="word-wrap: break-word; white-space: normal;">Business Economics of Distributor/ Retailer </a>
                @endif
                
                @if(isset($anexuerTwPer) && isset($anexuerTwPer) && $anexuerTwPer->view == 1 || $userId == 1)
                <a class="collapse-item" href="{{ route('anexure.fpo_a') }}"> Resource Mapping of FPO </a>
                @endif
                
                @if(isset($anexuerThirteenPer) && isset($anexuerThirteenPer) && $anexuerThirteenPer->view == 1 || $userId == 1)
                <a class="collapse-item" href="{{ route('anexure.fpo_b') }}" style="word-wrap: break-word; white-space: normal;"> Capabilities Mapping of FPO </a>
                @endif
               
            </div>
        </div>
    </li>
    @endif
    <!-- Divider -->
    <hr class="sidebar-divider">
    
    
   
    @if(isset($reportPermission) && isset($reportPermission) && $reportPermission->view == 1 || $userId == 1)
    <!-- Heading -->
    <div class="sidebar-heading">
         Report
    </div>

    <!-- Nav Item - Pages Collapse Menu -->
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#taTpDropDown1"
            aria-expanded="true" aria-controls="taTpDropDown1">
            <i class="far fa-file-alt"></i>
            <span>Report</span>
        </a>
        <div id="taTpDropDown1" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Report List :</h6>
                @if(isset($reportListPer) && isset($reportListPer) && $reportListPer->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('report.report') }}">List</a>
                @endif
                @if(isset($aaPermission) && isset($aaPermission) && $aaPermission->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('report.aacombine_list') }}">AA Combine Format</a>
                @endif
                @if(isset($aaaPermission) && isset($aaaPermission) && $aaaPermission->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('report.aaacombine_list') }}">AAA Complition Format</a>
                @endif
                @if(isset($iabPermission) && isset($iabPermission) && $iabPermission->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('report.iabcombine_list') }}">IAB Complition Format</a>
                @endif
            </div>
        </div>
    </li>
    @endif
    <!-- Divider -->
    <hr class="sidebar-divider">
    
    @if(isset($userPermission) && isset($userPermission) && $userPermission->view == 1 || $userId == 1)
    <div class="sidebar-heading">
        Management
    </div>

    <!-- Nav Item - Pages Collapse Menu -->
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#taTpDropDown2"
            aria-expanded="true" aria-controls="taTpDropDown2">
            <i class="fas fa-user-alt"></i>
            <span>User Management</span>
        </a>
        <div id="taTpDropDown2" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">User Management:</h6>
                @if(isset($userPermission) && isset($userPermission) && $userPermission->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('users.index') }}">List</a>
                @endif
                @if(isset($userPermission) && isset($userPermission) && $userPermission->created == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('users.create') }}">Add New</a>
                @endif
                <a class="collapse-item" href="{{ route('users.import') }}">Import Data</a>
            </div>
        </div>
    </li>
    @endif
    
     <!-- Heading -->
    @if(isset($hectareMasterPermission) && isset($hectareMasterPermission) && $hectareMasterPermission->view == 1 || $userId == 1)
    <div class="sidebar-heading">
        Hectare Master
    </div>

    <!-- Nav Item - Pages Collapse Menu -->
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#hectareMasterDropDown"
            aria-expanded="true" aria-controls="hectareMasterDropDown">
            <i class="fas fa-user-alt"></i>
            <span>Hectare Master</span>
        </a>
        <div id="hectareMasterDropDown" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Hectare Master:</h6>
                @if(isset($hectareMasterPermission) && isset($hectareMasterPermission) && $hectareMasterPermission->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('hectareMaster.index') }}">List</a>
                @endif
                @if(isset($hectareMasterPermission) && isset($hectareMasterPermission) && $hectareMasterPermission->created == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('hectareMaster.create') }}">Add New</a>
                @endif
            </div>
        </div>
    </li>
    @endif
    
    <hr class="sidebar-divider">
    
    @if(isset($rolesPermission) && isset($rolesPermission) && $rolesPermission->view == 1 || $userId == 1)
    <div class="sidebar-heading">
        Roles
    </div>
    
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#taTpDropDownRole"
            aria-expanded="true" aria-controls="taTpDropDownRole">
            <i class="fas fa-user-alt"></i>
            <span>Role Management</span>
        </a>
        <div id="taTpDropDownRole" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Role Management:</h6>
                @if(isset($rolesPermission) && isset($rolesPermission) && $rolesPermission->view == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('roles.index') }}">List</a>
                @endif
                @if(isset($rolesPermission) && isset($rolesPermission) && $rolesPermission->created == 1 || $userId == 1)
                    <a class="collapse-item" href="{{ route('roles.create') }}">Add New</a>
                @endif
            </div>
        </div>
    </li>
    @endif
    <!-- Divider -->
    <hr class="sidebar-divider">


    <li class="nav-item">
        <a class="nav-link" href="#" data-toggle="modal" data-target="#logoutModal">
            <i class="fas fa-sign-out-alt"></i>
            <span>Logout</span>
        </a>
    </li>
    <!-- Sidebar Toggler (Sidebar) -->
    <div class="text-center d-none d-md-inline">
        <button class="rounded-circle border-0" id="sidebarToggle"></button>
    </div>


</ul>

