@extends('layouts.app')

@section('title', 'Dashboard')

 <style>
        .pagination {
    display: flex;
    list-style: none;
    padding: 0;
    justify-content: center;
}

.pagination li {
    margin: 0 5px;
}

.pagination li a,
.pagination li span {
    padding: 5px 10px;
    border: 1px solid #ccc;
    color: #333;
    text-decoration: none;
}

.pagination li.active a {
    background-color: #007bff;
    color: #fff;
}

.pagination li.disabled span {
    color: #aaa;
    cursor: not-allowed;
}

.pagination li.disabled a {
    pointer-events: none;
}
    </style>
@section('content')
 <div class="container-fluid">

        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Report</h1>
        </div>

        {{-- Alert Messages --}}
        @include('common.alert')

        <!-- DataTales Example -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">List</h6>

            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-4">
                        <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
                    </div>
                    <div class="col-lg-8">
                        <label for="month">Select Date Range:</label>
                        <form action="#" method="GET" onsubmit="return validateDates()">
                            <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                            <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                            <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                            <a href="{{ route('report.report') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                        </form>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <td>S.No.</td>
                                <td>Farmer ID</td>
                                <td>Farmer Name</td>
                                <td>Village</td>
                                <td>District</td>
                                <td>Mobile</td>
                                <td>Date</td>
                                <td>State</td>
                                <td>Year</td>
                                <td>Crop</td>
                                <td>Cultivator No.</td>
                                <td>Parcel Plot Season (PPS)</td>
                                <td>Crop Area (Ha.)</td>
                                <td>Ha-months in ground (Ha.)</td>
                                <td>Main Product (Qtls.)</td>
                                <td>Main Product (Rs.)</td>
                                <td>By Product (Rs.)</td>
                                <td>Family Labour (Hrs.)</td>
                                <td>Family Labour (Rs.)</td>
                                <td>Attached Labour (Hrs.)</td>
                                <td>Attached Labour (Rs.)</td>
                                <td>Casual Labour (Hrs.)</td>
                                <td>Casual Labour (Rs.)</td>
                                <td>Hired Animal Labour (Hrs.)</td>
                                <td>Hired Animal Labour (Rs.)</td>
                                <td>Owned Animal Labour (Hrs.)</td>
                                <td>Owned Animal Labour (Rs.)</td>
                                <td>Hired Machine (Hrs.)</td>
                                <td>Hired Machine (Rs.)</td>
                                <td>Own Machine (Hrs.)</td>
                                <td>Own Machine (Rs.)</td>
                                <td>Hired Irrigation Machine (Hrs.)</td>
                                <td>Hired Irrigation Machine (Rs.)</td>
                                <td>Owned Irrigation Machine (Hrs.)</td>
                                <td>Owned Irrigation Machine (Rs.)</td>
                                <td>Canal and Other Irrigation Charges (Rs)</td>
                                <td>Seed Qty. (Kg.)</td>
                                <td>Seed Value (Rs.)</td>
                                <td>Fertiliser (N) (Kg.)</td>
                                <td>Fertiliser (N) (Rs.)</td>
                                <td>Fertiliser (P) (Kg.)</td>
                                <td>Fertiliser (P) (Rs.)</td>
                                <td>Fertiliser (K) (Kg.)</td>
                                <td>Fertiliser (K) (Rs.)</td>
                                <td>Other Fertiliser (Kg.)</td>
                                <td>Other Fertiliser (Rs.)</td>
                                <td>Total Fertiliser (Kg.)</td>
                                <td>Total Fertiliser (Rs.)</td>
                                <td>Manure (Qtl.)</td>
                                <td>Manure (Rs.)</td>
                                <td>Insecticides (Rs.)</td>
                                <td>Crop Insurance (Rs.</td>
                                <td>Payment to Contractor (Rs.)</td>
                                <td>Miscelaneous Cost (Rs.)</td>
                                <td>Land Revenue (Rs.)</td>
                                <td>Rent Paid for Leased in Land (Rs.)</td>
                                <td>Imputed Rent (Rs.)</td>
                                <td>Total Depreciation (Rs.)</td>
                                <td>Total Capital (Rs.)</td>
                                <td>Total No. of Growers in size group</td>
                                <td>Sample Number of Growers in size group</td>
                                <td>Cluster Factor/Weight</td>
                                <td>Area of all selected crops in Village (Ha.)</td>
                                <td>No. of Villages in Tehsil</td>
                                <td>Area of Crop in Zone (Ha.)</td>
                                <td>Production of Crop in Zone (Qtl.)</td>
                                <td>No. of Tehsils in Zone</td>
                                <td>Sample Tehsils in Zone</td>
                                <td>Area of all selected crops in Zone (Ha.)</td>
                                <td>Interest on working capital rate(%)</td>
                                <td>Interest on fixed capital rate(%)</td>
                                <td>Minimum Rent (%age of GVO)</td>
                                <td>Maximum Rent (%age of GVO)</td>
                                <td>Sample Zone in State</td>
                                <td>Sample Clusters in State</td>
                                <td>Tenure</td>
                                <td>Seed Variety</td>
                            </tr>
                        </thead>
                        <tbody>
                           <?php $count = ($report_details->currentPage() - 1) * $report_details->perPage(); ?>

                            @foreach($report_details as $report_detail)
                                <tr>
                                    <td>{{ ++$count }}</td>
                                    <td>{{ $report_detail->farmer_id }}</td>
                                    <td>{{ $report_detail->farmer_name }}</td>
                                    <td>{{ $report_detail->village }}</td>
                                    <td>{{ $report_detail->district }}</td>
                                    <td>{{ $report_detail->mobile_number }}</td>
                                     <td>{{ $report_detail->cropsDate }}</td>
                                    <td>{{ $report_detail->state }}</td>
                                    <td>na</td>
                                    <td>{{ $report_detail->crop_name }}</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>{{$report_detail->sold_main_product}}</td>
                                    <td>{{$report_detail->total_main_product_sold}}</td>
                                    <td>{{$report_detail->by_product}}</td>
                                    
                                    <td>{{$report_detail->family_labour_hrs}}</td>
                                    <td>{{$report_detail->family_labour_rs}}</td>
                                    <td>{{$report_detail->attached_labour_hrs}}</td>
                                    <td>{{$report_detail->attached_labour_rs}}</td>
                                    <td>{{$report_detail->casual_labour_rs}}</td>
                                    <td>{{$report_detail->casual_labour_hrs}}</td>
                                     <td>{{$report_detail->hired_animal_labour_rs}}</td>
                                    <td>{{$report_detail->hired_animal_labour_hrs}}</td>
                                    <td>{{$report_detail->owned_animal_hrs}}</td>
                                    <td>{{$report_detail->owned_animal_rs}}</td>
                                     <td>{{$report_detail->hired_machhine_hrs}}</td>
                                    <td>{{$report_detail->hired_machhine_rs}}</td>
                                     <td>{{$report_detail->own_machine_rs}}</td>
                                    <td>{{$report_detail->own_machine_hrs}}</td>
                                     <td>{{$report_detail->hired_irrigation_machine_hrs}}</td>
                                    <td>{{$report_detail->hired_irrigation_machine_rs}}</td>
                                     <td>{{$report_detail->owned_animal_unit_price}}</td>
                                    <td>{{$report_detail->owned_animal_remarks}}</td>
                                    <td>{{$report_detail->other_irrigation_charges_hrs}}</td>
                                    <td>{{$report_detail->seed_qty}}</td>
                                    <td>{{$report_detail->seed_value_rs}}</td>
                                    <td>{{$report_detail->fertiliser_n_qty}}</td>
                                    <td>{{$report_detail->fertiliser_n_rs}}</td>
                                    <td>{{$report_detail->fertiliser_p_qty}}</td>
                                    <td>{{$report_detail->fertiliser_p_rs}}</td>
                                    <td>{{$report_detail->fertiliser_k_qty}}</td>
                                    <td>{{$report_detail->fertiliser_k_rs}}</td>
                                     <td>{{$report_detail->other_fertiliser_qty}}</td>
                                    <td>{{$report_detail->other_fertiliser_rs}}</td>
                                    <td>na</td>
                                    <td>na</td>
                                     <td>{{$report_detail->manure_qty}}</td>
                                    <td>{{$report_detail->manure_rs}}</td>
                                    <td>{{$report_detail->insecticide_rs}}</td>
                                    <td>{{$report_detail->crop_insurance_rs}}</td>
                                    <td>na</td>
                                    <td>{{$report_detail->miscelaneous_cost_rs}}</td>
                                    <td>{{$report_detail->land_revenue_rs}}</td>
                                    <td>{{$report_detail->rent_paid_leased_land}}</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                     <td>na</td>
                                     <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                     <td>na</td>
                                     <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    <td>na</td>
                                    
                                     <td>{{$report_detail->seed_variety}}</td>
                                     
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                      {{$report_details->links("pagination::bootstrap-4")}}
                  
                </div>
            </div>
        </div>

    </div>

@endsection