@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')
 <div class="container-fluid">

        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Report</h1>
        </div>

        {{-- Alert Messages --}}
        @include('common.alert')

        <!-- DataTales Example -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">List</h6>

            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-4">
                        <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
                    </div>
                    <!--<div class="col-lg-8">-->
                    <!--    <label for="month">Select Month:</label>-->
                    <!--    <select class="form-control w-25" style="display:inline;width:40%;" id="month" name="month">-->
                    <!--        <option value="" disabled selected>Select Month</option>-->
                    <!--        <option value="1" {{ Request::input('month') == 1 ? 'selected' : '' }}>January</option>-->
                    <!--        <option value="2" {{ Request::input('month') == 2 ? 'selected' : '' }}>February</option>-->
                    <!--        <option value="3" {{ Request::input('month') == 3 ? 'selected' : '' }}>March</option>-->
                    <!--        <option value="4" {{ Request::input('month') == 4 ? 'selected' : '' }}>April</option>-->
                    <!--        <option value="5" {{ Request::input('month') == 5 ? 'selected' : '' }}>May</option>-->
                    <!--        <option value="6" {{ Request::input('month') == 6 ? 'selected' : '' }}>June</option>-->
                    <!--        <option value="7" {{ Request::input('month') == 7 ? 'selected' : '' }}>July</option>-->
                    <!--        <option value="8" {{ Request::input('month') == 8 ? 'selected' : '' }}>August</option>-->
                    <!--        <option value="9" {{ Request::input('month') == 9 ? 'selected' : '' }}>September</option>-->
                    <!--        <option value="10" {{ Request::input('month') == 10 ? 'selected' : '' }}>October</option>-->
                    <!--        <option value="11" {{ Request::input('month') == 11 ? 'selected' : '' }}>November</option>-->
                    <!--        <option value="12" {{ Request::input('month') == 12 ? 'selected' : '' }}>December</option>-->
                    <!--    </select>-->
                        
                    <!--    <select class="form-control w-25" style="display:inline;width:20%;" id="year" name="year">-->
                    <!--        <option value="" disabled selected>Select Year</option>-->
                    <!--        @for ($y = date("Y"); $y >= 2010; $y--)-->
                    <!--            <option value="{{ $y }}" {{ Request::input('year') == $y ? 'selected' : '' }}>{{ $y }}</option>-->
                    <!--        @endfor-->
                    <!--    </select>-->
                    <!--    <button class="btn btn-primary btn-sm" data-url="{{ route('report.iabcombine_list') }}" id="filterBtn">Filter</button>-->
                    <!--    <a href="{{ route('report.iabcombine_list') }}" class="btn btn-primary btn-sm">Clear Filters</a>-->
                    <!--</div>-->
                    <div class="col-lg-8">
                        <label for="month">Select Date Range:</label>
                        <form action="#" method="GET" onsubmit="return validateDates()">
                            <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                            <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                            <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                            <a href="{{ route('report.iabcombine_list') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                        </form>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <td></td>
                                <td>
                                    <strong>Producers Sample Number</strong>
                                </td>
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{$i+1}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>A</td>
                                <td>Name of Farmer</td>
                                @foreach($data as $fname)
                                <td>{{isset($fname->name) && $fname->name ? $fname->name : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>B</td>
                                <td>S/O or W/O</td>
                                @foreach($data as $sf)
                                <td>{{isset($sf->son_of) && $sf->son_of ? $sf->son_of : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>C</td>
                                <td>Village</td>
                                @foreach($data as $v)
                                <td>{{isset($v->village) && $v->village ? $v->village : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>D</td>
                                <td>Block</td>
                                @foreach($data as $bl)
                                <td>{{isset($bl->block) && $bl->block ? $bl->block : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>E</td>
                                <td>District</td>
                                @foreach($data as $dis)
                                <td>{{isset($dis->district) && $dis->district ? $dis->district : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>F</td>
                                <td>Land Holding Size (BEEGHA)</td>
                                @foreach($data as $lhs)
                                <td>{{isset($lhs->land_holding_size) && $lhs->land_holding_size ? $lhs->land_holding_size : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>G</td>
                                <td>Land Holding taken Lease</td>
                                @foreach($data as $lhtl)
                                <td>{{isset($lhtl->land_holding_taken_lease) && $lhtl->land_holding_taken_lease ? $lhtl->land_holding_taken_lease : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>H</td>
                                <td>Total Cultivable Area (BEEGHA)</td>
                                @foreach($data as $tc)
                                <td>{{isset($tc->total_cultivable) && $tc->total_cultivable ? $tc->total_cultivable : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>I</td>
                                <td>Mobile Number</td>
                                @foreach($data as $mobNnum)
                                <td>{{isset($mobNnum->mobile_number) && $mobNnum->mobile_number ? $mobNnum->mobile_number : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>J</td>
                                <td>KCC LIMIT</td>
                                @foreach($data as $kccLim)
                                <td>{{isset($kccLim->kcc_limit) && $kccLim->kcc_limit ? $kccLim->kcc_limit : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>K</td>
                                <td>CROPPING PATTERN</td>
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"CROP " . ($i + 1)}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>1</td>
                                <td>Name of Crop</td>
                                @foreach($data as $cName)
                                <td>{{isset($cName->crop_name) && $cName->crop_name ? $cName->crop_name : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>2</td>
                                <td>Crop Area(BEEGHA)</td>
                                @foreach($data as $cArea)
                                <td>{{isset($cArea->crop_area) && $cArea->crop_area ? $cArea->crop_area : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>3</td>
                                <td>Irrigated Area</td>
                                @foreach($data as $irrArea)
                                <td>{{isset($irrArea->irrigated_area) && $irrArea->irrigated_area ? $irrArea->irrigated_area : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>L</td>
                                <td>CROP WISE COST OF CULTIVATION</td>
                                <!--@foreach($data as $fname)-->
                                <!--<td>{{isset($fname->name) && $fname->name ? $fname->name : ''}}</td>-->
                                <!--@endforeach-->
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"Acre"}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>1</td>
                                <td>Family Labour (Hrs.) / Madays</td>
                                @foreach($data as $flh)
                                <td>{{isset($flh->family_labour_hrs) && $flh->family_labour_hrs ? $flh->family_labour_hrs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>2</td>
                                <td>Family Labour (Rs.)</td>
                                @foreach($data as $flr)
                                <td>{{isset($flr->family_labour_rs) && $flr->family_labour_rs ? $flr->family_labour_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>3</td>
                                <td>Attached Labour (Hrs.)</td>
                                @foreach($data as $alh)
                                <td>{{isset($alh->attached_labour_hrs) && $alh->attached_labour_hrs ? $alh->attached_labour_hrs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>4</td>
                                <td>Attached Labour (Rs.)</td>
                                @foreach($data as $alr)
                                <td>{{isset($alr->attached_labour_rs) && $alr->attached_labour_rs ? $alr->attached_labour_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>5</td>
                                <td>Casual Labour (Hrs.)</td>
                                @foreach($data as $clh)
                                <td>{{isset($clh->casual_labour_hrs) && $clh->casual_labour_hrs ? $clh->casual_labour_hrs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>6</td>
                                <td>Casual Labour (Rs.)</td>
                                @foreach($data as $clr)
                                <td>{{isset($clr->casual_labour_rs) && $clr->casual_labour_rs ? $clr->casual_labour_rs : ''}}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <td>7</td>
                                <td>Hired Animal Labour (Hrs.)</td>
                                @foreach($data as $halh)
                                <td>{{isset($halh->hired_animal_labour_hrs) && $halh->hired_animal_labour_hrs ? $halh->hired_animal_labour_hrs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>8</td>
                                <td>Hired Animal Labour (Rs.)</td>
                                @foreach($data as $halr)
                                <td>{{isset($halr->hired_animal_labour_rs) && $halr->hired_animal_labour_rs ? $halr->hired_animal_labour_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>9</td>
                                <td>Owned Animal Labour (Hrs.)</td>
                                @foreach($data as $oah)
                                <td>{{isset($oah->owned_animal_hrs) && $oah->owned_animal_hrs ? $oah->owned_animal_hrs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>10</td>
                                <td>Owned Animal Labour (Rs.)</td>
                                @foreach($data as $oar)
                                <td>{{isset($oar->owned_animal_rs) && $oar->owned_animal_rs ? $oar->owned_animal_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>11</td>
                                <td>Hired Machine (Hrs.)</td>
                                @foreach($data as $hmh)
                                <td>{{isset($hmh->hired_machhine_hrs) && $hmh->hired_machhine_hrs ? $hmh->hired_machhine_hrs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>12</td>
                                <td>Hired Machine (Rs.)</td>
                                @foreach($data as $hmr)
                                <td>{{isset($hmr->hired_machhine_rs) && $hmr->hired_machhine_rs ? $hmr->hired_machhine_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>13</td>
                                <td>Own Machine (Hrs.)</td>
                                @foreach($data as $omh)
                                <td>{{isset($omh->own_machine_hrs) && $omh->own_machine_hrs ? $omh->own_machine_hrs : ''}}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <td>14</td>
                                <td>Own Machine (Rs.)</td>
                                @foreach($data as $hmr)
                                <td>{{isset($hmr->hired_machhine_rs) && $hmr->hired_machhine_rs ? $hmr->hired_machhine_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>15</td>
                                <td>Hired Irrigation Machine (Hrs.)</td>
                                @foreach($data as $himh)
                                <td>{{isset($himh->hired_irrigation_machine_hrs) && $himh->hired_irrigation_machine_hrs ? $himh->hired_irrigation_machine_hrs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>16</td>
                                <td>Hired Irrigation Machine (Rs.)</td>
                                @foreach($data as $himr)
                                <td>{{isset($himr->hired_irrigation_machine_rs) && $himr->hired_irrigation_machine_rs ? $himr->hired_irrigation_machine_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>17</td>
                                <td>Owned Irrigation Machine (Hrs.)</td>
                                @foreach($data as $oimh)
                                <td>{{isset($oimh->owned_irrigation_machine_hrs) && $oimh->owned_irrigation_machine_hrs ? $oimh->owned_irrigation_machine_hrs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>18</td>
                                <td>Owned Irrigation Machine (Rs.)</td>
                                @foreach($data as $oimr)
                                <td>{{isset($oimr->owned_irrigation_machine_rs) && $oimr->owned_irrigation_machine_rs ? $oimr->owned_irrigation_machine_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>19</td>
                                <td>Canal and Other Irrigation Charges (Rs)</td>
                                @foreach($data as $coc)
                                <td>{{isset($coc->canal_other_charges) && $coc->canal_other_charges ? $coc->canal_other_charges : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>20</td>
                                <td>Variety</td>
                                @foreach($data as $var)
                                <td>{{isset($var->variety) && $var->variety ? $var->variety : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>21</td>
                                <td>Seed Qty. (Kg.)</td>
                                @foreach($data as $seedQty)
                                <td>{{isset($seedQty->seed_qty) && $seedQty->seed_qty ? $seedQty->seed_qty : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>22</td>
                                <td>Seed Value (Rs.)</td>
                                @foreach($data as $svr)
                                <td>{{isset($svr->seed_value_rs) && $svr->seed_value_rs ? $svr->seed_value_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>23</td>
                                <td>Fertiliser (N) (Kg.)</td>
                                @foreach($data as $fnQty)
                                <td>{{isset($fnQty->fertiliser_n_qty) && $fnQty->fertiliser_n_qty ? $fnQty->fertiliser_n_qty : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>24</td>
                                <td>Fertiliser (N) (Rs.)</td>
                                @foreach($data as $fnRs)
                                <td>{{isset($fnRs->fertiliser_n_rs) && $fnRs->fertiliser_n_rs ? $fnRs->fertiliser_n_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>25</td>
                                <td>Fertiliser (P) (Kg.)</td>
                                @foreach($data as $fpQty)
                                <td>{{isset($fpQty->fertiliser_p_qty) && $fpQty->fertiliser_p_qty ? $fpQty->fertiliser_p_qty : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>26</td>
                                <td>Fertiliser (P) (Rs.)</td>
                                @foreach($data as $fpRs)
                                <td>{{isset($fpRs->fertiliser_p_rs) && $fpRs->fertiliser_p_rs ? $fpRs->fertiliser_p_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>27</td>
                                <td>Fertiliser (K) (Kg.)</td>
                                @foreach($data as $fkQty)
                                <td>{{isset($fkQty->fertiliser_k_qty) && $fkQty->fertiliser_k_qty ? $fkQty->fertiliser_k_qty : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>28</td>
                                <td>Fertiliser (K) (Rs.)</td>
                                @foreach($data as $fkRs)
                                <td>{{isset($fkRs->fertiliser_k_rs) && $fkRs->fertiliser_k_rs ? $fkRs->fertiliser_k_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>29</td>
                                <td>Other Fertiliser (Kg.)</td>
                                @foreach($data as $ofQty)
                                <td>{{isset($ofQty->other_fertiliser_qty) && $ofQty->other_fertiliser_qty ? $ofQty->other_fertiliser_qty : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>30</td>
                                <td>Other Fertiliser (Rs.)</td>
                                @foreach($data as $ofRs)
                                <td>{{isset($ofRs->other_fertiliser_rs) && $ofRs->other_fertiliser_rs ? $ofRs->other_fertiliser_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>31</td>
                                <td>DAP (Kg)</td>
                                @foreach($data as $dapKg)
                                <td>{{isset($dapKg->dap_kg) && $dapKg->dap_kg ? $dapKg->dap_kg : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>32</td>
                                <td>DAP (Rs)</td>
                                @foreach($data as $dapRs)
                                <td>{{isset($dapRs->dap_rs) && $dapRs->dap_rs ? $dapRs->dap_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>33</td>
                                <td>NPK (Kg)</td>
                                @foreach($data as $npkKg)
                                <td>{{isset($npkKg->npk_kg) && $npkKg->npk_kg ? $npkKg->npk_kg : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>34</td>
                                <td>NPK (Rs.)</td>
                                @foreach($data as $npkRs)
                                <td>{{isset($npkRs->npk_rs) && $npkRs->npk_rs ? $npkRs->npk_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>35</td>
                                <td>Manure (Qtl.) FYM</td>
                                @foreach($data as $mQtl)
                                <td>{{isset($mQtl->manure_qtl) && $mQtl->manure_qtl ? $mQtl->manure_qtl : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>36</td>
                                <td>Manure (Rs.) FYM</td>
                                @foreach($data as $mRs)
                                <td>{{isset($mRs->manure_rs) && $mRs->manure_rs ? $mRs->manure_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>37</td>
                                <td>Insecticides (Rs.)</td>
                                @foreach($data as $iRs)
                                <td>{{isset($iRs->insecticide_rs) && $iRs->insecticide_rs ? $iRs->insecticide_rs : ''}}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <td>38</td>
                                <td>Crop Insurance (Rs.)</td>
                                @foreach($data as $ciRs)
                                <td>{{isset($ciRs->crop_insurance_rs) && $ciRs->crop_insurance_rs ? $ciRs->crop_insurance_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>39</td>
                                <td>Miscelaneous Cost (Rs.)</td>
                                @foreach($data as $mcRs)
                                <td>{{isset($mcRs->miscelaneous_cost_rs) && $mcRs->miscelaneous_cost_rs ? $mcRs->miscelaneous_cost_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>40</td>
                                <td>Land Revenue (Rs.) LAGAN</td>
                                @foreach($data as $lrRs)
                                <td>{{isset($lrRs->land_revenue_rs) && $lrRs->land_revenue_rs ? $lrRs->land_revenue_rs : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>41</td>
                                <td>Rent Paid for Leased in Land (Rs.)</td>
                                @foreach($data as $rpll)
                                <td>{{isset($rpll->rent_paid_leased_land) && $rpll->rent_paid_leased_land ? $rpll->rent_paid_leased_land : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>42</td>
                                <td>Interest on working capital rate(%) KCC</td>
                                @foreach($data as $iKcc)
                                <td>{{isset($iKcc->interest_kcc) && $iKcc->interest_kcc ? $iKcc->interest_kcc : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>M</td>
                                <td>OUTPUT OF PRODUCTION & MARKETING CHANNEL</td>
                                <!-- @foreach($data as $fname)
                                <td>{{isset($fname->name) && $fname->name ? $fname->name : ''}}</td>
                                @endforeach -->
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"0"}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>1</td>
                                <td>Total Production (Qunital)</td>
                                @foreach($data as $tp)
                                <td>{{isset($tp->total_production) && $tp->total_production ? $tp->total_production : ''}}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <td>2</td>
                                <td>Sold Main Product (Qtls.)</td>
                                @foreach($data as $smp)
                                <td>{{isset($smp->sold_main_product) && $smp->sold_main_product ? $smp->sold_main_product : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>3</td>
                                <td>Selling Price of main products</td>
                                @foreach($data as $spmp)
                                <td>{{isset($spmp->selling_price_main_product) && $spmp->selling_price_main_product ? $spmp->selling_price_main_product : ''}}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <td>4</td>
                                <td>By Product (Rs.)</td>
                                @foreach($data as $bp)
                                <td>{{isset($bp->by_product) && $bp->by_product ? $bp->by_product : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>5</td>
                                <td>Selling  Price of By-products</td>
                                @foreach($data as $spbp)
                                <td>{{isset($spbp->selling_price_by_product) && $spbp->selling_price_by_product ? $spbp->selling_price_by_product : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>6</td>
                                <td>Whom to Sold ( Tick Mark)</td>
                                <!-- @foreach($data as $fname)
                                <td>{{isset($fname->name) && $fname->name ? $fname->name : ''}}</td>
                                @endforeach -->
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"0"}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>7</td>
                                <td>Village Trader</td>
                                @foreach($data as $vt)
                                <td>{{isset($vt->village_trader) && $vt->village_trader ? $vt->village_trader : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>8</td>
                                <td>Wholesaler</td>
                                @foreach($data as $ws)
                                <td>{{isset($ws->wholesaler) && $ws->wholesaler ? $ws->wholesaler : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>9</td>
                                <td>MANDI</td>
                                @foreach($data as $m)
                                <td>{{isset($m->mandi) && $m->mandi ? $m->mandi : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>10</td>
                                <td>Processor</td>
                                @foreach($data as $proc)
                                <td>{{isset($proc->processor) && $proc->processor ? $proc->processor : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>11</td>
                                <td>Retailer</td>
                                @foreach($data as $r)
                                <td>{{isset($r->retailer) && $r->retailer ? $r->retailer : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>12</td>
                                <td>Consumer</td>
                                @foreach($data as $c)
                                <td>{{isset($c->consumer) && $c->consumer ? $c->consumer : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>N</td>
                                <td>INFRASTRUCTURE</td>
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"0"}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>1</td>
                                <td>Irrigation Infrastructure</td>
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"0"}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>a</td>
                                <td>Canal</td>
                                @foreach($data as $can)
                                <td>{{isset($can->canal) && $can->canal ? $can->canal : ''}}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <td>b</td>
                                <td>Tubewell</td>
                                @foreach($data as $tub)
                                <td>{{isset($tub->tubewell) && $tub->tubewell ? $tub->tubewell : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>c</td>
                                <td>Enginer / Motor / Solar</td>
                                @foreach($data as $ems)
                                <td>{{isset($ems->enginer_motor_solar) && $ems->enginer_motor_solar ? $ems->enginer_motor_solar : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>d</td>
                                <td>Pump sets ( Diesel/ electric/ Solar)</td>
                                @foreach($data as $ps)
                                <td>{{isset($ps->pump_sets) && $ps->pump_sets ? $ps->pump_sets : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>e</td>
                                <td>Pond</td>
                                @foreach($data as $pnd)
                                <td>{{isset($pnd->pond) && $pnd->pond ? $pnd->pond : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>f</td>
                                <td>Sprinkler / drip irrigation System</td>
                                @foreach($data as $is)
                                <td>{{isset($is->irrigation_system) && $is->irrigation_system ? $is->irrigation_system : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>g</td>
                                <td>Pump House</td>
                                @foreach($data as $ph)
                                <td>{{isset($ph->pump_house) && $ph->pump_house ? $ph->pump_house : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>h</td>
                                <td>Other</td>
                                @foreach($data as $o)
                                <td>{{isset($o->other) && $o->other ? $o->other : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>2</td>
                                <td>Farm Mechanization</td>
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"0"}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>a</td>
                                <td>Tractor</td>
                                @foreach($data as $tr)
                                <td>{{isset($tr->tractor) && $tr->tractor ? $tr->tractor : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>b</td>
                                <td>Power Tiller</td>
                                @foreach($data as $pt)
                                <td>{{isset($pt->power_tiller) && $pt->power_tiller ? $pt->power_tiller : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>c</td>
                                <td>Cultivator</td>
                                @foreach($data as $cul)
                                <td>{{isset($cul->cultivator) && $cul->cultivator ? $cul->cultivator : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>d</td>
                                <td>Rotator</td>
                                @foreach($data as $rot)
                                <td>{{isset($rot->rotator) && $rot->rotator ? $rot->rotator : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>e</td>
                                <td>Harrow</td>
                                @foreach($data as $harr)
                                <td>{{isset($harr->harrow) && $harr->harrow ? $harr->harrow : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>f</td>
                                <td>Leveller</td>
                                @foreach($data as $level)
                                <td>{{isset($level->leveller) && $level->leveller ? $level->leveller : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>g</td>
                                <td>Plough (MB Plough / Disc Plough)</td>
                                @foreach($data as $plo)
                                <td>{{isset($plo->plough) && $plo->plough ? $plo->plough : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>h</td>
                                <td>Seed drill</td>
                                @foreach($data as $sd)
                                <td>{{isset($sd->speed_drill) && $sd->speed_drill ? $sd->speed_drill : ''}}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <td>i</td>
                                <td>Seed Planter</td>
                                @foreach($data as $spp)
                                <td>{{isset($spp->speed_planter) && $spp->speed_planter ? $spp->speed_planter : ''}}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <td>j</td>
                                <td>Seed cum fertilizer drill</td>
                                @foreach($data as $scfd)
                                <td>{{isset($scfd->speed_cum_fertilizer_drill) && $scfd->speed_cum_fertilizer_drill ? $scfd->speed_cum_fertilizer_drill : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>k</td>
                                <td>Trolley</td>
                                @foreach($data as $tr)
                                <td>{{isset($tr->trolley) && $tr->trolley ? $tr->trolley : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>l</td>
                                <td>Reaper cum binder</td>
                                @foreach($data as $rcb)
                                <td>{{isset($rcb->reaper_cum_binder) && $rcb->reaper_cum_binder ? $rcb->reaper_cum_binder : ''}}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <td>m</td>
                                <td>Bhusa Making Machine</td>
                                @foreach($data as $bm)
                                <td>{{isset($bm->bhusa_machine) && $bm->bhusa_machine ? $bm->bhusa_machine : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>n</td>
                                <td>Thresher</td>
                                @foreach($data as $ts)
                                <td>{{isset($ts->thresher) && $ts->thresher ? $ts->thresher : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>o</td>
                                <td>Combine Harvester</td>
                                @foreach($data as $ch)
                                <td>{{isset($ch->combine_harvester) && $ch->combine_harvester ? $ch->combine_harvester : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>p</td>
                                <td>Other</td>
                                @foreach($data as $fmo)
                                <td>{{isset($fmo->farm_mechanism_other) && $fmo->farm_mechanism_other ? $fmo->farm_mechanism_other : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>3</td>
                                <td>Storage Structure</td>
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"0"}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>a</td>
                                <td>Kothila / Deshi Stoarge Structure</td>
                                @foreach($data as $d)
                                <td>{{isset($d->deshi) && $d->deshi ? $d->deshi : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>b</td>
                                <td>Godown</td>
                                @foreach($data as $gd)
                                <td>{{isset($gd->godown) && $gd->godown ? $gd->godown : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>c</td>
                                <td>Clod Stoarge</td>
                                @foreach($data as $c)
                                <td>{{isset($c->clod) && $c->clod ? $c->clod : ''}}</td>
                                @endforeach
                            </tr>

                            <tr>
                                <td>d</td>
                                <td>Bulk Cooling Unit</td>
                                @foreach($data as $bc)
                                <td>{{isset($bc->bulk_cooling) && $bc->bulk_cooling ? $bc->bulk_cooling : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>e</td>
                                <td>Storage for fodder</td>
                                @foreach($data as $f)
                                <td>{{isset($f->fodder) && $f->fodder ? $f->fodder : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>4</td>
                                <td>Processing Infrstructure</td>
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"0"}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>a</td>
                                <td>Wheat Processing Unit</td>
                                @foreach($data as $wp)
                                <td>{{isset($wp->wheat_processing) && $wp->wheat_processing ? $wp->wheat_processing : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>b</td>
                                <td>Oil Processing Unit</td>
                                @foreach($data as $op)
                                <td>{{isset($op->oil_processing) && $op->oil_processing ? $op->oil_processing : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>c</td>
                                <td>Sugarcane Processing Unit</td>
                                @foreach($data as $sp)
                                <td>{{isset($sp->sugarcane_processing) && $sp->sugarcane_processing ? $sp->sugarcane_processing : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>d</td>
                                <td>Dal Processing Unit</td>
                                @foreach($data as $dp)
                                <td>{{isset($dp->dal_processing) && $dp->dal_processing ? $dp->dal_processing : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>e</td>
                                <td>Any Other Processing unit</td>
                                @foreach($data as $op)
                                <td>{{isset($op->other_processing) && $op->other_processing ? $op->other_processing : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>5</td>
                                <td>Retails outlet with producer</td>
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"0"}}</td>
                                @endfor
                            </tr>

                            <tr>
                                <td>a</td>
                                <td>Kiran Outlets</td>
                                @foreach($data as $ko)
                                <td>{{isset($ko->kiran_outlets) && $ko->kiran_outlets ? $ko->kiran_outlets : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>b</td>
                                <td>Grossary Outlets</td>
                                @foreach($data as $go)
                                <td>{{isset($go->grossary_outlets) && $go->grossary_outlets ? $go->grossary_outlets : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>c</td>
                                <td>Any Other Retail outlets</td>
                                @foreach($data as $oo)
                                <td>{{isset($oo->other_outlets) && $oo->other_outlets ? $oo->other_outlets : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>6</td>
                                <td>Other Infrastructure (Specify)</td>
                                @for($i = 0; $i < count($data); $i++)
                                <td>{{"0"}}</td>
                                @endfor
                            </tr>
                            <tr>
                                <td>a</td>
                                <td>Shed (Kuchha)</td>
                                @foreach($data as $sk)
                                <td>{{isset($sk->shed_kuchha) && $sk->shed_kuchha ? $sk->shed_kuchha : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>b</td>
                                <td>Shed (Pucca)</td>
                                @foreach($data as $sp)
                                <td>{{isset($sp->shed_pucca) && $sp->shed_pucca ? $sp->shed_pucca : ''}}</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td>c</td>
                                <td>Any other infrastructrure</td>
                                @foreach($data as $oi)
                                <td>{{isset($oi->other_infrastructure) && $oi->other_infrastructure ? $oi->other_infrastructure : ''}}</td>
                                @endforeach
                            </tr>

                        </thead>
                    </table>
                  
                </div>
            </div>
        </div>

    </div>

@endsection