@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')

    <div class="container-fluid">
        <div class="table-responsive">
            <div class="row">
                <div class="col-lg-4">
                    <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
                </div>
                <div class="col-lg-8">
                    <label for="month">Select Date Range:</label>
                    <form action="#" method="GET" onsubmit="return validateDates()">
                        <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                        <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                        <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                        <a href="{{ route('report.aacombine_list') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    </form>
                </div>
            </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">aa data</h1>
        </div>
           <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <tr>
                    <td rowspan="2">Sample No</td>
                    <td rowspan="2">Farmer Id</td>
                    <td rowspan="2">Season</td>
                    <td rowspan="2">Crop Name</td>
                    <td rowspan="2">Variety</td>
                    <td colspan="2">{{$lastThreeYears[0]}}-{{$lastThreeYears[1]}}</td>
                    <td colspan="2">{{$lastThreeYears[1]}}-{{$lastThreeYears[2]}} </td>
                    <td colspan="2">{{$lastThreeYears[2]}}-{{$lastThreeYears[3]}}</td>
                    <td rowspan="2">Average Quantum Sold</td>
                    <td rowspan="2">Average Price of Selling </td>
                    <td rowspan="2">Min Rate</td>
                    <td rowspan="2">Max Rate</td>
                </tr>
                <tr>
                    <td>
                        Area (beegha)
                    </td>
                    <td>
                        Production (Q)
                    </td>
                    <td>
                        Area (beegha)
                    </td>
                    <td>
                        Production (Q)
                    </td>
                    <td>
                        Area (beegha)
                    </td>
                    <td>
                        Production (Q)
                    </td>
                </tr>
                
                
                @foreach($data as $data)
                <tr>
                    <td>
                        {{$data->id}}
                    </td>
                    <td>
                        {{$data->farmer_id}}
                    </td>
                    <td>
                        {{$data->season}}
                    </td>
                    <td>
                        {{$data->crop_name}}
                    </td>
                    <td>
                        {{$data->variety}}
                    </td>
                      <td>
                        {{$data->first_year_area}}
                    </td>
                     <td>
                        {{$data->first_year_production}}
                    </td>
                     <td>
                        {{$data->second_year_area}}
                    </td>
                     <td>
                        {{$data->second_year_production}}
                    </td>
                     <td>
                        {{$data->third_year_area}}
                    </td>
                     <td>
                        {{$data->third_year_production}}
                    </td>
                     <td>
                        {{$data->average_quantum_sold}}
                    </td>
                     <td>
                        {{$data->average_price_selling}}
                    </td>
                    <td>
                        {{$data->min_rate}}
                    </td>
                    <td>
                        {{$data->max_rate}}
                    </td>
                </tr>
                @endforeach
            </table>
        </div>
    </div>
@endsection