<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>
@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

<div class="container-fluid">
     <div class="table-responsive">
         <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            @if($deshboard == 1)
        
            @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.fpo_a') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.six.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            @endif
        </div>
         <br>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Format VII-B: Capability Mapping of FPO value chain actor of concerned cluster</h1>
           
        </div>

        @if($data->isNotEmpty())    
        @php
            $si = 1;
        @endphp
        @foreach($data as $datas)
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Capabilities OF FPO</th>
            <th>Unit (Wherever Applicable)  </th>
            <th>Quantitative / Qualitative Indicator</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td style="font-weight:700;">{{$si++}}</td>
            <td>{{$datas->farmer_code_id}}</td>
              <td>{{$datas->first_name == 'null' ? '' : $datas->first_name.' '.$datas->last_name}}</td>
            <td style="font-weight:700;" colspan="4">Development Capabilities</td>
         </tr>   
         
         <tr>
             @php
             $potential = json_decode($datas->ability_to_formulate_strategies, true);
            @endphp 
            <td>a</td>
            <td></td>
            <td></td>
            <td>Ability to formulate Strategies</td>
            <td>{{ $potential['unit'] ?? '' }}</td>
           <td>{{ $potential['indicator'] ?? '' }}</td>
           <td>{{ $potential['remark'] ?? '' }}</td>
         </tr>
         
          <tr>
               @php
                $ability_to_innovate_process_method = json_decode($datas->ability_to_innovate_process_method, true);
                @endphp 
            <td>b</td>
             <td></td>
            <td></td>
            <td>Ability to innovate process / method</td>
            <td>{{ $ability_to_innovate_process_method['unit'] ?? '' }}</td>
            <td>{{ $ability_to_innovate_process_method['indicator'] ?? '' }}</td>
            <td>{{ $ability_to_innovate_process_method['remark'] ?? '' }}</td>
         </tr>  
         
          <tr>
              @php
                $ability_to_innovate_product_main = json_decode($datas->ability_to_innovate_product_main, true);
                @endphp
            <td>c</td>
             <td></td>
            <td></td>
            <td>Ability to innovate product (main)</td>
               <td>{{ $ability_to_innovate_product_main['unit'] ?? '' }}</td>
                <td>{{ $ability_to_innovate_product_main['indicator'] ?? '' }}</td>
                <td>{{ $ability_to_innovate_product_main['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
                @php
                $ability_to_innovate_technique = json_decode($datas->ability_to_innovate_technique, true);
                @endphp
            <td>d</td>
             <td></td>
            <td></td>
            <td >Ability to innovate technique</td>
            <td>{{ $ability_to_innovate_technique['unit'] ?? '' }}</td>
            <td>{{ $ability_to_innovate_technique['indicator'] ?? '' }}</td>
            <td>{{ $ability_to_innovate_technique['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
            <td></td>
             <td></td>
            <td></td>
            <td ></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        
         
           <tr>
            <td style="font-weight:700;">2</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;" colspan="4">Operational Capabilities</td>
          
         </tr> 
         
           <tr>
               @php
                $ability_to_reduce_processing_cost = json_decode($datas->ability_to_reduce_processing_cost, true);
                @endphp
            <td>a</td>
             <td></td>
            <td></td>
            <td>Ability to reduce processing cost</td>
            <td>{{ $ability_to_reduce_processing_cost['unit'] ?? '' }}</td>
            <td>{{ $ability_to_reduce_processing_cost['indicator'] ?? '' }}</td>
            <td>{{ $ability_to_reduce_processing_cost['remark'] ?? '' }}</td>
         </tr> 
          
         
         <tr>
              @php
            $ability_to_deliver_on_time = json_decode($datas->ability_to_deliver_on_time, true);
            @endphp
            <td>b</td>
             <td></td>
            <td></td>
            <td>Ability to deliver on time </td>
            <td>{{ $ability_to_deliver_on_time['unit'] ?? '' }}</td>
            <td>{{ $ability_to_deliver_on_time['indicator'] ?? '' }}</td>
            <td>{{ $ability_to_deliver_on_time['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $ability_to_extent_quality_product = json_decode($datas->ability_to_extent_quality_product, true);
                @endphp
            <td>c</td>
             <td></td>
            <td></td>
            <td >Ability to extent quality product</td>
           <td>{{ $ability_to_extent_quality_product['unit'] ?? '' }}</td>
            <td>{{ $ability_to_extent_quality_product['indicator'] ?? '' }}</td>
            <td>{{ $ability_to_extent_quality_product['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
            <td></td>
             <td></td>
            <td></td>
            <td ></td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">3</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;" colspan="4">Management Capabilities</td>
           
         </tr> 
         
         <tr>
              @php
                $participation = json_decode($datas->participation, true);
                @endphp
            <td>a</td>
             <td></td>
            <td></td>
            <td>Participation </td>
           <td>{{ $participation['unit'] ?? '' }}</td>
            <td>{{ $participation['indicator'] ?? '' }}</td>
            <td>{{ $participation['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
                $status_of_statutory_and_legal_compliance = json_decode($datas->status_of_statutory_and_legal_compliance, true);
                @endphp
            <td>b</td>
             <td></td>
            <td></td>
            <td>Status of statutory and legal Compliance</td>
            <td>{{ $status_of_statutory_and_legal_compliance['unit'] ?? '' }}</td>
            <td>{{ $status_of_statutory_and_legal_compliance['indicator'] ?? '' }}</td>
            <td>{{ $status_of_statutory_and_legal_compliance['remark'] ?? '' }}</td>
         </tr> 
         
          
         
         <tr>
             @php
            $consensus_oriented = json_decode($datas->consensus_oriented, true);
            @endphp
            <td>c</td>
             <td></td>
            <td></td>
            <td>Consensus Oriented</td>
           <td>{{ $consensus_oriented['unit'] ?? '' }}</td>
            <td>{{ $consensus_oriented['indicator'] ?? '' }}</td>
            <td>{{ $consensus_oriented['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
            $equity_and_inclusiveness = json_decode($datas->equity_and_inclusiveness, true);
            @endphp
            <td>d</td>
             <td></td>
            <td></td>
            <td>Equity and Inclusiveness</td>
           <td>{{ $equity_and_inclusiveness['unit'] ?? '' }}</td>
            <td>{{ $equity_and_inclusiveness['indicator'] ?? '' }}</td>
            <td>{{ $equity_and_inclusiveness['remark'] ?? '' }}</td>
         </tr> 
         
         
         
         
        <tr>
            @php
            $effectiveness_and_efficiency = json_decode($datas->effectiveness_and_efficiency, true);
            @endphp
            <td>e</td>
             <td></td>
            <td></td>
            <td>Effectiveness and Efficiency</td>
           <td>{{ $effectiveness_and_efficiency['unit'] ?? '' }}</td>
            <td>{{ $effectiveness_and_efficiency['indicator'] ?? '' }}</td>
            <td>{{ $effectiveness_and_efficiency['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $accountability = json_decode($datas->accountability, true);
                @endphp
            <td>f</td>
             <td></td>
            <td></td>
            <td>Accountability</td>
             <td>{{ $accountability['unit'] ?? '' }}</td>
            <td>{{ $accountability['indicator'] ?? '' }}</td>
            <td>{{ $accountability['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $transparency = json_decode($datas->transparency, true);
                @endphp
            <td>g</td>
             <td></td>
            <td></td>
            <td>Transparency</td>
            <td>{{ $transparency['unit'] ?? '' }}</td>
            <td>{{ $transparency['indicator'] ?? '' }}</td>
            <td>{{ $transparency['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
              @php
            $responsiveness = json_decode($datas->responsiveness, true);
            @endphp
            <td>i</td>
             <td></td>
            <td></td>
            <td>Responsiveness</td>
             <td>{{ $responsiveness['unit'] ?? '' }}</td>
            <td>{{ $responsiveness['indicator'] ?? '' }}</td>
            <td>{{ $responsiveness['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
              @php
                $awareness_about_calculative_risk_taking_capacity = json_decode($datas->awareness_about_calculative_risk_taking_capacity, true);
                @endphp
            <td>j</td>
             <td></td>
            <td></td>
            <td>Awareness about calculative risk-taking capacity </td>
            <td>{{ $awareness_about_calculative_risk_taking_capacity['unit'] ?? '' }}</td>
                <td>{{ $awareness_about_calculative_risk_taking_capacity['indicator'] ?? '' }}</td>
                <td>{{ $awareness_about_calculative_risk_taking_capacity['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
              @php
            $ability_take_decision_per_the_calculative_risk = json_decode($datas->ability_take_decision_per_the_calculative_risk, true);
            @endphp
            <td>k</td>
             <td></td>
            <td></td>
            <td>Ability to take decision as per the calculative risk</td>
              <td>{{ $ability_take_decision_per_the_calculative_risk['unit'] ?? '' }}</td>
            <td>{{ $ability_take_decision_per_the_calculative_risk['indicator'] ?? '' }}</td>
            <td>{{ $ability_take_decision_per_the_calculative_risk['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
            $ability_collaboration_with_other_vCAs = json_decode($datas->ability_collaboration_with_other_vCAs, true);
            @endphp
            <td>l</td>
             <td></td>
            <td></td>
            <td>Ability of collaboration with other VCAs</td>
            <td>{{ $ability_collaboration_with_other_vCAs['unit'] ?? '' }}</td>
    <td>{{ $ability_collaboration_with_other_vCAs['indicator'] ?? '' }}</td>
    <td>{{ $ability_collaboration_with_other_vCAs['remark'] ?? '' }}</td>
         </tr> 
         
        <tr>
            <td style="font-weight:700;">4</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;" colspan="4">Transaction Capabilities</td>
           
         </tr> 
         
          <tr>
              @php
            $ability_to_extend_cheaper_inputs = json_decode($datas->ability_to_extend_cheaper_inputs, true);
            @endphp
            <td>a</td>
             <td></td>
            <td></td>
            <td>Ability to extend cheaper inputs (Input Business) to producers </td>
            <td>{{ $ability_to_extend_cheaper_inputs['unit'] ?? '' }}</td>
            <td>{{ $ability_to_extend_cheaper_inputs['indicator'] ?? '' }}</td>
            <td>{{ $ability_to_extend_cheaper_inputs['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $ability_to_extend_premimus_price = json_decode($datas->ability_to_extend_premimus_price, true);
                @endphp
            <td>b</td>
             <td></td>
            <td></td>
            <td>Ability to extend premium price (Output Business) to producers</td>
             <td>{{ $ability_to_extend_premimus_price['unit'] ?? '' }}</td>
            <td>{{ $ability_to_extend_premimus_price['indicator'] ?? '' }}</td>
            <td>{{ $ability_to_extend_premimus_price['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
            $ability_to_reduce_marketing_cost = json_decode($datas->ability_to_reduce_marketing_cost, true);
            @endphp
            <td>c</td>
             <td></td>
            <td></td>
            <td>Ability to reduce marketing cost</td>
            <td>{{ $ability_to_reduce_marketing_cost['unit'] ?? '' }}</td>
            <td>{{ $ability_to_reduce_marketing_cost['indicator'] ?? '' }}</td>
            <td>{{ $ability_to_reduce_marketing_cost['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
                $ability_to_reduce_bargaining_cost = json_decode($datas->ability_to_reduce_bargaining_cost, true);
                @endphp
            <td>d</td>
             <td></td>
            <td></td>
            <td>Ability to reduce bargaining cost</td>
            <td>{{ $ability_to_reduce_bargaining_cost['unit'] ?? '' }}</td>
            <td>{{ $ability_to_reduce_bargaining_cost['indicator'] ?? '' }}</td>
            <td>{{ $ability_to_reduce_bargaining_cost['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
                $ability_to_reduce_delivering_cost = json_decode($datas->ability_to_reduce_delivering_cost, true);
                @endphp
            <td>e</td>
             <td></td>
            <td></td>
            <td>Ability to reduce delivering cost</td>
            <td>{{ $ability_to_reduce_delivering_cost['unit'] ?? '' }}</td>
            <td>{{ $ability_to_reduce_delivering_cost['indicator'] ?? '' }}</td>
            <td>{{ $ability_to_reduce_delivering_cost['remark'] ?? '' }}</td>
         </tr> 
         
        </tbody>
  </table>
         @endforeach
        @else
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Capabilities OF FPO</th>
            <th>Unit (Wherever Applicable)  </th>
            <th>Quantitative / Qualitative Indicator</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td style="font-weight:700;">1</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Development Capabilities</td>
            <td></td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Ability to formulate Strategies</td>
            <td></td>
            <td></td>
             <td></td>
         </tr>
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Ability to innovate process / method</td>
            <td></td>
            <td></td>
             <td></td>
         </tr>  
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Ability to innovate product (main)</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td>d</td>
             <td></td>
            <td></td>
            <td >Ability to innovate technique</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td></td>
             <td></td>
            <td></td>
            <td ></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        
         
           <tr>
            <td style="font-weight:700;">2</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Operational Capabilities</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
           <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Ability to reduce processing cost</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
          
         
         <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Ability to deliver on time </td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td >Ability to extent quality product</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         <tr>
            <td></td>
             <td></td>
            <td></td>
            <td ></td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">3</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Management Capabilities</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Participation </td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Status of statutory and legal Compliance</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          
         
         <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Consensus Oriented</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
          <tr>
            <td>d</td>
             <td></td>
            <td></td>
            <td>Equity and Inclusiveness</td>
            <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         
         
         
        <tr>
            <td>e</td>
             <td></td>
            <td></td>
            <td>Effectiveness and Efficiency</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>f</td>
             <td></td>
            <td></td>
            <td>Accountability</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>g</td>
             <td></td>
            <td></td>
            <td>Transparency</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>i</td>
             <td></td>
            <td></td>
            <td>Responsiveness</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>j</td>
             <td></td>
            <td></td>
            <td>Awareness about calculative risk-taking capacity </td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>k</td>
             <td></td>
            <td></td>
            <td>Ability to take decision as per the calculative risk</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>l</td>
             <td></td>
            <td></td>
            <td>Ability of collaboration with other VCAs</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td style="font-weight:700;">4</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Transaction Capabilities</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Ability to extend cheaper inputs (Input Business) to producers </td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Ability to extend premium price (Output Business) to producers</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Ability to reduce marketing cost</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>d</td>
             <td></td>
            <td></td>
            <td>Ability to reduce bargaining cost</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>e</td>
             <td></td>
            <td></td>
            <td>Ability to reduce delivering cost</td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        </tbody>
  </table>
         @endif

    </div>
    
</div>

    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>

@endsection