
@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            @if($deshboard == 1)
        
                @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.two') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.two.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            @endif
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800" style="margin-left: 10px;">Infrastructure and Support Services</h1>
            </div>
           
        @if($data->isNotEmpty())      
        @foreach($data as $datas)
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
            <tr>
                <th style="text-align:center;">
                 S. No.
                </th>
                 <th>FARMER CODE</th>
                 <th>Farmer Name</th>
                <th>
                   Infrastructure and Support Services
                </th>
                
                <th>
                   YES/No
                </th>
                
                <th>
                    Number
                </th>
                
                <th>
                    Specification
                </th>
                
                <th>
                    Specification Unit
                </th>
                
                <th>
                  Year of Asset creation (DD/MM/YY)
                </th>
                
                <th>
                    Total Investment/ Cost (Rs.)
                </th>
                
                <th>
                    Subsidy / Grant (Rs.)
                </th>
                
                <th>
                    Bank Loan Cost (Rs.)
                </th>
                
                  <th>
                    Balance Source of Investment (Rs.)
                </th>
                
                  <th>
                   Economic / Useful  Life (Year)
                </th>
                
                  <th>
                    Residual Value of Asset (Rs.)
                </th>
                
                  <th>
                    Annual Interest on Bank Loan(Rs.)
                </th>
                
                  <th>
                    Annual Depreciation (Rs.)
                </th>
                
                  <th>
                    Annual Insurance (Rs.)
                </th>
                
                  <th>
                    Annual Tax (Rs.)
                </th>
                
               
                
                  <th>
                    Annual Repair and Maintenance (Rs.)
                </th>
                
                  <th>
                    Annual Fixed cost of Asset (Rs.)
                </th>
                
                  <th>
                    Rental Unit of Farm Asset in Cluster Area ( per hour/ per unit area per day / month / year ) 
                </th>
                
                <th>
                    Rental Rate of Farm Asset in Cluster Area (Rs.) 
                </th>

                  <th>
                    Any Other
                </th>
                
            </tr>
        
            
            <tr>
                <td style="text-align:center;">
                    1
                </td>
                
            
                <td>
                   {{$datas->farmer_code_id}} 
                </td>
             
               
                <td>
                {{$datas->first_name == 'null' ? '' : $datas->first_name.' '.$datas->last_name}}
                </td>
                

                <td style="font-weight:700;">
                    Irrigation Infrastructure
                </td>
                
                <td>0 for no 1 for yes</td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                    
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                </td>
                <td></td>
                 
                <td></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>

                
                <td>
                  
                </td>
                
                
                
                <td>
                   
                </td>
                
                <td>
                    Canal
                </td>
                
                <td></td>
                
                @php
                    $canalData = json_decode($datas->canal, true);
                @endphp
               <td>
                    {{ $canalData['number'] ?? '' }}
               </td>

                
               <td>
                    {{ $canalData['specification'] ?? '' }}
               </td>
               
                <td> {{ $canalData['specification_unit'] ?? '' }}</td>   

                <td>
                    {{ $canalData['year_of_asset_creation'] ?? '' }}
                </td>
                
                 <td>
                   {{ $canalData['total_investment_cost'] ?? '' }}
                </td>
                
                 <td>
                     {{ $canalData['subsidy_grant'] ?? '' }}
                </td>
                
                @php
                    $canbankLonCost = ($canalData['total_investment_cost'] ?? 0) - ($canalData['subsidy_grant'] ?? 0);
                    $Canbla_sou = $canbankLonCost - ($canalData['balance_source_of_investment'] ?? 0);
                @endphp
                
                 <td>
                     @if($Canbla_sou != 0)
                        {{ $Canbla_sou }}
                     @endif
                </td>
                
                 <td>
                   {{ $canalData['balance_source_of_investment'] ?? '' }}
                </td>
                
                <td>
                    {{ $canalData['economic_useful_life'] ?? '' }}
                </td>
                
                @php
                    $canresitent = ($canalData['total_investment_cost'] ?? 0) * 0.10;
                @endphp
                
                <td>
                     @if($canresitent != 0)
                        {{ $canresitent }}
                     @endif
                </td>
                
                 @php
                   $cananu = $Canbla_sou/2*12/100;
                 @endphp
                <td>
                    @if($cananu != 0)
                        {{ $cananu }}
                     @endif
                </td>
                
                @php
                    $cananul_dep = ($canalData['total_investment_cost'] ?? 0) / ($canalData['economic_useful_life'] ?? 1);
                @endphp
                <td>
                    @if($cananul_dep != 0)
                        {{ number_format($cananul_dep, 2) }}
                    @endif
                </td>

                
               
                
                 <td>
                   {{ $canalData['annual_insurance'] ?? '' }}
                </td>
                
                <td>
                   {{ $canalData['annual_tax'] ?? '' }}
                </td>
                
                 <td>
                    {{ $canalData['annual_repair_and_maintenance'] ?? '' }}
                </td>
                
                @php
                    $cananul_dep = ($canalData['total_investment_cost'] ?? 0) / ($canalData['economic_useful_life'] ?? 1);
                    $cananualfixdCost = $cananul_dep
                    + ($canalData['annual_insurance'] ?? 0)
                    + ($canalData['annual_tax'] ?? 0)
                    + ($canalData['annual_repair_and_maintenance'] ?? 0);
                    
                @endphp
                 <td>
                     @if($cananualfixdCost != 0)
                        {{ number_format($cananualfixdCost, 2) }}
                     @endif
                </td>
                  <td>
                    {{ $canalData['rental_unit'] ?? '' }}
                </td>
              <td> {{ $canalData['rental_rate'] ?? '' }}</td>
                 
                <td>{{ $canalData['any_other'] ?? '' }}</td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    b
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                
                <td>
                    Tubewell
                </td>
                
                <td></td>
                
                @php
                    $tubewellData = json_decode($datas->tubewell, true);
                @endphp
               <td>
                   {{ $tubewellData['number'] ?? '' }}
               </td>

                
               <td>
                    {{ $tubewellData['specification'] ?? '' }}
               </td>
               
                <td>
                    {{ $tubewellData['specification_unit'] ?? '' }}
               </td>
               

                  <td>
                    {{ $tubewellData['year_of_asset_creation'] ?? '' }}
                </td>
                
                 <td>
                   {{ $tubewellData['total_investment_cost'] ?? '' }}
                </td>
                
                 <td>
                     {{ $tubewellData['subsidy_grant'] ?? '' }}
                </td>
                
                 @php
                    $tubebankLonCost = ($tubewellData['total_investment_cost'] ?? 0) - ($tubewellData['subsidy_grant'] ?? 0);
                    $tubebla_sou = $tubebankLonCost - ($tubewellData['balance_source_of_investment'] ?? 0);
                 @endphp
                
                 <td>
                     @if($tubebla_sou != 0)
                        {{ $tubebla_sou }}
                     @endif
                </td>
                
                 <td>
                   {{ $tubewellData['balance_source_of_investment'] ?? '' }}
                </td>
                
                <td>
                    {{ $tubewellData['economic_useful_life'] ?? '' }}
                </td>
                
                @php
                $tuberesitent = ($tubewellData['total_investment_cost'] ?? 0) * 0.10;
                @endphp
                
                 <td>
                      @if($tuberesitent != 0)
                        {{ $tuberesitent }}
                     @endif
                </td>
                
                @php
                    $tubeanu = $tubebla_sou/2*12/100;
                @endphp
                
                <td>
                     @if($tubeanu != 0)
                        {{ $tubeanu }}
                     @endif
                </td>
                
                @php
                 $tubeanul_dep = ($tubewellData['total_investment_cost'] ?? 0) / ($tubewellData['economic_useful_life'] ?? 1);
                @endphp
                
                 <td>
                    
                      @if($tubeanul_dep != 0)
                        {{ number_format($tubeanul_dep, 2) }}
                     @endif
                  
                </td>
                
                 <td>
                   {{ $tubewellData['annual_insurance'] ?? '' }}
                </td>
                
                <td>
                   {{ $tubewellData['annual_tax'] ?? '' }}
                </td>
                
                
                
                 <td>
                   {{ $tubewellData['annual_repair_and_maintenance'] ?? '' }}
                </td>
                
                @php
                $tubeanul_dep = ($tubewellData['total_investment_cost'] ?? 0) / ($tubewellData['economic_useful_life'] ?? 1);
                $tubeanualfixdCost = $tubeanul_dep
                + ($tubewellData['annual_insurance'] ?? 0)
                + ($tubewellData['annual_tax'] ?? 0)
                + ($tubewellData['annual_repair_and_maintenance'] ?? 0);
                @endphp
                
                 <td>
                     @if($tubeanualfixdCost != 0)
                        {{ $tubeanualfixdCost }}
                     @endif
                </td>
                
                  <td>
                    {{ $tubewellData['rental_unit'] ?? '' }}
                </td>
                
              <td> {{ $tubewellData['rental_rate'] ?? '' }}</td>  
              
                <td>{{ $tubewellData['any_other'] ?? '' }}</td>
            </tr>

             <tr>
                <td style="text-align:center;">
                    c
                </td>

                <td>
                  
                </td>
                
                <td>
                   
                </td>
                
                <td>
                    Engine / Motor / Solar
                </td>
                
                <td></td>
                
                @php
                    $moterData = json_decode($datas->enginer_motor_solar, true);
                @endphp
               <td>
                    {{ $moterData['number'] ?? '' }}
               </td>

               <td>
                    {{ $moterData['specification'] ?? '' }}
               </td>
               
                <td>
                    {{ $moterData['specification_unit'] ?? '' }}
               </td>   

                  <td>
                    {{ $moterData['year_of_asset_creation'] ?? '' }}
                </td>
                
                 <td>
                   {{ $moterData['total_investment_cost'] ?? '' }}
                </td>
                
                 <td>
                     {{ $moterData['subsidy_grant'] ?? '' }}
                </td>
                
                 @php
                  $moterbankLonCost = ($moterData['total_investment_cost'] ?? 0) - ($moterData['subsidy_grant'] ?? 0);
                  $moterbla_sou = $moterbankLonCost - ($moterData['balance_source_of_investment'] ?? 0);
                @endphp
                
                <td>
                     @if($moterbla_sou != 0)
                      {{ $moterbla_sou }}
                     @endif
                </td>
                
                 <td>
                   {{ $moterData['balance_source_of_investment'] ?? '' }}
                </td>
                
                <td>
                    {{ $moterData['economic_useful_life'] ?? '' }}
                </td>
                
                @php
                $moterresitent = ($moterData['total_investment_cost'] ?? 0) * 0.10;
                @endphp
                
                 <td>
                  @if($moterresitent != 0)
                    {{ $moterresitent }}
                  @endif
                </td>
                
                 @php
                  $moteranu = $moterbla_sou/2*12/100;
                 @endphp
                
                <td>
                    @if($moteranu != 0)
                    {{ $moteranu }}
                    @endif
                </td>
                
                   @php
                    $moteranul_dep = ($moterData['total_investment_cost'] ?? 0) / ($moterData['economic_useful_life'] ?? 1);
                   @endphp
                
                 <td>
                    @if($moteranul_dep != 0)
                    {{ number_format($moteranul_dep, 2) }}
                    @endif
                </td>
                
                 <td>
                   {{ $moterData['annual_insurance'] ?? '' }}
                </td>
                
                <td>
                   {{ $moterData['annual_tax'] ?? '' }}
                </td>
                
                 <td>
                   {{ $moterData['annual_repair_and_maintenance'] ?? '' }}
                </td>
                
                @php
                $moteranul_dep = ($moterData['total_investment_cost'] ?? 0) / ($moterData['economic_useful_life'] ?? 1);
                $moteranualfixdCost = $moteranul_dep
                + ($moterData['annual_insurance'] ?? 0)
                + ($moterData['annual_tax'] ?? 0)
                + ($moterData['annual_repair_and_maintenance'] ?? 0);
                 $moteranualfixdCostFormatted = number_format($moteranualfixdCost, 2);
                @endphp
                
                <td>
                     @if($moteranualfixdCostFormatted != 0)
                    {{ $moteranualfixdCostFormatted }}
                    @endif
                </td> 
                
                <td>
                    {{ $moterData['rental_unit'] ?? '' }}
                </td> 
                
                 <td>
                   {{ $moterData['rental_rate'] ?? '' }}
                </td>
                
                <td>{{ $moterData['any_other'] ?? '' }}</td>
            </tr>
            
 <tr>
    <td style="text-align:center;">
        d
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
        Pump sets ( Diesel/ electric/ Solar)
    </td>
    
    <td></td>

    @php
    $pumpsetData = json_decode($datas->pump_sets, true);
    @endphp
    <td>
        {{ $pumpsetData['number'] ?? '' }}
    </td>


    <td>
        {{ $pumpsetData['specification'] ?? '' }}
    </td>
    
    <td>
        {{ $pumpsetData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $pumpsetData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $pumpsetData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $pumpsetData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
        $pumpbankLonCost = ($pumpsetData['total_investment_cost'] ?? 0) - ($pumpsetData['subsidy_grant'] ?? 0);
        $pumpbla_sou = $pumpbankLonCost - ($pumpsetData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($pumpbla_sou != 0)
        {{ $pumpbla_sou }}
        @endif
    </td>

    <td>
        {{ $pumpsetData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $pumpsetData['economic_useful_life'] ?? '' }}
    </td>

    @php
        $pumpresitent = ($pumpsetData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    <td>
        @if($pumpresitent != 0)
        {{ $pumpresitent ?? '' }}
        @endif
    </td>
    
    @php
       $punpanu = $pumpbla_sou/2*12/100;
    @endphp

    <td>
         @if($punpanu != 0)
        {{ $punpanu ?? '' }}
        @endif
    </td>
    
    @php
    $pumpanul_dep = ($pumpsetData['total_investment_cost'] ?? 0) / ($pumpsetData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($pumpanul_dep != 0)
        {{ $pumpanul_dep ?? '' }}
        @endif
    </td>

    <td>
        {{ $pumpsetData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $pumpsetData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $pumpsetData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
        $anul_deppump = ($pumpsetData['total_investment_cost'] ?? 0) / ($pumpsetData['economic_useful_life'] ?? 1);
       
        $pumpanualfixdCost = $anul_deppump 
                         + ($pumpsetData['annual_insurance'] ?? 0) 
                         + ($pumpsetData['annual_tax'] ?? 0) 
                         + ($pumpsetData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($pumpanualfixdCost != 0)
        {{ $pumpanualfixdCost ?? '' }}
        @endif
    </td>
    
    <td>{{ $pumpsetData['rental_unit'] ?? '' }}</td>
    <td>{{ $pumpsetData['rental_rate'] ?? '' }}</td>
     
    <td>{{ $pumpsetData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        e
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
        Pond
    </td>
    
    <td></td>

    @php
    $pondData = json_decode($datas->pond, true);
    @endphp
    <td>
        {{ $pondData['number'] ?? '' }}
    </td>


    <td>
        {{ $pondData['specification'] ?? '' }}
    </td>
    
    <td>
        {{ $pondData['specification_unit'] ?? '' }}
    </td>
    

    <td>
        {{ $pondData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $pondData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $pondData['subsidy_grant'] ?? '' }}
    </td>
    
     @php
      $pondbankLonCost = ($pondData['total_investment_cost'] ?? 0) - ($pondData['subsidy_grant'] ?? 0);
      $pondbla_sou = $pondbankLonCost - ($pondData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($pondbla_sou != 0)
        {{ $pondbla_sou }}
        @endif
    </td>

    <td>
        {{ $pondData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $pondData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $pondresitent = ($pondData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($pondresitent != 0)
        {{ $pondresitent }}
        @endif
    </td>
    
    @php
    $pondanu = $pondbla_sou/2*12/100;
    @endphp

    <td>
        @if($pondanu != 0)
        {{ $pondanu }}
        @endif
    </td>
    
    @php
    $pondanul_dep = ($pondData['total_investment_cost'] ?? 0) / ($pondData['economic_useful_life'] ?? 1);
    $formatted_pondanul_dep = number_format($pondanul_dep, 2);
    @endphp

    <td>
        @if($formatted_pondanul_dep != 0)
        {{ $formatted_pondanul_dep }}
        @endif
    </td>

    <td>
        {{ $pondData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $pondData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $pondData['annual_repair_and_maintenance'] ?? '' }}
    </td>

    @php
    $pondanul_dep = ($pondData['total_investment_cost'] ?? 0) / ($pondData['economic_useful_life'] ?? 1);
    $pondanualfixdCost = $pondanul_dep
    + ($pondData['annual_insurance'] ?? 0)
    + ($pondData['annual_tax'] ?? 0)
    + ($pondData['annual_repair_and_maintenance'] ?? 0);
    @endphp
    
    <td>
        @if($pondanualfixdCost != 0)
        {{ $pondanualfixdCost }}
        @endif
    </td>
    
    <td>
        {{ $pondData['rental_unit'] ?? '' }}
    </td>
    
    <td>{{ $pondData['rental_rate'] ?? '' }}</td>
    <td>{{ $pondData['any_other'] ?? '' }}</td>
</tr>
            
<tr>
    <td style="text-align:center;">
        f
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Sprinkler / drip irrigation System
    </td>
    
    <td></td>

    @php
    $irrigation_systemData = json_decode($datas->irrigation_system, true);
    @endphp
    <td>
        {{ $irrigation_systemData['number'] ?? '' }}
    </td>


    <td>
        {{ $irrigation_systemData['specification'] ?? '' }}
    </td>
    
    <td>
        {{ $irrigation_systemData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_systemData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_systemData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_systemData['subsidy_grant'] ?? '' }}
    </td>

    @php
    $irrigabankLonCost = ($irrigation_systemData['total_investment_cost'] ?? 0) - ($irrigation_systemData['subsidy_grant'] ?? 0);
    $irrgabla_sou = $irrigabankLonCost - ($irrigation_systemData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($irrgabla_sou != 0)
        {{ $irrgabla_sou }}
        @endif
    </td>

    <td>
        {{ $irrigation_systemData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_systemData['economic_useful_life'] ?? '' }}
    </td>
    @php
    $iggresitent = ($irrigation_systemData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    <td>
        @if($iggresitent != 0)
        {{ $iggresitent }}
        @endif
    </td>
    
    @php
    $igganu = $irrgabla_sou/2*12/100;
    @endphp


    <td>
        @if($igganu != 0)
        {{ $igganu }}
        @endif
    </td>
    
    @php
    $iggaanul_dep = ($irrigation_systemData['total_investment_cost'] ?? 0) / ($irrigation_systemData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($iggaanul_dep != 0)
        {{ $iggaanul_dep }}
        @endif
    </td>

    <td>
        {{ $irrigation_systemData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_systemData['annual_tax'] ?? '' }}
    </td>


    <td>
        {{ $irrigation_systemData['annual_repair_and_maintenance'] ?? '' }}
    </td>

    @php
    $iggaanul_dep = ($irrigation_systemData['total_investment_cost'] ?? 0) / ($irrigation_systemData['economic_useful_life'] ?? 1);
    $iggaanualfixdCost = $iggaanul_dep
    + ($irrigation_systemData['annual_insurance'] ?? 0)
    + ($irrigation_systemData['annual_tax'] ?? 0)
    + ($irrigation_systemData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($iggaanualfixdCost != 0)
        {{ $iggaanualfixdCost }}
        @endif
    </td>
    
    <td>
         {{ $irrigation_systemData['rental_unit'] ?? '' }}
    </td>
    
    <td>{{ $irrigation_systemData['rental_rate'] ?? '' }}</td>
    
    <td>{{ $irrigation_systemData['any_other'] ?? '' }}</td>
</tr>
            
    <tr>
    <td style="text-align:center;">
        g
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Pump House
    </td>
    
    <td></td>

    @php
    $pump_houseData = json_decode($datas->pump_house, true);
    @endphp
    <td>
        {{ $pump_houseData['number'] ?? '' }}
    </td>


    <td>
        {{ $pump_houseData['specification'] ?? '' }}
    </td>
    
    <td>
        {{ $pump_houseData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $pump_houseData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $pump_houseData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $pump_houseData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $pumpbankLonCost = ($pump_houseData['total_investment_cost'] ?? 0) - ($pump_houseData['subsidy_grant'] ?? 0);
    $pumpbla_sou = $pumpbankLonCost - ($pump_houseData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($pumpbla_sou != 0)
        {{ $pumpbla_sou }}
        @endif
    </td>

    <td>
        {{ $pump_houseData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $pump_houseData['economic_useful_life'] ?? '' }}
    </td>

    @php
    $resitent = ($pump_houseData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    
    <td>
        @if($resitent != 0)
        {{ $resitent }}
        @endif
    </td>

    @php
    $bankanu = $pumpbla_sou/2*12/100;
    @endphp

    <td>
         @if($bankanu != 0)
        {{ $bankanu }}
        @endif
    </td>

    @php
    $pumpanul_dep = ($pump_houseData['total_investment_cost'] ?? 0) / ($pump_houseData['economic_useful_life'] ?? 1);
    @endphp
    <td>
        @if($pumpanul_dep != 0)
        {{ $pumpanul_dep }}
        @endif
    </td>

    <td>
        {{ $pump_houseData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $pump_houseData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $pump_houseData['annual_repair_and_maintenance'] ?? '' }}
    </td>

    @php
    $pumpanul_dep = ($pump_houseData['total_investment_cost'] ?? 0) / ($pump_houseData['economic_useful_life'] ?? 1);
    $pumpanualfixdCost = $pumpanul_dep
    + ($pump_houseData['annual_insurance'] ?? 0)
    + ($pump_houseData['annual_tax'] ?? 0)
    + ($pump_houseData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($pumpanualfixdCost != 0)
        {{ $pumpanualfixdCost }}
        @endif
    </td>
    
    <td>
        {{ $pump_houseData['rental_unit'] ?? '' }}
    </td>
      
    <td>{{ $pump_houseData['rental_rate'] ?? '' }}</td>
    <td>{{ $pump_houseData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        h
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Other
    </td>
    
    <td></td>

    @php
    $irrigation_infrastructures_otherData = json_decode($datas->irrigation_infrastructures_other, true);
    @endphp
    <td>
        {{ $irrigation_infrastructures_otherData['number'] ?? '' }}
    </td>


    <td>
        {{ $irrigation_infrastructures_otherData['specification'] ?? '' }}
    </td>
    
      <td>
        {{ $irrigation_infrastructures_otherData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_infrastructures_otherData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_infrastructures_otherData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_infrastructures_otherData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $igbankLonCost = ($irrigation_infrastructures_otherData['total_investment_cost'] ?? 0) - ($irrigation_infrastructures_otherData['subsidy_grant'] ?? 0);
    $igbla_sou = $igbankLonCost - ($irrigation_infrastructures_otherData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
         @if($igbla_sou != 0)
        {{ $igbla_sou }}
        @endif
    </td>

    <td>
        {{ $irrigation_infrastructures_otherData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_infrastructures_otherData['economic_useful_life'] ?? '' }}
    </td>
    
     @php
    $igresitent = ($irrigation_infrastructures_otherData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
          @if($igresitent != 0)
        {{ $igresitent }}
        @endif
    </td>

    @php
    $iganu = $igbla_sou/2*12/100;
    @endphp
    <td>
        @if($iganu != 0)
        {{ $iganu }}
        @endif
    </td>

    @php
    $iganul_dep = ($irrigation_infrastructures_otherData['total_investment_cost'] ?? 0) / ($irrigation_infrastructures_otherData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
        @if($iganul_dep != 0)
        {{ $iganul_dep }}
        @endif
    </td>

    <td>
        {{ $irrigation_infrastructures_otherData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_infrastructures_otherData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $irrigation_infrastructures_otherData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $iganul_dep = ($irrigation_infrastructures_otherData['total_investment_cost'] ?? 0) / ($irrigation_infrastructures_otherData['economic_useful_life'] ?? 1);
    $iganualfixdCost = $iganul_dep
    + ($irrigation_infrastructures_otherData['annual_insurance'] ?? 0)
    + ($irrigation_infrastructures_otherData['annual_tax'] ?? 0)
    + ($irrigation_infrastructures_otherData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($iganualfixdCost != 0)
        {{ $iganualfixdCost }}
        @endif
    </td>
    
    <td>
        {{ $irrigation_infrastructures_otherData['rental_unit'] ?? '' }}
    </td>
      
    <td>{{ $irrigation_infrastructures_otherData['rental_rate'] ?? '' }}</td>
    
    <td>{{ $irrigation_infrastructures_otherData['any_other'] ?? '' }}</td>
</tr>

            <tr>
                <td style="text-align:center;">
                    2
                </td>

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                
                <td style="font-weight:700;">
                  Farm Mechanization Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                <td></td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                 
                <td></td>
            </tr>
            
<tr>
    <td style="text-align:center;">
        a
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Tractor
    </td>
    
    <td></td>

    @php
    $tractorData = json_decode($datas->tractor, true);
    @endphp
    <td>
        {{ $tractorData['number'] ?? '' }}
    </td>


    <td>
        {{ $tractorData['specification'] ?? '' }}
    </td>
    
    <td>
        {{ $tractorData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $tractorData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $tractorData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $tractorData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
        $bankLonCost = ($tractorData['total_investment_cost'] ?? 0) - ($tractorData['subsidy_grant'] ?? 0);
        $bla_sou = $bankLonCost - ($tractorData['balance_source_of_investment'] ?? 0);
    @endphp
    
    <td>
        @if($bla_sou != 0)
        {{ $bla_sou }}
       @endif
    </td>

    
    

    <td>
        {{ $tractorData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $tractorData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
        $resitent = ($tractorData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resitent != 0)
        {{ $resitent }}
       @endif
    </td>
    
    @php
       $anu = $bla_sou/2*12/100;
    @endphp

    <td>
        @if($anu != 0)
        {{ $anu }}
       @endif
    </td>

    @php
    $anul_dep = ($tractorData['total_investment_cost'] ?? 0) / ($tractorData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
        @if($anul_dep != 0)
        {{ $anul_dep }}
       @endif
    </td>

    <td>
        {{ $tractorData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $tractorData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $tractorData['annual_repair_and_maintenance'] ?? '' }}
    </td>

    @php
        $anul_dep = ($tractorData['total_investment_cost'] ?? 0) / ($tractorData['economic_useful_life'] ?? 1);
        $anualfixdCost = $anul_dep 
                         + ($tractorData['annual_insurance'] ?? 0) 
                         + ($tractorData['annual_tax'] ?? 0) 
                         + ($tractorData['annual_repair_and_maintenance'] ?? 0);
    @endphp
   
    <td>
        @if($anualfixdCost != 0)
        {{ $anualfixdCost }}
       @endif
    </td>
    
    <td>
        {{ $tractorData['rental_unit'] ?? '' }}
    </td>
     
    <td>{{ $tractorData['rental_rate'] ?? '' }}</td>
    <td>{{ $tractorData['any_other'] ?? '' }}</td>
</tr>
            
          <tr>
    <td style="text-align:center;">
        b
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Power Tiller
    </td>
    
    <td></td>

    @php
    $power_tillerData = json_decode($datas->power_tiller, true);
    @endphp
    <td>
        {{ $power_tillerData['number'] ?? '' }}
    </td>


    <td>
        {{ $power_tillerData['specification'] ?? '' }}
    </td>
    
     <td>
        {{ $power_tillerData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $power_tillerData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $power_tillerData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $power_tillerData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $powbankLonCost = ($power_tillerData['total_investment_cost'] ?? 0) - ($power_tillerData['subsidy_grant'] ?? 0);
    $powbla_sou = $powbankLonCost - ($power_tillerData['balance_source_of_investment'] ?? 0);
    @endphp


    <td>
        @if($powbla_sou != 0)
        {{ $powbla_sou }}
        @endif
    </td>

    <td>
        {{ $power_tillerData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $power_tillerData['economic_useful_life'] ?? '' }}
    </td>

    @php
    $powresitent = ($power_tillerData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    
    <td>
        @if($powresitent != 0)
        {{ $powresitent }}
        @endif
    </td>
    
    @php
    $poweranu = $powbla_sou/2*12/100;
    @endphp

    <td>
        @if($poweranu != 0)
        {{ $poweranu }}
        @endif
    </td>
    
    @php
    $powanul_dep = ($power_tillerData['total_investment_cost'] ?? 0) / ($power_tillerData['economic_useful_life'] ?? 1);
    @endphp


    <td>
        @if($powanul_dep != 0)
        {{ $powanul_dep }}
        @endif
    </td>

    <td>
        {{ $power_tillerData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $power_tillerData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $power_tillerData['annual_repair_and_maintenance'] ?? '' }}
    </td>

    @php
    $powanul_dep = ($power_tillerData['total_investment_cost'] ?? 0) / ($power_tillerData['economic_useful_life'] ?? 1);
    $powanualfixdCost = $powanul_dep
    + ($power_tillerData['annual_insurance'] ?? 0)
    + ($power_tillerData['annual_tax'] ?? 0)
    + ($power_tillerData['annual_repair_and_maintenance'] ?? 0);
    @endphp
    
    <td>
        @if($powanualfixdCost != 0)
        {{ $powanualfixdCost }}
        @endif
    </td>
    
    <td>
         {{ $power_tillerData['rental_unit'] ?? '' }}
    </td>
      
    <td> {{ $power_tillerData['rental_rate'] ?? '' }}</td>
    <td>{{ $power_tillerData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        c
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Cultivator
    </td>
    
    <td></td>

    @php
    $cultivatorData = json_decode($datas->cultivator, true);
    @endphp
    <td>
        {{ $cultivatorData['number'] ?? '' }}
    </td>


    <td>
        {{ $cultivatorData['specification'] ?? '' }}
    </td>
    
    <td>
        {{ $cultivatorData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $cultivatorData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $cultivatorData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $cultivatorData['subsidy_grant'] ?? '' }}
    </td>
    
     @php
    $cubankLonCost = ($cultivatorData['total_investment_cost'] ?? 0) - ($cultivatorData['subsidy_grant'] ?? 0);
    $cubla_sou = $cubankLonCost - ($cultivatorData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($cubla_sou != 0)
        {{ $cubla_sou }}
        @endif
    </td>

    <td>
        {{ $cultivatorData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $cultivatorData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $curesitent = ($cultivatorData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($curesitent != 0)
        {{ $curesitent }}
        @endif
    </td>

    @php
    $cuanu = $cubla_sou/2*12/100;
    @endphp
    
    <td>
        @if($cuanu != 0)
        {{ $cuanu }}
        @endif
    </td>

    @php
    $cuanul_dep = ($cultivatorData['total_investment_cost'] ?? 0) / ($cultivatorData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
         @if($cuanul_dep != 0)
        {{ $cuanul_dep }}
        @endif
    </td>

    <td>
        {{ $cultivatorData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $cultivatorData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $cultivatorData['annual_repair_and_maintenance'] ?? '' }}
    </td>

    @php
    $cuanul_dep = ($cultivatorData['total_investment_cost'] ?? 0) / ($cultivatorData['economic_useful_life'] ?? 1);
    $cuanualfixdCost = $cuanul_dep
    + ($cultivatorData['annual_insurance'] ?? 0)
    + ($cultivatorData['annual_tax'] ?? 0)
    + ($cultivatorData['annual_repair_and_maintenance'] ?? 0);
    @endphp
    
    <td>
         @if($cuanualfixdCost != 0)
        {{ $cuanualfixdCost }}
        @endif
    </td>
    
    <td>
         {{ $cultivatorData['rental_unit'] ?? '' }}
    </td>
    
    <td> {{ $cultivatorData['rental_rate'] ?? '' }}</td>
      
    <td>{{ $cultivatorData['any_other'] ?? '' }}</td>
</tr>
            
<tr>
    <td style="text-align:center;">
        d
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Rotator
    </td>
    
    <td></td>

    @php
    $rotatorData = json_decode($datas->rotator, true);
    @endphp
    <td>
        {{ $rotatorData['number'] ?? '' }}
    </td>


    <td>
        {{ $rotatorData['specification'] ?? '' }}
    </td>
    
     <td>
        {{ $rotatorData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $rotatorData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $rotatorData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $rotatorData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $rotatorDatabankLonCost = ($rotatorData['total_investment_cost'] ?? 0) - ($rotatorData['subsidy_grant'] ?? 0);
    $robla_sou = $rotatorDatabankLonCost - ($rotatorData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($robla_sou != 0)
        {{ $robla_sou }}
        @endif
    </td>

    <td>
        {{ $rotatorData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $rotatorData['economic_useful_life'] ?? '' }}
    </td>
    
     @php
    $roresitent = ($rotatorData['total_investment_cost'] ?? 0) * 0.10;
    @endphp


    <td>
        @if($roresitent != 0)
        {{ $roresitent }}
        @endif
    </td>
    
    @php
    $roanu = $robla_sou/2*12/100;
    @endphp


    <td>
        @if($roanu != 0)
        {{ $roanu }}
        @endif
    </td>

    @php
    $roanul_dep = ($rotatorData['total_investment_cost'] ?? 0) / ($rotatorData['economic_useful_life'] ?? 1);
    @endphp


    <td>
         @if($roanul_dep != 0)
        {{ $roanul_dep }}
        @endif
    </td>

    <td>
        {{ $rotatorData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $rotatorData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $rotatorData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $roanul_dep = ($rotatorData['total_investment_cost'] ?? 0) / ($rotatorData['economic_useful_life'] ?? 1);
    $roanualfixdCost = $roanul_dep
    + ($rotatorData['annual_insurance'] ?? 0)
    + ($rotatorData['annual_tax'] ?? 0)
    + ($rotatorData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($roanualfixdCost != 0)
        {{ $roanualfixdCost }}
        @endif
    </td>
    
    <td>
        {{ $rotatorData['rental_unit'] ?? '' }}
    </td>
    
    <td>{{ $rotatorData['rental_rate'] ?? '' }}</td>
     
    <td>{{ $rotatorData['any_other'] ?? '' }}</td>
</tr>
            
    <tr>
    <td style="text-align:center;">
        e
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Harrow
    </td>
    
    <td></td>

    @php
    $harrowData = json_decode($datas->harrow, true);
    @endphp
    <td>
        {{ $harrowData['number'] ?? '' }}
    </td>


    <td>
        {{ $harrowData['specification'] ?? '' }}
    </td>
    
    <td>
        {{ $harrowData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $harrowData['year_of_asset_creation'] ?? '' }}
    </td>


    <td>
        {{ $harrowData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $harrowData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
        $harrowBCost = ($harrowData['total_investment_cost'] ?? 0) - ($harrowData['subsidy_grant'] ?? 0);
        $harrowCost = $harrowBCost - ($harrowData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($harrowCost != 0)
        {{ $harrowCost }}
       @endif
    </td>

    <td>
        {{ $harrowData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $harrowData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
        $howwresitent = ($harrowData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($howwresitent != 0)
         {{ $howwresitent ?? '' }}
        @endif
    </td>
    
    @php
       $howwanu = $harrowCost/2*12/100;
    @endphp

    <td>
       @if($howwanu != 0)
         {{ $howwanu ?? '' }}
        @endif
    </td>
    
    
    @php
    $howwanul_dep = ($harrowData['total_investment_cost'] ?? 0) / ($harrowData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($howwanul_dep != 0)
         {{ $howwanul_dep ?? '' }}
        @endif
        <!--{{ $harrowData['annual_depreciation'] ?? '' }}-->
    </td>

    <td>
        {{ $harrowData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $harrowData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $harrowData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
     @php
        $howwanul_dep = ($harrowData['total_investment_cost'] ?? 0) / ($harrowData['economic_useful_life'] ?? 1);
        $howwanualfixdCost = $howwanul_dep 
                         + ($harrowData['annual_insurance'] ?? 0) 
                         + ($harrowData['annual_tax'] ?? 0) 
                         + ($harrowData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($howwanualfixdCost != 0)
         {{ $howwanualfixdCost ?? '' }}
        @endif
        <!--{{ $harrowData['annual_fixed_cost_of_asset'] ?? '' }}-->
    </td>
    
    <td>
         {{ $harrowData['rental_unit'] ?? '' }}
    </td>
      
    <td> {{ $harrowData['rental_rate'] ?? '' }}</td>
    <td>{{ $harrowData['any_other'] ?? '' }}</td>
</tr>
            
           <tr>
    <td style="text-align:center;">
        f
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Leveller
    </td>
    
    <td></td>

    @php
    $levellerData = json_decode($datas->leveller, true);
    @endphp
    <td>
        {{ $levellerData['number'] ?? '' }}
    </td>


    <td>
        {{ $levellerData['specification'] ?? '' }}
    </td>
    
    <td>
        {{ $levellerData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $levellerData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $levellerData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $levellerData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $lebankLonCost = ($levellerData['total_investment_cost'] ?? 0) - ($levellerData['subsidy_grant'] ?? 0);
    $lebla_sou = $lebankLonCost - ($levellerData['balance_source_of_investment'] ?? 0);
    @endphp


    <td>
         @if($lebla_sou != 0)
        {{ $lebla_sou }}
        @endif
    </td>

    <td>
        {{ $levellerData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $levellerData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $leresitent = ($levellerData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($leresitent != 0)
        {{ $leresitent }}
        @endif
    </td>

    @php
    $leanu = $lebla_sou/2*12/100;
    @endphp

    <td>
        @if($leanu != 0)
        {{ $leanu }}
        @endif
    </td>
    
    @php
    $leanul_dep = ($levellerData['total_investment_cost'] ?? 0) / ($levellerData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($leanul_dep != 0)
        {{ $leanul_dep }}
        @endif
    </td>

    <td>
        {{ $levellerData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $levellerData['annual_tax'] ?? '' }}
    </td>


    <td>
        {{ $levellerData['annual_repair_and_maintenance'] ?? '' }}
    </td>

     @php
    $leanul_dep = ($levellerData['total_investment_cost'] ?? 0) / ($levellerData['economic_useful_life'] ?? 1);
    $leanualfixdCost = $leanul_dep
    + ($levellerData['annual_insurance'] ?? 0)
    + ($levellerData['annual_tax'] ?? 0)
    + ($levellerData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($leanualfixdCost != 0)
        {{ $leanualfixdCost }}
        @endif
    </td>
    
    <td>
        {{ $levellerData['rental_unit'] ?? '' }}
    </td>
    
    <td>{{ $levellerData['rental_rate'] ?? '' }}</td>

    <td>{{ $levellerData['any_other'] ?? '' }}</td>
</tr>

    <tr>
    <td style="text-align:center;">
        g
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Plough (MB Plough / Disc Plough)
    </td>
    
    <td></td>

    @php
    $ploughData = json_decode($datas->plough, true);
    @endphp
    <td>
        {{ $ploughData['number'] ?? '' }}
    </td>


    <td>
        {{ $ploughData['specification'] ?? '' }}
    </td>
    
    <td>
        {{ $ploughData['specification_unit'] ?? '' }}
    </td>
    <td>
        {{ $ploughData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $ploughData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $ploughData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $plbankLonCost = ($ploughData['total_investment_cost'] ?? 0) - ($ploughData['subsidy_grant'] ?? 0);
    $plbla_sou = $plbankLonCost - ($ploughData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
       @if($plbla_sou != 0)
        {{ $plbla_sou }}
        @endif
    </td>

    <td>
        {{ $ploughData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $ploughData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $plresitent = ($ploughData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($plresitent != 0)
        {{ $plresitent }}
        @endif
    </td>
    
    
    @php
    $planu = $plbla_sou/2*12/100;
    @endphp

    <td>
       @if($planu != 0)
        {{ $planu }}
        @endif
    </td>

    @php
    $planul_dep = ($ploughData['total_investment_cost'] ?? 0) / ($ploughData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
        @if($planul_dep != 0)
        {{ $planul_dep }}
        @endif
    </td>

    <td>
        {{ $ploughData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $ploughData['annual_tax'] ?? '' }}
    </td>

    
    <td>
        {{ $ploughData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $planul_dep = ($ploughData['total_investment_cost'] ?? 0) / ($ploughData['economic_useful_life'] ?? 1);
    $planualfixdCost = $planul_dep
    + ($ploughData['annual_insurance'] ?? 0)
    + ($ploughData['annual_tax'] ?? 0)
    + ($ploughData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($planualfixdCost != 0)
        {{ $planualfixdCost }}
        @endif
    </td>
    
    <td>
         {{ $ploughData['rental_unit'] ?? '' }}
    </td>
    
    <td> {{ $ploughData['rental_rate'] ?? '' }}</td>
    
    <td>{{ $ploughData['any_other'] ?? '' }}</td>
</tr>
            
              <tr>
    <td style="text-align:center;">
        h
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Seed drill
    </td>
    
    <td></td>

    @php
    $speed_drillData = json_decode($datas->speed_drill, true);
    @endphp
    <td>
        {{ $speed_drillData['number'] ?? '' }}
    </td>


    <td>
        {{ $speed_drillData['specification'] ?? '' }}
    </td>

    <td>
        {{ $speed_drillData['specification_unit'] ?? '' }}
    </td>
  
    <td>
        {{ $speed_drillData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $speed_drillData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $speed_drillData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $spbankLonCost = ($speed_drillData['total_investment_cost'] ?? 0) - ($speed_drillData['subsidy_grant'] ?? 0);
    $spbla_sou = $spbankLonCost - ($speed_drillData['balance_source_of_investment'] ?? 0);
    @endphp
    
    <td>
        @if($spbla_sou != 0)
        {{ $spbla_sou }}
        @endif
    </td>

    <td>
        {{ $speed_drillData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $speed_drillData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $spresitent = ($speed_drillData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($spresitent != 0)
        {{ $spresitent }}
        @endif
    </td>
    
     @php
    $spanu = $spbla_sou/2*12/100;
    @endphp

    <td>
       @if($spanu != 0)
        {{ $spanu }}
        @endif
    </td>
    
    @php
    $spanul_dep = ($speed_drillData['total_investment_cost'] ?? 0) / ($speed_drillData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($spanul_dep != 0)
        {{ $spanul_dep }}
        @endif
    </td>

    <td>
        {{ $speed_drillData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $speed_drillData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $speed_drillData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $spanul_dep = ($speed_drillData['total_investment_cost'] ?? 0) / ($speed_drillData['economic_useful_life'] ?? 1);
    $anualfixdCost = $spanul_dep
    + ($speed_drillData['annual_insurance'] ?? 0)
    + ($speed_drillData['annual_tax'] ?? 0)
    + ($speed_drillData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualfixdCost != 0)
        {{ $anualfixdCost }}
        @endif
    </td>
    
    <td>
         {{ $speed_drillData['rental_unit'] ?? '' }}
    </td>
    
    <td> {{ $speed_drillData['rental_rate'] ?? '' }}</td>
    
    <td>{{ $speed_drillData['any_other'] ?? '' }}</td>
</tr>
            
             <tr>
    <td style="text-align:center;">
        i
    </td>


    <td>
    </td>
    
    <td>
    </td>

    <td>
     Seed Planter	
    </td>
 <td></td>
    @php
    $speed_planterData = json_decode($datas->speed_planter, true);
    @endphp
    <td>
        {{ $speed_planterData['number'] ?? '' }}
    </td>


    <td>
        {{ $speed_planterData['specification'] ?? '' }}
    </td>
    
     <td>
        {{ $speed_planterData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $speed_planterData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $speed_planterData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $speed_planterData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $speebankLonCost = ($speed_planterData['total_investment_cost'] ?? 0) - ($speed_planterData['subsidy_grant'] ?? 0);
    $speebla_sou = $speebankLonCost - ($speed_planterData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($speebla_sou != 0)
        {{ $speebla_sou }}
        @endif
    </td>

    <td>
        {{ $speed_planterData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $speed_planterData['economic_useful_life'] ?? '' }}
    </td>

    @php
    $speeresitent = ($speed_planterData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($speeresitent != 0)
        {{ $speeresitent }}
        @endif
    </td>
    
    @php
    $speeanu = $speebla_sou/2*12/100;
    @endphp


    <td>
        @if($speeanu != 0)
        {{ $speeanu }}
        @endif
    </td>
    
    @php
    $speeanul_dep = ($speed_planterData['total_investment_cost'] ?? 0) / ($speed_planterData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($speeanul_dep != 0)
        {{ $speeanul_dep }}
        @endif
    </td>

    <td>
        {{ $speed_planterData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $speed_planterData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $speed_planterData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $speeanul_dep = ($speed_planterData['total_investment_cost'] ?? 0) / ($speed_planterData['economic_useful_life'] ?? 1);
    $speeanualfixdCost = $speeanul_dep
    + ($speed_planterData['annual_insurance'] ?? 0)
    + ($speed_planterData['annual_tax'] ?? 0)
    + ($speed_planterData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($speeanualfixdCost != 0)
        {{ $speeanualfixdCost }}
        @endif
    </td>
    
    <td>
         {{ $speed_planterData['rental_unit'] ?? '' }}
    </td>
    <td> {{ $speed_planterData['rental_rate'] ?? '' }}</td>
      
    <td>{{ $speed_planterData['any_other'] ?? '' }}</td>
</tr>

             <tr>
    <td style="text-align:center;">
        j
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Seed cum fertilizer drill	
    </td>
    
    <td></td>

    @php
    $speed_cum_fertilizer_drillData = json_decode($datas->speed_cum_fertilizer_drill, true);
    @endphp
    <td>
        {{ $speed_cum_fertilizer_drillData['number'] ?? '' }}
    </td>


    <td>
        {{ $speed_cum_fertilizer_drillData['specification'] ?? '' }}
    </td>
    
     <td>
        {{ $speed_cum_fertilizer_drillData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $speed_cum_fertilizer_drillData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $speed_cum_fertilizer_drillData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $speed_cum_fertilizer_drillData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $scfbankLonCost = ($speed_cum_fertilizer_drillData['total_investment_cost'] ?? 0) - ($speed_cum_fertilizer_drillData['subsidy_grant'] ?? 0);
    $scfbla_sou = $scfbankLonCost - ($speed_cum_fertilizer_drillData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($scfbla_sou != 0)
        {{ $scfbla_sou }}
        @endif
    </td>

    <td>
        {{ $speed_cum_fertilizer_drillData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $speed_cum_fertilizer_drillData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $scfresitent = ($speed_cum_fertilizer_drillData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($scfresitent != 0)
        {{ $scfresitent }}
        @endif
    </td>
    
    @php
    $scfanu = $scfbla_sou/2*12/100;
    @endphp

    <td>
        @if($scfanu != 0)
        {{ $scfanu }}
        @endif
    </td>
    
    @php
    $scfanul_dep = ($speed_cum_fertilizer_drillData['total_investment_cost'] ?? 0) / ($speed_cum_fertilizer_drillData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($scfanul_dep != 0)
        {{ $scfanul_dep }}
        @endif
    </td>

    <td>
        {{ $speed_cum_fertilizer_drillData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $speed_cum_fertilizer_drillData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $speed_cum_fertilizer_drillData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $scfanul_dep = ($speed_cum_fertilizer_drillData['total_investment_cost'] ?? 0) / ($speed_cum_fertilizer_drillData['economic_useful_life'] ?? 1);
    $scfanualfixdCost = $scfanul_dep
    + ($speed_cum_fertilizer_drillData['annual_insurance'] ?? 0)
    + ($speed_cum_fertilizer_drillData['annual_tax'] ?? 0)
    + ($speed_cum_fertilizer_drillData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($scfanualfixdCost != 0)
        {{ $scfanualfixdCost }}
        @endif

    </td>
    
      <td>
        {{ $speed_cum_fertilizer_drillData['rental_unit'] ?? '' }}
    </td>
    
      <td>
        {{ $speed_cum_fertilizer_drillData['rental_rate'] ?? '' }}
    </td>
     
    <td>{{ $speed_cum_fertilizer_drillData['any_other'] ?? '' }}</td>
</tr>
            
              <tr>
    <td style="text-align:center;">
        k
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Trolley	
    </td>
    
    <td></td>

    @php
    $trolleyData = json_decode($datas->trolley, true);
    @endphp
    <td>
        {{ $trolleyData['number'] ?? '' }}
    </td>


    <td>
        {{ $trolleyData['specification'] ?? '' }}
    </td>
    
    <td>
        {{ $trolleyData['specification_unit'] ?? '' }}
    </td>

    <td>
        {{ $trolleyData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $trolleyData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $trolleyData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $tlbankLonCost = ($trolleyData['total_investment_cost'] ?? 0) - ($trolleyData['subsidy_grant'] ?? 0);
    $tlbla_sou = $tlbankLonCost - ($trolleyData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($tlbla_sou != 0)
        {{ $tlbla_sou }}
        @endif
    </td>

    <td>
        {{ $trolleyData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $trolleyData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $tlresitent = ($trolleyData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($tlresitent != 0)
        {{ $tlresitent }}
        @endif
    </td>
    
    @php
    $tlanu = $tlbla_sou/2*12/100;
    @endphp

    <td>
         @if($tlanu != 0)
        {{ $tlanu }}
        @endif
    </td>
    
    @php
    $tlanul_dep = ($trolleyData['total_investment_cost'] ?? 0) / ($trolleyData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($tlanul_dep != 0)
        {{ $tlanul_dep }}
        @endif
    </td>

    <td>
        {{ $trolleyData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $trolleyData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $trolleyData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $tlanul_dep = ($trolleyData['total_investment_cost'] ?? 0) / ($trolleyData['economic_useful_life'] ?? 1);
    $tlanualfixdCost = $tlanul_dep
    + ($trolleyData['annual_insurance'] ?? 0)
    + ($trolleyData['annual_tax'] ?? 0)
    + ($trolleyData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($tlanualfixdCost != 0)
        {{ $tlanualfixdCost }}
        @endif
    </td>
    
    <td>
        {{ $trolleyData['rental_unit'] ?? '' }}
    </td>

    <td>{{ $trolleyData['rental_rate'] ?? '' }}</td>
    
    <td>{{ $trolleyData['any_other'] ?? '' }}</td>
</tr>
            
             <tr>
    <td style="text-align:center;">
        l
    </td>


    <td>
    </td>

    <td>
    </td>

    <td>
    Reaper cum binder	
    </td>
    
    <td></td>

    @php
    $reaper_cum_binderData = json_decode($datas->reaper_cum_binder, true);
    @endphp
    
    <td>
        {{ $reaper_cum_binderData['number'] ?? '' }}
    </td>


    <td>
        {{ $reaper_cum_binderData['specification'] ?? '' }}
    </td>
    
     <td> {{ $reaper_cum_binderData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $reaper_cum_binderData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $reaper_cum_binderData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $reaper_cum_binderData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $rebankLonCost = ($reaper_cum_binderData['total_investment_cost'] ?? 0) - ($reaper_cum_binderData['subsidy_grant'] ?? 0);
    $rcbbla_sou = $rebankLonCost - ($reaper_cum_binderData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($rcbbla_sou != 0)
        {{ $rcbbla_sou }}
        @endif
    </td>

    <td>
        {{ $reaper_cum_binderData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $reaper_cum_binderData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $rcbresitent = ($reaper_cum_binderData['total_investment_cost'] ?? 0) * 0.10;
    @endphp


    <td>
         @if($rcbresitent != 0)
        {{ $rcbresitent }}
        @endif
    </td>
    
    @php
    $rcbanu = $rcbbla_sou/2*12/100;
    @endphp

    <td>
         @if($rcbanu != 0)
        {{ $rcbanu }}
        @endif
    </td>
    
    @php
    $rcbanul_dep = ($reaper_cum_binderData['total_investment_cost'] ?? 0) / ($reaper_cum_binderData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($rcbanul_dep != 0)
        {{ $rcbanul_dep }}
        @endif
    </td>

    <td>
        {{ $reaper_cum_binderData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $reaper_cum_binderData['annual_tax'] ?? '' }}
    </td>
    
     <td>
        {{ $reaper_cum_binderData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $rcbanul_dep = ($reaper_cum_binderData['total_investment_cost'] ?? 0) / ($reaper_cum_binderData['economic_useful_life'] ?? 1);
    $rcbanualfixdCost = $rcbanul_dep
    + ($reaper_cum_binderData['annual_insurance'] ?? 0)
    + ($reaper_cum_binderData['annual_tax'] ?? 0)
    + ($reaper_cum_binderData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($rcbanualfixdCost != 0)
        {{ $rcbanualfixdCost }}
       @endif
    </td>
    
    <td>
         {{ $reaper_cum_binderData['rental_unit'] ?? '' }}
    </td>
    <td> {{ $reaper_cum_binderData['rental_rate'] ?? '' }}</td>
      
    <td>{{ $reaper_cum_binderData['any_other'] ?? '' }}</td>
</tr>
            
             <tr>
    <td style="text-align:center;">
        m
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Husk Making Machine	
    </td>
    
    <td></td>

    @php
    $bhusa_machineData = json_decode($datas->bhusa_machine, true);
    @endphp
    <td>
        {{ $bhusa_machineData['number'] ?? '' }}
    </td>


    <td>
        {{ $bhusa_machineData['specification'] ?? '' }}
    </td>
    
      <td>{{ $bhusa_machineData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $bhusa_machineData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $bhusa_machineData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $bhusa_machineData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $banCost = ($bhusa_machineData['total_investment_cost'] ?? 0) - ($bhusa_machineData['subsidy_grant'] ?? 0);
    $blsou = $banCost - ($bhusa_machineData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
         @if($blsou != 0)
        {{ $blsou }}
        @endif
    </td>

    <td>
        {{ $bhusa_machineData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $bhusa_machineData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resent = ($bhusa_machineData['total_investment_cost'] ?? 0) * 0.10;
    @endphp


    <td>
        @if($resent != 0)
        {{ $resent }}
        @endif
    </td>
    
    @php
    $dfanu = $blsou/2*12/100;
    @endphp

    <td>
         @if($dfanu != 0)
        {{ $dfanu }}
        @endif
    </td>
    
     @php
    $anggul_dep = ($bhusa_machineData['total_investment_cost'] ?? 0) / ($bhusa_machineData['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($anggul_dep != 0)
        {{ $anggul_dep }}
        @endif
    </td>

    <td>
        {{ $bhusa_machineData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $bhusa_machineData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $bhusa_machineData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
     @php
    $anultdep = ($bhusa_machineData['total_investment_cost'] ?? 0) / ($bhusa_machineData['economic_useful_life'] ?? 1);
    $aalfixdCost = $anultdep
    + ($bhusa_machineData['annual_insurance'] ?? 0)
    + ($bhusa_machineData['annual_tax'] ?? 0)
    + ($bhusa_machineData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
         @if($aalfixdCost != 0)
        {{ $aalfixdCost }}
        @endif
    </td>
    
    <td>
        {{ $bhusa_machineData['rental_unit'] ?? '' }}
    </td>
    
    <td>{{ $bhusa_machineData['rental_rate'] ?? '' }}</td>
      
    <td>{{ $bhusa_machineData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        n
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Thresher	
    </td>
    
    <td></td>

    @php
    $thresherData = json_decode($datas->thresher, true);
    @endphp
    <td>
        {{ $thresherData['number'] ?? '' }}
    </td>


    <td>
        {{ $thresherData['specification'] ?? '' }}
    </td>
    
      <td>{{ $thresherData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $thresherData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $thresherData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $thresherData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $bankLost = ($thresherData['total_investment_cost'] ?? 0) - ($thresherData['subsidy_grant'] ?? 0);
    $thbla_sou = $bankLost - ($thresherData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($thbla_sou != 0)
        {{ $thbla_sou }}
        @endif
    </td>

    <td>
        {{ $thresherData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $thresherData['economic_useful_life'] ?? '' }}
    </td>
    
     @php
    $resirrtent = ($thresherData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resirrtent != 0)
        {{ $resirrtent }}
        @endif
    </td>
    
    @php
    $afenu = $thbla_sou/2*12/100;
    @endphp

    <td>
       @if($afenu != 0)
        {{ $afenu }}
        @endif
    </td>
    
    @php
    $anultdep = ($thresherData['total_investment_cost'] ?? 0) / ($thresherData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anultdep != 0)
        {{ $anultdep }}
        @endif
    </td>

    <td>
        {{ $thresherData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $thresherData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $thresherData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $aneedep = ($thresherData['total_investment_cost'] ?? 0) / ($thresherData['economic_useful_life'] ?? 1);
    $adfixdCost = $aneedep
    + ($thresherData['annual_insurance'] ?? 0)
    + ($thresherData['annual_tax'] ?? 0)
    + ($thresherData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($adfixdCost != 0)
        {{ $adfixdCost }}
        @endif
    </td>
    
    <td>
        {{ $thresherData['rental_unit'] ?? '' }}
    </td>
    
    <td>{{ $thresherData['rental_rate'] ?? '' }}</td>
    
    <td>{{ $thresherData['any_other'] ?? '' }}</td>
</tr>
            
               <tr>
    <td style="text-align:center;">
        o
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Combine Harvester	
    </td>
    
    <td></td>

    @php
    $combine_harvesterData = json_decode($datas->combine_harvester, true);
    @endphp
    <td>
        {{ $combine_harvesterData['number'] ?? '' }}
    </td>


    <td>
        {{ $combine_harvesterData['specification'] ?? '' }}
    </td>
    
      <td>{{ $combine_harvesterData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $combine_harvesterData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $combine_harvesterData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $combine_harvesterData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $baeenCost = ($combine_harvesterData['total_investment_cost'] ?? 0) - ($combine_harvesterData['subsidy_grant'] ?? 0);
    $chbla_sou = $baeenCost - ($combine_harvesterData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
          @if($chbla_sou != 0)
        {{ $chbla_sou }}
        @endif
    </td>

    <td>
        {{ $combine_harvesterData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $combine_harvesterData['economic_useful_life'] ?? '' }}
    </td>
    
     @php
    $reent = ($combine_harvesterData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($reent != 0)
        {{ $reent }}
        @endif
    </td>
    
     @php
    $anufe = $chbla_sou/2*12/100;
    @endphp

    <td>
        @if($anufe != 0)
        {{ $anufe }}
        @endif
    </td>
    
    @php
    $anuhrhl_dep = ($combine_harvesterData['total_investment_cost'] ?? 0) / ($combine_harvesterData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($anuhrhl_dep != 0)
        {{ $anuhrhl_dep }}
        @endif
    </td>

    <td>
        {{ $combine_harvesterData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $combine_harvesterData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $combine_harvesterData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anuydep = ($combine_harvesterData['total_investment_cost'] ?? 0) / ($combine_harvesterData['economic_useful_life'] ?? 1);
    $anualfixdCost = $anuydep
    + ($combine_harvesterData['annual_insurance'] ?? 0)
    + ($combine_harvesterData['annual_tax'] ?? 0)
    + ($combine_harvesterData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anualfixdCost != 0)
        {{ $anualfixdCost }}
        @endif
    </td>
    
    <td>
        {{ $combine_harvesterData['rental_unit'] ?? '' }}
    </td>
    
    <td>{{ $combine_harvesterData['rental_rate'] ?? '' }}</td>
     
    <td>{{ $combine_harvesterData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        p
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Other	
    </td>
    
    <td></td>

    @php
    $farm_mechanisms_otherData = json_decode($datas->farm_mechanisms_other, true);
    @endphp
    <td>
        {{ $farm_mechanisms_otherData['number'] ?? '' }}
    </td>


    <td>
        {{ $farm_mechanisms_otherData['specification'] ?? '' }}
    </td>
    
      <td>{{ $farm_mechanisms_otherData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $farm_mechanisms_otherData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $farm_mechanisms_otherData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $farm_mechanisms_otherData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $bryLonCost = ($farm_mechanisms_otherData['total_investment_cost'] ?? 0) - ($farm_mechanisms_otherData['subsidy_grant'] ?? 0);
    $fbla_sou = $bryLonCost - ($farm_mechanisms_otherData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($fbla_sou != 0)
        {{ $fbla_sou }}
        @endif
    </td>

    <td>
        {{ $farm_mechanisms_otherData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $farm_mechanisms_otherData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resitytyent = ($farm_mechanisms_otherData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    
    

    <td>
         @if($resitytyent != 0)
        {{ $resitytyent }}
        @endif
    </td>
    
     @php
    $ahjmnu = $fbla_sou/2*12/100;
    @endphp

    <td>
        @if($ahjmnu != 0)
        {{ $ahjmnu }}
        @endif
    </td>

     @php
    $anuerdep = ($farm_mechanisms_otherData['total_investment_cost'] ?? 0) / ($farm_mechanisms_otherData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anuerdep != 0)
        {{ $anuerdep }}
        @endif
    </td>

    <td>
        {{ $farm_mechanisms_otherData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $farm_mechanisms_otherData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $farm_mechanisms_otherData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anutrep = ($farm_mechanisms_otherData['total_investment_cost'] ?? 0) / ($farm_mechanisms_otherData['economic_useful_life'] ?? 1);
    $fixdCost = $anul_dep
    + ($farm_mechanisms_otherData['annual_insurance'] ?? 0)
    + ($farm_mechanisms_otherData['annual_tax'] ?? 0)
    + ($farm_mechanisms_otherData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($fixdCost != 0)
        {{ $fixdCost }}
        @endif
    </td>
    
    <td>
        {{ $farm_mechanisms_otherData['rental_unit'] ?? '' }}
    </td>
     
    <td>{{ $farm_mechanisms_otherData['rental_rate'] ?? '' }}</td>
    
    <td>{{ $farm_mechanisms_otherData['any_other'] ?? '' }}</td>
</tr>
            
             <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td style="font-weight:700;">
                Storage Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                     <td></td>
                     <td></td>
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
               
                   
                </td>
                  <td>
                   
                </td>
                  <td></td>
                    
                <td></td>
            </tr>
            
            <tr>
    <td style="text-align:center;">
        a
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Kothila / Deshi Storage Structure	
    </td>
    
    <td></td>

    @php
    $deshiData = json_decode($datas->deshi, true);
    @endphp
    <td>
        {{ $deshiData['number'] ?? '' }}
    </td>


    <td>
        {{ $deshiData['specification'] ?? '' }}
    </td>
    
      <td>{{ $deshiData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $deshiData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $deshiData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $deshiData['subsidy_grant'] ?? '' }}
    </td>
    
     @php
    $banhtnCost = ($deshiData['total_investment_cost'] ?? 0) - ($deshiData['subsidy_grant'] ?? 0);
    $ddbla_sou = $banhtnCost - ($deshiData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
         @if($ddbla_sou != 0)
        {{ $ddbla_sou }}
        @endif
    </td>

    <td>
        {{ $deshiData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $deshiData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $rewefent = ($deshiData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
           @if($rewefent != 0)
        {{ $rewefent }}
        @endif
    </td>
    
    @php
    $anfeu = $ddbla_sou/2*12/100;
    @endphp

    <td>
        @if($anfeu != 0)
        {{ $anfeu }}
        @endif
    </td>
    
    @php
    $anujep = ($deshiData['total_investment_cost'] ?? 0) / ($deshiData['economic_useful_life'] ?? 1);
    @endphp


    <td>
        @if($anujep != 0)
        {{ $anujep }}
        @endif
    </td>

    <td>
        {{ $deshiData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $deshiData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $deshiData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    
    @php
    $anugggrdep = ($deshiData['total_investment_cost'] ?? 0) / ($deshiData['economic_useful_life'] ?? 1);
    $anttixdCost = $anugggrdep
    + ($deshiData['annual_insurance'] ?? 0)
    + ($deshiData['annual_tax'] ?? 0)
    + ($deshiData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anttixdCost != 0)
        {{ $anttixdCost }}
        @endif
    </td>
    
    <td>
        {{ $deshiData['rental_unit'] ?? '' }}
    </td>
   
        <td>{{ $deshiData['rental_rate'] ?? '' }}</td>
        
    <td>{{ $deshiData['any_other'] ?? '' }}</td>
</tr>
            
             <tr>
    <td style="text-align:center;">
        b
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Godown
    </td>
    
    <td></td>

    @php
    $godownData = json_decode($datas->godown, true);
    @endphp
    <td>
        {{ $godownData['number'] ?? '' }}
    </td>


    <td>
        {{ $godownData['specification'] ?? '' }}
    </td>
    
      <td> {{ $godownData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $godownData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $godownData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $godownData['subsidy_grant'] ?? '' }}
    </td>
    
     @php
    $brgfost = ($godownData['total_investment_cost'] ?? 0) - ($godownData['subsidy_grant'] ?? 0);
    $godbla_sou = $brgfost - ($godownData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
       @if($godbla_sou != 0)
        {{ $godbla_sou }}
        @endif
    </td>

    <td>
        {{ $godownData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $godownData['economic_useful_life'] ?? '' }}
    </td>
    
     @php
    $resigr = ($godownData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
       @if($resigr != 0)
        {{ $resigr }}
        @endif
    </td>
    
    @php
    $anfnfu = $godbla_sou/2*12/100;
    @endphp


    <td>
         @if($anfnfu != 0)
        {{ $anfnfu }}
        @endif
    </td>
    
    @php
    $anulp = ($godownData['total_investment_cost'] ?? 0) / ($godownData['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($anulp != 0)
        {{ $anulp }}
        @endif
    </td>

    <td>
        {{ $godownData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $godownData['annual_tax'] ?? '' }}
    </td>

   

    <td>
        {{ $godownData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anhtrdep = ($godownData['total_investment_cost'] ?? 0) / ($godownData['economic_useful_life'] ?? 1);
    $anrgxdCost = $anhtrdep
    + ($godownData['annual_insurance'] ?? 0)
    + ($godownData['annual_tax'] ?? 0)
    + ($godownData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anrgxdCost != 0)
        {{ $anrgxdCost }}
        @endif
    </td>
    
    <td>
         {{ $godownData['rental_unit'] ?? '' }}
    </td>
    <td> {{ $godownData['rental_rate'] ?? '' }}</td>
     
    <td>{{ $godownData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        c
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    clod
    </td>
    
    <td></td>

    @php
    $clodData = json_decode($datas->clod, true);
    @endphp
    <td>
        {{ $clodData['number'] ?? '' }}
    </td>


    <td>
        {{ $clodData['specification'] ?? '' }}
    </td>
    
      <td> {{ $clodData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $clodData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $clodData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $clodData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $clCost = ($clodData['total_investment_cost'] ?? 0) - ($clodData['subsidy_grant'] ?? 0);
    $clbla_sou = $clCost - ($clodData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
       @if($clbla_sou != 0)
        {{ $clbla_sou }}
        @endif
    </td>

    <td>
        {{ $clodData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $clodData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resittt = ($clodData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    

    <td>
        @if($resittt != 0)
        {{ $resittt }}
        @endif
    </td>
    
     @php
    $anyju = $clbla_sou/2*12/100;
    @endphp


    <td>
        @if($anyju != 0)
        {{ $anyju }}
        @endif
    </td>
    
    @php
    $ainul_dep = ($clodData['total_investment_cost'] ?? 0) / ($clodData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($ainul_dep != 0)
        {{ $ainul_dep }}
        @endif
    </td>

    <td>
        {{ $clodData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $clodData['annual_tax'] ?? '' }}
    </td>


    <td>
        {{ $clodData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anurdep = ($clodData['total_investment_cost'] ?? 0) / ($clodData['economic_useful_life'] ?? 1);
    $anfggalfixdCost = $anurdep
    + ($clodData['annual_insurance'] ?? 0)
    + ($clodData['annual_tax'] ?? 0)
    + ($clodData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anfggalfixdCost != 0)
        {{ $anfggalfixdCost }}
        @endif
    </td>
    
    <td>
         {{ $clodData['rental_unit'] ?? '' }}
    </td>
    
    <td> {{ $clodData['rental_rate'] ?? '' }}</td>
      
    <td>{{ $clodData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        d
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Bulk Cooling Unit
    </td>
    
    <td></td>

    @php
    $bulk_coolingData = json_decode($datas->bulk_cooling, true);
    @endphp
    <td>
        {{ $bulk_coolingData['number'] ?? '' }}
    </td>


    <td>
        {{ $bulk_coolingData['specification'] ?? '' }}
    </td>
    
      <td>{{ $bulk_coolingData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $bulk_coolingData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $bulk_coolingData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $bulk_coolingData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $banefonCost = ($bulk_coolingData['total_investment_cost'] ?? 0) - ($bulk_coolingData['subsidy_grant'] ?? 0);
    $bcbla_sou = $banefonCost - ($bulk_coolingData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($bcbla_sou != 0)
        {{ $bcbla_sou }}
        @endif
    </td>

    <td>
        {{ $bulk_coolingData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $bulk_coolingData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $datresitent = ($bulk_coolingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($datresitent != 0)
        {{ $datresitent }}
        @endif
    </td>
    
    @php
    $anufr = $bcbla_sou/2*12/100;
    @endphp

    <td>
        @if($anufr != 0)
        {{ $anufr }}
        @endif
    </td>
    
    @php
    $anuyyep = ($bulk_coolingData['total_investment_cost'] ?? 0) / ($bulk_coolingData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($anuyyep != 0)
        {{ $anuyyep }}
        @endif
    </td>

    <td>
        {{ $bulk_coolingData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $bulk_coolingData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $bulk_coolingData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $ayynul_dep = ($bulk_coolingData['total_investment_cost'] ?? 0) / ($bulk_coolingData['economic_useful_life'] ?? 1);
    $anualwwfixdCost = $ayynul_dep
    + ($bulk_coolingData['annual_insurance'] ?? 0)
    + ($bulk_coolingData['annual_tax'] ?? 0)
    + ($bulk_coolingData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualwwfixdCost != 0)
        {{ $anualwwfixdCost }}
        @endif
    </td>
    
    <td>
       {{ $bulk_coolingData['rental_unit'] ?? '' }} 
    </td>
    
    <td>{{ $bulk_coolingData['rental_rate'] ?? '' }}</td>

    <td>{{ $bulk_coolingData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        e
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Storage for fodder
    </td>
    
    <td></td>

    @php
    $fodderData = json_decode($datas->fodder, true);
    @endphp
    <td>
        {{ $fodderData['number'] ?? '' }}
    </td>


    <td>
        {{ $fodderData['specification'] ?? '' }}
    </td>
    
     <td> {{ $fodderData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $fodderData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $fodderData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $fodderData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $ffbankLonCost = ($fodderData['total_investment_cost'] ?? 0) - ($fodderData['subsidy_grant'] ?? 0);
    $fodbla_sou = $ffbankLonCost - ($fodderData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($fodbla_sou != 0)
        {{ $fodbla_sou }}
        @endif
    </td>

    <td>
        {{ $fodderData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $fodderData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resngitent = ($fodderData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resngitent != 0)
        {{ $resngitent }}
        @endif
    </td>
    
    @php
    $aggnu = $fodbla_sou/2*12/100;
    @endphp


    <td>
        @if($aggnu != 0)
        {{ $aggnu }}
        @endif
    </td>
    
    @php
    $rttanul_dep = ($fodderData['total_investment_cost'] ?? 0) / ($fodderData['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($rttanul_dep != 0)
        {{ $rttanul_dep }}
        @endif
    </td>

    <td>
        {{ $fodderData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $fodderData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $fodderData['annual_repair_and_maintenance'] ?? '' }}
    </td>

    @php
    $fodanul_dep = ($fodderData['total_investment_cost'] ?? 0) / ($fodderData['economic_useful_life'] ?? 1);
    $anuaxdCost = $fodanul_dep
    + ($fodderData['annual_insurance'] ?? 0)
    + ($fodderData['annual_tax'] ?? 0)
    + ($fodderData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anuaxdCost != 0)
        {{ $anuaxdCost }}
        @endif
    </td>
    
    <td>
         {{ $fodderData['rental_unit'] ?? '' }}
    </td>
    
    <td> {{ $fodderData['rental_rate'] ?? '' }}</td>
      
    <td>{{ $fodderData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        f
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Other
    </td>
    
    <td></td>

    @php
    $storage_structures_otherData = json_decode($datas->storage_structures_other, true);
    @endphp
    <td>
        {{ $storage_structures_otherData['number'] ?? '' }}
    </td>


    <td>
        {{ $storage_structures_otherData['specification'] ?? '' }}
    </td>
    
      <td>{{ $storage_structures_otherData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $storage_structures_otherData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $storage_structures_otherData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $storage_structures_otherData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $bLonCost = ($storage_structures_otherData['total_investment_cost'] ?? 0) - ($storage_structures_otherData['subsidy_grant'] ?? 0);
    $ssbla_sou = $bLonCost - ($storage_structures_otherData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
       @if($ssbla_sou != 0)
        {{ $ssbla_sou }}
        @endif
    </td>

    <td>
        {{ $storage_structures_otherData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $storage_structures_otherData['economic_useful_life'] ?? '' }}
    </td>
    
     @php
    $resitdatent = ($storage_structures_otherData['total_investment_cost'] ?? 0) * 0.10;
    @endphp


    <td>
        @if($resitdatent != 0)
        {{ $resitdatent }}
        @endif
    </td>
    
    @php
    $anudata = $ssbla_sou/2*12/100;
    @endphp

    <td>
        @if($anudata != 0)
        {{ $anudata }}
        @endif
    </td>
    
    @php
    $anulf_dep = ($storage_structures_otherData['total_investment_cost'] ?? 0) / ($storage_structures_otherData['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($anulf_dep != 0)
        {{ $anulf_dep }}
        @endif
    </td>

    <td>
        {{ $storage_structures_otherData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $storage_structures_otherData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $storage_structures_otherData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    
    @php
    $anulyy_dep = ($storage_structures_otherData['total_investment_cost'] ?? 0) / ($storage_structures_otherData['economic_useful_life'] ?? 1);
    $anudixdCost = $anulyy_dep
    + ($storage_structures_otherData['annual_insurance'] ?? 0)
    + ($storage_structures_otherData['annual_tax'] ?? 0)
    + ($storage_structures_otherData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anudixdCost != 0)
        {{ $anudixdCost }}
        @endif
    </td>
    
    <td>
        {{ $storage_structures_otherData['rental_unit'] ?? '' }}
    </td>
    
    <td>{{ $storage_structures_otherData['rental_rate'] ?? '' }}</td>

    <td>{{ $storage_structures_otherData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                <td style="font-weight:700;">
                Processing Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                <td></td>
                  <td></td>
                    <td></td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
              
                    
                <td></td>
            </tr>
            
            <tr>
    <td style="text-align:center;">
        a
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Wheat Processing Unit
    </td>
    
    <td></td>

    @php
    $wheat_processingData = json_decode($datas->wheat_processing, true);
    @endphp
    <td>
        {{ $wheat_processingData['number'] ?? '' }}
    </td>


    <td>
        {{ $wheat_processingData['specification'] ?? '' }}
    </td>
    
    <td> {{ $wheat_processingData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $wheat_processingData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $wheat_processingData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $wheat_processingData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $banktost = ($wheat_processingData['total_investment_cost'] ?? 0) - ($wheat_processingData['subsidy_grant'] ?? 0);
    $wpbla_sou = $banktost - ($wheat_processingData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
       @if($wpbla_sou != 0)
        {{ $wpbla_sou }}
        @endif
    </td>

    <td>
        {{ $wheat_processingData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $wheat_processingData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resitgrent = ($wheat_processingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($resitgrent != 0)
        {{ $resitgrent }}
        @endif
    </td>
    
    @php
    $anufe = $wpbla_sou/2*12/100;
    @endphp

    <td>
        @if($anufe != 0)
        {{ $anufe }}
        @endif
    </td>
    
    @php
    $anulee_dep = ($wheat_processingData['total_investment_cost'] ?? 0) / ($wheat_processingData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anulee_dep != 0)
        {{ $anulee_dep }}
        @endif
    </td>

    <td>
        {{ $wheat_processingData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $wheat_processingData['annual_tax'] ?? '' }}
    </td>


    <td>
        {{ $wheat_processingData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anultt_dep = ($wheat_processingData['total_investment_cost'] ?? 0) / ($wheat_processingData['economic_useful_life'] ?? 1);
    $anfixdCost = $anultt_dep
    + ($wheat_processingData['annual_insurance'] ?? 0)
    + ($wheat_processingData['annual_tax'] ?? 0)
    + ($wheat_processingData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anfixdCost != 0)
        {{ $anfixdCost }}
        @endif
    </td>
    
    <td>
         {{ $wheat_processingData['rental_unit'] ?? '' }}
    </td>
    
    <td> {{ $wheat_processingData['rental_rate'] ?? '' }}</td>
      
    <td>{{ $wheat_processingData['any_other'] ?? '' }}</td>
</tr>
            
          <tr>
    <td style="text-align:center;">
        b
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Oil Processing Unit
    </td>
    
    <td></td>

    @php
    $oil_processingData = json_decode($datas->oil_processing, true);
    @endphp
    <td>
        {{ $oil_processingData['number'] ?? '' }}
    </td>


    <td>
        {{ $oil_processingData['specification'] ?? '' }}
    </td>
    
      <td>{{ $oil_processingData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $oil_processingData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $oil_processingData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $oil_processingData['subsidy_grant'] ?? '' }}
    </td>
    
     @php
     $bahnCost = ($oil_processingData['total_investment_cost'] ?? 0) - ($oil_processingData['subsidy_grant'] ?? 0);
     $opbla_sou = $bahnCost - ($oil_processingData['balance_source_of_investment'] ?? 0);
     @endphp

    <td>
       @if($opbla_sou != 0)
        {{ $opbla_sou }}
        @endif
    </td>

    <td>
        {{ $oil_processingData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $oil_processingData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resirt = ($oil_processingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resirt != 0)
        {{ $resirt }}
        @endif
    </td>
    
     @php
    $anudd = $opbla_sou/2*12/100;
    @endphp

    <td>
        @if($anudd != 0)
        {{ $anudd }}
        @endif
    </td>
    
    @php
    $anul_dep = ($oil_processingData['total_investment_cost'] ?? 0) / ($oil_processingData['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($anul_dep != 0)
        {{ $anul_dep }}
        @endif
    </td>

    <td>
        {{ $oil_processingData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $oil_processingData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $oil_processingData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anggul_dep = ($oil_processingData['total_investment_cost'] ?? 0) / ($oil_processingData['economic_useful_life'] ?? 1);
    $anddualfixdCost = $anggul_dep
    + ($oil_processingData['annual_insurance'] ?? 0)
    + ($oil_processingData['annual_tax'] ?? 0)
    + ($oil_processingData['annual_repair_and_maintenance'] ?? 0);
    @endphp


    <td>
         @if($anddualfixdCost != 0)
        {{ $anddualfixdCost }}
        @endif
    </td>
    
    <td>
        {{ $oil_processingData['rental_unit'] ?? '' }}
    </td>
      
    <td>{{ $oil_processingData['rental_unit'] ?? '' }}</td>
    
    <td>{{ $oil_processingData['any_other'] ?? '' }}</td>
</tr>

          <tr>
    <td style="text-align:center;">
        c
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Sugarcane Processing Unit
    </td>
    
    <td></td>

    @php
    $sugarcane_processingData = json_decode($datas->sugarcane_processing, true);
    @endphp
    <td>
        {{ $sugarcane_processingData['number'] ?? '' }}
    </td>


    <td>
        {{ $sugarcane_processingData['specification'] ?? '' }}
    </td>
    
      <td>{{ $sugarcane_processingData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $sugarcane_processingData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $sugarcane_processingData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $sugarcane_processingData['subsidy_grant'] ?? '' }}
    </td>
    
       @php
        $banknCost = ($sugarcane_processingData['total_investment_cost'] ?? 0) - ($sugarcane_processingData['subsidy_grant'] ?? 0);
        $spibla_sou = $banknCost - ($sugarcane_processingData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
         @if($spibla_sou != 0)
        {{ $spibla_sou }}
        @endif
    </td>

    <td>
        {{ $sugarcane_processingData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $sugarcane_processingData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resitentee = ($sugarcane_processingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resitentee != 0)
        {{ $resitentee }}
        @endif
    </td>
    
    @php
    $anusw = $spibla_sou/2*12/100;
    @endphp

    <td>
         @if($anusw != 0)
        {{ $anusw }}
        @endif
    </td>
    
    @php
    $ssanul_dep = ($sugarcane_processingData['total_investment_cost'] ?? 0) / ($sugarcane_processingData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($ssanul_dep != 0)
        {{ $ssanul_dep }}
        @endif
    </td>

    <td>
        {{ $sugarcane_processingData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $sugarcane_processingData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $sugarcane_processingData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anuwwl_dep = ($sugarcane_processingData['total_investment_cost'] ?? 0) / ($sugarcane_processingData['economic_useful_life'] ?? 1);
    $anhtfixdCost = $anuwwl_dep
    + ($sugarcane_processingData['annual_insurance'] ?? 0)
    + ($sugarcane_processingData['annual_tax'] ?? 0)
    + ($sugarcane_processingData['annual_repair_and_maintenance'] ?? 0);
    @endphp

   

    <td>
               @if($anhtfixdCost != 0)
        {{ $anhtfixdCost }}
        @endif
    </td>
    <td>
        {{ $sugarcane_processingData['rental_unit'] ?? '' }}
    </td>
      
    <td>{{ $sugarcane_processingData['rental_rate'] ?? '' }}</td>
    
    <td>{{ $sugarcane_processingData['any_other'] ?? '' }}</td>
</tr>
            
             <tr>
    <td style="text-align:center;">
        d
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Dal Processing Unit
    </td>
    
    <td></td>

    @php
    $dal_processingData = json_decode($datas->dal_processing, true);
    @endphp
    <td>
        {{ $dal_processingData['number'] ?? '' }}
    </td>


    <td>
        {{ $dal_processingData['specification'] ?? '' }}
    </td>
    
    <td>{{ $dal_processingData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $dal_processingData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $dal_processingData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $dal_processingData['subsidy_grant'] ?? '' }}
    </td>
    
       @php
        $banffkLonCost = ($dal_processingData['total_investment_cost'] ?? 0) - ($dal_processingData['subsidy_grant'] ?? 0);
        $dpbla_sou = $banffkLonCost - ($dal_processingData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($dpbla_sou != 0)
        {{ $dpbla_sou }}
        @endif
    </td>

    <td>
        {{ $dal_processingData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $dal_processingData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resitdent = ($dal_processingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    
    

    <td>
         @if($resitdent != 0)
        {{ $resitdent }}
        @endif
    </td>
    
    @php
    $anssu = $dpbla_sou/2*12/100;
    @endphp

    <td>
         @if($anssu != 0)
        {{ $anssu }}
        @endif
    </td>

     @php
    $anssul_dep = ($dal_processingData['total_investment_cost'] ?? 0) / ($dal_processingData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
        @if($anssul_dep != 0)
        {{ $anssul_dep }}
        @endif
    </td>

    <td>
        {{ $dal_processingData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $dal_processingData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $dal_processingData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
     @php
    $awnul_dep = ($dal_processingData['total_investment_cost'] ?? 0) / ($dal_processingData['economic_useful_life'] ?? 1);
    $ansalfixdCost = $awnul_dep
    + ($dal_processingData['annual_insurance'] ?? 0)
    + ($dal_processingData['annual_tax'] ?? 0)
    + ($dal_processingData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($ansalfixdCost != 0)
        {{ $ansalfixdCost }}
        @endif
    </td>
    
    <td>{{ $dal_processingData['rental_unit'] ?? '' }}</td>
    <td>{{ $dal_processingData['rental_rate'] ?? '' }}</td>
  
    
    <td>{{ $dal_processingData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        e
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Any Other Processing unit
    </td>
    
    <td></td>

    @php
    $other_processingData = json_decode($datas->other_processing, true);
    @endphp
    <td>
        {{ $other_processingData['number'] ?? '' }}
    </td>


    <td>
        {{ $other_processingData['specification'] ?? '' }}
    </td>
    
      <td>{{ $other_processingData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $other_processingData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $other_processingData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $other_processingData['subsidy_grant'] ?? '' }}
    </td>
    
        @php
        $bangnCost = ($other_processingData['total_investment_cost'] ?? 0) - ($other_processingData['subsidy_grant'] ?? 0);
        $opbla_sou = $bangnCost - ($other_processingData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($opbla_sou != 0)
        {{ $opbla_sou }}
        @endif
    </td>

    <td>
        {{ $other_processingData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $other_processingData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $refetent = ($other_processingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($refetent != 0)
        {{ $refetent }}
        @endif
    </td>
    
    @php
    $awednu = $opbla_sou/2*12/100;
    @endphp

    <td>
        @if($awednu != 0)
        {{ $awednu }}
        @endif
    </td>
    
    @php
    $andeul_dep = ($other_processingData['total_investment_cost'] ?? 0) / ($other_processingData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($andeul_dep != 0)
        {{ $andeul_dep }}
        @endif
    </td>

    <td>
        {{ $other_processingData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $other_processingData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $other_processingData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anuldddep = ($other_processingData['total_investment_cost'] ?? 0) / ($other_processingData['economic_useful_life'] ?? 1);
    $anutixdCost = $anuldddep
    + ($other_processingData['annual_insurance'] ?? 0)
    + ($other_processingData['annual_tax'] ?? 0)
    + ($other_processingData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anutixdCost != 0)
        {{ $anutixdCost }}
        @endif
    </td>
    
    <td>{{ $other_processingData['rental_unit'] ?? '' }}</td>
    <td>{{ $other_processingData['rental_rate'] ?? '' }}</td>
    
    <td>{{ $other_processingData['any_other'] ?? '' }}</td>
</tr>
            
              <tr>
                <td style="text-align:center;">
                    5
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td style="font-weight:700;">
                 Marketing Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
    <td style="text-align:center;">
        a
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Kiran Outlets
    </td>
    
    <td></td>

    @php
    $kiran_outletsData = json_decode($datas->kiran_outlets, true);
    @endphp
    <td>
        {{ $kiran_outletsData['number'] ?? '' }}
    </td>


    <td>
        {{ $kiran_outletsData['specification'] ?? '' }}
    </td>
    
      <td> {{ $kiran_outletsData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $kiran_outletsData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $kiran_outletsData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $kiran_outletsData['subsidy_grant'] ?? '' }}
    </td>
    
      @php
        $bronCost = ($kiran_outletsData['total_investment_cost'] ?? 0) - ($kiran_outletsData['subsidy_grant'] ?? 0);
        $kobla_sou = $bronCost - ($kiran_outletsData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
       @if($kobla_sou != 0)
        {{ $kobla_sou }}
        @endif
    </td>

    <td>
        {{ $kiran_outletsData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $kiran_outletsData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resiterrnt = ($kiran_outletsData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resiterrnt != 0)
        {{ $resiterrnt }}
        @endif
    </td>
    
    @php
    $anuee = $kobla_sou/2*12/100;
    @endphp

    <td>
         @if($anuee != 0)
        {{ $anuee }}
        @endif
    </td>
    
    
    @php
    $anuttdep = ($kiran_outletsData['total_investment_cost'] ?? 0) / ($kiran_outletsData['economic_useful_life'] ?? 1);
    @endphp

    <td>
      @if($anuttdep != 0)
        {{ $anuttdep }}
     @endif
    </td>

    <td>
        {{ $kiran_outletsData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $kiran_outletsData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $kiran_outletsData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anulff_dep = ($kiran_outletsData['total_investment_cost'] ?? 0) / ($kiran_outletsData['economic_useful_life'] ?? 1);
    $anualfixdCost = $anulff_dep
    + ($kiran_outletsData['annual_insurance'] ?? 0)
    + ($kiran_outletsData['annual_tax'] ?? 0)
    + ($kiran_outletsData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
     @if($anualfixdCost != 0)
        {{ $anualfixdCost }}
     @endif
    </td>
    
    <td>
        {{ $kiran_outletsData['rental_unit'] ?? '' }}
    </td>
    
    <td>{{ $kiran_outletsData['rental_rate'] ?? '' }}</td>
   
    <td>{{ $kiran_outletsData['any_other'] ?? '' }}</td>
</tr>
            
          <tr>
    <td style="text-align:center;">
        b
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Grocery Outlets
    </td>
    
    <td></td>

    @php
    $grossary_outletsData = json_decode($datas->grossary_outlets, true);
    @endphp
    <td>
        {{ $grossary_outletsData['number'] ?? '' }}
    </td>


    <td>
        {{ $grossary_outletsData['specification'] ?? '' }}
    </td>
    
      <td> {{ $grossary_outletsData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $grossary_outletsData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $grossary_outletsData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $grossary_outletsData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
    $bannCost = ($grossary_outletsData['total_investment_cost'] ?? 0) - ($grossary_outletsData['subsidy_grant'] ?? 0);
    $gobla_sou = $bannCost - ($grossary_outletsData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($gobla_sou != 0)
        {{ $gobla_sou }}
        @endif
    </td>

    <td>
        {{ $grossary_outletsData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $grossary_outletsData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resieetent = ($grossary_outletsData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resieetent != 0)
        {{ $resieetent }}
        @endif
    </td>
    
    @php
    $ddanu = $gobla_sou/2*12/100;
    @endphp

    <td>
        @if($ddanu != 0)
        {{ $ddanu }}
        @endif
    </td>
    
    @php
    $anuyyl_dep = ($grossary_outletsData['total_investment_cost'] ?? 0) / ($grossary_outletsData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anuyyl_dep != 0)
        {{ $anuyyl_dep }}
        @endif
    </td>

    <td>
        {{ $grossary_outletsData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $grossary_outletsData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $grossary_outletsData['annual_repair_and_maintenance'] ?? '' }}
    </td>

    
    @php
    $anuld_dep = ($grossary_outletsData['total_investment_cost'] ?? 0) / ($grossary_outletsData['economic_useful_life'] ?? 1);
    $anualrrdCost = $anuld_dep
    + ($grossary_outletsData['annual_insurance'] ?? 0)
    + ($grossary_outletsData['annual_tax'] ?? 0)
    + ($grossary_outletsData['annual_repair_and_maintenance'] ?? 0);
    @endphp
  

    <td>
        @if($anualrrdCost != 0)
        {{ $anualrrdCost }}
        @endif
    </td>
    <td>
         {{ $grossary_outletsData['rantel_unit'] ?? '' }}
    </td>
     
    <td> {{ $grossary_outletsData['rantel_rate'] ?? '' }}</td>
    <td>{{ $grossary_outletsData['any_other'] ?? '' }}</td>
</tr>
            
            
            <tr>
    <td style="text-align:center;">
        c
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Any Other Retail outlets
    </td>
    
    <td></td>

    @php
    $other_outletsData = json_decode($datas->other_outlets, true);
    @endphp
    <td>
        {{ $other_outletsData['number'] ?? '' }}
    </td>


    <td>
        {{ $other_outletsData['specification'] ?? '' }}
    </td>
    
      <td>{{ $other_outletsData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $other_outletsData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $other_outletsData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $other_outletsData['subsidy_grant'] ?? '' }}
    </td>
    
      @php
        $bankLttCost = ($other_outletsData['total_investment_cost'] ?? 0) - ($other_outletsData['subsidy_grant'] ?? 0);
        $oobla_sou = $bankLttCost - ($other_outletsData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
         @if($oobla_sou != 0)
        {{ $oobla_sou }}
        @endif
    </td>

    <td>
        {{ $other_outletsData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $other_outletsData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resihuir = ($other_outletsData['total_investment_cost'] ?? 0) * 0.10;
    @endphp


    <td>
       @if($resihuir != 0)
        {{ $resihuir }}
        @endif
    </td>
    
     @php
    $anuss = $oobla_sou/2*12/100;
    @endphp

    <td>
        @if($anuss != 0)
        {{ $anuss }}
        @endif
    </td>
    
    @php
    $anfgrl_dep = ($other_outletsData['total_investment_cost'] ?? 0) / ($other_outletsData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anfgrl_dep != 0)
        {{ $anfgrl_dep }}
        @endif
    </td>

    <td>
        {{ $other_outletsData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $other_outletsData['annual_tax'] ?? '' }}
    </td>

  

    <td>
        {{ $other_outletsData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
     @php
    $anuleee_dep = ($other_outletsData['total_investment_cost'] ?? 0) / ($other_outletsData['economic_useful_life'] ?? 1);
    $anualxdCost = $anuleee_dep
    + ($other_outletsData['annual_insurance'] ?? 0)
    + ($other_outletsData['annual_tax'] ?? 0)
    + ($other_outletsData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualxdCost != 0)
        {{ $anualxdCost }}
        @endif
    </td>
    
    <td>
        {{ $other_outletsData['rental_unit'] ?? '' }}
    </td>
   
    <td> {{ $other_outletsData['rental_rate'] ?? '' }}</td>
    <td>{{ $other_outletsData['any_other'] ?? '' }}</td>
</tr>
            
            <tr>
                <td style="text-align:center;">
                    6
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                
                <td style="font-weight:700;">
                 Farm Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                        
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
    <td style="text-align:center;">
        a
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Shed (Kuchha)
    </td>
    
    <td></td>

    @php
    $shed_kuchhaData = json_decode($datas->shed_kuchha, true);
    @endphp
    <td>
        {{ $shed_kuchhaData['number'] ?? '' }}
    </td>


    <td>
        {{ $shed_kuchhaData['specification'] ?? '' }}
    </td>
    
      <td> {{ $shed_kuchhaData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $shed_kuchhaData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $shed_kuchhaData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $shed_kuchhaData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
        $banCost = ($shed_kuchhaData['total_investment_cost'] ?? 0) - ($shed_kuchhaData['subsidy_grant'] ?? 0);
        $skbla_sou = $banCost - ($shed_kuchhaData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
         @if($skbla_sou != 0)
        {{ $skbla_sou }}
        @endif
    </td>

    <td>
        {{ $shed_kuchhaData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $shed_kuchhaData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resirr = ($shed_kuchhaData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resirr != 0)
        {{ $resirr }}
        @endif
    </td>
    
     @php
    $anuueu = $skbla_sou/2*12/100;
    @endphp

    <td>
        @if($anuueu != 0)
        {{ $anuueu }}
        @endif
    </td>

    @php
    $anul_deprr = ($shed_kuchhaData['total_investment_cost'] ?? 0) / ($shed_kuchhaData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
         @if($anul_deprr != 0)
        {{ $anul_deprr }}
        @endif
    </td>

    <td>
        {{ $shed_kuchhaData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $shed_kuchhaData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $shed_kuchhaData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anul_deps = ($shed_kuchhaData['total_investment_cost'] ?? 0) / ($shed_kuchhaData['economic_useful_life'] ?? 1);
    $anuarsdCost = $anul_deps
    + ($shed_kuchhaData['annual_insurance'] ?? 0)
    + ($shed_kuchhaData['annual_tax'] ?? 0)
    + ($shed_kuchhaData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anuarsdCost != 0)
        {{ $anuarsdCost }}
        @endif
    </td>
    <td>
         {{ $shed_kuchhaData['rental_unit'] ?? '' }}
    </td>
    <td> {{ $shed_kuchhaData['rental_rate'] ?? '' }}</td>
      
    <td>{{ $shed_kuchhaData['any_other'] ?? '' }}</td>
</tr>
            
 <tr>
    <td style="text-align:center;">
        b
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Shed (Pucca)
    </td>
    
    <td></td>

    @php
    $shed_puccaData = json_decode($datas->shed_pucca, true);
    @endphp
    <td>
        {{ $shed_puccaData['number'] ?? '' }}
    </td>


    <td>
        {{ $shed_puccaData['specification'] ?? '' }}
    </td>
    
    <td>{{ $shed_puccaData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $shed_puccaData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $shed_puccaData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $shed_puccaData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
        $baronCost = ($shed_puccaData['total_investment_cost'] ?? 0) - ($shed_puccaData['subsidy_grant'] ?? 0);
        $spbla_sou = $baronCost - ($shed_puccaData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($spbla_sou != 0)
        {{ $spbla_sou }}
        @endif
    </td>

    <td>
        {{ $shed_puccaData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $shed_puccaData['economic_useful_life'] ?? '' }}
    </td>
    
      @php
    $resiteddnt = ($shed_puccaData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
       @if($resiteddnt != 0)
        {{ $resiteddnt }}
        @endif
    </td>
    
       @php
    $anudf = $spbla_sou/2*12/100;
    @endphp

    <td>
         @if($anudf != 0)
        {{ $anudf }}
        @endif
    </td>
    
      @php
    $anul_dddep = ($shed_puccaData['total_investment_cost'] ?? 0) / ($shed_puccaData['economic_useful_life'] ?? 1);
    @endphp

    <td>
          @if($anul_dddep != 0)
        {{ $anul_dddep }}
        @endif
    </td>

    <td>
        {{ $shed_puccaData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $shed_puccaData['annual_tax'] ?? '' }}
    </td>

   

    <td>
        {{ $shed_puccaData['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
      @php
    $anuffl_dep = ($shed_puccaData['total_investment_cost'] ?? 0) / ($shed_puccaData['economic_useful_life'] ?? 1);
    $anuxdCost = $anuffl_dep
    + ($shed_puccaData['annual_insurance'] ?? 0)
    + ($shed_puccaData['annual_tax'] ?? 0)
    + ($shed_puccaData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anuxdCost != 0)
        {{ $anuxdCost }}
        @endif
    </td>
    
    <td>
          {{ $shed_puccaData['rental_unit'] ?? '' }}
    </td>
   
    <td>  {{ $shed_puccaData['rental_rate'] ?? '' }}</td>
    
    <td>{{ $shed_puccaData['any_other'] ?? '' }}</td>
</tr>

            <tr>
                <td style="text-align:center;">
                    7
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                
                <td style="font-weight:700;">
                 Investment under Plantation Crop (crop period more than 18 months) 
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                        
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>   
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                
             
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                   <td>
                 Name of Plantation Crop (Example : Tea, Apple, Mango, Orange, etc.)
                </td>
                
                <td></td>
               @php
    $name_plantationdata = json_decode($datas->name_plantation, true);
    @endphp
    <td>
        {{ $name_plantationdata['number'] ?? '' }}
    </td>


    <td>
        {{ $name_plantationdata['specification'] ?? '' }}
    </td>

    <td>{{ $name_plantationdata['specification_unit'] ?? '' }}</td>

    <td>
        {{ $name_plantationdata['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $name_plantationdata['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $name_plantationdata['subsidy_grant'] ?? '' }}
    </td>
    
        @php
        $bankLrst = ($name_plantationdata['total_investment_cost'] ?? 0) - ($name_plantationdata['subsidy_grant'] ?? 0);
        $npbla_sou = $bankLrst - ($name_plantationdata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
         @if($npbla_sou != 0)
        {{ $npbla_sou }}
        @endif
    </td>

    <td>
        {{ $name_plantationdata['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $name_plantationdata['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $rdata = ($name_plantationdata['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($rdata != 0)
        {{ $rdata }}
        @endif
    </td>
    
     @php
    $anurr = $npbla_sou/2*12/100;
    @endphp

    <td>
         @if($anurr != 0)
        {{ $anurr }}
        @endif
    </td>
    
    @php
    $anussrr = ($name_plantationdata['total_investment_cost'] ?? 0) / ($name_plantationdata['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anussrr != 0)
        {{ $anussrr }}
        @endif
    </td>

    <td>
        {{ $name_plantationdata['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $name_plantationdata['annual_tax'] ?? '' }}
    </td>



    <td>
        {{ $name_plantationdata['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anulss_dep = ($name_plantationdata['total_investment_cost'] ?? 0) / ($name_plantationdata['economic_useful_life'] ?? 1);
    $anualfisCost = $anulss_dep
    + ($name_plantationdata['annual_insurance'] ?? 0)
    + ($name_plantationdata['annual_tax'] ?? 0)
    + ($name_plantationdata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualfisCost != 0)
        {{ $anualfisCost }}
        @endif
    </td>

    <td>
        {{ $name_plantationdata['rental_unit'] ?? '' }}
    </td>

    <td> {{ $name_plantationdata['rental_rate'] ?? '' }}</td>

    <td>{{ $name_plantationdata['any_other'] ?? '' }}</td>
            </tr>    

            <tr>
                <td style="text-align:center;">
                    b
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                <td>
                 Cost of Plantation
                </td>
                
                <td></td>
                
               @php
    $cost_pantationdata = json_decode($datas->cost_pantation, true);
    @endphp
    <td>
        {{ $cost_pantationdata['number'] ?? '' }}
    </td>


    <td>
        {{ $cost_pantationdata['specification'] ?? '' }}
    </td>

    <td>{{ $cost_pantationdata['specification_unit'] ?? '' }}</td>

    <td>
        {{ $cost_pantationdata['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $cost_pantationdata['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $cost_pantationdata['subsidy_grant'] ?? '' }}
    </td>
    
        @php
        $bankLonst = ($cost_pantationdata['total_investment_cost'] ?? 0) - ($cost_pantationdata['subsidy_grant'] ?? 0);
        $cpbla_sou = $bankLonst - ($cost_pantationdata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($cpbla_sou != 0)
        {{ $cpbla_sou }}
        @endif
    </td>

    <td>
        {{ $cost_pantationdata['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $cost_pantationdata['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resitentdat = ($cost_pantationdata['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resitentdat != 0)
        {{ $resitentdat }}
        @endif
    </td>
    
    @php
    $anudd = $cpbla_sou/2*12/100;
    @endphp

    <td>
        @if($anudd != 0)
        {{ $anudd }}
        @endif
    </td>
    
    @php
    $anufiue = ($cost_pantationdata['total_investment_cost'] ?? 0) / ($cost_pantationdata['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anufiue != 0)
        {{ $anufiue }}
        @endif
    </td>

    <td>
        {{ $cost_pantationdata['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $cost_pantationdata['annual_tax'] ?? '' }}
    </td>



    <td>
        {{ $cost_pantationdata['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
     @php
    $anurdep = ($cost_pantationdata['total_investment_cost'] ?? 0) / ($cost_pantationdata['economic_useful_life'] ?? 1);
    $anualfrdCost = $anurdep
    + ($cost_pantationdata['annual_insurance'] ?? 0)
    + ($cost_pantationdata['annual_tax'] ?? 0)
    + ($cost_pantationdata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualfrdCost != 0)
        {{ $anualfrdCost }}
        @endif
    </td>

    <td>
        {{ $cost_pantationdata['rental_unit'] ?? '' }}
    </td>

    <td> {{ $cost_pantationdata['rental_rate'] ?? '' }}</td>

    <td>{{ $cost_pantationdata['any_other'] ?? '' }}</td>
            </tr>  
            
              <tr>
                <td style="text-align:center;">
                    c
                </td>
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Cost Infrastructure and Support Services
                </td>
                <td></td>
               @php
    $Infrastructuredata = json_decode($datas->Infrastructure, true);
    @endphp
    <td>
        {{ $Infrastructuredata['number'] ?? '' }}
    </td>


    <td>
        {{ $Infrastructuredata['specification'] ?? '' }}
    </td>

    <td>{{ $Infrastructuredata['specification_unit'] ?? '' }}</td>

    <td>
        {{ $Infrastructuredata['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $Infrastructuredata['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $Infrastructuredata['subsidy_grant'] ?? '' }}
    </td>
    
        @php
        $bankLoninfaCost = ($Infrastructuredata['total_investment_cost'] ?? 0) - ($Infrastructuredata['subsidy_grant'] ?? 0);
        $inbla_sou = $bankLoninfaCost - ($Infrastructuredata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($inbla_sou != 0)
        {{ $inbla_sou }}
        @endif
    </td>

    <td>
        {{ $Infrastructuredata['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $Infrastructuredata['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resitentfdf = ($Infrastructuredata['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resitentfdf != 0)
        {{ $resitentfdf }}
        @endif
    </td>
    
    @php
    $anuda = $inbla_sou/2*12/100;
    @endphp

    <td>
        @if($anuda != 0)
        {{ $anuda }}
        @endif
    </td>
    
    @php
    $anul_depdd = ($Infrastructuredata['total_investment_cost'] ?? 0) / ($Infrastructuredata['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anul_depdd != 0)
        {{ $anul_depdd }}
        @endif
    </td>

    <td>
        {{ $Infrastructuredata['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $Infrastructuredata['annual_tax'] ?? '' }}
    </td>



    <td>
        {{ $Infrastructuredata['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anuldata_dep = ($Infrastructuredata['total_investment_cost'] ?? 0) / ($Infrastructuredata['economic_useful_life'] ?? 1);
    $anualfixdCosts = $anuldata_dep
    + ($Infrastructuredata['annual_insurance'] ?? 0)
    + ($Infrastructuredata['annual_tax'] ?? 0)
    + ($Infrastructuredata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualfixdCosts != 0)
{{ $anualfixdCosts }}
@endif
    </td>

    <td>
        {{ $Infrastructuredata['rental_unit'] ?? '' }}
    </td>

    <td> {{ $Infrastructuredata['rental_rate'] ?? '' }}</td>

    <td>{{ $Infrastructuredata['any_other'] ?? '' }}</td>
            </tr>  
            
               <tr>
                <td style="text-align:center;">
                    d
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Cost of other material
                </td>
                
                <td></td>
                @php
    $materialdata = json_decode($datas->material, true);
    @endphp
    <td>
        {{ $materialdata['number'] ?? '' }}
    </td>


    <td>
        {{ $materialdata['specification'] ?? '' }}
    </td>

    <td>{{ $materialdata['specification_unit'] ?? '' }}</td>

    <td>
        {{ $materialdata['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $materialdata['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $materialdata['subsidy_grant'] ?? '' }}
    </td>
    @php
        $banknCost = ($materialdata['total_investment_cost'] ?? 0) - ($materialdata['subsidy_grant'] ?? 0);
        $mabla_sou = $banknCost - ($materialdata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
         @if($mabla_sou != 0)
        {{ $mabla_sou }}
        @endif
    </td>

    <td>
        {{ $materialdata['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $materialdata['economic_useful_life'] ?? '' }}
    </td>
    
     @php
    $resitentfw = ($materialdata['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    

    <td>
        @if($resitentfw != 0)
        {{ $resitentfw }}
        @endif
    </td>
    
    @php
    $anurr = $mabla_sou/2*12/100;
    @endphp

    <td>
       @if($anurr != 0)
        {{ $anurr }}
        @endif
    </td>
    
    @php
    $anulda_dep = ($materialdata['total_investment_cost'] ?? 0) / ($materialdata['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anulda_dep != 0)
        {{ $anulda_dep }}
        @endif
    </td>

    <td>
        {{ $materialdata['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $materialdata['annual_tax'] ?? '' }}
    </td>



    <td>
        {{ $materialdata['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anulrer_dep = ($materialdata['total_investment_cost'] ?? 0) / ($materialdata['economic_useful_life'] ?? 1);
    $anualfixdCosst = $anulrer_dep
    + ($materialdata['annual_insurance'] ?? 0)
    + ($materialdata['annual_tax'] ?? 0)
    + ($materialdata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anualfixdCosst != 0)
{{ $anualfixdCosst }}
@endif
    </td>

    <td>
        {{ $materialdata['rental_unit'] ?? '' }}
    </td>

    <td> {{ $materialdata['rental_rate'] ?? '' }}</td>

    <td>{{ $materialdata['any_other'] ?? '' }}</td>
            </tr>  
            
               <tr>
                <td style="text-align:center;">
                    e
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Cost Labour / mechanization
                </td>
                <td></td>
               @php
    $labour_mechanizationdata = json_decode($datas->labour_mechanization, true);
    @endphp
    <td>
        {{ $labour_mechanizationdata['number'] ?? '' }}
    </td>


    <td>
        {{ $labour_mechanizationdata['specification'] ?? '' }}
    </td>

    <td>{{ $labour_mechanizationdata['specification_unit'] ?? '' }}</td>

    <td>
        {{ $labour_mechanizationdata['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $labour_mechanizationdata['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $labour_mechanizationdata['subsidy_grant'] ?? '' }}
    </td>
    
    @php
        $bankLonCostsa = ($labour_mechanizationdata['total_investment_cost'] ?? 0) - ($labour_mechanizationdata['subsidy_grant'] ?? 0);
        $bla_souds = $bankLonCostsa - ($labour_mechanizationdata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
      @if($bla_souds != 0)
        {{ $bla_souds }}
        @endif
    </td>

    <td>
        {{ $labour_mechanizationdata['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $labour_mechanizationdata['economic_useful_life'] ?? '' }}
    </td>
    @php
    $resitenttion = ($labour_mechanizationdata['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    
    @if($resitenttion != 0)
        {{ $resitenttion }}
        @endif

    <td>
        {{ $labour_mechanizationdata['residual_value_of_asset'] ?? '' }}
    </td>

    <td>
        {{ $labour_mechanizationdata['annual_interest_on_bank_loan'] ?? '' }}
    </td>

    <td>
        {{ $labour_mechanizationdata['annual_depreciation'] ?? '' }}
    </td>

    <td>
        {{ $labour_mechanizationdata['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $labour_mechanizationdata['annual_tax'] ?? '' }}
    </td>



    <td>
        {{ $labour_mechanizationdata['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anulfda_dep = ($labour_mechanizationdata['total_investment_cost'] ?? 0) / ($labour_mechanizationdata['economic_useful_life'] ?? 1);
    $anualfixdCostlm = $anulfda_dep
    + ($labour_mechanizationdata['annual_insurance'] ?? 0)
    + ($labour_mechanizationdata['annual_tax'] ?? 0)
    + ($labour_mechanizationdata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
      @if($anualfixdCostlm != 0)
{{ $anualfixdCostlm }}
@endif
    </td>

    <td>
        {{ $labour_mechanizationdata['rental_unit'] ?? '' }}
    </td>

    <td> {{ $labour_mechanizationdata['rental_rate'] ?? '' }}</td>

    <td>{{ $labour_mechanizationdata['any_other'] ?? '' }}</td>
            </tr>  
            
             <tr>
                <td style="text-align:center;">
                    f
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Any other Fixed Cost
                </td>
                
                <td></td>
                
           @php
    $fixed_costdata = json_decode($datas->fixed_cost, true);
    @endphp
    <td>
        {{ $fixed_costdata['number'] ?? '' }}
    </td>


    <td>
        {{ $fixed_costdata['specification'] ?? '' }}
    </td>

    <td>{{ $fixed_costdata['specification_unit'] ?? '' }}</td>

    <td>
        {{ $fixed_costdata['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $fixed_costdata['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $fixed_costdata['subsidy_grant'] ?? '' }}
    </td>
    
    @php
        $bankLonCostfix = ($fixed_costdata['total_investment_cost'] ?? 0) - ($fixed_costdata['subsidy_grant'] ?? 0);
        $fxbla_sou = $bankLonCostfix - ($fixed_costdata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
       @if($fxbla_sou != 0)
        {{ $fxbla_sou }}
        @endif
    </td>

    <td>
        {{ $fixed_costdata['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $fixed_costdata['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resitentfix = ($fixed_costdata['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
       @if($resitentfix != 0)
        {{ $resitentfix }}
        @endif
    </td>
    
    @php
    $anufix = $fxbla_sou/2*12/100;
    @endphp

    <td>
         @if($anufix != 0)
        {{ $anufix }}
        @endif
    </td>
    
      @php
    $anulgg_dep = ($fixed_costdata['total_investment_cost'] ?? 0) / ($fixed_costdata['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($anulgg_dep != 0)
        {{ $anulgg_dep }}
        @endif
    </td>

    <td>
        {{ $fixed_costdata['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $fixed_costdata['annual_tax'] ?? '' }}
    </td>



    <td>
        {{ $fixed_costdata['annual_repair_and_maintenance'] ?? '' }}
    </td>
    
    @php
    $anul_deps = ($fixed_costdata['total_investment_cost'] ?? 0) / ($fixed_costdata['economic_useful_life'] ?? 1);
    $anualfixdCostfix = $anul_deps
    + ($fixed_costdata['annual_insurance'] ?? 0)
    + ($fixed_costdata['annual_tax'] ?? 0)
    + ($fixed_costdata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualfixdCostfix != 0)
        {{ $anualfixdCostfix }}
        @endif
    </td>

    <td>
        {{ $fixed_costdata['rental_unit'] ?? '' }}
    </td>

    <td> {{ $fixed_costdata['rental_rate'] ?? '' }}</td>

    <td>{{ $fixed_costdata['any_other'] ?? '' }}</td>
            </tr>  
            
             <tr>
    <td style="text-align:center;">
        8
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Any other infrastructure
    </td>
    
    <td></td>

    @php
    $other_infrastructureData = json_decode($datas->other_infrastructure, true);
    @endphp
    <td>
        {{ $other_infrastructureData['number'] ?? '' }}
    </td>


    <td>
        {{ $other_infrastructureData['specification'] ?? '' }}
    </td>
    
     <td>{{ $other_infrastructureData['specification_unit'] ?? '' }}</td>

    <td>
        {{ $other_infrastructureData['year_of_asset_creation'] ?? '' }}
    </td>

    <td>
        {{ $other_infrastructureData['total_investment_cost'] ?? '' }}
    </td>

    <td>
        {{ $other_infrastructureData['subsidy_grant'] ?? '' }}
    </td>
    
    @php
        $bankLonCostot = ($other_infrastructureData['total_investment_cost'] ?? 0) - ($other_infrastructureData['subsidy_grant'] ?? 0);
        $otbla_sou = $bankLonCostot - ($other_infrastructureData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($otbla_sou != 0)
        {{ $otbla_sou }}
        @endif
    </td>

    <td>
        {{ $other_infrastructureData['balance_source_of_investment'] ?? '' }}
    </td>

    <td>
        {{ $other_infrastructureData['economic_useful_life'] ?? '' }}
    </td>
    
    @php
    $resitentot = ($other_infrastructureData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($resitentot != 0)
        {{ $resitentot }}
        @endif
    </td>
    
     @php
    $anuot = $otbla_sou/2*12/100;
    @endphp

    <td>
        @if($anuot != 0)
        {{ $anuot }}
        @endif
    </td>
    
    @php
    $anul_depot = ($other_infrastructureData['total_investment_cost'] ?? 0) / ($other_infrastructureData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anul_depot != 0)
        {{ $anul_depot }}
        @endif
    </td>

    <td>
        {{ $other_infrastructureData['annual_insurance'] ?? '' }}
    </td>

    <td>
        {{ $other_infrastructureData['annual_tax'] ?? '' }}
    </td>

    <td>
        {{ $other_infrastructureData['annual_repair_and_maintenance'] ?? '' }}
    </td>

 @php
    $anul_depoh = ($other_infrastructureData['total_investment_cost'] ?? 0) / ($other_infrastructureData['economic_useful_life'] ?? 1);
    $anualfixdCostoh = $anul_depoh
    + ($other_infrastructureData['annual_insurance'] ?? 0)
    + ($other_infrastructureData['annual_tax'] ?? 0)
    + ($other_infrastructureData['annual_repair_and_maintenance'] ?? 0);
    @endphp
  

    <td>
         @if($anualfixdCostoh != 0)
        {{ $anualfixdCostoh }}
        @endif
    </td>
    <td>
         {{ $other_infrastructureData['rental_unit'] ?? '' }}
    </td>
     
       
    <td>{{ $other_infrastructureData['rental_rate'] ?? '' }}</td>
     <td>{{ $other_infrastructureData['any_other'] ?? '' }}</td>
</tr>
            
        </table>
        @endforeach
        @else
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
           
            <tr>
                <th style="text-align:center;">
                 S. No.
                </th>
                 <th>FARMER ID</th>
                 <th>Farmer Name</th>
                <th>
                   Infrastructure and Support Services
                </th>
                
                 <th>
                   YES/No
                </th>
                
                <th>
                    Number
                </th>
                
                <th>
                    Specification
                </th>
                
                <th>
                  Year of Asset creation (DD/MM/YY)
                </th>
                
                <th>
                    Total Investment/ Cost (Rs.)
                </th>
                
                <th>
                    Subsidy / Grant (Rs.)
                </th>
                
                <th>
                    Bank Loan Cost (Rs.)
                </th>
                
                  <th>
                    Balance Source of Investment (Rs.)
                </th>
                
                  <th>
                   Economic / Useful  Life (Year)
                </th>
                
                  <th>
                    Residual Value of Asset (Rs.)
                </th>
                
                  <th>
                    Annual Interest on Bank Loan(Rs.)
                </th>
                
                  <th>
                    Annual Depreciation (Rs.)
                </th>
                
                  <th>
                    Annual Insurance (Rs.)
                </th>
                
                  <th>
                    Annual Tax (Rs.)
                </th>
                
                  <th>
                   Annual Repair and Maintenance (Rs.)  
                </th>
                
                  <th>
                    Annual Repair and Maintenance (Rs.)
                </th>
                
                  <th>
                    Annual Fixed cost of Asset (Rs.)
                </th>
                
                  <th>
                    Rental Unit of Farm Asset in Cluster Area ( per hour/ per unit area per day / month / year ) 
                </th>
                
                  <th>
                    Rental Rate of Farm Asset in Cluster Area (Rs.) 
                </th>
                
                  <th>
                    Any Other
                </th>
                
            </tr>
        
            
            <tr>
                <td style="text-align:center;">
                    1
                </td>
                
                
            
                <td>
                   
                </td>
             
               
                <td>
                </td>
                

                <td style="font-weight:700;">
                    Irrigation Infrastructure
                </td>
                
                <td>0 for no 1 for yes</td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                <td>
                    Canal
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
              <td></td>
                <td></td>
            </tr>

            <tr>

                 <td style="text-align:center;">
                    b
                </td>
                <td>
                   
                </td>
                
                <td>
                  
                </td>
               
                <td>
                   Tubewell
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td></td>
                <td></td>
            </tr>

            <tr>
               <td style="text-align:center;">
                    c
                </td>
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 
                <td>
                   Engine / Motor / Solar
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                <td>
                   Pump sets ( Diesel/ electric/ Solar)
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    e
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                   Pond
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                 <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    f
                </td>
                
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                <td>
                  Sprinkler / drip irrigation System
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    g
                </td>
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                  Pump House
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    h
                </td>
                
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                <td>
                  Other
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    2
                </td>

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td style="font-weight:700;">
                  Farm Mechanization Infrastructure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                 <td>
                  Tractor
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                  Power Tiller
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                  Cultivator
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td>
                 Rotator
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    e
                </td>
               
                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                 <td>
                 Harrow
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    f
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td>
                 Leveller
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>

             <tr>
                <td style="text-align:center;">
                    g
                </td>

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td>
                 Plough (MB Plough / Disc Plough)
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    h
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Seed drill
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td> 
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    i
                </td>
             
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                   <td>
                 Seed Planter
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>

             <tr>
                <td style="text-align:center;">
                    j
                </td>

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td>
                 Seed cum fertilizer drill
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    k
                </td>
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Trolley
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    l
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Reaper cum binder
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    m
                </td>
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Husk Making Machine
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    n
                </td>
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Thresher
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
            </tr>
            
               <tr>
                <td style="text-align:center;">
                    o
                </td>
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Combine Harvester
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    p
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                Other
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td style="font-weight:700;">
                Storage Infrastructure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                Kothila / Deshi Storage Structure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    b
                </td>
             
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                   <td>
                Godown
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
            
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                    <td>
                Clod Storage
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>
                
                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                <td>
               Bulk Cooling Unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    e
                </td>
               
                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                 <td>
               Storage for fodder
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    f
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td>
                Other
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td style="font-weight:700;">
                Processing Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td>
                Wheat Processing Unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
                

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td>
                 Oil Processing Unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td>
                 Sugarcane Processing Unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    d
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Dal Processing Unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    e
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Any Other Processing unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    5
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td style="font-weight:700;">
                 Marketing Infrastructure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    a
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Kiran Outlets
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Grocery Outlets
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    c
                </td>
                
             
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                   <td>
                 Any Other Retail outlets
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    6
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td style="font-weight:700;">
                 Farm Infrastructure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
               <tr>
                <td style="text-align:center;">
                    a
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Shed (Kuchha)
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Shed (Pucca)
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>    
            
            <tr>
                <td style="text-align:center;">
                    7
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td style="font-weight:700;">
                 Investment under Plantation Crop (crop period more than 18 months) 
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>   
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                
             
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                   <td>
                 Name of Plantation Crop (Example : Tea, Apple, Mango, Orange, etc.)
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>    

            <tr>
                <td style="text-align:center;">
                    b
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td>
                 Cost of Plantation
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
              <tr>
                <td style="text-align:center;">
                    c
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Cost Infrastructure and Support Services
                </td>
                <td></td>
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
               <tr>
                <td style="text-align:center;">
                    d
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Cost of other material
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
               <tr>
                <td style="text-align:center;">
                    e
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Cost Labour / mechanization
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
             <tr>
                <td style="text-align:center;">
                    f
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Any other Fixed Cost
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
             <tr>
                <td style="text-align:center;">
                    8
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td style="font-weight:700;">
                 Any other infrastructure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
        </table>
        @endif
               
               
        </div>
    </div>
    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>
@endsection