
@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-3">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            
            <div class="col-lg-9">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.one.update') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <a href="{{ route('anexure.one') }}" class="btn btn-primary btn-sm">Back</a>
                </form>
            </div>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Anexure List Two</h1>
        </div>
        
            
        @if($data->isNotEmpty())  
        
        @foreach($data as $datas)
        <form>
            @csrf
            <input type="hidden" name="data_id" id="data_id" value="">
            <input type="hidden" name="farmer_id" id="farmer_id" value="">
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
            <tr>
                <th style="text-align:center;">
                 S. No.
                </th>
                 <th>FARMER CODE</th>
                 <th>Farmer Name</th>
                <th>
                   Infrastructure and Support Services
                </th>
                
                <th>
                   YES/No
                </th>
                
                <th>
                    Number
                </th>
                
                <th>
                    Specification
                </th>
                
                <th>
                    Specification Unit
                </th>
                
                <th>
                  Year of Asset creation (DD/MM/YY)
                </th>
                
                <th>
                    Total Investment/ Cost (Rs.)
                </th>
                
                <th>
                    Subsidy / Grant (Rs.)
                </th>
                
                <th>
                    Bank Loan Cost (Rs.)
                </th>
                
                  <th>
                    Balance Source of Investment (Rs.)
                </th>
                
                  <th>
                   Economic / Useful  Life (Year)
                </th>
                
                  <th>
                    Residual Value of Asset (Rs.)
                </th>
                
                  <th>
                    Annual Interest on Bank Loan(Rs.)
                </th>
                
                  <th>
                    Annual Depreciation (Rs.)
                </th>
                
                  <th>
                    Annual Insurance (Rs.)
                </th>
                
                  <th>
                    Annual Tax (Rs.)
                </th>
                
               
                
                  <th>
                    Annual Repair and Maintenance (Rs.)
                </th>
                
                  <th>
                    Annual Fixed cost of Asset (Rs.)
                </th>
                
                  <th>
                    Rental Unit of Farm Asset in Cluster Area ( per hour/ per unit area per day / month / year ) 
                </th>
                
                <th>
                    Rental Rate of Farm Asset in Cluster Area (Rs.) 
                </th>

                  <th>
                    Any Other
                </th>
                
            </tr>
        
            
            <tr>
                <td style="text-align:center;">
                    1
                </td>
                
            
                <td>
                   {{$datas->farmer_code == 'null' ? '' : $datas->farmer_code}} 
                </td>
             
               
                <td>
                {{$datas->farmer_first_name == 'null' ? '' : $datas->farmer_first_name.' '.$datas->farmer_last_name}}
                </td>
                

                <td style="font-weight:700;">
                    Irrigation Infrastructure
                </td>
                
                <td>0 for no 1 for yes</td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                    
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                </td>
                <td></td>
                 
                <td></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>

                
                <td>
                  
                </td>
                
                
                
                <td>
                   
                </td>
                
                <td>
                    Canal
                </td>
                
                <td></td>
                
                @php
                    $canalData = json_decode($datas->canal, true);
                @endphp
                
               <td>
                 <input type="text" id="canal_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" class="canal_number" name="canal_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['number'] ?? '' }}">
               </td>

                
               <td>
                 <input type="text" id="canal_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" class="canal_specification" name="canal_specification{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['specification'] ?? '' }}">
               </td>
               
                <td> <input type="text" id="canal_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" class="canal_specification_unit" name="canal_specification_unit{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['specification_unit'] ?? '' }}"></td>   

                <td>
                    <input type="text" id="canel_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" class="canel_year" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['year_of_asset_creation'] ?? '' }}">
                </td>
                
                 <td>
                   <input type="text" id="canel_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" class="canel_invesment" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['total_investment_cost'] ?? '' }}">
                </td>
                
                 <td>
                     <input type="text" id="canel_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" class="canel_subgrand" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['subsidy_grant'] ?? '' }}">
                </td>
                
                @php
                    $canbankLonCost = ($canalData['total_investment_cost'] ?? 0) - ($canalData['subsidy_grant'] ?? 0);
                    $Canbla_sou = $canbankLonCost - ($canalData['balance_source_of_investment'] ?? 0);
                @endphp
                
                 <td>
                     @if($Canbla_sou != 0)
                        {{ $Canbla_sou }}
                     @endif
                </td>
                
                 <td>
                   <input type="text" id="canel_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" class="canel_balance" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['balance_source_of_investment'] ?? '' }}">
                </td>
                
                <td>
                    <input type="text" id="canel_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" class="canel_economic" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['economic_useful_life'] ?? '' }}">
                </td>
                
                @php
                    $canresitent = ($canalData['total_investment_cost'] ?? 0) * 0.10;
                @endphp
                
                <td>
                     @if($canresitent != 0)
                        {{ $canresitent }}
                     @endif
                </td>
                
                 @php
                   $cananu = $Canbla_sou/2*12/100;
                 @endphp
                <td>
                    @if($cananu != 0)
                        {{ $cananu }}
                     @endif
                </td>
                
                 @php
                  $cananul_dep = ($canalData['total_investment_cost'] ?? 0) / ($canalData['economic_useful_life'] ?? 1);
                 @endphp
                 <td>
                     @if($cananul_dep != 0)
                        {{ $cananul_dep }}
                     @endif
                </td>
                
                 <td>
                   <input type="text" id="canel_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['annual_insurance'] ?? '' }}">
                </td>
                
                <td>
                   <input type="text" id="canel_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['annual_tax'] ?? '' }}">
                </td>
                
                 <td>
                    <input type="text" id="canel_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['annual_repair_and_maintenance'] ?? '' }}">
                </td>
                
                @php
                    $cananul_dep = ($canalData['total_investment_cost'] ?? 0) / ($canalData['economic_useful_life'] ?? 1);
                    $cananualfixdCost = $cananul_dep
                    + ($canalData['annual_insurance'] ?? 0)
                    + ($canalData['annual_tax'] ?? 0)
                    + ($canalData['annual_repair_and_maintenance'] ?? 0);
                    
                @endphp
                 <td>
                     @if($cananualfixdCost != 0)
                        {{ $cananualfixdCost }}
                     @endif
                </td>
                  <td>
                    <input type="text" id="canel_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['rental_unit'] ?? '' }}">
                </td>
              <td> <input type="text" id="canel_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['rental_rate'] ?? '' }}"></td>
                 
                <td><input type="text" id="canel_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="canal_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $canalData['any_other'] ?? '' }}"></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    b
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                
                <td>
                    Tubewell
                </td>
                
                <td></td>
                
                @php
                    $tubewellData = json_decode($datas->tubewell, true);
                @endphp
               <td>
                   <input type="text" id="tubewell_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewell_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['number'] ?? '' }}">
               </td>

                
               <td>
                    <input type="text" id="tubewell_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['specification'] ?? '' }}">
               </td>
               
                <td>
                    <input type="text" id="tubewell_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['specification_unit'] ?? '' }}">
               </td>
               

                  <td>
                    <input type="text" id="tubewell_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['year_of_asset_creation'] ?? '' }}">
                </td>
                
                 <td>
                   <input type="text" id="tubewell_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['total_investment_cost'] ?? '' }}">
                </td>
                
                 <td>
                     <input type="text" id="tubewell_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['subsidy_grant'] ?? '' }}">
                </td>
                
                 @php
                    $tubebankLonCost = ($tubewellData['total_investment_cost'] ?? 0) - ($tubewellData['subsidy_grant'] ?? 0);
                    $tubebla_sou = $tubebankLonCost - ($tubewellData['balance_source_of_investment'] ?? 0);
                 @endphp
                
                 <td>
                     @if($tubebla_sou != 0)
                        {{ $tubebla_sou }}
                     @endif
                </td>
                
                 <td>
                   <input type="text" id="tubewell_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['balance_source_of_investment'] ?? '' }}">
                </td>
                
                <td>
                    <input type="text" id="tubewell_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['economic_useful_life'] ?? '' }}">
                </td>
                
                @php
                $tuberesitent = ($tubewellData['total_investment_cost'] ?? 0) * 0.10;
                @endphp
                
                 <td>
                      @if($tuberesitent != 0)
                        {{ $tuberesitent }}
                     @endif
                </td>
                
                @php
                    $tubeanu = $tubebla_sou/2*12/100;
                @endphp
                
                <td>
                     @if($tubeanu != 0)
                        {{ $tubeanu }}
                     @endif
                </td>
                
                @php
                 $tubeanul_dep = ($tubewellData['total_investment_cost'] ?? 0) / ($tubewellData['economic_useful_life'] ?? 1);
                @endphp
                
                 <td>
                      @if($tubeanul_dep != 0)
                        {{ $tubeanul_dep }}
                     @endif
                  
                </td>
                
                 <td>
                   <input type="text" id="tubewell_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['annual_insurance'] ?? '' }}">
                </td>
                
                <td>
                   <input type="text" id="tubewell_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['annual_tax'] ?? '' }}">
                </td>
                
                
                
                 <td>
                   <input type="text" id="tubewell_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['annual_repair_and_maintenance'] ?? '' }}">
                </td>
                
                @php
                $tubeanul_dep = ($tubewellData['total_investment_cost'] ?? 0) / ($tubewellData['economic_useful_life'] ?? 1);
                $tubeanualfixdCost = $tubeanul_dep
                + ($tubewellData['annual_insurance'] ?? 0)
                + ($tubewellData['annual_tax'] ?? 0)
                + ($tubewellData['annual_repair_and_maintenance'] ?? 0);
                @endphp
                
                 <td>
                     @if($tubeanualfixdCost != 0)
                        {{ $tubeanualfixdCost }}
                     @endif
                </td>
                
                  <td>
                    <input type="text" id="tubewell_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['rental_unit'] ?? '' }}">
                </td>
                
              <td> <input type="text" id="tubewell_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['rental_rate'] ?? '' }}"></td>  
              
                <td><input type="text" id="tubewell_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="tubewel_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $tubewellData['any_other'] ?? '' }}"></td>
            </tr>

             <tr>
                <td style="text-align:center;">
                    c
                </td>

                <td> </td>
                
                <td></td>
                
                <td>
                    Engine / Motor / Solar
                </td>
                
                <td></td>
                
                @php
                    $moterData = json_decode($datas->enginer_motor_solar, true);
                @endphp
               <td>
                    <input type="text" id="enginer_motor_solar_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['number'] ?? '' }}">
               </td>

               <td>
                    <input type="text" id="enginer_motor_solar_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['specification'] ?? '' }}">
               </td>
               
                <td>
                    <input type="text" id="enginer_motor_solar_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['specification_unit'] ?? '' }}">
               </td>   

                  <td>
                    <input type="text" id="enginer_motor_solar_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['year_of_asset_creation'] ?? '' }}">
                </td>
                
                 <td>
                   <input type="text" id="enginer_motor_solar_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['total_investment_cost'] ?? '' }}">
                </td>
                
                 <td>
                     <input type="text" id="enginer_motor_solar_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['subsidy_grant'] ?? '' }}">
                </td>
                
                 @php
                  $moterbankLonCost = ($moterData['total_investment_cost'] ?? 0) - ($moterData['subsidy_grant'] ?? 0);
                  $moterbla_sou = $moterbankLonCost - ($moterData['balance_source_of_investment'] ?? 0);
                @endphp
                
                <td>
                     @if($moterbla_sou != 0)
                      {{ $moterbla_sou }}
                     @endif
                </td>
                
                 <td>
                   <input type="text" id="enginer_motor_solar_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['balance_source_of_investment'] ?? '' }}">
                </td>
                
                <td>
                    <input type="text" id="enginer_motor_solar_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['economic_useful_life'] ?? '' }}">
                </td>
                
                @php
                $moterresitent = ($moterData['total_investment_cost'] ?? 0) * 0.10;
                @endphp
                
                 <td>
                  @if($moterresitent != 0)
                    {{ $moterresitent }}
                  @endif
                </td>
                
                 @php
                  $moteranu = $moterbla_sou/2*12/100;
                 @endphp
                
                <td>
                    @if($moteranu != 0)
                    {{ $moteranu }}
                    @endif
                </td>
                
                   @php
                    $moteranul_dep = ($moterData['total_investment_cost'] ?? 0) / ($moterData['economic_useful_life'] ?? 1);
                   @endphp
                
                 <td>
                    @if($moteranul_dep != 0)
                    {{ $moteranul_dep }}
                    @endif
                </td>
                
                 <td>
                   <input type="text" id="enginer_motor_solar_economic_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['annual_insurance'] ?? '' }}">
                </td>
                
                <td>
                   <input type="text" id="enginer_motor_solar_economic_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['annual_tax'] ?? '' }}">
                </td>
                
                 <td>
                   <input type="text" id="enginer_motor_solar_economic_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['annual_repair_and_maintenance'] ?? '' }}">
                </td>
                
                @php
                $moteranul_dep = ($moterData['total_investment_cost'] ?? 0) / ($moterData['economic_useful_life'] ?? 1);
                $moteranualfixdCost = $moteranul_dep
                + ($moterData['annual_insurance'] ?? 0)
                + ($moterData['annual_tax'] ?? 0)
                + ($moterData['annual_repair_and_maintenance'] ?? 0);
                 $moteranualfixdCostFormatted = number_format($moteranualfixdCost, 2);
                @endphp
                
                <td>
                     @if($moteranualfixdCostFormatted != 0)
                    {{ $moteranualfixdCostFormatted }}
                    @endif
                </td> 
                
                <td>
                    <input type="text" id="enginer_motor_solar_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['rental_unit'] ?? '' }}">
                </td> 
                
                 <td>
                   <input type="text" id="enginer_motor_solar_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['rental_rate'] ?? '' }}">
                </td>
                
                <td><input type="text" id="enginer_motor_solar_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="moter_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $moterData['any_other'] ?? '' }}"></td>
            </tr>
            
  <tr>
    <td style="text-align:center;">
        d
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
        Pump sets ( Diesel/ electric/ Solar)
    </td>
    
    <td></td>

    @php
    $pumpsetData = json_decode($datas->pump_sets, true);
    @endphp
    <td>
        <input type="text" id="pump_sets_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="pump_sets_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['specification'] ?? '' }}">
    </td>
    
    <td>
        <input type="text" id="pump_sets_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_sets_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_sets_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_sets_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
        $pumpbankLonCost = ($pumpsetData['total_investment_cost'] ?? 0) - ($pumpsetData['subsidy_grant'] ?? 0);
        $pumpbla_sou = $pumpbankLonCost - ($pumpsetData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($pumpbla_sou != 0)
        {{ $pumpbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="pump_sets_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_sets_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['economic_useful_life'] ?? '' }}">
    </td>

    @php
        $pumpresitent = ($pumpsetData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    <td>
        @if($pumpresitent != 0)
        {{ $pumpresitent ?? '' }}
        @endif
    </td>
    
    @php
       $punpanu = $pumpbla_sou/2*12/100;
    @endphp

    <td>
         @if($punpanu != 0)
        {{ $punpanu ?? '' }}
        @endif
    </td>
    
    @php
    $pumpanul_dep = ($pumpsetData['total_investment_cost'] ?? 0) / ($pumpsetData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($pumpanul_dep != 0)
        {{ $pumpanul_dep ?? '' }}
        @endif
    </td>

    <td>
        <input type="text" id="pump_sets_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_sets_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_sets_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
        $anul_deppump = ($pumpsetData['total_investment_cost'] ?? 0) / ($pumpsetData['economic_useful_life'] ?? 1);
       
        $pumpanualfixdCost = $anul_deppump 
                         + ($pumpsetData['annual_insurance'] ?? 0) 
                         + ($pumpsetData['annual_tax'] ?? 0) 
                         + ($pumpsetData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($pumpanualfixdCost != 0)
        {{ $pumpanualfixdCost ?? '' }}
        @endif
    </td>
    
    <td><input type="text" id="pump_sets_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['rental_unit'] ?? '' }}"></td>
    <td><input type="text" id="pump_sets_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['rental_rate'] ?? '' }}"></td>
     
    <td><input type="text" id="pump_sets_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_sets_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pumpsetData['any_other'] ?? '' }}"></td>
</tr>
            
    <tr>
        <td style="text-align:center;">
        e
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
        Pond
    </td>
    
    <td></td>

    @php
    $pondData = json_decode($datas->pond, true);
    @endphp
    <td>
        <input type="text" id="pond_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['number'] ?? '' }}">
    </td>


    <td>
         <input type="text" id="pond_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['specification'] ?? '' }}">
    </td>
    
    <td>
         <input type="text" id="pond_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['specification_unit'] ?? '' }}">
    </td>
    

    <td>
         <input type="text" id="pond_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
         <input type="text" id="pond_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
         <input type="text" id="pond_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['subsidy_grant'] ?? '' }}">
    </td>
    
     @php
      $pondbankLonCost = ($pondData['total_investment_cost'] ?? 0) - ($pondData['subsidy_grant'] ?? 0);
      $pondbla_sou = $pondbankLonCost - ($pondData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($pondbla_sou != 0)
        {{ $pondbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="pond_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pond_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $pondresitent = ($pondData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($pondresitent != 0)
        {{ $pondresitent }}
        @endif
    </td>
    
    @php
    $pondanu = $pondbla_sou/2*12/100;
    @endphp

    <td>
        @if($pondanu != 0)
        {{ $pondanu }}
        @endif
    </td>
    
    @php
    $pondanul_dep = ($pondData['total_investment_cost'] ?? 0) / ($pondData['economic_useful_life'] ?? 1);
    $formatted_pondanul_dep = number_format($pondanul_dep, 2);
    @endphp

    <td>
        @if($formatted_pondanul_dep != 0)
        {{ $formatted_pondanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="pond_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pond_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pond_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

    @php
    $pondanul_dep = ($pondData['total_investment_cost'] ?? 0) / ($pondData['economic_useful_life'] ?? 1);
    $pondanualfixdCost = $pondanul_dep
    + ($pondData['annual_insurance'] ?? 0)
    + ($pondData['annual_tax'] ?? 0)
    + ($pondData['annual_repair_and_maintenance'] ?? 0);
    @endphp
    
    <td>
        @if($pondanualfixdCost != 0)
        {{ $pondanualfixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="pond_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['rental_unit'] ?? '' }}">
    </td>
    
    <td><input type="text" id="pond_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['rental_rate'] ?? '' }}"></td>
    <td><input type="text" id="pond_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pond_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pondData['any_other'] ?? '' }}"></td>
</tr>
            
<tr>
    <td style="text-align:center;">
        f
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Sprinkler / drip irrigation System
    </td>
    
    <td></td>

    @php
    $irrigation_systemData = json_decode($datas->irrigation_system, true);
    @endphp
    <td>
        <input type="text" id="irrigation_system_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="irrigation_system_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['specification'] ?? '' }}">
    </td>
    
    <td>
        <input type="text" id="irrigation_system_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_system_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_system_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_system_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['subsidy_grant'] ?? '' }}">
    </td>

    @php
    $irrigabankLonCost = ($irrigation_systemData['total_investment_cost'] ?? 0) - ($irrigation_systemData['subsidy_grant'] ?? 0);
    $irrgabla_sou = $irrigabankLonCost - ($irrigation_systemData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($irrgabla_sou != 0)
        {{ $irrgabla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="irrigation_system_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_system_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['economic_useful_life'] ?? '' }}">
    </td>
    @php
    $iggresitent = ($irrigation_systemData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    <td>
        @if($iggresitent != 0)
        {{ $iggresitent }}
        @endif
    </td>
    
    @php
    $igganu = $irrgabla_sou/2*12/100;
    @endphp


    <td>
        @if($igganu != 0)
        {{ $igganu }}
        @endif
    </td>
    
    @php
    $iggaanul_dep = ($irrigation_systemData['total_investment_cost'] ?? 0) / ($irrigation_systemData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($iggaanul_dep != 0)
        {{ $iggaanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="irrigation_system_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_system_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['annual_tax'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="irrigation_system_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

    @php
    $iggaanul_dep = ($irrigation_systemData['total_investment_cost'] ?? 0) / ($irrigation_systemData['economic_useful_life'] ?? 1);
    $iggaanualfixdCost = $iggaanul_dep
    + ($irrigation_systemData['annual_insurance'] ?? 0)
    + ($irrigation_systemData['annual_tax'] ?? 0)
    + ($irrigation_systemData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($iggaanualfixdCost != 0)
        {{ $iggaanualfixdCost }}
        @endif
    </td>
    
    <td>
         <input type="text" id="irrigation_system_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['rental_unit'] ?? '' }}">
    </td>
    
    <td><input type="text" id="irrigation_system_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="irrigation_system_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_system_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_systemData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        g
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Pump House
    </td>
    
    <td></td>

    @php
    $pump_houseData = json_decode($datas->pump_house, true);
    @endphp
    <td>
        <input type="text" id="pump_house_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="pump_house_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['specification'] ?? '' }}">
    </td>
    
    <td>
        <input type="text" id="pump_house_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_house_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_house_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_house_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $pumpbankLonCost = ($pump_houseData['total_investment_cost'] ?? 0) - ($pump_houseData['subsidy_grant'] ?? 0);
    $pumpbla_sou = $pumpbankLonCost - ($pump_houseData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($pumpbla_sou != 0)
        {{ $pumpbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="pump_house_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_house_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['economic_useful_life'] ?? '' }}">
    </td>

    @php
    $resitent = ($pump_houseData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    
    <td>
        @if($resitent != 0)
        {{ $resitent }}
        @endif
    </td>

    @php
    $bankanu = $pumpbla_sou/2*12/100;
    @endphp

    <td>
         @if($bankanu != 0)
        {{ $bankanu }}
        @endif
    </td>

    @php
    $pumpanul_dep = ($pump_houseData['total_investment_cost'] ?? 0) / ($pump_houseData['economic_useful_life'] ?? 1);
    @endphp
    <td>
        @if($pumpanul_dep != 0)
        {{ $pumpanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="pump_house_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_house_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="pump_house_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

    @php
    $pumpanul_dep = ($pump_houseData['total_investment_cost'] ?? 0) / ($pump_houseData['economic_useful_life'] ?? 1);
    $pumpanualfixdCost = $pumpanul_dep
    + ($pump_houseData['annual_insurance'] ?? 0)
    + ($pump_houseData['annual_tax'] ?? 0)
    + ($pump_houseData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($pumpanualfixdCost != 0)
        {{ $pumpanualfixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="pump_house_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['rental_unit'] ?? '' }}">
    </td>
      
    <td><input type="text" id="pump_house_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['rental_rate'] ?? '' }}"></td>
    <td><input type="text" id="pump_house_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="pump_house_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $pump_houseData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        h
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Other
    </td>
    
    <td></td>

    @php
    $irrigation_infrastructures_otherData = json_decode($datas->irrigation_infrastructures_other, true);
    @endphp
    <td>
        <input type="text" id="irrigation_infrastructures_other_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="irrigation_infrastructures_other_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['specification'] ?? '' }}">
    </td>
    
      <td>
        <input type="text"id="irrigation_infrastructures_other_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_infrastructures_other_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_infrastructures_other_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_infrastructures_other_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $igbankLonCost = ($irrigation_infrastructures_otherData['total_investment_cost'] ?? 0) - ($irrigation_infrastructures_otherData['subsidy_grant'] ?? 0);
    $igbla_sou = $igbankLonCost - ($irrigation_infrastructures_otherData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
         @if($igbla_sou != 0)
        {{ $igbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="irrigation_infrastructures_other_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_infrastructures_other_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['economic_useful_life'] ?? '' }}">
    </td>
    
     @php
    $igresitent = ($irrigation_infrastructures_otherData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
          @if($igresitent != 0)
        {{ $igresitent }}
        @endif
    </td>

    @php
    $iganu = $igbla_sou/2*12/100;
    @endphp
    <td>
        @if($iganu != 0)
        {{ $iganu }}
        @endif
    </td>

    @php
    $iganul_dep = ($irrigation_infrastructures_otherData['total_investment_cost'] ?? 0) / ($irrigation_infrastructures_otherData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
        @if($iganul_dep != 0)
        {{ $iganul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="irrigation_infrastructures_other_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_infrastructures_other_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="irrigation_infrastructures_other_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $iganul_dep = ($irrigation_infrastructures_otherData['total_investment_cost'] ?? 0) / ($irrigation_infrastructures_otherData['economic_useful_life'] ?? 1);
    $iganualfixdCost = $iganul_dep
    + ($irrigation_infrastructures_otherData['annual_insurance'] ?? 0)
    + ($irrigation_infrastructures_otherData['annual_tax'] ?? 0)
    + ($irrigation_infrastructures_otherData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($iganualfixdCost != 0)
        {{ $iganualfixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="irrigation_infrastructures_other_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['rental_unit'] ?? '' }}">
    </td>
      
    <td><input type="text" id="irrigation_infrastructures_other_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="irrigation_infrastructures_other_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" name="irrigation_infrastructures_other_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $irrigation_infrastructures_otherData['any_other'] ?? '' }}"></td>
</tr>

            <tr>
                <td style="text-align:center;">
                    2
                </td>

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                
                <td style="font-weight:700;">
                  Farm Mechanization Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                <td></td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                 
                <td></td>
            </tr>
            
  <tr>
    <td style="text-align:center;">
        a
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Tractor
    </td>
    
    <td></td>

    @php
    $tractorData = json_decode($datas->tractor, true);
    @endphp
    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['specification'] ?? '' }}">
    </td>
    
    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
        $bankLonCost = ($tractorData['total_investment_cost'] ?? 0) - ($tractorData['subsidy_grant'] ?? 0);
        $bla_sou = $bankLonCost - ($tractorData['balance_source_of_investment'] ?? 0);
    @endphp
    
    <td>
        @if($bla_sou != 0)
        {{ $bla_sou }}
       @endif
    </td>

    
    

    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
        $resitent = ($tractorData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resitent != 0)
        {{ $resitent }}
       @endif
    </td>
    
    @php
       $anu = $bla_sou/2*12/100;
    @endphp

    <td>
        @if($anu != 0)
        {{ $anu }}
       @endif
    </td>

    @php
    $anul_dep = ($tractorData['total_investment_cost'] ?? 0) / ($tractorData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
        @if($anul_dep != 0)
        {{ $anul_dep }}
       @endif
    </td>

    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

    @php
        $anul_dep = ($tractorData['total_investment_cost'] ?? 0) / ($tractorData['economic_useful_life'] ?? 1);
        $anualfixdCost = $anul_dep 
                         + ($tractorData['annual_insurance'] ?? 0) 
                         + ($tractorData['annual_tax'] ?? 0) 
                         + ($tractorData['annual_repair_and_maintenance'] ?? 0);
    @endphp
   
    <td>
        @if($anualfixdCost != 0)
        {{ $anualfixdCost }}
       @endif
    </td>
    
    <td>
        <input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['rental_unit'] ?? '' }}">
    </td>
     
    <td><input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['rental_rate'] ?? '' }}"></td>
    <td><input type="text" name="tractor_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" id="tractor_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $tractorData['any_other'] ?? '' }}"></td>
</tr>
            
          <tr>
    <td style="text-align:center;">
        b
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Power Tiller
    </td>
    
    <td></td>

    @php
    $power_tillerData = json_decode($datas->power_tiller, true);
    @endphp
    <td>
        <input type="text" id="power_tiller_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $power_tillerData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="power_tiller_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $power_tillerData['specification'] ?? '' }}">
    </td>
    
     <td>
        <input type="text" id="power_tiller_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $power_tillerData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="power_tiller_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $power_tillerData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="power_tiller_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"   value="{{ $power_tillerData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="power_tiller_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $power_tillerData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $powbankLonCost = ($power_tillerData['total_investment_cost'] ?? 0) - ($power_tillerData['subsidy_grant'] ?? 0);
    $powbla_sou = $powbankLonCost - ($power_tillerData['balance_source_of_investment'] ?? 0);
    @endphp


    <td>
        @if($powbla_sou != 0)
        {{ $powbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="power_tiller_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $power_tillerData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="power_tiller_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $power_tillerData['economic_useful_life'] ?? '' }}">
    </td>

    @php
    $powresitent = ($power_tillerData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    
    <td>
        @if($powresitent != 0)
        {{ $powresitent }}
        @endif
    </td>
    
    @php
    $poweranu = $powbla_sou/2*12/100;
    @endphp

    <td>
        @if($poweranu != 0)
        {{ $poweranu }}
        @endif
    </td>
    
    @php
    $powanul_dep = ($power_tillerData['total_investment_cost'] ?? 0) / ($power_tillerData['economic_useful_life'] ?? 1);
    @endphp


    <td>
        @if($powanul_dep != 0)
        {{ $powanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="power_tiller_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $power_tillerData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="power_tiller_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $power_tillerData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="power_tiller_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $power_tillerData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

    @php
    $powanul_dep = ($power_tillerData['total_investment_cost'] ?? 0) / ($power_tillerData['economic_useful_life'] ?? 1);
    $powanualfixdCost = $powanul_dep
    + ($power_tillerData['annual_insurance'] ?? 0)
    + ($power_tillerData['annual_tax'] ?? 0)
    + ($power_tillerData['annual_repair_and_maintenance'] ?? 0);
    @endphp
    
    <td>
        @if($powanualfixdCost != 0)
        {{ $powanualfixdCost }}
        @endif
    </td>
    
    <td>
         <input type="text" id="power_tiller_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $power_tillerData['rental_unit'] ?? '' }}">
    </td>
      
    <td> <input type="text" id="power_tiller_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $power_tillerData['rental_rate'] ?? '' }}"></td>
    <td><input type="text" id="power_tiller_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $power_tillerData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        c
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Cultivator
    </td>
    
    <td></td>

    @php
    $cultivatorData = json_decode($datas->cultivator, true);
    @endphp
    <td>
        <input type="text" id="cultivator_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="cultivator_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['specification'] ?? '' }}">
    </td>
    
    <td>
        <input type="text" id="cultivator_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"value="{{ $cultivatorData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="cultivator_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="cultivator_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="cultivator_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['subsidy_grant'] ?? '' }}">
    </td>
    
     @php
    $cubankLonCost = ($cultivatorData['total_investment_cost'] ?? 0) - ($cultivatorData['subsidy_grant'] ?? 0);
    $cubla_sou = $cubankLonCost - ($cultivatorData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($cubla_sou != 0)
        {{ $cubla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="cultivator_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="cultivator_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $curesitent = ($cultivatorData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($curesitent != 0)
        {{ $curesitent }}
        @endif
    </td>

    @php
    $cuanu = $cubla_sou/2*12/100;
    @endphp
    
    <td>
        @if($cuanu != 0)
        {{ $cuanu }}
        @endif
    </td>

    @php
    $cuanul_dep = ($cultivatorData['total_investment_cost'] ?? 0) / ($cultivatorData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
         @if($cuanul_dep != 0)
        {{ $cuanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="cultivator_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="cultivator_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="cultivator_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

    @php
    $cuanul_dep = ($cultivatorData['total_investment_cost'] ?? 0) / ($cultivatorData['economic_useful_life'] ?? 1);
    $cuanualfixdCost = $cuanul_dep
    + ($cultivatorData['annual_insurance'] ?? 0)
    + ($cultivatorData['annual_tax'] ?? 0)
    + ($cultivatorData['annual_repair_and_maintenance'] ?? 0);
    @endphp
    
    <td>
         @if($cuanualfixdCost != 0)
        {{ $cuanualfixdCost }}
        @endif
    </td>
    
    <td>
         <input type="text" id="cultivator_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['rental_unit'] ?? '' }}">
    </td>
    
    <td> <input type="text" id="cultivator_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['rental_rate'] ?? '' }}"></td>
      
    <td><input type="text" id="cultivator_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $cultivatorData['any_other'] ?? '' }}"></td>
</tr>
            
<tr>
    <td style="text-align:center;">
        d
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Rotator
    </td>
    
    <td></td>

    @php
    $rotatorData = json_decode($datas->rotator, true);
    @endphp
    <td>
        <input type="text" id="rotator_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="rotator_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['specification'] ?? '' }}">
    </td>
    
     <td>
        <input type="text" id="rotator_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="rotator_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="rotator_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="rotator_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $rotatorDatabankLonCost = ($rotatorData['total_investment_cost'] ?? 0) - ($rotatorData['subsidy_grant'] ?? 0);
    $robla_sou = $rotatorDatabankLonCost - ($rotatorData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($robla_sou != 0)
        {{ $robla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="rotator_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="rotator_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['economic_useful_life'] ?? '' }}">
    </td>
    
     @php
    $roresitent = ($rotatorData['total_investment_cost'] ?? 0) * 0.10;
    @endphp


    <td>
        @if($roresitent != 0)
        {{ $roresitent }}
        @endif
    </td>
    
    @php
    $roanu = $robla_sou/2*12/100;
    @endphp


    <td>
        @if($roanu != 0)
        {{ $roanu }}
        @endif
    </td>

    @php
    $roanul_dep = ($rotatorData['total_investment_cost'] ?? 0) / ($rotatorData['economic_useful_life'] ?? 1);
    @endphp


    <td>
         @if($roanul_dep != 0)
        {{ $roanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="rotator_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="rotator_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="rotator_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $roanul_dep = ($rotatorData['total_investment_cost'] ?? 0) / ($rotatorData['economic_useful_life'] ?? 1);
    $roanualfixdCost = $roanul_dep
    + ($rotatorData['annual_insurance'] ?? 0)
    + ($rotatorData['annual_tax'] ?? 0)
    + ($rotatorData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($roanualfixdCost != 0)
        {{ $roanualfixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="rotator_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['rental_unit'] ?? '' }}">
    </td>
    
    <td><input type="text" id="rotator_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['rental_rate'] ?? '' }}"></td>
     
    <td><input type="text" id="rotator_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $rotatorData['any_other'] ?? '' }}"></td>
</tr>
            
    <tr>
    <td style="text-align:center;">
        e
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Harrow
    </td>
    
    <td></td>

    @php
    $harrowData = json_decode($datas->harrow, true);
    @endphp
    <td>
        <input type="text" id="harrow_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $harrowData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="harrow_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $harrowData['specification'] ?? '' }}">
    </td>
    
    <td>
        <input type="text" id="harrow_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $harrowData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="harrow_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $harrowData['year_of_asset_creation'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="harrow_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $harrowData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="harrow_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $harrowData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
        $harrowBCost = ($harrowData['total_investment_cost'] ?? 0) - ($harrowData['subsidy_grant'] ?? 0);
        $harrowCost = $harrowBCost - ($harrowData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($harrowCost != 0)
        {{ $harrowCost }}
       @endif
    </td>

    <td>
        <input type="text" id="harrow_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $harrowData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="harrow_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $harrowData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
        $howwresitent = ($harrowData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($howwresitent != 0)
         {{ $howwresitent ?? '' }}
        @endif
    </td>
    
    @php
       $howwanu = $harrowCost/2*12/100;
    @endphp

    <td>
       @if($howwanu != 0)
         {{ $howwanu ?? '' }}
        @endif
    </td>
    
    
    @php
    $howwanul_dep = ($harrowData['total_investment_cost'] ?? 0) / ($harrowData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($howwanul_dep != 0)
         {{ $howwanul_dep ?? '' }}
        @endif
    </td>

    <td>
        <input type="text" id="harrow_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $harrowData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="harrow_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $harrowData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="harrow_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $harrowData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
     @php
        $howwanul_dep = ($harrowData['total_investment_cost'] ?? 0) / ($harrowData['economic_useful_life'] ?? 1);
        $howwanualfixdCost = $howwanul_dep 
                         + ($harrowData['annual_insurance'] ?? 0) 
                         + ($harrowData['annual_tax'] ?? 0) 
                         + ($harrowData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($howwanualfixdCost != 0)
         {{ $howwanualfixdCost ?? '' }}
        @endif
       
    </td>
    
    <td>
         <input type="text" id="harrow_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $harrowData['rental_unit'] ?? '' }}">
    </td>
      
    <td> <input type="text" id="harrow_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $harrowData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="harrow_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $harrowData['any_other'] ?? '' }}"></td>
</tr>
            
           <tr>
    <td style="text-align:center;">
        f
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Leveller
    </td>
    
    <td></td>

    @php
    $levellerData = json_decode($datas->leveller, true);
    @endphp
    <td>
        <input type="text" id="leveller_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="leveller_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['specification'] ?? '' }}">
    </td>
    
    <td>
        <input type="text" id="leveller_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="leveller_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="leveller_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="leveller_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $lebankLonCost = ($levellerData['total_investment_cost'] ?? 0) - ($levellerData['subsidy_grant'] ?? 0);
    $lebla_sou = $lebankLonCost - ($levellerData['balance_source_of_investment'] ?? 0);
    @endphp


    <td>
         @if($lebla_sou != 0)
        {{ $lebla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="leveller_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="leveller_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $leresitent = ($levellerData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($leresitent != 0)
        {{ $leresitent }}
        @endif
    </td>

    @php
    $leanu = $lebla_sou/2*12/100;
    @endphp

    <td>
        @if($leanu != 0)
        {{ $leanu }}
        @endif
    </td>
    
    @php
    $leanul_dep = ($levellerData['total_investment_cost'] ?? 0) / ($levellerData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($leanul_dep != 0)
        {{ $leanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="leveller_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="leveller_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['annual_tax'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="leveller_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

     @php
    $leanul_dep = ($levellerData['total_investment_cost'] ?? 0) / ($levellerData['economic_useful_life'] ?? 1);
    $leanualfixdCost = $leanul_dep
    + ($levellerData['annual_insurance'] ?? 0)
    + ($levellerData['annual_tax'] ?? 0)
    + ($levellerData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($leanualfixdCost != 0)
        {{ $leanualfixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="leveller_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['rental_unit'] ?? '' }}">
    </td>
    
    <td><input type="text" id="leveller_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['rental_rate'] ?? '' }}"></td>

    <td><input type="text" id="leveller_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $levellerData['any_other'] ?? '' }}"></td>
</tr>

    <tr>
    <td style="text-align:center;">
        g
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Plough (MB Plough / Disc Plough)
    </td>
    
    <td></td>

    @php
    $ploughData = json_decode($datas->plough, true);
    @endphp
    <td>
        <input type="text" id="plough_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="plough_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['specification'] ?? '' }}">
    </td>
    
    <td>
        <input type="text" id="plough_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['specification_unit'] ?? '' }}">
    </td>
    <td>
        <input type="text" id="plough_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="plough_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="plough_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $plbankLonCost = ($ploughData['total_investment_cost'] ?? 0) - ($ploughData['subsidy_grant'] ?? 0);
    $plbla_sou = $plbankLonCost - ($ploughData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
       @if($plbla_sou != 0)
        {{ $plbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="plough_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="plough_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $plresitent = ($ploughData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($plresitent != 0)
        {{ $plresitent }}
        @endif
    </td>
    
    
    @php
    $planu = $plbla_sou/2*12/100;
    @endphp

    <td>
       @if($planu != 0)
        {{ $planu }}
        @endif
    </td>

    @php
    $planul_dep = ($ploughData['total_investment_cost'] ?? 0) / ($ploughData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
        @if($planul_dep != 0)
        {{ $planul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="plough_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="plough_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['annual_tax'] ?? '' }}">
    </td>

    
    <td>
        <input type="text" id="plough_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $ploughData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $planul_dep = ($ploughData['total_investment_cost'] ?? 0) / ($ploughData['economic_useful_life'] ?? 1);
    $planualfixdCost = $planul_dep
    + ($ploughData['annual_insurance'] ?? 0)
    + ($ploughData['annual_tax'] ?? 0)
    + ($ploughData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($planualfixdCost != 0)
        {{ $planualfixdCost }}
        @endif
    </td>
    
    <td>
         <input type="text" id="plough_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $ploughData['rental_unit'] ?? '' }}">
    </td>
    
    <td> <input type="text" id="plough_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $ploughData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="plough_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $ploughData['any_other'] ?? '' }}"></td>
</tr>
            
 <tr>
    <td style="text-align:center;">
        h
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Seed drill
    </td>
    
    <td></td>

    @php
    $speed_drillData = json_decode($datas->speed_drill, true);
    @endphp
    <td>
        <input type="text" id="speed_drill_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="speed_drill_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['specification'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_drill_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['specification_unit'] ?? '' }}">
    </td>
  
    <td>
        <input type="text" id="speed_drill_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_drill_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_drill_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $spbankLonCost = ($speed_drillData['total_investment_cost'] ?? 0) - ($speed_drillData['subsidy_grant'] ?? 0);
    $spbla_sou = $spbankLonCost - ($speed_drillData['balance_source_of_investment'] ?? 0);
    @endphp
    
    <td>
        @if($spbla_sou != 0)
        {{ $spbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="speed_drill_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_drill_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $spresitent = ($speed_drillData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($spresitent != 0)
        {{ $spresitent }}
        @endif
    </td>
    
     @php
    $spanu = $spbla_sou/2*12/100;
    @endphp

    <td>
       @if($spanu != 0)
        {{ $spanu }}
        @endif
    </td>
    
    @php
    $spanul_dep = ($speed_drillData['total_investment_cost'] ?? 0) / ($speed_drillData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($spanul_dep != 0)
        {{ $spanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="speed_drill_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_drill_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_drill_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $spanul_dep = ($speed_drillData['total_investment_cost'] ?? 0) / ($speed_drillData['economic_useful_life'] ?? 1);
    $anualfixdCost = $spanul_dep
    + ($speed_drillData['annual_insurance'] ?? 0)
    + ($speed_drillData['annual_tax'] ?? 0)
    + ($speed_drillData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualfixdCost != 0)
        {{ $anualfixdCost }}
        @endif
    </td>
    
    <td>
         <input type="text" id="speed_drill_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['rental_unit'] ?? '' }}">
    </td>
    
    <td> <input type="text" id="speed_drill_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text"  id="speed_drill_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_drillData['any_other'] ?? '' }}"></td>
</tr>
            
 <tr>
    <td style="text-align:center;">
        i
    </td>


    <td>
    </td>
    
    <td>
    </td>

    <td>
     Seed Planter	
    </td>
    
    <td></td>
    @php
    $speed_planterData = json_decode($datas->speed_planter, true);
    @endphp
    <td>
        <input type="text" id="speed_planter_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="speed_planter_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['specification'] ?? '' }}">
    </td>
    
     <td>
        <input type="text" id="speed_planter_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_planter_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_planter_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_planter_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $speebankLonCost = ($speed_planterData['total_investment_cost'] ?? 0) - ($speed_planterData['subsidy_grant'] ?? 0);
    $speebla_sou = $speebankLonCost - ($speed_planterData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($speebla_sou != 0)
        {{ $speebla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="speed_planter_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_planter_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['economic_useful_life'] ?? '' }}">
    </td>

    @php
    $speeresitent = ($speed_planterData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($speeresitent != 0)
        {{ $speeresitent }}
        @endif
    </td>
    
    @php
    $speeanu = $speebla_sou/2*12/100;
    @endphp


    <td>
        @if($speeanu != 0)
        {{ $speeanu }}
        @endif
    </td>
    
    @php
    $speeanul_dep = ($speed_planterData['total_investment_cost'] ?? 0) / ($speed_planterData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($speeanul_dep != 0)
        {{ $speeanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="speed_planter_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_planter_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_planter_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $speeanul_dep = ($speed_planterData['total_investment_cost'] ?? 0) / ($speed_planterData['economic_useful_life'] ?? 1);
    $speeanualfixdCost = $speeanul_dep
    + ($speed_planterData['annual_insurance'] ?? 0)
    + ($speed_planterData['annual_tax'] ?? 0)
    + ($speed_planterData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($speeanualfixdCost != 0)
        {{ $speeanualfixdCost }}
        @endif
    </td>
    
    <td>
         <input type="text" id="speed_planter_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['rental_unit'] ?? '' }}">
    </td>
    <td> <input type="text" id="speed_planter_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['rental_rate'] ?? '' }}"></td>
      
    <td><input type="text" id="speed_planter_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_planterData['any_other'] ?? '' }}"></td>
</tr>

<tr>
    <td style="text-align:center;">
        j
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Seed cum fertilizer drill	
    </td>
    
    <td></td>

    @php
    $speed_cum_fertilizer_drillData = json_decode($datas->speed_cum_fertilizer_drill, true);
    @endphp
    <td>
        <input type="text" id="speed_cum_fertilizer_drill_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="speed_cum_fertilizer_drill_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['specification'] ?? '' }}">
    </td>
    
     <td>
        <input type="text" id="speed_cum_fertilizer_drill_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_cum_fertilizer_drill_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_cum_fertilizer_drill_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"value="{{ $speed_cum_fertilizer_drillData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_cum_fertilizer_drill_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $scfbankLonCost = ($speed_cum_fertilizer_drillData['total_investment_cost'] ?? 0) - ($speed_cum_fertilizer_drillData['subsidy_grant'] ?? 0);
    $scfbla_sou = $scfbankLonCost - ($speed_cum_fertilizer_drillData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($scfbla_sou != 0)
        {{ $scfbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="speed_cum_fertilizer_drill_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_cum_fertilizer_drill_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $scfresitent = ($speed_cum_fertilizer_drillData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($scfresitent != 0)
        {{ $scfresitent }}
        @endif
    </td>
    
    @php
    $scfanu = $scfbla_sou/2*12/100;
    @endphp

    <td>
        @if($scfanu != 0)
        {{ $scfanu }}
        @endif
    </td>
    
    @php
    $scfanul_dep = ($speed_cum_fertilizer_drillData['total_investment_cost'] ?? 0) / ($speed_cum_fertilizer_drillData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($scfanul_dep != 0)
        {{ $scfanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="speed_cum_fertilizer_drill_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_cum_fertilizer_drill_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="speed_cum_fertilizer_drill_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $scfanul_dep = ($speed_cum_fertilizer_drillData['total_investment_cost'] ?? 0) / ($speed_cum_fertilizer_drillData['economic_useful_life'] ?? 1);
    $scfanualfixdCost = $scfanul_dep
    + ($speed_cum_fertilizer_drillData['annual_insurance'] ?? 0)
    + ($speed_cum_fertilizer_drillData['annual_tax'] ?? 0)
    + ($speed_cum_fertilizer_drillData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($scfanualfixdCost != 0)
        {{ $scfanualfixdCost }}
        @endif

    </td>
    
      <td>
        <input type="text" id="speed_cum_fertilizer_drill_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['rental_unit'] ?? '' }}">
    </td>
    
      <td>
        <input type="text" id="speed_cum_fertilizer_drill_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['rental_rate'] ?? '' }}">
    </td>
     
    <td><input type="text" id="speed_cum_fertilizer_drill_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $speed_cum_fertilizer_drillData['any_other'] ?? '' }}"></td>
</tr>
            
 <tr>
    <td style="text-align:center;">
        k
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Trolley	
    </td>
    
    <td></td>

    @php
    $trolleyData = json_decode($datas->trolley, true);
    @endphp
    <td>
        <input type="text" id="trolley_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="trolley_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['specification'] ?? '' }}">
    </td>
    
    <td>
        <input type="text" id="trolley_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['specification_unit'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="trolley_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="trolley_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="trolley_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $tlbankLonCost = ($trolleyData['total_investment_cost'] ?? 0) - ($trolleyData['subsidy_grant'] ?? 0);
    $tlbla_sou = $tlbankLonCost - ($trolleyData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($tlbla_sou != 0)
        {{ $tlbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="trolley_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="trolley_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $tlresitent = ($trolleyData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($tlresitent != 0)
        {{ $tlresitent }}
        @endif
    </td>
    
    @php
    $tlanu = $tlbla_sou/2*12/100;
    @endphp

    <td>
         @if($tlanu != 0)
        {{ $tlanu }}
        @endif
    </td>
    
    @php
    $tlanul_dep = ($trolleyData['total_investment_cost'] ?? 0) / ($trolleyData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($tlanul_dep != 0)
        {{ $tlanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="trolley_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="trolley_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="trolley_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $tlanul_dep = ($trolleyData['total_investment_cost'] ?? 0) / ($trolleyData['economic_useful_life'] ?? 1);
    $tlanualfixdCost = $tlanul_dep
    + ($trolleyData['annual_insurance'] ?? 0)
    + ($trolleyData['annual_tax'] ?? 0)
    + ($trolleyData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($tlanualfixdCost != 0)
        {{ $tlanualfixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="trolley_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['rental_unit'] ?? '' }}">
    </td>

    <td><input type="text" id="trolley_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="trolley_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $trolleyData['any_other'] ?? '' }}"></td>
</tr>
            
 <tr>
    <td style="text-align:center;">
        l
    </td>


    <td>
    </td>

    <td>
    </td>

    <td>
    Reaper cum binder	
    </td>
    
    <td></td>

    @php
    $reaper_cum_binderData = json_decode($datas->reaper_cum_binder, true);
    @endphp
    
    <td>
        <input type="text" id="reaper_cum_binder_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="reaper_cum_binder_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['specification'] ?? '' }}">
    </td>
    
     <td><input type="text" id="reaper_cum_binder_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="reaper_cum_binder_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="reaper_cum_binder_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="reaper_cum_binder_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $rebankLonCost = ($reaper_cum_binderData['total_investment_cost'] ?? 0) - ($reaper_cum_binderData['subsidy_grant'] ?? 0);
    $rcbbla_sou = $rebankLonCost - ($reaper_cum_binderData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($rcbbla_sou != 0)
        {{ $rcbbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="reaper_cum_binder_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="reaper_cum_binder_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $rcbresitent = ($reaper_cum_binderData['total_investment_cost'] ?? 0) * 0.10;
    @endphp


    <td>
         @if($rcbresitent != 0)
        {{ $rcbresitent }}
        @endif
    </td>
    
    @php
    $rcbanu = $rcbbla_sou/2*12/100;
    @endphp

    <td>
         @if($rcbanu != 0)
        {{ $rcbanu }}
        @endif
    </td>
    
    @php
    $rcbanul_dep = ($reaper_cum_binderData['total_investment_cost'] ?? 0) / ($reaper_cum_binderData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($rcbanul_dep != 0)
        {{ $rcbanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="reaper_cum_binder_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="reaper_cum_binder_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['annual_tax'] ?? '' }}">
    </td>
    
     <td>
        <input type="text" id="reaper_cum_binder_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $rcbanul_dep = ($reaper_cum_binderData['total_investment_cost'] ?? 0) / ($reaper_cum_binderData['economic_useful_life'] ?? 1);
    $rcbanualfixdCost = $rcbanul_dep
    + ($reaper_cum_binderData['annual_insurance'] ?? 0)
    + ($reaper_cum_binderData['annual_tax'] ?? 0)
    + ($reaper_cum_binderData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($rcbanualfixdCost != 0)
        {{ $rcbanualfixdCost }}
       @endif
    </td>
    
    <td>
        <input type="text" id="reaper_cum_binder_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['rental_unit'] ?? '' }}">
    </td>
    <td><input type="text" id="reaper_cum_binder_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['rental_rate'] ?? '' }}"></td>
      
    <td><input type="text" id="reaper_cum_binder_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $reaper_cum_binderData['any_other'] ?? '' }}"></td>
</tr>
            
<tr>
    <td style="text-align:center;">
        m
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Husk Making Machine	
    </td>
    
    <td></td>

    @php
    $bhusa_machineData = json_decode($datas->bhusa_machine, true);
    @endphp
    <td>
        <input type="text" id="bhusa_machine_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="bhusa_machine_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="bhusa_machine_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="bhusa_machine_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="bhusa_machine_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="bhusa_machine_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $banCost = ($bhusa_machineData['total_investment_cost'] ?? 0) - ($bhusa_machineData['subsidy_grant'] ?? 0);
    $blsou = $banCost - ($bhusa_machineData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
         @if($blsou != 0)
        {{ $blsou }}
        @endif
    </td>

    <td>
        <input type="text" id="bhusa_machine_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="bhusa_machine_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resent = ($bhusa_machineData['total_investment_cost'] ?? 0) * 0.10;
    @endphp


    <td>
        @if($resent != 0)
        {{ $resent }}
        @endif
    </td>
    
    @php
    $dfanu = $blsou/2*12/100;
    @endphp

    <td>
         @if($dfanu != 0)
        {{ $dfanu }}
        @endif
    </td>
    
     @php
    $anggul_dep = ($bhusa_machineData['total_investment_cost'] ?? 0) / ($bhusa_machineData['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($anggul_dep != 0)
        {{ $anggul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="bhusa_machine_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="bhusa_machine_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="bhusa_machine_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
     @php
    $anultdep = ($bhusa_machineData['total_investment_cost'] ?? 0) / ($bhusa_machineData['economic_useful_life'] ?? 1);
    $aalfixdCost = $anultdep
    + ($bhusa_machineData['annual_insurance'] ?? 0)
    + ($bhusa_machineData['annual_tax'] ?? 0)
    + ($bhusa_machineData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
         @if($aalfixdCost != 0)
        {{ $aalfixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="bhusa_machine_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['rental_unit'] ?? '' }}">
    </td>
    
    <td><input type="text" id="bhusa_machine_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['rental_rate'] ?? '' }}"></td>
      
    <td><input type="text" id="bhusa_machine_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bhusa_machineData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        n
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Thresher	
    </td>
    
    <td></td>

    @php
    $thresherData = json_decode($datas->thresher, true);
    @endphp
    <td>
        <input type="text" id="thresher_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="thresher_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="thresher_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="thresher_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="thresher_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="thresher_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $bankLost = ($thresherData['total_investment_cost'] ?? 0) - ($thresherData['subsidy_grant'] ?? 0);
    $thbla_sou = $bankLost - ($thresherData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($thbla_sou != 0)
        {{ $thbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="thresher_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="thresher_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"value="{{ $thresherData['economic_useful_life'] ?? '' }}">
    </td>
    
     @php
    $resirrtent = ($thresherData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resirrtent != 0)
        {{ $resirrtent }}
        @endif
    </td>
    
    @php
    $afenu = $thbla_sou/2*12/100;
    @endphp

    <td>
       @if($afenu != 0)
        {{ $afenu }}
        @endif
    </td>
    
    @php
    $anultdep = ($thresherData['total_investment_cost'] ?? 0) / ($thresherData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anultdep != 0)
        {{ $anultdep }}
        @endif
    </td>

    <td>
        <input type="text" id="thresher_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="thresher_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="thresher_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $aneedep = ($thresherData['total_investment_cost'] ?? 0) / ($thresherData['economic_useful_life'] ?? 1);
    $adfixdCost = $aneedep
    + ($thresherData['annual_insurance'] ?? 0)
    + ($thresherData['annual_tax'] ?? 0)
    + ($thresherData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($adfixdCost != 0)
        {{ $adfixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="thresher_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['rental_unit'] ?? '' }}">
    </td>
    
    <td><input type="text" id="thresher_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="thresher_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $thresherData['any_other'] ?? '' }}"></td>
</tr>
            
               <tr>
    <td style="text-align:center;">
        o
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Combine Harvester	
    </td>
    
    <td></td>

    @php
    $combine_harvesterData = json_decode($datas->combine_harvester, true);
    @endphp
    <td>
        <input type="text" id="combine_harvester_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="combine_harvester_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="combine_harvester_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="combine_harvester_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="combine_harvester_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="combine_harvester_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $baeenCost = ($combine_harvesterData['total_investment_cost'] ?? 0) - ($combine_harvesterData['subsidy_grant'] ?? 0);
    $chbla_sou = $baeenCost - ($combine_harvesterData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
          @if($chbla_sou != 0)
        {{ $chbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="combine_harvester_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $combine_harvesterData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="combine_harvester_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  value="{{ $combine_harvesterData['economic_useful_life'] ?? '' }}">
    </td>
    
     @php
    $reent = ($combine_harvesterData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($reent != 0)
        {{ $reent }}
        @endif
    </td>
    
     @php
    $anufe = $chbla_sou/2*12/100;
    @endphp

    <td>
        @if($anufe != 0)
        {{ $anufe }}
        @endif
    </td>
    
    @php
    $anuhrhl_dep = ($combine_harvesterData['total_investment_cost'] ?? 0) / ($combine_harvesterData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($anuhrhl_dep != 0)
        {{ $anuhrhl_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="combine_harvester_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="combine_harvester_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="combine_harvester_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anuydep = ($combine_harvesterData['total_investment_cost'] ?? 0) / ($combine_harvesterData['economic_useful_life'] ?? 1);
    $anualfixdCost = $anuydep
    + ($combine_harvesterData['annual_insurance'] ?? 0)
    + ($combine_harvesterData['annual_tax'] ?? 0)
    + ($combine_harvesterData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anualfixdCost != 0)
        {{ $anualfixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="combine_harvester_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['rental_unit'] ?? '' }}">
    </td>
    
    <td><input type="text" id="combine_harvester_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['rental_rate'] ?? '' }}"></td>
     
    <td><input type="text" id="combine_harvester_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $combine_harvesterData['any_other'] ?? '' }}"></td>
</tr>
            
<tr>
    <td style="text-align:center;">
        p
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Other	
    </td>
    
    <td></td>

    @php
    $farm_mechanisms_otherData = json_decode($datas->farm_mechanisms_other, true);
    @endphp
    <td>
        <input type="text" id="farm_mechanisms_other_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="farm_mechanisms_other_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="farm_mechanisms_other_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="farm_mechanisms_other_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="farm_mechanisms_other_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="farm_mechanisms_other_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $bryLonCost = ($farm_mechanisms_otherData['total_investment_cost'] ?? 0) - ($farm_mechanisms_otherData['subsidy_grant'] ?? 0);
    $fbla_sou = $bryLonCost - ($farm_mechanisms_otherData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($fbla_sou != 0)
        {{ $fbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="farm_mechanisms_other_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="farm_mechanisms_other_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resitytyent = ($farm_mechanisms_otherData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    
    

    <td>
         @if($resitytyent != 0)
        {{ $resitytyent }}
        @endif
    </td>
    
     @php
    $ahjmnu = $fbla_sou/2*12/100;
    @endphp

    <td>
        @if($ahjmnu != 0)
        {{ $ahjmnu }}
        @endif
    </td>

     @php
    $anuerdep = ($farm_mechanisms_otherData['total_investment_cost'] ?? 0) / ($farm_mechanisms_otherData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anuerdep != 0)
        {{ $anuerdep }}
        @endif
    </td>

    <td>
        <input type="text" id="farm_mechanisms_other_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="farm_mechanisms_other_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="farm_mechanisms_other_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anutrepss = ($farm_mechanisms_otherData['total_investment_cost'] ?? 0) / ($farm_mechanisms_otherData['economic_useful_life'] ?? 1);
    $fixdCost = $anutrepss
    + ($farm_mechanisms_otherData['annual_insurance'] ?? 0)
    + ($farm_mechanisms_otherData['annual_tax'] ?? 0)
    + ($farm_mechanisms_otherData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($fixdCost != 0)
        {{ $fixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="farm_mechanisms_other_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['rental_unit'] ?? '' }}">
    </td>
     
    <td><input type="text" id="farm_mechanisms_other_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"value="{{ $farm_mechanisms_otherData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="farm_mechanisms_other_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $farm_mechanisms_otherData['any_other'] ?? '' }}"></td>
</tr>
            
             <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td style="font-weight:700;">
                Storage Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                     <td></td>
                     <td></td>
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
               
                   
                </td>
                  <td>
                   
                </td>
                  <td></td>
                    
                <td></td>
            </tr>
            
            <tr>
    <td style="text-align:center;">
        a
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Kothila / Deshi Storage Structure	
    </td>
    
    <td></td>

    @php
    $deshiData = json_decode($datas->deshi, true);
    @endphp
    <td>
        <input type="text" id="deshi_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="deshi_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="deshi_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="deshi_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="deshi_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="deshi_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['subsidy_grant'] ?? '' }}">
    </td>
    
     @php
    $banhtnCost = ($deshiData['total_investment_cost'] ?? 0) - ($deshiData['subsidy_grant'] ?? 0);
    $ddbla_sou = $banhtnCost - ($deshiData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
         @if($ddbla_sou != 0)
        {{ $ddbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="deshi_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="deshi_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $rewefent = ($deshiData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
           @if($rewefent != 0)
        {{ $rewefent }}
        @endif
    </td>
    
    @php
    $anfeu = $ddbla_sou/2*12/100;
    @endphp

    <td>
        @if($anfeu != 0)
        {{ $anfeu }}
        @endif
    </td>
    
    @php
    $anujep = ($deshiData['total_investment_cost'] ?? 0) / ($deshiData['economic_useful_life'] ?? 1);
    @endphp


    <td>
        @if($anujep != 0)
        {{ $anujep }}
        @endif
    </td>

    <td>
        <input type="text" id="deshi_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="deshi_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="deshi_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    
    @php
    $anugggrdep = ($deshiData['total_investment_cost'] ?? 0) / ($deshiData['economic_useful_life'] ?? 1);
    $anttixdCost = $anugggrdep
    + ($deshiData['annual_insurance'] ?? 0)
    + ($deshiData['annual_tax'] ?? 0)
    + ($deshiData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anttixdCost != 0)
        {{ $anttixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="deshi_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['rental_unit'] ?? '' }}">
    </td>
   
    <td><input type="text" id="deshi_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['rental_rate'] ?? '' }}"></td>
        
    <td><input type="text" id="deshi_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $deshiData['any_other'] ?? '' }}"></td>
</tr>
            
             <tr>
    <td style="text-align:center;">
        b
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Godown
    </td>
    
    <td></td>

    @php
    $godownData = json_decode($datas->godown, true);
    @endphp
    <td>
        <input type="text" id="godown_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="godown_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['specification'] ?? '' }}">
    </td>
    
      <td> <input type="text" id="godown_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="godown_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="godown_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="godown_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['subsidy_grant'] ?? '' }}">
    </td>
    
     @php
    $brgfost = ($godownData['total_investment_cost'] ?? 0) - ($godownData['subsidy_grant'] ?? 0);
    $godbla_sou = $brgfost - ($godownData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
       @if($godbla_sou != 0)
        {{ $godbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="godown_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="godown_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['economic_useful_life'] ?? '' }}">
    </td>
    
     @php
    $resigr = ($godownData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
       @if($resigr != 0)
        {{ $resigr }}
        @endif
    </td>
    
    @php
    $anfnfu = $godbla_sou/2*12/100;
    @endphp


    <td>
         @if($anfnfu != 0)
        {{ $anfnfu }}
        @endif
    </td>
    
    @php
    $anulp = ($godownData['total_investment_cost'] ?? 0) / ($godownData['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($anulp != 0)
        {{ $anulp }}
        @endif
    </td>

    <td>
        <input type="text" id="godown_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="godown_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['annual_tax'] ?? '' }}">
    </td>

   

    <td>
        <input type="text" id="godown_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"value="{{ $godownData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anhtrdep = ($godownData['total_investment_cost'] ?? 0) / ($godownData['economic_useful_life'] ?? 1);
    $anrgxdCost = $anhtrdep
    + ($godownData['annual_insurance'] ?? 0)
    + ($godownData['annual_tax'] ?? 0)
    + ($godownData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anrgxdCost != 0)
        {{ $anrgxdCost }}
        @endif
    </td>
    
    <td>
         <input type="text" id="godown_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['rental_unit'] ?? '' }}">
    </td>
    <td> <input type="text" id="godown_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['rental_rate'] ?? '' }}"></td>
     
    <td><input type="text" id="godown_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $godownData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        c
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    clod
    </td>
    
    <td></td>

    @php
    $clodData = json_decode($datas->clod, true);
    @endphp
    <td>
        <input type="text" id="clod_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="clod_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['specification'] ?? '' }}">
    </td>
    
      <td> <input type="text" id="clod_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="clod_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="clod_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="clod_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $clCost = ($clodData['total_investment_cost'] ?? 0) - ($clodData['subsidy_grant'] ?? 0);
    $clbla_sou = $clCost - ($clodData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
       @if($clbla_sou != 0)
        {{ $clbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="clod_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="clod_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resittt = ($clodData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    

    <td>
        @if($resittt != 0)
        {{ $resittt }}
        @endif
    </td>
    
     @php
    $anyju = $clbla_sou/2*12/100;
    @endphp


    <td>
        @if($anyju != 0)
        {{ $anyju }}
        @endif
    </td>
    
    @php
    $ainul_dep = ($clodData['total_investment_cost'] ?? 0) / ($clodData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($ainul_dep != 0)
        {{ $ainul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="clod_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="clod_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['annual_tax'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="clod_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anurdep = ($clodData['total_investment_cost'] ?? 0) / ($clodData['economic_useful_life'] ?? 1);
    $anfggalfixdCost = $anurdep
    + ($clodData['annual_insurance'] ?? 0)
    + ($clodData['annual_tax'] ?? 0)
    + ($clodData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anfggalfixdCost != 0)
        {{ $anfggalfixdCost }}
        @endif
    </td>
    
    <td>
         <input type="text" id="clod_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['rental_unit'] ?? '' }}">
    </td>
    
    <td> <input type="text" id="clod_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['rental_rate'] ?? '' }}"></td>
      
    <td><input type="text" id="clod_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $clodData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        d
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Bulk Cooling Unit
    </td>
    
    <td></td>

    @php
    $bulk_coolingData = json_decode($datas->bulk_cooling, true);
    @endphp
    <td>
        <input type="text" id="bulk_cooling_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="bulk_cooling_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="bulk_cooling_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="bulk_cooling_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="bulk_cooling_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="bulk_cooling_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $banefonCost = ($bulk_coolingData['total_investment_cost'] ?? 0) - ($bulk_coolingData['subsidy_grant'] ?? 0);
    $bcbla_sou = $banefonCost - ($bulk_coolingData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($bcbla_sou != 0)
        {{ $bcbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="bulk_cooling_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="bulk_cooling_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $datresitent = ($bulk_coolingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($datresitent != 0)
        {{ $datresitent }}
        @endif
    </td>
    
    @php
    $anufr = $bcbla_sou/2*12/100;
    @endphp

    <td>
        @if($anufr != 0)
        {{ $anufr }}
        @endif
    </td>
    
    @php
    $anuyyep = ($bulk_coolingData['total_investment_cost'] ?? 0) / ($bulk_coolingData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($anuyyep != 0)
        {{ $anuyyep }}
        @endif
    </td>

    <td>
        <input type="text" id="bulk_cooling_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="bulk_cooling_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="bulk_cooling_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $ayynul_dep = ($bulk_coolingData['total_investment_cost'] ?? 0) / ($bulk_coolingData['economic_useful_life'] ?? 1);
    $anualwwfixdCost = $ayynul_dep
    + ($bulk_coolingData['annual_insurance'] ?? 0)
    + ($bulk_coolingData['annual_tax'] ?? 0)
    + ($bulk_coolingData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualwwfixdCost != 0)
        {{ $anualwwfixdCost }}
        @endif
    </td>
    
    <td>
       <input type="text" id="bulk_cooling_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['rental_unit'] ?? '' }}"> 
    </td>
    
    <td><input type="text" id="bulk_cooling_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['rental_rate'] ?? '' }}"></td>

    <td><input type="text" id="bulk_cooling_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $bulk_coolingData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        e
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Storage for fodder
    </td>
    
    <td></td>

    @php
    $fodderData = json_decode($datas->fodder, true);
    @endphp
    <td>
        <input type="text" id="fodder_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="fodder_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['specification'] ?? '' }}">
    </td>
    
     <td> <input type="text" id="fodder_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="fodder_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="fodder_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="fodder_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $ffbankLonCost = ($fodderData['total_investment_cost'] ?? 0) - ($fodderData['subsidy_grant'] ?? 0);
    $fodbla_sou = $ffbankLonCost - ($fodderData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($fodbla_sou != 0)
        {{ $fodbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="fodder_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="fodder_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resngitent = ($fodderData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resngitent != 0)
        {{ $resngitent }}
        @endif
    </td>
    
    @php
    $aggnu = $fodbla_sou/2*12/100;
    @endphp


    <td>
        @if($aggnu != 0)
        {{ $aggnu }}
        @endif
    </td>
    
    @php
    $rttanul_dep = ($fodderData['total_investment_cost'] ?? 0) / ($fodderData['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($rttanul_dep != 0)
        {{ $rttanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="fodder_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="fodder_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="fodder_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

    @php
    $fodanul_dep = ($fodderData['total_investment_cost'] ?? 0) / ($fodderData['economic_useful_life'] ?? 1);
    $anuaxdCost = $fodanul_dep
    + ($fodderData['annual_insurance'] ?? 0)
    + ($fodderData['annual_tax'] ?? 0)
    + ($fodderData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anuaxdCost != 0)
        {{ $anuaxdCost }}
        @endif
    </td>
    
    <td>
         <input type="text" id="fodder_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['rental_unit'] ?? '' }}">
    </td>
    
    <td> <input type="text" id="fodder_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['rental_rate'] ?? '' }}"></td>
      
    <td><input type="text" id="fodder_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $fodderData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        f
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Other
    </td>
    
    <td></td>

    @php
    $storage_structures_otherData = json_decode($datas->storage_structures_other, true);
    @endphp
    <td>
        <input type="text" id="storage_structures_other_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="storage_structures_other_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="storage_structures_other_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"value="{{ $storage_structures_otherData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="storage_structures_other_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text"id="storage_structures_other_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="storage_structures_other_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $bLonCost = ($storage_structures_otherData['total_investment_cost'] ?? 0) - ($storage_structures_otherData['subsidy_grant'] ?? 0);
    $ssbla_sou = $bLonCost - ($storage_structures_otherData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
       @if($ssbla_sou != 0)
        {{ $ssbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="storage_structures_other_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="storage_structures_other_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['economic_useful_life'] ?? '' }}">
    </td>
    
     @php
    $resitdatent = ($storage_structures_otherData['total_investment_cost'] ?? 0) * 0.10;
    @endphp


    <td>
        @if($resitdatent != 0)
        {{ $resitdatent }}
        @endif
    </td>
    
    @php
    $anudata = $ssbla_sou/2*12/100;
    @endphp

    <td>
        @if($anudata != 0)
        {{ $anudata }}
        @endif
    </td>
    
    @php
    $anulf_dep = ($storage_structures_otherData['total_investment_cost'] ?? 0) / ($storage_structures_otherData['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($anulf_dep != 0)
        {{ $anulf_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="storage_structures_other_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="storage_structures_other_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="storage_structures_other_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    
    @php
    $anulyy_dep = ($storage_structures_otherData['total_investment_cost'] ?? 0) / ($storage_structures_otherData['economic_useful_life'] ?? 1);
    $anudixdCost = $anulyy_dep
    + ($storage_structures_otherData['annual_insurance'] ?? 0)
    + ($storage_structures_otherData['annual_tax'] ?? 0)
    + ($storage_structures_otherData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anudixdCost != 0)
        {{ $anudixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="storage_structures_other_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['rental_unit'] ?? '' }}">
    </td>
    
    <td><input type="text" id="storage_structures_other_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['rental_rate'] ?? '' }}"></td>

    <td><input type="text" id="storage_structures_other_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $storage_structures_otherData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                <td style="font-weight:700;">
                Processing Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                <td></td>
                  <td></td>
                    <td></td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
              
                    
                <td></td>
            </tr>
            
<tr>
    <td style="text-align:center;">
        a
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
        Wheat Processing Unit
    </td>

    <td></td>

    @php
    $wheat_processingData = json_decode($datas->wheat_processing, true);
    @endphp
    <td>
        <input type="text"
            id="wheat_processing_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text"
            id="wheat_processing_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['specification'] ?? '' }}">
    </td>

    <td> <input type="text"
            id="wheat_processing_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text"
            id="wheat_processing_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text"
            id="wheat_processing_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text"
            id="wheat_processing_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['subsidy_grant'] ?? '' }}">
    </td>

    @php
    $banktost = ($wheat_processingData['total_investment_cost'] ?? 0) - ($wheat_processingData['subsidy_grant'] ?? 0);
    $wpbla_sou = $banktost - ($wheat_processingData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($wpbla_sou != 0)
        {{ $wpbla_sou }}
        @endif
    </td>

    <td>
        <input type="text"
            id="wheat_processing_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text"
            id="wheat_processing_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['economic_useful_life'] ?? '' }}">
    </td>

    @php
    $resitgrent = ($wheat_processingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resitgrent != 0)
        {{ $resitgrent }}
        @endif
    </td>

    @php
    $anufe = $wpbla_sou/2*12/100;
    @endphp

    <td>
        @if($anufe != 0)
        {{ $anufe }}
        @endif
    </td>

    @php
    $anulee_dep = ($wheat_processingData['total_investment_cost'] ?? 0) / ($wheat_processingData['economic_useful_life']
    ?? 1);
    @endphp

    <td>
        @if($anulee_dep != 0)
        {{ $anulee_dep }}
        @endif
    </td>

    <td>
        <input type="text"
            id="wheat_processing_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text"
            id="wheat_processing_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['annual_tax'] ?? '' }}">
    </td>


    <td>
        <input type="text"
            id="wheat_processing_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

    @php
    $anultt_dep = ($wheat_processingData['total_investment_cost'] ?? 0) / ($wheat_processingData['economic_useful_life']
    ?? 1);
    $anfixdCost = $anultt_dep
    + ($wheat_processingData['annual_insurance'] ?? 0)
    + ($wheat_processingData['annual_tax'] ?? 0)
    + ($wheat_processingData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anfixdCost != 0)
        {{ $anfixdCost }}
        @endif
    </td>

    <td>
        <input type="text"
            id="wheat_processing_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['rental_unit'] ?? '' }}">
    </td>

    <td> <input type="text"
            id="wheat_processing_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['rental_rate'] ?? '' }}"></td>

    <td><input type="text"
            id="wheat_processing_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $wheat_processingData['any_other'] ?? '' }}"></td>
</tr>
            
          <tr>
    <td style="text-align:center;">
        b
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Oil Processing Unit
    </td>
    
    <td></td>

    @php
    $oil_processingData = json_decode($datas->oil_processing, true);
    @endphp
    <td>
        <input type="text" id="oil_processing_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $oil_processingData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="oil_processing_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $oil_processingData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="oil_processing_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
      value="{{ $oil_processingData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="oil_processing_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $oil_processingData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="oil_processing_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $oil_processingData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="oil_processing_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $oil_processingData['subsidy_grant'] ?? '' }}">
    </td>
    
     @php
     $bahnCost = ($oil_processingData['total_investment_cost'] ?? 0) - ($oil_processingData['subsidy_grant'] ?? 0);
     $opbla_sou = $bahnCost - ($oil_processingData['balance_source_of_investment'] ?? 0);
     @endphp

    <td>
       @if($opbla_sou != 0)
        {{ $opbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="oil_processing_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $oil_processingData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="oil_processing_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $oil_processingData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resirt = ($oil_processingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resirt != 0)
        {{ $resirt }}
        @endif
    </td>
    
     @php
    $anudd = $opbla_sou/2*12/100;
    @endphp

    <td>
        @if($anudd != 0)
        {{ $anudd }}
        @endif
    </td>
    
    @php
    $anul_dep = ($oil_processingData['total_investment_cost'] ?? 0) / ($oil_processingData['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($anul_dep != 0)
        {{ $anul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="oil_processing_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $oil_processingData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="oil_processing_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $oil_processingData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="oil_processing_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $oil_processingData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anggul_dep = ($oil_processingData['total_investment_cost'] ?? 0) / ($oil_processingData['economic_useful_life'] ?? 1);
    $anddualfixdCost = $anggul_dep
    + ($oil_processingData['annual_insurance'] ?? 0)
    + ($oil_processingData['annual_tax'] ?? 0)
    + ($oil_processingData['annual_repair_and_maintenance'] ?? 0);
    @endphp


    <td>
         @if($anddualfixdCost != 0)
        {{ $anddualfixdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="oil_processing_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $oil_processingData['rental_unit'] ?? '' }}">
    </td>
      
    <td><input type="text" id="oil_processing_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $oil_processingData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="oil_processing_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $oil_processingData['any_other'] ?? '' }}"></td>
</tr>

          <tr>
    <td style="text-align:center;">
        c
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Sugarcane Processing Unit
    </td>
    
    <td></td>

    @php
    $sugarcane_processingData = json_decode($datas->sugarcane_processing, true);
    @endphp
    
    <td>
        <input type="text" id="sugarcane_processing_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $sugarcane_processingData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="sugarcane_processing_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $sugarcane_processingData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="sugarcane_processing_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
      value="{{ $sugarcane_processingData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="sugarcane_processing_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $sugarcane_processingData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="sugarcane_processing_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $sugarcane_processingData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="sugarcane_processing_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $sugarcane_processingData['subsidy_grant'] ?? '' }}">
    </td>
    
       @php
        $banknCost = ($sugarcane_processingData['total_investment_cost'] ?? 0) - ($sugarcane_processingData['subsidy_grant'] ?? 0);
        $spibla_sou = $banknCost - ($sugarcane_processingData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
         @if($spibla_sou != 0)
        {{ $spibla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="sugarcane_processing_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $sugarcane_processingData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="sugarcane_processing_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $sugarcane_processingData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resitentee = ($sugarcane_processingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resitentee != 0)
        {{ $resitentee }}
        @endif
    </td>
    
    @php
    $anusw = $spibla_sou/2*12/100;
    @endphp

    <td>
         @if($anusw != 0)
        {{ $anusw }}
        @endif
    </td>
    
    @php
    $ssanul_dep = ($sugarcane_processingData['total_investment_cost'] ?? 0) / ($sugarcane_processingData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($ssanul_dep != 0)
        {{ $ssanul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="sugarcane_processing_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $sugarcane_processingData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="sugarcane_processing_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $sugarcane_processingData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="sugarcane_processing_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $sugarcane_processingData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anuwwl_dep = ($sugarcane_processingData['total_investment_cost'] ?? 0) / ($sugarcane_processingData['economic_useful_life'] ?? 1);
    $anhtfixdCost = $anuwwl_dep
    + ($sugarcane_processingData['annual_insurance'] ?? 0)
    + ($sugarcane_processingData['annual_tax'] ?? 0)
    + ($sugarcane_processingData['annual_repair_and_maintenance'] ?? 0);
    @endphp

   

    <td>
        @if($anhtfixdCost != 0)
        {{ $anhtfixdCost }}
        @endif
    </td>
    <td>
        <input type="text" id="sugarcane_processing_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $sugarcane_processingData['rental_unit'] ?? '' }}">
    </td>
      
    <td><input type="text" id="sugarcane_processing_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
    value="{{ $sugarcane_processingData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="sugarcane_processing_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
    value="{{ $sugarcane_processingData['any_other'] ?? '' }}"></td>
</tr>
            
             <tr>
    <td style="text-align:center;">
        d
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Dal Processing Unit
    </td>
    
    <td></td>

    @php
    $dal_processingData = json_decode($datas->dal_processing, true);
    @endphp
    <td>
        <input type="text" id="dal_processing_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $dal_processingData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="dal_processing_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $dal_processingData['specification'] ?? '' }}">
    </td>
    
    <td><input type="text" id="dal_processing_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
    value="{{ $dal_processingData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="dal_processing_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $dal_processingData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="dal_processing_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $dal_processingData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="dal_processing_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $dal_processingData['subsidy_grant'] ?? '' }}">
    </td>
    
       @php
        $banffkLonCost = ($dal_processingData['total_investment_cost'] ?? 0) - ($dal_processingData['subsidy_grant'] ?? 0);
        $dpbla_sou = $banffkLonCost - ($dal_processingData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($dpbla_sou != 0)
        {{ $dpbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="dal_processing_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $dal_processingData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="dal_processing_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $dal_processingData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resitdent = ($dal_processingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    
    

    <td>
         @if($resitdent != 0)
        {{ $resitdent }}
        @endif
    </td>
    
    @php
    $anssu = $dpbla_sou/2*12/100;
    @endphp

    <td>
         @if($anssu != 0)
        {{ $anssu }}
        @endif
    </td>

     @php
    $anssul_dep = ($dal_processingData['total_investment_cost'] ?? 0) / ($dal_processingData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
        @if($anssul_dep != 0)
        {{ $anssul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="dal_processing_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $dal_processingData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="dal_processing_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $dal_processingData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="dal_processing_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $dal_processingData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
     @php
    $awnul_dep = ($dal_processingData['total_investment_cost'] ?? 0) / ($dal_processingData['economic_useful_life'] ?? 1);
    $ansalfixdCost = $awnul_dep
    + ($dal_processingData['annual_insurance'] ?? 0)
    + ($dal_processingData['annual_tax'] ?? 0)
    + ($dal_processingData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($ansalfixdCost != 0)
        {{ $ansalfixdCost }}
        @endif
    </td>
    
    <td><input type="text" id="dal_processing_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
    value="{{ $dal_processingData['rental_unit'] ?? '' }}"></td>
    
    <td><input type="text" id="dal_processing_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
    value="{{ $dal_processingData['rental_rate'] ?? '' }}"></td>
  
    
    <td><input type="text" id="dal_processing_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
    value="{{ $dal_processingData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
    <td style="text-align:center;">
        e
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Any Other Processing unit
    </td>
    
    <td></td>

    @php
    $other_processingData = json_decode($datas->other_processing, true);
    @endphp
    <td>
        <input type="text" id="other_processing_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $other_processingData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="other_processing_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $other_processingData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="other_processing_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $other_processingData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="other_processing_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $other_processingData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_processing_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $other_processingData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_processing_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" value="{{ $other_processingData['subsidy_grant'] ?? '' }}">
    </td>
    
        @php
        $bangnCost = ($other_processingData['total_investment_cost'] ?? 0) - ($other_processingData['subsidy_grant'] ?? 0);
        $opbla_sou = $bangnCost - ($other_processingData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($opbla_sou != 0)
        {{ $opbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="other_processing_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_processingData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_processing_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_processingData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $refetent = ($other_processingData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($refetent != 0)
        {{ $refetent }}
        @endif
    </td>
    
    @php
    $awednu = $opbla_sou/2*12/100;
    @endphp

    <td>
        @if($awednu != 0)
        {{ $awednu }}
        @endif
    </td>
    
    @php
    $andeul_dep = ($other_processingData['total_investment_cost'] ?? 0) / ($other_processingData['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($andeul_dep != 0)
        {{ $andeul_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="other_processing_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_processingData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_processing_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_processingData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_processing_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_processingData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anuldddep = ($other_processingData['total_investment_cost'] ?? 0) / ($other_processingData['economic_useful_life'] ?? 1);
    $anutixdCost = $anuldddep
    + ($other_processingData['annual_insurance'] ?? 0)
    + ($other_processingData['annual_tax'] ?? 0)
    + ($other_processingData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anutixdCost != 0)
        {{ $anutixdCost }}
        @endif
    </td>
    
    <td><input type="text" id="other_processing_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
    value="{{ $other_processingData['rental_unit'] ?? '' }}"></td>
    
    <td><input type="text" id="other_processing_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
    value="{{ $other_processingData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="other_processing_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  
    value="{{ $other_processingData['any_other'] ?? '' }}"></td>
</tr>
            
              <tr>
                <td style="text-align:center;">
                    5
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td style="font-weight:700;">
                 Marketing Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
    <td style="text-align:center;">
        a
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Kiran Outlets
    </td>
    
    <td></td>

    @php
    $kiran_outletsData = json_decode($datas->kiran_outlets, true);
    @endphp
    <td>
        <input type="text" id="kiran_outlets_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $kiran_outletsData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="kiran_outlets_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $kiran_outletsData['specification'] ?? '' }}">
    </td>
    
      <td> <input type="text" id="kiran_outlets_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
      value="{{ $kiran_outletsData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="kiran_outlets_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $kiran_outletsData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="kiran_outlets_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $kiran_outletsData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="kiran_outlets_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $kiran_outletsData['subsidy_grant'] ?? '' }}">
    </td>
    
      @php
        $bronCost = ($kiran_outletsData['total_investment_cost'] ?? 0) - ($kiran_outletsData['subsidy_grant'] ?? 0);
        $kobla_sou = $bronCost - ($kiran_outletsData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
       @if($kobla_sou != 0)
        {{ $kobla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="kiran_outlets_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $kiran_outletsData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="kiran_outlets_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $kiran_outletsData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resiterrnt = ($kiran_outletsData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resiterrnt != 0)
        {{ $resiterrnt }}
        @endif
    </td>
    
    @php
    $anuee = $kobla_sou/2*12/100;
    @endphp

    <td>
         @if($anuee != 0)
        {{ $anuee }}
        @endif
    </td>
    
    
    @php
    $anuttdep = ($kiran_outletsData['total_investment_cost'] ?? 0) / ($kiran_outletsData['economic_useful_life'] ?? 1);
    @endphp

    <td>
      @if($anuttdep != 0)
        {{ $anuttdep }}
     @endif
    </td>

    <td>
        <input type="text" id="kiran_outlets_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $kiran_outletsData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="kiran_outlets_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $kiran_outletsData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="kiran_outlets_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $kiran_outletsData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anulff_dep = ($kiran_outletsData['total_investment_cost'] ?? 0) / ($kiran_outletsData['economic_useful_life'] ?? 1);
    $anualfixdCost = $anulff_dep
    + ($kiran_outletsData['annual_insurance'] ?? 0)
    + ($kiran_outletsData['annual_tax'] ?? 0)
    + ($kiran_outletsData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
     @if($anualfixdCost != 0)
        {{ $anualfixdCost }}
     @endif
    </td>
    
    <td>
        <input type="text" id="kiran_outlets_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $kiran_outletsData['rental_unit'] ?? '' }}">
    </td>
    
    <td><input type="text" id="kiran_outlets_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
    value="{{ $kiran_outletsData['rental_rate'] ?? '' }}"></td>
   
    <td><input type="text" id="kiran_outlets_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
    value="{{ $kiran_outletsData['any_other'] ?? '' }}"></td>
</tr>
            
          <tr>
    <td style="text-align:center;">
        b
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Grocery Outlets
    </td>
    
    <td></td>

    @php
    $grossary_outletsData = json_decode($datas->grossary_outlets, true);
    @endphp
    <td>
        <input type="text" id="grossary_outlets_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $grossary_outletsData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="grossary_outlets_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $grossary_outletsData['specification'] ?? '' }}">
    </td>
    
      <td> <input type="text" id="grossary_outlets_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
      value="{{ $grossary_outletsData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="grossary_outlets_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $grossary_outletsData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="grossary_outlets_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $grossary_outletsData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="grossary_outlets_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $grossary_outletsData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
    $bannCost = ($grossary_outletsData['total_investment_cost'] ?? 0) - ($grossary_outletsData['subsidy_grant'] ?? 0);
    $gobla_sou = $bannCost - ($grossary_outletsData['balance_source_of_investment'] ?? 0);
    @endphp

    <td>
        @if($gobla_sou != 0)
        {{ $gobla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="grossary_outlets_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $grossary_outletsData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="grossary_outlets_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $grossary_outletsData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resieetent = ($grossary_outletsData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resieetent != 0)
        {{ $resieetent }}
        @endif
    </td>
    
    @php
    $ddanu = $gobla_sou/2*12/100;
    @endphp

    <td>
        @if($ddanu != 0)
        {{ $ddanu }}
        @endif
    </td>
    
    @php
    $anuyyl_dep = ($grossary_outletsData['total_investment_cost'] ?? 0) / ($grossary_outletsData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anuyyl_dep != 0)
        {{ $anuyyl_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="grossary_outlets_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $grossary_outletsData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="grossary_outlets_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $grossary_outletsData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="grossary_outlets_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $grossary_outletsData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

    
    @php
    $anuld_dep = ($grossary_outletsData['total_investment_cost'] ?? 0) / ($grossary_outletsData['economic_useful_life'] ?? 1);
    $anualrrdCost = $anuld_dep
    + ($grossary_outletsData['annual_insurance'] ?? 0)
    + ($grossary_outletsData['annual_tax'] ?? 0)
    + ($grossary_outletsData['annual_repair_and_maintenance'] ?? 0);
    @endphp
  

    <td>
        @if($anualrrdCost != 0)
        {{ $anualrrdCost }}
        @endif
    </td>
    <td>
         <input type="text" id="grossary_outlets_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
         value="{{ $grossary_outletsData['rantel_unit'] ?? '' }}">
    </td>
     
    <td> <input type="text" id="grossary_outlets_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
    value="{{ $grossary_outletsData['rantel_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="grossary_outlets_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
    value="{{ $grossary_outletsData['any_other'] ?? '' }}"></td>
</tr>
            
            
            <tr>
    <td style="text-align:center;">
        c
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
     Any Other Retail outlets
    </td>
    
    <td></td>

    @php
    $other_outletsData = json_decode($datas->other_outlets, true);
    @endphp
    <td>
        <input type="text" id="other_outlets_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_outletsData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="other_outlets_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_outletsData['specification'] ?? '' }}">
    </td>
    
      <td><input type="text" id="other_outlets_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
      value="{{ $other_outletsData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="other_outlets_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_outletsData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_outlets_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_outletsData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_outlets_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_outletsData['subsidy_grant'] ?? '' }}">
    </td>
    
      @php
        $bankLttCost = ($other_outletsData['total_investment_cost'] ?? 0) - ($other_outletsData['subsidy_grant'] ?? 0);
        $oobla_sou = $bankLttCost - ($other_outletsData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
         @if($oobla_sou != 0)
        {{ $oobla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="other_outlets_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_outletsData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_outlets_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_outletsData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resihuir = ($other_outletsData['total_investment_cost'] ?? 0) * 0.10;
    @endphp


    <td>
       @if($resihuir != 0)
        {{ $resihuir }}
        @endif
    </td>
    
     @php
    $anuss = $oobla_sou/2*12/100;
    @endphp

    <td>
        @if($anuss != 0)
        {{ $anuss }}
        @endif
    </td>
    
    @php
    $anfgrl_dep = ($other_outletsData['total_investment_cost'] ?? 0) / ($other_outletsData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anfgrl_dep != 0)
        {{ $anfgrl_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="other_outlets_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_outletsData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_outlets_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_outletsData['annual_tax'] ?? '' }}">
    </td>

  

    <td>
        <input type="text" id="other_outlets_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_outletsData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
     @php
    $anuleee_dep = ($other_outletsData['total_investment_cost'] ?? 0) / ($other_outletsData['economic_useful_life'] ?? 1);
    $anualxdCost = $anuleee_dep
    + ($other_outletsData['annual_insurance'] ?? 0)
    + ($other_outletsData['annual_tax'] ?? 0)
    + ($other_outletsData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualxdCost != 0)
        {{ $anualxdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="other_outlets_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_outletsData['rental_unit'] ?? '' }}">
    </td>
   
    <td> <input type="text" id="other_outlets_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
       value="{{ $other_outletsData['rental_rate'] ?? '' }}"></td>
       
    <td><input type="text" id="other_outlets_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
       value="{{ $other_outletsData['any_other'] ?? '' }}"></td>
</tr>
            
            <tr>
                <td style="text-align:center;">
                    6
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                
                <td style="font-weight:700;">
                 Farm Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                        
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
    <td style="text-align:center;">
        a
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Shed (Kuchha)
    </td>
    
    <td></td>

    @php
    $shed_kuchhaData = json_decode($datas->shed_kuchha, true);
    @endphp
    <td>
        <input type="text" id="shed_kuchha_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="shed_kuchha_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['specification'] ?? '' }}">
    </td>
    
      <td> <input type="text" id="shed_kuchha_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
      value="{{ $shed_kuchhaData['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="shed_kuchha_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="shed_kuchha_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="shed_kuchha_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
        $banCost = ($shed_kuchhaData['total_investment_cost'] ?? 0) - ($shed_kuchhaData['subsidy_grant'] ?? 0);
        $skbla_sou = $banCost - ($shed_kuchhaData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
         @if($skbla_sou != 0)
        {{ $skbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="shed_kuchha_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="shed_kuchha_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resirr = ($shed_kuchhaData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resirr != 0)
        {{ $resirr }}
        @endif
    </td>
    
     @php
    $anuueu = $skbla_sou/2*12/100;
    @endphp

    <td>
        @if($anuueu != 0)
        {{ $anuueu }}
        @endif
    </td>

    @php
    $anul_deprr = ($shed_kuchhaData['total_investment_cost'] ?? 0) / ($shed_kuchhaData['economic_useful_life'] ?? 1);
    @endphp
    
    <td>
         @if($anul_deprr != 0)
        {{ $anul_deprr }}
        @endif
    </td>

    <td>
        <input type="text" id="shed_kuchha_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="shed_kuchha_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="shed_kuchha_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anul_deps = ($shed_kuchhaData['total_investment_cost'] ?? 0) / ($shed_kuchhaData['economic_useful_life'] ?? 1);
    $anuarsdCost = $anul_deps
    + ($shed_kuchhaData['annual_insurance'] ?? 0)
    + ($shed_kuchhaData['annual_tax'] ?? 0)
    + ($shed_kuchhaData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anuarsdCost != 0)
        {{ $anuarsdCost }}
        @endif
    </td>
    <td>
         <input type="text" id="shed_kuchha_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
         value="{{ $shed_kuchhaData['rental_unit'] ?? '' }}">
    </td>
    <td> <input type="text" id="shed_kuchha_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['rental_rate'] ?? '' }}"></td>
      
    <td><input type="text" id="shed_kuchha_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_kuchhaData['any_other'] ?? '' }}"></td>
</tr>
            
 <tr>
    <td style="text-align:center;">
        b
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Shed (Pucca)
    </td>
    
    <td></td>

    @php
    $shed_puccaData = json_decode($datas->shed_pucca, true);
    @endphp
    <td>
        <input type="text" id="shed_pucca_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $shed_puccaData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="shed_pucca_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_puccaData['specification'] ?? '' }}">
    </td>
    
    <td><input type="text" id="shed_pucca_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_puccaData['specification_unit'] ?? '' }}"></td>
    <td>
        <input type="text" id="shed_pucca_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $shed_puccaData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="shed_pucca_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $shed_puccaData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="shed_pucca_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $shed_puccaData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
        $baronCost = ($shed_puccaData['total_investment_cost'] ?? 0) - ($shed_puccaData['subsidy_grant'] ?? 0);
        $spbla_sou = $baronCost - ($shed_puccaData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($spbla_sou != 0)
        {{ $spbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="shed_pucca_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $shed_puccaData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="shed_pucca_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $shed_puccaData['economic_useful_life'] ?? '' }}">
    </td>
    
      @php
    $resiteddnt = ($shed_puccaData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
       @if($resiteddnt != 0)
        {{ $resiteddnt }}
        @endif
    </td>
    
       @php
    $anudf = $spbla_sou/2*12/100;
    @endphp

    <td>
         @if($anudf != 0)
        {{ $anudf }}
        @endif
    </td>
    
      @php
    $anul_dddep = ($shed_puccaData['total_investment_cost'] ?? 0) / ($shed_puccaData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anul_dddep != 0)
        {{ $anul_dddep }}
        @endif
    </td>

    <td>
        <input type="text" id="shed_pucca_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $shed_puccaData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="shed_pucca_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_puccaData['annual_tax'] ?? '' }}">
    </td>

   

    <td>
        <input type="text" id="shed_pucca_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_puccaData['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
      @php
    $anuffl_dep = ($shed_puccaData['total_investment_cost'] ?? 0) / ($shed_puccaData['economic_useful_life'] ?? 1);
    $anuxdCost = $anuffl_dep
    + ($shed_puccaData['annual_insurance'] ?? 0)
    + ($shed_puccaData['annual_tax'] ?? 0)
    + ($shed_puccaData['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anuxdCost != 0)
        {{ $anuxdCost }}
        @endif
    </td>
    
    <td>
        <input type="text" id="shed_pucca_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $shed_puccaData['rental_unit'] ?? '' }}">
    </td>
   
    <td><input type="text" id="shed_pucca_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_puccaData['rental_rate'] ?? '' }}"></td>
    
    <td><input type="text" id="shed_pucca_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $shed_puccaData['any_other'] ?? '' }}"></td>
</tr>

            <tr>
                <td style="text-align:center;">
                    7
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                
                <td style="font-weight:700;">
                 Investment under Plantation Crop (crop period more than 18 months) 
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                        
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>   
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                
             
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                   <td>
                 Name of Plantation Crop (Example : Tea, Apple, Mango, Orange, etc.)
                </td>
                
                <td></td>
               @php
                $name_plantationdata = json_decode($datas->name_plantation, true);
                @endphp
            <td>
                <input type="text" id="name_plantation_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
                value="{{ $name_plantationdata['number'] ?? '' }}">
            </td>
        
        
            <td>
                <input type="text" id="name_plantation_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  
                value="{{ $name_plantationdata['specification'] ?? '' }}">
            </td>
        
            <td><input type="text" id="name_plantation_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
              value="{{ $name_plantationdata['specification_unit'] ?? '' }}"></td>
        
            <td>
                <input type="text" id="name_plantation_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
                value="{{ $name_plantationdata['year_of_asset_creation'] ?? '' }}">
            </td>
        
            <td>
                <input type="text" id="name_plantation_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
                value="{{ $name_plantationdata['total_investment_cost'] ?? '' }}">
            </td>

            <td>
                <input type="text" id="name_plantation_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
                value="{{ $name_plantationdata['subsidy_grant'] ?? '' }}">
            </td>
    
        @php
        $bankLrst = ($name_plantationdata['total_investment_cost'] ?? 0) - ($name_plantationdata['subsidy_grant'] ?? 0);
        $npbla_sou = $bankLrst - ($name_plantationdata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
         @if($npbla_sou != 0)
        {{ $npbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="name_plantation_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"  
        value="{{ $name_plantationdata['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="name_plantation_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $name_plantationdata['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $rdata = ($name_plantationdata['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($rdata != 0)
        {{ $rdata }}
        @endif
    </td>
    
     @php
    $anurr = $npbla_sou/2*12/100;
    @endphp

    <td>
         @if($anurr != 0)
        {{ $anurr }}
        @endif
    </td>
    
    @php
    $anussrr = ($name_plantationdata['total_investment_cost'] ?? 0) / ($name_plantationdata['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anussrr != 0)
        {{ $anussrr }}
        @endif
    </td>

    <td>
        <input type="text" id="name_plantation_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $name_plantationdata['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="name_plantation_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $name_plantationdata['annual_tax'] ?? '' }}">
    </td>



    <td>
        <input type="text" id="name_plantation_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
            value="{{ $name_plantationdata['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anulss_dep = ($name_plantationdata['total_investment_cost'] ?? 0) / ($name_plantationdata['economic_useful_life'] ?? 1);
    $anualfisCost = $anulss_dep
    + ($name_plantationdata['annual_insurance'] ?? 0)
    + ($name_plantationdata['annual_tax'] ?? 0)
    + ($name_plantationdata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualfisCost != 0)
        {{ $anualfisCost }}
        @endif
    </td>

    <td>
        <input type="text" id="name_plantation_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $name_plantationdata['rental_unit'] ?? '' }}">
    </td>

    <td> <input type="text" id="name_plantation_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $name_plantationdata['rental_rate'] ?? '' }}"></td>

    <td><input type="text" id="name_plantation_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $name_plantationdata['any_other'] ?? '' }}"></td>
        
    
            </tr>    

            <tr>
                <td style="text-align:center;">
                    b
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                <td>
                 Cost of Plantation
                </td>
                
                <td></td>
                
               @php
    $cost_pantationdata = json_decode($datas->cost_pantation, true);
    @endphp
    <td>
        <input type="text" id="cost_pantation_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $cost_pantationdata['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="cost_pantation_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $cost_pantationdata['specification'] ?? '' }}">
    </td>

    <td><input type="text" id="cost_pantation_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $cost_pantationdata['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="cost_pantation_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $cost_pantationdata['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="cost_pantation_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $cost_pantationdata['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="cost_pantation_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $cost_pantationdata['subsidy_grant'] ?? '' }}">
    </td>
    
        @php
        $bankLonst = ($cost_pantationdata['total_investment_cost'] ?? 0) - ($cost_pantationdata['subsidy_grant'] ?? 0);
        $cpbla_sou = $bankLonst - ($cost_pantationdata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($cpbla_sou != 0)
        {{ $cpbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="cost_pantation_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $cost_pantationdata['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="cost_pantation_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $cost_pantationdata['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resitentdat = ($cost_pantationdata['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
        @if($resitentdat != 0)
        {{ $resitentdat }}
        @endif
    </td>
    
    @php
    $anudd = $cpbla_sou/2*12/100;
    @endphp

    <td>
        @if($anudd != 0)
        {{ $anudd }}
        @endif
    </td>
    
    @php
    $anufiue = ($cost_pantationdata['total_investment_cost'] ?? 0) / ($cost_pantationdata['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anufiue != 0)
        {{ $anufiue }}
        @endif
    </td>

    <td>
        <input type="text" id="cost_pantation_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $cost_pantationdata['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="cost_pantation_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $cost_pantationdata['annual_tax'] ?? '' }}">
    </td>



    <td>
        <input type="text" id="cost_pantation_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $cost_pantationdata['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
     @php
    $anurdep = ($cost_pantationdata['total_investment_cost'] ?? 0) / ($cost_pantationdata['economic_useful_life'] ?? 1);
    $anualfrdCost = $anurdep
    + ($cost_pantationdata['annual_insurance'] ?? 0)
    + ($cost_pantationdata['annual_tax'] ?? 0)
    + ($cost_pantationdata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualfrdCost != 0)
        {{ $anualfrdCost }}
        @endif
    </td>

    <td>
        <input type="text" id="cost_pantation_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $cost_pantationdata['rental_unit'] ?? '' }}">
    </td>

    <td> <input type="text" id="cost_pantation_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
    value="{{ $cost_pantationdata['rental_rate'] ?? '' }}"></td>

    <td><input type="text" id="cost_pantation_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
    value="{{ $cost_pantationdata['any_other'] ?? '' }}"></td>
    
    
            </tr>  
            
              <tr>
                <td style="text-align:center;">
                    c
                </td>
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Cost Infrastructure and Support Services
                </td>
                <td></td>
               @php
                $Infrastructuredata = json_decode($datas->Infrastructure, true);
                @endphp
                <td>
                    <input type="text" id="Infrastructure_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                    value="{{ $Infrastructuredata['number'] ?? '' }}">
                </td>
            
            
                <td>
                    <input type="text" id="Infrastructure_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                    value="{{ $Infrastructuredata['specification'] ?? '' }}">
                </td>
            
                <td><input type="text" id="Infrastructure_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                    value="{{ $Infrastructuredata['specification_unit'] ?? '' }}"></td>
            
                <td>
                    <input type="text" id="Infrastructure_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                    value="{{ $Infrastructuredata['year_of_asset_creation'] ?? '' }}">
                </td>
            
                <td>
                    <input type="text" id="Infrastructure_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                    value="{{ $Infrastructuredata['total_investment_cost'] ?? '' }}">
                </td>
            
                <td>
                    <input type="text" id="Infrastructure_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                    value="{{ $Infrastructuredata['subsidy_grant'] ?? '' }}">
                </td>
    
                @php
                $bankLoninfaCost = ($Infrastructuredata['total_investment_cost'] ?? 0) - ($Infrastructuredata['subsidy_grant'] ?? 0);
                $inbla_sou = $bankLoninfaCost - ($Infrastructuredata['balance_source_of_investment'] ?? 0);
                @endphp
        
            <td>
                @if($inbla_sou != 0)
                {{ $inbla_sou }}
                @endif
            </td>

            <td>
                <input type="text" id="Infrastructure_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                value="{{ $Infrastructuredata['balance_source_of_investment'] ?? '' }}">
            </td>
        
            <td>
                <input type="text" id="Infrastructure_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                value="{{ $Infrastructuredata['economic_useful_life'] ?? '' }}">
            </td>
            
            @php
            $resitentfdf = ($Infrastructuredata['total_investment_cost'] ?? 0) * 0.10;
            @endphp
        
            <td>
                @if($resitentfdf != 0)
                {{ $resitentfdf }}
                @endif
            </td>
    
            @php
            $anuda = $inbla_sou/2*12/100;
            @endphp
        
            <td>
                @if($anuda != 0)
                {{ $anuda }}
                @endif
            </td>
    
            @php
            $anul_depdd = ($Infrastructuredata['total_investment_cost'] ?? 0) / ($Infrastructuredata['economic_useful_life'] ?? 1);
            @endphp
        
            <td>
                @if($anul_depdd != 0)
                {{ $anul_depdd }}
                @endif
            </td>

            <td>
                <input type="text" id="Infrastructure_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                value="{{ $Infrastructuredata['annual_insurance'] ?? '' }}">
            </td>
        
            <td>
                <input type="text" id="Infrastructure_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                value="{{ $Infrastructuredata['annual_tax'] ?? '' }}">
            </td>
        


            <td>
                <input type="text" id="Infrastructure_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
                value="{{ $Infrastructuredata['annual_repair_and_maintenance'] ?? '' }}">
            </td>
            
            @php
            $anuldata_dep = ($Infrastructuredata['total_investment_cost'] ?? 0) / ($Infrastructuredata['economic_useful_life'] ?? 1);
            $anualfixdCosts = $anuldata_dep
            + ($Infrastructuredata['annual_insurance'] ?? 0)
            + ($Infrastructuredata['annual_tax'] ?? 0)
            + ($Infrastructuredata['annual_repair_and_maintenance'] ?? 0);
            @endphp
        
            <td>
                @if($anualfixdCosts != 0)
        {{ $anualfixdCosts }}
        @endif
            </td>

    <td>
        <input type="text" id="Infrastructure_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $Infrastructuredata['rental_unit'] ?? '' }}">
    </td>

    <td> <input type="text" id="Infrastructure_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
    value="{{ $Infrastructuredata['rental_rate'] ?? '' }}"></td>

    <td><input type="text" id="Infrastructure_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
    value="{{ $Infrastructuredata['any_other'] ?? '' }}"></td>
    
            </tr>  
            
               <tr>
                <td style="text-align:center;">
                    d
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Cost of other material
                </td>
                
                <td></td>
                @php
    $materialdata = json_decode($datas->material, true);
    @endphp
    <td>
        <input type="text" id="material_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $materialdata['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="material_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $materialdata['specification'] ?? '' }}">
    </td>

    <td><input type="text" id="material_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
    value="{{ $materialdata['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="material_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $materialdata['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="material_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $materialdata['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="material_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $materialdata['subsidy_grant'] ?? '' }}">
    </td>
    @php
        $banknCost = ($materialdata['total_investment_cost'] ?? 0) - ($materialdata['subsidy_grant'] ?? 0);
        $mabla_sou = $banknCost - ($materialdata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
         @if($mabla_sou != 0)
        {{ $mabla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="material_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $materialdata['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="material_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $materialdata['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resitentfw = ($materialdata['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    

    <td>
        @if($resitentfw != 0)
        {{ $resitentfw }}
        @endif
    </td>
    
    @php
    $anurr = $mabla_sou/2*12/100;
    @endphp

    <td>
       @if($anurr != 0)
        {{ $anurr }}
        @endif
    </td>
    
    @php
    $anulda_dep = ($materialdata['total_investment_cost'] ?? 0) / ($materialdata['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anulda_dep != 0)
        {{ $anulda_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="material_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $materialdata['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="material_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $materialdata['annual_tax'] ?? '' }}">
    </td>



    <td>
        <input type="text" id="material_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $materialdata['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anulrer_dep = ($materialdata['total_investment_cost'] ?? 0) / ($materialdata['economic_useful_life'] ?? 1);
    $anualfixdCosst = $anulrer_dep
    + ($materialdata['annual_insurance'] ?? 0)
    + ($materialdata['annual_tax'] ?? 0)
    + ($materialdata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
       @if($anualfixdCosst != 0)
{{ $anualfixdCosst }}
@endif
    </td>

    <td>
        <input type="text" id="material_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $materialdata['rental_unit'] ?? '' }}">
    </td>

    <td> <input type="text" id="material_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $materialdata['rental_rate'] ?? '' }}"></td>

    <td><input type="text" id="material_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $materialdata['any_other'] ?? '' }}"></td>
    
            </tr>  
            
               <tr>
                <td style="text-align:center;">
                    e
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Cost Labour / mechanization
                </td>
                <td></td>
               @php
    $labour_mechanizationdata = json_decode($datas->labour_mechanization, true);
    @endphp
    <td>
        <input type="text" id="labour_mechanization_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="labour_mechanization_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $labour_mechanizationdata['specification'] ?? '' }}">
    </td>

    <td><input type="text" id="labour_mechanization_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="labour_mechanization_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="labour_mechanization_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="labour_mechanization_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['subsidy_grant'] ?? '' }}">
    </td>
    
        @php
        $bankLonCostsa = ($labour_mechanizationdata['total_investment_cost'] ?? 0) - ($labour_mechanizationdata['subsidy_grant'] ?? 0);
        $bla_souds = $bankLonCostsa - ($labour_mechanizationdata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
      @if($bla_souds != 0)
        {{ $bla_souds }}
        @endif
    </td>

    <td>
        <input type="text" id="labour_mechanization_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="labour_mechanization_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['economic_useful_life'] ?? '' }}">
    </td>
    @php
    $resitenttion = ($labour_mechanizationdata['total_investment_cost'] ?? 0) * 0.10;
    @endphp
    
     <td>   
        @if($resitenttion != 0)
         {{ $resitenttion }}
        @endif
     </td>
     
    @php
    $anuoted = $bla_souds/2*12/100;
    @endphp

    <td>
        @if($anuoted != 0)
        {{ $anuoted }}
        @endif
    </td>
    
    
    @php
    $anul_depotdat = ($labour_mechanizationdata['total_investment_cost'] ?? 0) / ($labour_mechanizationdata['economic_useful_life'] ?? 1);
    @endphp

    <td>
         @if($anul_depotdat != 0)
        {{ $anul_depotdat }}
        @endif
    </td>

    

    <td>
        <input type="text" id="labour_mechanization_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="labour_mechanization_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['annual_tax'] ?? '' }}">
    </td>



    <td>
        <input type="text" id="labour_mechanization_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anulfda_dep = ($labour_mechanizationdata['total_investment_cost'] ?? 0) / ($labour_mechanizationdata['economic_useful_life'] ?? 1);
    $anualfixdCostlm = $anulfda_dep
    + ($labour_mechanizationdata['annual_insurance'] ?? 0)
    + ($labour_mechanizationdata['annual_tax'] ?? 0)
    + ($labour_mechanizationdata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
      @if($anualfixdCostlm != 0)
        {{ $anualfixdCostlm }}
        @endif
    </td>

    <td>
        <input type="text" id="labour_mechanization_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['rental_unit'] ?? '' }}">
    </td>

    <td> <input type="text" id="labour_mechanization_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['rental_rate'] ?? '' }}"></td>

    <td><input type="text" id="labour_mechanization_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $labour_mechanizationdata['any_other'] ?? '' }}"></td>
    
    </tr>  
            
             <tr>
                <td style="text-align:center;">
                    f
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Any other Fixed Cost
                </td>
                
                <td></td>
                
            @php
            $fixed_costdata = json_decode($datas->fixed_cost, true);
            @endphp
    <td>
        <input type="text" id="fixed_cost_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="fixed_cost_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $fixed_costdata['specification'] ?? '' }}">
    </td>

    <td><input type="text" id="fixed_cost_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['specification_unit'] ?? '' }}"></td>

    <td>
        <input type="text" id="fixed_cost_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="fixed_cost_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="fixed_cost_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
        $bankLonCostfix = ($fixed_costdata['total_investment_cost'] ?? 0) - ($fixed_costdata['subsidy_grant'] ?? 0);
        $fxbla_sou = $bankLonCostfix - ($fixed_costdata['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
       @if($fxbla_sou != 0)
        {{ $fxbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="fixed_cost_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="fixed_cost_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resitentfix = ($fixed_costdata['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
       @if($resitentfix != 0)
        {{ $resitentfix }}
        @endif
    </td>
    
    @php
    $anufix = $fxbla_sou/2*12/100;
    @endphp

    <td>
         @if($anufix != 0)
        {{ $anufix }}
        @endif
    </td>
    
      @php
    $anulgg_dep = ($fixed_costdata['total_investment_cost'] ?? 0) / ($fixed_costdata['economic_useful_life'] ?? 1);
    @endphp

    <td>
       @if($anulgg_dep != 0)
        {{ $anulgg_dep }}
        @endif
    </td>

    <td>
        <input type="text" id="fixed_cost_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="fixed_cost_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['annual_tax'] ?? '' }}">
    </td>



    <td>
        <input type="text" id="fixed_cost_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['annual_repair_and_maintenance'] ?? '' }}">
    </td>
    
    @php
    $anul_deps = ($fixed_costdata['total_investment_cost'] ?? 0) / ($fixed_costdata['economic_useful_life'] ?? 1);
    $anualfixdCostfix = $anul_deps
    + ($fixed_costdata['annual_insurance'] ?? 0)
    + ($fixed_costdata['annual_tax'] ?? 0)
    + ($fixed_costdata['annual_repair_and_maintenance'] ?? 0);
    @endphp

    <td>
        @if($anualfixdCostfix != 0)
        {{ $anualfixdCostfix }}
        @endif
    </td>

    <td>
        <input type="text" id="fixed_cost_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['rental_unit'] ?? '' }}">
    </td>

    <td> <input type="text" id="fixed_cost_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['rental_rate'] ?? '' }}"></td>

    <td><input type="text" id="fixed_cost_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $fixed_costdata['any_other'] ?? '' }}"></td>
</tr>  
            
 <tr>
    <td style="text-align:center;">
        8
    </td>


    <td>

    </td>

    <td>

    </td>

    <td>
    Any other infrastructure
    </td>
    
    <td></td>

    @php
    $other_infrastructureData = json_decode($datas->other_infrastructure, true);
    @endphp
    <td>
        <input type="text" id="other_infrastructure_number_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}" 
        value="{{ $other_infrastructureData['number'] ?? '' }}">
    </td>


    <td>
        <input type="text" id="other_infrastructure_specification_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['specification'] ?? '' }}">
    </td>
    
     <td><input type="text" id="other_infrastructure_specification_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['specification_unit'] ?? '' }}"></td>
    <td>
        <input type="text" id="other_infrastructure_year_of_asset_creation_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['year_of_asset_creation'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_infrastructure_total_investment_cost_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['total_investment_cost'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_infrastructure_subsidy_grant_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['subsidy_grant'] ?? '' }}">
    </td>
    
    @php
        $bankLonCostot = ($other_infrastructureData['total_investment_cost'] ?? 0) - ($other_infrastructureData['subsidy_grant'] ?? 0);
        $otbla_sou = $bankLonCostot - ($other_infrastructureData['balance_source_of_investment'] ?? 0);
        @endphp

    <td>
        @if($otbla_sou != 0)
        {{ $otbla_sou }}
        @endif
    </td>

    <td>
        <input type="text" id="other_infrastructure_balance_source_of_investment_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['balance_source_of_investment'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_infrastructure_economic_useful_life_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['economic_useful_life'] ?? '' }}">
    </td>
    
    @php
    $resitentot = ($other_infrastructureData['total_investment_cost'] ?? 0) * 0.10;
    @endphp

    <td>
         @if($resitentot != 0)
        {{ $resitentot }}
        @endif
    </td>
    
     @php
    $anuot = $otbla_sou/2*12/100;
    @endphp

    <td>
        @if($anuot != 0)
        {{ $anuot }}
        @endif
    </td>
    
    @php
    $anul_depot = ($other_infrastructureData['total_investment_cost'] ?? 0) / ($other_infrastructureData['economic_useful_life'] ?? 1);
    @endphp

    <td>
        @if($anul_depot != 0)
        {{ $anul_depot }}
        @endif
    </td>

    <td>
        <input type="text" id="other_infrastructure_annual_insurance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['annual_insurance'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_infrastructure_annual_tax_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['annual_tax'] ?? '' }}">
    </td>

    <td>
        <input type="text" id="other_infrastructure_annual_repair_and_maintenance_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['annual_repair_and_maintenance'] ?? '' }}">
    </td>

    @php
    $anul_depoh = ($other_infrastructureData['total_investment_cost'] ?? 0) / ($other_infrastructureData['economic_useful_life'] ?? 1);
    $anualfixdCostoh = $anul_depoh
    + ($other_infrastructureData['annual_insurance'] ?? 0)
    + ($other_infrastructureData['annual_tax'] ?? 0)
    + ($other_infrastructureData['annual_repair_and_maintenance'] ?? 0);
    @endphp
  

    <td>
         @if($anualfixdCostoh != 0)
        {{ $anualfixdCostoh }}
        @endif
    </td>
    <td>
         <input type="text" id="other_infrastructure_rental_unit_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
         value="{{ $other_infrastructureData['rental_unit'] ?? '' }}">
    </td>
        <td><input type="text" id="other_infrastructure_rental_rate_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
        value="{{ $other_infrastructureData['rental_rate'] ?? '' }}"></td>
        
         <td><input type="text" id="other_infrastructure_any_other_{{$datas->id}}_{{isset($datas->farmer_id) && $datas->farmer_id ? $datas->farmer_id : ''}}"
         value="{{ $other_infrastructureData['any_other'] ?? '' }}"></td>
    </tr>
            <td><button type="button" id="submitBtn" class="btn btn-primary submitBtn" data-id="{{ $datas->id }}" data-farmerId="{{ $datas->farmer_id }}">Submit Data</button></td>
        </table>
        </form>
        @endforeach
        
        @else
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
           
            <tr>
                <th style="text-align:center;">
                 S. No.
                </th>
                 <th>FARMER ID</th>
                 <th>Farmer Name</th>
                <th>
                   Infrastructure and Support Services
                </th>
                
                 <th>
                   YES/No
                </th>
                
                <th>
                    Number
                </th>
                
                <th>
                    Specification
                </th>
                
                <th>
                  Year of Asset creation (DD/MM/YY)
                </th>
                
                <th>
                    Total Investment/ Cost (Rs.)
                </th>
                
                <th>
                    Subsidy / Grant (Rs.)
                </th>
                
                <th>
                    Bank Loan Cost (Rs.)
                </th>
                
                  <th>
                    Balance Source of Investment (Rs.)
                </th>
                
                  <th>
                   Economic / Useful  Life (Year)
                </th>
                
                  <th>
                    Residual Value of Asset (Rs.)
                </th>
                
                  <th>
                    Annual Interest on Bank Loan(Rs.)
                </th>
                
                  <th>
                    Annual Depreciation (Rs.)
                </th>
                
                  <th>
                    Annual Insurance (Rs.)
                </th>
                
                  <th>
                    Annual Tax (Rs.)
                </th>
                
                  <th>
                   Annual Repair and Maintenance (Rs.)  
                </th>
                
                  <th>
                    Annual Repair and Maintenance (Rs.)
                </th>
                
                  <th>
                    Annual Fixed cost of Asset (Rs.)
                </th>
                
                  <th>
                    Rental Unit of Farm Asset in Cluster Area ( per hour/ per unit area per day / month / year ) 
                </th>
                
                  <th>
                    Rental Rate of Farm Asset in Cluster Area (Rs.) 
                </th>
                
                  <th>
                    Any Other
                </th>
                
            </tr>
        
            
            <tr>
                <td style="text-align:center;">
                    1
                </td>
                
                
            
                <td>
                   
                </td>
             
               
                <td>
                </td>
                

                <td style="font-weight:700;">
                    Irrigation Infrastructure
                </td>
                
                <td>0 for no 1 for yes</td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                <td>
                    Canal
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
              <td></td>
                <td></td>
            </tr>

            <tr>

                 <td style="text-align:center;">
                    b
                </td>
                <td>
                   
                </td>
                
                <td>
                  
                </td>
               
                <td>
                   Tubewell
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td></td>
                <td></td>
            </tr>

            <tr>
               <td style="text-align:center;">
                    c
                </td>
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 
                <td>
                   Engine / Motor / Solar
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                <td>
                   Pump sets ( Diesel/ electric/ Solar)
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    e
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                   Pond
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                 <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    f
                </td>
                
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                <td>
                  Sprinkler / drip irrigation System
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    g
                </td>
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                  Pump House
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    h
                </td>
                
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                <td>
                  Other
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>

            <tr>
                <td style="text-align:center;">
                    2
                </td>

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td style="font-weight:700;">
                  Farm Mechanization Infrastructure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                 <td>
                  Tractor
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                  Power Tiller
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                  Cultivator
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td>
                 Rotator
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    e
                </td>
               
                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                 <td>
                 Harrow
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    f
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td>
                 Leveller
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>

             <tr>
                <td style="text-align:center;">
                    g
                </td>

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td>
                 Plough (MB Plough / Disc Plough)
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    h
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Seed drill
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td> 
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    i
                </td>
             
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                   <td>
                 Seed Planter
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>

             <tr>
                <td style="text-align:center;">
                    j
                </td>

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td>
                 Seed cum fertilizer drill
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    k
                </td>
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Trolley
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    l
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Reaper cum binder
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    m
                </td>
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Husk Making Machine
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    n
                </td>
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Thresher
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
            </tr>
            
               <tr>
                <td style="text-align:center;">
                    o
                </td>
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Combine Harvester
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    p
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                Other
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td style="font-weight:700;">
                Storage Infrastructure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                Kothila / Deshi Storage Structure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    b
                </td>
             
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                   <td>
                Godown
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
            
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                    <td>
                Clod Storage
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>
                
                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                <td>
               Bulk Cooling Unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    e
                </td>
               
                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                 <td>
               Storage for fodder
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    f
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td>
                Other
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td style="font-weight:700;">
                Processing Infrastructure
                </td>
                
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td>
                Wheat Processing Unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
                

                
                <td>
                  
                </td>
                
                <td>
                   
                </td>
                                <td>
                 Oil Processing Unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    c
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td>
                 Sugarcane Processing Unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    d
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Dal Processing Unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    e
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Any Other Processing unit
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    5
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td style="font-weight:700;">
                 Marketing Infrastructure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                    a
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Kiran Outlets
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Grocery Outlets
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    c
                </td>
                
             
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                   <td>
                 Any Other Retail outlets
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    6
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td style="font-weight:700;">
                 Farm Infrastructure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
               <tr>
                <td style="text-align:center;">
                    a
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Shed (Kuchha)
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    b
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Shed (Pucca)
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>    
            
            <tr>
                <td style="text-align:center;">
                    7
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td style="font-weight:700;">
                 Investment under Plantation Crop (crop period more than 18 months) 
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>   
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                
             
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                   <td>
                 Name of Plantation Crop (Example : Tea, Apple, Mango, Orange, etc.)
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>    

            <tr>
                <td style="text-align:center;">
                    b
                </td>
                

                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                                <td>
                 Cost of Plantation
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
              <tr>
                <td style="text-align:center;">
                    c
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Cost Infrastructure and Support Services
                </td>
                <td></td>
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
               <tr>
                <td style="text-align:center;">
                    d
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Cost of other material
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
               <tr>
                <td style="text-align:center;">
                    e
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td>
                 Cost Labour / mechanization
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
             <tr>
                <td style="text-align:center;">
                    f
                </td>
                
              
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                  <td>
                 Any other Fixed Cost
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
             <tr>
                <td style="text-align:center;">
                    8
                </td>
                
               
                
                <td>
                   
                </td>
                
                <td>
                  
                </td>
                 <td style="font-weight:700;">
                 Any other infrastructure
                </td>
                <td></td>
                
                <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                  <td>
                   
                </td>
                   <td></td>
                <td></td>
            </tr>  
            
        </table>
        @endif
            
    </form>
    </div>
 </div>
 <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
 
 


 <script>
 document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll('.submitBtn').forEach(button => {
        button.addEventListener('click', function () {
            // Get the id and farmerId from the button's data attributes
            const id = this.getAttribute('data-id');
            const farmerId = this.getAttribute('data-farmerId');
            // Gather data for canel, tubewell, etc.  
            const canel = {
                number: document.getElementById(`canal_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`canal_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`canal_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`canel_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`canel_total_investment_cost_${id}_${farmerId}`).value,  
                subsidy_grant: document.getElementById(`canel_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`canel_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`canel_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`canel_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`canel_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`canel_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`canel_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`canel_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`canel_any_other_${id}_${farmerId}`).value,
            };
            const tubewell = {
                number: document.getElementById(`tubewell_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`tubewell_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`tubewell_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`tubewell_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`tubewell_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`tubewell_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`tubewell_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`tubewell_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`tubewell_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`tubewell_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`tubewell_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`tubewell_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`tubewell_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`tubewell_any_other_${id}_${farmerId}`).value,
            };
            
            const enginer_motor = {
                number: document.getElementById(`enginer_motor_solar_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`enginer_motor_solar_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`enginer_motor_solar_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`enginer_motor_solar_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`enginer_motor_solar_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`enginer_motor_solar_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`enginer_motor_solar_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`enginer_motor_solar_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`enginer_motor_solar_economic_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`enginer_motor_solar_economic_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`enginer_motor_solar_economic_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`enginer_motor_solar_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`enginer_motor_solar_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`enginer_motor_solar_any_other_${id}_${farmerId}`).value,
            };
            
            const pump_sets = {
                number: document.getElementById(`pump_sets_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`pump_sets_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`pump_sets_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`pump_sets_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`pump_sets_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`pump_sets_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`pump_sets_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`pump_sets_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`pump_sets_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`pump_sets_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`pump_sets_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`pump_sets_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`pump_sets_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`pump_sets_any_other_${id}_${farmerId}`).value,  
            };
            
            const pond = {
                number: document.getElementById(`pond_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`pond_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`pond_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`pond_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`pond_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`pond_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`pond_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`pond_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`pond_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`pond_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`pond_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`pond_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`pond_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`pond_any_other_${id}_${farmerId}`).value,
            };
            
            
            const irrigation_system = {
                number: document.getElementById(`irrigation_system_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`irrigation_system_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`irrigation_system_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`irrigation_system_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`irrigation_system_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`irrigation_system_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`irrigation_system_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`irrigation_system_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`irrigation_system_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`irrigation_system_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`irrigation_system_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`irrigation_system_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`irrigation_system_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`irrigation_system_any_other_${id}_${farmerId}`).value,
            }
            
            const pump_house = {
            number: document.getElementById(`pump_house_number_${id}_${farmerId}`).value,
            specification: document.getElementById(`pump_house_specification_${id}_${farmerId}`).value,
            specification_unit: document.getElementById(`pump_house_specification_unit_${id}_${farmerId}`).value,
            year_of_asset_creation: document.getElementById(`pump_house_year_of_asset_creation_${id}_${farmerId}`).value,
            total_investment_cost: document.getElementById(`pump_house_total_investment_cost_${id}_${farmerId}`).value,
            subsidy_grant: document.getElementById(`pump_house_subsidy_grant_${id}_${farmerId}`).value,
            balance_source_of_investment: document.getElementById(`pump_house_balance_source_of_investment_${id}_${farmerId}`).value,
            economic_useful_life: document.getElementById(`pump_house_economic_useful_life_${id}_${farmerId}`).value,
            annual_insurance: document.getElementById(`pump_house_annual_insurance_${id}_${farmerId}`).value,
            annual_tax: document.getElementById(`pump_house_annual_tax_${id}_${farmerId}`).value,
            annual_repair_and_maintenance: document.getElementById(`pump_house_annual_repair_and_maintenance_${id}_${farmerId}`).value,
            rental_unit: document.getElementById(`pump_house_rental_unit_${id}_${farmerId}`).value,
            rental_rate: document.getElementById(`pump_house_rental_rate_${id}_${farmerId}`).value,
            any_other: document.getElementById(`pump_house_any_other_${id}_${farmerId}`).value,
         };

            const irrigation_infrastructures_other = {
                number: document.getElementById(`irrigation_infrastructures_other_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`irrigation_infrastructures_other_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`irrigation_infrastructures_other_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`irrigation_infrastructures_other_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`irrigation_infrastructures_other_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`irrigation_infrastructures_other_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`irrigation_infrastructures_other_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`irrigation_infrastructures_other_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`irrigation_infrastructures_other_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`irrigation_infrastructures_other_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`irrigation_infrastructures_other_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`irrigation_infrastructures_other_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`irrigation_infrastructures_other_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`irrigation_infrastructures_other_any_other_${id}_${farmerId}`).value,
            };
            
            const tractor = {
                number: document.getElementById(`tractor_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`tractor_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`tractor_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`tractor_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`tractor_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`tractor_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`tractor_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`tractor_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`tractor_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`tractor_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`tractor_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`tractor_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`tractor_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`tractor_any_other_${id}_${farmerId}`).value,
            }

            const power_tiller = {
                number: document.getElementById(`power_tiller_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`power_tiller_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`power_tiller_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`power_tiller_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`power_tiller_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`power_tiller_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`power_tiller_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`power_tiller_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`power_tiller_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`power_tiller_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`power_tiller_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`power_tiller_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`power_tiller_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`power_tiller_any_other_${id}_${farmerId}`).value,
            }
            
            
            const cultivator = {
                number: document.getElementById(`cultivator_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`cultivator_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`cultivator_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`cultivator_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`cultivator_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`cultivator_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`cultivator_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`cultivator_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`cultivator_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`cultivator_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`cultivator_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`cultivator_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`cultivator_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`cultivator_any_other_${id}_${farmerId}`).value,
            }
            
            const rotator = {
                number: document.getElementById(`rotator_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`rotator_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`rotator_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`rotator_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`rotator_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`rotator_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`rotator_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`rotator_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`rotator_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`rotator_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`rotator_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`rotator_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`rotator_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`rotator_any_other_${id}_${farmerId}`).value,
            }
            
            const leveller = {
            number: document.getElementById(`leveller_number_${id}_${farmerId}`).value,
            specification: document.getElementById(`leveller_specification_${id}_${farmerId}`).value,
            specification_unit: document.getElementById(`leveller_specification_unit_${id}_${farmerId}`).value,
            year_of_asset_creation: document.getElementById(`leveller_year_of_asset_creation_${id}_${farmerId}`).value,
            total_investment_cost: document.getElementById(`leveller_total_investment_cost_${id}_${farmerId}`).value,
            subsidy_grant: document.getElementById(`leveller_subsidy_grant_${id}_${farmerId}`).value,
            balance_source_of_investment: document.getElementById(`leveller_balance_source_of_investment_${id}_${farmerId}`).value,
            economic_useful_life: document.getElementById(`leveller_economic_useful_life_${id}_${farmerId}`).value,
            annual_insurance: document.getElementById(`leveller_annual_insurance_${id}_${farmerId}`).value,
            annual_tax: document.getElementById(`leveller_annual_tax_${id}_${farmerId}`).value,
            annual_repair_and_maintenance: document.getElementById(`leveller_annual_repair_and_maintenance_${id}_${farmerId}`).value,
            rental_unit: document.getElementById(`leveller_rental_unit_${id}_${farmerId}`).value,
            rental_rate: document.getElementById(`leveller_rental_rate_${id}_${farmerId}`).value,
            any_other: document.getElementById(`leveller_any_other_${id}_${farmerId}`).value,
         }
         
            const plough = {
                number: document.getElementById(`plough_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`plough_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`plough_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`plough_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`plough_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`plough_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`plough_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`plough_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`plough_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`plough_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`plough_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`plough_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`plough_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`plough_any_other_${id}_${farmerId}`).value,
            }
            
            const speed_drill = {
                number: document.getElementById(`speed_drill_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`speed_drill_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`speed_drill_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`speed_drill_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`speed_drill_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`speed_drill_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`speed_drill_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`speed_drill_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`speed_drill_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`speed_drill_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`speed_drill_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`speed_drill_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`speed_drill_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`speed_drill_any_other_${id}_${farmerId}`).value,
            }
            
            const speed_planter = {
                number: document.getElementById(`speed_planter_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`speed_planter_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`speed_planter_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`speed_planter_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`speed_planter_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`speed_planter_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`speed_planter_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`speed_planter_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`speed_planter_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`speed_planter_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`speed_planter_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`speed_planter_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`speed_planter_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`speed_planter_any_other_${id}_${farmerId}`).value,
            }
            
            
            const speed_cum_fertilizer_drill = {
                number: document.getElementById(`speed_cum_fertilizer_drill_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`speed_cum_fertilizer_drill_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`speed_cum_fertilizer_drill_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`speed_cum_fertilizer_drill_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`speed_cum_fertilizer_drill_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`speed_cum_fertilizer_drill_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`speed_cum_fertilizer_drill_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`speed_cum_fertilizer_drill_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`speed_cum_fertilizer_drill_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`speed_cum_fertilizer_drill_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`speed_cum_fertilizer_drill_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`speed_cum_fertilizer_drill_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`speed_cum_fertilizer_drill_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`speed_cum_fertilizer_drill_any_other_${id}_${farmerId}`).value,
            }
            
            
            const trolley = {
                number: document.getElementById(`trolley_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`trolley_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`trolley_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`trolley_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`trolley_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`trolley_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`trolley_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`trolley_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`trolley_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`trolley_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`trolley_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`trolley_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`trolley_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`trolley_any_other_${id}_${farmerId}`).value,
            }
            
            const reaper_cum_binder = {
                number: document.getElementById(`reaper_cum_binder_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`reaper_cum_binder_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`reaper_cum_binder_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`reaper_cum_binder_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`reaper_cum_binder_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`reaper_cum_binder_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`reaper_cum_binder_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`reaper_cum_binder_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`reaper_cum_binder_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`reaper_cum_binder_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`reaper_cum_binder_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`reaper_cum_binder_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`reaper_cum_binder_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`reaper_cum_binder_any_other_${id}_${farmerId}`).value,
            }
            
            const bhusa_machine = {
                number: document.getElementById(`bhusa_machine_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`bhusa_machine_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`bhusa_machine_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`bhusa_machine_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`bhusa_machine_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`bhusa_machine_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment: document.getElementById(`bhusa_machine_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`bhusa_machine_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`bhusa_machine_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`bhusa_machine_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance: document.getElementById(`bhusa_machine_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`bhusa_machine_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`bhusa_machine_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`bhusa_machine_any_other_${id}_${farmerId}`).value,
            }
            
            const thresher = {
                number: document.getElementById(`thresher_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`thresher_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`thresher_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`thresher_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`thresher_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`thresher_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`thresher_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`thresher_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`thresher_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`thresher_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`thresher_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`thresher_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`thresher_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`thresher_any_other_${id}_${farmerId}`).value,
            }
            
            const combine_harvester = {
                number: document.getElementById(`combine_harvester_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`combine_harvester_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`combine_harvester_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`combine_harvester_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`combine_harvester_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`combine_harvester_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`combine_harvester_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`combine_harvester_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`combine_harvester_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`combine_harvester_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`combine_harvester_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`combine_harvester_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`combine_harvester_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`combine_harvester_any_other_${id}_${farmerId}`).value,
            }
            
            const farm_mechanisms_other = {
                number: document.getElementById(`farm_mechanisms_other_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`farm_mechanisms_other_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`farm_mechanisms_other_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`farm_mechanisms_other_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`farm_mechanisms_other_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`farm_mechanisms_other_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`farm_mechanisms_other_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`farm_mechanisms_other_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`farm_mechanisms_other_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`farm_mechanisms_other_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`farm_mechanisms_other_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`farm_mechanisms_other_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`farm_mechanisms_other_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`farm_mechanisms_other_any_other_${id}_${farmerId}`).value,
            }
            
            const deshi = {
                number: document.getElementById(`deshi_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`deshi_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`deshi_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`deshi_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`deshi_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`deshi_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`deshi_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`deshi_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`deshi_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`deshi_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`deshi_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`deshi_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`deshi_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`deshi_any_other_${id}_${farmerId}`).value,
            }
            
            const godown = {
                number: document.getElementById(`godown_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`godown_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`godown_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`godown_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`godown_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`godown_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`godown_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`godown_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`godown_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`godown_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`godown_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`godown_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`godown_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`godown_any_other_${id}_${farmerId}`).value,
            }
            
            const clod = {
                number: document.getElementById(`clod_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`clod_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`clod_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`clod_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`clod_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`clod_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`clod_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`clod_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`clod_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`clod_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`clod_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`clod_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`clod_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`clod_any_other_${id}_${farmerId}`).value,
            }
            
            const bulk_cooling = {
                number: document.getElementById(`bulk_cooling_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`bulk_cooling_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`bulk_cooling_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`bulk_cooling_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`bulk_cooling_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`bulk_cooling_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`bulk_cooling_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`bulk_cooling_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`bulk_cooling_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`bulk_cooling_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`bulk_cooling_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`bulk_cooling_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`bulk_cooling_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`bulk_cooling_any_other_${id}_${farmerId}`).value,
            }
            
            const fodder = {
                number: document.getElementById(`fodder_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`fodder_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`fodder_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`fodder_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`fodder_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`fodder_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`fodder_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`fodder_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`fodder_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`fodder_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`fodder_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`fodder_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`fodder_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`fodder_any_other_${id}_${farmerId}`).value,
            }
            
            const storage_structures_other = {
                number: document.getElementById(`storage_structures_other_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`storage_structures_other_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`storage_structures_other_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation: document.getElementById(`storage_structures_other_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost: document.getElementById(`storage_structures_other_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`storage_structures_other_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`storage_structures_other_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`storage_structures_other_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`storage_structures_other_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`storage_structures_other_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`storage_structures_other_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`storage_structures_other_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`storage_structures_other_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`storage_structures_other_any_other_${id}_${farmerId}`).value,
            }
            
            const wheat_processing = {
                number: document.getElementById(`wheat_processing_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`wheat_processing_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`wheat_processing_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`wheat_processing_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`wheat_processing_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`wheat_processing_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`wheat_processing_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`wheat_processing_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`wheat_processing_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`wheat_processing_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`wheat_processing_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`wheat_processing_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`wheat_processing_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`wheat_processing_any_other_${id}_${farmerId}`).value,
            }
            
            const oil_processing = {
                number: document.getElementById(`oil_processing_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`oil_processing_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`oil_processing_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`oil_processing_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`oil_processing_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`oil_processing_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`oil_processing_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`oil_processing_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`oil_processing_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`oil_processing_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`oil_processing_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`oil_processing_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`oil_processing_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`oil_processing_any_other_${id}_${farmerId}`).value,
            }
            
            const sugarcane_processing = {
                number: document.getElementById(`sugarcane_processing_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`sugarcane_processing_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`sugarcane_processing_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`sugarcane_processing_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`sugarcane_processing_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`sugarcane_processing_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`sugarcane_processing_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`sugarcane_processing_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`sugarcane_processing_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`sugarcane_processing_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`sugarcane_processing_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`sugarcane_processing_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`sugarcane_processing_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`sugarcane_processing_any_other_${id}_${farmerId}`).value,
            }

            const dal_processing = {
                number: document.getElementById(`dal_processing_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`dal_processing_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`dal_processing_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`dal_processing_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`dal_processing_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`dal_processing_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`dal_processing_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`dal_processing_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`dal_processing_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`dal_processing_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`dal_processing_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`dal_processing_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`dal_processing_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`dal_processing_any_other_${id}_${farmerId}`).value,
            }
            
            const other_processing = {
                number: document.getElementById(`other_processing_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`other_processing_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`other_processing_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`other_processing_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`other_processing_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`other_processing_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`other_processing_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`other_processing_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`other_processing_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`other_processing_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`other_processing_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`other_processing_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`other_processing_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`other_processing_any_other_${id}_${farmerId}`).value,
            }
            
            const kiran_outlets = {
                number: document.getElementById(`kiran_outlets_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`kiran_outlets_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`kiran_outlets_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`kiran_outlets_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`kiran_outlets_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`kiran_outlets_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`kiran_outlets_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`kiran_outlets_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`kiran_outlets_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`kiran_outlets_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`kiran_outlets_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`kiran_outlets_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`kiran_outlets_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`kiran_outlets_any_other_${id}_${farmerId}`).value,
            }
            
            const grossary_outlets = {
                number: document.getElementById(`grossary_outlets_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`grossary_outlets_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`grossary_outlets_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`grossary_outlets_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`grossary_outlets_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`grossary_outlets_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`grossary_outlets_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`grossary_outlets_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`grossary_outlets_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`grossary_outlets_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`grossary_outlets_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`grossary_outlets_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`grossary_outlets_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`grossary_outlets_any_other_${id}_${farmerId}`).value,
            }
            
            const other_outlets = {
                number: document.getElementById(`other_outlets_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`other_outlets_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`other_outlets_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`other_outlets_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`other_outlets_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`other_outlets_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`other_outlets_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`other_outlets_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`other_outlets_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`other_outlets_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`other_outlets_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`other_outlets_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`other_outlets_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`other_outlets_any_other_${id}_${farmerId}`).value,
            }


            const shed_kuchha = {
                number: document.getElementById(`shed_kuchha_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`shed_kuchha_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`shed_kuchha_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`shed_kuchha_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`shed_kuchha_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`shed_kuchha_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`shed_kuchha_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`shed_kuchha_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`shed_kuchha_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`shed_kuchha_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`shed_kuchha_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`shed_kuchha_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`shed_kuchha_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`shed_kuchha_any_other_${id}_${farmerId}`).value,
            }
            
            const shed_pucca = {
                number: document.getElementById(`shed_pucca_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`shed_pucca_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`shed_pucca_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`shed_pucca_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`shed_pucca_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`shed_pucca_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`shed_pucca_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`shed_pucca_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`shed_pucca_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`shed_pucca_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`shed_pucca_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`shed_pucca_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`shed_pucca_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`shed_pucca_any_other_${id}_${farmerId}`).value,
            }
            
            const name_plantation = {
                number: document.getElementById(`name_plantation_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`name_plantation_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`name_plantation_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`name_plantation_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`name_plantation_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`name_plantation_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`name_plantation_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`name_plantation_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`name_plantation_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`name_plantation_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`name_plantation_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`name_plantation_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`name_plantation_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`name_plantation_any_other_${id}_${farmerId}`).value,
            }
            
            const cost_pantation = {
                number: document.getElementById(`cost_pantation_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`cost_pantation_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`cost_pantation_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`cost_pantation_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`cost_pantation_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`cost_pantation_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`cost_pantation_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`cost_pantation_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`cost_pantation_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`cost_pantation_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`cost_pantation_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`cost_pantation_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`cost_pantation_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`cost_pantation_any_other_${id}_${farmerId}`).value,
            }
            
            const Infrastructure = {
                number: document.getElementById(`Infrastructure_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`Infrastructure_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`Infrastructure_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`Infrastructure_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`Infrastructure_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`Infrastructure_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`Infrastructure_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`Infrastructure_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`Infrastructure_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`Infrastructure_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`Infrastructure_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`Infrastructure_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`Infrastructure_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`Infrastructure_any_other_${id}_${farmerId}`).value,
            }
            
            const material = {
                number: document.getElementById(`material_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`material_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`material_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`material_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`material_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`material_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`material_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`material_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`material_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`material_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`material_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`material_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`material_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`material_any_other_${id}_${farmerId}`).value,
            }
            
            const labour_mechanization = {
                number: document.getElementById(`labour_mechanization_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`labour_mechanization_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`labour_mechanization_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`labour_mechanization_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`labour_mechanization_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`labour_mechanization_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`labour_mechanization_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`labour_mechanization_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`labour_mechanization_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`labour_mechanization_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`labour_mechanization_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`labour_mechanization_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`labour_mechanization_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`labour_mechanization_any_other_${id}_${farmerId}`).value,
            }
            
            const fixed_cost = {
                number: document.getElementById(`fixed_cost_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`fixed_cost_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`fixed_cost_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`fixed_cost_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`fixed_cost_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`fixed_cost_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`fixed_cost_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`fixed_cost_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`fixed_cost_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`fixed_cost_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`fixed_cost_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`fixed_cost_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`fixed_cost_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`fixed_cost_any_other_${id}_${farmerId}`).value,
            }
            
            const other_infrastructure = {
                number: document.getElementById(`other_infrastructure_number_${id}_${farmerId}`).value,
                specification: document.getElementById(`other_infrastructure_specification_${id}_${farmerId}`).value,
                specification_unit: document.getElementById(`other_infrastructure_specification_unit_${id}_${farmerId}`).value,
                year_of_asset_creation:
                document.getElementById(`other_infrastructure_year_of_asset_creation_${id}_${farmerId}`).value,
                total_investment_cost:
                document.getElementById(`other_infrastructure_total_investment_cost_${id}_${farmerId}`).value,
                subsidy_grant: document.getElementById(`other_infrastructure_subsidy_grant_${id}_${farmerId}`).value,
                balance_source_of_investment:
                document.getElementById(`other_infrastructure_balance_source_of_investment_${id}_${farmerId}`).value,
                economic_useful_life: document.getElementById(`other_infrastructure_economic_useful_life_${id}_${farmerId}`).value,
                annual_insurance: document.getElementById(`other_infrastructure_annual_insurance_${id}_${farmerId}`).value,
                annual_tax: document.getElementById(`other_infrastructure_annual_tax_${id}_${farmerId}`).value,
                annual_repair_and_maintenance:
                document.getElementById(`other_infrastructure_annual_repair_and_maintenance_${id}_${farmerId}`).value,
                rental_unit: document.getElementById(`other_infrastructure_rental_unit_${id}_${farmerId}`).value,
                rental_rate: document.getElementById(`other_infrastructure_rental_rate_${id}_${farmerId}`).value,
                any_other: document.getElementById(`other_infrastructure_any_other_${id}_${farmerId}`).value,
            }

            
            const data = {id, farmer_id: farmerId, canel, tubewell , enginer_motor , pump_sets , pond , irrigation_system , pump_house , pump_house , irrigation_infrastructures_other ,
               tractor , power_tiller , cultivator , rotator , leveller , plough , speed_drill , speed_planter , speed_cum_fertilizer_drill , trolley , reaper_cum_binder , bhusa_machine ,
               thresher , combine_harvester , farm_mechanisms_other , deshi , godown , clod , bulk_cooling , fodder , storage_structures_other , wheat_processing ,
               oil_processing , sugarcane_processing , dal_processing , other_processing , kiran_outlets , grossary_outlets , other_outlets , shed_kuchha ,shed_pucca,
               name_plantation , cost_pantation , Infrastructure , material , labour_mechanization , fixed_cost , other_infrastructure
            };

            console.log(data);

            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

            fetch('{{ route("anexure.two.update") }}', {
                method: 'POST', 
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                body: JSON.stringify(data)
            })
            .then(response => response.json())
            .then(data => {
                alert('Success! ' + JSON.stringify(data));
            })
            .catch(error => console.error('Error:', error));
        });
    });
});
 </script>

@endsection