<?php
    use App\Models\HectareMeasurement;
    use Illuminate\Support\Collection;
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
    
    $loggedInTeamLeaderId = $userDetail->team_leader_id;
    
    $uniqueUserIds = $data->pluck('user_id')->unique();
    $hectareMaster = HectareMeasurement::all();
    $targetTeamLeaderId = $hectareMaster->pluck('user_id')->filter()->unique()->values();
    $filteredCollection = $hectareMaster->filter(function ($item) use ($targetTeamLeaderId) {
        return $targetTeamLeaderId->contains($item->user_id);
    });
    
    
    
    
    
    // $hectare_master_unit = 'hectare';
    // foreach ($data as $entry1) {
    //     $user_id = $entry1->id; 
    //     if(isset($targetTeamLeaderId[0])){
    //         $teamLeadArray = (array)$targetTeamLeaderId[0] ?? [];
    //     }else{
    //         $teamLeadArray = [];
    //     }
       
    //     if(in_array($entry1->team_leader_id, $teamLeadArray)){
            
    //         foreach ($filteredCollection as $entry2){
          
    //             if($entry1->first_year_area_unit == $entry2->unit){
    //                 $entry1->first_year_area_unit = $hectare_master_unit;
    //                 $entry1->first_year_area = number_format($entry1->first_year_area/$entry2->value,3);
    //             }
                
    //             if($entry1->second_year_area_unit == $entry2->unit){
    //                 $entry1->second_year_area_unit = $hectare_master_unit;
    //                 $entry1->second_year_area = number_format($entry1->second_year_area/$entry2->value,3);
    //             }
                
    //             if($entry1->third_year_area_unit == $entry2->unit){
    //                 $entry1->third_year_area_unit = $hectare_master_unit;
    //                 $entry1->third_year_area = number_format($entry1->third_year_area/$entry2->value,3);
    //             }
                
    //             if($entry1->first_year_production_unit == $entry2->unit){
    //                 $entry1->first_year_production_unit = $hectare_master_unit;
    //                 $entry1->first_year_production = number_format($entry1->first_year_production/$entry2->value,3);
    //             }
                
    //             if($entry1->second_year_production_unit == $entry2->unit){
    //                 $entry1->second_year_production_unit = $hectare_master_unit;
    //                 $entry1->second_year_production = number_format($entry1->second_year_production/$entry2->value,3);
    //             }
                
    //             if($entry1->third_year_production_unit == $entry2->unit){
    //                 $entry1->third_year_production_unit = $hectare_master_unit;
    //                 $entry1->third_year_production = number_format($entry1->third_year_production/$entry2->value,3);
    //             }
            
    //         }
    //     }
    // }

?>
@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')

<div class="container-fluid">
    <div class="table-responsive">
         @if(Session::has('success'))
        <p class="alert alert-success">{{ Session::get('success') }}</p>
        @endif
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
             <br>
            @if($deshboard == 1)
        
                @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.three') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.three.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            @endif
           
         <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Cropping pattern, Area and Production & Marketed Surplus</h1>
        </div>
        
        
        @if($data->isNotEmpty())    
        @php
            $si = 1;
        @endphp
        @foreach($data as $datas)
        <form id="dataForm_{{ $datas->id }}" action="{{ route('anexure.three.update') }}" method="POST">
          @csrf
          <input type="hidden" name="data_id" id="data_id" value="">
          <input type="hidden" name="farmerid" id="farmerid" value="">
        <table class="table table-bordered">
          <thead>
            <tr>
                <?php
                $currentYear = date("Y");
                $previousYear = $currentYear - 1;
                $previoustwoYear = $currentYear - 2;
                $previousthreeYear = $currentYear - 3;
                ?>
              <th colspan="6" ></th>
              <th colspan="3" style="text-align:center;"><?php echo $previousthreeYear . "-" . $previoustwoYear; ?></th>
              <th colspan="3" style="text-align:center;"><?php echo $previoustwoYear . "-" . $previousYear; ?></th>
              <th colspan="11" style="text-align:center;"><?php echo $previousYear . "-" . $currentYear; ?></th>
            </tr>
            <tr>
              <th>Season</th>
              <th>S. No.</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Name of the Crop</th>
              <th>Variety</th>
              
              <th>Area</th>
               <th>Area (Unit)</th>
              <th>Production QTL</th>
              <th>Production (Unit)</th>
              <th>Productivity (Unit)/QTL</th>
              
              <th>Area</th>
              <th>Area (Unit)</th>
              <th>Production QTL</th>
              <th>Production (Unit)</th>
              <th>Productivity (Unit)/QTL</th>
              
              <th>Area</th>
              <th>Area (Unit)</th>
              <th>Production QTL</th>
              <th>Production (Unit)</th>
              <th>Productivity (Unit)/QTL</th>
              
              <th>AGR(Avarage Growth Rate)</th>
              <th>CAGR </th>
              
              <th>Marketed Surplus (Unit)/QTL</th>
              <th>Average Price of Selling </th>
              <th>Minimum Price</th>
              <th>Maximum Price</th>
              <th>NET AREA UNDER NEXT SEASON</th>
               
              <th>PROJECTED PRODUCTION</th>
              <th>PROJECTED MARKETED SURPLUS</th>
               
              <th>Remark</th>
              <th>Update</th>
            </tr>
          </thead>
          <tbody>


            <tr>
              <td style="font-weight:700;"rowspan="3"> {{$datas->season}}</td>
              <td>{{ $si++ }}</td>
              
              <td><input type="text"  disabled  value="{{$datas->farmer_code_id}}"></td>
              <td><input type="text"  disabled  value="{{$datas->farmer_first_name}} {{$datas->farmer_last_name}}"></td>
              <td> <input type="text"  disabled  value="{{$datas->crop_name}}"></td>
              
              <td><input type="text" name="variety" value="{{$datas->variety}}"></td>
              
                <td>
                  <input type="text" name="first_year_area" value="{{$datas->first_year_area}}">
                </td>

              
              <td>
                  <select class="form-select" name="first_year_area_unit">
                    <option value="acre" {{$datas->first_year_area_unit == 'acre' ? 'selected' : ''}}>acre</option>
                    <option value="bigha" {{$datas->first_year_area_unit == 'bigha' ? 'selected' : ''}}>bigha</option>
                    <option value="hectare" {{$datas->first_year_area_unit == 'hectare' ? 'selected' : ''}}>hectare</option>
                    <option value="other" {{$datas->first_year_area_unit == 'other' ? 'selected' : ''}}>Other</option>
                  </select>
              </td>
              
              <td><input type="text" name="first_year_production" value="{{$datas->first_year_production}}"></td>
              
              <td>
                  <select class="form-select" name="first_year_production_unit">
                    <option value="quintal" {{$datas->first_year_production_unit == 'quintal' ? 'selected' : ''}}>Quintal</option>
                    <option value="kilograms" {{$datas->first_year_production_unit == 'kilograms' ? 'selected' : ''}}>KiloGrams</option>
                    <option value="other" {{$datas->first_year_production_unit == 'other' ? 'selected' : ''}}>Other</option>
                  </select>
              </td>
              
               @php
                $first_year_area = $datas->first_year_area === 'null' ? 0 : $datas->first_year_area;
                $first_year_production = $datas->first_year_production ?? 0;
                $firstYproduct = $first_year_area > 0 ? ($first_year_production / $first_year_area) : 0;
                $firstYproduct = number_format($firstYproduct, 2);
               @endphp
            
              
              <td>{{$firstYproduct}}</td>
              
              
              <td>
                 <input type="text" name="second_year_area" value="{{$datas->second_year_area}}">
              </td>
              
              <td>
                  <select class="form-select" name="second_year_area_unit">
                    <option value="acre" {{$datas->second_year_area_unit == 'acre' ? 'selected' : ''}}>acre</option>
                    <option value="bigha" {{$datas->second_year_area_unit == 'bigha' ? 'selected' : ''}}>bigha</option>
                    <option value="hectare" {{$datas->second_year_area_unit == 'hectare' ? 'selected' : ''}}>hectare</option>
                    <option value="other" {{$datas->second_year_area_unit == 'other' ? 'selected' : ''}}>Other</option>
                  </select>
              </td>
              
              <td> <input type="text" name="second_year_production" value="{{$datas->second_year_production}}"></td>
              
              <td> 
                  <select class="form-select" name="second_year_production_unit">
                    <option value="quintal" {{$datas->second_year_production_unit == 'quintal' ? 'selected' : ''}}>Quintal</option>
                    <option value="kilograms" {{$datas->second_year_production_unit == 'kilograms' ? 'selected' : ''}}>KiloGrams</option>
                    <option value="other" {{$datas->second_year_production_unit == 'other' ? 'selected' : ''}}>Other</option>
                  </select>
              </td>
              
              @php
                $second_year_area = $datas->second_year_area === 'null' ? 0 : $datas->second_year_area;
                $second_year_production = $datas->second_year_production ?? 0;
                $secondYproduct = $second_year_area > 0 ? ($second_year_production / $second_year_area) : 0;
                $secondYproduct = number_format($secondYproduct, 2);
               @endphp
              
              
              <td> {{$secondYproduct}}</td>
              
              <td>
                  <input type="text" name="third_year_area" value="{{$datas->third_year_area}}">
              </td>
              
               <td>
                   <select class="form-select" name="third_year_area_unit">
                    <option value="acre" {{$datas->third_year_area_unit == 'acre' ? 'selected' : ''}}>acre</option>
                    <option value="bigha" {{$datas->third_year_area_unit == 'bigha' ? 'selected' : ''}}>bigha</option>
                    <option value="hectare" {{$datas->third_year_area_unit == 'hectare' ? 'selected' : ''}}>hectare</option>
                    <option value="other" {{$datas->third_year_area_unit == 'other' ? 'selected' : ''}}>Other</option>
                  </select>
               </td>
               
              <td><input type="text" name="third_year_production" value="{{$datas->third_year_production}}"></td>
              
               <td>
                  <select class="form-select" name="third_year_production_unit">
                    <option value="quintal" {{$datas->third_year_production_unit == 'quintal' ? 'selected' : ''}}>Quintal</option>
                    <option value="kilograms" {{$datas->third_year_production_unit == 'kilograms' ? 'selected' : ''}}>KiloGrams</option>
                    <option value="other" {{$datas->third_year_production_unit == 'other' ? 'selected' : ''}}>Other</option>
                  </select>
               </td>
               
               @php
                $third_year_area = $datas->third_year_area === 'null' ? 0 : $datas->third_year_area;
                $third_year_production = $datas->third_year_production ?? 0;
                $thirdYproduct = $third_year_area > 0 ? ($third_year_production / $third_year_area) : 0;
                $thirdYproduct = number_format($thirdYproduct, 2);
               @endphp
              

              <td>{{$thirdYproduct}}</td>
              
             <!--update agr formula-->
              
                  @php
                    $ma = $thirdYproduct; 
                    $ja = $secondYproduct; 
                    $ga = $firstYproduct;  
                    $ma = is_numeric($ma) ? (float) $ma : 0;
                    $ja = is_numeric($ja) ? (float) $ja : 0;
                    $ga = is_numeric($ga) ? (float) $ga : 0;
                    if ($ja != 0 && $ga != 0) { 
                        $agr = ((($ma - $ja) / $ja + ($ja - $ga) / $ga) / 2);
                    } else {
                        $agr = 0; 
                    }
                    $agr = $agr * 100;
                    $agr = number_format($agr, 2);
                 @endphp
                
                  <th>{{ $agr }} %</th>

              
              <!--update agr formula-->
              
               @php
                    $lc = is_numeric($datas->third_year_production) ? (float) $datas->third_year_production : 0;
                    $fc = is_numeric($datas->first_year_production) ? (float) $datas->first_year_production : 0;
                
                    if ($fc != 0) {
                        $cagr = pow(($lc / $fc), (1 / 3)) - 1; 
                    } else {
                        $cagr = 0;  
                    }
                    $cagr = $cagr * 100;
                    $cagr = number_format($cagr, 2);
                @endphp
                
                <th>{{ $cagr }} %</th>
              
              <td><input type="text" name="marketed_surplus" value="{{$datas->marketed_surplus}}"></td>
              <td><input type="text" name="average_price_selling" value="{{$datas->average_price_selling}}"></td>
              <td> <input type="text" name="min_rate" value="{{$datas->min_rate}}"></td>
              <td><input type="text" name="max_rate" value="{{$datas->max_rate}}"></td>
              
              <td><input type="text" name="net_area_under_nest_season" value="{{$datas->net_area_under_nest_season}}"></td>
              
              <!--PROJECTED PRODUCTION -->
              
               @php
                // Ensure each variable is treated as a number (integer or float)
                $t7 = is_numeric($datas->net_area_under_nest_season) ? (float) $datas->net_area_under_nest_season : 0; 
                
                // Convert percentage values to decimals (divide by 100)
                $n7 = is_numeric($agr) ? (float) $agr / 100 : 0; 
                $m7 = is_numeric($thirdYproduct) ? (float) $thirdYproduct : 0;
                $o7 = is_numeric($cagr) ? (float) $cagr / 100 : 0; 
                
                // Calculate projectPro with the numeric values
                $projectPro = $t7 * $m7 * (1 + min($n7, $o7));
                $projectPro1 = number_format($projectPro, 2);
               @endphp
            
              <td>{{ $projectPro1 }}</td>
              
              
              
             @php
                $u7 = is_numeric($projectPro1) ? (float) $projectPro1 : 0;
                $p7 = is_numeric($datas->marketed_surplus) ? (float) $datas->marketed_surplus : 0;
                $l7 = is_numeric($datas->third_year_production) ? (float) $datas->third_year_production : 0;
                
                if ($l7 != 0) {
                    $projectmar = ($u7 * $p7) / $l7;
                } else {
                    $projectmar = 0;
                }
                $projectmar = number_format($projectmar, 2);
            @endphp
            
            <td>{{ $projectmar }}</td>

              
              <!--PROJECTED MARKETED SURPLUS -->
              
              <td><input type="text" name="remark" value="{{$datas->remark}}"></td>
              
               <input type="text" name="id"  value="{{$datas->id}}" hidden>
               <input type="text" name="farmarid" value="{{$datas->farmer_id}}" hidden>
              
              <td><button type="button" class="btn btn-primary" data-id="{{$datas->id}}" data-farmerid="{{$datas->farmer_id}}">Update</button></td>
              
            </tr>
          </tbody>
        </table>
        </form>
        @endforeach
        @else
        <table class="table table-bordered">
          <thead>
              
            <tr>
                <?php
                $currentYear = date("Y");
                $previousYear = $currentYear - 1;
                $previoustwoYear = $currentYear - 2;
                $previousthreeYear = $currentYear - 3;
                ?>
              <th colspan="6" ></th>
              <th colspan="3" style="text-align:center;"><?php echo $previousthreeYear . "-" . $previoustwoYear; ?></th>
              <th colspan="3" style="text-align:center;"><?php echo $previoustwoYear . "-" . $previousYear; ?></th>
              <th colspan="11" style="text-align:center;"><?php echo $previousYear . "-" . $currentYear; ?></th>
            </tr>
            
            <tr>
              <th>Season</th>
              <th>S. No.</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Name of the Crop</th>
              <th>Variety</th>
              <th>Area (Unit)</th>
              <th>Production (Unit)/QTL</th>
              <th>Productivity (Unit)/QTL</th>
              <th>Area (Unit)</th>
              <th>Production (Unit)/QTL</th>
              <th>Productivity (Unit)/QTL</th>
              <th>Area (Unit)</th>
              <th>Production (Unit)/QTL</th>
              <th>Productivity (Unit)/QTL</th>
              <th>AGR(Avarage Growth Rate)</th>
              <th>CAGR </th>
              <th>Marketed Surplus (Unit)/QTL</th>
              <th>Average Price of Selling </th>
              <th>Minimum Price</th>
              <th>Maximum Price</th>
              <th>NET AREA UNDER NEXT SEASON</th>
              <th>PROJECTED PRODUCTION</th>
              <th>PROJECTED MARKETED SURPLUS</th>
              <th>Remark</th>
            </tr>
            
          </thead>
          <tbody>

            <tr>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
               <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
                <td></td>
              <td></td>
              <td></td>
            </tr>

            <tr>
              <td style="font-weight:700;"rowspan="3"> Season</td>
             <td>1</td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td>
                  
              </td>
               <th></th>
              <th></th>
              <td></td>
              <td></td>
              <td>
                  
              </td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td> </td>
              <td></td>
              <td></td>
              </tr><tr>
                    <td></td>
              <td></td>
              <td></td>
            </tr>
            
          </tbody>
        </table>
        @endif
        
        </div>
    </div>
    
    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <script>
         $(document).ready(function() {
        function submitForm(id, farmerid) {
            var form = $('#dataForm_' + id);
            if (form.length) {
                form.submit();
            }
            $('#data_id').val(id); 
            $('#farmerid').val(farmerid); 
        }
            $('.btn-primary').on('click', function() {
                var id = $(this).data('id');
                var farmerid = $(this).data('farmerid');
                submitForm(id, farmerid);
            });
        });
    </script>
    
    
@endsection