<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>
@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            @if($deshboard == 1)
        
            @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.six') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.six.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            @endif
        </div>
        
        @if($data->isNotEmpty()) 
        @php
            $si = 1;
        @endphp
        @foreach($data as $datas)
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">A . Infrastructure and Support Services</h1>
        </div>
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Unit Rate</th>
             <th>Amt (Rs.)</th>
             <th>Annulised Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
            <tr>
            @php
             $shop_permanent = json_decode($datas->cost_of_establishment_of_input_shop_permanent, true);
            @endphp
            <td>{{ $si++ }}</td>
            <td>{{$datas->farmer_code_id}}</td>
            <td>{{$datas->first_name}} {{$datas->last_name}}</td>
            <td>Cost of establishment of Input Shop Permanent</td>
            <td>{{ $shop_permanent['unit'] ?? '' }}</td>
            <td>{{ $shop_permanent['unitRate'] ?? '' }}</td>
            <td>{{ $shop_permanent['amount'] ?? '' }}</td>
            
             @php
                $annualizedcostPer = isset($shop_permanent['amount']) && isset($perYear->year) && $perYear->year != 0 
                    ? $shop_permanent['amount'] / $perYear->year 
                    : null;
            @endphp
            <td>{{ $annualizedcostPer ?? '' }}</td>
            
            
            <td>{{ $shop_permanent['remark'] ?? '' }}</td>
         </tr>
            
         <tr>
            @php
             $shop_temporary = json_decode($datas->cost_of_establishment_of_input_shop_temporary, true);
            @endphp
            <td>2</td>
            <td></td>
            <td></td>
            <td>Cost of establishment of Input Shop Temporary</td>
            <td>{{ $shop_temporary['unit'] ?? '' }}</td>
            <td>{{ $shop_temporary['unitRate'] ?? '' }}</td>
            <td>{{ $shop_temporary['amount'] ?? '' }}</td>
            
            @php
                $annualizedcosttemp = isset($shop_temporary['amount']) && isset($tempYear->year) && $tempYear->year != 0 
                    ? $shop_temporary['amount'] / $tempYear->year 
                    : null;
            @endphp
            
            <td>{{ $annualizedcosttemp ?? '' }}</td>
            
            <td>{{ $shop_temporary['remark'] ?? '' }}</td>
         </tr> 
         
         
         <tr>
            @php
             $stostri = json_decode($datas->storage_structure_of_input, true);
            @endphp
            <td>2</td>
            <td></td>
            <td></td>
            <td>Cost Storage Structure for Inputs</td>
            <td>{{ $stostri['unit'] ?? '' }}</td>
            <td>{{ $stostri['unitRate'] ?? '' }}</td>
            <td>{{ $stostri['amount'] ?? '' }}</td>
            
            @php
                $coststrogedata = isset($stostri['amount']) && isset($coststorage->year) && $coststorage->year != 0 
                    ? $stostri['amount'] / $coststorage->year 
                    : null;
            @endphp
            
            <td>{{ $coststrogedata ?? '' }}</td>
            <td>{{ $stostri['remark'] ?? '' }}</td>
         </tr>
         
          <tr>
             @php
             $ss = json_decode($datas->other_infrastructure_input, true);
            @endphp
            <td>3</td>
            <td></td>
            <td></td>
            <td>Cost other Infrastructure for Inputs</td>
            <td>{{ $ss['unit'] ?? '' }}</td>
            <td>{{ $ss['unitRate'] ?? '' }}</td>
            <td>{{ $ss['amount'] ?? '' }}</td>
            <td>{{ $ss['annualCost'] ?? '' }}</td>
            <td>{{ $ss['remark'] ?? '' }}</td>
         </tr>  
         
          <tr>
            @php
             $me = json_decode($datas->monthly_expenses_on_electricity, true);
            @endphp
            <td>4</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td>{{ $me['unit'] ?? '' }}</td>
            <td>{{ $me['unitRate'] ?? '' }}</td>
            <td>{{ $me['amount'] ?? '' }}</td>
            
            @php
                $monthelectricdata = isset($me['amount']) && isset($monthElectricity->year) && $monthElectricity->year != 0 
                    ? $me['amount'] / $monthElectricity->year 
                    : null;
            @endphp
            
            <td>{{ $monthelectricdata ?? '' }}</td>
            
            <td>{{ $me['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
             $mem = json_decode($datas->monthly_expenses_on_manpower, true);
            @endphp
            <td>5</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Monthly Expenses on Manpower</td>
            <td>{{ $mem['unit'] ?? '' }}</td>
            <td>{{ $mem['unitRate'] ?? '' }}</td>
            <td>{{ $mem['amount'] ?? '' }}</td>
            <td>{{ $mem['annualCost'] ?? '' }}</td>
            <td>{{ $mem['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
              @php
             $mr = json_decode($datas->monthly_rent, true);
            @endphp
            <td>6</td>
             <td></td>
            <td></td>
            <td>Monthly rent ( If shop is on rent)</td>
            <td>{{ $mr['unit'] ?? '' }}</td>
            <td>{{ $mr['unitRate'] ?? '' }}</td>
            <td>{{ $mr['amount'] ?? '' }}</td>
            <td>{{ $mr['annualCost'] ?? '' }}</td>
            <td>{{ $mr['remark'] ?? '' }}</td>
         </tr> 
         
           <tr>
             @php
             $mte = json_decode($datas->monthly_travelling_expense, true);
            @endphp
            <td>7</td>
             <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
           <td>{{ $mte['unit'] ?? '' }}</td>
            <td>{{ $mte['unitRate'] ?? '' }}</td>
            <td>{{ $mte['amount'] ?? '' }}</td>
            <td>{{ $mte['annualCost'] ?? '' }}</td>
            <td>{{ $mte['remark'] ?? '' }}</td>
         </tr> 
         
           <tr>
            @php
             $any_ot = json_decode($datas->any_other, true);
            @endphp
            <td>8</td>
             <td></td>
            <td></td>
            <td>Any Other</td>
            <td>{{ $any_ot['unit'] ?? '' }}</td>
            <td>{{ $any_ot['unitRate'] ?? '' }}</td>
            <td>{{ $any_ot['amount'] ?? '' }}</td>
            <td>{{ $any_ot['annualCost'] ?? '' }}</td>
            <td>{{ $any_ot['remark'] ?? '' }}</td>
         </tr> 
         
         
         <tr>
            @php
             $aici = json_decode($datas->annual_intt_on_capital_investment, true);
            @endphp
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Intt on Capital Investment</td>
            <td>{{ $aici['unit'] ?? '' }}</td>
            <td>{{ $aici['unitRate'] ?? '' }}</td>
            <td>{{ $aici['amount'] ?? '' }}</td>
            <td>{{ $aici['annualCost'] ?? '' }}</td>
            <td>{{ $aici['remark'] ?? '' }}</td>
         </tr> 
         
          @php
            $sumOfannualdata = 
                ($shop_permanent['amount'] ?? 0) + 
                ($shop_temporary['amount'] ?? 0) + 
                ($stostri['amount'] ?? 0) + 
                ($ss['amount'] ?? 0) + 
                ($me['amount'] ?? 0) + 
                ($mem['amount'] ?? 0) +     
                ($mr['amount'] ?? 0) + 
                ($mte['amount'] ?? 0) + 
                ($any_ot['amount'] ?? 0) + 
                ($aici['amount'] ?? 0);
            @endphp
         
         
         <tr>
            <td></td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of CA / PHC</td>
            <td></td>
            <td></td>
             <td style="font-weight:700;">{{$sumOfannualdata}}</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            @php
             $awc = json_decode($datas->annual_intt_on_working_capital, true);
            @endphp
            <td>10</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Annual Intt on Working Capital</td>
            <td>{{ $awc['unit'] ?? '' }}</td>
            <td>{{ $awc['unitRate'] ?? '' }}</td>
            <td>{{ $awc['amount'] ?? '' }}</td>
            <td>{{ $awc['annualCost'] ?? '' }}</td>
            <td>{{ $awc['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
             $pfv = json_decode($datas->purchase_from_farmer_at_village, true);
            @endphp
            <td>11</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at village/ Farm Gate Level ?</td>
            <td>{{ $pfv['unit'] ?? '' }}</td>
            <td>{{ $pfv['unitRate'] ?? '' }}</td>
            <td>{{ $pfv['amount'] ?? '' }}</td>
            <td>{{ $pfv['annualCost'] ?? '' }}</td>
            <td>{{ $pfv['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
             $localMandi = json_decode($datas->local_mandi, true);
            @endphp
            <td>12</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi ?</td>
            <td>{{ $localMandi['unit'] ?? '' }}</td>
            <td>{{ $localMandi['unitRate'] ?? '' }}</td>
            <td>{{ $localMandi['amount'] ?? '' }}</td>
            <td>{{ $localMandi['annualCost'] ?? '' }}</td>
            <td>{{ $localMandi['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
             @php
             $preMech = json_decode($datas->prevalent_purchase_mechanism, true);
            @endphp
            <td>13</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism ( Village Level/ local Mandi/ APMC)</td>
            <td>{{ $preMech['unit'] ?? '' }}</td>
            <td>{{ $preMech['unitRate'] ?? '' }}</td>
            <td>{{ $preMech['amount'] ?? '' }}</td>
            <td>{{ $preMech['annualCost'] ?? '' }}</td>
            <td>{{ $preMech['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
            <td>14</td>
             <td></td>
            <td></td>
            <td>Any Other Channel</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            @php
             $dopc = json_decode($datas->duration_of_purchase_on_credit, true);
            @endphp
            <td>15</td> 
             <td></td>
            <td></td>
            <td>Duration of purchase on credit</td>
            <td>{{ $dopc['unit'] ?? '' }}</td>
            <td>{{ $dopc['unitRate'] ?? '' }}</td>
            <td>{{ $dopc['amount'] ?? '' }}</td>
            <td>{{ $dopc['annualCost'] ?? '' }}</td>
            <td>{{ $dopc['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
             $dsc = json_decode($datas->duration_sale_credit, true);
            @endphp
            <td>16</td>
             <td></td>
            <td></td>
            <td>Duration of Sale credit</td>
            <td>{{ $dsc['unit'] ?? '' }}</td>
            <td>{{ $dsc['unitRate'] ?? '' }}</td>
            <td>{{ $dsc['amount'] ?? '' }}</td>
            <td>{{ $dsc['annualCost'] ?? '' }}</td>
            <td>{{ $dsc['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
             $iacp = json_decode($datas->input_advance_credit_producer, true);
            @endphp
            <td>17</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Input / advance credit to producer (% of the estimated sale)</td>
            <td>{{ $iacp['unit'] ?? '' }}</td>
            <td>{{ $iacp['unitRate'] ?? '' }}</td>
            <td>{{ $iacp['amount'] ?? '' }}</td>
            <td>{{ $iacp['annualCost'] ?? '' }}</td>
            <td>{{ $iacp['remark'] ?? '' }}</td>
         </tr> 
         
         
        <tr>
            @php
             $anyinfo = json_decode($datas->any_other_information, true);
            @endphp
            <td>18</td>
            <td></td>
            <td></td>
            <td>Any Other Information</td>
            <td>{{ $anyinfo['unit'] ?? '' }}</td>
            <td>{{ $anyinfo['unitRate'] ?? '' }}</td>
            <td>{{ $anyinfo['amount'] ?? '' }}</td>
            <td>{{ $anyinfo['annualCost'] ?? '' }}</td>
            <td>{{ $anyinfo['remark'] ?? '' }}</td>
         </tr> 
         
        </tbody>
  </table>
        
        <br>
        <div class="table-responsive">
          <h1 class="h3 mb-0 text-gray-800">B . Business parameters</h1>
          <br>
         <table class="table table-bordered ">
            <thead>
              <tr>
                <th>S. No.</th>
                <th>FARMER ID</th>
                <th>Farmer Name</th>
    
                <th>Particulars of Inputs</th>
                <th>Unit</th>
                <th>Name of Product</th>
                <th>Unit (quantity)</th>
                <th>Average Rate (Rs./Unit Quantity)</th>
                <th>Min Rate (Rs./Unit Quantity)</th>
                <th>Max Rate (Rs./Unit Quantity)</th>
                <th>Remark</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>I</td>
                
                <td>{{$datas->farmer_code_id}}</td>
                <td>{{$datas->first_name}} {{$datas->last_name}}</td>
                <td style="font-weight:700;">Average Purchase Price</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>   
             
            <tr>
                 @php
                    $apa = json_decode($datas->averag_purchase_a, true);
                 @endphp
                <td></td>
                <td></td>
                <td></td>
                <td>Grade A (mention applicable grade specification)</td>
                 <td></td>
                 <td>{{ $apa['name'] ?? '' }}</td>
                 <td> {{ $apa['unit'] ?? '' }}</td>
                 <td>{{ $apa['averate_rate'] ?? '' }}</td>
                 <td>{{ $apa['min_variation'] ?? '' }}</td>
                <td>{{ $apa['max_variation'] ?? '' }}</td>
                <td>{{ $apa['remarks'] ?? '' }}</td>
             </tr>
             
               <tr>
                   @php
                    $apb = json_decode($datas->averag_purchase_b, true);
                 @endphp
                <td></td>
                <td></td>
                <td></td>
                <td>Grade B (mention applicable grade specification)</td>
               <td></td>
                 <td>{{ $apb['name'] ?? '' }}</td>
                 <td> {{ $apb['unit'] ?? '' }}</td>
                 <td>{{ $apb['averate_rate'] ?? '' }}</td>
                 <td>{{ $apb['min_variation'] ?? '' }}</td>
                <td>{{ $apb['max_variation'] ?? '' }}</td>
                <td>{{ $apb['remarks'] ?? '' }}</td>
             </tr>
             
               <tr>
                   @php
                    $apc = json_decode($datas->averag_purchase_c, true);
                 @endphp
                <td></td>  
                <td></td>
                <td></td>
                <td>Grade C (mention applicable grade specification)</td>
                <td></td>
                <td>{{ $apc['name'] ?? '' }}</td>
                 <td> {{ $apc['unit'] ?? '' }}</td>
                 <td>{{ $apc['averate_rate'] ?? '' }}</td>
                 <td>{{ $apc['min_variation'] ?? '' }}</td>
                <td>{{ $apc['max_variation'] ?? '' }}</td>
                <td>{{ $apc['remarks'] ?? '' }}</td>
             </tr>
             
              <tr>
                   @php
                    $apd = json_decode($datas->averag_purchase_d, true);
                 @endphp
                <td></td>  
                <td></td>
                <td></td>
                <td>Grade D (mention applicable grade specification)</td>
                <td></td>
               <td>{{ $apd['name'] ?? '' }}</td>
                 <td> {{ $apd['unit'] ?? '' }}</td>
                 <td>{{ $apd['averate_rate'] ?? '' }}</td>
                 <td>{{ $apd['min_variation'] ?? '' }}</td>
                <td>{{ $apd['max_variation'] ?? '' }}</td>
                <td>{{ $apd['remarks'] ?? '' }}</td>
             </tr>
             
             
             
              <tr>
                <td>II</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Cost of Value Addition</td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                   @php
                    $phc = json_decode($datas->pre_harvesting_contractor_cost, true);
                 @endphp
                <td>a</td>
                <td></td>
                <td></td>
                <td>Pre-Harvesting Contractor Cost</td>
                <td></td>
                <td>{{ $phc['name'] ?? '' }}</td>
                 <td> {{ $phc['unit'] ?? '' }}</td>
                 <td>{{ $phc['averate_rate'] ?? '' }}</td>
                 <td>{{ $phc['min_variation'] ?? '' }}</td>
                <td>{{ $phc['max_variation'] ?? '' }}</td>
                <td>{{ $phc['remarks'] ?? '' }}</td>
             </tr> 
             
              <tr>
                   @php
                    $hc = json_decode($datas->harvesting_cost, true);
                 @endphp
                <td>b</td>
                   <td></td>
                <td></td>
                <td>Harvesting Cost</td>
                <td></td>
                <td>{{ $hc['name'] ?? '' }}</td>
                 <td> {{ $hc['unit'] ?? '' }}</td>
                 <td>{{ $hc['averate_rate'] ?? '' }}</td>
                 <td>{{ $hc['min_variation'] ?? '' }}</td>
                <td>{{ $hc['max_variation'] ?? '' }}</td>
                <td>{{ $hc['remarks'] ?? '' }}</td>
             </tr> 
             
               <tr>
                @php
                    $tran_cost = json_decode($datas->transportation_cost, true);
                 @endphp
                <td>c</td>
                   <td></td>
                <td></td>
                <td>Transportation Cost</td>
                <td></td>
                <td>{{ $tran_cost['name'] ?? '' }}</td>
                 <td> {{ $tran_cost['unit'] ?? '' }}</td>
                 <td>{{ $tran_cost['averate_rate'] ?? '' }}</td>
                 <td>{{ $tran_cost['min_variation'] ?? '' }}</td>
                <td>{{ $tran_cost['max_variation'] ?? '' }}</td>
                <td>{{ $tran_cost['remarks'] ?? '' }}</td>
             </tr> 
             
             
             <tr>
                  @php
                    $lauc = json_decode($datas->loading_and_unloading_charges, true);
                 @endphp
                <td>d</td>
                   <td></td>
                <td></td>
                <td>Loading and Unloading Charges</td>
                <td></td>
                <td>{{ $lauc['name'] ?? '' }}</td>
                 <td> {{ $lauc['unit'] ?? '' }}</td>
                 <td>{{ $lauc['averate_rate'] ?? '' }}</td>
                 <td>{{ $lauc['min_variation'] ?? '' }}</td>
                <td>{{ $lauc['max_variation'] ?? '' }}</td>
                <td>{{ $lauc['remarks'] ?? '' }}</td>
             </tr> 
             
              <tr>
                  @php
                    $prmary_proCost = json_decode($datas->primary_processing_cost, true);
                    @endphp
                <td>e</td>
                   <td></td>
                <td></td>
                <td>Primary Processing Cost</td>
                <td></td>
                <td>{{ $prmary_proCost['name'] ?? '' }}</td>
                <td> {{ $prmary_proCost['unit'] ?? '' }}</td>
                <td>{{ $prmary_proCost['averate_rate'] ?? '' }}</td>
                <td>{{ $prmary_proCost['min_variation'] ?? '' }}</td>
                <td>{{ $prmary_proCost['max_variation'] ?? '' }}</td>
                <td>{{ $prmary_proCost['remarks'] ?? '' }}</td>
             </tr> 
             
              <tr>
                   @php
                $dry_loss = json_decode($datas->drying_loss_or_any_other_loss, true);
                @endphp
                <td>f</td>
                <td></td>
                <td></td>
                <td>Drying Loss or any other loss</td>
                <td></td>
              <td>{{ $dry_loss['name'] ?? '' }}</td>
                <td> {{ $dry_loss['unit'] ?? '' }}</td>
                <td>{{ $dry_loss['averate_rate'] ?? '' }}</td>
                <td>{{ $dry_loss['min_variation'] ?? '' }}</td>
                <td>{{ $dry_loss['max_variation'] ?? '' }}</td>
                <td>{{ $dry_loss['remarks'] ?? '' }}</td>
             </tr> 
             
             <tr>
                  @php
                $mandi_fees = json_decode($datas->mandi_fees, true);
                @endphp
                <td>g</td>
                <td></td>
                <td></td>
                <td>Mandi fees /Tax/ Commission</td>
                <td></td>
                 <td>{{ $mandi_fees['name'] ?? '' }}</td>
                <td> {{ $mandi_fees['unit'] ?? '' }}</td>
                <td>{{ $mandi_fees['averate_rate'] ?? '' }}</td>
                <td>{{ $mandi_fees['min_variation'] ?? '' }}</td>
                <td>{{ $mandi_fees['max_variation'] ?? '' }}</td>
                <td>{{ $mandi_fees['remarks'] ?? '' }}</td>
             </tr> 
             
              <tr>
                   @php
                    $packingex = json_decode($datas->packaging_expenses, true);
                    @endphp
                <td>h</td>
                <td></td>
                <td></td>
                <td>Packaging expenses</td>
                <td></td>
                 <td>{{ $packingex['name'] ?? '' }}</td>
                <td> {{ $packingex['unit'] ?? '' }}</td>
                <td>{{ $packingex['averate_rate'] ?? '' }}</td>
                <td>{{ $packingex['min_variation'] ?? '' }}</td>
                <td>{{ $packingex['max_variation'] ?? '' }}</td>
                <td>{{ $packingex['remarks'] ?? '' }}</td>
             </tr> 
             </tr> 
             
              <tr>
                   @php
                    $anyother_marCost = json_decode($datas->any_other_marketing_cost, true);
                    @endphp
                <td>i</td>
                <td></td>
                <td></td>
                <td>Any other Marketing Cost</td>
                <td></td>
                <td>{{ $anyother_marCost['name'] ?? '' }}</td>
                <td> {{ $anyother_marCost['unit'] ?? '' }}</td>
                <td>{{ $anyother_marCost['averate_rate'] ?? '' }}</td>
                <td>{{ $anyother_marCost['min_variation'] ?? '' }}</td>
                <td>{{ $anyother_marCost['max_variation'] ?? '' }}</td>
                <td>{{ $anyother_marCost['remarks'] ?? '' }}</td>
             </tr> 
             </tr> 
             
             <tr>
                <td>j</td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                  <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
              <tr>
                <td>k</td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
              <tr>
                <td>III</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Selling Price</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
             
            <tr>
                @php
                $sellingPriceA = json_decode($datas->selling_price_a, true);
                @endphp
                <td></td>
                 <td></td>
                <td></td>
                <td>Grade A (mention applicable grade specification)</td>
                <td></td>
                <td>{{ $sellingPriceA['name'] ?? '' }}</td>
                <td> {{ $sellingPriceA['unit'] ?? '' }}</td>
                <td>{{ $sellingPriceA['averate_rate'] ?? '' }}</td>
                <td>{{ $sellingPriceA['min_variation'] ?? '' }}</td>
                <td>{{ $sellingPriceA['max_variation'] ?? '' }}</td>
                <td>{{ $sellingPriceA['remarks'] ?? '' }}</td>
             </tr> 
             
              <tr>
                   @php
                $sellingPriceB = json_decode($datas->selling_price_b, true);
                @endphp
                <td></td>
                   <td></td>
                <td></td>
                <td>Grade B (mention applicable grade specification)</td>
                <td></td>
                <td>{{ $sellingPriceB['name'] ?? '' }}</td>
                <td> {{ $sellingPriceB['unit'] ?? '' }}</td>
                <td>{{ $sellingPriceB['averate_rate'] ?? '' }}</td>
                <td>{{ $sellingPriceB['min_variation'] ?? '' }}</td>
                <td>{{ $sellingPriceB['max_variation'] ?? '' }}</td>
                <td>{{ $sellingPriceB['remarks'] ?? '' }}</td>
             </tr> 
             
              <tr>
                @php
                $sellingPriceC = json_decode($datas->selling_price_c, true);
                @endphp
                <td></td>
                   <td></td>
                <td></td>
                <td>Grade C (mention applicable grade specification)</td>
                <td></td>
               <td>{{ $sellingPriceC['name'] ?? '' }}</td>
                <td> {{ $sellingPriceC['unit'] ?? '' }}</td>
                <td>{{ $sellingPriceC['averate_rate'] ?? '' }}</td>
                <td>{{ $sellingPriceC['min_variation'] ?? '' }}</td>
                <td>{{ $sellingPriceC['max_variation'] ?? '' }}</td>
                <td>{{ $sellingPriceC['remarks'] ?? '' }}</td>
             </tr> 
             
             <tr>
                @php
                $sellingPriceD = json_decode($datas->selling_price_d, true);
                @endphp
                <td></td>
                <td></td>
                <td></td>
                <td>Grade D (mention applicable grade specification)</td>
                <td></td>
                 <td>{{ $sellingPriceD['name'] ?? '' }}</td>
                <td> {{ $sellingPriceD['unit'] ?? '' }}</td>
                <td>{{ $sellingPriceD['averate_rate'] ?? '' }}</td>
                <td>{{ $sellingPriceD['min_variation'] ?? '' }}</td>
                <td>{{ $sellingPriceD['max_variation'] ?? '' }}</td>
                <td>{{ $sellingPriceD['remarks'] ?? '' }}</td>
             </tr> 
             
            <tr>
                <td>IV</td>
                   <td></td>
                <td></td>
                <td style="font-weight:700;">Any other Cost Parameter</td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                 <td></td>
                <td></td>
                 <td></td>
             </tr> 
             
             <tr>
                  @php
                $QUAN = json_decode($datas->quantum_handled_year, true);
                @endphp
                <td></td>
                   <td></td>
                <td></td>
                <td>Quantum Handled in a year (weight)</td>
                <td></td>
                <td>{{ $QUAN['name'] ?? '' }}</td>
                <td> {{ $QUAN['unit'] ?? '' }}</td>
                <td>{{ $QUAN['averate_rate'] ?? '' }}</td>
                <td>{{ $QUAN['min_variation'] ?? '' }}</td>
                <td>{{ $QUAN['max_variation'] ?? '' }}</td>
                <td>{{ $QUAN['remarks'] ?? '' }}</td>
             </tr> 
             
            <tr>
                  @php
                $pspf = json_decode($datas->purchase_selling_prices_fluctuation, true);
                @endphp
                <td></td>
                   <td></td>
                <td></td>
                <td>Purchase and selling prices fluctuation during the whole marketing season</td>
                <td></td>
                <td>{{ $pspf['name'] ?? '' }}</td>
                <td> {{ $pspf['unit'] ?? '' }}</td>
                <td>{{ $pspf['averate_rate'] ?? '' }}</td>
                <td>{{ $pspf['min_variation'] ?? '' }}</td>
                <td>{{ $pspf['max_variation'] ?? '' }}</td>
                <td>{{ $pspf['remarks'] ?? '' }}</td>
             </tr> 
             
            </tbody>
      </table>
        </div>
        <br>
          <div class="table-responsive">
            <h1 class="h3 mb-0 text-gray-800">C . Indicative Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
            <br>
          <table class="table table-bordered ">
            <thead>
              <tr>
                <th>1</th>
                  <td>Farmer ID</td>
                <td>Farmer Name</td>
                <th>IIssues / Constraints</th>
                <th>Quantitative / Qualitative Indicators</th>
                <th>Remark</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                  @php
                    $ica = json_decode($datas->issues_constraints_a, true);
                    @endphp
                <td></td>
                <td>{{$datas->farmer_code_id}}</td>
                <td>{{$datas->first_name}} {{$datas->last_name}}</td>
                <td>a) Quantity reduction due to moisture content during the procurement</td>
                <td>{{ $ica['value'] ?? '' }}</td>
                <td> {{ $ica['remark'] ?? '' }}</td>
             </tr>   
             
             <tr>
                 @php
                    $icb = json_decode($datas->issues_constraints_b, true);
                    @endphp
                <td></td>
                <td></td>
                <td></td>
                <td>b) We will not get same quality produce every time</td>
               <td>{{ $icb['value'] ?? '' }}</td>
                <td> {{ $icb['remark'] ?? '' }}</td>
             </tr>
             
              <tr>
                   @php
                    $icc = json_decode($datas->issues_constraints_c, true);
                    @endphp
                <td></td>
                <td></td>
                <td></td>
                <td>c) Licence issues during the transportation</td>
                <td>{{ $icc['value'] ?? '' }}</td>
                <td> {{ $icc['remark'] ?? '' }}</td>
             </tr>  
             
               
             
              <tr>
                <td style="font-weight:700;">2</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Challenges</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                  @php
                    $ca = json_decode($datas->challenges_a, true);
                    @endphp
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Credit -Higher interest rates from financing persons</td>
                <td>{{ $ca['value'] ?? '' }}</td>
                <td> {{ $ca['remark'] ?? '' }}</td>
             </tr> 
             
              <tr>
                   @php
                    $ca = json_decode($datas->challenges_b, true);
                    @endphp
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Market rates will be up and down</td>
                 <td>{{ $cb['value'] ?? '' }}</td>
                <td> {{ $cb['remark'] ?? '' }}</td>
             </tr> 
             
               <tr>
                    @php
                    $cc = json_decode($datas->challenges_c, true);
                    @endphp
                <td></td>
                 <td></td>
                <td></td>
                <td>c)Production will depends on weather</td>
                <td>{{ $cc['value'] ?? '' }}</td>
                <td> {{ $cc['remark'] ?? '' }}</td>
             </tr> 
             
             <tr>
                <td style="font-weight:700;">3</td>
                 <td></td>
                <td></td>
                <td style="font-weight:700;">Risk</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                  @php
                    $ra = json_decode($datas->risk_a, true);
                    @endphp
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Credit basis supply to wholesaler</td>
                  <td>{{ $ra['value'] ?? '' }}</td>
                <td> {{ $ra['remark'] ?? '' }}</td>
             </tr> 
             
              <tr>
                    @php
                    $rb = json_decode($datas->risk_b, true);
                    @endphp
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Farmer will take advance from one marketing agent will sell to other marketing agent</td>
                <td>{{ $rb['value'] ?? '' }}</td>
                <td> {{ $rb['remark'] ?? '' }}</td>
             </tr>
             
              <tr>
                  @php
                    $rc = json_decode($datas->rsk_c, true);
                    @endphp
                <td></td>
                 <td></td>
                <td></td>
                <td>c) Storage loss during the storage in godowns if market price is not good</td>
                 <td>{{ $rc['value'] ?? '' }}</td>
                <td> {{ $rc['remark'] ?? '' }}</td>
             </tr>
             
              <tr>
                <td style="font-weight:700;">4</td>
                 <td></td>
                <td></td>
                <td style="font-weight:700;">Prospects</td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                    @php
                    $pa = json_decode($datas->prospects_a, true);
                    @endphp
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Loans on low interest rates from banks</td>
               <td>{{ $pa['value'] ?? '' }}</td>
                <td> {{ $pa['remark'] ?? '' }}</td>
             </tr> 
             
             <tr>
                    @php
                    $pb = json_decode($datas->prospects_b, true);
                    @endphp
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Godown for storage</td>
                  <td>{{ $pb['value'] ?? '' }}</td>
                <td> {{ $pb['remark'] ?? '' }}</td>
             </tr> 
             
              <tr>
                    @php
                    $pc = json_decode($datas->prospects_c, true);
                    @endphp
                <td></td>
                 <td></td>
                <td></td>
                <td>c) Getting licences  easily </td>
                <td>{{ $pc['value'] ?? '' }}</td>
                <td> {{ $pc['remark'] ?? '' }}</td>
             </tr> 
             
           
             
            </tbody>
      </table>
         </div>
     @endforeach
     @else
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">A . Infrastructure and Support Services</h1>
        </div>
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Unit Rate</th>
             <th>Amt (Rs.)</th>
             <th>Annulised Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
        <tr>
            <td>1</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Cost of establishment of Input Shop Permanent</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>2</td>
            <td></td>
            <td></td>
            <td>Cost of establishment of Input Shop Temporary</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            
            <td>4</td>
            <td></td>
            <td></td>
            <td>Cost Storage Structure for Inputs</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>5</td>
             <td></td>
            <td></td>
            <td>Cost other Infrastructure for Inputs</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>  
         
          <tr>
            <td>6</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>7</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Monthly Expenses on Manpower</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>8</td>
             <td></td>
            <td></td>
            <td>Monthly rent ( If shop is on rent)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>9</td>
             <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>8</td>
             <td></td>
            <td></td>
            <td>Any Other</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         <tr>
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Intt on Capital Investment</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td></td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of CA / PHC</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>10</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Annual Intt on Working Capital</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>11</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at village/ Farm Gate Level ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>12</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>13</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism ( Village Level/ local Mandi/ APMC)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>14</td>
             <td></td>
            <td></td>
            <td>Any Other Channel</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>15</td>
             <td></td>
            <td></td>
            <td>Duration of purchase on credit</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>16</td>
             <td></td>
            <td></td>
            <td>Duration of Sale credit</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>17</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Input / advance credit to producer (% of the estimated sale)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
        <tr>
            <td>18</td>
             <td></td>
            <td></td>
            <td>Any Other Information</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        </tbody>
  </table>
        </div>  
        <br>
        <div class="table-responsive">
          <h1 class="h3 mb-0 text-gray-800">B . Business parameters</h1>
          <br>
         <table class="table table-bordered ">
            <thead>
              <tr>
                <th>S. No.</th>
                <th>FARMER ID</th>
                <th>Farmer Name</th>
    
                <th>Particulars of Inputs</th>
                <th>Unit</th>
                <th>Name of Product</th>
                <th>Unit (quantity)</th>
                <th>Average Rate (Rs./Unit Quantity)</th>
                <th>Min Rate (Rs./Unit Quantity)</th>
                <th>Max Rate (Rs./Unit Quantity)</th>
                <th>Remark</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>I</td>
                
               <td></td>
                <td></td>
                <td style="font-weight:700;">Average Purchase Price</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>   
             
             <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>Grade A (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>
             
               <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>Grade B (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>
             
               <tr>
                <td></td>  
                <td></td>
                <td></td>
                <td>Grade C (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>
             
              <tr>
                <td></td>  
                <td></td>
                <td></td>
                <td>Grade D (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr>
             
             
             
              <tr>
                <td>II</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Cost of Value Addition</td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td>a</td>
                   <td></td>
                <td></td>
                <td>Pre-Harvesting Contractor Cost</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
               <tr>
                <td>b</td>
                   <td></td>
                <td></td>
                <td>Harvesting Cost</td>
                <td></td>
                <td></td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
               <tr>
                <td>c</td>
                   <td></td>
                <td></td>
                <td>Transportation Cost</td>
                <td></td>
                <td></td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
             
             <tr>
                <td>d</td>
                   <td></td>
                <td></td>
                <td>Loading and Unloading Charges</td>
                <td></td>
                <td></td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td>e</td>
                   <td></td>
                <td></td>
                <td>Primary Processing Cost</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td>f</td>
                   <td></td>
                <td></td>
                <td>Drying Loss or any other loss</td>
                <td></td>
                <td></td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td>g</td>
                   <td></td>
                <td></td>
                <td>Mandi fees /Tax/ Commission</td>
                <td></td>
                <td></td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td>h</td>
                   <td></td>
                <td></td>
                <td>Packaging expenses</td>
                <td></td>
                <td></td>
                  <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
              <tr>
                <td>i</td>
                   <td></td>
                <td></td>
                <td>Any other Marketing Cost</td>
                <td></td>
                <td></td>
                  <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
             <tr>
                <td>j</td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                  <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
              <tr>
                <td>k</td>
                   <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
              <tr>
                <td>III</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Selling Price</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             </tr> 
             
             
            <tr>
                <td></td>
                   <td></td>
                <td></td>
                <td>Grade A (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td></td>
                   <td></td>
                <td></td>
                <td>Grade B (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td></td>
                   <td></td>
                <td></td>
                <td>Grade C (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>Grade D (mention applicable grade specification)</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
             </tr> 
             
            <tr>
                <td>IV</td>
                   <td></td>
                <td></td>
                <td style="font-weight:700;">Any other Cost Parameter</td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
                 <td></td>
                <td></td>
                 <td></td>
             </tr> 
             
             <tr>
                <td></td>
                   <td></td>
                <td></td>
                <td>Quantum Handled in a year (weight)</td>
                <td></td>
                <td></td>
                 <td></td>
                 <td></td>
                 <td></td>
                <td></td>
                 <td></td>
             </tr> 
             
                <tr>
                <td></td>
                   <td></td>
                <td></td>
                <td>Purchase and selling prices fluctuation during the whole marketing season</td>
                <td></td>
                <td></td>
                 <td></td>
                 <td></td>
                 <td></td>
                <td></td>
                 <td></td>
             </tr> 
             
            </tbody>
      </table>
        </div>
        <br>
          <div class="table-responsive">
            <h1 class="h3 mb-0 text-gray-800">C . Indicative Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
            <br>
          <table class="table table-bordered ">
            <thead>
              <tr>
                <th>1</th>
                  <td>Farmer ID</td>
                <td>Farmer Name</td>
                <th>IIssues / Constraints</th>
                <th>Quantitative / Qualitative Indicators</th>
                <th>Remark</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>a) Quantity reduction due to moisture content during the procurement</td>
                <td></td>
                <td></td>
             </tr>   
             
             <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>b) We will not get same quality produce every time</td>
                <td></td>
                <td></td>
             </tr>
             
              <tr>
                <td></td>
                <td></td>
                <td></td>
                <td>c) Licence issues during the transportation</td>
                <td></td>
                <td></td>
             </tr>  
             
               
             
              <tr>
                <td style="font-weight:700;">2</td>
                <td></td>
                <td></td>
                <td style="font-weight:700;">Challenges</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Credit -Higher interest rates from financing persons</td>
                <td></td>
                <td></td>
             </tr> 
             
               <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Market rates will be up and down</td>
                <td></td>
                <td></td>
             </tr> 
             
               <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>c)Production will depends on weather</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td style="font-weight:700;">3</td>
                 <td></td>
                <td></td>
                <td style="font-weight:700;">Risk</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Credit basis supply to wholesaler</td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Farmer will take advance from one marketing agent will sell to other marketing agent</td>
                <td></td>
                <td></td>
             </tr>
             
              <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>c) Storage loss during the storage in godowns if market price is not good</td>
                <td></td>
                <td></td>
             </tr>
             
              <tr>
                <td style="font-weight:700;">4</td>
                 <td></td>
                <td></td>
                <td style="font-weight:700;">Prospects</td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>a) Loans on low interest rates from banks</td>
                <td></td>
                <td></td>
             </tr> 
             
             <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>b) Godown for storage</td>
                <td></td>
                <td></td>
             </tr> 
             
              <tr>
                <td></td>
                 <td></td>
                <td></td>
                <td>c) Getting licences  easily </td>
                <td></td>
                <td></td>
             </tr> 
             
           
             
            </tbody>
      </table>
         </div>
     @endif
     
   
</div>

    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>
@endsection