<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>
@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

<div class="container-fluid">
     <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            @if($deshboard == 1)
        
            @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.seven') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.seven.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
           @endif
        </div>
         <br>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">VILLAGE TEDER / TRADER / WHOLESALER</h1>
           
        </div>
         <h2>A. Infrastructure and Support Service</h2>

    @if($data->isNotEmpty()) 
        @php
            $sid = 1;
        @endphp
    @foreach($data as $datas)
     <table class="table table-bordered ">
        <thead>
          <tr>
              
            <td>{{ $sid++ }}</td>
           <td>{{ $datas->farmer_code_id ?? '' }}</td>
            <td>{{ $datas->first_name ?? '' }} {{ $datas->last_name ?? '' }}</td>

            <th>Infrastructure and Support Service</th>
            <th>Unit</th>
            <th>Unit Rate</th>
             <th>Amt (Rs.)</th>
             <th>Annulised Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
            
            <tr>
               @php
                 $shop_permanent = $datas->cost_of_establishment_permanent ? json_decode($datas->cost_of_establishment_permanent, true) : [];
                @endphp
            <td>1</td>
             <td></td>
            <td></td>
            <td>Cost of Establishment Permanent</td>
           <td>{{ $shop_permanent['unit'] ?? '' }}</td>
            <td>{{ $shop_permanent['unitRate'] ?? '' }}</td>
            <td>{{ $shop_permanent['amount'] ?? '' }}</td>
            
            @php
                $annualizedcostPer = isset($shop_permanent['amount']) && isset($perYear->year) && $perYear->year != 0 
                    ? $shop_permanent['amount'] / $perYear->year 
                    : null;
            @endphp
            <td>{{ $annualizedcostPer ?? '' }}</td>
            
            <td>{{ $shop_permanent['remark'] ?? '' }}</td>
         </tr>
         
         <tr>
           @php
             $shop_temporary = $datas->cost_of_establishment_temporary ? json_decode($datas->cost_of_establishment_temporary, true) : [];
            @endphp
            <td>1</td>
            <td></td>
            <td></td>
            <td>Cost of Establishment Temporary</td>
           <td>{{ $shop_temporary['unit'] ?? '' }}</td>
            <td>{{ $shop_temporary['unitRate'] ?? '' }}</td>
            <td>{{ $shop_temporary['amount'] ?? '' }}</td>
            
            @php
                $annualizedcosttemp = isset($shop_temporary['amount']) && isset($tempYear->year) && $tempYear->year != 0 
                    ? $shop_temporary['amount'] / $tempYear->year 
                    : null;
            @endphp
            
            <td>{{ $annualizedcosttemp ?? '' }}</td>
            
            <td>{{ $shop_temporary['remark'] ?? '' }}</td>
         </tr>
            
           
         
         <tr>
             @php
             $sidata = json_decode($datas->storage_structure_for_procurement, true);
            @endphp
            <td>2</td>
             <td></td>
            <td></td>
            <td>Cost Storage Structure for Procurement</td>
            <td>{{ $sidata['unit'] ?? '' }}</td>
            <td>{{ $sidata['unitRate'] ?? '' }}</td>
            <td>{{ $sidata['amount'] ?? '' }}</td>
            <td>{{ $sidata['annualCost'] ?? '' }}</td>
            <td>{{ $sidata['remark'] ?? '' }}</td>
         </tr>
         
          <tr>
             @php
             $ss = json_decode($datas->monthly_expenses_on_electricity, true);
            @endphp
            <td>3</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
             <td>{{ $ss['unit'] ?? '' }}</td>
            <td>{{ $ss['unitRate'] ?? '' }}</td>
            <td>{{ $ss['amount'] ?? '' }}</td>
            <td>{{ $ss['annualCost'] ?? '' }}</td>
            <td>{{ $ss['remark'] ?? '' }}</td>
         </tr>  
         
          <tr>
              @php
             $mem = json_decode($datas->monthly_expenses_on_manpower, true);
            @endphp
            <td>4</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Manpower</td>
            <td>{{ $mem['unit'] ?? '' }}</td>
            <td>{{ $mem['unitRate'] ?? '' }}</td>
            <td>{{ $mem['amount'] ?? '' }}</td>
            <td>{{ $mem['annualCost'] ?? '' }}</td>
            <td>{{ $mem['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
             $monthly_rent = json_decode($datas->monthly_rent, true);
            @endphp
            <td>5</td>
             <td></td>
            <td></td>
            <td >Monthly rent ( If Shop is on rent)</td>
            <td>{{ $monthly_rent['unit'] ?? '' }}</td>
            <td>{{ $monthly_rent['unitRate'] ?? '' }}</td>
            <td>{{ $monthly_rent['amount'] ?? '' }}</td>
            <td>{{ $monthly_rent['annualCost'] ?? '' }}</td>
            <td>{{ $monthly_rent['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
             $mte = json_decode($datas->monthly_travelling_expense, true);
            @endphp 
            <td>6</td>
             <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td>{{ $mte['unit'] ?? '' }}</td>
            <td>{{ $mte['unitRate'] ?? '' }}</td>
            <td>{{ $mte['amount'] ?? '' }}</td>
            <td>{{ $mte['annualCost'] ?? '' }}</td>
            <td>{{ $mte['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
             $aicc = json_decode($datas->annual_Interest_cost_on_capital, true);
            @endphp     
            <td>7</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on Capital  </td>
            <td>{{ $aicc['unit'] ?? '' }}</td>
            <td>{{ $aicc['unitRate'] ?? '' }}</td>
            <td>{{ $aicc['amount'] ?? '' }}</td>
            <td>{{ $aicc['annualCost'] ?? '' }}</td>
            <td>{{ $aicc['remark'] ?? '' }}</td>
         </tr> 
         
           @php
            $sumfixdata = 
                ($shop_permanent['amount'] ?? 0) + 
                ($shop_temporary['amount'] ?? 0) + 
                ($sidata['amount'] ?? 0) + 
                ($ss['amount'] ?? 0) + 
                ($mem['amount'] ?? 0) +     
                ($monthly_rent['amount'] ?? 0) + 
                ($mte['amount'] ?? 0) + 
                ($aicc['amount'] ?? 0);
            @endphp
         
        <tr>
            <td>8</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Any other fixed cost</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">{{$sumfixdata}}</td>
            <td></td>
            <td></td>
         </tr> 
         
         
       
         
            <tr>
            <td></td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of Trader / Trader / Wholesaler</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
             @php
            $aintco = json_decode($datas->annual_intt_cost_on_working_capital, true);
            @endphp
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on working capital </td>
            <td>{{ $aintco['unit'] ?? '' }}</td>
            <td>{{ $aintco['unitRate'] ?? '' }}</td>
            <td>{{ $aintco['amount'] ?? '' }}</td>
            <td>{{ $aintco['annualCost'] ?? '' }}</td>
            <td>{{ $aintco['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
            $atfar = json_decode($datas->purchase_from_farmer_at_village, true);
            @endphp
            <td>10</td>
             <td></td>
            <td></td>
            <td >Purchase from farmer at village Level / Farm Gate ?</td>
             <td>{{ $atfar['unit'] ?? '' }}</td>
            <td>{{ $atfar['unitRate'] ?? '' }}</td>
            <td>{{ $atfar['amount'] ?? '' }}</td>
            <td>{{ $atfar['annualCost'] ?? '' }}</td>
            <td>{{ $atfar['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
            $farmer_local_mandi = json_decode($datas->farmer_local_mandi, true);
            @endphp
            <td>11</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi ?</td>
            <td>{{ $farmer_local_mandi['unit'] ?? '' }}</td>
            <td>{{ $farmer_local_mandi['unitRate'] ?? '' }}</td>
            <td>{{ $farmer_local_mandi['amount'] ?? '' }}</td>
            <td>{{ $farmer_local_mandi['annualCost'] ?? '' }}</td>
            <td>{{ $farmer_local_mandi['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
            $commission_agent = json_decode($datas->commission_agent, true);
            @endphp
            <td>12</td>
             <td></td>
            <td></td>
            <td>Purchase from Commission Agent ?</td>
            <td>{{ $commission_agent['unit'] ?? '' }}</td>
            <td>{{ $commission_agent['unitRate'] ?? '' }}</td>
            <td>{{ $commission_agent['amount'] ?? '' }}</td>
            <td>{{ $commission_agent['annualCost'] ?? '' }}</td>
            <td>{{ $commission_agent['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
                $any_other_channel = json_decode($datas->any_other_channel, true);
                @endphp
            <td>13</td>
             <td></td>
            <td></td>
            <td>Any other channel</td>
            <td>{{ $any_other_channel['unit'] ?? '' }}</td>
            <td>{{ $any_other_channel['unitRate'] ?? '' }}</td>
            <td>{{ $any_other_channel['amount'] ?? '' }}</td>
            <td>{{ $any_other_channel['annualCost'] ?? '' }}</td>
            <td>{{ $any_other_channel['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
                $most_prevalent_purchase_mechanism = json_decode($datas->most_prevalent_purchase_mechanism, true);
                @endphp
            <td>14</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism ( 10/11/12/13 )?</td>
            <td>{{ $most_prevalent_purchase_mechanism['unit'] ?? '' }}</td>
            <td>{{ $most_prevalent_purchase_mechanism['unitRate'] ?? '' }}</td>
            <td>{{ $most_prevalent_purchase_mechanism['amount'] ?? '' }}</td>
            <td>{{ $most_prevalent_purchase_mechanism['annualCost'] ?? '' }}</td>
            <td>{{ $most_prevalent_purchase_mechanism['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
              @php
            $duration_of_purchase_on_credit = json_decode($datas->duration_of_purchase_on_credit, true);
            @endphp
            <td>15</td>
             <td></td>
            <td></td>
            <td>Duration of purchase on credit</td>
             <td>{{ $duration_of_purchase_on_credit['unit'] ?? '' }}</td>
            <td>{{ $duration_of_purchase_on_credit['unitRate'] ?? '' }}</td>
            <td>{{ $duration_of_purchase_on_credit['amount'] ?? '' }}</td>
            <td>{{ $duration_of_purchase_on_credit['annualCost'] ?? '' }}</td>
            <td>{{ $duration_of_purchase_on_credit['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
                $duration_of_sale_on_credit = json_decode($datas->duration_of_sale_on_credit, true);
                @endphp
            <td>16</td>
             <td></td>
            <td></td>
            <td>Duration of Sale on credit</td>
            <td>{{ $duration_of_sale_on_credit['unit'] ?? '' }}</td>
            <td>{{ $duration_of_sale_on_credit['unitRate'] ?? '' }}</td>
            <td>{{ $duration_of_sale_on_credit['amount'] ?? '' }}</td>
            <td>{{ $duration_of_sale_on_credit['annualCost'] ?? '' }}</td>
            <td>{{ $duration_of_sale_on_credit['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $advance_credit_to_producer = json_decode($datas->advance_credit_to_producer, true);
                @endphp
            <td>17</td>
            <td></td>
            <td></td>
            <td>Input / advance credit to producer (% of the estimated sale)</td>
            <td>{{ $advance_credit_to_producer['unit'] ?? '' }}</td>
            <td>{{ $advance_credit_to_producer['unitRate'] ?? '' }}</td>
            <td>{{ $advance_credit_to_producer['amount'] ?? '' }}</td>
            <td>{{ $advance_credit_to_producer['annualCost'] ?? '' }}</td>
            <td>{{ $advance_credit_to_producer['remark'] ?? '' }}</td>
         </tr> 
         
         
        <tr>
             @php
            $any_other_infor = json_decode($datas->any_other_infor, true);
            @endphp
            <td>18</td>
             <td></td>
            <td></td>
            <td>Any other information</td>
             <td>{{ $any_other_infor['unit'] ?? '' }}</td>
            <td>{{ $any_other_infor['unitRate'] ?? '' }}</td>
            <td>{{ $any_other_infor['amount'] ?? '' }}</td>
            <td>{{ $any_other_infor['annualCost'] ?? '' }}</td>
            <td>{{ $any_other_infor['remark'] ?? '' }}</td>
         </tr> 
         
        </tbody>
  </table>
    </div>
    <div class="table-responsive" style="margin-top:40px;">
     <h1 class="h3 mb-0 text-gray-800">B . Business parameters</h1>
      <br>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars of Inputs</th>
            <th>Name of Product</th>
            <th>Unit (quantity)</th>
            <th>Average Rate (Rs./Unit Quantity)</th>
            <th>Min Rate (Rs./Unit Quantity)</th>
            <th>Max Rate (Rs./Unit Quantity)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>{{ $sid++ }}</td>
             <td>{{ $datas->farmer_code_id ?? '' }}</td>
             <td>{{ $datas->first_name ?? '' }} {{ $datas->last_name ?? '' }}</td>

            <td style="font-weight:700;">Average Purchase Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
         </tr>   
         
         <tr>
             @php
                $average_purchase_a = json_decode($datas->average_purchase_a, true);
            @endphp
            <td></td>
             <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td>{{ $average_purchase_a['name'] ?? '' }}</td>
            <td>{{ $average_purchase_a['unit'] ?? '' }}</td>
            <td>{{ $average_purchase_a['averate_rate'] ?? '' }}</td>
            <td>{{ $average_purchase_a['min_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_a['max_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_a['remarks'] ?? '' }}</td>
         </tr>
         
           <tr>
            @php
                $average_purchase_b = json_decode($datas->average_purchase_b, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
            <td>{{ $average_purchase_b['name'] ?? '' }}</td>
            <td>{{ $average_purchase_b['unit'] ?? '' }}</td>
            <td>{{ $average_purchase_b['averate_rate'] ?? '' }}</td>
            <td>{{ $average_purchase_b['min_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_b['max_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_b['remarks'] ?? '' }}</td>
         </tr>
         
           <tr>
               @php
                $average_purchase_c = json_decode($datas->average_purchase_c, true);
            @endphp
            <td></td> 
            <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
             <td>{{ $average_purchase_c['name'] ?? '' }}</td>
            <td>{{ $average_purchase_c['unit'] ?? '' }}</td>
            <td>{{ $average_purchase_c['averate_rate'] ?? '' }}</td>
            <td>{{ $average_purchase_c['min_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_c['max_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_c['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
             @php
                $average_purchase_d = json_decode($datas->average_purchase_d, true);
            @endphp
            <td></td>  
            <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
             <td>{{ $average_purchase_d['name'] ?? '' }}</td>
            <td>{{ $average_purchase_d['unit'] ?? '' }}</td>
            <td>{{ $average_purchase_d['averate_rate'] ?? '' }}</td>
            <td>{{ $average_purchase_d['min_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_d['max_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_d['remarks'] ?? '' }}</td>
         </tr>
         
         
          <tr>
               
            <td>II</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Cost of Value Addition</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         
           <tr>
               @php
                $harvesting_cost = json_decode($datas->harvesting_cost, true);
                @endphp
            <td>a</td>
            <td></td>
            <td></td>
            <td>Harvesting Cost</td>
           <td>{{ $harvesting_cost['name'] ?? '' }}</td>
            <td>{{ $harvesting_cost['unit'] ?? '' }}</td>
            <td>{{ $harvesting_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $harvesting_cost['min_variation'] ?? '' }}</td>
            <td>{{ $harvesting_cost['max_variation'] ?? '' }}</td>
            <td>{{ $harvesting_cost['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
                 @php
                $transportation_cost = json_decode($datas->transportation_cost, true);
                @endphp
            <td>b</td>
             <td></td>
            <td></td>
            <td>Transportation Cost</td>
            <td>{{ $transportation_cost['name'] ?? '' }}</td>
            <td>{{ $transportation_cost['unit'] ?? '' }}</td>
            <td>{{ $transportation_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $transportation_cost['min_variation'] ?? '' }}</td>
            <td>{{ $transportation_cost['max_variation'] ?? '' }}</td>
            <td>{{ $transportation_cost['remarks'] ?? '' }}</td>
         </tr> 
         
         
         <tr>
             @php
            $loading_and_unloading_charges = json_decode($datas->loading_and_unloading_charges, true);
            @endphp
            <td>c</td>
               <td></td>
            <td></td>
            <td>Loading and Unloading Charges</td>
           <td>{{ $loading_and_unloading_charges['name'] ?? '' }}</td>
            <td>{{ $loading_and_unloading_charges['unit'] ?? '' }}</td>
            <td>{{ $loading_and_unloading_charges['averate_rate'] ?? '' }}</td>
            <td>{{ $loading_and_unloading_charges['min_variation'] ?? '' }}</td>
            <td>{{ $loading_and_unloading_charges['max_variation'] ?? '' }}</td>
            <td>{{ $loading_and_unloading_charges['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
            $primary_processing_cost = json_decode($datas->primary_processing_cost, true);
            @endphp
            <td>d</td>
               <td></td>
            <td></td>
            <td>Primary Processing Cost</td>
           <td>{{ $primary_processing_cost['name'] ?? '' }}</td>
            <td>{{ $primary_processing_cost['unit'] ?? '' }}</td>
            <td>{{ $primary_processing_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $primary_processing_cost['min_variation'] ?? '' }}</td>
            <td>{{ $primary_processing_cost['max_variation'] ?? '' }}</td>
            <td>{{ $primary_processing_cost['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
                @php
                $drying_Loss_any_other_loss = json_decode($datas->drying_Loss_any_other_loss, true);
                @endphp
            <td>e</td>
             <td></td>
            <td></td>
            <td>Drying Loss or any other loss</td>
                <td>{{ $drying_Loss_any_other_loss['name'] ?? '' }}</td>
                <td>{{ $drying_Loss_any_other_loss['unit'] ?? '' }}</td>
                <td>{{ $drying_Loss_any_other_loss['averate_rate'] ?? '' }}</td>
                <td>{{ $drying_Loss_any_other_loss['min_variation'] ?? '' }}</td>
                <td>{{ $drying_Loss_any_other_loss['max_variation'] ?? '' }}</td>
                <td>{{ $drying_Loss_any_other_loss['remarks'] ?? '' }}</td>
         </tr> 
         
        <tr>
             @php
            $value_establishment_cost = json_decode($datas->value_establishment_cost, true);
            @endphp
            <td>f</td>
             <td></td>
            <td></td>
            <td>Establishment Cost</td>
              <td>{{ $value_establishment_cost['name'] ?? '' }}</td>
                <td>{{ $value_establishment_cost['unit'] ?? '' }}</td>
                <td>{{ $value_establishment_cost['averate_rate'] ?? '' }}</td>
                <td>{{ $value_establishment_cost['min_variation'] ?? '' }}</td>
                <td>{{ $value_establishment_cost['max_variation'] ?? '' }}</td>
                <td>{{ $value_establishment_cost['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
            $marketing_cost = json_decode($datas->marketing_cost, true);
            @endphp
            <td>g</td>
            <td></td>
            <td></td>
            <td>Marketing Cost</td>
             <td>{{ $marketing_cost['name'] ?? '' }}</td>
            <td>{{ $marketing_cost['unit'] ?? '' }}</td>
            <td>{{ $marketing_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $marketing_cost['min_variation'] ?? '' }}</td>
            <td>{{ $marketing_cost['max_variation'] ?? '' }}</td>
            <td>{{ $marketing_cost['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
                  @php
                $storage_cost = json_decode($datas->storage_cost, true);
                @endphp
            <td>h</td>
               <td></td>
            <td></td>
            <td>Storage Cost</td>
              <td>{{ $storage_cost['name'] ?? '' }}</td>
            <td>{{ $storage_cost['unit'] ?? '' }}</td>
            <td>{{ $storage_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $storage_cost['min_variation'] ?? '' }}</td>
            <td>{{ $storage_cost['max_variation'] ?? '' }}</td>
            <td>{{ $storage_cost['remarks'] ?? '' }}</td>
         </tr> 
         </tr> 
         
          <tr>
               @php
                $any_other_cost = json_decode($datas->any_other_cost, true);
                @endphp
            <td>i</td>
               <td></td>
            <td></td>
            <td>Any other cost</td>
            <td>{{ $any_other_cost['name'] ?? '' }}</td>
            <td>{{ $any_other_cost['unit'] ?? '' }}</td>
            <td>{{ $any_other_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $any_other_cost['min_variation'] ?? '' }}</td>
            <td>{{ $any_other_cost['max_variation'] ?? '' }}</td>
            <td>{{ $any_other_cost['remarks'] ?? '' }}</td>
         </tr> 
         </tr> 
         
         <tr>
            <td>j</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>k</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>III</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Selling Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
         
        <tr>
             @php
            $selling_price_a = json_decode($datas->selling_price_a, true);
            @endphp
            <td></td>
               <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td>{{ $selling_price_a['name'] ?? '' }}</td>
                <td>{{ $selling_price_a['unit'] ?? '' }}</td>
                <td>{{ $selling_price_a['averate_rate'] ?? '' }}</td>
                <td>{{ $selling_price_a['min_variation'] ?? '' }}</td>
                <td>{{ $selling_price_a['max_variation'] ?? '' }}</td>
                <td>{{ $selling_price_a['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
            $selling_price_b = json_decode($datas->selling_price_b, true);
            @endphp
            <td></td>
               <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
             <td>{{ $selling_price_a['name'] ?? '' }}</td>
                 <td>{{ $selling_price_b['unit'] ?? '' }}</td>
                <td>{{ $selling_price_b['averate_rate'] ?? '' }}</td>
                <td>{{ $selling_price_b['min_variation'] ?? '' }}</td>
                <td>{{ $selling_price_b['max_variation'] ?? '' }}</td>
                <td>{{ $selling_price_b['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
            $selling_price_c = json_decode($datas->selling_price_c, true);
            @endphp
            <td></td>
               <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
                <td>{{ $selling_price_a['name'] ?? '' }}</td>
                 <td>{{ $selling_price_c['unit'] ?? '' }}</td>
                <td>{{ $selling_price_c['averate_rate'] ?? '' }}</td>
                <td>{{ $selling_price_c['min_variation'] ?? '' }}</td>
                <td>{{ $selling_price_c['max_variation'] ?? '' }}</td>
                <td>{{ $selling_price_c['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
            $selling_price_d = json_decode($datas->selling_price_d, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
            <td>{{ $selling_price_a['name'] ?? '' }}</td>
             <td>{{ $selling_price_d['unit'] ?? '' }}</td>
            <td>{{ $selling_price_d['averate_rate'] ?? '' }}</td>
            <td>{{ $selling_price_d['min_variation'] ?? '' }}</td>
            <td>{{ $selling_price_d['max_variation'] ?? '' }}</td>
            <td>{{ $selling_price_d['remarks'] ?? '' }}</td>
         </tr> 
         
        <tr>
            <td>IV</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Any other Cost Parameter</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Quantum Handled in a year (weight)</td>
            <td></td>
             <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
            <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Purchase and selling prices fluctuation during the whole marketing season</td>
            <td></td>
             <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
        </tbody>
  </table>

    </div>
    <div class="table-responsive" style="margin-top:40px">
        
     <h1 class="h3 mb-0 text-gray-800">C . Indicative Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
        <br>
      <table class="table table-bordered ">
        <thead>
          <tr>
            <th>1</th>
            <td>Farmer ID</td>
            <td>Farmer Name</td>
            <th>Issues / Constraints</th>
            <th></th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
              @php
                    $issues_constraints_a =  json_decode($datas->issues_constraints_a, true);
                @endphp
            <td>a</td>
           <td>{{ $datas->farmer_code_id ?? '' }}</td>
            <td>{{ $datas->first_name ?? '' }} {{ $datas->last_name ?? '' }}</td>
            <td>Marketing problem ( rate fluctuation and more storage time due to lack of end market )</td>
            <td>{{ $issues_constraints_a['value'] ?? '' }}</td>
            <td>{{ $issues_constraints_a['remark'] ?? '' }}</td>
         </tr>   
         
         <tr>
             @php
                $issues_constraints_b = json_decode($datas->issues_constraints_b, true);
                @endphp
            <td>b</td>
            <td></td>
            <td></td>
            <td>Credit taken agents will not  supply agreed quantity of  produce </td>
            <td>{{ $issues_constraints_b['value'] ?? '' }}</td>
            <td>{{ $issues_constraints_b['remark'] ?? '' }}</td>
         </tr>
         
         
         <tr>
                @php
                $issues_constraints_c = json_decode($datas->issues_constraints_c, true);
                @endphp
            <td>c</td>
            <td></td>
            <td></td>
            <td>Needs to give Credit to farmers through  the channel of commission agents</td>
            <td>{{ $issues_constraints_c['value'] ?? '' }}</td>
            <td>{{ $issues_constraints_c['remark'] ?? '' }}</td>
         </tr>  
         
           
         
          <tr>
            <td style="font-weight:700;">2</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Challenge</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
             @php
            $challenges_a = json_decode($datas->challenges_a, true);
            @endphp
            <td>a</td>
             <td></td>
            <td></td>
            <td>Transportation and storage  losses ( average extent of losses (%) ? ) </td>
            <td>{{ $challenges_a['value'] ?? '' }}</td>
            <td>{{ $challenges_a['remark'] ?? '' }}</td>
         </tr> 
         
           <tr>
           @php
            $challenges_b = json_decode($datas->challenges_b, true);
            @endphp
            <td>b</td>
             <td></td>
            <td></td>
            <td>Manpower availability during the procurement and transportation</td>
            <td>{{ $challenges_b['value'] ?? '' }}</td>
            <td>{{ $challenges_b['remark'] ?? '' }}</td>
         </tr> 
         
          
         <tr>
            <td style="font-weight:700;">3</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Risk</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
             @php
            $risk_a = json_decode($datas->risk_a, true);
            @endphp
            <td>a</td>
             <td></td>
            <td></td>
            <td>Business is purely depends on local weather conditions</td>
            <td>{{ $risk_a['value'] ?? '' }}</td>
            <td>{{ $risk_a['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
            $risk_b = json_decode($datas->risk_b, true);
            @endphp
            <td>b</td>
             <td></td>
            <td></td>
            <td>Credits to commission agents ( How much credit needs to be given and duration of the credit outstanding: ? )</td>
             <td>{{ $risk_b['value'] ?? '' }}</td>
            <td>{{ $risk_b['remark'] ?? '' }}</td>
         </tr>
         
          <tr>
            @php
            $risk_c = json_decode($datas->risk_c, true);
            @endphp
            <td>c</td>
             <td></td>
            <td></td>
            <td>Supply of produce from regular agents due to competition</td>
             <td>{{ $risk_c['value'] ?? '' }}</td>
            <td>{{ $risk_c['remark'] ?? '' }}</td>
         </tr>
         
          <tr>
            <td style="font-weight:700;">4</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Prospects</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
             @php
            $prospects_a = json_decode($datas->prospects_a, true);
            @endphp
            <td>a</td>
             <td></td>
            <td></td>
            <td>Godowns supply on subsidy basis by govt.</td>
           <td>{{ $prospects_a['value'] ?? '' }}</td>
            <td>{{ $prospects_a['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
            @php
            $prospects_b = json_decode($datas->prospects_b, true);
            @endphp
            <td>b</td>
            <td></td>
            <td></td>
            <td>Insurance for storage</td>
           <td>{{ $prospects_b['value'] ?? '' }}</td>
            <td>{{ $prospects_b['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
            $prospects_c = json_decode($datas->prospects_c, true);
            @endphp
            <td>c</td>
             <td></td>
            <td></td>
            <td>Policy regulation on market prices </td>
            <td>{{ $prospects_c['value'] ?? '' }}</td>
            <td>{{ $prospects_c['remark'] ?? '' }}</td>
         </tr> 
         
       
         
        </tbody>
  </table>
  
    </div>
    @endforeach
    @else
    <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Infrastructure and Support Service</th>
            <th>Unit</th>
            <th>Unit Rate</th>
             <th>Amt (Rs.)</th>
             <th>Annulised Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
             <td></td>
            <td></td>
            <td>Cost of Establishment Permanent</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>1</td>
             <td></td>
            <td></td>
            <td>Cost of Establishment Temporary</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>2</td>
             <td></td>
            <td></td>
            <td>Cost Storage Structure for Procurement</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>3</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>  
         
          <tr>
            <td>4</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Manpower</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>5</td>
             <td></td>
            <td></td>
            <td >Monthly rent ( If Shop is on rent)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>6</td>
             <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>7</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on Capital  </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>8</td>
             <td></td>
            <td></td>
            <td>Any other fixed cost</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
       
         
            <tr>
            <td></td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of Trader / Trader / Wholesaler</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on working capital </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>10</td>
             <td></td>
            <td></td>
            <td >Purchase from farmer at village Level / Farm Gate ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>11</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>12</td>
             <td></td>
            <td></td>
            <td>Purchase from Commission Agent ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>13</td>
             <td></td>
            <td></td>
            <td>Any other channel</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>14</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism ( 10/11/12/13 )?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>15</td>
             <td></td>
            <td></td>
            <td>Duration of purchase on credit</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>16</td>
             <td></td>
            <td></td>
            <td>Duration of Sale on credit</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>17</td>
             <td></td>
            <td></td>
            <td>Input / advance credit to producer (% of the estimated sale)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
        <tr>
            <td>18</td>
             <td></td>
            <td></td>
            <td>Any other information</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        </tbody>
  </table>
    </div>
    <div class="table-responsive" style="margin-top:40px;">
     <h1 class="h3 mb-0 text-gray-800">B . Business parameters</h1>
      <br>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars of Inputs</th>
            <th>Name of Product</th>
            <th>Unit (quantity)</th>
            <th>Average Rate (Rs./Unit Quantity)</th>
            <th>Min Rate (Rs./Unit Quantity)</th>
            <th>Max Rate (Rs./Unit Quantity)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>I</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Average Purchase Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
           <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
           <tr>
            <td></td>   <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
        <tr>
            <td></td>  
            <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
         
          <tr>
            <td>II</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Cost of Value Addition</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         
           <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Harvesting Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Transportation Cost</td>
            <td></td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Loading and Unloading Charges</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>d</td>
               <td></td>
            <td></td>
            <td>Primary Processing Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>e</td>
             <td></td>
            <td></td>
            <td>Drying Loss or any other loss</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>f</td>
             <td></td>
            <td></td>
            <td>Establishment Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>g</td>
               <td></td>
            <td></td>
            <td>Marketing Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>h</td>
               <td></td>
            <td></td>
            <td>Storage Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>i</td>
               <td></td>
            <td></td>
            <td>Any other cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
         <tr>
            <td>j</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>k</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>III</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Selling Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
         
        <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>IV</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Any other Cost Parameter</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Quantum Handled in a year (weight)</td>
            <td></td>
             <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
            <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Purchase and selling prices fluctuation during the whole marketing season</td>
            <td></td>
             <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
        </tbody>
  </table>

    </div>
    <div class="table-responsive" style="margin-top:40px">
        
     <h1 class="h3 mb-0 text-gray-800">C . Indicative Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
        <br>
      <table class="table table-bordered ">
        <thead>
          <tr>
            <th>1</th>
            <td>Farmer ID</td>
            <td>Farmer Name</td>
            <th>Issues / Constraints</th>
            <th></th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>a</td>
            <td></td>
            <td></td>
            <td>Marketing problem ( rate fluctuation and more storage time due to lack of end market )</td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td>b</td>
            <td></td>
            <td></td>
            <td>Credit taken agents will not  supply agreed quantity of  produce </td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>c</td>
            <td></td>
            <td></td>
            <td>Needs to give Credit to farmers through  the channel of commission agents</td>
            <td></td>
            <td></td>
         </tr>  
         
           
         
          <tr>
            <td style="font-weight:700;">2</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Challenge</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Transportation and storage  losses ( average extent of losses (%) ? ) </td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Manpower availability during the procurement and transportation</td>
            <td></td>
            <td></td>
         </tr> 
         
          
         <tr>
            <td style="font-weight:700;">3</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Risk</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Business is purely depends on local weather conditions</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Credits to commission agents ( How much credit needs to be given and duration of the credit outstanding: ? )</td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Supply of produce from regular agents due to competition</td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td style="font-weight:700;">4</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Prospects</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
             <td></td>
            <td></td>
            <td>Godowns supply on subsidy basis by govt.</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>b</td>
             <td></td>
            <td></td>
            <td>Insurance for storage</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Policy regulation on market prices </td>
            <td></td>
            <td></td>
         </tr> 
         
       
         
        </tbody>
  </table>
  
    </div>
    @endif
    
</div>

    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>

@endsection