<?php
    use App\Models\HectareMeasurement;
    use App\Models\User;
    use Illuminate\Support\Collection;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
    
    $loggedInTeamLeaderId = $userDetail->team_leader_id;
    
    $uniqueUserIds = $data->pluck('user_id')->unique();
    $hectareMaster = HectareMeasurement::all();
    $targetTeamLeaderId = $hectareMaster->pluck('user_id')->filter()->unique()->values();
    $userData = User::all();
    
    $filteredUsers = $userData->filter(function ($user) use ($targetTeamLeaderId) {
        return $targetTeamLeaderId->contains($user->team_leader_id);
    });
    
    $userId = $filteredUsers->pluck('id')->filter()->unique()->values();
    
    // $filteredCollection = $hectareMaster->filter(function ($item) use ($targetTeamLeaderId) {
    //     return $targetTeamLeaderId->contains($item->user_id);
    // });
    $filteredCollection = $hectareMaster->filter(function ($item) use ($loggedInTeamLeaderId) {
        return $item->user_id === $loggedInTeamLeaderId;
    });
    
    foreach ($data as $entry1) 
    {
        $user_id = $entry1->user_id; 
        
        foreach ($filteredCollection as $entry2) 
        {
            $filteredUsers = User::whereIn('team_leader_id', $targetTeamLeaderId)->get();
            
            $filteredUsers = $filteredUsers->first(function ($user) use ($user_id) {
                return $user->id === $user_id;
            });
            
            if (isset($filteredUsers) && $filteredUsers) 
            {
                if($entry1->total_cultivable_unit == $entry2->unit)
                {
                    $entry1->total_cultivable = $entry2->value;
                }

                if($entry1->land_holding_size_unit == $entry2->unit)
                {
                    $entry1->land_holding_size = $entry2->value;
                }
                if($entry1->crop_area_unit == $entry2->unit)
                {
                    $entry1->crop_area = $entry2->value;
                }
                
                if($entry1->hired_animal_unit == $entry2->unit)
                {
                    $entry1->hired_animal_hrs = $entry2->value;
                }
                
                if($entry1->owned_animal_unit == $entry2->unit)
                {
                    $entry1->owned_animal_hrs = $entry2->value;
                }
                
                if($entry1->hired_irrigation_machine_unit == $entry2->unit)
                {
                    $entry1->hired_irrigation_machine_hrs = $entry2->value;
                }
                
                if($entry1->owned_irrigation_machine_unit == $entry2->unit)
                {
                    $entry1->owned_irrigation_machine_hrs = $entry2->value;
                }
                
                if($entry1->land_holding_taken_lease_unit == $entry2->unit)
                {
                    $entry1->land_holding_taken_lease = $entry2->value;
                }
                
                if($entry1->land_given_lease_unit == $entry2->unit)
                {
                    $entry1->land_given_lease = $entry2->value;
                }
            }
        }
    }
    // $list = $data;
    // $filter = [];
    // $data = [];
    // foreach($list as $item){
    //     if (!in_array($item->farmerId, $filter)) {
    //         $filter[] = $item->farmerId; 
    //         $data[] = $item; 
    //     }
    // }
    // dump($data);

?>
@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')
<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-3">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            <div class="col-lg-9">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.one') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.one.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Anexure List One</h1>
        </div>
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
        @if((isset($rolePermission) && $rolePermission->edit == 1) || $loginUserId == 1)
        <tr>
            <td>
                
            </td>
            <td>
                Status Action
            </td>
            
            @foreach($data as $status)
            <td>
                @if ($status->status == 0)
                <a href="{{ route('anexure.one.status', ['crop_id' => $status->id, 'status' => 1]) }}"
                    class="btn btn-success m-2">
                    <i class="fa fa-check">Approve</i>
                </a>
                @elseif ($status->status == 1)
                <a href="{{ route('anexure.one.status', ['crop_id' => $status->id, 'status' => 0]) }}"
                    class="btn btn-danger m-2">
                    <i class="fa fa-ban">Reject</i>
                </a>
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                
            </td>
            <td>
                Status 
            </td>
            
            @foreach($data as $status)
            <td>
                @if ($status->status == 0)
                    <span class="badge badge-danger">Rejected</span>
                @elseif ($status->status == 1)
                    <span class="badge badge-success">Approved</span>
                @endif
            </td>
            @endforeach
        </tr>
        @endif
        <tr>
            <td>
                A
            </td>
            <td>
                FARMER CODE
            </td>
            
            @foreach($data as $farmer)
            <td>
               {{$farmer->farmer_code}}
            </td>
            @endforeach
        </tr>
        <tr>
              <td>
                B
            </td>
            <td>
                Farmer Name
            </td>
            
            @foreach($data as $farmer_name)
            <td>
               {{$farmer_name->farmer_first_name == 'null' ? '' : $farmer_name->farmer_first_name.' '.$farmer_name->farmer_last_name}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                C
            </td>
            <td>
               S/O or W/O
            </td>
            
            @foreach($data as $father_name)
            <td>
               {{isset($father_name->farmer_husband_father_name) && $father_name->farmer_husband_father_name ? $father_name->farmer_husband_father_name : ''}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                D
            </td>
            <td>
               Village
            </td>
            
            @foreach($data as $farmer_village)
            <td>
               {{$farmer_village->user_village == 'null' ? '' : $farmer_village->user_village}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                E
            </td>
           <td>
              State
            </td>
            
            @foreach($data as $farmer_state)
            <td>
               {{$farmer_state->farmer_state_name == 'null' ? '' : $farmer_state->farmer_state_name}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                F
            </td>
           <td>
              District
            </td>
            
            @foreach($data as $farmer_dis)
            <td>
               {{$farmer_dis->farmer_district_name == 'null' ? '' : $farmer_dis->farmer_district_name}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                G
            </td>
            <td>
               Block
            </td>
            
            @foreach($data as $farmer_block)
            <td>
               {{$farmer_block->farmer_block == 'null' ? '' : $farmer_block->farmer_block}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                H
            </td>
            <td>
                Mobile Number
            </td>
            
            @foreach($data as $mobile_number)
            <td>
                {{$mobile_number->farmer_mobile_number == 'null' ? '' : $mobile_number->farmer_mobile_number}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                I
            </td>
            <td>
                Kcc Limit
            </td>
            @foreach($data as $kcc_limit)
            <td>
                {{$kcc_limit->kcc_limit == 'null' ? '' : $kcc_limit->kcc_limit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                J
            </td>
            <td>
                Land Type
            </td>
            
            @foreach($data as $land_type)
            <td>
                {{$land_type->land_type == 'null' ? '' : $land_type->land_type}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                K
            </td>
            <td>
                Soil Health Card
            </td>
            
            @foreach($data as $soilHealthCard)
            <td>
                @if(isset($soilHealthCard->soil_health_card) && strtolower($soilHealthCard->soil_health_card) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                L
            </td>
            <td>
                Soil Health Card Remark
            </td>
            @foreach($data as $soilHealthCardRemark)
            <td>
                {{$soilHealthCardRemark->soil_health_card_remark == 'null' ? '' : $soilHealthCardRemark->soil_health_card_remark}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                M
            </td>
            <td>
                Land Holding Size Unit
            </td>
            
            @foreach($data as $landHoldSizeUnit)
            <td>
                {{$landHoldSizeUnit->land_holding_size_unit == 'null' ? '' : $landHoldSizeUnit->land_holding_size_unit}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                N
            </td>
            <td>
                Land Holding (Area)
            </td>
            
            @foreach($data as $land_holding_size)
            <td>
                @if(isset($land_holding_size->land_holding_size_unit) && $land_holding_size->land_holding_size_unit == $entry1->land_holding_size_unit)
                    {{$entry1->land_holding_size == 'null' ? '' : $entry1->land_holding_size}}
                @else
                    {{$land_holding_size->land_holding_size == 'null' ? '' : $land_holding_size->land_holding_size}}
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                O
            </td>
            <td>
                Land Given Lease Unit
            </td>
            
            @foreach($data as $landGivenLeaseUnit)
            <td>
                {{$landGivenLeaseUnit->land_given_lease_unit == 'null' ? '' : $landGivenLeaseUnit->land_given_lease_unit}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
                P
            </td>
            <td>
                Land Given Lease (Area)
            </td>
            
            @foreach($data as $landGivenLease)
            <td>
                @if(isset($landGivenLease->land_given_lease_unit) && $landGivenLease->land_given_lease_unit == $entry1->land_given_lease_unit)
                    {{$entry1->land_given_lease == 'null' ? '' : $entry1->land_given_lease}}
                @else
                    {{$landGivenLease->land_given_lease == 'null' ? '' : $landGivenLease->land_given_lease}}
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                Q
            </td>
            <td>
                Land Holding Taken Lease Unit
            </td>
            
            @foreach($data as $landHoldTakenLeaseUnit)
            <td>
                {{$landHoldTakenLeaseUnit->land_holding_taken_lease_unit == 'null' ? '' : $landHoldTakenLeaseUnit->land_holding_taken_lease_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                R
            </td>
            <td>
                Land Holding taken Lease (Area)
            </td>
            
            @foreach($data as $land_holding_taken_lease)
            <td>
                @if(isset($land_holding_taken_lease->land_holding_taken_lease_unit) && $land_holding_taken_lease->land_holding_taken_lease_unit == $entry1->land_holding_taken_lease_unit)
                    {{$entry1->land_holding_taken_lease == 'null' ? '' : $entry1->land_holding_taken_lease}}
                @else
                    {{$land_holding_taken_lease->land_holding_taken_lease == 'null' ? '' : $land_holding_taken_lease->land_holding_taken_lease}}
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                S
            </td>
            <td>
                Total Cultivable Area Unit
            </td>
            
            @foreach($data as $totalCultiUnit)
            <td>
                {{$totalCultiUnit->total_cultivable_unit == 'null' ? '' : $totalCultiUnit->total_cultivable_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                T
            </td>
            <td>
                Total Cultivable (Area)
            </td>
            
            @foreach($data as $total_cultivable)
            <td>
                @if(isset($total_cultivable->total_cultivable_unit) && $total_cultivable->total_cultivable_unit === $entry1->total_cultivable_unit)
                    {{$entry1->total_cultivable == 'null' ? '' : $entry1->total_cultivable}}
                @else
                    {{$total_cultivable->total_cultivable == 'null' ? '' : $total_cultivable->total_cultivable}}
                @endif
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                U
            </td>
            <td>
                CROPPING PATTERN
            </td>
             @php
                $counter = [];
            @endphp
            @foreach($data as $crop_patt)
            @php
                $farmerId = $crop_patt->farmer_id;
                $counter[$farmerId] = isset($counter[$farmerId]) ? $counter[$farmerId] + 1 : 1;
                $romanCount = int_to_roman($counter[$farmerId]);
            @endphp
            <td>
                CROP {{ $romanCount }}
            </td>
            @endforeach
            @php
                function int_to_roman($num) 
                {
                    $n = intval($num);
                    $result = '';
                    
                    $roman_numerals = array(
                        'M' => 1000,
                        'CM' => 900,
                        'D' => 500,
                        'CD' => 400,
                        'C' => 100,
                        'XC' => 90,
                        'L' => 50,
                        'XL' => 40,
                        'X' => 10,
                        'IX' => 9,
                        'V' => 5,
                        'IV' => 4,
                        'I' => 1
                    );
                    
                    foreach ($roman_numerals as $roman => $value) {
                        $matches = intval($n / $value);
                        $result .= str_repeat($roman, $matches);
                        $n = $n % $value;
                    }
                    
                    return $result;
                }
            @endphp
        </tr>
        <tr>
            <td>
                1
            </td>
            <td>
                Season
            </td>
            
            @foreach($data as $season)
            <td>
                {{$season->season == 'null' ? '' : $season->season}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                2
            </td>
            <td>
                Crop Name
            </td>
            
            @foreach($data as $crop_name)
            <td>
                {{$crop_name->crop_name == 'null' ? '' : $crop_name->crop_name}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                3
            </td>
            <td>
                Total Cultivatable  Area Unit
            </td>
            
            @foreach($data as $crop_area_unit)
            <td>
                {{$crop_area_unit->crop_area_unit == 'null' ? '' : $crop_area_unit->crop_area_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                4
            </td>
            <td>
                Total Cultivatable Crop Area
            </td>
            
            @foreach($data as $crop_area)
            <td>
                @if(isset($crop_area->crop_area_unit) && $crop_area->crop_area_unit == $entry1->crop_area_unit)
                    {{$entry1->crop_area == 'null' ? '' : $entry1->crop_area}}
                @else
                    {{$crop_area->crop_area == 'null' ? '' : $crop_area->crop_area}}
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                5
            </td>
            <td>
                Irrigated Area
            </td>
            
            @foreach($data as $irr)
            <td>
                @if(isset($irr->irrigated_area) && strtolower($irr->irrigated_area) == 'yes')
                    1
                @else
                    0
                @endif
               <!--{{$irr->irrigated_area == 'null' ? '' : $irr->irrigated_area}}-->
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                V
            </td>
            <th colspan="50">
                CULTIVATION  COST  
            </th>
        </tr>
        <tr>
            <td>
                1
            </td>
            <td>
                Family Labour Unit
            </td>
            
            @foreach($data as $fl)
            <td>
                @if(isset($fl->family_labour_unit) && $fl->family_labour_unit == 'mandays')
                    Mandays
                @elseif(isset($fl->family_labour_unit) && $fl->family_labour_unit == 'hours')
                    Hours
                @else
                    {{$fl->family_labour_unit == 'null' ? '' : $fl->family_labour_unit}}
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                2
            </td>
            <td>
                Family Labour
            </td>
            
            @foreach($data as $fl)
            <td>
                {{$fl->family_labour_hrs == 'null' ? '' : $fl->family_labour_hrs}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                3
            </td>
            <td>
                Family Labour Unit Price
            </td>
            
            @foreach($data as $familyLabourUnitPrice)
            <td>
                {{$familyLabourUnitPrice->family_labour_unit_price == 'null' ? '' : $familyLabourUnitPrice->family_labour_unit_price}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                4
            </td>
            <td>
                Family Labour (Rs.)
            </td>
            
            @foreach($data as $flr)
            <td>
                {{$flr->family_labour_rs == 'null' ? '' : $flr->family_labour_rs}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                5
            </td>
            <td>
                Family Labour Remarks
            </td>
            
            @foreach($data as $familyLabourRemarks)
            <td>
                {{$familyLabourRemarks->family_labour_remarks == 'null' ? '' : $familyLabourRemarks->family_labour_remarks}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                6
            </td>
            <td>
                Attached Labour Unit
            </td>
            
            @foreach($data as $fl)
            <td>
                @if(isset($fl->attached_labour_unit) && $fl->attached_labour_unit == 'mandays')
                    Mandays
                @elseif(isset($fl->attached_labour_unit) && $fl->attached_labour_unit == 'hours')
                    Hours
                @else
                    {{$fl->attached_labour_unit == 'null' ? '' : $fl->attached_labour_unit}}
                @endif
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                7
            </td>
            <td>
                Attached Labour 
            </td>
            
            @foreach($data as $attached_labour_hrs)
            <td>
                {{$attached_labour_hrs->attached_labour_hrs == 'null' ? '' : $attached_labour_hrs->attached_labour_hrs}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                8
            </td>
            <td>
                Attached Labour Unit Price
            </td>
            
            @foreach($data as $attachedLabourUnitPrice)
            <td>
                {{$attachedLabourUnitPrice->attached_labour_unit_price == 'null' ? '' : $attachedLabourUnitPrice->attached_labour_unit_price}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                9
            </td>
            <td>
                Attached Labour (Rs.)
            </td>
            
            @foreach($data as $attached_labour_rs)
            <td>
                {{$attached_labour_rs->attached_labour_rs == 'null' ? '' : $attached_labour_rs->attached_labour_rs}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               10
            </td>
            <td>
                Attached Labour Remarks
            </td>
            
            @foreach($data as $attachedLabourRemarks)
            <td>
                {{$attachedLabourRemarks->attached_labour_remarks == 'null' ? '' : $attachedLabourRemarks->attached_labour_remarks}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                11
            </td>
            <td>
                Casual Labour Unit
            </td>
            
            @foreach($data as $fl)
            <td>
                @if(isset($fl->casual_labour_unit) && $fl->casual_labour_unit == 'mandays')
                    Mandays
                @elseif(isset($fl->casual_labour_unit) && $fl->casual_labour_unit == 'hours')
                    Hours
                @else
                    {{$fl->casual_labour_unit == 'null' ? '' : $fl->casual_labour_unit}}
                @endif
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                12
            </td>
            <td>
                Casual Labour 
            </td>
            @foreach($data as $casual_labour_hrs)
            <td>
               {{$casual_labour_hrs->casual_labour_hrs == 'null' ? '' : $casual_labour_hrs->casual_labour_hrs}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                13
            </td>
            <td>
                Casual Labour Unit Price
            </td>
            
            @foreach($data as $casualLabourUnitPrice)
            <td>
                {{$casualLabourUnitPrice->casual_labour_unit_price == 'null' ? '' : $casualLabourUnitPrice->casual_labour_unit_price}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                14
            </td>
            <td>
                Casual Labour (Rs.)
            </td>
            
            @foreach($data as $casual_labour_rs)
            <td>
                {{$casual_labour_rs->casual_labour_rs == 'null' ? '' : $casual_labour_rs->casual_labour_rs}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               15
            </td>
            <td>
                Casual Labour Remarks
            </td>
            
            @foreach($data as $casualLabourRemarks)
            <td>
                {{$casualLabourRemarks->casual_labour_remarks == 'null' ? '' : $casualLabourRemarks->casual_labour_remarks}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                16
            </td>
            <td>
                Hired Animal Unit
            </td>
            
            @foreach($data as $hired_animal_unit)
            <td>
                {{$hired_animal_unit->hired_animal_unit == 'null' ? '' : $hired_animal_unit->hired_animal_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                17
            </td>
            <td>
                Hired Animal 
            </td>
            
            @foreach($data as $hiredAnimalHrs)
            <td>
                @if(isset($hiredAnimalHrs->hired_animal_unit) && $hiredAnimalHrs->hired_animal_unit == $entry1->hired_animal_unit)
                    {{$entry1->hired_animal_hrs == 'null' ? '' : $entry1->hired_animal_hrs}}
                @else
                    {{$hiredAnimalHrs->hired_animal_hrs == 'null' ? '' : $hiredAnimalHrs->hired_animal_hrs}}
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                18
            </td>
            <td>
                Hired Animal Unit Price
            </td>
            
            @foreach($data as $hiredAnimalUnitPrice)
            <td>
                {{$hiredAnimalUnitPrice->hired_animal_unit_price == 'null' ? '' : $hiredAnimalUnitPrice->hired_animal_unit_price}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                19
            </td>
            <td>
                Hired Animal (Rs)
            </td>
            
            @foreach($data as $hiredAnimalRs)
            <td>
                {{$hiredAnimalRs->hired_animal_rs == 'null' ? '' : $hiredAnimalRs->hired_animal_rs}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               20
            </td>
            <td>
                Hired Animal Remarks
            </td>
            
            @foreach($data as $hiredAnimalRemarks)
            <td>
                {{$hiredAnimalRemarks->hired_animal_remarks == 'null' ? '' : $hiredAnimalRemarks->hired_animal_remarks}}
            </td>
            @endforeach
        </tr>
        
         <tr>
            <td>
               21
            </td>
            <td>
                Owned Animal Unit
            </td>
            
            @foreach($data as $ownedAnimalUnit)
            <td>
                {{$ownedAnimalUnit->owned_animal_unit == 'null' ? '' : $ownedAnimalUnit->owned_animal_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                22
            </td>
            <td>
                Owned Animal 
            </td>
            
            @foreach($data as $owned_animal_hrs)
            <td>
                @if(isset($owned_animal_hrs->owned_animal_unit) && $owned_animal_hrs->owned_animal_unit == $entry1->owned_animal_unit)
                    {{$entry1->owned_animal_hrs == 'null' ? '' : $entry1->owned_animal_hrs}}
                @else
                    {{$owned_animal_hrs->owned_animal_hrs == 'null' ? '' : $owned_animal_hrs->owned_animal_hrs}}
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               23
            </td>
            <td>
                Owned Animal Unit Price
            </td>
            
            @foreach($data as $ownedAnimalUnitPrice)
            <td>
                {{$ownedAnimalUnitPrice->owned_animal_unit_price == 'null' ? '' : $ownedAnimalUnitPrice->owned_animal_unit_price}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                24
            </td>
            <td>
                Owned Animal Labour (Rs.)
            </td>
            
            @foreach($data as $owned_animal_rs)
            <td>
                {{$owned_animal_rs->owned_animal_rs == 'null' ? '' : $owned_animal_rs->owned_animal_rs}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
               25
            </td>
            <td>
                Owned Animal Remarks
            </td>
            
            @foreach($data as $ownedAnimalRemarks)
            <td>
                {{$ownedAnimalRemarks->owned_animal_remarks == 'null' ? '' : $ownedAnimalRemarks->owned_animal_remarks}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                26
            </td>
            <td>
                Hired Machine Unit
            </td>
            
            @foreach($data as $hired_machhine_unit)
            <td>
                {{$hired_machhine_unit->hired_machhine_unit == 'null' ? '' : $hired_machhine_unit->hired_machhine_unit}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                27
            </td>
            <td>
                Hired Machine 
            </td>
            
            @foreach($data as $hired_machhine_hrs)
            <td>
                {{$hired_machhine_hrs->hired_machhine_hrs == 'null' ? '' : $hired_machhine_hrs->hired_machhine_hrs}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                28
            </td>
            <td>
                Hired Machhine Unit Price
            </td>
            
            @foreach($data as $hiredMachhineUnitPrice)
            <td>
                {{$hiredMachhineUnitPrice->hired_machhine_unit_price == 'null' ? '' : $hiredMachhineUnitPrice->hired_machhine_unit_price}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                29
            </td>
            <td>
                Hired Machine (Rs.)
            </td>
            
            @foreach($data as $hired_machhine_rs)
            <td>
                {{$hired_machhine_rs->hired_machhine_rs == 'null' ? '' : $hired_machhine_rs->hired_machhine_rs}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                30
            </td>
            <td>
                Hired Machine Remarks
            </td>
            
            @foreach($data as $hiredMachhineRemarks)
            <td>
                {{$hiredMachhineRemarks->hired_machhine_remarks == 'null' ? '' : $hiredMachhineRemarks->hired_machhine_remarks}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                31
            </td>
            <td>
                Own Machine Unit
            </td>
            
            @foreach($data as $ownMachineUnit)
            <td>
                {{$ownMachineUnit->own_machine_unit == 'null' ? '' : $ownMachineUnit->own_machine_unit}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
                32
            </td>
            <td>
                Own Machine
            </td>
             @foreach($data as $own_machine_hrs)
            <td>
                {{$own_machine_hrs->own_machine_hrs == 'null' ? '' : $own_machine_hrs->own_machine_hrs}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                33
            </td>
            <td>
                Own Machine Unit Price
            </td>
            
            @foreach($data as $ownMachineUnitPrice)
            <td>
                {{$ownMachineUnitPrice->own_machine_unit_price == 'null' ? '' : $ownMachineUnitPrice->own_machine_unit_price}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                34
            </td>
            <td>
                Own Machine (Rs.)
            </td>
            @foreach($data as $own_machine_rs)
            <td>
                {{$own_machine_rs->own_machine_rs == 'null' ? '' : $own_machine_rs->own_machine_rs}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               35
            </td>
            <td>
                Own Machine Remarks
            </td>
            
            @foreach($data as $ownMachineRemarks)
            <td>
               {{$ownMachineRemarks->own_machine_remarks == 'null' ? '' : $ownMachineRemarks->own_machine_remarks}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
               36
            </td>
            <td>
                Hired Irrigation Machine Unit
            </td>
            
            @foreach($data as $hiredIrrigationMachineUnit)
            <td>
               {{$hiredIrrigationMachineUnit->hired_irrigation_machine_unit == 'null' ? '' : $hiredIrrigationMachineUnit->hired_irrigation_machine_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                37
            </td>
            <td>
                Hired Irrigation Machine 
            </td>
            
            @foreach($data as $hired_irrigation_machine_hrs)
            <td>
                @if(isset($hired_irrigation_machine_hrs->hired_animal_unit) && $hired_irrigation_machine_hrs->hired_irrigation_machine_unit == $entry1->hired_irrigation_machine_unit)
                    {{$entry1->hired_irrigation_machine_hrs == 'null' ? '' : $entry1->hired_irrigation_machine_hrs}}
                @else
                    {{$hired_irrigation_machine_hrs->hired_irrigation_machine_hrs == 'null' ? '' : $hired_irrigation_machine_hrs->hired_irrigation_machine_hrs}}
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                38
            </td>
            <td>
            Hired Irrigation Machine Unit Price
            </td>
            @foreach($data as $hired_irrigation_machine_unit_price)
            <td>
               {{$hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price == 'null' ? '' : $hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                39
            </td>
            <td>
           Hired Irrigation Machine (Rs.)
            </td>
            
            @foreach($data as $hired_irrigation_machine_rs)
            <td>
               {{$hired_irrigation_machine_rs->hired_irrigation_machine_rs == 'null' ? '' : $hired_irrigation_machine_rs->hired_irrigation_machine_rs}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                40
            </td>
            <td>
           Hired Irrigation Machine Remarks
            </td>
            @foreach($data as $hired_irrigation_machine_remarks)
            <td>
               {{$hired_irrigation_machine_remarks->hired_irrigation_machine_remarks == 'null' ? '' : $hired_irrigation_machine_remarks->hired_irrigation_machine_remarks}}
            </td>
            @endforeach
           
        </tr>
        
        <tr>
            <td>
               41
            </td>
            <td>
                Owned Irrigation Machine Unit
            </td>
            
            @foreach($data as $ownedIrrigationMachineUnit)
            <td>
               {{$ownedIrrigationMachineUnit->owned_irrigation_machine_unit == 'null' ? '' : $ownedIrrigationMachineUnit->owned_irrigation_machine_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                42
            </td>
            <td>
                Owned Irrigation Machine 
            </td>
            @foreach($data as $owned_irrigation_machine_hrs)
            <td>
                @if(isset($owned_irrigation_machine_hrs->owned_irrigation_machine_unit) && $owned_irrigation_machine_hrs->owned_irrigation_machine_unit == $entry1->owned_irrigation_machine_unit)
                    {{$entry1->owned_irrigation_machine_hrs == 'null' ? '' : $entry1->owned_irrigation_machine_hrs}}
                @else
                    {{$owned_irrigation_machine_hrs->owned_irrigation_machine_hrs == 'null' ? '' : $owned_irrigation_machine_hrs->owned_irrigation_machine_hrs}}
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               43
            </td>
            <td>
                Owned Irrigation Machine Unit Price
            </td>
            
            @foreach($data as $ownedIrrigationMachineUnitPrice)
            <td>
               {{$ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price == 'null' ? '' : $ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                44
            </td>
            <td>
          Owned Irrigation Machine (Rs.)
            </td>
            
            @foreach($data as $owned_irrigation_machine_rs)
            <td>
               {{$owned_irrigation_machine_rs->owned_irrigation_machine_rs == 'null' ? '' : $owned_irrigation_machine_rs->owned_irrigation_machine_rs}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               45
            </td>
            <td>
                Owned Irrigation Machine Remarks
            </td>
            
            @foreach($data as $ownedIrrigationMachineRemarks)
            <td>
               {{$ownedIrrigationMachineRemarks->owned_irrigation_machine_remarks == 'null' ? '' : $ownedIrrigationMachineRemarks->owned_irrigation_machine_remarks}}
            </td>
            @endforeach
        </tr>
        
    <!--Seed    -->
        <tr>
            <td>
               46
            </td>
            <td>
                Source of Seed / Plantlets
            </td>
            
            @foreach($data as $seedType)
            <td>
               {{$seedType->seed_type == 'null' ? '' : $seedType->seed_type}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               47
            </td>
            <td>
                Seed Variety
            </td>
            
            @foreach($data as $seedVariety)
            <td>
               {{$seedVariety->seed_variety == 'null' ? '' : $seedVariety->seed_variety}}
            </td>
            @endforeach
        </tr>
        
        
         <tr>
            <td>
               48
            </td>
            <td>
                Seed Qty Unit
            </td>
            
            @foreach($data as $seedQtyUnit)
            <td>
               {{$seedQtyUnit->seed_qty_unit == 'null' ? '' : $seedQtyUnit->seed_qty_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                49
            </td>
            <td>
                Seed / Plantlets Quanity
            </td>
            
            @foreach($data as $seed_qty)
            <td>
               {{$seed_qty->seed_qty == 'null' ? '' : $seed_qty->seed_qty}}
            </td>
            @endforeach
        </tr>
       
        <tr>
            <td>
               50
            </td>
            <td>
                Seed Unit Price
            </td>
            
            @foreach($data as $seedUnitPrice)
            <td>
               {{$seedUnitPrice->seed_unit_price == 'null' ? '' : $seedUnitPrice->seed_unit_price}}
            </td>
            @endforeach
        </tr>
        
         <tr>
            <td>
                51
            </td>
            <td>
            Seed Value (Rs.)
            </td>
            
            @foreach($data as $seed_value_rs)
            <td>
               {{$seed_value_rs->seed_value_rs == 'null' ? '' : $seed_value_rs->seed_value_rs}}
            </td>
            @endforeach
        </tr>

         <tr>
            <td>
               52
            </td>
            <td>
                Seed Remarks
            </td>
            
            @foreach($data as $seedRemarks)
            <td>
               {{$seedRemarks->seed_remarks == 'null' ? '' : $seedRemarks->seed_remarks}}
            </td>
            @endforeach
        </tr>
    
    <!--Fertiliser (N)-->
        <tr>
            <td>
               53
            </td>
            <td>
                Fertiliser (N) Qty Unit
            </td>
            
            @foreach($data as $fertiliserNQtyUnit)
            <td>
               {{$fertiliserNQtyUnit->fertiliser_n_qty_unit == 'null' ? '' : $fertiliserNQtyUnit->fertiliser_n_qty_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                54
            </td>
            <td>
                Fertiliser (N) Quantity
            </td>
            
            @foreach($data as $fertiliser_n_qty)
            <td>
               {{$fertiliser_n_qty->fertiliser_n_qty == 'null' ? '' : $fertiliser_n_qty->fertiliser_n_qty}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               55
            </td>
            <td>
                Fertiliser (N) Unit Price
            </td>
            
            @foreach($data as $fertiliserNUnitPrice)
            <td>
               {{$fertiliserNUnitPrice->fertiliser_n_unit_price == 'null' ? '' : $fertiliserNUnitPrice->fertiliser_n_unit_price}}
            </td>
            @endforeach
        </tr>

         <tr>
            <td>
                56
            </td>
            <td>
            Fertiliser (N) (Rs.)
            </td>
            
            @foreach($data as $fertiliser_n_rs)
            <td>
               {{$fertiliser_n_rs->fertiliser_n_rs == 'null' ? '' : $fertiliser_n_rs->fertiliser_n_rs}}
            </td>
            @endforeach
        </tr>
        
        
        <tr>
            <td>
               57
            </td>
            <td>
                Fertiliser (N) Remarks
            </td>
            
            @foreach($data as $fertiliserNRemarks)
            <td>
               {{$fertiliserNRemarks->fertiliser_n_remarks == 'null' ? '' : $fertiliserNRemarks->fertiliser_n_remarks}}
            </td>
            @endforeach
        </tr>
        
        
        
        <tr>
            <td>
               58
            </td>
            <td>
                Fertiliser (P) Qty Unit
            </td>
            
            @foreach($data as $fertiliserPQtyUnit)
            <td>
               {{$fertiliserPQtyUnit->fertiliser_p_qty_unit == 'null' ? '' : $fertiliserPQtyUnit->fertiliser_p_qty_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                59
            </td>
            <td>
                Fertiliser (P) Quanity
            </td>
            
            @foreach($data as $fertiliser_p_qty)
            <td>
               {{$fertiliser_p_qty->fertiliser_p_qty == 'null' ? '' : $fertiliser_p_qty->fertiliser_p_qty}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               60
            </td>
            <td>
                Fertiliser (P) Unit Price
            </td>
            
            @foreach($data as $fertiliserPUnitPrice)
            <td>
               {{$fertiliserPUnitPrice->fertiliser_p_unit_price == 'null' ? '' : $fertiliserPUnitPrice->fertiliser_p_unit_price}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                61
            </td>
            <td>
            Fertiliser (P) (Rs.)
            </td>
            
            @foreach($data as $fertiliser_p_rs)
            <td>
               {{$fertiliser_p_rs->fertiliser_p_rs == 'null' ? '' : $fertiliser_p_rs->fertiliser_p_rs}}
            </td>
            @endforeach
        </tr>

        <tr>
            <td>
               62
            </td>
            <td>
                Fertiliser (P) Remarks
            </td>
            
            @foreach($data as $fertiliserPRemarks)
            <td>
               {{$fertiliserPRemarks->fertiliser_p_remarks == 'null' ? '' : $fertiliserPRemarks->fertiliser_p_remarks}}
            </td>
            @endforeach
        </tr>
        
        
        <tr>
            <td>
               63
            </td>
            <td>
                Fertiliser (K) Qty Unit
            </td>
            
            @foreach($data as $fertiliserKQtyUnit)
            <td>
               {{$fertiliserKQtyUnit->fertiliser_k_qty_unit == 'null' ? '' : $fertiliserKQtyUnit->fertiliser_k_qty_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                64
            </td>
            <td>
                Fertiliser (K) Quanity
            </td>
            
            @foreach($data as $fertiliser_k_qty)
            <td>
               {{$fertiliser_k_qty->fertiliser_k_qty == 'null' ? '' : $fertiliser_k_qty->fertiliser_k_qty}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               65
            </td>
            <td>
                Fertiliser (K) Unit Price
            </td>
            
            @foreach($data as $fertiliserKUnitPrice)
            <td>
               {{$fertiliserKUnitPrice->fertiliser_k_unit_price == 'null' ? '' : $fertiliserKUnitPrice->fertiliser_k_unit_price}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                66
            </td>
            <td>
            Fertiliser (K) (Rs.)
            </td>
            
            @foreach($data as $fertiliser_k_rs)
            <td>
               {{$fertiliser_k_rs->fertiliser_k_rs == 'null' ? '' : $fertiliser_k_rs->fertiliser_k_rs}}
            </td>
            @endforeach
        </tr>

         <tr>
            <td>
               67
            </td>
            <td>
                Fertiliser (K) Remarks
            </td>
            
            @foreach($data as $fertiliserKRemarks)
            <td>
               {{$fertiliserKRemarks->fertiliser_k_remarks == 'null' ? '' : $fertiliserKRemarks->fertiliser_k_remarks}}
            </td>
            @endforeach
        </tr>
    
    
        <tr>
            <td>
               68
            </td>
            <td>
                Other Fertiliser Qty Unit
            </td>
            
            @foreach($data as $otherFertiliserQtyUnit)
            <td>
               {{$otherFertiliserQtyUnit->other_fertiliser_qty_unit == 'null' ? '' : $otherFertiliserQtyUnit->other_fertiliser_qty_unit}}
            </td>
            @endforeach
        </tr>
        <!--<tr>
            <td>
               66
            </td>
            <td>
                Other Fertiliser Qty Unit Remarks
            </td>
            
            @foreach($data as $otherFertiliserQtyUnitRemarks)
            <td>
               {{$otherFertiliserQtyUnitRemarks->other_fertiliser_qty_unit_remarks == 'null' ? '' : $otherFertiliserQtyUnitRemarks->other_fertiliser_qty_unit_remarks}}
            </td>
            @endforeach
        </tr>-->
        <!--<tr>-->
        <!--    <td>-->
        <!--       67-->
        <!--    </td>-->
        <!--    <td>-->
        <!--        Other Fertiliser (Kg)-->
        <!--    </td>-->
            
        <!--    @foreach($data as $otherFertiliserKg)-->
        <!--    <td>-->
        <!--       {{$otherFertiliserKg->other_fertiliser_kg == 'null' ? '' : $otherFertiliserKg->other_fertiliser_kg}}-->
        <!--    </td>-->
        <!--    @endforeach-->
        <!--</tr>-->
        
        <tr>
            <td>
                69
            </td>
            <td>
            Other Fertiliser Qty
            </td>
            
            @foreach($data as $other_fertiliser_qty)
            <td>
               {{$other_fertiliser_qty->other_fertiliser_qty == 'null' ? '' : $other_fertiliser_qty->other_fertiliser_qty}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
               70
            </td>
            <td>
                Other Fertiliser Unit Price
            </td>
            
            @foreach($data as $otherFertiliserUnitPrice)
            <td>
               {{$otherFertiliserUnitPrice->other_fertiliser_unit_price == 'null' ? '' : $otherFertiliserUnitPrice->other_fertiliser_unit_price}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
                71
            </td>
            <td>
            Other Fertiliser (Rs.)
            </td>
            
            @foreach($data as $other_fertiliser_rs)
            <td>
               {{$other_fertiliser_rs->other_fertiliser_rs == 'null' ? '' : $other_fertiliser_rs->other_fertiliser_rs}}
            </td>
            @endforeach
        </tr>
        
        
        <tr>
            <td>
               72
            </td>
            <td>
                Other Fertiliser Remarks
            </td>
            
            @foreach($data as $otherFertiliserRemarks)
            <td>
               {{$otherFertiliserRemarks->other_fertiliser_remarks == 'null' ? '' : $otherFertiliserRemarks->other_fertiliser_remarks}}
            </td>
            @endforeach
        </tr>
        
        
        
        <tr>
            <td>
               73
            </td>
            <td>
                DAP Qty Unit
            </td>
            
            @foreach($data as $dapQtyUnit)
            <td>
               {{$dapQtyUnit->dap_qty_unit == 'null' ? '' : $dapQtyUnit->dap_qty_unit}}
            </td>
            @endforeach
        </tr>
       
        <!--<tr>-->
        <!--    <td>-->
        <!--        73-->
        <!--    </td>-->
        <!--    <td>-->
        <!--    DAP (Kg)-->
        <!--    </td>-->
            
        <!--    @foreach($data as $dap_kg)-->
        <!--    <td>-->
        <!--       {{$dap_kg->dap_kg == 'null' ? '' : $dap_kg->dap_kg}}-->
        <!--    </td>-->
        <!--    @endforeach-->
        <!--</tr>-->
        
        <tr>
            <td>
               74
            </td>
            <td>
                DAP Qty
            </td>
            
            @foreach($data as $dapQty)
            <td>
               {{$dapQty->dap_qty == 'null' ? '' : $dapQty->dap_qty}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               75
            </td>
            <td>
                DAP Unit Price
            </td>
            
            @foreach($data as $dapUnitPrice)
            <td>
               {{$dapUnitPrice->dap_unit_price == 'null' ? '' : $dapUnitPrice->dap_unit_price}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
                76
            </td>
            <td>
                DAP (Rs)
            </td>
            
            @foreach($data as $dap_rs)
            <td>
               {{$dap_rs->dap_rs == 'null' ? '' : $dap_rs->dap_rs}}
            </td>
            @endforeach
        </tr>
        <!--<tr>-->
        <!--    <td>-->
        <!--       78-->
        <!--    </td>-->
        <!--    <td>-->
        <!--        DAP Unit Remarks-->
        <!--    </td>-->
            
        <!--    @foreach($data as $dapUnitRemarks)-->
        <!--    <td>-->
        <!--       {{$dapUnitRemarks->dap_unit_remarks == 'null' ? '' : $dapUnitRemarks->dap_unit_remarks}}-->
        <!--    </td>-->
        <!--    @endforeach-->
        <!--</tr>-->
        
        <tr>
            <td>
               77
            </td>
            <td>
                DAP Remarks
            </td>
            
            @foreach($data as $dapRemarks)
            <td>
               {{$dapRemarks->dap_remarks == 'null' ? '' : $dapRemarks->dap_remarks}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
               78
            </td>
            <td>
                NPK Qty Unit
            </td>
            
            @foreach($data as $npkQtyUnit)
            <td>
               {{$npkQtyUnit->npk_qty_unit == 'null' ? '' : $npkQtyUnit->npk_qty_unit}}
            </td>
            @endforeach
        </tr>
        <!--<tr>-->
        <!--    <td>-->
        <!--       79-->
        <!--    </td>-->
        <!--    <td>-->
        <!--        Npk Qty Unit Remarks-->
        <!--    </td>-->
            
        <!--    @foreach($data as $npkQtyUnitRemarks)-->
        <!--    <td>-->
        <!--       {{$npkQtyUnitRemarks->npk_qty_unit_remarks == 'null' ? '' : $npkQtyUnitRemarks->npk_qty_unit_remarks}}-->
        <!--    </td>-->
        <!--    @endforeach-->
        <!--</tr>-->
        <!--<tr>-->
        <!--    <td>-->
        <!--        80-->
        <!--    </td>-->
        <!--    <td>-->
        <!--        NPK (Kg)-->
        <!--    </td>-->
            
        <!--    @foreach($data as $npk_kg)-->
        <!--    <td>-->
        <!--       {{$npk_kg->npk_kg == 'null' ? '' : $npk_kg->npk_kg}}-->
        <!--    </td>-->
        <!--    @endforeach-->
        <!--</tr>-->
        
        <tr>
            <td>
               79
            </td>
            <td>
                NPK Qty
            </td>
            
            @foreach($data as $npkQty)
            <td>
               {{$npkQty->npk_qty == 'null' ? '' : $npkQty->npk_qty}}
            </td>
            @endforeach
        </tr>

        <tr>
            <td>
               80
            </td>
            <td>
                NPK Unit Price
            </td>
            
            @foreach($data as $npkUnitPrice)
            <td>
               {{$npkUnitPrice->npk_unit_price == 'null' ? '' : $npkUnitPrice->npk_unit_price}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
                81
            </td>
            <td>
                NPK (Rs.)
            </td>
            
            @foreach($data as $npk_rs)
            <td>
               {{$npk_rs->npk_rs == 'null' ? '' : $npk_rs->npk_rs}}
            </td>
            @endforeach
        </tr>

        <tr>
            <td>
               82
            </td>
            <td>
                NPK Remarks
            </td>
            
            @foreach($data as $npkRemarks)
            <td>
               {{$npkRemarks->npk_remarks == 'null' ? '' : $npkRemarks->npk_remarks}}
            </td>
            @endforeach
        </tr>
        
        
        <tr>
            <td>
               83
            </td>
            <td>
                Manure Qty Unit
            </td>
            @foreach($data as $manureQtyUnit)
            <td>
               {{$manureQtyUnit->manure_qty_unit == 'null' ? '' : $manureQtyUnit->manure_qty_unit}}
            </td>
            @endforeach
        </tr>

        <!--<tr>-->
        <!--    <td>-->
        <!--       86-->
        <!--    </td>-->
        <!--    <td>-->
        <!--        Manure Qty Unit Remarks-->
        <!--    </td>-->
            
        <!--    @foreach($data as $manureQtyUnitRemarks)-->
        <!--    <td>-->
        <!--       {{$manureQtyUnitRemarks->manure_qty_unit_remarks == 'null' ? '' : $manureQtyUnitRemarks->manure_qty_unit_remarks}}-->
        <!--    </td>-->
        <!--    @endforeach-->
        <!--</tr>-->
        <!--<tr>-->
        <!--    <td>-->
        <!--        87-->
        <!--    </td>-->
        <!--    <td>-->
        <!--    Manure (Qtl.) FYM-->
        <!--    </td>-->
            
        <!--    @foreach($data as $manure_qtl)-->
        <!--    <td>-->
        <!--       {{$manure_qtl->manure_qtl == 'null' ? '' : $manure_qtl->manure_qtl}}-->
        <!--    </td>-->
        <!--    @endforeach-->
        <!--</tr>-->

        <tr>
            <td>
               84
            </td>
            <td>
                Manure Qty
            </td>
            
            @foreach($data as $manureQty)
            <td>
               {{$manureQty->manure_qty == 'null' ? '' : $manureQty->manure_qty}}
            </td>
            @endforeach
        </tr>

        <tr>
            <td>
               85
            </td>
            <td>
                Manure Unit Price
            </td>
            
            @foreach($data as $manureUnitPrice)
            <td>
               {{$manureUnitPrice->manure_unit_price == 'null' ? '' : $manureUnitPrice->manure_unit_price}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
                86
            </td>
            <td>
            Manure (Rs.) FYM
            </td>
            
            @foreach($data as $manure_rs)
            <td>
               {{$manure_rs->manure_rs == 'null' ? '' : $manure_rs->manure_rs}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               87
            </td>
            <td>
                Manure Remarks
            </td>
            
            @foreach($data as $manureRemarks)
            <td>
               {{$manureRemarks->manure_remarks == 'null' ? '' : $manureRemarks->manure_remarks}}
            </td>
            @endforeach
        </tr>

        <tr>
            <td>
               88
            </td>
            <td>
                Insecticide Unit
            </td>
            
            @foreach($data as $insecticideUnit)
            <td>
               {{$insecticideUnit->insecticide_unit == 'null' ? '' : $insecticideUnit->insecticide_unit}}
            </td>
            @endforeach
        </tr>

        <tr>
            <td>
               89
            </td>
            <td>
                Plant Protection Name
            </td>
            
            @foreach($data as $insticideName)
            <td>
               {{$insticideName->insticide_name == 'null' ? '' : $insticideName->insticide_name}}
            </td>
            @endforeach
        </tr>

        <tr>
            <td>
               90
            </td>
            <td>
                Plant Protection Qty
            </td>
            
            @foreach($data as $insecticideQty)
           
            <td>
               {{$insecticideQty->insecticide_qty == 'null' ? '' : $insecticideQty->insecticide_qty}}
            </td>
            @endforeach
        </tr>

        <tr>
            <td>
               91
            </td>
            <td>
                Plant Protection Unit Price
            </td>
            
            @foreach($data as $insecticideUnitPrice)
            <td>
               {{$insecticideUnitPrice->insecticide_unit_price == 'null' ? '' : $insecticideUnitPrice->insecticide_unit_price}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                92
            </td>
            <td>
                Plant Protection (Rs.)
            </td>
            
            @foreach($data as $insecticide_rs)
            <td>
               {{$insecticide_rs->insecticide_rs == 'null' ? '' : $insecticide_rs->insecticide_rs}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               93
            </td>
            <td>
                Plant Protection Remarks
            </td>
            
            @foreach($data as $insecticideRemarks)
            <td>
               {{$insecticideRemarks->insecticide_remarks == 'null' ? '' : $insecticideRemarks->insecticide_remarks}}
            </td>
            @endforeach
        </tr>
       <tr>
            <td>
               94
            </td>
            <td>
                Canal / other Irrigation Charges (Rs)
            </td>
            
            @foreach($data as $canalOtherCharges)
            <td>
               {{$canalOtherCharges->canal_other_charges == 'null' ? '' : $canalOtherCharges->canal_other_charges}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
                95
            </td>
            <td>
            Crop Insurance (Rs.)
            </td>
            
            @foreach($data as $crop_insurance_rs)
            <td>
               {{$crop_insurance_rs->crop_insurance_rs == 'null' ? '' : $crop_insurance_rs->crop_insurance_rs}}
            </td>
            @endforeach
        </tr>
        
         <tr>
            <td>
                96
            </td>
            <td>
            Miscelaneous Cost (Rs.)
            </td>
            
            @foreach($data as $miscelaneous_cost_rs)
            <td>
               {{$miscelaneous_cost_rs->miscelaneous_cost_rs == 'null' ? '' : $miscelaneous_cost_rs->miscelaneous_cost_rs}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
               97
            </td>
            <td>
            Land Revenue (Rs.) LAGAN
            </td>
            
            @foreach($data as $land_revenue_rs)
            <td>
               {{$land_revenue_rs->land_revenue_rs == 'null' ? '' : $land_revenue_rs->land_revenue_rs}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
                98
            </td>
            <td>
            Rent Paid for Leased in Land (Rs.)
            </td>
            
            @foreach($data as $rent_paid_leased_land)
            <td>
               {{$rent_paid_leased_land->rent_paid_leased_land == 'null' ? '' : $rent_paid_leased_land->rent_paid_leased_land}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               99
            </td>
            <td>
            Interest on working capital rate(%) KCC
            </td>
            
            @foreach($data as $interest_kcc)
            <td>
               {{$interest_kcc->interest_kcc == 'null' ? '' : $interest_kcc->interest_kcc}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
               100
            </td>
            <td>
                Depericiation of Farm Assets
            </td>
            
            @foreach($data as $depericiation_farm_assets)
            <td>
               {{$depericiation_farm_assets->depericiation_farm_assets == 'null' ? '' : $depericiation_farm_assets->depericiation_farm_assets}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>101</td>
            <td>Total Cost Of Cultivation</td>
            @foreach($data as $item)
                @php
                    $sumOfAllValue = $item->family_labour_rs + $item->attached_labour_rs + $item->casual_labour_rs + 
                        $item->hired_animal_rs + $item->owned_animal_rs + $item->own_machine_rs + $item->hired_irrigation_machine_rs + 
                        $item->owned_irrigation_machine_rs + $item->seed_value_rs + $item->hired_machhine_rs +
                        $item->fertiliser_n_rs + $item->fertiliser_p_rs + $item->fertiliser_k_rs + 
                        $item->other_fertiliser_rs + $item->dap_rs + $item->npk_rs + 
                        $item->crop_insurance_rs + $item->miscelaneous_cost_rs +
                        $item->land_revenue_rs + $item->rent_paid_leased_land;
                @endphp
        
                <td>{{ $sumOfAllValue }}</td>
            @endforeach
        </tr>


        <!--<tr>-->
        <!--    <td>-->
        <!--        104-->
        <!--    </td>-->
        <!--    <td>-->
        <!--    Canal and Other Irrigation Charges (Rs)-->
        <!--    </td>-->
            
        <!--    @foreach($data as $other_irrigation_charges_hrs)-->
        <!--    <td>-->
        <!--       {{$other_irrigation_charges_hrs->other_irrigation_charges_hrs == 'null' ? '' : $other_irrigation_charges_hrs->other_irrigation_charges_hrs}}-->
        <!--    </td>-->
        <!--    @endforeach-->
        <!--</tr>-->
        
        <tr>
            <td>
              W
            </td>
            <th colspan="50">
                Farm Output
            </th>
        </tr>
        <tr>
            <td>
               1
            </td>
            <td>
                Total Production Unit
            </td>
            
            @foreach($data as $totalProductionUnit)
            <td>
               {{$totalProductionUnit->total_production_unit == 'null' ? '' : $totalProductionUnit->total_production_unit}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
               2
            </td>
            <td>
               Total Production
            </td>
            
            @foreach($data as $total_production)
            <td>
               {{$total_production->total_production == 'null' ? '' : $total_production->total_production}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
               3
            </td>
            <td>
                Sold Main Product Unit
            </td>
            
            @foreach($data as $soldMainProductUnit)
            <td>
               {{$soldMainProductUnit->sold_main_product_unit == 'null' ? '' : $soldMainProductUnit->sold_main_product_unit}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               4
            </td>
            <td>
              Sold Main Product
            </td>
            
            @foreach($data as $sold_main_product)
            <td>
                @if(isset($sold_main_product->sold_main_product) && strtolower($sold_main_product->sold_main_product) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               5
            </td>
            <td>
                Total Main Product Sold
            </td>
            
            @foreach($data as $totalMainProductSold)
            <td>
               {{$totalMainProductSold->total_main_product_sold == 'null' ? '' : $totalMainProductSold->total_main_product_sold}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               6
            </td>
            <td>
             Selling Price of main products
            </td>
            
            @foreach($data as $selling_price_main_product)
            <td>
               {{$selling_price_main_product->selling_price_main_product == 'null' ? '' : $selling_price_main_product->selling_price_main_product}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               7
            </td>
            <td>
             Total Selling Price Of Main Product 
            </td>
            
            @foreach($data as $itemMulti)
                @php
                    $multiOfAllValue = $itemMulti->total_main_product_sold * $itemMulti->selling_price_main_product;
                @endphp
        
                <td>{{ $multiOfAllValue }}</td>
            @endforeach
        </tr>
        <tr>
            <td>
               8
            </td>
            <td>
            By Product (Rs.)
            </td>
            
            @foreach($data as $by_product)
            <td>
               {{$by_product->by_product == 'null' ? '' : $by_product->by_product}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               9
            </td>
            <td>
             Selling  Price of By-products
            </td>
            
            @foreach($data as $selling_price_by_product)
            <td>
               {{$selling_price_by_product->selling_price_by_product == 'null' ? '' : $selling_price_by_product->selling_price_by_product}}
            </td>
            @endforeach
        </tr>
        
         <tr>
            <td>
                X
            </td>
            <th colspan="50">
                Whom to sold
            </th>
        </tr>
        <tr>
            <td>
               10
            </td>
            <td>
            Village Trader
            </td>
            @foreach($data as $village_trader)
            <td>
               {{$village_trader->village_trader == 'null' ? '0' : $village_trader->village_trader}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
               11
            </td>
            <td>
            Wholesaler
            </td>
            
            @foreach($data as $wholesaler)
            <td>
               {{$wholesaler->wholesaler == 'null' ? '' : $wholesaler->wholesaler}}
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
               12
            </td>
            <td>
           MANDI
            </td>
            
            @foreach($data as $mandi)
            <td>
               {{$mandi->mandi == 'null' ? '' : $mandi->mandi}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               13
            </td>
            <td>
           Processor
            </td>
            
            @foreach($data as $processor)
            <td>
               {{$processor->processor == 'null' ? '' : $processor->processor}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               14
            </td>
            <td>
         Retailer
            </td>
            
            @foreach($data as $retailer)
            <td>
               {{$retailer->retailer == 'null' ? '' : $retailer->retailer}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               15
            </td>
            <td>
          Consumer
            </td>
            
            @foreach($data as $consumer)
            <td>
               {{$consumer->consumer == 'null' ? '' : $consumer->consumer}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               16
            </td>
            <td>
                Company
            </td>
            
            @foreach($data as $company)
            <td>
               {{$company->company == 'null' ? '' : $company->company}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               17
            </td>
            <td>
                Commission Agent
            </td>
            
            @foreach($data as $commissionAgent)
            <td>
               {{$commissionAgent->commission_agent == 'null' ? '' : $commissionAgent->commission_agent}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               18
            </td>
            <td>
                Other
            </td>
            @foreach($data as $production_outputs_other)
            <td>
               {{$production_outputs_other->production_outputs_other == 'null' ? '' : $production_outputs_other->production_outputs_other}}
            </td>
            @endforeach
        </tr>
       
       
        <tr>
            <td>
                Y
            </td>
            <th colspan="50">
                Infrastructure
            </th>
        </tr>
        <!--<tr>-->
        <!--    <td>-->
        <!--       X-->
        <!--    </td>-->
        <!--    <th colspan="50">-->
        <!--         INFRASTRUCTURE -->
        <!--    </td>-->
        <!--</tr>-->
        <tr>
            <td>
               1
            </td>
            <th colspan="50">
                Irrigation Infrastructure
            </td>
        </tr>
         <tr>
            <td>
               a
            </td>
            <td>
         Canal
            </td>
            
            @foreach($data as $canal)
            <td>
                @if(isset($canal->canal) && strtolower($canal->canal) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
               b
            </td>
            <td>
                   Tubewell
            </td>
            
            @foreach($data as $tubewell)
            <td>
                @if(isset($tubewell->tubewell) && strtolower($tubewell->tubewell) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               c
            </td>
            <td>
                 Enginer / Motor / Solar 
            </td>
            
            @foreach($data as $enginer_motor_solar)
            <td>
                @if(isset($enginer_motor_solar->enginer_motor_solar) && strtolower($enginer_motor_solar->enginer_motor_solar) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               d
            </td>
            <td>
                  Pump sets ( Diesel/ electric/ Solar)
            </td>
            
            @foreach($data as $pump_sets)
            <td>
                @if(isset($pump_sets->pump_sets) && strtolower($pump_sets->pump_sets) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               e
            </td>
            <td>
              Pond
            </td>
            
            @foreach($data as $pond)
            <td>
                @if(isset($pond->pond) && strtolower($pond->pond) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               f
            </td>
            <td>
                Sprinkler / drip irrigation System
            </td>
            
            @foreach($data as $irrigation_system)
            <td>
                @if(isset($irrigation_system->irrigation_system) && strtolower($irrigation_system->irrigation_system) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               g
            </td>
            <td>
                Pump House
            </td>
            
            @foreach($data as $pumpHouse)
            <td>
                @if(isset($pumpHouse->pump_house) && strtolower($pumpHouse->pump_house) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               h
            </td>
            <td>
                Other
            </td>
            
            @foreach($data as $irrigation_infrastructures_other)
            <td>
                {{$irrigation_infrastructures_other->irrigation_infrastructures_other == 'null' ? '' : $irrigation_infrastructures_other->irrigation_infrastructures_other}}
            </td>
            @endforeach
            
            <!--@foreach($data as $other)-->
            <!--<td>-->
            <!--   {{$other->other == 'null' ? '' : $other->other}}-->
            <!--</td>-->
            <!--@endforeach-->
        </tr>
        
        <tr>
            <td>
                2
            </td>
            <th colspan="50">
                Farm Mechanization Infrastructure
            </th>
        </tr>
        <!--<tr>-->
        <!--    <td>-->
        <!--       2-->
        <!--    </td>-->
        <!--    <th colspan="50">-->
        <!--        Farm Mechanization-->
        <!--    </td>-->
        <!--</tr>-->
        <tr>
            <td>
               a
            </td>
            <td>
               Tractor
            </td>
            
            @foreach($data as $tractor)
            <td>
                @if(isset($tractor->tractor) && strtolower($tractor->tractor) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
         
          <tr>
            <td>
               b
            </td>
            <td>
              Power Tiller
            </td>
            
            @foreach($data as $power_tiller)
            <td>
                @if(isset($power_tiller->power_tiller) && strtolower($power_tiller->power_tiller) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               c
            </td>
            <td>
             Cultivator
            </td>
            
            @foreach($data as $cultivator)
            <td>
                @if(isset($cultivator->cultivator) && strtolower($cultivator->cultivator) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               d
            </td>
            <td>
              Rotator
            </td>
            
            @foreach($data as $rotator)
            <td>
                @if(isset($rotator->rotator) && strtolower($rotator->rotator) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               e
            </td>
            <td>
               Harrow
            </td>
            
            @foreach($data as $harrow)
            <td>
                @if(isset($harrow->harrow) && strtolower($harrow->harrow) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               f
            </td>
            <td>
              Leveller
            </td>
            
            @foreach($data as $leveller)
            <td>
                @if(isset($leveller->leveller) && strtolower($leveller->leveller) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               g
            </td>
            <td>
               Plough (MB Plough / Disc Plough)
            </td>
            
            @foreach($data as $plough)
            <td>
                @if(isset($plough->plough) && strtolower($plough->plough) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               h
            </td>
            <td>
             Seed drill 
            </td>
            
            @foreach($data as $speed_drill)
            <td>
                @if(isset($speed_drill->speed_drill) && strtolower($speed_drill->speed_drill) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               i
            </td>
            <td>
              Seed Planter
            </td>
            
            @foreach($data as $speed_planter)
            <td>
                @if(isset($speed_planter->speed_planter) && strtolower($speed_planter->speed_planter) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               j
            </td>
            <td>
               Seed cum fertilizer drill
            </td>
            
            @foreach($data as $speed_cum_fertilizer_drill)
            <td>
                @if(isset($speed_cum_fertilizer_drill->speed_cum_fertilizer_drill) && strtolower($speed_cum_fertilizer_drill->speed_cum_fertilizer_drill) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               k
            </td>
            <td>
               Trolley
            </td>
            
            @foreach($data as $trolley)
            <td>
                @if(isset($trolley->trolley) && strtolower($trolley->trolley) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               l
            </td>
            <td>
              Reaper cum binder
            </td>
            
            @foreach($data as $reaper_cum_binder)
            <td>
                @if(isset($reaper_cum_binder->reaper_cum_binder) && strtolower($reaper_cum_binder->reaper_cum_binder) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
          <tr>
            <td>
               m
            </td>
            <td>
            Bhusa Making Machine
            </td>
            
            @foreach($data as $bhusa_machine)
            <td>
                @if(isset($bhusa_machine->bhusa_machine) && strtolower($bhusa_machine->bhusa_machine) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
               n
            </td>
            <td>
              Thresher
            </td>
            
            @foreach($data as $thresher)
            <td>
                @if(isset($thresher->thresher) && strtolower($thresher->thresher) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
               o
            </td>
            <td>
              Combine Harvester
            </td>
            
            @foreach($data as $combine_harvester)
            <td>
                @if(isset($combine_harvester->combine_harvester) && strtolower($combine_harvester->combine_harvester) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               p
            </td>
            <td>
               Other
            </td>
            
            @foreach($data as $farm_mechanisms_other)
            <td>
               {{$farm_mechanisms_other->farm_mechanisms_other == 'null' ? '' : $farm_mechanisms_other->farm_mechanisms_other}}
            </td>
            @endforeach
        </tr>
        
        <tr>
            <td>
                3
            </td>
            <th colspan="50">
                Storage Infrastructure
            </th>
        </tr>
        <!--<tr>-->
        <!--    <td>-->
        <!--       3-->
        <!--    </td>-->
        <!--    <th colspan="50">-->
        <!--        Storage Structure-->
        <!--    </td>-->
        <!--</tr>-->
         <tr>
            <td>
               a
            </td>
            <td>
              Kothila / Deshi Stoarge Structure
            </td>
            
            @foreach($data as $deshi)
            <td>
                @if(isset($deshi->deshi) && strtolower($deshi->deshi) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               b
            </td>
            <td>
              Godown
            </td>
            
            @foreach($data as $godown)
            <td>
                @if(isset($godown->godown) && strtolower($godown->godown) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               c
            </td>
            <td>
              Clod Stoarge
            </td>
            
            @foreach($data as $clod)
            <td>
                @if(isset($clod->clod) && strtolower($clod->clod) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               d
            </td>
            <td>
             Bulk Cooling Unit
            </td>
            
            @foreach($data as $bulk_cooling)
            <td>
                @if(isset($bulk_cooling->bulk_cooling) && strtolower($bulk_cooling->bulk_cooling) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               e
            </td>
            <td>
             Storage for fodder
            </td>
            
            @foreach($data as $fodder)
            <td>
                @if(isset($fodder->fodder) && strtolower($fodder->fodder) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        
        
        <tr>
            <td>
               f
            </td>
            <td>
             Other
            </td>
            @foreach($data as $storage_structures_other)
            <td>
               {{$storage_structures_other->storage_structures_other == 'null' ? '' : $storage_structures_other->storage_structures_other}}
            </td>
            @endforeach
        </tr>
        
        
        <tr>
            <td>
                4
            </td>
            <th colspan="50">
                Processing Infrastructure
            </th>
        </tr>
        <tr>
            <td>
               a
            </td>
            <td>
              Wheat Processing Unit
            </td>
            
            @foreach($data as $wheat_processing)
            <td>
                @if(isset($wheat_processing->wheat_processing) && strtolower($wheat_processing->wheat_processing) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               b
            </td>
            <td>
             Oil Processing Unit
            </td>
            
            @foreach($data as $oil_processing)
            <td>
                @if(isset($oil_processing->oil_processing) && strtolower($oil_processing->oil_processing) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               c
            </td>
            <td>
              Sugarcane Processing Unit
            </td>
            
            @foreach($data as $sugarcane_processing)
            <td>
                @if(isset($sugarcane_processing->sugarcane_processing) && strtolower($sugarcane_processing->sugarcane_processing) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               d
            </td>
            <td>
              Dal Processing Unit
            </td>
            
            @foreach($data as $dal_processing)
            <td>
                @if(isset($dal_processing->dal_processing) && strtolower($dal_processing->dal_processing) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               e
            </td>
            <td>
             Any Other Processing unit
            </td>
            
            @foreach($data as $other_processing)
            <td>
               {{$other_processing->other_processing == 'null' ? '' : $other_processing->other_processing}}
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               5
            </td>
            <th colspan="50">
                Marketing Infrastructure
            </th>
        </tr>
        <!--<tr>-->
        <!--    <td>-->
        <!--       5-->
        <!--    </td>-->
        <!--    <th colspan="50">-->
        <!--        Retails outlet with producer-->
        <!--    </td>-->
        <!--</tr>-->
         <tr>
            <td>
               a
            </td>
            <td>
            Kiran Outlets
            </td>
            
            @foreach($data as $kiran_outlets)
            <td>
                @if(isset($kiran_outlets->kiran_outlets) && strtolower($kiran_outlets->kiran_outlets) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
         <tr>
            <td>
               b
            </td>
            <td>
            Grossary Outlets
            </td>
            
            @foreach($data as $grossary_outlets)
            <td>
                @if(isset($grossary_outlets->grossary_outlets) && strtolower($grossary_outlets->grossary_outlets) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               c
            </td>
            <td>
             Any Other Retail outlets
            </td>
            
            @foreach($data as $other_outlets)
            <td>
                 {{$other_outlets->other_outlets == 'null' ? '' : $other_outlets->other_outlets}}
            </td>
            @endforeach
        </tr>
        
        
        <!--<tr>-->
        <!--    <td>-->
        <!--       6-->
        <!--    </td>-->
        <!--    <th colspan="50">-->
        <!--       Other Infrastructure (Specify)-->
        <!--    </td>-->
        <!--</tr>-->
        
        <tr>
            <td>
                6
            </td>
            <th colspan="50">
               Farm Infrastructure
            </th>
        </tr>
        <tr>
            <td>
               a
            </td>
            <td>
             Shed (Kuchha)
            </td>
            
            @foreach($data as $shed_kuchha)
            <td>
                @if(isset($shed_kuchha->shed_kuchha) && strtolower($shed_kuchha->shed_kuchha) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               b
            </td>
            <td>
            Shed (Pucca)
            </td>
            
            @foreach($data as $shed_pucca)
            <td>
                @if(isset($shed_pucca->shed_pucca) && strtolower($shed_pucca->shed_pucca) == 'yes')
                    1
                @else
                    0
                @endif
            </td>
            @endforeach
        </tr>
        <tr>
            <td>
               c
            </td>
            <td>
            Any other infrastructrure 
            </td>
            
            @foreach($data as $other_infrastructure)
            <td>
               {{$other_infrastructure->other_infrastructure == 'null' ? '' : $other_infrastructure->other_infrastructure}}
            </td>
            @endforeach
        </tr>
        
        
    </table>
    </div>
 </div>
@endsection