<?php
    use App\Models\HectareMeasurement;
    use App\Models\User;
    use Illuminate\Support\Collection;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
    
    
    $loggedInTeamLeaderId = $userDetail->team_leader_id;
    
    
    $uniqueUserIds = $data->pluck('user_id')->unique();
    $hectareMaster = HectareMeasurement::all();
    $targetTeamLeaderId = $hectareMaster->pluck('user_id')->filter()->unique()->values();
    $userData = User::all();
    
    $filteredUsers = $userData->filter(function ($user) use ($targetTeamLeaderId) {
        return $targetTeamLeaderId->contains($user->team_leader_id);
    });
    
    $userId = $filteredUsers->pluck('id')->filter()->unique()->values();
    
    $filteredCollection = $hectareMaster->filter(function ($item) use ($targetTeamLeaderId) {
        return $targetTeamLeaderId->contains($item->user_id);
    });
    
    // $filteredCollection = $hectareMaster->filter(function ($item) use ($loggedInTeamLeaderId) {
    //     return $item->user_id === $loggedInTeamLeaderId;
    // });
    
    $landMeas = $hectareMaster->filter(function ($item) use ($userDetail) {
        return $item->user_id === $userDetail->id;
    });
    
    $hectare_master_unit = 'hectare';
    foreach ($data as $entry1){
        $user_id = $entry1->user_id; 
        if(isset($targetTeamLeaderId[0])){
            $teamLeadArray = (array)$targetTeamLeaderId[0] ?? [];
        }else{
            $teamLeadArray = [];
        }
        
        if(in_array($entry1->team_leader_id, $teamLeadArray)){
                foreach ($filteredCollection as $entry2) {
  
                        if($entry1->total_cultivable_unit == $entry2->unit && is_numeric($entry1->total_cultivable)){
                            $entry1->total_cultivable_unit = $hectare_master_unit;
                            $entry1->total_cultivable = number_format($entry1->total_cultivable/$entry2->value,3);
                        }
        
                        if($entry1->land_holding_size_unit == $entry2->unit && is_numeric( $entry1->land_holding_size)){
                          $entry1->land_holding_size_unit = $hectare_master_unit;
                          $entry1->land_holding_size = number_format($entry1->land_holding_size/$entry2->value,3);
                        }
                        
                        if($entry1->crop_area_unit == $entry2->unit && is_numeric( $entry1->crop_area)){
                            $entry1->crop_area_unit = $hectare_master_unit;
                            $entry1->crop_area = number_format($entry1->crop_area/$entry2->value,3);
                        }
                        
                        if($entry1->hired_animal_unit == $entry2->unit && is_numeric($entry1->hired_animal_unit)){
                            $entry1->hired_animal_unit = $hectare_master_unit;
                            $entry1->hired_animal_hrs = number_format($entry1->hired_animal_unit/$entry2->value,3);
                        }
                        
                        if($entry1->owned_animal_unit == $entry2->unit && is_numeric($entry1->owned_animal_hrs)){
                            $entry1->owned_animal_unit = $hectare_master_unit;
                            $entry1->owned_animal_hrs = number_format($entry1->owned_animal_hrs/$entry2->value,3);
                        }
                        
                        if($entry1->hired_irrigation_machine_unit == $entry2->unit  && is_numeric($entry1->hired_irrigation_machine_hrs)){
                            $entry1->hired_irrigation_machine_unit = $hectare_master_unit;
                            $entry1->hired_irrigation_machine_hrs = number_format($entry1->hired_irrigation_machine_hrs/$entry2->value,3);
                        }
                        
                        if($entry1->owned_irrigation_machine_unit == $entry2->unit && is_numeric($entry1->owned_irrigation_machine_hrs)){
                            $entry1->owned_irrigation_machine_unit = $hectare_master_unit;
                            $entry1->owned_irrigation_machine_hrs = number_format($entry1->owned_irrigation_machine_hrs/$entry2->value,3);
                        }
                        
                        if($entry1->land_holding_taken_lease_unit == $entry2->unit && is_numeric($entry1->land_holding_taken_lease)){
                            $entry1->land_holding_taken_lease_unit = $hectare_master_unit;
                            $entry1->land_holding_taken_lease = number_format($entry1->land_holding_taken_lease/$entry2->value,3);
                        }
                        
                        if($entry1->land_given_lease_unit == $entry2->unit && is_numeric($entry1->land_given_lease)){
                            $entry1->land_given_lease_unit = $hectare_master_unit;
                            $entry1->land_given_lease = number_format($entry1->land_given_lease/$entry2->value,3);
                        }
                }
        }
    }
    
    $unitArr = [];
     foreach($data as $unites){
      $val = $unites->insecticide_unit !== null ? json_decode($unites->insecticide_unit, true) : [];
      if(count($val) > count($unitArr)){
         $unitArr = $val; 
      }
    }
    
    $otherferArr = [];
        foreach($data as $otherferunit){
          $val = $otherferunit->other_fertiliser_name !== null ? json_decode($otherferunit->other_fertiliser_name, true) : [];
          if(count($val) > count($otherferArr)){
             $otherferArr = $val; 
          }
    }
   
    $prother = [];
        foreach($data as $proOther){
          $val = $proOther->production_outputs_other !== null ? json_decode($proOther->production_outputs_other, true) : [];
          if(count($val) > count($prother)){
             $prother = $val; 
          }
    }

?>
@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')



<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-3">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            
            <div class="col-lg-9">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.one.update') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <a href="{{ route('anexure.one') }}" class="btn btn-primary btn-sm">Back</a>
                </form>
            </div>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Anexure List One</h1>
        </div>
        
        <form id="dataForm" action="{{ route('anexure.one.update') }}" method="POST">
            @csrf
            <input type="hidden" name="data_id" id="data_id" value="">
            <input type="hidden" name="farmer_id" id="farmer_id" value="">

            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <tr>
                    <td>
                        A
                    </td>
                    <td>
                        FARMER CODE
                    </td>
                    
                    @foreach($data as $farmer)
                    <td>
                       <input type="text" name="" disabled value="{{$farmer->farmer_code}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        B
                    </td>
                    <td>
                        Farmer Name
                    </td>
                    
                    @foreach($data as $farmer_first_name)
                    <td>
                       
                        <input type="text" name="" disabled 
                        value="{{$farmer_first_name->farmer_first_name == 'null' ? '' : $farmer_first_name->farmer_first_name }} {{$farmer_first_name->farmer_last_name == 'null' ? '' : $farmer_first_name->farmer_last_name}}">
                    </td>
                    @endforeach
                    
                       
                       
                        
                        
                    
                </tr>
                <!--<tr>-->
                <!--    <td>-->
                <!--        B-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Farmer Last Name-->
                <!--    </td>-->
                    
                <!--    @foreach($data as $farmer_last_name)-->
                <!--    <td>-->
                <!--        <input type="text" name="" disabled value="{{$farmer_last_name->farmer_last_name == 'null' ? '' : $farmer_last_name->farmer_last_name}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                <tr>
                    <td>
                        C
                    </td>
                    <td>
                       S/O or W/O
                    </td>
                    
                    @foreach($data as $father_name)
                    <td>
                        <input type="text" name="" disabled value="{{isset($father_name->farmer_husband_father_name) && $father_name->farmer_husband_father_name ? $father_name->farmer_husband_father_name : ''}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        D
                    </td>
                    <td>
                       Village
                    </td>
                    
                    @foreach($data as $farmer_village)
                    <td>
                        <input type="text" name="" disabled value="{{$farmer_village->user_village == 'null' ? '' : $farmer_village->user_village}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        E
                    </td>
                   <td>
                      State
                    </td>
                    
                    @foreach($data as $farmer_state)
                    <td>
                        <input type="text" name="" disabled value="{{$farmer_state->farmer_state_name == 'null' ? '' : $farmer_state->farmer_state_name}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        F
                    </td>
                   <td>
                      District
                    </td>
                    
                    @foreach($data as $farmer_dis)
                    <td>
                        <input type="text" name="" disabled value="{{$farmer_dis->farmer_district_name == 'null' ? '' : $farmer_dis->farmer_district_name}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        G
                    </td>
                    <td>
                       Block
                    </td>
                    
                    @foreach($data as $farmer_block)
                    <td>
                        <input type="text" name="" disabled value="{{$farmer_block->farmer_block == 'null' ? '' : $farmer_block->farmer_block}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        H
                    </td>
                    <td>
                        Mobile Number
                    </td>
                    
                    @foreach($data as $mobile_number)
                    <td>
                        <input type="text" name="" disabled value="{{$mobile_number->farmer_mobile_number == 'null' ? '' : $mobile_number->farmer_mobile_number}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        I
                    </td>
                    <td>
                        Kcc Limit
                    </td>
                    @foreach($data as $kcc_limit)
                    <td>
                        <input type="text" 
                        name="kcc_limit_{{isset($kcc_limit->id) && $kcc_limit->id ? $kcc_limit->id : ''}}_{{isset($kcc_limit->farmerId) && $kcc_limit->farmerId ? $kcc_limit->farmerId : ''}}" value="{{$kcc_limit->kcc_limit == 'null' ? '' : $kcc_limit->kcc_limit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        J
                    </td>
                    <td>
                        Land Type
                    </td>
                    
                    @foreach($data as $land_type)
                    <td>
                        <input type="text" 
                        name="land_type_{{isset($land_type->id) && $land_type->id ? $land_type->id : ''}}_{{isset($land_type->farmerId) && $land_type->farmerId ? $land_type->farmerId : ''}}" value="{{$land_type->land_type == 'null' ? '' : $land_type->land_type}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        K
                    </td>
                    <td>
                        Soil Health Card
                    </td>
                    
                    @foreach($data as $soilHealthCard)
                    <td>
                        <input type="text" 
                        name="soil_health_card_{{isset($soilHealthCard->id) && $soilHealthCard->id ? $soilHealthCard->id : ''}}_{{isset($soilHealthCard->farmerId) && $soilHealthCard->farmerId ? $soilHealthCard->farmerId : ''}}" value="{{$soilHealthCard->soil_health_card == 'null' ? '' : $soilHealthCard->soil_health_card}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        L
                    </td>
                    <td>
                        Soil Health Card Remark
                    </td>
                    @foreach($data as $soilHealthCardRemark)
                    <td>
                        <input type="text" 
                        name="soil_health_card_remark_{{isset($soilHealthCardRemark->farmerId) && $soilHealthCardRemark->farmerId ? $soilHealthCardRemark->farmerId : ''}}_{{isset($soilHealthCardRemark->id) && $soilHealthCardRemark->id ? $soilHealthCardRemark->id : ''}}" value="{{$soilHealthCardRemark->soil_health_card_remark == 'null' ? '' : $soilHealthCardRemark->soil_health_card_remark}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        M
                    </td>
                    <td>
                        Land Holding Size Unit
                    </td>
                    
                    @foreach($data as $landHoldSizeUnit)
                    <td>
                        <input type="text" 
                        name="land_holding_size_unit_{{isset($landHoldSizeUnit->id) && $landHoldSizeUnit->id ? $landHoldSizeUnit->id : ''}}_{{isset($landHoldSizeUnit->farmerId) && $landHoldSizeUnit->farmerId ? $landHoldSizeUnit->farmerId : ''}}" value="{{$landHoldSizeUnit->land_holding_size_unit == 'null' ? '' : $landHoldSizeUnit->land_holding_size_unit}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        N
                    </td>
                    <td>
                        Land Holding (Area)
                    </td>
                    
                    @foreach($data as $land_holding_size)
                    <td>
                      
                   
                   
                    
                    <input type="text" 
                        name="land_holding_size_{{isset($land_holding_size->id) && $land_holding_size->id ? $land_holding_size->id : ''}}_{{isset($land_holding_size->farmerId) && $land_holding_size->farmerId ? $land_holding_size->farmerId : ''}}" 
                        value=" {{$land_holding_size->land_holding_size == 'null' ? '' : $land_holding_size->land_holding_size}}">
                        
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        O
                    </td>
                    <td>
                        Land Given Lease Unit
                    </td>
                    
                    @foreach($data as $landGivenLeaseUnit)
                    <td>
                        <input type="text" 
                        name="land_given_lease_unit_{{isset($landGivenLeaseUnit->id) && $landGivenLeaseUnit->id ? $landGivenLeaseUnit->id : ''}}_{{isset($landGivenLeaseUnit->farmerId) && $landGivenLeaseUnit->farmerId ? $landGivenLeaseUnit->farmerId : ''}}" value="{{$landGivenLeaseUnit->land_given_lease_unit == 'null' ? '' : $landGivenLeaseUnit->land_given_lease_unit}}">
                    </td>
                    @endforeach
                </tr>
                 <tr>
                    <td>
                        P
                    </td>
                    <td>
                        Land Given Lease (Area)
                    </td>
                    
                    @foreach($data as $landGivenLease)
                    <td>
                       
                               
                    
                    <input type="text" name="land_given_lease_{{isset($landGivenLease->id) && $landGivenLease->id ? $landGivenLease->id : ''}}" 
                            value="{{ $landGivenLease->land_given_lease == 'null' ? '' : $landGivenLease->land_given_lease }}">
                        
                        
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        Q
                    </td>
                    <td>
                        Land Holding Taken Lease Unit
                    </td>
                    
                    @foreach($data as $landHoldTakenLeaseUnit)
                    <td>
                        <input type="text" name="land_holding_taken_lease_unit_{{isset($landHoldTakenLeaseUnit->id) && $landHoldTakenLeaseUnit->id ? $landHoldTakenLeaseUnit->id : ''}}" value="{{$landHoldTakenLeaseUnit->land_holding_taken_lease_unit == 'null' ? '' : $landHoldTakenLeaseUnit->land_holding_taken_lease_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        R
                    </td>
                    <td>
                        Land Holding taken Lease (Area)
                    </td>
                    
                    @foreach($data as $land_holding_taken_lease)
                    <td>
                       
                        
                        <input type="text" name="land_holding_taken_lease_{{isset($land_holding_taken_lease->id) && $land_holding_taken_lease->id ? $land_holding_taken_lease->id : ''}}" 
                        value="">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        S
                    </td>
                    <td>
                        Total Cultivable Area Unit
                    </td>
                    
                    @foreach($data as $totalCultiUnit)
                    <td>
                        <input type="text" name="total_cultivable_unit_{{isset($totalCultiUnit->id) && $totalCultiUnit->id ? $totalCultiUnit->id : ''}}" value="{{$totalCultiUnit->total_cultivable_unit == 'null' ? '' : $totalCultiUnit->total_cultivable_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        T
                    </td>
                    <td>
                        Total Cultivable (Area)
                    </td>
                    
                    @foreach($data as $total_cultivable)
                    <td>
                   
                    
                    <input type="text" name="total_cultivable_{{isset($total_cultivable->id) && $total_cultivable->id ? $total_cultivable->id : ''}}" 
                    value="{{$totalCultiUnit->total_cultivable_unit == 'null' ? '' : $totalCultiUnit->total_cultivable_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        U
                    </td>
                   <td>
                        CROPPING PATTERN
                    </td>
                     @php
                        $counter = [];
                    @endphp
                    @foreach($data as $crop_patt)
                     @php
                            $farmerId = $crop_patt->farmer_id;
                            $counter[$farmerId] = isset($counter[$farmerId]) ? $counter[$farmerId] + 1 : 1;
                             $romanCount = int_to_roman($counter[$farmerId]);
                        @endphp
                    <td>
                       CROP {{ $romanCount }}
                    </td>
                    @endforeach
                    @php
                            function int_to_roman($num) {
                                $n = intval($num);
                                $result = '';
                                
                                $roman_numerals = array(
                                    'M' => 1000,
                                    'CM' => 900,
                                    'D' => 500,
                                    'CD' => 400,
                                    'C' => 100,
                                    'XC' => 90,
                                    'L' => 50,
                                    'XL' => 40,
                                    'X' => 10,
                                    'IX' => 9,
                                    'V' => 5,
                                    'IV' => 4,
                                    'I' => 1
                                );
                                
                                foreach ($roman_numerals as $roman => $value) {
                                    $matches = intval($n / $value);
                                    $result .= str_repeat($roman, $matches);
                                    $n = $n % $value;
                                }
                                
                                return $result;
                            }
                        @endphp
                </tr>
                <tr>
                    <td>
                        1
                    </td>
                    <td>
                        Season
                    </td>
                    
                    @foreach($data as $season)
                    <td>
                        <input type="text" 
                        name="season_{{isset($season->id) && $season->id ? $season->id : ''}}_{{isset($season->farmerId) && $season->farmerId ? $season->farmerId : ''}}" value="{{$season->season == 'null' ? '' : $season->season}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        2
                    </td>
                    <td>
                        Crop Name
                    </td>
                    @foreach($data as $crop_name)
                    <td>
                        <input type="text" name="crop_name_{{isset($crop_name->id) && $crop_name->id ? $crop_name->id : ''}}_{{isset($crop_name->farmerId) && $crop_name->farmerId ? $crop_name->farmerId : ''}}" value="{{$crop_name->crop_name == 'null' ? '' : $crop_name->crop_name}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        3
                    </td>
                    <td>
                        Total Cultivatable  Area Unit
                    </td>
                    
                    @foreach($data as $crop_area_unit)
                    <td>
                        <input type="text" name="crop_area_unit_{{isset($crop_area_unit->id) && $crop_area_unit->id ? $crop_area_unit->id : ''}}_{{isset($crop_area_unit->farmerId) && $crop_area_unit->farmerId ? $crop_area_unit->farmerId : ''}}" value="{{$crop_area_unit->crop_area_unit == 'null' ? '' : $crop_area_unit->crop_area_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        4
                    </td>
                    <td>
                        Total Cultivatable Crop Area
                    </td>
                    
                    @foreach($data as $crop_area)
                    <td>
                   
                    <input type="text" name="crop_area_{{isset($crop_area->id) && $crop_area->id ? $crop_area->id : ''}}_{{isset($crop_area->farmerId) && $crop_area->farmerId ? $crop_area->farmerId : ''}}" 
                    value="{{$crop_area->crop_area == 'null' ? '' : $crop_area->crop_area}}">
                    </td>
                    @endforeach
                    
                </tr>
                <tr>
                    <td>
                        5
                    </td>
                    <td>
                        Irrigated Area
                    </td>
                    
                    @foreach($data as $irr)
                    <td>
                        <input type="text" name="irrigated_area_{{isset($irr->id) && $irr->id ? $irr->id : ''}}_{{isset($irr->farmerId) && $irr->farmerId ? $irr->farmerId : ''}}" value="{{$irr->irrigated_area == 'null' ? '' : $irr->irrigated_area}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        V
                    </td>
                    <th colspan="50">
                        CULTIVATION  COST 
                    </td>
                       
                </tr>
                
                <tr>
                    <td>
                        1
                    </td>
                    <td>
                        Family Labour Unit
                    </td>
                    
                    @foreach($data as $fl)
                    <td>
                        <input type="text" name="family_labour_unit_{{isset($fl->id) && $fl->id ? $fl->id : ''}}_{{isset($fl->farmerId) && $fl->farmerId ? $fl->farmerId : ''}}"
                        
                        @if(isset($fl->family_labour_unit) && $fl->family_labour_unit == 'mandays')
                            value="Mandays"
                        @elseif(isset($fl->family_labour_unit) && $fl->family_labour_unit == 'hours')
                           value="Hours" 
                        @else
                            value="{{$fl->family_labour_unit == 'null' ? '' : $fl->family_labour_unit}}"
                        @endif
                        >
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        2
                    </td>
                    <td>
                        Family Labour
                    </td>
                    
                    @foreach($data as $fl)
                    <td>
                        <input type="text" name="family_labour_hrs_{{isset($fl->id) && $fl->id ? $fl->id : ''}}_{{isset($fl->farmerId) && $fl->farmerId ? $fl->farmerId : ''}}" value="{{$fl->family_labour_hrs == 'null' ? '' : $fl->family_labour_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        3
                    </td>
                    <td>
                        Family Labour Unit Price
                    </td>
                    
                    @foreach($data as $familyLabourUnitPrice)
                    <td>
                        <input type="text" name="family_labour_unit_price_{{isset($familyLabourUnitPrice->id) && $familyLabourUnitPrice->id ? $familyLabourUnitPrice->id : ''}}_{{isset($familyLabourUnitPrice->farmerId) && $familyLabourUnitPrice->farmerId ? $familyLabourUnitPrice->farmerId : ''}}" value="{{$familyLabourUnitPrice->family_labour_unit_price == 'null' ? '' : $familyLabourUnitPrice->family_labour_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        4
                    </td>
                    <td>
                        Family Labour (Rs.)
                    </td>
                    
                    @foreach($data as $flr)
                    <td>
                        <input type="text" name="family_labour_rs_{{isset($flr->id) && $flr->id ? $flr->id : ''}}_{{isset($flr->farmerId) && $flr->farmerId ? $flr->farmerId : ''}}" value="{{$flr->family_labour_rs == 'null' ? '' : $flr->family_labour_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        5
                    </td>
                    <td>
                        Family Labour Remarks
                    </td>
                    
                    @foreach($data as $familyLabourRemarks)
                    <td>
                        <input type="text" name="family_labour_remarks_{{isset($familyLabourRemarks->id) && $familyLabourRemarks->id ? $familyLabourRemarks->id : ''}}_{{isset($familyLabourRemarks->farmerId) && $familyLabourRemarks->farmerId ? $familyLabourRemarks->farmerId : ''}}" value="{{$familyLabourRemarks->family_labour_remarks == 'null' ? '' : $familyLabourRemarks->family_labour_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        6
                    </td>
                    <td>
                        Attached Labour Unit
                    </td>
                    
                    @foreach($data as $fl)
                    <td>
                        <input type="text" name="attached_labour_unit_{{isset($fl->id) && $fl->id ? $fl->id : ''}}_{{isset($fl->farmerId) && $fl->farmerId ? $fl->farmerId : ''}}" value="{{$fl->attached_labour_unit == 'null' ? '' : $fl->attached_labour_unit}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        6
                    </td>
                    <td>
                        Attached Labour Duration
                    </td>
                    
                    @foreach($data as $attached_labour_duration)
                    <td>
                        <input type="text" name="attached_labour_duration_{{isset($attached_labour_duration->id) && $attached_labour_duration->id ? $attached_labour_duration->id : ''}}_{{isset($attached_labour_duration->farmerId) && $attached_labour_duration->farmerId ? $attached_labour_duration->farmerId : ''}}" value="{{$attached_labour_duration->attached_labour_duration == 'null' ? '' : $attached_labour_duration->attached_labour_duration}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        7
                    </td>
                    <td>
                        Attached Labour
                    </td>
                    
                    @foreach($data as $attached_labour_hrs)
                    <td>
                        <input type="text" name="attached_labour_hrs_{{isset($attached_labour_hrs->id) && $attached_labour_hrs->id ? $attached_labour_hrs->id : ''}}_{{isset($attached_labour_hrs->farmerId) && $attached_labour_hrs->farmerId ? $attached_labour_hrs->farmerId : ''}}" value="{{$attached_labour_hrs->attached_labour_hrs == 'null' ? '' : $attached_labour_hrs->attached_labour_hrs}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        8
                    </td>
                    <td>
                        Attached Labour Unit Price
                    </td>
                    
                    @foreach($data as $attachedLabourUnitPrice)
                    <td>
                        <input type="text" name="attached_labour_unit_price_{{isset($attachedLabourUnitPrice->id) && $attachedLabourUnitPrice->id ? $attachedLabourUnitPrice->id : ''}}_{{isset($attachedLabourUnitPrice->farmerId) && $attachedLabourUnitPrice->farmerId ? $attachedLabourUnitPrice->farmerId : ''}}" value="{{$attachedLabourUnitPrice->attached_labour_unit_price == 'null' ? '' : $attachedLabourUnitPrice->attached_labour_unit_price}}">
                    </td>
                    @endforeach
                </tr>
        
                <tr>
                    <td>
                        9
                    </td>
                    <td>
                        Attached Labour (Rs.)
                    </td>
                    
                    @foreach($data as $attached_labour_rs)
                    <td>
                        <input type="text" name="attached_labour_rs_{{isset($attached_labour_rs->id) && $attached_labour_rs->id ? $attached_labour_rs->id : ''}}_{{isset($attached_labour_rs->farmerId) && $attached_labour_rs->farmerId ? $attached_labour_rs->farmerId : ''}}" value="{{$attached_labour_rs->attached_labour_rs == 'null' ? '' : $attached_labour_rs->attached_labour_rs}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       10
                    </td>
                    <td>
                        Attached Labour Remarks
                    </td>
                    
                    @foreach($data as $attachedLabourRemarks)
                    <td>
                        <input type="text" name="attached_labour_remarks_{{isset($attachedLabourRemarks->id) && $attachedLabourRemarks->id ? $attachedLabourRemarks->id : ''}}_{{isset($attachedLabourRemarks->farmerId) && $attachedLabourRemarks->farmerId ? $attachedLabourRemarks->farmerId : ''}}" value="{{$attachedLabourRemarks->attached_labour_remarks == 'null' ? '' : $attachedLabourRemarks->attached_labour_remarks}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        11
                    </td>
                    <td>
                        Casual Labour Unit
                    </td>
                    
                    @foreach($data as $fl)
                    <td>
                        <input type="text" name="casual_labour_unit_{{isset($fl->id) && $fl->id ? $fl->id : ''}}_{{isset($fl->farmerId) && $fl->farmerId ? $fl->farmerId : ''}}" value="{{$fl->casual_labour_unit == 'null' ? '' : $fl->casual_labour_unit}}">
                    </td>
                    @endforeach
                </tr>
                
                <!--<tr>-->
                <!--    <td>-->
                <!--        12-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Casual Labour (Rs.)-->
                <!--    </td>-->
                    
                <!--    @foreach($data as $casual_labour_rs)-->
                <!--    <td>-->
                <!--        <input type="text" name="casual_labour_rs_{{isset($casual_labour_rs->id) && $casual_labour_rs->id ? $casual_labour_rs->id : ''}}" value="{{$casual_labour_rs->casual_labour_rs == 'null' ? '' : $casual_labour_rs->casual_labour_rs}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
            
                <tr>
                    <td>
                        12
                    </td>
                    <td>
                        Casual Labour
                    </td>
                    
                    @foreach($data as $casual_labour_hrs)
                    <td>
                        <input type="text" name="casual_labour_hrs_{{isset($casual_labour_hrs->id) && $casual_labour_hrs->id ? $casual_labour_hrs->id : ''}}_{{isset($casual_labour_hrs->farmerId) && $casual_labour_hrs->farmerId ? $casual_labour_hrs->farmerId : ''}}" value="{{$casual_labour_hrs->casual_labour_hrs == 'null' ? '' : $casual_labour_hrs->casual_labour_hrs}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        13
                    </td>
                    <td>
                        Casual Labour Unit Price
                    </td>
                    
                    @foreach($data as $casualLabourUnitPrice)
                    <td>
                        <input type="text" name="casual_labour_unit_price_{{isset($casualLabourUnitPrice->id) && $casualLabourUnitPrice->id ? $casualLabourUnitPrice->id : ''}}_{{isset($casualLabourUnitPrice->farmerId) && $casualLabourUnitPrice->farmerId ? $casualLabourUnitPrice->farmerId : ''}}" value="{{$casualLabourUnitPrice->casual_labour_unit_price == 'null' ? '' : $casualLabourUnitPrice->casual_labour_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                
                
                 <tr>
                    <td>
                        14
                    </td>
                    <td>
                        Casual Labour (Rs.)
                    </td>
                    
                    @foreach($data as $casual_labour_rs)
                    <td>
                        <input type="text" name="casual_labour_rs_{{isset($casual_labour_rs->id) && $casual_labour_rs->id ? $casual_labour_rs->id : ''}}_{{isset($casual_labour_rs->farmerId) && $casual_labour_rs->farmerId ? $casual_labour_rs->farmerId : ''}}" value="{{$casual_labour_rs->casual_labour_rs == 'null' ? '' : $casual_labour_rs->casual_labour_rs}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       15
                    </td>
                    <td>
                        Casual Labour Remarks
                    </td>
                    
                    @foreach($data as $casualLabourRemarks)
                    <td>
                        <input type="text" name="casual_labour_remarks_{{isset($casualLabourRemarks->id) && $casualLabourRemarks->id ? $casualLabourRemarks->id : ''}}_{{isset($casualLabourRemarks->farmerId) && $casualLabourRemarks->farmerId ? $casualLabourRemarks->farmerId : ''}}" value="{{$casualLabourRemarks->casual_labour_remarks == 'null' ? '' : $casualLabourRemarks->casual_labour_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        16
                    </td>
                    <td>
                        Hired Animal Unit
                    </td>
                    
                    @foreach($data as $hired_animal_unit)
                    <td>
                        <input type="text" name="hired_animal_unit_{{isset($hired_animal_unit->id) && $hired_animal_unit->id ? $hired_animal_unit->id : ''}}_{{isset($hired_animal_unit->farmerId) && $hired_animal_unit->farmerId ? $hired_animal_unit->farmerId : ''}}" value="{{$hired_animal_unit->hired_animal_unit == 'null' ? '' : $hired_animal_unit->hired_animal_unit}}">
                    </td>
                    @endforeach
                </tr>
                <!--<tr>-->
                <!--    <td>-->
                <!--        17-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Animal Labour-->
                <!--    </td>-->
                    
                <!--    @foreach($data as $hired_animal_labour_rs)-->
                <!--    <td>-->
                <!--        <input type="text" name="hired_animal_labour_rs_{{isset($hired_animal_labour_rs->id) && $hired_animal_labour_rs->id ? $hired_animal_labour_rs->id : ''}}" value="{{$hired_animal_labour_rs->hired_animal_labour_rs == 'null' ? '' : $hired_animal_labour_rs->hired_animal_labour_rs}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                
                <tr>
                    <td>
                        17
                    </td>
                    <td>
                        Hired Animal 
                    </td>
                    
                    @foreach($data as $hiredAnimalHrs)
                    <td>
                        
                         <input type="text" name="hiredAnimalHrs_{{isset($hiredAnimalHrs->id) && $hiredAnimalHrs->id ? $hiredAnimalHrs->id : ''}}_{{isset($hiredAnimalHrs->farmerId) && $hiredAnimalHrs->farmerId ? $hiredAnimalHrs->farmerId : ''}}" 
                         value="{{$hiredAnimalHrs->hired_animal_hrs == 'null' ? '' : $hiredAnimalHrs->hired_animal_hrs}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        18
                    </td>
                    <td>
                        Hired Animal Unit Price
                    </td>
                    
                    @foreach($data as $hiredAnimalUnitPrice)
                    <td>
                        <input type="text" name="hired_animal_unit_price_{{isset($hiredAnimalUnitPrice->id) && $hiredAnimalUnitPrice->id ? $hiredAnimalUnitPrice->id : ''}}_{{isset($hiredAnimalUnitPrice->farmerId) && $hiredAnimalUnitPrice->farmerId ? $hiredAnimalUnitPrice->farmerId : ''}}" value="{{$hiredAnimalUnitPrice->hired_animal_unit_price == 'null' ? '' : $hiredAnimalUnitPrice->hired_animal_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <!--<tr>-->
                <!--    <td>-->
                <!--        18-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Animal Labour -->
                <!--    </td>-->
                    
                <!--    @foreach($data as $hired_animal_labour_hrs)-->
                <!--    <td>-->
                <!--        <input type="text" name="hired_animal_labour_hrs_{{isset($hired_animal_labour_hrs->id) && $hired_animal_labour_hrs->id ? $hired_animal_labour_hrs->id : ''}}" value="{{$hired_animal_labour_hrs->hired_animal_labour_hrs == 'null' ? '' : $hired_animal_labour_hrs->hired_animal_labour_hrs}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                
                <tr>
                    <td>
                        19
                    </td>
                    <td>
                        Hired Animal (Rs)
                    </td>
                    
                    @foreach($data as $hiredAnimalRs)
                    <td>
                        
                        <input type="text" name="hiredAnimalRs_{{isset($hiredAnimalRs->id) && $hiredAnimalRs->id ? $hiredAnimalRs->id : ''}}_{{isset($hiredAnimalRs->farmerId) && $hiredAnimalRs->farmerId ? $hiredAnimalRs->farmerId : ''}}"
                        value="{{$hiredAnimalRs->hired_animal_rs == 'null' ? '' : $hiredAnimalRs->hired_animal_rs}}">
                    </td>
                    @endforeach
                </tr>
        
                <tr>
                    <td>
                       20
                    </td>
                    <td>
                        Hired Animal Remarks
                    </td>
                    
                    @foreach($data as $hiredAnimalRemarks)
                    <td>
                        <input type="text" name="hired_animal_remarks_{{isset($hiredAnimalRemarks->id) && $hiredAnimalRemarks->id ? $hiredAnimalRemarks->id : ''}}_{{isset($hiredAnimalRemarks->farmerId) && $hiredAnimalRemarks->farmerId ? $hiredAnimalRemarks->farmerId : ''}}" value="{{$hiredAnimalRemarks->hired_animal_remarks == 'null' ? '' : $hiredAnimalRemarks->hired_animal_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       21
                    </td>
                    <td>
                        Owned Animal Unit
                    </td>
                    
                    @foreach($data as $ownedAnimalUnit)
                    <td>
                        <input type="text" name="owned_animal_unit_{{isset($ownedAnimalUnit->id) && $ownedAnimalUnit->id ? $ownedAnimalUnit->id : ''}}_{{isset($ownedAnimalUnit->farmerId) && $ownedAnimalUnit->farmerId ? $ownedAnimalUnit->farmerId : ''}}" value="{{$ownedAnimalUnit->owned_animal_unit == 'null' ? '' : $ownedAnimalUnit->owned_animal_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        22
                    </td>
                    <td>
                        Owned Animal  
                    </td>
                    
                    @foreach($data as $owned_animal_hrs)
                    <td>
                        <input type="text" name="owned_animal_hrs_{{isset($owned_animal_hrs->id) && $owned_animal_hrs->id ? $owned_animal_hrs->id : ''}}_{{isset($owned_animal_hrs->farmerId) && $owned_animal_hrs->farmerId ? $owned_animal_hrs->farmerId : ''}}" value="{{$owned_animal_hrs->owned_animal_hrs == 'null' ? '' : $owned_animal_hrs->owned_animal_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       23
                    </td>
                    <td>
                        Owned Animal Unit Price
                    </td>
                    
                    @foreach($data as $ownedAnimalUnitPrice)
                    <td>
                        <input type="text" name="owned_animal_unit_price_{{isset($ownedAnimalUnitPrice->id) && $ownedAnimalUnitPrice->id ? $ownedAnimalUnitPrice->id : ''}}_{{isset($ownedAnimalUnitPrice->farmerId) && $ownedAnimalUnitPrice->farmerId ? $ownedAnimalUnitPrice->farmerId : ''}}" value="{{$ownedAnimalUnitPrice->owned_animal_unit_price == 'null' ? '' : $ownedAnimalUnitPrice->owned_animal_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        24
                    </td>
                    <td>
                        Owned Animal Labour (Rs.)
                    </td>
                    
                    @foreach($data as $owned_animal_rs)
                    <td>
                        <input type="text" name="owned_animal_rs_{{isset($owned_animal_rs->id) && $owned_animal_rs->id ? $owned_animal_rs->id : ''}}_{{isset($owned_animal_rs->farmerId) && $owned_animal_rs->farmerId ? $owned_animal_rs->farmerId : ''}}" value="{{$owned_animal_rs->owned_animal_rs == 'null' ? '' : $owned_animal_rs->owned_animal_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       25
                    </td>
                    <td>
                        Owned Animal Remarks
                    </td>
                    
                    @foreach($data as $ownedAnimalRemarks)
                    <td>
                        <input type="text" name="owned_animal_remarks_{{isset($ownedAnimalRemarks->id) && $ownedAnimalRemarks->id ? $ownedAnimalRemarks->id : ''}}_{{isset($ownedAnimalRemarks->farmerId) && $ownedAnimalRemarks->farmerId ? $ownedAnimalRemarks->farmerId : ''}}" value="{{$ownedAnimalRemarks->owned_animal_remarks == 'null' ? '' : $ownedAnimalRemarks->owned_animal_remarks}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        26
                    </td>
                    <td>
                        Hired Machine Unit
                    </td>
                    
                    @foreach($data as $hired_machhine_unit)
                    <td>
                        <input type="text" name="hired_machhine_unit_{{isset($hired_machhine_unit->id) && $hired_machhine_unit->id ? $hired_machhine_unit->id : ''}}_{{isset($hired_machhine_unit->farmerId) && $hired_machhine_unit->farmerId ? $hired_machhine_unit->farmerId : ''}}"
                        value="{{$hired_machhine_unit->hired_machhine_unit == 'null' ? '' : $hired_machhine_unit->hired_machhine_unit}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        27
                    </td>
                    <td>
                        Hired Machine 
                    </td>
                    
                    @foreach($data as $hired_machhine_hrs)
                    <td>
                        <input type="text" name="hired_machhine_hrs_{{isset($hired_machhine_hrs->id) && $hired_machhine_hrs->id ? $hired_machhine_hrs->id : ''}}_{{isset($hired_machhine_hrs->farmerId) && $hired_machhine_hrs->farmerId ? $hired_machhine_hrs->farmerId : ''}}" value="{{$hired_machhine_hrs->hired_machhine_hrs == 'null' ? '' : $hired_machhine_hrs->hired_machhine_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        28
                    </td>
                    <td>
                        Hired Machhine Unit Price
                    </td>
                    
                    @foreach($data as $hiredMachhineUnitPrice)
                    <td>
                        <input type="text" name="hired_machhine_unit_price_{{isset($hiredMachhineUnitPrice->id) && $hiredMachhineUnitPrice->id ? $hiredMachhineUnitPrice->id : ''}}_{{isset($hiredMachhineUnitPrice->farmerId) && $hiredMachhineUnitPrice->farmerId ? $hiredMachhineUnitPrice->farmerId : ''}}" value="{{$hiredMachhineUnitPrice->hired_machhine_unit_price == 'null' ? '' : $hiredMachhineUnitPrice->hired_machhine_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        29
                    </td>
                    <td>
                        Hired Machine (Rs.)
                    </td>
                    
                    @foreach($data as $hired_machhine_rs)
                    <td>
                        <input type="text" name="hired_machhine_rs_{{isset($hired_machhine_rs->id) && $hired_machhine_rs->id ? $hired_machhine_rs->id : ''}}_{{isset($hired_machhine_rs->farmerId) && $hired_machhine_rs->farmerId ? $hired_machhine_rs->farmerId : ''}}" value="{{$hired_machhine_rs->hired_machhine_rs == 'null' ? '' : $hired_machhine_rs->hired_machhine_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        30
                    </td>
                    <td>
                        Hired Machine Remarks
                    </td>
                    
                    @foreach($data as $hiredMachhineRemarks)
                    <td>
                        <input type="text" name="hired_machhine_remarks_{{isset($hiredMachhineRemarks->id) && $hiredMachhineRemarks->id ? $hiredMachhineRemarks->id : ''}}_{{isset($hiredMachhineRemarks->farmerId) && $hiredMachhineRemarks->farmerId ? $hiredMachhineRemarks->farmerId : ''}}" value="{{$hiredMachhineRemarks->hired_machhine_remarks == 'null' ? '' : $hiredMachhineRemarks->hired_machhine_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        31
                    </td>
                    <td>
                        Own Machine Unit
                    </td>
                    
                    @foreach($data as $ownMachineUnit)
                    <td>
                        <input type="text" name="own_machine_unit_{{isset($ownMachineUnit->id) && $ownMachineUnit->id ? $ownMachineUnit->id : ''}}_{{isset($ownMachineUnit->farmerId) && $ownMachineUnit->farmerId ? $ownMachineUnit->farmerId : ''}}" value="{{$ownMachineUnit->own_machine_unit == 'null' ? '' : $ownMachineUnit->own_machine_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        32
                    </td>
                    <td>
                        Own Machine 
                    </td>
                    
                    @foreach($data as $own_machine_rs)
                    <td>
                        <input type="text" name="own_machine_rs_{{isset($own_machine_rs->id) && $own_machine_rs->id ? $own_machine_rs->id : ''}}_{{isset($own_machine_rs->farmerId) && $own_machine_rs->farmerId ? $own_machine_rs->farmerId : ''}}" value="{{$own_machine_rs->own_machine_rs == 'null' ? '' : $own_machine_rs->own_machine_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        33
                    </td>
                    <td>
                        Own Machine Unit Price
                    </td>
                    
                    @foreach($data as $ownMachineUnitPrice)
                    <td>
                        <input type="text" name="own_machine_unit_price_{{isset($ownMachineUnitPrice->id) && $ownMachineUnitPrice->id ? $ownMachineUnitPrice->id : ''}}_{{isset($ownMachineUnitPrice->farmerId) && $ownMachineUnitPrice->farmerId ? $ownMachineUnitPrice->farmerId : ''}}" value="{{$ownMachineUnitPrice->own_machine_unit_price == 'null' ? '' : $ownMachineUnitPrice->own_machine_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        34
                    </td>
                    <td>
                        Own Machine (Rs.)
                    </td>
                    
                    @foreach($data as $own_machine_rs)
                    <td>
                        <input type="text" name="own_machine_rs_{{isset($own_machine_rs->id) && $own_machine_rs->id ? $own_machine_rs->id : ''}}_{{isset($own_machine_rs->farmerId) && $own_machine_rs->farmerId ? $own_machine_rs->farmerId : ''}}" 
                        value="{{ $own_machine_rs->own_machine_rs == 'null' ? '' : $own_machine_rs->own_machine_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       35
                    </td>
                    <td>
                        Own Machine Remarks
                    </td>
                    
                    @foreach($data as $ownMachineRemarks)
                    <td>
                       <input type="text" name="own_machine_remarks_{{isset($ownMachineRemarks->id) && $ownMachineRemarks->id ? $ownMachineRemarks->id : ''}}_{{isset($ownMachineRemarks->farmerId) && $ownMachineRemarks->farmerId ? $ownMachineRemarks->farmerId : ''}}" value="{{ $ownMachineRemarks->own_machine_remarks == 'null' ? '' : $ownMachineRemarks->own_machine_remarks}}">
                    </td>
                    @endforeach
                </tr>
                
                
                <!--<tr>-->
                <!--    <td>-->
                <!--       36-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Irrigation Machine Unit-->
                <!--    </td>-->
                    
                <!--    @foreach($data as $hiredIrrigationMachineUnit)-->
                <!--    <td>-->
                <!--       <input type="text" name="hired_irrigation_machine_unit_{{isset($hiredIrrigationMachineUnit->id) && $hiredIrrigationMachineUnit->id ? $hiredIrrigationMachineUnit->id : ''}}" value="{{ $hiredIrrigationMachineUnit->hired_irrigation_machine_unit == 'null' ? '' : $hiredIrrigationMachineUnit->hired_irrigation_machine_unit}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        37-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Irrigation Machine -->
                <!--    </td>-->
                    
                <!--    @foreach($data as $hired_irrigation_machine_hrs)-->
                <!--    <td>-->
                <!--        <input type="text" name="hired_irrigation_machine_hrs_{{isset($hired_irrigation_machine_hrs->id) && $hired_irrigation_machine_hrs->id ? $hired_irrigation_machine_hrs->id : ''}}" value="{{ $hired_irrigation_machine_hrs->hired_irrigation_machine_hrs == 'null' ? '' : $hired_irrigation_machine_hrs->hired_irrigation_machine_hrs}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        38-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Irrigation Machine Unit Price-->
                <!--    </td>-->
                <!--    @foreach($data as $hired_irrigation_machine_unit_price)-->
                <!--    <td>-->
                <!--       <input type="text" name="hired_irrigation_machine_unit_price_{{isset($hired_irrigation_machine_unit_price->id) && $hired_irrigation_machine_unit_price->id ? $hired_irrigation_machine_unit_price->id : ''}}" value="{{ $hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price == 'null' ? '' : $hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        39-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Hired Irrigation Machine (Rs.)-->
                <!--    </td>-->
                    
                <!--    @foreach($data as $hired_irrigation_machine_rs)-->
                <!--    <td>-->
                <!--        <input type="text" name="hired_irrigation_machine_rs_{{isset($hired_irrigation_machine_rs->id) && $hired_irrigation_machine_rs->id ? $hired_irrigation_machine_rs->id : ''}}" value="{{ $hired_irrigation_machine_rs->hired_irrigation_machine_rs == 'null' ? '' : $hired_irrigation_machine_rs->hired_irrigation_machine_rs}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        40-->
                <!--    </td>-->
                <!--    <td>-->
                <!--   Hired Irrigation Machine Remarks-->
                <!--    </td>-->
                <!--    @foreach($data as $hired_irrigation_machine_remarks)-->
                <!--    <td>-->
                <!--       <input type="text" name="hired_irrigation_machine_remarks_{{isset($hired_irrigation_machine_remarks->id) && $hired_irrigation_machine_remarks->id ? $hired_irrigation_machine_remarks->id : ''}}" value="{{ $hired_irrigation_machine_remarks->hired_irrigation_machine_remarks == 'null' ? '' : $hired_irrigation_machine_remarks->hired_irrigation_machine_remarks}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                   
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--       41-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Owned Irrigation Machine Unit-->
                <!--    </td>-->
                    
                <!--    @foreach($data as $ownedIrrigationMachineUnit)-->
                <!--    <td>-->
                <!--       <input type="text" name="owned_irrigation_machine_unit_{{isset($ownedIrrigationMachineUnit->id) && $ownedIrrigationMachineUnit->id ? $ownedIrrigationMachineUnit->id : ''}}" -->
                <!--       value="{{ $ownedIrrigationMachineUnit->owned_irrigation_machine_unit == 'null' ? '' : $ownedIrrigationMachineUnit->owned_irrigation_machine_unit}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        42-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Owned Irrigation Machine -->
                <!--    </td>-->
                    
                <!--    @foreach($data as $owned_irrigation_machine_hrs)-->
                <!--    <td>-->
                <!--        <input type="text" name="owned_irrigation_machine_hrs_{{isset($owned_irrigation_machine_hrs->id) && $owned_irrigation_machine_hrs->id ? $owned_irrigation_machine_hrs->id : ''}}" -->
                <!--        value="{{ $owned_irrigation_machine_hrs->owned_irrigation_machine_hrs}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--       43-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Owned Irrigation Machine Unit Price-->
                <!--    </td>-->
                    
                <!--    @foreach($data as $ownedIrrigationMachineUnitPrice)-->
                <!--    <td>-->
                <!--       <input type="text" name="owned_irrigation_machine_unit_price_{{isset($ownedIrrigationMachineUnitPrice->id) && $ownedIrrigationMachineUnitPrice->id ? $ownedIrrigationMachineUnitPrice->id : ''}}" value="{{ $ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price == 'null' ? '' : $ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--        44-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Owned Irrigation Machine (Rs.)-->
                <!--    </td>-->
                    
                <!--    @foreach($data as $owned_irrigation_machine_rs)-->
                <!--    <td>-->
                <!--        <input type="text" name="owned_irrigation_machine_rs_{{isset($owned_irrigation_machine_rs->id) && $owned_irrigation_machine_rs->id ? $owned_irrigation_machine_rs->id : ''}}" value="{{ $owned_irrigation_machine_rs->owned_irrigation_machine_rs}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--       45-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Owned Irrigation Machine Remarks-->
                <!--    </td>-->
                    
                <!--    @foreach($data as $ownedIrrigationMachineRemarks)-->
                <!--    <td>-->
                <!--       <input type="text" name="owned_irrigation_machine_remarks_{{isset($ownedIrrigationMachineRemarks->id) && $ownedIrrigationMachineRemarks->id ? $ownedIrrigationMachineRemarks->id : ''}}" value="{{ $ownedIrrigationMachineRemarks->owned_irrigation_machine_remarks}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                <!--<tr>-->
                <!--    <td>-->
                <!--       46-->
                <!--    </td>-->
                <!--    <td>-->
                <!--        Source of Seed / Plantlets-->
                <!--    </td>-->
                    
                <!--    @foreach($data as $seedType)-->
                <!--    <td>-->
                <!--       <input type="text" name="seed_type_{{isset($seedType->id) && $seedType->id ? $seedType->id : ''}}" value="{{ $seedType->seed_type}}">-->
                <!--    </td>-->
                <!--    @endforeach-->
                <!--</tr>-->
                
                <tr>
                    <td>
                       36
                    </td>
                    <td>
                        Hired Irrigation Machine Unit
                    </td>
                    
                    @foreach($data as $hiredIrrigationMachineUnit)
                    <td>
                       <input type="text" name="hired_irrigation_machine_unit_{{isset($hiredIrrigationMachineUnit->id) && $hiredIrrigationMachineUnit->id ? $hiredIrrigationMachineUnit->id : ''}}_{{isset($hiredIrrigationMachineUnit->farmerId) && $hiredIrrigationMachineUnit->farmerId ? $hiredIrrigationMachineUnit->farmerId : ''}}" value="{{ $hiredIrrigationMachineUnit->hired_irrigation_machine_unit == 'null' ? '' : $hiredIrrigationMachineUnit->hired_irrigation_machine_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        37
                    </td>
                    <td>
                        Hired Irrigation Machine 
                    </td>
                    
                    @foreach($data as $hired_irrigation_machine_hrs)
                    <td>
                        <input type="text" name="hired_irrigation_machine_hrs_{{isset($hired_irrigation_machine_hrs->id) && $hired_irrigation_machine_hrs->id ? $hired_irrigation_machine_hrs->id : ''}}_{{isset($hired_irrigation_machine_hrs->farmerId) && $hired_irrigation_machine_hrs->farmerId ? $hired_irrigation_machine_hrs->farmerId : ''}}" value="{{ $hired_irrigation_machine_hrs->hired_irrigation_machine_hrs == 'null' ? '' : $hired_irrigation_machine_hrs->hired_irrigation_machine_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        38
                    </td>
                    <td>
                        Hired Irrigation Machine Unit Price
                    </td>
                    @foreach($data as $hired_irrigation_machine_unit_price)
                    <td>
                       <input type="text" name="hired_irrigation_machine_unit_price_{{isset($hired_irrigation_machine_unit_price->id) && $hired_irrigation_machine_unit_price->id ? $hired_irrigation_machine_unit_price->id : ''}}_{{isset($hired_irrigation_machine_unit_price->farmerId) && $hired_irrigation_machine_unit_price->farmerId ? $hired_irrigation_machine_unit_price->farmerId : ''}}" value="{{ $hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price == 'null' ? '' : $hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        39
                    </td>
                    <td>
                        Hired Irrigation Machine (Rs.)
                    </td>
                    
                    @foreach($data as $hired_irrigation_machine_rs)
                    <td>
                        <input type="text" name="hired_irrigation_machine_rs_{{isset($hired_irrigation_machine_rs->id) && $hired_irrigation_machine_rs->id ? $hired_irrigation_machine_rs->id : ''}}_{{isset($hired_irrigation_machine_rs->farmerId) && $hired_irrigation_machine_rs->farmerId ? $hired_irrigation_machine_rs->farmerId : ''}}" value="{{ $hired_irrigation_machine_rs->hired_irrigation_machine_rs == 'null' ? '' : $hired_irrigation_machine_rs->hired_irrigation_machine_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        40
                    </td>
                    <td>
                   Hired Irrigation Machine Remarks
                    </td>
                    @foreach($data as $hired_irrigation_machine_remarks)
                    <td>
                       <input type="text" name="hired_irrigation_machine_remarks_{{isset($hired_irrigation_machine_remarks->id) && $hired_irrigation_machine_remarks->id ? $hired_irrigation_machine_remarks->id : ''}}_{{isset($hired_irrigation_machine_remarks->farmerId) && $hired_irrigation_machine_remarks->farmerId ? $hired_irrigation_machine_remarks->farmerId : ''}}" value="{{ $hired_irrigation_machine_remarks->hired_irrigation_machine_remarks == 'null' ? '' : $hired_irrigation_machine_remarks->hired_irrigation_machine_remarks}}">
                    </td>
                    @endforeach
                   
                </tr>
                <tr>
                    <td>
                       41
                    </td>
                    <td>
                        Owned Irrigation Machine Unit
                    </td>
                    
                    @foreach($data as $ownedIrrigationMachineUnit)
                    <td>
                       <input type="text" name="owned_irrigation_machine_unit_{{isset($ownedIrrigationMachineUnit->id) && $ownedIrrigationMachineUnit->id ? $ownedIrrigationMachineUnit->id : ''}}_{{isset($ownedIrrigationMachineUnit->farmerId) && $ownedIrrigationMachineUnit->farmerId ? $ownedIrrigationMachineUnit->farmerId : ''}}" 
                       value="{{ $ownedIrrigationMachineUnit->owned_irrigation_machine_unit == 'null' ? '' : $ownedIrrigationMachineUnit->owned_irrigation_machine_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        42
                    </td>
                    <td>
                        Owned Irrigation Machine 
                    </td>
                    
                    @foreach($data as $owned_irrigation_machine_hrs)
                    <td>
                        <input type="text" name="owned_irrigation_machine_hrs_{{isset($owned_irrigation_machine_hrs->id) && $owned_irrigation_machine_hrs->id ? $owned_irrigation_machine_hrs->id : ''}}_{{isset($owned_irrigation_machine_hrs->farmerId) && $owned_irrigation_machine_hrs->farmerId ? $owned_irrigation_machine_hrs->farmerId : ''}}" 
                        value="{{ $owned_irrigation_machine_hrs->owned_irrigation_machine_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       43
                    </td>
                    <td>
                        Owned Irrigation Machine Unit Price
                    </td>
                    
                    @foreach($data as $ownedIrrigationMachineUnitPrice)
                    <td>
                       <input type="text"
                        name="owned_irrigation_machine_unit_price_{{isset($ownedIrrigationMachineUnitPrice->id) && $ownedIrrigationMachineUnitPrice->id ? $ownedIrrigationMachineUnitPrice->id : ''}}_{{isset($ownedIrrigationMachineUnitPrice->farmerId) && $ownedIrrigationMachineUnitPrice->farmerId ? $ownedIrrigationMachineUnitPrice->farmerId : ''}}" value="{{ $ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price == 'null' ? '' : $ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        44
                    </td>
                    <td>
                        Owned Irrigation Machine (Rs.)
                    </td>
                    
                    @foreach($data as $owned_irrigation_machine_rs)
                    <td>
                        <input type="text" name="owned_irrigation_machine_rs_{{isset($owned_irrigation_machine_rs->id) && $owned_irrigation_machine_rs->id ? $owned_irrigation_machine_rs->id : ''}}_{{isset($owned_irrigation_machine_rs->farmerId) && $owned_irrigation_machine_rs->farmerId ? $owned_irrigation_machine_rs->farmerId : ''}}" value="{{ $owned_irrigation_machine_rs->owned_irrigation_machine_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       45
                    </td>
                    <td>
                        Owned Irrigation Machine Remarks
                    </td>
                    
                    @foreach($data as $ownedIrrigationMachineRemarks)
                    <td>
                       <input type="text" name="owned_irrigation_machine_remarks_{{isset($ownedIrrigationMachineRemarks->id) && $ownedIrrigationMachineRemarks->id ? $ownedIrrigationMachineRemarks->id : ''}}_{{isset($ownedIrrigationMachineRemarks->farmerId) && $ownedIrrigationMachineRemarks->farmerId ? $ownedIrrigationMachineRemarks->farmerId : ''}}" value="{{ $ownedIrrigationMachineRemarks->owned_irrigation_machine_remarks}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       46
                    </td>
                    <td>
                        Source of Seed / Plantlets
                    </td>
                    
                    @foreach($data as $seedType)
                    <td>
                       <input type="text" name="seed_type_{{isset($seedType->id) && $seedType->id ? $seedType->id : ''}}_{{isset($seedType->farmerId) && $seedType->farmerId ? $seedType->farmerId : ''}}" value="{{ $seedType->seed_type}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>47</td>
                    <td>Seed Standard</td>
                    @foreach($data as $seed_standard)
                    <td>
                       <input type="text" name="$seed_standard_{{isset($seed_standard->id) && $seed_standard->id ? $seed_standard->id : ''}}_{{isset($seed_standard->farmerId) && $seed_standard->farmerId ? $seed_standard->farmerId : ''}}" value="{{ $seed_standard->seed_standard}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>48</td>
                    <td>Seed Standard Remark</td>
                    @foreach($data as $seed_standard_remark)
                    <td>
                       <input type="text" name="$seed_standard_remark_{{isset($seed_standard_remark->id) && $seed_standard_remark->id ? $seed_standard_remark->id : ''}}_{{isset($seed_standard_remark->farmerId) && $seed_standard_remark->farmerId ? $seed_standard_remark->farmerId : ''}}" value="{{ $seed_standard_remark->seed_standard_remark}}">
                    </td>
                    @endforeach
                </tr>
                
                
                <tr>
                    <td>
                       49
                    </td>
                    <td>
                        Seed Variety
                    </td>
                    
                    @foreach($data as $seedVariety)
                    <td>
                       <input type="text" name="seed_variety_{{isset($seedVariety->id) && $seedVariety->id ? $seedVariety->id : ''}}_{{isset($seedVariety->farmerId) && $seedVariety->farmerId ? $seedVariety->farmerId : ''}}" value="{{ $seedVariety->seed_variety}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       48
                    </td>
                    <td>
                        Seed Qty Unit
                    </td>
                    
                    @foreach($data as $seedQtyUnit)
                    <td>
                       <input type="text" name="seed_qty_unit_{{isset($seedQtyUnit->id) && $seedQtyUnit->id ? $seedQtyUnit->id : ''}}_{{isset($seedQtyUnit->farmerId) && $seedQtyUnit->farmerId ? $seedQtyUnit->farmerId : ''}}" value="{{ $seedQtyUnit->seed_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        49
                    </td>
                    <td>
                        Seed / Plantlets Quanity
                    </td>
                    
                    @foreach($data as $seed_qty)
                    <td>
                       <input type="text" name="seed_qty_{{isset($seed_qty->id) && $seed_qty->id ? $seed_qty->id : ''}}_{{isset($seed_qty->farmerId) && $seed_qty->farmerId ? $seed_qty->farmerId : ''}}" value="{{ $seed_qty->seed_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       50
                    </td>
                    <td>
                        Seed Unit Price
                    </td>
                    
                    @foreach($data as $seedUnitPrice)
                    <td>
                       <input type="text" name="seed_unit_price_{{isset($seedUnitPrice->id) && $seedUnitPrice->id ? $seedUnitPrice->id : ''}}_{{isset($seedUnitPrice->farmerId) && $seedUnitPrice->farmerId ? $seedUnitPrice->farmerId : ''}}" value="{{ $seedUnitPrice->seed_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        51
                    </td>
                    <td>
                        Seed Value (Rs.)
                    </td>
                    
                    @foreach($data as $seed_value_rs)
                    <td>
                       <input type="text" name="seed_value_rs_{{isset($seed_value_rs->id) && $seed_value_rs->id ? $seed_value_rs->id : ''}}_{{isset($seed_value_rs->farmerId) && $seed_value_rs->farmerId ? $seed_value_rs->farmerId : ''}}" value="{{ $seed_value_rs->seed_value_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        52
                    </td>
                    <td>
                        Seed Remarks
                    </td>
                    
                    @foreach($data as $seedRemarks)
                    <td>
                       <input type="text" name="seed_remarks_{{isset($seedRemarks->id) && $seedRemarks->id ? $seedRemarks->id : ''}}_{{isset($seedRemarks->farmerId) && $seedRemarks->farmerId ? $seedRemarks->farmerId : ''}}" value="{{ $seedRemarks->seed_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        53
                    </td>
                    <td>
                        Fertiliser (N) Qty Unit
                    </td>
                    
                    @foreach($data as $fertiliserNQtyUnit)
                    <td>
                       <input type="text" name="fertiliser_n_qty_unit_{{isset($fertiliserNQtyUnit->id) && $fertiliserNQtyUnit->id ? $fertiliserNQtyUnit->id : ''}}_{{isset($fertiliserNQtyUnit->farmerId) && $fertiliserNQtyUnit->farmerId ? $fertiliserNQtyUnit->farmerId : ''}}" value="{{ $fertiliserNQtyUnit->fertiliser_n_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        54
                    </td>
                    <td>
                        Fertiliser (N) Quantity
                    </td>
                    
                    @foreach($data as $fertiliser_n_qty)
                    <td>
                       <input type="text" name="fertiliser_n_qty_{{isset($fertiliser_n_qty->id) && $fertiliser_n_qty->id ? $fertiliser_n_qty->id : ''}}_{{isset($fertiliser_n_qty->farmerId) && $fertiliser_n_qty->farmerId ? $fertiliser_n_qty->farmerId : ''}}" value="{{ $fertiliser_n_qty->fertiliser_n_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        55
                    </td>
                    <td>
                        Fertiliser (N) Unit Price
                    </td>
                    @foreach($data as $fertiliserNUnitPrice)
                    <td>
                       <input type="text" name="fertiliser_n_unit_price_{{isset($fertiliserNUnitPrice->id) && $fertiliserNUnitPrice->id ? $fertiliserNUnitPrice->id : ''}}_{{isset($fertiliserNUnitPrice->farmerId) && $fertiliserNUnitPrice->farmerId ? $fertiliserNUnitPrice->farmerId : ''}}" value="{{ $fertiliserNUnitPrice->fertiliser_n_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        56
                    </td>
                    <td>
                    Fertiliser (N) (Rs.)
                    </td>
                    
                    @foreach($data as $fertiliser_n_rs)
                    <td>
                       <input type="text" name="fertiliser_n_rs_{{isset($fertiliser_n_rs->id) && $fertiliser_n_rs->id ? $fertiliser_n_rs->id : ''}}_{{isset($fertiliser_n_rs->farmerId) && $fertiliser_n_rs->farmerId ? $fertiliser_n_rs->farmerId : ''}}" value="{{ $fertiliser_n_rs->fertiliser_n_rs}}">
                    </td>
                    @endforeach
                </tr>
                
                
                
                <tr>
                    <td>
                       57
                    </td>
                    <td>
                        Fertiliser (N) Remarks
                    </td>
                    
                    @foreach($data as $fertiliserNRemarks)
                    <td>
                        <input type="text" name="fertiliser_n_remarks_{{isset($fertiliserNRemarks->id) && $fertiliserNRemarks->id ? $fertiliserNRemarks->id : ''}}_{{isset($fertiliserNRemarks->farmerId) && $fertiliserNRemarks->farmerId ? $fertiliserNRemarks->farmerId : ''}}" value="{{ $fertiliserNRemarks->fertiliser_n_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       58
                    </td>
                    <td>
                        Fertiliser (P) Qty Unit
                    </td>
                    
                    @foreach($data as $fertiliserPQtyUnit)
                    <td>
                       <input type="text" name="fertiliser_p_qty_unit_{{isset($fertiliserPQtyUnit->id) && $fertiliserPQtyUnit->id ? $fertiliserPQtyUnit->id : ''}}_{{isset($fertiliserPQtyUnit->farmerId) && $fertiliserPQtyUnit->farmerId ? $fertiliserPQtyUnit->farmerId : ''}}" value="{{ $fertiliserPQtyUnit->fertiliser_p_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        59
                    </td>
                    <td>
                        Fertiliser (P) Quanity
                    </td>
                    
                    @foreach($data as $fertiliser_p_qty)
                    <td>
                       <input type="text" name="fertiliser_p_qty_{{isset($fertiliser_p_qty->id) && $fertiliser_p_qty->id ? $fertiliser_p_qty->id : ''}}_{{isset($fertiliser_p_qty->farmerId) && $fertiliser_p_qty->farmerId ? $fertiliser_p_qty->farmerId : ''}}" value="{{ $fertiliser_p_qty->fertiliser_p_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       60
                    </td>
                    <td>
                        Fertiliser (P) Unit Price
                    </td>
                    
                    @foreach($data as $fertiliserPUnitPrice)
                    <td>
                       <input type="text" name="fertiliser_p_unit_price_{{isset($fertiliserPUnitPrice->id) && $fertiliserPUnitPrice->id ? $fertiliserPUnitPrice->id : ''}}_{{isset($fertiliserPUnitPrice->farmerId) && $fertiliserPUnitPrice->farmerId ? $fertiliserPUnitPrice->farmerId : ''}}" value="{{ $fertiliserPUnitPrice->fertiliser_p_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        61
                    </td>
                    <td>
                    Fertiliser (P) (Rs.)
                    </td>
                    
                    @foreach($data as $fertiliser_p_rs)
                    <td>
                       <input type="text" name="fertiliser_p_rs_{{isset($fertiliser_p_rs->id) && $fertiliser_p_rs->id ? $fertiliser_p_rs->id : ''}}_{{isset($fertiliser_p_rs->farmerId) && $fertiliser_p_rs->farmerId ? $fertiliser_p_rs->farmerId : ''}}" value="{{ $fertiliser_p_rs->fertiliser_p_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       62
                    </td>
                    <td>
                        Fertiliser (P) Remarks
                    </td>
                    
                    @foreach($data as $fertiliserPRemarks)
                    <td>
                       <input type="text" name="fertiliser_p_remarks_{{isset($fertiliserPRemarks->id) && $fertiliserPRemarks->id ? $fertiliserPRemarks->id : ''}}_{{isset($fertiliserPRemarks->farmerId) && $fertiliserPRemarks->farmerId ? $fertiliserPRemarks->farmerId : ''}}" value="{{ $fertiliserPRemarks->fertiliser_p_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       63
                    </td>
                    <td>
                        Fertiliser (K) Qty Unit
                    </td>
                    
                    @foreach($data as $fertiliserKQtyUnit)
                    <td>
                       <input type="text" name="fertiliser_k_qty_unit_{{isset($fertiliserKQtyUnit->id) && $fertiliserKQtyUnit->id ? $fertiliserKQtyUnit->id : ''}}_{{isset($fertiliserKQtyUnit->farmerId) && $fertiliserKQtyUnit->farmerId ? $fertiliserKQtyUnit->farmerId : ''}}" value="{{ $fertiliserKQtyUnit->fertiliser_k_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        64
                    </td>
                    <td>
                        Fertiliser (K) Quanity
                    </td>
                    
                    @foreach($data as $fertiliser_k_qty)
                    <td>
                       <input type="text" name="fertiliser_k_qty_{{isset($fertiliser_k_qty->id) && $fertiliser_k_qty->id ? $fertiliser_k_qty->id : ''}}_{{isset($fertiliser_k_qty->farmerId) && $fertiliser_k_qty->farmerId ? $fertiliser_k_qty->farmerId : ''}}" value="{{ $fertiliser_k_qty->fertiliser_k_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       65
                    </td>
                    <td>
                        Fertiliser (K) Unit Price
                    </td>
                    
                    @foreach($data as $fertiliserKUnitPrice)
                    <td>
                       <input type="text" name="fertiliser_k_unit_price_{{isset($fertiliserKUnitPrice->id) && $fertiliserKUnitPrice->id ? $fertiliserKUnitPrice->id : ''}}_{{isset($fertiliserKUnitPrice->farmerId) && $fertiliserKUnitPrice->farmerId ? $fertiliserKUnitPrice->farmerId : ''}}" value="{{ $fertiliserKUnitPrice->fertiliser_k_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        66
                    </td>
                    <td>
                    Fertiliser (K) (Rs.)
                    </td>
                    
                    @foreach($data as $fertiliser_k_rs)
                    <td>
                       <input type="text" name="fertiliser_k_rs_{{isset($fertiliser_k_rs->id) && $fertiliser_k_rs->id ? $fertiliser_k_rs->id : ''}}_{{isset($fertiliser_k_rs->farmerId) && $fertiliser_k_rs->farmerId ? $fertiliser_k_rs->farmerId : ''}}" value="{{ $fertiliser_k_rs->fertiliser_k_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       67
                    </td>
                    <td>
                        Fertiliser (K) Remarks
                    </td>
                    
                    @foreach($data as $fertiliserKRemarks)
                    <td>
                       <input type="text" name="fertiliser_k_remarks_{{isset($fertiliserKRemarks->id) && $fertiliserKRemarks->id ? $fertiliserKRemarks->id : ''}}_{{isset($fertiliserKRemarks->farmerId) && $fertiliserKRemarks->farmerId ? $fertiliserKRemarks->farmerId : ''}}" value="{{ $fertiliserKRemarks->fertiliser_k_remarks}}">
                    </td>
                    @endforeach
                </tr>
                
                <!--other Fertiliser Unit-->
                
                @forelse($otherferArr as $t=>$val)
                
                
                <tr>
                    <td>67</td>
                    <td>Other Fertiliser Name</td>
                    
                    @foreach($data as $other_fertiliser_name)
                    <td>
                        @php
                            $decoded = $other_fertiliser_name->other_fertiliser_name !== null ? json_decode($other_fertiliser_name->other_fertiliser_name, true) : [];
                        @endphp
                       <input type="text" name="other_fertiliser_name_{{isset($other_fertiliser_name->id) && $other_fertiliser_name->id ? $other_fertiliser_name->id : ''}}_{{isset($other_fertiliser_name->farmerId) && $other_fertiliser_name->farmerId ? $other_fertiliser_name->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                
                
                <tr>
                    <td>
                       68
                    </td>
                    <td>
                        Other Fertiliser Qty Unit
                    </td>
                    
                    @foreach($data as $otherFertiliserQtyUnit)
                    <td>
                        @php
                        $decoded = $otherFertiliserQtyUnit->other_fertiliser_qty_unit !== null ? json_decode($otherFertiliserQtyUnit->other_fertiliser_qty_unit, true) : [];
                        @endphp
                       <input type="text" name="other_fertiliser_qty_unit_{{isset($otherFertiliserQtyUnit->id) && $otherFertiliserQtyUnit->id ? $otherFertiliserQtyUnit->id : ''}}_{{isset($otherFertiliserQtyUnit->farmerId) && $otherFertiliserQtyUnit->farmerId ? $otherFertiliserQtyUnit->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        69
                    </td>
                    <td>
                        Other Fertiliser Qty
                    </td>
                    
                    @foreach($data as $other_fertiliser_qty)
                    <td>
                        @php
                         $decoded = $other_fertiliser_qty->other_fertiliser_qty !== null ? json_decode($other_fertiliser_qty->other_fertiliser_qty, true) : [];
                        @endphp
                       <input type="text" name="other_fertiliser_qty_{{isset($other_fertiliser_qty->id) && $other_fertiliser_qty->id ? $other_fertiliser_qty->id : ''}}_{{isset($other_fertiliser_qty->farmerId) && $other_fertiliser_qty->farmerId ? $other_fertiliser_qty->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       70
                    </td>
                    <td>
                        Other Fertiliser Unit Price
                    </td>
                    
                    @foreach($data as $otherFertiliserUnitPrice)
                    <td>
                        @php
                            $decoded = $otherFertiliserUnitPrice->other_fertiliser_unit_price !== null ? json_decode($otherFertiliserUnitPrice->other_fertiliser_unit_price, true) : [];
                        @endphp
                
                       <input type="text" name="other_fertiliser_unit_price_{{isset($otherFertiliserUnitPrice->id) && $otherFertiliserUnitPrice->id ? $otherFertiliserUnitPrice->id : ''}}_{{isset($otherFertiliserUnitPrice->farmerId) && $otherFertiliserUnitPrice->farmerId ? $otherFertiliserUnitPrice->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        71
                    </td>
                    <td>
                    Other Fertiliser (Rs.)
                    </td>
                    
                    @foreach($data as $other_fertiliser_rs)
                    <td>
                         @php
                            $decoded = $other_fertiliser_rs->other_fertiliser_rs !== null ? json_decode($other_fertiliser_rs->other_fertiliser_rs, true) : [];
                        @endphp
                       
                       <input type="text" name="other_fertiliser_rs_{{isset($other_fertiliser_rs->id) && $other_fertiliser_rs->id ? $other_fertiliser_rs->id : ''}}_{{isset($other_fertiliser_rs->farmerId) && $other_fertiliser_rs->farmerId ? $other_fertiliser_rs->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       72
                    </td>
                    <td>
                        Other Fertiliser Remarks
                    </td>
                    
                    @foreach($data as $otherFertiliserRemarks)
                    <td>
                        @php
                            $decoded = $otherFertiliserRemarks->other_fertiliser_remarks !== null 
                                ? json_decode($otherFertiliserRemarks->other_fertiliser_remarks, true) 
                                : [];
                        @endphp
                       <input type="text" name="other_fertiliser_remarks_{{isset($otherFertiliserRemarks->id) && $otherFertiliserRemarks->id ? $otherFertiliserRemarks->id : ''}}_{{isset($otherFertiliserRemarks->farmerId) && $otherFertiliserRemarks->farmerId ? $otherFertiliserRemarks->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
             @empty
             
             <tr>
                 
                <tr>
                    <td>67</td>
                    <td>Other Fertiliser Name</td>
                    
                    @foreach($data as $other_fertiliser_name)
                    <td>
                        @php
                            $decoded = $other_fertiliser_name->other_fertiliser_name !== null ? json_decode($other_fertiliser_name->other_fertiliser_name, true) : [];
                        @endphp
                       <input type="text" name="other_fertiliser_name_{{isset($other_fertiliser_name->id) && $other_fertiliser_name->id ? $other_fertiliser_name->id : ''}}_{{isset($other_fertiliser_name->farmerId) && $other_fertiliser_name->farmerId ? $other_fertiliser_name->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                 
                 
                    <td>
                       68
                    </td>
                    <td>
                        Other Fertiliser Qty Unit
                    </td>
                    
                    @foreach($data as $otherFertiliserQtyUnit)
                    <td>
                        @php
                        $decoded = $otherFertiliserQtyUnit->other_fertiliser_qty_unit !== null ? json_decode($otherFertiliserQtyUnit->other_fertiliser_qty_unit, true) : [];
                        @endphp
                       <input type="text" name="other_fertiliser_qty_unit_{{isset($otherFertiliserQtyUnit->id) && $otherFertiliserQtyUnit->id ? $otherFertiliserQtyUnit->id : ''}}_{{isset($otherFertiliserQtyUnit->farmerId) && $otherFertiliserQtyUnit->farmerId ? $otherFertiliserQtyUnit->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        69
                    </td>
                    <td>
                        Other Fertiliser Qty
                    </td>
                    
                    @foreach($data as $other_fertiliser_qty)
                    <td>
                        @php
                         $decoded = $other_fertiliser_qty->other_fertiliser_qty !== null ? json_decode($other_fertiliser_qty->other_fertiliser_qty, true) : [];
                        @endphp
                       <input type="text" name="other_fertiliser_qty_{{isset($other_fertiliser_qty->id) && $other_fertiliser_qty->id ? $other_fertiliser_qty->id : ''}}_{{isset($other_fertiliser_qty->farmerId) && $other_fertiliser_qty->farmerId ? $other_fertiliser_qty->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       70
                    </td>
                    <td>
                        Other Fertiliser Unit Price
                    </td>
                    
                    @foreach($data as $otherFertiliserUnitPrice)
                    <td>
                        @php
                            $decoded = $otherFertiliserUnitPrice->other_fertiliser_unit_price !== null ? json_decode($otherFertiliserUnitPrice->other_fertiliser_unit_price, true) : [];
                        @endphp
                
                       <input type="text" name="other_fertiliser_unit_price_{{isset($otherFertiliserUnitPrice->id) && $otherFertiliserUnitPrice->id ? $otherFertiliserUnitPrice->id : ''}}_{{isset($otherFertiliserUnitPrice->farmerId) && $otherFertiliserUnitPrice->farmerId ? $otherFertiliserUnitPrice->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        71
                    </td>
                    <td>
                    Other Fertiliser (Rs.)
                    </td>
                    
                    @foreach($data as $other_fertiliser_rs)
                    <td>
                         @php
                            $decoded = $other_fertiliser_rs->other_fertiliser_rs !== null ? json_decode($other_fertiliser_rs->other_fertiliser_rs, true) : [];
                        @endphp
                       
                       <input type="text" name="other_fertiliser_rs_{{isset($other_fertiliser_rs->id) && $other_fertiliser_rs->id ? $other_fertiliser_rs->id : ''}}_{{isset($other_fertiliser_rs->farmerId) && $other_fertiliser_rs->farmerId ? $other_fertiliser_rs->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       72
                    </td>
                    <td>
                        Other Fertiliser Remarks
                    </td>
                    
                    @foreach($data as $otherFertiliserRemarks)
                    <td>
                        @php
                            $decoded = $otherFertiliserRemarks->other_fertiliser_remarks !== null 
                                ? json_decode($otherFertiliserRemarks->other_fertiliser_remarks, true) 
                                : [];
                        @endphp
                       <input type="text" name="other_fertiliser_remarks_{{isset($otherFertiliserRemarks->id) && $otherFertiliserRemarks->id ? $otherFertiliserRemarks->id : ''}}_{{isset($otherFertiliserRemarks->farmerId) && $otherFertiliserRemarks->farmerId ? $otherFertiliserRemarks->farmerId : ''}}" value="{{$decoded[$t] ?? null}}">
                    </td>
                    @endforeach
                </tr>
             
             @endforelse
                <!--other Fertiliser Unit-->
                
                <tr>
                    <td>
                       73
                    </td>
                    <td>
                        DAP Qty Unit
                    </td>
                    
                    @foreach($data as $dapQtyUnit)
                    <td>
                       <input type="text" name="dap_qty_unit_{{isset($dapQtyUnit->id) && $dapQtyUnit->id ? $dapQtyUnit->id : ''}}_{{isset($dapQtyUnit->farmerId) && $dapQtyUnit->farmerId ? $dapQtyUnit->farmerId : ''}}" value="{{ $dapQtyUnit->dap_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       74
                    </td>
                    <td>
                        DAP Qty
                    </td>
                    
                    @foreach($data as $dapQty)
                    <td>
                       <input type="text" name="dap_qty_{{isset($dapQty->id) && $dapQty->id ? $dapQty->id : ''}}_{{isset($dapQty->farmerId) && $dapQty->farmerId ? $dapQty->farmerId : ''}}" value="{{ $dapQty->dap_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       75
                    </td>
                    <td>
                        DAP Unit Price
                    </td>
                    
                    @foreach($data as $dapUnitPrice)
                    <td>
                      
                       <input type="text" name="dap_unit_price_{{isset($dapUnitPrice->id) && $dapUnitPrice->id ? $dapUnitPrice->id : ''}}_{{isset($dapUnitPrice->farmerId) && $dapUnitPrice->farmerId ? $dapUnitPrice->farmerId : ''}}" value="{{ $dapUnitPrice->dap_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                 <tr>
                    <td>
                        76
                    </td>
                    <td>
                        DAP (Rs)
                    </td>
                    
                    @foreach($data as $dap_rs)
                    <td>
                       <input type="text" name="dap_rs_{{isset($dap_rs->id) && $dap_rs->id ? $dap_rs->id : ''}}_{{isset($dap_rs->farmerId) && $dap_rs->farmerId ? $dap_rs->farmerId : ''}}" value="{{ $dap_rs->dap_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       77
                    </td>
                    <td>
                        DAP Remarks
                    </td>
                    
                    @foreach($data as $dapRemarks)
                    <td>
                       <input type="text" name="dap_remarks_{{isset($dapRemarks->id) && $dapRemarks->id ? $dapRemarks->id : ''}}_{{isset($dapRemarks->farmerId) && $dapRemarks->farmerId ? $dapRemarks->farmerId : ''}}" value="{{ $dapRemarks->dap_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       78
                    </td>
                    <td>
                        NPK Qty Unit
                    </td>
                    
                    @foreach($data as $npkQtyUnit)
                    <td>
                        <input type="text" name="npk_qty_unit_{{isset($npkQtyUnit->id) && $npkQtyUnit->id ? $npkQtyUnit->id : ''}}_{{isset($npkQtyUnit->farmerId) && $npkQtyUnit->farmerId ? $npkQtyUnit->farmerId : ''}}" value="{{ $npkQtyUnit->npk_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                
                
                <tr>
                    <td>
                       79
                    </td>
                    <td>
                        NPK Qty
                    </td>
                    
                    @foreach($data as $npkQty)
                    <td>
                       <input type="text" name="npk_qty_{{isset($npkQty->id) && $npkQty->id ? $npkQty->id : ''}}_{{isset($npkQty->farmerId) && $npkQty->farmerId ? $npkQty->farmerId : ''}}" value="{{ $npkQty->npk_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        80
                    </td>
                    <td>
                        NPK Unit Price
                    </td>
                    
                    @foreach($data as $npkUnitPrice)
                    <td>
                       <input type="text" name="npk_unit_price_{{isset($npkUnitPrice->id) && $npkUnitPrice->id ? $npkUnitPrice->id : ''}}_{{isset($npkUnitPrice->farmerId) && $npkUnitPrice->farmerId ? $npkUnitPrice->farmerId : ''}}" value="{{ $npkUnitPrice->npk_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        81
                    </td>
                    <td>
                        NPK (Rs.)
                    </td>
                    
                    @foreach($data as $npk_rs)
                    <td>
                       <input type="text" name="npk_rs_{{isset($npk_rs->id) && $npk_rs->id ? $npk_rs->id : ''}}_{{isset($npk_rs->farmerId) && $npk_rs->farmerId ? $npk_rs->farmerId : ''}}" value="{{ $npk_rs->npk_rs}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       82
                    </td>
                    <td>
                        NPK Remarks
                    </td>
                    
                    @foreach($data as $npkRemarks)
                    <td>
                        <input type="text" name="npk_remarks_{{isset($npkRemarks->id) && $npkRemarks->id ? $npkRemarks->id : ''}}_{{isset($npkRemarks->farmerId) && $npkRemarks->farmerId ? $npkRemarks->farmerId : ''}}" value="{{ $npkRemarks->npk_remarks}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       83
                    </td>
                    <td>
                        Manure Qty Unit
                    </td>
                    @foreach($data as $manureQtyUnit)
                    <td>
                       <input type="text" name="manure_qty_unit_{{isset($manureQtyUnit->id) && $manureQtyUnit->id ? $manureQtyUnit->id : ''}}_{{isset($manureQtyUnit->farmerId) && $manureQtyUnit->farmerId ? $manureQtyUnit->farmerId : ''}}" value="{{ $manureQtyUnit->manure_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       84
                    </td>
                    <td>
                        Manure Qty
                    </td>
                    
                    @foreach($data as $manureQty)
                    <td>
                       <input type="text" name="manure_qty_{{isset($manureQty->id) && $manureQty->id ? $manureQty->id : ''}}_{{isset($manureQty->farmerId) && $manureQty->farmerId ? $manureQty->farmerId : ''}}" value="{{ $manureQty->manure_qty}}">
                    </td>
                    @endforeach
                </tr>
                
              
                
                
                <tr>
                    <td>
                        85
                    </td>
                    <td>
                        Manure Unit Price
                    </td>
                    
                    @foreach($data as $manureUnitPrice)
                    <td>
                        <input type="text" 
                        name="manure_unit_price_{{isset($manureUnitPrice->id) && $manureUnitPrice->id ? $manureUnitPrice->id : ''}}_{{isset($manureUnitPrice->farmerId) && $manureUnitPrice->farmerId ? $manureUnitPrice->farmerId : ''}}" value="{{ $manureUnitPrice->manure_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        86
                    </td>
                    <td>
                        Manure (Rs.) FYM
                    </td>
                    
                    @foreach($data as $manure_rs)
                    <td>
                        <input type="text" name="manure_rs_{{isset($manure_rs->id) && $manure_rs->id ? $manure_rs->id : ''}}_{{isset($manure_rs->farmerId) && $manure_rs->farmerId ? $manure_rs->farmerId : ''}}" value="{{ $manure_rs->manure_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       87
                    </td>
                    <td>
                        Manure Remarks
                    </td>
                    
                    @foreach($data as $manureRemarks)
                    <td>
                        <input type="text" name="manure_remarks_{{isset($manureRemarks->id) && $manureRemarks->id ? $manureRemarks->id : ''}}_{{isset($manureRemarks->farmerId) && $manureRemarks->farmerId ? $manureRemarks->farmerId : ''}}" value="{{ $manureRemarks->manure_remarks}}">
                    </td>
                    @endforeach
                </tr>
                
                <!--Insecticide-->  
                
               @forelse($unitArr as $k=>$val) 
                <tr>
                    <td>
                       88
                    </td>
                    <td>
                        Insecticide Unit
                    </td>
                    @foreach($data as $insecticideUnit)
                    <td>
                        @php
                          $decoded = $insecticideUnit->insecticide_unit !== null ? json_decode($insecticideUnit->insecticide_unit, true) : [];
                        @endphp
                        <input type="text" name="insecticide_unit_{{isset($insecticideUnit->id) && $insecticideUnit->id ? $insecticideUnit->id : ''}}_{{isset($insecticideUnit->farmerId) && $insecticideUnit->farmerId ? $insecticideUnit->farmerId : ''}}" value="{{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       89
                    </td>
                    <td>
                        Plant Protection Name
                    </td>
                    @foreach($data as $insticideName)
                    <td>
                        @php
                            $decoded = $insticideName->insticide_name !== null ? json_decode($insticideName->insticide_name, true) : [];
                        @endphp
                       <input type="text" name="insticide_name_{{isset($insticideName->id) && $insticideName->id ? $insticideName->id : ''}}_{{isset($insticideName->farmerId) && $insticideName->farmerId ? $insticideName->farmerId : ''}}" value="{{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                
                
                <tr>
                    <td>
                        90
                    </td>
                    <td>
                        Plant Protection Qty
                    </td>
                    @foreach($data as $insecticideQty)
                    <td>
                        @php
                            $decoded = $insecticideQty->insecticide_qty !== null ? json_decode($insecticideQty->insecticide_qty, true) : [];
                        @endphp
                       <input type="text" name="insecticide_qty_{{isset($insecticideQty->id) && $insecticideQty->id ? $insecticideQty->id : ''}}_{{isset($insecticideQty->farmerId) && $insecticideQty->farmerId ? $insecticideQty->farmerId : ''}}" value=" {{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
        
                <tr>
                    <td>
                       91
                    </td>
                    <td>
                        Plant Protection Unit Price
                    </td>
                    
                    @foreach($data as $insecticideUnitPrice)
                    <td>
                        @php
                            $decoded = $insecticideUnitPrice->insecticide_unit_price !== null ? json_decode($insecticideUnitPrice->insecticide_unit_price, true) : [];
                        @endphp
                       <input type="text" name="insecticide_unit_price_{{isset($insecticideUnitPrice->id) && $insecticideUnitPrice->id ? $insecticideUnitPrice->id : ''}}_{isset($insecticideUnitPrice->farmerId) && $insecticideUnitPrice->farmerId ? $insecticideUnitPrice->farmerId : ''}}" value=" {{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        92
                    </td>
                    <td>
                        Plant Protection (Rs.)
                    </td>
                    
                    @foreach($data as $insecticide_rs)
                    <td>
                        @php
                            $decoded = $insecticide_rs->insecticide_rs !== null ? json_decode($insecticide_rs->insecticide_rs, true) : [];
                        @endphp
                       <input type="text" name="insecticide_rs_{{isset($insecticide_rs->id) && $insecticide_rs->id ? $insecticide_rs->id : ''}}_{{isset($insecticide_rs->farmerId) && $insecticide_rs->farmerId ? $insecticide_rs->farmerId : ''}}" value="{{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        93
                    </td>
                    <td>
                        Plant Protection Remarks
                    </td>
                    
                    @foreach($data as $insecticideRemarks)
                    <td>
                        @php
                            $decoded = $insecticideRemarks->insecticide_remarks !== null ? json_decode($insecticideRemarks->insecticide_remarks, true) : [];
                        @endphp
                        <input type="text" name="insecticide_remarks_{{isset($insecticideRemarks->id) && $insecticideRemarks->id ? $insecticideRemarks->id : ''}}_{{isset($insecticideRemarks->farmerId) && $insecticideRemarks->farmerId ? $insecticideRemarks->farmerId : ''}}" value="{{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                
                @empty
                
                <tr>
                    <td>
                       88
                    </td>
                    <td>
                        Insecticide Unit
                    </td>
                    @foreach($data as $insecticideUnit)
                    <td>
                        @php
                          $decoded = $insecticideUnit->insecticide_unit !== null ? json_decode($insecticideUnit->insecticide_unit, true) : [];
                        @endphp
                        <input type="text" name="insecticide_unit_{{isset($insecticideUnit->id) && $insecticideUnit->id ? $insecticideUnit->id : ''}}_{{isset($insecticideUnit->farmerId) && $insecticideUnit->farmerId ? $insecticideUnit->farmerId : ''}}" value="{{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       89
                    </td>
                    <td>
                        Plant Protection Name
                    </td>
                    @foreach($data as $insticideName)
                    <td>
                        @php
                            $decoded = $insticideName->insticide_name !== null ? json_decode($insticideName->insticide_name, true) : [];
                        @endphp
                       <input type="text" name="insticide_name_{{isset($insticideName->id) && $insticideName->id ? $insticideName->id : ''}}_{{isset($insticideName->farmerId) && $insticideName->farmerId ? $insticideName->farmerId : ''}}" value="{{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                
                
                <tr>
                    <td>
                        90
                    </td>
                    <td>
                        Plant Protection Qty
                    </td>
                    @foreach($data as $insecticideQty)
                    <td>
                        @php
                            $decoded = $insecticideQty->insecticide_qty !== null ? json_decode($insecticideQty->insecticide_qty, true) : [];
                        @endphp
                       <input type="text" name="insecticide_qty_{{isset($insecticideQty->id) && $insecticideQty->id ? $insecticideQty->id : ''}}_{{isset($insecticideQty->farmerId) && $insecticideQty->farmerId ? $insecticideQty->farmerId : ''}}" value=" {{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
        
                <tr>
                    <td>
                       91
                    </td>
                    <td>
                        Plant Protection Unit Price
                    </td>
                    
                    @foreach($data as $insecticideUnitPrice)
                    <td>
                        @php
                            $decoded = $insecticideUnitPrice->insecticide_unit_price !== null ? json_decode($insecticideUnitPrice->insecticide_unit_price, true) : [];
                        @endphp
                       <input type="text" name="insecticide_unit_price_{{isset($insecticideUnitPrice->id) && $insecticideUnitPrice->id ? $insecticideUnitPrice->id : ''}}_{isset($insecticideUnitPrice->farmerId) && $insecticideUnitPrice->farmerId ? $insecticideUnitPrice->farmerId : ''}}" value=" {{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        92
                    </td>
                    <td>
                        Plant Protection (Rs.)
                    </td>
                    
                    @foreach($data as $insecticide_rs)
                    <td>
                        @php
                            $decoded = $insecticide_rs->insecticide_rs !== null ? json_decode($insecticide_rs->insecticide_rs, true) : [];
                        @endphp
                       <input type="text" name="insecticide_rs_{{isset($insecticide_rs->id) && $insecticide_rs->id ? $insecticide_rs->id : ''}}_{{isset($insecticide_rs->farmerId) && $insecticide_rs->farmerId ? $insecticide_rs->farmerId : ''}}" value="{{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        93
                    </td>
                    <td>
                        Plant Protection Remarks
                    </td>
                    
                    @foreach($data as $insecticideRemarks)
                    <td>
                        @php
                            $decoded = $insecticideRemarks->insecticide_remarks !== null ? json_decode($insecticideRemarks->insecticide_remarks, true) : [];
                        @endphp
                        <input type="text" name="insecticide_remarks_{{isset($insecticideRemarks->id) && $insecticideRemarks->id ? $insecticideRemarks->id : ''}}_{{isset($insecticideRemarks->farmerId) && $insecticideRemarks->farmerId ? $insecticideRemarks->farmerId : ''}}" value="{{$decoded[$k] ?? null}}">
                    </td>
                    @endforeach
                </tr>
                
                @endforelse
                
                <!--Insecticide-->
                
               <tr>
                    <td>
                       94
                    </td>
                    <td>
                        Canal / other Irrigation Charges (Rs)
                    </td>
                    
                    @foreach($data as $canalOtherCharges)
                    <td>
                        <input type="text" name="canal_other_charges_{{isset($canalOtherCharges->id) && $canalOtherCharges->id ? $canalOtherCharges->id : ''}}_{{isset($canalOtherCharges->farmerId) && $canalOtherCharges->farmerId ? $canalOtherCharges->farmerId : ''}}" value="{{ $canalOtherCharges->canal_other_charges}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        95
                    </td>
                    <td>
                    Crop Insurance (Rs.)
                    </td>
                    
                    @foreach($data as $crop_insurance_rs)
                    <td>
                        <input type="text" name="crop_insurance_rs_{{isset($crop_insurance_rs->id) && $crop_insurance_rs->id ? $crop_insurance_rs->id : ''}}_{{isset($crop_insurance_rs->farmerId) && $crop_insurance_rs->farmerId ? $crop_insurance_rs->farmerId : ''}}" value="{{ $crop_insurance_rs->crop_insurance_rs}}">
                    </td>
                    @endforeach
                </tr>
                
                 <tr>
                    <td>
                        96
                    </td>
                    <td>
                    Miscelaneous Cost (Rs.)
                    </td>
                    
                    @foreach($data as $miscelaneous_cost_rs)
                    <td>
                        <input type="text" name="miscelaneous_cost_rs_{{isset($miscelaneous_cost_rs->id) && $miscelaneous_cost_rs->id ? $miscelaneous_cost_rs->id : ''}}_{isset($miscelaneous_cost_rs->farmerId) && $miscelaneous_cost_rs->farmerId ? $miscelaneous_cost_rs->farmerId : ''}}" value="{{ $miscelaneous_cost_rs->miscelaneous_cost_rs}}">
                    </td>
                    @endforeach
                </tr>
                 <tr>
                    <td>
                        97
                    </td>
                    <td>
                        Land Revenue (Rs.) LAGAN
                    </td>
                    
                    @foreach($data as $land_revenue_rs)
                    <td>
                        <input type="text" name="land_revenue_rs_{{isset($land_revenue_rs->id) && $land_revenue_rs->id ? $land_revenue_rs->id : ''}}_{{isset($land_revenue_rs->farmerId) && $land_revenue_rs->farmerId ? $land_revenue_rs->farmerId : ''}}" value="{{ $land_revenue_rs->land_revenue_rs}}">
                    </td>
                    @endforeach
                </tr>
                 <tr>
                    <td>
                        98
                    </td>
                    <td>
                        Rent Paid for Leased in Land (Rs.)
                    </td>
                    
                    @foreach($data as $rent_paid_leased_land)
                    <td>
                       <input type="text" name="rent_paid_leased_land_{{isset($rent_paid_leased_land->id) && $rent_paid_leased_land->id ? $rent_paid_leased_land->id : ''}}_{{isset($rent_paid_leased_land->farmerId) && $rent_paid_leased_land->farmerId ? $rent_paid_leased_land->farmerId : ''}}" value="{{ $rent_paid_leased_land->rent_paid_leased_land}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        99
                    </td>
                    <td>
                        Interest on working capital rate(%) KCC
                    </td>
                    
                    @foreach($data as $interest_kcc)
                    <td>
                        <input type="text" name="interest_kcc_{{isset($interest_kcc->id) && $interest_kcc->id ? $interest_kcc->id : ''}}_{{isset($interest_kcc->farmerId) && $interest_kcc->farmerId ? $interest_kcc->farmerId : ''}}" value="{{ $interest_kcc->interest_kcc}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        100
                    </td>
                    <td>
                        Depericiation of Farm Assets
                    </td>
                    
                    @foreach($data as $depericiation_farm_assets)
                    <td>
                       <input type="text" name="depericiation_farm_assets_{{isset($depericiation_farm_assets->id) && $depericiation_farm_assets->id ? $depericiation_farm_assets->id : ''}}_{{isset($depericiation_farm_assets->farmerId) && $depericiation_farm_assets->farmerId ? $depericiation_farm_assets->farmerId : ''}}" value="{{ $depericiation_farm_assets->depericiation_farm_assets}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
    <td>
        101
    </td>
    <td>
        Interest on Capital Assests
    </td>
    
    
    @foreach($data as $int_cap)
            <td>
                <input type="text" name="int_cap" value="" />
            </td>
    @endforeach
            
</tr>
                
        <!--<tr>-->
        <!--    <td>102</td>-->
        <!--    <td>Marketing Cost of Producers</td>-->
        <!--    <td></td>-->
        <!--</tr>-->
        
        <tr>
            <td>102</td>
            <td>Other Fixed Cost</td>
            @foreach($data as $other_fix_cost)
            <td>
             <input type="text" name="other_fix_cost_{{isset($other_fix_cost->id) && $other_fix_cost->id ? $other_fix_cost->id : ''}}_{{$other_fix_cost->farmerId ?? ''}}" value="{{$other_fix_cost->other_fix_cost == 'null' ? '' : $other_fix_cost->other_fix_cost}}">
            </td>
            @endforeach
        </tr>
        
        
        
                
                <tr>
                    <td>
                       W
                    </td>
                    <th colspan="50">
                         Farm Output
                    </td>
                </tr>
                
                <tr>
                    <td>
                       1
                    </td>
                    <td>
                        Total Production Unit
                    </td>
                    
                    @foreach($data as $totalProductionUnit)
                    <td>
                       
                       <input type="text" disabled
                       name="total_production_{{isset($totalProductionUnit->id) && $totalProductionUnit->id ? $totalProductionUnit->id : ''}}_{{$totalProductionUnit->farmerId ?? ''}}" value="{{$totalProductionUnit->total_production_unit == 'null' ? '' : $totalProductionUnit->total_production_unit}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       2
                    </td>
                    <td>
                       Total Production Qty
                    </td>
                    
                    @foreach($data as $total_production)
                    <td>
                        <input type="text" name="total_production_{{isset($total_production->id) && $total_production->id ? $total_production->id : ''}}_{{$total_production->farmerId ?? ''}}" value="{{$total_production->total_production == 'null' ? '' : $total_production->total_production}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       3
                    </td>
                    <td>
                        Sold Main Product Unit
                    </td>
                    
                    @foreach($data as $soldMainProductUnit)
                    <td>
                       <input type="text" name="soldMainProductUnit_{{isset($soldMainProductUnit->id) && $soldMainProductUnit->id ? $soldMainProductUnit->id : ''}}_{{$soldMainProductUnit->farmerId ?? ''}}" value="{{$soldMainProductUnit->sold_main_product_unit == 'null' ? '' : $soldMainProductUnit->sold_main_product_unit}}" />
                    </td>$
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       4
                    </td>
                    <td> 
                      Sold Main Product Qty
                    </td>
                    
                    @foreach($data as $sold_main_product)
                    <td>
                        <input type="text" name="sold_main_product_{{isset($sold_main_product->id) && $sold_main_product->id ? $sold_main_product->id : ''}}_{{$sold_main_product->farmerId ?? ''}}" value="{{$sold_main_product->sold_main_product == 'null' ? '' : $sold_main_product->sold_main_product}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       5
                    </td>
                    <td>
                        Total Value of Main Product Sold
                    </td>
                    
                    @foreach($data as $totalMainProductSold)
                    <td>
                       
                       <input type="text" name="totalMainProductSold_{{isset($totalMainProductSold->id) && $totalMainProductSold->id ? $totalMainProductSold->id : ''}}_{{$totalMainProductSold->farmerId ?? ''}}" value="{{$totalMainProductSold->total_main_product_sold == 'null' ? '' : $totalMainProductSold->total_main_product_sold}}" />
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       6
                    </td>
                    <td>
                     Selling Price of main products
                    </td>
                    
                    @foreach($data as $selling_price_main_product)
                    <td>
                        <input type="text" name="selling_price_main_product_{{isset($selling_price_main_product->id) && $selling_price_main_product->id ? $selling_price_main_product->id : ''}}_{{$selling_price_main_product->farmerId ?? ''}}" value="{{$selling_price_main_product->selling_price_main_product == 'null' ? '' : $selling_price_main_product->selling_price_main_product}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>7</td>
                    <td>Minimum Price </td>
                     @foreach($data as $main_min_sell_price)
                     <td>
                      <input type="text" name="main_min_sell_price" value="{{$main_min_sell_price->main_min_sell_price == 'null' ? '' : $main_min_sell_price->main_min_sell_price}}" />
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>8</td>
                    <td>Maximum Price </td>
                    @foreach($data as $main_max_sell_price)
                    <td>
                      <input type="text" name="main_max_sell_price" value="{{$main_max_sell_price->main_max_sell_price == 'null' ? '' : $main_max_sell_price->main_max_sell_price}}" />
                    </td>
                    @endforeach
                </tr>
                
                
                <tr>
                    <td>9</td>
                    <td>By-Product Name</td>
                    @foreach($data as $by_product_name)
                    <td>
                      <input type="text" name="by_product_name" value="{{$by_product_name->by_product_name == 'null' ? '' : $by_product_name->by_product_name}}" />
                    </td>
                    @endforeach
                </tr>
                
                
                {{--
                <tr>
                    <td>
                       7
                    </td>
                    <td>
                     Total Selling Price Of Main Product 
                    </td>
                    
                    @foreach($data as $itemMulti)
                        @php
                            $multiOfAllValue = $itemMulti->total_main_product_sold * $itemMulti->selling_price_main_product;
                        @endphp
                
                        <td>
                            
                            <input type="text" name="itemMulti_{{isset($itemMulti->id) && $itemMulti->id ? $itemMulti->id : ''}}_{{$itemMulti->farmerId ?? ''}}" 
                            value="{{ $multiOfAllValue }}">
                        </td>
                    @endforeach
                </tr>
                --}}
                
                <tr>
                    <td>
                        10
                    </td>
                    <td>
                        By-Product Unit 
                    </td>
                    @foreach($data as $prod_unit)
                            <td>
                                <input type="text" name="prod_unit" value="{{$prod_unit->by_product_unit == 'null' ? '' : $prod_unit->by_product_unit}}" />
                            </td>
                    @endforeach
                
                </tr>
                
                
                
                
                <tr>
                    <td>
                       11
                    </td>
                    <td>
                        By-Product Value
                    </td>
                    
                    @foreach($data as $by_product)
                    <td>
                        <input type="text" name="by_product_{{isset($by_product->id) && $by_product->id ? $by_product->id : ''}}_{{$by_product->farmerId ?? ''}}" value="{{$by_product->by_product == 'null' ? '' : $by_product->by_product}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       12
                    </td>
                    <td>
                        Selling  Price of By-products
                    </td>
                    
                    @foreach($data as $selling_price_by_product)
                    <td>
                        <input type="text" 
                        name="selling_price_by_product_{{isset($selling_price_by_product->id) && $selling_price_by_product->id ? $selling_price_by_product->id : ''}}_{{$selling_price_by_product->farmerId ?? ''}}" value="{{$selling_price_by_product->selling_price_by_product == 'null' ? '' : $selling_price_by_product->selling_price_by_product}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>13</td>
                    <td>Minimum Price </td>
                     @foreach($data as $by_min_sell_price)
                     <td>
                      <input type="text" name="by_min_sell_price" value="{{$by_min_sell_price->by_min_sell_price == 'null' ? '' : $by_min_sell_price->by_min_sell_price}}" />
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>14</td>
                    <td>Maximum Price </td>
                    @foreach($data as $by_max_sell_price)
                    <td>
                      <input type="text" name="by_max_sell_price" value="{{$by_max_sell_price->by_max_sell_price == 'null' ? '' : $by_max_sell_price->by_max_sell_price}}" />
                    </td>
                    @endforeach
                </tr>
                
                
                 <tr>
                    <td>
                        X
                    </td>
                    <th colspan="50">
                        Whom to sold
                    </th>
                </tr>
                
                
                <tr>
                    <td>
                       10
                    </td>
                    <td>
                        Village Trader
                    </td>
                    
                    @foreach($data as $village_trader)
                    <td>
                        <input type="text" name="village_trader_{{isset($village_trader->id) && $village_trader->id ? $village_trader->id : ''}}_{{$village_trader->farmerId ?? ''}}" value="{{$village_trader->village_trader == 'null' ? '' : $village_trader->village_trader}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                      11
                    </td>
                    <td>
                        Wholesaler
                    </td>
                    
                    @foreach($data as $wholesaler)
                    <td>
                        <input type="text" name="wholesaler_{{isset($wholesaler->id) && $wholesaler->id ? $wholesaler->id : ''}}_{{$wholesaler->farmerId ?? ''}}" value="{{$wholesaler->wholesaler == 'null' ? '' : $wholesaler->wholesaler}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       12
                    </td>
                    <td>
                        MANDI
                    </td>
                    
                    @foreach($data as $mandi)
                    <td>
                        <input type="text" name="mandi_{{isset($mandi->id) && $mandi->id ? $mandi->id : ''}}_{{$mandi->farmerId ?? ''}}" value="{{$mandi->mandi == 'null' ? '' : $mandi->mandi}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       13
                    </td>
                    <td>
                        Processor
                    </td>
                    
                    @foreach($data as $processor)
                    <td>
                        <input type="text" name="processor_{{isset($processor->id) && $processor->id ? $processor->id : ''}}_{{$processor->farmerId ?? ''}}" value="{{$processor->processor == 'null' ? '' : $processor->processor}}">  
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       14
                    </td>
                    <td>
                        Retailer
                    </td>
                    
                    @foreach($data as $retailer)
                    <td>
                        <input type="text" name="retailer_{{isset($retailer->id) && $retailer->id ? $retailer->id : ''}}_{{$retailer->farmerId ?? ''}}" value="{{$retailer->retailer == 'null' ? '' : $retailer->retailer}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       15
                    </td>
                    <td>
                        Consumer
                    </td>
                    
                    @foreach($data as $consumer)
                    <td>
                        <input type="text" name="consumer_{{isset($consumer->id) && $consumer->id ? $consumer->id : ''}}_{{$consumer->farmerId ?? ''}}" value="{{$consumer->consumer == 'null' ? '' : $consumer->consumer}}">
                    </td>
                    @endforeach
                </tr>
                
                 <tr>
                    <td>
                       16
                    </td>
                    <td>
                        Company
                    </td>
                    
                    @foreach($data as $company)
                    <td>
                       <input type="text" name="company_{{isset($company->id) && $company->id ? $company->id : ''}}_{{$company->farmerId ?? ''}}"
                       value="{{$company->company == 'null' ? '' : $company->company}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       17
                    </td>
                    <td>
                        Commission Agent
                    </td>
                    
                    @foreach($data as $commissionAgent)
                    <td>
                       
                       <input type="text" name="commissionAgent_{{isset($commissionAgent->id) && $commissionAgent->id ? $commissionAgent->id : ''}}_{{$commissionAgent->farmerId ?? ''}}"
                       value="{{$commissionAgent->commission_agent == 'null' ? '' : $commissionAgent->commission_agent}}">
                    </td>
                    @endforeach
                </tr>
                
               @forelse($prother as $pk => $val)
                <tr>
                    <td>18</td>
                    <td>Other</td>
                    @foreach($data as $production_outputs_other)
                        @php
                            // Decode JSON, handling 'null' cases
                            $value = ($production_outputs_other->production_outputs_other === 'null') 
                                     ? [] 
                                     : json_decode($production_outputs_other->production_outputs_other, true);
                        @endphp
                        <td>
                            <input type="text" name="production_outputs_other_{{ $production_outputs_other->id ?? '' }}_{{ $production_outputs_other->farmerId ?? '' }}"
                                   value="{{ $value[$pk] ?? null }}">
                        </td>
                    @endforeach
                </tr>
               @empty
                <tr>
                    <td>18</td>
                    <td>Other</td>
                    @foreach($data as $production_outputs_other)
                        @php
                            // Decode JSON, handling 'null' cases
                            $value = ($production_outputs_other->production_outputs_other === 'null') 
                                     ? [] 
                                     : json_decode($production_outputs_other->production_outputs_other, true);
                        @endphp
                        <td>
                            <input type="text" name="production_outputs_other_{{ $production_outputs_other->id ?? '' }}_{{ $production_outputs_other->farmerId ?? '' }}"
                                   value="{{ $value[0] ?? null }}">
                        </td>
                    @endforeach
                </tr>
            @endforelse

         
        <tr>
            <td></td>
            <td></td>
             @foreach($data as $id)
                    
                    <td style="text-align:center;">
                        <button type="button" class="btn btn-primary fardwardbtn" data-farmer="{{$id->farmerId}}" data-id="{{ $id->id }}">Submit Data</button>
                    </td>                 
            @endforeach             
        </tr>
 
                
            </table>
    </form>
    </div>
 </div>
 <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
        function submitForm(id,farmerId) {
            
            $('#data_id').val(id); 
            $('#farmer_id').val(farmerId); 
            $('#dataForm').submit();
            
        }

        $('.btn-primary').on('click', function() {
            let id = $(this).data('id'); 
            let farmerId = $(this).data('farmer'); 
            $('#dataForm').find('table input[name]').each(function() {
                        if($(this).val()!=''){
                            // console.log($(this).val())
                             var inputString = $(this).attr('name');
                             const parts = inputString.split(/_(?=\d)/);
                             const other_infrastructure = parts[0];
                             if(other_infrastructure+'_'+id+'_'+farmerId!=inputString){
                                $(this).removeAttr('name')
                             }
                        }else{
                            $(this).removeAttr('name')
                        }
            })
            submitForm(id,farmerId); 
        });
    });
 </script>
@endsection