@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-3">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            
            <div class="col-lg-9">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.one.update') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <a href="{{ route('anexure.one') }}" class="btn btn-primary btn-sm">Back</a>
                </form>
            </div>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Anexure List One</h1>
        </div>
        <form id="dataForm" action="{{ route('anexure.one.update') }}" method="POST">
            @csrf
            <input type="hidden" name="data_id" id="data_id" value="">

            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <tr>
                    <td>
                        A
                    </td>
                    <td>
                        FARMER CODE
                    </td>
                    
                    @foreach($data as $farmer)
                    <td>
                       <input type="text" name="" disabled value="{{$farmer->farmer_code}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        B
                    </td>
                    <td>
                        Farmer First Name
                    </td>
                    
                    @foreach($data as $farmer_first_name)
                    <td>
                        <input type="text" name="" disabled value="{{$farmer_first_name->farmer_first_name == 'null' ? '' : $farmer_first_name->farmer_first_name}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        B
                    </td>
                    <td>
                        Farmer Last Name
                    </td>
                    
                    @foreach($data as $farmer_last_name)
                    <td>
                        <input type="text" name="" disabled value="{{$farmer_last_name->farmer_last_name == 'null' ? '' : $farmer_last_name->farmer_last_name}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        C
                    </td>
                    <td>
                       S/O or W/O
                    </td>
                    
                    @foreach($data as $father_name)
                    <td>
                        <input type="text" name="" disabled value="{{isset($father_name->farmer_husband_father_name) && $father_name->farmer_husband_father_name ? $father_name->farmer_husband_father_name : ''}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        D
                    </td>
                    <td>
                       Village
                    </td>
                    
                    @foreach($data as $farmer_village)
                    <td>
                        <input type="text" name="" disabled value="{{$farmer_village->village == 'null' ? '' : $farmer_village->village}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        E
                    </td>
                   <td>
                      State
                    </td>
                    
                    @foreach($data as $farmer_state)
                    <td>
                        <input type="text" name="" disabled value="{{$farmer_state->farmer_state_name == 'null' ? '' : $farmer_state->farmer_state_name}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        F
                    </td>
                   <td>
                      District
                    </td>
                    
                    @foreach($data as $farmer_dis)
                    <td>
                        <input type="text" name="" disabled value="{{$farmer_dis->farmer_district_name == 'null' ? '' : $farmer_dis->farmer_district_name}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        G
                    </td>
                    <td>
                       Block
                    </td>
                    
                    @foreach($data as $farmer_block)
                    <td>
                        <input type="text" name="" disabled value="{{$farmer_block->farmer_block == 'null' ? '' : $farmer_block->farmer_block}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        H
                    </td>
                    <td>
                        Mobile Number
                    </td>
                    
                    @foreach($data as $mobile_number)
                    <td>
                        <input type="text" name="" disabled value="{{$mobile_number->farmer_mobile_number == 'null' ? '' : $mobile_number->farmer_mobile_number}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        I
                    </td>
                    <td>
                        Kcc Limit
                    </td>
                    @foreach($data as $kcc_limit)
                    <td>
                        <input type="text" name="kcc_limit_{{isset($kcc_limit->id) && $kcc_limit->id ? $kcc_limit->id : ''}}" value="{{$kcc_limit->kcc_limit == 'null' ? '' : $kcc_limit->kcc_limit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        J
                    </td>
                    <td>
                        Land Type
                    </td>
                    
                    @foreach($data as $land_type)
                    <td>
                        <input type="text" name="land_type_{{isset($land_type->id) && $land_type->id ? $land_type->id : ''}}" value="{{$land_type->land_type == 'null' ? '' : $land_type->land_type}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        K
                    </td>
                    <td>
                        Soil Health Card
                    </td>
                    
                    @foreach($data as $soilHealthCard)
                    <td>
                        <input type="text" name="soil_health_card_{{isset($soilHealthCard->id) && $soilHealthCard->id ? $soilHealthCard->id : ''}}" value="{{$soilHealthCard->soil_health_card == 'null' ? '' : $soilHealthCard->soil_health_card}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        L
                    </td>
                    <td>
                        Soil Health Card Remark
                    </td>
                    @foreach($data as $soilHealthCardRemark)
                    <td>
                        <input type="text" name="soil_health_card_remark_{{isset($soilHealthCardRemark->id) && $soilHealthCardRemark->id ? $soilHealthCardRemark->id : ''}}" value="{{$soilHealthCardRemark->soil_health_card_remark == 'null' ? '' : $soilHealthCardRemark->soil_health_card_remark}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        M
                    </td>
                    <td>
                        Land Holding Size Unit
                    </td>
                    
                    @foreach($data as $landHoldSizeUnit)
                    <td>
                        <input type="text" name="land_holding_size_unit_{{isset($landHoldSizeUnit->id) && $landHoldSizeUnit->id ? $landHoldSizeUnit->id : ''}}" value="{{$landHoldSizeUnit->land_holding_size_unit == 'null' ? '' : $landHoldSizeUnit->land_holding_size_unit}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        N
                    </td>
                    <td>
                        Land Holding (Area)
                    </td>
                    
                    @foreach($data as $land_holding_size)
                    <td>
                         <input type="text" name="land_holding_size_{{isset($land_holding_size->id) && $land_holding_size->id ? $land_holding_size->id : ''}}" value="{{$land_holding_size->land_holding_size == 'null' ? '' : $land_holding_size->land_holding_size}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        O
                    </td>
                    <td>
                        Land Given Lease Unit
                    </td>
                    
                    @foreach($data as $landGivenLeaseUnit)
                    <td>
                        <input type="text" name="land_given_lease_unit_{{isset($landGivenLeaseUnit->id) && $landGivenLeaseUnit->id ? $landGivenLeaseUnit->id : ''}}" value="{{$landGivenLeaseUnit->land_given_lease_unit == 'null' ? '' : $landGivenLeaseUnit->land_given_lease_unit}}">
                    </td>
                    @endforeach
                </tr>
                 <tr>
                    <td>
                        P
                    </td>
                    <td>
                        Land Given Lease (Area)
                    </td>
                    
                    @foreach($data as $landGivenLease)
                    <td>
                        <input type="text" name="land_given_lease_{{isset($landGivenLease->id) && $landGivenLease->id ? $landGivenLease->id : ''}}" value="{{$landGivenLease->land_given_lease == 'null' ? '' : $landGivenLease->land_given_lease}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        Q
                    </td>
                    <td>
                        Land Holding Taken Lease Unit
                    </td>
                    
                    @foreach($data as $landHoldTakenLeaseUnit)
                    <td>
                        <input type="text" name="land_holding_taken_lease_unit_{{isset($landHoldTakenLeaseUnit->id) && $landHoldTakenLeaseUnit->id ? $landHoldTakenLeaseUnit->id : ''}}" value="{{$landHoldTakenLeaseUnit->land_holding_taken_lease_unit == 'null' ? '' : $landHoldTakenLeaseUnit->land_holding_taken_lease_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        R
                    </td>
                    <td>
                        Land Holding taken Lease (Area)
                    </td>
                    
                    @foreach($data as $land_holding_taken_lease)
                    <td>
                        <input type="text" name="land_holding_taken_lease_{{isset($land_holding_taken_lease->id) && $land_holding_taken_lease->id ? $land_holding_taken_lease->id : ''}}" value="{{$land_holding_taken_lease->land_holding_taken_lease == 'null' ? '' : $land_holding_taken_lease->land_holding_taken_lease}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        S
                    </td>
                    <td>
                        Total Cultivable Area Unit
                    </td>
                    
                    @foreach($data as $totalCultiUnit)
                    <td>
                        <input type="text" name="total_cultivable_unit_{{isset($totalCultiUnit->id) && $totalCultiUnit->id ? $totalCultiUnit->id : ''}}" value="{{$totalCultiUnit->total_cultivable_unit == 'null' ? '' : $totalCultiUnit->total_cultivable_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        T
                    </td>
                    <td>
                        Total Cultivable (Area)
                    </td>
                    
                    @foreach($data as $total_cultivable)
                    <td>
                        <input type="text" name="total_cultivable_{{isset($total_cultivable->id) && $total_cultivable->id ? $total_cultivable->id : ''}}" value="{{$total_cultivable->total_cultivable == 'null' ? '' : $total_cultivable->total_cultivable}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        L
                    </td>
                   <td>
                        CROPPING PATTERN
                    </td>
                     @php
                        $counter = [];
                    @endphp
                    @foreach($data as $crop_patt)
                     @php
                            $farmerId = $crop_patt->farmer_id;
                            $counter[$farmerId] = isset($counter[$farmerId]) ? $counter[$farmerId] + 1 : 1;
                             $romanCount = int_to_roman($counter[$farmerId]);
                        @endphp
                    <td>
                       CROP {{ $romanCount }}
                    </td>
                    @endforeach
                    @php
                            function int_to_roman($num) {
                                $n = intval($num);
                                $result = '';
                                
                                $roman_numerals = array(
                                    'M' => 1000,
                                    'CM' => 900,
                                    'D' => 500,
                                    'CD' => 400,
                                    'C' => 100,
                                    'XC' => 90,
                                    'L' => 50,
                                    'XL' => 40,
                                    'X' => 10,
                                    'IX' => 9,
                                    'V' => 5,
                                    'IV' => 4,
                                    'I' => 1
                                );
                                
                                foreach ($roman_numerals as $roman => $value) {
                                    $matches = intval($n / $value);
                                    $result .= str_repeat($roman, $matches);
                                    $n = $n % $value;
                                }
                                
                                return $result;
                            }
                        @endphp
                </tr>
                <tr>
                    <td>
                        1
                    </td>
                    <td>
                        Season
                    </td>
                    
                    @foreach($data as $season)
                    <td>
                        <input type="text" name="season_{{isset($season->id) && $season->id ? $season->id : ''}}" value="{{$season->season == 'null' ? '' : $season->season}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        2
                    </td>
                    <td>
                        Crop Name
                    </td>
                    @foreach($data as $crop_name)
                    <td>
                        <input type="text" name="crop_name_{{isset($crop_name->id) && $crop_name->id ? $crop_name->id : ''}}" value="{{$crop_name->crop_name == 'null' ? '' : $crop_name->crop_name}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        3
                    </td>
                    <td>
                        Total Cultivatable  Area Unit
                    </td>
                    
                    @foreach($data as $crop_area_unit)
                    <td>
                        <input type="text" name="crop_area_unit_{{isset($crop_area_unit->id) && $crop_area_unit->id ? $crop_area_unit->id : ''}}" value="{{$crop_area_unit->crop_area_unit == 'null' ? '' : $crop_area_unit->crop_area_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        4
                    </td>
                    <td>
                        Total Cultivatable Crop Area
                    </td>
                    
                    @foreach($data as $crop_area)
                    <td>
                        <input type="text" name="crop_area_{{isset($crop_area->id) && $crop_area->id ? $crop_area->id : ''}}" value="{{$crop_area->crop_area == 'null' ? '' : $crop_area->crop_area}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        5
                    </td>
                    <td>
                        Irrigated Area
                    </td>
                    
                    @foreach($data as $irr)
                    <td>
                        <input type="text" name="irrigated_area_{{isset($irr->id) && $irr->id ? $irr->id : ''}}" value="{{$irr->irrigated_area == 'null' ? '' : $irr->irrigated_area}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        M
                    </td>
                    <th colspan="50">
                        CROP WISE COST OF CULTIVATION
                    </td>
                       
                </tr>
                <tr>
                    <td>
                        1
                    </td>
                    <td>
                        Family Labour
                    </td>
                    
                    @foreach($data as $fl)
                    <td>
                        <input type="text" name="family_labour_hrs_{{isset($fl->id) && $fl->id ? $fl->id : ''}}" value="{{$fl->family_labour_hrs == 'null' ? '' : $fl->family_labour_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        2
                    </td>
                    <td>
                        Family Labour Unit Price
                    </td>
                    
                    @foreach($data as $familyLabourUnitPrice)
                    <td>
                        <input type="text" name="family_labour_unit_price_{{isset($familyLabourUnitPrice->id) && $familyLabourUnitPrice->id ? $familyLabourUnitPrice->id : ''}}" value="{{$familyLabourUnitPrice->family_labour_unit_price == 'null' ? '' : $familyLabourUnitPrice->family_labour_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        3
                    </td>
                    <td>
                        Family Labour (Rs.)
                    </td>
                    
                    @foreach($data as $flr)
                    <td>
                        <input type="text" name="family_labour_rs_{{isset($flr->id) && $flr->id ? $flr->id : ''}}" value="{{$flr->family_labour_rs == 'null' ? '' : $flr->family_labour_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        5
                    </td>
                    <td>
                        Family Labour Remarks
                    </td>
                    
                    @foreach($data as $familyLabourRemarks)
                    <td>
                        <input type="text" name="family_labour_remarks_{{isset($familyLabourRemarks->id) && $familyLabourRemarks->id ? $familyLabourRemarks->id : ''}}" value="{{$familyLabourRemarks->family_labour_remarks == 'null' ? '' : $familyLabourRemarks->family_labour_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        6
                    </td>
                    <td>
                        Attached Labour Unit
                    </td>
                    
                    @foreach($data as $fl)
                    <td>
                        <input type="text" name="attached_labour_unit_{{isset($fl->id) && $fl->id ? $fl->id : ''}}" value="{{$fl->attached_labour_unit == 'null' ? '' : $fl->attached_labour_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        4
                    </td>
                    <td>
                        Attached Labour (Hrs.)
                    </td>
                    
                    @foreach($data as $attached_labour_hrs)
                    <td>
                        <input type="text" name="attached_labour_hrs_{{isset($attached_labour_hrs->id) && $attached_labour_hrs->id ? $attached_labour_hrs->id : ''}}" value="{{$attached_labour_hrs->attached_labour_hrs == 'null' ? '' : $attached_labour_hrs->attached_labour_hrs}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        8
                    </td>
                    <td>
                        Attached Labour Unit Price
                    </td>
                    
                    @foreach($data as $attachedLabourUnitPrice)
                    <td>
                        <input type="text" name="attached_labour_unit_price_{{isset($attachedLabourUnitPrice->id) && $attachedLabourUnitPrice->id ? $attachedLabourUnitPrice->id : ''}}" value="{{$attachedLabourUnitPrice->attached_labour_unit_price == 'null' ? '' : $attachedLabourUnitPrice->attached_labour_unit_price}}">
                    </td>
                    @endforeach
                </tr>
        
                <tr>
                    <td>
                        4
                    </td>
                    <td>
                        Attached Labour (Rs.)
                    </td>
                    
                    @foreach($data as $attached_labour_rs)
                    <td>
                        <input type="text" name="attached_labour_rs_{{isset($attached_labour_rs->id) && $attached_labour_rs->id ? $attached_labour_rs->id : ''}}" value="{{$attached_labour_rs->attached_labour_rs == 'null' ? '' : $attached_labour_rs->attached_labour_rs}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       10
                    </td>
                    <td>
                        Attached Labour Remarks
                    </td>
                    
                    @foreach($data as $attachedLabourRemarks)
                    <td>
                        <input type="text" name="attached_labour_remarks_{{isset($attachedLabourRemarks->id) && $attachedLabourRemarks->id ? $attachedLabourRemarks->id : ''}}" value="{{$attachedLabourRemarks->attached_labour_remarks == 'null' ? '' : $attachedLabourRemarks->attached_labour_remarks}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        11
                    </td>
                    <td>
                        Casual Labour Unit
                    </td>
                    
                    @foreach($data as $fl)
                    <td>
                        <input type="text" name="casual_labour_unit_{{isset($fl->id) && $fl->id ? $fl->id : ''}}" value="{{$fl->casual_labour_unit == 'null' ? '' : $fl->casual_labour_unit}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        5
                    </td>
                    <td>
                        Casual Labour (Hrs.)
                    </td>
                    
                    @foreach($data as $casual_labour_rs)
                    <td>
                        <input type="text" name="casual_labour_rs_{{isset($casual_labour_rs->id) && $casual_labour_rs->id ? $casual_labour_rs->id : ''}}" value="{{$casual_labour_rs->casual_labour_rs == 'null' ? '' : $casual_labour_rs->casual_labour_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        13
                    </td>
                    <td>
                        Casual Labour Unit Price
                    </td>
                    
                    @foreach($data as $casualLabourUnitPrice)
                    <td>
                        <input type="text" name="casual_labour_unit_price_{{isset($casualLabourUnitPrice->id) && $casualLabourUnitPrice->id ? $casualLabourUnitPrice->id : ''}}" value="{{$casualLabourUnitPrice->casual_labour_unit_price == 'null' ? '' : $casualLabourUnitPrice->casual_labour_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        6
                    </td>
                    <td>
                        Casual Labour (Rs.)
                    </td>
                    
                    @foreach($data as $casual_labour_hrs)
                    <td>
                        <input type="text" name="casual_labour_hrs_{{isset($casual_labour_hrs->id) && $casual_labour_hrs->id ? $casual_labour_hrs->id : ''}}" value="{{$casual_labour_hrs->casual_labour_hrs == 'null' ? '' : $casual_labour_hrs->casual_labour_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       15
                    </td>
                    <td>
                        Casual Labour Remarks
                    </td>
                    
                    @foreach($data as $casualLabourRemarks)
                    <td>
                        <input type="text" name="casual_labour_remarks_{{isset($casualLabourRemarks->id) && $casualLabourRemarks->id ? $casualLabourRemarks->id : ''}}" value="{{$casualLabourRemarks->casual_labour_remarks == 'null' ? '' : $casualLabourRemarks->casual_labour_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        16
                    </td>
                    <td>
                        Hired Animal Unit
                    </td>
                    
                    @foreach($data as $hired_animal_unit)
                    <td>
                        <input type="text" name="hired_animal_unit_{{isset($hired_animal_unit->id) && $hired_animal_unit->id ? $hired_animal_unit->id : ''}}" value="{{$hired_animal_unit->hired_animal_unit == 'null' ? '' : $hired_animal_unit->hired_animal_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        7
                    </td>
                    <td>
                        Hired Animal Labour (Hrs.)
                    </td>
                    
                    @foreach($data as $hired_animal_labour_rs)
                    <td>
                        <input type="text" name="hired_animal_labour_rs_{{isset($hired_animal_labour_rs->id) && $hired_animal_labour_rs->id ? $hired_animal_labour_rs->id : ''}}" value="{{$hired_animal_labour_rs->hired_animal_labour_rs == 'null' ? '' : $hired_animal_labour_rs->hired_animal_labour_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        18
                    </td>
                    <td>
                        Hired Animal Unit Price
                    </td>
                    
                    @foreach($data as $hiredAnimalUnitPrice)
                    <td>
                        <input type="text" name="hired_animal_unit_price_{{isset($hiredAnimalUnitPrice->id) && $hiredAnimalUnitPrice->id ? $hiredAnimalUnitPrice->id : ''}}" value="{{$hiredAnimalUnitPrice->hired_animal_unit_price == 'null' ? '' : $hiredAnimalUnitPrice->hired_animal_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        8
                    </td>
                    <td>
                        Hired Animal Labour (Rs.)
                    </td>
                    
                    @foreach($data as $hired_animal_labour_hrs)
                    <td>
                        <input type="text" name="hired_animal_labour_hrs_{{isset($hired_animal_labour_hrs->id) && $hired_animal_labour_hrs->id ? $hired_animal_labour_hrs->id : ''}}" value="{{$hired_animal_labour_hrs->hired_animal_labour_hrs == 'null' ? '' : $hired_animal_labour_hrs->hired_animal_labour_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       20
                    </td>
                    <td>
                        Hired Animal Remarks
                    </td>
                    
                    @foreach($data as $hiredAnimalRemarks)
                    <td>
                        <input type="text" name="hired_animal_remarks_{{isset($hiredAnimalRemarks->id) && $hiredAnimalRemarks->id ? $hiredAnimalRemarks->id : ''}}" value="{{$hiredAnimalRemarks->hired_animal_remarks == 'null' ? '' : $hiredAnimalRemarks->hired_animal_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       21
                    </td>
                    <td>
                        Owned Animal Unit
                    </td>
                    
                    @foreach($data as $ownedAnimalUnit)
                    <td>
                        <input type="text" name="owned_animal_unit_{{isset($ownedAnimalUnit->id) && $ownedAnimalUnit->id ? $ownedAnimalUnit->id : ''}}" value="{{$ownedAnimalUnit->owned_animal_unit == 'null' ? '' : $ownedAnimalUnit->owned_animal_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        9
                    </td>
                    <td>
                        Owned Animal Labour (Hrs.)
                    </td>
                    
                    @foreach($data as $owned_animal_hrs)
                    <td>
                        <input type="text" name="owned_animal_hrs_{{isset($owned_animal_hrs->id) && $owned_animal_hrs->id ? $owned_animal_hrs->id : ''}}" value="{{$owned_animal_hrs->owned_animal_hrs == 'null' ? '' : $owned_animal_hrs->owned_animal_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       23
                    </td>
                    <td>
                        Owned Animal Unit Price
                    </td>
                    
                    @foreach($data as $ownedAnimalUnitPrice)
                    <td>
                        <input type="text" name="owned_animal_unit_price_{{isset($ownedAnimalUnitPrice->id) && $ownedAnimalUnitPrice->id ? $ownedAnimalUnitPrice->id : ''}}" value="{{$ownedAnimalUnitPrice->owned_animal_unit_price == 'null' ? '' : $ownedAnimalUnitPrice->owned_animal_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        10
                    </td>
                    <td>
                        Owned Animal Labour (Rs.)
                    </td>
                    
                    @foreach($data as $owned_animal_rs)
                    <td>
                        <input type="text" name="owned_animal_rs_{{isset($owned_animal_rs->id) && $owned_animal_rs->id ? $owned_animal_rs->id : ''}}" value="{{$owned_animal_rs->owned_animal_rs == 'null' ? '' : $owned_animal_rs->owned_animal_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       25
                    </td>
                    <td>
                        Owned Animal Remarks
                    </td>
                    
                    @foreach($data as $ownedAnimalRemarks)
                    <td>
                        <input type="text" name="owned_animal_remarks_{{isset($ownedAnimalRemarks->id) && $ownedAnimalRemarks->id ? $ownedAnimalRemarks->id : ''}}" value="{{$ownedAnimalRemarks->owned_animal_remarks == 'null' ? '' : $ownedAnimalRemarks->owned_animal_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        11
                    </td>
                    <td>
                        Hired Machine (Hrs.)
                    </td>
                    
                    @foreach($data as $hired_machhine_hrs)
                    <td>
                        <input type="text" name="hired_machhine_hrs_{{isset($hired_machhine_hrs->id) && $hired_machhine_hrs->id ? $hired_machhine_hrs->id : ''}}" value="{{$hired_machhine_hrs->hired_machhine_hrs == 'null' ? '' : $hired_machhine_hrs->hired_machhine_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        27
                    </td>
                    <td>
                        Hired Machhine Unit Price
                    </td>
                    
                    @foreach($data as $hiredMachhineUnitPrice)
                    <td>
                        <input type="text" name="hired_machhine_unit_price_{{isset($hiredMachhineUnitPrice->id) && $hiredMachhineUnitPrice->id ? $hiredMachhineUnitPrice->id : ''}}" value="{{$hiredMachhineUnitPrice->hired_machhine_unit_price == 'null' ? '' : $hiredMachhineUnitPrice->hired_machhine_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        12
                    </td>
                    <td>
                        Hired Machine (Rs.)
                    </td>
                    
                    @foreach($data as $hired_machhine_rs)
                    <td>
                        <input type="text" name="hired_machhine_rs_{{isset($hired_machhine_rs->id) && $hired_machhine_rs->id ? $hired_machhine_rs->id : ''}}" value="{{$hired_machhine_rs->hired_machhine_rs == 'null' ? '' : $hired_machhine_rs->hired_machhine_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        29
                    </td>
                    <td>
                        Hired Machine Remarks
                    </td>
                    
                    @foreach($data as $hiredMachhineRemarks)
                    <td>
                        <input type="text" name="hired_machhine_remarks_{{isset($hiredMachhineRemarks->id) && $hiredMachhineRemarks->id ? $hiredMachhineRemarks->id : ''}}" value="{{$hiredMachhineRemarks->hired_machhine_remarks == 'null' ? '' : $hiredMachhineRemarks->hired_machhine_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        30
                    </td>
                    <td>
                        Own Machine Unit
                    </td>
                    
                    @foreach($data as $ownMachineUnit)
                    <td>
                        <input type="text" name="own_machine_unit_{{isset($ownMachineUnit->id) && $ownMachineUnit->id ? $ownMachineUnit->id : ''}}" value="{{$ownMachineUnit->own_machine_unit == 'null' ? '' : $ownMachineUnit->own_machine_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        13
                    </td>
                    <td>
                        Own Machine (Hrs.)
                    </td>
                    
                    @foreach($data as $own_machine_rs)
                    <td>
                        <input type="text" name="own_machine_rs_{{isset($own_machine_rs->id) && $own_machine_rs->id ? $own_machine_rs->id : ''}}" value="{{$own_machine_rs->own_machine_rs == 'null' ? '' : $own_machine_rs->own_machine_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        32
                    </td>
                    <td>
                        Own Machine Unit Price
                    </td>
                    
                    @foreach($data as $ownMachineUnitPrice)
                    <td>
                        <input type="text" name="own_machine_unit_price_{{isset($ownMachineUnitPrice->id) && $ownMachineUnitPrice->id ? $ownMachineUnitPrice->id : ''}}" value="{{$ownMachineUnitPrice->own_machine_unit_price == 'null' ? '' : $ownMachineUnitPrice->own_machine_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        14
                    </td>
                    <td>
                        Own Machine (Rs.)
                    </td>
                    
                    @foreach($data as $own_machine_hrs)
                    <td>
                        <input type="text" name="own_machine_hrs_{{isset($own_machine_hrs->id) && $own_machine_hrs->id ? $own_machine_hrs->id : ''}}" value="{{ $own_machine_hrs->own_machine_hrs == 'null' ? '' : $own_machine_hrs->own_machine_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       34
                    </td>
                    <td>
                        Own Machine Remarks
                    </td>
                    
                    @foreach($data as $ownMachineRemarks)
                    <td>
                       <input type="text" name="own_machine_remarks_{{isset($ownMachineRemarks->id) && $ownMachineRemarks->id ? $ownMachineRemarks->id : ''}}" value="{{ $ownMachineRemarks->own_machine_remarks == 'null' ? '' : $ownMachineRemarks->own_machine_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       35
                    </td>
                    <td>
                        Hired Irrigation Machine Unit
                    </td>
                    
                    @foreach($data as $hiredIrrigationMachineUnit)
                    <td>
                       <input type="text" name="hired_irrigation_machine_unit_{{isset($hiredIrrigationMachineUnit->id) && $hiredIrrigationMachineUnit->id ? $hiredIrrigationMachineUnit->id : ''}}" value="{{ $hiredIrrigationMachineUnit->hired_irrigation_machine_unit == 'null' ? '' : $hiredIrrigationMachineUnit->hired_irrigation_machine_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        15
                    </td>
                    <td>
                        Hired Irrigation Machine (Hrs.)
                    </td>
                    
                    @foreach($data as $hired_irrigation_machine_hrs)
                    <td>
                        <input type="text" name="hired_irrigation_machine_hrs_{{isset($hired_irrigation_machine_hrs->id) && $hired_irrigation_machine_hrs->id ? $hired_irrigation_machine_hrs->id : ''}}" value="{{ $hired_irrigation_machine_hrs->hired_irrigation_machine_hrs == 'null' ? '' : $hired_irrigation_machine_hrs->hired_irrigation_machine_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        37
                    </td>
                    <td>
                        Hired Irrigation Machine Unit Price
                    </td>
                    @foreach($data as $hired_irrigation_machine_unit_price)
                    <td>
                       <input type="text" name="hired_irrigation_machine_unit_price_{{isset($hired_irrigation_machine_unit_price->id) && $hired_irrigation_machine_unit_price->id ? $hired_irrigation_machine_unit_price->id : ''}}" value="{{ $hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price == 'null' ? '' : $hired_irrigation_machine_unit_price->hired_irrigation_machine_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        16
                    </td>
                    <td>
                        Hired Irrigation Machine (Rs.)
                    </td>
                    
                    @foreach($data as $hired_irrigation_machine_rs)
                    <td>
                        <input type="text" name="hired_irrigation_machine_rs_{{isset($hired_irrigation_machine_rs->id) && $hired_irrigation_machine_rs->id ? $hired_irrigation_machine_rs->id : ''}}" value="{{ $hired_irrigation_machine_rs->hired_irrigation_machine_rs == 'null' ? '' : $hired_irrigation_machine_rs->hired_irrigation_machine_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        39
                    </td>
                    <td>
                   Hired Irrigation Machine Remarks
                    </td>
                    @foreach($data as $hired_irrigation_machine_remarks)
                    <td>
                       <input type="text" name="hired_irrigation_machine_remarks_{{isset($hired_irrigation_machine_remarks->id) && $hired_irrigation_machine_remarks->id ? $hired_irrigation_machine_remarks->id : ''}}" value="{{ $hired_irrigation_machine_remarks->hired_irrigation_machine_remarks == 'null' ? '' : $hired_irrigation_machine_remarks->hired_irrigation_machine_remarks}}">
                    </td>
                    @endforeach
                   
                </tr>
                <tr>
                    <td>
                       40
                    </td>
                    <td>
                        Owned Irrigation Machine Unit
                    </td>
                    
                    @foreach($data as $ownedIrrigationMachineUnit)
                    <td>
                       <input type="text" name="owned_irrigation_machine_unit_{{isset($ownedIrrigationMachineUnit->id) && $ownedIrrigationMachineUnit->id ? $ownedIrrigationMachineUnit->id : ''}}" value="{{ $ownedIrrigationMachineUnit->owned_irrigation_machine_unit == 'null' ? '' : $ownedIrrigationMachineUnit->owned_irrigation_machine_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        17
                    </td>
                    <td>
                        Owned Irrigation Machine (Hrs.)
                    </td>
                    
                    @foreach($data as $owned_irrigation_machine_hrs)
                    <td>
                        <input type="text" name="owned_irrigation_machine_hrs_{{isset($owned_irrigation_machine_hrs->id) && $owned_irrigation_machine_hrs->id ? $owned_irrigation_machine_hrs->id : ''}}" value="{{ $owned_irrigation_machine_hrs->owned_irrigation_machine_hrs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       42
                    </td>
                    <td>
                        Owned Irrigation Machine Unit Price
                    </td>
                    
                    @foreach($data as $ownedIrrigationMachineUnitPrice)
                    <td>
                       <input type="text" name="owned_irrigation_machine_unit_price_{{isset($ownedIrrigationMachineUnitPrice->id) && $ownedIrrigationMachineUnitPrice->id ? $ownedIrrigationMachineUnitPrice->id : ''}}" value="{{ $ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price == 'null' ? '' : $ownedIrrigationMachineUnitPrice->owned_irrigation_machine_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        18
                    </td>
                    <td>
                        Owned Irrigation Machine (Rs.)
                    </td>
                    
                    @foreach($data as $owned_irrigation_machine_rs)
                    <td>
                        <input type="text" name="owned_irrigation_machine_rs_{{isset($owned_irrigation_machine_rs->id) && $owned_irrigation_machine_rs->id ? $owned_irrigation_machine_rs->id : ''}}" value="{{ $owned_irrigation_machine_rs->owned_irrigation_machine_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       44
                    </td>
                    <td>
                        Owned Irrigation Machine Remarks
                    </td>
                    
                    @foreach($data as $ownedIrrigationMachineRemarks)
                    <td>
                       <input type="text" name="owned_irrigation_machine_remarks_{{isset($ownedIrrigationMachineRemarks->id) && $ownedIrrigationMachineRemarks->id ? $ownedIrrigationMachineRemarks->id : ''}}" value="{{ $ownedIrrigationMachineRemarks->owned_irrigation_machine_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       45
                    </td>
                    <td>
                        Source of Seed / Plantlets
                    </td>
                    
                    @foreach($data as $seedType)
                    <td>
                       <input type="text" name="seed_type_{{isset($seedType->id) && $seedType->id ? $seedType->id : ''}}" value="{{ $seedType->seed_type}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       46
                    </td>
                    <td>
                        Seed Variety
                    </td>
                    
                    @foreach($data as $seedVariety)
                    <td>
                       <input type="text" name="seed_variety_{{isset($seedVariety->id) && $seedVariety->id ? $seedVariety->id : ''}}" value="{{ $seedVariety->seed_variety}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       47
                    </td>
                    <td>
                        Seed Qty Unit
                    </td>
                    
                    @foreach($data as $seedQtyUnit)
                    <td>
                       <input type="text" name="seed_qty_unit_{{isset($seedQtyUnit->id) && $seedQtyUnit->id ? $seedQtyUnit->id : ''}}" value="{{ $seedQtyUnit->seed_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        48
                    </td>
                    <td>
                        Seed / Plantlets Quanity
                    </td>
                    
                    @foreach($data as $seed_qty)
                    <td>
                       <input type="text" name="seed_qty_{{isset($seed_qty->id) && $seed_qty->id ? $seed_qty->id : ''}}" value="{{ $seed_qty->seed_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       49
                    </td>
                    <td>
                        Seed Unit Price
                    </td>
                    
                    @foreach($data as $seedUnitPrice)
                    <td>
                       <input type="text" name="seed_unit_price_{{isset($seedUnitPrice->id) && $seedUnitPrice->id ? $seedUnitPrice->id : ''}}" value="{{ $seedUnitPrice->seed_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        50
                    </td>
                    <td>
                        Seed Value (Rs.)
                    </td>
                    
                    @foreach($data as $seed_value_rs)
                    <td>
                       <input type="text" name="seed_value_rs_{{isset($seed_value_rs->id) && $seed_value_rs->id ? $seed_value_rs->id : ''}}" value="{{ $seed_value_rs->seed_value_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        51
                    </td>
                    <td>
                        Seed Remarks
                    </td>
                    
                    @foreach($data as $seedRemarks)
                    <td>
                       <input type="text" name="seed_remarks_{{isset($seedRemarks->id) && $seedRemarks->id ? $seedRemarks->id : ''}}" value="{{ $seedRemarks->seed_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        52
                    </td>
                    <td>
                        Fertiliser (N) Qty Unit
                    </td>
                    
                    @foreach($data as $fertiliserNQtyUnit)
                    <td>
                       <input type="text" name="fertiliser_n_qty_unit_{{isset($fertiliserNQtyUnit->id) && $fertiliserNQtyUnit->id ? $fertiliserNQtyUnit->id : ''}}" value="{{ $fertiliserNQtyUnit->fertiliser_n_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        53
                    </td>
                    <td>
                        Fertiliser (N) Quantity
                    </td>
                    
                    @foreach($data as $fertiliser_n_qty)
                    <td>
                       <input type="text" name="fertiliser_n_qty_{{isset($fertiliser_n_qty->id) && $fertiliser_n_qty->id ? $fertiliser_n_qty->id : ''}}" value="{{ $fertiliser_n_qty->fertiliser_n_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        54
                    </td>
                    <td>
                        Fertiliser (N) Unit Price
                    </td>
                    @foreach($data as $fertiliserNUnitPrice)
                    <td>
                       <input type="text" name="fertiliser_n_unit_price_{{isset($fertiliserNUnitPrice->id) && $fertiliserNUnitPrice->id ? $fertiliserNUnitPrice->id : ''}}" value="{{ $fertiliserNUnitPrice->fertiliser_n_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        55
                    </td>
                    <td>
                    Fertiliser (N) (Rs.)
                    </td>
                    
                    @foreach($data as $fertiliser_n_rs)
                    <td>
                       <input type="text" name="fertiliser_n_rs_{{isset($fertiliser_n_rs->id) && $fertiliser_n_rs->id ? $fertiliser_n_rs->id : ''}}" value="{{ $fertiliser_n_rs->fertiliser_n_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       56
                    </td>
                    <td>
                        Fertiliser (N) Remarks
                    </td>
                    
                    @foreach($data as $fertiliserNRemarks)
                    <td>
                        <input type="text" name="fertiliser_n_remarks_{{isset($fertiliserNRemarks->id) && $fertiliserNRemarks->id ? $fertiliserNRemarks->id : ''}}" value="{{ $fertiliserNRemarks->fertiliser_n_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       57
                    </td>
                    <td>
                        Fertiliser (P) Qty Unit
                    </td>
                    
                    @foreach($data as $fertiliserPQtyUnit)
                    <td>
                       <input type="text" name="fertiliser_p_qty_unit_{{isset($fertiliserPQtyUnit->id) && $fertiliserPQtyUnit->id ? $fertiliserPQtyUnit->id : ''}}" value="{{ $fertiliserPQtyUnit->fertiliser_p_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        58
                    </td>
                    <td>
                        Fertiliser (P) Quanity
                    </td>
                    
                    @foreach($data as $fertiliser_p_qty)
                    <td>
                       <input type="text" name="fertiliser_p_qty_{{isset($fertiliser_p_qty->id) && $fertiliser_p_qty->id ? $fertiliser_p_qty->id : ''}}" value="{{ $fertiliser_p_qty->fertiliser_p_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       59
                    </td>
                    <td>
                        Fertiliser (P) Unit Price
                    </td>
                    
                    @foreach($data as $fertiliserPUnitPrice)
                    <td>
                       <input type="text" name="fertiliser_p_unit_price_{{isset($fertiliserPUnitPrice->id) && $fertiliserPUnitPrice->id ? $fertiliserPUnitPrice->id : ''}}" value="{{ $fertiliserPUnitPrice->fertiliser_p_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        60
                    </td>
                    <td>
                    Fertiliser (P) (Rs.)
                    </td>
                    
                    @foreach($data as $fertiliser_p_rs)
                    <td>
                       <input type="text" name="fertiliser_p_rs_{{isset($fertiliser_p_rs->id) && $fertiliser_p_rs->id ? $fertiliser_p_rs->id : ''}}" value="{{ $fertiliser_p_rs->fertiliser_p_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       61
                    </td>
                    <td>
                        Fertiliser (P) Remarks
                    </td>
                    
                    @foreach($data as $fertiliserPRemarks)
                    <td>
                       <input type="text" name="fertiliser_p_remarks_{{isset($fertiliserPRemarks->id) && $fertiliserPRemarks->id ? $fertiliserPRemarks->id : ''}}" value="{{ $fertiliserPRemarks->fertiliser_p_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       62
                    </td>
                    <td>
                        Fertiliser (K) Qty Unit
                    </td>
                    
                    @foreach($data as $fertiliserKQtyUnit)
                    <td>
                       <input type="text" name="fertiliser_k_qty_unit_{{isset($fertiliserKQtyUnit->id) && $fertiliserKQtyUnit->id ? $fertiliserKQtyUnit->id : ''}}" value="{{ $fertiliserKQtyUnit->fertiliser_k_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        63
                    </td>
                    <td>
                        Fertiliser (K) Quanity
                    </td>
                    
                    @foreach($data as $fertiliser_k_qty)
                    <td>
                       <input type="text" name="fertiliser_k_qty_{{isset($fertiliser_k_qty->id) && $fertiliser_k_qty->id ? $fertiliser_k_qty->id : ''}}" value="{{ $fertiliser_k_qty->fertiliser_k_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       64
                    </td>
                    <td>
                        Fertiliser (K) Unit Price
                    </td>
                    
                    @foreach($data as $fertiliserKUnitPrice)
                    <td>
                       <input type="text" name="fertiliser_k_unit_price_{{isset($fertiliserKUnitPrice->id) && $fertiliserKUnitPrice->id ? $fertiliserKUnitPrice->id : ''}}" value="{{ $fertiliserKUnitPrice->fertiliser_k_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        65
                    </td>
                    <td>
                    Fertiliser (K) (Rs.)
                    </td>
                    
                    @foreach($data as $fertiliser_k_rs)
                    <td>
                       <input type="text" name="fertiliser_k_rs_{{isset($fertiliser_k_rs->id) && $fertiliser_k_rs->id ? $fertiliser_k_rs->id : ''}}" value="{{ $fertiliser_k_rs->fertiliser_k_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       66
                    </td>
                    <td>
                        Fertiliser (K) Remarks
                    </td>
                    
                    @foreach($data as $fertiliserKRemarks)
                    <td>
                       <input type="text" name="fertiliser_k_remarks_{{isset($fertiliserKRemarks->id) && $fertiliserKRemarks->id ? $fertiliserKRemarks->id : ''}}" value="{{ $fertiliserKRemarks->fertiliser_k_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       67
                    </td>
                    <td>
                        Other Fertiliser Qty Unit
                    </td>
                    
                    @foreach($data as $otherFertiliserQtyUnit)
                    <td>
                       <input type="text" name="other_fertiliser_qty_unit_{{isset($otherFertiliserQtyUnit->id) && $otherFertiliserQtyUnit->id ? $otherFertiliserQtyUnit->id : ''}}" value="{{ $otherFertiliserQtyUnit->other_fertiliser_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        68
                    </td>
                    <td>
                        Other Fertiliser Qty
                    </td>
                    
                    @foreach($data as $other_fertiliser_qty)
                    <td>
                       <input type="text" name="other_fertiliser_qty_{{isset($other_fertiliser_qty->id) && $other_fertiliser_qty->id ? $other_fertiliser_qty->id : ''}}" value="{{ $other_fertiliser_qty->other_fertiliser_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       69
                    </td>
                    <td>
                        Other Fertiliser Unit Price
                    </td>
                    
                    @foreach($data as $otherFertiliserUnitPrice)
                    <td>
                       <input type="text" name="other_fertiliser_unit_price_{{isset($otherFertiliserUnitPrice->id) && $otherFertiliserUnitPrice->id ? $otherFertiliserUnitPrice->id : ''}}" value="{{ $otherFertiliserUnitPrice->other_fertiliser_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        70
                    </td>
                    <td>
                    Other Fertiliser (Rs.)
                    </td>
                    
                    @foreach($data as $other_fertiliser_rs)
                    <td>
                       <input type="text" name="other_fertiliser_rs_{{isset($other_fertiliser_rs->id) && $other_fertiliser_rs->id ? $other_fertiliser_rs->id : ''}}" value="{{ $other_fertiliser_rs->other_fertiliser_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       71
                    </td>
                    <td>
                        Other Fertiliser Remarks
                    </td>
                    
                    @foreach($data as $otherFertiliserRemarks)
                    <td>
                       <input type="text" name="other_fertiliser_remarks_{{isset($otherFertiliserRemarks->id) && $otherFertiliserRemarks->id ? $otherFertiliserRemarks->id : ''}}" value="{{ $otherFertiliserRemarks->other_fertiliser_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       72
                    </td>
                    <td>
                        DAP Qty Unit
                    </td>
                    
                    @foreach($data as $dapQtyUnit)
                    <td>
                       <input type="text" name="dap_qty_unit_{{isset($dapQtyUnit->id) && $dapQtyUnit->id ? $dapQtyUnit->id : ''}}" value="{{ $dapQtyUnit->dap_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       73
                    </td>
                    <td>
                        DAP Qty
                    </td>
                    
                    @foreach($data as $dapQty)
                    <td>
                       <input type="text" name="dap_qty_{{isset($dapQty->id) && $dapQty->id ? $dapQty->id : ''}}" value="{{ $dapQty->dap_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       74
                    </td>
                    <td>
                        DAP Unit Price
                    </td>
                    
                    @foreach($data as $dapUnitPrice)
                    <td>
                       {{$dapUnitPrice->dap_unit_price == 'null' ? '' : $dapUnitPrice->dap_unit_price}}
                       <input type="text" name="dap_unit_price_{{isset($dapUnitPrice->id) && $dapUnitPrice->id ? $dapUnitPrice->id : ''}}" value="{{ $dapUnitPrice->dap_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                 <tr>
                    <td>
                        75
                    </td>
                    <td>
                        DAP (Rs)
                    </td>
                    
                    @foreach($data as $dap_rs)
                    <td>
                       <input type="text" name="dap_rs_{{isset($dap_rs->id) && $dap_rs->id ? $dap_rs->id : ''}}" value="{{ $dap_rs->dap_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       76
                    </td>
                    <td>
                        DAP Remarks
                    </td>
                    
                    @foreach($data as $dapRemarks)
                    <td>
                       <input type="text" name="dap_remarks_{{isset($dapRemarks->id) && $dapRemarks->id ? $dapRemarks->id : ''}}" value="{{ $dapRemarks->dap_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       77
                    </td>
                    <td>
                        NPK Qty Unit
                    </td>
                    
                    @foreach($data as $npkQtyUnit)
                    <td>
                        <input type="text" name="npk_qty_unit_{{isset($npkQtyUnit->id) && $npkQtyUnit->id ? $npkQtyUnit->id : ''}}" value="{{ $npkQtyUnit->npk_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       78
                    </td>
                    <td>
                        NPK Qty
                    </td>
                    
                    @foreach($data as $npkQty)
                    <td>
                       <input type="text" name="npk_qty_{{isset($npkQty->id) && $npkQty->id ? $npkQty->id : ''}}" value="{{ $npkQty->npk_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        79
                    </td>
                    <td>
                        NPK Unit Price
                    </td>
                    
                    @foreach($data as $npkUnitPrice)
                    <td>
                       <input type="text" name="npk_unit_price_{{isset($npkUnitPrice->id) && $npkUnitPrice->id ? $npkUnitPrice->id : ''}}" value="{{ $npkUnitPrice->npk_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        80
                    </td>
                    <td>
                        NPK (Rs.)
                    </td>
                    
                    @foreach($data as $npk_rs)
                    <td>
                       <input type="text" name="npk_rs_{{isset($npk_rs->id) && $npk_rs->id ? $npk_rs->id : ''}}" value="{{ $npk_rs->npk_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       81
                    </td>
                    <td>
                        NPK Remarks
                    </td>
                    
                    @foreach($data as $npkRemarks)
                    <td>
                        <input type="text" name="npk_remarks_{{isset($npkRemarks->id) && $npkRemarks->id ? $npkRemarks->id : ''}}" value="{{ $npkRemarks->npk_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       82
                    </td>
                    <td>
                        Manure Qty Unit
                    </td>
                    @foreach($data as $manureQtyUnit)
                    <td>
                       <input type="text" name="manure_qty_unit_{{isset($manureQtyUnit->id) && $manureQtyUnit->id ? $manureQtyUnit->id : ''}}" value="{{ $manureQtyUnit->manure_qty_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       83
                    </td>
                    <td>
                        Manure Qty
                    </td>
                    
                    @foreach($data as $manureQty)
                    <td>
                       <input type="text" name="manure_qty_{{isset($manureQty->id) && $manureQty->id ? $manureQty->id : ''}}" value="{{ $manureQty->manure_qty}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        84
                    </td>
                    <td>
                        Manure Unit Price
                    </td>
                    
                    @foreach($data as $manureUnitPrice)
                    <td>
                        <input type="text" name="manure_unit_price_{{isset($manureUnitPrice->id) && $manureUnitPrice->id ? $manureUnitPrice->id : ''}}" value="{{ $manureUnitPrice->manure_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        85
                    </td>
                    <td>
                        Manure (Rs.) FYM
                    </td>
                    
                    @foreach($data as $manure_rs)
                    <td>
                        <input type="text" name="manure_rs_{{isset($manure_rs->id) && $manure_rs->id ? $manure_rs->id : ''}}" value="{{ $manure_rs->manure_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       86
                    </td>
                    <td>
                        Manure Remarks
                    </td>
                    
                    @foreach($data as $manureRemarks)
                    <td>
                        <input type="text" name="manure_remarks_{{isset($manureRemarks->id) && $manureRemarks->id ? $manureRemarks->id : ''}}" value="{{ $manureRemarks->manure_remarks}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       87
                    </td>
                    <td>
                        Insecticide Unit
                    </td>
                    
                    @foreach($data as $insecticideUnit)
                    <td>
                        <input type="text" name="insecticide_unit_{{isset($insecticideUnit->id) && $insecticideUnit->id ? $insecticideUnit->id : ''}}" value="{{ $insecticideUnit->insecticide_unit}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       88
                    </td>
                    <td>
                        Plant Protection Name
                    </td>
                    
                    @foreach($data as $insticideName)
                    <td>
                       <input type="text" name="insticide_name_{{isset($insticideName->id) && $insticideName->id ? $insticideName->id : ''}}" value="{{ $insticideName->insticide_name}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        89
                    </td>
                    <td>
                        Plant Protection Qty
                    </td>
                    
                    @foreach($data as $insecticideQty)
                    <td>
                       <input type="text" name="insecticide_qty_{{isset($insecticideQty->id) && $insecticideQty->id ? $insecticideQty->id : ''}}" value="{{ $insecticideQty->insecticide_qty}}">
                    </td>
                    @endforeach
                </tr>
        
                <tr>
                    <td>
                       90
                    </td>
                    <td>
                        Plant Protection Unit Price
                    </td>
                    
                    @foreach($data as $insecticideUnitPrice)
                    <td>
                       <input type="text" name="insecticide_unit_price_{{isset($insecticideUnitPrice->id) && $insecticideUnitPrice->id ? $insecticideUnitPrice->id : ''}}" value="{{ $insecticideUnitPrice->insecticide_unit_price}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        91
                    </td>
                    <td>
                        Plant Protection (Rs.)
                    </td>
                    
                    @foreach($data as $insecticide_rs)
                    <td>
                       <input type="text" name="insecticide_rs_{{isset($insecticide_rs->id) && $insecticide_rs->id ? $insecticide_rs->id : ''}}" value="{{ $insecticide_rs->insecticide_rs}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        92
                    </td>
                    <td>
                        Plant Protection Remarks
                    </td>
                    
                    @foreach($data as $insecticideRemarks)
                    <td>
                        <input type="text" name="insecticide_remarks_{{isset($insecticideRemarks->id) && $insecticideRemarks->id ? $insecticideRemarks->id : ''}}" value="{{ $insecticideRemarks->insecticide_remarks}}">
                    </td>
                    @endforeach
                </tr>
               <tr>
                    <td>
                       93
                    </td>
                    <td>
                        Canal / other Irrigation Charges (Rs)
                    </td>
                    
                    @foreach($data as $canalOtherCharges)
                    <td>
                        <input type="text" name="canal_other_charges_{{isset($canalOtherCharges->id) && $canalOtherCharges->id ? $canalOtherCharges->id : ''}}" value="{{ $canalOtherCharges->canal_other_charges}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        94
                    </td>
                    <td>
                    Crop Insurance (Rs.)
                    </td>
                    
                    @foreach($data as $crop_insurance_rs)
                    <td>
                        <input type="text" name="crop_insurance_rs_{{isset($crop_insurance_rs->id) && $crop_insurance_rs->id ? $crop_insurance_rs->id : ''}}" value="{{ $crop_insurance_rs->crop_insurance_rs}}">
                    </td>
                    @endforeach
                </tr>
                
                 <tr>
                    <td>
                        95
                    </td>
                    <td>
                    Miscelaneous Cost (Rs.)
                    </td>
                    
                    @foreach($data as $miscelaneous_cost_rs)
                    <td>
                        <input type="text" name="miscelaneous_cost_rs_{{isset($miscelaneous_cost_rs->id) && $miscelaneous_cost_rs->id ? $miscelaneous_cost_rs->id : ''}}" value="{{ $miscelaneous_cost_rs->miscelaneous_cost_rs}}">
                    </td>
                    @endforeach
                </tr>
                 <tr>
                    <td>
                        96
                    </td>
                    <td>
                        Land Revenue (Rs.) LAGAN
                    </td>
                    
                    @foreach($data as $land_revenue_rs)
                    <td>
                        <input type="text" name="land_revenue_rs_{{isset($land_revenue_rs->id) && $land_revenue_rs->id ? $land_revenue_rs->id : ''}}" value="{{ $land_revenue_rs->land_revenue_rs}}">
                    </td>
                    @endforeach
                </tr>
                 <tr>
                    <td>
                        97
                    </td>
                    <td>
                        Rent Paid for Leased in Land (Rs.)
                    </td>
                    
                    @foreach($data as $rent_paid_leased_land)
                    <td>
                       <input type="text" name="rent_paid_leased_land_{{isset($rent_paid_leased_land->id) && $rent_paid_leased_land->id ? $rent_paid_leased_land->id : ''}}" value="{{ $rent_paid_leased_land->rent_paid_leased_land}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        98
                    </td>
                    <td>
                        Interest on working capital rate(%) KCC
                    </td>
                    
                    @foreach($data as $interest_kcc)
                    <td>
                        <input type="text" name="interest_kcc_{{isset($interest_kcc->id) && $interest_kcc->id ? $interest_kcc->id : ''}}" value="{{ $interest_kcc->interest_kcc}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                        99
                    </td>
                    <td>
                        Depericiation of Farm Assets
                    </td>
                    
                    @foreach($data as $depericiation_farm_assets)
                    <td>
                       <input type="text" name="depericiation_farm_assets_{{isset($depericiation_farm_assets->id) && $depericiation_farm_assets->id ? $depericiation_farm_assets->id : ''}}" value="{{ $depericiation_farm_assets->depericiation_farm_assets}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       N
                    </td>
                    <th colspan="50">
                        OUTPUT OF PRODUCTION & MARKETING CHANNEL
                    </td>
                </tr>
                <tr>
                    <td>
                       1
                    </td>
                    <td>
                       Total Production (Qunital)
                    </td>
                    
                    @foreach($data as $total_production)
                    <td>
                        <input type="text" name="total_production_{{isset($total_production->id) && $total_production->id ? $total_production->id : ''}}" value="{{$total_production->total_production == 'null' ? '' : $total_production->total_production}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       2
                    </td>
                    <td>
                      Sold Main Product (Qtls.)
                    </td>
                    
                    @foreach($data as $sold_main_product)
                    <td>
                        <input type="text" name="sold_main_product_{{isset($sold_main_product->id) && $sold_main_product->id ? $sold_main_product->id : ''}}" value="{{$sold_main_product->sold_main_product == 'null' ? '' : $sold_main_product->sold_main_product}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       3
                    </td>
                    <td>
                     Selling Price of main products
                    </td>
                    
                    @foreach($data as $selling_price_main_product)
                    <td>
                        <input type="text" name="selling_price_main_product_{{isset($selling_price_main_product->id) && $selling_price_main_product->id ? $selling_price_main_product->id : ''}}" value="{{$selling_price_main_product->selling_price_main_product == 'null' ? '' : $selling_price_main_product->selling_price_main_product}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       4
                    </td>
                    <td>
                        By Product (Rs.)
                    </td>
                    
                    @foreach($data as $by_product)
                    <td>
                        <input type="text" name="by_product_{{isset($by_product->id) && $by_product->id ? $by_product->id : ''}}" value="{{$by_product->by_product == 'null' ? '' : $by_product->by_product}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       5
                    </td>
                    <td>
                        Selling  Price of By-products
                    </td>
                    
                    @foreach($data as $selling_price_by_product)
                    <td>
                        <input type="text" name="selling_price_by_product_{{isset($selling_price_by_product->id) && $selling_price_by_product->id ? $selling_price_by_product->id : ''}}" value="{{$selling_price_by_product->selling_price_by_product == 'null' ? '' : $selling_price_by_product->selling_price_by_product}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       6
                    </td>
                    <td>
                        Village Trader
                    </td>
                    
                    @foreach($data as $village_trader)
                    <td>
                        <input type="text" name="village_trader_{{isset($village_trader->id) && $village_trader->id ? $village_trader->id : ''}}" value="{{$village_trader->village_trader == 'null' ? '' : $village_trader->village_trader}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       7
                    </td>
                    <td>
                        Wholesaler
                    </td>
                    
                    @foreach($data as $wholesaler)
                    <td>
                        <input type="text" name="wholesaler_{{isset($wholesaler->id) && $wholesaler->id ? $wholesaler->id : ''}}" value="{{$wholesaler->wholesaler == 'null' ? '' : $wholesaler->wholesaler}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       8
                    </td>
                    <td>
                        MANDI
                    </td>
                    
                    @foreach($data as $mandi)
                    <td>
                        <input type="text" name="mandi_{{isset($mandi->id) && $mandi->id ? $mandi->id : ''}}" value="{{$mandi->mandi == 'null' ? '' : $mandi->mandi}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       9
                    </td>
                    <td>
                        Processor
                    </td>
                    
                    @foreach($data as $processor)
                    <td>
                        <input type="text" name="processor_{{isset($processor->id) && $processor->id ? $processor->id : ''}}" value="{{$processor->processor == 'null' ? '' : $processor->processor}}">  
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       10
                    </td>
                    <td>
                        Retailer
                    </td>
                    
                    @foreach($data as $retailer)
                    <td>
                        <input type="text" name="retailer_{{isset($retailer->id) && $retailer->id ? $retailer->id : ''}}" value="{{$retailer->retailer == 'null' ? '' : $retailer->retailer}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       11
                    </td>
                    <td>
                        Consumer
                    </td>
                    
                    @foreach($data as $consumer)
                    <td>
                        <input type="text" name="consumer_{{isset($consumer->id) && $consumer->id ? $consumer->id : ''}}" value="{{$consumer->consumer == 'null' ? '' : $consumer->consumer}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       O
                    </td>
                    <th colspan="50">
                         INFRASTRUCTURE 
                    </td>
                </tr>
                <tr>
                    <td>
                       1
                    </td>
                    <th colspan="50">
                        Irrigation Infrastructure
                    </td>
                </tr>
                <tr>
                    <td>
                       a
                    </td>
                    <td>
                        Canal
                    </td>
                    
                    @foreach($data as $canal)
                    <td>
                        <input type="text" name="canal_{{isset($canal->id) && $canal->id ? $canal->id : ''}}" value="{{$canal->canal == 'null' ? '' : $canal->canal}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       b
                    </td>
                    <td>
                       Tubewell
                    </td>
                    
                    @foreach($data as $tubewell)
                    <td>
                        <input type="text" name="tubewell_{{isset($tubewell->id) && $tubewell->id ? $tubewell->id : ''}}" value="{{$tubewell->tubewell == 'null' ? '' : $tubewell->tubewell}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       c
                    </td>
                    <td>
                         Enginer / Motor / Solar 
                    </td>
                    
                    @foreach($data as $enginer_motor_solar)
                    <td>
                        <input type="text" name="enginer_motor_solar_{{isset($enginer_motor_solar->id) && $enginer_motor_solar->id ? $enginer_motor_solar->id : ''}}" value="{{$enginer_motor_solar->enginer_motor_solar == 'null' ? '' : $enginer_motor_solar->enginer_motor_solar}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       d
                    </td>
                    <td>
                        Pump Sets ( Diesel/ Electric/ Solar)
                    </td>
                    
                    @foreach($data as $pump_sets)
                    <td>
                        <input type="text" name="pump_sets_{{isset($pump_sets->id) && $pump_sets->id ? $pump_sets->id : ''}}" value="{{$pump_sets->pump_sets == 'null' ? '' : $pump_sets->pump_sets}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       e
                    </td>
                    <td>
                        Pond
                    </td>
                    
                    @foreach($data as $pond)
                    <td>
                        <input type="text" name="pond_{{isset($pond->id) && $pond->id ? $pond->id : ''}}" value="{{$pond->pond == 'null' ? '' : $pond->pond}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       f
                    </td>
                    <td>
                        Sprinkler / Drip Irrigation System
                    </td>
                    
                    @foreach($data as $irrigation_system)
                    <td>
                        <input type="text" name="irrigation_system_{{isset($irrigation_system->id) && $irrigation_system->id ? $irrigation_system->id : ''}}" value="{{$irrigation_system->irrigation_system == 'null' ? '' : $irrigation_system->irrigation_system}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       g
                    </td>
                    <td>
                        Pump House
                    </td>
                    
                    @foreach($data as $enginer_motor_solar)
                    <td>
                        <input type="text" name="enginer_motor_solar_{{isset($enginer_motor_solar->id) && $enginer_motor_solar->id ? $enginer_motor_solar->id : ''}}" value="{{$enginer_motor_solar->enginer_motor_solar == 'null' ? '' : $enginer_motor_solar->enginer_motor_solar}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       h
                    </td>
                    <td>
                        Other
                    </td>
                    
                    @foreach($data as $other)
                    <td>
                        <input type="text" name="irrigation_infrastructure_other_{{isset($other->id) && $other->id ? $other->id : ''}}" value="{{$other->irrigation_infrastructures_other == 'null' ? '' : $other->irrigation_infrastructures_other}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       2
                    </td>
                    <th colspan="50">
                        Farm Mechanization
                    </td>
                </tr>
                <tr>
                    <td>
                       a
                    </td>
                    <td>
                       Tractor
                    </td>
                    
                    @foreach($data as $tractor)
                    <td>
                        <input type="text" name="tractor_{{isset($tractor->id) && $tractor->id ? $tractor->id : ''}}" value="{{$tractor->tractor == 'null' ? '' : $tractor->tractor}}">
                    </td>
                    @endforeach
                </tr> 
                <tr>
                    <td>
                       b
                    </td>
                    <td>
                        Power Tiller
                    </td>
                    
                    @foreach($data as $power_tiller)
                    <td>
                        <input type="text" name="power_tiller_{{isset($power_tiller->id) && $power_tiller->id ? $power_tiller->id : ''}}" value="{{$power_tiller->power_tiller == 'null' ? '' : $power_tiller->power_tiller}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       c
                    </td>
                    <td>
                        Cultivator
                    </td>
                    
                    @foreach($data as $cultivator)
                    <td>
                        <input type="text" name="cultivator_{{isset($cultivator->id) && $cultivator->id ? $cultivator->id : ''}}" value="{{$cultivator->cultivator == 'null' ? '' : $cultivator->cultivator}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       d
                    </td>
                    <td>
                        Rotator
                    </td>
                    
                    @foreach($data as $rotator)
                    <td>
                        <input type="text" name="rotator_{{isset($rotator->id) && $rotator->id ? $rotator->id : ''}}" value="{{$rotator->rotator == 'null' ? '' : $rotator->rotator}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       e
                    </td>
                    <td>
                        Harrow
                    </td>
                    
                    @foreach($data as $harrow)
                    <td>
                        <input type="text" name="harrow_{{isset($harrow->id) && $harrow->id ? $harrow->id : ''}}" value="{{$harrow->harrow == 'null' ? '' : $harrow->harrow}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       f
                    </td>
                    <td>
                        Leveller
                    </td>
                    
                    @foreach($data as $leveller)
                    <td>
                        <input type="text" name="leveller_{{isset($leveller->id) && $leveller->id ? $leveller->id : ''}}" value="{{$leveller->leveller == 'null' ? '' : $leveller->leveller}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       g
                    </td>
                    <td>
                        Plough (MB Plough / Disc Plough)
                    </td>
                    
                    @foreach($data as $plough)
                    <td>
                        <input type="text" name="plough_{{isset($plough->id) && $plough->id ? $plough->id : ''}}" value="{{$plough->plough == 'null' ? '' : $plough->plough}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       h
                    </td>
                    <td>
                        Seed drill 
                    </td>
                    
                    @foreach($data as $speed_drill)
                    <td>
                        <input type="text" name="speed_drill_{{isset($speed_drill->id) && $speed_drill->id ? $speed_drill->id : ''}}" value="{{$speed_drill->speed_drill == 'null' ? '' : $speed_drill->speed_drill}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       i
                    </td>
                    <td>
                        Seed Planter
                    </td>
                    
                    @foreach($data as $speed_planter)
                    <td>
                        <input type="text" name="speed_planter_{{isset($speed_planter->id) && $speed_planter->id ? $speed_planter->id : ''}}" value="{{$speed_planter->speed_planter == 'null' ? '' : $speed_planter->speed_planter}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       j
                    </td>
                    <td>
                       Seed cum fertilizer drill
                    </td>
                    
                    @foreach($data as $speed_cum_fertilizer_drill)
                    <td>
                        <input type="text" name="speed_cum_fertilizer_drill_{{isset($speed_cum_fertilizer_drill->id) && $speed_cum_fertilizer_drill->id ? $speed_cum_fertilizer_drill->id : ''}}" value="{{$speed_cum_fertilizer_drill->speed_cum_fertilizer_drill == 'null' ? '' : $speed_cum_fertilizer_drill->speed_cum_fertilizer_drill}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       k
                    </td>
                    <td>
                        Trolley
                    </td>
                    
                    @foreach($data as $trolley)
                    <td>
                        <input type="text" name="trolley_{{isset($trolley->id) && $trolley->id ? $trolley->id : ''}}" value="{{$trolley->trolley == 'null' ? '' : $trolley->trolley}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       l
                    </td>
                    <td>
                        Reaper cum binder
                    </td>
                    
                    @foreach($data as $reaper_cum_binder)
                    <td>
                        <input type="text" name="reaper_cum_binder_{{isset($reaper_cum_binder->id) && $reaper_cum_binder->id ? $reaper_cum_binder->id : ''}}" value="{{$reaper_cum_binder->reaper_cum_binder == 'null' ? '' : $reaper_cum_binder->reaper_cum_binder}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       m
                    </td>
                    <td>
                        Bhusa Making Machine
                    </td>
                    
                    @foreach($data as $bhusa_machine)
                    <td>
                        <input type="text" name="bhusa_machine_{{isset($bhusa_machine->id) && $bhusa_machine->id ? $bhusa_machine->id : ''}}" value="{{$bhusa_machine->bhusa_machine == 'null' ? '' : $bhusa_machine->bhusa_machine}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       n
                    </td>
                    <td>
                        Thresher
                    </td>
                    
                    @foreach($data as $thresher)
                    <td>
                        <input type="text" name="thresher_{{isset($thresher->id) && $thresher->id ? $thresher->id : ''}}" value="{{$thresher->thresher == 'null' ? '' : $thresher->thresher}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       o
                    </td>
                    <td>
                      Combine Harvester
                    </td>
                    
                    @foreach($data as $combine_harvester)
                    <td>
                        <input type="text" name="combine_harvester_{{isset($combine_harvester->id) && $combine_harvester->id ? $combine_harvester->id : ''}}" value="{{$combine_harvester->combine_harvester == 'null' ? '' : $combine_harvester->combine_harvester}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       p
                    </td>
                    <td>
                       Other
                    </td>
                    
                    @foreach($data as $other)
                    <td>
                        <input type="text" name="farm_mechanisms_other_{{isset($other->id) && $other->id ? $other->id : ''}}" value="{{$other->farm_mechanisms_other == 'null' ? '' : $other->farm_mechanisms_other}}">
                    </td>
                    @endforeach
                </tr>
                
                <tr>
                    <td>
                       3
                    </td>
                    <th colspan="50">
                        Storage Structure
                    </td>
                </tr>
                <tr>
                    <td>
                       a
                    </td>
                    <td>
                        Kothila / Deshi Stoarge Structure
                    </td>
                    
                    @foreach($data as $deshi)
                    <td>
                        <input type="text" name="deshi_{{isset($deshi->id) && $deshi->id ? $deshi->id : ''}}" value="{{$deshi->deshi == 'null' ? '' : $deshi->deshi}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       b
                    </td>
                    <td>
                        Godown
                    </td>
                    
                    @foreach($data as $godown)
                    <td>
                        <input type="text" name="godown_{{isset($godown->id) && $godown->id ? $godown->id : ''}}" value="{{$godown->godown == 'null' ? '' : $godown->godown}}">
                       
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       c
                    </td>
                    <td>
                        Clod Stoarge
                    </td>
                    
                    @foreach($data as $clod)
                    <td>
                        <input type="text" name="clod_{{isset($clod->id) && $clod->id ? $clod->id : ''}}" value="{{$clod->clod == 'null' ? '' : $clod->clod}}">
                       
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       d
                    </td>
                    <td>
                        Bulk Cooling Unit
                    </td>
                    
                    @foreach($data as $bulk_cooling)
                    <td>
                        <input type="text" name="bulk_cooling_{{isset($bulk_cooling->id) && $bulk_cooling->id ? $bulk_cooling->id : ''}}" value="{{$bulk_cooling->bulk_cooling == 'null' ? '' : $bulk_cooling->bulk_cooling}}">
                       
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       e
                    </td>
                    <td>
                        Storage for fodder
                    </td>
                    
                    @foreach($data as $fodder)
                    <td>
                        <input type="text" name="fodder_{{isset($fodder->id) && $fodder->id ? $fodder->id : ''}}" value="{{$fodder->fodder == 'null' ? '' : $fodder->fodder}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       4
                    </td>
                    <th colspan="50">
                        Processing Infrstructure
                    </td>
                </tr>
                <tr>
                    <td>
                       a
                    </td>
                    <td>
                        Wheat Processing Unit
                    </td>
                    
                    @foreach($data as $wheat_processing)
                    <td>
                        <input type="text" name="wheat_processing_{{isset($wheat_processing->id) && $wheat_processing->id ? $wheat_processing->id : ''}}" value="{{$wheat_processing->wheat_processing == 'null' ? '' : $wheat_processing->wheat_processing}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       b
                    </td>
                    <td>
                        Oil Processing Unit
                    </td>
                    
                    @foreach($data as $oil_processing)
                    <td>
                        <input type="text" name="oil_processing_{{isset($oil_processing->id) && $oil_processing->id ? $oil_processing->id : ''}}" value="{{$oil_processing->oil_processing == 'null' ? '' : $oil_processing->oil_processing}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       c
                    </td>
                    <td>
                        Sugarcane Processing Unit
                    </td>
                    
                    @foreach($data as $sugarcane_processing)
                    <td>
                        <input type="text" name="sugarcane_processing_{{isset($sugarcane_processing->id) && $sugarcane_processing->id ? $sugarcane_processing->id : ''}}" value="{{$sugarcane_processing->sugarcane_processing == 'null' ? '' : $sugarcane_processing->sugarcane_processing}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       d
                    </td>
                    <td>
                        Dal Processing Unit
                    </td>
                    
                    @foreach($data as $dal_processing)
                    <td>
                        <input type="text" name="dal_processing_{{isset($dal_processing->id) && $dal_processing->id ? $dal_processing->id : ''}}" value="{{$dal_processing->dal_processing == 'null' ? '' : $dal_processing->dal_processing}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       e
                    </td>
                    <td>
                        Any Other Processing unit
                    </td>
                    
                    @foreach($data as $other_processing)
                    <td>
                        <input type="text" name="other_processing_{{isset($other_processing->id) && $other_processing->id ? $other_processing->id : ''}}" value="{{$other_processing->other_processing == 'null' ? '' : $other_processing->other_processing}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       5
                    </td>
                    <th colspan="50">
                        Retails outlet with producer
                    </td>
                </tr>
                <tr>
                    <td>
                       a
                    </td>
                    <td>
                        Kiran Outlets
                    </td>
                    
                    @foreach($data as $kiran_outlets)
                    <td>
                        <input type="text" name="kiran_outlets_{{isset($kiran_outlets->id) && $kiran_outlets->id ? $kiran_outlets->id : ''}}" value="{{$kiran_outlets->kiran_outlets == 'null' ? '' : $kiran_outlets->kiran_outlets}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       b
                    </td>
                    <td>
                        Grossary Outlets
                    </td>
                    
                    @foreach($data as $grossary_outlets)
                    <td>
                        <input type="text" name="grossary_outlets_{{isset($grossary_outlets->id) && $grossary_outlets->id ? $grossary_outlets->id : ''}}" value="{{$grossary_outlets->grossary_outlets == 'null' ? '' : $grossary_outlets->grossary_outlets}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       c
                    </td>
                    <td>
                        Any Other Retail outlets
                    </td>
                    
                    @foreach($data as $other_outlets)
                    <td>
                        <input type="text" name="other_outlets_{{isset($other_outlets->id) && $other_outlets->id ? $other_outlets->id : ''}}" value="{{$other_outlets->other_outlets == 'null' ? '' : $other_outlets->other_outlets}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       6
                    </td>
                    <th colspan="50">
                        Other Infrastructure (Specify)
                    </td>
                </tr>
                <tr>
                    <td>
                       a
                    </td>
                    <td>
                        Shed (Kuchha)
                    </td>
                    
                    @foreach($data as $shed_kuchha)
                    <td>
                        <input type="text" name="shed_kuchha_{{isset($shed_kuchha->id) && $shed_kuchha->id ? $shed_kuchha->id : ''}}" value="{{$shed_kuchha->shed_kuchha == 'null' ? '' : $shed_kuchha->shed_kuchha}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       b
                    </td>
                    <td>
                        Shed (Pucca)
                    </td>
                    
                    @foreach($data as $shed_pucca)
                    <td>
                        <input type="text" name="shed_pucca_{{isset($shed_pucca->id) && $shed_pucca->id ? $shed_pucca->id : ''}}" value="{{$shed_pucca->shed_pucca == 'null' ? '' : $shed_pucca->shed_pucca}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                       c
                    </td>
                    <td>
                        Any other infrastructrure 
                    </td>
                    
                    @foreach($data as $other_infrastructure)
                    <td>
                        <input type="text" name="other_infrastructure_{{isset($other_infrastructure->id) && $other_infrastructure->id ? $other_infrastructure->id : ''}}" value="{{$other_infrastructure->other_infrastructure == 'null' ? '' : $other_infrastructure->other_infrastructure}}">
                    </td>
                    @endforeach
                </tr>
                <tr>
                    <td>
                        
                    </td>
                    <td>
                        
                    </td>
                    
                    @foreach($data as $id)
                    <td>
                        <button type="button" class="btn btn-primary" data-id="{{ $id->id }}">Submit Data</button>
                    </td>
                    @endforeach
                </tr>
            </table>
        </form>
    </div>
 </div>
 <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
 <script>
    $(document).ready(function() {
        function submitForm(id) {
            $('#data_id').val(id); 
            $('#dataForm').submit();
        }

        $('.btn-primary').on('click', function() {
            var id = $(this).data('id'); 
            submitForm(id); 
        });
    });
</script>
@endsection