@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-3">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            <div class="col-lg-9">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.one') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                </form>
            </div>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Anexure List One</h1>
        </div>
        <form action="{{ route('anexure.one.update', ['value' => 'change']) }}" method="POST">
            @csrf
            <?php
                $updateTable = [
                        'crops'
                    ];
            ?>
            <input type="hidden" name="update_table" value="{{ json_encode($updateTable) }}">
            
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                @foreach(['farmer_id', 'crop_name', 'crop_area_unit', 'irrigated_area', 'season', 'crop_area','family_labour_hrs', 'family_labour_rs', 'attached_labour_hrs', 'attached_labour_rs', 'casual_labour_rs', 'casual_labour_hrs', 'hired_animal_labour_rs', 'hired_animal_labour_hrs', 'family_labour_unit_price', 'attached_labour_unit_price',
                'casual_labour_unit_price', 'hired_animal_hrs', 'hired_animal_unit_price', 'hired_animal_rs', 'family_labour_remarks', 'family_labour_unit', 'attached_labour_remarks', 'attached_labour_unit', 'casual_labour_remarks', 'casual_labour_unit', 'hired_animal_remarks',
                'hired_animal_unit', 'owned_animal_hrs', 'owned_animal_rs', 'hired_machhine_hrs', 'hired_machhine_rs', 'own_machine_rs', 'own_machine_hrs', 'hired_irrigation_machine_hrs', 'hired_irrigation_machine_rs', 'owned_animal_unit_price', 'owned_animal_remarks', 'owned_animal_unit',
                'hired_machhine_unit_price', 'hired_machhine_remarks', 'hired_machhine_unit', 'own_machine_unit_price', 'own_machine_remarks', 'own_machine_unit', 'hired_irrigation_machine_unit_price', 'hired_irrigation_machine_remarks', 'hired_irrigation_machine_unit', 'owned_irrigation_machine_unit_price',
                'owned_irrigation_machine_remarks', 'owned_irrigation_machine_unit', 'owned_irrigation_machine_hrs', 'owned_irrigation_machine_rs', 'other_irrigation_charges_hrs', 'seed_value_rs', 'fertiliser_n_rs', 'fertiliser_p_rs', 'fertiliser_k_rs', 'seed_qty_unit', 'seed_qty', 'seed_unit_price', 'seed_remarks',
                'seed_variety', 'fertiliser_n_qty_unit', 'fertiliser_n_qty', 'fertiliser_n_unit_price', 'fertiliser_n_remarks', 'fertiliser_p_qty_unit', 'fertiliser_p_qty', 'fertiliser_p_unit_price', 'fertiliser_p_remarks', 'fertiliser_k_qty_unit', 'fertiliser_k_qty', 'fertiliser_k_unit_price', 'fertiliser_k_remarks',
                'other_fertiliser_kg', 'other_fertiliser_rs', 'dap_kg', 'dap_rs', 'npk_kg', 'npk_rs', 'manure_qtl', 'manure_rs', 'other_fertiliser_qty_unit', 'other_fertiliser_qty_unit_remarks', 'other_fertiliser_qty', 'other_fertiliser_unit_price', 'other_fertiliser_remarks', 'dap_qty_unit', 'dap_unit_remarks', 'dap_qty',
                'dap_unit_price', 'dap_remarks', 'npk_qty_unit', 'npk_qty_unit_remarks', 'npk_qty', 'npk_unit_price', 'npk_remarks', 'manure_qty_unit', 'manure_qty_unit_remarks', 'manure_qty', 'manure_unit_price', 'manure_remarks', 'crop_insurance_rs', 'insecticide_unit', 'insecticide_qty',
                'insecticide_unit_price', 'insecticide_rs', 'land_revenue_rs', 'rent_paid_leased_land', 'interest_kcc', 'canal_other_charges', 'seed_type', 'insecticide_remarks','total_production', 'sold_main_product', 'selling_price_main_product', 'by_product', 'selling_price_by_product', 'village_trader','wholesaler',
                'mandi','processor','retailer','consumer','total_production_unit','sold_main_product_unit','total_main_product_sold','company','commission_agent','production_outputs_other','tractor', 'power_tiller', 'cultivator', 'rotator', 'harrow', 'leveller','plough','speed_drill','speed_planter','speed_cum_fertilizer_drill','trolley','reaper_cum_binder',
                'bhusa_machine','thresher','combine_harvester','farm_mechanisms_other','canal', 'tubewell', 'enginer_motor_solar', 'pump_sets', 'pond', 'irrigation_system','pump_house','irrigation_infrastructures_other','deshi', 'godown', 'clod', 'bulk_cooling', 'fodder', 'storage_structures_other','wheat_processing', 'oil_processing', 'sugarcane_processing', 'dal_processing', 'other_processing',
                'kiran_outlets', 'grossary_outlets', 'other_outlets','shed_kuchha', 'shed_pucca', 'other_infrastructure'] as $field)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ ucfirst(str_replace('_', ' ', $field)) }}</td>
                        @foreach($data as $item)
                            <td>
                                <input type="hidden" name="ids[]" value="{{ $item->id }}">
                                <input type="text" name="{{ $field }}[]" value="{{ $item->$field ?? '' }}">
                            </td>
                        @endforeach
                    </tr>
                @endforeach
            </table>
            <button type="submit" class="btn btn-primary">Update</button>
        </form>
    </div>
 </div>
@endsection