@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')

<?php
    // echo "<pre>";
    // print_r($data); die;
    // echo "</pre>";
?>

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.four') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                </form>
            </div>
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Anexure List Four</h1>
        </div>
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
              <tr>
                <th style="text-align:center;">A</th>
                <th colspan="11">Backward Linkages</th>
            </tr>
            <tr>
               <th style="width:100px; vertical-align:bottom;">
                    Farmer Id
                </th>
                <th style="width:200px; vertical-align:bottom;">
                    Particulars
                </th>
                
                <th style="writing-mode: vertical-lr; text-align:center; width:75px;">
                  Supplier Name
                </th>
                
                
                <th style="writing-mode: vertical-lr; text-align:center; width:150px;">
                  Phone Number </br>Supplier 
                </th>
                
                
                <th style="writing-mode: vertical-lr; text-align:center;">
                    Adequacy(y/N)
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    Quality
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    Timely supply
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    Effectiveness
                </th>
                <th style="writing-mode: vertical-lr; text-align:center; width:75px;">
                    & consultancy service</br>As per scientific recommendation
                </th>
                
                <th style="writing-mode: vertical-lr; text-align:center;">
                    Price reasonability
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    With or without credit
                </th>
                <th style="writing-mode: vertical-lr; text-align:center; width:75px;">
                    with or without credit</br>Difference in input price under
                </th>
                
                <th style="writing-mode: vertical-lr; text-align:center;">
                    Remark
                </th>
            </tr>  
           
            @foreach($data2 as $dset)
            <tr>
                <td>{{$dset->farmer_id}}</td>
                <td>{{$dset->particular_name}}</td>
                <td>{{$dset->input_supplier_name}}</td>
                <td></td>
                <td>{{$dset->adequacy}}</td>
                <td>{{$dset->quality}}</td>
                <td>{{$dset->timely_supply}}</td>
                <td>{{$dset->effectiveness}}</td>
                <td>{{$dset->as_consultancy_service}}</td>
                <td>{{$dset->price_reasonability}}</td>
                <td>{{$dset->with_or_without_credit}}</td>
                <td>{{$dset->diff_in_price_with_without_credit}}</td>
                <td>{{$dset->remark}}</td>
            </tr>
            @endforeach
            
        </table>
    </div>


    <div class="table-responsive mt-5">
        
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
            <tr>
                <th style="text-align:center;">B</th>
                <th colspan="27">Forward Linkages</th>
            </tr>
            <tr>
                <th style="width:150px; text-align:center; vertical-align:bottom;">
                   Farmer Id
                </th>
               
                <th style="writing-mode: vertical-lr; text-align:center;">
                    & Segemenation </br>Marketing channel (Purchaser) 
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    from farm gate</br>Distance of marketing channel
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;width:75px;">
                     Transportation method
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    rickshaw/auto/mini van/tractor/etc.</br>Transport by 
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;width:75px;">
                    Transport Expenses /Charges
                </th>

                <th style="writing-mode: vertical-lr; text-align:center;">
                    (Cleaning, Grading & Sorting)</br>Who undertake primary Processing 
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    buyer/institution present?</br>Whether any assured 
                </th>
                
                
                <th style="writing-mode: vertical-lr; text-align:center;">
                    being practiced by the farmer? </br>inforaml contract farming is</br>Whether any form of formal or
                </th>
                
                <th style="writing-mode: vertical-lr; text-align:center;">
                institutions near the farm gate).</br>Presence of Niche Market (big hotels/residential
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                     packaging, marketing, etc.)</br>undertaken presently(value addition,</br>Whether secondary processing being
                </th>
                
                <th style="writing-mode: vertical-lr; text-align:center;">
                     or food enterprise in the vicinity</br>Presence of any processing plant
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    Whether Storage facility available?
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                     Controlled Atmoshpheric Storage</br>Grain Storage / Cold Storage /
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                   If yes, capacity of the facility?
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    system / any other preservation system</br>Charges for storage / cold storage / bulk cooling
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                     within 3 months/6 months / More</br>Time of sale of produce – Immediately /within month/
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    concrete/brick/metallic road/others</br>Road Connectivity to farm gate is mud road/
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    ( Immeditalely/ duartion of deley)</br>Payment of sale proceed  
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                     of total sale value</br>Extent of Default of Payment
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    Weighing Method ( Conventional / Scientific)
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    Extent of under weighing of whole proceed
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                   ( Demand / Price etc.)</br> Source of Market Information 
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    marketable surplus MSP</br> Pecrentage of sale of total
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                     on MSP procurement center ?</br>Are Producer directly selling
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    If No, extent of getting MSP price
                </th>
                <th style="writing-mode: vertical-lr; text-align:center;">
                    Remarks
                </th>
                
            </tr>  
            
            @foreach($data as $fl)
            <tr>
                <td style="text-align:center;">
                    {{$fl->farmer_id}}
                </td>
                <td>
                    <?php
                        $marketing_channel = isset($fl->marketing_channel) && $fl->marketing_channel ? json_decode($fl->marketing_channel, true) : '';
                    ?>
                    <p>Unit: {{isset($marketing_channel['unit']) && $marketing_channel['unit'] ? $marketing_channel['unit'] : ''}}</p>
                    <p>Farm Gate: {{isset($marketing_channel['farm_gate']) && $marketing_channel['farm_gate'] ? $marketing_channel['farm_gate'] : ''}}</p>
                    <p>MSP: {{isset($marketing_channel['msp']) && $marketing_channel['msp'] ? $marketing_channel['msp'] : ''}}</p>
                    <p>Village Trader: {{isset($marketing_channel['village_trader']) && $marketing_channel['village_trader'] ? $marketing_channel['village_trader'] : ''}}</p>
                    <p>Mandi: {{isset($marketing_channel['mandi']) && $marketing_channel['mandi'] ? $marketing_channel['mandi'] : ''}}</p>
                    <p>Processor: {{isset($marketing_channel['processor']) && $marketing_channel['processor'] ? $marketing_channel['processor'] : ''}}</p>
                    <p>Distributor: {{isset($marketing_channel['distributor']) && $marketing_channel['distributor'] ? $marketing_channel['distributor'] : ''}}</p>
                    <p>Retailer: {{isset($marketing_channel['retailer']) && $marketing_channel['retailer'] ? $marketing_channel['retailer'] : ''}}</p>
                    <p>Consumer: {{isset($marketing_channel['consumer']) && $marketing_channel['consumer'] ? $marketing_channel['consumer'] : ''}}</p>
                </td>
                <td>
                    <?php
                        $marketing_channel_distance = isset($fl->marketing_channel_distance) && $fl->marketing_channel_distance ? json_decode($fl->marketing_channel_distance, true) : '';
                    ?> 
                    <p>Unit: {{isset($marketing_channel_distance['unit']) && $marketing_channel_distance['unit'] ? $marketing_channel_distance['unit'] : ''}}</p>
                    <p>Farm Gate: {{isset($marketing_channel_distance['farm_gate']) && $marketing_channel_distance['farm_gate'] ? $marketing_channel_distance['farm_gate'] : ''}}</p>
                    <p>MSP: {{isset($marketing_channel_distance['msp']) && $marketing_channel_distance['msp'] ? $marketing_channel_distance['msp'] : ''}}</p>
                    <p>Village Trader: {{isset($marketing_channel_distance['village_trader']) && $marketing_channel_distance['village_trader'] ? $marketing_channel_distance['village_trader'] : ''}}</p>
                    <p>Mandi: {{isset($marketing_channel_distance['mandi']) && $marketing_channel_distance['mandi'] ? $marketing_channel_distance['mandi'] : ''}}</p>
                    <p>Processor: {{isset($marketing_channel_distance['processor']) && $marketing_channel_distance['processor'] ? $marketing_channel_distance['processor'] : ''}}</p>
                    <p>Distributor: {{isset($marketing_channel_distance['distributor']) && $marketing_channel_distance['distributor'] ? $marketing_channel_distance['distributor'] : ''}}</p>
                    <p>Retailer: {{isset($marketing_channel_distance['retailer']) && $marketing_channel_distance['retailer'] ? $marketing_channel_distance['retailer'] : ''}}</p>
                    <p>Consumer: {{isset($marketing_channel_distance['consumer']) && $marketing_channel_distance['consumer'] ? $marketing_channel_distance['consumer'] : ''}}</p>
                </td>
                <td>
                    <?php
                        $transportation_method = isset($fl->transportation_method) && $fl->transportation_method ? json_decode($fl->transportation_method, true) : '';
                    ?> 
                    <p>Unit: {{isset($transportation_method['unit']) && $transportation_method['unit'] ? $transportation_method['unit'] : ''}}</p>
                    <p>Farm Gate: {{isset($transportation_method['farm_gate']) && $transportation_method['farm_gate'] ? $transportation_method['farm_gate'] : ''}}</p>
                    <p>MSP: {{isset($transportation_method['msp']) && $transportation_method['msp'] ? $transportation_method['msp'] : ''}}</p>
                    <p>Village Trader: {{isset($transportation_method['village_trader']) && $transportation_method['village_trader'] ? $transportation_method['village_trader'] : ''}}</p>
                    <p>Mandi: {{isset($transportation_method['mandi']) && $transportation_method['mandi'] ? $transportation_method['mandi'] : ''}}</p>
                    <p>Processor: {{isset($transportation_method['processor']) && $transportation_method['processor'] ? $transportation_method['processor'] : ''}}</p>
                    <p>Distributor: {{isset($transportation_method['distributor']) && $transportation_method['distributor'] ? $transportation_method['distributor'] : ''}}</p>
                    <p>Retailer: {{isset($transportation_method['retailer']) && $transportation_method['retailer'] ? $transportation_method['retailer'] : ''}}</p>
                    <p>Consumer: {{isset($transportation_method['consumer']) && $transportation_method['consumer'] ? $transportation_method['consumer'] : ''}}</p>
                </td>
                <td>
                    <?php
                        $transport_by = isset($fl->transport_by) && $fl->transport_by ? json_decode($fl->transport_by, true) : '';
                    ?> 
                    <p>Unit: {{isset($transport_by['unit']) && $transport_by['unit'] ? $transport_by['unit'] : ''}}</p>
                    <p>Farm Gate: {{isset($transport_by['farm_gate']) && $transport_by['farm_gate'] ? $transport_by['farm_gate'] : ''}}</p>
                    <p>MSP: {{isset($transport_by['msp']) && $transport_by['msp'] ? $transport_by['msp'] : ''}}</p>
                    <p>Village Trader: {{isset($transport_by['village_trader']) && $transport_by['village_trader'] ? $transport_by['village_trader'] : ''}}</p>
                    <p>Mandi: {{isset($transport_by['mandi']) && $transport_by['mandi'] ? $transport_by['mandi'] : ''}}</p>
                    <p>Processor: {{isset($transport_by['processor']) && $transport_by['processor'] ? $transport_by['processor'] : ''}}</p>
                    <p>Distributor: {{isset($transport_by['distributor']) && $transport_by['distributor'] ? $transport_by['distributor'] : ''}}</p>
                    <p>Retailer: {{isset($transport_by['retailer']) && $transport_by['retailer'] ? $transport_by['retailer'] : ''}}</p>
                    <p>Consumer: {{isset($transport_by['consumer']) && $transport_by['consumer'] ? $transport_by['consumer'] : ''}}</p> 
                </td>
                <td> 
                    <?php
                        $transport_expenses = isset($fl->transport_expenses) && $fl->transport_expenses ? json_decode($fl->transport_expenses, true) : '';
                    ?> 
                    <p>Unit: {{isset($transport_expenses['unit']) && $transport_expenses['unit'] ? $transport_expenses['unit'] : ''}}</p>
                    <p>Farm Gate: {{isset($transport_expenses['farm_gate']) && $transport_expenses['farm_gate'] ? $transport_expenses['farm_gate'] : ''}}</p>
                    <p>MSP: {{isset($transport_expenses['msp']) && $transport_expenses['msp'] ? $transport_expenses['msp'] : ''}}</p>
                    <p>Village Trader: {{isset($transport_expenses['village_trader']) && $transport_expenses['village_trader'] ? $transport_expenses['village_trader'] : ''}}</p>
                    <p>Mandi: {{isset($transport_expenses['mandi']) && $transport_expenses['mandi'] ? $transport_expenses['mandi'] : ''}}</p>
                    <p>Processor: {{isset($transport_expenses['processor']) && $transport_expenses['processor'] ? $transport_expenses['processor'] : ''}}</p>
                    <p>Distributor: {{isset($transport_expenses['distributor']) && $transport_expenses['distributor'] ? $transport_expenses['distributor'] : ''}}</p>
                    <p>Retailer: {{isset($transport_expenses['retailer']) && $transport_expenses['retailer'] ? $transport_expenses['retailer'] : ''}}</p>
                    <p>Consumer: {{isset($transport_expenses['consumer']) && $transport_expenses['consumer'] ? $transport_expenses['consumer'] : ''}}</p>
                </td>
                <td> 
                    <?php
                        $primary_processing = isset($fl->primary_processing) && $fl->primary_processing ? json_decode($fl->primary_processing, true) : '';
                    ?> 
                    <p>Unit: {{isset($primary_processing['unit']) && $primary_processing['unit'] ? $primary_processing['unit'] : ''}}</p>
                    <p>Farm Gate: {{isset($primary_processing['farm_gate']) && $primary_processing['farm_gate'] ? $primary_processing['farm_gate'] : ''}}</p>
                    <p>MSP: {{isset($primary_processing['msp']) && $primary_processing['msp'] ? $primary_processing['msp'] : ''}}</p>
                    <p>Village Trader: {{isset($primary_processing['village_trader']) && $primary_processing['village_trader'] ? $primary_processing['village_trader'] : ''}}</p>
                    <p>Mandi: {{isset($primary_processing['mandi']) && $primary_processing['mandi'] ? $primary_processing['mandi'] : ''}}</p>
                    <p>Processor: {{isset($primary_processing['processor']) && $primary_processing['processor'] ? $primary_processing['processor'] : ''}}</p>
                    <p>Distributor: {{isset($primary_processing['distributor']) && $primary_processing['distributor'] ? $primary_processing['distributor'] : ''}}</p>
                    <p>Retailer: {{isset($primary_processing['retailer']) && $primary_processing['retailer'] ? $primary_processing['retailer'] : ''}}</p>
                    <p>Consumer: {{isset($primary_processing['consumer']) && $primary_processing['consumer'] ? $primary_processing['consumer'] : ''}}</p>
                </td>
                <td> 
                    <?php
                        $buyer_institution_present = isset($fl->buyer_institution_present) && $fl->buyer_institution_present ? json_decode($fl->buyer_institution_present, true) : '';
                    ?> 
                    <p>Unit: {{isset($buyer_institution_present['unit']) && $buyer_institution_present['unit'] ? $buyer_institution_present['unit'] : ''}}</p>
                    <p>Farm Gate: {{isset($buyer_institution_present['farm_gate']) && $buyer_institution_present['farm_gate'] ? $buyer_institution_present['farm_gate'] : ''}}</p>
                    <p>MSP: {{isset($buyer_institution_present['msp']) && $buyer_institution_present['msp'] ? $buyer_institution_present['msp'] : ''}}</p>
                    <p>Village Trader: {{isset($buyer_institution_present['village_trader']) && $buyer_institution_present['village_trader'] ? $buyer_institution_present['village_trader'] : ''}}</p>
                    <p>Mandi: {{isset($buyer_institution_present['mandi']) && $buyer_institution_present['mandi'] ? $buyer_institution_present['mandi'] : ''}}</p>
                    <p>Processor: {{isset($buyer_institution_present['processor']) && $buyer_institution_present['processor'] ? $buyer_institution_present['processor'] : ''}}</p>
                    <p>Distributor: {{isset($buyer_institution_present['distributor']) && $buyer_institution_present['distributor'] ? $buyer_institution_present['distributor'] : ''}}</p>
                    <p>Retailer: {{isset($buyer_institution_present['retailer']) && $buyer_institution_present['retailer'] ? $buyer_institution_present['retailer'] : ''}}</p>
                    <p>Consumer: {{isset($buyer_institution_present['consumer']) && $buyer_institution_present['consumer'] ? $buyer_institution_present['consumer'] : ''}}</p>
                </td>
                <td> 
                    <?php
                        $formal_informal_contract = isset($fl->formal_informal_contract) && $fl->formal_informal_contract ? json_decode($fl->formal_informal_contract, true) : '';
                    ?> 
                    <p>Unit: {{isset($formal_informal_contract['unit']) && $formal_informal_contract['unit'] ? $formal_informal_contract['unit'] : ''}}</p>
                    <p>Farm Gate: {{isset($formal_informal_contract['farm_gate']) && $formal_informal_contract['farm_gate'] ? $formal_informal_contract['farm_gate'] : ''}}</p>
                    <p>MSP: {{isset($formal_informal_contract['msp']) && $formal_informal_contract['msp'] ? $formal_informal_contract['msp'] : ''}}</p>
                    <p>Village Trader: {{isset($formal_informal_contract['village_trader']) && $formal_informal_contract['village_trader'] ? $formal_informal_contract['village_trader'] : ''}}</p>
                    <p>Mandi: {{isset($formal_informal_contract['mandi']) && $formal_informal_contract['mandi'] ? $formal_informal_contract['mandi'] : ''}}</p>
                    <p>Processor: {{isset($formal_informal_contract['processor']) && $formal_informal_contract['processor'] ? $formal_informal_contract['processor'] : ''}}</p>
                    <p>Distributor: {{isset($formal_informal_contract['distributor']) && $formal_informal_contract['distributor'] ? $formal_informal_contract['distributor'] : ''}}</p>
                    <p>Retailer: {{isset($formal_informal_contract['retailer']) && $formal_informal_contract['retailer'] ? $formal_informal_contract['retailer'] : ''}}</p>
                    <p>Consumer: {{isset($formal_informal_contract['consumer']) && $formal_informal_contract['consumer'] ? $formal_informal_contract['consumer'] : ''}}</p>
                </td>
                <td> {{$fl->niche_market}}</td>
                <td>
                    <?php
                        $secondary_processing = isset($fl->secondary_processing) && $fl->secondary_processing ? json_decode($fl->secondary_processing, true) : '';
                    ?> 
                    <p>Unit: {{isset($secondary_processing['unit']) && $secondary_processing['unit'] ? $secondary_processing['unit'] : ''}}</p>
                    <p>Farm Gate: {{isset($secondary_processing['farm_gate']) && $secondary_processing['farm_gate'] ? $secondary_processing['farm_gate'] : ''}}</p>
                    <p>MSP: {{isset($secondary_processing['msp']) && $secondary_processing['msp'] ? $secondary_processing['msp'] : ''}}</p>
                    <p>Village Trader: {{isset($secondary_processing['village_trader']) && $secondary_processing['village_trader'] ? $secondary_processing['village_trader'] : ''}}</p>
                    <p>Mandi: {{isset($secondary_processing['mandi']) && $secondary_processing['mandi'] ? $secondary_processing['mandi'] : ''}}</p>
                    <p>Processor: {{isset($secondary_processing['processor']) && $secondary_processing['processor'] ? $secondary_processing['processor'] : ''}}</p>
                    <p>Distributor: {{isset($secondary_processing['distributor']) && $secondary_processing['distributor'] ? $secondary_processing['distributor'] : ''}}</p>
                    <p>Retailer: {{isset($secondary_processing['retailer']) && $secondary_processing['retailer'] ? $secondary_processing['retailer'] : ''}}</p>
                    <p>Consumer: {{isset($secondary_processing['consumer']) && $secondary_processing['consumer'] ? $secondary_processing['consumer'] : ''}}</p> 
                </td>
                <td>
                    <?php
                        $processing_in_vicinity = isset($fl->processing_in_vicinity) && $fl->processing_in_vicinity ? json_decode($fl->processing_in_vicinity, true) : '';
                    ?> 
                    <p>Unit: {{isset($processing_in_vicinity['unit']) && $processing_in_vicinity['unit'] ? $processing_in_vicinity['unit'] : ''}}</p>
                    <p>Farm Gate: {{isset($processing_in_vicinity['farm_gate']) && $processing_in_vicinity['farm_gate'] ? $processing_in_vicinity['farm_gate'] : ''}}</p>
                    <p>MSP: {{isset($processing_in_vicinity['msp']) && $processing_in_vicinity['msp'] ? $processing_in_vicinity['msp'] : ''}}</p>
                    <p>Village Trader: {{isset($processing_in_vicinity['village_trader']) && $processing_in_vicinity['village_trader'] ? $processing_in_vicinity['village_trader'] : ''}}</p>
                    <p>Mandi: {{isset($processing_in_vicinity['mandi']) && $processing_in_vicinity['mandi'] ? $processing_in_vicinity['mandi'] : ''}}</p>
                    <p>Processor: {{isset($processing_in_vicinity['processor']) && $processing_in_vicinity['processor'] ? $processing_in_vicinity['processor'] : ''}}</p>
                    <p>Distributor: {{isset($processing_in_vicinity['distributor']) && $processing_in_vicinity['distributor'] ? $processing_in_vicinity['distributor'] : ''}}</p>
                    <p>Retailer: {{isset($processing_in_vicinity['retailer']) && $processing_in_vicinity['retailer'] ? $processing_in_vicinity['retailer'] : ''}}</p>
                    <p>Consumer: {{isset($processing_in_vicinity['consumer']) && $processing_in_vicinity['consumer'] ? $processing_in_vicinity['consumer'] : ''}}</p>
                </td>
                
                <td> {{$fl->storage_facility}}</td>
                <td> {{$fl->storage}}</td>
                <td> {{$fl->facility_capacity}}</td>
                <td> {{$fl->storage_charges}}</td>
                <td> {{$fl->time_of_sale}}</td>
                <td> {{$fl->road_connectivity}}</td>
                <td> {{$fl->payment_of_sale}}</td>
                
                <td> {{$fl->total_sale_value}}</td>
                <td> {{$fl->weighing_method}}</td>
                <td> {{$fl->extent_of_under_weighing}}</td>
                <td> {{$fl->source_of_market_info}}</td>
                <td> {{$fl->total_marketable_surplus}}</td>
                <td> {{$fl->selling_on_msp}}</td>
                
                <td> {{$fl->extent_of_msp_price}}</td>
                <td> {{$fl->remark}}</td>
             
            </tr>
           @endforeach
            
            
        </table>
    </div>

</div>
<script>
        document.getElementById('filterBtn').addEventListener('click', function() {
            var selectedMonth = document.getElementById('month').value;
            var selectedYear = document.getElementById('year').value;
            var dataUrl = document.getElementById('filterBtn').getAttribute('data-url'); 
            var url = dataUrl;
        
            if (selectedMonth) {
                url += "?month=" + selectedMonth;
                if (selectedYear) {
                    url += "&year=" + selectedYear;
                }
            } else if (selectedYear) {
                url += "?year=" + selectedYear;
            }
        
            window.location.href = url;
        });

    </script>
    
    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>
@endsection