<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>
@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            @if($deshboard == 1)
        
            @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.five') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.five.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            @endif
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Quantitative Data from Input suppliers</h1>
        </div>

    @if($data->isNotEmpty()) 
        @php
            $si = 1;
        @endphp
        @foreach($data as $datas)
        <div class="table-responsive">
           <h3>A  . Infrastructure and Support Services</h3>
        <table class="table table-bordered">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Unit Rate</th>
            <th>Amt (Rs.)</th>
            <th>Annualized Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
            <tr>
               @php
                 $shop_permanent= json_decode($datas->cost_of_establishment_of_input_shop_permanent, true);
                @endphp
            <td>{{$si++}}</td>
            <td>{{$datas->farmer_code_id}}</td>
            <td>{{$datas->first_name}} {{$datas->last_name}}</td>
            <td>Cost of establishment of Input Shop Permanent</td>
           <td>{{ $shop_permanent['unit'] ?? '' }}</td>
            <td>{{ $shop_permanent['unitRate'] ?? '' }}</td>
            <td>{{ $shop_permanent['amount'] ?? '' }}</td>
    
            @php
                $annualizedcostPer = isset($shop_permanent['amount']) && isset($perYear->year) && $perYear->year != 0 
                    ? $shop_permanent['amount'] / $perYear->year 
                    : null;
            @endphp
            
            <td>{{ $annualizedcostPer !== null ? number_format($annualizedcostPer, 2) : '' }}</td>
            <!--<td>{{ $annualizedcostPer ?? '' }}</td>-->
            
            <td>{{ $shop_permanent['remark'] ?? '' }}</td>
          </tr>
          
          <tr>
               @php
                 $shop_temporary= json_decode($datas->cost_of_establishment_of_input_shop_temporary, true);
                @endphp
            <td>{{$si++}}</td>
            <td></td>
            <td></td>
            <td>Cost of establishment of Input Shop Temporary</td>
           <td>{{ $shop_temporary['unit'] ?? '' }}</td>
            <td>{{ $shop_temporary['unitRate'] ?? '' }}</td>
            <td>{{ $shop_temporary['amount'] ?? '' }}</td>
            
            
           @php
                $annualizedcosttemp = isset($shop_temporary['amount']) && isset($tempYear->year) && $tempYear->year != 0 
                    ? $shop_temporary['amount'] / $tempYear->year 
                    : null;
            @endphp
            
            <td>{{ $annualizedcosttemp ?? '' }}</td>
            
            
            <td>{{ $shop_temporary['remark'] ?? '' }}</td>
          </tr>
            
        
          
          <tr>
              @php
             $sidd = json_decode($datas->storage_structure_of_input, true);
            @endphp
            <td>2</td>
            <td></td>
            <td></td>
            <td>Cost Storage Structure for Inputs</td>
            <td>{{ $sidd['unit'] ?? '' }}</td>
            <td>{{ $sidd['unitRate'] ?? '' }}</td>
            
            <!--<td>{{ $sidd['amount'] ?? '' }}</td>-->
            
             <td>{{ isset($sidd['unitRate']) ? $sidd['unitRate'] * 500 : null }}</td>
             
            @php
            $storagestc = isset($sidd['unitRate']) && isset($stogest->year) && $stogest->year != 0 
                ? ($sidd['unitRate'] * 500) / $stogest->year 
                : null;
            @endphp 
    
            <td>{{ $storagestc ?? '' }}</td> 
            
            <td>{{ $sidd['remark'] ?? '' }}</td>
          </tr>
          
          <tr>
            @php
             $ss = json_decode($datas->other_infrastructure_input, true);
            @endphp
            <td>3</td>
            <td></td>
            <td></td>
            <td>Cost other Infrastructure for Inputs</td>
            <td>{{ $ss['unit'] ?? '' }}</td>
            <td>{{ $ss['unitRate'] ?? '' }}</td>
            <td>{{ $ss['amount'] ?? '' }}</td>
            <td>{{ $ss['annualCost'] ?? '' }}</td>
            <td>{{ $ss['remark'] ?? '' }}</td>
           </tr>
            
         <tr>
               @php
             $me = json_decode($datas->monthly_expenses_on_electricity, true);
            @endphp
            <td>4</td>
            <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td>{{ $me['unit'] ?? '' }}</td>
            <td>{{ $me['unitRate'] ?? '' }}</td>
            <td>{{ $me['amount'] ?? '' }}</td>
            
            @php
                $monthelectricdata = isset($me['amount']) && isset($monthElectricity->year) && $monthElectricity->year != 0 
                    ? $me['amount'] / $monthElectricity->year 
                    : null;
            @endphp
            
            <td>{{ $monthelectricdata ?? '' }}</td>
            
            <td>{{ $me['remark'] ?? '' }}</td>
          </tr>
          
          
          <tr>
               @php
             $mem = json_decode($datas->monthly_expenses_on_manpower, true);
            @endphp
            <td>5</td>
            <td></td>
            <td></td>
            <td>Monthly Expenses on Manpower</td>
            <td>{{ $mem['unit'] ?? '' }}</td>
            <td>{{ $mem['unitRate'] ?? '' }}</td>
            <td>{{ $mem['amount'] ?? '' }}</td>
            <td>{{ $mem['annualCost'] ?? '' }}</td>
            <td>{{ $mem['remark'] ?? '' }}</td>
           </tr>
          
           <tr>
           @php
             $mr = json_decode($datas->monthly_rent, true);
            @endphp
            <td>6</td>
            <td></td>
            <td></td>
            <td>Monthly rent ( If shop is on rent)</td>
             <td>{{ $mr['unit'] ?? '' }}</td>
            <td>{{ $mr['unitRate'] ?? '' }}</td>
            <td>{{ $mr['amount'] ?? '' }}</td>
            <td>{{ $mr['annualCost'] ?? '' }}</td>
            <td>{{ $mr['remark'] ?? '' }}</td>
           </tr>
           
            <tr>
                 @php
             $mte = json_decode($datas->monthly_travelling_expense, true);
            @endphp
            <td>7</td>
            <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td>{{ $mte['unit'] ?? '' }}</td>
            <td>{{ $mte['unitRate'] ?? '' }}</td>
            <td>{{ $mte['amount'] ?? '' }}</td>
            <td>{{ $mte['annualCost'] ?? '' }}</td>
            <td>{{ $mte['remark'] ?? '' }}</td>
           </tr>
           
          
           
           <tr>
            @php
             $cea_data = json_decode($datas->computer_electronic_assoceris, true);
            @endphp
            <td>8</td>
            <td></td>
            <td></td>
            <td>Computer Electronic Assoceris </td>
            <td>{{ $cea_data['unit'] ?? '' }}</td>
            <td>{{ $cea_data['unitRate'] ?? '' }}</td>
            <td>{{ $cea_data['amount'] ?? '' }}</td>
            
             @php
                $compdata = isset($cea_data['amount']) && isset($computerasso->year) && $computerasso->year != 0 
                    ? $cea_data['amount'] / $computerasso->year 
                    : null;
            @endphp
            
            <!--<td>{{ $compdata ?? '' }}</td>-->
            <td>{{ $compdata !== null ? number_format($compdata, 2) : '' }}</td>
            <td>{{ $cea_data['remark'] ?? '' }}</td>
           </tr>
           
          <tr>
            @php
             $plant_machinary = json_decode($datas->plant_machinary, true);
            @endphp
            <td>9</td>
            <td></td>
            <td></td>
            <td>Plant Machinary </td>
            <td>{{ $plant_machinary['unit'] ?? '' }}</td>
            <td>{{ $plant_machinary['unitRate'] ?? '' }}</td>
            <td>{{ $plant_machinary['amount'] ?? '' }}</td>
            
            @php
                $plantdata = isset($plant_machinary['amount']) && isset($plant->year) && $plant->year != 0 
                    ? $plant_machinary['amount'] / $plant->year 
                    : null;
            @endphp
            
            <td>{{ $plantdata !== null ? number_format($plantdata, 2) : '' }}</td>
            <td>{{ $plant_machinary['remark'] ?? '' }}</td>
           </tr>
           
           <tr>
            @php
             $electric_moter = json_decode($datas->electric_moter, true);
            @endphp
            <td>10</td>
            <td></td>
            <td></td>
            <td>ELECTRIC MOTOR</td>
            <td>{{ $electric_moter['unit'] ?? '' }}</td>
            <td>{{ $electric_moter['unitRate'] ?? '' }}</td>
            <td>{{ $electric_moter['amount'] ?? '' }}</td>
            
            @php
                $electricdata = isset($electric_moter['amount']) && isset($electricmoter->year) && $electricmoter->year != 0 
                    ? $electric_moter['amount'] / $electricmoter->year 
                    : null;
            @endphp
            
            <td>{{ $electricdata ?? '' }}</td>
            <td>{{ $electric_moter['remark'] ?? '' }}</td>
           </tr>
           
           
            <tr>
            @php
             $diseal_engine = json_decode($datas->diseal_engine, true);
            @endphp
            <td>10</td>
            <td></td>
            <td></td>
            <td>Diseal Engine </td>
            <td>{{ $diseal_engine['unit'] ?? '' }}</td>
            <td>{{ $diseal_engine['unitRate'] ?? '' }}</td>
            <td>{{ $diseal_engine['amount'] ?? '' }}</td>
            
            @php
                $disealdata = isset($diseal_engine['amount']) && isset($disealengine->year) && $disealengine->year != 0 
                    ? $diseal_engine['amount'] / $disealengine->year 
                    : null;
            @endphp
            
            <td>{{ $disealdata ?? '' }}</td>
            <td>{{ $diseal_engine['remark'] ?? '' }}</td>
           </tr>
           
          <tr>
            @php
             $tractor = json_decode($datas->tractor, true);
            @endphp
            <td>10</td>
            <td></td>
            <td></td>
            <td>Tractor </td>
            <td>{{ $tractor['unit'] ?? '' }}</td>
            <td>{{ $tractor['unitRate'] ?? '' }}</td>
            <td>{{ $tractor['amount'] ?? '' }}</td>
            
             @php
                $tractordatas = isset($tractor['amount']) && isset($tractorda->year) && $tractorda->year != 0 
                    ? $tractor['amount'] / $tractorda->year 
                    : null;
            @endphp
            
            <td>{{ $tractordatas ?? '' }}</td>
            
            <td>{{ $tractor['remark'] ?? '' }}</td>
           </tr>
           
          
           
           
            <tr>
            @php
             $any_ot = json_decode($datas->any_other, true);
            @endphp
            <td>8</td>
            <td></td>
            <td></td>
            <td>Any Other</td>
            <td>{{ $any_ot['unit'] ?? '' }}</td>
            <td>{{ $any_ot['unitRate'] ?? '' }}</td>
            <td>{{ $any_ot['amount'] ?? '' }}</td>
            <td>{{ $any_ot['annualCost'] ?? '' }}</td>
            <td>{{ $any_ot['remark'] ?? '' }}</td>
           </tr>
           
          <!-- Continue adding rows -->
          
            @php
                $sumOfannual = 
                    ($shop_permanent['amount'] ?? 0) + 
                    ($shop_temporary['amount'] ?? 0) + 
                    (isset($sidd['unitRate']) ? $sidd['unitRate'] * 500 : 0) +
                    ($ss['amount'] ?? 0) + 
                    ($me['amount'] ?? 0) + 
                    ($mem['amount'] ?? 0) + 
                    ($mr['amount'] ?? 0) + 
                    ($mte['amount'] ?? 0) + 
                    ($cea_data['amount'] ?? 0) + 
                    ($plant_machinary['amount'] ?? 0) + 
                    ($electric_moter['amount'] ?? 0) + 
                    ($diseal_engine['amount'] ?? 0) + 
                    ($tractor['amount'] ?? 0) + 
                    ($any_ot['amount'] ?? 0);
            @endphp

          
          <tr>
            <td>9</td>
            <td></td>
            <td></td>
            <td>Annual Intt. on Capital Investment</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">{{$sumOfannual}}</td>
            <td></td>
            <td></td>
          </tr>
          <tr>
            <td colspan="7" class=" text-center" style="font-weight:700;">Total Fixed Cost of Input Supplier</td>
          </tr>
          
          <tr>
               @php
             $awc = json_decode($datas->annual_intt_on_working_capital, true);
            @endphp
            <td>11</td>
            <td></td>
            <td></td>
            <td>Annual Intt. on Working Capital</td>
            <td>{{ $awc['unit'] ?? '' }}</td>
            <td>{{ $awc['unitRate'] ?? '' }}</td>
            <td>{{ $awc['amount'] ?? '' }}</td>
            <td>{{ $awc['annualCost'] ?? '' }}</td>
            <td>{{ $awc['remark'] ?? '' }}</td>
          </tr>
          
         <tr>
               @php
                $picf = json_decode($datas->percentage_of_input_on_credit_farmer, true);
                @endphp
            <td>12</td>
            <td></td>
            <td></td>
            <td>Percentage of Inputs on credit to farmer</td>
            <td>{{ $picf['unit'] ?? '' }}</td>
            <td>{{ $picf['unitRate'] ?? '' }}</td>
            <td>{{ $picf['amount'] ?? '' }}</td>
            <td>{{ $picf['annualCost'] ?? '' }}</td>
            <td>{{ $picf['remark'] ?? '' }}</td>
          </tr>
          
           <tr>
            @php
            $doicf = json_decode($datas->duration_of_input_on_credit_farmer, true);
            @endphp
            <td>13</td>
            <td></td>
            <td></td>
            <td>Duration of Inputs on credit to farmer</td>
            <td>{{ $doicf['unit'] ?? '' }}</td>
            <td>{{ $doicf['unitRate'] ?? '' }}</td>
            <td>{{ $doicf['amount'] ?? '' }}</td>
            <td>{{ $doicf['annualCost'] ?? '' }}</td>
            <td>{{ $doicf['remark'] ?? '' }}</td>
          </tr>
          
           <tr>
            @php
            $eocd = json_decode($datas->extent_of_credit_default, true);
            @endphp
            <td>14</td>
            <td></td>
            <td></td>
            <td>Extent of Credit Default</td>
            <td>{{ $eocd['unit'] ?? '' }}</td>
            <td>{{ $eocd['unitRate'] ?? '' }}</td>
            <td>{{ $eocd['amount'] ?? '' }}</td>
            <td>{{ $eocd['annualCost'] ?? '' }}</td>
            <td>{{ $eocd['remark'] ?? '' }}</td>
          </tr>
          
           <tr>
            @php
             $tec_advi = json_decode($datas->techincal_advisory, true);
            @endphp
            <td>15</td>
            <td></td>
            <td></td>
            <td>Technical Advisory services ( Y/N)</td>
           <td>{{ $tec_advi['unit'] ?? '' }}</td>
            <td>{{ $tec_advi['unitRate'] ?? '' }}</td>
            <td>{{ $tec_advi['amount'] ?? '' }}</td>
            <td>{{ $tec_advi['annualCost'] ?? '' }}</td>
            <td>{{ $tec_advi['remark'] ?? '' }}</td>
          </tr>
          
          <!-- Continue adding rows for other data points -->
          <tr>
            @php
             $any_other_info = json_decode($datas->any_other_information, true);
            @endphp
            <td>16</td>
            <td></td>
            <td></td>
            <td>Any other Information</td>
            <td>{{ $any_other_info['unit'] ?? '' }}</td>
            <td>{{ $any_other_info['unitRate'] ?? '' }}</td>
            <td>{{ $any_other_info['amount'] ?? '' }}</td>
            <td>{{ $any_other_info['annualCost'] ?? '' }}</td>
            <td>{{ $any_other_info['remark'] ?? '' }}</td>
          </tr>
        </tbody>
  </table>
        </div>
        </div>
    
        <div class="table-responsive" style="margin-top:40px;">
        <h3>B . Business Economics</h3>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Type of inputs</th>
            <th>Unit</th>
            <th>Average Cost of purchase</th>
            <th>Average Cost of value addition</th>
            <th>Average Sale Price</th>
            <th>Operational Margins (min & Max)</th>
            <th>Seasonal quantum of sale </th>
            <th>Extent of credit default</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
          <tr>
              @php
             $seed = json_decode($datas->seed, true);
            @endphp
               <td>1</td>
            <td>{{$datas->farmer_code_id}}</td>
            <td>{{$datas->first_name}} {{$datas->last_name}}</td>
            <td>Seed</td>
            <td>{{ $seed['purchase_average_cost_unit'] ?? '' }}</td>
            <td>{{ $seed['purchase_average_cost'] ?? '' }}</td>
            <td>{{ $seed['value_addition_average_cost'] ?? '' }}</td>
            <td>{{ $seed['avrage_sale_price'] ?? '' }}</td>
            <td>min- {{ $seed['min_operational_margins'] ?? '' }} & max- {{ $seed['max_operational_margins'] ?? '' }}</td>
            <td>{{ $seed['seasonal_quantum'] ?? '' }}</td>
            <td>{{ $seed['credit_extent'] ?? '' }}</td>
            <td>{{ $seed['remarks'] ?? '' }}</td>
          </tr>
          
          <tr>
             @php
            $fertilizer = json_decode($datas->fertilizer, true);
            @endphp
            <td>2</td>
            <td></td>
            <td></td>
            <td>Fertilizer</td>
           <td>{{ $fertilizer['purchase_average_cost_unit'] ?? '' }}</td>
            <td>{{ $fertilizer['purchase_average_cost'] ?? '' }}</td>
            <td>{{ $fertilizer['value_addition_average_cost'] ?? '' }}</td>
            <td>{{ $fertilizer['avrage_sale_price'] ?? '' }}</td>
            <td>min- {{ $fertilizer['min_operational_margins'] ?? '' }} & max- {{ $fertilizer['max_operational_margins'] ?? '' }}</td>
            <td>{{ $fertilizer['seasonal_quantum'] ?? '' }}</td>
            <td>{{ $fertilizer['credit_extent'] ?? '' }}</td>
            <td>{{ $fertilizer['remarks'] ?? '' }}</td>
          </tr>
          <tr>
             @php
            $nutrients = json_decode($datas->nutrients, true);
            @endphp
            <td>3</td>
            <td></td>
            <td></td>
            <td>Nutrients</td>
             <td>{{ $nutrients['purchase_average_cost_unit'] ?? '' }}</td>
                <td>{{ $nutrients['purchase_average_cost'] ?? '' }}</td>
                <td>{{ $nutrients['value_addition_average_cost'] ?? '' }}</td>
                <td>{{ $nutrients['avrage_sale_price'] ?? '' }}</td>
                <td>min- {{ $nutrients['min_operational_margins'] ?? '' }} & max- {{ $nutrients['max_operational_margins'] ?? '' }}</td>
                <td>{{ $nutrients['seasonal_quantum'] ?? '' }}</td>
                <td>{{ $nutrients['credit_extent'] ?? '' }}</td>
                <td>{{ $nutrients['remarks'] ?? '' }}</td>
          </tr>
       
          <tr>
               @php
                $insecticide_pesticides_herbicides = json_decode($datas->insecticide_pesticides_herbicides, true);
                @endphp
            <td>4</td>
            <td></td>
            <td></td>
            <td>Insecticide / Pesticides / Herbicides</td>
             <td>{{ $insecticide_pesticides_herbicides['purchase_average_cost_unit'] ?? '' }}</td>
            <td>{{ $insecticide_pesticides_herbicides['purchase_average_cost'] ?? '' }}</td>
            <td>{{ $insecticide_pesticides_herbicides['value_addition_average_cost'] ?? '' }}</td>
            <td>{{ $insecticide_pesticides_herbicides['avrage_sale_price'] ?? '' }}</td>
            <td>min- {{ $insecticide_pesticides_herbicides['min_operational_margins'] ?? '' }} & max- {{ $insecticide_pesticides_herbicides['max_operational_margins'] ?? '' }}</td>
            <td>{{ $insecticide_pesticides_herbicides['seasonal_quantum'] ?? '' }}</td>
            <td>{{ $insecticide_pesticides_herbicides['credit_extent'] ?? '' }}</td>
            <td>{{ $insecticide_pesticides_herbicides['remarks'] ?? '' }}</td>
          </tr>
          
        <tr>
            @php
            $fm_custom_hiring_service = json_decode($datas->fm_custom_hiring_service, true);
            @endphp
            <td>5</td>
            <td></td>
            <td></td>
            <td>FM- Custom and Hiring Services</td>
              <td>{{ $fm_custom_hiring_service['purchase_average_cost_unit'] ?? '' }}</td>
            <td>{{ $fm_custom_hiring_service['purchase_average_cost'] ?? '' }}</td>
            <td>{{ $fm_custom_hiring_service['value_addition_average_cost'] ?? '' }}</td>
            <td>{{ $fm_custom_hiring_service['avrage_sale_price'] ?? '' }}</td>
            <td>min- {{ $fm_custom_hiring_service['min_operational_margins'] ?? '' }} & max- {{ $fm_custom_hiring_service['max_operational_margins'] ?? '' }}</td>
            <td>{{ $fm_custom_hiring_service['seasonal_quantum'] ?? '' }}</td>
            <td>{{ $fm_custom_hiring_service['credit_extent'] ?? '' }}</td>
            <td>{{ $fm_custom_hiring_service['remarks'] ?? '' }}</td>
          </tr>
          
          <tr>
               @php
            $fingerling = json_decode($datas->fingerling, true);
            @endphp
            <td>6</td>
            <td></td>
            <td></td>
            <td>Fingerling (fishery)</td>
             <td>{{ $fingerling['purchase_average_cost_unit'] ?? '' }}</td>
            <td>{{ $fingerling['purchase_average_cost'] ?? '' }}</td>
            <td>{{ $fingerling['value_addition_average_cost'] ?? '' }}</td>
            <td>{{ $fingerling['avrage_sale_price'] ?? '' }}</td>
            <td>min- {{ $fingerling['min_operational_margins'] ?? '' }} & max- {{ $fingerling['max_operational_margins'] ?? '' }}</td>
            <td>{{ $fingerling['seasonal_quantum'] ?? '' }}</td>
            <td>{{ $fingerling['credit_extent'] ?? '' }}</td>
            <td>{{ $fingerling['remarks'] ?? '' }}</td>
          </tr>
          
           <tr>
            @php
            $poultry = json_decode($datas->poultry, true);
            @endphp
            <td>7</td>
            <td></td>
            <td></td>
            <td>DOCs (Poultry)</td>
             <td>{{ $poultry['purchase_average_cost_unit'] ?? '' }}</td>
            <td>{{ $poultry['purchase_average_cost'] ?? '' }}</td>
            <td>{{ $poultry['value_addition_average_cost'] ?? '' }}</td>
            <td>{{ $poultry['avrage_sale_price'] ?? '' }}</td>
            <td>min- {{ $poultry['min_operational_margins'] ?? '' }} & max- {{ $poultry['max_operational_margins'] ?? '' }}</td>
            <td>{{ $poultry['seasonal_quantum'] ?? '' }}</td>
            <td>{{ $poultry['credit_extent'] ?? '' }}</td>
            <td>{{ $poultry['remarks'] ?? '' }}</td>
          </tr>
          
           <tr>
                @php
                $plantlets = json_decode($datas->plantlets, true);
                @endphp
            <td>8</td>
            <td></td>
            <td></td>
            <td>Plantlets (Horticulture)</td>
             <td>{{ $plantlets['purchase_average_cost_unit'] ?? '' }}</td>
            <td>{{ $plantlets['purchase_average_cost'] ?? '' }}</td>
            <td>{{ $plantlets['value_addition_average_cost'] ?? '' }}</td>
            <td>{{ $plantlets['avrage_sale_price'] ?? '' }}</td>
            <td>min- {{ $plantlets['min_operational_margins'] ?? '' }} & max- {{ $plantlets['max_operational_margins'] ?? '' }}</td>
            <td>{{ $plantlets['seasonal_quantum'] ?? '' }}</td>
            <td>{{ $plantlets['credit_extent'] ?? '' }}</td>
            <td>{{ $plantlets['remarks'] ?? '' }}</td>
          </tr>
          
           <tr>
                @php
    $feeds_supply = json_decode($datas->feeds_supply, true);
    @endphp
            <td>9</td>
            <td></td>
            <td></td>
            <td>Feeds supply</td>
            <td>{{ $feeds_supply['purchase_average_cost_unit'] ?? '' }}</td>
    <td>{{ $feeds_supply['purchase_average_cost'] ?? '' }}</td>
    <td>{{ $feeds_supply['value_addition_average_cost'] ?? '' }}</td>
    <td>{{ $feeds_supply['avrage_sale_price'] ?? '' }}</td>
    <td>min- {{ $feeds_supply['min_operational_margins'] ?? '' }} & max- {{ $feeds_supply['max_operational_margins'] ?? '' }}</td>
    <td>{{ $feeds_supply['seasonal_quantum'] ?? '' }}</td>
    <td>{{ $feeds_supply['credit_extent'] ?? '' }}</td>
    <td>{{ $feeds_supply['remarks'] ?? '' }}</td>
          </tr>
          
           <tr>
                @php
    $medicines = json_decode($datas->medicines, true);
    @endphp
            <td>10</td>
            <td></td>
            <td></td>
            <td>Medicines</td>
            <td>{{ $medicines['purchase_average_cost_unit'] ?? '' }}</td>
    <td>{{ $medicines['purchase_average_cost'] ?? '' }}</td>
    <td>{{ $medicines['value_addition_average_cost'] ?? '' }}</td>
    <td>{{ $medicines['avrage_sale_price'] ?? '' }}</td>
    <td>min- {{ $medicines['min_operational_margins'] ?? '' }} & max- {{ $medicines['max_operational_margins'] ?? '' }}</td>
    <td>{{ $medicines['seasonal_quantum'] ?? '' }}</td>
    <td>{{ $medicines['credit_extent'] ?? '' }}</td>
    <td>{{ $medicines['remarks'] ?? '' }}</td>
          </tr>
          
            <tr>
                 @php
                $consultancy = json_decode($datas->consultancy, true);
                @endphp
            <td>11</td>
            <td></td>
            <td></td>
            <td>Consultancy</td>
            <td>{{ $consultancy['purchase_average_cost_unit'] ?? '' }}</td>
            <td>{{ $consultancy['purchase_average_cost'] ?? '' }}</td>
            <td>{{ $consultancy['value_addition_average_cost'] ?? '' }}</td>
            <td>{{ $consultancy['avrage_sale_price'] ?? '' }}</td>
            <td>min- {{ $consultancy['min_operational_margins'] ?? '' }} & max- {{ $consultancy['max_operational_margins'] ?? '' }}</td>
            <td>{{ $consultancy['seasonal_quantum'] ?? '' }}</td>
            <td>{{ $consultancy['credit_extent'] ?? '' }}</td>
            <td>{{ $consultancy['remarks'] ?? '' }}</td>
          </tr>
          
        </tbody>
  </table>
    </div>

        <div class="table-responsive" style="margin-top:40px;">
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">C . Other Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
        </div>
        
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Indicative / Illustrative Issues / Constraints*</th>
            <th>Quantitative / Qualitative Indicators</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
            <td>{{$datas->farmer_code_id}}</td>
            <td>{{$datas->first_name}} {{$datas->last_name}}</td>
            <td style="font-weight:700;">General</td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
              @php
                $Issues_constraints_a = json_decode($datas->Issues_constraints_a, true);
                @endphp
            <td>a</td>
               <td></td>
            <td></td>
            <td>Farmer who has taken inputs on Credit, next time they will purchase inputs in other shops</td>
             <td>{{ $Issues_constraints_a['value'] ?? '' }}</td>
            <td>{{ $Issues_constraints_a['remark'] ?? '' }}</td>
         </tr>
         
          <tr>
              @php
                $Issues_constraints_b = json_decode($datas->Issues_constraints_b, true);
                @endphp
            <td>b</td>
               <td></td>
            <td></td>
            <td>Delay in collection of credits if farmer produce rates are very low</td>
            <td>{{ $Issues_constraints_b['value'] ?? '' }}</td>
            <td>{{ $Issues_constraints_b['remark'] ?? '' }}</td>
         </tr>  
         
          <tr>
              @php
                $Issues_constraints_c = json_decode($datas->Issues_constraints_c, true);
              @endphp
            <td>c</td>
               <td></td>
            <td></td>
            <td>Transportation losses</td>
            <td>{{ $Issues_constraints_c['value'] ?? '' }}</td>
            <td>{{ $Issues_constraints_c['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              
            <td>2</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Challenge</td>
           <td></td>
            <td></td>
         </tr> 
         
         <tr>
              @php
                $challenges_a = json_decode($datas->challenges_a, true);
              @endphp
            <td>a</td>
               <td></td>
            <td></td>
            <td>Prise variations compare to other shops</td>
             <td>{{ $challenges_a['value'] ?? '' }}</td>
            <td>{{ $challenges_a['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
    $challenges_b = json_decode($datas->challenges_b, true);
    @endphp
            <td>b</td>
               <td></td>
            <td></td>
            <td>Farmers will purchase based on results</td>
           <td>{{ $challenges_b['value'] ?? '' }}</td>
    <td>{{ $challenges_b['remark'] ?? '' }}</td>
         </tr> 
         
           <tr>
                @php
    $challenges_c = json_decode($datas->challenges_c, true);
    @endphp
            <td>c</td>
               <td></td>
            <td></td>
            <td>Marketing of new products launched by company</td>
                  <td>{{ $challenges_c['value'] ?? '' }}</td>
    <td>{{ $challenges_c['remark'] ?? '' }}</td>
         </tr> 
         
         
         <tr>
              @php
            $challenges_d = json_decode($datas->challenges_d, true);
            @endphp
            <td>d</td>
               <td></td>
            <td></td>
            <td>Credit business compulsory</td>
             <td>{{ $challenges_d['value'] ?? '' }}</td>
             <td>{{ $challenges_d['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
               
            <td>3</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Risk</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
               @php
            $risk_a = json_decode($datas->risk_a, true);
            @endphp
            <td>a</td>
               <td></td>
            <td></td>
            <td>100% credits collection not possible</td>
          <td>{{ $risk_a['value'] ?? '' }}</td>
         <td>{{ $risk_a['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
              @php
            $risk_b = json_decode($datas->risk_b, true);
            @endphp
            <td>b</td>
               <td></td>
            <td></td>
            <td>Same company will give inputs on cash basis</td>
             <td>{{ $risk_b['value'] ?? '' }}</td>
            <td>{{ $risk_b['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
            $risk_c = json_decode($datas->risk_c, true);
            @endphp
            <td>c</td>
               <td></td>
            <td></td>
            <td>Competition on Product Prise variations compare to other shops</td>
           <td>{{ $risk_c['value'] ?? '' }}</td>
            <td>{{ $risk_c['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
            $risk_d = json_decode($datas->risk_d, true);
            @endphp
            <td>d</td>
               <td></td>
            <td></td>
            <td>Farmers will purchase inputs next time  based on results he will get in his field</td>
            <td>{{ $risk_d['value'] ?? '' }}</td>
            <td>{{ $risk_d['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
            $risk_e = json_decode($datas->risk_e, true);
            @endphp
            <td>e</td>
               <td></td>
            <td></td>
            <td>Extent of expiry of inputs</td>
             <td>{{ $risk_e['value'] ?? '' }}</td>
            <td>{{ $risk_e['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
            $risk_f = json_decode($datas->risk_f, true);
            @endphp
            <td>f</td>
               <td></td>
            <td></td>
            <td>Any other</td>
           <td>{{ $risk_f['value'] ?? '' }}</td>
            <td>{{ $risk_f['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
            <td>4</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Prospects</td>
            <td></td>
            <td></td>
         </tr> 
         
         
        <tr>
             @php
            $prospects_a = json_decode($datas->prospects_a, true);
            @endphp
            <td>a</td>
               <td></td>
            <td></td>
            <td>Timely/Regular  supply of inputs from company</td>
            <td>{{ $prospects_a['value'] ?? '' }}</td>
            <td>{{ $prospects_a['remark'] ?? '' }}</td>
         </tr> 
         
        <tr>
            @php
            $prospects_b = json_decode($datas->prospects_b, true);
            @endphp
            <td>b</td>
               <td></td>
            <td></td>
            <td>Cash and carry business</td>
            <td>{{ $prospects_b['value'] ?? '' }}</td>
            <td>{{ $prospects_b['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
            $prospects_c = json_decode($datas->prospects_c, true);
            @endphp
            <td>c</td>
               <td></td>
            <td></td>
            <td>Policy support on market rates </td>
            <td>{{ $prospects_c['value'] ?? '' }}</td>
            <td>{{ $prospects_c['remark'] ?? '' }}</td>
         </tr> 
         
        </tbody>
  </table>
  
        
    </div>
    @endforeach
    @else
        <div class="table-responsive">
           <h3>A  . Infrastructure and Support Services</h3>
        <table class="table table-bordered">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Unit Rate</th>
            <th>Amt (Rs.)</th>
            <th>Annualized Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
            <td></td>
            <td></td>
            <td>Cost of establishment of Input Shop</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
          </tr>
          <tr>
            <td>2</td>
            <td></td>
            <td></td>
                        <td>Cost Storage Structure for Inputs</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>3</td>
            <td></td>
            <td></td>
            <td>Cost other Infrastructure for Inputs</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
           </tr>
            
         <tr>
            <td>4</td>
            <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
          </tr>
          
          
          <tr>
            <td>5</td>
            <td></td>
            <td></td>
            <td>Monthly Expenses on Manpower</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
           </tr>
          
           <tr>
            <td>6</td>
            <td></td>
            <td></td>
            <td>Monthly rent ( If shop is on rent)</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
           </tr>
           
            <tr>
            <td>7</td>
            <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
           </tr>
           
            <tr>
            <td>8</td>
            <td></td>
            <td></td>
            <td>Any Other</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
           </tr>
           
          <!-- Continue adding rows -->
          <tr>
            <td>9</td>
            <td></td>
            <td></td>
            <td>Annual Intt. on Capital Investment</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          <tr>
            <td colspan="7" class=" text-center" style="font-weight:700;">Total Fixed Cost of Input Supplier</td>
          </tr>
          <tr>
            <td>11</td>
            <td></td>
            <td></td>
            <td>Annual Intt. on Working Capital</td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
          
         <tr>
            <td>12</td>
            <td></td>
            <td></td>
            <td>Percentage of Inputs on credit to farmer</td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>13</td>
            <td></td>
            <td></td>
            <td>Duration of Inputs on credit to farmer</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>14</td>
            <td></td>
            <td></td>
            <td>Extent of Credit Default</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>15</td>
            <td></td>
            <td></td>
            <td>Technical Advisory services ( Y/N)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
          
          <!-- Continue adding rows for other data points -->
          <tr>
            <td>16</td>
            <td></td>
            <td></td>
            <td>Any other Information</td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
        </tbody>
  </table>
        </div>
        </div>
    
        <div class="table-responsive" style="margin-top:40px;">
        <h3>B . Business Economics</h3>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Type of inputs</th>
            <th>Unit</th>
            <th>Average Cost of purchase</th>
            <th>Average Cost of value addition</th>
            <th>Average Sale Price</th>
            <th>Operational Margins (min & Max)</th>
            <th>Seasonal quantum of sale </th>
            <th>Extent of credit default</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
            <td></td>
            <td></td>
            <td>Seed</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
              <td></td>
               <td></td>
          </tr>
          <tr>
            <td>2</td>
            <td></td>
            <td></td>
            <td>Fertilizer</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
              <td></td>
            <td></td>
            <td></td>
          </tr>
          <tr>
            <td>3</td>
            <td></td>
            <td></td>
            <td>Nutrients</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
       
          <tr>
            <td>4</td>
            <td></td>
            <td></td>
            <td>Insecticide / Pesticides / Herbicides</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
        <tr>
            <td>5</td>
            <td></td>
            <td></td>
            <td>FM- Custom and Hiring Services</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
          <tr>
            <td>6</td>
            <td></td>
            <td></td>
            <td>Fingerling (fishery)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>7</td>
            <td></td>
            <td></td>
            <td>DOCs (Poultry)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>8</td>
            <td></td>
            <td></td>
            <td>Plantlets (Horticulture)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>9</td>
            <td></td>
            <td></td>
            <td>Feeds supply</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
           <tr>
            <td>10</td>
            <td></td>
            <td></td>
            <td>Medicines</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
            <tr>
            <td>11</td>
            <td></td>
            <td></td>
            <td>Consultancy</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
          </tr>
          
        </tbody>
  </table>
    </div>

        <div class="table-responsive" style="margin-top:40px;">
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">C . Other Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
        </div>
        
        <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
               <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Indicative / Illustrative Issues / Constraints*</th>
            <th>Quantitative / Qualitative Indicators</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">General</td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Farmer who has taken inputs on Credit, next time they will purchase inputs in other shops</td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Delay in collection of credits if farmer produce rates are very low</td>
            <td></td>
            <td></td>
         </tr>  
         
          <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Transportation losses</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>2</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Challenge</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Prise variations compare to other shops</td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Farmers will purchase based on results</td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Marketing of new products launched by company</td>
            <td></td>
            <td></td>
         </tr> 
         
         
         <tr>
            <td>d</td>
               <td></td>
            <td></td>
            <td>Credit business compulsory</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>3</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Risk</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>100% credits collection not possible</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Same company will give inputs on cash basis</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Competition on Product Prise variations compare to other shops</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>d</td>
               <td></td>
            <td></td>
            <td>Farmers will purchase inputs next time  based on results he will get in his field</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>e</td>
               <td></td>
            <td></td>
            <td>Extent of expiry of inputs</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>f</td>
               <td></td>
            <td></td>
            <td>Any other</td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>4</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Prospects</td>
            <td></td>
            <td></td>
         </tr> 
         
         
        <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Timely/Regular  supply of inputs from company</td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Cash and carry business</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Policy support on market rates </td>
            <td></td>
            <td></td>
         </tr> 
         
        </tbody>
  </table>
  
        
    </div>
    @endif
    
    
</div>

    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>

@endsection