<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>
@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
             @if($deshboard == 1)
        
            @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.four') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.f.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            @endif
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Forward Linkages</h1>
        </div>
        
        @if($data->isNotEmpty())
        @php
            $si = 1;
        @endphp
        @foreach($data as $datas)
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Farm Gate</th>
              <th>Procurement Centre through MSP</th>
              <th>Village Trader</th>
              <th>Mandi (Wholesaler) </th>
              <th>Processor</th>
              <th>Distributor</th>
              <th>Retailer </th>
              <th>Consumer</th>
              <th>Any other Institution </th>
          </thead>
          
          
         
            <tr>
                <td style="text-align:center;">
                    {{ $si++ }}
                </td>

                <td>{{$datas->farmer_code_id}} </td>
                <td> {{$datas->farmer_first_name == 'null' ? '' : $datas->farmer_first_name.' '.$datas->farmer_last_name}}</td>
                <td>
                    Marketing channel (Purchaser)
                </td>
                @php
                $marketingchannel = json_decode($datas->marketing_channel, true);
                @endphp
                <td>{{ $marketingchannel['unit'] ?? '' }}</td>
                <td>{{ $marketingchannel['farm_gate'] ?? '' }}</td>
                <td>{{ $marketingchannel['msp'] ?? '' }}</td>
                <td>{{ $marketingchannel['village_trader'] ?? '' }}</td>
                <td>{{ $marketingchannel['mandi'] ?? '' }}</td>
                <td>{{ $marketingchannel['processor'] ?? '' }}</td>
                <td>{{ $marketingchannel['distributor'] ?? '' }}</td>
                <td>{{ $marketingchannel['retailer'] ?? '' }}</td>
                <td>{{ $marketingchannel['consumer'] ?? '' }}</td>
                <td>{{ $marketingchannel['any_others'] ?? '' }}</td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
              
                <td></td>
                <td></td>
                  <td>
                   Distance of marketing channel from farm gate
                </td>
                @php
                $marketingchanneldistance = json_decode($datas->marketing_channel_distance, true);
                @endphp
                 <td>{{ $marketingchanneldistance['unit'] ?? '' }}</td>
                <td>{{ $marketingchanneldistance['farm_gate'] ?? '' }}</td>
                <td>{{ $marketingchanneldistance['msp'] ?? '' }}</td>
                <td>{{ $marketingchanneldistance['village_trader'] ?? '' }}</td>
                <td>{{ $marketingchanneldistance['mandi'] ?? '' }}</td>
                <td>{{ $marketingchanneldistance['processor'] ?? '' }}</td>
                <td>{{ $marketingchanneldistance['distributor'] ?? '' }}</td>
                <td>{{ $marketingchanneldistance['retailer'] ?? '' }}</td>
                <td>{{ $marketingchanneldistance['consumer'] ?? '' }}</td>
                <td>{{ $marketingchanneldistance['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                <td></td>
                <td></td>
                 <td>
                    Transportation 
                </td>
                
                @php
                $transportationmethod = json_decode($datas->transportation_method, true);
                @endphp
                 <td>{{ $transportationmethod['unit'] ?? '' }}</td>
                <td>{{ $transportationmethod['farm_gate'] ?? '' }}</td>
                <td>{{ $transportationmethod['msp'] ?? '' }}</td>
                <td>{{ $transportationmethod['village_trader'] ?? '' }}</td>
                <td>{{ $transportationmethod['mandi'] ?? '' }}</td>
                <td>{{ $transportationmethod['processor'] ?? '' }}</td>
                <td>{{ $transportationmethod['distributor'] ?? '' }}</td>
                <td>{{ $transportationmethod['retailer'] ?? '' }}</td>
                <td>{{ $transportationmethod['consumer'] ?? '' }}</td>
                <td>{{ $transportationmethod['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
                
                <td></td>
                <td></td>
                <td>
                   Transport through
                </td>
                @php
                $transportby = json_decode($datas->transport_by, true);
                @endphp
                 <td>{{ $transportby['unit'] ?? '' }}</td>
                <td>{{ $transportby['farm_gate'] ?? '' }}</td>
                <td>{{ $transportby['msp'] ?? '' }}</td>
                <td>{{ $transportby['village_trader'] ?? '' }}</td>
                <td>{{ $transportby['mandi'] ?? '' }}</td>
                <td>{{ $transportby['processor'] ?? '' }}</td>
                <td>{{ $transportby['distributor'] ?? '' }}</td>
                <td>{{ $transportby['retailer'] ?? '' }}</td>
                <td>{{ $transportby['consumer'] ?? '' }}</td>
                <td>{{ $transportby['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    5
                </td>

                <td></td>
                <td></td>
                <td>
                  Transport Expenses / Charges 
                </td>
                
                @php
                $transportexpenses = json_decode($datas->transport_expenses, true);
                @endphp
                 <td>{{ $transportexpenses['unit'] ?? '' }}</td>
                <td>{{ $transportexpenses['farm_gate'] ?? '' }}</td>
                <td>{{ $transportexpenses['msp'] ?? '' }}</td>
                <td>{{ $transportexpenses['village_trader'] ?? '' }}</td>
                <td>{{ $transportexpenses['mandi'] ?? '' }}</td>
                <td>{{ $transportexpenses['processor'] ?? '' }}</td>
                <td>{{ $transportexpenses['distributor'] ?? '' }}</td>
                <td>{{ $transportexpenses['retailer'] ?? '' }}</td>
                <td>{{ $transportexpenses['consumer'] ?? '' }}</td>
                <td>{{ $transportexpenses['any_others'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    6
                </td>
              
                <td></td>
                <td></td>
                  <td>
                  Who undertake primary Processing (Cleaning, Grading & Sorting)
                </td>
                 @php
                $primaryprocessing = json_decode($datas->primary_processing, true);
                @endphp
                 <td>{{ $primaryprocessing['unit'] ?? '' }}</td>
                <td>{{ $primaryprocessing['farm_gate'] ?? '' }}</td>
                <td>{{ $primaryprocessing['msp'] ?? '' }}</td>
                <td>{{ $primaryprocessing['village_trader'] ?? '' }}</td>
                <td>{{ $primaryprocessing['mandi'] ?? '' }}</td>
                <td>{{ $primaryprocessing['processor'] ?? '' }}</td>
                <td>{{ $primaryprocessing['distributor'] ?? '' }}</td>
                <td>{{ $primaryprocessing['retailer'] ?? '' }}</td>
                <td>{{ $primaryprocessing['consumer'] ?? '' }}</td>
                <td>{{ $primaryprocessing['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    7
                </td>
                
                
                <td></td>
                <td></td>
                <td>
                 Whether any assured buyer/institution present?
                </td>
                 @php
                 $buyerinstitutionpresent = json_decode($datas->buyer_institution_present, true);
                @endphp
                 <td>{{ $buyerinstitutionpresent['unit'] ?? '' }}</td>
                <td>{{ $buyerinstitutionpresent['farm_gate'] ?? '' }}</td>
                <td>{{ $buyerinstitutionpresent['msp'] ?? '' }}</td>
                <td>{{ $buyerinstitutionpresent['village_trader'] ?? '' }}</td>
                <td>{{ $buyerinstitutionpresent['mandi'] ?? '' }}</td>
                <td>{{ $buyerinstitutionpresent['processor'] ?? '' }}</td>
                <td>{{ $buyerinstitutionpresent['distributor'] ?? '' }}</td>
                <td>{{ $buyerinstitutionpresent['retailer'] ?? '' }}</td>
                <td>{{ $buyerinstitutionpresent['consumer'] ?? '' }}</td>
                <td>{{ $buyerinstitutionpresent['any_others'] ?? '' }}</td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Whether any form of formal or informal contract farming is being practiced by the farmer? 
                </td>
               @php
                 $formalinformalcontract = json_decode($datas->formal_informal_contract, true);
                @endphp
                 <td>{{ $formalinformalcontract['unit'] ?? '' }}</td>
                <td>{{ $formalinformalcontract['farm_gate'] ?? '' }}</td>
                <td>{{ $formalinformalcontract['msp'] ?? '' }}</td>
                <td>{{ $formalinformalcontract['village_trader'] ?? '' }}</td>
                <td>{{ $formalinformalcontract['mandi'] ?? '' }}</td>
                <td>{{ $formalinformalcontract['processor'] ?? '' }}</td>
                <td>{{ $formalinformalcontract['distributor'] ?? '' }}</td>
                <td>{{ $formalinformalcontract['retailer'] ?? '' }}</td>
                <td>{{ $formalinformalcontract['consumer'] ?? '' }}</td>
                <td>{{ $formalinformalcontract['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    9
                </td>
            
                <td></td>
                <td></td>
                <td>
                  Presence of Niche Market (big hotels/residential institutions near the farm gate). 
                </td>
                 @php
                 $nichemarket = json_decode($datas->niche_market, true);
                 @endphp
                 <td>{{ $nichemarket['unit'] ?? '' }}</td>
                <td>{{ $nichemarket['farm_gate'] ?? '' }}</td>
                <td>{{ $nichemarket['msp'] ?? '' }}</td>
                <td>{{ $nichemarket['village_trader'] ?? '' }}</td>
                <td>{{ $nichemarket['mandi'] ?? '' }}</td>
                <td>{{ $nichemarket['processor'] ?? '' }}</td>
                <td>{{ $nichemarket['distributor'] ?? '' }}</td>
                <td>{{ $nichemarket['retailer'] ?? '' }}</td>
                <td>{{ $nichemarket['consumer'] ?? '' }}</td>
                <td>{{ $nichemarket['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    10
                </td>

                <td></td>
                <td></td>
                <td style="font-weight:700;">
                Whether secondary processing being undertaken presently (value addition, packaging, marketing, etc.)
                </td>
                 @php
                 $secondaryprocessing = json_decode($datas->secondary_processing, true);
                @endphp
                 <td>{{ $secondaryprocessing['unit'] ?? '' }}</td>
                <td>{{ $secondaryprocessing['farm_gate'] ?? '' }}</td>
                <td>{{ $secondaryprocessing['msp'] ?? '' }}</td>
                <td>{{ $secondaryprocessing['village_trader'] ?? '' }}</td>
                <td>{{ $secondaryprocessing['mandi'] ?? '' }}</td>
                <td>{{ $secondaryprocessing['processor'] ?? '' }}</td>
                <td>{{ $secondaryprocessing['distributor'] ?? '' }}</td>
                <td>{{ $secondaryprocessing['retailer'] ?? '' }}</td>
                <td>{{ $secondaryprocessing['consumer'] ?? '' }}</td>
                <td>{{ $secondaryprocessing['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    11
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Presence of any processing plant or food enterprise in the vicinity of farm gate
                </td>
                 @php
                 $processinginvicinity = json_decode($datas->processing_in_vicinity, true);
                @endphp
                 <td>{{ $processinginvicinity['unit'] ?? '' }}</td>
                <td>{{ $processinginvicinity['farm_gate'] ?? '' }}</td>
                <td>{{ $processinginvicinity['msp'] ?? '' }}</td>
                <td>{{ $processinginvicinity['village_trader'] ?? '' }}</td>
                <td>{{ $processinginvicinity['mandi'] ?? '' }}</td>
                <td>{{ $processinginvicinity['processor'] ?? '' }}</td>
                <td>{{ $processinginvicinity['distributor'] ?? '' }}</td>
                <td>{{ $processinginvicinity['retailer'] ?? '' }}</td>
                <td>{{ $processinginvicinity['consumer'] ?? '' }}</td>
                <td>{{ $processinginvicinity['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    12
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Whether Storage facility available?
                </td>
                 @php
                 $storagefacility = json_decode($datas->storage_facility, true);
                @endphp
                 <td>{{ $storagefacility['unit'] ?? '' }}</td>
                <td>{{ $storagefacility['farm_gate'] ?? '' }}</td>
                <td>{{ $storagefacility['msp'] ?? '' }}</td>
                <td>{{ $storagefacility['village_trader'] ?? '' }}</td>
                <td>{{ $storagefacility['mandi'] ?? '' }}</td>
                <td>{{ $storagefacility['processor'] ?? '' }}</td>
                <td>{{ $storagefacility['distributor'] ?? '' }}</td>
                <td>{{ $storagefacility['retailer'] ?? '' }}</td>
                <td>{{ $storagefacility['consumer'] ?? '' }}</td>
                <td>{{ $storagefacility['any_others'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    13
                </td>
               
               
                <td></td>
                <td></td>
                 <td>
                 Grain Storage / Cold Storage / Controlled Atmospheric Storage
                </td>
                 @php
                 $storage = json_decode($datas->storage, true);
                @endphp
                <td>{{ $storage['unit'] ?? '' }}</td>
                <td>{{ $storage['farm_gate'] ?? '' }}</td>
                <td>{{ $storage['msp'] ?? '' }}</td>
                <td>{{ $storage['village_trader'] ?? '' }}</td>
                <td>{{ $storage['mandi'] ?? '' }}</td>
                <td>{{ $storage['processor'] ?? '' }}</td>
                <td>{{ $storage['distributor'] ?? '' }}</td>
                <td>{{ $storage['retailer'] ?? '' }}</td>
                <td>{{ $storage['consumer'] ?? '' }}</td>
                <td>{{ $storage['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    14
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 If yes, capacity of the facility?
                </td>
                
                @php
                 $facilitycapacity = json_decode($datas->facility_capacity, true);
                @endphp
                <td>{{ $facilitycapacity['unit'] ?? '' }}</td>
                <td>{{ $facilitycapacity['farm_gate'] ?? '' }}</td>
                <td>{{ $facilitycapacity['msp'] ?? '' }}</td>
                <td>{{ $facilitycapacity['village_trader'] ?? '' }}</td>
                <td>{{ $facilitycapacity['mandi'] ?? '' }}</td>
                <td>{{ $facilitycapacity['processor'] ?? '' }}</td>
                <td>{{ $facilitycapacity['distributor'] ?? '' }}</td>
                <td>{{ $facilitycapacity['retailer'] ?? '' }}</td>
                <td>{{ $facilitycapacity['consumer'] ?? '' }}</td>
                <td>{{ $facilitycapacity['any_others'] ?? '' }}</td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    15
                </td>

               
                <td></td>
                <td></td>
                 <td>
                 Charges for storage / cold storage / bulk cooling system / any other preservation system   
                </td>
                @php
                 $storagecharges = json_decode($datas->storage_charges, true);
                @endphp
                <td>{{ $storagecharges['unit'] ?? '' }}</td>
                <td>{{ $storagecharges['farm_gate'] ?? '' }}</td>
                <td>{{ $storagecharges['msp'] ?? '' }}</td>
                <td>{{ $storagecharges['village_trader'] ?? '' }}</td>
                <td>{{ $storagecharges['mandi'] ?? '' }}</td>
                <td>{{ $storagecharges['processor'] ?? '' }}</td>
                <td>{{ $storagecharges['distributor'] ?? '' }}</td>
                <td>{{ $storagecharges['retailer'] ?? '' }}</td>
                <td>{{ $storagecharges['consumer'] ?? '' }}</td>
                <td>{{ $storagecharges['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    16
                </td>
            
                <td></td>
                <td></td>
                
                <td>
                 Storage Duration 
                </td>
              @php
                $storage_duretion = json_decode($datas->storage_duretion, true);
                @endphp
                <td>{{ $storage_duretion['unit'] ?? '' }}</td>
                <td>{{ $storage_duretion['farm_gate'] ?? '' }}</td>
                <td>{{ $storage_duretion['msp'] ?? '' }}</td>
                <td>{{ $storage_duretion['village_trader'] ?? '' }}</td>
                <td>{{ $storage_duretion['mandi'] ?? '' }}</td>
                <td>{{ $storage_duretion['processor'] ?? '' }}</td>
                <td>{{ $storage_duretion['distributor'] ?? '' }}</td>
                <td>{{ $storage_duretion['retailer'] ?? '' }}</td>
                <td>{{ $storage_duretion['consumer'] ?? '' }}</td>
                <td>{{ $storage_duretion['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    17
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Time of sale of produce after harvesting
                </td>
                
                @php
                 $timeofsale = json_decode($datas->time_of_sale, true);
                @endphp
                <td>{{ $timeofsale['unit'] ?? '' }}</td>
                <td>{{ $timeofsale['farm_gate'] ?? '' }}</td>
                <td>{{ $timeofsale['msp'] ?? '' }}</td>
                <td>{{ $timeofsale['village_trader'] ?? '' }}</td>
                <td>{{ $timeofsale['mandi'] ?? '' }}</td>
                <td>{{ $timeofsale['processor'] ?? '' }}</td>
                <td>{{ $timeofsale['distributor'] ?? '' }}</td>
                <td>{{ $timeofsale['retailer'] ?? '' }}</td>
                <td>{{ $timeofsale['consumer'] ?? '' }}</td>
                <td>{{ $timeofsale['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                18
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Type of road connectivity to farm gate 
                </td>
                
                @php
                 $roadconnectivity = json_decode($datas->road_connectivity, true);
                @endphp
                <td>{{ $roadconnectivity['unit'] ?? '' }}</td>
                <td>{{ $roadconnectivity['farm_gate'] ?? '' }}</td>
                <td>{{ $roadconnectivity['msp'] ?? '' }}</td>
                <td>{{ $roadconnectivity['village_trader'] ?? '' }}</td>
                <td>{{ $roadconnectivity['mandi'] ?? '' }}</td>
                <td>{{ $roadconnectivity['processor'] ?? '' }}</td>
                <td>{{ $roadconnectivity['distributor'] ?? '' }}</td>
                <td>{{ $roadconnectivity['retailer'] ?? '' }}</td>
                <td>{{ $roadconnectivity['consumer'] ?? '' }}</td>
                <td>{{ $roadconnectivity['any_others'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    19
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Payment of sale proceed
                </td>
                 @php
                 $paymentofsale = json_decode($datas->payment_of_sale, true);
                @endphp
                <td>{{ $paymentofsale['unit'] ?? '' }}</td>
                <td>{{ $paymentofsale['farm_gate'] ?? '' }}</td>
                <td>{{ $paymentofsale['msp'] ?? '' }}</td>
                <td>{{ $paymentofsale['village_trader'] ?? '' }}</td>
                <td>{{ $paymentofsale['mandi'] ?? '' }}</td>
                <td>{{ $paymentofsale['processor'] ?? '' }}</td>
                <td>{{ $paymentofsale['distributor'] ?? '' }}</td>
                <td>{{ $paymentofsale['retailer'] ?? '' }}</td>
                <td>{{ $paymentofsale['consumer'] ?? '' }}</td>
                <td>{{ $paymentofsale['any_others'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    20
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Extent of default of Payment of total sale value
                </td>
               
               @php
                 $totalsalevalue = json_decode($datas->total_sale_value, true);
                @endphp
                <td>{{ $totalsalevalue['unit'] ?? '' }}</td>
                <td>{{ $totalsalevalue['farm_gate'] ?? '' }}</td>
                <td>{{ $totalsalevalue['msp'] ?? '' }}</td>
                <td>{{ $totalsalevalue['village_trader'] ?? '' }}</td>
                <td>{{ $totalsalevalue['mandi'] ?? '' }}</td>
                <td>{{ $totalsalevalue['processor'] ?? '' }}</td>
                <td>{{ $totalsalevalue['distributor'] ?? '' }}</td>
                <td>{{ $totalsalevalue['retailer'] ?? '' }}</td>
                <td>{{ $totalsalevalue['consumer'] ?? '' }}</td>
                <td>{{ $totalsalevalue['any_others'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    21
                </td>
               
              
                <td></td>
                <td></td>
                  <td>
                    Weighing Method
                </td>
                 @php
                 $weighingmethod = json_decode($datas->weighing_method, true);
                @endphp
                <td>{{ $weighingmethod['unit'] ?? '' }}</td>
                <td>{{ $weighingmethod['farm_gate'] ?? '' }}</td>
                <td>{{ $weighingmethod['msp'] ?? '' }}</td>
                <td>{{ $weighingmethod['village_trader'] ?? '' }}</td>
                <td>{{ $weighingmethod['mandi'] ?? '' }}</td>
                <td>{{ $weighingmethod['processor'] ?? '' }}</td>
                <td>{{ $weighingmethod['distributor'] ?? '' }}</td>
                <td>{{ $weighingmethod['retailer'] ?? '' }}</td>
                <td>{{ $weighingmethod['consumer'] ?? '' }}</td>
                <td>{{ $weighingmethod['any_others'] ?? '' }}</td>
            </tr>
            
         
            
             <tr>
                <td style="text-align:center;">
                22
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Extent of under weighing of whole proceed
                </td>
                @php
                 $extentofunderweighing = json_decode($datas->extent_of_under_weighing, true);
                @endphp
                <td>{{ $extentofunderweighing['unit'] ?? '' }}</td>
                <td>{{ $extentofunderweighing['farm_gate'] ?? '' }}</td>
                <td>{{ $extentofunderweighing['msp'] ?? '' }}</td>
                <td>{{ $extentofunderweighing['village_trader'] ?? '' }}</td>
                <td>{{ $extentofunderweighing['mandi'] ?? '' }}</td>
                <td>{{ $extentofunderweighing['processor'] ?? '' }}</td>
                <td>{{ $extentofunderweighing['distributor'] ?? '' }}</td>
                <td>{{ $extentofunderweighing['retailer'] ?? '' }}</td>
                <td>{{ $extentofunderweighing['consumer'] ?? '' }}</td>
                <td>{{ $extentofunderweighing['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                23
                </td>
                
                <td></td>
                <td></td>
                <td>
               Source of Market Information (Demand / Price etc.)
                </td>
                 @php
                 $source_of_market_info = json_decode($datas->source_of_market_info, true);
                @endphp
                <td>{{ $source_of_market_info['unit'] ?? '' }}</td>
                <td>{{ $source_of_market_info['farm_gate'] ?? '' }}</td>
                <td>{{ $source_of_market_info['msp'] ?? '' }}</td>
                <td>{{ $source_of_market_info['village_trader'] ?? '' }}</td>
                <td>{{ $source_of_market_info['mandi'] ?? '' }}</td>
                <td>{{ $source_of_market_info['processor'] ?? '' }}</td>
                <td>{{ $source_of_market_info['distributor'] ?? '' }}</td>
                <td>{{ $source_of_market_info['retailer'] ?? '' }}</td>
                <td>{{ $source_of_market_info['consumer'] ?? '' }}</td>
                <td>{{ $source_of_market_info['any_others'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                24  
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Percentage of sale of total marketable surplus through MSP
                </td>
               
                 @php
                 $totalmarketablesurplus = json_decode($datas->total_marketable_surplus, true);
                @endphp
                <td>{{ $totalmarketablesurplus['unit'] ?? '' }}</td>
                <td>{{ $totalmarketablesurplus['farm_gate'] ?? '' }}</td>
                <td>{{ $totalmarketablesurplus['msp'] ?? '' }}</td>
                <td>{{ $totalmarketablesurplus['village_trader'] ?? '' }}</td>
                <td>{{ $totalmarketablesurplus['mandi'] ?? '' }}</td>
                <td>{{ $totalmarketablesurplus['processor'] ?? '' }}</td>
                <td>{{ $totalmarketablesurplus['distributor'] ?? '' }}</td>
                <td>{{ $totalmarketablesurplus['retailer'] ?? '' }}</td>
                <td>{{ $totalmarketablesurplus['consumer'] ?? '' }}</td>
                <td>{{ $totalmarketablesurplus['any_others'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                25
                </td>
            
                <td></td>
                <td></td>
                    <td>
               Is producer directly selling to MSP procurement agency or through mediator
                </td>
                 @php
                 $sellingonmsp = json_decode($datas->selling_on_msp, true);
                @endphp
                <td>{{ $sellingonmsp['unit'] ?? '' }}</td>
                <td>{{ $sellingonmsp['farm_gate'] ?? '' }}</td>
                <td>{{ $sellingonmsp['msp'] ?? '' }}</td>
                <td>{{ $sellingonmsp['village_trader'] ?? '' }}</td>
                <td>{{ $sellingonmsp['mandi'] ?? '' }}</td>
                <td>{{ $sellingonmsp['processor'] ?? '' }}</td>
                <td>{{ $sellingonmsp['distributor'] ?? '' }}</td>
                <td>{{ $sellingonmsp['retailer'] ?? '' }}</td>
                <td>{{ $sellingonmsp['consumer'] ?? '' }}</td>
                <td>{{ $sellingonmsp['any_others'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                26
                </td>
               
                <td></td>
                <td></td>
                 <td>
               If No, extent of getting MSP price
                </td>
               @php
                 $extentofmspprice = json_decode($datas->extent_of_msp_price, true);
                @endphp
                <td>{{ $extentofmspprice['unit'] ?? '' }}</td>
                <td>{{ $extentofmspprice['farm_gate'] ?? '' }}</td>
                <td>{{ $extentofmspprice['msp'] ?? '' }}</td>
                <td>{{ $extentofmspprice['village_trader'] ?? '' }}</td>
                <td>{{ $extentofmspprice['mandi'] ?? '' }}</td>
                <td>{{ $extentofmspprice['processor'] ?? '' }}</td>
                <td>{{ $extentofmspprice['distributor'] ?? '' }}</td>
                <td>{{ $extentofmspprice['retailer'] ?? '' }}</td>
                <td>{{ $extentofmspprice['consumer'] ?? '' }}</td>
                <td>{{ $extentofmspprice['any_others'] ?? '' }}</td>
            </tr>
            
        </table>
        @endforeach
        @else
         <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Farm Gate</th>
              <th>Procurement Centre through MSP</th>
              <th>Village Trader</th>
              <th>Mandi (Wholesaler) </th>
              <th>Processor</th>
              <th>Distributor</th>
              <th>Retailer </th>
              <th>Consumer</th>
              <th>Any other Institution </th>
          </thead>
          
          
         
            <tr>
                <td style="text-align:center;">
                    1
                </td>

                <td> </td>
                <td> </td>
                <td>
                    Marketing channel (Purchaser)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
              
                <td></td>
                <td></td>
                  <td>
                   Distance of marketing channel from farm gate
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
               
                <td></td>
                <td></td>
                 <td>
                    Transportation 
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
                
                <td></td>
                <td></td>
                <td>
                   Transport through
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    5
                </td>

                <td></td>
                <td></td>
                <td>
                  Transport Expenses / Charges 
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    6
                </td>
              
                <td></td>
                <td></td>
                  <td>
                  Who undertake primary Processing (Cleaning, Grading & Sorting)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    7
                </td>
                
                
                <td></td>
                <td></td>
                <td>
                 Whether any assured buyer/institution present?
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Whether any form of formal or informal contract farming is being practiced by the farmer? 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    9
                </td>
            
                <td></td>
                <td></td>
                    <td>
               Presence of Niche Market big hotels/residential institutions near the farm gate. 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    10
                </td>

                <td></td>
                <td></td>
                <td style="font-weight:700;">
                Whether secondary processing being undertaken presently (value addition, packaging, marketing, etc.)
                </td>
                Presence of Niche Market big hotels/residential institutions near the farm gate. 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    11
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Presence of any processing plant or food enterprise in the vicinity of farm gate
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    12
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Whether Storage facility available?
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    13
                </td>
               
               
                <td></td>
                <td></td>
                 <td>
                 Grain Storage / Cold Storage / Controlled Atmospheric Storage
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    14
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 If yes, capacity of the facility?
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    15
                </td>

               
                <td></td>
                <td></td>
                 <td>
                 Charges for storage / cold storage / bulk cooling system / any other preservation system   
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    16
                </td>
            
                <td></td>
                <td></td>
                    <td>
                 Storage Duration 
                </td>
                
                <td>
                 Day/ Month / Year
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    17
                </td>
             
                <td></td>
                <td></td>
                   <td>
               Time of sale of produce after harvesting
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                18
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Type of road connectivity to farm gate 
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    19
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Payment of sale proceed
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    20
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Extent of default of Payment of total sale value
                </td>
               
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    21
                </td>
               
              
                <td></td>
                <td></td>
                  <td>
                    Weighing Method
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
         
            
             <tr>
                <td style="text-align:center;">
                22
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Extent of under weighing of whole proceed
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                23
                </td>
                
                <td></td>
                <td></td>
                <td>
               Source of Market Information (Demand / Price etc.)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                24  
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Percentage of sale of total marketable surplus through MSP
                </td>
               
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                25
                </td>
            
                <td></td>
                <td></td>
                    <td>
               Is producer directly selling to MSP procurement agency or through mediator
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                26
                </td>
               
                <td></td>
                <td></td>
                 <td>
               If No, extent of getting MSP price
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
        </table>
         
       @endif


    </div>


    <div class="table-responsive mt-5">
        
       
        
    </div>

</div>

@endsection