<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>
@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

<div class="container-fluid">
     <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            @if($deshboard == 1)
        
            @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.eight') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.eight.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            @endif
        </div>
       
         <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800"></h1>
           
        </div>
         <h2>A. Infrastructure, Operational and Qualitative characteristics of Processing Units </h2>
    @php
     $si=1;
    @endphp
    @foreach($data as $datas)
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Primary Processing</th>
             <th>Secondary Processing</th>
             <th>Tertiary Processing</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
               @php
                $establishment = json_decode($datas->establishment, true);
               @endphp
            <td>{{$si++}}</td>
             <td>{{$datas->farmer_code_id}}</td>
            <td>{{$datas->first_name}} {{$datas->last_name}}</td>
            <td>Cost of Establishment</td>
            <td>{{ $establishment['primary_unit'] ?? '' }}</td>
            <td> {{ $establishment['primary'] ?? '' }}</td>
            <td>{{ $establishment['secondary'] ?? '' }}</td>
            <td>{{ $establishment['tertiary'] ?? '' }}</td>
            <td>{{ $establishment['remarks'] ?? '' }}</td>
         </tr>   
         
         <tr>
             @php
                $storage = json_decode($datas->storage, true);
               @endphp
            <td>2</td>
             <td></td>
            <td></td>
            <td>Cost of Storage Structure </td>
            <td>{{ $storage['primary_unit'] ?? '' }}</td>
            <td> {{ $storage['primary'] ?? '' }}</td>
            <td>{{ $storage['secondary'] ?? '' }}</td>
            <td>{{ $storage['tertiary'] ?? '' }}</td>
            <td>{{ $storage['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
              @php
                $plant_machinery = json_decode($datas->plant_machinery, true);
               @endphp
            <td>3</td>
             <td></td>
            <td></td>
            <td>Cost of Plant and Machineries for processing</td>
            <td>{{ $plant_machinery['primary_unit'] ?? '' }}</td>
            <td> {{ $plant_machinery['primary'] ?? '' }}</td>
            <td>{{ $plant_machinery['secondary'] ?? '' }}</td>
            <td>{{ $plant_machinery['tertiary'] ?? '' }}</td>
            <td>{{ $plant_machinery['remarks'] ?? '' }}</td>
         </tr>  
         
          <tr>
             @php
               $electric_anual_ex = json_decode($datas->electricity_annual_expense, true);
             @endphp
            <td>4</td>
             <td></td>
            <td></td>
            <td>Annual Expenses on Electricity</td>
            <td>{{ $electric_anual_ex['primary_unit'] ?? '' }}</td>
            <td> {{ $electric_anual_ex['primary'] ?? '' }}</td>
            <td>{{ $electric_anual_ex['secondary'] ?? '' }}</td>
            <td>{{ $electric_anual_ex['tertiary'] ?? '' }}</td>
            <td>{{ $electric_anual_ex['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
               $elec_manpow = json_decode($datas->manpower_annual_expense, true);
             @endphp
            <td>5</td>
             <td></td>
            <td></td>
            <td >Annual Expenses on Manpower</td>
             <td>{{ $elec_manpow['primary_unit'] ?? '' }}</td>
            <td> {{ $elec_manpow['primary'] ?? '' }}</td>
            <td>{{ $elec_manpow['secondary'] ?? '' }}</td>
            <td>{{ $elec_manpow['tertiary'] ?? '' }}</td>
            <td>{{ $elec_manpow['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
               $rent_annual = json_decode($datas->rent_annual, true);
             @endphp
            <td>6</td>
             <td></td>
            <td></td>
            <td>Annual rent ( If establishment is on rent)</td>
           <td>{{ $rent_annual['primary_unit'] ?? '' }}</td>
            <td> {{ $rent_annual['primary'] ?? '' }}</td>
            <td>{{ $rent_annual['secondary'] ?? '' }}</td>
            <td>{{ $rent_annual['tertiary'] ?? '' }}</td>
            <td>{{ $rent_annual['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
               @php
               $tra_annual = json_decode($datas->travelling_expense_annual, true);
             @endphp
            <td>7</td>
             <td></td>
            <td></td>
            <td>Annual Travelling Expense </td>
            <td>{{ $tra_annual['primary_unit'] ?? '' }}</td>
            <td> {{ $tra_annual['primary'] ?? '' }}</td>
            <td>{{ $tra_annual['secondary'] ?? '' }}</td>
            <td>{{ $tra_annual['tertiary'] ?? '' }}</td>
            <td>{{ $tra_annual['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
             @php
               $insucost_annual = json_decode($datas->insurance_cost_annual, true);
             @endphp
            <td>8</td>
             <td></td>
            <td></td>
            <td>Annual Insurance cost</td>
             <td>{{ $insucost_annual['primary_unit'] ?? '' }}</td>
            <td> {{ $insucost_annual['primary'] ?? '' }}</td>
            <td>{{ $insucost_annual['secondary'] ?? '' }}</td>
            <td>{{ $insucost_annual['tertiary'] ?? '' }}</td>
            <td>{{ $insucost_annual['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
              @php
               $admin_cost = json_decode($datas->misc_admin_cost_annual, true);
             @endphp
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Miscellaneous Admin cost</td>
           <td>{{ $admin_cost['primary_unit'] ?? '' }}</td>
            <td> {{ $admin_cost['primary'] ?? '' }}</td>
            <td>{{ $admin_cost['secondary'] ?? '' }}</td>
            <td>{{ $admin_cost['tertiary'] ?? '' }}</td>
            <td>{{ $admin_cost['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
            $capital_investment_interest = json_decode($datas->capital_investment_interest, true);
            @endphp
            <td>10</td>
             <td></td>
            <td></td>
            <td >Interest payment on Capital investment</td>
            <td>Rs. in Lakh</td>
           <td> {{ $capital_investment_interest['primary'] ?? '' }}</td>
            <td>{{ $capital_investment_interest['secondary'] ?? '' }}</td>
            <td>{{ $capital_investment_interest['tertiary'] ?? '' }}</td>
            <td>{{ $capital_investment_interest['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
            <td>11</td>
             <td></td>
            <td></td>
            <td>Any other Fixed Cost</td>
            <td>Rs. in Lakh</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        @php
        $sumprimary = 
            (float)($establishment['primary'] ?? 0) +  
            (float)($storage['primary'] ?? 0) + 
            (float)($plant_machinery['primary'] ?? 0) + 
            (float)($electric_anual_ex['primary'] ?? 0) + 
            (float)($elec_manpow['primary'] ?? 0) + 
            (float)($rent_annual['primary'] ?? 0) + 
            (float)($tra_annual['primary'] ?? 0) + 
            (float)($insucost_annual['primary'] ?? 0) + 
            (float)($admin_cost['primary'] ?? 0) + 
            (float)($capital_investment_interest['primary'] ?? 0) + 
            (float)($diseal_engine['primary'] ?? 0) + 
            (float)($tractor['primary'] ?? 0) + 
            (float)($any_ot['primary'] ?? 0);

        $sumsecondary = 
            (float)($establishment['secondary'] ?? 0) +  
            (float)($storage['secondary'] ?? 0) + 
            (float)($plant_machinery['secondary'] ?? 0) + 
            (float)($electric_anual_ex['secondary'] ?? 0) + 
            (float)($elec_manpow['secondary'] ?? 0) + 
            (float)($rent_annual['secondary'] ?? 0) + 
            (float)($tra_annual['secondary'] ?? 0) + 
            (float)($insucost_annual['secondary'] ?? 0) + 
            (float)($admin_cost['secondary'] ?? 0) + 
            (float)($capital_investment_interest['secondary'] ?? 0) + 
            (float)($diseal_engine['secondary'] ?? 0) + 
            (float)($tractor['secondary'] ?? 0) + 
            (float)($any_ot['secondary'] ?? 0);
            
            $sumtertiary = 
            (float)($establishment['tertiary'] ?? 0) +  
            (float)($storage['tertiary'] ?? 0) + 
            (float)($plant_machinery['tertiary'] ?? 0) + 
            (float)($electric_anual_ex['tertiary'] ?? 0) + 
            (float)($elec_manpow['tertiary'] ?? 0) + 
            (float)($rent_annual['tertiary'] ?? 0) + 
            (float)($tra_annual['tertiary'] ?? 0) + 
            (float)($insucost_annual['tertiary'] ?? 0) + 
            (float)($admin_cost['tertiary'] ?? 0) + 
            (float)($capital_investment_interest['tertiary'] ?? 0) + 
            (float)($diseal_engine['tertiary'] ?? 0) + 
            (float)($tractor['tertiary'] ?? 0) + 
            (float)($any_ot['tertiary'] ?? 0);
    @endphp


            

         
          <tr>
            <td></td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of Processor</td>
            <td></td>
            <td style="font-weight:700;">{{$sumprimary}}</td>
            <td style="font-weight:700;">{{$sumsecondary}}</td>
            <td style="font-weight:700;">{{$sumtertiary}}</td>
            <td></td>
         </tr>
         
          <tr>
              @php
                $working_capital_interest = json_decode($datas->working_capital_interest, true);
                @endphp
            <td>14</td>
             <td></td>
            <td></td>
            <td>Interest payment on Working Capital</td>
            <td>Rs. in Lakh</td>
               <td> {{ $working_capital_interest['primary'] ?? '' }}</td>
                <td>{{ $working_capital_interest['secondary'] ?? '' }}</td>
                <td>{{ $working_capital_interest['tertiary'] ?? '' }}</td>
                <td>{{ $working_capital_interest['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
                $repairmdata = json_decode($datas->repair_maintenance_annual, true);
                @endphp
            <td>15</td>
             <td></td>
            <td></td>
            <td>Annual Repair and Maintenance cost</td>
            <td>Rs. in Lakh</td>
                <td> {{ $repairmdata['primary'] ?? '' }}</td>
                <td>{{ $repairmdata['secondary'] ?? '' }}</td>
                <td>{{ $repairmdata['tertiary'] ?? '' }}</td>
                <td>{{ $repairmdata['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
                $capacity_of_plant_machinery = json_decode($datas->capacity_of_plant_machinery, true);
              @endphp
            <td>16</td>
             <td></td>
            <td></td>
            <td>Capacity of Plant Machinery </td>
            <td>MT / Hour</td>
                <td> {{ $capacity_of_plant_machinery['primary'] ?? '' }}</td>
                <td>{{ $capacity_of_plant_machinery['secondary'] ?? '' }}</td>
                <td>{{ $capacity_of_plant_machinery['tertiary'] ?? '' }}</td>
                <td>{{ $capacity_of_plant_machinery['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
                @php
                $average_operating_capacity_of_machine = json_decode($datas->average_operating_capacity_of_machine, true);
                @endphp
            <td>17</td>
             <td></td>
            <td></td>
            <td>Average operating Capacity of Machine </td>
            <td>MT / Hour</td>
           <td> {{ $average_operating_capacity_of_machine['primary'] ?? '' }}</td>
            <td>{{ $average_operating_capacity_of_machine['secondary'] ?? '' }}</td>
            <td>{{ $average_operating_capacity_of_machine['tertiary'] ?? '' }}</td>
            <td>{{ $average_operating_capacity_of_machine['remarks'] ?? '' }}</td>
         </tr> 
         
         
        <tr>
             @php
            $actual_annual_running_hours = json_decode($datas->actual_annual_running_hours, true);
            @endphp
            <td>18</td>
             <td></td>
            <td></td>
            <td>Actual annual running hours</td>
            <td>Hour</td>
              <td> {{ $actual_annual_running_hours['primary'] ?? '' }}</td>
                <td>{{ $actual_annual_running_hours['secondary'] ?? '' }}</td>
                <td>{{ $actual_annual_running_hours['tertiary'] ?? '' }}</td>
                <td>{{ $actual_annual_running_hours['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
                $annual_processing_of_produce = json_decode($datas->annual_processing_of_produce, true);
                @endphp
            <td>19</td>
             <td></td>
            <td></td>
            <td>Annual processing of produce ( MT)</td>
            <td>MT</td>
           <td> {{ $annual_processing_of_produce['primary'] ?? '' }}</td>
            <td>{{ $annual_processing_of_produce['secondary'] ?? '' }}</td>
            <td>{{ $annual_processing_of_produce['tertiary'] ?? '' }}</td>
            <td>{{ $annual_processing_of_produce['remarks'] ?? '' }}</td>
         </tr> 
         
         
         
          <tr>
            <td>20</td>
             <td></td>
            <td></td>
            <td>Purchase of Raw Material ( Produce) </td>
            <td>Name</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
          <tr>
                @php
            $purchase_of_raw_material_a = json_decode($datas->purchase_of_raw_material_a, true);
            @endphp
            <td>a</td>
             <td></td>
            <td></td>
            <td>Purchase of Raw Material ( Produce) A</td>
            <td></td>
            <td> {{ $purchase_of_raw_material_a['primary'] ?? '' }}</td>
            <td>{{ $purchase_of_raw_material_a['secondary'] ?? '' }}</td>
            <td>{{ $purchase_of_raw_material_a['tertiary'] ?? '' }}</td>
            <td>{{ $purchase_of_raw_material_a['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
            $purchase_of_raw_material_b = json_decode($datas->purchase_of_raw_material_b, true);
            @endphp
            <td>b</td>
             <td></td>
            <td></td>
            <td>Purchase of Raw Material ( Produce) B</td>
            <td></td>
           <td> {{ $purchase_of_raw_material_b['primary'] ?? '' }}</td>
            <td>{{ $purchase_of_raw_material_b['secondary'] ?? '' }}</td>
            <td>{{ $purchase_of_raw_material_b['tertiary'] ?? '' }}</td>
            <td>{{ $purchase_of_raw_material_b['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $purchase_of_raw_material_c = json_decode($datas->purchase_of_raw_material_c, true);
                @endphp
            <td>c</td>
             <td></td>
            <td></td>
            <td>Purchase of Raw Material ( Produce) C</td>
            <td></td>
                <td> {{ $purchase_of_raw_material_c['primary'] ?? '' }}</td>
                <td>{{ $purchase_of_raw_material_c['secondary'] ?? '' }}</td>
                <td>{{ $purchase_of_raw_material_c['tertiary'] ?? '' }}</td>
                <td>{{ $purchase_of_raw_material_c['remarks'] ?? '' }}</td>
         </tr> 
          <tr>
            <td>21</td>
             <td></td>
            <td></td>
            <td>Inbound Channel</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
               @php
                $farmer_village_purchase = json_decode($datas->farmer_village_purchase, true);
               @endphp
            <td>a</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at village Level / Farm Gate</td>
            <td>Y/N with (%)</td>
            <td> {{ $farmer_village_purchase['primary'] ?? '' }}</td>
            <td>{{ $farmer_village_purchase['secondary'] ?? '' }}</td>
            <td>{{ $farmer_village_purchase['tertiary'] ?? '' }}</td>
            <td>{{ $farmer_village_purchase['remarks'] ?? '' }}</td>
         </tr> 
         
        <tr>
              @php
                $local_mandi_purchase = json_decode($datas->local_mandi_purchase, true);
                @endphp 
            <td>b</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi </td>
            <td>Y/N with (%)</td>
            <td> {{ $local_mandi_purchase['primary'] ?? '' }}</td>
            <td>{{ $local_mandi_purchase['secondary'] ?? '' }}</td>
            <td>{{ $local_mandi_purchase['tertiary'] ?? '' }}</td>
            <td>{{ $local_mandi_purchase['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
            @php
            $apmc_purchase = json_decode($datas->apmc_purchase, true);
            @endphp
            <td>c</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at APMC</td>
            <td>Y/N with (%)</td>
            <td> {{ $apmc_purchase['primary'] ?? '' }}</td>
            <td>{{ $apmc_purchase['secondary'] ?? '' }}</td>
            <td>{{ $apmc_purchase['tertiary'] ?? '' }}</td>
            <td>{{ $apmc_purchase['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
               @php
                $commission_agent_purchase = json_decode($datas->commission_agent_purchase, true);
                @endphp
            <td>d</td>
             <td></td>
            <td></td>
            <td>Purchase from Commission Agent </td>
            <td>Y/N with (%)</td>
           <td> {{ $commission_agent_purchase['primary'] ?? '' }}</td>
            <td>{{ $commission_agent_purchase['secondary'] ?? '' }}</td>
            <td>{{ $commission_agent_purchase['tertiary'] ?? '' }}</td>
            <td>{{ $commission_agent_purchase['remarks'] ?? '' }}</td>
         </tr> 
         
        <tr>
            @php
            $wholesaler_purchase = json_decode($datas->wholesaler_purchase, true);
            @endphp
            <td>e</td>
             <td></td>
            <td></td>
            <td>Purchase from Wholesaler  </td>
            <td>Y/N with (%)</td>
           <td> {{ $wholesaler_purchase['primary'] ?? '' }}</td>
            <td>{{ $wholesaler_purchase['secondary'] ?? '' }}</td>
            <td>{{ $wholesaler_purchase['tertiary'] ?? '' }}</td>
            <td>{{ $wholesaler_purchase['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
            @php
            $outside_import = json_decode($datas->outside_import, true);
            @endphp
            <td>g</td>
             <td></td>
            <td></td>
            <td>Import from outside</td>
            <td></td>
             <td> {{ $outside_import['primary'] ?? '' }}</td>
            <td>{{ $outside_import['secondary'] ?? '' }}</td>
            <td>{{ $outside_import['tertiary'] ?? '' }}</td>
            <td>{{ $outside_import['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
               @php
                $primary_processor_purchase = json_decode($datas->primary_processor_purchase, true);
                @endphp
            <td>h</td>
             <td></td>
            <td></td>
            <td>Purchase from Primary Processor </td>
            <td>Y/N with (%)</td>
             <td> {{ $primary_processor_purchase['primary'] ?? '' }}</td>
                <td>{{ $primary_processor_purchase['secondary'] ?? '' }}</td>
                <td>{{ $primary_processor_purchase['tertiary'] ?? '' }}</td>
                <td>{{ $primary_processor_purchase['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
            @php
            $secondary_processor_purchase = json_decode($datas->secondary_processor_purchase, true);
            @endphp
            <td>i</td>
             <td></td>
            <td></td>
            <td>Purchase from Secondary Processor</td>
            <td>Y/N with (%)</td>
           <td> {{ $secondary_processor_purchase['primary'] ?? '' }}</td>
            <td>{{ $secondary_processor_purchase['secondary'] ?? '' }}</td>
            <td>{{ $secondary_processor_purchase['tertiary'] ?? '' }}</td>
            <td>{{ $secondary_processor_purchase['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
             @php
            $prevalent_purchase_mechanism = json_decode($datas->prevalent_purchase_mechanism, true);
            @endphp
            <td>21</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism</td>
            <td>Among (21a) to (21i)</td>
            <td>{{ $prevalent_purchase_mechanism['primary'] ?? '' }}</td>
            <td>{{ $prevalent_purchase_mechanism['secondary'] ?? '' }}</td>
            <td>{{ $prevalent_purchase_mechanism['tertiary'] ?? '' }}</td>
            <td>{{ $prevalent_purchase_mechanism['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
            @php
            $raw_material_regularity = json_decode($datas->raw_material_regularity, true);
            @endphp
            <td>22</td>
             <td></td>
            <td></td>
            <td>Regularity of raw material</td>
            <td>Poor/Good/Excellent</td>
            <td> {{ $raw_material_regularity['primary'] ?? '' }}</td>
            <td>{{ $raw_material_regularity['secondary'] ?? '' }}</td>
            <td>{{ $raw_material_regularity['tertiary'] ?? '' }}</td>
            <td>{{ $raw_material_regularity['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
            @php
            $raw_material_availability = json_decode($datas->raw_material_availability, true);
            @endphp
            <td>23</td>
             <td></td>
            <td></td>
            <td>Availability of raw material </td>
            <td>Poor/Good/Excellent</td>
            <td> {{ $raw_material_availability['primary'] ?? '' }}</td>
            <td>{{ $raw_material_availability['secondary'] ?? '' }}</td>
            <td>{{ $raw_material_availability['tertiary'] ?? '' }}</td>
            <td>{{ $raw_material_availability['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
             @php
            $quality_issue = json_decode($datas->quality_issue, true);
            @endphp
            <td>24</td>
             <td></td>
            <td></td>
            <td>Quality issue</td>
            <td>Poor/Good/Excellent</td>
            <td> {{ $quality_issue['primary'] ?? '' }}</td>
            <td>{{ $quality_issue['secondary'] ?? '' }}</td>
            <td>{{ $quality_issue['tertiary'] ?? '' }}</td>
            <td>{{ $quality_issue['remarks'] ?? '' }}</td>
         </tr>
         
         <tr>
               @php
                $credit_supplier_advice = json_decode($datas->credit_supplier_advice, true);
                @endphp
            <td>25</td>
             <td></td>
            <td></td>
            <td>Any advance credit to supplier</td>
            <td>Y/N with (%)</td>
            <td> {{ $credit_supplier_advice['primary'] ?? '' }}</td>
            <td>{{ $credit_supplier_advice['secondary'] ?? '' }}</td>
            <td>{{ $credit_supplier_advice['tertiary'] ?? '' }}</td>
            <td>{{ $credit_supplier_advice['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
             @php
            $supplier_credit_duration = json_decode($datas->supplier_credit_duration, true);
            @endphp
            <td>26</td>
             <td></td>
            <td></td>
            <td>Supplier credit duration</td>
            <td>Days / Month</td>
             <td> {{ $supplier_credit_duration['primary'] ?? '' }}</td>
            <td>{{ $supplier_credit_duration['secondary'] ?? '' }}</td>
            <td>{{ $supplier_credit_duration['tertiary'] ?? '' }}</td>
            <td>{{ $supplier_credit_duration['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
            @php
            $supplier_payment = json_decode($datas->supplier_payment, true);
            @endphp
            <td>27</td>
             <td></td>
            <td></td>
            <td>Supplier payment in single / multiple </td>
            <td>Single/double/multiple</td>
            <td> {{ $supplier_payment['primary'] ?? '' }}</td>
            <td>{{ $supplier_payment['secondary'] ?? '' }}</td>
            <td>{{ $supplier_payment['tertiary'] ?? '' }}</td>
            <td>{{ $supplier_payment['remarks'] ?? '' }}</td>
         </tr>
         
         
        <tr>
             @php
            $sell_through_distributor = json_decode($datas->sell_through_distributor, true);
            @endphp
            <td>28</td>
             <td></td>
            <td></td>
            <td>Selling to through distributor</td>
            <td>Y/N with (%)</td>
            <td> {{ $sell_through_distributor['primary'] ?? '' }}</td>
            <td>{{ $sell_through_distributor['secondary'] ?? '' }}</td>
            <td>{{ $sell_through_distributor['tertiary'] ?? '' }}</td>
            <td>{{ $sell_through_distributor['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
                 @php
                $sell_through_retailers = json_decode($datas->sell_through_retailers, true);
                @endphp
            <td>29</td>
             <td></td>
            <td></td>
            <td>Selling to through Retailers </td>
            <td>Y/N with (%)</td>
           <td> {{ $sell_through_retailers['primary'] ?? '' }}</td>
            <td>{{ $sell_through_retailers['secondary'] ?? '' }}</td>
            <td>{{ $sell_through_retailers['tertiary'] ?? '' }}</td>
            <td>{{ $sell_through_retailers['remarks'] ?? '' }}</td>
         </tr>
         
         <tr>
             @php
            $sell_through_outlets = json_decode($datas->sell_through_outlets, true);
            @endphp
            <td>30</td>
             <td></td>
            <td></td>
            <td>Selling to through own outlets</td>
            <td>Y/N with (%)</td>
            <td> {{ $sell_through_outlets['primary'] ?? '' }}</td>
            <td>{{ $sell_through_outlets['secondary'] ?? '' }}</td>
            <td>{{ $sell_through_outlets['tertiary'] ?? '' }}</td>
            <td>{{ $sell_through_outlets['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
             @php
            $online_selling = json_decode($datas->online_selling, true);
            @endphp
            <td>31</td>
             <td></td>
            <td></td>
            <td>Online Selling  </td>
            <td>Y/N with (%)</td>
          <td> {{ $online_selling['primary'] ?? '' }}</td>
        <td>{{ $online_selling['secondary'] ?? '' }}</td>
        <td>{{ $online_selling['tertiary'] ?? '' }}</td>
        <td>{{ $online_selling['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
             @php
            $export = json_decode($datas->export, true);
            @endphp
            <td>32</td>
             <td></td>
            <td></td>
            <td>Export</td>
            <td>Y/N with (%)</td>
              <td> {{ $export['primary'] ?? '' }}</td>
            <td>{{ $export['secondary'] ?? '' }}</td>
            <td>{{ $export['tertiary'] ?? '' }}</td>
            <td>{{ $export['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
             @php
            $other_marketing = json_decode($datas->other_marketing, true);
            @endphp
            <td>33</td>
             <td></td>
            <td></td>
            <td>Any other mechanism of marketing</td>
            <td></td>
           <td> {{ $other_marketing['primary'] ?? '' }}</td>
            <td>{{ $other_marketing['secondary'] ?? '' }}</td>
            <td>{{ $other_marketing['tertiary'] ?? '' }}</td>
            <td>{{ $other_marketing['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
              @php
            $supply_on_credit = json_decode($datas->supply_on_credit, true);
            @endphp
            <td>34</td>
             <td></td>
            <td></td>
            <td>Supply on credit </td>
            <td>Y/N with (%)</td>
           <td> {{ $supply_on_credit['primary'] ?? '' }}</td>
            <td>{{ $supply_on_credit['secondary'] ?? '' }}</td>
            <td>{{ $supply_on_credit['tertiary'] ?? '' }}</td>
            <td>{{ $supply_on_credit['remarks'] ?? '' }}</td>
         </tr>
         
           <tr>
            <td>35</td>
             <td></td>
            <td></td>
            <td>Credit duration</td>
            <td>Days / Month</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>
         
           <tr>
                @php
                $other_info = json_decode($datas->other_info, true);
                @endphp
            <td>36</td>
             <td></td>
            <td></td>
            <td>Any other relevant information</td>
            <td></td>
             <td> {{ $other_info['primary'] ?? '' }}</td>
            <td>{{ $other_info['secondary'] ?? '' }}</td>
            <td>{{ $other_info['tertiary'] ?? '' }}</td>
            <td>{{ $other_info['remarks'] ?? '' }}</td>
         </tr>
         
          
         
        </tbody>
  </table>
    @endforeach
    </div>
    <br>
    
    
    @foreach($data1 as $data1)
     <div class="table-responsive">
        <h2>B. Business Economics of Processing Units</h2>

     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Primary Processing</th>
             <th>Secondary Processing</th>
             <th>Tertiary Processing</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>I</td>
             <td>{{$data1->farmer_code_id}}</td>
            <td>{{$data1->first_name}} {{$data1->last_name}}</td>
            <td style="font-weight:700;">Average Purchase Price </td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>
         
        <tr>
            @php
            $average_purchase_price_a = json_decode($data1->average_purchase_price_a, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Raw Produce (Name & Grade)</td>
            <td>{{ $average_purchase_price_a['primary'] ?? '' }} ,
                {{ $average_purchase_price_a['secondary'] ?? '' }} ,
                {{ $average_purchase_price_a['tertiary'] ?? '' }}
            </td>
            <td>
                 Processing : {{ $average_purchase_price_a['primary_unit'] ?? '' }} ,
                 Name : {{ $average_purchase_price_a['primary_name'] ?? '' }} ,
                 Grade : {{ $average_purchase_price_a['primary_grade'] ?? '' }}
            </td>
        
            <td>
                 Processing : {{ $average_purchase_price_a['secondary_unit'] ?? '' }} ,
                 Name : {{ $average_purchase_price_a['secondary_name'] ?? '' }} ,
                 Grade : {{ $average_purchase_price_a['secondary_grade'] ?? '' }}
            </td>
        
            <td>
                 Processing : {{ $average_purchase_price_a['tertiary_unit'] ?? '' }} ,
                 Name : {{ $average_purchase_price_a['tertiary_name'] ?? '' }} ,
                 Grade : {{ $average_purchase_price_a['tertiary_grade'] ?? '' }}
            </td>
            <td>{{ $average_purchase_price_a['remarks'] ?? '' }}</td>
        </tr>
         
        <tr>
    @php
    $average_purchase_price_b = json_decode($data1->average_purchase_price_b, true);
    @endphp
    <td></td>
    <td></td>
    <td></td>
    <td>Raw Produce (Name & Grade)</td>
    <td>{{ $average_purchase_price_b['primary'] ?? '' }} ,
        {{ $average_purchase_price_b['secondary'] ?? '' }} ,
        {{ $average_purchase_price_b['tertiary'] ?? '' }}
    </td>
    <td>
        Processing : {{ $average_purchase_price_b['primary_unit'] ?? '' }} ,
        Name : {{ $average_purchase_price_b['primary_name'] ?? '' }} ,
        Grade : {{ $average_purchase_price_b['primary_grade'] ?? '' }}
    </td>

    <td>
        Processing : {{ $average_purchase_price_b['secondary_unit'] ?? '' }} ,
        Name : {{ $average_purchase_price_b['secondary_name'] ?? '' }} ,
        Grade : {{ $average_purchase_price_b['secondary_grade'] ?? '' }}
    </td>

    <td>
        Processing : {{ $average_purchase_price_b['tertiary_unit'] ?? '' }} ,
        Name : {{ $average_purchase_price_b['tertiary_name'] ?? '' }} ,
        Grade : {{ $average_purchase_price_b['tertiary_grade'] ?? '' }}
    </td>
    <td>{{ $average_purchase_price_b['remarks'] ?? '' }}</td>
</tr>
         
        <tr>
            @php
            $average_purchase_price_c = json_decode($data1->average_purchase_price_c, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Raw Produce (Name & Grade)</td>
            <td>{{ $average_purchase_price_c['primary'] ?? '' }} ,
                {{ $average_purchase_price_c['secondary'] ?? '' }} ,
                {{ $average_purchase_price_c['tertiary'] ?? '' }}
            </td>
            <td>
                Processing : {{ $average_purchase_price_c['primary_unit'] ?? '' }} ,
                Name : {{ $average_purchase_price_c['primary_name'] ?? '' }} ,
                Grade : {{ $average_purchase_price_c['primary_grade'] ?? '' }}
            </td>
        
            <td>
                Processing : {{ $average_purchase_price_c['secondary_unit'] ?? '' }} ,
                Name : {{ $average_purchase_price_c['secondary_name'] ?? '' }} ,
                Grade : {{ $average_purchase_price_c['secondary_grade'] ?? '' }}
            </td>
        
            <td>
                Processing : {{ $average_purchase_price_c['tertiary_unit'] ?? '' }} ,
                Name : {{ $average_purchase_price_c['tertiary_name'] ?? '' }} ,
                Grade : {{ $average_purchase_price_c['tertiary_grade'] ?? '' }}
            </td>
            <td>{{ $average_purchase_price_c['remarks'] ?? '' }}</td>
        </tr> 
         
        <tr>
    @php
    $average_purchase_price_d = json_decode($data1->average_purchase_price_d, true);
    @endphp
    <td></td>
    <td></td>
    <td></td>
    <td>Raw Produce (Name & Grade)</td>
    <td>{{ $average_purchase_price_d['primary'] ?? '' }} ,
        {{ $average_purchase_price_d['secondary'] ?? '' }} ,
        {{ $average_purchase_price_d['tertiary'] ?? '' }}
    </td>
    <td>
        Processing : {{ $average_purchase_price_d['primary_unit'] ?? '' }} ,
        Name : {{ $average_purchase_price_d['primary_name'] ?? '' }} ,
        Grade : {{ $average_purchase_price_d['primary_grade'] ?? '' }}
    </td>

    <td>
        Processing : {{ $average_purchase_price_d['secondary_unit'] ?? '' }} ,
        Name : {{ $average_purchase_price_d['secondary_name'] ?? '' }} ,
        Grade : {{ $average_purchase_price_d['secondary_grade'] ?? '' }}
    </td>

    <td>
        Processing : {{ $average_purchase_price_d['tertiary_unit'] ?? '' }} ,
        Name : {{ $average_purchase_price_d['tertiary_name'] ?? '' }} ,
        Grade : {{ $average_purchase_price_d['tertiary_grade'] ?? '' }}
    </td>
    <td>{{ $average_purchase_price_d['remarks'] ?? '' }}</td>
</tr>
         
           <tr>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
       <tr>
            @php
            $primary_processed_produce_a = json_decode($data1->primary_processed_produce_a, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Primary Processed Produce (Name & Grade)</td>
            <td>{{ $primary_processed_produce_a['primary'] ?? '' }} ,
                {{ $primary_processed_produce_a['secondary'] ?? '' }} ,
                {{ $primary_processed_produce_a['tertiary'] ?? '' }}
            </td>
            <td>
                Processing : {{ $primary_processed_produce_a['primary_unit'] ?? '' }} ,
                Name : {{ $primary_processed_produce_a['primary_name'] ?? '' }} ,
                Grade : {{ $primary_processed_produce_a['primary_grade'] ?? '' }}
            </td>
        
            <td>
                Processing : {{ $primary_processed_produce_a['secondary_unit'] ?? '' }} ,
                Name : {{ $primary_processed_produce_a['secondary_name'] ?? '' }} ,
                Grade : {{ $primary_processed_produce_a['secondary_grade'] ?? '' }}
            </td>
        
            <td>
                Processing : {{ $primary_processed_produce_a['tertiary_unit'] ?? '' }} ,
                Name : {{ $primary_processed_produce_a['tertiary_name'] ?? '' }} ,
                Grade : {{ $primary_processed_produce_a['tertiary_grade'] ?? '' }}
            </td>
            <td>{{ $primary_processed_produce_a['remarks'] ?? '' }}</td>
        </tr>
         
           <tr>
                @php
                $primary_processed_produce_b = json_decode($data1->primary_processed_produce_b, true);
                @endphp
                <td></td>
                <td></td>
                <td></td>
                <td>Primary Processed Produce (Name & Grade)</td>
                <td>{{ $primary_processed_produce_b['primary'] ?? '' }} ,
                    {{ $primary_processed_produce_b['secondary'] ?? '' }} ,
                    {{ $primary_processed_produce_b['tertiary'] ?? '' }}
                </td>
                <td>
                    Processing : {{ $primary_processed_produce_b['primary_unit'] ?? '' }} ,
                    Name : {{ $primary_processed_produce_b['primary_name'] ?? '' }} ,
                    Grade : {{ $primary_processed_produce_b['primary_grade'] ?? '' }}
                </td>
            
                <td>
                    Processing : {{ $primary_processed_produce_b['secondary_unit'] ?? '' }} ,
                    Name : {{ $primary_processed_produce_b['secondary_name'] ?? '' }} ,
                    Grade : {{ $primary_processed_produce_b['secondary_grade'] ?? '' }}
                </td>
            
                <td>
                    Processing : {{ $primary_processed_produce_b['tertiary_unit'] ?? '' }} ,
                    Name : {{ $primary_processed_produce_b['tertiary_name'] ?? '' }} ,
                    Grade : {{ $primary_processed_produce_b['tertiary_grade'] ?? '' }}
                </td>
                <td>{{ $primary_processed_produce_b['remarks'] ?? '' }}</td>
            </tr>
         
            <tr>
    @php
    $primary_processed_produce_c = json_decode($data1->primary_processed_produce_c, true);
    @endphp
    <td></td>
    <td></td>
    <td></td>
    <td>Primary Processed Produce (Name & Grade)</td>
    <td>{{ $primary_processed_produce_c['primary'] ?? '' }} ,
        {{ $primary_processed_produce_c['secondary'] ?? '' }} ,
        {{ $primary_processed_produce_c['tertiary'] ?? '' }}
    </td>
    <td>
        Processing : {{ $primary_processed_produce_c['primary_unit'] ?? '' }} ,
        Name : {{ $primary_processed_produce_c['primary_name'] ?? '' }} ,
        Grade : {{ $primary_processed_produce_c['primary_grade'] ?? '' }}
    </td>

    <td>
        Processing : {{ $primary_processed_produce_c['secondary_unit'] ?? '' }} ,
        Name : {{ $primary_processed_produce_c['secondary_name'] ?? '' }} ,
        Grade : {{ $primary_processed_produce_c['secondary_grade'] ?? '' }}
    </td>

    <td>
        Processing : {{ $primary_processed_produce_c['tertiary_unit'] ?? '' }} ,
        Name : {{ $primary_processed_produce_c['tertiary_name'] ?? '' }} ,
        Grade : {{ $primary_processed_produce_c['tertiary_grade'] ?? '' }}
    </td>
    <td>{{ $primary_processed_produce_c['remarks'] ?? '' }}</td>
</tr>
         
             <tr>
    @php
    $primary_processed_produce_d = json_decode($data1->primary_processed_produce_d, true);
    @endphp
    <td></td>
    <td></td>
    <td></td>
    <td>Primary Processed Produce (Name & Grade)</td>
    <td>{{ $primary_processed_produce_d['primary'] ?? '' }} ,
        {{ $primary_processed_produce_d['secondary'] ?? '' }} ,
        {{ $primary_processed_produce_d['tertiary'] ?? '' }}
    </td>
    <td>
        Processing : {{ $primary_processed_produce_d['primary_unit'] ?? '' }} ,
        Name : {{ $primary_processed_produce_d['primary_name'] ?? '' }} ,
        Grade : {{ $primary_processed_produce_d['primary_grade'] ?? '' }}
    </td>

    <td>
        Processing : {{ $primary_processed_produce_d['secondary_unit'] ?? '' }} ,
        Name : {{ $primary_processed_produce_d['secondary_name'] ?? '' }} ,
        Grade : {{ $primary_processed_produce_d['secondary_grade'] ?? '' }}
    </td>

    <td>
        Processing : {{ $primary_processed_produce_d['tertiary_unit'] ?? '' }} ,
        Name : {{ $primary_processed_produce_d['tertiary_name'] ?? '' }} ,
        Grade : {{ $primary_processed_produce_d['tertiary_grade'] ?? '' }}
    </td>
    <td>{{ $primary_processed_produce_d['remarks'] ?? '' }}</td>
</tr>
         
         <tr>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            @php
            $secondary_processed_produce_a = json_decode($data1->secondary_processed_produce_a, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Secondary Processed Produce (Name & Grade)</td>
            <td>{{ $secondary_processed_produce_a['primary'] ?? '' }} ,
                {{ $secondary_processed_produce_a['secondary'] ?? '' }} ,
                {{ $secondary_processed_produce_a['tertiary'] ?? '' }}
            </td>
            <td>
                Processing : {{ $secondary_processed_produce_a['primary_unit'] ?? '' }} ,
                Name : {{ $secondary_processed_produce_a['primary_name'] ?? '' }} ,
                Grade : {{ $secondary_processed_produce_a['primary_grade'] ?? '' }}
            </td>
        
            <td>
                Processing : {{ $secondary_processed_produce_a['secondary_unit'] ?? '' }} ,
                Name : {{ $secondary_processed_produce_a['secondary_name'] ?? '' }} ,
                Grade : {{ $secondary_processed_produce_a['secondary_grade'] ?? '' }}
            </td>
        
            <td>
                Processing : {{ $secondary_processed_produce_a['tertiary_unit'] ?? '' }} ,
                Name : {{ $secondary_processed_produce_a['tertiary_name'] ?? '' }} ,
                Grade : {{ $secondary_processed_produce_a['tertiary_grade'] ?? '' }}
            </td>
            <td>{{ $secondary_processed_produce_a['remarks'] ?? '' }}</td>
        </tr>
         
           <tr>
                @php
                $secondary_processed_produce_b = json_decode($data1->secondary_processed_produce_b, true);
                @endphp
                <td></td>
                <td></td>
                <td></td>
                <td>Secondry Processed Produce (Name & Grade)</td>
                <td>{{ $secondary_processed_produce_b['primary'] ?? '' }} ,
                    {{ $secondary_processed_produce_b['secondary'] ?? '' }} ,
                    {{ $secondary_processed_produce_b['tertiary'] ?? '' }}
                </td>
                <td>
                    Processing : {{ $secondary_processed_produce_b['primary_unit'] ?? '' }} ,
                    Name : {{ $secondary_processed_produce_b['primary_name'] ?? '' }} ,
                    Grade : {{ $secondary_processed_produce_b['primary_grade'] ?? '' }}
                </td>
            
                <td>
                    Processing : {{ $secondary_processed_produce_b['secondary_unit'] ?? '' }} ,
                    Name : {{ $secondary_processed_produce_b['secondary_name'] ?? '' }} ,
                    Grade : {{ $secondary_processed_produce_b['secondary_grade'] ?? '' }}
                </td>
            
                <td>
                    Processing : {{ $secondary_processed_produce_b['tertiary_unit'] ?? '' }} ,
                    Name : {{ $secondary_processed_produce_b['tertiary_name'] ?? '' }} ,
                    Grade : {{ $secondary_processed_produce_b['tertiary_grade'] ?? '' }}
                </td>
                <td>{{ $secondary_processed_produce_b['remarks'] ?? '' }}</td>
            </tr>
         
          <tr>
            @php
            $secondary_processed_produce_c = json_decode($data1->secondary_processed_produce_c, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Secondary Processed Produce (Name & Grade)</td>
            <td>{{ $secondary_processed_produce_c['primary'] ?? '' }} ,
                {{ $secondary_processed_produce_c['secondary'] ?? '' }} ,
                {{ $secondary_processed_produce_c['tertiary'] ?? '' }}
            </td>
            <td>
                Processing : {{ $secondary_processed_produce_c['primary_unit'] ?? '' }} ,
                Name : {{ $secondary_processed_produce_c['primary_name'] ?? '' }} ,
                Grade : {{ $secondary_processed_produce_c['primary_grade'] ?? '' }}
            </td>
        
            <td>
                Processing : {{ $secondary_processed_produce_c['secondary_unit'] ?? '' }} ,
                Name : {{ $secondary_processed_produce_c['secondary_name'] ?? '' }} ,
                Grade : {{ $secondary_processed_produce_c['secondary_grade'] ?? '' }}
            </td>
        
            <td>
                Processing : {{ $secondary_processed_produce_c['tertiary_unit'] ?? '' }} ,
                Name : {{ $secondary_processed_produce_c['tertiary_name'] ?? '' }} ,
                Grade : {{ $secondary_processed_produce_c['tertiary_grade'] ?? '' }}
            </td>
            <td>{{ $secondary_processed_produce_c['remarks'] ?? '' }}</td>
        </tr>
         
         <tr>
            @php
            $secondary_processed_produce_d = json_decode($data1->secondary_processed_produce_d, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Secondary Processed Produce (Name & Grade)</td>
            <td>{{ $secondary_processed_produce_d['primary'] ?? '' }} ,
                {{ $secondary_processed_produce_d['secondary'] ?? '' }} ,
                {{ $secondary_processed_produce_d['tertiary'] ?? '' }}
            </td>
            <td>
                Processing : {{ $secondary_processed_produce_d['primary_unit'] ?? '' }} ,
                Name : {{ $secondary_processed_produce_d['primary_name'] ?? '' }} ,
                Grade : {{ $secondary_processed_produce_d['primary_grade'] ?? '' }}
            </td>
        
            <td>
                Processing : {{ $secondary_processed_produce_d['secondary_unit'] ?? '' }} ,
                Name : {{ $secondary_processed_produce_d['secondary_name'] ?? '' }} ,
                Grade : {{ $secondary_processed_produce_d['secondary_grade'] ?? '' }}
            </td>
        
            <td>
                Processing : {{ $secondary_processed_produce_d['tertiary_unit'] ?? '' }} ,
                Name : {{ $secondary_processed_produce_d['tertiary_name'] ?? '' }} ,
                Grade : {{ $secondary_processed_produce_d['tertiary_grade'] ?? '' }}
            </td>
            <td>{{ $secondary_processed_produce_d['remarks'] ?? '' }}</td>
        </tr>
         
         <tr>
            <td>II</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Cost of Value Addition</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            @php
            $transportation_cost = json_decode($data1->transportation_cost, true);
            @endphp
            <td>a</td>
            <td></td>
            <td></td>
            <td>Transportation Cost</td>
            <td>{{ $transportation_cost['primary'] ?? '' }}</td>
            <td>{{ $transportation_cost['primary_unit'] ?? '' }}</td>
            <td>{{ $transportation_cost['secondary'] ?? '' }}</td>
            <td>{{ $transportation_cost['tertiary'] ?? '' }}</td>
            <td>{{ $transportation_cost['remarks'] ?? '' }}</td>
        </tr>
         
         <tr>
            @php
            $loading_and_unloading_charges = json_decode($data1->loading_and_unloading_charges, true);
            @endphp
            <td>b</td>
            <td></td>
            <td></td>
            <td>Loading and Unloading Charges</td>
            <td>{{ $loading_and_unloading_charges['primary'] ?? '' }}</td>
            <td>{{ $loading_and_unloading_charges['primary_unit'] ?? '' }}</td>
            <td>{{ $loading_and_unloading_charges['secondary'] ?? '' }}</td>
            <td>{{ $loading_and_unloading_charges['tertiary'] ?? '' }}</td>
            <td>{{ $loading_and_unloading_charges['remarks'] ?? '' }}</td>
        </tr>
         
         
        <tr>
            <td>c</td>
             <td></td>
            <td></td>
            <td>Processing Cost</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
              @php
                $cost_of_primary_processing = json_decode($data1->cost_of_primary_processing, true);
              @endphp
            <td>i</td>
             <td></td>
            <td></td>
            <td>Cost of Primary Processing</td>
            <td>{{ $cost_of_primary_processing['primary'] ?? '' }}</td>
            <td>{{ $cost_of_primary_processing['primary_unit'] ?? '' }}</td>
            <td>{{ $cost_of_primary_processing['secondary'] ?? '' }}</td>
            <td>{{ $cost_of_primary_processing['tertiary'] ?? '' }}</td>
            <td>{{ $cost_of_primary_processing['remarks'] ?? '' }}</td>
         </tr> 
         
         
         
          <tr>
               @php
                $cost_of_secondary_processing = json_decode($data1->cost_of_secondary_processing, true);
                @endphp
            <td>ii</td>
             <td></td>
            <td></td>
            <td>Cost of Secondary Processing</td>
          <td>{{ $cost_of_secondary_processing['primary'] ?? '' }}</td>
            <td>{{ $cost_of_secondary_processing['primary_unit'] ?? '' }}</td>
            <td>{{ $cost_of_secondary_processing['secondary'] ?? '' }}</td>
            <td>{{ $cost_of_secondary_processing['tertiary'] ?? '' }}</td>
            <td>{{ $cost_of_secondary_processing['remarks'] ?? '' }}</td>
         </tr> 
         
         
          <tr>
              @php
                $cost_of_tertiary_processing = json_decode($data1->cost_of_tertiary_processing, true);
                @endphp
            <td>iii</td>
             <td></td>
            <td></td>
            <td>Cost of Tertiary Processing</td>
            <td>{{ $cost_of_tertiary_processing['primary'] ?? '' }}</td>
            <td>{{ $cost_of_tertiary_processing['primary_unit'] ?? '' }}</td>
            <td>{{ $cost_of_tertiary_processing['secondary'] ?? '' }}</td>
            <td>{{ $cost_of_tertiary_processing['tertiary'] ?? '' }}</td>
            <td>{{ $cost_of_tertiary_processing['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
            $value_of_drying_loss = json_decode($data1->value_of_drying_loss, true);
            @endphp
            <td>d</td>
             <td></td>
            <td></td>
            <td>Value of drying loss/weight loss or any other losses</td>
             <td>{{ $value_of_drying_loss['primary'] ?? '' }}</td>
            <td>{{ $value_of_drying_loss['primary_unit'] ?? '' }}</td>
            <td>{{ $value_of_drying_loss['secondary'] ?? '' }}</td>
            <td>{{ $value_of_drying_loss['tertiary'] ?? '' }}</td>
            <td>{{ $value_of_drying_loss['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $weighing_cost = json_decode($data1->weighing_cost, true);
                @endphp
            <td>e</td>
             <td></td>
            <td></td>
            <td>Weighing Cost</td>
            <td>{{ $weighing_cost['primary'] ?? '' }}</td>
            <td>{{ $weighing_cost['primary_unit'] ?? '' }}</td>
            <td>{{ $weighing_cost['secondary'] ?? '' }}</td>
            <td>{{ $weighing_cost['tertiary'] ?? '' }}</td>
            <td>{{ $weighing_cost['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
            $packaging_cost = json_decode($data1->packaging_cost, true);
            @endphp
            <td>f</td>
             <td></td>
            <td></td>
            <td>Packaging Cost</td>
            <td>{{ $packaging_cost['primary'] ?? '' }}</td>
            <td>{{ $packaging_cost['primary_unit'] ?? '' }}</td>
            <td>{{ $packaging_cost['secondary'] ?? '' }}</td>
            <td>{{ $packaging_cost['tertiary'] ?? '' }}</td>
            <td>{{ $packaging_cost['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $branding_cost = json_decode($data1->branding_cost, true);
                @endphp
            <td>g</td>
             <td></td>
            <td></td>
            <td>Branding Cost</td>
            <td>{{ $branding_cost['primary'] ?? '' }}</td>
            <td>{{ $branding_cost['primary_unit'] ?? '' }}</td>
            <td>{{ $branding_cost['secondary'] ?? '' }}</td>
            <td>{{ $branding_cost['tertiary'] ?? '' }}</td>
            <td>{{ $branding_cost['remarks'] ?? '' }}</td>
         </tr> 
         
        <tr>
               @php
                $marketing_cost = json_decode($data1->marketing_cost, true);
                @endphp
            <td>h</td>
             <td></td>
            <td></td>
            <td>Marketing Cost</td>
          <td>{{ $marketing_cost['primary'] ?? '' }}</td>
            <td>{{ $marketing_cost['primary_unit'] ?? '' }}</td>
            <td>{{ $marketing_cost['secondary'] ?? '' }}</td>
            <td>{{ $marketing_cost['tertiary'] ?? '' }}</td>
            <td>{{ $marketing_cost['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
            $any_other_cost = json_decode($data1->any_other_cost, true);
            @endphp
            <td>i</td>
             <td></td>
            <td></td>
            <td>Any other cost</td>
            <td>{{ $any_other_cost['primary'] ?? '' }}</td>
            <td>{{ $any_other_cost['primary_unit'] ?? '' }}</td>
            <td>{{ $any_other_cost['secondary'] ?? '' }}</td>
            <td>{{ $any_other_cost['tertiary'] ?? '' }}</td>
            <td>{{ $any_other_cost['remarks'] ?? '' }}</td>
         </tr> 
         
         
         
           <tr>
            <td>j</td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>k</td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>l</td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>III</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Selling Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
        <tr>
            @php
            $selling_price_a = json_decode($data1->selling_price_a, true);
            @endphp
            <td></td>
             <td></td>
            <td></td>
            <td>By-Product A (Name)</td>
             <td>{{ $selling_price_a['primary'] ?? '' }}</td>
            <td>{{ $selling_price_a['primary_unit'] ?? '' }}</td>
            <td>{{ $selling_price_a['secondary'] ?? '' }}</td>
            <td>{{ $selling_price_a['tertiary'] ?? '' }}</td>
            <td>{{ $selling_price_a['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
               @php
                $selling_price_b = json_decode($data1->selling_price_b, true);
                @endphp
            <td></td>
             <td></td>
            <td></td>
            <td>By-Product B (Name)</td>
            <td>{{ $selling_price_b['primary'] ?? '' }}</td>
            <td>{{ $selling_price_b['primary_unit'] ?? '' }}</td>
            <td>{{ $selling_price_b['secondary'] ?? '' }}</td>
            <td>{{ $selling_price_b['tertiary'] ?? '' }}</td>
            <td>{{ $selling_price_b['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
               @php
                $selling_price_c = json_decode($data1->selling_price_c, true);
                @endphp
            <td></td>
             <td></td>
            <td></td>
            <td>By-Product C (Name)</td>
            <td>{{ $selling_price_c['primary'] ?? '' }}</td>
            <td>{{ $selling_price_c['primary_unit'] ?? '' }}</td>
            <td>{{ $selling_price_c['secondary'] ?? '' }}</td>
            <td>{{ $selling_price_c['tertiary'] ?? '' }}</td>
            <td>{{ $selling_price_c['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
               @php
                $selling_price_d = json_decode($data1->selling_price_d, true);
                @endphp
            <td></td>
             <td></td>
            <td></td>
            <td>By-Product D (Name)</td>
           <td>{{ $selling_price_d['primary'] ?? '' }}</td>
            <td>{{ $selling_price_d['primary_unit'] ?? '' }}</td>
            <td>{{ $selling_price_d['secondary'] ?? '' }}</td>
            <td>{{ $selling_price_d['tertiary'] ?? '' }}</td>
            <td>{{ $selling_price_d['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>
         
        <tr>
            <td>IV</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Any other Cost Parameter</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>
         
        <tr>
             @php
            $quantum_handled_year = json_decode($data1->quantum_handled_year, true);
            @endphp
            <td>a</td>
             <td></td>
            <td></td>
            <td>Quantum Handled in a year (weight)</td>
            <td>{{ $quantum_handled_year['primary'] ?? '' }}</td>
            <td>{{ $quantum_handled_year['primary_unit'] ?? '' }}</td>
            <td>{{ $quantum_handled_year['secondary'] ?? '' }}</td>
            <td>{{ $quantum_handled_year['tertiary'] ?? '' }}</td>
            <td>{{ $quantum_handled_year['remarks'] ?? '' }}</td>
         </tr>
         
         <tr>
               @php
            $purchase_and_selling_prices = json_decode($data1->purchase_and_selling_prices, true);
            @endphp
            <td>b</td>
             <td></td>
            <td></td>
            <td>Purchase and selling prices fluctuation during marketing season</td>
               <td>{{ $purchase_and_selling_prices['primary'] ?? '' }}</td>
                <td>{{ $purchase_and_selling_prices['primary_unit'] ?? '' }}</td>
                <td>{{ $purchase_and_selling_prices['secondary'] ?? '' }}</td>
                <td>{{ $purchase_and_selling_prices['tertiary'] ?? '' }}</td>
                <td>{{ $purchase_and_selling_prices['remarks'] ?? '' }}</td>
         </tr>
         
        </tbody>
  </table>
    </div>
    @endforeach
    
    @if($data2->isNotEmpty()) 
        @php
            $si = 1;
        @endphp
    @foreach($data2 as $datas2)
    <div class="table-responsive">
     <h2>C. SWOT Analysis of the processing units</h2>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Primary Processing</th>
             <th>Secondary Processing</th>
             <th>Tertiary Processing</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>{{$si++}}</td>
             <td>{{$datas2->farmer_code_id}}</td>
            <td>{{$datas2->first_name}} {{$datas2->last_name}}</td>
            <td style="font-weight:700;">Strength</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
              @php
            $abundant_availability_of_raw_material = json_decode($datas2->abundant_availability_of_raw_material, true);
            @endphp
            <td>i</td>
             <td></td>
            <td></td>
            <td>Abundant availability of raw material</td>
              <td>{{ $abundant_availability_of_raw_material['primary'] ?? '' }}</td>
                <td>{{ $abundant_availability_of_raw_material['secondary'] ?? '' }}</td>
                <td>{{ $abundant_availability_of_raw_material['tertiary'] ?? '' }}</td>
                <td>{{ $abundant_availability_of_raw_material['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
              @php
                $government_support = json_decode($datas2->government_support, true);
                @endphp
            <td>ii</td>
             <td></td>
            <td></td>
            <td>Government support ( Financial / Non Financial)</td>
            <td>{{ $government_support['primary'] ?? '' }}</td>
            <td>{{ $government_support['secondary'] ?? '' }}</td>
            <td>{{ $government_support['tertiary'] ?? '' }}</td>
            <td>{{ $government_support['remarks'] ?? '' }}</td>
         </tr>  
         
          <tr>
              @php
                $market_demand = json_decode($datas2->market_demand, true);
                @endphp
            <td>iii</td>
             <td></td>
            <td></td>
            <td>Market demand</td>
              <td>{{ $market_demand['primary'] ?? '' }}</td>
            <td>{{ $market_demand['secondary'] ?? '' }}</td>
            <td>{{ $market_demand['tertiary'] ?? '' }}</td>
            <td>{{ $market_demand['remarks'] ?? '' }}</td
         </tr> 
         
          <tr>
               @php
                $niche_market = json_decode($datas2->niche_market, true);
                @endphp
            <td>iv</td>
             <td></td>
            <td></td>
            <td >Niche Market</td>
             <td>{{ $niche_market['primary'] ?? '' }}</td>
            <td>{{ $niche_market['secondary'] ?? '' }}</td>
            <td>{{ $niche_market['tertiary'] ?? '' }}</td>
            <td>{{ $niche_market['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
              @php
                $skilled_unskilled_labour = json_decode($datas2->skilled_unskilled_labour, true);
                @endphp
            <td>v</td>
             <td></td>
            <td></td>
            <td>Availability of skilled / unskilled labour</td>
            <td>{{ $skilled_unskilled_labour['primary'] ?? '' }}</td>
            <td>{{ $skilled_unskilled_labour['secondary'] ?? '' }}</td>
            <td>{{ $skilled_unskilled_labour['tertiary'] ?? '' }}</td>
            <td>{{ $skilled_unskilled_labour['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>W</td>
             <td></td>
            <td></td>
            <td>Weakness</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
               @php
            $infrastructure_and_support_services = json_decode($datas2->infrastructure_and_support_services, true);
            @endphp
            <td>i</td>
             <td></td>
            <td></td>
            <td>Infrastructure and Support Services</td>
            <td>{{ $infrastructure_and_support_services['primary'] ?? '' }}</td>
            <td>{{ $infrastructure_and_support_services['secondary'] ?? '' }}</td>
            <td>{{ $infrastructure_and_support_services['tertiary'] ?? '' }}</td>
            <td>{{ $infrastructure_and_support_services['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $quality_and_standard = json_decode($datas2->quality_and_standard, true);
                @endphp
            <td>ii</td>
             <td></td>
            <td></td>
            <td>Quality and Standard</td>
          <td>{{ $quality_and_standard['primary'] ?? '' }}</td>
            <td>{{ $quality_and_standard['secondary'] ?? '' }}</td>
            <td>{{ $quality_and_standard['tertiary'] ?? '' }}</td>
            <td>{{ $quality_and_standard['remarks'] ?? '' }}</td>
         </tr> 
         
        <tr>
             @php
            $competitor = json_decode($datas2->competitor, true);
            @endphp
            <td>iii</td>
             <td></td>
            <td></td>
            <td>Competitor (competitiveness)</td>
             <td>{{ $competitor['primary'] ?? '' }}</td>
            <td>{{ $competitor['secondary'] ?? '' }}</td>
            <td>{{ $competitor['tertiary'] ?? '' }}</td>
            <td>{{ $competitor['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
               @php
            $cost_of_financial_resources = json_decode($datas2->cost_of_financial_resources, true);
            @endphp
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Cost of Financial Resources</td>
            <td>{{ $cost_of_financial_resources['primary'] ?? '' }}</td>
            <td>{{ $cost_of_financial_resources['secondary'] ?? '' }}</td>
            <td>{{ $cost_of_financial_resources['tertiary'] ?? '' }}</td>
            <td>{{ $cost_of_financial_resources['remarks'] ?? '' }}</td>
         </tr> 
         
        <tr>
            @php
            $access_to_updated_technology = json_decode($datas2->access_to_updated_technology, true);
            @endphp
            <td>v</td>
             <td></td>
            <td></td>
            <td>Access to updated technology</td>
            <td>{{ $access_to_updated_technology['primary'] ?? '' }}</td>
            <td>{{ $access_to_updated_technology['secondary'] ?? '' }}</td>
            <td>{{ $access_to_updated_technology['tertiary'] ?? '' }}</td>
            <td>{{ $access_to_updated_technology['remarks'] ?? '' }}</td>
         </tr> 
         
        <tr>
              @php
            $seasonality_of_raw_material = json_decode($datas2->seasonality_of_raw_material, true);
            @endphp
            <td>vi</td>
             <td></td>
            <td></td>
            <td>Seasonality of raw material</td>
           <td>{{ $seasonality_of_raw_material['primary'] ?? '' }}</td>
            <td>{{ $seasonality_of_raw_material['secondary'] ?? '' }}</td>
            <td>{{ $seasonality_of_raw_material['tertiary'] ?? '' }}</td>
            <td>{{ $seasonality_of_raw_material['remarks'] ?? '' }}</td>
         </tr>  
         
          <tr>
            <td></td>
             <td></td>
            <td></td>
            <td>Secondary Processed Produce (Name & Grade)</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>O</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Opportunities</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         
          <tr>
                 @php
                $social_factor = json_decode($datas2->social_factor, true);
                @endphp
            <td>i</td>
             <td></td>
            <td></td>
            <td>Social Factor</td>
            <td>{{ $social_factor['primary'] ?? '' }}</td>
            <td>{{ $social_factor['secondary'] ?? '' }}</td>
            <td>{{ $social_factor['tertiary'] ?? '' }}</td>
            <td>{{ $social_factor['remarks'] ?? '' }}</td>
         </tr> 
         
         
        <tr>
             @php
    $technological_factor = json_decode($datas2->technological_factor, true);
    @endphp
            <td>ii</td>
             <td></td>
            <td></td>
            <td>Technological Factor</td>
               <td>{{ $technological_factor['primary'] ?? '' }}</td>
    <td>{{ $technological_factor['secondary'] ?? '' }}</td>
    <td>{{ $technological_factor['tertiary'] ?? '' }}</td>
    <td>{{ $technological_factor['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $legal_factor = json_decode($datas2->legal_factor, true);
                @endphp
            <td>iii</td>
             <td></td>
            <td></td>
            <td>Legal Factor</td>
          <td>{{ $legal_factor['primary'] ?? '' }}</td>
            <td>{{ $legal_factor['secondary'] ?? '' }}</td>
            <td>{{ $legal_factor['tertiary'] ?? '' }}</td>
            <td>{{ $legal_factor['remarks'] ?? '' }}</td>
         </tr> 
         
         
         
          <tr>
                @php
    $political_factor = json_decode($datas2->political_factor, true);
    @endphp
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Political Factor</td>
             <td>{{ $political_factor['primary'] ?? '' }}</td>
    <td>{{ $political_factor['secondary'] ?? '' }}</td>
    <td>{{ $political_factor['tertiary'] ?? '' }}</td>
    <td>{{ $political_factor['remarks'] ?? '' }}</td>
         </tr> 
         
         
          <tr>
              @php
            $economic_factors = json_decode($datas2->economic_factors, true);
            @endphp
            <td>v</td>
             <td></td>
            <td></td>
            <td>Economic Factors</td>
                <td>{{ $economic_factors['primary'] ?? '' }}</td>
                <td>{{ $economic_factors['secondary'] ?? '' }}</td>
                <td>{{ $economic_factors['tertiary'] ?? '' }}</td>
                <td>{{ $economic_factors['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
                @php
            $environmental_factor = json_decode($datas2->environmental_factor, true);
            @endphp
            <td>vi</td>
             <td></td>
            <td></td>
            <td>Environmental Factor</td>
            <td>{{ $environmental_factor['primary'] ?? '' }}</td>
            <td>{{ $environmental_factor['secondary'] ?? '' }}</td>
            <td>{{ $environmental_factor['tertiary'] ?? '' }}</td>
            <td>{{ $environmental_factor['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
            $any_other = json_decode($datas2->any_other, true);
            @endphp
            <td>vii</td>
             <td></td>
            <td></td>
            <td>Any Other</td>
            <td>{{ $any_other['primary'] ?? '' }}</td>
            <td>{{ $any_other['secondary'] ?? '' }}</td>
            <td>{{ $any_other['tertiary'] ?? '' }}</td>
            <td>{{ $any_other['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
            <td>T</td>
             <td></td>
            <td></td>
            <td>Threat</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
               @php
                $threat_social_factor = json_decode($datas2->threat_social_factor, true);
                @endphp
            <td>i</td>
             <td></td>
            <td></td>
            <td>Social Factor</td>
           <td>{{ $threat_social_factor['primary'] ?? '' }}</td>
            <td>{{ $threat_social_factor['secondary'] ?? '' }}</td>
            <td>{{ $threat_social_factor['tertiary'] ?? '' }}</td>
            <td>{{ $threat_social_factor['remarks'] ?? '' }}</td>
         </tr> 
         
        <tr>
              @php
            $threat_technological_factor = json_decode($datas2->threat_technological_factor, true);
            @endphp
            <td>ii</td>
             <td></td>
            <td></td>
            <td>Technological Factor</td>
            <td>{{ $threat_technological_factor['primary'] ?? '' }}</td>
            <td>{{ $threat_technological_factor['secondary'] ?? '' }}</td>
            <td>{{ $threat_technological_factor['tertiary'] ?? '' }}</td>
            <td>{{ $threat_technological_factor['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
            $threat_legal_factor = json_decode($datas2->threat_legal_factor, true);
            @endphp
            <td>iii</td>
             <td></td>
            <td></td>
            <td>Legal Factor</td>
            <td>{{ $threat_legal_factor['primary'] ?? '' }}</td>
            <td>{{ $threat_legal_factor['secondary'] ?? '' }}</td>
            <td>{{ $threat_legal_factor['tertiary'] ?? '' }}</td>
            <td>{{ $threat_legal_factor['remarks'] ?? '' }}</td>
         </tr> 
         
         
         
           <tr>
                @php
            $threat_political_factor = json_decode($datas2->threat_political_factor, true);
            @endphp
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Political Factor</td>
            <td>{{ $threat_political_factor['primary'] ?? '' }}</td>
            <td>{{ $threat_political_factor['secondary'] ?? '' }}</td>
            <td>{{ $threat_political_factor['tertiary'] ?? '' }}</td>
            <td>{{ $threat_political_factor['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
                   @php
                $threat_economic_factors = json_decode($datas2->threat_economic_factors, true);
                @endphp
            <td>v</td>
             <td></td>
            <td></td>
            <td>Economic Factors</td>
               <td>{{ $threat_economic_factors['primary'] ?? '' }}</td>
                <td>{{ $threat_economic_factors['secondary'] ?? '' }}</td>
                <td>{{ $threat_economic_factors['tertiary'] ?? '' }}</td>
                <td>{{ $threat_economic_factors['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
              @php
            $threat_environmental_factor = json_decode($datas2->threat_environmental_factor, true);
            @endphp
            <td>vi</td>
             <td></td>
            <td></td>
            <td>Environmental Factor</td>
               <td>{{ $threat_environmental_factor['primary'] ?? '' }}</td>
            <td>{{ $threat_environmental_factor['secondary'] ?? '' }}</td>
            <td>{{ $threat_environmental_factor['tertiary'] ?? '' }}</td>
            <td>{{ $threat_environmental_factor['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
               @php
            $threat_any_other = json_decode($datas2->threat_any_other, true);
            @endphp
            <td>vii</td>
             <td></td>
            <td></td>
            <td>Any Other </td>
                <td>{{ $threat_any_other['primary'] ?? '' }}</td>
            <td>{{ $threat_any_other['secondary'] ?? '' }}</td>
            <td>{{ $threat_any_other['tertiary'] ?? '' }}</td>
            <td>{{ $threat_any_other['remarks'] ?? '' }}</td>
         </tr> 
        
        </tbody>
  </table>
    </div>
    @endforeach
    @else
     <div class="table-responsive">
     <h2>C. SWOT Analysis of the processing units</h2>

     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Primary Processing</th>
             <th>Secondary Processing</th>
             <th>Tertiary Processing</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>S</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Strength</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td>i</td>
             <td></td>
            <td></td>
            <td>Abundant availability of raw material</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>ii</td>
             <td></td>
            <td></td>
            <td>Government support ( Financial / Non Financial)</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>  
         
          <tr>
            <td>iii</td>
             <td></td>
            <td></td>
            <td>Market demand</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>iv</td>
             <td></td>
            <td></td>
            <td >Niche Market</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>v</td>
             <td></td>
            <td></td>
            <td>Availability of skilled / unskilled labour</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>W</td>
             <td></td>
            <td></td>
            <td>Weakness</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>i</td>
             <td></td>
            <td></td>
            <td>Infrastructure and Support Services</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>ii</td>
             <td></td>
            <td></td>
            <td>Quality and Standard</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>iii</td>
             <td></td>
            <td></td>
            <td>Competitor (competitiveness)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Cost of Financial Resources</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>v</td>
             <td></td>
            <td></td>
            <td>Access to updated technology</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>vi</td>
             <td></td>
            <td></td>
            <td>Seasonality of raw material</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>  
         
          <tr>
            <td></td>
             <td></td>
            <td></td>
            <td>Secondary Processed Produce (Name & Grade)</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>O</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Opportunities</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         
          <tr>
            <td>i</td>
             <td></td>
            <td></td>
            <td>Social Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
        <tr>
            <td>ii</td>
             <td></td>
            <td></td>
            <td>Technological Factor</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>iii</td>
             <td></td>
            <td></td>
            <td>Legal Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         
          <tr>
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Political Factor</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
          <tr>
            <td>v</td>
             <td></td>
            <td></td>
            <td>Economic Factors</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>vi</td>
             <td></td>
            <td></td>
            <td>Environmental Factor</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
          <tr>
            <td>vii</td>
             <td></td>
            <td></td>
            <td>Any Other</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>T</td>
             <td></td>
            <td></td>
            <td>Threat</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>i</td>
             <td></td>
            <td></td>
            <td>Social Factor</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>ii</td>
             <td></td>
            <td></td>
            <td>Technological Factor</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>iii</td>
             <td></td>
            <td></td>
            <td>Legal Factor</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         
           <tr>
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Political Factor</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>v</td>
             <td></td>
            <td></td>
            <td>Economic Factors</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>vi</td>
             <td></td>
            <td></td>
            <td>Environmental Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>vii</td>
             <td></td>
            <td></td>
            <td>Any Other </td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
        
        </tbody>
  </table>
    </div>
    @endif
    
    
</div>

    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>

@endsection