<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>
@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

<div class="container-fluid">
    <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
             @if($deshboard == 1)
        
            @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.e') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.e.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            @endif
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Backward Linkages</h1>
        </div>
        @if($data->isNotEmpty())
         @php
            $si = 1;
        @endphp
        @foreach($data as $data)
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Name of the input supplier / supporting value chain actor</th>
              <th>Adequacy</th>
              <th>quality</th>
              <th>Timely supply</th>
              <th>Effectiveness</th>
              <th>As per scientific recommendation (SOP) </th>
              <th>Price reasonability </th>
              <th>Is inputs on credit  </th>
              <th>Difference in input price under with or without credit (%) </th>
              <th>Remark</th>
          </thead>
          
           <tr>
                <td colspan="5">
                </td>
               
                <td>Name</td>
                <td colspan="6" style="text-align:center; background-color:yellow; color:black; font-weight:700;">Rating as per given below matrix</td>
                <td>Y/N</td>
                <td>%</td>
               <td></td>
            </tr>
         
            <tr>
                <td style="text-align:center;">
                    {{ $si++ }}
                </td>
                <td>{{$data->farmer_code_id}}</td>
                <td>{{$data->farmer_first_name}} {{$data->farmer_last_name}}</td>
                <td>
                    Seed
                </td>
                 @php
                    $seedData = json_decode($data->seed, true);
                @endphp
                
                <td>
                    {{ $seedData['unit'] ?? '' }}
                </td>
                <td>{{ $seedData['input_supplier_name'] ?? '' }}</td>
                <td>{{ $seedData['adequacy'] ?? '' }}</td>
                <td>{{ $seedData['quality'] ?? '' }}</td>
                <td>{{ $seedData['timely_supply'] ?? '' }}</td>
                <td>{{ $seedData['effectiveness'] ?? '' }}</td>
                <td>{{ $seedData['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $seedData['price_reasonability'] ?? '' }}</td>
                <td>{{ $seedData['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $seedData['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $seedData['remark'] ?? '' }}</td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
                
                <td>
                </td>
                <td></td>
                <td>
                   Plantlets
                </td>
                @php
                $plantletsData = json_decode($data->plantlets, true);
                @endphp
                
                <td>
                    {{ $plantletsData['unit'] ?? '' }}
                </td>
                <td>{{ $plantletsData['input_supplier_name'] ?? '' }}</td>
                <td>{{ $plantletsData['adequacy'] ?? '' }}</td>
                <td>{{ $plantletsData['quality'] ?? '' }}</td>
                <td>{{ $plantletsData['timely_supply'] ?? '' }}</td>
                <td>{{ $plantletsData['effectiveness'] ?? '' }}</td>
                <td>{{ $plantletsData['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $plantletsData['price_reasonability'] ?? '' }}</td>
                <td>{{ $plantletsData['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $plantletsData['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $plantletsData['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
              
                <td>
                   
                </td>
                <td></td>
                  <td>
                    Fingerling (fishery)
                </td>
              @php
                $fingerlingData = json_decode($data->fingerling_fishery, true);
                @endphp
                
                <td>
                    {{ $fingerlingData['unit'] ?? '' }}
                </td>
                <td>{{ $fingerlingData['input_supplier_name'] ?? '' }}</td>
                <td>{{ $fingerlingData['adequacy'] ?? '' }}</td>
                <td>{{ $fingerlingData['quality'] ?? '' }}</td>
                <td>{{ $fingerlingData['timely_supply'] ?? '' }}</td>
                <td>{{ $fingerlingData['effectiveness'] ?? '' }}</td>
                <td>{{ $fingerlingData['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $fingerlingData['price_reasonability'] ?? '' }}</td>
                <td>{{ $fingerlingData['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $fingerlingData['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $fingerlingData['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
               
                <td></td>
                <td></td>
                 <td>
                   day old chick (Poultry)
                </td>
                @php
                $daychickData = json_decode($data->day_old_chick, true);
                @endphp
                
                <td>
                    {{ $daychickData['unit'] ?? '' }}
                </td>
                <td>{{ $daychickData['input_supplier_name'] ?? '' }}</td>
                <td>{{ $daychickData['adequacy'] ?? '' }}</td>
                <td>{{ $daychickData['quality'] ?? '' }}</td>
                <td>{{ $daychickData['timely_supply'] ?? '' }}</td>
                <td>{{ $daychickData['effectiveness'] ?? '' }}</td>
                <td>{{ $daychickData['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $daychickData['price_reasonability'] ?? '' }}</td>
                <td>{{ $daychickData['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $daychickData['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $daychickData['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    5
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Feed 
                </td>
               @php
                $feedData = json_decode($data->feed, true);
                @endphp
                
                <td>
                    {{ $feedData['unit'] ?? '' }}
                </td>
                <td>{{ $feedData['input_supplier_name'] ?? '' }}</td>
                <td>{{ $feedData['adequacy'] ?? '' }}</td>
                <td>{{ $feedData['quality'] ?? '' }}</td>
                <td>{{ $feedData['timely_supply'] ?? '' }}</td>
                <td>{{ $feedData['effectiveness'] ?? '' }}</td>
                <td>{{ $feedData['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $feedData['price_reasonability'] ?? '' }}</td>
                <td>{{ $feedData['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $feedData['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $feedData['remark'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    6
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Fertilizer
                </td>
               @php
                $fertilizerData = json_decode($data->fertilizer, true);
                @endphp
                
                <td>
                    {{ $fertilizerData['unit'] ?? '' }}
                </td>
                <td>{{ $fertilizerData['input_supplier_name'] ?? '' }}</td>
                <td>{{ $fertilizerData['adequacy'] ?? '' }}</td>
                <td>{{ $fertilizerData['quality'] ?? '' }}</td>
                <td>{{ $fertilizerData['timely_supply'] ?? '' }}</td>
                <td>{{ $fertilizerData['effectiveness'] ?? '' }}</td>
                <td>{{ $fertilizerData['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $fertilizerData['price_reasonability'] ?? '' }}</td>
                <td>{{ $fertilizerData['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $fertilizerData['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $fertilizerData['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    7
                </td>
                
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                  Pesticides / Insecticide / Herbicides
                </td>
                @php
                $pesticideData = json_decode($data->pesticides_insec_her, true);
                @endphp
                
                <td>
                    {{ $pesticideData['unit'] ?? '' }}
                </td>
                <td>{{ $pesticideData['input_supplier_name'] ?? '' }}</td>
                <td>{{ $pesticideData['adequacy'] ?? '' }}</td>
                <td>{{ $pesticideData['quality'] ?? '' }}</td>
                <td>{{ $pesticideData['timely_supply'] ?? '' }}</td>
                <td>{{ $pesticideData['effectiveness'] ?? '' }}</td>
                <td>{{ $pesticideData['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $pesticideData['price_reasonability'] ?? '' }}</td>
                <td>{{ $pesticideData['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $pesticideData['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $pesticideData['remark'] ?? '' }}</td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Nutrients
                </td>
                @php
                $nutrientsdata = json_decode($data->nutrients, true);
                @endphp
                
                <td>
                    {{ $nutrientsdata['unit'] ?? '' }}
                </td>
                <td>{{ $nutrientsdata['input_supplier_name'] ?? '' }}</td>
                <td>{{ $nutrientsdata['adequacy'] ?? '' }}</td>
                <td>{{ $nutrientsdata['quality'] ?? '' }}</td>
                <td>{{ $nutrientsdata['timely_supply'] ?? '' }}</td>
                <td>{{ $nutrientsdata['effectiveness'] ?? '' }}</td>
                <td>{{ $nutrientsdata['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $nutrientsdata['price_reasonability'] ?? '' }}</td>
                <td>{{ $nutrientsdata['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $nutrientsdata['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $nutrientsdata['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    9
                </td>
              
                <td></td>
                <td></td>
                  <td>
               Medicine
                </td>
                @php
                $medicinedata = json_decode($data->medicine, true);
                @endphp
                
                <td>
                    {{ $medicinedata['unit'] ?? '' }}
                </td>
                <td>{{ $medicinedata['input_supplier_name'] ?? '' }}</td>
                <td>{{ $medicinedata['adequacy'] ?? '' }}</td>
                <td>{{ $medicinedata['quality'] ?? '' }}</td>
                <td>{{ $medicinedata['timely_supply'] ?? '' }}</td>
                <td>{{ $medicinedata['effectiveness'] ?? '' }}</td>
                <td>{{ $medicinedata['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $medicinedata['price_reasonability'] ?? '' }}</td>
                <td>{{ $medicinedata['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $medicinedata['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $medicinedata['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    10
                </td>
             
                <td></td>
                <td></td>
                   <td style="font-weight:700;">
                 Labour
                </td>
               @php
                $labourdata = json_decode($data->labour, true);
                @endphp
                
                <td>
                    {{ $labourdata['unit'] ?? '' }}
                </td>
                <td>{{ $labourdata['input_supplier_name'] ?? '' }}</td>
                <td>{{ $labourdata['adequacy'] ?? '' }}</td>
                <td>{{ $labourdata['quality'] ?? '' }}</td>
                <td>{{ $labourdata['timely_supply'] ?? '' }}</td>
                <td>{{ $labourdata['effectiveness'] ?? '' }}</td>
                <td>{{ $labourdata['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $labourdata['price_reasonability'] ?? '' }}</td>
                <td>{{ $labourdata['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $labourdata['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $labourdata['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    11
                </td>
             
                <td></td>
                <td></td>
                   <td>
                Supply of diesel fuel / electricity
                </td>
               @php
                $supplydata = json_decode($data->supply_of_diesel_fuel_electricity, true);
                @endphp
                
                <td>
                    {{ $supplydata['unit'] ?? '' }}
                </td>
                <td>{{ $supplydata['input_supplier_name'] ?? '' }}</td>
                <td>{{ $supplydata['adequacy'] ?? '' }}</td>
                <td>{{ $supplydata['quality'] ?? '' }}</td>
                <td>{{ $supplydata['timely_supply'] ?? '' }}</td>
                <td>{{ $supplydata['effectiveness'] ?? '' }}</td>
                <td>{{ $supplydata['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $supplydata['price_reasonability'] ?? '' }}</td>
                <td>{{ $supplydata['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $supplydata['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $supplydata['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    12
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Technology Transfer 
                </td>
               @php
                $techdata = json_decode($data->technology_transfer, true);
                @endphp
                
                <td>
                    {{ $techdata['unit'] ?? '' }}
                </td>
                <td>{{ $techdata['input_supplier_name'] ?? '' }}</td>
                <td>{{ $techdata['adequacy'] ?? '' }}</td>
                <td>{{ $techdata['quality'] ?? '' }}</td>
                <td>{{ $techdata['timely_supply'] ?? '' }}</td>
                <td>{{ $techdata['effectiveness'] ?? '' }}</td>
                <td>{{ $techdata['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $techdata['price_reasonability'] ?? '' }}</td>
                <td>{{ $techdata['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $techdata['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $techdata['remark'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    13
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                 FM-Custom Hire Services
                </td>
                @php
                $fmdata = json_decode($data->fm_custom_hire_services, true);
                @endphp
                
                <td>
                    {{ $fmdata['unit'] ?? '' }}
                </td>
                <td>{{ $fmdata['input_supplier_name'] ?? '' }}</td>
                <td>{{ $fmdata['adequacy'] ?? '' }}</td>
                <td>{{ $fmdata['quality'] ?? '' }}</td>
                <td>{{ $fmdata['timely_supply'] ?? '' }}</td>
                <td>{{ $fmdata['effectiveness'] ?? '' }}</td>
                <td>{{ $fmdata['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $fmdata['price_reasonability'] ?? '' }}</td>
                <td>{{ $fmdata['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $fmdata['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $fmdata['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    14
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Irrigation on Custom and Hiring
                </td>
                
                 @php
                $irga = json_decode($data->irrigation_on_custom_and_hiring, true);
                @endphp
                
                <td>
                    {{ $irga['unit'] ?? '' }}
                </td>
                <td>{{ $irga['input_supplier_name'] ?? '' }}</td>
                <td>{{ $irga['adequacy'] ?? '' }}</td>
                <td>{{ $irga['quality'] ?? '' }}</td>
                <td>{{ $irga['timely_supply'] ?? '' }}</td>
                <td>{{ $irga['effectiveness'] ?? '' }}</td>
                <td>{{ $irga['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $irga['price_reasonability'] ?? '' }}</td>
                <td>{{ $irga['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $irga['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $irga['remark'] ?? '' }}</td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    15
                </td>
                
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                Source of Credit
                </td>
               @php
                $sourcece = json_decode($data->source_of_credit, true);
                @endphp
                
                <td>
                    {{ $sourcece['unit'] ?? '' }}
                </td>
                <td>{{ $sourcece['input_supplier_name'] ?? '' }}</td>
                <td>{{ $sourcece['adequacy'] ?? '' }}</td>
                <td>{{ $sourcece['quality'] ?? '' }}</td>
                <td>{{ $sourcece['timely_supply'] ?? '' }}</td>
                <td>{{ $sourcece['effectiveness'] ?? '' }}</td>
                <td>{{ $sourcece['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $sourcece['price_reasonability'] ?? '' }}</td>
                <td>{{ $sourcece['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $sourcece['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $sourcece['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Input Credit
                </td>
                @php
                $inputcre = json_decode($data->input_credit, true);
                @endphp
                
                <td>
                    {{ $inputcre['unit'] ?? '' }}
                </td>
                <td>{{ $inputcre['input_supplier_name'] ?? '' }}</td>
                <td>{{ $inputcre['adequacy'] ?? '' }}</td>
                <td>{{ $inputcre['quality'] ?? '' }}</td>
                <td>{{ $inputcre['timely_supply'] ?? '' }}</td>
                <td>{{ $inputcre['effectiveness'] ?? '' }}</td>
                <td>{{ $inputcre['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $inputcre['price_reasonability'] ?? '' }}</td>
                <td>{{ $inputcre['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $inputcre['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $inputcre['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>
                
                <td></td>
                <td></td>
                <td>
                Supply Credit
                </td>
               @php
                $supplycre = json_decode($data->supply_credit, true);
                @endphp
                
                <td>
                    {{ $supplycre['unit'] ?? '' }}
                </td>
                <td>{{ $supplycre['input_supplier_name'] ?? '' }}</td>
                <td>{{ $supplycre['adequacy'] ?? '' }}</td>
                <td>{{ $supplycre['quality'] ?? '' }}</td>
                <td>{{ $supplycre['timely_supply'] ?? '' }}</td>
                <td>{{ $supplycre['effectiveness'] ?? '' }}</td>
                <td>{{ $supplycre['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $supplycre['price_reasonability'] ?? '' }}</td>
                <td>{{ $supplycre['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $supplycre['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $supplycre['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                c
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Credit from NBSC
                </td>
               @php
                $nbsc = json_decode($data->credit_from_nbsc, true);
                @endphp
                
                <td>
                    {{ $nbsc['unit'] ?? '' }}
                </td>
                <td>{{ $nbsc['input_supplier_name'] ?? '' }}</td>
                <td>{{ $nbsc['adequacy'] ?? '' }}</td>
                <td>{{ $nbsc['quality'] ?? '' }}</td>
                <td>{{ $nbsc['timely_supply'] ?? '' }}</td>
                <td>{{ $nbsc['effectiveness'] ?? '' }}</td>
                <td>{{ $nbsc['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $nbsc['price_reasonability'] ?? '' }}</td>
                <td>{{ $nbsc['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $nbsc['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $nbsc['remark'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    d
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Credit from Banks
                </td>
                @php
                $bankcre = json_decode($data->credit_from_banks, true);
                @endphp
                
                <td>
                    {{ $bankcre['unit'] ?? '' }}
                </td>
                <td>{{ $bankcre['input_supplier_name'] ?? '' }}</td>
                <td>{{ $bankcre['adequacy'] ?? '' }}</td>
                <td>{{ $bankcre['quality'] ?? '' }}</td>
                <td>{{ $bankcre['timely_supply'] ?? '' }}</td>
                <td>{{ $bankcre['effectiveness'] ?? '' }}</td>
                <td>{{ $bankcre['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $bankcre['price_reasonability'] ?? '' }}</td>
                <td>{{ $bankcre['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $bankcre['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $bankcre['remark'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    e
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Other source/s
                </td>
               @php
                $othersource = json_decode($data->other_source, true);
                @endphp
                
                <td>
                    {{ $othersource['unit'] ?? '' }}
                </td>
                <td>{{ $othersource['input_supplier_name'] ?? '' }}</td>
                <td>{{ $othersource['adequacy'] ?? '' }}</td>
                <td>{{ $othersource['quality'] ?? '' }}</td>
                <td>{{ $othersource['timely_supply'] ?? '' }}</td>
                <td>{{ $othersource['effectiveness'] ?? '' }}</td>
                <td>{{ $othersource['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $othersource['price_reasonability'] ?? '' }}</td>
                <td>{{ $othersource['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $othersource['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $othersource['remark'] ?? '' }}</td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    16
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
               Any Other Information
                </td>
               @php
                $anyotherin = json_decode($data->any_other_information, true);
                @endphp
                
                <td>
                    {{ $anyotherin['unit'] ?? '' }}
                </td>
                <td>{{ $anyotherin['input_supplier_name'] ?? '' }}</td>
                <td>{{ $anyotherin['adequacy'] ?? '' }}</td>
                <td>{{ $anyotherin['quality'] ?? '' }}</td>
                <td>{{ $anyotherin['timely_supply'] ?? '' }}</td>
                <td>{{ $anyotherin['effectiveness'] ?? '' }}</td>
                <td>{{ $anyotherin['as_consultancy_service'] ?? '' }}</td>
                <td>{{ $anyotherin['price_reasonability'] ?? '' }}</td>
                <td>{{ $anyotherin['with_or_without_credit'] ?? '' }}</td>
                <td>{{ $anyotherin['diff_in_price_with_without_credit'] ?? '' }}</td>
                <td>{{ $anyotherin['remark'] ?? '' }}</td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700; background-color:#efefef;">
                 Rating
                </td>
                
                <td style="font-weight:700;background-color:#efefef;">
                 Assigned Number for filling rating
                </td>
                
                <td></td>
                
                <td style="font-weight:700;background-color:#efefef;">
                 Adequacy  
                </td>
                
                <td style="font-weight:700;background-color:#efefef;">
                 quality  
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
                
                <td></td>
                <td></td>
                <td style="background-color: green;color:white">
                  Strongly Agree
                </td>
                <td style="background-color: green;color:white">
                 3
                </td>
                <td></td>
                
                <td style="background-color: green;color:white">
                  Strongly Agree
                </td>
                <td>
                 9
                </td>
                
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
                
                <td></td>
                <td></td>
                <td style="background-color: #66971b; color:white;">
                 Agree
                </td>
                <td style="background-color: #66971b; color:white;">
                 2
                </td>
                <td></td>
                
                <td style="background-color: #66971b; color:white;">
                 Agree
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                
                </td>
               
                <td></td>
                <td></td>
                 <td style="background-color:yellow; color:black">
                 Satisfactory
                </td>
                <td style="background-color:yellow; color:black">
                 1
                </td>
                <td></td>
                
                <td style="background-color:yellow; color:black">
                 Satisfactory
                </td>
                
                <td>10</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
               
                <td></td>
                <td></td>
                 <td style="background-color:#ff7300; color:white">
               Disagree
                </td>
                <td style="background-color:#ff7300; color:white">
                 -2
                </td>
                <td></td>
                <td style="background-color:#ff7300; color:white">
                 Disagree
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                
                </td>
                <td>
                </td>
                <td>
                 
                </td>
                  <td style="background-color:red; color:white">
               Strongly Disagree
                </td>
                <td style="background-color:red; color:white">
                 -3
                </td>
                <td></td>
               
                 <td style="background-color:red; color:white">
               Strongly Disagree
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
               
                <td></td>
                <td></td>
                 <td>
               Can not say
                </td>
                <td>
                 0
                </td>
                <td></td>
                <td>
               Can not say
                </td>
                <td>1</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                S. No.
                </td>
                <td style="font-weight:700;">
                Particulars
                </td>
                <td>
                 Unit
                </td>
                <td>Indicator</td>
                <td>Remark</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                1
                </td>
                <td>
                Type of seed used
                </td>
                <td>
                 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                a
                </td>
                <td>
               Foundation Seed
                </td>
                
               @php
                $foundsed = json_decode($data->foundation_seed, true);
                @endphp
                
                <td>
                    {{ $foundsed['unit'] ?? '' }}
                </td>
                <td>{{ $foundsed['indicator'] ?? '' }}</td>
                <td>{{ $foundsed['remark'] ?? '' }}</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                b   
                </td>
                <td>
               Breeder Seed
                </td>
                @php
                $breedseed = json_decode($data->breeder_seed, true);
                @endphp
                
                <td>
                    {{ $breedseed['unit'] ?? '' }}
                </td>
                <td>{{ $breedseed['indicator'] ?? '' }}</td>
                <td>{{ $breedseed['remark'] ?? '' }}</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                c
                </td>
                <td>
               Certified Seed
                </td>
                @php
                $cer_seed = json_decode($data->certified_seed, true);
                @endphp
                
                <td>
                    {{ $cer_seed['unit'] ?? '' }}
                </td>
                <td>{{ $cer_seed['indicator'] ?? '' }}</td>
                <td>{{ $cer_seed['remark'] ?? '' }}</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                d
                </td>
                <td>
              Other Seed
                </td>
               @php
                $otherseed = json_decode($data->other_seed, true);
                @endphp
                
                <td>
                    {{ $otherseed['unit'] ?? '' }}
                </td>
                <td>{{ $otherseed['indicator'] ?? '' }}</td>
                <td>{{ $otherseed['remark'] ?? '' }}</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                e
                </td>
                <td>
                Brand of Seed
                </td>
                @php
                $brand_of_seed = json_decode($data->brand_of_seed, true);
                @endphp
                
                <td>
                    {{ $brand_of_seed['unit'] ?? '' }}
                </td>
                <td>{{ $brand_of_seed['indicator'] ?? '' }}</td>
                <td>{{ $brand_of_seed['remark'] ?? '' }}</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                2
                </td>
                <td style="font-weight:700;">
               Source of Seed
                </td>
                <td>
                 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                a
                </td>
                <td>
              Own Seed
                </td>
                @php
            $own_seed = json_decode($data->own_seed, true);
            @endphp
            
            <td>
                {{ $own_seed['unit'] ?? '' }}
            </td>
            <td>{{ $own_seed['indicator'] ?? '' }}</td>
            <td>{{ $own_seed['remark'] ?? '' }}</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
                <td>
                Seed Purchase from Market
                </td>
                @php
                $seed_purchase_from_market = json_decode($data->seed_purchase_from_market, true);
                @endphp
                
                <td>
                    {{ $seed_purchase_from_market['unit'] ?? '' }}
                </td>
                <td>{{ $seed_purchase_from_market['indicator'] ?? '' }}</td>
                <td>{{ $seed_purchase_from_market['remark'] ?? '' }}</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                c
                </td>
                <td>
                Any other source
                </td>
                @php
                $any_other_source = json_decode($data->any_other_source, true);
                @endphp
                
                <td>
                    {{ $any_other_source['unit'] ?? '' }}
                </td>
                <td>{{ $any_other_source['indicator'] ?? '' }}</td>
                <td>{{ $any_other_source['remark'] ?? '' }}</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                3
                </td>
                <td>
                Source : Distance from farm (KM) 
                </td>
               @php
                $source_distance_km = json_decode($data->source_distance_km, true);
                @endphp
                
                <td>
                    {{ $source_distance_km['unit'] ?? '' }}
                </td>
                <td>{{ $source_distance_km['indicator'] ?? '' }}</td>
                <td>{{ $source_distance_km['remark'] ?? '' }}</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                4
                </td>
                <td>
                Any Other 
                </td>
               @php
                $any_other = json_decode($data->any_other, true);
                @endphp
                
                <td>
                    {{ $any_other['unit'] ?? '' }}
                </td>
                <td>{{ $any_other['indicator'] ?? '' }}</td>
                <td>{{ $any_other['remark'] ?? '' }}</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
        </table>
        @endforeach
        @else
         
         <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
    <thead>
        <tr>
            <th>S. No</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars</th>
            <th>Unit</th>
            <th>Name of the input supplier / supporting value chain actor</th>
            <th>Adequacy</th>
            <th>quality</th>
            <th>Timely supply</th>
            <th>Effectiveness</th>
            <th>As per scientific recommendation (SOP) </th>
            <th>Price reasonability </th>
            <th>Is inputs on credit </th>
            <th>Difference in input price under with or without credit (%) </th>
            <th>Remark</th>
    </thead>

    <tr>
        <td colspan="5">
        </td>

        <td>Name</td>
        <td colspan="6" style="text-align:center; background-color:yellow; color:black; font-weight:700;">Rating as per
            given below matrix</td>
        <td>Y/N</td>
        <td>%</td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            1
        </td>
        <td></td>
        <td></td>
        <td>
            Seed
        </td>
       
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>


    <tr>
        <td style="text-align:center;">
            2
        </td>

        <td>
        </td>
        <td></td>
        <td>
            Plantlets
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            3
        </td>

        <td>

        </td>
        <td></td>
        <td>
            Fingerling (fishery)
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            4
        </td>

        <td></td>
        <td></td>
        <td>
            day old chick (Poultry)
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            5
        </td>

        <td></td>
        <td></td>
        <td>
            Feed
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            6
        </td>

        <td></td>
        <td></td>
        <td>
            Fertilizer
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            7
        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            Pesticides / Insecticide / Herbicides
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>


    <tr>
        <td style="text-align:center;">
            8
        </td>

        <td></td>
        <td></td>
        <td>
            Nutrients
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            9
        </td>

        <td></td>
        <td></td>
        <td>
            Medicine
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            10
        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            Labour
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            11
        </td>

        <td></td>
        <td></td>
        <td>
            Supply of diesel fuel / electricity
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            12
        </td>

        <td></td>
        <td></td>
        <td>
            Technology Transfer
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            13
        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            FM-Custom Hire Services
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            14
        </td>

        <td></td>
        <td></td>
        <td>
            Irrigation on Custom and Hiring
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>


    <tr>
        <td style="text-align:center;">
            15
        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            Source of Credit
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            a
        </td>

        <td></td>
        <td></td>
        <td>
            Input Credit
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            d
        </td>

        <td></td>
        <td></td>
        <td>
            Supply Credit
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            c
        </td>

        <td></td>
        <td></td>
        <td>
            Credit from NBSC
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            d
        </td>

        <td></td>
        <td></td>
        <td>
            Credit from Banks
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            e
        </td>

        <td></td>
        <td></td>
        <td>
            Other source/s
        </td>
        <td>
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            16
        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            Any Other Information
        </td>
        <td>
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td style="font-weight:700;">
            Rating
        </td>
        <td style="font-weight:700;">
            Assigned Number for filling rating
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td style="background-color: green;color:white">
            Strongly Agree
        </td>
        <td style="background-color: green;color:white">
            3
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td style="background-color: #66971b; color:white;">
            Agree
        </td>
        <td style="background-color: #66971b; color:white;">
            2
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td style="background-color:yellow; color:black">
            Satisfactory
        </td>
        <td style="background-color:yellow; color:black">
            1
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td style="background-color:#ff7300; color:white">
            Disagree
        </td>
        <td style="background-color:#ff7300; color:white">
            -2
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>

    </tr>

    <tr>
        <td style="text-align:center;">

        </td>
        <td>
        </td>
        <td>

        </td>
        <td style="background-color:red; color:white">
            Strongly Disagree
        </td>
        <td style="background-color:red; color:white">
            -3
        </td>
        <td></td>

        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">

        </td>

        <td></td>
        <td></td>
        <td>
            Can not say
        </td>
        <td>
            0
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            S. No.
        </td>
        <td style="font-weight:700;">
            Particulars
        </td>
        <td>
            Unit
        </td>
        <td>Indicator</td>
        <td>Remark</td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            1
        </td>
        <td>
            Type of seed used
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            a
        </td>
        <td>
            Foundation Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            b
        </td>
        <td>
            Breeder Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            c
        </td>
        <td>
            Certified Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            d
        </td>
        <td>
            Other Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            e
        </td>
        <td>
            Brand of Seed
        </td>
        <td>
        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            2
        </td>
        <td style="font-weight:700;">
            Source of Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            a
        </td>
        <td>
            Own Seed
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            b
        </td>
        <td>
            Seed Purchase from Market
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            c
        </td>
        <td>
            Any other source
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            3
        </td>
        <td>
            Source : Distance from farm (KM)
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    <tr>
        <td style="text-align:center;">
            4
        </td>
        <td>
            Any Other
        </td>
        <td>

        </td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

</table>

        @endif
    </div>


    <div class="table-responsive mt-5">
        
       
        
    </div>

</div>
<script>
        document.getElementById('filterBtn').addEventListener('click', function() {
            var selectedMonth = document.getElementById('month').value;
            var selectedYear = document.getElementById('year').value;
            var dataUrl = document.getElementById('filterBtn').getAttribute('data-url'); 
            var url = dataUrl;
            if (selectedMonth) {
                url += "?month=" + selectedMonth;
                if (selectedYear) {
                    url += "&year=" + selectedYear;
                }
            } else if (selectedYear) {
                url += "?year=" + selectedYear;
            }
            window.location.href = url;
        });
    </script>
    
    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>
@endsection