<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>
@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

<div class="container-fluid">
    <div class="table-responsive">
         @if(Session::has('success'))
        <p class="alert alert-success">{{ Session::get('success') }}</p>
        @endif
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
             @if($deshboard == 1)
        
            @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.e') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.e.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            @endif
        </div>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Backward Linkages Update</h1>
        </div>
        @if($data->isNotEmpty())
         @php
            $si = 1;
        @endphp
        @foreach($data as $data)
       <form>
        @csrf
        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
         <thead>
            <tr>
              <th>S. No</th>
              <th>FARMER ID</th>
              <th>Farmer Name</th>
              <th>Particulars</th>
              <th>Unit</th>
              <th>Name of the input supplier / supporting value chain actor</th>
              <th>Adequacy</th>
              <th>quality</th>
              <th>Timely supply</th>
              <th>Effectiveness</th>
              <th>As per scientific recommendation (SOP) </th>
              <th>Price reasonability </th>
              <th>Is inputs on credit  </th>
              <th>Difference in input price under with or without credit (%) </th>
              <th>Remark</th>
          </thead>
          
            <tr>
                <td colspan="5">
                </td>
                <td>Name</td>
                <td colspan="6" style="text-align:center; background-color:yellow; color:black; font-weight:700;">Rating as per given below matrix</td>
                <td>Y/N</td>
                <td>%</td>
                <td></td>
            </tr>
         
            <tr>
                <td style="text-align:center;">
                    {{ $si++ }}
                </td>
                <td><input class="form-control" name="" value="{{$data->farmer_code_id ?? ''}}" disabled></td>
                <td><input class="form-control" name="" value="{{$data->farmer_first_name ?? ''}} {{$data->farmer_last_name}}" disabled></td>
                <td>
                    Seed
                </td>
                 @php
                    $seedData = json_decode($data->seed, true);
                @endphp
                
                <td>
                    <input class="form-control" id="seed_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{ $seedData['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="seed_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{ $seedData['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                     $adequacyValue = $seedData['adequacy'] ?? '';
                    @endphp
                   <select class="form-control" id="seed_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                    <option value="">Select</option>
                    <option value="3" {{ $adequacyValue == '3' ? 'selected' : '' }}>Strongly Agree</option>
                    <option value="2" {{ $adequacyValue == '2' ? 'selected' : '' }}>Agree</option>
                    <option value="1" {{ $adequacyValue == '1' ? 'selected' : '' }}>Satisfactory</option>
                    <option value="-2" {{ $adequacyValue == '-2' ? 'selected' : '' }}>Disagree</option>
                    <option value="-3" {{ $adequacyValue == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                   </select>
                </td>
                <td>
                    @php
                     $sdvalue = $seedData['quality'] ?? '';
                    @endphp
                    <select class="form-control" id="seed_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                    <option value="">Select</option>
                    <option value="3" {{ $sdvalue == '3' ? 'selected' : '' }}>Strongly Agree</option>
                    <option value="2" {{ $sdvalue == '2' ? 'selected' : '' }}>Agree</option>
                    <option value="1" {{ $sdvalue == '1' ? 'selected' : '' }}>Satisfactory</option>
                    <option value="-2" {{ $sdvalue == '-2' ? 'selected' : '' }}>Disagree</option>
                    <option value="-3" {{ $sdvalue == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                   </select>    
                </td>
                <td>
                    @php
                     $stsupply = $seedData['timely_supply'] ?? '';
                    @endphp
                   <select class="form-control" id="seed_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                    <option value="">Select</option>
                    <option value="3" {{ $stsupply == '3' ? 'selected' : '' }}>Strongly Agree</option>
                    <option value="2" {{ $stsupply == '2' ? 'selected' : '' }}>Agree</option>
                    <option value="1" {{ $stsupply == '1' ? 'selected' : '' }}>Satisfactory</option>
                    <option value="-2" {{ $stsupply == '-2' ? 'selected' : '' }}>Disagree</option>
                    <option value="-3" {{ $stsupply == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                   </select>   
                </td>
                <td>
                    @php
                     $effect = $seedData['effectiveness'] ?? '';
                    @endphp
                   <select class="form-control" id="seed_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                    <option value="">Select</option>
                    <option value="3" {{ $effect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                    <option value="2" {{ $effect == '2' ? 'selected' : '' }}>Agree</option>
                    <option value="1" {{ $effect == '1' ? 'selected' : '' }}>Satisfactory</option>
                    <option value="-2" {{ $effect == '-2' ? 'selected' : '' }}>Disagree</option>
                    <option value="-3" {{ $effect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                   </select>
                </td>
                <td>
                    @php
                     $consutser = $seedData['as_consultancy_service'] ?? '';
                    @endphp
                   <select class="form-control" id="seed_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                    <option value="">Select</option>
                    <option value="3" {{ $consutser == '3' ? 'selected' : '' }}>Strongly Agree</option>
                    <option value="2" {{ $consutser == '2' ? 'selected' : '' }}>Agree</option>
                    <option value="1" {{ $consutser == '1' ? 'selected' : '' }}>Satisfactory</option>
                    <option value="-2" {{ $consutser == '-2' ? 'selected' : '' }}>Disagree</option>
                    <option value="-3" {{ $consutser == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                   </select>
                </td>
                <td>
                    @php
                     $pricerea = $seedData['price_reasonability'] ?? '';
                    @endphp
                   <select class="form-control" id="seed_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                    <option value="">Select</option>
                    <option value="3" {{ $pricerea == '3' ? 'selected' : '' }}>Strongly Agree</option>
                    <option value="2" {{ $pricerea == '2' ? 'selected' : '' }}>Agree</option>
                    <option value="1" {{ $pricerea == '1' ? 'selected' : '' }}>Satisfactory</option>
                    <option value="-2" {{ $pricerea == '-2' ? 'selected' : '' }}>Disagree</option>
                    <option value="-3" {{ $pricerea == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                   </select>
                </td>
                <td>
                    @php
                     $withcredit = $seedData['with_or_without_credit'] ?? '';
                    @endphp
                   <select class="form-control" id="seed_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                    <option value="">Select</option>
                    <option value="yes" {{ $withcredit == 'yes' ? 'selected' : '' }}>YES</option>
                    <option value="no" {{ $withcredit == 'no' ? 'selected' : '' }}>NO</option>
                   </select>
                </td>
                <td><input class="form-control" name="" id="seed_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{ $seedData['diff_in_price_with_without_credit'] ?? ''}}"></td>
                <td><input class="form-control" name="" id="seed_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{ $seedData['remark'] ?? ''}}"></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    2
                </td>
                
                <td>
                </td>
                <td></td>
                <td>
                   Plantlets
                </td>
                @php
                $plantletsData = json_decode($data->plantlets, true);
                @endphp
                
                <td>
                    <input class="form-control" id="plantlets_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$plantletsData['unit'] ?? ''}}">
                </td>
                
                <td><input class="form-control" id="plantlets_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$plantletsData['input_supplier_name'] ?? ''}}"></td>
                
                <td>
                    @php
                    $pdadeq = $plantletsData['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" id="plantlets_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $pdadeq == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $pdadeq == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $pdadeq == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $pdadeq == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $pdadeq == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $plantquality = $plantletsData['quality'] ?? '';
                    @endphp
                    <select class="form-control" id="plantlets_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $plantquality == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $plantquality == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $plantquality == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $plantquality == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $plantquality == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $planttimesupply = $plantletsData['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" id="plantlets_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $planttimesupply == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $planttimesupply == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $planttimesupply == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $planttimesupply == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $planttimesupply == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                
                </td>
                
                <td>
                    @php
                    $planteffectiv = $plantletsData['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="plantlets_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $planteffectiv == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $planteffectiv == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $planteffectiv == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $planteffectiv == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $planteffectiv == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                    
                </td>
                
                <td>
                    @php
                    $plantAcs = $plantletsData['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="plantlets_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $plantAcs == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $plantAcs == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $plantAcs == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $plantAcs == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $plantAcs == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $plantPR = $plantletsData['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="plantlets_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $plantPR == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $plantPR == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $plantPR == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $plantPR == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $plantPR == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                    </td>
                
                <td>
                    @php
                    $plantwithcre = $plantletsData['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="plantlets_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $plantwithcre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $plantwithcre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td>
                    <input class="form-control" name="" id="plantlets_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{ $plantletsData['diff_in_price_with_without_credit'] ?? ''}}">
                </td>
                
                <td>
                  <input class="form-control" name="" id="plantlets_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{ $plantletsData['remark'] ?? ''}}">
                </td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    3
                </td>
              
                <td>
                   
                </td>
                <td></td>
                  <td>
                    Fingerling (fishery)
                </td>
                @php
                $fingerlingData = json_decode($data->fingerling_fishery, true);
                @endphp
                
                <td>
                     <input class="form-control" id="fingerling_fishery_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{ $fingerlingData['unit'] ?? ''}}">
                </td>
                
                <td><input class="form-control" id="fingerling_fishery_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$fingerlingData['input_supplier_name'] ?? ''}}"></td>
                
                <td>
                    @php
                    $finlin = $fingerlingData['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" id="fingerling_fishery_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $finlin == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $finlin == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $finlin == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $finlin == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $finlin == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $finlinqua = $fingerlingData['quality'] ?? '';
                    @endphp
                    <select class="form-control" id="fingerling_fishery_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $finlinqua == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $finlinqua == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $finlinqua == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $finlinqua == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $finlinqua == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $finlintimesupp = $fingerlingData['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" id="fingerling_fishery_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $finlintimesupp == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $finlintimesupp == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $finlintimesupp == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $finlintimesupp == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $finlintimesupp == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $finlineff = $fingerlingData['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" id="fingerling_fishery_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $finlineff == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $finlineff == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $finlineff == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $finlineff == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $finlineff == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $finlinconser = $fingerlingData['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" id="fingerling_fishery_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $finlinconser == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $finlinconser == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $finlinconser == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $finlinconser == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $finlinconser == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $finlinprirea = $fingerlingData['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" id="fingerling_fishery_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $finlinprirea == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $finlinprirea == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $finlinprirea == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $finlinprirea == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $finlinprirea == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $finliwithcre = $fingerlingData['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fingerling_fishery_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $finliwithcre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $finliwithcre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" name="" id="fingerling_fishery_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$fingerlingData['diff_in_price_with_without_credit'] ?? '' }}"></td>
                
                <td><input class="form-control" id="fingerling_fishery_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$fingerlingData['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    4
                </td>
               
                <td></td>
                <td></td>
                 <td>
                   day old chick (Poultry)
                </td>
                @php
                $daychickData = json_decode($data->day_old_chick, true);
                @endphp
                
                <td>
                    <input class="form-control" id="day_old_chick_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$daychickData['unit'] ?? '' }}">
                </td>
                <td><input  class="form-control" id="day_old_chick_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$daychickData['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $dayadeq = $daychickData['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="day_old_chick_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $dayadeq == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $dayadeq == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $dayadeq == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $dayadeq == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $dayadeq == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $dayqua = $daychickData['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="day_old_chick_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $dayqua == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $dayqua == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $dayqua == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $dayqua == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $dayqua == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $daychtimesupp = $daychickData['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="day_old_chick_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $daychtimesupp == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $daychtimesupp == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $daychtimesupp == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $daychtimesupp == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $daychtimesupp == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $dayeffictiv = $daychickData['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="day_old_chick_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $dayeffictiv == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $dayeffictiv == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $dayeffictiv == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $dayeffictiv == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $dayeffictiv == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                
               <td>
                    @php
                    $dayconser = $daychickData['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="day_old_chick_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $dayconser == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $dayconser == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $dayconser == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $dayconser == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $dayconser == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $daypric = $daychickData['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="day_old_chick_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $daypric == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $daypric == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $daypric == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $daypric == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $daypric == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $daywithot = $daychickData['with_or_without_credit'] ?? '';
                    @endphp
                     <select class="form-control" name="" id="day_old_chick_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $daywithot == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $daywithot == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                <td><input class="form-control" id="day_old_chick_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name=""  value="{{$daychickData['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" name="" id="day_old_chick_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$daychickData['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    5
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Feed 
                </td>
               @php
                $feedData = json_decode($data->feed, true);
                @endphp
                
                <td>
                    <input class="form-control" name="" id="feed_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$feedData['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" name="" id="feed_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$feedData['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $feedadeq = $feedData['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="feed_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $feedadeq == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $feedadeq == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $feedadeq == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $feedadeq == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $feedadeq == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $feddqua = $feedData['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="feed_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $feddqua == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $feddqua == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $feddqua == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $feddqua == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $feddqua == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>

                <td>
                    @php
                    $feedtime = $feedData['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="feed_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $feedtime == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $feedtime == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $feedtime == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $feedtime == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $feedtime == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $feedeffect = $feedData['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="feed_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $feedeffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $feedeffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $feedeffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $feedeffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $feedeffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>

                <td>
                    @php
                    $feedconser = $feedData['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="feed_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $feedconser == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $feedconser == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $feedconser == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $feedconser == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $feedconser == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $feedprirea = $feedData['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="feed_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $feedprirea == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $feedprirea == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $feedprirea == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $feedprirea == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $feedprirea == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $feedeithcre = $feedData['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="feed_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $feedeithcre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $feedeithcre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input name="" id="feed_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}"  class="form-control" value="{{$feedData['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input name="" id="feed_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" value="{{$feedData['remark'] ?? '' }}"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    6
                </td>
               
                <td></td>
                <td></td>
                 <td>
                  Fertilizer
                </td>
                @php
                $fertilizerData = json_decode($data->fertilizer, true);
                @endphp
                
                <td>
                  <input name="" class="form-control" id="fertilizer_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$fertilizerData['unit'] ?? '' }}">
                </td>
                <td><input name="" class="form-control" id="fertilizer_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$fertilizerData['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $fertizeraq = $fertilizerData['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fertilizer_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $fertizeraq == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $fertizeraq == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $fertizeraq == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $fertizeraq == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $fertizeraq == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $fertiquality = $fertilizerData['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fertilizer_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $fertiquality == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $fertiquality == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $fertiquality == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $fertiquality == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $fertiquality == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $ferttimesupp = $fertilizerData['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fertilizer_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $ferttimesupp == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $ferttimesupp == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $ferttimesupp == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $ferttimesupp == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $ferttimesupp == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>

                <td>
                    @php
                    $ferteffect = $fertilizerData['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fertilizer_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $ferteffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $ferteffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $ferteffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $ferteffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $ferteffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>

                <td>
                    @php
                    $fertconservi = $fertilizerData['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fertilizer_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $fertconservi == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $fertconservi == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $fertconservi == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $fertconservi == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $fertconservi == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $fertpricres = $fertilizerData['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fertilizer_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $fertpricres == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $fertpricres == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $fertpricres == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $fertpricres == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $fertpricres == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $fertwithcre = $fertilizerData['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fertilizer_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $fertwithcre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $fertwithcre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" name="" id="fertilizer_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$fertilizerData['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" name="" id="fertilizer_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$fertilizerData['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    7
                </td>
                
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                  Pesticides / Insecticide / Herbicides
                </td>
                @php
                $pesticideData = json_decode($data->pesticides_insec_her, true);
                @endphp
                
                <td>
                    <input class="form-control" id="pesticides_insec_her_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$pesticideData['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="pesticides_insec_her_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$pesticideData['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $pesticideAde = $pesticideData['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="pesticides_insec_her_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $pesticideAde == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $pesticideAde == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $pesticideAde == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $pesticideAde == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $pesticideAde == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $pesticidequlity = $pesticideData['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="pesticides_insec_her_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $pesticidequlity == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $pesticidequlity == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $pesticidequlity == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $pesticidequlity == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $pesticidequlity == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $pesticidetimesupply = $pesticideData['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="pesticides_insec_her_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $pesticidetimesupply == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $pesticidetimesupply == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $pesticidetimesupply == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $pesticidetimesupply == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $pesticidetimesupply == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $pesticideeffect = $pesticideData['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="pesticides_insec_her_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $pesticideeffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $pesticideeffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $pesticideeffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $pesticideeffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $pesticideeffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $pesticideconserv = $pesticideData['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="pesticides_insec_her_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $pesticideconserv == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $pesticideconserv == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $pesticideconserv == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $pesticideconserv == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $pesticideconserv == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $pesticidpricereas = $pesticideData['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="pesticides_insec_her_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $pesticidpricereas == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $pesticidpricereas == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $pesticidpricereas == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $pesticidpricereas == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $pesticidpricereas == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $peseithcre = $pesticideData['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="pesticides_insec_her_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $peseithcre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $peseithcre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" id="pesticides_insec_her_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$pesticideData['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" id="pesticides_insec_her_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$pesticideData['remark'] ?? '' }}"></td>
            </tr>
            
            
            <tr>
                <td style="text-align:center;">
                    8
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Nutrients
                </td>
                @php
                $nutrientsdata = json_decode($data->nutrients, true);
                @endphp
                
                <td>
                    <input class="form-control" name="" id="nutrients_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$nutrientsdata['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" name="" id="nutrients_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$nutrientsdata['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $nutriadeq = $nutrientsdata['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="nutrients_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nutriadeq == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nutriadeq == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nutriadeq == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nutriadeq == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nutriadeq == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $nutriqulity = $nutrientsdata['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="nutrients_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nutriqulity == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nutriqulity == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nutriqulity == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nutriqulity == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nutriqulity == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $nutritimesupp = $nutrientsdata['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="nutrients_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nutritimesupp == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nutritimesupp == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nutritimesupp == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nutritimesupp == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nutritimesupp == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $nutrieffect= $nutrientsdata['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="nutrients_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nutrieffect== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nutrieffect== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nutrieffect== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nutrieffect== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nutrieffect== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                                
               <td>
                    @php
                    $nutriconsersev= $nutrientsdata['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="nutrients_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nutriconsersev== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nutriconsersev== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nutriconsersev== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nutriconsersev== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nutriconsersev== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $nutriprireas= $nutrientsdata['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="nutrients_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nutriprireas== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nutriprireas== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nutriprireas== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nutriprireas== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nutriprireas== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>

                
                <td>
                    @php
                    $nutrieithout = $nutrientsdata['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="nutrients_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $nutrieithout == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $nutrieithout == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" name="" id="nutrients_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$nutrientsdata['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" name="" id="nutrients_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$nutrientsdata['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    9
                </td>
              
                <td></td>
                <td></td>
                  <td>
               Medicine
                </td>
                @php
                $medicinedata = json_decode($data->medicine, true);
                @endphp
                
                <td>
                    <input class="form-control" id="medicine_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$medicinedata['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="medicine_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$medicinedata['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $medicinadeq= $medicinedata['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="medicine_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $medicinadeq== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $medicinadeq== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $medicinadeq== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $medicinadeq== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $medicinadeq== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $medicinquli= $medicinedata['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="medicine_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $medicinquli== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $medicinquli== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $medicinquli== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $medicinquli== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $medicinquli== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $medicintimesupp= $medicinedata['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="medicine_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $medicintimesupp== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $medicintimesupp== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $medicintimesupp== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $medicintimesupp== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $medicintimesupp== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $medicineffect= $medicinedata['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="medicine_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $medicineffect== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $medicineffect== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $medicineffect== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $medicineffect== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $medicineffect== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $medicineconslser= $medicinedata['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="medicine_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $medicineconslser== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $medicineconslser== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $medicineconslser== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $medicineconslser== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $medicineconslser== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $medicineprice= $medicinedata['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="medicine_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $medicineprice== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $medicineprice== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $medicineprice== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $medicineprice== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $medicineprice== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $medicineithcre = $medicinedata['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="medicine_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $medicineithcre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $medicineithcre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" name="" id="medicine_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$medicinedata['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" name="" id="medicine_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$medicinedata['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    10
                </td>
             
                <td></td>
                <td></td>
                   <td style="font-weight:700;">
                 Labour
                </td>
               @php
                $labourdata = json_decode($data->labour, true);
               @endphp
                
                <td>
                    <input class="form-control" name="" id="labour_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$labourdata['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="labour_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{ $labourdata['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $labourade= $labourdata['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="labour_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $labourade== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $labourade== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $labourade== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $labourade== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $labourade== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $labourqulity= $labourdata['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="labour_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $labourqulity== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $labourqulity== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $labourqulity== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $labourqulity== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $labourqulity== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $labourtimesupply= $labourdata['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="labour_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $labourtimesupply== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $labourtimesupply== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $labourtimesupply== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $labourtimesupply== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $labourtimesupply== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $laboureffect= $labourdata['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="labour_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $laboureffect== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $laboureffect== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $laboureffect== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $laboureffect== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $laboureffect== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $labourconserv= $labourdata['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="labour_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $labourconserv== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $labourconserv== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $labourconserv== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $labourconserv== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $labourconserv== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $labourpriceres= $labourdata['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="labour_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $labourpriceres== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $labourpriceres== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $labourpriceres== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $labourpriceres== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $labourpriceres== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $laboureith = $labourdata['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="labour_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $laboureith == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $laboureith == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" id="labour_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$labourdata['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" id="labour_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$labourdata['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    11
                </td>
             
                <td></td>
                <td></td>
                   <td>
                 Supply of diesel fuel / electricity
                </td>
                @php
                $supplydata = json_decode($data->supply_of_diesel_fuel_electricity, true);
                @endphp
                
                <td>
                    <input class="form-control" name="" id="supply_of_diesel_fuel_electricity_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$supplydata['unit'] ?? '' }}">
                </td>
                
                <td><input class="form-control" name="" id="supply_of_diesel_fuel_electricity_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$supplydata['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $supplyadeq= $supplydata['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" id="supply_of_diesel_fuel_electricity_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="">
                        <option value="">Select</option>
                        <option value="3" {{ $supplyadeq== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $supplyadeq== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $supplyadeq== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $supplyadeq== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $supplyadeq== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
             
                
                <td>
                    @php
                    $supplyqulity= $supplydata['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_of_diesel_fuel_electricity_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $supplyqulity== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $supplyqulity== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $supplyqulity== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $supplyqulity== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $supplyqulity== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $supplytimesupp= $supplydata['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_of_diesel_fuel_electricity_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $supplytimesupp== '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $supplytimesupp== '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $supplytimesupp== '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $supplytimesupp== '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $supplytimesupp== '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $supplyeffect = $supplydata['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_of_diesel_fuel_electricity_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $supplyeffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $supplyeffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $supplyeffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $supplyeffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $supplyeffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $supplyconserv = $supplydata['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_of_diesel_fuel_electricity_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $supplyconserv == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $supplyconserv == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $supplyconserv == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $supplyconserv == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $supplyconserv == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $supplyprice = $supplydata['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_of_diesel_fuel_electricity_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $supplyprice == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $supplyprice == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $supplyprice == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $supplyprice == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $supplyprice == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $supplyeithcredit = $supplydata['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_of_diesel_fuel_electricity_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $supplyeithcredit == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $supplyeithcredit == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" name="" id="supply_of_diesel_fuel_electricity_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$supplydata['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" name="" id="supply_of_diesel_fuel_electricity_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$supplydata['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    12
                </td>
              
                <td></td>
                <td></td>
                  <td>
                 Technology Transfer 
                </td>
               @php
                $techdata = json_decode($data->technology_transfer, true);
                @endphp
                
                <td>
                    <input class="form-control" id="technology_transfer_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$techdata['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="technology_transfer_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$techdata['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $techade = $techdata['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="technology_transfer_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $techade == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $techade == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $techade == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $techade == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $techade == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $techqulity = $techdata['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="technology_transfer_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $techqulity == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $techqulity == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $techqulity == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $techqulity == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $techqulity == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $techtimesupply = $techdata['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="technology_transfer_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $techtimesupply == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $techtimesupply == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $techtimesupply == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $techtimesupply == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $techtimesupply == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                                
                <td>
                    @php
                    $techeffect = $techdata['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="technology_transfer_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $techeffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $techeffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $techeffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $techeffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $techeffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $techconserv = $techdata['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="technology_transfer_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $techconserv == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $techconserv == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $techconserv == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $techconserv == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $techconserv == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $techpricereas = $techdata['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="technology_transfer_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $techpricereas == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $techpricereas == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $techpricereas == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $techpricereas == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $techpricereas == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $techeithcredit = $techdata['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="technology_transfer_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $techeithcredit == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $techeithcredit == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" name="" id="technology_transfer_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$techdata['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" name="" id="technology_transfer_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$techdata['remark'] ?? '' }}"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    13
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                  FM-Custom Hire Services
                </td>
                @php
                $fmdata = json_decode($data->fm_custom_hire_services, true);
                @endphp
                <td>
                    <input class="form-control" id="fm_custom_hire_services_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$fmdata['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="fm_custom_hire_services_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$fmdata['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $fmdataade = $fmdata['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fm_custom_hire_services_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $fmdataade == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $fmdataade == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $fmdataade == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $fmdataade == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $fmdataade == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $fmdataqulity = $fmdata['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fm_custom_hire_services_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $fmdataqulity == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $fmdataqulity == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $fmdataqulity == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $fmdataqulity == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $fmdataqulity == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $fmdatatimesupp = $fmdata['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fm_custom_hire_services_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $fmdatatimesupp == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $fmdatatimesupp == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $fmdatatimesupp == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $fmdatatimesupp == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $fmdatatimesupp == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $fmdataeffect = $fmdata['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fm_custom_hire_services_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $fmdataeffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $fmdataeffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $fmdataeffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $fmdataeffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $fmdataeffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $fmdataconserv = $fmdata['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fm_custom_hire_services_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $fmdataconserv == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $fmdataconserv == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $fmdataconserv == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $fmdataconserv == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $fmdataconserv == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
            <td>
                @php
                $fmdatapricre = $fmdata['price_reasonability'] ?? '';
                @endphp
                <select class="form-control" name="" id="fm_custom_hire_services_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                    <option value="">Select</option>
                    <option value="3" {{ $fmdatapricre == '3' ? 'selected' : '' }}>Strongly Agree</option>
                    <option value="2" {{ $fmdatapricre == '2' ? 'selected' : '' }}>Agree</option>
                    <option value="1" {{ $fmdatapricre == '1' ? 'selected' : '' }}>Satisfactory</option>
                    <option value="-2" {{ $fmdatapricre == '-2' ? 'selected' : '' }}>Disagree</option>
                    <option value="-3" {{ $fmdatapricre == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                </select>
               </td>
                
               <td>
                    @php
                    $famdataeithcre = $fmdata['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="fm_custom_hire_services_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $famdataeithcre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $famdataeithcre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" id="fm_custom_hire_services_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$fmdata['diff_in_price_with_without_credit'] ?? '' }}"></td>
                
                <td><input class="form-control" id="fm_custom_hire_services_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$fmdata['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    14
                </td>
               
                <td></td>
                <td></td>
                 <td>
                 Irrigation on Custom and Hiring
                </td>
                
                @php
                $irga = json_decode($data->irrigation_on_custom_and_hiring, true);
                @endphp
                
                <td>
                    <input class="form-control" id="irrigation_on_custom_and_hiring_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$irga['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" name="" value="{{$irga['input_supplier_name'] ?? '' }}" id="irrigation_on_custom_and_hiring_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}"></td>
                
                <td>
                    @php
                    $irgaadeq = $irga['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="irrigation_on_custom_and_hiring_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $irgaadeq == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $irgaadeq == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $irgaadeq == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $irgaadeq == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $irgaadeq == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $irgaqulity = $irga['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="irrigation_on_custom_and_hiring_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $irgaqulity == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $irgaqulity == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $irgaqulity == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $irgaqulity == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $irgaqulity == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $irgatimesp = $irga['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="irrigation_on_custom_and_hiring_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $irgatimesp == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $irgatimesp == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $irgatimesp == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $irgatimesp == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $irgatimesp == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $irgaeffect = $irga['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="irrigation_on_custom_and_hiring_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $irgaeffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $irgaeffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $irgaeffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $irgaeffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $irgaeffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $irgaconserv = $irga['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="irrigation_on_custom_and_hiring_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $irgaconserv == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $irgaconserv == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $irgaconserv == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $irgaconserv == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $irgaconserv == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $irgapricerea = $irga['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="irrigation_on_custom_and_hiring_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $irgapricerea == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $irgapricerea == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $irgapricerea == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $irgapricerea == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $irgapricerea == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $irgaeith = $irga['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="irrigation_on_custom_and_hiring_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $irgaeith == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $irgaeith == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" name="" id="irrigation_on_custom_and_hiring_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$irga['diff_in_price_with_without_credit'] ?? '' }}"></td>
                
                <td><input class="form-control" name="" value="{{$irga['remark']  ?? ''}}" id="irrigation_on_custom_and_hiring_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}"></td>
            </tr>
            
            
             <tr>
                <td style="text-align:center;">
                    15
                </td>
                
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                Source of Credit
                </td>
                @php
                $sourcece = json_decode($data->source_of_credit, true) ?? '';
                @endphp
                
                <td>
                    <input class="form-control" id="source_of_credit_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$sourcece['unit'] ?? ''}}">
                </td>
                <td><input class="form-control" name="" id="source_of_credit_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$sourcece['input_supplier_name'] ?? ''}}"></td>
                
                <td>
                   @php
                    $sourcece_datas = $sourcece['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="source_of_credit_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $sourcece_datas == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $sourcece_datas == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $sourcece_datas == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $sourcece_datas == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $sourcece_datas == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                
                
                <td>
                    @php
                    $souData = $sourcece['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="source_of_credit_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $souData == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $souData == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $souData == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $souData == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $souData == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $souTimesup = $sourcece['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="source_of_credit_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $souTimesup == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $souTimesup == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $souTimesup == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $souTimesup == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $souTimesup == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                   @php
                    $soueffeci = $sourcece['effectiveness'] ?? '';
                    @endphp
                      <select class="form-control" name="" id="source_of_credit_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                            <option value="">Select</option>
                            <option value="3" {{ $soueffeci == '3' ? 'selected' : '' }}>Strongly Agree</option>
                            <option value="2" {{ $soueffeci == '2' ? 'selected' : '' }}>Agree</option>
                            <option value="1" {{ $soueffeci == '1' ? 'selected' : '' }}>Satisfactory</option>
                            <option value="-2" {{ $soueffeci == '-2' ? 'selected' : '' }}>Disagree</option>
                            <option value="-3" {{ $soueffeci == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                  @php
                    $souconser = $sourcece['as_consultancy_service'] ?? '';
                    @endphp
                      <select class="form-control" name="" id="source_of_credit_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                            <option value="">Select</option>
                            <option value="3" {{ $souconser == '3' ? 'selected' : '' }}>Strongly Agree</option>
                            <option value="2" {{ $souconser == '2' ? 'selected' : '' }}>Agree</option>
                            <option value="1" {{ $souconser == '1' ? 'selected' : '' }}>Satisfactory</option>
                            <option value="-2" {{ $souconser == '-2' ? 'selected' : '' }}>Disagree</option>
                            <option value="-3" {{ $souconser == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                
                
                <td>
                  @php
                    $soucopri_re = $sourcece['price_reasonability'] ?? '';
                    @endphp
                      <select class="form-control" name="" id="source_of_credit_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                            <option value="">Select</option>
                            <option value="3" {{ $soucopri_re == '3' ? 'selected' : '' }}>Strongly Agree</option>
                            <option value="2" {{ $soucopri_re == '2' ? 'selected' : '' }}>Agree</option>
                            <option value="1" {{ $soucopri_re == '1' ? 'selected' : '' }}>Satisfactory</option>
                            <option value="-2" {{ $soucopri_re == '-2' ? 'selected' : '' }}>Disagree</option>
                            <option value="-3" {{ $soucopri_re == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                <td>
                    @php
                    $sourwithcre = $sourcece['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="source_of_credit_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $sourwithcre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $sourwithcre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                <td> 
                    <input class="form-control" id="source_of_credit_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{ $sourcece['diff_in_price_with_without_credit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="source_of_credit_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$sourcece['remark']  ?? ''}}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Input Credit
                </td>
                @php
                $inputcre = json_decode($data->input_credit, true);
                @endphp
                
                <td>
                    <input class="form-control" id="input_credit_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$inputcre['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="input_credit_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$inputcre['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $inputcre = $inputcre['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="input_credit_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $inputcre == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $inputcre == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $inputcre == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $inputcre == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $inputcre == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                

                <td>
                    @php
                    $inpQulity = $inputcre['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="input_credit_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $inpQulity == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $inpQulity == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $inpQulity == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $inpQulity == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $inpQulity == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                
                <td>
                    @php
                    $inptimesupply = $inputcre['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="input_credit_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $inptimesupply == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $inptimesupply == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $inptimesupply == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $inptimesupply == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $inptimesupply == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                

                <td>
                    @php
                    $inpeffect = $inputcre['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="input_credit_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $inpeffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $inpeffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $inpeffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $inpeffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $inpeffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                

                <td>
                    @php
                    $inpconser = $inputcre['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="input_credit_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $inpconser == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $inpconser == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $inpconser == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $inpconser == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $inpconser == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                

                <td>
                    @php
                    $inpprireas = $inputcre['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="input_credit_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $inpprireas == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $inpprireas == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $inpprireas == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $inpprireas == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $inpprireas == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $inputwithcre = $inputcre['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="input_credit_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $inputwithcre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $inputwithcre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" id="input_credit_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$inputcre['diff_in_price_with_without_credit'] ?? ''}}"></td>
                <td><input class="form-control" id="input_credit_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{ $inputcre['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    d
                </td>
                
                <td></td>
                <td></td>
                <td>
                 Supply Credit
                </td>
                @php
                $supplycre = json_decode($data->supply_credit, true);
                @endphp
                
                <td>
                    <input class="form-control" id="supply_credit_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$supplycre['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="supply_credit_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$supplycre['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $supade = $supplycre['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_credit_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $supade == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $supade == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $supade == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $supade == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $supade == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                

                <td>
                    @php
                    $supqua = $supplycre['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_credit_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $supqua == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $supqua == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $supqua == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $supqua == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $supqua == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                

                <td>
                    @php
                    $suptimesupp = $supplycre['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_credit_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $suptimesupp == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $suptimesupp == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $suptimesupp == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $suptimesupp == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $suptimesupp == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                

                <td>
                    @php
                    $suppeffect = $supplycre['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_credit_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $suppeffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $suppeffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $suppeffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $suppeffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $suppeffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                
                <td>
                    @php
                    $suppconser = $supplycre['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_credit_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $suppconser == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $suppconser == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $suppconser == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $suppconser == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $suppconser == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                 </td>
                
                <td>
                    @php
                    $suppprirea = $supplycre['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_credit_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $suppprirea == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $suppprirea == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $suppprirea == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $suppprirea == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $suppprirea == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                                
                
                <td>
                    @php
                    $suppeithc = $supplycre['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="supply_credit_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $suppeithc == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $suppeithc == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                
                
                <td><input class="form-control" name="" id="supply_credit_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$supplycre['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" name="" id="supply_credit_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{ $supplycre['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                c
                </td>
               
                <td></td>
                <td></td>
                 <td>
                Credit from NBSC
                </td>
               @php
                $nbsc = json_decode($data->credit_from_nbsc, true);
                @endphp
                
                <td>
                    <input class="form-control" id="credit_from_nbsc_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$nbsc['unit'] ?? '' }}">
                </td>
                
                <td><input class="form-control" id="credit_from_nbsc_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$nbsc['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $nbscpric = $nbsc['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_nbsc_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nbscpric == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nbscpric == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nbscpric == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nbscpric == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nbscpric == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $nbscqua = $nbsc['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_nbsc_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nbscqua == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nbscqua == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nbscqua == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nbscqua == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nbscqua == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $nbsctim = $nbsc['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_nbsc_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nbsctim == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nbsctim == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nbsctim == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nbsctim == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nbsctim == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $nbsceffect = $nbsc['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_nbsc_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nbsceffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nbsceffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nbsceffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nbsceffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nbsceffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $nbscconser = $nbsc['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_nbsc_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nbscconser == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nbscconser == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nbscconser == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nbscconser == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nbscconser == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $nbsprire = $nbsc['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_nbsc_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $nbsprire == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $nbsprire == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $nbsprire == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $nbsprire == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $nbsprire == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $nbscwithcre = $nbsc['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_nbsc_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $nbscwithcre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $nbscwithcre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" name="" id="credit_from_nbsc_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$nbsc['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" name="" id="credit_from_nbsc_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$nbsc['remark'] ?? '' }}"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    d
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Credit from Banks
                </td>
                @php
                $bankcre = json_decode($data->credit_from_banks, true);
                @endphp
                
                <td>
                    <input class="form-control" id="credit_from_banks_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$bankcre['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" name="" id="credit_from_banks_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$bankcre['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $backcreadeq = $bankcre['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_banks_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $backcreadeq == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $backcreadeq == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $backcreadeq == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $backcreadeq == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $backcreadeq == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $backcrquality = $bankcre['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_banks_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $backcrquality == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $backcrquality == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $backcrquality == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $backcrquality == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $backcrquality == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $backcrtimesup = $bankcre['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_banks_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $backcrtimesup == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $backcrtimesup == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $backcrtimesup == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $backcrtimesup == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $backcrtimesup == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
               <td>
                    @php
                    $backcreffect = $bankcre['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_banks_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $backcreffect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $backcreffect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $backcreffect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $backcreffect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $backcreffect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $backcreasconser = $bankcre['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_banks_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $backcreasconser == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $backcreasconser == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $backcreasconser == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $backcreasconser == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $backcreasconser == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $backcreprireas = $bankcre['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_banks_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $backcreprireas == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $backcreprireas == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $backcreprireas == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $backcreprireas == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $backcreprireas == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $backcrewith = $bankcre['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="credit_from_banks_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $backcrewith == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $backcrewith == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" name="" id="credit_from_banks_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{ $bankcre['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" name="" id="credit_from_banks_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" value="{{$bankcre['remark'] ?? '' }}"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    e
                </td>
              
                <td></td>
                <td></td>
                  <td>
                Other source/s
                </td>
               @php
                $othersource = json_decode($data->other_source, true);
                @endphp
                
                <td>
                    <input class="form-control" id="other_source_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$othersource['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="other_source_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{ $othersource['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $othersou_adeq = $othersource['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="other_source_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $othersou_adeq == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $othersou_adeq == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $othersou_adeq == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $othersou_adeq == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $othersou_adeq == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                
                <td>
                    @php
                    $othersou_quality = $othersource['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="other_source_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $othersou_quality == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $othersou_quality == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $othersou_quality == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $othersou_quality == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $othersou_quality == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                
                <td>
                    @php
                    $othersou_time_supply = $othersource['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="other_source_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $othersou_time_supply == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $othersou_time_supply == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $othersou_time_supply == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $othersou_time_supply == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $othersou_time_supply == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $othersou_effecti = $othersource['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="other_source_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $othersou_effecti == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $othersou_effecti == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $othersou_effecti == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $othersou_effecti == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $othersou_effecti == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                
                <td>
                    @php
                    $othersou_asCon_ser = $othersource['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="other_source_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $othersou_asCon_ser == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $othersou_asCon_ser == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $othersou_asCon_ser == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $othersou_asCon_ser == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $othersou_asCon_ser == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                
               <td>
                    @php
                    $othersou_price_reas = $othersource['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="other_source_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $othersou_price_reas == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $othersou_price_reas == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $othersou_price_reas == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $othersou_price_reas == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $othersou_price_reas == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                
                <td>
                    @php
                    $othersource_with_cre = $othersource['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="other_source_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $othersource_with_cre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $othersource_with_cre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" id="other_source_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{ $othersource['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" id="other_source_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$othersource['remark'] ?? '' }}"></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                    16
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
               Any Other Information
                </td>
               @php
                $anyotherin = json_decode($data->any_other_information, true);
                @endphp
                
                <td>
                    <input class="form-control" id="any_other_information_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$anyotherin['unit'] ?? '' }}">
                </td>
                <td><input class="form-control" id="any_other_information_supplier_name_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$anyotherin['input_supplier_name'] ?? '' }}"></td>
                
                <td>
                    @php
                    $anyotherin_adeq = $anyotherin['adequacy'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="any_other_information_adequacy_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $anyotherin_adeq == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $anyotherin_adeq == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $anyotherin_adeq == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $anyotherin_adeq == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $anyotherin_adeq == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $anyotherin_qulity = $anyotherin['quality'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="any_other_information_quality_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $anyotherin_qulity == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $anyotherin_qulity == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $anyotherin_qulity == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $anyotherin_qulity == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $anyotherin_qulity == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $anyotherin_time_sup = $anyotherin['timely_supply'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="any_other_information_timely_supply_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $anyotherin_time_sup == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $anyotherin_time_sup == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $anyotherin_time_sup == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $anyotherin_time_sup == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $anyotherin_time_sup == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $anyotherin_effect = $anyotherin['effectiveness'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="any_other_information_effectiveness_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $anyotherin_effect == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $anyotherin_effect == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $anyotherin_effect == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $anyotherin_effect == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $anyotherin_effect == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $anyotherin_conserv = $anyotherin['as_consultancy_service'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="any_other_information_as_consultancy_service_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $anyotherin_conserv == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $anyotherin_conserv == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $anyotherin_conserv == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $anyotherin_conserv == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $anyotherin_conserv == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $anyotherin_priceRes = $anyotherin['price_reasonability'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="any_other_information_price_reasonability_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="3" {{ $anyotherin_priceRes == '3' ? 'selected' : '' }}>Strongly Agree</option>
                        <option value="2" {{ $anyotherin_priceRes == '2' ? 'selected' : '' }}>Agree</option>
                        <option value="1" {{ $anyotherin_priceRes == '1' ? 'selected' : '' }}>Satisfactory</option>
                        <option value="-2" {{ $anyotherin_priceRes == '-2' ? 'selected' : '' }}>Disagree</option>
                        <option value="-3" {{ $anyotherin_priceRes == '-3' ? 'selected' : '' }}>Strongly Disagree</option>
                    </select>
                </td>
                
                <td>
                    @php
                    $anyotherin_withCre = $anyotherin['with_or_without_credit'] ?? '';
                    @endphp
                    <select class="form-control" name="" id="any_other_information_with_or_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}">
                        <option value="">Select</option>
                        <option value="yes" {{ $anyotherin_withCre == 'yes' ? 'selected' : '' }}>Yes</option>
                        <option value="no" {{ $anyotherin_withCre == 'no' ? 'selected' : '' }}>No</option>
                    </select>
                </td>
                
                <td><input class="form-control" id="any_other_information_diff_in_price_with_without_credit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{ $anyotherin['diff_in_price_with_without_credit'] ?? '' }}"></td>
                <td><input class="form-control" id="any_other_information_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" name="" value="{{$anyotherin['remark'] ?? '' }}"></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                    
                </td>
               
                <td></td>
                <td></td>
                 <td style="font-weight:700;">
                 Rating
                </td>
                <td style="font-weight:700;">
                 Assigned Number for filling rating
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
                
                <td></td>
                <td></td>
                <td style="background-color: green;color:white">
                  Strongly Agree
                </td>
                <td style="background-color: green;color:white">
                 3
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
                
                <td></td>
                <td></td>
                <td style="background-color: #66971b; color:white;">
                 Agree
                </td>
                <td style="background-color: #66971b; color:white;">
                 2
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                
                </td>
               
                <td></td>
                <td></td>
                 <td style="background-color:yellow; color:black">
                 Satisfactory
                </td>
                <td style="background-color:yellow; color:black">
                 1
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
               
                <td></td>
                <td></td>
                 <td style="background-color:#ff7300; color:white">
               Disagree
                </td>
                <td style="background-color:#ff7300; color:white">
                 -2
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                
            </tr>
            
             <tr>
                <td style="text-align:center;">
                
                </td>
                <td>
                </td>
                <td>
                 
                </td>
                  <td style="background-color:red; color:white">
               Strongly Disagree
                </td>
                <td style="background-color:red; color:white">
                 -3
                </td>
                <td></td>
               
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                
                </td>
               
                <td></td>
                <td></td>
                 <td>
               Can not say
                </td>
                <td>
                 0
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                S. No.
                </td>
                <td style="font-weight:700;">
                Particulars
                </td>
                <td>
                 Unit
                </td>
                <td>Indicator</td>
                <td>Remark</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                1
                </td>
                <td>
                Type of seed used
                </td>
                <td>
                 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                a
                </td>
                <td>
                 Foundation Seed
                </td>
                
                @php
                $foundsed = json_decode($data->foundation_seed, true);
                @endphp
                
                <td>
                    <input type="number" id="foundation_seed_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $foundsed['unit'] ?? '' }}">
                </td>
                <td><input type="text" id="foundation_seed_indicator_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $foundsed['indicator'] ?? '' }}"></td>
                <td><input type="text" id="foundation_seed_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $foundsed['remark'] ?? '' }}"></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                 <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                b   
                </td>
                <td>
               Breeder Seed
                </td>
                @php
                $breedseed = json_decode($data->breeder_seed, true);
                @endphp
                
                <td>
                    <input type="number" id="breeder_seed_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $breedseed['unit'] ?? '' }}">
                </td>
                <td><input type="text" id="breeder_seed_indicator_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $breedseed['indicator'] ?? '' }}"></td>
                <td><input type="text" id="breeder_seed_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $breedseed['remark'] ?? '' }}"></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                c
                </td>
                <td>
               Certified Seed
                </td>
                @php
                $cer_seed = json_decode($data->certified_seed, true);
                @endphp
                
                <td>
                    <input type="number" id="certified_seed_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $cer_seed['unit'] ?? '' }}">
                </td>
                <td><input type="text"  id="certified_seed_indicator_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $cer_seed['indicator'] ?? '' }}"></td>
                <td><input type="text" id="certified_seed_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $cer_seed['remark'] ?? '' }}"></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                d
                </td>
                <td>
              Other Seed
                </td>
               @php
                $otherseed = json_decode($data->other_seed, true);
                @endphp
                
                <td>
                    <input type="number" id="other_seed_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $otherseed['unit'] ?? '' }}">
                </td>
                <td><input type="text" id="other_seed_indicator_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $otherseed['indicator'] ?? '' }}"></td>
                <td><input type="text" id="other_seed_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $otherseed['remark'] ?? '' }}"></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                e
                </td>
                <td>
                Brand of Seed
                </td>
                @php
                $brand_of_seed = json_decode($data->brand_of_seed, true);
                @endphp
                
                <td>
                    <input type="number" id="brand_of_seed_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $brand_of_seed['unit'] ?? '' }}">
                </td>
                <td><input type="text" id="brand_of_seed_indicator_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $brand_of_seed['indicator'] ?? '' }}"></td>
                <td><input type="text" id="brand_of_seed_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $brand_of_seed['remark'] ?? '' }}"></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                2
                </td>
                <td style="font-weight:700;">
               Source of Seed
                </td>
                <td>
                 
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                a
                </td>
                <td>
              Own Seed
                </td>
                @php
                $own_seed = json_decode($data->own_seed, true);
                @endphp
            
            <td>
                <input type="number" id="own_seed_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $own_seed['unit'] ?? '' }}">
            </td>
            <td><input type="text" id="own_seed_indicator_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $own_seed['indicator'] ?? '' }}"></td>
            <td><input type="text" id="own_seed_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $own_seed['remark'] ?? '' }}"></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                b
                </td>
                <td>
                Seed Purchase from Market
                </td>
                @php
                $seed_purchase_from_market = json_decode($data->seed_purchase_from_market, true);
                @endphp
                
                <td>
                    <input type="number" id="seed_purchase_from_market_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $seed_purchase_from_market['unit'] ?? '' }}">
                </td>
                <td><input type="text" id="seed_purchase_from_market_indicator_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $seed_purchase_from_market['indicator'] ?? '' }}"></td>
                <td><input type="text" id="seed_purchase_from_market_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $seed_purchase_from_market['remark'] ?? '' }}"></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
             <tr>
                <td style="text-align:center;">
                c
                </td>
                <td>
                Any other source
                </td>
                @php
                $any_other_source = json_decode($data->any_other_source, true);
                @endphp
                
                <td>
                    <input type="number" id="any_other_source_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $any_other_source['unit'] ?? '' }}">
                </td>
                <td><input type="text" id="any_other_source_indicator_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $any_other_source['indicator'] ?? '' }}"></td>
                <td><input type="text" id="any_other_source_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $any_other_source['remark'] ?? '' }}"></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
              <tr>
                <td style="text-align:center;">
                3
                </td>
                <td>
                Source : Distance from farm (KM) 
                </td>
               @php
                $source_distance_km = json_decode($data->source_distance_km, true);
                @endphp
                
                <td>
                    <input type="number" id="source_distance_km_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $source_distance_km['unit'] ?? '' }}">
                </td>
                <td><input type="text" id="source_distance_km_indicator_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $source_distance_km['indicator'] ?? '' }}"></td>
                <td><input type="text" id="source_distance_km_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $source_distance_km['remark'] ?? '' }}"></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            
            <tr>
                <td style="text-align:center;">
                4
                </td>
                <td>
                Any Other 
                </td>
               @php
                $any_other = json_decode($data->any_other, true);
                @endphp
                
                <td>
                    <input type="number" id="any_other_unit_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $any_other['unit'] ?? '' }}">
                </td>
                <td><input type="text" id="any_other_indicator_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $any_other['indicator'] ?? '' }}"></td>
                <td><input type="text" id="any_other_remark_{{$data->id}}_{{isset($data->farmer_id) && $data->farmer_id ? $data->farmer_id : ''}}" class="form-control" name="" value="{{ $any_other['remark'] ?? '' }}"></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
            <td colspan="16"><button type="button" id="submitBtn" class="btn btn-primary submitBtn" data-id="{{$data->id}}" data-farmerid="{{$data->farmer_id}}">Update</button></td>
        </table>
        </form>
        @endforeach
        @else
         
         <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
            <thead>
                <tr>
                    <th>S. No</th>
                    <th>FARMER ID</th>
                    <th>Farmer Name</th>
                    <th>Particulars</th>
                    <th>Unit</th>
                    <th>Name of the input supplier / supporting value chain actor</th>
                    <th>Adequacy</th>
                    <th>quality</th>
                    <th>Timely supply</th>
                    <th>Effectiveness</th>
                    <th>As per scientific recommendation (SOP) </th>
                    <th>Price reasonability </th>
                    <th>Is inputs on credit </th>
                    <th>Difference in input price under with or without credit (%) </th>
                    <th>Remark</th>
            </thead>
        
            <tr>
                <td colspan="5">
                </td>
        
                <td>Name</td>
                <td colspan="6" style="text-align:center; background-color:yellow; color:black; font-weight:700;">Rating as per
                    given below matrix</td>
                <td>Y/N</td>
                <td>%</td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    1
                </td>
                <td></td>
                <td></td>
                <td>
                    Seed
                </td>
               
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
        
            <tr>
                <td style="text-align:center;">
                    2
                </td>
        
                <td>
                </td>
                <td></td>
                <td>
                    Plantlets
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    3
                </td>
        
                <td>
        
                </td>
                <td></td>
                <td>
                    Fingerling (fishery)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    4
                </td>
        
                <td></td>
                <td></td>
                <td>
                    day old chick (Poultry)
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    5
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Feed
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    6
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Fertilizer
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    7
                </td>
        
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                    Pesticides / Insecticide / Herbicides
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
        
            <tr>
                <td style="text-align:center;">
                    8
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Nutrients
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    9
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Medicine
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    10
                </td>
        
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                    Labour
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    11
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Supply of diesel fuel / electricity
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    12
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Technology Transfer
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    13
                </td>
        
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                    FM-Custom Hire Services
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    14
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Irrigation on Custom and Hiring
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
        
            <tr>
                <td style="text-align:center;">
                    15
                </td>
        
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                    Source of Credit
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    a
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Input Credit
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    d
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Supply Credit
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    c
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Credit from NBSC
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    d
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Credit from Banks
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    e
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Other source/s
                </td>
                <td>
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    16
                </td>
        
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                    Any Other Information
                </td>
                <td>
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
        
                </td>
        
                <td></td>
                <td></td>
                <td style="font-weight:700;">
                    Rating
                </td>
                <td style="font-weight:700;">
                    Assigned Number for filling rating
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
        
                </td>
        
                <td></td>
                <td></td>
                <td style="background-color: green;color:white">
                    Strongly Agree
                </td>
                <td style="background-color: green;color:white">
                    3
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
        
                </td>
        
                <td></td>
                <td></td>
                <td style="background-color: #66971b; color:white;">
                    Agree
                </td>
                <td style="background-color: #66971b; color:white;">
                    2
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
        
                </td>
        
                <td></td>
                <td></td>
                <td style="background-color:yellow; color:black">
                    Satisfactory
                </td>
                <td style="background-color:yellow; color:black">
                    1
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
        
                </td>
        
                <td></td>
                <td></td>
                <td style="background-color:#ff7300; color:white">
                    Disagree
                </td>
                <td style="background-color:#ff7300; color:white">
                    -2
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
        
            </tr>
        
            <tr>
                <td style="text-align:center;">
        
                </td>
                <td>
                </td>
                <td>
        
                </td>
                <td style="background-color:red; color:white">
                    Strongly Disagree
                </td>
                <td style="background-color:red; color:white">
                    -3
                </td>
                <td></td>
        
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
        
                </td>
        
                <td></td>
                <td></td>
                <td>
                    Can not say
                </td>
                <td>
                    0
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    S. No.
                </td>
                <td style="font-weight:700;">
                    Particulars
                </td>
                <td>
                    Unit
                </td>
                <td>Indicator</td>
                <td>Remark</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    1
                </td>
                <td>
                    Type of seed used
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                <td>
                    Foundation Seed
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    b
                </td>
                <td>
                    Breeder Seed
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    c
                </td>
                <td>
                    Certified Seed
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    d
                </td>
                <td>
                    Other Seed
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    e
                </td>
                <td>
                    Brand of Seed
                </td>
                <td>
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    2
                </td>
                <td style="font-weight:700;">
                    Source of Seed
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    a
                </td>
                <td>
                    Own Seed
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    b
                </td>
                <td>
                    Seed Purchase from Market
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    c
                </td>
                <td>
                    Any other source
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    3
                </td>
                <td>
                    Source : Distance from farm (KM)
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
            <tr>
                <td style="text-align:center;">
                    4
                </td>
                <td>
                    Any Other
                </td>
                <td>
        
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        
        </table>

        @endif
    </div>


    <div class="table-responsive mt-5">
        
       
        
    </div>

</div>
<script>
        document.getElementById('filterBtn').addEventListener('click', function() {
            var selectedMonth = document.getElementById('month').value;
            var selectedYear = document.getElementById('year').value;
            var dataUrl = document.getElementById('filterBtn').getAttribute('data-url'); 
            var url = dataUrl;
            if (selectedMonth) {
                url += "?month=" + selectedMonth;
                if (selectedYear) {
                    url += "&year=" + selectedYear;
                }
            } else if (selectedYear) {
                url += "?year=" + selectedYear;
            }
            window.location.href = url;
        });
    </script>
    
<script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>
    
   
  <!--edit get data-->
<script>
 document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll('.submitBtn').forEach(button => {
        button.addEventListener('click', function () {
           
            const id = this.getAttribute('data-id');
            const farmerId = this.getAttribute('data-farmerId');
            
            const seed = {
                unit: document.getElementById(`seed_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`seed_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`seed_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`seed_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`seed_timely_supply_${id}_${farmerId}`).value, 
                effectiveness: document.getElementById(`seed_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`seed_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`seed_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`seed_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit: document.getElementById(`seed_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`seed_remark_${id}_${farmerId}`).value,
            };
           
            const plantlets = {
            unit: document.getElementById(`plantlets_unit_${id}_${farmerId}`).value,
            input_supplier_name: document.getElementById(`plantlets_supplier_name_${id}_${farmerId}`).value,
            adequacy: document.getElementById(`plantlets_adequacy_${id}_${farmerId}`).value,
            quality: document.getElementById(`plantlets_quality_${id}_${farmerId}`).value,
            timely_supply: document.getElementById(`plantlets_timely_supply_${id}_${farmerId}`).value,
            effectiveness: document.getElementById(`plantlets_effectiveness_${id}_${farmerId}`).value,
            as_consultancy_service: document.getElementById(`plantlets_as_consultancy_service_${id}_${farmerId}`).value,
            price_reasonability: document.getElementById(`plantlets_price_reasonability_${id}_${farmerId}`).value,
            with_or_without_credit: document.getElementById(`plantlets_with_or_without_credit_${id}_${farmerId}`).value,
            diff_in_price_with_without_credit:
            document.getElementById(`plantlets_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
            remark: document.getElementById(`plantlets_remark_${id}_${farmerId}`).value,
            };
            
            const fingerling_fishery = {
                unit: document.getElementById(`fingerling_fishery_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`fingerling_fishery_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`fingerling_fishery_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`fingerling_fishery_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`fingerling_fishery_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`fingerling_fishery_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`fingerling_fishery_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`fingerling_fishery_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`fingerling_fishery_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`fingerling_fishery_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`fingerling_fishery_remark_${id}_${farmerId}`).value,
            };
            
            const day_old_chick = {
            unit: document.getElementById(`day_old_chick_unit_${id}_${farmerId}`).value,
            input_supplier_name: document.getElementById(`day_old_chick_supplier_name_${id}_${farmerId}`).value,
            adequacy: document.getElementById(`day_old_chick_adequacy_${id}_${farmerId}`).value,
            quality: document.getElementById(`day_old_chick_quality_${id}_${farmerId}`).value,
            timely_supply: document.getElementById(`day_old_chick_timely_supply_${id}_${farmerId}`).value,
            effectiveness: document.getElementById(`day_old_chick_effectiveness_${id}_${farmerId}`).value,
            as_consultancy_service: document.getElementById(`day_old_chick_as_consultancy_service_${id}_${farmerId}`).value,
            price_reasonability: document.getElementById(`day_old_chick_price_reasonability_${id}_${farmerId}`).value,
            with_or_without_credit: document.getElementById(`day_old_chick_with_or_without_credit_${id}_${farmerId}`).value,
            diff_in_price_with_without_credit:
            document.getElementById(`day_old_chick_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
            remark: document.getElementById(`day_old_chick_remark_${id}_${farmerId}`).value,
            };
            
            const feed = {
            unit: document.getElementById(`feed_unit_${id}_${farmerId}`).value,
            input_supplier_name: document.getElementById(`feed_supplier_name_${id}_${farmerId}`).value,
            adequacy: document.getElementById(`feed_adequacy_${id}_${farmerId}`).value,
            quality: document.getElementById(`feed_quality_${id}_${farmerId}`).value,
            timely_supply: document.getElementById(`feed_timely_supply_${id}_${farmerId}`).value,
            effectiveness: document.getElementById(`feed_effectiveness_${id}_${farmerId}`).value,
            as_consultancy_service: document.getElementById(`feed_as_consultancy_service_${id}_${farmerId}`).value,
            price_reasonability: document.getElementById(`feed_price_reasonability_${id}_${farmerId}`).value,
            with_or_without_credit: document.getElementById(`feed_with_or_without_credit_${id}_${farmerId}`).value,
            diff_in_price_with_without_credit:
            document.getElementById(`feed_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
            remark: document.getElementById(`feed_remark_${id}_${farmerId}`).value,
            };
            
            const fertilizer = {
                unit: document.getElementById(`fertilizer_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`fertilizer_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`fertilizer_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`fertilizer_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`fertilizer_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`fertilizer_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`fertilizer_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`fertilizer_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`fertilizer_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`fertilizer_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`fertilizer_remark_${id}_${farmerId}`).value,
            };
            
            const pesticides_insec_her = {
            unit: document.getElementById(`pesticides_insec_her_unit_${id}_${farmerId}`).value,
            input_supplier_name: document.getElementById(`pesticides_insec_her_supplier_name_${id}_${farmerId}`).value,
            adequacy: document.getElementById(`pesticides_insec_her_adequacy_${id}_${farmerId}`).value,
            quality: document.getElementById(`pesticides_insec_her_quality_${id}_${farmerId}`).value,
            timely_supply: document.getElementById(`pesticides_insec_her_timely_supply_${id}_${farmerId}`).value,
            effectiveness: document.getElementById(`pesticides_insec_her_effectiveness_${id}_${farmerId}`).value,
            as_consultancy_service: document.getElementById(`pesticides_insec_her_as_consultancy_service_${id}_${farmerId}`).value,
            price_reasonability: document.getElementById(`pesticides_insec_her_price_reasonability_${id}_${farmerId}`).value,
            with_or_without_credit: document.getElementById(`pesticides_insec_her_with_or_without_credit_${id}_${farmerId}`).value,
            diff_in_price_with_without_credit:
            document.getElementById(`pesticides_insec_her_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
            remark: document.getElementById(`pesticides_insec_her_remark_${id}_${farmerId}`).value,
            };
            
            const nutrients = {
                unit: document.getElementById(`nutrients_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`nutrients_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`nutrients_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`nutrients_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`nutrients_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`nutrients_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`nutrients_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`nutrients_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`nutrients_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`nutrients_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`nutrients_remark_${id}_${farmerId}`).value,
                };
                
                const medicine = {
                unit: document.getElementById(`medicine_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`medicine_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`medicine_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`medicine_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`medicine_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`medicine_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`medicine_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`medicine_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`medicine_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`medicine_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`medicine_remark_${id}_${farmerId}`).value,
                };
                
                
                const labour = {
                    unit: document.getElementById(`labour_unit_${id}_${farmerId}`).value,
                    input_supplier_name: document.getElementById(`labour_supplier_name_${id}_${farmerId}`).value,
                    adequacy: document.getElementById(`labour_adequacy_${id}_${farmerId}`).value,
                    quality: document.getElementById(`labour_quality_${id}_${farmerId}`).value,
                    timely_supply: document.getElementById(`labour_timely_supply_${id}_${farmerId}`).value,
                    effectiveness: document.getElementById(`labour_effectiveness_${id}_${farmerId}`).value,
                    as_consultancy_service: document.getElementById(`labour_as_consultancy_service_${id}_${farmerId}`).value,
                    price_reasonability: document.getElementById(`labour_price_reasonability_${id}_${farmerId}`).value,
                    with_or_without_credit: document.getElementById(`labour_with_or_without_credit_${id}_${farmerId}`).value,
                    diff_in_price_with_without_credit:
                    document.getElementById(`labour_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                    remark: document.getElementById(`labour_remark_${id}_${farmerId}`).value,
                };
                
                const supply_of_diesel_fuel_electricity = {
                unit: document.getElementById(`supply_of_diesel_fuel_electricity_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`supply_of_diesel_fuel_electricity_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`supply_of_diesel_fuel_electricity_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`supply_of_diesel_fuel_electricity_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`supply_of_diesel_fuel_electricity_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`supply_of_diesel_fuel_electricity_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`supply_of_diesel_fuel_electricity_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`supply_of_diesel_fuel_electricity_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`supply_of_diesel_fuel_electricity_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`supply_of_diesel_fuel_electricity_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`supply_of_diesel_fuel_electricity_remark_${id}_${farmerId}`).value,
                };
                
                const technology_transfer = {
                unit: document.getElementById(`technology_transfer_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`technology_transfer_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`technology_transfer_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`technology_transfer_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`technology_transfer_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`technology_transfer_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`technology_transfer_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`technology_transfer_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`technology_transfer_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`technology_transfer_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`technology_transfer_remark_${id}_${farmerId}`).value,
                };
                
                const fm_custom_hire_services = {
                unit: document.getElementById(`fm_custom_hire_services_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`fm_custom_hire_services_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`fm_custom_hire_services_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`fm_custom_hire_services_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`fm_custom_hire_services_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`fm_custom_hire_services_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`fm_custom_hire_services_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`fm_custom_hire_services_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`fm_custom_hire_services_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`fm_custom_hire_services_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`fm_custom_hire_services_remark_${id}_${farmerId}`).value,
                };
                
                const irrigation_on_custom_and_hiring = {
                unit: document.getElementById(`irrigation_on_custom_and_hiring_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`irrigation_on_custom_and_hiring_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`irrigation_on_custom_and_hiring_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`irrigation_on_custom_and_hiring_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`irrigation_on_custom_and_hiring_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`irrigation_on_custom_and_hiring_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`irrigation_on_custom_and_hiring_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`irrigation_on_custom_and_hiring_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`irrigation_on_custom_and_hiring_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`irrigation_on_custom_and_hiring_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`irrigation_on_custom_and_hiring_remark_${id}_${farmerId}`).value,
                };
                
                const source_of_credit = {
                unit: document.getElementById(`source_of_credit_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`source_of_credit_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`source_of_credit_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`source_of_credit_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`source_of_credit_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`source_of_credit_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`source_of_credit_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`source_of_credit_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`source_of_credit_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`source_of_credit_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`source_of_credit_remark_${id}_${farmerId}`).value,
                };
                
                const input_credit = {
                unit: document.getElementById(`input_credit_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`input_credit_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`input_credit_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`input_credit_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`input_credit_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`input_credit_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`input_credit_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`input_credit_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`input_credit_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`input_credit_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`input_credit_remark_${id}_${farmerId}`).value,
                };
                
                const supply_credit = {
                unit: document.getElementById(`supply_credit_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`supply_credit_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`supply_credit_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`supply_credit_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`supply_credit_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`supply_credit_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`supply_credit_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`supply_credit_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`supply_credit_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`supply_credit_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`supply_credit_remark_${id}_${farmerId}`).value,
                };
                
                const credit_from_nbsc = {
                unit: document.getElementById(`credit_from_nbsc_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`credit_from_nbsc_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`credit_from_nbsc_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`credit_from_nbsc_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`credit_from_nbsc_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`credit_from_nbsc_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`credit_from_nbsc_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`credit_from_nbsc_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`credit_from_nbsc_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`credit_from_nbsc_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`credit_from_nbsc_remark_${id}_${farmerId}`).value,
                };
                
                const credit_from_banks = {
                unit: document.getElementById(`credit_from_banks_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`credit_from_banks_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`credit_from_banks_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`credit_from_banks_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`credit_from_banks_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`credit_from_banks_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`credit_from_banks_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`credit_from_banks_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`credit_from_banks_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`credit_from_banks_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`credit_from_banks_remark_${id}_${farmerId}`).value,
                };
                
                const other_source = {
                    unit: document.getElementById(`other_source_unit_${id}_${farmerId}`).value,
                    input_supplier_name: document.getElementById(`other_source_supplier_name_${id}_${farmerId}`).value,
                    adequacy: document.getElementById(`other_source_adequacy_${id}_${farmerId}`).value,
                    quality: document.getElementById(`other_source_quality_${id}_${farmerId}`).value,
                    timely_supply: document.getElementById(`other_source_timely_supply_${id}_${farmerId}`).value,
                    effectiveness: document.getElementById(`other_source_effectiveness_${id}_${farmerId}`).value,
                    as_consultancy_service: document.getElementById(`other_source_as_consultancy_service_${id}_${farmerId}`).value,
                    price_reasonability: document.getElementById(`other_source_price_reasonability_${id}_${farmerId}`).value,
                    with_or_without_credit: document.getElementById(`other_source_with_or_without_credit_${id}_${farmerId}`).value,
                    diff_in_price_with_without_credit:
                    document.getElementById(`other_source_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                    remark: document.getElementById(`other_source_remark_${id}_${farmerId}`).value,
                };
                
                
                const any_other_information = {
                unit: document.getElementById(`any_other_information_unit_${id}_${farmerId}`).value,
                input_supplier_name: document.getElementById(`any_other_information_supplier_name_${id}_${farmerId}`).value,
                adequacy: document.getElementById(`any_other_information_adequacy_${id}_${farmerId}`).value,
                quality: document.getElementById(`any_other_information_quality_${id}_${farmerId}`).value,
                timely_supply: document.getElementById(`any_other_information_timely_supply_${id}_${farmerId}`).value,
                effectiveness: document.getElementById(`any_other_information_effectiveness_${id}_${farmerId}`).value,
                as_consultancy_service: document.getElementById(`any_other_information_as_consultancy_service_${id}_${farmerId}`).value,
                price_reasonability: document.getElementById(`any_other_information_price_reasonability_${id}_${farmerId}`).value,
                with_or_without_credit: document.getElementById(`any_other_information_with_or_without_credit_${id}_${farmerId}`).value,
                diff_in_price_with_without_credit:
                document.getElementById(`any_other_information_diff_in_price_with_without_credit_${id}_${farmerId}`).value,
                remark: document.getElementById(`any_other_information_remark_${id}_${farmerId}`).value,
                };
                
                const foundation_seed = {
                unit: document.getElementById(`foundation_seed_unit_${id}_${farmerId}`).value,
                indicator: document.getElementById(`foundation_seed_indicator_${id}_${farmerId}`).value,
                remark: document.getElementById(`foundation_seed_remark_${id}_${farmerId}`).value,
                };
            
                const breeder_seed = {
                unit: document.getElementById(`breeder_seed_unit_${id}_${farmerId}`).value,
                indicator: document.getElementById(`breeder_seed_indicator_${id}_${farmerId}`).value,
                remark: document.getElementById(`breeder_seed_remark_${id}_${farmerId}`).value,
                };
                
                const certified_seed = {
                unit: document.getElementById(`certified_seed_unit_${id}_${farmerId}`).value,
                indicator: document.getElementById(`certified_seed_indicator_${id}_${farmerId}`).value,
                remark: document.getElementById(`certified_seed_remark_${id}_${farmerId}`).value,
                };
                
                const other_seed = {
                unit: document.getElementById(`other_seed_unit_${id}_${farmerId}`).value,
                indicator: document.getElementById(`other_seed_indicator_${id}_${farmerId}`).value,
                remark: document.getElementById(`other_seed_remark_${id}_${farmerId}`).value,
                };
                
                const brand_of_seed = {
                unit: document.getElementById(`brand_of_seed_unit_${id}_${farmerId}`).value,
                indicator: document.getElementById(`brand_of_seed_indicator_${id}_${farmerId}`).value,
                remark: document.getElementById(`brand_of_seed_remark_${id}_${farmerId}`).value,
                };
                
                
                const own_seed = {
                unit: document.getElementById(`own_seed_unit_${id}_${farmerId}`).value,
                indicator: document.getElementById(`own_seed_indicator_${id}_${farmerId}`).value,
                remark: document.getElementById(`own_seed_remark_${id}_${farmerId}`).value,
                };
                
                
                const seed_purchase_from_market = {
                unit: document.getElementById(`seed_purchase_from_market_unit_${id}_${farmerId}`).value,
                indicator: document.getElementById(`seed_purchase_from_market_indicator_${id}_${farmerId}`).value,
                remark: document.getElementById(`seed_purchase_from_market_remark_${id}_${farmerId}`).value,
                };
                
                const any_other_source = {
                unit: document.getElementById(`any_other_source_unit_${id}_${farmerId}`).value,
                indicator: document.getElementById(`any_other_source_indicator_${id}_${farmerId}`).value,
                remark: document.getElementById(`any_other_source_remark_${id}_${farmerId}`).value,
                };
                
                const source_distance_km = {
                unit: document.getElementById(`source_distance_km_unit_${id}_${farmerId}`).value,
                indicator: document.getElementById(`source_distance_km_indicator_${id}_${farmerId}`).value,
                remark: document.getElementById(`source_distance_km_remark_${id}_${farmerId}`).value,
                };
                
                
                const any_other = {
                unit: document.getElementById(`any_other_unit_${id}_${farmerId}`).value,
                indicator: document.getElementById(`any_other_indicator_${id}_${farmerId}`).value,
                remark: document.getElementById(`any_other_remark_${id}_${farmerId}`).value,
                };
                            
          
            const data = {id, farmer_id: farmerId, seed , plantlets , fingerling_fishery , day_old_chick , feed , fertilizer , pesticides_insec_her ,
                           nutrients , medicine , labour , supply_of_diesel_fuel_electricity , technology_transfer , fm_custom_hire_services ,
                           irrigation_on_custom_and_hiring , source_of_credit , input_credit , supply_credit , credit_from_nbsc , credit_from_banks ,
                           other_source , any_other_information , foundation_seed ,breeder_seed , certified_seed , other_seed , brand_of_seed ,
                           own_seed , seed_purchase_from_market , any_other_source , source_distance_km , any_other
                        };

            console.log(data);

            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

           fetch('{{ route("anexure.e.update") }}', {
                method: 'POST', 
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                body: JSON.stringify(data)
            })
            .then(response => response.json())
            .then(data => {
                alert('Success! ' + JSON.stringify(data));
            })
            .catch(error => console.error('Error:', error));
        });
    });
});
 </script>
  
  <!--end edit data-->
    
    
    
    
@endsection