<?php
    use App\Models\User;
    
    $loginUserId = Auth::user()->id;
    $userDetail = User::find($loginUserId);
    $permissions = DB::table('tbl_role_permissions')->where('role_id', $userDetail->role_id)->get();
    $rolePermission = $permissions->firstWhere('menu_id', 21);
?>
@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

<div class="container-fluid">
     <div class="table-responsive">
        <div class="row">
            <div class="col-lg-4">
                <button class="btn btn-primary mb-4" onclick="exportTableData()">Export CSV</button>
            </div>
            @if($deshboard == 1)
        
            @else
            <div class="col-lg-8">
                <label for="month">Select Date Range:</label>
                <form action="#" method="GET" onsubmit="return validateDates()">
                    <input type="date" id="start_date" value="{{ isset($_GET['start_date']) ? $_GET['start_date'] : '' }}" name="start_date" placeholder="start date">
                    <input type="date" id="end_date" value="{{ isset($_GET['end_date']) ? $_GET['end_date'] : '' }}" name="end_date" placeholder="end date">
                    <button type="submit" class="btn btn-primary btn-sm" id="filterBtn">Filter</button>
                    <a href="{{ route('anexure.fpo_a') }}" class="btn btn-primary btn-sm">Clear Filters</a>
                    <?php
                        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '';
                        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '';
                    ?>
                    <a href="{{ route('anexure.six.update', ['start_date' => $startDate, 'end_date' => $endDate]) }}" class="btn btn-primary btn-sm">Edit</a>
                </form>
            </div>
            @endif
        </div>
         <br>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">A. Infrastructure and Support Service</h1>
        </div>
    @if($data->isNotEmpty())    
        @php
            $si = 1;
        @endphp
        @foreach($data as $datas)
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Infrastructure and Support Service</th>
            <th>Unit</th>
            <th>Unit Rate</th>
             <th>Amt (Rs.)</th>
             <th>Annulised Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
          <tr>
              @php
             $cost_permanent = json_decode($datas->cost_of_establishment_permanent, true);
            @endphp 
             <td style="font-weight:700;">{{$si++}}</td>
            <td>{{$datas->farmer_code_id}}</td>
              <td>{{$datas->first_name == 'null' ? '' : $datas->first_name.' '.$datas->last_name}}</td>
            <td>Cost of Establishment Permanent</td>
              <td>{{ $cost_permanent['unit'] ?? '' }}</td>
               <td>{{ $cost_permanent['unitRate'] ?? '' }}</td>
               <td>{{ $cost_permanent['amount'] ?? '' }}</td>
               
            @php
                $annualizedcostPer = isset($cost_permanent['amount']) && isset($perYear->year) && $perYear->year != 0 
                    ? $cost_permanent['amount'] / $perYear->year 
                    : null;
            @endphp
            <td>{{ $annualizedcostPer ?? '' }}</td>
            
            <td>{{ $cost_permanent['remark'] ?? '' }}</td>
         </tr>   
         
         
        <tr>
            @php
             $cost_temporary = json_decode($datas->cost_of_establishment_temporary, true);
            @endphp 
             <td style="font-weight:700;">2</td>
            <td></td>
            <td></td>
            <td>Cost of Establishment Temporary</td>
            <td>{{ $cost_temporary['unit'] ?? '' }}</td>
            <td>{{ $cost_temporary['unitRate'] ?? '' }}</td>
            <td>{{ $cost_temporary['amount'] ?? '' }}</td>
            
             @php
                $annualizedcosttemp = isset($cost_temporary['amount']) && isset($tempYear->year) && $tempYear->year != 0 
                    ? $cost_temporary['amount'] / $tempYear->year 
                    : null;
            @endphp
            
            <td>{{ $annualizedcosttemp ?? '' }}</td>
            <td>{{ $cost_temporary['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
            $cost_storage_structure = json_decode($datas->cost_storage_structure, true);
            @endphp
            <td>3</td>
             <td></td>
            <td></td>
            <td>Cost Storage Structure for Procurement</td>
            <td>{{ $cost_storage_structure['unit'] ?? '' }}</td>
            <td>{{ $cost_storage_structure['unitRate'] ?? '' }}</td>
            <td>{{ $cost_storage_structure['amount'] ?? '' }}</td>
            <td>{{ $cost_storage_structure['annualCost'] ?? '' }}</td>
            <td>{{ $cost_storage_structure['remark'] ?? '' }}</td>
         </tr>
         
          <tr>
               @php
                $monthly_expenses_electricity = json_decode($datas->monthly_expenses_electricity, true);
                @endphp
            <td>4</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
           <td>{{ $monthly_expenses_electricity['unit'] ?? '' }}</td>
            <td>{{ $monthly_expenses_electricity['unitRate'] ?? '' }}</td>
            <td>{{ $monthly_expenses_electricity['amount'] ?? '' }}</td>
            <td>{{ $monthly_expenses_electricity['annualCost'] ?? '' }}</td>
            <td>{{ $monthly_expenses_electricity['remark'] ?? '' }}</td>
         </tr>  
         
          <tr>
              @php
            $monthly_expenses_on_manpower = json_decode($datas->monthly_expenses_on_manpower, true);
            @endphp
            <td>5</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Manpower</td>
              <td>{{ $monthly_expenses_on_manpower['unit'] ?? '' }}</td>
            <td>{{ $monthly_expenses_on_manpower['unitRate'] ?? '' }}</td>
            <td>{{ $monthly_expenses_on_manpower['amount'] ?? '' }}</td>
            <td>{{ $monthly_expenses_on_manpower['annualCost'] ?? '' }}</td>
            <td>{{ $monthly_expenses_on_manpower['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
            $monthly_rent = json_decode($datas->monthly_rent, true);
            @endphp

            <td>5</td>
             <td></td>
            <td></td>
            <td >Monthly rent ( If Shop is on rent)</td>
            <td>{{ $monthly_rent['unit'] ?? '' }}</td>
            <td>{{ $monthly_rent['unitRate'] ?? '' }}</td>
            <td>{{ $monthly_rent['amount'] ?? '' }}</td>
            <td>{{ $monthly_rent['annualCost'] ?? '' }}</td>
            <td>{{ $monthly_rent['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
            $monthly_travelling_expense = json_decode($datas->monthly_travelling_expense, true);
            @endphp
            <td>6</td>
             <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
             <td>{{ $monthly_travelling_expense['unit'] ?? '' }}</td>
            <td>{{ $monthly_travelling_expense['unitRate'] ?? '' }}</td>
            <td>{{ $monthly_travelling_expense['amount'] ?? '' }}</td>
            <td>{{ $monthly_travelling_expense['annualCost'] ?? '' }}</td>
            <td>{{ $monthly_travelling_expense['remark'] ?? '' }}</td>
         </tr> 
         
           <tr>
                 @php
            $annual_interest_cost_on_capital = json_decode($datas->annual_interest_cost_on_capital, true);
            @endphp
            <td>7</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on Capital  </td>
            <td>{{ $annual_interest_cost_on_capital['unit'] ?? '' }}</td>
            <td>{{ $annual_interest_cost_on_capital['unitRate'] ?? '' }}</td>
            <td>{{ $annual_interest_cost_on_capital['amount'] ?? '' }}</td>
            <td>{{ $annual_interest_cost_on_capital['annualCost'] ?? '' }}</td>
            <td>{{ $annual_interest_cost_on_capital['remark'] ?? '' }}</td>
         </tr> 
         
           <tr>
            @php
            $any_other_fixed_cost = json_decode($datas->any_other_fixed_cost, true);
            @endphp
            <td>8</td>
             <td></td>
            <td></td>
            <td>Any other fixed cost</td>
            <td>{{ $any_other_fixed_cost['unit'] ?? '' }}</td>
            <td>{{ $any_other_fixed_cost['unitRate'] ?? '' }}</td>
            <td>{{ $any_other_fixed_cost['amount'] ?? '' }}</td>
            <td>{{ $any_other_fixed_cost['annualCost'] ?? '' }}</td>
            <td>{{ $any_other_fixed_cost['remark'] ?? '' }}</td>
         </tr> 
         
         
         
          @php
            $sumfixdata = 
                ($cost_permanent['amount'] ?? 0) + 
                ($cost_temporary['amount'] ?? 0) + 
                ($cost_storage_structure['amount'] ?? 0) + 
                ($monthly_expenses_electricity['amount'] ?? 0) + 
                ($monthly_expenses_on_manpower['amount'] ?? 0) +     
                ($monthly_rent['amount'] ?? 0) + 
                ($monthly_travelling_expense['amount'] ?? 0) + 
                ($any_other_fixed_cost['amount'] ?? 0) +
                ($annual_interest_cost_on_capital['amount'] ?? 0);
            @endphp
       
         
            <tr>
            <td></td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of Trader / Trader / Wholesaler</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">{{ $sumfixdata }}</td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
             @php
            $annual_interest_cost_on_working_capital = json_decode($datas->annual_interest_cost_on_working_capital, true);
            @endphp
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on working capital </td>
              <td>{{ $annual_interest_cost_on_working_capital['unit'] ?? '' }}</td>
            <td>{{ $annual_interest_cost_on_working_capital['unitRate'] ?? '' }}</td>
            <td>{{ $annual_interest_cost_on_working_capital['amount'] ?? '' }}</td>
            <td>{{ $annual_interest_cost_on_working_capital['annualCost'] ?? '' }}</td>
            <td>{{ $annual_interest_cost_on_working_capital['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
                @php
                $purchase_from_farmer_at_village_level = json_decode($datas->purchase_from_farmer_at_village_level, true);
                @endphp
            <td>10</td>
             <td></td>
            <td></td>
            <td >Purchase from farmer at village Level / Farm Gate ?</td>
                <td>{{ $purchase_from_farmer_at_village_level['unit'] ?? '' }}</td>
                <td>{{ $purchase_from_farmer_at_village_level['unitRate'] ?? '' }}</td>
                <td>{{ $purchase_from_farmer_at_village_level['amount'] ?? '' }}</td>
                <td>{{ $purchase_from_farmer_at_village_level['annualCost'] ?? '' }}</td>
                <td>{{ $purchase_from_farmer_at_village_level['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
                  @php
            $purchase_from_farmer_at_local_mandi = json_decode($datas->purchase_from_farmer_at_local_mandi, true);
            @endphp
            <td>11</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi ?</td>
                <td>{{ $purchase_from_farmer_at_local_mandi['unit'] ?? '' }}</td>
                <td>{{ $purchase_from_farmer_at_local_mandi['unitRate'] ?? '' }}</td>
                <td>{{ $purchase_from_farmer_at_local_mandi['amount'] ?? '' }}</td>
                <td>{{ $purchase_from_farmer_at_local_mandi['annualCost'] ?? '' }}</td>
                <td>{{ $purchase_from_farmer_at_local_mandi['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
            @php
            $purchase_from_commission_agent = json_decode($datas->purchase_from_commission_agent, true);
            @endphp
            <td>12</td>
             <td></td>
            <td></td>
            <td>Purchase from Commission Agent ?</td>
              <td>{{ $purchase_from_commission_agent['unit'] ?? '' }}</td>
                <td>{{ $purchase_from_commission_agent['unitRate'] ?? '' }}</td>
                <td>{{ $purchase_from_commission_agent['amount'] ?? '' }}</td>
                <td>{{ $purchase_from_commission_agent['annualCost'] ?? '' }}</td>
                <td>{{ $purchase_from_commission_agent['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $purchase_from_primary_processor = json_decode($datas->purchase_from_primary_processor, true);
                @endphp
            <td>13</td>
             <td></td>
            <td></td>
            <td>Purchase from Primary Processor ?</td>
               <td>{{ $purchase_from_primary_processor['unit'] ?? '' }}</td>
                <td>{{ $purchase_from_primary_processor['unitRate'] ?? '' }}</td>
                <td>{{ $purchase_from_primary_processor['amount'] ?? '' }}</td>
                <td>{{ $purchase_from_primary_processor['annualCost'] ?? '' }}</td>
                <td>{{ $purchase_from_primary_processor['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
                  @php
                $purchase_from_secondary_processor = json_decode($datas->purchase_from_secondary_processor, true);
                @endphp
            <td>14</td>
             <td></td>
            <td></td>
            <td>Purchase from Secondary Processor ?</td>
             <td>{{ $purchase_from_secondary_processor['unit'] ?? '' }}</td>
            <td>{{ $purchase_from_secondary_processor['unitRate'] ?? '' }}</td>
            <td>{{ $purchase_from_secondary_processor['amount'] ?? '' }}</td>
            <td>{{ $purchase_from_secondary_processor['annualCost'] ?? '' }}</td>
            <td>{{ $purchase_from_secondary_processor['remark'] ?? '' }}</td>
         </tr> 
         
         <tr>
             @php
            $purchase_from_tertiary_processor = json_decode($datas->purchase_from_tertiary_processor, true);
            @endphp
            <td>15</td>
             <td></td>
            <td></td>
            <td>Purchase from Tertiary Processor ?</td>
                <td>{{ $purchase_from_tertiary_processor['unit'] ?? '' }}</td>
            <td>{{ $purchase_from_tertiary_processor['unitRate'] ?? '' }}</td>
            <td>{{ $purchase_from_tertiary_processor['amount'] ?? '' }}</td>
            <td>{{ $purchase_from_tertiary_processor['annualCost'] ?? '' }}</td>
            <td>{{ $purchase_from_tertiary_processor['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
                $any_other_channel = json_decode($datas->any_other_channel, true);
                @endphp
            <td>16</td>
             <td></td>
            <td></td>
            <td>Any other channel</td>
             <td>{{ $any_other_channel['unit'] ?? '' }}</td>
            <td>{{ $any_other_channel['unitRate'] ?? '' }}</td>
            <td>{{ $any_other_channel['amount'] ?? '' }}</td>
            <td>{{ $any_other_channel['annualCost'] ?? '' }}</td>
            <td>{{ $any_other_channel['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
              @php
            $most_prevalent_purchase_mechanism = json_decode($datas->most_prevalent_purchase_mechanism, true);
            @endphp
            <td>17</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism ( 10/11/12/16 )?</td>
            <td>{{ $most_prevalent_purchase_mechanism['unit'] ?? '' }}</td>
            <td>{{ $most_prevalent_purchase_mechanism['unitRate'] ?? '' }}</td>
            <td>{{ $most_prevalent_purchase_mechanism['amount'] ?? '' }}</td>
            <td>{{ $most_prevalent_purchase_mechanism['annualCost'] ?? '' }}</td>
            <td>{{ $most_prevalent_purchase_mechanism['remark'] ?? '' }}</td>
         </tr> 
         
         
        <tr>
                @php
    $duration_of_purchase_on_credit = json_decode($datas->duration_of_purchase_on_credit, true);
    @endphp
            <td>18</td>
             <td></td>
            <td></td>
            <td>Duration of purchase on credit</td>
              <td>{{ $duration_of_purchase_on_credit['unit'] ?? '' }}</td>
            <td>{{ $duration_of_purchase_on_credit['unitRate'] ?? '' }}</td>
            <td>{{ $duration_of_purchase_on_credit['amount'] ?? '' }}</td>
            <td>{{ $duration_of_purchase_on_credit['annualCost'] ?? '' }}</td>
            <td>{{ $duration_of_purchase_on_credit['remark'] ?? '' }}</td>
         </tr> 
         
          <tr>
                  @php
            $duration_of_sale_on_credit = json_decode($datas->duration_of_sale_on_credit, true);
            @endphp
            <td>19</td>
             <td></td>
            <td></td>
            <td>Duration of Sale on credit</td>
             <td>{{ $duration_of_sale_on_credit['unit'] ?? '' }}</td>
            <td>{{ $duration_of_sale_on_credit['unitRate'] ?? '' }}</td>
            <td>{{ $duration_of_sale_on_credit['amount'] ?? '' }}</td>
            <td>{{ $duration_of_sale_on_credit['annualCost'] ?? '' }}</td>
            <td>{{ $duration_of_sale_on_credit['remark'] ?? '' }}</td>
         </tr> 
         
           <tr>
                @php
                $any_other_information = json_decode($datas->any_other_information, true);
                @endphp

            <td>20</td>
             <td></td>
            <td></td>
            <td>Any other information</td>
               <td>{{ $any_other_information['unit'] ?? '' }}</td>
                <td>{{ $any_other_information['unitRate'] ?? '' }}</td>
                <td>{{ $any_other_information['amount'] ?? '' }}</td>
                <td>{{ $any_other_information['annualCost'] ?? '' }}</td>
                <td>{{ $any_other_information['remark'] ?? '' }}</td>
         </tr> 
         
        </tbody>
  </table>
    <!--</div>-->
    <div class="table-responsive" style="margin-top:40px;">
     <h1 class="h3 mb-0 text-gray-800">B . Business parameters</h1>
      <br>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars of Inputs</th>
            <th>Unit</th>
            <th>Name of Product</th>
            <th>Unit (quantity)</th>
            <th>Average Rate (Rs./Unit Quantity)</th>
            <th>Min Rate (Rs./Unit Quantity)</th>
            <th>Max Rate (Rs./Unit Quantity)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
            
          <tr>
          
            <td style="font-weight:700;">{{$si++}}</td>
            <td>{{$datas->farmer_code_id}}</td>
            <td>{{$datas->first_name == 'null' ? '' : $datas->first_name.' '.$datas->last_name}}</td>
            <td style="font-weight:700;">Average Purchase Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
             @php
            $average_purchase_price_a = json_decode($datas->average_purchase_price_a, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td></td>
            <td>{{ $average_purchase_price_a['name'] ?? '' }}</td>
            <td>{{ $average_purchase_price_a['unit'] ?? '' }}</td>
            <td>{{ $average_purchase_price_a['averate_rate'] ?? '' }}</td>
            <td>{{ $average_purchase_price_a['min_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_price_a['max_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_price_a['remarks'] ?? '' }}</td>
         </tr>
         
           <tr>
               @php
            $average_purchase_price_b = json_decode($datas->average_purchase_price_b, true);
            @endphp
            <td></td>
               <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
            <td></td>
            <td>{{ $average_purchase_price_b['name'] ?? '' }}</td>
            <td>{{ $average_purchase_price_b['unit'] ?? '' }}</td>
            <td>{{ $average_purchase_price_b['averate_rate'] ?? '' }}</td>
            <td>{{ $average_purchase_price_b['min_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_price_b['max_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_price_b['remarks'] ?? '' }}</td>
         </tr>
         
           <tr>
            @php
            $average_purchase_price_c = json_decode($datas->average_purchase_price_c, true);
            @endphp
            <td></td> 
            <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
            <td></td>
            <td>{{ $average_purchase_price_c['name'] ?? '' }}</td>
            <td>{{ $average_purchase_price_c['unit'] ?? '' }}</td>
            <td>{{ $average_purchase_price_c['averate_rate'] ?? '' }}</td>
            <td>{{ $average_purchase_price_c['min_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_price_c['max_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_price_c['remarks'] ?? '' }}</td>
         </tr>
         
        <tr>
            @php
            $average_purchase_price_d = json_decode($datas->average_purchase_price_d, true);
            @endphp
            <td></td> 
            <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
             <td></td>
             <td>{{ $average_purchase_price_d['name'] ?? '' }}</td>
            <td>{{ $average_purchase_price_d['unit'] ?? '' }}</td>
            <td>{{ $average_purchase_price_d['averate_rate'] ?? '' }}</td>
            <td>{{ $average_purchase_price_d['min_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_price_d['max_variation'] ?? '' }}</td>
            <td>{{ $average_purchase_price_d['remarks'] ?? '' }}</td>
         </tr>
         
         
         
          <tr>
            <td>II</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Cost of Value Addition</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         
           <tr>
               @php
                $transportation_cost = json_decode($datas->transportation_cost, true);
                @endphp
            <td>a</td>
               <td></td>
            <td></td>
            <td>Transportation Cost</td>
            <td></td>
           <td>{{ $transportation_cost['name'] ?? '' }}</td>
            <td>{{ $transportation_cost['unit'] ?? '' }}</td>
            <td>{{ $transportation_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $transportation_cost['min_variation'] ?? '' }}</td>
            <td>{{ $transportation_cost['max_variation'] ?? '' }}</td>
            <td>{{ $transportation_cost['remarks'] ?? '' }}</td>
         </tr> 
         
         
         <tr>
              @php
                $loding_unloading_charge = json_decode($datas->loding_unloading_charge, true);
                @endphp
            <td>b</td>
               <td></td>
            <td></td>
            <td>Loading and Unloading Charges</td>
            <td></td>
            <td>{{ $loding_unloading_charge['name'] ?? '' }}</td>
            <td>{{ $loding_unloading_charge['unit'] ?? '' }}</td>
            <td>{{ $loding_unloading_charge['averate_rate'] ?? '' }}</td>
            <td>{{ $loding_unloading_charge['min_variation'] ?? '' }}</td>
            <td>{{ $loding_unloading_charge['max_variation'] ?? '' }}</td>
            <td>{{ $loding_unloading_charge['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
            $primary_processing_cost = json_decode($datas->primary_processing_cost, true);
            @endphp
            <td>c</td>
               <td></td>
            <td></td>
            <td>Primary Processing Cost</td>
            <td></td>
            <td>{{ $primary_processing_cost['name'] ?? '' }}</td>
            <td>{{ $primary_processing_cost['unit'] ?? '' }}</td>
            <td>{{ $primary_processing_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $primary_processing_cost['min_variation'] ?? '' }}</td>
            <td>{{ $primary_processing_cost['max_variation'] ?? '' }}</td>
            <td>{{ $primary_processing_cost['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $drying_loss_or_any_other_loss = json_decode($datas->drying_loss_or_any_other_loss, true);
                @endphp

            <td>d</td>
             <td></td>
            <td></td>
            <td>Drying Loss or any other loss</td>
            <td></td>
               <td>{{ $drying_loss_or_any_other_loss['name'] ?? '' }}</td>
            <td>{{ $drying_loss_or_any_other_loss['unit'] ?? '' }}</td>
            <td>{{ $drying_loss_or_any_other_loss['averate_rate'] ?? '' }}</td>
            <td>{{ $drying_loss_or_any_other_loss['min_variation'] ?? '' }}</td>
            <td>{{ $drying_loss_or_any_other_loss['max_variation'] ?? '' }}</td>
            <td>{{ $drying_loss_or_any_other_loss['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
               @php
                $establishment_cost = json_decode($datas->establishment_cost, true);
                @endphp
            <td>e</td>
             <td></td>
            <td></td>
            <td>Establishment Cost</td>
            <td></td>
            <td>{{ $establishment_cost['name'] ?? '' }}</td>
            <td>{{ $establishment_cost['unit'] ?? '' }}</td>
            <td>{{ $establishment_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $establishment_cost['min_variation'] ?? '' }}</td>
            <td>{{ $establishment_cost['max_variation'] ?? '' }}</td>
            <td>{{ $establishment_cost['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
              @php
            $marketing_cost = json_decode($datas->marketing_cost, true);
            @endphp
            <td>f</td>
               <td></td>
            <td></td>
            <td>Marketing Cost</td>
            <td></td>
             <td>{{ $marketing_cost['name'] ?? '' }}</td>
            <td>{{ $marketing_cost['unit'] ?? '' }}</td>
            <td>{{ $marketing_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $marketing_cost['min_variation'] ?? '' }}</td>
            <td>{{ $marketing_cost['max_variation'] ?? '' }}</td>
            <td>{{ $marketing_cost['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
            $stronge_cost = json_decode($datas->stronge_cost, true);
            @endphp
            <td>g</td>
               <td></td>
            <td></td>
            <td>Storage Cost</td>
            <td></td>
            <td>{{ $stronge_cost['name'] ?? '' }}</td>
            <td>{{ $stronge_cost['unit'] ?? '' }}</td>
            <td>{{ $stronge_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $stronge_cost['min_variation'] ?? '' }}</td>
            <td>{{ $stronge_cost['max_variation'] ?? '' }}</td>
            <td>{{ $stronge_cost['remarks'] ?? '' }}</td>
         </tr> 
         </tr> 
         
          <tr>
              @php
                $any_other_cost = json_decode($datas->any_other_cost, true);
                @endphp

            <td>h</td>
               <td></td>
            <td></td>
            <td>Any other cost</td>
            <td></td>
            <td>{{ $any_other_cost['name'] ?? '' }}</td>
            <td>{{ $any_other_cost['unit'] ?? '' }}</td>
            <td>{{ $any_other_cost['averate_rate'] ?? '' }}</td>
            <td>{{ $any_other_cost['min_variation'] ?? '' }}</td>
            <td>{{ $any_other_cost['max_variation'] ?? '' }}</td>
            <td>{{ $any_other_cost['remarks'] ?? '' }}</td>
         </tr> 
         </tr> 
         
         <tr>
            <td>i</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>j</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>III</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Selling Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
         
        <tr>
             @php
                $selling_price_a = json_decode($datas->selling_price_a, true);
                @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td></td>
             <td>{{ $selling_price_a['name'] ?? '' }}</td>
            <td>{{ $selling_price_a['unit'] ?? '' }}</td>
            <td>{{ $selling_price_a['averate_rate'] ?? '' }}</td>
            <td>{{ $selling_price_a['min_variation'] ?? '' }}</td>
            <td>{{ $selling_price_a['max_variation'] ?? '' }}</td>
            <td>{{ $selling_price_a['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
            @php
            $selling_price_b = json_decode($datas->selling_price_b, true);
            @endphp
            <td></td>
               <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
            <td></td>
               <td>{{ $selling_price_b['name'] ?? '' }}</td>
            <td>{{ $selling_price_b['unit'] ?? '' }}</td>
            <td>{{ $selling_price_b['averate_rate'] ?? '' }}</td>
            <td>{{ $selling_price_b['min_variation'] ?? '' }}</td>
            <td>{{ $selling_price_b['max_variation'] ?? '' }}</td>
            <td>{{ $selling_price_b['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
            $selling_price_c = json_decode($datas->selling_price_c, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
            <td></td>
             <td>{{ $selling_price_c['name'] ?? '' }}</td>
            <td>{{ $selling_price_c['unit'] ?? '' }}</td>
            <td>{{ $selling_price_c['averate_rate'] ?? '' }}</td>
            <td>{{ $selling_price_c['min_variation'] ?? '' }}</td>
            <td>{{ $selling_price_c['max_variation'] ?? '' }}</td>
            <td>{{ $selling_price_c['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
               @php
            $selling_price_d = json_decode($datas->selling_price_d, true);
            @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
            <td></td>
             <td>{{ $selling_price_d['name'] ?? '' }}</td>
            <td>{{ $selling_price_d['unit'] ?? '' }}</td>
            <td>{{ $selling_price_d['averate_rate'] ?? '' }}</td>
            <td>{{ $selling_price_d['min_variation'] ?? '' }}</td>
            <td>{{ $selling_price_d['max_variation'] ?? '' }}</td>
            <td>{{ $selling_price_d['remarks'] ?? '' }}</td>
         </tr> 
         
        <tr>
            <td>IV</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Any other Cost Parameter</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         <tr>
               @php
                $quantum_handled_year = json_decode($datas->quantum_handled_year, true);
                @endphp
            <td></td>
            <td></td>
            <td></td>
            <td>Quantum Handled in a year (weight)</td>
            <td></td>
             <td>{{ $quantum_handled_year['name'] ?? '' }}</td>
                <td>{{ $quantum_handled_year['unit'] ?? '' }}</td>
                <td>{{ $quantum_handled_year['averate_rate'] ?? '' }}</td>
                <td>{{ $quantum_handled_year['min_variation'] ?? '' }}</td>
                <td>{{ $quantum_handled_year['max_variation'] ?? '' }}</td>
                <td>{{ $quantum_handled_year['remarks'] ?? '' }}</td>
         </tr> 
         
            <tr>
                    @php
            $purchase_and_selling_prices = json_decode($datas->purchase_and_selling_prices, true);
            @endphp
            <td></td>
               <td></td>
            <td></td>
            <td>Purchase and selling prices fluctuation during the whole marketing season</td>
            <td></td>
           <td>{{ $purchase_and_selling_prices['name'] ?? '' }}</td>
            <td>{{ $purchase_and_selling_prices['unit'] ?? '' }}</td>
            <td>{{ $purchase_and_selling_prices['averate_rate'] ?? '' }}</td>
            <td>{{ $purchase_and_selling_prices['min_variation'] ?? '' }}</td>
            <td>{{ $purchase_and_selling_prices['max_variation'] ?? '' }}</td>
            <td>{{ $purchase_and_selling_prices['remarks'] ?? '' }}</td>
         </tr> 
         
        </tbody>
  </table>

    </div>
    <div class="table-responsive" style="margin-top:40px">
     <h1 class="h3 mb-0 text-gray-800">C . Indicative Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
     <br>
          <h1 class="h3 mb-0 text-gray-800">C. SWOT Analysis of the Distributor </h1>
        <br>
      <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <td>Farmer ID</td>
            <td>Farmer Name</td>
            <th>Particulars</th>
            <th>Primary Processing</th>
           <th>Secondary Processing</th>
           <th>Tertiary Processing</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>S</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Strength</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
             @php
            $government_support = json_decode($datas->government_support, true);
            @endphp
            <td>i</td>
            <td></td>
            <td></td>
            <td>Government support ( Financial / Non Financial)</td>
             <td>{{ $government_support['primary'] ?? '' }}</td>
            <td>{{ $government_support['secondary'] ?? '' }}</td>
            <td>{{ $government_support['tertiary'] ?? '' }}</td>
            <td>{{ $government_support['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
               @php
            $market_demand = json_decode($datas->market_demand, true);
            @endphp
            <td>ii</td>
            <td></td>
            <td></td>
            <td>Market demand</td>
            <td>{{ $market_demand['primary'] ?? '' }}</td>
            <td>{{ $market_demand['secondary'] ?? '' }}</td>
            <td>{{ $market_demand['tertiary'] ?? '' }}</td>
            <td>{{ $market_demand['remarks'] ?? '' }}</td>
         </tr>  
         
           
         
           <tr>
                @php
            $niche_market = json_decode($datas->niche_market, true);
            @endphp
            <td>iii</td>
            <td></td>
            <td></td>
            <td>Niche Market</td>
            <td>{{ $niche_market['primary'] ?? '' }}</td>
            <td>{{ $niche_market['secondary'] ?? '' }}</td>
            <td>{{ $niche_market['tertiary'] ?? '' }}</td>
            <td>{{ $niche_market['remarks'] ?? '' }}</td>
         </tr>  
         
         <tr>
               @php
            $availability_skilled_unskilled_labour = json_decode($datas->availability_skilled_unskilled_labour, true);
            @endphp
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Availability of skilled / unskilled labour</td>
              <td>{{ $availability_skilled_unskilled_labour['primary'] ?? '' }}</td>
                <td>{{ $availability_skilled_unskilled_labour['secondary'] ?? '' }}</td>
                <td>{{ $availability_skilled_unskilled_labour['tertiary'] ?? '' }}</td>
                <td>{{ $availability_skilled_unskilled_labour['remarks'] ?? '' }}</td>
         </tr> 
         
           <tr>
            <td style="font-weight:700;">W</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Weakness</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
             @php
            $infrastructure_and_support_services = json_decode($datas->infrastructure_and_support_services, true);
            @endphp
            <td>i</td>
            <td></td>
            <td></td>
            <td>Infrastructure and Support Services</td>
            <td>{{ $infrastructure_and_support_services['primary'] ?? '' }}</td>
            <td>{{ $infrastructure_and_support_services['secondary'] ?? '' }}</td>
            <td>{{ $infrastructure_and_support_services['tertiary'] ?? '' }}</td>
            <td>{{ $infrastructure_and_support_services['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
                 @php
                $quality_and_standard = json_decode($datas->quality_and_standard, true);
                @endphp
            <td>ii</td>
            <td></td>
            <td></td>
            <td>Quality and Standard</td>
               <td>{{ $quality_and_standard['primary'] ?? '' }}</td>
            <td>{{ $quality_and_standard['secondary'] ?? '' }}</td>
            <td>{{ $quality_and_standard['tertiary'] ?? '' }}</td>
            <td>{{ $quality_and_standard['remarks'] ?? '' }}</td>
         </tr>  
         
           
         
           <tr>
            @php
            $competitor = json_decode($datas->competitor, true);
            @endphp
            <td>iii</td>
            <td></td>
            <td></td>
            <td>Competitor (competitiveness)</td>
             <td>{{ $competitor['primary'] ?? '' }}</td>
            <td>{{ $competitor['secondary'] ?? '' }}</td>
            <td>{{ $competitor['tertiary'] ?? '' }}</td>
            <td>{{ $competitor['remarks'] ?? '' }}</td>
         </tr>  
         
         <tr>
              @php
            $cost_of_rinancial_resources = json_decode($datas->cost_of_rinancial_resources, true);
            @endphp
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Cost of Financial Resources</td>
            <td>{{ $cost_of_rinancial_resources['primary'] ?? '' }}</td>
            <td>{{ $cost_of_rinancial_resources['secondary'] ?? '' }}</td>
            <td>{{ $cost_of_rinancial_resources['tertiary'] ?? '' }}</td>
            <td>{{ $cost_of_rinancial_resources['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">O</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Opportunities</td>
            <td></td>
            <td></td>
               <td></td>
            <td></td>
         </tr> 
         
        <tr>
             @php
            $social_factor = json_decode($datas->social_factor, true);
            @endphp
            <td>i</td>
            <td></td>
            <td></td>
            <td>Social Factor</td>
             <td>{{ $social_factor['primary'] ?? '' }}</td>
            <td>{{ $social_factor['secondary'] ?? '' }}</td>
            <td>{{ $social_factor['tertiary'] ?? '' }}</td>
            <td>{{ $social_factor['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
              @php
                $technological_factor = json_decode($datas->technological_factor, true);
                @endphp
            <td>ii</td>
            <td></td>
            <td></td>
            <td>Technological Factor</td>
              <td>{{ $technological_factor['primary'] ?? '' }}</td>
            <td>{{ $technological_factor['secondary'] ?? '' }}</td>
            <td>{{ $technological_factor['tertiary'] ?? '' }}</td>
            <td>{{ $technological_factor['remarks'] ?? '' }}</td>
         </tr>  
         
           
         
           <tr>
                 @php
            $legal_factor = json_decode($datas->legal_factor, true);
            @endphp
            <td>iii</td>
            <td></td>
            <td></td>
            <td>Legal Factor</td>
            <td>{{ $legal_factor['primary'] ?? '' }}</td>
            <td>{{ $legal_factor['secondary'] ?? '' }}</td>
            <td>{{ $legal_factor['tertiary'] ?? '' }}</td>
            <td>{{ $legal_factor['remarks'] ?? '' }}</td>
         </tr>  
         
         <tr>
            @php
            $political_factor = json_decode($datas->political_factor, true);
            @endphp
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Political Factor</td>
              <td>{{ $political_factor['primary'] ?? '' }}</td>
                <td>{{ $political_factor['secondary'] ?? '' }}</td>
                <td>{{ $political_factor['tertiary'] ?? '' }}</td>
                <td>{{ $political_factor['remarks'] ?? '' }}</td>
         </tr> 
          
           <tr>
                   @php
            $economic_factors = json_decode($datas->economic_factors, true);
            @endphp
            <td>v</td>
             <td></td>
            <td></td>
            <td>Economic Factors</td>
              <td>{{ $economic_factors['primary'] ?? '' }}</td>
            <td>{{ $economic_factors['secondary'] ?? '' }}</td>
            <td>{{ $economic_factors['tertiary'] ?? '' }}</td>
            <td>{{ $economic_factors['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
               @php
                $environmental_factor = json_decode($datas->environmental_factor, true);
                @endphp
            <td>vi</td>
             <td></td>
            <td></td>
            <td>Environmental Factor</td>
              <td>{{ $environmental_factor['primary'] ?? '' }}</td>
            <td>{{ $environmental_factor['secondary'] ?? '' }}</td>
            <td>{{ $environmental_factor['tertiary'] ?? '' }}</td>
            <td>{{ $environmental_factor['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
                 @php
                $any_other = json_decode($datas->any_other, true);
                @endphp
            <td>vii</td>
             <td></td>
            <td></td>
            <td>Any Other</td>
               <td>{{ $any_other['primary'] ?? '' }}</td>
            <td>{{ $any_other['secondary'] ?? '' }}</td>
            <td>{{ $any_other['tertiary'] ?? '' }}</td>
            <td>{{ $any_other['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">T</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Threat</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            @php
            $threat_social_factor = json_decode($datas->threat_social_factor, true);
            @endphp
            <td>i</td>
            <td></td>
            <td></td>
            <td>Social Factor</td>
             <td>{{ $threat_social_factor['primary'] ?? '' }}</td>
            <td>{{ $threat_social_factor['secondary'] ?? '' }}</td>
            <td>{{ $threat_social_factor['tertiary'] ?? '' }}</td>
            <td>{{ $threat_social_factor['remarks'] ?? '' }}</td>
         </tr>
         
          <tr>
               @php
            $threat_technological_factor = json_decode($datas->threat_technological_factor, true);
            @endphp
            <td>ii</td>
            <td></td>
            <td></td>
            <td>Technological Factor</td>
             <td>{{ $threat_technological_factor['primary'] ?? '' }}</td>
            <td>{{ $threat_technological_factor['secondary'] ?? '' }}</td>
            <td>{{ $threat_technological_factor['tertiary'] ?? '' }}</td>
            <td>{{ $threat_technological_factor['remarks'] ?? '' }}</td>
         </tr>  
         
           
         
           <tr>
                @php
            $threat_legal_factor = json_decode($datas->threat_legal_factor, true);
            @endphp
            <td>iii</td>
            <td></td>
            <td></td>
            <td>Legal Factor</td>
           <td>{{ $threat_legal_factor['primary'] ?? '' }}</td>
            <td>{{ $threat_legal_factor['secondary'] ?? '' }}</td>
            <td>{{ $threat_legal_factor['tertiary'] ?? '' }}</td>
            <td>{{ $threat_legal_factor['remarks'] ?? '' }}</td>
         </tr>  
         
         <tr>
              @php
                $threat_political_factor = json_decode($datas->threat_political_factor, true);
                @endphp
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Political Factor</td>
            <td>{{ $threat_political_factor['primary'] ?? '' }}</td>
            <td>{{ $threat_political_factor['secondary'] ?? '' }}</td>
            <td>{{ $threat_political_factor['tertiary'] ?? '' }}</td>
            <td>{{ $threat_political_factor['remarks'] ?? '' }}</td>
         </tr> 
          
           <tr>
                  @php
                $threat_economic_factors = json_decode($datas->threat_economic_factors, true);
                @endphp
            <td>v</td>
             <td></td>
            <td></td>
            <td>Economic Factors</td>
            <td>{{ $threat_economic_factors['primary'] ?? '' }}</td>
            <td>{{ $threat_economic_factors['secondary'] ?? '' }}</td>
            <td>{{ $threat_economic_factors['tertiary'] ?? '' }}</td>
            <td>{{ $threat_economic_factors['remarks'] ?? '' }}</td>
         </tr> 
         
          <tr>
           @php
            $threat_environmental_factor = json_decode($datas->threat_environmental_factor, true);
            @endphp
            <td>vi</td>
             <td></td>
            <td></td>
            <td>Environmental Factor</td>
                   <td>{{ $threat_environmental_factor['primary'] ?? '' }}</td>
            <td>{{ $threat_environmental_factor['secondary'] ?? '' }}</td>
            <td>{{ $threat_environmental_factor['tertiary'] ?? '' }}</td>
            <td>{{ $threat_environmental_factor['remarks'] ?? '' }}</td>
         </tr> 
         
         <tr>
                @php
                $threat_any_other = json_decode($datas->threat_any_other, true);
                @endphp
            <td>vii</td>
             <td></td>
            <td></td>
            <td>Any Other</td>
            <td>{{ $threat_any_other['primary'] ?? '' }}</td>
            <td>{{ $threat_any_other['secondary'] ?? '' }}</td>
            <td>{{ $threat_any_other['tertiary'] ?? '' }}</td>
            <td>{{ $threat_any_other['remarks'] ?? '' }}</td>
         </tr> 
       
         
        </tbody>
  </table>
    </div>
   @endforeach
    @else
         <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Infrastructure and Support Service</th>
            <th>Unit</th>
            <th>Unit Rate</th>
             <th>Amt (Rs.)</th>
             <th>Annulised Cost (Rs.)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
             <td></td>
            <td></td>
            <td>Cost of Establishment Permanent</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>2</td>
             <td></td>
            <td></td>
            <td>Cost of Establishment Temporary</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>  
         
         <tr>
            <td>3</td>
             <td></td>
            <td></td>
            <td>Cost Storage Structure for Procurement</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>4</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Electricity</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr>  
         
          <tr>
            <td>5</td>
             <td></td>
            <td></td>
            <td>Monthly Expenses on Manpower</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>6</td>
             <td></td>
            <td></td>
            <td >Monthly rent ( If Shop is on rent)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>6</td>
             <td></td>
            <td></td>
            <td>Monthly Travelling Expense </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>7</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on Capital  </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>8</td>
             <td></td>
            <td></td>
            <td>Any other fixed cost</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
       
         
            <tr>
            <td></td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Total Fixed Cost of Trader / Trader / Wholesaler</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>9</td>
             <td></td>
            <td></td>
            <td>Annual Interest Cost on working capital </td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>10</td>
             <td></td>
            <td></td>
            <td >Purchase from farmer at village Level / Farm Gate ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>11</td>
             <td></td>
            <td></td>
            <td>Purchase from farmer at Local Mandi ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>12</td>
             <td></td>
            <td></td>
            <td>Purchase from Commission Agent ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>13</td>
             <td></td>
            <td></td>
            <td>Purchase from Primary Processor ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>14</td>
             <td></td>
            <td></td>
            <td>Purchase from Secondary Processor ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>15</td>
             <td></td>
            <td></td>
            <td>Purchase from Tertiary Processor ?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>16</td>
             <td></td>
            <td></td>
            <td>Any other channel</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>17</td>
             <td></td>
            <td></td>
            <td>Most prevalent purchase mechanism ( 10/11/12/16 )?</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
        <tr>
            <td>18</td>
             <td></td>
            <td></td>
            <td>Duration of purchase on credit</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>19</td>
             <td></td>
            <td></td>
            <td>Duration of Sale on credit</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>20</td>
             <td></td>
            <td></td>
            <td>Any other information</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        </tbody>
  </table>
    <!--</div>-->
    <div class="table-responsive" style="margin-top:40px;">
     <h1 class="h3 mb-0 text-gray-800">B . Business parameters</h1>
      <br>
     <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <th>FARMER ID</th>
            <th>Farmer Name</th>
            <th>Particulars of Inputs</th>
            <th>Unit</th>
            <th>Name of Product</th>
            <th>Unit (quantity)</th>
            <th>Average Rate (Rs./Unit Quantity)</th>
            <th>Min Rate (Rs./Unit Quantity)</th>
            <th>Max Rate (Rs./Unit Quantity)</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>I</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Average Purchase Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
           <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
           <tr>
            <td></td>   <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
        <tr>
            <td></td> 
            <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>
         
         
         
          <tr>
            <td>II</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Cost of Value Addition</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         
           <tr>
            <td>a</td>
               <td></td>
            <td></td>
            <td>Transportation Cost</td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         
         <tr>
            <td>b</td>
               <td></td>
            <td></td>
            <td>Loading and Unloading Charges</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>c</td>
               <td></td>
            <td></td>
            <td>Primary Processing Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>d</td>
             <td></td>
            <td></td>
            <td>Drying Loss or any other loss</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td>e</td>
             <td></td>
            <td></td>
            <td>Establishment Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>f</td>
               <td></td>
            <td></td>
            <td>Marketing Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>g</td>
               <td></td>
            <td></td>
            <td>Storage Cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>h</td>
               <td></td>
            <td></td>
            <td>Any other cost</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
         <tr>
            <td>i</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>j</td>
               <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
          <tr>
            <td>III</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Selling Price</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         </tr> 
         
         
        <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade A (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade B (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade C (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Grade D (mention applicable grade specification)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>IV</td>
               <td></td>
            <td></td>
            <td style="font-weight:700;">Any other Cost Parameter</td>
            <td></td>
            <td></td>
            <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
         <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Quantum Handled in a year (weight)</td>
            <td></td>
             <td></td>
             <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
            <tr>
            <td></td>
               <td></td>
            <td></td>
            <td>Purchase and selling prices fluctuation during the whole marketing season</td>
            <td></td>
             <td></td>
             <td></td>
             <td></td>
             <td></td>
            <td></td>
             <td></td>
         </tr> 
         
        </tbody>
  </table>

    </div>
    <div class="table-responsive" style="margin-top:40px">
     <h1 class="h3 mb-0 text-gray-800">C . Indicative Parameters related with Farmers, Government Support, Policy, Regulation Licence etc., </h1>
     <br>
          <h1 class="h3 mb-0 text-gray-800">C. SWOT Analysis of the Distributor </h1>
        <br>
      <table class="table table-bordered ">
        <thead>
          <tr>
            <th>S. No.</th>
            <td>Farmer ID</td>
            <td>Farmer Name</td>
            <th>Particulars</th>
            <th>Primary Processing</th>
           <th>Secondary Processing</th>
           <th>Tertiary Processing</th>
            <th>Remark</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>S</td>
            <td></td>
            <td></td>
            <td style="font-weight:700;">Strength</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>   
         
         <tr>
            <td>i</td>
            <td></td>
            <td></td>
            <td>Government support ( Financial / Non Financial)</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>ii</td>
            <td></td>
            <td></td>
            <td>Market demand</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>  
         
           
         
           <tr>
            <td>iii</td>
            <td></td>
            <td></td>
            <td>Niche Market</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>  
         
         <tr>
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Availability of skilled / unskilled labour</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
           <tr>
            <td style="font-weight:700;">W</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Weakness</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>i</td>
            <td></td>
            <td></td>
            <td>Infrastructure and Support Services</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>ii</td>
            <td></td>
            <td></td>
            <td>Quality and Standard</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>  
         
           
         
           <tr>
            <td>iii</td>
            <td></td>
            <td></td>
            <td>Competitor (competitiveness)</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>  
         
         <tr>
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Cost of Financial Resources</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">O</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Opportunities</td>
            <td></td>
            <td></td>
               <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>i</td>
            <td></td>
            <td></td>
            <td>Social Factor</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>ii</td>
            <td></td>
            <td></td>
            <td>Technological Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>  
         
           
         
           <tr>
            <td>iii</td>
            <td></td>
            <td></td>
            <td>Legal Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>  
         
         <tr>
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Political Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
          
           <tr>
            <td>v</td>
             <td></td>
            <td></td>
            <td>Economic Factors</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>vi</td>
             <td></td>
            <td></td>
            <td>Environmental Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>vii</td>
             <td></td>
            <td></td>
            <td>Any Other</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td style="font-weight:700;">T</td>
             <td></td>
            <td></td>
            <td style="font-weight:700;">Threat</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
        <tr>
            <td>i</td>
            <td></td>
            <td></td>
            <td>Social Factor</td>
            <td></td>
            <td></td>
             <td></td>
            <td></td>
         </tr>
         
          <tr>
            <td>ii</td>
            <td></td>
            <td></td>
            <td>Technological Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>  
         
           
         
           <tr>
            <td>iii</td>
            <td></td>
            <td></td>
            <td>Legal Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr>  
         
         <tr>
            <td>iv</td>
             <td></td>
            <td></td>
            <td>Political Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
          
           <tr>
            <td>v</td>
             <td></td>
            <td></td>
            <td>Economic Factors</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
          <tr>
            <td>vi</td>
             <td></td>
            <td></td>
            <td>Environmental Factor</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
         
         <tr>
            <td>vii</td>
             <td></td>
            <td></td>
            <td>Any Other</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
         </tr> 
       
         
        </tbody>
  </table>
    </div>
     @endif
</div>

    <script>
        function exportTableData() {
            var tables = document.querySelectorAll("table"); 
            var csv = [];
        
            tables.forEach(function(table) {
                var rows = table.getElementsByTagName("tr");
                
                for (var i = 0; i < rows.length; i++) {
                    var row = [], cols = rows[i].getElementsByTagName("td");
                
                    for (var j = 0; j < cols.length; j++) {
                        row.push(cols[j].innerText);
                    }
                    csv.push(row.join(","));
                }
        
                csv.push("");
            });
            
            var csvData = new Blob([csv.join("\n")], { type: "text/csv" });
            var link = document.createElement("a");
            link.href = window.URL.createObjectURL(csvData);
            link.download = "table_data.csv";
            link.style.display = "none";
            
            document.body.appendChild(link);
            link.click();
            
            document.body.removeChild(link);
        }
    </script>

@endsection