<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'image',
        'email',
        'role_id',
        'employee_code',
        'fpo_employee_code',
        'team_leader_id',
        'status',
        'password',
        'decrypt_password',
        'mobile_number',
        'husband_father_name',
        'address',
        'dob',
        'occupation',
        'designation',
        'doa',
        'aadhaar_number',
        'pan_number',
        'gender',
        'din_number',
        'toa',
        'num_of_shares',
        'cls_of_shares',
        'other_directorship',
        'company_debt',
        'single_share_values',
        'total_share_values',
        'cin_number',
        'company_logo',
        'registration_date',
        'authorized_capital_rs',
        'paidup_capital_rs',
        'authorized_person_name',
        'authorized_person_email',
        'authorized_person_mobile_num',
        'authorized_person_designation',
        'authorized_person_pan_num',
        'authorized_person_aadhaar_num',
        'state_id',
        'district_id',
        'village',
        'farmer_code_id',
        'block',
        'pan_card',
        'aadhaar_card',
        'moa',
        'aoa',
        'gst_certificate',
        'gst_statement',
        'audited_financial',
        'bank_statement',
        'photo',
        'pincode',
        'phone_type',
        'bank_account_number',
        'confirm_bank_account_number',
        'ifsc_code',
        'education',
        'roc_certificate',
        'education_certificate',
        'role_id',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * Get the user's full name.
     *
     * @return string
     */
    public function getFullNameAttribute()
    {
        return "{$this->first_name} {$this->last_name}";
    }
    
    public function rolePermissions()
    {
        return $this->hasMany(RolePermission::class, 'role_id', 'id');
    }


}
