<?php

namespace App\Http\Controllers;

use App\Exports\UsersExport;
use App\Imports\UsersImport;
use App\Models\User;
use App\Models\Farmer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Password;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Facades\Excel;
use Spatie\Permission\Models\Role;

class ReportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
      
    }

    public function report(Request $request)
    {
       
    //   try{
    //           $report_detail = DB::table('crops')
            
    //           ->leftjoin('farmers','farmers.id','=','crops.farmer_id')
    //           ->leftjoin('crop_cultivations','crop_cultivations.crop_id','=','crops.id')
    //           ->leftjoin('production_outputs','production_outputs.crop_id','=','crops.id')
    //           ->select('crops.*','farmers.name as farmer_name','farmers.village','farmers.district','farmers.mobile_number','farmers.state',
    //                   'crop_cultivations.*','production_outputs.by_product','production_outputs.sold_main_product','production_outputs.total_main_product_sold')
    //           ->orderBy('farmers.id','DESC')
    //           ->paginate(10);
    //           return view('Report.list',['report_details'=> $report_detail]);

    //     } catch (\Throwable $th) {
           
    //         DB::rollBack();
    //         return redirect()->back()->withInput()->with('error', $th->getMessage());
    //     }
    
        try {
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
    
            $query = DB::table('crops')
                ->leftJoin('farmers', 'farmers.id', '=', 'crops.farmer_id')
                ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
                ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
                ->select(
                    'crops.*', 'crops.created_at as cropsDate',
                    'farmers.name as farmer_name',
                    'farmers.village',
                    'farmers.district',
                    'farmers.mobile_number',
                    'farmers.state',
                    'crop_cultivations.*',
                    'production_outputs.by_product',
                    'production_outputs.sold_main_product',
                    'production_outputs.total_main_product_sold'
                );
    
            if ($startDate && $endDate) {
                $query->whereBetween('crops.created_at', [$startDate, $endDate]);
            } elseif ($startDate) {
                $query->whereDate('crops.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $query->whereDate('crops.created_at', '<=', $endDate);
            } else {
                $query->whereDate('crops.created_at', '=', now()->toDateString());
            }
    
            $report_detail = $query->orderBy('crops.id', 'DESC')->paginate(15);
    
            return view('Report.list', ['report_details' => $report_detail]);
        } catch (\Throwable $th) {
            return redirect()->back()->withInput()->with('error', $th->getMessage());
        }
    }
    
    public function aacombine_list(Request $request)
    {
        try {
            $currentYear = date('Y');
            $lastThreeYears = [$currentYear - 3, $currentYear - 2, $currentYear - 1, $currentYear];
    
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            $dataQuery = DB::table('last_year_productions')
                ->select('last_year_productions.*')
                ->where(function ($query) use ($lastThreeYears) {
                    $query->whereIn('last_year_productions.first_year', $lastThreeYears)
                        ->orWhereIn('last_year_productions.second_year', $lastThreeYears)
                        ->orWhereIn('last_year_productions.third_year', $lastThreeYears);
                });
    
            if ($startDate && $endDate) {
                $dataQuery->whereBetween('last_year_productions.created_at', [$startDate, $endDate]);
            } elseif ($startDate) {
                $dataQuery->whereDate('last_year_productions.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('last_year_productions.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('last_year_productions.created_at', '=', now()->toDateString());
            }
    
            $data = $dataQuery->orderBy('last_year_productions.farmer_id', 'DESC')->paginate(15);
    
            return view('Report.aa', ['data' => $data, 'lastThreeYears' => $lastThreeYears]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }

    
    public function aaacombine_list(Request $request)
    {
        try{
            $currentYear = date('Y');
            $lastThreeYears = [$currentYear - 3,$currentYear - 2, $currentYear - 1, $currentYear];
           
            // $month = $request->input('month');
            // $year = $request->input('year');
            
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            $dataQuery = DB::table('last_year_productions')
                ->select('last_year_productions.*')
                ->where(function ($query) use ($lastThreeYears) {
                    $query->whereIn('last_year_productions.first_year', $lastThreeYears)
                          ->orWhereIn('last_year_productions.second_year', $lastThreeYears)
                          ->orWhereIn('last_year_productions.third_year', $lastThreeYears);
                });

            // if ($month) 
            // {
            //     $dataQuery->whereMonth('last_year_productions.created_at', $month);
            // }
            // else
            // {
            //     $dataQuery->whereDate('last_year_productions.created_at', '=', now()->toDateString());
            // }
    
            // if ($year) 
            // {
            //     $dataQuery->whereYear('last_year_productions.created_at', $year);
            // }
            // else
            // {
            //     $dataQuery->whereDate('last_year_productions.created_at', '=', now()->toDateString());
            // }
            
            if ($startDate && $endDate) {
                $dataQuery->whereBetween('last_year_productions.created_at', [$startDate, $endDate]);
            } elseif ($startDate) {
                $dataQuery->whereDate('last_year_productions.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('last_year_productions.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('last_year_productions.created_at', '=', now()->toDateString());
            }
    
            $data = $dataQuery->orderBy('last_year_productions.farmer_id', 'DESC')->paginate(15);
            
            return view('Report.aaa',['data'=>$data , 'lastThreeYears' => $lastThreeYears]);
        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    public function iabcombine_list(Request $request)
    {   
        try{
            
            // $month = $request->input('month');
            // $year = $request->input('year');
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            $query = DB::table('crops')
                ->select([
                    'farmers.*',
                    'crops.*',
                    'crops.created_at as created_at',
                    'crop_cultivations.*',
                    'production_outputs.total_production',
                    'production_outputs.sold_main_product',
                    'production_outputs.selling_price_main_product',
                    'production_outputs.by_product',
                    'production_outputs.selling_price_by_product',
                    'production_outputs.village_trader',
                    'production_outputs.wholesaler',
                    'production_outputs.mandi',
                    'production_outputs.processor',
                    'production_outputs.retailer',
                    'production_outputs.consumer',
                    'irrigation_infrastructures.*',
                    'farm_mechanisms.*',
                    'farm_mechanisms.other as farm_mechanism_other',
                    'storage_structures.*',
                    'processing_infrastructures.*',
                    'retail_outlets.*',
                    'other_infrastructures.*',
            ])
            ->leftjoin('farmers','farmers.id','=','crops.farmer_id')
            ->leftjoin('crop_cultivations','crop_cultivations.crop_id','=','crops.id')
            ->leftjoin('production_outputs','production_outputs.crop_id','=','crops.id')
            ->leftjoin('irrigation_infrastructures','irrigation_infrastructures.crop_id','=','crops.id')
            ->leftjoin('farm_mechanisms','farm_mechanisms.crop_id','=','crops.id')
            ->leftjoin('storage_structures','storage_structures.crop_id','=','crops.id')
            ->leftjoin('processing_infrastructures','processing_infrastructures.crop_id','=','crops.id')
            ->leftjoin('retail_outlets','retail_outlets.crop_id','=','crops.id')
            ->leftjoin('other_infrastructures','other_infrastructures.crop_id','=','crops.id');
            // if ($month) {
            //     $query->whereMonth('crops.created_at', $month);
            // }
    
            // if ($year) {
            //     $query->whereYear('crops.created_at', $year);
            // }
            
            if ($startDate && $endDate) {
                $query->whereBetween('crops.created_at', [$startDate, $endDate]);
            } elseif ($startDate) {
                $query->whereDate('crops.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $query->whereDate('crops.created_at', '<=', $endDate);
            } else {
                $query->whereDate('crops.created_at', '=', now()->toDateString());
            }
    
            $data = $query->orderBy('crops.id', 'DESC')->paginate(15);
            
            return view('Report.iab',['data'=>$data]);
        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }

}
