<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use App\Rules\MatchOldPassword;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use App\Models\HectareMaster;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\Models\economic_life_farm_assets_master;




class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $userAuth = Auth::user();
        
        $Hectare= HectareMaster::where('status',1)->get();
        $states = DB::table('states')->get();
        $fpo = User::where('role_id',44)->where('status',1)->whereNotNull('first_name')->select('first_name','id')->get();
        return view('home',['Hectare'=>$Hectare , 'states'=>$states, 'fpo'=>$fpo]);
    }
    
   
    
  


  
   public function filter(Request $request)
    {
      // dd($request->all());
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        $current_user_role_id = $userAuth['role_id'];
        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');
        $annexure = $request->input('annexure');
        if ($startDate) {
            $startDate = Carbon::createFromFormat('d/m/Y', $startDate)->format('Y-m-d');
        }
    
        if ($endDate) {
            $endDate = Carbon::createFromFormat('d/m/Y', $endDate)->format('Y-m-d');
        }
        
        if($annexure == 1){

        $crop_name = strtolower($request->input('crop_name'));
        $state_id = $request->input('state_id');
        $district_id = $request->input('district_id');
        $village = $request->input('village');
        
        $fpo_id = $request->input('fpo_id');
        
        $from_hectare = $request->input('from_hectare');
        
        $to_hectare = $request->input('to_hectare');
        
        $whom_to_sold = $request->input('whom_to_sold');
        
        $farmers_land_wise = $request->input('farmers_land_wise');
        
        $block = $request->input('block');
       

        if (!empty($farmers_land_wise)) {
                switch ($farmers_land_wise) {
                    case 'Marginal: Less than 1 hectare':
                        $from_hectare = 0;
                        $to_hectare = 1;
                        break;
                    case 'Small: 1–2 hectares':
                        $from_hectare = 1;
                        $to_hectare = 2;
                        break;
                    case 'Semi-medium: 2–4 hectares':
                        $from_hectare = 2;
                        $to_hectare = 4;
                        break;
                    case 'Medium: 4–10 hectares':
                        $from_hectare = 4;
                        $to_hectare = 10;
                        break;
                    case 'Large: More than 10 hectares':
                        $from_hectare = 10;
                        $to_hectare = null;
                        break;
                    default:
                        $from_hectare = 0;
                        $to_hectare = 0;
                        break;
                }
            }
    
        // Format start and end date if present
            

    
        // Start building the query
        $query = DB::table('crops')->select(
            'crops.*',
            'users.team_leader_id',
            'users.village as user_village',
            'users.role_id',
            'users.farmer_code_id as farmer_code',
            'users.first_name as farmer_first_name',
            'users.last_name as farmer_last_name',
            'users.husband_father_name as farmer_husband_father_name',
            'states.state_name as farmer_state_name',
            'districts.district_name as farmer_district_name',
            'users.block as farmer_block',
            'users.mobile_number as farmer_mobile_number',
            'farmers.id as farmerId',
            'farmers.*',
            'crops.crop_area as crop_areas',
            'crop_cultivations.*',
            'production_outputs.*',
            'production_outputs.other as production_outputs_other',
            'irrigation_infrastructures.*',
            'irrigation_infrastructures.other as irrigation_infrastructures_other',
            'farm_mechanisms.*',
            'farm_mechanisms.other as farm_mechanisms_other',
            'storage_structures.*',
            'storage_structures.other as storage_structures_other',
            'processing_infrastructures.*',
            'retail_outlets.*',
            'other_infrastructures.*',
            'crops.id as id',
            'crops.user_id as user_id'
        )
        ->leftJoin('users', 'users.id', '=', 'crops.user_id')
        ->leftJoin('states', 'states.id', '=', 'users.state_id')
        ->leftJoin('districts', 'districts.id', '=', 'users.district_id')
        ->leftJoin('farmers', 'farmers.user_id', '=', 'crops.farmer_id')
        ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
        ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
        ->leftJoin('farm_mechanisms', 'farm_mechanisms.crop_id', '=', 'crops.id')
        ->leftJoin('irrigation_infrastructures', 'irrigation_infrastructures.crop_id', '=', 'crops.id')
        ->leftJoin('storage_structures', 'storage_structures.crop_id', '=', 'crops.id')
        ->leftJoin('processing_infrastructures', 'processing_infrastructures.crop_id', '=', 'crops.id')
        ->leftJoin('retail_outlets', 'retail_outlets.crop_id', '=', 'crops.id')
        ->leftJoin('other_infrastructures', 'other_infrastructures.crop_id', '=', 'crops.id');
    
        // Apply filters
        
        if (!empty($crop_name)) {
            $query->where('crops.crop_name', $crop_name);
        }
        
        
        if (!empty($state_id)) {
            $query->where('states.id', $state_id);
        }
    
        if (!empty($district_id)) {
            $query->where('districts.id', $district_id);
        }
    
        if (!empty($village)) {
            $query->where('users.village', $village);
        }
        
        if (!empty($fpo_id)) {
            $query->where('users.team_leader_id', $fpo_id);
        }
        
        if (!empty($block)) {
            $query->where('users.block', $block);
        }
        
        // Apply filters for crop_area
        if (!empty($from_hectare) && !empty($to_hectare)) {
            $from_hectare = intval(floor($from_hectare)); 
            $to_hectare = intval(ceil($to_hectare));
            $query->whereBetween('crops.crop_area', [$from_hectare, $to_hectare]);
        }

        // Apply filters for farmer-related hectare fields
        if (!empty($from_hectare) && !empty($to_hectare)) {
            $query->where(function ($query) use ($from_hectare, $to_hectare) {
                $query->whereBetween('farmers.land_holding_size', [$from_hectare, $to_hectare])
                    ->orWhereBetween('farmers.total_cultivable', [$from_hectare, $to_hectare])
                    ->orWhereBetween('farmers.land_holding_taken_lease', [$from_hectare, $to_hectare])
                    ->orWhereBetween('farmers.land_given_lease', [$from_hectare, $to_hectare]);
            });
        }
    
        if (!empty($whom_to_sold)) {
            switch ($whom_to_sold) {
                case 'Consumer':
                    $query->where('production_outputs.consumer', 1);
                    break;
                case 'Company':
                    $query->where('production_outputs.company', 1);
                    break;
                case 'Commission Agent':
                    $query->where('production_outputs.commission_agent', 1);
                    break;
                case 'Mandi':
                    $query->where('production_outputs.mandi', 1);
                    break;
                case 'Processor':
                    $query->where('production_outputs.processor', 1);
                    break;
                case 'Retailer':
                    $query->where('production_outputs.retailer', 1);
                    break;
                case 'Village Trader':
                    $query->where('production_outputs.village_trader', 1);
                    break;
                case 'Wholesaler':
                    $query->where('production_outputs.wholesaler', 1);
                    break;
                default:
                    $query->where('production_outputs.other', 1);
                    break;
            }
        }
        
        // User-based filtering
        $query->when($user_id, function ($query) use ($user_id, $current_user_role_id) {
            if (in_array($current_user_role_id, [41, 45, 47, 48])) {
                return $query;
            }
            // return $query->where(function ($query) use ($user_id) {
            //     $query->where('users.team_leader_id', $user_id)
            //           ->orWhere('users.id', $user_id);
            // });
        });
    
        // Apply date filters
        if ($startDate && $endDate) {
            if ($startDate && $endDate) {
                $query->whereBetween('crops.created_at', [$startDate, $endDate])
                    ->whereBetween('farmers.created_at', [$startDate, $endDate]);
            } elseif ($startDate) {
                $query->whereDate('crops.created_at', '>=', $startDate)
                    ->whereDate('farmers.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $query->whereDate('crops.created_at', '<=', $endDate)
                    ->whereDate('farmers.created_at', '<=', $endDate);
            } else {
                $query->whereDate('crops.created_at', '=', now()->toDateString())
                    ->whereDate('farmers.created_at', '=', now()->toDateString());
            }
        }else{
            
        }
    
        // Paginate and return results
        $data = $query->orderBy('farmers.id', 'DESC')->paginate(15);
    
        $deshboard = 1;
        return view('Anexure.anexure-one', ['data' => $data,'deshboard'=>$deshboard]);
      }elseif($annexure == 2){
        

     // Start building the query
        $query = DB::table('irrigation_infrastructures')->select(
        'users.*',
        'irrigation_infrastructures.*',
        'irrigation_infrastructures.other as irrigation_infrastructures_other',
        'farm_mechanisms.*',
        'farm_mechanisms.other as farm_mechanisms_other',
        'storage_structures.*',
        'storage_structures.other as storage_structures_other',
        'processing_infrastructures.*',
        'retail_outlets.*',
        'other_infrastructures.*',
        'investment_plantations.*'
        )
        ->leftJoin('users', 'users.id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('farm_mechanisms', 'farm_mechanisms.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('storage_structures', 'storage_structures.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('processing_infrastructures', 'processing_infrastructures.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('retail_outlets', 'retail_outlets.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('investment_plantations', 'investment_plantations.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('other_infrastructures', 'other_infrastructures.farmer_id', '=', 'irrigation_infrastructures.farmer_id');

       
        // Apply date range filter if both start and end dates are provided
        if ($startDate && $endDate) {
            $startDate = Carbon::parse($startDate);
            $endDate = Carbon::parse($endDate);
            $endDate->addDay();
           if ($startDate >= $endDate) {
                // If start and end dates are the same, use whereDate for that day
                $query->whereDate('irrigation_infrastructures.created_at', '=', $startDate);
            } else {
                // Use a date range
                $query->whereBetween('irrigation_infrastructures.created_at', [$startDate, $endDate]);
            }
        } elseif ($startDate) {
            $query->whereDate('irrigation_infrastructures.created_at', '>=', $startDate);
        } elseif ($endDate) {
            $query->whereDate('irrigation_infrastructures.created_at', '<=', $endDate);
        } else {
            // Optional: default to today if no dates provided
            $query->whereDate('irrigation_infrastructures.created_at', '=', now()->toDateString());
        }
    
        // Order and paginate results
        //$data = $query->orderBy('irrigation_infrastructures.farmer_id', 'DESC')->paginate(15);

        $data = $query->orderBy('irrigation_infrastructures.created_at', 'DESC')->paginate(15);
         
         $deshboard = 1;
         
         return view('Anexure.anexure-two', ['data' => $data, 'deshboard'=>$deshboard]);
         
      }elseif($annexure == 3){
         
        //   $animal_name = $request->input('animal_name');
        //   $breed = $request->input('breed');
        //   $whom_purchased = $request->input('whom_purchased');
         
         $currentYear = date('Y');
         $lastThreeYears = [$currentYear - 3, $currentYear - 2, $currentYear - 1, $currentYear];
          
        $dataQuery = DB::table('last_year_productions')
                ->select(
                    'last_year_productions.*', 
                    'users.farmer_code_id',
                      'users.first_name as farmer_first_name',
                      'users.last_name as farmer_last_name',
                    'users.team_leader_id'
                )
                ->distinct()
                ->leftJoin('users', 'users.id', '=', 'last_year_productions.farmer_id')
                ->leftJoin('agriculture_activities', 'agriculture_activities.farmer_id', '=', 'last_year_productions.farmer_id')
             
                ->where(function ($query) use ($lastThreeYears) {
                    $query->whereIn('last_year_productions.first_year', $lastThreeYears)
                          ->orWhereIn('last_year_productions.second_year', $lastThreeYears)
                          ->orWhereIn('last_year_productions.third_year', $lastThreeYears);
                })
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.id', $user_id);
                });
                
             
             
        //   if (!empty($animal_name)) {
        //     $dataQuery->where('agriculture_activities.animal_name', $animal_name);
        //   }   
          
        //   if (!empty($breed)) {
        //     $dataQuery->where('agriculture_activities.breed', $breed);
        //   }
          
        //   if (!empty($whom_purchased)) {
        //     $dataQuery->where('agriculture_activities.who_purchase', $whom_purchased);
        //   }
             
        
         
          if ($startDate && $endDate) {
                   $startDate = Carbon::parse($startDate);
                    $endDate = Carbon::parse($endDate);
                    $endDate->addDay();
           if ($startDate >= $endDate) {
                    $dataQuery->whereDate('last_year_productions.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('last_year_productions.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('last_year_productions.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('last_year_productions.created_at', '<=', $endDate);
            } else {
                 $dataQuery->whereDate('last_year_productions.created_at', '=', now()->toDateString());
            }
            $data = $dataQuery->orderBy('last_year_productions.id', 'DESC')->paginate(15);
            
         $deshboard = 1;
         return view('Anexure.anexure-three', ['data' => $data, 'lastThreeYears' => $lastThreeYears, 'deshboard'=>$deshboard]);
            
       }elseif($annexure == 4){
           
        $dataQuery = DB::table('agriculture_activities')
                ->select(
                    'agriculture_activities.*', 
                    'users.farmer_code_id',
                    'users.first_name as farmer_first_name',
                    'users.last_name as farmer_last_name'
                )
                ->leftJoin('users', 'users.id', '=', 'agriculture_activities.farmer_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.id', $user_id);
                });
            
            if ($startDate && $endDate) 
            {
                $startDate = Carbon::parse($startDate);
                $endDate = Carbon::parse($endDate);
                $endDate->addDay();
            if ($startDate >= $endDate) {
                    $dataQuery->whereDate('agriculture_activities.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('agriculture_activities.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('agriculture_activities.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('agriculture_activities.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('agriculture_activities.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 1;
            $data = $dataQuery->orderBy('agriculture_activities.id', 'DESC')->paginate(15);
          
            return view('Anexure.anexure-four', ['data' => $data,'deshboard'=>$deshboard]);
            
       }elseif($annexure == 5){
          $dataQuery = DB::table('input_suppliers')
                ->select(
                    'input_suppliers.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id'
                )
                ->leftJoin('users', 'input_suppliers.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                 $endDate = Carbon::parse($endDate);
                $endDate->addDay();
            if ($startDate >= $endDate) {
                    $dataQuery->whereDate('input_suppliers.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('input_suppliers.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('input_suppliers.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('input_suppliers.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('input_suppliers.created_at', '=', \Carbon\Carbon::today());
            }
            
            $perYear = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost of establishment of Input Shop Permanent')
            ->where('economic_life_name','INPUT SHOP PERMANENT')
            ->first();
            
            $stogest = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost Storage Structure for Inputs')
            ->where('economic_life_name','STORAGE GODOWN')
            ->first();
            
            $tempYear = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost of establishment of Input Shop Temporary')
            ->where('economic_life_name','INPUT SHOP TEMPARORY')->select('year')
            ->first();
            
            $monthElectricity = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Monthly Expenses on Electricity')
            ->where('economic_life_name','ELECTRICITY INSTALLATION')->select('year')
            ->first();
            
            $computerasso = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','COMPUTER & ELECTRONIC ASSOCERIES')
            ->where('economic_life_name','COMPUTER & ELECTRONIC ASSOCERIES')->select('year')
            ->first();
            
            $plant = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','PLANT & MACHINARY')
            ->where('economic_life_name','PLANT & MACHINARY')->select('year')
            ->first();
            
            $electricmoter = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','ELECTRIC MOTOR')
            ->where('economic_life_name','ELECTRIC MOTOR')->select('year')
            ->first();
            
            $disealengine = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','DISEAL ENGINE')
            ->where('economic_life_name','DISEAL ENGINE')->select('year')
            ->first();
            
            $tractorda = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','TRACTOR')
            ->where('economic_life_name','TRACTOR')->select('year')
            ->first();
            
            $deshboard = 1;
            $data = $dataQuery->orderBy('input_suppliers.id', 'DESC')->paginate(15);
            
            return view('Anexure.anexure-five', ['data' => $data,'deshboard'=>$deshboard ,'perYear'=>$perYear , 'stogest'=>$stogest , 'tempYear'=>$tempYear,
            'monthElectricity'=>$monthElectricity, 'computerasso'=>$computerasso , 'plant'=>$plant , 'electricmoter'=>$electricmoter, 'disealengine'=>$disealengine,
            'tractorda'=>$tractorda]);
       }elseif($annexure == 6){
           
            $dataQuery = DB::table('caph_farms')
                ->select(
                    'caph_farms.*', 
                    'users.team_leader_id',
                     'users.first_name',
                     'users.last_name',
                     'users.farmer_code_id',
                    'caph_farms.id as id'
                )
                ->leftJoin('users', 'users.id', '=', 'caph_farms.user_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                $endDate = Carbon::parse($endDate);
                $endDate->addDay();
            if ($startDate >= $endDate) {
                    $dataQuery->whereDate('caph_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('caph_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('caph_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('caph_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('caph_farms.created_at', '=', \Carbon\Carbon::today());
            }
            
            $deshboard = 1;
            
            $data = $dataQuery->orderBy('caph_farms.id', 'DESC')->paginate(15);
            
            $perYear = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost of establishment of Input Shop Permanent')
            ->where('economic_life_name','INPUT SHOP PERMANENT')->select('year')
            ->first();
            
            $tempYear = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost of establishment of Input Shop Temporary')
            ->where('economic_life_name','INPUT SHOP TEMPARORY')->select('year')
            ->first();
           
           $monthElectricity = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Monthly Expenses on Electricity')
            ->where('economic_life_name','ELECTRICITY INSTALLATION')->select('year')
            ->first();
            
            $coststorage = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost Storage Structure for Inputs')
            ->where('economic_life_name','STORAGE GODOWN')->select('year')
            ->first();
            
            return view('Anexure.anexure-six', ['data' => $data,'deshboard'=>$deshboard, 'perYear'=>$perYear , 'tempYear'=>$tempYear,
            'monthElectricity'=>$monthElectricity , 'coststorage'=>$coststorage]);
       }elseif($annexure == 7){
            
           $dataQuery = DB::table('trd_farms')
                ->select(
                    'trd_farms.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'trd_farms.id as id'
                )
                ->leftJoin('users', 'trd_farms.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                 $endDate = Carbon::parse($endDate);
                $endDate->addDay();
            if ($startDate >= $endDate) {
                    $dataQuery->whereDate('trd_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('trd_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('trd_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('trd_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('trd_farms.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 1;
            $data = $dataQuery->orderBy('trd_farms.user_id', 'DESC')->paginate(15);
            
             $perYear = economic_life_farm_assets_master::where('form_name','anexure-distributor')->where('field_name','Cost of Establishment Parmanant')
            ->where('economic_life_name','INPUT SHOP PERMANENT')->select('year')
            ->first();
            
            
            $tempYear = economic_life_farm_assets_master::where('form_name','anexure-distributor')->where('field_name','Cost of Establishment Temparory')
            ->where('economic_life_name','INPUT SHOP TEMPARORY')->select('year')
            ->first();
          
            return view('Anexure.anexure-seven', ['data' => $data,'deshboard'=>$deshboard , 'perYear'=>$perYear,'tempYear'=>$tempYear]);
            
       }elseif($annexure == 8){
          
         $dataQuery = DB::table('va_one_farms')
                ->select(
                    'va_one_farms.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'users.team_leader_id',
                    'va_one_farms.id as id'
                )
                ->leftJoin('users', 'users.id', '=', 'va_one_farms.user_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                 $endDate = Carbon::parse($endDate);
                $endDate->addDay();
                if ($startDate >= $endDate) {
                    $dataQuery->whereDate('va_one_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('va_one_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('va_one_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('va_one_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('va_one_farms.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data = $dataQuery->orderBy('va_one_farms.user_id', 'DESC')->paginate(15);
           
            $dataQuery1 = DB::table('va_two_farms')
                ->select(
                    'va_two_farms.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'users.team_leader_id',
                    'va_two_farms.id as id'
                )
                ->leftJoin('users', 'va_two_farms.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                $endDate = Carbon::parse($endDate);
                $endDate->addDay();
            if ($startDate >= $endDate) {
                    $dataQuery1->whereDate('va_two_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery1->whereBetween('va_two_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery1->whereDate('va_two_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery1->whereDate('va_two_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery1->whereDate('va_two_farms.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data1 = $dataQuery1->orderBy('va_two_farms.user_id', 'DESC')->paginate(15);
          
            $dataQuery2 = DB::table('va_three_farms')
                ->select(
                    'va_three_farms.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'users.team_leader_id',
                    'va_three_farms.id as id'
                )
                ->leftJoin('users', 'users.id', '=', 'va_three_farms.user_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                $endDate = Carbon::parse($endDate);
                $endDate->addDay();
            if ($startDate >= $endDate) {
                    $dataQuery2->whereDate('va_three_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery2->whereBetween('va_three_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery2->whereDate('va_three_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery2->whereDate('va_three_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery2->whereDate('va_three_farms.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 1;
            $data2 = $dataQuery2->orderBy('va_three_farms.user_id', 'DESC')->paginate(15);
           
            return view('Anexure.anexure-eight', ['data' => $data, 'data1' => $data1, 'data2' => $data2,'deshboard'=>$deshboard]);   
            
       }elseif($annexure == 9){
        
       $dataQuery2 = DB::table('backward_linkages')
                ->select(
                    'backward_linkages.*',
                    'backward_linkages.id as id',
                    'backward_linkage_twos.*',
                    'users.first_name as farmer_first_name',
                    'users.last_name as farmer_last_name',
                    'users.farmer_code_id'
                ) 
                ->leftJoin('users', 'users.id', '=', 'backward_linkages.farmer_id')
                ->leftJoin('backward_linkage_twos', 'backward_linkage_twos.backward_linkages_id', '=', 'backward_linkages.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('backward_linkages.farmer_id', $user_id);
                });
          
            if ($startDate && $endDate) {
                 $startDate = Carbon::parse($startDate);
                $endDate = Carbon::parse($endDate);
                $endDate->addDay();
            if ($startDate >= $endDate) {
                    $dataQuery2->whereDate('backward_linkages.created_at', '=', $startDate);
                } else {
                    $dataQuery2->whereBetween('backward_linkages.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery2->whereDate('backward_linkages.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery2->whereDate('backward_linkages.created_at', '<=', $endDate);
            } else {
                $dataQuery2->whereDate('backward_linkages.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data = $dataQuery2->orderBy('backward_linkages.id', 'DESC')->paginate(15);
            
            $deshboard = 1;

            return view('Anexure.anexure-e', ['data' => $data,'deshboard'=>$deshboard]);
       }elseif($annexure == 10){
                $dataQuery = DB::table('forward_linkages')
                ->select(
                    'forward_linkages.*',
                    'users.team_leader_id',
                    'users.farmer_code_id',
                    'users.first_name as farmer_first_name',
                    'users.last_name as farmer_last_name',
                    'forward_linkages.id as id'
                )
                ->leftJoin('users', 'users.id', '=', 'forward_linkages.farmer_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.id', $user_id);
                });
                
            if ($startDate && $endDate) {
                $startDate = Carbon::parse($startDate);
                $endDate = Carbon::parse($endDate);
                $endDate->addDay();
                if ($startDate >= $endDate) {
                    $dataQuery->whereDate('forward_linkages.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('forward_linkages.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('forward_linkages.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('forward_linkages.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('forward_linkages.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data = $dataQuery->orderBy('forward_linkages.farmer_id', 'DESC')->paginate(15);

            $deshboard = 1;

           
            return view('Anexure.anexure-f', ['data' => $data,'deshboard'=>$deshboard]);
       }elseif($annexure == 11){
           $dataQuery = DB::table('distributors')
                ->select(
                    'distributors.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'distributors.id as id'
                )
                ->leftJoin('users', 'distributors.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
           
            if ($startDate && $endDate) {
                $endDate = Carbon::parse($endDate);
                $endDate->addDay();
                if ($startDate >= $endDate) {
                    $dataQuery->whereDate('distributors.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('distributors.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('distributors.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('distributors.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('distributors.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 1;
            $data = $dataQuery->orderBy('distributors.user_id', 'DESC')->paginate(15);
            
            $perYear = economic_life_farm_assets_master::where('form_name','anexure-distributor')->where('field_name','Cost of Establishment Parmanant')
            ->where('economic_life_name','INPUT SHOP PERMANENT')->select('year')
            ->first();
            
            
            $tempYear = economic_life_farm_assets_master::where('form_name','anexure-distributor')->where('field_name','Cost of Establishment Temparory')
            ->where('economic_life_name','INPUT SHOP TEMPARORY')->select('year')
            ->first();
            
            
            return view('Anexure.Anexure-distributor', ['data' => $data,'deshboard'=>$deshboard,'perYear'=>$perYear,'tempYear'=>$tempYear]); 
       }elseif($annexure == 12){
           $dataQuery = DB::table('fpoa_masters')
                ->select(
                    'fpoa_masters.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'fpoa_masters.id as id'
                )
                ->leftJoin('users', 'fpoa_masters.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
           
            if ($startDate && $endDate) {
              $endDate = Carbon::parse($endDate);
                $endDate->addDay();
                if ($startDate >= $endDate) {
                    $dataQuery->whereDate('fpoa_masters.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('fpoa_masters.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('fpoa_masters.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('fpoa_masters.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('fpoa_masters.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 1;
            $data = $dataQuery->orderBy('fpoa_masters.id', 'DESC')->paginate(15);
            
            return view('Anexure.fpo-a', ['data' => $data,'deshboard'=>$deshboard]);
       }elseif($annexure == 13){
           $dataQuery = DB::table('fpob_masters')
                ->select(
                    'fpob_masters.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'fpob_masters.id as id'
                )
                ->leftJoin('users', 'fpob_masters.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
           
            if ($startDate && $endDate) {
               $endDate = Carbon::parse($endDate);
                $endDate->addDay();
                if ($startDate >= $endDate) {
                    $dataQuery->whereDate('fpob_masters.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('fpob_masters.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('fpob_masters.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('fpob_masters.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('fpob_masters.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 1;
            $data = $dataQuery->orderBy('fpob_masters.user_id', 'DESC')->paginate(15);
          
            return view('Anexure.fpo-b', ['data' => $data,'deshboard'=>$deshboard]);
       }
       else{
           return back();
       }
      
    }
 


//  public function filter(Request $request)
// {
    
//     $userAuth = Auth::user();
//     $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
//     $current_user_role_id = $userAuth['role_id'];
//     $startDate = $request->input('start_date');
//     $endDate = $request->input('end_date');
//     $annexure = $request->input('annexure');
//     if ($startDate) {
//         $startDate = Carbon::createFromFormat('d/m/Y', $startDate)->format('Y-m-d');
//     }

//     if ($endDate) {
//         $endDate = Carbon::createFromFormat('d/m/Y', $endDate)->format('Y-m-d');
//     }
//     if($annexure == 1){

//     $crop_name = strtolower($request->input('crop_name'));
//     $state_id = $request->input('state_id');
//     $district_id = $request->input('district_id');
//     $village = $request->input('village');
    
//     $fpo_id = $request->input('fpo_id');
    
//     $from_hectare = $request->input('from_hectare');
    
//     $to_hectare = $request->input('to_hectare');
    
//     $whom_to_sold = $request->input('whom_to_sold');
    
//     $farmers_land_wise = $request->input('farmers_land_wise');
    
//     $block = $request->input('block');
   

//     if (!empty($farmers_land_wise)) {
//             switch ($farmers_land_wise) {
//                 case 'Marginal: Less than 1 hectare':
//                     $from_hectare = 0;
//                     $to_hectare = 1;
//                     break;
//                 case 'Small: 1–2 hectares':
//                     $from_hectare = 1;
//                     $to_hectare = 2;
//                     break;
//                 case 'Semi-medium: 2–4 hectares':
//                     $from_hectare = 2;
//                     $to_hectare = 4;
//                     break;
//                 case 'Medium: 4–10 hectares':
//                     $from_hectare = 4;
//                     $to_hectare = 10;
//                     break;
//                 case 'Large: More than 10 hectares':
//                     $from_hectare = 10;
//                     $to_hectare = null;
//                     break;
//                 default:
//                     $from_hectare = 0;
//                     $to_hectare = 0;
//                     break;
//             }
//         }

//     // Format start and end date if present
        


//     // Start building the query
//     $query = DB::table('crops')->select(
//         'crops.*',
//         'users.team_leader_id',
//         'users.village as user_village',
//         'users.role_id',
//         'users.farmer_code_id as farmer_code',
//         'users.first_name as farmer_first_name',
//         'users.last_name as farmer_last_name',
//         'users.husband_father_name as farmer_husband_father_name',
//         'states.state_name as farmer_state_name',
//         'districts.district_name as farmer_district_name',
//         'users.block as farmer_block',
//         'users.mobile_number as farmer_mobile_number',
//         'farmers.id as farmerId',
//         'farmers.*',
//         'crops.crop_area as crop_areas',
//         'crop_cultivations.*',
//         'production_outputs.*',
//         'production_outputs.other as production_outputs_other',
//         'irrigation_infrastructures.*',
//         'irrigation_infrastructures.other as irrigation_infrastructures_other',
//         'farm_mechanisms.*',
//         'farm_mechanisms.other as farm_mechanisms_other',
//         'storage_structures.*',
//         'storage_structures.other as storage_structures_other',
//         'processing_infrastructures.*',
//         'retail_outlets.*',
//         'other_infrastructures.*',
//         'crops.id as id',
//         'crops.user_id as user_id'
//     )
//     ->leftJoin('users', 'users.id', '=', 'crops.user_id')
//     ->leftJoin('states', 'states.id', '=', 'users.state_id')
//     ->leftJoin('districts', 'districts.id', '=', 'users.district_id')
//     ->leftJoin('farmers', 'farmers.user_id', '=', 'crops.farmer_id')
//     ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
//     ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
//     ->leftJoin('farm_mechanisms', 'farm_mechanisms.crop_id', '=', 'crops.id')
//     ->leftJoin('irrigation_infrastructures', 'irrigation_infrastructures.crop_id', '=', 'crops.id')
//     ->leftJoin('storage_structures', 'storage_structures.crop_id', '=', 'crops.id')
//     ->leftJoin('processing_infrastructures', 'processing_infrastructures.crop_id', '=', 'crops.id')
//     ->leftJoin('retail_outlets', 'retail_outlets.crop_id', '=', 'crops.id')
//     ->leftJoin('other_infrastructures', 'other_infrastructures.crop_id', '=', 'crops.id');

//     // Apply filters
    
//     if (!empty($crop_name)) {
//         $query->where('crops.crop_name', $crop_name);
//     }
    
    
//     if (!empty($state_id)) {
//         $query->where('states.id', $state_id);
//     }

//     if (!empty($district_id)) {
//         $query->where('districts.id', $district_id);
//     }

//     if (!empty($village)) {
//         $query->where('users.village', $village);
//     }
    
//     if (!empty($fpo_id)) {
//         $query->where('users.team_leader_id', $fpo_id);
//     }
    
//     if (!empty($block)) {
//         $query->where('users.block', $block);
//     }
    
//     // Apply filters for crop_area
//     if (!empty($from_hectare) && !empty($to_hectare)) {
//         $from_hectare = intval(floor($from_hectare)); 
//         $to_hectare = intval(ceil($to_hectare));
//         $query->whereBetween('crops.crop_area', [$from_hectare, $to_hectare]);
//     }

//     // Apply filters for farmer-related hectare fields
//     if (!empty($from_hectare) && !empty($to_hectare)) {
//         $query->where(function ($query) use ($from_hectare, $to_hectare) {
//             $query->whereBetween('farmers.land_holding_size', [$from_hectare, $to_hectare])
//                 ->orWhereBetween('farmers.total_cultivable', [$from_hectare, $to_hectare])
//                 ->orWhereBetween('farmers.land_holding_taken_lease', [$from_hectare, $to_hectare])
//                 ->orWhereBetween('farmers.land_given_lease', [$from_hectare, $to_hectare]);
//         });
//     }

//     if (!empty($whom_to_sold)) {
//         switch ($whom_to_sold) {
//             case 'Consumer':
//                 $query->where('production_outputs.consumer', 1);
//                 break;
//             case 'Company':
//                 $query->where('production_outputs.company', 1);
//                 break;
//             case 'Commission Agent':
//                 $query->where('production_outputs.commission_agent', 1);
//                 break;
//             case 'Mandi':
//                 $query->where('production_outputs.mandi', 1);
//                 break;
//             case 'Processor':
//                 $query->where('production_outputs.processor', 1);
//                 break;
//             case 'Retailer':
//                 $query->where('production_outputs.retailer', 1);
//                 break;
//             case 'Village Trader':
//                 $query->where('production_outputs.village_trader', 1);
//                 break;
//             case 'Wholesaler':
//                 $query->where('production_outputs.wholesaler', 1);
//                 break;
//             default:
//                 $query->where('production_outputs.other', 1);
//                 break;
//         }
//     }
    
//     // User-based filtering
//     $query->when($user_id, function ($query) use ($user_id, $current_user_role_id) {
//         if (in_array($current_user_role_id, [41, 45, 47, 48])) {
//             return $query;
//         }
//         // return $query->where(function ($query) use ($user_id) {
//         //     $query->where('users.team_leader_id', $user_id)
//         //           ->orWhere('users.id', $user_id);
//         // });
//     });

//     // Apply date filters
//     if ($startDate && $endDate) {
//         if ($startDate && $endDate) {
//             $query->whereBetween('crops.created_at', [$startDate, $endDate])
//                 ->whereBetween('farmers.created_at', [$startDate, $endDate]);
//         } elseif ($startDate) {
//             $query->whereDate('crops.created_at', '>=', $startDate)
//                 ->whereDate('farmers.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $query->whereDate('crops.created_at', '<=', $endDate)
//                 ->whereDate('farmers.created_at', '<=', $endDate);
//         } else {
//             $query->whereDate('crops.created_at', '=', now()->toDateString())
//                 ->whereDate('farmers.created_at', '=', now()->toDateString());
//         }
//     }else{
        
//     }

//     // Paginate and return results
//     $data = $query->orderBy('farmers.id', 'DESC')->paginate(15);
    
//     $deshboard = 1;
//     return view('Anexure.anexure-one', ['data' => $data,'deshboard'=>$deshboard]);
//  }elseif($annexure == 2){
     
//       $animal_name = $request->input('animal_name');
//       $breed = $request->input('breed');
//       $whom_purchased = $request->input('whom_purchased');
     
//      $currentYear = date('Y');
//      $lastThreeYears = [$currentYear - 3, $currentYear - 2, $currentYear - 1, $currentYear];
      
//      $dataQuery = DB::table('last_year_productions')
//          ->select(
//              'last_year_productions.*', 
//              'agriculture_activities.*',
//              'users.farmer_code_id',
//              // 'farmers.*', 
//              'users.team_leader_id'
//              // 'users.farmer_code_id',
//              // 'last_year_productions.id as id'
//          )

//          ->leftJoin('users', 'users.id', '=', 'last_year_productions.farmer_id')
         
//          ->leftJoin('agriculture_activities', 'agriculture_activities.farmer_id', '=', 'last_year_productions.farmer_id')

//          ->where(function ($query) use ($lastThreeYears) {
//              $query->whereIn('last_year_productions.first_year', $lastThreeYears)
//                   ->orWhereIn('last_year_productions.second_year', $lastThreeYears)
//                   ->orWhereIn('last_year_productions.third_year', $lastThreeYears);
//          })
//          ->when($user_id, function ($query, $user_id) {
//              // return $query->where('users.team_leader_id', $user_id);
//              return $query->where('users.id', $user_id);
//          })
//          ->orderBy('last_year_productions.farmer_id');
         
         
//       if (!empty($animal_name)) {
//         $dataQuery->where('agriculture_activities.animal_name', $animal_name);
//       }   
      
//       if (!empty($breed)) {
//         $dataQuery->where('agriculture_activities.breed', $breed);
//       }
      
//       if (!empty($whom_purchased)) {
//         $dataQuery->where('agriculture_activities.who_purchase', $whom_purchased);
//       }
         
    
     
//      if ($startDate && $endDate) {
//              $dataQuery->whereBetween('last_year_productions.created_at', [$startDate, $endDate]);
//      } elseif ($startDate) {
//          $dataQuery->whereDate('last_year_productions.created_at', '>=', $startDate);
//      } elseif ($endDate) {
//          $dataQuery->whereDate('last_year_productions.created_at', '<=', $endDate);
//      } else {
//          $dataQuery->whereDate('last_year_productions.created_at', '=', now()->toDateString());
//      }
     
//      $data = $dataQuery->orderBy('last_year_productions.id', 'DESC')->paginate(15);
     
//      $deshboard = 1;
//      return view('Anexure.anexure-two', ['data' => $data, 'lastThreeYears' => $lastThreeYears, 'deshboard'=>$deshboard]);
//   }elseif($annexure == 3){
     
//         $dataQuery = DB::table('agriculture_activities')
//             ->select(
//                 'agriculture_activities.*', 
//                 'users.farmer_code_id'
//                 // 'farmers.*',
//                 // 'users.team_leader_id',
//                 // 'agriculture_activities.id as id'
//             )
//             // ->leftJoin('farmers', 'farmers.id', '=', 'agriculture_activities.farmer_id')
//             // ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//             ->leftJoin('users', 'users.id', '=', 'agriculture_activities.farmer_id')
//             ->when($user_id, function ($query, $user_id) {
//                 // return $query->where('users.team_leader_id', $user_id);
//                 return $query->where('users.id', $user_id);
//             });
        
//         if ($startDate && $endDate) 
//         {
//           $dataQuery->whereBetween('agriculture_activities.created_at', [$startDate, $endDate]);
//         } elseif ($startDate) {
//             $dataQuery->whereDate('agriculture_activities.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $dataQuery->whereDate('agriculture_activities.created_at', '<=', $endDate);
//         } else {
//             $dataQuery->whereDate('agriculture_activities.created_at', '=', \Carbon\Carbon::today());
//         }
//         $deshboard = 1;
//         $data = $dataQuery->orderBy('agriculture_activities.id', 'DESC')->paginate(15);
        
//         return view('Anexure.anexure-three', ['data' => $data,'deshboard'=>$deshboard]);
//   }elseif($annexure == 4){

//         $dataQuery = DB::table('forward_linkages')
//             ->select(
//                 'forward_linkages.*',
//                 // 'farmers.*',
//                 'users.team_leader_id',
//                 'users.farmer_code_id',
//                 // 'users.*',
//                 'forward_linkages.id as id'
//             )
//             // ->leftJoin('farmers', 'farmers.id', '=', 'forward_linkages.farmer_id')
//             // ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//             ->leftJoin('users', 'users.id', '=', 'forward_linkages.farmer_id')
//             ->when($user_id, function ($query, $user_id) {
//                 // return $query->where('users.team_leader_id', $user_id);
//                 return $query->where('users.id', $user_id);
//             });
            
//         if ($startDate && $endDate) {
//             $dataQuery->whereBetween('forward_linkages.created_at', [$startDate, $endDate]);
//         } elseif ($startDate) {
//             $dataQuery->whereDate('forward_linkages.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $dataQuery->whereDate('forward_linkages.created_at', '<=', $endDate);
//         } else {
//             $dataQuery->whereDate('forward_linkages.created_at', '=', \Carbon\Carbon::today());
//         }
        
//         $data = $dataQuery->orderBy('forward_linkages.farmer_id', 'DESC')->paginate(15);
        
//         $dataQuery2 = DB::table('backward_linkages')
//             ->select(
//                 'backward_linkages.*',
//                 'backward_linkages.id as id'
//             )->when($user_id, function ($query, $user_id) {
//                 // return $query->where('users.team_leader_id', $user_id);
//                 return $query->where('backward_linkages.farmer_id', $user_id);
//             });
        
//         if ($startDate && $endDate) {
            
//                 $dataQuery2->whereBetween('backward_linkages.created_at', [$startDate, $endDate]);
            
//         } elseif ($startDate) {
//             $dataQuery2->whereDate('backward_linkages.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $dataQuery2->whereDate('backward_linkages.created_at', '<=', $endDate);
//         } else {
//             $dataQuery2->whereDate('backward_linkages.created_at', '=', \Carbon\Carbon::today());
//         }
        
//         $data2 = $dataQuery2->orderBy('backward_linkages.farmer_id', 'DESC')->paginate(15);
        
//         $dataQuery3 = DB::table('backward_linkage_twos')
//             ->select(
//                 'backward_linkage_twos.*', 
//                 // 'farmers.*', 
//                 'users.team_leader_id'
//             )
//             // ->leftJoin('farmers', 'farmers.id', '=', 'backward_linkage_twos.farmer_id')
//             // ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//             ->leftJoin('users', 'users.id', '=', 'backward_linkage_twos.farmer_id')
//             ->when($user_id, function ($query, $user_id) {
//                 // return $query->where('users.team_leader_id', $user_id);
//                 return $query->where('users.id', $user_id);
//             });
            
//         if ($startDate && $endDate) {
//           $dataQuery3->whereBetween('backward_linkage_twos.created_at', [$startDate, $endDate]);
//         } elseif ($startDate) {
//             $dataQuery3->whereDate('backward_linkage_twos.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $dataQuery3->whereDate('backward_linkage_twos.created_at', '<=', $endDate);
//         } else {
//             $dataQuery3->whereDate('backward_linkage_twos.created_at', '=', \Carbon\Carbon::today());
//         }
//         $deshboard = 1;

//         $data3 = $dataQuery3->orderBy('backward_linkage_twos.farmer_id', 'DESC')->paginate(15);
        
//         return view('Anexure.anexure-four', ['data' => $data, 'data2' => $data2, 'data3' => $data3,'deshboard'=>$deshboard]);
//   }elseif($annexure == 5){
//         $dataQuery = DB::table('input_suppliers')
//             ->select(
//                 'input_suppliers.*', 
//                 'farmers.*', 
//                 'users.team_leader_id',
//                 'input_suppliers.id as id'
//             )
//             ->leftJoin('farmers', 'farmers.id', '=', 'input_suppliers.user_id')
//             ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//             ->when($user_id, function ($query, $user_id) {
//                 return $query->where('users.team_leader_id', $user_id);
//             });
        
//         if ($startDate && $endDate) {
//                 $dataQuery->whereBetween('input_suppliers.created_at', [$startDate, $endDate]);
//         } elseif ($startDate) {
//             $dataQuery->whereDate('input_suppliers.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $dataQuery->whereDate('input_suppliers.created_at', '<=', $endDate);
//         } else {
//             $dataQuery->whereDate('input_suppliers.created_at', '=', \Carbon\Carbon::today());
//         }
//         $deshboard = 1;
//         $data = $dataQuery->orderBy('input_suppliers.user_id', 'DESC')->paginate(15);
        
//         return view('Anexure.anexure-five', ['data' => $data,'deshboard'=>$deshboard]);
//   }elseif($annexure == 6){
          
        
//         $dataQuery = DB::table('caph_farms')
//             ->select(
//                 'caph_farms.*', 
//                 'farmers.*', 
//                 'users.team_leader_id',
//                 'caph_farms.id as id'
//             )
//             ->leftJoin('farmers', 'farmers.id', '=', 'caph_farms.user_id')
//             ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//             ->when($user_id, function ($query, $user_id) {
//                 return $query->where('users.team_leader_id', $user_id);
//             });
        
//         if ($startDate && $endDate) {
           
//                 $dataQuery->whereBetween('caph_farms.created_at', [$startDate, $endDate]);
            
//         } elseif ($startDate) {
//             $dataQuery->whereDate('caph_farms.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $dataQuery->whereDate('caph_farms.created_at', '<=', $endDate);
//         } else {
//             $dataQuery->whereDate('caph_farms.created_at', '=', \Carbon\Carbon::today());
//         }
//         $deshboard = 1;
        
//         $data = $dataQuery->orderBy('caph_farms.user_id', 'DESC')->paginate(15);
        
//         return view('Anexure.anexure-six', ['data' => $data,'deshboard'=>$deshboard]);
//   }elseif($annexure == 7){
            
//         $dataQuery = DB::table('trd_farms')
//             ->select(
//                 'trd_farms.*', 
//                 'farmers.*', 
//                 'users.team_leader_id',
//                 'trd_farms.id as id'
//             )
//             ->leftJoin('farmers', 'farmers.id', '=', 'trd_farms.farmer_id')
//             ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//             ->when($user_id, function ($query, $user_id) {
//                 return $query->where('users.team_leader_id', $user_id);
//             });
        
//         if ($startDate && $endDate) {
            
//                 $dataQuery->whereBetween('trd_farms.created_at', [$startDate, $endDate]);
            
//         } elseif ($startDate) {
//             $dataQuery->whereDate('trd_farms.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $dataQuery->whereDate('trd_farms.created_at', '<=', $endDate);
//         } else {
//             $dataQuery->whereDate('trd_farms.created_at', '=', \Carbon\Carbon::today());
//         }
        
//         $deshboard = 1;
       
//         $data = $dataQuery->orderBy('trd_farms.user_id', 'DESC')->paginate(15);
        
//         return view('Anexure.anexure-seven', ['data' => $data,'deshboard'=>$deshboard]);
//   }elseif($annexure == 8){
//         $dataQuery = DB::table('va_one_farms')
//             ->select(
//                 'va_one_farms.*', 
//                 'farmers.*', 
//                 'users.team_leader_id',
//                 'va_one_farms.id as id'
//             )
//             ->leftJoin('farmers', 'farmers.id', '=', 'va_one_farms.user_id')
//             ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//             ->when($user_id, function ($query, $user_id) {
//                 return $query->where('users.team_leader_id', $user_id);
//             });
        
//         if ($startDate && $endDate) {
           
//                 $dataQuery->whereBetween('va_one_farms.created_at', [$startDate, $endDate]);
            
//         } elseif ($startDate) {
//             $dataQuery->whereDate('va_one_farms.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $dataQuery->whereDate('va_one_farms.created_at', '<=', $endDate);
//         } else {
//             $dataQuery->whereDate('va_one_farms.created_at', '=', \Carbon\Carbon::today());
//         }
        
//         $data = $dataQuery->orderBy('va_one_farms.user_id', 'DESC')->paginate(15);
        
//         $dataQuery1 = DB::table('va_two_farms')
//             ->select(
//                 'va_two_farms.*', 
//                 'farmers.*', 
//                 'users.team_leader_id',
//                 'va_two_farms.id as id'
//             )
//             ->leftJoin('farmers', 'farmers.id', '=', 'va_two_farms.user_id')
//             ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//             ->when($user_id, function ($query, $user_id) {
//                 return $query->where('users.team_leader_id', $user_id);
//             });
        
//         if ($startDate && $endDate) {
           
//                 $dataQuery1->whereBetween('va_two_farms.created_at', [$startDate, $endDate]);
            
//         } elseif ($startDate) {
//             $dataQuery1->whereDate('va_two_farms.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $dataQuery1->whereDate('va_two_farms.created_at', '<=', $endDate);
//         } else {
//             $dataQuery1->whereDate('va_two_farms.created_at', '=', \Carbon\Carbon::today());
//         }
        
//         $data1 = $dataQuery1->orderBy('va_two_farms.user_id', 'DESC')->paginate(15);
        
//         $dataQuery2 = DB::table('va_three_farms')
//             ->select(
//                 'va_three_farms.*', 
//                 'farmers.*', 
//                 'users.team_leader_id',
//                 'va_three_farms.id as id'
//             )
//             ->leftJoin('farmers', 'farmers.id', '=', 'va_three_farms.user_id')
//             ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//             ->when($user_id, function ($query, $user_id) {
//                 return $query->where('users.team_leader_id', $user_id);
//             });
        
//         if ($startDate && $endDate) {
           
//                 $dataQuery2->whereBetween('va_three_farms.created_at', [$startDate, $endDate]);
            
//         } elseif ($startDate) {
//             $dataQuery2->whereDate('va_three_farms.created_at', '>=', $startDate);
//         } elseif ($endDate) {
//             $dataQuery2->whereDate('va_three_farms.created_at', '<=', $endDate);
//         } else {
//             $dataQuery2->whereDate('va_three_farms.created_at', '=', \Carbon\Carbon::today());
//         }
//         $deshboard = 1;
//         $data2 = $dataQuery2->orderBy('va_three_farms.user_id', 'DESC')->paginate(15);
        
//         return view('Anexure.anexure-eight', ['data' => $data, 'data1' => $data1, 'data2' => $data2,'deshboard'=>$deshboard]);
//   }else{
//       return back();
//   }
  
// }


    /**
     * User Profile
     * @param Nill
     * @return View Profile
     * @author Shani Singh
     */
    public function getProfile()
    {
        return view('profile');
    }




    /**
     * Update Profile
     * @param $profileData
     * @return Boolean With Success Message
     * @author Shani Singh
     */
    public function updateProfile(Request $request)
    {
        #Validations
        $request->validate([
            'first_name'    => 'required',
            'last_name'     => 'required',
            'mobile_number' => 'required|numeric|digits:10',
        ]);

        try {
            DB::beginTransaction();

            #Update Profile Data
            User::whereId(auth()->user()->id)->update([
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'mobile_number' => $request->mobile_number,
            ]);

            #Commit Transaction
            DB::commit();

            #Return To Profile page with success
            return back()->with('success', 'Profile Updated Successfully.');

        } catch (\Throwable $th) {
            DB::rollBack();
            return back()->with('error', $th->getMessage());
        }
    }

    /**
     * Change Password
     * @param Old Password, New Password, Confirm New Password
     * @return Boolean With Success Message
     * @author Shani Singh
     */
    public function changePassword(Request $request)
    {
        $request->validate([
            'current_password' => ['required', new MatchOldPassword],
            'new_password' => ['required'],
            'new_confirm_password' => ['same:new_password'],
        ]);

        try {
            DB::beginTransaction();

            #Update Password
            User::find(auth()->user()->id)->update(['password'=> Hash::make($request->new_password)]);

            #Commit Transaction
            DB::commit();

            #Return To Profile page with success
            return back()->with('success', 'Password Changed Successfully.');

        } catch (\Throwable $th) {
            DB::rollBack();
            return back()->with('error', $th->getMessage());
        }
    }
}
