<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Crop;
use App\Models\CropCultivation;
use App\Models\Farmer;
use App\Models\FarmMechanism;
use App\Models\IrrigationInfrastructure;
use App\Models\InfrastructureKey;
use App\Models\LastYearProduction;
use App\Models\OtherInfrastructure;
use App\Models\ProcessingInfrastructure;
use App\Models\ProductionOutput;
use App\Models\RetailOutlet;
use App\Models\StorageStructure;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Models\investment_plantation;

class AppController extends Controller
{


    public function createFarmer(Request $request)
    {
        if(isset($request->image))
        {
            if ($request->hasFile('image') && $request->file('image')->isValid()) {
                $uploadedFile = $request->file('image');
            
                $targetDir = "uploads/"; // Change this to your desired local folder path
            
                // Ensure the target directory exists, create it if necessary
                if (!file_exists($targetDir)) {
                    mkdir($targetDir, 0755, true);
                }
            
                $targetFile = $targetDir . $uploadedFile->getClientOriginalName();
            
                // Move the uploaded file to the desired location
                if ($uploadedFile->move($targetDir, $targetFile)) {
                   
                } else {
                    echo "Sorry, there was an error uploading your file.";
                }
            } else {
                echo "Error: No valid file uploaded.";
            }
        }

        try {

            $validator = Validator::make($request->all(), [
                // 'name' => 'required|string',
                // 'son_of' => 'required|string',
                // 'village' => 'required|string',
                // 'block' => 'required|string',
                // 'district' => 'required|string',
                "land_holding_size_unit"=> 'required|string',
                "land_holding_size"=> "required|string",
              
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'remark' => 'validation_error',
                    'status' => 'error',
                    'message' => ['error' => $validator->errors()],
                ]);
            }

            $add_farmer = new Farmer();
            // $add_farmer->name = $request->name;
            // $add_farmer->son_of = $request->son_of;
            // $add_farmer->village = $request->village;
            // $add_farmer->block = $request->block;
            // $add_farmer->district = $request->district;
            // $add_farmer->mobile_number = $request->mobile_number;
            $add_farmer->kcc_limit = $request->kcc_limit;
            $add_farmer->land_type = $request->land_type;
            $add_farmer->soil_health_card = $request->soil_health_card;
            $add_farmer->land_holding_size_unit = $request->land_holding_size_unit;
            $add_farmer->land_holding_size = $request->land_holding_size;
            $add_farmer->land_holding_taken_lease_unit = $request->land_holding_taken_lease_unit;
            $add_farmer->land_holding_taken_lease = $request->land_holding_taken_lease;
            $add_farmer->total_cultivable_unit = $request->total_cultivable_unit;
            $add_farmer->total_cultivable = $request->total_cultivable;
            $add_farmer->state = $request->state;
            $add_farmer->image = $request->image;
            $add_farmer->soil_health_card_remark = $request->soil_health_card_remark;
            $add_farmer->land_given_lease_unit = $request->land_given_lease_unit;
            $add_farmer->land_given_lease = $request->land_given_lease;
            $add_farmer->user_id = Auth::user()->id;
            $add_farmer->save();
            
            return response()->json([
                'status' => true,
                'message' => 'Farmer Created Successfully',
                'farmer_id' => $add_farmer->id
            ], 200);

        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }

    // 0ld code
    // public function loginUser(Request $request)
    // {
        
    //     try {
    //         $validator = Validator::make(
    //             $request->all(),
    //             [
    //                 'email' => 'required|string',
    //                 'password' => 'required|string'
    //             ]
    //         );
    
    //         if ($validator->fails()) {
    //             return response()->json([
    //                 'status' => false,
    //                 'message' => 'Validation error',
    //                 'errors' => $validator->errors()
    //             ], 422); 
    //         }
    
    //         $input = $request->input('email');
    //         $credentials = $request->only('password');
            
    //         if (filter_var($input, FILTER_VALIDATE_EMAIL)) {
    //             $user = User::where('email', $input)->first();
    //         } else {
    //             $user = User::where('farmer_code_id', $input)->first();
    //         }
            
    //         // echo "<pre>";
    //         // print_r($user->farmer_code_id); die;
            
    //         if (!$user) {
    //             return response()->json([
    //                 'status' => false,
    //                 'message' => 'User not found',
    //             ], 404);
    //         }
    //         if (!Auth::attempt(['farmer_code_id' => $user->farmer_code_id, 'password' => $credentials['password']])) {
    //             return response()->json([
    //                 'status' => false,
    //                 'message' => 'Email, Farmer Code, or Password is incorrect.',
    //             ], 401); 
    //         }
            
    //         $permissions = DB::table('tbl_role_permissions')
    //         ->leftJoin('tbl_menu', 'tbl_role_permissions.menu_id', '=', 'tbl_menu.menu_id')
    //         ->where('tbl_role_permissions.role_id', $user->role_id)
    //         ->select('tbl_role_permissions.*', 'tbl_menu.label')
    //         ->get();
            
    //         $user = Auth::user(); 
    
    //         return response()->json([
    //             'status' => true,
    //             'message' => 'Login successful',
    //             'data' => [
    //                 'user' => $user,
    //                 'token' => $user->createToken("API TOKEN")->plainTextToken
    //             ],
    //             'permissions' => $permissions,
    //         ], 200);
    
    //     } catch (\Throwable $th) {
    //         return response()->json([
    //             'status' => false,
    //             'message' => 'An error occurred during login',
    //             'error' => $th->getMessage()
    //         ], 500); 
    //     }
    // }
    
   // 11/11/24
    public function loginUser(Request $request)
    {
    try {
        // Validate email or farmer_code_id and password
        $validator = Validator::make(
            $request->all(),
            [
                'email' => 'required|string',
                'password' => 'required|string'
            ]
        );

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 422); 
        }

        
        $input = $request->input('email');
        $password = $request->input('password');

        if (filter_var($input, FILTER_VALIDATE_EMAIL)) {
            $user = User::where('email', $input)->first();
            $credentials = ['email' => $input, 'password' => $password];
        } else {
            $user = User::where('farmer_code_id', $input)->first();
            $credentials = ['farmer_code_id' => $input, 'password' => $password];
        }

        // Check if the user exists
        if (!$user) {
            return response()->json([
                'status' => false,
                'message' => 'User not found',
            ], 404);
        }

        // Attempt login with the appropriate credentials
        if (!Auth::attempt($credentials)) {
            return response()->json([
                'status' => false,
                'message' => 'Email, Farmer Code, or Password is incorrect.',
            ], 401); 
        }

        // Retrieve user permissions
        $permissions = DB::table('tbl_role_permissions')
            ->leftJoin('tbl_menu', 'tbl_role_permissions.menu_id', '=', 'tbl_menu.menu_id')
            ->where('tbl_role_permissions.role_id', $user->role_id)
            ->select('tbl_role_permissions.*', 'tbl_menu.label')
            ->get();

        $user = Auth::user(); 

        return response()->json([
            'status' => true,
            'message' => 'Login successful',
            'data' => [
                'user' => $user,
                'token' => $user->createToken("API TOKEN")->plainTextToken
            ],
            'permissions' => $permissions,
        ], 200);

    } catch (\Throwable $th) {
        return response()->json([
            'status' => false,
            'message' => 'An error occurred during login',
            'error' => $th->getMessage()
        ], 500); 
    }
}

    
    public function farmerDataUpdate(Request $request)
    {
        try {
            $user = Auth::user();
            
            if (!$user) {
                return response()->json([
                    'error' => 'User not found'
                ], 404);
            }
            $farmerData = $request->only([
                'kcc_limit',
                'land_type',
                'soil_health_card',
                'land_holding_size_unit',
                'land_holding_size',
                'land_holding_taken_lease_unit',
                'land_holding_taken_lease',
                'total_cultivable_unit',
                'total_cultivable',
                'soil_health_card_remark',
                'land_given_lease_unit',
                'land_given_lease',
            ]);
            
            DB::table('users')->where('id', $user->id)->update($farmerData);
            
            return response()->json([
                'status' => 'success',
                'data' => $farmerData,
            ], 200);
            
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'error' => 'An error occurred while retrieving the profile',
                'message' => $e->getMessage()
            ], 500);
        }
    }
    
    public function farmerProfile()
    {
        try {
            $user = Auth::user();
            
            if (!$user) {
                return response()->json([
                    'error' => 'User not found'
                ], 404);
            }
            
            $profileData = [
                'id' => $user->id,
                'role_id' => $user->role_id,
                'fpo_id' => $user->team_leader_id,
                'farmer_code_id' => $user->farmer_code_id,
                'first_name' => $user->first_name,
                'last_name' => $user->last_name,
                'email' => $user->email,
                'mobile_number' => $user->mobile_number,
                'husband_father_name' => $user->husband_father_name,
                'aadhaar_number' => $user->aadhaar_number,
                'pan_number' => $user->pan_number,
                'smart_phone' => $user->smart_phone,
                'education' => $user->education,
                'state_id' => $user->state_id,
                'district_id' => $user->district_id,
                'block' => $user->block,
                'address' => $user->address,
                'education_certificate' => $user->education_certificate,
                'bank_account_number' => $user->bank_account_number,
                'ifsc_code' => $user->ifsc_code,
                'num_of_shares' => $user->num_of_shares,
                'single_share_values' => $user->single_share_values,
                'total_share_values' => $user->total_share_values,
                'created_at' => $user->created_at->toDateTimeString(),
                'updated_at' => $user->updated_at->toDateTimeString()
            ];
            
            $states = DB::table('states')->get();
            $districts = DB::table('districts')->get();
            
            return response()->json([
                'status' => 'success',
                'user' => $profileData,
                'states' => $states,
                'districts' => $districts
            ], 200);
            
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'error' => 'An error occurred while retrieving the profile',
                'message' => $e->getMessage()
            ], 500);
        }
    }
    
   public function updateFarmerProfile(Request $request) 
   {
        try {
            $user = Auth::user();
            if (!$user) {
                return response()->json([
                    'error' => 'User not found'
                ], 404);
            }
    
            $data = $request->only([
                'first_name',
                'last_name',
                'email',
                'mobile_number',
                'husband_father_name',
                'aadhaar_number',
                'pan_number',
                'smart_phone',
                'education',
                'state_id',
                'district_id',
                'block',
                'address',
                'bank_account_number',
                'ifsc_code',
                'num_of_shares',
                'single_share_values',
                'total_share_values'
            ]);
    
            if (isset($data['email']) && $data['email'] !== $user->email) {
                $existingUser = User::where('email', $data['email'])->first();
                if ($existingUser) {
                    return response()->json([
                        'error' => 'The email address is already taken'
                    ], 400);
                }
            }
            $user->fill($data);
            $user->save();
            
            $profileData = [
                'id' => $user->id,
                'role_id' => $user->role_id,
                'fpo_id' => $user->team_leader_id,
                'farmer_code_id' => $user->farmer_code_id,
                'first_name' => $user->first_name,
                'last_name' => $user->last_name,
                'email' => $user->email,
                'mobile_number' => $user->mobile_number,
                'husband_father_name' => $user->husband_father_name,
                'aadhaar_number' => $user->aadhaar_number,
                'pan_number' => $user->pan_number,
                'smart_phone' => $user->smart_phone,
                'education' => $user->education,
                'state_id' => $user->state_id,
                'district_id' => $user->district_id,
                'block' => $user->block,
                'address' => $user->address,
                // 'education_certificate' => $user->education_certificate,
                'bank_account_number' => $user->bank_account_number,
                'ifsc_code' => $user->ifsc_code,
                'num_of_shares' => $user->num_of_shares,
                'single_share_values' => $user->single_share_values,
                'total_share_values' => $user->total_share_values,
                'created_at' => $user->created_at->toDateTimeString(),
                'updated_at' => $user->updated_at->toDateTimeString()
            ];
    
            return response()->json([
                'status' => 'success',
                'message' => 'Profile updated successfully',
                'user' => $profileData
            ], 200);
    
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'error' => 'An error occurred while updating the profile',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function createCrop(Request $request)
    {
        try {

            $validateUser = Validator::make(
                $request->all(),
                [
                    'crop_name' => 'required|string',
                    'crop_area' => 'required|numeric',
                    'crop_area_unit' => 'required|string',
                    'season' => 'required|string',
                    'farmer_id' => 'required'
                ]
            );

            if ($validateUser->fails()) {
                return response()->json([
                    'status' => false,
                    'message' => 'validation error',
                    'errors' => $validateUser->errors()
                ], 401);
            }

            $getUser = Auth::user(); 
            $fpoId = $getUser->team_leader_id;
            
            $add_crop = new Crop();
            $add_crop->crop_name = $request->crop_name;
            $add_crop->crop_area_unit = $request->crop_area_unit;
            $add_crop->irrigated_area = $request->irrigated_area;
            // $add_crop->un_irrigated_area = $request->un_irrigated_area;
            $add_crop->crop_area = $request->crop_area;
            $add_crop->farmer_id = $request->farmer_id;
            $add_crop->season = $request->season;
            $add_crop->user_id = Auth::user()->id;
            // $add_crop->user_id = $fpoId;
            $add_crop->save();



            return response()->json([
                'status' => true,
                'message' => 'Crop Created Successfully',
                'crop_id' => $add_crop->id
            ], 200);


        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    

    public function cropCultivation(Request $request)
    {
        try {
            // dd($request->all());
            if ($request->step == 1) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'family_labour_hrs' => 'numeric',
                        // 'family_labour_rs' => 'numeric',
                        // 'attached_labour_hrs' => 'numeric',
                        // 'attached_labour_rs' => 'numeric',
                        // 'casual_labour_rs' => 'numeric',
                        // 'casual_labour_hrs' => 'numeric',
                        // 'hired_animal_labour_rs' => 'numeric',
                        // 'hired_animal_labour_hrs' => 'numeric',
                        
                        // "family_labour_unit_price"=> 'numeric',                  
                        // "attached_labour_unit_price"=> 'numeric',                   
                        // "casual_labour_unit_price"=> 'numeric',                   
                        // "hired_animal_hrs"=>'numeric',
                        // "hired_animal_unit_price"=> 'numeric',
                        // "hired_animal_rs"=>'numeric'
                       
                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $crop_cultivation = new CropCultivation();
                $crop_cultivation->family_labour_hrs = $request->family_labour_hrs;
                $crop_cultivation->family_labour_rs = $request->family_labour_rs;
                $crop_cultivation->attached_labour_hrs = $request->attached_labour_hrs;
                $crop_cultivation->attached_labour_rs = $request->attached_labour_rs;
                $crop_cultivation->casual_labour_rs = $request->casual_labour_rs;
                $crop_cultivation->casual_labour_hrs = $request->casual_labour_hrs;
                $crop_cultivation->hired_animal_labour_rs = $request->hired_animal_labour_rs;
                $crop_cultivation->hired_animal_labour_hrs = $request->hired_animal_labour_hrs;
                
                $crop_cultivation->family_labour_unit_price = $request->family_labour_unit_price;
                $crop_cultivation->attached_labour_unit_price = $request->attached_labour_unit_price;
                $crop_cultivation->casual_labour_unit_price = $request->casual_labour_unit_price;
                $crop_cultivation->hired_animal_hrs = $request->hired_animal_hrs;
                $crop_cultivation->hired_animal_unit_price = $request->hired_animal_unit_price;
                $crop_cultivation->hired_animal_rs = $request->hired_animal_rs;
                $crop_cultivation->family_labour_remarks = $request->family_labour_remarks;
                $crop_cultivation->family_labour_unit = $request->family_labour_unit;
                $crop_cultivation->attached_labour_remarks = $request->attached_labour_remarks;
                $crop_cultivation->attached_labour_unit = $request->attached_labour_unit;
                
                $crop_cultivation->attached_labour_duration = $request->attached_labour_duration;
                
                $crop_cultivation->casual_labour_remarks = $request->casual_labour_remarks;
                $crop_cultivation->casual_labour_unit = $request->casual_labour_unit;
                $crop_cultivation->hired_animal_remarks = $request->hired_animal_remarks;
                $crop_cultivation->hired_animal_unit = $request->hired_animal_unit;
                
                $crop_cultivation->crop_id = $request->crop_id;
                $crop_cultivation->save();



                return response()->json([
                    'status' => true,
                    'message' => 'Crop Cultivation First step created Successfully',

                ], 200);
            }

            if ($request->step == 2) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                    //     'owned_animal_hrs' => 'integer',
                    //     'owned_animal_rs' => 'integer',
                    //     'hired_machhine_hrs' => 'integer',
                    //     'hired_machhine_rs' => 'integer',
                    //     'own_machine_rs' => 'integer',
                    //     'own_machine_hrs' => 'integer',
                    //     'hired_irrigation_machine_hrs' => 'integer',
                    //     'hired_irrigation_machine_rs' => 'integer',
                        
                    //       "owned_animal_unit_price": "3",                  
                    // "owned_animal_remarks": "",                 
                    // "hired_machhine_unit_price": "500",                  
                    // "hired_machhine_remarks": "",                  
                    // "own_machine_unit_price": "1000",                   
                    // "own_machine_remarks": "",                   
                    // "hired_irrigation_machine_unit_price": "1200",                   
                    // "hired_irrigation_machine_remarks": "",
                    // "owned_irrigation_machine_hrs": "4",
                    // "owned_irrigation_machine_unit_price": "300",
                    // "owned_irrigation_machine_rs": "1200",
                    // "owned_irrigation_machine_remarks":""
                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }

                $id = CropCultivation::where('crop_id', $request->crop_id)->first();
              
                
                CropCultivation::whereId($id->id)->update([
                    'owned_animal_hrs' => $request->owned_animal_hrs,
                    'owned_animal_rs' => $request->owned_animal_rs,
                    'hired_machhine_hrs' => $request->hired_machhine_hrs,
                    'hired_machhine_rs' => $request->hired_machhine_rs,
                    'own_machine_rs' => $request->own_machine_rs,
                    'own_machine_hrs' => $request->own_machine_hrs,
                    'hired_irrigation_machine_hrs' => $request->hired_irrigation_machine_hrs,
                    'hired_irrigation_machine_rs' => $request->hired_irrigation_machine_rs,
                    
                    'owned_animal_unit_price' => $request->owned_animal_unit_price,
                    'owned_animal_remarks' => $request->owned_animal_remarks,
                    'owned_animal_unit' => $request->owned_animal_unit,
                    'hired_machhine_unit_price' => $request->hired_machhine_unit_price,
                    'hired_machhine_remarks' => $request->hired_machhine_remarks,
                    'hired_machhine_unit' => $request->hired_machhine_unit,
                    'own_machine_unit_price' => $request->own_machine_unit_price,
                    'own_machine_remarks' => $request->own_machine_remarks,
                    'own_machine_unit' => $request->own_machine_unit,
                    'hired_irrigation_machine_unit_price' => $request->hired_irrigation_machine_unit_price,
                    'hired_irrigation_machine_remarks' => $request->hired_irrigation_machine_remarks,
                    'hired_irrigation_machine_unit' => $request->hired_irrigation_machine_unit,
                    'owned_irrigation_machine_hrs' => $request->owned_irrigation_machine_hrs,
                    'owned_irrigation_machine_unit_price' => $request->owned_irrigation_machine_unit_price,
                    'owned_irrigation_machine_rs' => $request->owned_irrigation_machine_rs,
                    'owned_irrigation_machine_remarks' => $request->owned_irrigation_machine_remarks,
                    'owned_irrigation_machine_unit' => $request->owned_irrigation_machine_unit
                                    
                    
                ]);

                return response()->json([
                    'status' => true,
                    'message' => 'Crop Cultivation Second step created Successfully',

                ], 200);
            }

            if ($request->step == 3) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        'owned_irrigation_machine_hrs' => 'required|numeric',
                        'owned_irrigation_machine_rs' => 'required|numeric',
                        'other_irrigation_charges_hrs' => 'required|numeric',
                        'variety' => 'required|string',

                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }

                $id = CropCultivation::where('crop_id', $request->crop_id)->first();


                CropCultivation::whereId($id->id)->update([
                    'owned_irrigation_machine_hrs' => $request->owned_irrigation_machine_hrs,
                    'owned_irrigation_machine_rs' => $request->owned_irrigation_machine_rs,
                    'other_irrigation_charges_hrs' => $request->other_irrigation_charges_hrs,
                    'variety' => $request->variety,
                ]);

                return response()->json([
                    'status' => true,
                    'message' => 'Crop Cultivation Third step created Successfully',

                ], 200);
            }

            if ($request->step == 4) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        'seed_type' => 'required|string',
                        'seed_qty_unit' => 'required|string',
                        'seed_variety' => 'required|string',
                        'seed_qty' => 'required|numeric',
                        'seed_unit_price' => 'required|numeric',
                        'seed_value_rs' => 'required|numeric',
                        'crop_id' => 'required|numeric'
                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
                $id = CropCultivation::where('crop_id', $request->crop_id)->first();
                CropCultivation::whereId($id->id)->update([
                    'seed_type' => $request->seed_type,
                    'seed_qty_unit' => $request->seed_qty_unit,
                    'seed_qty' => $request->seed_qty,
                    'seed_unit_price' => $request->seed_unit_price,
                    'seed_value_rs' => $request->seed_value_rs,
                    'seed_remarks' => $request->seed_remarks,
                    'seed_variety' => $request->seed_variety,
                    
                    'seed_standard' => $request->seed_standard,
                    'seed_standard_remark' => $request->seed_standard_remark,
                    
                    'fertiliser_n_qty_unit' => $request->fertiliser_n_qty_unit,
                    'fertiliser_n_rs' => $request->fertiliser_n_rs,
                    'fertiliser_n_qty' => $request->fertiliser_n_qty,
                    'fertiliser_n_unit_price' => $request->fertiliser_n_unit_price,
                    'fertiliser_n_remarks' => $request->fertiliser_n_remarks,
                    'fertiliser_p_qty_unit' => $request->fertiliser_p_qty_unit,
                    'fertiliser_p_rs' => $request->fertiliser_p_rs,
                    'fertiliser_p_qty' => $request->fertiliser_p_qty,
                    'fertiliser_p_unit_price' => $request->fertiliser_p_unit_price,
                    'fertiliser_p_remarks' => $request->fertiliser_p_remarks,
                    'fertiliser_k_qty_unit' => $request->fertiliser_k_qty_unit,
                    'fertiliser_k_rs' => $request->fertiliser_k_rs,
                    'fertiliser_k_qty' => $request->fertiliser_k_qty,
                    'fertiliser_k_unit_price' => $request->fertiliser_k_unit_price,
                    'fertiliser_k_remarks' => $request->fertiliser_k_remarks,
                   
                 
                ]);

                return response()->json([
                    'status' => true,
                    'message' => 'Crop Cultivation Fourth step created Successfully',

                ], 200);
            }

            if ($request->step == 5) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'other_fertiliser_kg' => 'required|integer',
                        // 'other_fertiliser_rs' => 'required|integer',
                        // 'Dap_kg' => 'required|integer',
                        // 'Dap_rs' => 'required|integer',
                        // 'npk_kg' => 'required|integer',
                        // 'npk_rs' => 'required|integer',
                        // 'manure_qtl' => 'required|integer',
                        // 'manure_rs' => 'required|integer',

                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }

                $id = CropCultivation::where('crop_id', $request->crop_id)->first();


                CropCultivation::whereId($id->id)->update([
                    'other_fertiliser_kg' => $request->other_fertiliser_kg,
                    'other_fertiliser_rs' => json_encode($request->other_fertiliser_rs),
                    'Dap_kg' => $request->Dap_kg,
                    'Dap_rs' => $request->Dap_rs,
                    'npk_kg' => $request->npk_kg,
                    'npk_rs' => $request->npk_rs,
                    'manure_qtl' => $request->manure_qtl,
                    'manure_rs' => $request->manure_rs,
                    
                    'other_fertiliser_qty_unit' => json_encode($request->other_fertiliser_qty_unit),
                    'other_fertiliser_qty_unit_remarks' => json_encode($request->other_fertiliser_qty_unit_remarks),
                    'other_fertiliser_qty' => json_encode($request->other_fertiliser_qty),
                    'other_fertiliser_unit_price' => json_encode($request->other_fertiliser_unit_price),
                    'other_fertiliser_remarks' => json_encode($request->other_fertiliser_remarks),
                    'other_fertiliser_name' => json_encode($request->other_fertiliser_name),
                    
                    'dap_qty_unit' => $request->dap_qty_unit,
                    'dap_unit_remarks' => $request->dap_unit_remarks,
                    'dap_qty' => $request->dap_qty,
                     'dap_unit_price' => $request->dap_unit_price,
                    'dap_rs' => $request->dap_rs,
                    'dap_remarks' => $request->dap_remarks,
                    'npk_qty_unit' => $request->npk_qty_unit,
                    'npk_qty_unit_remarks' => $request->npk_qty_unit_remarks,
                    'npk_qty' => $request->npk_qty,
                    'npk_unit_price' => $request->npk_unit_price,
                    'npk_remarks' => $request->npk_remarks,
                    'manure_qty_unit' => $request->manure_qty_unit,
                    'manure_qty_unit_remarks' => $request->manure_qty_unit_remarks,
                    'manure_qty' => $request->manure_qty,
                    'manure_unit_price' => $request->manure_unit_price,
                    'manure_remarks' => $request->manure_remarks,
                    'manure_rs_fym' => $request->manure_qty * $request->manure_unit_price,
                  
                ]);

                return response()->json([
                    'status' => true,
                    'message' => 'Crop Cultivation Fifth step created Successfully',

                ], 200);
            }


            if ($request->step == 6) {
                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'variety' => 'required|string',
                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
                $id = CropCultivation::where('crop_id', $request->crop_id)->first();

                CropCultivation::whereId($id->id)->update([
                    'crop_insurance_rs' => $request->crop_insurance_rs,
                    'miscelaneous_cost_rs' => $request->miscelaneous_cost_rs,
                    'land_revenue_rs' => $request->land_revenue_rs,
                    'rent_paid_leased_land' => $request->rent_paid_leased_land,
                    'interest_kcc' => $request->interest_kcc,
                    'canal_other_charges' => $request->canal_other_charges,
                    'interest_capital_assets' => $request->interest_capital_assets,
                    'insecticide_unit' => json_encode($request->insecticide_unit),
                    'insticide_name' => json_encode($request->insticide_name),
                    'insecticide_qty' => json_encode($request->insecticide_qty),
                    'insecticide_unit_price' => json_encode($request->insecticide_unit_price),
                    'insecticide_rs' => json_encode($request->insecticide_rs),
                    'insecticide_remarks' => json_encode($request->insecticide_remarks),
                    'depericiation_farm_assets' => $request->depericiation_farm_assets,
                    'other_fix_cost' => $request->other_fix_cost,
                ]);

                return response()->json([
                    'status' => true,
                    'message' => 'Crop Cultivation Sixth step created Successfully',

                ], 200);
            }


        } catch (\Throwable $th) {
           

            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }

    public function productionOutput(Request $request)
    {
        try {

            $validateUser = Validator::make(
                $request->all(),
                [
                    'sold_main_product' => 'required|string',
                    'total_production' => 'required',
                    'total_production_unit' => 'required|string',
                   
                   
                ]
            );

            if ($validateUser->fails()) {
                return response()->json([
                    'status' => false,
                    'message' => 'validation error',
                    'errors' => $validateUser->errors()
                ], 401);
            }


            $production_output = new ProductionOutput();
            $production_output->total_production = $request->total_production;
            $production_output->sold_main_product = $request->sold_main_product;
            $production_output->selling_price_main_product = $request->selling_price_main_product;
            $production_output->by_product = $request->by_product;
            $production_output->minimum_price = $request->minimum_price;
            $production_output->maximum_price = $request->maximum_price;
            $production_output->main_min_sell_price = $request->main_min_sell_price;
            $production_output->main_max_sell_price = $request->main_max_sell_price;
            $production_output->by_product_unit = $request->by_product_unit;
            $production_output->by_product_name = $request->by_product_name;
            $production_output->by_min_sell_price = $request->by_min_sell_price;
            $production_output->by_max_sell_price = $request->by_max_sell_price;
            $production_output->minimum_price_unit = $request->minimum_price_unit;
            $production_output->maximum_price_unit = $request->maximum_price_unit;
            
            $production_output->selling_price_by_product = $request->selling_price_by_product;
            
            $production_output->total_value_main_product_sold = $request->total_value_main_product_sold;
            
            $production_output->village_trader = $request->village_trader;
            $production_output->wholesaler = $request->wholesaler;
            $production_output->mandi = $request->mandi;
            $production_output->processor = $request->processor;
            $production_output->retailer = $request->retailer;
            $production_output->consumer = $request->consumer;
            $production_output->total_production_unit = $request->total_production_unit;
            $production_output->sold_main_product_unit = $request->sold_main_product_unit;
            $production_output->total_main_product_sold = $request->total_main_product_sold;
            
            $production_output->company = $request->company;
            $production_output->commission_agent = $request->commission_agent;
            $production_output->other = json_encode($request->other);
               
            $production_output->crop_id = $request->crop_id;
            $production_output->save();
            
           



            return response()->json([
                'status' => true,
                'message' => 'Production Output Created Successfully',

            ], 200);


        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    public function infrastructure2(Request $request)
    {
        try {

            /////irrigation  infrastructure
            if ($request->step == 1) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'canal' => 'required|integer',
                        // 'tubewell' => 'required|integer',
                        // 'enginer_motor_solar' => 'required|integer',
                        // 'pump_sets' => 'required|integer',
                        // 'pond' => 'required|integer',
                        // 'irrigation_system' => 'required|integer',
                        // 'pump_house' => 'required|integer',
                        // 'other' => 'required|integer',

                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $irrigation_infrastructure = new IrrigationInfrastructure();
                $irrigation_infrastructure->farmer_id = $request->farmer_id;
                $irrigation_infrastructure->canal = $request->canal;
                $irrigation_infrastructure->tubewell = $request->tubewell;
                $irrigation_infrastructure->enginer_motor_solar = $request->enginer_motor_solar;
                $irrigation_infrastructure->pump_sets = $request->pump_sets;
                $irrigation_infrastructure->pond = $request->pond;
                $irrigation_infrastructure->irrigation_system = $request->irrigation_system;
                $irrigation_infrastructure->pump_house = $request->pump_house;
                $irrigation_infrastructure->other = $request->other;
                $irrigation_infrastructure->crop_id = $request->crop_id;
                
                $irrigation_infrastructure->created_at = $request->created_at;
                
                $irrigation_infrastructure->save();
               
                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure First Step Created Successfully',

                ], 200);
            }


            ///// farm mechanization
            if ($request->step == 2) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'tractor' => 'required|integer',
                        // 'power_tiller' => 'required|integer',
                        // 'cultivator' => 'required|integer',
                        // 'rotator' => 'required|integer',
                        // 'harrow' => 'required|integer',
                        // 'leveller' => 'required|integer',
                        // 'plough' => 'required|integer',
                        // 'speed_drill' => 'required|integer',
                        // 'speed_planter' => 'required|integer',
                        // 'speed_cum_fertilizer_drill' => 'required|integer',
                        // 'trolley' => 'required|integer',
                        // 'reaper_cum_binder' => 'required|integer',
                        // 'bhusa_machine' => 'required|integer',
                        // 'thresher' => 'required|integer',
                        // 'combine_harvester' => 'required|integer',
                        // 'other' => 'required|integer',

                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $farm_mechanism = new FarmMechanism();
                $farm_mechanism->farmer_id = $request->farmer_id;
                $farm_mechanism->tractor = $request->tractor;
                $farm_mechanism->power_tiller = $request->power_tiller;
                $farm_mechanism->cultivator = $request->cultivator;
                $farm_mechanism->rotator = $request->rotator;
                $farm_mechanism->harrow = $request->harrow;
                $farm_mechanism->leveller = $request->leveller;
                $farm_mechanism->plough = $request->plough;
                $farm_mechanism->speed_drill = $request->speed_drill;
                $farm_mechanism->speed_planter = $request->speed_planter;
                $farm_mechanism->speed_cum_fertilizer_drill = $request->speed_cum_fertilizer_drill;
                $farm_mechanism->trolley = $request->trolley;
                $farm_mechanism->reaper_cum_binder = $request->reaper_cum_binder;
                $farm_mechanism->bhusa_machine = $request->bhusa_machine;
                $farm_mechanism->thresher = $request->thresher;
                $farm_mechanism->combine_harvester = $request->combine_harvester;
                $farm_mechanism->other = $request->other;
                $farm_mechanism->crop_id = $request->crop_id;
                $farm_mechanism->save();
                
                
                



                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Second Step Created Successfully',

                ], 200);
            }


             ///// Storage Structure
             if ($request->step == 3) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'deshi' => 'required|integer',
                        // 'godown' => 'required|integer',
                        // 'clod' => 'required|integer',
                        // 'bulk_cooling' => 'required|integer',
                        // 'fodder' => 'required|integer',

                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $storage_structure = new StorageStructure();
                 $storage_structure->farmer_id = $request->farmer_id;
                $storage_structure->deshi = $request->deshi;
                $storage_structure->godown = $request->godown;
                $storage_structure->clod = $request->clod;
                $storage_structure->bulk_cooling = $request->bulk_cooling;
                $storage_structure->fodder = $request->fodder;
                $storage_structure->other = $request->other;
                $storage_structure->crop_id = $request->crop_id;
                $storage_structure->save();
                
                
               



                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Third Step Created Successfully',

                ], 200);
            }

             ///// Processing Infrastructure
             if ($request->step == 4) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'wheat_processing' => 'required|integer',
                        // 'oil_processing' => 'required|integer',
                        // 'sugarcane_processing' => 'required|integer',
                        // 'dal_processing' => 'required|integer',
                        // 'other_processing' => 'required|integer',

                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $processing_infrastructure = new ProcessingInfrastructure();
                
                $processing_infrastructure->farmer_id = $request->farmer_id;
                
                $processing_infrastructure->wheat_processing = $request->wheat_processing;
                $processing_infrastructure->oil_processing = $request->oil_processing;
                $processing_infrastructure->sugarcane_processing = $request->sugarcane_processing;
                $processing_infrastructure->dal_processing = $request->dal_processing;
                $processing_infrastructure->other_processing = $request->other_processing;
                $processing_infrastructure->crop_id = $request->crop_id;
                $processing_infrastructure->save();
                
                



                

                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Fourth Step Created Successfully',

                ], 200);
            }

               /////Retails Outlets
               if ($request->step == 5) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'kiran_outlets' => 'required|integer',
                        // 'grossary_outlets' => 'required|integer',
                        // 'other_outlets' => 'required|integer',


                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $retail_outlet = new RetailOutlet();
                 $retail_outlet->farmer_id = $request->farmer_id;
                $retail_outlet->kiran_outlets = $request->kiran_outlets;
                $retail_outlet->grossary_outlets = $request->grossary_outlets;
                $retail_outlet->other_outlets = $request->other_outlets;
                $retail_outlet->crop_id = $request->crop_id;
                $retail_outlet->save();
                

                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Fifth Step Created Successfully',

                ], 200);
            }

            /////Other Infrastructure
            if ($request->step == 6) {
                
                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'shed_kuchha' => 'required|integer',
                        // 'shed_pucca' => 'required|integer',
                        // 'other_infrastructure' => 'required|integer',
                    ]
                );
                 
                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
                $retail_outlet = new OtherInfrastructure();
                $retail_outlet->farmer_id = $request->farmer_id;
                $retail_outlet->shed_kuchha = $request->shed_kuchha;
                $retail_outlet->shed_pucca = $request->shed_pucca;
                $retail_outlet->other_infrastructure = $request->other_infrastructure;
                $retail_outlet->crop_id = $request->crop_id;
                $retail_outlet->save();
            
                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Sixth Step Created Successfully',

                ], 200);
            }
            
             /////investment plantetion
            if ($request->step == 7) {
                
                  $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'name_plantation' => 'required',
                        // 'cost_pantation' => 'required',
                        // 'Infrastructure' => 'required',
                        // 'material' => 'required',
                        // 'labour_mechanization' => 'required',
                        // 'fixed_cost' => 'required',
                    ]
                  );
                 
                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
          
                $investment_plantation = new investment_plantation();
                
                $investment_plantation->farmer_id = $request->farmer_id;
                
                $investment_plantation->name_plantation = $request->name_plantation;
                $investment_plantation->cost_pantation = $request->cost_pantation;
                $investment_plantation->Infrastructure = $request->Infrastructure;
                $investment_plantation->material = $request->material;
                $investment_plantation->labour_mechanization = $request->labour_mechanization;
                $investment_plantation->fixed_cost = $request->fixed_cost;
                $investment_plantation->crop_id = $request->crop_id;
                $investment_plantation->save();
            
                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Seven Step Created Successfully',

                ], 200);
                
            }
            

        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    public function infrastructure3(Request $request)
    {
        try {

            /////irrigation  infrastructure
            if ($request->step == 1) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'canal' => 'required|integer',
                        // 'tubewell' => 'required|integer',
                        // 'enginer_motor_solar' => 'required|integer',
                        // 'pump_sets' => 'required|integer',
                        // 'pond' => 'required|integer',
                        // 'irrigation_system' => 'required|integer',
                        // 'pump_house' => 'required|integer',
                        // 'other' => 'required|integer',

                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $irrigation_infrastructure = new IrrigationInfrastructure();
                $irrigation_infrastructure->canal = $request->canal;
                $irrigation_infrastructure->tubewell = $request->tubewell;
                $irrigation_infrastructure->enginer_motor_solar = $request->enginer_motor_solar;
                $irrigation_infrastructure->pump_sets = $request->pump_sets;
                $irrigation_infrastructure->pond = $request->pond;
                $irrigation_infrastructure->irrigation_system = $request->irrigation_system;
                $irrigation_infrastructure->pump_house = $request->pump_house;
                $irrigation_infrastructure->other = $request->other;
                $irrigation_infrastructure->crop_id = $request->crop_id;
                $irrigation_infrastructure->save();
                
                
                $infrastructure = ['canal','tubewell','enginer_motor_solar',
                'pump_sets','pond','irrigation_system','pump_house','other'];
                foreach($infrastructure as $key){
                    $infrastructure_key = new InfrastructureKey();
                    $data['number']=$request->input("number_".$key);
                    $data['specification']=$request->input("specification_".$key);
                    $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
                    $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
                    $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
                    $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
                    $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
                    $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
                    $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
                    $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
                    $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
                    $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
                    $data['annual_tax'] = $request->input("annual_tax_" . $key);
                    $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
                    $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
                    $data['any_other'] = $request->input("any_other_" . $key);
                    
                    $data['specification_unit']=$request->input("specification_unit_".$key);
                    $data['rental_unit']=$request->input("rental_unit_".$key);
                    $data['rental_rate']=$request->input("rental_rate_".$key);
                  
                    
                    $infrastructure_key->type = $key;
                    $infrastructure_key->crop_id = $request->crop_id;
                    $infrastructure_key->fields = json_encode($data);
                    $infrastructure_key->save();
                    
                    
                }
                
                


                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure First Step Created Successfully',

                ], 200);
            }


            ///// farm mechanization
            if ($request->step == 2) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'tractor' => 'required|integer',
                        // 'power_tiller' => 'required|integer',
                        // 'cultivator' => 'required|integer',
                        // 'rotator' => 'required|integer',
                        // 'harrow' => 'required|integer',
                        // 'leveller' => 'required|integer',
                        // 'plough' => 'required|integer',
                        // 'speed_drill' => 'required|integer',
                        // 'speed_planter' => 'required|integer',
                        // 'speed_cum_fertilizer_drill' => 'required|integer',
                        // 'trolley' => 'required|integer',
                        // 'reaper_cum_binder' => 'required|integer',
                        // 'bhusa_machine' => 'required|integer',
                        // 'thresher' => 'required|integer',
                        // 'combine_harvester' => 'required|integer',
                        // 'other' => 'required|integer',

                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $farm_mechanism = new FarmMechanism();
                $farm_mechanism->tractor = $request->tractor;
                $farm_mechanism->power_tiller = $request->power_tiller;
                $farm_mechanism->cultivator = $request->cultivator;
                $farm_mechanism->rotator = $request->rotator;
                $farm_mechanism->harrow = $request->harrow;
                $farm_mechanism->leveller = $request->leveller;
                $farm_mechanism->plough = $request->plough;
                $farm_mechanism->speed_drill = $request->speed_drill;
                $farm_mechanism->speed_planter = $request->speed_planter;
                $farm_mechanism->speed_cum_fertilizer_drill = $request->speed_cum_fertilizer_drill;
                $farm_mechanism->trolley = $request->trolley;
                $farm_mechanism->reaper_cum_binder = $request->reaper_cum_binder;
                $farm_mechanism->bhusa_machine = $request->bhusa_machine;
                $farm_mechanism->thresher = $request->thresher;
                $farm_mechanism->combine_harvester = $request->combine_harvester;
                $farm_mechanism->other = $request->other;
                $farm_mechanism->crop_id = $request->crop_id;
                $farm_mechanism->save();
                
                
                $infrastructure = ['tractor','power_tiller','cultivator',
                'rotator','leveller','plough','speed_drill','speed_planter',
                'speed_cum_fertilizer_drill','trolley','reaper_cum_binder',
                'bhusa_machine','thresher','combine_harvester','other'];
                foreach($infrastructure as $key){
                    $infrastructure_key = new InfrastructureKey();
                    $data['number']=$request->input("number_".$key);
                    $data['specification']=$request->input("specification_".$key);
                    $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
                    $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
                    $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
                    $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
                    $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
                    $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
                    $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
                    $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
                    $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
                    $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
                    $data['annual_tax'] = $request->input("annual_tax_" . $key);
                    $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
                    $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
                    $data['any_other'] = $request->input("any_other_" . $key);
                    
                    $data['specification_unit']=$request->input("specification_unit_".$key);
                    $data['rental_unit']=$request->input("rental_unit_".$key);
                    $data['rental_rate']=$request->input("rental_rate_".$key);
                    
                    $infrastructure_key->type = $key;
                    $infrastructure_key->crop_id = $request->crop_id;
                    $infrastructure_key->fields = json_encode($data);
                    $infrastructure_key->save();
                    
                    
                }



                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Second Step Created Successfully',

                ], 200);
            }


             ///// Storage Structure
             if ($request->step == 3) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'deshi' => 'required|integer',
                        // 'godown' => 'required|integer',
                        // 'clod' => 'required|integer',
                        // 'bulk_cooling' => 'required|integer',
                        // 'fodder' => 'required|integer',

                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $storage_structure = new StorageStructure();
                $storage_structure->deshi = $request->deshi;
                $storage_structure->godown = $request->godown;
                $storage_structure->clod = $request->clod;
                $storage_structure->bulk_cooling = $request->bulk_cooling;
                $storage_structure->fodder = $request->fodder;
                $storage_structure->other = $request->other;
                $storage_structure->crop_id = $request->crop_id;
                $storage_structure->save();
                
                
                $infrastructure = ['deshi','godown','clod',
                'bulk_cooling','fodder','other'];
                foreach($infrastructure as $key){
                    $infrastructure_key = new InfrastructureKey();
                    $data['number']=$request->input("number_".$key);
                    $data['specification']=$request->input("specification_".$key);
                    $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
                    $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
                    $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
                    $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
                    $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
                    $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
                    $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
                    $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
                    $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
                    $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
                    $data['annual_tax'] = $request->input("annual_tax_" . $key);
                    $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
                    $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
                    $data['any_other'] = $request->input("any_other_" . $key);
                    
                    $data['specification_unit']=$request->input("specification_unit_".$key);
                    $data['rental_unit']=$request->input("rental_unit_".$key);
                    $data['rental_rate']=$request->input("rental_rate_".$key);
                    
                    $infrastructure_key->type = $key;
                    $infrastructure_key->crop_id = $request->crop_id;
                    $infrastructure_key->fields = json_encode($data);
                    $infrastructure_key->save();
                    
                    
                }



                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Third Step Created Successfully',

                ], 200);
            }

             ///// Processing Infrastructure
             if ($request->step == 4) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'wheat_processing' => 'required|integer',
                        // 'oil_processing' => 'required|integer',
                        // 'sugarcane_processing' => 'required|integer',
                        // 'dal_processing' => 'required|integer',
                        // 'other_processing' => 'required|integer',

                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $processing_infrastructure = new ProcessingInfrastructure();
                $processing_infrastructure->wheat_processing = $request->wheat_processing;
                $processing_infrastructure->oil_processing = $request->oil_processing;
                $processing_infrastructure->sugarcane_processing = $request->sugarcane_processing;
                $processing_infrastructure->dal_processing = $request->dal_processing;
                $processing_infrastructure->other_processing = $request->other_processing;
                $processing_infrastructure->crop_id = $request->crop_id;
                $processing_infrastructure->save();
                
                



                 $infrastructure = ['wheat_processing','oil_processing','sugarcane_processing',
                'dal_processing','other_processing'];
                foreach($infrastructure as $key){
                    $infrastructure_key = new InfrastructureKey();
                    $data['number']=$request->input("number_".$key);
                    $data['specification']=$request->input("specification_".$key);
                    $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
                    $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
                    $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
                    $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
                    $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
                    $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
                    $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
                    $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
                    $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
                    $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
                    $data['annual_tax'] = $request->input("annual_tax_" . $key);
                    $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
                    $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
                    $data['any_other'] = $request->input("any_other_" . $key);
                    
                     $data['specification_unit']=$request->input("specification_unit_".$key);
                    $data['rental_unit']=$request->input("rental_unit_".$key);
                    $data['rental_rate']=$request->input("rental_rate_".$key);
                    
                    $infrastructure_key->type = $key;
                    $infrastructure_key->crop_id = $request->crop_id;
                    $infrastructure_key->fields = json_encode($data);
                    $infrastructure_key->save();
                    
                    
                }


                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Fourth Step Created Successfully',

                ], 200);
            }

               /////Retails Outlets
               if ($request->step == 5) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'kiran_outlets' => 'required|integer',
                        // 'grossary_outlets' => 'required|integer',
                        // 'other_outlets' => 'required|integer',


                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $retail_outlet = new RetailOutlet();
                $retail_outlet->kiran_outlets = $request->kiran_outlets;
                $retail_outlet->grossary_outlets = $request->grossary_outlets;
                $retail_outlet->other_outlets = $request->other_outlets;
                $retail_outlet->crop_id = $request->crop_id;
                $retail_outlet->save();
                
                
                
                 $infrastructure = ['kiran_outlets','grossary_outlets','other_outlets'];
                foreach($infrastructure as $key){
                    $infrastructure_key = new InfrastructureKey();
                    $data['number']=$request->input("number_".$key);
                    $data['specification']=$request->input("specification_".$key);
                    $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
                    $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
                    $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
                    $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
                    $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
                    $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
                    $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
                    $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
                    $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
                    $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
                    $data['annual_tax'] = $request->input("annual_tax_" . $key);
                    $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
                    $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
                    $data['any_other'] = $request->input("any_other_" . $key);
                    
                     $data['specification_unit']=$request->input("specification_unit_".$key);
                    $data['rental_unit']=$request->input("rental_unit_".$key);
                    $data['rental_rate']=$request->input("rental_rate_".$key);
                    
                    $infrastructure_key->type = $key;
                    $infrastructure_key->crop_id = $request->crop_id;
                    $infrastructure_key->fields = json_encode($data);
                    $infrastructure_key->save();
                }



                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Fifth Step Created Successfully',

                ], 200);
            }

             /////Other Infrastructure
            if ($request->step == 6) {

                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'shed_kuchha' => 'required|integer',
                        // 'shed_pucca' => 'required|integer',
                        // 'other_infrastructure' => 'required|integer',
                    ]
                );
                   
                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }


                $retail_outlet = new OtherInfrastructure();
                $retail_outlet->shed_kuchha = $request->shed_kuchha;
                $retail_outlet->shed_pucca = $request->shed_pucca;
                $retail_outlet->other_infrastructure = $request->other_infrastructure;
                $retail_outlet->crop_id = $request->crop_id;
                $retail_outlet->save();
                
                
                $infrastructure = ['shed_kuchha','shed_pucca','other_infrastructure'];
                foreach($infrastructure as $key){
                    $infrastructure_key = new InfrastructureKey();
                    $data['number']=$request->input("number_".$key);
                    $data['specification']=$request->input("specification_".$key);
                    $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
                    $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
                    $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
                    $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
                    $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
                    $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
                    $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
                    $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
                    $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
                    $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
                    $data['annual_tax'] = $request->input("annual_tax_" . $key);
                    $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
                    $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
                    $data['any_other'] = $request->input("any_other_" . $key);
                    
                    $data['specification_unit']=$request->input("specification_unit_".$key);
                    $data['rental_unit']=$request->input("rental_unit_".$key);
                    $data['rental_rate']=$request->input("rental_rate_".$key);
                    
                    $infrastructure_key->type = $key;
                    $infrastructure_key->crop_id = $request->crop_id;
                    $infrastructure_key->fields = json_encode($data);
                    $infrastructure_key->save();
                }
                
                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Sixth Step Created Successfully',

                ], 200);
            }
            
            
            /////investment plantetion
            if ($request->step == 7) {
                
                  $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'name_plantation' => 'required',
                        // 'cost_pantation' => 'required',
                        // 'Infrastructure' => 'required',
                        // 'material' => 'required',
                        // 'labour_mechanization' => 'required',
                        // 'fixed_cost' => 'required',
                    ]
                );
                 
                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
                
                $investment_plantation = new investment_plantation();
                $investment_plantation->name_plantation = $request->name_plantation;
                $investment_plantation->cost_pantation = $request->cost_pantation;
                $investment_plantation->Infrastructure = $request->Infrastructure;
                $investment_plantation->material = $request->material;
                $investment_plantation->labour_mechanization = $request->labour_mechanization;
                $investment_plantation->fixed_cost = $request->fixed_cost;
                $investment_plantation->crop_id = $request->crop_id;
                $investment_plantation->save();
                
                $infrastructure = ['name_plantation','cost_pantation','Infrastructure','material','labour_mechanization','fixed_cost'];
                foreach($infrastructure as $key){
                    $infrastructure_key = new InfrastructureKey();
                    $data['number']=$request->input("number_".$key);
                    $data['specification']=$request->input("specification_".$key);
                    $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
                    $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
                    $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
                    $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
                    $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
                    $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
                    $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
                    $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
                    $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
                    $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
                    $data['annual_tax'] = $request->input("annual_tax_" . $key);
                    $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
                    $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
                    $data['any_other'] = $request->input("any_other_" . $key);
                    
                    $data['specification_unit']=$request->input("specification_unit_".$key);
                    $data['rental_unit']=$request->input("rental_unit_".$key);
                    $data['rental_rate']=$request->input("rental_rate_".$key);
                    
                    $infrastructure_key->type = $key;
                    $infrastructure_key->crop_id = $request->crop_id;
                    $infrastructure_key->fields = json_encode($data);
                    $infrastructure_key->save();
                }
            
                return response()->json([
                    'status' => true,
                    'message' => 'Investment Platetion seven Step Created Successfully',

                ], 200);
                
            }
            
            

        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    
    public function infrastructure(Request $request){
        
        try {

            /////irrigation  infrastructure
            
            //old query
            // if ($request->step == 1) {
                
            //         $validateUser = Validator::make(
            //             $request->all(),
            //             [
            //                 // 'canal' => 'required|integer',
            //                 // 'tubewell' => 'required|integer',
            //                 // 'enginer_motor_solar' => 'required|integer',
            //                 // 'pump_sets' => 'required|integer',
            //                 // 'pond' => 'required|integer',
            //                 // 'irrigation_system' => 'required|integer',
            //                 // 'pump_house' => 'required|integer',
            //                 // 'other' => 'required|integer',
    
            //             ]
            //         );
            //         if ($validateUser->fails()) {
            //             return response()->json([
            //                 'status' => false,
            //                 'message' => 'validation error',
            //                 'errors' => $validateUser->errors()
            //             ], 401);
            //         }
    
            //         $irrigation_infrastructure = new IrrigationInfrastructure();
                    
            //         $infrastructure = ['canal','tubewell','enginer_motor_solar',
            //         'pump_sets','pond','irrigation_system','pump_house','other'];
                    
            //         foreach($infrastructure as $key){
                       
            //             $data['number']=$request->input("number_".$key);
            //             $data['specification']=$request->input("specification_".$key);
            //             $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
            //             $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
            //             $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
            //             $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
            //             $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
            //             $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
            //             $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
            //             $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
            //             $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
            //             $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
            //             $data['annual_tax'] = $request->input("annual_tax_" . $key);
            //             $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
            //             $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
            //             $data['any_other'] = $request->input("any_other_" . $key);
                        
            //             $data['specification_unit']=$request->input("specification_unit_".$key);
            //             $data['rental_unit']=$request->input("rental_unit_".$key);
            //             $data['rental_rate']=$request->input("rental_rate_".$key);
                        
            //             $irrigation_infrastructure->$key = ($request->$key=='Yes') ? json_encode($data):null;
                         
            //         }
                    
            //         $irrigation_infrastructure->crop_id = $request->crop_id;
            //         $irrigation_infrastructure->farmer_id = $request->farmer_id;
            //         $irrigation_infrastructure->save();
                
            //         return response()->json([
            //             'status' => true,
            //             'message' => 'Infrastructure First Step Created Successfully',
    
            //         ], 200);
            // }

            if ($request->step == 1) {
                
                if ($request->farmer_id == null) {
                // Validation for missing farmer_id
                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // Add validation rules as needed
                    ]
                );

                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }

                    $irrigation_infrastructure = new IrrigationInfrastructure();
                } else {
                    // Use updateOrCreate to handle existing records based on farmer_id
                    $irrigation_infrastructure = IrrigationInfrastructure::updateOrCreate(
                        ['farmer_id' => $request->farmer_id]
                    );
                }

                // Define infrastructure array and loop through fields
                $infrastructure = ['canal', 'tubewell', 'enginer_motor_solar', 'pump_sets', 'pond', 'irrigation_system', 'pump_house', 'other'];
                
                foreach ($infrastructure as $key) {
                    $data = [
                        'number' => $request->input("number_$key"),
                        'specification' => $request->input("specification_$key"),
                        'year_of_asset_creation' => $request->input("year_of_asset_creation_$key"),
                        'total_investment_cost' => $request->input("total_investment_cost_$key"),
                        'subsidy_grant' => $request->input("subsidy_grant_$key"),
                        'bank_loan_cost' => $request->input("bank_loan_cost_$key"),
                        'balance_source_of_investment' => $request->input("balance_source_of_investment_$key"),
                        'economic_useful_life' => $request->input("economic_useful_life_$key"),
                        'residual_value_of_asset' => $request->input("residual_value_of_asset_$key"),
                        'annual_interest_on_bank_loan' => $request->input("annual_interest_on_bank_loan_$key"),
                        'annual_depreciation' => $request->input("annual_depreciation_$key"),
                        'annual_insurance' => $request->input("annual_insurance_$key"),
                        'annual_tax' => $request->input("annual_tax_$key"),
                        'annual_repair_and_maintenance' => $request->input("annual_repair_and_maintenance_$key"),
                        'annual_fixed_cost_of_asset' => $request->input("annual_fixed_cost_of_asset_$key"),
                        'any_other' => $request->input("any_other_$key"),
                        'specification_unit' => $request->input("specification_unit_$key"),
                        'rental_unit' => $request->input("rental_unit_$key"),
                        'rental_rate' => $request->input("rental_rate_$key")
                    ];
                
                    $irrigation_infrastructure->$key = ($request->$key == 'Yes') ? json_encode($data) : null;
                }
                
                // Set additional properties and save
                $irrigation_infrastructure->farmer_id = $request->farmer_id;
                $irrigation_infrastructure->save();
                
                return response()->json([
                    'status' => true,
                    'message' => ($request->farmer_id == null) ? 'Infrastructure First Step Created Successfully' : 'Infrastructure Step Updated Successfully'
                ], 200);

                
            }



            ///// farm mechanization old query
            // if ($request->step == 2) {

            //     $validateUser = Validator::make(
            //         $request->all(),
            //         [
            //             // 'tractor' => 'required|integer',
            //             // 'power_tiller' => 'required|integer',
            //             // 'cultivator' => 'required|integer',
            //             // 'rotator' => 'required|integer',
            //             // 'harrow' => 'required|integer',
            //             // 'leveller' => 'required|integer',
            //             // 'plough' => 'required|integer',
            //             // 'speed_drill' => 'required|integer',
            //             // 'speed_planter' => 'required|integer',
            //             // 'speed_cum_fertilizer_drill' => 'required|integer',
            //             // 'trolley' => 'required|integer',
            //             // 'reaper_cum_binder' => 'required|integer',
            //             // 'bhusa_machine' => 'required|integer',
            //             // 'thresher' => 'required|integer',
            //             // 'combine_harvester' => 'required|integer',
            //             // 'other' => 'required|integer',

            //         ]
            //     );

            //     if ($validateUser->fails()) {
            //         return response()->json([
            //             'status' => false,
            //             'message' => 'validation error',
            //             'errors' => $validateUser->errors()
            //         ], 401);
            //     }


            //     $farm_mechanism = new FarmMechanism();
                
                
                
                
            //     $infrastructure = ['tractor','power_tiller','cultivator',
            //     'rotator','harrow','leveller','plough','speed_drill','speed_planter',
            //     'speed_cum_fertilizer_drill','trolley','reaper_cum_binder',
            //     'bhusa_machine','thresher','combine_harvester','other'];
            //     foreach($infrastructure as $key){
                   
            //         $data['number']=$request->input("number_".$key);
            //         $data['specification']=$request->input("specification_".$key);
            //         $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
            //         $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
            //         $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
            //         $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
            //         $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
            //         $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
            //         $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
            //         $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
            //         $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
            //         $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
            //         $data['annual_tax'] = $request->input("annual_tax_" . $key);
            //         $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
            //         $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
            //         $data['any_other'] = $request->input("any_other_" . $key);
                    
            //          $data['specification_unit']=$request->input("specification_unit_".$key);
            //         $data['rental_unit']=$request->input("rental_unit_".$key);
            //         $data['rental_rate']=$request->input("rental_rate_".$key);
                    
            //         $farm_mechanism->$key = ($request->$key=='Yes') ? json_encode($data):null;
                    
    
                    
            //     }
            //     $farm_mechanism->crop_id = $request->crop_id;
            //     $farm_mechanism->farmer_id = $request->farmer_id;

            //     $farm_mechanism->save();



            //     return response()->json([
            //         'status' => true,
            //         'message' => 'Infrastructure Second Step Created Successfully',

            //     ], 200);
            // }
            
            
            if ($request->step == 2) {
                // Check if farmer_id is null and validate
                if ($request->farmer_id == null) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Farmer ID is required'
                    ], 400);
                }
            
                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // Add validation rules as necessary
                    ]
                );
            
                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
            
                $farm_mechanism = FarmMechanism::updateOrCreate(
                    ['farmer_id' => $request->farmer_id],
                    ['crop_id' => $request->crop_id]
                );
            
                $infrastructure = [
                    'tractor', 'power_tiller', 'cultivator', 'rotator', 'harrow', 'leveller', 
                    'plough', 'speed_drill', 'speed_planter', 'speed_cum_fertilizer_drill', 
                    'trolley', 'reaper_cum_binder', 'bhusa_machine', 'thresher', 
                    'combine_harvester', 'other'
                ];
            
                foreach ($infrastructure as $key) {
                    $data = [
                        'number' => $request->input("number_$key"),
                        'specification' => $request->input("specification_$key"),
                        'year_of_asset_creation' => $request->input("year_of_asset_creation_$key"),
                        'total_investment_cost' => $request->input("total_investment_cost_$key"),
                        'subsidy_grant' => $request->input("subsidy_grant_$key"),
                        'bank_loan_cost' => $request->input("bank_loan_cost_$key"),
                        'balance_source_of_investment' => $request->input("balance_source_of_investment_$key"),
                        'economic_useful_life' => $request->input("economic_useful_life_$key"),
                        'residual_value_of_asset' => $request->input("residual_value_of_asset_$key"),
                        'annual_interest_on_bank_loan' => $request->input("annual_interest_on_bank_loan_$key"),
                        'annual_depreciation' => $request->input("annual_depreciation_$key"),
                        'annual_insurance' => $request->input("annual_insurance_$key"),
                        'annual_tax' => $request->input("annual_tax_$key"),
                        'annual_repair_and_maintenance' => $request->input("annual_repair_and_maintenance_$key"),
                        'annual_fixed_cost_of_asset' => $request->input("annual_fixed_cost_of_asset_$key"),
                        'any_other' => $request->input("any_other_$key"),
                        'specification_unit' => $request->input("specification_unit_$key"),
                        'rental_unit' => $request->input("rental_unit_$key"),
                        'rental_rate' => $request->input("rental_rate_$key")
                    ];
            
                    $farm_mechanism->$key = ($request->$key == 'Yes') ? json_encode($data) : null;
                }
            
                $farm_mechanism->save();
            
                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Second Step Created Successfully',
                ], 200);
            }


             ///// Storage Structure old query 
            //  if ($request->step == 3) {

            //     $validateUser = Validator::make(
            //         $request->all(),
            //         [
            //             // 'deshi' => 'required|integer',
            //             // 'godown' => 'required|integer',
            //             // 'clod' => 'required|integer',
            //             // 'bulk_cooling' => 'required|integer',
            //             // 'fodder' => 'required|integer',

            //         ]
            //     );

            //     if ($validateUser->fails()) {
            //         return response()->json([
            //             'status' => false,
            //             'message' => 'validation error',
            //             'errors' => $validateUser->errors()
            //         ], 401);
            //     }


            //     $storage_structure = new StorageStructure();
                
                
                
                
            //     $infrastructure = ['deshi','godown','clod',
            //     'bulk_cooling','fodder','other'];
            //     foreach($infrastructure as $key){
                    
            //         $data['number']=$request->input("number_".$key);
            //         $data['specification']=$request->input("specification_".$key);
            //         $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
            //         $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
            //         $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
            //         $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
            //         $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
            //         $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
            //         $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
            //         $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
            //         $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
            //         $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
            //         $data['annual_tax'] = $request->input("annual_tax_" . $key);
            //         $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
            //         $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
            //         $data['any_other'] = $request->input("any_other_" . $key);
                    
            //         $data['specification_unit']=$request->input("specification_unit_".$key);
            //         $data['rental_unit']=$request->input("rental_unit_".$key);
            //         $data['rental_rate']=$request->input("rental_rate_".$key);
                    
            //         $storage_structure->$key = ($request->$key=='Yes') ? json_encode($data):null;
            
                    
                    
            //     }
                
            //     $storage_structure->crop_id = $request->crop_id;
            //     $storage_structure->farmer_id = $request->farmer_id;
            //     $storage_structure->save();



            //     return response()->json([
            //         'status' => true,
            //         'message' => 'Infrastructure Third Step Created Successfully',

            //     ], 200);
            // }
            
            if ($request->step == 3) {
    
                if ($request->farmer_id == null) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Farmer ID is required'
                    ], 400);
                }
            
                // Validate the request (uncomment and adjust rules as needed)
                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // Add validation rules here if required
                    ]
                );
            
                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
            
                // Use updateOrCreate to handle existing records based on farmer_id
                $storage_structure = StorageStructure::updateOrCreate(
                    ['farmer_id' => $request->farmer_id],
                    ['crop_id' => $request->crop_id]
                );
            
                // Define the array of infrastructure keys
                $infrastructure = ['deshi', 'godown', 'clod', 'bulk_cooling', 'fodder', 'other'];
            
                foreach ($infrastructure as $key) {
                    $data = [
                        'number' => $request->input("number_$key"),
                        'specification' => $request->input("specification_$key"),
                        'year_of_asset_creation' => $request->input("year_of_asset_creation_$key"),
                        'total_investment_cost' => $request->input("total_investment_cost_$key"),
                        'subsidy_grant' => $request->input("subsidy_grant_$key"),
                        'bank_loan_cost' => $request->input("bank_loan_cost_$key"),
                        'balance_source_of_investment' => $request->input("balance_source_of_investment_$key"),
                        'economic_useful_life' => $request->input("economic_useful_life_$key"),
                        'residual_value_of_asset' => $request->input("residual_value_of_asset_$key"),
                        'annual_interest_on_bank_loan' => $request->input("annual_interest_on_bank_loan_$key"),
                        'annual_depreciation' => $request->input("annual_depreciation_$key"),
                        'annual_insurance' => $request->input("annual_insurance_$key"),
                        'annual_tax' => $request->input("annual_tax_$key"),
                        'annual_repair_and_maintenance' => $request->input("annual_repair_and_maintenance_$key"),
                        'annual_fixed_cost_of_asset' => $request->input("annual_fixed_cost_of_asset_$key"),
                        'any_other' => $request->input("any_other_$key"),
                        'specification_unit' => $request->input("specification_unit_$key"),
                        'rental_unit' => $request->input("rental_unit_$key"),
                        'rental_rate' => $request->input("rental_rate_$key")
                    ];
            
                    $storage_structure->$key = ($request->$key == 'Yes') ? json_encode($data) : null;
                }
            
                // Save or update record with new data
                $storage_structure->save();
            
                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Third Step Created Successfully',
                ], 200);
        }

            
           

             ///// Processing Infrastructure old query
            //  if ($request->step == 4) {

            //     $validateUser = Validator::make(
            //         $request->all(),
            //         [
            //             // 'wheat_processing' => 'required|integer',
            //             // 'oil_processing' => 'required|integer',
            //             // 'sugarcane_processing' => 'required|integer',
            //             // 'dal_processing' => 'required|integer',
            //             // 'other_processing' => 'required|integer',

            //         ]
            //     );

            //     if ($validateUser->fails()) {
            //         return response()->json([
            //             'status' => false,
            //             'message' => 'validation error',
            //             'errors' => $validateUser->errors()
            //         ], 401);
            //     }


            //     $processing_infrastructure = new ProcessingInfrastructure();
               
                
                
                



            //      $infrastructure = ['wheat_processing','oil_processing','sugarcane_processing',
            //     'dal_processing','other_processing'];
            //     foreach($infrastructure as $key){
                    
            //         $data['number']=$request->input("number_".$key);
            //         $data['specification']=$request->input("specification_".$key);
            //         $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
            //         $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
            //         $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
            //         $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
            //         $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
            //         $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
            //         $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
            //         $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
            //         $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
            //         $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
            //         $data['annual_tax'] = $request->input("annual_tax_" . $key);
            //         $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
            //         $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
            //         $data['any_other'] = $request->input("any_other_" . $key);
                    
            //          $data['specification_unit']=$request->input("specification_unit_".$key);
            //         $data['rental_unit']=$request->input("rental_unit_".$key);
            //         $data['rental_rate']=$request->input("rental_rate_".$key);
                    
            //         $processing_infrastructure->$key = ($request->$key=='Yes') ? json_encode($data):null;
                
                    
                    
                    
            //     }
                
            //     $processing_infrastructure->crop_id = $request->crop_id;
            //     $processing_infrastructure->farmer_id = $request->farmer_id;
            //     $processing_infrastructure->save();


            //     return response()->json([
            //         'status' => true,
            //         'message' => 'Infrastructure Fourth Step Created Successfully',

            //     ], 200);
            // }
            
            if ($request->step == 4) {
                
                if ($request->farmer_id == null) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Farmer ID is required'
                    ], 400);
                }
            
                
                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // Add validation rules if required
                    ]
                );
            
                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
            
                
                $processing_infrastructure = ProcessingInfrastructure::updateOrCreate(
                    ['farmer_id' => $request->farmer_id],
                    ['crop_id' => $request->crop_id]
                );
            
             
                $infrastructure = ['wheat_processing', 'oil_processing', 'sugarcane_processing', 'dal_processing', 'other_processing'];
            
                foreach ($infrastructure as $key) {
                    $data = [
                        'number' => $request->input("number_$key"),
                        'specification' => $request->input("specification_$key"),
                        'year_of_asset_creation' => $request->input("year_of_asset_creation_$key"),
                        'total_investment_cost' => $request->input("total_investment_cost_$key"),
                        'subsidy_grant' => $request->input("subsidy_grant_$key"),
                        'bank_loan_cost' => $request->input("bank_loan_cost_$key"),
                        'balance_source_of_investment' => $request->input("balance_source_of_investment_$key"),
                        'economic_useful_life' => $request->input("economic_useful_life_$key"),
                        'residual_value_of_asset' => $request->input("residual_value_of_asset_$key"),
                        'annual_interest_on_bank_loan' => $request->input("annual_interest_on_bank_loan_$key"),
                        'annual_depreciation' => $request->input("annual_depreciation_$key"),
                        'annual_insurance' => $request->input("annual_insurance_$key"),
                        'annual_tax' => $request->input("annual_tax_$key"),
                        'annual_repair_and_maintenance' => $request->input("annual_repair_and_maintenance_$key"),
                        'annual_fixed_cost_of_asset' => $request->input("annual_fixed_cost_of_asset_$key"),
                        'any_other' => $request->input("any_other_$key"),
                        'specification_unit' => $request->input("specification_unit_$key"),
                        'rental_unit' => $request->input("rental_unit_$key"),
                        'rental_rate' => $request->input("rental_rate_$key")
                    ];
            
                    $processing_infrastructure->$key = ($request->$key == 'Yes') ? json_encode($data) : null;
                }
            
                // Save or update record with new data
                $processing_infrastructure->save();
            
                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Fourth Step Created Successfully',
                ], 200);
            }


               /////Retails Outlets old query
            //   if ($request->step == 5) {

            //     $validateUser = Validator::make(
            //         $request->all(),
            //         [
            //             // 'kiran_outlets' => 'required|integer',
            //             // 'grossary_outlets' => 'required|integer',
            //             // 'other_outlets' => 'required|integer',


            //         ]
            //     );

            //     if ($validateUser->fails()) {
            //         return response()->json([
            //             'status' => false,
            //             'message' => 'validation error',
            //             'errors' => $validateUser->errors()
            //         ], 401);
            //     }


            //     $retail_outlet = new RetailOutlet();
           
                
                
                
                
            //      $infrastructure = ['kiran_outlets','grossary_outlets','other_outlets'];
            //     foreach($infrastructure as $key){
                   
            //         $data['number']=$request->input("number_".$key);
            //         $data['specification']=$request->input("specification_".$key);
            //         $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
            //         $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
            //         $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
            //         $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
            //         $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
            //         $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
            //         $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
            //         $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
            //         $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
            //         $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
            //         $data['annual_tax'] = $request->input("annual_tax_" . $key);
            //         $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
            //         $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
            //         $data['any_other'] = $request->input("any_other_" . $key);
                    
            //          $data['specification_unit']=$request->input("specification_unit_".$key);
            //         $data['rental_unit']=$request->input("rental_unit_".$key);
            //         $data['rental_rate']=$request->input("rental_rate_".$key);
                    
            //         $retail_outlet->$key = ($request->$key=='Yes') ? json_encode($data):null;
                  
                    
                    
            //     }
            //     $retail_outlet->crop_id = $request->crop_id;
            //     $retail_outlet->farmer_id = $request->farmer_id;
            //     $retail_outlet->save();



            //     return response()->json([
            //         'status' => true,
            //         'message' => 'Infrastructure Fifth Step Created Successfully',

            //     ], 200);
            // }

            if ($request->step == 5) {
                // Ensure `farmer_id` is provided
                if ($request->farmer_id == null) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Farmer ID is required'
                    ], 400);
                }
            
                // Validation (add rules if necessary)
                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // Define validation rules if required
                    ]
                );
            
                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
            
                // Use `updateOrCreate` to insert or update a record based on `farmer_id`
                $retail_outlet = RetailOutlet::updateOrCreate(
                    ['farmer_id' => $request->farmer_id],
                    ['crop_id' => $request->crop_id]
                );
            
                // Define infrastructure array and loop through fields
                $infrastructure = ['kiran_outlets', 'grossary_outlets', 'other_outlets'];
            
                foreach ($infrastructure as $key) {
                    $data = [
                        'number' => $request->input("number_$key"),
                        'specification' => $request->input("specification_$key"),
                        'year_of_asset_creation' => $request->input("year_of_asset_creation_$key"),
                        'total_investment_cost' => $request->input("total_investment_cost_$key"),
                        'subsidy_grant' => $request->input("subsidy_grant_$key"),
                        'bank_loan_cost' => $request->input("bank_loan_cost_$key"),
                        'balance_source_of_investment' => $request->input("balance_source_of_investment_$key"),
                        'economic_useful_life' => $request->input("economic_useful_life_$key"),
                        'residual_value_of_asset' => $request->input("residual_value_of_asset_$key"),
                        'annual_interest_on_bank_loan' => $request->input("annual_interest_on_bank_loan_$key"),
                        'annual_depreciation' => $request->input("annual_depreciation_$key"),
                        'annual_insurance' => $request->input("annual_insurance_$key"),
                        'annual_tax' => $request->input("annual_tax_$key"),
                        'annual_repair_and_maintenance' => $request->input("annual_repair_and_maintenance_$key"),
                        'annual_fixed_cost_of_asset' => $request->input("annual_fixed_cost_of_asset_$key"),
                        'any_other' => $request->input("any_other_$key"),
                        'specification_unit' => $request->input("specification_unit_$key"),
                        'rental_unit' => $request->input("rental_unit_$key"),
                        'rental_rate' => $request->input("rental_rate_$key")
                    ];
            
                    $retail_outlet->$key = ($request->$key == 'Yes') ? json_encode($data) : null;
                }
            
                // Save or update the record with the new data
                $retail_outlet->save();
            
                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Fifth Step Created Successfully',
                ], 200);
            }

            

            /////Other Infrastructure old query
            // if ($request->step == 6) {

            //     $validateUser = Validator::make(
            //         $request->all(),
            //         [
            //             // 'shed_kuchha' => 'required|integer',
            //             // 'shed_pucca' => 'required|integer',
            //             // 'other_infrastructure' => 'required|integer',


            //         ]
            //     );
                   
            //     if ($validateUser->fails()) {
            //         return response()->json([
            //             'status' => false,
            //             'message' => 'validation error',
            //             'errors' => $validateUser->errors()
            //         ], 401);
            //     }


            //     $retail_outlet = new OtherInfrastructure();
               
                
                
                
            //     $infrastructure = ['shed_kuchha','shed_pucca','other_infrastructure'];
                 
            //     foreach($infrastructure as $key){
                    
            //         $data['number']=$request->input("number_".$key);
            //         $data['specification']=$request->input("specification_".$key);
            //         $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
            //         $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
            //         $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
            //         $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
            //         $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
            //         $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
            //         $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
            //         $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
            //         $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
            //         $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
            //         $data['annual_tax'] = $request->input("annual_tax_" . $key);
            //         $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
            //         $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
            //         $data['any_other'] = $request->input("any_other_" . $key);
                    
            //          $data['specification_unit']=$request->input("specification_unit_".$key);
            //         $data['rental_unit']=$request->input("rental_unit_".$key);
            //         $data['rental_rate']=$request->input("rental_rate_".$key);
                    
            //         $retail_outlet->$key = ($request->$key=='Yes') ? json_encode($data):null;
                     
            //     }
            //     $retail_outlet->crop_id = $request->crop_id;
            //     $retail_outlet->farmer_id = $request->farmer_id;
            //     $retail_outlet->save();

            //     return response()->json([
            //         'status' => true,
            //         'message' => 'Infrastructure Sixth Step Created Successfully',

            //     ], 200);
            // }
            
            
            if ($request->step == 6) {
                
                if ($request->farmer_id == null) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Farmer ID is required'
                    ], 400);
                }
            
               
                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // Add validation rules if required
                    ]
                );
            
                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
            
              
                $other_infrastructure = OtherInfrastructure::updateOrCreate(
                    ['farmer_id' => $request->farmer_id],
                    ['crop_id' => $request->crop_id]
                );
            
                
                $infrastructure = ['shed_kuchha', 'shed_pucca', 'other_infrastructure'];
            
                foreach ($infrastructure as $key) {
                    $data = [
                        'number' => $request->input("number_$key"),
                        'specification' => $request->input("specification_$key"),
                        'year_of_asset_creation' => $request->input("year_of_asset_creation_$key"),
                        'total_investment_cost' => $request->input("total_investment_cost_$key"),
                        'subsidy_grant' => $request->input("subsidy_grant_$key"),
                        'bank_loan_cost' => $request->input("bank_loan_cost_$key"),
                        'balance_source_of_investment' => $request->input("balance_source_of_investment_$key"),
                        'economic_useful_life' => $request->input("economic_useful_life_$key"),
                        'residual_value_of_asset' => $request->input("residual_value_of_asset_$key"),
                        'annual_interest_on_bank_loan' => $request->input("annual_interest_on_bank_loan_$key"),
                        'annual_depreciation' => $request->input("annual_depreciation_$key"),
                        'annual_insurance' => $request->input("annual_insurance_$key"),
                        'annual_tax' => $request->input("annual_tax_$key"),
                        'annual_repair_and_maintenance' => $request->input("annual_repair_and_maintenance_$key"),
                        'annual_fixed_cost_of_asset' => $request->input("annual_fixed_cost_of_asset_$key"),
                        'any_other' => $request->input("any_other_$key"),
                        'specification_unit' => $request->input("specification_unit_$key"),
                        'rental_unit' => $request->input("rental_unit_$key"),
                        'rental_rate' => $request->input("rental_rate_$key")
                    ];
            
                    $other_infrastructure->$key = ($request->$key == 'Yes') ? json_encode($data) : null;
                }
            
                $other_infrastructure->save();
            
                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure Sixth Step Created Successfully',
                ], 200);
            }

            
            
            /////investment plantetion old query
            // if ($request->step == 7) {
                
            //       $validateUser = Validator::make(
            //         $request->all(),
            //         [
            //             // 'name_plantation' => 'required',
            //             // 'cost_pantation' => 'required',
            //             // 'Infrastructure' => 'required',
            //             // 'material' => 'required',
            //             // 'labour_mechanization' => 'required',
            //             // 'fixed_cost' => 'required',
            //         ]
            //     );
                 
            //     if ($validateUser->fails()) {
            //         return response()->json([
            //             'status' => false,
            //             'message' => 'validation error',
            //             'errors' => $validateUser->errors()
            //         ], 401);
            //     }
                
            //     $investment_plantation = new investment_plantation();

                
            //     $infrastructure = ['name_plantation','cost_pantation','Infrastructure','material','labour_mechanization','fixed_cost'];
            //     foreach($infrastructure as $key){
            //         $infrastructure_key = new InfrastructureKey();
            //         $data['number']=$request->input("number_".$key);
            //         $data['specification']=$request->input("specification_".$key);
            //         $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
            //         $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
            //         $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
            //         $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
            //         $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
            //         $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
            //         $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
            //         $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
            //         $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
            //         $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
            //         $data['annual_tax'] = $request->input("annual_tax_" . $key);
            //         $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
            //         $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
            //         $data['any_other'] = $request->input("any_other_" . $key);
                    
            //         $data['specification_unit']=$request->input("specification_unit_".$key);
            //         $data['rental_unit']=$request->input("rental_unit_".$key);
            //         $data['rental_rate']=$request->input("rental_rate_".$key);
                    
            //         $investment_plantation->$key = ($request->$key=='Yes') ? json_encode($data):null;
                    
            //     }
                
            //     $investment_plantation->crop_id = $request->crop_id;
            //      $investment_plantation->farmer_id = $request->farmer_id;
            //     $investment_plantation->save();
            
            //     return response()->json([
            //         'status' => true,
            //         'message' => 'Infrastructure seven Step Created Successfully',

            //     ], 200);
                
            // }
            
              if ($request->step == 7) {
                
                
                if ($request->farmer_id == null) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Farmer ID is required'
                    ], 400);
                }
    
                $validateUser = Validator::make(
                    $request->all(),
                    [
                        // 'name_plantation' => 'required',
                        // 'cost_pantation' => 'required',
                        // 'Infrastructure' => 'required',
                        // 'material' => 'required',
                        // 'labour_mechanization' => 'required',
                        // 'fixed_cost' => 'required',
                    ]
                );
                 
                if ($validateUser->fails()) {
                    return response()->json([
                        'status' => false,
                        'message' => 'validation error',
                        'errors' => $validateUser->errors()
                    ], 401);
                }
                
                 $investment_plantation = investment_plantation::updateOrCreate(
                    ['farmer_id' => $request->farmer_id],
                    ['crop_id' => $request->crop_id]
                 );
                
                
                $infrastructure = ['name_plantation','cost_pantation','Infrastructure','material','labour_mechanization','fixed_cost'];
                foreach($infrastructure as $key){
                    $infrastructure_key = new InfrastructureKey();
                    $data['number']=$request->input("number_".$key);
                    $data['specification']=$request->input("specification_".$key);
                    $data['year_of_asset_creation']=$request->input("year_of_asset_creation_".$key);
                    $data['total_investment_cost'] = $request->input("total_investment_cost_" . $key);
                    $data['subsidy_grant'] = $request->input("subsidy_grant_" . $key);
                    $data['bank_loan_cost'] = $request->input("bank_loan_cost_" . $key);
                    $data['balance_source_of_investment'] = $request->input("balance_source_of_investment_" . $key);
                    $data['economic_useful_life'] = $request->input("economic_useful_life_" . $key);
                    $data['residual_value_of_asset'] = $request->input("residual_value_of_asset_" . $key);
                    $data['annual_interest_on_bank_loan'] = $request->input("annual_interest_on_bank_loan_" . $key);
                    $data['annual_depreciation'] = $request->input("annual_depreciation_" . $key);
                    $data['annual_insurance'] = $request->input("annual_insurance_" . $key);
                    $data['annual_tax'] = $request->input("annual_tax_" . $key);
                    $data['annual_repair_and_maintenance'] = $request->input("annual_repair_and_maintenance_" . $key);
                    $data['annual_fixed_cost_of_asset'] = $request->input("annual_fixed_cost_of_asset_" . $key);
                    $data['any_other'] = $request->input("any_other_" . $key);
                    
                    $data['specification_unit']=$request->input("specification_unit_".$key);
                    $data['rental_unit']=$request->input("rental_unit_".$key);
                    $data['rental_rate']=$request->input("rental_rate_".$key);
                    
                    $investment_plantation->$key = ($request->$key=='Yes') ? json_encode($data):null;
                    
                }
                
                $investment_plantation->save();
            
                return response()->json([
                    'status' => true,
                    'message' => 'Infrastructure seven Step Created Successfully',

                ], 200);
                
            }
            
            
            

        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }

    public function threeYearProduction(Request $request)
    {
        try {

            $validateUser = Validator::make(
                $request->all(),
                [
                    'season' => 'required|string',
                    'crop_name' => 'required|string',
                    'variety' => 'required|string',
                    'first_year' => 'required|string',
                    'second_year' => 'required|string',
                    'third_year' => 'required|string',
                    'first_year_area' => 'required|numeric',
                    'first_year_production' => 'required',
                    'second_year_area' => 'required|numeric',
                    'second_year_production' => 'required',
                    'third_year_area' => 'required|numeric',
                    'third_year_production' => 'required',
                    'average_price_selling' => 'required|numeric',
                    'min_rate' => 'required|numeric',
                    'max_rate' => 'required|numeric',
                    'first_year_area_unit' => 'required|string',
                    'first_year_production_unit' => 'required|string',
                    'second_year_area_unit' => 'required|string',
                    'second_year_production_unit' => 'required|string',
                    'third_year_area_unit' => 'required|string',
                    'third_year_production_unit' => 'required|string',
                ]
            );

            if ($validateUser->fails()) {
                return response()->json([
                    'status' => false,
                    'message' => 'validation error',
                    'errors' => $validateUser->errors()
                ], 401);
            }


            $production_years = new LastYearProduction();
            $production_years->season = $request->season;
            $production_years->crop_name = $request->crop_name;
            $production_years->variety = $request->variety;
            $production_years->first_year = $request->first_year;
            $production_years->second_year = $request->second_year;
            $production_years->third_year = $request->third_year;
            $production_years->first_year_area = $request->first_year_area;
            $production_years->first_year_production = $request->first_year_production;
            $production_years->second_year_area = $request->second_year_area;
            $production_years->second_year_production = $request->second_year_production;
            $production_years->third_year_area = $request->third_year_area;
            $production_years->third_year_production = $request->third_year_production;
            
            $production_years->average_price_selling = $request->average_price_selling;
            

            $production_years->min_rate = $request->min_rate;
            $production_years->max_rate = $request->max_rate;
            
            $production_years->net_area_under_nest_season = $request->net_area_under_nest_season;
            
            $production_years->first_year_area_unit = $request->first_year_area_unit;
            
            $production_years->first_year_production_unit = $request->first_year_production_unit;
            
            // $production_years->first_year_productivity_unit = $request->first_year_productivity_unit;

            $production_years->second_year_area_unit = $request->second_year_area_unit;
            $production_years->second_year_production_unit = $request->second_year_production_unit;
            
            // $production_years->second_year_productivity_unit = $request->second_year_productivity_unit;

            $production_years->third_year_area_unit = $request->third_year_area_unit;
            $production_years->third_year_production_unit = $request->third_year_production_unit;
            
            // $production_years->third_year_productivity_unit = $request->third_year_productivity_unit;
            
            $production_years->remark = $request->remark;
            
            
            $production_years->marketed_surplus = $request->marketed_surplus;

            $production_years->farmer_id = $request->farmer_id;
            $production_years->save();

            return response()->json([
                'status' => true,
                'message' => 'Production For Last Year Created Successfully',

            ], 200);


        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }

}
