<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AgricultureActivity;
use App\Models\Crop;
use App\Models\CropCultivation;
use App\Models\Farmer;
use App\Models\FarmMechanism;
use App\Models\IrrigationInfrastructure;
use App\Models\LastYearProduction;
use App\Models\OtherInfrastructure;
use App\Models\ProcessingInfrastructure;
use App\Models\ProductionOutput;
use App\Models\RetailOutlet;
use App\Models\StorageStructure;
use App\Models\User;
use App\Models\InputSupplier;
use App\Models\CaphFarm;
use App\Models\TrdFarm;
use App\Models\VaOneFarm;
use App\Models\VaTwoFarm;
use App\Models\VaThreeFarm;
use App\Models\ForwardLinkage;
use App\Models\BackwardLinkage;
use App\Models\BackwardLinkageTwo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\distributor;
use App\Models\fpoA;
use App\Models\fpoB;

class AgricultureController extends Controller
{


    public function agriculture_activities(Request $request)
    {
        try {

            if($request->step == 1)
            {

                $validator = Validator::make($request->all(), [
                    'animal_name' => 'required|string',
                    'number' => 'required|integer',
                    'breed' => 'required|string',
                   
                ]);
                if ($validator->fails()) {
                    return response()->json([
                        'remark' => 'validation_error',
                        'status' => 'error',
                        'message' => ['error' => $validator->errors()],
                    ]);
                }

                $agriculture_activity = new AgricultureActivity();
                $agriculture_activity->animal_name = $request->animal_name;
                $agriculture_activity->number = $request->number;
                $agriculture_activity->breed = $request->breed;
                $agriculture_activity->generation = $request->generation;
                
                $agriculture_activity->green_fodder = $request->green_fodder;
                
                $agriculture_activity->dry_feed = $request->dry_feed;
                $agriculture_activity->green_fodder_quantity = $request->green_fodder_quantity;
                $agriculture_activity->green_fodder_expenses = $request->green_fodder_expenses;
                $agriculture_activity->dry_fodder_quantity = $request->dry_fodder_quantity;
                $agriculture_activity->dry_fodder_expenses = $request->dry_fodder_expenses;
                $agriculture_activity->conventional_feed = $request->conventional_feed;
                $agriculture_activity->conventional_feed_quantity = $request->conventional_feed_quantity;
                $agriculture_activity->conventional_feed_expenditure = $request->conventional_feed_expenditure;
                $agriculture_activity->commercial_feed = $request->commercial_feed;
                $agriculture_activity->commercial_feed_quantity = $request->commercial_feed_quantity;
                $agriculture_activity->commercial_feed_expenses = $request->commercial_feed_expenses;
                $agriculture_activity->local = $request->local;
                $agriculture_activity->branded = $request->branded;
                $agriculture_activity->farmer_id =$request->farmer_id;
                $agriculture_activity->save();


                return response()->json([
                    'status' => true,
                    'message' => 'Agriculture Activity First Step Created Successfully',
                ], 200);
            }

            if($request->step == 2)
            {
                $validator = Validator::make($request->all(), [

                    // 'health_expenditure' => 'required|integer',
                    // 'veterinary_distance' => 'required|integer',
                    // 'veterinary_quality' => 'required|string',
                    // 'product' => 'required|string',
                    // 'main_product_production' => 'required|integer',
                    // 'quantity_selling_market' => 'required|integer',
                    // 'average_selling_price' => 'required|integer',
                    // 'other_product_production' => 'required|integer',
                    // 'quantity_selling_other' => 'required|integer',
                    // 'average_selling_other' => 'required|integer',
                    // 'first_sale_place' => 'required|string',
                    // 'who_purchase' => 'required|string',
                    // 'unit_price_produce' => 'required|integer',
                    // 'under_weighing' => 'required|integer',
                    // 'trader_default' => 'required|integer',


                ]);
                if ($validator->fails()) {
                    return response()->json([
                        'remark' => 'validation_error',
                        'status' => 'error',
                        'message' => ['error' => $validator->errors()],
                    ]);
                }
                //$id = AgricultureActivity::select('id')->where('farmer_id',$request->farmer_id)->first();
                // dd($id->id);
                
                //$id = AgricultureActivity::where('farmer_id',$request->farmer_id)->first();


                AgricultureActivity::where('farmer_id',$request->farmer_id)->update([
                    
                    'health_expenditure' => $request->health_expenditure,
                    'veterinary_distance' => $request->veterinary_distance,
                    'veterinary_quality' => $request->veterinary_quality,
                    'product' => $request->product,
                    'main_product_production' => $request->main_product_production,
                    'average_selling_price' => $request->average_selling_price,
                    'other_product_production' => $request->other_product_production,
                    'quantity_selling_market' => $request->quantity_selling_market,
                    'quantity_selling_other' => $request->quantity_selling_other,
                    'average_selling_other' => $request->average_selling_other,
                    'first_sale_place' => $request->first_sale_place,
                    
                    'avarage_lactetation_period_days' => $request->avarage_lactetation_period_days,
                    'avarage_lactetation_period_month' => $request->avarage_lactetation_period_month,
                    'avarage_lactetation_period_year' => $request->avarage_lactetation_period_year,
                    
                    
                    'avarage_lactetation_period_unit' => $request->avarage_lactetation_period_unit,
                    
                    'who_purchase' => $request->who_purchase,
                    'unit_price_produce' => $request->unit_price_produce,
                    'under_weighing' => $request->under_weighing,
                    'trader_default' => $request->trader_default,
                    
                      "sold_to_villagers" => $request->sold_to_villagers,
                  
                      "sold_to_milkman" => $request->sold_to_milkman,
                      "sold_to_local_dairy_unit" => $request->sold_to_local_dairy_unit,
                      "milk_processing_company" => $request->milk_processing_company,
                      "milk_cooperative_society" => $request->milk_cooperative_society,
                      "direct_sel_loc_mark" => $request->direct_sel_loc_mark,
                      "sold_to_other" => $request->sold_to_other,
                      "post_production_losses" => $request->post_production_losses,
                      "any_other_factors" => $request->any_other_factors,
                ]);
                return response()->json([
                    'status' => true,
                    'message' => 'Agriculture Activity Second Step Created Successfully',
                ], 200);
            }

        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }

    public function backward_linkage(Request $request)
    {
        try{
            $url = $request->url();
            $urlExp = isset($url) && $url ? explode('/',$url) : [];
            $urlExp = isset($urlExp) && $urlExp ? end($urlExp) : '';
            
            if($urlExp == 'one')
            {
                $validator = Validator::make($request->all(), [
                    // 'input_supplier_name' => 'required|string',
                    // 'particular_name' => 'required|string',
                    // 'adequacy' => 'required|text',
                    // 'quality' => 'required|text',
                    // 'timely_supply' => 'required|text',
                    // 'effectiveness' => 'required|text',
                    // 'as_consultancy_service' => 'required|text',
                    // 'price_reasonability' => 'required|text',
                    // 'with_or_without_credit' => 'required|text',
                    // 'diff_in_price_with_without_credit' => 'required|text',
                ]);
                
                if ($validator->fails()) {
                    return response()->json([
                        'remark' => 'validation_error',
                        'status' => 'error',
                        'message' => [
                            'error' => $validator->errors()
                        ],
                    ]);
                }
                
                $backward_linkage = new BackwardLinkage();
                
                $backward_linkage->seed = json_encode($request->seed);
                $backward_linkage->plantlets = json_encode($request->plantlets);
                $backward_linkage->fingerling_fishery = json_encode($request->fingerling_fishery);
                $backward_linkage->day_old_chick = json_encode($request->day_old_chick);
                $backward_linkage->feed = json_encode($request->feed);
                $backward_linkage->fertilizer = json_encode($request->fertilizer);
                $backward_linkage->pesticides_insec_her = json_encode($request->pesticides_insec_her);
                $backward_linkage->nutrients = json_encode($request->nutrients);
                $backward_linkage->medicine = json_encode($request->medicine);
                $backward_linkage->labour = json_encode($request->labour);
                $backward_linkage->supply_of_diesel_fuel_electricity = json_encode($request->supply_of_diesel_fuel_electricity);
                $backward_linkage->technology_transfer = json_encode($request->technology_transfer);
                $backward_linkage->fm_custom_hire_services = json_encode($request->fm_custom_hire_services);
                $backward_linkage->irrigation_on_custom_and_hiring = json_encode($request->irrigation_on_custom_and_hiring);
                $backward_linkage->input_credit = json_encode($request->input_credit);
                $backward_linkage->supply_credit = json_encode($request->supply_credit);
                $backward_linkage->credit_from_nbsc = json_encode($request->credit_from_nbsc);
                $backward_linkage->credit_from_banks = json_encode($request->credit_from_banks);
                $backward_linkage->other_source = json_encode($request->other_source);
                $backward_linkage->any_other_information = json_encode($request->any_other_information);
                $backward_linkage->farmer_id = $request->farmer_id;
                $backward_linkage->save();
                
                return response()->json([
                    'status' => true,
                    'data'   => [
                        'id' => $backward_linkage['id'],
                        'farmer_id' => $backward_linkage['farmer_id'], 
                    ],
                    'message' => 'Backward Linkage Step One Created Successfully',
                ], 200);
            }
        
            if($urlExp == 'two')
            {
                $validator = Validator::make($request->all(), [
                    
                    // 'seed_type' => 'required|text',
                    // 'distance_from_farm_unit' => 'required|text',
                    // 'distance_from_farm' => 'required|numeric|between:0,999999.99',
                    // 'fuel_electricity_supply' => 'required|text',
                    // 'fuel_electricity_source' => 'required|text',
                    // 'fuel_electricity_value' => 'required|numeric|between:0,999999.99',
                    // 'technology_transfer' => 'required|text',
                    // 'other' => 'required|text',
                    // 'labour' => 'required|text',
                    // 'labour_unit' => 'required|text',
                    // 'labour_unit_price' => 'required|numeric|between:0,999999.99',
                    // 'labour_cost' => 'required|numeric|between:0,999999.99',
                    // 'labour_remarks' => 'required|text',
                ]);
                
                if ($validator->fails()) {
                    return response()->json([
                        'remark' => 'validation_error',
                        'status' => 'error',
                        'message' => [
                            'error' => $validator->errors()
                        ],
                    ]);
                }
                
                $backward_linkage_two = new BackwardLinkageTwo();

                $backward_linkage_two->foundation_seed = json_encode($request->foundation_seed);
                
                $backward_linkage_two->backward_linkages_id = $request->backward_linkages_id;
                
                $backward_linkage_two->breeder_seed = json_encode($request->breeder_seed);
                
                $backward_linkage_two->certified_seed = json_encode($request->certified_seed);
                $backward_linkage_two->other_seed = json_encode($request->other_seed);
                
                $backward_linkage_two->brand_of_seed = json_encode($request->brand_of_seed);
                
                $backward_linkage_two->own_seed = json_encode($request->own_seed);
                $backward_linkage_two->seed_purchase_from_market = json_encode($request->seed_purchase_from_market);
                $backward_linkage_two->any_other_source = json_encode($request->any_other_source);
                $backward_linkage_two->source_distance_km = json_encode($request->source_distance_km);
                $backward_linkage_two->any_other = json_encode($request->any_other);
                $backward_linkage_two->farmer_id = $request->farmer_id;
                $backward_linkage_two->save();
                
                return response()->json([
                    'status' => true,
                    'message' => 'Backward Linkage Step Two Created Successfully',
                ], 200);
            }
        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
        
    }
    
    
    
    
    
    
                
    public function forward_linkage_data(Request $request)
    {
        try{
            
            
            if($request->step == 1)
            {
                
                $validator = Validator::make($request->all(), [
    
                    // 'marketing_channel' => 'required|string',
                    // 'marketing_channel_distance' => 'required|integer',
                    // 'transportation_method' => 'required|string',
                    // 'transport_by' => 'required|string',
                    // 'transport_expenses' => 'required|integer',
                    // 'primary_processing' => 'required|string',
                    // 'buyer_institution_present' => 'required|integer',
                    // 'formal_informal_contract' => 'required|string',
                    // 'niche_market' => 'required|integer',
                    // 'secondary_processing' => 'required|integer',
                    // 'processing_in_vicinity' => 'required|integer',
    
                ]);
                if ($validator->fails()) {
                    return response()->json([
                        'remark' => 'validation_error',
                        'status' => 'error',
                        'message' => ['error' => $validator->errors()],
                    ]);
                }
            
            $forward_linkage = new ForwardLinkage();
            $forward_linkage->marketing_channel = $request->marketing_channel;
            $forward_linkage->marketing_channel_distance = $request->marketing_channel_distance;
            $forward_linkage->transportation_method = $request->transportation_method;
            $forward_linkage->transport_by = $request->transport_by;
            $forward_linkage->transport_expenses = $request->transport_expenses;
            $forward_linkage->primary_processing = $request->primary_processing;
            $forward_linkage->buyer_institution_present = $request->buyer_institution_present;
            $forward_linkage->formal_informal_contract = $request->formal_informal_contract;
            $forward_linkage->niche_market = $request->niche_market;
            $forward_linkage->secondary_processing = $request->secondary_processing;
            $forward_linkage->processing_in_vicinity = $request->processing_in_vicinity;
            $forward_linkage->farmer_id = $request->farmer_id;
            $forward_linkage->save();
          
          
            return response()->json([
                'status' => true,
                'message' => 'Forward Linkage First Step Created Successfully',
            ], 200);
        
            }
            
            
            if($request->step == 2)
            {
                
                $validator = Validator::make($request->all(), [
    
                    // 'storage_facility' => 'required|integer',
                    // 'storage' => 'required|string',
                    // 'facility_capacity' => 'required|integer',
                    // 'storage_charges' => 'required|integer',
                    // 'time_of_sale' => 'required|string',
                    // 'road_connectivity' => 'required|text',
                    // 'payment_of_sale' => 'required|text',
                    // 'total_sale_value' => 'required|integer',
                    // 'weighing_method' => 'required|string',
                    // 'extent_of_under_weighing' => 'required|integer',
                    // 'source_of_market_info' => 'required|string',
                    // 'total_marketable_surplus' => 'required|integer',
                    // 'selling_on_msp' => 'required|integer',
                    // 'extent_of_msp_price' => 'required|integer',
    
                ]);
                
                if ($validator->fails()) {
                    return response()->json([
                        'remark' => 'validation_error',
                        'status' => 'error',
                        'message' => ['error' => $validator->errors()],
                    ]);
                }
            
                $id = ForwardLinkage::select('id')->where('farmer_id', $request->farmer_id)->first();
             
                ForwardLinkage::whereId($id->id)->update([
                    'storage_facility' => $request->storage_facility,
                    'storage' => $request->storage,
                    'facility_capacity' => $request->facility_capacity,
                    'storage_charges' => $request->storage_charges,
                    'storage_duretion' => $request->storage_duretion,
                    'time_of_sale' => $request->time_of_sale,
                    'road_connectivity' => $request->road_connectivity,
                    'payment_of_sale' => $request->payment_of_sale,
                    'total_sale_value' => $request->total_sale_value,
                    'weighing_method' => $request->weighing_method,
                    'extent_of_under_weighing' => $request->extent_of_under_weighing,
                    'source_of_market_info' => $request->source_of_market_info,
                    'total_marketable_surplus' =>$request->total_marketable_surplus,
                    'selling_on_msp' => $request->selling_on_msp,
                    'extent_of_msp_price' =>$request->extent_of_msp_price,
                    'remark' =>$request->remark,
                ]);
            
              
                return response()->json([
                    'status' => true,
                    'message' => 'Forward Linkage Second Step Created Successfully',
                ], 200);
        
            }
          
        
        
        }
        catch (\Throwable $th) {
                return response()->json([
                    'status' => false,
                    'message' => $th->getMessage()
                ], 500);
            }
        
    }
             
    // old query                
    // public function input_upplier(Request $request)
    // {
        
        
    //     if(isset($request->image))
    //       {
              
    //         if ($request->hasFile('image') && $request->file('image')->isValid()) 
    //         {
    //             $uploadedFile = $request->file('image');
            
    //             $targetDir = "uploads/"; // Change this to your desired local folder path
            
    //             // Ensure the target directory exists, create it if necessary
    //             if (!file_exists($targetDir)) {
    //                 mkdir($targetDir, 0755, true);
    //             }
            
    //             $targetFile = $targetDir . $uploadedFile->getClientOriginalName();
            
    //             // Move the uploaded file to the desired location
    //             if ($uploadedFile->move($targetDir, $targetFile)) {
                   
    //             } else {
    //                 echo "Sorry, there was an error uploading your file.";
    //             }
    //         } else {
    //             echo "Error: No valid file uploaded.";
    //         }
    //       }
          
    //     try{
    //         // dd($request->all());
    //         $validator = Validator::make($request->all(), [
    //             // 'trader.name' => 'string',
    //             // 'trader.mobile' => 'string',
    //             // 'trader.district' => 'string',
    //             // 'trader.block' => 'string',
            
    //             // 'infra_support.establishment_cost' => 'numeric',
    //             // 'infra_support.storage_structure_cost' => 'numeric',
    //             // 'infra_support.electricity_monthly_expense' => 'numeric',
    //             // 'infra_support.manpower_monthly_expense' => 'numeric',
    //             // 'infra_support.rent_monthly' => 'numeric',
    //             // 'infra_support.travelling_monthly' => 'numeric',
    //             // 'infra_support.input_percentage' => 'numeric',
    //             // 'infra_support.input_duration' => 'numeric',
    //             // 'infra_support.interest_annual' => 'numeric',
    //             // 'infra_support.technical_advisory' => 'numeric',
    //             // 'infra_support.other_expense' => 'numeric',
            
    //             // 'seed.name' => 'string',
    //             // 'seed.purchase_average_cost' => 'numeric',
    //             // 'seed.value_addition_average_cost' => 'numeric',
    //             // 'seed.avrage_sale_price' => 'numeric',
    //             // 'seed.operational_margins' => 'string',
    //             // 'seed.seasonal_quantum' => 'numeric',
    //             // 'seed.credit_extent' => 'numeric',
    //             // 'seed.remark' => 'string',
                
                
    //             //  'fertilizer.name' => 'string',
    //             // 'fertilizer.purchase_average_cost' => 'numeric',
    //             // 'fertilizer.value_addition_average_cost' => 'numeric',
    //             // 'fertilizer.avrage_sale_price' => 'numeric',
    //             // 'fertilizer.operational_margins' => 'string',
    //             // 'fertilizer.seasonal_quantum' => 'numeric',
    //             // 'fertilizer.credit_extent' => 'numeric',
    //             // 'fertilizer.remark' => 'string',
            
    //             // 'nutrients.name' => 'string',
    //             // 'nutrients.purchase_average_cost' => 'numeric',
    //             // 'nutrients.value_addition_average_cost' => 'numeric',
    //             // 'nutrients.avrage_sale_price' => 'numeric',
    //             // 'nutrients.operational_margins' => 'string',
    //             // 'nutrients.seasonal_quantum' => 'numeric',
    //             // 'nutrients.credit_extent' => 'numeric',
    //             // 'nutrients.remark' => 'string',
            
    //             // 'plant_protection.name' => 'string',
    //             // 'plant_protection.purchase_average_cost' => 'numeric',
    //             // 'plant_protection.value_addition_average_cost' => 'numeric',
    //             // 'plant_protection.avrage_sale_price' => 'numeric',
    //             // 'plant_protection.operational_margins' => 'string',
    //             // 'plant_protection.seasonal_quantum' => 'numeric',
    //             // 'plant_protection.credit_extent' => 'numeric',
    //             // 'plant_protection.remark' => 'string',
            
    //             // 'fm.name' => 'string',
    //             // 'fm.purchase_average_cost' => 'numeric',
    //             // 'fm.value_addition_average_cost' => 'numeric',
    //             // 'fm.avrage_sale_price' => 'numeric',
    //             // 'fm.operational_margins' => 'string',
    //             // 'fm.seasonal_quantum' => 'numeric',
    //             // 'fm.credit_extent' => 'numeric',
    //             // 'fm.remark' => 'string',
            
    //             // 'fingerling.name' => 'string',
    //             // 'fingerling.purchase_average_cost' => 'numeric',
    //             // 'fingerling.value_addition_average_cost' => 'numeric',
    //             // 'fingerling.avrage_sale_price' => 'numeric',
    //             // 'fingerling.operational_margins' => 'string',
    //             // 'fingerling.seasonal_quantum' => 'numeric',
    //             // 'fingerling.credit_extent' => 'numeric',
    //             // 'fingerling.remark' => 'string',
            
    //             // 'docs.name' => 'string',
    //             // 'docs.purchase_average_cost' => 'numeric',
    //             // 'docs.value_addition_average_cost' => 'numeric',
    //             // 'docs.avrage_sale_price' => 'numeric',
    //             // 'docs.operational_margins' => 'string',
    //             // 'docs.seasonal_quantum' => 'numeric',
    //             // 'docs.credit_extent' => 'numeric',
    //             // 'docs.remark' => 'string',
                
                
    //             //  'plantlets.name' => 'string',
    //             //     'plantlets.purchase_average_cost' => 'numeric',
    //             //     'plantlets.value_addition_average_cost' => 'numeric',
    //             //     'plantlets.avrage_sale_price' => 'numeric',
    //             //     'plantlets.operational_margins' => 'string',
    //             //     'plantlets.seasonal_quantum' => 'numeric',
    //             //     'plantlets.credit_extent' => 'numeric',
    //             //     'plantlets.remark' => 'string',
                
    //             //     'feeds_supply.name' => 'string',
    //             //     'feeds_supply.purchase_average_cost' => 'numeric',
    //             //     'feeds_supply.value_addition_average_cost' => 'numeric',
    //             //     'feeds_supply.avrage_sale_price' => 'numeric',
    //             //     'feeds_supply.operational_margins' => 'string',
    //             //     'feeds_supply.seasonal_quantum' => 'numeric',
    //             //     'feeds_supply.credit_extent' => 'numeric',
    //             //     'feeds_supply.remark' => 'string',
                
    //             //     'medicines.name' => 'string',
    //             //     'medicines.purchase_average_cost' => 'numeric',
    //             //     'medicines.value_addition_average_cost' => 'numeric',
    //             //     'medicines.avrage_sale_price' => 'numeric',
    //             //     'medicines.operational_margins' => 'string',
    //             //     'medicines.seasonal_quantum' => 'numeric',
    //             //     'medicines.credit_extent' => 'numeric',
    //             //     'medicines.remark' => 'string',
                
    //             //     'consultancy.name' => 'string',
    //             //     'consultancy.purchase_average_cost' => 'numeric',
    //             //     'consultancy.value_addition_average_cost' => 'numeric',
    //             //     'consultancy.avrage_sale_price' => 'numeric',
    //             //     'consultancy.operational_margins' => 'string',
    //             //     'consultancy.seasonal_quantum' => 'numeric',
    //             //     'consultancy.credit_extent' => 'numeric',
    //             //     'consultancy.remark' => 'string',
                    
    //             //      'indicativeI.parameter' => 'string',
    //             //     'indicativeI.remark' => 'string',
                
    //             //     'indicativeII.parameter' => 'string',
    //             //     'indicativeII.remark' => 'string',
                
    //             //     'indicativeIII.parameter' => 'string',
    //             //     'indicativeIII.remark' => 'string',
                
    //             //     'challengeI.parameter' => 'string',
    //             //     'challengeI.remark' => 'string',
                
    //             //     'challengeII.parameter' => 'string',
    //             //     'challengeII.remark' => 'string',
                
    //             //     'challengeIII.parameter' => 'string',
    //             //     'challengeIII.remark' => 'string',
                
    //             //     'challengeIV.parameter' => 'string',
    //             //     'challengeIV.remark' => 'string',
                
    //             //     'riskI.parameter' => 'string',
    //             //     'riskI.remark' => 'string',
                
    //             //     'riskII.parameter' => 'string',
    //             //     'riskII.remark' => 'string',
                
    //             //     'riskIII.parameter' => 'string',
    //             //     'riskIII.remark' => 'string',
                
    //             //     'riskIV.parameter' => 'string',
    //             //     'riskIV.remark' => 'string',
                
    //             //     'riskV.parameter' => 'string',
    //             //     'riskV.remark' => 'string',
                
    //             //     'riskVI.parameter' => 'string',
    //             //     'riskVI.remark' => 'string',
                
    //             //     'prospectI.parameter' => 'string',
    //             //     'prospectI.remark' => 'string',
                
    //             //     'prospectII.parameter' => 'string',
    //             //     'prospectII.remark' => 'string',
                
    //             //     'prospectIII.parameter' => 'string',
    //             //     'prospectIII.remark' => 'string',
    //         ]);

    //         if ($validator->fails()) {
    //             return response()->json([
    //                 'remark' => 'validation_error',
    //                 'status' => 'error',
    //                 'message' => ['error' => $validator->errors()],
    //             ]);
    //         }
            
    //         $input_supplier = new InputSupplier();
            
    //         $input_supplier->user_id = Auth::user()->id;
            
    //         // Assign trader details
    //         $input_supplier->trader_name = $request->input('trader.name');
    //         $input_supplier->trader_mobile = $request->input('trader.mobile');
    //         $input_supplier->trader_district = $request->input('trader.district');
    //         $input_supplier->trader_block = $request->input('trader.block');
    //         $input_supplier->image = $request->input('trader.image');
            
    //         // Assign infra_support details
    //         $input_supplier->establishment_cost = $request->input('infra_support.establishment_cost');
    //         $input_supplier->storage_structure_cost = $request->input('infra_support.storage_structure_cost');
    //         $input_supplier->electricity_monthly_expense = $request->input('infra_support.electricity_monthly_expense');
    //         $input_supplier->manpower_monthly_expense = $request->input('infra_support.manpower_monthly_expense');
    //         $input_supplier->rent_monthly = $request->input('infra_support.rent_monthly');
    //         $input_supplier->travelling_monthly = $request->input('infra_support.travelling_monthly');
    //         $input_supplier->input_percentage = $request->input('infra_support.input_percentage');
    //         $input_supplier->input_duration = $request->input('infra_support.input_duration');
    //         $input_supplier->interest_annual = $request->input('infra_support.interest_annual');
    //         $input_supplier->technical_advisory = $request->input('infra_support.technical_advisory');
    //         $input_supplier->other_expense = $request->input('infra_support.other_expense');
    //         $input_supplier->establishment_cost_unit = $request->input('infra_support.establishment_cost_unit');
    //         $input_supplier->storage_structure_cost_unit = $request->input('infra_support.storage_structure_cost_unit');
    //         $input_supplier->electricity_expense_unit = $request->input('infra_support.electricity_expense_unit');
            
    //         // Assign seed details
    //         $input_supplier->seed_name = $request->input('seed.name');
    //         $input_supplier->seed_purchase_average_cost = $request->input('seed.purchase_average_cost');
    //         $input_supplier->seed_value_addition_average_cost = $request->input('seed.value_addition_average_cost');
    //         $input_supplier->seed_avrage_sale_price = $request->input('seed.avrage_sale_price');
    //         // $input_supplier->seed_operational_margins = $request->input('seed.operational_margins');
    //         $input_supplier->seed_seasonal_quantum = $request->input('seed.seasonal_quantum');
    //         $input_supplier->seed_credit_extent = $request->input('seed.credit_extent');
    //         $input_supplier->seed_remark = $request->input('seed.remark');
    //         $input_supplier->seed_purchase_average_cost_unit = $request->input('seed.purchase_average_cost_unit');
    //         $input_supplier->seed_value_addition_average_cost_unit = $request->input('seed.value_addition_average_cost_unit');
    //         $input_supplier->seed_min_operational_margins = $request->input('seed.min_operational_margins');
    //         $input_supplier->seed_max_operational_margins = $request->input('seed.max_operational_margins');
    //         $input_supplier->seed_seasonal_quantum_unit = $request->input('seed.seasonal_quantum_unit');
            
    //         // Assign fertilizer details
    //         $input_supplier->fertilizer_name = $request->input('fertilizer.name');
    //         $input_supplier->fertilizer_purchase_average_cost = $request->input('fertilizer.purchase_average_cost');
    //         $input_supplier->fertilizer_value_addition_average_cost = $request->input('fertilizer.value_addition_average_cost');
    //         $input_supplier->fertilizer_avrage_sale_price = $request->input('fertilizer.avrage_sale_price');
    //         $input_supplier->fertilizer_seasonal_quantum = $request->input('fertilizer.seasonal_quantum');
    //         $input_supplier->fertilizer_credit_extent = $request->input('fertilizer.credit_extent');
    //         $input_supplier->fertilizer_remark = $request->input('fertilizer.remark');
    //         $input_supplier->fertilizer_purchase_average_cost_unit = $request->input('fertilizer.purchase_average_cost_unit');
    //         $input_supplier->fertilizer_value_addition_average_cost_unit = $request->input('fertilizer.value_addition_average_cost_unit');
    //         $input_supplier->fertilizer_min_operational_margins = $request->input('fertilizer.min_operational_margins');
    //         $input_supplier->fertilizer_max_operational_margins = $request->input('fertilizer.max_operational_margins');
    //         $input_supplier->fertilizer_seasonal_quantum_unit = $request->input('fertilizer.seasonal_quantum_unit');

            
            
    //         // Assign nutrients details
    //         $input_supplier->nutrients_name = $request->input('nutrients.name');
    //         $input_supplier->nutrients_purchase_average_cost = $request->input('nutrients.purchase_average_cost');
    //         $input_supplier->nutrients_value_addition_average_cost = $request->input('nutrients.value_addition_average_cost');
    //         $input_supplier->nutrients_avrage_sale_price = $request->input('nutrients.avrage_sale_price');
    //         $input_supplier->nutrients_seasonal_quantum = $request->input('nutrients.seasonal_quantum');
    //         $input_supplier->nutrients_credit_extent = $request->input('nutrients.credit_extent');
    //         $input_supplier->nutrients_remark = $request->input('nutrients.remark');
    //         $input_supplier->nutrients_purchase_average_cost_unit = $request->input('nutrients.purchase_average_cost_unit');
    //         $input_supplier->nutrients_value_addition_average_cost_unit = $request->input('nutrients.value_addition_average_cost_unit');
    //         $input_supplier->nutrients_min_operational_margins = $request->input('nutrients.min_operational_margins');
    //         $input_supplier->nutrients_max_operational_margins = $request->input('nutrients.max_operational_margins');
    //         $input_supplier->nutrients_seasonal_quantum_unit = $request->input('nutrients.seasonal_quantum_unit');

        
    //          // Assign plant_protection details
    //         $input_supplier->plant_protection_name = $request->input('plant_protection.name');
    //         $input_supplier->plant_protection_purchase_average_cost = $request->input('plant_protection.purchase_average_cost');
    //         $input_supplier->plant_protection_value_addition_average_cost = $request->input('plant_protection.value_addition_average_cost');
    //         $input_supplier->plant_protection_avrage_sale_price = $request->input('plant_protection.avrage_sale_price');
    //         $input_supplier->plant_protection_seasonal_quantum = $request->input('plant_protection.seasonal_quantum');
    //         $input_supplier->plant_protection_credit_extent = $request->input('plant_protection.credit_extent');
    //         $input_supplier->plant_protection_remark = $request->input('plant_protection.remark');
    //         $input_supplier->plant_protection_purchase_average_cost_unit = $request->input('plant_protection.purchase_average_cost_unit');
    //         $input_supplier->plant_protection_value_addition_average_cost_unit = $request->input('plant_protection.value_addition_average_cost_unit');
    //         $input_supplier->plant_protection_min_operational_margins = $request->input('plant_protection.min_operational_margins');
    //         $input_supplier->plant_protection_max_operational_margins = $request->input('plant_protection.max_operational_margins');
    //         $input_supplier->plant_protection_seasonal_quantum_unit = $request->input('plant_protection.seasonal_quantum_unit');
            
    //         // Assign fm details
    //         $input_supplier->fm_name = $request->input('fm.name');
    //         $input_supplier->fm_purchase_average_cost = $request->input('fm.purchase_average_cost');
    //         $input_supplier->fm_value_addition_average_cost = $request->input('fm.value_addition_average_cost');
    //         $input_supplier->fm_avrage_sale_price = $request->input('fm.avrage_sale_price');
    //         $input_supplier->fm_seasonal_quantum = $request->input('fm.seasonal_quantum');
    //         $input_supplier->fm_credit_extent = $request->input('fm.credit_extent');
    //         $input_supplier->fm_remark = $request->input('fm.remark');
    //         $input_supplier->fm_purchase_average_cost_unit = $request->input('fm.purchase_average_cost_unit');
    //         $input_supplier->fm_value_addition_average_cost_unit = $request->input('fm.value_addition_average_cost_unit');
    //         $input_supplier->fm_min_operational_margins = $request->input('fm.min_operational_margins');
    //         $input_supplier->fm_max_operational_margins = $request->input('fm.max_operational_margins');
    //         $input_supplier->fm_seasonal_quantum_unit = $request->input('fm.seasonal_quantum_unit');
            
    //         // Assign fingerling details
    //         $input_supplier->fingerling_name = $request->input('fingerling.name');
    //         $input_supplier->fingerling_purchase_average_cost = $request->input('fingerling.purchase_average_cost');
    //         $input_supplier->fingerling_value_addition_average_cost = $request->input('fingerling.value_addition_average_cost');
    //         $input_supplier->fingerling_avrage_sale_price = $request->input('fingerling.avrage_sale_price');
    //         $input_supplier->fingerling_seasonal_quantum = $request->input('fingerling.seasonal_quantum');
    //         $input_supplier->fingerling_credit_extent = $request->input('fingerling.credit_extent');
    //         $input_supplier->fingerling_remark = $request->input('fingerling.remark');
    //         $input_supplier->fingerling_purchase_average_cost_unit = $request->input('fingerling.purchase_average_cost_unit');
    //         $input_supplier->fingerling_value_addition_average_cost_unit = $request->input('fingerling.value_addition_average_cost_unit');
    //         $input_supplier->fingerling_min_operational_margins = $request->input('fingerling.min_operational_margins');
    //         $input_supplier->fingerling_max_operational_margins = $request->input('fingerling.max_operational_margins');
    //         $input_supplier->fingerling_seasonal_quantum_unit = $request->input('fingerling.seasonal_quantum_unit');
            
    //         // Assign docs details
    //         $input_supplier->docs_name = $request->input('docs.name');
    //         $input_supplier->docs_purchase_average_cost = $request->input('docs.purchase_average_cost');
    //         $input_supplier->docs_value_addition_average_cost = $request->input('docs.value_addition_average_cost');
    //         $input_supplier->docs_avrage_sale_price = $request->input('docs.avrage_sale_price');
    //         $input_supplier->docs_seasonal_quantum = $request->input('docs.seasonal_quantum');
    //         $input_supplier->docs_credit_extent = $request->input('docs.credit_extent');
    //         $input_supplier->docs_remark = $request->input('docs.remark');
    //         $input_supplier->docs_purchase_average_cost_unit = $request->input('docs.purchase_average_cost_unit');
    //         $input_supplier->docs_value_addition_average_cost_unit = $request->input('docs.value_addition_average_cost_unit');
    //         $input_supplier->docs_min_operational_margins = $request->input('docs.min_operational_margins');
    //         $input_supplier->docs_max_operational_margins = $request->input('docs.max_operational_margins');
    //         $input_supplier->docs_seasonal_quantum_unit = $request->input('docs.seasonal_quantum_unit');
            
    //         // Assign plantlets details
    //         $input_supplier->plantlets_name = $request->input('plantlets.name');
    //         $input_supplier->plantlets_purchase_average_cost = $request->input('plantlets.purchase_average_cost');
    //         $input_supplier->plantlets_value_addition_average_cost = $request->input('plantlets.value_addition_average_cost');
    //         $input_supplier->plantlets_avrage_sale_price = $request->input('plantlets.avrage_sale_price');
    //         $input_supplier->plantlets_seasonal_quantum = $request->input('plantlets.seasonal_quantum');
    //         $input_supplier->plantlets_credit_extent = $request->input('plantlets.credit_extent');
    //         $input_supplier->plantlets_remark = $request->input('plantlets.remark');
    //         $input_supplier->plantlets_purchase_average_cost_unit = $request->input('plantlets.purchase_average_cost_unit');
    //         $input_supplier->plantlets_value_addition_average_cost_unit = $request->input('plantlets.value_addition_average_cost_unit');
    //         $input_supplier->plantlets_min_operational_margins = $request->input('plantlets.min_operational_margins');
    //         $input_supplier->plantlets_max_operational_margins = $request->input('plantlets.max_operational_margins');
    //         $input_supplier->plantlets_seasonal_quantum_unit = $request->input('plantlets.seasonal_quantum_unit');
            
    //         // Feeds Supply
    //         $input_supplier->feeds_supply_name = $request->input('feeds_supply.name');
    //         $input_supplier->feeds_supply_purchase_average_cost = $request->input('feeds_supply.purchase_average_cost');
    //         $input_supplier->feeds_supply_value_addition_average_cost = $request->input('feeds_supply.value_addition_average_cost');
    //         $input_supplier->feeds_supply_avrage_sale_price = $request->input('feeds_supply.avrage_sale_price');
    //         $input_supplier->feeds_supply_seasonal_quantum = $request->input('feeds_supply.seasonal_quantum');
    //         $input_supplier->feeds_supply_credit_extent = $request->input('feeds_supply.credit_extent');
    //         $input_supplier->feeds_supply_remark = $request->input('feeds_supply.remark');
    //         $input_supplier->feeds_supply_purchase_average_cost_unit = $request->input('feeds_supply.purchase_average_cost_unit');
    //         $input_supplier->feeds_supply_value_addition_average_cost_unit = $request->input('feeds_supply.value_addition_average_cost_unit');
    //         $input_supplier->feeds_supply_min_operational_margins = $request->input('feeds_supply.min_operational_margins');
    //         $input_supplier->feeds_supply_max_operational_margins = $request->input('feeds_supply.max_operational_margins');
    //         $input_supplier->feeds_supply_seasonal_quantum_unit = $request->input('feeds_supply.seasonal_quantum_unit');

        
    //         // Medicines
    //         $input_supplier->medicines_name = $request->input('medicines.name');
    //         $input_supplier->medicines_purchase_average_cost = $request->input('medicines.purchase_average_cost');
    //         $input_supplier->medicines_value_addition_average_cost = $request->input('medicines.value_addition_average_cost');
    //         $input_supplier->medicines_avrage_sale_price = $request->input('medicines.avrage_sale_price');
    //         $input_supplier->medicines_seasonal_quantum = $request->input('medicines.seasonal_quantum');
    //         $input_supplier->medicines_credit_extent = $request->input('medicines.credit_extent');
    //         $input_supplier->medicines_remark = $request->input('medicines.remark');
    //         $input_supplier->medicines_purchase_average_cost_unit = $request->input('medicines.purchase_average_cost_unit');
    //         $input_supplier->medicines_value_addition_average_cost_unit = $request->input('medicines.value_addition_average_cost_unit');
    //         $input_supplier->medicines_min_operational_margins = $request->input('medicines.min_operational_margins');
    //         $input_supplier->medicines_max_operational_margins = $request->input('medicines.max_operational_margins');
    //         $input_supplier->medicines_seasonal_quantum_unit = $request->input('medicines.seasonal_quantum_unit');
            
    //         // Consultancy
    //         $input_supplier->consultancy_name = $request->input('consultancy.name');
    //         $input_supplier->consultancy_purchase_average_cost = $request->input('consultancy.purchase_average_cost');
    //         $input_supplier->consultancy_value_addition_average_cost = $request->input('consultancy.value_addition_average_cost');
    //         $input_supplier->consultancy_avrage_sale_price = $request->input('consultancy.avrage_sale_price');
    //         $input_supplier->consultancy_seasonal_quantum = $request->input('consultancy.seasonal_quantum');
    //         $input_supplier->consultancy_credit_extent = $request->input('consultancy.credit_extent');
    //         $input_supplier->consultancy_remark = $request->input('consultancy.remark');
    //         $input_supplier->consultancy_purchase_average_cost_unit = $request->input('consultancy.purchase_average_cost_unit');
    //         $input_supplier->consultancy_value_addition_average_cost_unit = $request->input('consultancy.value_addition_average_cost_unit');
    //         $input_supplier->consultancy_min_operational_margins = $request->input('consultancy.min_operational_margins');
    //         $input_supplier->consultancy_max_operational_margins = $request->input('consultancy.max_operational_margins');
    //         $input_supplier->consultancy_seasonal_quantum_unit = $request->input('consultancy.seasonal_quantum_unit');
                
                
    //         // Indicative
    //         $input_supplier->indicativeI_parameter = $request->input('indicativeI.parameter');
    //         $input_supplier->indicativeI_remark = $request->input('indicativeI.remark');
            
    //         $input_supplier->indicativeII_parameter = $request->input('indicativeII.parameter');
    //         $input_supplier->indicativeII_remark = $request->input('indicativeII.remark');
            
    //         $input_supplier->indicativeIII_parameter = $request->input('indicativeIII.parameter');
    //         $input_supplier->indicativeIII_remark = $request->input('indicativeIII.remark');
            
    //         // Challenge
    //         $input_supplier->challengeI_parameter = $request->input('challengeI.parameter');
    //         $input_supplier->challengeI_remark = $request->input('challengeI.remark');
            
    //         $input_supplier->challengeII_parameter = $request->input('challengeII.parameter');
    //         $input_supplier->challengeII_remark = $request->input('challengeII.remark');
            
    //         $input_supplier->challengeIII_parameter = $request->input('challengeIII.parameter');
    //         $input_supplier->challengeIII_remark = $request->input('challengeIII.remark');
            
    //         $input_supplier->challengeIV_parameter = $request->input('challengeIV.parameter');
    //         $input_supplier->challengeIV_remark = $request->input('challengeIV.remark');
            
    //         // Risk
    //         $input_supplier->riskI_parameter = $request->input('riskI.parameter');
    //         $input_supplier->riskI_remark = $request->input('riskI.remark');
            
    //         $input_supplier->riskII_parameter = $request->input('riskII.parameter');
    //         $input_supplier->riskII_remark = $request->input('riskII.remark');
            
    //         $input_supplier->riskIII_parameter = $request->input('riskIII.parameter');
    //         $input_supplier->riskIII_remark = $request->input('riskIII.remark');
            
    //         $input_supplier->riskIV_parameter = $request->input('riskIV.parameter');
    //         $input_supplier->riskIV_remark = $request->input('riskIV.remark');
            
    //         $input_supplier->riskV_parameter = $request->input('riskV.parameter');
    //         $input_supplier->riskV_remark = $request->input('riskV.remark');
            
    //         $input_supplier->riskVI_parameter = $request->input('riskVI.parameter');
    //         $input_supplier->riskVI_remark = $request->input('riskVI.remark');
            
    //         // Prospect
    //         $input_supplier->prospectI_parameter = $request->input('prospectI.parameter');
    //         $input_supplier->prospectI_remark = $request->input('prospectI.remark');
            
    //         $input_supplier->prospectII_parameter = $request->input('prospectII.parameter');
    //         $input_supplier->prospectII_remark = $request->input('prospectII.remark');
            
    //         $input_supplier->prospectIII_parameter = $request->input('prospectIII.parameter');
    //         $input_supplier->prospectIII_remark = $request->input('prospectIII.remark');

    //         //dd($input_supplier);
    //         // Save the model
    //         $input_supplier->save();
            
    //         return response()->json([
    //             'status' => true,
    //             'message' => 'Input Supplier Data Created Successfully',
    //         ], 200);
    //     }
    //     catch (\Throwable $th) {
    //         return response()->json([
    //             'status' => false,
    //             'message' => $th->getMessage()
    //         ], 500);
    //     }
    // }
    
    
    public function input_upplier(Request $request)
    {
        
        if(isset($request->image))
          {
              
          if ($request->hasFile('image') && $request->file('image')->isValid()) 
            {
                $uploadedFile = $request->file('image');
            
                $targetDir = "uploads/"; // Change this to your desired local folder path
            
                // Ensure the target directory exists, create it if necessary
                if (!file_exists($targetDir)) {
                    mkdir($targetDir, 0755, true);
                }
            
                $targetFile = $targetDir . $uploadedFile->getClientOriginalName();
            
                // Move the uploaded file to the desired location
                if ($uploadedFile->move($targetDir, $targetFile)) {
                   
                } else {
                    echo "Sorry, there was an error uploading your file.";
                }
            } else {
                echo "Error: No valid file uploaded.";
            }
        }
          
         try{
            // dd($request->all());
            $validator = Validator::make($request->all(), [
                // 'infra_support.establishment_cost' => 'numeric',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'remark' => 'validation_error',
                    'status' => 'error',
                    'message' => ['error' => $validator->errors()],
                ]);
            }
            
            $input_supplier = new InputSupplier();
            
            $input_supplier->user_id = Auth::user()->id;
            
            $input_supplier->trader_info = json_encode($request->trader_info);
            
            $input_supplier->cost_of_establishment_of_input_shop_permanent = json_encode($request->cost_of_establishment_of_input_shop_permanent);
            
            $input_supplier->cost_of_establishment_of_input_shop_temporary = json_encode($request->cost_of_establishment_of_input_shop_temporary);
            
            $input_supplier->computer_electronic_assoceris = json_encode($request->computer_electronic_assoceris);
            
            $input_supplier->plant_machinary = json_encode($request->plant_machinary);
            $input_supplier->electric_moter = json_encode($request->electric_moter);
            $input_supplier->diseal_engine = json_encode($request->diseal_engine);
            $input_supplier->tractor = json_encode($request->tractor);
            
            $input_supplier->anull_int_on_capital_investment = json_encode($request->anull_int_on_capital_investment);
            

        	$input_supplier->storage_structure_of_input = json_encode($request->storage_structure_of_input);
        	
            $input_supplier->other_infrastructure_input	 = json_encode($request->other_infrastructure_input);	
            
            $input_supplier->monthly_expenses_on_electricity = json_encode($request->monthly_expenses_on_electricity);			
            $input_supplier->monthly_expenses_on_manpower = json_encode($request->monthly_expenses_on_manpower);			
            $input_supplier->monthly_rent = json_encode($request->monthly_rent);			
            $input_supplier->monthly_travelling_expense = json_encode($request->monthly_travelling_expense);			
            $input_supplier->any_other = json_encode($request->any_other);
            
            $input_supplier->annual_intt_on_working_capital = json_encode($request->annual_intt_on_working_capital);
            
            $input_supplier->percentage_of_input_on_credit_farmer = json_encode($request->percentage_of_input_on_credit_farmer);
            

            $input_supplier->duration_of_input_on_credit_farmer = json_encode($request->duration_of_input_on_credit_farmer);
            
           			
            $input_supplier->extent_of_credit_default = json_encode($request->extent_of_credit_default);
            
             $input_supplier->techincal_advisory	 = json_encode($request->techincal_advisory);
             $input_supplier->any_other_information	 = json_encode($request->any_other_information);
            
            $input_supplier->Issues_constraints_a = json_encode($request->issues_constraints_a);			
            $input_supplier->Issues_constraints_b = json_encode($request->issues_constraints_b);			
            $input_supplier->Issues_constraints_c = json_encode($request->issues_constraints_c);
            
            $input_supplier->challenges_a = json_encode($request->challenges_a);			
            $input_supplier->challenges_b = json_encode($request->challenges_b);			
            $input_supplier->challenges_c = json_encode($request->challenges_c);			
            $input_supplier->challenges_d = json_encode($request->challenges_d);
            
            $input_supplier->risk_a	 = json_encode($request->risk_a);	
            $input_supplier->risk_b	 = json_encode($request->risk_b);		
            $input_supplier->risk_c	 = json_encode($request->risk_c);	
            $input_supplier->risk_d	 = json_encode($request->risk_d);	
            $input_supplier->risk_e	 = json_encode($request->risk_e);		
            $input_supplier->risk_f	 = json_encode($request->risk_f);
            
            $input_supplier->prospects_a  = json_encode($request->prospects_a);			
            $input_supplier->prospects_b  = json_encode($request->prospects_b);			
            $input_supplier->prospects_c =  json_encode($request->prospects_b);	
            
            $input_supplier->seed = json_encode($request->seed);			
            $input_supplier->fertilizer	 = json_encode($request->fertilizer);		
            $input_supplier->nutrients = json_encode($request->nutrients);	
            
            $input_supplier->insecticide_pesticides_herbicides = json_encode($request->insecticide_pesticides_herbicides);
            
            $input_supplier->fm_custom_hiring_service  = json_encode($request->fm_custom_hiring_service);			
            $input_supplier->fingerling = json_encode($request->fingerling);			
            $input_supplier->poultry = json_encode($request->poultry);			
            $input_supplier->plantlets = json_encode($request->plantlets);			
            $input_supplier->feeds_supply = json_encode($request->feeds_supply);			
            $input_supplier->medicines = json_encode($request->medicines);			
            $input_supplier->consultancy = json_encode($request->consultancy);	
            // Save the model
            $input_supplier->save();
            
            return response()->json([
                'status' => true,
                'message' => 'Input Supplier Data Created Successfully',
            ], 200);
        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    
    public function caph_farm(Request $request)
    {
        if(isset($request->image))
        {
          
            if ($request->hasFile('image') && $request->file('image')->isValid()) {
                $uploadedFile = $request->file('image');
            
                $targetDir = "uploads/"; // Change this to your desired local folder path
            
                // Ensure the target directory exists, create it if necessary
                if (!file_exists($targetDir)) {
                    mkdir($targetDir, 0755, true);
                }
            
                $targetFile = $targetDir . $uploadedFile->getClientOriginalName();
            
                // Move the uploaded file to the desired location
                if ($uploadedFile->move($targetDir, $targetFile)) {
                   
                } else {
                    echo "Sorry, there was an error uploading your file.";
                }
            } else {
                echo "Error: No valid file uploaded.";
            }
        }
        
        try{
            $validator = Validator::make($request->all(), [
                // 'establishment_cost_shop' => 'numeric',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'remark' => 'validation_error',
                    'status' => 'error',
                    'message' => ['error' => $validator->errors()],
                ]);
            }
            
            
            $caph_farm = new CaphFarm();
            
            $caph_farm->user_id = Auth::user()->id;
            
            $caph_farm->value_mapping= $request->value_mapping;
            
            $caph_farm->commission_agent = json_encode($request->commision_agent);
            
            $caph_farm->cost_of_establishment_of_input_shop_permanent = json_encode($request->cost_of_establishment_of_input_shop_permanent);
            $caph_farm->cost_of_establishment_of_input_shop_temporary = json_encode($request->cost_of_establishment_of_input_shop_temporary);
            
        	$caph_farm->storage_structure_of_input = json_encode($request->storage_structure_of_input);		
            $caph_farm->other_infrastructure_input	 = json_encode($request->other_infrastructure_input);		
            $caph_farm->monthly_expenses_on_electricity = json_encode($request->monthly_expenses_on_electricity);			
            $caph_farm->monthly_expenses_on_manpower = json_encode($request->monthly_expenses_on_manpower);			
            $caph_farm->monthly_rent = json_encode($request->monthly_rent);			
            $caph_farm->monthly_travelling_expense = json_encode($request->monthly_travelling_expense);			
            $caph_farm->any_other = json_encode($request->any_other);			
            $caph_farm->annual_intt_on_capital_investment = json_encode($request->annual_intt_on_capital_investment);			
            $caph_farm->annual_intt_on_working_capital = json_encode($request->annual_intt_on_working_capital);
            
            $caph_farm->purchase_from_farmer_at_village = json_encode($request->purchase_from_farmer_at_village);	
            
            $caph_farm->local_mandi = json_encode($request->local_mandi);			
            $caph_farm->prevalent_purchase_mechanism = json_encode($request->prevalent_purchase_mechanism);			
            $caph_farm->duration_of_purchase_on_credit = json_encode($request->duration_of_purchase_on_credit);			
            $caph_farm->duration_sale_credit = json_encode($request->duration_sale_credit);		
            
            $caph_farm->input_advance_credit_producer = json_encode($request->input_advance_credit_producer);
            
            $caph_farm->any_other_information = json_encode($request->any_other_information);
            

            $caph_farm->averag_purchase_a = json_encode($request->average_purchase_a);			
            $caph_farm->averag_purchase_b = json_encode($request->average_purchase_b);			
            $caph_farm->averag_purchase_c = json_encode($request->average_purchase_c);		
            $caph_farm->averag_purchase_d = json_encode($request->average_purchase_d);		
            
            $caph_farm->Pre_harvesting_contractor_cost = json_encode($request->pre_harvesting_contractor_cost);			
            $caph_farm->harvesting_cost = json_encode($request->harvesting_cost);			
            $caph_farm->transportation_cost = json_encode($request->transportation_cost);
            
            $caph_farm->loading_and_unloading_charges = json_encode($request->loading_and_unloading_charges);			
            $caph_farm->primary_processing_cost = json_encode($request->primary_processing_cost);			
            $caph_farm->drying_loss_or_any_other_loss = json_encode($request->drying_loss_or_any_other_loss);			
            $caph_farm->mandi_fees = json_encode($request->mandi_fees);			
            $caph_farm->packaging_expenses = json_encode($request->packaging_expenses);			
            $caph_farm->any_other_marketing_cost = json_encode($request->any_other_marketing_cost);
            
            $caph_farm->selling_price_a = json_encode($request->selling_price_a);			
            $caph_farm->selling_price_b = json_encode($request->selling_price_b);			
            $caph_farm->selling_price_c = json_encode($request->selling_price_c);			
            $caph_farm->selling_price_d = json_encode($request->selling_price_d);	
            
            $caph_farm->quantum_handled_year = json_encode($request->quantum_handled_year);			
            $caph_farm->purchase_selling_prices_fluctuation = json_encode($request->purchase_selling_prices_fluctuation);
            
            $caph_farm->issues_constraints_a = json_encode($request->issues_constraints_a);			
            $caph_farm->issues_constraints_b = json_encode($request->issues_constraints_b);			
            $caph_farm->issues_constraints_c = json_encode($request->issues_constraints_c);
            
            $caph_farm->challenges_a = json_encode($request->challenges_a);			
            $caph_farm->challenges_b = json_encode($request->challenges_b);			
            $caph_farm->challenges_c = json_encode($request->challenges_c);			

            $caph_farm->risk_a	 = json_encode($request->risk_a);	
            $caph_farm->risk_b	 = json_encode($request->risk_b);		
            $caph_farm->rsk_c	 = json_encode($request->risk_c);	
           		    
            $caph_farm->prospects_a  = json_encode($request->prospects_a);			
            $caph_farm->prospects_b  = json_encode($request->prospects_b);			
            $caph_farm->prospects_c = json_encode($request->prospects_b);	
            
  	
            // Save the model
            $caph_farm->save();
            
            return response()->json([
                'status' => true,
                'message' => 'Input Supplier Data Created Successfully',
            ], 200);
        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
   
    // old query
    // public function caph_farm(Request $request)
    // {
        
    //         if(isset($request->image))
    //         {
              
    //             if ($request->hasFile('image') && $request->file('image')->isValid()) {
    //                 $uploadedFile = $request->file('image');
                
    //                 $targetDir = "uploads/"; // Change this to your desired local folder path
                
    //                 // Ensure the target directory exists, create it if necessary
    //                 if (!file_exists($targetDir)) {
    //                     mkdir($targetDir, 0755, true);
    //                 }
                
    //                 $targetFile = $targetDir . $uploadedFile->getClientOriginalName();
                
    //                 // Move the uploaded file to the desired location
    //                 if ($uploadedFile->move($targetDir, $targetFile)) {
                       
    //                 } else {
    //                     echo "Sorry, there was an error uploading your file.";
    //                 }
    //             } else {
    //                 echo "Error: No valid file uploaded.";
    //             }
    //         }
          
    //     try{
    //         // dd($request->all());
    //         $validator = Validator::make($request->all(), [
    //             // 'agent.name' => 'string',
    //             // 'agent.mobile' => 'string',
    //             // 'agent.district' => 'string',
    //             // 'agent.block' => 'string',
            
    //             // 'infra_support.establishment_cost' => 'numeric',
    //             // 'infra_support.electricity_monthly_expense' => 'numeric',
    //             // 'infra_support.manpower_monthly_expense' => 'numeric',
    //             // 'infra_support.rent_monthly' => 'numeric',
    //             // 'infra_support.travelling_monthly' => 'numeric',
    //             // 'infra_support.other_expense' => 'numeric',
    //             // 'infra_support.interest_annual' => 'numeric',
    //             // 'infra_support.village_purchase' => 'string',
    //             // 'infra_support.local_mandi_purchase' => 'string',
    //             // 'infra_support.prevalent_purchase_mechanism' => 'string',
    //             // 'infra_support.purchase_credit_duration' => 'numeric',
    //             // 'infra_support.sale_credit_duration' => 'numeric',
    //             // 'infra_support.advance_credit' => 'numeric',
    //             // 'infra_support.other_info' => 'string',
                
    //             // 'average_purchase_price.gradeA.product_name' => 'string',
    //             // 'average_purchase_price.gradeA.unit_quantity' => 'string',
    //             // 'average_purchase_price.gradeA.average_rate' => 'numeric',
    //             // 'average_purchase_price.gradeA.min_max_variation' => 'string',
    //             // 'average_purchase_price.gradeA.remarks' => 'string',
            
    //             // 'average_purchase_price.gradeB.product_name' => 'string',
    //             // 'average_purchase_price.gradeB.unit_quantity' => 'string',
    //             // 'average_purchase_price.gradeB.average_rate' => 'numeric',
    //             // 'average_purchase_price.gradeB.min_max_variation' => 'string',
    //             // 'average_purchase_price.gradeB.remarks' => 'string',
            
    //             // 'average_purchase_price.gradeC.product_name' => 'string',
    //             // 'average_purchase_price.gradeC.unit_quantity' => 'string',
    //             // 'average_purchase_price.gradeC.average_rate' => 'numeric',
    //             // 'average_purchase_price.gradeC.min_max_variation' => 'string',
    //             // 'average_purchase_price.gradeC.remarks' => 'string',
            
    //             // 'average_purchase_price.gradeD.product_name' => 'string',
    //             // 'average_purchase_price.gradeD.unit_quantity' => 'string',
    //             // 'average_purchase_price.gradeD.average_rate' => 'numeric',
    //             // 'average_purchase_price.gradeD.min_max_variation' => 'string',
    //             // 'average_purchase_price.gradeD.remarks' => 'string',
                
    //             // 'value_addition_cost.transportation_cost.product_name' => 'string',
    //             // 'value_addition_cost.transportation_cost.unit_quantity' => 'string',
    //             // 'value_addition_cost.transportation_cost.average_rate' => 'numeric',
    //             // 'value_addition_cost.transportation_cost.min_max_variation' => 'string',
    //             // 'value_addition_cost.transportation_cost.remarks' => 'string',
    //             // 'value_addition_cost.loading_unloading_cost.product_name' => 'string',
    //             // 'value_addition_cost.loading_unloading_cost.unit_quantity' => 'string',
    //             // 'value_addition_cost.loading_unloading_cost.average_rate' => 'numeric',
    //             // 'value_addition_cost.loading_unloading_cost.min_max_variation' => 'string',
    //             // 'value_addition_cost.loading_unloading_cost.remarks' => 'string',
    //             // 'value_addition_cost.primary_processing_cost.product_name' => 'string',
    //             // 'value_addition_cost.primary_processing_cost.unit_quantity' => 'string',
    //             // 'value_addition_cost.primary_processing_cost.average_rate' => 'numeric',
    //             // 'value_addition_cost.primary_processing_cost.min_max_variation' => 'string',
    //             // 'value_addition_cost.primary_processing_cost.remarks' => 'string',
    //             // 'value_addition_cost.dry_other_loss.product_name' => 'string',
    //             // 'value_addition_cost.dry_other_loss.unit_quantity' => 'string',
    //             // 'value_addition_cost.dry_other_loss.average_rate' => 'numeric',
    //             // 'value_addition_cost.dry_other_loss.min_max_variation' => 'string',
    //             // 'value_addition_cost.dry_other_loss.remarks' => 'string',
            
    //             // 'value_addition_cost.marketing_cost.product_name' => 'string',
    //             // 'value_addition_cost.marketing_cost.unit_quantity' => 'string',
    //             // 'value_addition_cost.marketing_cost.average_rate' => 'numeric',
    //             // 'value_addition_cost.marketing_cost.min_max_variation' => 'string',
    //             // 'value_addition_cost.marketing_cost.remarks' => 'string',
    //             // 'value_addition_cost.storage_cost.product_name' => 'string',
    //             // 'value_addition_cost.storage_cost.unit_quantity' => 'string',
    //             // 'value_addition_cost.storage_cost.average_rate' => 'numeric',
    //             // 'value_addition_cost.storage_cost.min_max_variation' => 'string',
    //             // 'value_addition_cost.storage_cost.remarks' => 'string',
    //             // 'value_addition_cost.other_cost.product_name' => 'string',
    //             // 'value_addition_cost.other_cost.unit_quantity' => 'string',
    //             // 'value_addition_cost.other_cost.average_rate' => 'numeric',
    //             // 'value_addition_cost.other_cost.min_max_variation' => 'string',
    //             // 'value_addition_cost.other_cost.remarks' => 'string',
            
    //             // 'selling_price.gradeA.product_name' => 'string',
    //             // 'selling_price.gradeA.unit_quantity' => 'string',
    //             // 'selling_price.gradeA.average_rate' => 'numeric',
    //             // 'selling_price.gradeA.min_max_variation' => 'string',
    //             // 'selling_price.gradeA.remarks' => 'string',
            
    //             // 'selling_price.gradeB.product_name' => 'string',
    //             // 'selling_price.gradeB.unit_quantity' => 'string',
    //             // 'selling_price.gradeB.average_rate' => 'numeric',
    //             // 'selling_price.gradeB.min_max_variation' => 'string',
    //             // 'selling_price.gradeB.remarks' => 'string',
            
    //             // 'selling_price.gradeC.product_name' => 'string',
    //             // 'selling_price.gradeC.unit_quantity' => 'string',
    //             // 'selling_price.gradeC.average_rate' => 'numeric',
    //             // 'selling_price.gradeC.min_max_variation' => 'string',
    //             // 'selling_price.gradeC.remarks' => 'string',
            
    //             // 'selling_price.gradeD.product_name' => 'string',
    //             // 'selling_price.gradeD.unit_quantity' => 'string',
    //             // 'selling_price.gradeD.average_rate' => 'numeric',
    //             // 'selling_price.gradeD.min_max_variation' => 'string',
    //             // 'selling_price.gradeD.remarks' => 'string',
                
    //             // 'other_cost_parameter.quantum_handled.product_name' => 'string',
    //             // 'other_cost_parameter.quantum_handled.unit_quantity' => 'string',
    //             // 'other_cost_parameter.quantum_handled.average_rate' => 'numeric',
    //             // 'other_cost_parameter.quantum_handled.min_max_variation' => 'string',
    //             // 'other_cost_parameter.quantum_handled.remarks' => 'string',
    //             // 'other_cost_parameter.price_fluctuations.product_name' => 'string',
    //             // 'other_cost_parameter.price_fluctuations.unit_quantity' => 'string',
    //             // 'other_cost_parameter.price_fluctuations.average_rate' => 'numeric',
    //             // 'other_cost_parameter.price_fluctuations.min_max_variation' => 'string',
    //             // 'other_cost_parameter.price_fluctuations.remarks' => 'string',
            
    //             // 'indicativeI.parameter' => 'string',
    //             // 'indicativeI.remark' => 'string',
            
    //             // 'indicativeII.parameter' => 'string',
    //             // 'indicativeII.remark' => 'string',
            
    //             // 'indicativeIII.parameter' => 'string',
    //             // 'indicativeIII.remark' => 'string',
            
    //             // 'challengeI.parameter' => 'string',
    //             // 'challengeI.remark' => 'string',
            
    //             // 'challengeII.parameter' => 'string',
    //             // 'challengeII.remark' => 'string',
            
    //             // 'challengeIII.parameter' => 'string',
    //             // 'challengeIII.remark' => 'string',
                
    //             //  'riskI.parameter' => 'string',
    //             // 'riskI.remark' => 'string',
            
    //             // 'riskII.parameter' => 'string',
    //             // 'riskII.remark' => 'string',
            
    //             // 'riskIII.parameter' => 'string',
    //             // 'riskIII.remark' => 'string',
            
    //             // 'prospectI.parameter' => 'string',
    //             // 'prospectI.remark' => 'string',
            
    //             // 'prospectII.parameter' => 'string',
    //             // 'prospectII.remark' => 'string',
            
    //             // 'prospectIII.parameter' => 'string',
    //             // 'prospectIII.remark' => 'string',
            
               
    //         ]);

    //         if ($validator->fails()) {
    //             return response()->json([
    //                 'remark' => 'validation_error',
    //                 'status' => 'error',
    //                 'message' => ['error' => $validator->errors()],
    //             ]);
    //         }
            
            
    //             $caph_farm = new CaphFarm();
              
    //             $caph_farm->user_id = Auth::user()->id;
                
    //           // Assign agent details
    //             $caph_farm->agent_name = $request->input('agent.name');
    //             $caph_farm->agent_mobile = $request->input('agent.mobile');
    //             $caph_farm->agent_district = $request->input('agent.district');
    //             $caph_farm->agent_block = $request->input('agent.block');
    //             $caph_farm->image = $request->input('agent.image');
                
               
    //             $caph_farm->electricity_monthly_expense = $request->input('infra_support.electricity_monthly_expense');
                
    //             $caph_farm->manpower_monthly_expense = $request->input('infra_support.manpower_monthly_expense');
    //             $caph_farm->rent_monthly = $request->input('infra_support.rent_monthly');
    //             $caph_farm->travelling_monthly = $request->input('infra_support.travelling_monthly');
    //             $caph_farm->other_expense = $request->input('infra_support.other_expense');
    //             $caph_farm->interest_annual = $request->input('infra_support.interest_annual');
    //             $caph_farm->village_purchase = $request->input('infra_support.village_purchase');
    //             $caph_farm->local_mandi_purchase = $request->input('infra_support.local_mandi_purchase');
    //             $caph_farm->prevalent_purchase_mechanism = $request->input('infra_support.prevalent_purchase_mechanism');
    //             $caph_farm->purchase_credit_duration = $request->input('infra_support.purchase_credit_duration');
    //             $caph_farm->sale_credit_duration = $request->input('infra_support.sale_credit_duration');
    //             $caph_farm->advance_credit = $request->input('infra_support.advance_credit');
    //             $caph_farm->other_info = $request->input('infra_support.other_info');
    //             $caph_farm->establishment_cost_unit = $request->input('infra_support.establishment_cost_unit');
    //             $caph_farm->electricity_expense_unit = $request->input('infra_support.electricity_expense_unit');
    //             $caph_farm->travelling_unit = $request->input('infra_support.travelling_unit');
                
    //             // Assign average_purchase_price details for gradeA
    //             $caph_farm->gradeA_product_name = $request->input('average_purchase_price.gradeA.product_name');
    //             $caph_farm->gradeA_unit_quantity = $request->input('average_purchase_price.gradeA.unit_quantity');
    //             $caph_farm->gradeA_average_rate = $request->input('average_purchase_price.gradeA.average_rate');
    //             $caph_farm->gradeA_remarks = $request->input('average_purchase_price.gradeA.remarks');
    //             $caph_farm->gradeA_unit = $request->input('average_purchase_price.gradeA.unit');
    //             $caph_farm->gradeA_min_variation = $request->input('average_purchase_price.gradeA.min_variation');
    //             $caph_farm->gradeA_max_variation = $request->input('average_purchase_price.gradeA.max_variation');

                
    //             // Assign average_purchase_price details for gradeB
    //             $caph_farm->gradeB_product_name = $request->input('average_purchase_price.gradeB.product_name');
    //             $caph_farm->gradeB_unit_quantity = $request->input('average_purchase_price.gradeB.unit_quantity');
    //             $caph_farm->gradeB_average_rate = $request->input('average_purchase_price.gradeB.average_rate');
    //             $caph_farm->gradeB_remarks = $request->input('average_purchase_price.gradeB.remarks');
    //             $caph_farm->gradeB_unit = $request->input('average_purchase_price.gradeB.unit');
    //             $caph_farm->gradeB_min_variation = $request->input('average_purchase_price.gradeB.min_variation');
    //             $caph_farm->gradeB_max_variation = $request->input('average_purchase_price.gradeB.max_variation');

                
    //             // Assign average_purchase_price details for gradeC
    //             $caph_farm->gradeC_product_name = $request->input('average_purchase_price.gradeC.product_name');
    //             $caph_farm->gradeC_unit_quantity = $request->input('average_purchase_price.gradeC.unit_quantity');
    //             $caph_farm->gradeC_average_rate = $request->input('average_purchase_price.gradeC.average_rate');
    //             $caph_farm->gradeC_remarks = $request->input('average_purchase_price.gradeC.remarks');
    //             $caph_farm->gradeC_unit = $request->input('average_purchase_price.gradeC.unit');
    //             $caph_farm->gradeC_min_variation = $request->input('average_purchase_price.gradeC.min_variation');
    //             $caph_farm->gradeC_max_variation = $request->input('average_purchase_price.gradeC.max_variation');

                
    //             // Assign average_purchase_price details for gradeD
    //             $caph_farm->gradeD_product_name = $request->input('average_purchase_price.gradeD.product_name');
    //             $caph_farm->gradeD_unit_quantity = $request->input('average_purchase_price.gradeD.unit_quantity');
    //             $caph_farm->gradeD_average_rate = $request->input('average_purchase_price.gradeD.average_rate');
    //             $caph_farm->gradeD_remarks = $request->input('average_purchase_price.gradeD.remarks');
    //             $caph_farm->gradeD_unit = $request->input('average_purchase_price.gradeD.unit');
    //             $caph_farm->gradeD_min_variation = $request->input('average_purchase_price.gradeD.min_variation');
    //             $caph_farm->gradeD_max_variation = $request->input('average_purchase_price.gradeD.max_variation');
                
                
    //             // Assign average_purchase_price details for gradeE
    //             $caph_farm->gradeE_product_name = $request->input('average_purchase_price.gradeE.product_name');
    //             $caph_farm->gradeE_unit_quantity = $request->input('average_purchase_price.gradeE.unit_quantity');
    //             $caph_farm->gradeE_average_rate = $request->input('average_purchase_price.gradeE.average_rate');
    //             $caph_farm->gradeE_remarks = $request->input('average_purchase_price.gradeE.remarks');
    //             $caph_farm->gradeE_unit = $request->input('average_purchase_price.gradeE.unit');
    //             $caph_farm->gradeE_min_variation = $request->input('average_purchase_price.gradeE.min_variation');
    //             $caph_farm->gradeE_max_variation = $request->input('average_purchase_price.gradeE.max_variation');

                
    //             // Assign average_purchase_price details for gradeF
    //             $caph_farm->gradeF_product_name = $request->input('average_purchase_price.gradeF.product_name');
    //             $caph_farm->gradeF_unit_quantity = $request->input('average_purchase_price.gradeF.unit_quantity');
    //             $caph_farm->gradeF_average_rate = $request->input('average_purchase_price.gradeF.average_rate');
    //             $caph_farm->gradeF_remarks = $request->input('average_purchase_price.gradeF.remarks');
    //             $caph_farm->gradeF_unit = $request->input('average_purchase_price.gradeF.unit');
    //             $caph_farm->gradeF_min_variation = $request->input('average_purchase_price.gradeF.min_variation');
    //             $caph_farm->gradeF_max_variation = $request->input('average_purchase_price.gradeF.max_variation');

                
    //             // Assign average_purchase_price details for gradeG
    //             $caph_farm->gradeG_product_name = $request->input('average_purchase_price.gradeG.product_name');
    //             $caph_farm->gradeG_unit_quantity = $request->input('average_purchase_price.gradeG.unit_quantity');
    //             $caph_farm->gradeG_average_rate = $request->input('average_purchase_price.gradeG.average_rate');
    //             $caph_farm->gradeG_remarks = $request->input('average_purchase_price.gradeG.remarks');
    //             $caph_farm->gradeG_unit = $request->input('average_purchase_price.gradeG.unit');
    //             $caph_farm->gradeG_min_variation = $request->input('average_purchase_price.gradeG.min_variation');
    //             $caph_farm->gradeG_max_variation = $request->input('average_purchase_price.gradeG.max_variation');

                
    //             // Assign average_purchase_price details for gradeH
    //             $caph_farm->gradeH_product_name = $request->input('average_purchase_price.gradeH.product_name');
    //             $caph_farm->gradeH_unit_quantity = $request->input('average_purchase_price.gradeH.unit_quantity');
    //             $caph_farm->gradeH_average_rate = $request->input('average_purchase_price.gradeH.average_rate');
    //             $caph_farm->gradeH_remarks = $request->input('average_purchase_price.gradeH.remarks');
    //             $caph_farm->gradeH_unit = $request->input('average_purchase_price.gradeH.unit');
    //             $caph_farm->gradeH_min_variation = $request->input('average_purchase_price.gradeH.min_variation');
    //             $caph_farm->gradeH_max_variation = $request->input('average_purchase_price.gradeH.max_variation');

    //           // Assign value_addition_cost details
                       
                        
    //                     $caph_farm->transportation_product_name = $request->input('value_addition_cost.transportation_cost.product_name');
    //                     $caph_farm->transportation_unit_quantity = $request->input('value_addition_cost.transportation_cost.unit_quantity');
    //                     $caph_farm->transportation_average_rate = $request->input('value_addition_cost.transportation_cost.average_rate');
    //                     $caph_farm->transportation_min_max_variation = $request->input('value_addition_cost.transportation_cost.min_max_variation');
    //                     $caph_farm->transportation_remarks = $request->input('value_addition_cost.transportation_cost.remarks');
                        
    //                     $caph_farm->luc_product_name = $request->input('value_addition_cost.loading_unloading_cost.product_name');
    //                     $caph_farm->luc_unit_quantity = $request->input('value_addition_cost.loading_unloading_cost.unit_quantity');
    //                     $caph_farm->luc_average_rate = $request->input('value_addition_cost.loading_unloading_cost.average_rate');
    //                     $caph_farm->luc_min_max_variation = $request->input('value_addition_cost.loading_unloading_cost.min_max_variation');
    //                     $caph_farm->luc_remarks = $request->input('value_addition_cost.loading_unloading_cost.remarks');
                        
    //                      $caph_farm->ppc_product_name = $request->input('value_addition_cost.primary_processing_cost.product_name');
    //                     $caph_farm->ppc_unit_quantity = $request->input('value_addition_cost.primary_processing_cost.unit_quantity');
    //                     $caph_farm->ppc_average_rate = $request->input('value_addition_cost.primary_processing_cost.average_rate');
    //                     $caph_farm->ppc_min_max_variation = $request->input('value_addition_cost.primary_processing_cost.min_max_variation');
    //                     $caph_farm->ppc_remarks = $request->input('value_addition_cost.primary_processing_cost.remarks');
                        
    //                      $caph_farm->dol_product_name = $request->input('value_addition_cost.dry_other_loss.product_name');
    //                     $caph_farm->dol_unit_quantity = $request->input('value_addition_cost.dry_other_loss.unit_quantity');
    //                     $caph_farm->dol_average_rate = $request->input('value_addition_cost.dry_other_loss.average_rate');
    //                     $caph_farm->dol_min_max_variation = $request->input('value_addition_cost.dry_other_loss.min_max_variation');
    //                     $caph_farm->dol_remarks = $request->input('value_addition_cost.dry_other_loss.remarks');
                        
                       
                        
    //                      $caph_farm->m_product_name = $request->input('value_addition_cost.marketing_cost.product_name');
    //                     $caph_farm->m_unit_quantity = $request->input('value_addition_cost.marketing_cost.unit_quantity');
    //                     $caph_farm->m_average_rate = $request->input('value_addition_cost.marketing_cost.average_rate');
    //                     $caph_farm->m_min_max_variation = $request->input('value_addition_cost.marketing_cost.min_max_variation');
    //                     $caph_farm->m_remarks = $request->input('value_addition_cost.marketing_cost.remarks');
                        
                        
    //                      $caph_farm->mandi_product_name = $request->input('value_addition_cost.mandi_fee.product_name');
    //                     $caph_farm->mandi_unit_quantity = $request->input('value_addition_cost.mandi_fee.unit_quantity');
    //                     $caph_farm->mandi_average_rate = $request->input('value_addition_cost.mandi_fee.average_rate');
    //                     $caph_farm->mandi_min_max_variation = $request->input('value_addition_cost.mandi_fee.min_max_variation');
    //                     $caph_farm->mandi_remarks = $request->input('value_addition_cost.mandi_fee.remarks');
                        
                        
                        
    //                      $caph_farm->pe_product_name = $request->input('value_addition_cost.packaging_expense.product_name');
    //                     $caph_farm->pe_unit_quantity = $request->input('value_addition_cost.packaging_expense.unit_quantity');
    //                     $caph_farm->pe_average_rate = $request->input('value_addition_cost.packaging_expense.average_rate');
    //                     $caph_farm->pe_min_max_variation = $request->input('value_addition_cost.packaging_expense.min_max_variation');
    //                     $caph_farm->pe_remarks = $request->input('value_addition_cost.packaging_expense.remarks');
                        
                      


                        
    //                     // Assign selling_price details for gradeA
    //                     $caph_farm->selling_gradeA_product_name = $request->input('selling_price.gradeA.product_name');
    //                     $caph_farm->selling_gradeA_unit_quantity = $request->input('selling_price.gradeA.unit_quantity');
    //                     $caph_farm->selling_gradeA_average_rate = $request->input('selling_price.gradeA.average_rate');
    //                     $caph_farm->selling_gradeA_min_max_variation = $request->input('selling_price.gradeA.min_max_variation');
    //                     $caph_farm->selling_gradeA_remarks = $request->input('selling_price.gradeA.remarks');
                        
    //                     // Assign selling_price details for gradeB
    //                     $caph_farm->selling_gradeB_product_name = $request->input('selling_price.gradeB.product_name');
    //                     $caph_farm->selling_gradeB_unit_quantity = $request->input('selling_price.gradeB.unit_quantity');
    //                     $caph_farm->selling_gradeB_average_rate = $request->input('selling_price.gradeB.average_rate');
    //                     $caph_farm->selling_gradeB_min_max_variation = $request->input('selling_price.gradeB.min_max_variation');
    //                     $caph_farm->selling_gradeB_remarks = $request->input('selling_price.gradeB.remarks');
                        
    //                     // Assign selling_price details for gradeC
    //                     $caph_farm->selling_gradeC_product_name = $request->input('selling_price.gradeC.product_name');
    //                     $caph_farm->selling_gradeC_unit_quantity = $request->input('selling_price.gradeC.unit_quantity');
    //                     $caph_farm->selling_gradeC_average_rate = $request->input('selling_price.gradeC.average_rate');
    //                     $caph_farm->selling_gradeC_min_max_variation = $request->input('selling_price.gradeC.min_max_variation');
    //                     $caph_farm->selling_gradeC_remarks = $request->input('selling_price.gradeC.remarks');
                        
    //                     // Assign selling_price details for gradeD
    //                     $caph_farm->selling_gradeD_product_name = $request->input('selling_price.gradeD.product_name');
    //                     $caph_farm->selling_gradeD_unit_quantity = $request->input('selling_price.gradeD.unit_quantity');
    //                     $caph_farm->selling_gradeD_average_rate = $request->input('selling_price.gradeD.average_rate');
    //                     $caph_farm->selling_gradeD_min_max_variation = $request->input('selling_price.gradeD.min_max_variation');
    //                     $caph_farm->selling_gradeD_remarks = $request->input('selling_price.gradeD.remarks');
                        
                        
    //                     $caph_farm->product_quantum_handled = $request->input('other_cost_parameter.quantum_handled');
    //                     $caph_farm->product_unit_quantity_quantum = $request->input('other_cost_parameter.quantum_handled_unit');
    //                     $caph_farm->product_price_fluctuations = $request->input('other_cost_parameter.price_fluctuations');
                    
                        
    //                     // Assign indicative details
    //                     $caph_farm->indicativeI_parameter = $request->input('indicativeI.parameter');
    //                     $caph_farm->indicativeI_remark = $request->input('indicativeI.remark');
                        
    //                     $caph_farm->indicativeII_parameter = $request->input('indicativeII.parameter');
    //                     $caph_farm->indicativeII_remark = $request->input('indicativeII.remark');
                        
    //                     $caph_farm->indicativeIII_parameter = $request->input('indicativeIII.parameter');
    //                     $caph_farm->indicativeIII_remark = $request->input('indicativeIII.remark');
                        
    //                     // Assign challenge details
    //                     $caph_farm->challengeI_parameter = $request->input('challengeI.parameter');
    //                     $caph_farm->challengeI_remark = $request->input('challengeI.remark');
                        
    //                     $caph_farm->challengeII_parameter = $request->input('challengeII.parameter');
    //                     $caph_farm->challengeII_remark = $request->input('challengeII.remark');
                        
    //                     $caph_farm->challengeIII_parameter = $request->input('challengeIII.parameter');
    //                     $caph_farm->challengeIII_remark = $request->input('challengeIII.remark');
                        
    //                     // Assign risk details
    //                     $caph_farm->riskI_parameter = $request->input('riskI.parameter');
    //                     $caph_farm->riskI_remark = $request->input('riskI.remark');
                        
    //                     $caph_farm->riskII_parameter = $request->input('riskII.parameter');
    //                     $caph_farm->riskII_remark = $request->input('riskII.remark');
                        
    //                     $caph_farm->riskIII_parameter = $request->input('riskIII.parameter');
    //                     $caph_farm->riskIII_remark = $request->input('riskIII.remark');
                        
    //                     // Assign prospect details
    //                     $caph_farm->prospectI_parameter = $request->input('prospectI.parameter');
    //                     $caph_farm->prospectI_remark = $request->input('prospectI.remark');
                        
    //                     $caph_farm->prospectII_parameter = $request->input('prospectII.parameter');
    //                     $caph_farm->prospectII_remark = $request->input('prospectII.remark');
                        
    //                     $caph_farm->prospectIII_parameter = $request->input('prospectIII.parameter');
    //                     $caph_farm->prospectIII_remark = $request->input('prospectIII.remark');


    //                 //   dd($caph_farm);
    //             // Save the model
    //             $caph_farm->save();

              
              
    //             return response()->json([
    //             'status' => true,
    //             'message' => 'CaphFarm Data Created Successfully',
    //         ], 200);
    //     }
    //      catch (\Throwable $th) {
    //         return response()->json([
    //             'status' => false,
    //             'message' => $th->getMessage()
    //         ], 500);
    //      }
    // }
    
    
    public function trd_farm(Request $request)
    {
        
        try{
            $validator = Validator::make($request->all(), [
                // 'establishment_cost_shop' => 'numeric',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'remark' => 'validation_error',
                    'status' => 'error',
                    'message' => ['error' => $validator->errors()],
                ]);
            }
            
            
             $trd_farm = new TrdFarm();
            
             $trd_farm->user_id = Auth::user()->id;
            
        	 $trd_farm->traders_info = json_encode($request->traders_info);
        	
        	 $trd_farm->cost_of_establishment_permanent = json_encode($request->cost_of_establishment_permanent);
        	 $trd_farm->cost_of_establishment_temporary = json_encode($request->cost_of_establishment_temporary);
        	
             $trd_farm->establishment_cost = json_encode($request->establishment_cost);
             $trd_farm->storage_structure_for_procurement = json_encode($request->storage_structure_for_procurement);
             $trd_farm->monthly_expenses_on_electricity = json_encode($request->monthly_expenses_on_electricity);
             $trd_farm->monthly_expenses_on_manpower = json_encode($request->monthly_expenses_on_manpower);
             $trd_farm->monthly_rent = json_encode($request->monthly_rent);
            
             $trd_farm->monthly_travelling_expense = json_encode($request->monthly_travelling_expense);
            
             $trd_farm->annual_Interest_cost_on_capital = json_encode($request->annual_Interest_cost_on_capital);
             $trd_farm->any_other_fix_cost = json_encode($request->any_other_fix_cost);
             $trd_farm->annual_intt_cost_on_working_capital = json_encode($request->annual_intt_cost_on_working_capital);
             $trd_farm->purchase_from_farmer_at_village = json_encode($request->purchase_from_farmer_at_village);
             
             $trd_farm->farmer_local_mandi = json_encode($request->farmer_local_mandi);
             $trd_farm->commission_agent = json_encode($request->commission_agent);
             $trd_farm->any_other_channel = json_encode($request->any_other_channel);
             $trd_farm->most_prevalent_purchase_mechanism = json_encode($request->most_prevalent_purchase_mechanism);
             $trd_farm->duration_of_purchase_on_credit = json_encode($request->duration_of_sale_on_credit);
             $trd_farm->advance_credit_to_producer = json_encode($request->advance_credit_to_producer);
             
            $trd_farm->any_other_infor = json_encode($request->any_other_infor);
            
            $trd_farm->average_purchase_a = json_encode($request->average_purchase_a);
            $trd_farm->average_purchase_b = json_encode($request->average_purchase_b);
            $trd_farm->average_purchase_c = json_encode($request->average_purchase_c);
            $trd_farm->average_purchase_d = json_encode($request->average_purchase_d);
            
            $trd_farm->harvesting_cost = json_encode($request->harvesting_cost);
            $trd_farm->transportation_cost = json_encode($request->transportation_cost);
            $trd_farm->loading_and_unloading_charges = json_encode($request->loading_and_unloading_charges);
            $trd_farm->primary_processing_cost = json_encode($request->primary_processing_cost);
            $trd_farm->drying_Loss_any_other_loss = json_encode($request->drying_Loss_any_other_loss);
            $trd_farm->value_establishment_cost = json_encode($request->value_establishment_cost);
            $trd_farm->marketing_cost = json_encode($request->marketing_cost);
            $trd_farm->storage_cost = json_encode($request->storage_cost);
            
            $trd_farm->any_other_cost = json_encode($request->any_other_cost);
            
            $trd_farm->selling_price_a = json_encode($request->selling_price_a);
            $trd_farm->selling_price_b = json_encode($request->selling_price_b);
            $trd_farm->selling_price_c = json_encode($request->selling_price_c);
            $trd_farm->selling_price_d = json_encode($request->selling_price_d);
            
            $trd_farm->other_cost_parameter_quantum_handle = json_encode($request->other_cost_parameter_quantum_handle);
            $trd_farm->other_cost_parameter_pur_sel_pri = json_encode($request->other_cost_parameter_pur_sel_pri);
            
            $trd_farm->challenges_a = json_encode($request->challenges_a);
            $trd_farm->challenges_b = json_encode($request->challenges_b);

            $trd_farm->risk_a = json_encode($request->risk_a);
            $trd_farm->risk_b = json_encode($request->risk_b);
            $trd_farm->risk_c = json_encode($request->risk_c);
            
            $trd_farm->issues_constraints_a = json_encode($request->issues_constraints_a);
            $trd_farm->issues_constraints_b = json_encode($request->issues_constraints_b);
            $trd_farm->issues_constraints_c = json_encode($request->issues_constraints_c);
            
            $trd_farm->prospects_a = json_encode($request->prospects_a);
            $trd_farm->prospects_b = json_encode($request->prospects_b);
            $trd_farm->prospects_c = json_encode($request->prospects_c);
            
            // Save the model
            $trd_farm->save();
            
            return response()->json([
                'status' => true,
                'message' => 'trd  Data Created Successfully',
            ], 200);
        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    // old query
    // public function trd_farm(Request $request)
    // {
    //     if(isset($request->image))
    //         {
              
    //             if ($request->hasFile('image') && $request->file('image')->isValid()) {
    //                 $uploadedFile = $request->file('image');
                
    //                 $targetDir = "uploads/"; // Change this to your desired local folder path
                
    //                 // Ensure the target directory exists, create it if necessary
    //                 if (!file_exists($targetDir)) {
    //                     mkdir($targetDir, 0755, true);
    //                 }
                
    //                 $targetFile = $targetDir . $uploadedFile->getClientOriginalName();
                
    //                 // Move the uploaded file to the desired location
    //                 if ($uploadedFile->move($targetDir, $targetFile)) {
                       
    //                 } else {
    //                     echo "Sorry, there was an error uploading your file.";
    //                 }
    //             } else {
    //                 echo "Error: No valid file uploaded.";
    //             }
    //         }
    //     try{
    //         // dd($request->all());
    //         $validator = Validator::make($request->all(), [
    //                 //   'trader.name' => 'string',
    //                 //     'trader.mobile' => 'string',
    //                 //     'trader.district' => 'string',
    //                 //     'trader.block' => 'string',
                    
    //                 //     'infra_support.establishment_cost' => 'numeric',
    //                 //     'infra_support.storage_cost' => 'numeric',
    //                 //     'infra_support.electricity_monthly_expense' => 'numeric',
    //                 //     'infra_support.manpower_monthly_expense' => 'numeric',
    //                 //     'infra_support.rent_monthly' => 'numeric',
    //                 //     'infra_support.travelling_monthly' => 'numeric',
    //                 //     'infra_support.village_purchase' => 'string',
    //                 //     'infra_support.local_mandi_purchase' => 'string',
    //                 //     'infra_support.commision_agent_purchase' => 'string',
    //                 //     'infra_support.prevalent_purchase_mechanism' => 'string',
    //                 //     'infra_support.interest_annual' => 'numeric',
    //                 //     'infra_support.purchase_credit_duration' => 'numeric',
    //                 //     'infra_support.sale_credit_duration' => 'numeric',
    //                 //     'infra_support.advance_credit' => 'numeric',
    //                 //     'infra_support.other_info' => 'string',
                        
    //                 //      'average_purchase_price.gradeA.product_name' => 'string',
    //                 //     'average_purchase_price.gradeA.unit_quantity' => 'string',
    //                 //     'average_purchase_price.gradeA.average_rate' => 'numeric',
    //                 //     'average_purchase_price.gradeA.min_max_variation' => 'string',
    //                 //     'average_purchase_price.gradeA.remarks' => 'string',
                    
    //                 //     'average_purchase_price.gradeB.product_name' => 'string',
    //                 //     'average_purchase_price.gradeB.unit_quantity' => 'string',
    //                 //     'average_purchase_price.gradeB.average_rate' => 'numeric',
    //                 //     'average_purchase_price.gradeB.min_max_variation' => 'string',
    //                 //     'average_purchase_price.gradeB.remarks' => 'string',
                    
    //                 //     'average_purchase_price.gradeC.product_name' => 'string',
    //                 //     'average_purchase_price.gradeC.unit_quantity' => 'string',
    //                 //     'average_purchase_price.gradeC.average_rate' => 'numeric',
    //                 //     'average_purchase_price.gradeC.min_max_variation' => 'string',
    //                 //     'average_purchase_price.gradeC.remarks' => 'string',
                    
    //                 //     'average_purchase_price.gradeD.product_name' => 'string',
    //                 //     'average_purchase_price.gradeD.unit_quantity' => 'string',
    //                 //     'average_purchase_price.gradeD.average_rate' => 'numeric',
    //                 //     'average_purchase_price.gradeD.min_max_variation' => 'string',
    //                 //     'average_purchase_price.gradeD.remarks' => 'string',
                        
    //                 //      'value_addition_cost.transportation_cost.product_name' => 'string',
    //                 //     'value_addition_cost.transportation_cost.unit_quantity' => 'string',
    //                 //     'value_addition_cost.transportation_cost.average_rate' => 'numeric',
    //                 //     'value_addition_cost.transportation_cost.min_max_variation' => 'string',
    //                 //     'value_addition_cost.transportation_cost.remarks' => 'string',
    //                 //     'value_addition_cost.loading_unloading_cost.product_name' => 'string',
    //                 //     'value_addition_cost.loading_unloading_cost.unit_quantity' => 'string',
    //                 //     'value_addition_cost.loading_unloading_cost.average_rate' => 'numeric',
    //                 //     'value_addition_cost.loading_unloading_cost.min_max_variation' => 'string',
    //                 //     'value_addition_cost.loading_unloading_cost.remarks' => 'string',
    //                 //     'value_addition_cost.primary_processing_cost.product_name' => 'string',
    //                 //     'value_addition_cost.primary_processing_cost.unit_quantity' => 'string',
    //                 //     'value_addition_cost.primary_processing_cost.average_rate' => 'numeric',
    //                 //     'value_addition_cost.primary_processing_cost.min_max_variation' => 'string',
    //                 //     'value_addition_cost.primary_processing_cost.remarks' => 'string',
    //                 //     'value_addition_cost.dry_other_loss.product_name' => 'string',
    //                 //     'value_addition_cost.dry_other_loss.unit_quantity' => 'string',
    //                 //     'value_addition_cost.dry_other_loss.average_rate' => 'numeric',
    //                 //     'value_addition_cost.dry_other_loss.min_max_variation' => 'string',
    //                 //     'value_addition_cost.dry_other_loss.remarks' => 'string',
    //                 //     'value_addition_cost.establishment_cost.product_name' => 'string',
    //                 //     'value_addition_cost.establishment_cost.unit_quantity' => 'string',
    //                 //     'value_addition_cost.establishment_cost.average_rate' => 'numeric',
    //                 //     'value_addition_cost.establishment_cost.min_max_variation' => 'string',
    //                 //     'value_addition_cost.establishment_cost.remarks' => 'string',
    //                 //     'value_addition_cost.marketing_cost.product_name' => 'string',
    //                 //     'value_addition_cost.marketing_cost.unit_quantity' => 'string',
    //                 //     'value_addition_cost.marketing_cost.average_rate' => 'numeric',
    //                 //     'value_addition_cost.marketing_cost.min_max_variation' => 'string',
    //                 //     'value_addition_cost.marketing_cost.remarks' => 'string',
    //                 //     'value_addition_cost.storage_cost.product_name' => 'string',
    //                 //     'value_addition_cost.storage_cost.unit_quantity' => 'string',
    //                 //     'value_addition_cost.storage_cost.average_rate' => 'numeric',
    //                 //     'value_addition_cost.storage_cost.min_max_variation' => 'string',
    //                 //     'value_addition_cost.storage_cost.remarks' => 'string',
    //                 //     'value_addition_cost.other_cost.product_name' => 'string',
    //                 //     'value_addition_cost.other_cost.unit_quantity' => 'string',
    //                 //     'value_addition_cost.other_cost.average_rate' => 'numeric',
    //                 //     'value_addition_cost.other_cost.min_max_variation' => 'string',
    //                 //     'value_addition_cost.other_cost.remarks' => 'string',
                        
                        
    //                 //      'selling_price.gradeA.product_name' => 'string',
    //                 //     'selling_price.gradeA.unit_quantity' => 'string',
    //                 //     'selling_price.gradeA.average_rate' => 'numeric',
    //                 //     'selling_price.gradeA.min_max_variation' => 'string',
    //                 //     'selling_price.gradeA.remarks' => 'string',
                    
    //                 //     'selling_price.gradeB.product_name' => 'string',
    //                 //     'selling_price.gradeB.unit_quantity' => 'string',
    //                 //     'selling_price.gradeB.average_rate' => 'numeric',
    //                 //     'selling_price.gradeB.min_max_variation' => 'string',
    //                 //     'selling_price.gradeB.remarks' => 'string',
                    
    //                 //     'selling_price.gradeC.product_name' => 'string',
    //                 //     'selling_price.gradeC.unit_quantity' => 'string',
    //                 //     'selling_price.gradeC.average_rate' => 'numeric',
    //                 //     'selling_price.gradeC.min_max_variation' => 'string',
    //                 //     'selling_price.gradeC.remarks' => 'string',
                    
    //                 //     'selling_price.gradeD.product_name' => 'string',
    //                 //     'selling_price.gradeD.unit_quantity' => 'string',
    //                 //     'selling_price.gradeD.average_rate' => 'numeric',
    //                 //     'selling_price.gradeD.min_max_variation' => 'string',
    //                 //     'selling_price.gradeD.remarks' => 'string',
                        
    //                 //      'other_cost_parameter.quantum_handled.product_name' => 'string',
    //                 //     'other_cost_parameter.quantum_handled.unit_quantity' => 'string',
    //                 //     'other_cost_parameter.quantum_handled.average_rate' => 'numeric',
    //                 //     'other_cost_parameter.quantum_handled.min_max_variation' => 'string',
    //                 //     'other_cost_parameter.quantum_handled.remarks' => 'string',
    //                 //     'other_cost_parameter.price_fluctuations.product_name' => 'string',
    //                 //     'other_cost_parameter.price_fluctuations.unit_quantity' => 'string',
    //                 //     'other_cost_parameter.price_fluctuations.average_rate' => 'numeric',
    //                 //     'other_cost_parameter.price_fluctuations.min_max_variation' => 'string',
    //                 //     'other_cost_parameter.price_fluctuations.remarks' => 'string',
                    
    //                 //     'indicativeI.parameter' => 'string',
    //                 //     'indicativeI.remark' => 'string',
                    
    //                 //     'indicativeII.parameter' => 'string',
    //                 //     'indicativeII.remark' => 'string',
                    
    //                 //     'indicativeIII.parameter' => 'string',
    //                 //     'indicativeIII.remark' => 'string',
                    
    //                 //     'challengeI.parameter' => 'string',
    //                 //     'challengeI.remark' => 'string',
                    
    //                 //     'challengeII.parameter' => 'string',
    //                 //     'challengeII.remark' => 'string',
                    
    //                 //     'riskI.parameter' => 'string',
    //                 //     'riskI.remark' => 'string',
                    
    //                 //     'riskII.parameter' => 'string',
    //                 //     'riskII.remark' => 'string',
                    
    //                 //     'riskIII.parameter' => 'string',
    //                 //     'riskIII.remark' => 'string',
                    
    //                 //     'prospectI.parameter' => 'string',
    //                 //     'prospectI.remark' => 'string',
                    
    //                 //     'prospectII.parameter' => 'string',
    //                 //     'prospectII.remark' => 'string',
                    
    //                 //     'prospectIII.parameter' => 'string',
    //                 //     'prospectIII.remark' => 'string',
    //                 ]);

    //                 if ($validator->fails()) {
    //                     return response()->json([
    //                         'remark' => 'validation_error',
    //                         'status' => 'error',
    //                         'message' => ['error' => $validator->errors()],
    //                     ]);
    //                 }
                    
                    
    //                     $trd_farm = new TrdFarm();
                        
    //                     $trd_farm->user_id = Auth::user()->id;
                        
    //                   // Assign trader details
    //                     $trd_farm->trader_name = $request->input('trader.name');
    //                     $trd_farm->trader_mobile = $request->input('trader.mobile');
    //                     $trd_farm->trader_district = $request->input('trader.district');
    //                     $trd_farm->trader_block = $request->input('trader.block');
    //                     $trd_farm->image = $request->input('trader.image');
                        
    //                     // Assign infra_support details
    //                     $trd_farm->establishment_cost = $request->input('infra_support.establishment_cost');
    //                     $trd_farm->storage_cost = $request->input('infra_support.storage_cost');
    //                     $trd_farm->electricity_monthly_expense = $request->input('infra_support.electricity_monthly_expense');
    //                     $trd_farm->manpower_monthly_expense = $request->input('infra_support.manpower_monthly_expense');
    //                     $trd_farm->rent_monthly = $request->input('infra_support.rent_monthly');
    //                     $trd_farm->travelling_monthly = $request->input('infra_support.travelling_monthly');
    //                     $trd_farm->village_purchase = $request->input('infra_support.village_purchase');
    //                     $trd_farm->local_mandi_purchase = $request->input('infra_support.local_mandi_purchase');
    //                     $trd_farm->commision_agent_purchase = $request->input('infra_support.commision_agent_purchase');
    //                     $trd_farm->prevalent_purchase_mechanism = $request->input('infra_support.prevalent_purchase_mechanism');
    //                     $trd_farm->interest_annual = $request->input('infra_support.interest_annual');
    //                     $trd_farm->purchase_credit_duration = $request->input('infra_support.purchase_credit_duration');
    //                     $trd_farm->sale_credit_duration = $request->input('infra_support.sale_credit_duration');
    //                     $trd_farm->advance_credit = $request->input('infra_support.advance_credit');
    //                     $trd_farm->other_info = $request->input('infra_support.other_info');
    //                     $trd_farm->establishment_cost_unit = $request->input('infra_support.establishment_cost_unit');
    //                     $trd_farm->electricity_expense_unit = $request->input('infra_support.electricity_expense_unit');
    //                     $trd_farm->travelling_unit = $request->input('infra_support.travelling_unit');
                     
                        
    //                     // Assign average_purchase_price details for gradeA
    //                     $trd_farm->gradeA_product_name = $request->input('average_purchase_price.gradeA.product_name');
    //                     $trd_farm->gradeA_unit_quantity = $request->input('average_purchase_price.gradeA.unit_quantity');
    //                     $trd_farm->gradeA_average_rate = $request->input('average_purchase_price.gradeA.average_rate');
    //                     $trd_farm->gradeA_remarks = $request->input('average_purchase_price.gradeA.remarks');
    //                     $trd_farm->gradeA_unit = $request->input('average_purchase_price.gradeA.unit');
    //                     $trd_farm->gradeA_min_variation = $request->input('average_purchase_price.gradeA.min_variation');
    //                     $trd_farm->gradeA_max_variation = $request->input('average_purchase_price.gradeA.max_variation');
                        
    //                     // Assign average_purchase_price details for gradeB
    //                     $trd_farm->gradeB_product_name = $request->input('average_purchase_price.gradeB.product_name');
    //                     $trd_farm->gradeB_unit_quantity = $request->input('average_purchase_price.gradeB.unit_quantity');
    //                     $trd_farm->gradeB_average_rate = $request->input('average_purchase_price.gradeB.average_rate');
    //                     $trd_farm->gradeB_remarks = $request->input('average_purchase_price.gradeB.remarks');
    //                     $trd_farm->gradeB_unit = $request->input('average_purchase_price.gradeB.unit');
    //                     $trd_farm->gradeB_min_variation = $request->input('average_purchase_price.gradeB.min_variation');
    //                     $trd_farm->gradeB_max_variation = $request->input('average_purchase_price.gradeB.max_variation');
                        
    //                     // Assign average_purchase_price details for gradeC
    //                     $trd_farm->gradeC_product_name = $request->input('average_purchase_price.gradeC.product_name');
    //                     $trd_farm->gradeC_unit_quantity = $request->input('average_purchase_price.gradeC.unit_quantity');
    //                     $trd_farm->gradeC_average_rate = $request->input('average_purchase_price.gradeC.average_rate');
    //                     $trd_farm->gradeC_remarks = $request->input('average_purchase_price.gradeC.remarks');
    //                     $trd_farm->gradeC_unit = $request->input('average_purchase_price.gradeC.unit');
    //                     $trd_farm->gradeC_min_variation = $request->input('average_purchase_price.gradeC.min_variation');
    //                     $trd_farm->gradeC_max_variation = $request->input('average_purchase_price.gradeC.max_variation');
                        
    //                     // Assign average_purchase_price details for gradeD
    //                     $trd_farm->gradeD_product_name = $request->input('average_purchase_price.gradeD.product_name');
    //                     $trd_farm->gradeD_unit_quantity = $request->input('average_purchase_price.gradeD.unit_quantity');
    //                     $trd_farm->gradeD_average_rate = $request->input('average_purchase_price.gradeD.average_rate');
    //                     $trd_farm->gradeD_remarks = $request->input('average_purchase_price.gradeD.remarks');
    //                     $trd_farm->gradeD_unit = $request->input('average_purchase_price.gradeD.unit');
    //                     $trd_farm->gradeD_min_variation = $request->input('average_purchase_price.gradeD.min_variation');
    //                     $trd_farm->gradeD_max_variation = $request->input('average_purchase_price.gradeD.max_variation');
                        
    //                     // Assign average_purchase_price details for gradeE
    //                     $trd_farm->gradeE_product_name = $request->input('average_purchase_price.gradeE.product_name');
    //                     $trd_farm->gradeE_unit_quantity = $request->input('average_purchase_price.gradeE.unit_quantity');
    //                     $trd_farm->gradeE_average_rate = $request->input('average_purchase_price.gradeE.average_rate');
    //                     $trd_farm->gradeE_remarks = $request->input('average_purchase_price.gradeE.remarks');
    //                     $trd_farm->gradeE_unit = $request->input('average_purchase_price.gradeE.unit');
    //                     $trd_farm->gradeE_min_variation = $request->input('average_purchase_price.gradeE.min_variation');
    //                     $trd_farm->gradeE_max_variation = $request->input('average_purchase_price.gradeE.max_variation');
                        
    //                     // Assign average_purchase_price details for gradeF
    //                     $trd_farm->gradeF_product_name = $request->input('average_purchase_price.gradeF.product_name');
    //                     $trd_farm->gradeF_unit_quantity = $request->input('average_purchase_price.gradeF.unit_quantity');
    //                     $trd_farm->gradeF_average_rate = $request->input('average_purchase_price.gradeF.average_rate');
    //                     $trd_farm->gradeF_remarks = $request->input('average_purchase_price.gradeF.remarks');
    //                     $trd_farm->gradeF_unit = $request->input('average_purchase_price.gradeF.unit');
    //                     $trd_farm->gradeF_min_variation = $request->input('average_purchase_price.gradeF.min_variation');
    //                     $trd_farm->gradeF_max_variation = $request->input('average_purchase_price.gradeF.max_variation');
                        
    //                     // Assign average_purchase_price details for gradeG
    //                     $trd_farm->gradeG_product_name = $request->input('average_purchase_price.gradeG.product_name');
    //                     $trd_farm->gradeG_unit_quantity = $request->input('average_purchase_price.gradeG.unit_quantity');
    //                     $trd_farm->gradeG_average_rate = $request->input('average_purchase_price.gradeG.average_rate');
    //                     $trd_farm->gradeG_remarks = $request->input('average_purchase_price.gradeG.remarks');
    //                     $trd_farm->gradeG_unit = $request->input('average_purchase_price.gradeG.unit');
    //                     $trd_farm->gradeG_min_variation = $request->input('average_purchase_price.gradeG.min_variation');
    //                     $trd_farm->gradeG_max_variation = $request->input('average_purchase_price.gradeG.max_variation');
                        
    //                     // Assign average_purchase_price details for gradeH
    //                     $trd_farm->gradeH_product_name = $request->input('average_purchase_price.gradeH.product_name');
    //                     $trd_farm->gradeH_unit_quantity = $request->input('average_purchase_price.gradeH.unit_quantity');
    //                     $trd_farm->gradeH_average_rate = $request->input('average_purchase_price.gradeH.average_rate');
    //                     $trd_farm->gradeH_remarks = $request->input('average_purchase_price.gradeH.remarks');
    //                     $trd_farm->gradeH_unit = $request->input('average_purchase_price.gradeH.unit');
    //                     $trd_farm->gradeH_min_variation = $request->input('average_purchase_price.gradeH.min_variation');
    //                     $trd_farm->gradeH_max_variation = $request->input('average_purchase_price.gradeH.max_variation');
                        
    //                     // Assign value_addition_cost details
    //                     $trd_farm->transportation_product_name = $request->input('value_addition_cost.transportation_cost.product_name');
    //                     $trd_farm->transportation_unit_quantity = $request->input('value_addition_cost.transportation_cost.unit_quantity');
    //                     $trd_farm->transportation_average_rate = $request->input('value_addition_cost.transportation_cost.average_rate');
    //                     $trd_farm->transportation_remarks = $request->input('value_addition_cost.transportation_cost.remarks');
    //                     $trd_farm->transportation_unit = $request->input('value_addition_cost.transportation_cost.unit');
    //                     $trd_farm->transportation_min_variation = $request->input('value_addition_cost.transportation_cost.min_variation');
    //                     $trd_farm->transportation_max_variation = $request->input('value_addition_cost.transportation_cost.max_variation');
                        
    //                     $trd_farm->luc_product_name = $request->input('value_addition_cost.loading_unloading_cost.product_name');
    //                     $trd_farm->luc_unit_quantity = $request->input('value_addition_cost.loading_unloading_cost.unit_quantity');
    //                     $trd_farm->luc_average_rate = $request->input('value_addition_cost.loading_unloading_cost.average_rate');
    //                     $trd_farm->luc_remarks = $request->input('value_addition_cost.loading_unloading_cost.remarks');
    //                     $trd_farm->luc_unit = $request->input('value_addition_cost.loading_unloading_cost.unit');
    //                     $trd_farm->luc_min_variation = $request->input('value_addition_cost.loading_unloading_cost.min_variation');
    //                     $trd_farm->luc_max_variation = $request->input('value_addition_cost.loading_unloading_cost.max_variation');
                        
    //                     $trd_farm->ppc_product_name = $request->input('value_addition_cost.primary_processing_cost.product_name');
    //                     $trd_farm->ppc_unit_quantity = $request->input('value_addition_cost.primary_processing_cost.unit_quantity');
    //                     $trd_farm->ppc_average_rate = $request->input('value_addition_cost.primary_processing_cost.average_rate');
    //                     $trd_farm->ppc_remarks = $request->input('value_addition_cost.primary_processing_cost.remarks');
    //                     $trd_farm->ppc_unit = $request->input('value_addition_cost.primary_processing_cost.unit');
    //                     $trd_farm->ppc_min_variation = $request->input('value_addition_cost.primary_processing_cost.min_variation');
    //                     $trd_farm->ppc_max_variation = $request->input('value_addition_cost.primary_processing_cost.max_variation');
                        
                        
    //                     $trd_farm->dol_product_name = $request->input('value_addition_cost.dry_other_loss.product_name');
    //                     $trd_farm->dol_unit_quantity = $request->input('value_addition_cost.dry_other_loss.unit_quantity');
    //                     $trd_farm->dol_average_rate = $request->input('value_addition_cost.dry_other_loss.average_rate');
    //                     $trd_farm->dol_remarks = $request->input('value_addition_cost.dry_other_loss.remarks');
    //                     $trd_farm->dol_unit = $request->input('value_addition_cost.dry_other_loss.unit');
    //                     $trd_farm->dol_min_variation = $request->input('value_addition_cost.dry_other_loss.min_variation');
    //                     $trd_farm->dol_max_variation = $request->input('value_addition_cost.dry_other_loss.max_variation');

                        
    //                     $trd_farm->ec_product_name = $request->input('value_addition_cost.establishment_cost.product_name');
    //                     $trd_farm->ec_unit_quantity = $request->input('value_addition_cost.establishment_cost.unit_quantity');
    //                     $trd_farm->ec_average_rate = $request->input('value_addition_cost.establishment_cost.average_rate');
    //                     $trd_farm->ec_remarks = $request->input('value_addition_cost.establishment_cost.remarks');
    //                     $trd_farm->ec_unit = $request->input('value_addition_cost.establishment_cost.unit');
    //                     $trd_farm->ec_min_variation = $request->input('value_addition_cost.establishment_cost.min_variation');
    //                     $trd_farm->ec_max_variation = $request->input('value_addition_cost.establishment_cost.max_variation');

                        
    //                     $trd_farm->m_product_name = $request->input('value_addition_cost.marketing_cost.product_name');
    //                     $trd_farm->m_unit_quantity = $request->input('value_addition_cost.marketing_cost.unit_quantity');
    //                     $trd_farm->m_average_rate = $request->input('value_addition_cost.marketing_cost.average_rate');
    //                     $trd_farm->m_remarks = $request->input('value_addition_cost.marketing_cost.remarks');
    //                     $trd_farm->m_unit = $request->input('value_addition_cost.marketing_cost.unit');
    //                     $trd_farm->m_min_variation = $request->input('value_addition_cost.marketing_cost.min_variation');
    //                     $trd_farm->m_max_variation = $request->input('value_addition_cost.marketing_cost.max_variation');

                        
    //                     $trd_farm->sc_product_name = $request->input('value_addition_cost.storage_cost.product_name');
    //                     $trd_farm->sc_unit_quantity = $request->input('value_addition_cost.storage_cost.unit_quantity');
    //                     $trd_farm->sc_average_rate = $request->input('value_addition_cost.storage_cost.average_rate');
    //                     $trd_farm->sc_remarks = $request->input('value_addition_cost.storage_cost.remarks');
    //                     $trd_farm->sc_unit = $request->input('value_addition_cost.storage_cost.unit');
    //                     $trd_farm->sc_min_variation = $request->input('value_addition_cost.storage_cost.min_variation');
    //                     $trd_farm->sc_max_variation = $request->input('value_addition_cost.storage_cost.max_variation');

                        
    //                     $trd_farm->oc_product_name = $request->input('value_addition_cost.other_cost.product_name');
    //                     $trd_farm->oc_unit_quantity = $request->input('value_addition_cost.other_cost.unit_quantity');
    //                     $trd_farm->oc_average_rate = $request->input('value_addition_cost.other_cost.average_rate');
    //                     $trd_farm->oc_remarks = $request->input('value_addition_cost.other_cost.remarks');
    //                     $trd_farm->oc_unit = $request->input('value_addition_cost.other_cost.unit');
    //                     $trd_farm->oc_min_variation = $request->input('value_addition_cost.other_cost.min_variation');
    //                     $trd_farm->oc_max_variation = $request->input('value_addition_cost.other_cost.max_variation');

    //                     // Assign selling_price details for gradeA
    //                     $trd_farm->selling_gradeA_product_name = $request->input('selling_price.gradeA.product_name');
    //                     $trd_farm->selling_gradeA_unit_quantity = $request->input('selling_price.gradeA.unit_quantity');
    //                     $trd_farm->selling_gradeA_average_rate = $request->input('selling_price.gradeA.average_rate');
    //                     $trd_farm->selling_gradeA_remarks = $request->input('selling_price.gradeA.remarks');
    //                     $trd_farm->selling_gradeA_unit = $request->input('selling_price.gradeA.unit');
    //                     $trd_farm->selling_gradeA_min_variation = $request->input('selling_price.gradeA.min_variation');
    //                     $trd_farm->selling_gradeA_max_variation = $request->input('selling_price.gradeA.max_variation');

                        
    //                     // Assign selling_price details for gradeB
    //                     $trd_farm->selling_gradeB_product_name = $request->input('selling_price.gradeB.product_name');
    //                     $trd_farm->selling_gradeB_unit_quantity = $request->input('selling_price.gradeB.unit_quantity');
    //                     $trd_farm->selling_gradeB_average_rate = $request->input('selling_price.gradeB.average_rate');
    //                     $trd_farm->selling_gradeB_remarks = $request->input('selling_price.gradeB.remarks');
    //                     $trd_farm->selling_gradeB_unit = $request->input('selling_price.gradeB.unit');
    //                     $trd_farm->selling_gradeB_min_variation = $request->input('selling_price.gradeB.min_variation');
    //                     $trd_farm->selling_gradeB_max_variation = $request->input('selling_price.gradeB.max_variation');
                        
    //                     // Assign selling_price details for gradeC
    //                     $trd_farm->selling_gradeC_product_name = $request->input('selling_price.gradeC.product_name');
    //                     $trd_farm->selling_gradeC_unit_quantity = $request->input('selling_price.gradeC.unit_quantity');
    //                     $trd_farm->selling_gradeC_average_rate = $request->input('selling_price.gradeC.average_rate');
    //                     $trd_farm->selling_gradeC_remarks = $request->input('selling_price.gradeC.remarks');
    //                     $trd_farm->selling_gradeC_unit = $request->input('selling_price.gradeC.unit');
    //                     $trd_farm->selling_gradeC_min_variation = $request->input('selling_price.gradeC.min_variation');
    //                     $trd_farm->selling_gradeC_max_variation = $request->input('selling_price.gradeC.max_variation');
                        
    //                     // Assign selling_price details for gradeD
    //                     $trd_farm->selling_gradeD_product_name = $request->input('selling_price.gradeD.product_name');
    //                     $trd_farm->selling_gradeD_unit_quantity = $request->input('selling_price.gradeD.unit_quantity');
    //                     $trd_farm->selling_gradeD_average_rate = $request->input('selling_price.gradeD.average_rate');
    //                     $trd_farm->selling_gradeD_remarks = $request->input('selling_price.gradeD.remarks');
    //                     $trd_farm->selling_gradeD_unit = $request->input('selling_price.gradeD.unit');
    //                     $trd_farm->selling_gradeD_min_variation = $request->input('selling_price.gradeD.min_variation');
    //                     $trd_farm->selling_gradeD_max_variation = $request->input('selling_price.gradeD.max_variation');

    //                     // Assign selling_price details for gradeE
    //                     $trd_farm->selling_gradeE_product_name = $request->input('selling_price.gradeE.product_name');
    //                     $trd_farm->selling_gradeE_unit_quantity = $request->input('selling_price.gradeE.unit_quantity');
    //                     $trd_farm->selling_gradeE_average_rate = $request->input('selling_price.gradeE.average_rate');
    //                     $trd_farm->selling_gradeE_remarks = $request->input('selling_price.gradeE.remarks');
    //                     $trd_farm->selling_gradeE_unit = $request->input('selling_price.gradeE.unit');
    //                     $trd_farm->selling_gradeE_min_variation = $request->input('selling_price.gradeE.min_variation');
    //                     $trd_farm->selling_gradeE_max_variation = $request->input('selling_price.gradeE.max_variation');

                        
    //                     // Assign selling_price details for gradeF
    //                     $trd_farm->selling_gradeF_product_name = $request->input('selling_price.gradeF.product_name');
    //                     $trd_farm->selling_gradeF_unit_quantity = $request->input('selling_price.gradeF.unit_quantity');
    //                     $trd_farm->selling_gradeF_average_rate = $request->input('selling_price.gradeF.average_rate');
    //                     $trd_farm->selling_gradeF_remarks = $request->input('selling_price.gradeF.remarks');
    //                     $trd_farm->selling_gradeF_unit = $request->input('selling_price.gradeF.unit');
    //                     $trd_farm->selling_gradeF_min_variation = $request->input('selling_price.gradeF.min_variation');
    //                     $trd_farm->selling_gradeF_max_variation = $request->input('selling_price.gradeF.max_variation');
                        
    //                     // Assign selling_price details for gradeG
    //                     $trd_farm->selling_gradeG_product_name = $request->input('selling_price.gradeG.product_name');
    //                     $trd_farm->selling_gradeG_unit_quantity = $request->input('selling_price.gradeG.unit_quantity');
    //                     $trd_farm->selling_gradeG_average_rate = $request->input('selling_price.gradeG.average_rate');
    //                     $trd_farm->selling_gradeG_remarks = $request->input('selling_price.gradeG.remarks');
    //                     $trd_farm->selling_gradeG_unit = $request->input('selling_price.gradeG.unit');
    //                     $trd_farm->selling_gradeG_min_variation = $request->input('selling_price.gradeG.min_variation');
    //                     $trd_farm->selling_gradeG_max_variation = $request->input('selling_price.gradeG.max_variation');
                        
    //                     // Assign selling_price details for gradeH
    //                     $trd_farm->selling_gradeH_product_name = $request->input('selling_price.gradeH.product_name');
    //                     $trd_farm->selling_gradeH_unit_quantity = $request->input('selling_price.gradeH.unit_quantity');
    //                     $trd_farm->selling_gradeH_average_rate = $request->input('selling_price.gradeH.average_rate');
    //                     $trd_farm->selling_gradeH_remarks = $request->input('selling_price.gradeH.remarks');
    //                     $trd_farm->selling_gradeH_unit = $request->input('selling_price.gradeH.unit');
    //                     $trd_farm->selling_gradeH_min_variation = $request->input('selling_price.gradeH.min_variation');
    //                     $trd_farm->selling_gradeH_max_variation = $request->input('selling_price.gradeH.max_variation');
                            
    //                     // Assign other_cost_parameter details
                      
    //                     $trd_farm->product_name_quantum = $request->input('other_cost_parameter.quantum_handled');
    //                     $trd_farm->unit_quantity_quantum = $request->input('other_cost_parameter.quantum_handled_unit');
    //                     $trd_farm->product_name_fluctuations = $request->input('other_cost_parameter.price_fluctuations');
                    
                    
    //                     // Assign indicative details
    //                     $trd_farm->indicativeI_parameter = $request->input('indicativeI.parameter');
    //                     $trd_farm->indicativeI_remark = $request->input('indicativeI.remark');
                        
    //                     $trd_farm->indicativeII_parameter = $request->input('indicativeII.parameter');
    //                     $trd_farm->indicativeII_remark = $request->input('indicativeII.remark');
                        
    //                     $trd_farm->indicativeIII_parameter = $request->input('indicativeIII.parameter');
    //                     $trd_farm->indicativeIII_remark = $request->input('indicativeIII.remark');
                        
    //                     // Assign challenge details
    //                     $trd_farm->challengeI_parameter = $request->input('challengeI.parameter');
    //                     $trd_farm->challengeI_remark = $request->input('challengeI.remark');
                        
    //                     $trd_farm->challengeII_parameter = $request->input('challengeII.parameter');
    //                     $trd_farm->challengeII_remark = $request->input('challengeII.remark');
                        
                        
    //                     // Assign risk details
    //                     $trd_farm->riskI_parameter = $request->input('riskI.parameter');
    //                     $trd_farm->riskI_remark = $request->input('riskI.remark');
                        
    //                     $trd_farm->riskII_parameter = $request->input('riskII.parameter');
    //                     $trd_farm->riskII_remark = $request->input('riskII.remark');
                        
    //                     $trd_farm->riskIII_parameter = $request->input('riskIII.parameter');
    //                     $trd_farm->riskIII_remark = $request->input('riskIII.remark');
                        
    //                     // Assign prospect details
    //                     $trd_farm->prospectI_parameter = $request->input('prospectI.parameter');
    //                     $trd_farm->prospectI_remark = $request->input('prospectI.remark');
                        
    //                     $trd_farm->prospectII_parameter = $request->input('prospectII.parameter');
    //                     $trd_farm->prospectII_remark = $request->input('prospectII.remark');
                        
    //                     $trd_farm->prospectIII_parameter = $request->input('prospectIII.parameter');
    //                     $trd_farm->prospectIII_remark = $request->input('prospectIII.remark');
                            
    //                     // Save the model
    //                     $trd_farm->save();

    //                     return response()->json([
    //                     'status' => true,
    //                     'message' => 'TRDFarm Data Created Successfully',
    //                 ], 200);
    //     }
    //      catch (\Throwable $th) {
    //                         return response()->json([
    //                             'status' => false,
    //                             'message' => $th->getMessage()
    //                         ], 500);
    //                     }
    // }
    
    
    public function va_farm_one(Request $request)
    {
        try{
            // dd($request->all());
           $validator = Validator::make($request->all(), [
                // 'plant_machinery' => 'string',
            ]);
            
                    if ($validator->fails()) {
                        return response()->json([
                            'remark' => 'validation_error',
                            'status' => 'error',
                            'message' => ['error' => $validator->errors()],
                        ]);
                    }
                    
                    
                       $va_farm = new VaOneFarm();
                    
                        $va_farm->user_id = Auth::user()->id;
                        
                         // Assign establishment details
                         
                        $va_farm->value_mapping = json_encode($request->value_mapping);
                        $va_farm->establishment = json_encode($request->establishment);
                        $va_farm-> storage= json_encode($request->storage);
                        
                        $va_farm->capacity_of_plant_machinery = json_encode($request->capacity_of_plant_machinery);
                        $va_farm->average_operating_capacity_of_machine = json_encode($request->average_operating_capacity_of_machine);
                        $va_farm->actual_annual_running_hours = json_encode($request->actual_annual_running_hours);
                        $va_farm->annual_processing_of_produce = json_encode($request->annual_processing_of_produce);
                        $va_farm->purchase_of_raw_material_a = json_encode($request->purchase_of_raw_material_a);
                        $va_farm->purchase_of_raw_material_b = json_encode($request->purchase_of_raw_material_b);
                        $va_farm->purchase_of_raw_material_c = json_encode($request->purchase_of_raw_material_c);
                        
                        $va_farm->plant_machinery = json_encode($request->plant_machinery);
                        $va_farm->plant_machinery_capacity = json_encode($request->plant_machinery_capacity);
                        $va_farm->average_operating_capacity = json_encode($request->average_operating_capacity);
                        $va_farm->annual_running_hours = json_encode($request->annual_running_hours);
                        $va_farm->produce_annual_processing = json_encode($request->produce_annual_processing);
                        $va_farm->electricity_annual_expense = json_encode($request->electricity_annual_expense);
                        $va_farm->manpower_annual_expense = json_encode($request->manpower_annual_expense);
                        $va_farm->rent_annual = json_encode($request->rent_annual);
                        $va_farm->travelling_expense_annual = json_encode($request->travelling_expense_annual);
                        $va_farm->repair_maintenance_annual = json_encode($request->repair_maintenance_annual);
                        $va_farm->insurance_cost_annual = json_encode($request->insurance_cost_annual);
                        $va_farm->misc_admin_cost_annual = json_encode($request->misc_admin_cost_annual);
                        $va_farm->raw_material_purchase = json_encode($request->raw_material_purchase);
                        $va_farm->farmer_village_purchase = json_encode($request->farmer_village_purchase);
                        $va_farm->local_mandi_purchase = json_encode($request->local_mandi_purchase);
                        $va_farm->apmc_purchase = json_encode($request->apmc_purchase);
                        $va_farm->commission_agent_purchase = json_encode($request->commission_agent_purchase);
                        $va_farm->wholesaler_purchase = json_encode($request->wholesaler_purchase);
                        $va_farm->outside_import = json_encode($request->outside_import);
                        $va_farm->primary_processor_purchase = json_encode($request->primary_processor_purchase);
                        $va_farm->secondary_processor_purchase = json_encode($request->secondary_processor_purchase);
                        $va_farm->prevalent_purchase_mechanism = json_encode($request->prevalent_purchase_mechanism);
                        $va_farm->raw_material_availability = json_encode($request->raw_material_availability);
                        
                        $va_farm->raw_material_regularity = json_encode($request->raw_material_regularity);
                        
                        $va_farm->any_other_fix_cost = json_encode($request->any_other_fix_cost);
                        
                        $va_farm->quality_issue = json_encode($request->quality_issue);
                        $va_farm->credit_supplier_advice = json_encode($request->credit_supplier_advice);
                        $va_farm->supplier_credit_duration = json_encode($request->supplier_credit_duration);
                        $va_farm->supplier_payment = json_encode($request->supplier_payment);
                        $va_farm->sell_through_distributor = json_encode($request->sell_through_distributor);
                        $va_farm->sell_through_retailers = json_encode($request->sell_through_retailers);
                        $va_farm->sell_through_outlets = json_encode($request->sell_through_outlets);
                        $va_farm->online_selling = json_encode($request->online_selling);
                        $va_farm->export = json_encode($request->export);
                        $va_farm->other_marketing = json_encode($request->other_marketing);
                        $va_farm->supply_on_credit = json_encode($request->supply_on_credit);
                        $va_farm->capital_investment_interest = json_encode($request->capital_investment_interest);
                        $va_farm->working_capital_interest = json_encode($request->working_capital_interest);
                        
                        $va_farm->other_info = json_encode($request->other_info);
                        
                        //   dd($va_farm);
                        // Save the model
                        $va_farm->save();

                        return response()->json([
                        'status' => true,
                        'message' => 'VAFarm Units Characteristics Data Created Successfully',
                    ], 200);
        }
         catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
         }
    }
    
    // old query
    // public function va_farm_one(Request $request)
    // {
    //     try{
    //         // dd($request->all());
    //       $validator = Validator::make($request->all(), [
    //             // 'units_characteristics.establishment.particulars' => 'string',
    //             // 'units_characteristics.establishment.primary' => 'string',
    //             // 'units_characteristics.establishment.secondary' => 'string',
    //             // 'units_characteristics.establishment.tertiary' => 'string',
    //             // 'units_characteristics.establishment.remarks' => 'string',
            
    //             // 'units_characteristics.storage.particulars' => 'string',
    //             // 'units_characteristics.storage.primary' => 'string',
    //             // 'units_characteristics.storage.secondary' => 'string',
    //             // 'units_characteristics.storage.tertiary' => 'string',
    //             // 'units_characteristics.storage.remarks' => 'string',
            
    //             //  'plant_machinery.particulars' => 'string',
    //             // 'plant_machinery.primary' => 'string',
    //             // 'plant_machinery.secondary' => 'string',
    //             // 'plant_machinery.tertiary' => 'string',
    //             // 'plant_machinery.remarks' => 'string',
            
    //             // 'plant_machinery_capacity.particulars' => 'string',
    //             // 'plant_machinery_capacity.primary' => 'string',
    //             // 'plant_machinery_capacity.secondary' => 'string',
    //             // 'plant_machinery_capacity.tertiary' => 'string',
    //             // 'plant_machinery_capacity.remarks' => 'string',
            
    //             // 'average_operating_capacity.particulars' => 'string',
    //             // 'average_operating_capacity.primary' => 'string',
    //             // 'average_operating_capacity.secondary' => 'string',
    //             // 'average_operating_capacity.tertiary' => 'string',
    //             // 'average_operating_capacity.remarks' => 'string',
            
    //             // 'annual_running_hours.particulars' => 'string',
    //             // 'annual_running_hours.primary' => 'string',
    //             // 'annual_running_hours.secondary' => 'string',
    //             // 'annual_running_hours.tertiary' => 'string',
    //             // 'annual_running_hours.remarks' => 'string',
                
    //             //  'produce_annual_processing.particulars' => 'string',
    //             // 'produce_annual_processing.primary' => 'string',
    //             // 'produce_annual_processing.secondary' => 'string',
    //             // 'produce_annual_processing.tertiary' => 'string',
    //             // 'produce_annual_processing.remarks' => 'string',
            
    //             // 'electricity_annual_expense.particulars' => 'string',
    //             // 'electricity_annual_expense.primary' => 'string',
    //             // 'electricity_annual_expense.secondary' => 'string',
    //             // 'electricity_annual_expense.tertiary' => 'string',
    //             // 'electricity_annual_expense.remarks' => 'string',
            
    //             // 'manpower_annual_expense.particulars' => 'string',
    //             // 'manpower_annual_expense.primary' => 'string',
    //             // 'manpower_annual_expense.secondary' => 'string',
    //             // 'manpower_annual_expense.tertiary' => 'string',
    //             // 'manpower_annual_expense.remarks' => 'string',
            
    //             // 'rent_annual.particulars' => 'string',
    //             // 'rent_annual.primary' => 'string',
    //             // 'rent_annual.secondary' => 'string',
    //             // 'rent_annual.tertiary' => 'string',
    //             // 'rent_annual.remarks' => 'string',
                
    //             //  'travelling_expense_annual.particulars' => 'string',
    //             // 'travelling_expense_annual.primary' => 'string',
    //             // 'travelling_expense_annual.secondary' => 'string',
    //             // 'travelling_expense_annual.tertiary' => 'string',
    //             // 'travelling_expense_annual.remarks' => 'string',
            
    //             // 'repair_maintenance_annual.particulars' => 'string',
    //             // 'repair_maintenance_annual.primary' => 'string',
    //             // 'repair_maintenance_annual.secondary' => 'string',
    //             // 'repair_maintenance_annual.tertiary' => 'string',
    //             // 'repair_maintenance_annual.remarks' => 'string',
            
    //             // 'insurance_cost_annual.particulars' => 'string',
    //             // 'insurance_cost_annual.primary' => 'string',
    //             // 'insurance_cost_annual.secondary' => 'string',
    //             // 'insurance_cost_annual.tertiary' => 'string',
    //             // 'insurance_cost_annual.remarks' => 'string',
            
    //             // 'misc_admin_cost_annual.particulars' => 'string',
    //             // 'misc_admin_cost_annual.primary' => 'string',
    //             // 'misc_admin_cost_annual.secondary' => 'string',
    //             // 'misc_admin_cost_annual.tertiary' => 'string',
    //             // 'misc_admin_cost_annual.remarks' => 'string',
                
    //             // 'raw_material_purchase.particulars' => 'string',
    //             // 'raw_material_purchase.primary' => 'string',
    //             // 'raw_material_purchase.secondary' => 'string',
    //             // 'raw_material_purchase.tertiary' => 'string',
    //             // 'raw_material_purchase.remarks' => 'string',
            
    //             // 'farmer_village_purchase.particulars' => 'string',
    //             // 'farmer_village_purchase.primary' => 'string',
    //             // 'farmer_village_purchase.secondary' => 'string',
    //             // 'farmer_village_purchase.tertiary' => 'string',
    //             // 'farmer_village_purchase.remarks' => 'string',
            
    //             // 'local_mandi_purchase.particulars' => 'string',
    //             // 'local_mandi_purchase.primary' => 'string',
    //             // 'local_mandi_purchase.secondary' => 'string',
    //             // 'local_mandi_purchase.tertiary' => 'string',
    //             // 'local_mandi_purchase.remarks' => 'string',
            
    //             // 'apmc_purchase.particulars' => 'string',
    //             // 'apmc_purchase.primary' => 'string',
    //             // 'apmc_purchase.secondary' => 'string',
    //             // 'apmc_purchase.tertiary' => 'string',
    //             // 'apmc_purchase.remarks' => 'string',
                
    //             //  'commission_agent_purchase.particulars' => 'string',
    //             // 'commission_agent_purchase.primary' => 'string',
    //             // 'commission_agent_purchase.secondary' => 'string',
    //             // 'commission_agent_purchase.tertiary' => 'string',
    //             // 'commission_agent_purchase.remarks' => 'string',
            
    //             // 'wholesaler_purchase.particulars' => 'string',
    //             // 'wholesaler_purchase.primary' => 'string',
    //             // 'wholesaler_purchase.secondary' => 'string',
    //             // 'wholesaler_purchase.tertiary' => 'string',
    //             // 'wholesaler_purchase.remarks' => 'string',
            
    //             // 'outside_import.particulars' => 'string',
    //             // 'outside_import.primary' => 'string',
    //             // 'outside_import.secondary' => 'string',
    //             // 'outside_import.tertiary' => 'string',
    //             // 'outside_import.remarks' => 'string',
            
    //             // 'primary_processor_purchase.particulars' => 'string',
    //             // 'primary_processor_purchase.primary' => 'string',
    //             // 'primary_processor_purchase.secondary' => 'string',
    //             // 'primary_processor_purchase.tertiary' => 'string',
    //             // 'primary_processor_purchase.remarks' => 'string',
                
    //             //  'secondary_processor_purchase.particulars' => 'string',
    //             // 'secondary_processor_purchase.primary' => 'string',
    //             // 'secondary_processor_purchase.secondary' => 'string',
    //             // 'secondary_processor_purchase.tertiary' => 'string',
    //             // 'secondary_processor_purchase.remarks' => 'string',
            
    //             // 'prevalent_purchase_mechanism.particulars' => 'string',
    //             // 'prevalent_purchase_mechanism.primary' => 'string',
    //             // 'prevalent_purchase_mechanism.secondary' => 'string',
    //             // 'prevalent_purchase_mechanism.tertiary' => 'string',
    //             // 'prevalent_purchase_mechanism.remarks' => 'string',
            
    //             // 'raw_material_regularity.particulars' => 'string',
    //             // 'raw_material_regularity.primary' => 'string',
    //             // 'raw_material_regularity.secondary' => 'string',
    //             // 'raw_material_regularity.tertiary' => 'string',
    //             // 'raw_material_regularity.remarks' => 'string',
            
    //             // 'raw_material_availability.particulars' => 'string',
    //             // 'raw_material_availability.primary' => 'string',
    //             // 'raw_material_availability.secondary' => 'string',
    //             // 'raw_material_availability.tertiary' => 'string',
    //             // 'raw_material_availability.remarks' => 'string',
                
    //             //  'quality_issue.particulars' => 'string',
    //             // 'quality_issue.primary' => 'string',
    //             // 'quality_issue.secondary' => 'string',
    //             // 'quality_issue.tertiary' => 'string',
    //             // 'quality_issue.remarks' => 'string',
            
    //             // 'credit_supplier_advice.particulars' => 'string',
    //             // 'credit_supplier_advice.primary' => 'string',
    //             // 'credit_supplier_advice.secondary' => 'string',
    //             // 'credit_supplier_advice.tertiary' => 'string',
    //             // 'credit_supplier_advice.remarks' => 'string',
            
    //             // 'supplier_credit_duration.particulars' => 'string',
    //             // 'supplier_credit_duration.primary' => 'string',
    //             // 'supplier_credit_duration.secondary' => 'string',
    //             // 'supplier_credit_duration.tertiary' => 'string',
    //             // 'supplier_credit_duration.remarks' => 'string',
            
    //             // 'supplier_payment.particulars' => 'string',
    //             // 'supplier_payment.primary' => 'string',
    //             // 'supplier_payment.secondary' => 'string',
    //             // 'supplier_payment.tertiary' => 'string',
    //             // 'supplier_payment.remarks' => 'string',
                
    //             //  'sell_through_distributor.particulars' => 'string',
    //             // 'sell_through_distributor.primary' => 'string',
    //             // 'sell_through_distributor.secondary' => 'string',
    //             // 'sell_through_distributor.tertiary' => 'string',
    //             // 'sell_through_distributor.remarks' => 'string',
            
    //             // 'sell_through_retailers.particulars' => 'string',
    //             // 'sell_through_retailers.primary' => 'string',
    //             // 'sell_through_retailers.secondary' => 'string',
    //             // 'sell_through_retailers.tertiary' => 'string',
    //             // 'sell_through_retailers.remarks' => 'string',
            
    //             // 'sell_through_outlets.particulars' => 'string',
    //             // 'sell_through_outlets.primary' => 'string',
    //             // 'sell_through_outlets.secondary' => 'string',
    //             // 'sell_through_outlets.tertiary' => 'string',
    //             // 'sell_through_outlets.remarks' => 'string',
            
    //             // 'online_selling.particulars' => 'string',
    //             // 'online_selling.primary' => 'string',
    //             // 'online_selling.secondary' => 'string',
    //             // 'online_selling.tertiary' => 'string',
    //             // 'online_selling.remarks' => 'string',
                
    //             //   'export.particulars' => 'string',
    //             // 'export.primary' => 'string',
    //             // 'export.secondary' => 'string',
    //             // 'export.tertiary' => 'string',
    //             // 'export.remarks' => 'string',
            
    //             // 'other_marketing.particulars' => 'string',
    //             // 'other_marketing.primary' => 'string',
    //             // 'other_marketing.secondary' => 'string',
    //             // 'other_marketing.tertiary' => 'string',
    //             // 'other_marketing.remarks' => 'string',
            
    //             // 'supply_on_credit.particulars' => 'string',
    //             // 'supply_on_credit.primary' => 'string',
    //             // 'supply_on_credit.secondary' => 'string',
    //             // 'supply_on_credit.tertiary' => 'string',
    //             // 'supply_on_credit.remarks' => 'string',
            
    //             // 'capital_investment_interest.particulars' => 'string',
    //             // 'capital_investment_interest.primary' => 'string',
    //             // 'capital_investment_interest.secondary' => 'string',
    //             // 'capital_investment_interest.tertiary' => 'string',
    //             // 'capital_investment_interest.remarks' => 'string',
                
    //             //  'working_capital_interest.particulars' => 'string',
    //             // 'working_capital_interest.primary' => 'string',
    //             // 'working_capital_interest.secondary' => 'string',
    //             // 'working_capital_interest.tertiary' => 'string',
    //             // 'working_capital_interest.remarks' => 'string',
            
    //             // 'other_info.particulars' => 'string',
    //             // 'other_info.primary' => 'string',
    //             // 'other_info.secondary' => 'string',
    //             // 'other_info.tertiary' => 'string',
    //             // 'other_info.remarks' => 'string',
                
    //         ]);


    //                 if ($validator->fails()) {
    //                     return response()->json([
    //                         'remark' => 'validation_error',
    //                         'status' => 'error',
    //                         'message' => ['error' => $validator->errors()],
    //                     ]);
    //                 }
                    
                    
    //                   $va_farm = new VaOneFarm();
                    
    //                     $va_farm->user_id = Auth::user()->id;
                        
    //                     // Assign establishment details
    //                     $va_farm->uc_establishment_particulars = $request->input('establishment.particulars');
    //                     $va_farm->uc_establishment_primary = $request->input('establishment.primary');
    //                     $va_farm->uc_establishment_secondary = $request->input('establishment.secondary');
    //                     $va_farm->uc_establishment_tertiary = $request->input('establishment.tertiary');
    //                     $va_farm->uc_establishment_remarks = $request->input('establishment.remarks');
    //                     $va_farm->uc_establishment_primary_unit = $request->input('establishment.primary_unit');
    //                     $va_farm->uc_establishment_secondary_unit = $request->input('establishment.secondary_unit');
    //                     $va_farm->uc_establishment_tertiary_unit = $request->input('establishment.tertiary_unit');

    //                     // Assign storage details
    //                     $va_farm->uc_storage_particulars = $request->input('storage.particulars');
    //                     $va_farm->uc_storage_primary = $request->input('storage.primary');
    //                     $va_farm->uc_storage_secondary = $request->input('storage.secondary');
    //                     $va_farm->uc_storage_tertiary = $request->input('storage.tertiary');
    //                     $va_farm->uc_storage_remarks = $request->input('storage.remarks');
    //                     $va_farm->uc_storage_primary_unit = $request->input('storage.primary_unit');
    //                     $va_farm->uc_storage_secondary_unit = $request->input('storage.secondary_unit');
    //                     $va_farm->uc_storage_tertiary_unit = $request->input('storage.tertiary_unit');
                        
    //                     // Assign plant machinery details
    //                     $va_farm->uc_pm_particulars = $request->input('plant_machinery.particulars');
    //                     $va_farm->uc_pm_primary = $request->input('plant_machinery.primary');
    //                     $va_farm->uc_pm_secondary = $request->input('plant_machinery.secondary');
    //                     $va_farm->uc_pm_tertiary = $request->input('plant_machinery.tertiary');
    //                     $va_farm->uc_pm_remarks = $request->input('plant_machinery.remarks');
    //                     $va_farm->uc_pm_primary_unit = $request->input('plant_machinery.primary_unit');
    //                     $va_farm->uc_pm_secondary_unit = $request->input('plant_machinery.secondary_unit');
    //                     $va_farm->uc_pm_tertiary_unit = $request->input('plant_machinery.tertiary_unit');
                        
    //                     // Assign plant machinery capacity details
    //                     $va_farm->uc_pm_capacity_particulars = $request->input('plant_machinery_capacity.particulars');
    //                     $va_farm->uc_pm_capacity_primary = $request->input('plant_machinery_capacity.primary');
    //                     $va_farm->uc_pm_capacity_secondary = $request->input('plant_machinery_capacity.secondary');
    //                     $va_farm->uc_pm_capacity_tertiary = $request->input('plant_machinery_capacity.tertiary');
    //                     $va_farm->uc_pm_capacity_remarks = $request->input('plant_machinery_capacity.remarks');
    //                     $va_farm->uc_pm_capacity_primary_unit = $request->input('plant_machinery_capacity.primary_unit');
    //                     $va_farm->uc_pm_capacity_secondary_unit = $request->input('plant_machinery_capacity.secondary_unit');
    //                     $va_farm->uc_pm_capacity_tertiary_unit = $request->input('plant_machinery_capacity.tertiary_unit');
                        
    //                     // Assign average operating capacity details
    //                     $va_farm->uc_avg_capacity_particulars = $request->input('average_operating_capacity.particulars');
    //                     $va_farm->uc_avg_capacity_primary = $request->input('average_operating_capacity.primary');
    //                     $va_farm->uc_avg_capacity_secondary = $request->input('average_operating_capacity.secondary');
    //                     $va_farm->uc_avg_capacity_tertiary = $request->input('average_operating_capacity.tertiary');
    //                     $va_farm->uc_avg_capacity_remarks = $request->input('average_operating_capacity.remarks');
    //                     $va_farm->uc_avg_capacity_primary_unit = $request->input('average_operating_capacity.primary_unit');
    //                     $va_farm->uc_avg_capacity_secondary_unit = $request->input('average_operating_capacity.secondary_unit');
    //                     $va_farm->uc_avg_capacity_tertiary_unit = $request->input('average_operating_capacity.tertiary_unit');
                     
    //                     // Assign annual running hours details
    //                     $va_farm->uc_arh_particulars = $request->input('annual_running_hours.particulars');
    //                     $va_farm->uc_arh_primary = $request->input('annual_running_hours.primary');
    //                     $va_farm->uc_arh_secondary = $request->input('annual_running_hours.secondary');
    //                     $va_farm->uc_arh_tertiary = $request->input('annual_running_hours.tertiary');
    //                     $va_farm->uc_arh_remarks = $request->input('annual_running_hours.remarks');
    //                     $va_farm->uc_arh_primary_unit = $request->input('annual_running_hours.primary_unit');
    //                     $va_farm->uc_arh_secondary_unit = $request->input('annual_running_hours.secondary_unit');
    //                     $va_farm->uc_arh_tertiary_unit = $request->input('annual_running_hours.tertiary_unit');
                        
    //                     // Assign produce annual processing details
    //                     $va_farm->uc_pap_particulars = $request->input('produce_annual_processing.particulars');
    //                     $va_farm->uc_pap_primary = $request->input('produce_annual_processing.primary');
    //                     $va_farm->uc_pap_secondary = $request->input('produce_annual_processing.secondary');
    //                     $va_farm->uc_pap_tertiary = $request->input('produce_annual_processing.tertiary');
    //                     $va_farm->uc_pap_remarks = $request->input('produce_annual_processing.remarks');
    //                     $va_farm->uc_pap_primary_unit = $request->input('produce_annual_processing.primary_unit');
    //                     $va_farm->uc_pap_secondary_unit = $request->input('produce_annual_processing.secondary_unit');
    //                     $va_farm->uc_pap_tertiary_unit = $request->input('produce_annual_processing.tertiary_unit');
                        
    //                     // Assign electricity annual expense details
    //                     $va_farm->uc_eae_particulars = $request->input('electricity_annual_expense.particulars');
    //                     $va_farm->uc_eae_primary = $request->input('electricity_annual_expense.primary');
    //                     $va_farm->uc_eae_secondary = $request->input('electricity_annual_expense.secondary');
    //                     $va_farm->uc_eae_tertiary = $request->input('electricity_annual_expense.tertiary');
    //                     $va_farm->uc_eae_remarks = $request->input('electricity_annual_expense.remarks');
    //                     $va_farm->uc_eae_primary_unit = $request->input('electricity_annual_expense.primary_unit');
    //                     $va_farm->uc_eae_secondary_unit = $request->input('electricity_annual_expense.secondary_unit');
    //                     $va_farm->uc_eae_tertiary_unit = $request->input('electricity_annual_expense.tertiary_unit');
                        
    //                     // Assign manpower annual expense details
    //                     $va_farm->uc_mae_particulars = $request->input('manpower_annual_expense.particulars');
    //                     $va_farm->uc_mae_primary = $request->input('manpower_annual_expense.primary');
    //                     $va_farm->uc_mae_secondary = $request->input('manpower_annual_expense.secondary');
    //                     $va_farm->uc_mae_tertiary = $request->input('manpower_annual_expense.tertiary');
    //                     $va_farm->uc_mae_remarks = $request->input('manpower_annual_expense.remarks');
    //                     $va_farm->uc_mae_primary_unit = $request->input('manpower_annual_expense.primary_unit');
    //                     $va_farm->uc_mae_secondary_unit = $request->input('manpower_annual_expense.secondary_unit');
    //                     $va_farm->uc_mae_tertiary_unit = $request->input('manpower_annual_expense.tertiary_unit');

    //                     // Assign rent annual details
    //                     $va_farm->uc_rent_annual_particulars = $request->input('rent_annual.particulars');
    //                     $va_farm->uc_rent_annual_primary = $request->input('rent_annual.primary');
    //                     $va_farm->uc_rent_annual_secondary = $request->input('rent_annual.secondary');
    //                     $va_farm->uc_rent_annual_tertiary = $request->input('rent_annual.tertiary');
    //                     $va_farm->uc_rent_annual_remarks = $request->input('rent_annual.remarks');
    //                     $va_farm->uc_rent_annual_primary_unit = $request->input('rent_annual.primary_unit');
    //                     $va_farm->uc_rent_annual_secondary_unit = $request->input('rent_annual.secondary_unit');
    //                     $va_farm->uc_rent_annual_tertiary_unit = $request->input('rent_annual.tertiary_unit');
                        
    //                     // Assign travelling expense annual details
    //                     $va_farm->uc_tea_particulars = $request->input('travelling_expense_annual.particulars');
    //                     $va_farm->uc_tea_primary = $request->input('travelling_expense_annual.primary');
    //                     $va_farm->uc_tea_secondary = $request->input('travelling_expense_annual.secondary');
    //                     $va_farm->uc_tea_tertiary = $request->input('travelling_expense_annual.tertiary');
    //                     $va_farm->uc_tea_remarks = $request->input('travelling_expense_annual.remarks');
    //                     $va_farm->uc_tea_primary_unit = $request->input('travelling_expense_annual.primary_unit');
    //                     $va_farm->uc_tea_secondary_unit = $request->input('travelling_expense_annual.secondary_unit');
    //                     $va_farm->uc_tea_tertiary_unit = $request->input('travelling_expense_annual.tertiary_unit');
                        
    //                     // Assign repair maintenance annual details
    //                     $va_farm->uc_rma_particulars = $request->input('repair_maintenance_annual.particulars');
    //                     $va_farm->uc_rma_primary = $request->input('repair_maintenance_annual.primary');
    //                     $va_farm->uc_rma_secondary = $request->input('repair_maintenance_annual.secondary');
    //                     $va_farm->uc_rma_tertiary = $request->input('repair_maintenance_annual.tertiary');
    //                     $va_farm->uc_rma_remarks = $request->input('repair_maintenance_annual.remarks');
    //                     $va_farm->uc_rma_primary_unit = $request->input('repair_maintenance_annual.primary_unit');
    //                     $va_farm->uc_rma_secondary_unit = $request->input('repair_maintenance_annual.secondary_unit');
    //                     $va_farm->uc_rma_tertiary_unit = $request->input('repair_maintenance_annual.tertiary_unit');
                        
    //                     // Assign insurance cost annual details
    //                     $va_farm->uc_ica_particulars = $request->input('insurance_cost_annual.particulars');
    //                     $va_farm->uc_ica_primary = $request->input('insurance_cost_annual.primary');
    //                     $va_farm->uc_ica_secondary = $request->input('insurance_cost_annual.secondary');
    //                     $va_farm->uc_ica_tertiary = $request->input('insurance_cost_annual.tertiary');
    //                     $va_farm->uc_ica_remarks = $request->input('insurance_cost_annual.remarks');
    //                     $va_farm->uc_ica_primary_unit = $request->input('insurance_cost_annual.primary_unit');
    //                     $va_farm->uc_ica_secondary_unit = $request->input('insurance_cost_annual.secondary_unit');
    //                     $va_farm->uc_ica_tertiary_unit = $request->input('insurance_cost_annual.tertiary_unit');
                        
    //                     // Assign misc admin cost annual details
    //                     $va_farm->uc_maca_particulars = $request->input('misc_admin_cost_annual.particulars');
    //                     $va_farm->uc_maca_primary = $request->input('misc_admin_cost_annual.primary');
    //                     $va_farm->uc_maca_secondary = $request->input('misc_admin_cost_annual.secondary');
    //                     $va_farm->uc_maca_tertiary = $request->input('misc_admin_cost_annual.tertiary');
    //                     $va_farm->uc_maca_remarks = $request->input('misc_admin_cost_annual.remarks');
    //                     $va_farm->uc_maca_primary_unit = $request->input('misc_admin_cost_annual.primary_unit');
    //                     $va_farm->uc_maca_secondary_unit = $request->input('misc_admin_cost_annual.secondary_unit');
    //                     $va_farm->uc_maca_tertiary_unit = $request->input('misc_admin_cost_annual.tertiary_unit');
                        
    //                     // Assign raw material purchase details
    //                     $va_farm->uc_rmp_particulars = $request->input('raw_material_purchase.particulars');
    //                     $va_farm->uc_rmp_primary = $request->input('raw_material_purchase.primary');
    //                     $va_farm->uc_rmp_secondary = $request->input('raw_material_purchase.secondary');
    //                     $va_farm->uc_rmp_tertiary = $request->input('raw_material_purchase.tertiary');
    //                     $va_farm->uc_rmp_remarks = $request->input('raw_material_purchase.remarks');
    //                     $va_farm->uc_rmp_primary_unit = $request->input('raw_material_purchase.primary_unit');
    //                     $va_farm->uc_rmp_secondary_unit = $request->input('raw_material_purchase.secondary_unit');
    //                     $va_farm->uc_rmp_tertiary_unit = $request->input('raw_material_purchase.tertiary_unit');
                        
    //                     // Assign farmer village purchase details
    //                     $va_farm->uc_fvp_particulars = $request->input('farmer_village_purchase.particulars');
    //                     $va_farm->uc_fvp_primary = $request->input('farmer_village_purchase.primary');
    //                     $va_farm->uc_fvp_secondary = $request->input('farmer_village_purchase.secondary');
    //                     $va_farm->uc_fvp_tertiary = $request->input('farmer_village_purchase.tertiary');
    //                     $va_farm->uc_fvp_remarks = $request->input('farmer_village_purchase.remarks');
    //                     $va_farm->uc_fvp_primary_unit = $request->input('farmer_village_purchase.primary_unit');
    //                     $va_farm->uc_fvp_secondary_unit = $request->input('farmer_village_purchase.secondary_unit');
    //                     $va_farm->uc_fvp_tertiary_unit = $request->input('farmer_village_purchase.tertiary_unit');
                        
    //                     // Assign local mandi purchase details
    //                     $va_farm->uc_lmp_particulars = $request->input('local_mandi_purchase.particulars');
    //                     $va_farm->uc_lmp_primary = $request->input('local_mandi_purchase.primary');
    //                     $va_farm->uc_lmp_secondary = $request->input('local_mandi_purchase.secondary');
    //                     $va_farm->uc_lmp_tertiary = $request->input('local_mandi_purchase.tertiary');
    //                     $va_farm->uc_lmp_remarks = $request->input('local_mandi_purchase.remarks');
    //                     $va_farm->uc_lmp_primary_unit = $request->input('local_mandi_purchase.primary_unit');
    //                     $va_farm->uc_lmp_secondary_unit = $request->input('local_mandi_purchase.secondary_unit');
    //                     $va_farm->uc_lmp_tertiary_unit = $request->input('local_mandi_purchase.tertiary_unit');


    //                     // Assign APMC purchase details
    //                     $va_farm->uc_apmc_particulars = $request->input('apmc_purchase.particulars');
    //                     $va_farm->uc_apmc_primary = $request->input('apmc_purchase.primary');
    //                     $va_farm->uc_apmc_secondary = $request->input('apmc_purchase.secondary');
    //                     $va_farm->uc_apmc_tertiary = $request->input('apmc_purchase.tertiary');
    //                     $va_farm->uc_apmc_remarks = $request->input('apmc_purchase.remarks');
    //                     $va_farm->uc_apmc_primary_unit = $request->input('apmc_purchase.primary_unit');
    //                     $va_farm->uc_apmc_secondary_unit = $request->input('apmc_purchase.secondary_unit');
    //                     $va_farm->uc_apmc_tertiary_unit = $request->input('apmc_purchase.tertiary_unit');
                        
    //                     // Assign commission agent purchase details
    //                     $va_farm->uc_cap_particulars = $request->input('commission_agent_purchase.particulars');
    //                     $va_farm->uc_cap_primary = $request->input('commission_agent_purchase.primary');
    //                     $va_farm->uc_cap_secondary = $request->input('commission_agent_purchase.secondary');
    //                     $va_farm->uc_cap_tertiary = $request->input('commission_agent_purchase.tertiary');
    //                     $va_farm->uc_cap_remarks = $request->input('commission_agent_purchase.remarks');
    //                     $va_farm->uc_cap_primary_unit = $request->input('commission_agent_purchase.primary_unit');
    //                     $va_farm->uc_cap_secondary_unit = $request->input('commission_agent_purchase.secondary_unit');
    //                     $va_farm->uc_cap_tertiary_unit = $request->input('commission_agent_purchase.tertiary_unit');
                        
    //                     // Assign wholesaler purchase details
    //                     $va_farm->uc_wp_particulars = $request->input('wholesaler_purchase.particulars');
    //                     $va_farm->uc_wp_primary = $request->input('wholesaler_purchase.primary');
    //                     $va_farm->uc_wp_secondary = $request->input('wholesaler_purchase.secondary');
    //                     $va_farm->uc_wp_tertiary = $request->input('wholesaler_purchase.tertiary');
    //                     $va_farm->uc_wp_remarks = $request->input('wholesaler_purchase.remarks');
    //                     $va_farm->uc_wp_primary_unit = $request->input('wholesaler_purchase.primary_unit');
    //                     $va_farm->uc_wp_secondary_unit = $request->input('wholesaler_purchase.secondary_unit');
    //                     $va_farm->uc_wp_tertiary_unit = $request->input('wholesaler_purchase.tertiary_unit');
                        
    //                     // Assign outside import details
    //                     $va_farm->uc_oimport_particulars = $request->input('outside_import.particulars');
    //                     $va_farm->uc_oimport_primary = $request->input('outside_import.primary');
    //                     $va_farm->uc_oimport_secondary = $request->input('outside_import.secondary');
    //                     $va_farm->uc_oimport_tertiary = $request->input('outside_import.tertiary');
    //                     $va_farm->uc_oimport_remarks = $request->input('outside_import.remarks');
    //                     $va_farm->uc_oimport_primary_unit = $request->input('outside_import.primary_unit');
    //                     $va_farm->uc_oimport_secondary_unit = $request->input('outside_import.secondary_unit');
    //                     $va_farm->uc_oimport_tertiary_unit = $request->input('outside_import.tertiary_unit');

    //                     // Assign primary processor purchase details
    //                     $va_farm->uc_ppp_particulars = $request->input('primary_processor_purchase.particulars');
    //                     $va_farm->uc_ppp_primary = $request->input('primary_processor_purchase.primary');
    //                     $va_farm->uc_ppp_secondary = $request->input('primary_processor_purchase.secondary');
    //                     $va_farm->uc_ppp_tertiary = $request->input('primary_processor_purchase.tertiary');
    //                     $va_farm->uc_ppp_remarks = $request->input('primary_processor_purchase.remarks');
    //                     $va_farm->uc_ppp_primary_unit = $request->input('primary_processor_purchase.primary_unit');
    //                     $va_farm->uc_ppp_secondary_unit = $request->input('primary_processor_purchase.secondary_unit');
    //                     $va_farm->uc_ppp_tertiary_unit = $request->input('primary_processor_purchase.tertiary_unit');
                        
    //                     // Assign secondary processor purchase details
    //                     $va_farm->uc_spp_particulars = $request->input('secondary_processor_purchase.particulars');
    //                     $va_farm->uc_spp_primary = $request->input('secondary_processor_purchase.primary');
    //                     $va_farm->uc_spp_secondary = $request->input('secondary_processor_purchase.secondary');
    //                     $va_farm->uc_spp_tertiary = $request->input('secondary_processor_purchase.tertiary');
    //                     $va_farm->uc_spp_remarks = $request->input('secondary_processor_purchase.remarks');
    //                     $va_farm->uc_spp_primary_unit = $request->input('secondary_processor_purchase.primary_unit');
    //                     $va_farm->uc_spp_secondary_unit = $request->input('secondary_processor_purchase.secondary_unit');
    //                     $va_farm->uc_spp_tertiary_unit = $request->input('secondary_processor_purchase.tertiary_unit');
                        
    //                     // Assign prevalent purchase mechanism details
    //                     $va_farm->uc_ppm_particulars = $request->input('prevalent_purchase_mechanism.particulars');
    //                     $va_farm->uc_ppm_primary = $request->input('prevalent_purchase_mechanism.primary');
    //                     $va_farm->uc_ppm_secondary = $request->input('prevalent_purchase_mechanism.secondary');
    //                     $va_farm->uc_ppm_tertiary = $request->input('prevalent_purchase_mechanism.tertiary');
    //                     $va_farm->uc_ppm_remarks = $request->input('prevalent_purchase_mechanism.remarks');
    //                     $va_farm->uc_ppm_primary_unit = $request->input('prevalent_purchase_mechanism.primary_unit');
    //                     $va_farm->uc_ppm_secondary_unit = $request->input('prevalent_purchase_mechanism.secondary_unit');
    //                     $va_farm->uc_ppm_tertiary_unit = $request->input('prevalent_purchase_mechanism.tertiary_unit');
                        
    //                     // Assign raw material regularity details
    //                     $va_farm->uc_rr_particulars = $request->input('raw_material_regularity.particulars');
    //                     $va_farm->uc_rr_primary = $request->input('raw_material_regularity.primary');
    //                     $va_farm->uc_rr_secondary = $request->input('raw_material_regularity.secondary');
    //                     $va_farm->uc_rr_tertiary = $request->input('raw_material_regularity.tertiary');
    //                     $va_farm->uc_rr_remarks = $request->input('raw_material_regularity.remarks');
    //                     $va_farm->uc_rr_primary_unit = $request->input('raw_material_regularity.primary_unit');
    //                     $va_farm->uc_rr_secondary_unit = $request->input('raw_material_regularity.secondary_unit');
    //                     $va_farm->uc_rr_tertiary_unit = $request->input('raw_material_regularity.tertiary_unit');
                        
    //                     // Assign raw material availability details
    //                     $va_farm->uc_rm_particulars = $request->input('raw_material_availability.particulars');
    //                     $va_farm->uc_rm_primary = $request->input('raw_material_availability.primary');
    //                     $va_farm->uc_rm_secondary = $request->input('raw_material_availability.secondary');
    //                     $va_farm->uc_rm_tertiary = $request->input('raw_material_availability.tertiary');
    //                     $va_farm->uc_rm_remarks = $request->input('raw_material_availability.remarks');
    //                     $va_farm->uc_rm_primary_unit = $request->input('raw_material_availability.primary_unit');
    //                     $va_farm->uc_rm_secondary_unit = $request->input('raw_material_availability.secondary_unit');
    //                     $va_farm->uc_rm_tertiary_unit = $request->input('raw_material_availability.tertiary_unit');
                        
    //                     // Assign quality issue details
    //                     $va_farm->uc_qi_particulars = $request->input('quality_issue.particulars');
    //                     $va_farm->uc_qi_primary = $request->input('quality_issue.primary');
    //                     $va_farm->uc_qi_secondary = $request->input('quality_issue.secondary');
    //                     $va_farm->uc_qi_tertiary = $request->input('quality_issue.tertiary');
    //                     $va_farm->uc_qi_remarks = $request->input('quality_issue.remarks');
    //                     $va_farm->uc_qi_primary_unit = $request->input('quality_issue.primary_unit');
    //                     $va_farm->uc_qi_secondary_unit = $request->input('quality_issue.secondary_unit');
    //                     $va_farm->uc_qi_tertiary_unit = $request->input('quality_issue.tertiary_unit');
                        
    //                     // Assign credit supplier advice details
    //                     $va_farm->uc_csa_particulars = $request->input('credit_supplier_advice.particulars');
    //                     $va_farm->uc_csa_primary = $request->input('credit_supplier_advice.primary');
    //                     $va_farm->uc_csa_secondary = $request->input('credit_supplier_advice.secondary');
    //                     $va_farm->uc_csa_tertiary = $request->input('credit_supplier_advice.tertiary');
    //                     $va_farm->uc_csa_remarks = $request->input('credit_supplier_advice.remarks');
    //                     $va_farm->uc_csa_primary_unit = $request->input('credit_supplier_advice.primary_unit');
    //                     $va_farm->uc_csa_secondary_unit = $request->input('credit_supplier_advice.secondary_unit');
    //                     $va_farm->uc_csa_tertiary_unit = $request->input('credit_supplier_advice.tertiary_unit');
                        
    //                     // Assign supplier credit duration details
    //                     $va_farm->uc_scd_particulars = $request->input('supplier_credit_duration.particulars');
    //                     $va_farm->uc_scd_primary = $request->input('supplier_credit_duration.primary');
    //                     $va_farm->uc_scd_secondary = $request->input('supplier_credit_duration.secondary');
    //                     $va_farm->uc_scd_tertiary = $request->input('supplier_credit_duration.tertiary');
    //                     $va_farm->uc_scd_remarks = $request->input('supplier_credit_duration.remarks');
    //                     $va_farm->uc_scd_primary_unit = $request->input('supplier_credit_duration.primary_unit');
    //                     $va_farm->uc_scd_secondary_unit = $request->input('supplier_credit_duration.secondary_unit');
    //                     $va_farm->uc_scd_tertiary_unit = $request->input('supplier_credit_duration.tertiary_unit');


    //                     // Assign supplier payment details
    //                     $va_farm->uc_sp_particulars = $request->input('supplier_payment.particulars');
    //                     $va_farm->uc_sp_primary = $request->input('supplier_payment.primary');
    //                     $va_farm->uc_sp_secondary = $request->input('supplier_payment.secondary');
    //                     $va_farm->uc_sp_tertiary = $request->input('supplier_payment.tertiary');
    //                     $va_farm->uc_sp_remarks = $request->input('supplier_payment.remarks');
    //                     $va_farm->uc_sp_primary_unit = $request->input('supplier_payment.primary_unit');
    //                     $va_farm->uc_sp_secondary_unit = $request->input('supplier_payment.secondary_unit');
    //                     $va_farm->uc_sp_tertiary_unit = $request->input('supplier_payment.tertiary_unit');
                        
    //                     // Assign sell through distributor details
    //                     $va_farm->uc_std_particulars = $request->input('sell_through_distributor.particulars');
    //                     $va_farm->uc_std_primary = $request->input('sell_through_distributor.primary');
    //                     $va_farm->uc_std_secondary = $request->input('sell_through_distributor.secondary');
    //                     $va_farm->uc_std_tertiary = $request->input('sell_through_distributor.tertiary');
    //                     $va_farm->uc_std_remarks = $request->input('sell_through_distributor.remarks');
    //                     $va_farm->uc_std_primary_unit = $request->input('sell_through_distributor.primary_unit');
    //                     $va_farm->uc_std_secondary_unit = $request->input('sell_through_distributor.secondary_unit');
    //                     $va_farm->uc_std_tertiary_unit = $request->input('sell_through_distributor.tertiary_unit');
                        
    //                     // Assign sell through retailers details
    //                     $va_farm->uc_str_particulars = $request->input('sell_through_retailers.particulars');
    //                     $va_farm->uc_str_primary = $request->input('sell_through_retailers.primary');
    //                     $va_farm->uc_str_secondary = $request->input('sell_through_retailers.secondary');
    //                     $va_farm->uc_str_tertiary = $request->input('sell_through_retailers.tertiary');
    //                     $va_farm->uc_str_remarks = $request->input('sell_through_retailers.remarks');
    //                     $va_farm->uc_str_primary_unit = $request->input('sell_through_retailers.primary_unit');
    //                     $va_farm->uc_str_secondary_unit = $request->input('sell_through_retailers.secondary_unit');
    //                     $va_farm->uc_str_tertiary_unit = $request->input('sell_through_retailers.tertiary_unit');
                        
    //                     // Assign sell through outlets details
    //                     $va_farm->uc_sto_particulars = $request->input('sell_through_outlets.particulars');
    //                     $va_farm->uc_sto_primary = $request->input('sell_through_outlets.primary');
    //                     $va_farm->uc_sto_secondary = $request->input('sell_through_outlets.secondary');
    //                     $va_farm->uc_sto_tertiary = $request->input('sell_through_outlets.tertiary');
    //                     $va_farm->uc_sto_remarks = $request->input('sell_through_outlets.remarks');
    //                     $va_farm->uc_sto_primary_unit = $request->input('sell_through_outlets.primary_unit');
    //                     $va_farm->uc_sto_secondary_unit = $request->input('sell_through_outlets.secondary_unit');
    //                     $va_farm->uc_sto_tertiary_unit = $request->input('sell_through_outlets.tertiary_unit');

    //                     // Assign online selling details
    //                     $va_farm->uc_os_particulars = $request->input('online_selling.particulars');
    //                     $va_farm->uc_os_primary = $request->input('online_selling.primary');
    //                     $va_farm->uc_os_secondary = $request->input('online_selling.secondary');
    //                     $va_farm->uc_os_tertiary = $request->input('online_selling.tertiary');
    //                     $va_farm->uc_os_remarks = $request->input('online_selling.remarks');
    //                     $va_farm->uc_os_primary_unit = $request->input('online_selling.primary_unit');
    //                     $va_farm->uc_os_secondary_unit = $request->input('online_selling.secondary_unit');
    //                     $va_farm->uc_os_tertiary_unit = $request->input('online_selling.tertiary_unit');
                        
    //                     // Assign export details
    //                     $va_farm->uc_ex_particulars = $request->input('export.particulars');
    //                     $va_farm->uc_ex_primary = $request->input('export.primary');
    //                     $va_farm->uc_ex_secondary = $request->input('export.secondary');
    //                     $va_farm->uc_ex_tertiary = $request->input('export.tertiary');
    //                     $va_farm->uc_ex_remarks = $request->input('export.remarks');
    //                     $va_farm->uc_ex_primary_unit = $request->input('export.primary_unit');
    //                     $va_farm->uc_ex_secondary_unit = $request->input('export.secondary_unit');
    //                     $va_farm->uc_ex_tertiary_unit = $request->input('export.tertiary_unit');
                        
    //                     // Assign other marketing details
    //                     $va_farm->uc_om_particulars = $request->input('other_marketing.particulars');
    //                     $va_farm->uc_om_primary = $request->input('other_marketing.primary');
    //                     $va_farm->uc_om_secondary = $request->input('other_marketing.secondary');
    //                     $va_farm->uc_om_tertiary = $request->input('other_marketing.tertiary');
    //                     $va_farm->uc_om_remarks = $request->input('other_marketing.remarks');
    //                     $va_farm->uc_om_primary_unit = $request->input('other_marketing.primary_unit');
    //                     $va_farm->uc_om_secondary_unit = $request->input('other_marketing.secondary_unit');
    //                     $va_farm->uc_om_tertiary_unit = $request->input('other_marketing.tertiary_unit');
                        
    //                     // Assign supply on credit details
    //                     $va_farm->uc_soc_particulars = $request->input('supply_on_credit.particulars');
    //                     $va_farm->uc_soc_primary = $request->input('supply_on_credit.primary');
    //                     $va_farm->uc_soc_secondary = $request->input('supply_on_credit.secondary');
    //                     $va_farm->uc_soc_tertiary = $request->input('supply_on_credit.tertiary');
    //                     $va_farm->uc_soc_remarks = $request->input('supply_on_credit.remarks');
    //                     $va_farm->uc_soc_primary_unit = $request->input('supply_on_credit.primary_unit');
    //                     $va_farm->uc_soc_secondary_unit = $request->input('supply_on_credit.secondary_unit');
    //                     $va_farm->uc_soc_tertiary_unit = $request->input('supply_on_credit.tertiary_unit');
                        
    //                     // Assign capital investment interest details
    //                     $va_farm->uc_cii_particulars = $request->input('capital_investment_interest.particulars');
    //                     $va_farm->uc_cii_primary = $request->input('capital_investment_interest.primary');
    //                     $va_farm->uc_cii_secondary = $request->input('capital_investment_interest.secondary');
    //                     $va_farm->uc_cii_tertiary = $request->input('capital_investment_interest.tertiary');
    //                     $va_farm->uc_cii_remarks = $request->input('capital_investment_interest.remarks');
    //                     $va_farm->uc_cii_primary_unit = $request->input('capital_investment_interest.primary_unit');
    //                     $va_farm->uc_cii_secondary_unit = $request->input('capital_investment_interest.secondary_unit');
    //                     $va_farm->uc_cii_tertiary_unit = $request->input('capital_investment_interest.tertiary_unit');
                        
    //                     // Assign working capital interest details
    //                     $va_farm->uc_wci_particulars = $request->input('working_capital_interest.particulars');
    //                     $va_farm->uc_wci_primary = $request->input('working_capital_interest.primary');
    //                     $va_farm->uc_wci_secondary = $request->input('working_capital_interest.secondary');
    //                     $va_farm->uc_wci_tertiary = $request->input('working_capital_interest.tertiary');
    //                     $va_farm->uc_wci_remarks = $request->input('working_capital_interest.remarks');
    //                     $va_farm->uc_wci_primary_unit = $request->input('working_capital_interest.primary_unit');
    //                     $va_farm->uc_wci_secondary_unit = $request->input('working_capital_interest.secondary_unit');
    //                     $va_farm->uc_wci_tertiary_unit = $request->input('working_capital_interest.tertiary_unit');
                        
    //                     // Assign other info details
    //                     $va_farm->uc_oi_particulars = $request->input('other_info.particulars');
    //                     $va_farm->uc_oi_primary = $request->input('other_info.primary');
    //                     $va_farm->uc_oi_secondary = $request->input('other_info.secondary');
    //                     $va_farm->uc_oi_tertiary = $request->input('other_info.tertiary');
    //                     $va_farm->uc_oi_remarks = $request->input('other_info.remarks');


    //                     //   dd($va_farm);
    //                     // Save the model
    //                     $va_farm->save();

    //                     return response()->json([
    //                     'status' => true,
    //                     'message' => 'VAFarm Units Characteristics Data Created Successfully',
    //                 ], 200);
    //     }
    //      catch (\Throwable $th) {
    //                         return response()->json([
    //                             'status' => false,
    //                             'message' => $th->getMessage()
    //                         ], 500);
    //                     }
    // }
    
    public function va_farm_two(Request $request)
    {
        try{
           $validator = Validator::make($request->all(), [
                // 'average_purchase_price_a' => 'string',
            ]);
                    if ($validator->fails()) {
                        return response()->json([
                            'remark' => 'validation_error',
                            'status' => 'error',
                            'message' => ['error' => $validator->errors()],
                        ]);
                    }
                    
                        $va_farm = new VaTwoFarm();
                        
                        $va_farm->user_id = Auth::user()->id;
                        
                        $va_farm->average_purchase_price_a = json_encode($request->average_purchase_price_a);
                        $va_farm->average_purchase_price_b = json_encode($request->average_purchase_price_b);
                        $va_farm->average_purchase_price_c = json_encode($request->average_purchase_price_c);
                        $va_farm->average_purchase_price_d = json_encode($request->average_purchase_price_d);
                        
                        $va_farm->primary_processed_produce_a = json_encode($request->primary_processed_produce_a);
                        
                        $va_farm->primary_processed_produce_b = json_encode($request->primary_processed_produce_b);
                        $va_farm->primary_processed_produce_c = json_encode($request->primary_processed_produce_c);
                        $va_farm->primary_processed_produce_d = json_encode($request->primary_processed_produce_d);
                        
                        
                        $va_farm->secondary_processed_produce_a = json_encode($request->secondary_processed_produce_a);
                        $va_farm->secondary_processed_produce_b = json_encode($request->secondary_processed_produce_b);
                        $va_farm->secondary_processed_produce_c = json_encode($request->secondary_processed_produce_c);
                        $va_farm->secondary_processed_produce_d = json_encode($request->secondary_processed_produce_d);
                        
                        $va_farm->transportation_cost = json_encode($request->transportation_cost);
                        
                        $va_farm->loading_and_unloading_charges = json_encode($request->loading_and_unloading_charges);
                        
                        
                        $va_farm->cost_of_primary_processing = json_encode($request->cost_of_primary_processing);
                        $va_farm->cost_of_secondary_processing = json_encode($request->cost_of_secondary_processing);
                        
                        $va_farm->cost_of_tertiary_processing = json_encode($request->cost_of_tertiary_processing);
                        $va_farm->value_of_drying_loss = json_encode($request->value_of_drying_loss);
                        $va_farm->weighing_cost = json_encode($request->weighing_cost);
                        $va_farm->packaging_cost = json_encode($request->packaging_cost);
                        $va_farm->branding_cost = json_encode($request->branding_cost);
                        
                        $va_farm->marketing_cost = json_encode($request->marketing_cost);
                        $va_farm->any_other_cost = json_encode($request->any_other_cost);
                        $va_farm->selling_price_a = json_encode($request->selling_price_a);
                        $va_farm->selling_price_b = json_encode($request->selling_price_b);
                        $va_farm->selling_price_c = json_encode($request->selling_price_c);
                        $va_farm->selling_price_d = json_encode($request->selling_price_d);

                        $va_farm->quantum_handled_year = json_encode($request->quantum_handled_year);
                          
                        $va_farm->purchase_and_selling_prices = json_encode($request->purchase_and_selling_prices);
                      
                        $va_farm->save();
                         
                    return response()->json([
                        'status' => true,
                        'message' => 'VAFarm Units Characteristics Data Created Successfully',
                    ], 200);
        }
         catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
         }
    }
    
    
    // old query
    //  public function va_farm_two(Request $request)
    //  {
    //     try{
    //         // dd($request->all());
    //                 $validator = Validator::make($request->all(), [
    //                             // 'business_economics.average_purchase.raw_produceI.particulars' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceI.primary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceI.secondary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceI.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceI.remarks' => 'string',

    //                             // 'business_economics.average_purchase.raw_produceII.particulars' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceII.primary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceII.secondary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceII.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceII.remarks' => 'string',
                                
    //                             // 'business_economics.average_purchase.raw_produceIII.particulars' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceIII.primary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceIII.secondary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceIII.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceIII.remarks' => 'string',
                                
    //                             // 'business_economics.average_purchase.raw_produceIV.particulars' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceIV.primary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceIV.secondary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceIV.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.raw_produceIV.remarks' => 'string',
                                
    //                             // 'business_economics.average_purchase.primary_processedI.particulars' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedI.primary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedI.secondary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedI.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedI.remarks' => 'string',
                            
    //                             // 'business_economics.average_purchase.primary_processedII.particulars' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedII.primary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedII.secondary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedII.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedII.remarks' => 'string',
                            
    //                             // 'business_economics.average_purchase.primary_processedIII.particulars' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedIII.primary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedIII.secondary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedIII.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedIII.remarks' => 'string',
                            
    //                             // 'business_economics.average_purchase.primary_processedIV.particulars' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedIV.primary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedIV.secondary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedIV.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.primary_processedIV.remarks' => 'string',
                                
    //                             //  'business_economics.average_purchase.secondary_processedI.particulars' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedI.primary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedI.secondary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedI.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedI.remarks' => 'string',
                                
    //                             // 'business_economics.average_purchase.secondary_processedII.particulars' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedII.primary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedII.secondary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedII.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedII.remarks' => 'string',
                                
    //                             // 'business_economics.average_purchase.secondary_processedIII.particulars' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedIII.primary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedIII.secondary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedIII.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedIII.remarks' => 'string',
                                
    //                             // 'business_economics.average_purchase.secondary_processedIV.particulars' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedIV.primary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedIV.secondary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedIV.tertiary' => 'string',
    //                             // 'business_economics.average_purchase.secondary_processedIV.remarks' => 'string',
                                
    //                             //  'business_economics.value_addition_cost.transportation_cost' => 'numeric',
    //                             // 'business_economics.value_addition_cost.loading_unloading_cost' => 'numeric',
    //                             // 'business_economics.value_addition_cost.primary_processing_cost' => 'numeric',
    //                             // 'business_economics.value_addition_cost.secondary_processing_cost' => 'numeric',
    //                             // 'business_economics.value_addition_cost.tertiary_processing_cost' => 'numeric',
    //                             // 'business_economics.value_addition_cost.dry_other_loss' => 'numeric',
    //                             // 'business_economics.value_addition_cost.weigh_cost' => 'numeric',
    //                             // 'business_economics.value_addition_cost.packaging_cost' => 'numeric',
    //                             // 'business_economics.value_addition_cost.branding_cost' => 'numeric',
    //                             // 'business_economics.value_addition_cost.marketing_cost' => 'numeric',
    //                             // 'business_economics.value_addition_cost.other_cost' => 'numeric',
                                
    //                             // 'business_economics.selling_price.byproduct_a.particulars' => 'string',
    //                             // 'business_economics.selling_price.byproduct_a.primary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_a.secondary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_a.tertiary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_a.remarks' => 'string',
                            
    //                             // 'business_economics.selling_price.byproduct_b.particulars' => 'string',
    //                             // 'business_economics.selling_price.byproduct_b.primary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_b.secondary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_b.tertiary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_b.remarks' => 'string',
                            
    //                             // 'business_economics.selling_price.byproduct_c.particulars' => 'string',
    //                             // 'business_economics.selling_price.byproduct_c.primary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_c.secondary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_c.tertiary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_c.remarks' => 'string',
                            
    //                             // 'business_economics.selling_price.byproduct_d.particulars' => 'string',
    //                             // 'business_economics.selling_price.byproduct_d.primary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_d.secondary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_d.tertiary' => 'string',
    //                             // 'business_economics.selling_price.byproduct_d.remarks' => 'string',
                                
    //                             // 'business_economics.other_cost_paramater.quantum_handled' => 'numeric',
    //                             // 'business_economics.other_cost_paramater.price_fluctuations' => 'string',
                              
    //                         ]);



    //                 if ($validator->fails()) {
    //                     return response()->json([
    //                         'remark' => 'validation_error',
    //                         'status' => 'error',
    //                         'message' => ['error' => $validator->errors()],
    //                     ]);
    //                 }
                    
                    
    //                     $va_farm = new VaTwoFarm();
                       
    //                     $va_farm->user_id = Auth::user()->id;
                        
    //                     // Assign raw produce I details
    //                     $va_farm->be_ap_rpI_particulars = $request->input('average_purchase.raw_produceI.particulars');
    //                     $va_farm->be_ap_rpI_primary = $request->input('average_purchase.raw_produceI.primary');
    //                     $va_farm->be_ap_rpI_primary_unit = $request->input('average_purchase.raw_produceI.primary_unit');
    //                     $va_farm->be_ap_rpI_secondary = $request->input('average_purchase.raw_produceI.secondary');
    //                     $va_farm->be_ap_rpI_secondary_unit = $request->input('average_purchase.raw_produceI.secondary_unit');
    //                     $va_farm->be_ap_rpI_tertiary = $request->input('average_purchase.raw_produceI.tertiary');
    //                     $va_farm->be_ap_rpI_tertiary_unit = $request->input('average_purchase.raw_produceI.tertiary_unit');
    //                     $va_farm->be_ap_rpI_remarks = $request->input('average_purchase.raw_produceI.remarks');
                        
    //                     // Assign raw produce II details
    //                     $va_farm->be_ap_rpII_particulars = $request->input('average_purchase.raw_produceII.particulars');
    //                     $va_farm->be_ap_rpII_primary = $request->input('average_purchase.raw_produceII.primary');
    //                     $va_farm->be_ap_rpII_primary_unit = $request->input('average_purchase.raw_produceII.primary_unit');
    //                     $va_farm->be_ap_rpII_secondary = $request->input('average_purchase.raw_produceII.secondary');
    //                     $va_farm->be_ap_rpII_secondary_unit = $request->input('average_purchase.raw_produceII.secondary_unit');
    //                     $va_farm->be_ap_rpII_tertiary = $request->input('average_purchase.raw_produceII.tertiary');
    //                     $va_farm->be_ap_rpII_tertiary_unit = $request->input('average_purchase.raw_produceII.tertiary_unit');
    //                     $va_farm->be_ap_rpII_remarks = $request->input('average_purchase.raw_produceII.remarks');
                        
    //                     // Assign raw produce III details
    //                     $va_farm->be_ap_rpIII_particulars = $request->input('average_purchase.raw_produceIII.particulars');
    //                     $va_farm->be_ap_rpIII_primary = $request->input('average_purchase.raw_produceIII.primary');
    //                     $va_farm->be_ap_rpIII_primary_unit = $request->input('average_purchase.raw_produceIII.primary_unit');
    //                     $va_farm->be_ap_rpIII_secondary = $request->input('average_purchase.raw_produceIII.secondary');
    //                     $va_farm->be_ap_rpIII_secondary_unit = $request->input('average_purchase.raw_produceIII.secondary_unit');
    //                     $va_farm->be_ap_rpIII_tertiary = $request->input('average_purchase.raw_produceIII.tertiary');
    //                     $va_farm->be_ap_rpIII_tertiary_unit = $request->input('average_purchase.raw_produceIII.tertiary_unit');
    //                     $va_farm->be_ap_rpIII_remarks = $request->input('average_purchase.raw_produceIII.remarks');
                        
    //                     // Assign raw produce IV details
    //                     $va_farm->be_ap_rpIV_particulars = $request->input('average_purchase.raw_produceIV.particulars');
    //                     $va_farm->be_ap_rpIV_primary = $request->input('average_purchase.raw_produceIV.primary');
    //                     $va_farm->be_ap_rpIV_primary_unit = $request->input('average_purchase.raw_produceIV.primary_unit');
    //                     $va_farm->be_ap_rpIV_secondary = $request->input('average_purchase.raw_produceIV.secondary');
    //                     $va_farm->be_ap_rpIV_secondary_unit = $request->input('average_purchase.raw_produceIV.secondary_unit');
    //                     $va_farm->be_ap_rpIV_tertiary = $request->input('average_purchase.raw_produceIV.tertiary');
    //                     $va_farm->be_ap_rpIV_tertiary_unit = $request->input('average_purchase.raw_produceIV.tertiary_unit');
    //                     $va_farm->be_ap_rpIV_remarks = $request->input('average_purchase.raw_produceIV.remarks');
                        
    //                     // Assign primary processed I details
    //                     $va_farm->be_ap_ppI_particulars = $request->input('average_purchase.primary_processedI.particulars');
    //                     $va_farm->be_ap_ppI_primary = $request->input('average_purchase.primary_processedI.primary');
    //                     $va_farm->be_ap_ppI_primary_unit = $request->input('average_purchase.primary_processedI.primary_unit');
    //                     $va_farm->be_ap_ppI_secondary = $request->input('average_purchase.primary_processedI.secondary');
    //                     $va_farm->be_ap_ppI_secondary_unit = $request->input('average_purchase.primary_processedI.secondary_unit');
    //                     $va_farm->be_ap_ppI_tertiary = $request->input('average_purchase.primary_processedI.tertiary');
    //                     $va_farm->be_ap_ppI_tertiary_unit = $request->input('average_purchase.primary_processedI.tertiary_unit');
    //                     $va_farm->be_ap_ppI_remarks = $request->input('average_purchase.primary_processedI.remarks');
                        
    //                     // Assign primary processed II details
    //                     $va_farm->be_ap_ppII_particulars = $request->input('average_purchase.primary_processedII.particulars');
    //                     $va_farm->be_ap_ppII_primary = $request->input('average_purchase.primary_processedII.primary');
    //                     $va_farm->be_ap_ppII_primary_unit = $request->input('average_purchase.primary_processedII.primary_unit');
    //                     $va_farm->be_ap_ppII_secondary = $request->input('average_purchase.primary_processedII.secondary');
    //                     $va_farm->be_ap_ppII_secondary_unit = $request->input('average_purchase.primary_processedII.secondary_unit');
    //                     $va_farm->be_ap_ppII_tertiary = $request->input('average_purchase.primary_processedII.tertiary');
    //                     $va_farm->be_ap_ppII_tertiary_unit = $request->input('average_purchase.primary_processedII.tertiary_unit');
    //                     $va_farm->be_ap_ppII_remarks = $request->input('average_purchase.primary_processedII.remarks');
                        
    //                     // Assign primary processed III details
    //                     $va_farm->be_ap_ppIII_particulars = $request->input('average_purchase.primary_processedIII.particulars');
    //                     $va_farm->be_ap_ppIII_primary = $request->input('average_purchase.primary_processedIII.primary');
    //                     $va_farm->be_ap_ppIII_primary_unit = $request->input('average_purchase.primary_processedIII.primary_unit');
    //                     $va_farm->be_ap_ppIII_secondary = $request->input('average_purchase.primary_processedIII.secondary');
    //                     $va_farm->be_ap_ppIII_secondary_unit = $request->input('average_purchase.primary_processedIII.secondary_unit');
    //                     $va_farm->be_ap_ppIII_tertiary = $request->input('average_purchase.primary_processedIII.tertiary');
    //                     $va_farm->be_ap_ppIII_tertiary_unit = $request->input('average_purchase.primary_processedIII.tertiary_unit');
    //                     $va_farm->be_ap_ppIII_remarks = $request->input('average_purchase.primary_processedIII.remarks');
                        
    //                     // Assign primary processed IV details
    //                     $va_farm->be_ap_ppIV_particulars = $request->input('average_purchase.primary_processedIV.particulars');
    //                     $va_farm->be_ap_ppIV_primary = $request->input('average_purchase.primary_processedIV.primary');
    //                     $va_farm->be_ap_ppIV_primary_unit = $request->input('average_purchase.primary_processedIV.primary_unit');
    //                     $va_farm->be_ap_ppIV_secondary = $request->input('average_purchase.primary_processedIV.secondary');
    //                     $va_farm->be_ap_ppIV_secondary_unit = $request->input('average_purchase.primary_processedIV.secondary_unit');
    //                     $va_farm->be_ap_ppIV_tertiary = $request->input('average_purchase.primary_processedIV.tertiary');
    //                     $va_farm->be_ap_ppIV_tertiary_unit = $request->input('average_purchase.primary_processedIV.tertiary_unit');
    //                     $va_farm->be_ap_ppIV_remarks = $request->input('average_purchase.primary_processedIV.remarks');
                        
    //                     // Assign supplier payment I details
    //                     $va_farm->be_ap_spI_particulars = $request->input('average_purchase.secondary_processedI.particulars');
    //                     $va_farm->be_ap_spI_primary = $request->input('average_purchase.secondary_processedI.primary');
    //                     $va_farm->be_ap_spI_primary_unit = $request->input('average_purchase.secondary_processedI.primary_unit');
    //                     $va_farm->be_ap_spI_secondary = $request->input('average_purchase.secondary_processedI.secondary');
    //                     $va_farm->be_ap_spI_secondary_unit = $request->input('average_purchase.secondary_processedI.secondary_unit');
    //                     $va_farm->be_ap_spI_tertiary = $request->input('average_purchase.secondary_processedI.tertiary');
    //                     $va_farm->be_ap_spI_tertiary_unit = $request->input('average_purchase.secondary_processedI.tertiary_unit');
    //                     $va_farm->be_ap_spI_remarks = $request->input('average_purchase.secondary_processedI.remarks');
                        
    //                     // Assign supplier payment II details
    //                     $va_farm->be_ap_spII_particulars = $request->input('average_purchase.secondary_processedII.particulars');
    //                     $va_farm->be_ap_spII_primary = $request->input('average_purchase.secondary_processedII.primary');
    //                     $va_farm->be_ap_spII_primary_unit = $request->input('average_purchase.secondary_processedII.primary_unit');
    //                     $va_farm->be_ap_spII_secondary = $request->input('average_purchase.secondary_processedII.secondary');
    //                     $va_farm->be_ap_spII_secondary_unit = $request->input('average_purchase.secondary_processedII.secondary_unit');
    //                     $va_farm->be_ap_spII_tertiary = $request->input('average_purchase.secondary_processedII.tertiary');
    //                     $va_farm->be_ap_spII_tertiary_unit = $request->input('average_purchase.secondary_processedII.tertiary_unit');
    //                     $va_farm->be_ap_spII_remarks = $request->input('average_purchase.secondary_processedII.remarks');
                        
    //                     // Assign supplier payment III details
    //                     $va_farm->be_ap_spIII_particulars = $request->input('average_purchase.secondary_processedIII.particulars');
    //                     $va_farm->be_ap_spIII_primary = $request->input('average_purchase.secondary_processedIII.primary');
    //                     $va_farm->be_ap_spIII_primary_unit = $request->input('average_purchase.secondary_processedIII.primary_unit');
    //                     $va_farm->be_ap_spIII_secondary = $request->input('average_purchase.secondary_processedIII.secondary');
    //                     $va_farm->be_ap_spIII_secondary_unit = $request->input('average_purchase.secondary_processedIII.secondary_unit');
    //                     $va_farm->be_ap_spIII_tertiary = $request->input('average_purchase.secondary_processedIII.tertiary');
    //                     $va_farm->be_ap_spIII_tertiary_unit = $request->input('average_purchase.secondary_processedIII.tertiary_unit');
    //                     $va_farm->be_ap_spIII_remarks = $request->input('average_purchase.secondary_processedIII.remarks');
                        
    //                     // Assign supplier payment IV details
    //                     $va_farm->be_ap_spIV_particulars = $request->input('average_purchase.secondary_processedIV.particulars');
    //                     $va_farm->be_ap_spIV_primary = $request->input('average_purchase.secondary_processedIV.primary');
    //                     $va_farm->be_ap_spIV_primary_unit = $request->input('average_purchase.secondary_processedIV.primary_unit');
    //                     $va_farm->be_ap_spIV_secondary = $request->input('average_purchase.secondary_processedIV.secondary');
    //                     $va_farm->be_ap_spIV_secondary_unit = $request->input('average_purchase.secondary_processedIV.secondary_unit');
    //                     $va_farm->be_ap_spIV_tertiary = $request->input('average_purchase.secondary_processedIV.tertiary');
    //                     $va_farm->be_ap_spIV_tertiary_unit = $request->input('average_purchase.secondary_processedIV.tertiary_unit');
    //                     $va_farm->be_ap_spIV_remarks = $request->input('average_purchase.secondary_processedIV.remarks');
                        
    //                     // Assign value addition cost details
    //                     $va_farm->vac_tc_particulars = $request->input('value_addition_cost.transportation_cost.particulars');
    //                     $va_farm->vac_luc_particulars = $request->input('value_addition_cost.loading_unloading_cost.particulars');
    //                     $va_farm->vac_ppc_particulars = $request->input('value_addition_cost.primary_processing_cost.particulars');
    //                     $va_farm->vac_spc_particulars = $request->input('value_addition_cost.secondary_processing_cost.particulars');
    //                     $va_farm->vac_tpc_particulars = $request->input('value_addition_cost.tertiary_processing_cost.particulars');
    //                     $va_farm->vac_dol_particulars = $request->input('value_addition_cost.dry_other_loss.particulars');
    //                     $va_farm->vac_wc_particulars = $request->input('value_addition_cost.weigh_cost.particulars');
    //                     $va_farm->vac_pc_particulars = $request->input('value_addition_cost.packaging_cost.particulars');
    //                     $va_farm->vac_bc_particulars = $request->input('value_addition_cost.branding_cost.particulars');
    //                     $va_farm->vac_mc_particulars = $request->input('value_addition_cost.marketing_cost.particulars');
    //                     $va_farm->vac_oc_particulars = $request->input('value_addition_cost.other_cost.particulars');
                        
    //                     $va_farm->vac_tc_primary = $request->input('value_addition_cost.transportation_cost.primary');
    //                     $va_farm->vac_tc_primary_unit = $request->input('value_addition_cost.transportation_cost.primary_unit');
    //                     $va_farm->vac_luc_primary = $request->input('value_addition_cost.loading_unloading_cost.primary');
    //                     $va_farm->vac_luc_primary_unit = $request->input('value_addition_cost.loading_unloading_cost.primary_unit');
    //                     $va_farm->vac_ppc_primary = $request->input('value_addition_cost.primary_processing_cost.primary');
    //                     $va_farm->vac_ppc_primary_unit = $request->input('value_addition_cost.primary_processing_cost.primary_unit');
    //                     $va_farm->vac_spc_primary = $request->input('value_addition_cost.secondary_processing_cost.primary');
    //                     $va_farm->vac_spc_primary_unit = $request->input('value_addition_cost.secondary_processing_cost.primary_unit');
    //                     $va_farm->vac_tpc_primary = $request->input('value_addition_cost.tertiary_processing_cost.primary');
    //                     $va_farm->vac_tpc_primary_unit = $request->input('value_addition_cost.tertiary_processing_cost.primary_unit');
    //                     $va_farm->vac_dol_primary = $request->input('value_addition_cost.dry_other_loss.primary');
    //                     $va_farm->vac_dol_primary_unit = $request->input('value_addition_cost.dry_other_loss.primary_unit');
    //                     $va_farm->vac_wc_primary = $request->input('value_addition_cost.weigh_cost.primary');
    //                     $va_farm->vac_wc_primary_unit = $request->input('value_addition_cost.weigh_cost.primary_unit');
    //                     $va_farm->vac_pc_primary = $request->input('value_addition_cost.packaging_cost.primary');
    //                     $va_farm->vac_pc_primary_unit = $request->input('value_addition_cost.packaging_cost.primary_unit');
    //                     $va_farm->vac_bc_primary = $request->input('value_addition_cost.branding_cost.primary');
    //                     $va_farm->vac_bc_primary_unit = $request->input('value_addition_cost.branding_cost.primary_unit');
    //                     $va_farm->vac_mc_primary = $request->input('value_addition_cost.marketing_cost.primary');
    //                     $va_farm->vac_mc_primary_unit = $request->input('value_addition_cost.marketing_cost.primary_unit');
    //                     $va_farm->vac_oc_primary = $request->input('value_addition_cost.other_cost.primary');
    //                     $va_farm->vac_oc_primary_unit = $request->input('value_addition_cost.other_cost.primary_unit');

                        
                        
    //                     $va_farm->vac_tc_secondary = $request->input('value_addition_cost.transportation_cost.secondary');
    //                     $va_farm->vac_tc_secondary_unit = $request->input('value_addition_cost.transportation_cost.secondary_unit');
    //                     $va_farm->vac_luc_secondary = $request->input('value_addition_cost.loading_unloading_cost.secondary');
    //                     $va_farm->vac_luc_secondary_unit = $request->input('value_addition_cost.loading_unloading_cost.secondary_unit');
    //                     $va_farm->vac_ppc_secondary = $request->input('value_addition_cost.secondary_processing_cost.secondary');
    //                     $va_farm->vac_ppc_secondary_unit = $request->input('value_addition_cost.secondary_processing_cost.secondary_unit');
    //                     $va_farm->vac_spc_secondary = $request->input('value_addition_cost.secondary_processing_cost.secondary');
    //                     $va_farm->vac_spc_secondary_unit = $request->input('value_addition_cost.secondary_processing_cost.secondary_unit');
    //                     $va_farm->vac_tpc_secondary = $request->input('value_addition_cost.tertiary_processing_cost.secondary');
    //                     $va_farm->vac_tpc_secondary_unit = $request->input('value_addition_cost.tertiary_processing_cost.secondary_unit');
    //                     $va_farm->vac_dol_secondary = $request->input('value_addition_cost.dry_other_loss.secondary');
    //                     $va_farm->vac_dol_secondary_unit = $request->input('value_addition_cost.dry_other_loss.secondary_unit');
    //                     $va_farm->vac_wc_secondary = $request->input('value_addition_cost.weigh_cost.secondary');
    //                     $va_farm->vac_wc_secondary_unit = $request->input('value_addition_cost.weigh_cost.secondary_unit');
    //                     $va_farm->vac_pc_secondary = $request->input('value_addition_cost.packaging_cost.secondary');
    //                     $va_farm->vac_pc_secondary_unit = $request->input('value_addition_cost.packaging_cost.secondary_unit');
    //                     $va_farm->vac_bc_secondary = $request->input('value_addition_cost.branding_cost.secondary');
    //                     $va_farm->vac_bc_secondary_unit = $request->input('value_addition_cost.branding_cost.secondary_unit');
    //                     $va_farm->vac_mc_secondary = $request->input('value_addition_cost.marketing_cost.secondary');
    //                     $va_farm->vac_mc_secondary_unit = $request->input('value_addition_cost.marketing_cost.secondary_unit');
    //                     $va_farm->vac_oc_secondary = $request->input('value_addition_cost.other_cost.secondary');
    //                     $va_farm->vac_oc_secondary_unit = $request->input('value_addition_cost.other_cost.secondary_unit');

                        
                        
    //                     $va_farm->vac_tc_tertiary = $request->input('value_addition_cost.transportation_cost.tertiary');
    //                     $va_farm->vac_tc_tertiary_uint = $request->input('value_addition_cost.transportation_cost.tertiary_unit');
    //                     $va_farm->vac_luc_tertiary = $request->input('value_addition_cost.loading_unloading_cost.tertiary');
    //                     $va_farm->vac_luc_tertiary_unit = $request->input('value_addition_cost.loading_unloading_cost.tertiary_unit');
    //                     $va_farm->vac_ppc_tertiary = $request->input('value_addition_cost.tertiary_processing_cost.tertiary');
    //                     $va_farm->vac_ppc_tertiary_unit = $request->input('value_addition_cost.tertiary_processing_cost.tertiary_unit');
    //                     $va_farm->vac_spc_tertiary = $request->input('value_addition_cost.tertiary_processing_cost.tertiary');
    //                     $va_farm->vac_spc_tertiary_unit = $request->input('value_addition_cost.tertiary_processing_cost.tertiary_unit');
    //                     $va_farm->vac_tpc_tertiary = $request->input('value_addition_cost.tertiary_processing_cost.tertiary');
    //                     $va_farm->vac_tpc_tertiary_unit = $request->input('value_addition_cost.tertiary_processing_cost.tertiary_unit');
    //                     $va_farm->vac_dol_tertiary = $request->input('value_addition_cost.dry_other_loss.tertiary');
    //                     $va_farm->vac_dol_tertiary_unit = $request->input('value_addition_cost.dry_other_loss.tertiary_unit');
    //                     $va_farm->vac_wc_tertiary = $request->input('value_addition_cost.weigh_cost.tertiary');
    //                     $va_farm->vac_wc_tertiary_unit = $request->input('value_addition_cost.weigh_cost.tertiary_unit');
    //                     $va_farm->vac_pc_tertiary = $request->input('value_addition_cost.packaging_cost.tertiary');
    //                     $va_farm->vac_pc_tertiary_unit = $request->input('value_addition_cost.packaging_cost.tertiary_unit');
    //                     $va_farm->vac_bc_tertiary = $request->input('value_addition_cost.branding_cost.tertiary');
    //                     $va_farm->vac_bc_tertiary_unit = $request->input('value_addition_cost.branding_cost.tertiary_unit');
    //                     $va_farm->vac_mc_tertiary = $request->input('value_addition_cost.marketing_cost.tertiary');
    //                     $va_farm->vac_mc_tertiary_unit = $request->input('value_addition_cost.marketing_cost.tertiary_unit');
    //                     $va_farm->vac_oc_tertiary = $request->input('value_addition_cost.other_cost.tertiary');
    //                     $va_farm->vac_oc_tertiary_unit = $request->input('value_addition_cost.other_cost.tertiary_unit');

    //                     $va_farm->vac_tc_remarks = $request->input('value_addition_cost.transportation_cost.remarks');
    //                     $va_farm->vac_luc_remarks = $request->input('value_addition_cost.loading_unloading_cost.remarks');
    //                     $va_farm->vac_ppc_remarks = $request->input('value_addition_cost.remarks_processing_cost.remarks');
    //                     $va_farm->vac_spc_remarks = $request->input('value_addition_cost.remarks_processing_cost.remarks');
    //                     $va_farm->vac_tpc_remarks = $request->input('value_addition_cost.remarks_processing_cost.remarks');
    //                     $va_farm->vac_dol_remarks = $request->input('value_addition_cost.dry_other_loss.remarks');
    //                     $va_farm->vac_wc_remarks = $request->input('value_addition_cost.weigh_cost.remarks');
    //                     $va_farm->vac_pc_remarks = $request->input('value_addition_cost.packaging_cost.remarks');
    //                     $va_farm->vac_bc_remarks = $request->input('value_addition_cost.branding_cost.remarks');
    //                     $va_farm->vac_mc_remarks = $request->input('value_addition_cost.marketing_cost.remarks');
    //                     $va_farm->vac_oc_remarks = $request->input('value_addition_cost.other_cost.remarks');
                        
    //                     // Assign selling price details for byproduct A
    //                     $va_farm->sp_ba_particulars = $request->input('selling_price.byproduct_a.particulars');
    //                     $va_farm->sp_ba_primary = $request->input('selling_price.byproduct_a.primary');
    //                     $va_farm->sp_ba_primary_unit = $request->input('selling_price.byproduct_a.primary_unit');
    //                     $va_farm->sp_ba_secondary = $request->input('selling_price.byproduct_a.secondary');
    //                     $va_farm->sp_ba_secondary_unit = $request->input('selling_price.byproduct_a.secondary_unit');
    //                     $va_farm->sp_ba_tertiary = $request->input('selling_price.byproduct_a.tertiary');
    //                     $va_farm->sp_ba_tertiary_unit = $request->input('selling_price.byproduct_a.tertiary_unit');
    //                     $va_farm->sp_ba_remarks = $request->input('selling_price.byproduct_a.remarks');
                        
    //                     // Assign selling price details for byproduct B
    //                     $va_farm->sp_bb_particulars = $request->input('selling_price.byproduct_b.particulars');
    //                     $va_farm->sp_bb_primary = $request->input('selling_price.byproduct_b.primary');
    //                     $va_farm->sp_bb_primary_unit = $request->input('selling_price.byproduct_b.primary_unit');
    //                     $va_farm->sp_bb_secondary = $request->input('selling_price.byproduct_b.secondary');
    //                     $va_farm->sp_bb_secondary_unit = $request->input('selling_price.byproduct_b.secondary_unit');
    //                     $va_farm->sp_bb_tertiary = $request->input('selling_price.byproduct_b.tertiary');
    //                     $va_farm->sp_bb_tertiary_unit = $request->input('selling_price.byproduct_b.tertiary_unit');
    //                     $va_farm->sp_bb_remarks = $request->input('selling_price.byproduct_b.remarks');
                        
    //                     // Assign selling price details for byproduct C
    //                     $va_farm->sp_bc_particulars = $request->input('selling_price.byproduct_c.particulars');
    //                     $va_farm->sp_bc_primary = $request->input('selling_price.byproduct_c.primary');
    //                     $va_farm->sp_bc_primary_unit = $request->input('selling_price.byproduct_c.primary_unit');
    //                     $va_farm->sp_bc_secondary = $request->input('selling_price.byproduct_c.secondary');
    //                     $va_farm->sp_bc_secondary_unit = $request->input('selling_price.byproduct_c.secondary_unit');
    //                     $va_farm->sp_bc_tertiary = $request->input('selling_price.byproduct_c.tertiary');
    //                     $va_farm->sp_bc_tertiary_unit = $request->input('selling_price.byproduct_c.tertiary_unit');
    //                     $va_farm->sp_bc_remarks = $request->input('selling_price.byproduct_c.remarks');
                        
    //                     // Assign selling price details for byproduct D
    //                     $va_farm->sp_bd_particulars = $request->input('selling_price.byproduct_d.particulars');
    //                     $va_farm->sp_bd_primary = $request->input('selling_price.byproduct_d.primary');
    //                     $va_farm->sp_bd_primary_unit = $request->input('selling_price.byproduct_d.primary_unit');
    //                     $va_farm->sp_bd_secondary = $request->input('selling_price.byproduct_d.secondary');
    //                     $va_farm->sp_bd_secondary_unit = $request->input('selling_price.byproduct_d.secondary_unit');
    //                     $va_farm->sp_bd_tertiary = $request->input('selling_price.byproduct_d.tertiary');
    //                     $va_farm->sp_bd_tertiary_unit = $request->input('selling_price.byproduct_d.tertiary_unit');
    //                     $va_farm->sp_bd_remarks = $request->input('selling_price.byproduct_d.remarks');
                        
    //                     // Assign other cost parameter details
    //                     $va_farm->ocp_qh = $request->input('other_cost_paramater.quantum_handled');   
    //                     $va_farm->ocp_qh_unit = $request->input('other_cost_paramater.quantum_handled_unit');
    //                     $va_farm->ocp_pf = $request->input('other_cost_paramater.price_fluctuations');
                        
                        
    //                     // Save the model
    //                     $va_farm->save();

    //                     return response()->json([
    //                     'status' => true,
    //                     'message' => 'VAFarm Business Economics Data Created Successfully',
    //                 ], 200);
    //     }
    //      catch (\Throwable $th) {
    //         //  dd($th);
    //                         return response()->json([
    //                             'status' => false,
    //                             'message' => $th->getMessage()
    //                         ], 500);
    //                     }
    // }
    
    
    
    public function va_farm_three(Request $request)
    {
        try{
           $validator = Validator::make($request->all(), [
                // 'average_purchase_price_a' => 'string',
            ]);
                   if ($validator->fails()) {
                        return response()->json([
                            'remark' => 'validation_error',
                            'status' => 'error',
                            'message' => ['error' => $validator->errors()],
                        ]);
                    }
                    
                        $va_farm = new VaThreeFarm();
                        $va_farm->user_id = Auth::user()->id;
                        $va_farm->abundant_availability_of_raw_material = json_encode($request->abundant_availability_of_raw_material);
                        $va_farm->government_support = json_encode($request->government_support);
                        $va_farm->market_demand = json_encode($request->market_demand);
                        $va_farm->niche_market = json_encode($request->niche_market);
                        $va_farm->skilled_unskilled_labour = json_encode($request->skilled_unskilled_labour);
                        $va_farm->infrastructure_and_support_services = json_encode($request->infrastructure_and_support_services);
                        $va_farm->quality_and_standard = json_encode($request->quality_and_standard);
                        $va_farm->competitor = json_encode($request->competitor);
                        $va_farm->cost_of_financial_resources = json_encode($request->cost_of_financial_resources);
                        $va_farm->access_to_updated_technology = json_encode($request->access_to_updated_technology);
                        $va_farm->seasonality_of_raw_material = json_encode($request->seasonality_of_raw_material);
                        $va_farm->social_factor = json_encode($request->social_factor);
                        $va_farm->technological_factor = json_encode($request->technological_factor);
                        $va_farm->legal_factor = json_encode($request->legal_factor);
                        $va_farm->political_factor = json_encode($request->political_factor);
                        $va_farm->economic_factors = json_encode($request->economic_factors);
                        $va_farm->environmental_factor = json_encode($request->environmental_factor);
                        $va_farm->any_other = json_encode($request->any_other);
                        $va_farm->threat_social_factor = json_encode($request->threat_social_factor);
                        $va_farm->threat_technological_factor = json_encode($request->threat_technological_factor);
                        $va_farm->threat_legal_factor = json_encode($request->threat_legal_factor);
                        $va_farm->threat_political_factor = json_encode($request->threat_political_factor);
                        $va_farm->threat_economic_factors = json_encode($request->threat_economic_factors);
                        $va_farm->threat_environmental_factor = json_encode($request->threat_environmental_factor);
                        $va_farm->threat_any_other = json_encode($request->threat_any_other);
                        $va_farm->save();
                        return response()->json([
                        'status' => true,
                        'message' => 'VAFarm Units Characteristics Data Created Successfully',
                    ], 200);
        }
         catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
         }
    }
    
    // old query
    // public function va_farm_three(Request $request)
    // {
    //     try{
    //         // dd($request->all());
    //                 $validator = Validator::make($request->all(), [
    //                             // 'swot_analysis.strengthI.particulars' => 'string',
    //                             // 'swot_analysis.strengthI.primary' => 'string',
    //                             // 'swot_analysis.strengthI.secondary' => 'string',
    //                             // 'swot_analysis.strengthI.tertiary' => 'string',
    //                             // 'swot_analysis.strengthI.remarks' => 'string',
                            
    //                             // 'swot_analysis.strengthII.particulars' => 'string',
    //                             // 'swot_analysis.strengthII.primary' => 'string',
    //                             // 'swot_analysis.strengthII.secondary' => 'string',
    //                             // 'swot_analysis.strengthII.tertiary' => 'string',
    //                             // 'swot_analysis.strengthII.remarks' => 'string',
                            
    //                             // 'swot_analysis.strengthIII.particulars' => 'string',
    //                             // 'swot_analysis.strengthIII.primary' => 'string',
    //                             // 'swot_analysis.strengthIII.secondary' => 'string',
    //                             // 'swot_analysis.strengthIII.tertiary' => 'string',
    //                             // 'swot_analysis.strengthIII.remarks' => 'string',
                            
    //                             // 'swot_analysis.strengthIV.particulars' => 'string',
    //                             // 'swot_analysis.strengthIV.primary' => 'string',
    //                             // 'swot_analysis.strengthIV.secondary' => 'string',
    //                             // 'swot_analysis.strengthIV.tertiary' => 'string',
    //                             // 'swot_analysis.strengthIV.remarks' => 'string',
                            
    //                             // 'swot_analysis.strengthV.particulars' => 'string',
    //                             // 'swot_analysis.strengthV.primary' => 'string',
    //                             // 'swot_analysis.strengthV.secondary' => 'string',
    //                             // 'swot_analysis.strengthV.tertiary' => 'string',
    //                             // 'swot_analysis.strengthV.remarks' => 'string',
                                
    //                             // 'swot_analysis.weaknessI.particulars' => 'string',
    //                             // 'swot_analysis.weaknessI.primary' => 'string',
    //                             // 'swot_analysis.weaknessI.secondary' => 'string',
    //                             // 'swot_analysis.weaknessI.tertiary' => 'string',
    //                             // 'swot_analysis.weaknessI.remarks' => 'string',
                            
    //                             // 'swot_analysis.weaknessII.particulars' => 'string',
    //                             // 'swot_analysis.weaknessII.primary' => 'string',
    //                             // 'swot_analysis.weaknessII.secondary' => 'string',
    //                             // 'swot_analysis.weaknessII.tertiary' => 'string',
    //                             // 'swot_analysis.weaknessII.remarks' => 'string',
                            
    //                             // 'swot_analysis.weaknessIII.particulars' => 'string',
    //                             // 'swot_analysis.weaknessIII.primary' => 'string',
    //                             // 'swot_analysis.weaknessIII.secondary' => 'string',
    //                             // 'swot_analysis.weaknessIII.tertiary' => 'string',
    //                             // 'swot_analysis.weaknessIII.remarks' => 'string',
                            
    //                             // 'swot_analysis.weaknessIV.particulars' => 'string',
    //                             // 'swot_analysis.weaknessIV.primary' => 'string',
    //                             // 'swot_analysis.weaknessIV.secondary' => 'string',
    //                             // 'swot_analysis.weaknessIV.tertiary' => 'string',
    //                             // 'swot_analysis.weaknessIV.remarks' => 'string',
                            
    //                             // 'swot_analysis.weaknessV.particulars' => 'string',
    //                             // 'swot_analysis.weaknessV.primary' => 'string',
    //                             // 'swot_analysis.weaknessV.secondary' => 'string',
    //                             // 'swot_analysis.weaknessV.tertiary' => 'string',
    //                             // 'swot_analysis.weaknessV.remarks' => 'string',
                            
    //                             // 'swot_analysis.weaknessVI.particulars' => 'string',
    //                             // 'swot_analysis.weaknessVI.primary' => 'string',
    //                             // 'swot_analysis.weaknessVI.secondary' => 'string',
    //                             // 'swot_analysis.weaknessVI.tertiary' => 'string',
    //                             // 'swot_analysis.weaknessVI.remarks' => 'string',
    
    //                             //  'swot_analysis.opportunitiesI.particulars' => 'string',
    //                             // 'swot_analysis.opportunitiesI.primary' => 'string',
    //                             // 'swot_analysis.opportunitiesI.secondary' => 'string',
    //                             // 'swot_analysis.opportunitiesI.tertiary' => 'string',
    //                             // 'swot_analysis.opportunitiesI.remarks' => 'string',
                            
    //                             // 'swot_analysis.opportunitiesII.particulars' => 'string',
    //                             // 'swot_analysis.opportunitiesII.primary' => 'string',
    //                             // 'swot_analysis.opportunitiesII.secondary' => 'string',
    //                             // 'swot_analysis.opportunitiesII.tertiary' => 'string',
    //                             // 'swot_analysis.opportunitiesII.remarks' => 'string',
                            
    //                             // 'swot_analysis.opportunitiesIII.particulars' => 'string',
    //                             // 'swot_analysis.opportunitiesIII.primary' => 'string',
    //                             // 'swot_analysis.opportunitiesIII.secondary' => 'string',
    //                             // 'swot_analysis.opportunitiesIII.tertiary' => 'string',
    //                             // 'swot_analysis.opportunitiesIII.remarks' => 'string',
                            
    //                             // 'swot_analysis.opportunitiesIV.particulars' => 'string',
    //                             // 'swot_analysis.opportunitiesIV.primary' => 'string',
    //                             // 'swot_analysis.opportunitiesIV.secondary' => 'string',
    //                             // 'swot_analysis.opportunitiesIV.tertiary' => 'string',
    //                             // 'swot_analysis.opportunitiesIV.remarks' => 'string',
                            
    //                             // 'swot_analysis.opportunitiesV.particulars' => 'string',
    //                             // 'swot_analysis.opportunitiesV.primary' => 'string',
    //                             // 'swot_analysis.opportunitiesV.secondary' => 'string',
    //                             // 'swot_analysis.opportunitiesV.tertiary' => 'string',
    //                             // 'swot_analysis.opportunitiesV.remarks' => 'string',
                            
    //                             // 'swot_analysis.opportunitiesVI.particulars' => 'string',
    //                             // 'swot_analysis.opportunitiesVI.primary' => 'string',
    //                             // 'swot_analysis.opportunitiesVI.secondary' => 'string',
    //                             // 'swot_analysis.opportunitiesVI.tertiary' => 'string',
    //                             // 'swot_analysis.opportunitiesVI.remarks' => 'string',
                                
    //                             // 'swot_analysis.opportunitiesVII.particulars' => 'string',
    //                             // 'swot_analysis.opportunitiesVII.primary' => 'string',
    //                             // 'swot_analysis.opportunitiesVII.secondary' => 'string',
    //                             // 'swot_analysis.opportunitiesVII.tertiary' => 'string',
    //                             // 'swot_analysis.opportunitiesVII.remarks' => 'string',
                                
    //                             //  'swot_analysis.threatsI.particulars' => 'string',
    //                             // 'swot_analysis.threatsI.primary' => 'string',
    //                             // 'swot_analysis.threatsI.secondary' => 'string',
    //                             // 'swot_analysis.threatsI.tertiary' => 'string',
    //                             // 'swot_analysis.threatsI.remarks' => 'string',
                            
    //                             // 'swot_analysis.threatsII.particulars' => 'string',
    //                             // 'swot_analysis.threatsII.primary' => 'string',
    //                             // 'swot_analysis.threatsII.secondary' => 'string',
    //                             // 'swot_analysis.threatsII.tertiary' => 'string',
    //                             // 'swot_analysis.threatsII.remarks' => 'string',
                            
    //                             // 'swot_analysis.threatsIII.particulars' => 'string',
    //                             // 'swot_analysis.threatsIII.primary' => 'string',
    //                             // 'swot_analysis.threatsIII.secondary' => 'string',
    //                             // 'swot_analysis.threatsIII.tertiary' => 'string',
    //                             // 'swot_analysis.threatsIII.remarks' => 'string',
                            
    //                             // 'swot_analysis.threatsIV.particulars' => 'string',
    //                             // 'swot_analysis.threatsIV.primary' => 'string',
    //                             // 'swot_analysis.threatsIV.secondary' => 'string',
    //                             // 'swot_analysis.threatsIV.tertiary' => 'string',
    //                             // 'swot_analysis.threatsIV.remarks' => 'string',
                            
    //                             // 'swot_analysis.threatsV.particulars' => 'string',
    //                             // 'swot_analysis.threatsV.primary' => 'string',
    //                             // 'swot_analysis.threatsV.secondary' => 'string',
    //                             // 'swot_analysis.threatsV.tertiary' => 'string',
    //                             // 'swot_analysis.threatsV.remarks' => 'string',
                                
    //                             // 'swot_analysis.threatsVI.particulars' => 'string',
    //                             // 'swot_analysis.threatsVI.primary' => 'string',
    //                             // 'swot_analysis.threatsVI.secondary' => 'string',
    //                             // 'swot_analysis.threatsVI.tertiary' => 'string',
    //                             // 'swot_analysis.threatsVI.remarks' => 'string',
                                
    //                             // 'swot_analysis.threatsVII.particulars' => 'string',
    //                             // 'swot_analysis.threatsVII.primary' => 'string',
    //                             // 'swot_analysis.threatsVII.secondary' => 'string',
    //                             // 'swot_analysis.threatsVII.tertiary' => 'string',
    //                             // 'swot_analysis.threatsVII.remarks' => 'string',
                                
    //                         ]);



    //                 if ($validator->fails()) {
    //                     return response()->json([
    //                         'remark' => 'validation_error',
    //                         'status' => 'error',
    //                         'message' => ['error' => $validator->errors()],
    //                     ]);
    //                 }
                    
                    
    //                   $va_farm = new VaThreeFarm();
                       
    //                     $va_farm->user_id = Auth::user()->id;
                        
    //                     // Assign strength I details
    //                         $va_farm->swot_strengthI_particulars = $request->input('swot_analysis.strengthI.particulars');
    //                         $va_farm->swot_strengthI_primary = $request->input('swot_analysis.strengthI.primary');
    //                         $va_farm->swot_strengthI_secondary = $request->input('swot_analysis.strengthI.secondary');
    //                         $va_farm->swot_strengthI_tertiary = $request->input('swot_analysis.strengthI.tertiary');
    //                         $va_farm->swot_strengthI_remarks = $request->input('swot_analysis.strengthI.remarks');
                            
    //                         // Assign strength II details
    //                         $va_farm->swot_strengthII_particulars = $request->input('swot_analysis.strengthII.particulars');
    //                         $va_farm->swot_strengthII_primary = $request->input('swot_analysis.strengthII.primary');
    //                         $va_farm->swot_strengthII_secondary = $request->input('swot_analysis.strengthII.secondary');
    //                         $va_farm->swot_strengthII_tertiary = $request->input('swot_analysis.strengthII.tertiary');
    //                         $va_farm->swot_strengthII_remarks = $request->input('swot_analysis.strengthII.remarks');
                            
    //                         // Assign strength III details
    //                         $va_farm->swot_strengthIII_particulars = $request->input('swot_analysis.strengthIII.particulars');
    //                         $va_farm->swot_strengthIII_primary = $request->input('swot_analysis.strengthIII.primary');
    //                         $va_farm->swot_strengthIII_secondary = $request->input('swot_analysis.strengthIII.secondary');
    //                         $va_farm->swot_strengthIII_tertiary = $request->input('swot_analysis.strengthIII.tertiary');
    //                         $va_farm->swot_strengthIII_remarks = $request->input('swot_analysis.strengthIII.remarks');
                            
    //                         // Assign strength IV details
    //                         $va_farm->swot_strengthIV_particulars = $request->input('swot_analysisstrengthIV.particulars');
    //                         $va_farm->swot_strengthIV_primary = $request->input('swot_analysis.strengthIV.primary');
    //                         $va_farm->swot_strengthIV_secondary = $request->input('swot_analysis.strengthIV.secondary');
    //                         $va_farm->swot_strengthIV_tertiary = $request->input('swot_analysis.strengthIV.tertiary');
    //                         $va_farm->swot_strengthIV_remarks = $request->input('swot_analysis.strengthIV.remarks');
                            
    //                         // Assign strength V details
    //                         $va_farm->swot_strengthV_particulars = $request->input('swot_analysis.strengthV.particulars');
    //                         $va_farm->swot_strengthV_primary = $request->input('swot_analysis.strengthV.primary');
    //                         $va_farm->swot_strengthV_secondary = $request->input('swot_analysis.strengthV.secondary');
    //                         $va_farm->swot_strengthV_tertiary = $request->input('swot_analysis.strengthV.tertiary');
    //                         $va_farm->swot_strengthV_remarks = $request->input('swot_analysis.strengthV.remarks');
                            
    //                         // Assign weakness I details
    //                         $va_farm->swot_weaknessI_particulars = $request->input('swot_analysis.weaknessI.particulars');
    //                         $va_farm->swot_weaknessI_primary = $request->input('swot_analysis.weaknessI.primary');
    //                         $va_farm->swot_weaknessI_secondary = $request->input('swot_analysis.weaknessI.secondary');
    //                         $va_farm->swot_weaknessI_tertiary = $request->input('swot_analysis.weaknessI.tertiary');
    //                         $va_farm->swot_weaknessI_remarks = $request->input('swot_analysis.weaknessI.remarks');
                            
    //                         // Assign weakness II details
    //                         $va_farm->swot_weaknessII_particulars = $request->input('swot_analysis.weaknessII.particulars');
    //                         $va_farm->swot_weaknessII_primary = $request->input('swot_analysis.weaknessII.primary');
    //                         $va_farm->swot_weaknessII_secondary = $request->input('swot_analysis.weaknessII.secondary');
    //                         $va_farm->swot_weaknessII_tertiary = $request->input('swot_analysis.weaknessII.tertiary');
    //                         $va_farm->swot_weaknessII_remarks = $request->input('swot_analysis.weaknessII.remarks');
                            
    //                         // Assign weakness III details
    //                         $va_farm->swot_weaknessIII_particulars = $request->input('swot_analysis.weaknessIII.particulars');
    //                         $va_farm->swot_weaknessIII_primary = $request->input('swot_analysis.weaknessIII.primary');
    //                         $va_farm->swot_weaknessIII_secondary = $request->input('swot_analysis.weaknessIII.secondary');
    //                         $va_farm->swot_weaknessIII_tertiary = $request->input('swot_analysis.weaknessIII.tertiary');
    //                         $va_farm->swot_weaknessIII_remarks = $request->input('swot_analysis.weaknessIII.remarks');
                            
    //                         // Assign weakness IV details
    //                         $va_farm->swot_weaknessIV_particulars = $request->input('swot_analysis.weaknessIV.particulars');
    //                         $va_farm->swot_weaknessIV_primary = $request->input('swot_analysis.weaknessIV.primary');
    //                         $va_farm->swot_weaknessIV_secondary = $request->input('swot_analysis.weaknessIV.secondary');
    //                         $va_farm->swot_weaknessIV_tertiary = $request->input('swot_analysis.weaknessIV.tertiary');
    //                         $va_farm->swot_weaknessIV_remarks = $request->input('swot_analysis.weaknessIV.remarks');
                            
    //                         // Assign weakness V details
    //                         $va_farm->swot_weaknessV_particulars = $request->input('swot_analysis.weaknessV.particulars');
    //                         $va_farm->swot_weaknessV_primary = $request->input('swot_analysis.weaknessV.primary');
    //                         $va_farm->swot_weaknessV_secondary = $request->input('swot_analysis.weaknessV.secondary');
    //                         $va_farm->swot_weaknessV_tertiary = $request->input('swot_analysis.weaknessV.tertiary');
    //                         $va_farm->swot_weaknessV_remarks = $request->input('swot_analysis.weaknessV.remarks');
                            
    //                         // Assign weakness VI details
    //                         $va_farm->swot_weaknessVI_particulars = $request->input('swot_analysis.weaknessVI.particulars');
    //                         $va_farm->swot_weaknessVI_primary = $request->input('swot_analysis.weaknessVI.primary');
    //                         $va_farm->swot_weaknessVI_secondary = $request->input('swot_analysis.weaknessVI.secondary');
    //                         $va_farm->swot_weaknessVI_tertiary = $request->input('swot_analysis.weaknessVI.tertiary');
    //                         $va_farm->swot_weaknessVI_remarks = $request->input('swot_analysis.weaknessVI.remarks');
                            
    //                         // Assign opportunities I details
    //                         $va_farm->swot_opportunitiesI_particulars = $request->input('swot_analysis.opportunitiesI.particulars');
    //                         $va_farm->swot_opportunitiesI_primary = $request->input('swot_analysis.opportunitiesI.primary');
    //                         $va_farm->swot_opportunitiesI_secondary = $request->input('swot_analysis.opportunitiesI.secondary');
    //                         $va_farm->swot_opportunitiesI_tertiary = $request->input('swot_analysis.opportunitiesI.tertiary');
    //                         $va_farm->swot_opportunitiesI_remarks = $request->input('swot_analysis.opportunitiesI.remarks');
                            
    //                         // Assign opportunities II details
    //                         $va_farm->swot_opportunitiesII_particulars = $request->input('swot_analysis.opportunitiesII.particulars');
    //                         $va_farm->swot_opportunitiesII_primary = $request->input('swot_analysis.opportunitiesII.primary');
    //                         $va_farm->swot_opportunitiesII_secondary = $request->input('swot_analysis.opportunitiesII.secondary');
    //                         $va_farm->swot_opportunitiesII_tertiary = $request->input('swot_analysis.opportunitiesII.tertiary');
    //                         $va_farm->swot_opportunitiesII_remarks = $request->input('swot_analysis.opportunitiesII.remarks');
                            
    //                         // Assign opportunities III details
    //                         $va_farm->swot_opportunitiesIII_particulars = $request->input('swot_analysis.opportunitiesIII.particulars');
    //                         $va_farm->swot_opportunitiesIII_primary = $request->input('swot_analysis.opportunitiesIII.primary');
    //                         $va_farm->swot_opportunitiesIII_secondary = $request->input('swot_analysis.opportunitiesIII.secondary');
    //                         $va_farm->swot_opportunitiesIII_tertiary = $request->input('swot_analysis.opportunitiesIII.tertiary');
    //                         $va_farm->swot_opportunitiesIII_remarks = $request->input('swot_analysis.opportunitiesIII.remarks');
                            
    //                         // Assign opportunities IV details
    //                         $va_farm->swot_opportunitiesIV_particulars = $request->input('swot_analysis.opportunitiesIV.particulars');
    //                         $va_farm->swot_opportunitiesIV_primary = $request->input('swot_analysis.opportunitiesIV.primary');
    //                         $va_farm->swot_opportunitiesIV_secondary = $request->input('swot_analysis.opportunitiesIV.secondary');
    //                         $va_farm->swot_opportunitiesIV_tertiary = $request->input('swot_analysis.opportunitiesIV.tertiary');
    //                         $va_farm->swot_opportunitiesIV_remarks = $request->input('swot_analysis.opportunitiesIV.remarks');
                            
    //                         // Assign opportunities V details
    //                         $va_farm->swot_opportunitiesV_particulars = $request->input('swot_analysis.opportunitiesV.particulars');
    //                         $va_farm->swot_opportunitiesV_primary = $request->input('swot_analysis.opportunitiesV.primary');
    //                         $va_farm->swot_opportunitiesV_secondary = $request->input('swot_analysis.opportunitiesV.secondary');
    //                         $va_farm->swot_opportunitiesV_tertiary = $request->input('swot_analysis.opportunitiesV.tertiary');
    //                         $va_farm->swot_opportunitiesV_remarks = $request->input('swot_analysis.opportunitiesV.remarks');
                            
    //                         // Assign opportunities VI details
    //                         $va_farm->swot_opportunitiesVI_particulars = $request->input('swot_analysis.opportunitiesVI.particulars');
    //                         $va_farm->swot_opportunitiesVI_primary = $request->input('swot_analysis.opportunitiesVI.primary');
    //                         $va_farm->swot_opportunitiesVI_secondary = $request->input('swot_analysis.opportunitiesVI.secondary');
    //                         $va_farm->swot_opportunitiesVI_tertiary = $request->input('swot_analysis.opportunitiesVI.tertiary');
    //                         $va_farm->swot_opportunitiesVI_remarks = $request->input('swot_analysis.opportunitiesVI.remarks');
                            
    //                         // Assign opportunities VII details
    //                         $va_farm->swot_opportunitiesVII_particulars = $request->input('swot_analysis.opportunitiesVII.particulars');
    //                         $va_farm->swot_opportunitiesVII_primary = $request->input('swot_analysis.opportunitiesVII.primary');
    //                         $va_farm->swot_opportunitiesVII_secondary = $request->input('swot_analysis.opportunitiesVII.secondary');
    //                         $va_farm->swot_opportunitiesVII_tertiary = $request->input('swot_analysis.opportunitiesVII.tertiary');
    //                         $va_farm->swot_opportunitiesVII_remarks = $request->input('swot_analysis.opportunitiesVII.remarks');
                         
    //                       // Assign threats I details
    //                         $va_farm->swot_threatsI_particulars = $request->input('swot_analysis.threatsI.particulars');
    //                         $va_farm->swot_threatsI_primary = $request->input('swot_analysis.threatsI.primary');
    //                         $va_farm->swot_threatsI_secondary = $request->input('swot_analysis.threatsI.secondary');
    //                         $va_farm->swot_threatsI_tertiary = $request->input('swot_analysis.threatsI.tertiary');
    //                         $va_farm->swot_threatsI_remarks = $request->input('swot_analysis.threatsI.remarks');
                            
    //                         // Assign threats II details
    //                         $va_farm->swot_threatsII_particulars = $request->input('swot_analysis.threatsII.particulars');
    //                         $va_farm->swot_threatsII_primary = $request->input('swot_analysis.threatsII.primary');
    //                         $va_farm->swot_threatsII_secondary = $request->input('swot_analysis.threatsII.secondary');
    //                         $va_farm->swot_threatsII_tertiary = $request->input('swot_analysis.threatsII.tertiary');
    //                         $va_farm->swot_threatsII_remarks = $request->input('swot_analysis.threatsII.remarks');
                            
    //                         // Assign threats III details
    //                         $va_farm->swot_threatsIII_particulars = $request->input('swot_analysis.threatsIII.particulars');
    //                         $va_farm->swot_threatsIII_primary = $request->input('swot_analysis.threatsIII.primary');
    //                         $va_farm->swot_threatsIII_secondary = $request->input('swot_analysis.threatsIII.secondary');
    //                         $va_farm->swot_threatsIII_tertiary = $request->input('swot_analysis.threatsIII.tertiary');
    //                         $va_farm->swot_threatsIII_remarks = $request->input('swot_analysis.threatsIII.remarks');
                            
    //                         // Assign threats IV details
    //                         $va_farm->swot_threatsIV_particulars = $request->input('swot_analysis.threatsIV.particulars');
    //                         $va_farm->swot_threatsIV_primary = $request->input('swot_analysis.threatsIV.primary');
    //                         $va_farm->swot_threatsIV_secondary = $request->input('swot_analysis.threatsIV.secondary');
    //                         $va_farm->swot_threatsIV_tertiary = $request->input('swot_analysis.threatsIV.tertiary');
    //                         $va_farm->swot_threatsIV_remarks = $request->input('swot_analysis.threatsIV.remarks');
                            
    //                         // Assign threats V details
    //                         $va_farm->swot_threatsV_particulars = $request->input('swot_analysis.threatsV.particulars');
    //                         $va_farm->swot_threatsV_primary = $request->input('swot_analysis.threatsV.primary');
    //                         $va_farm->swot_threatsV_secondary = $request->input('swot_analysis.threatsV.secondary');
    //                         $va_farm->swot_threatsV_tertiary = $request->input('swot_analysis.threatsV.tertiary');
    //                         $va_farm->swot_threatsV_remarks = $request->input('swot_analysis.threatsV.remarks');
                            
    //                         // Assign threats V details
    //                         $va_farm->swot_threatsVI_particulars = $request->input('swot_analysis.threatsVI.particulars');
    //                         $va_farm->swot_threatsVI_primary = $request->input('swot_analysis.threatsVI.primary');
    //                         $va_farm->swot_threatsVI_secondary = $request->input('swot_analysis.threatsVI.secondary');
    //                         $va_farm->swot_threatsVI_tertiary = $request->input('swot_analysis.threatsVI.tertiary');
    //                         $va_farm->swot_threatsVI_remarks = $request->input('swot_analysis.threatsVI.remarks');
                            
    //                         // Assign threats V details
    //                         $va_farm->swot_threatsVII_particulars = $request->input('swot_analysis.threatsVII.particulars');
    //                         $va_farm->swot_threatsVII_primary = $request->input('swot_analysis.threatsVII.primary');
    //                         $va_farm->swot_threatsVII_secondary = $request->input('swot_analysis.threatsVII.secondary');
    //                         $va_farm->swot_threatsVII_tertiary = $request->input('swot_analysis.threatsVII.tertiary');
    //                         $va_farm->swot_threatsVII_remarks = $request->input('swot_analysis.threatsVII.remarks');

    //                     //   dd($va_farm);
    //                     // Save the model
    //                     $va_farm->save();

    //                     return response()->json([
    //                     'status' => true,
    //                     'message' => 'VAFarm Swot Analysis Data Created Successfully',
    //                 ], 200);
    //     }
    //      catch (\Throwable $th) {
    //                         return response()->json([
    //                             'status' => false,
    //                             'message' => $th->getMessage()
    //                         ], 500);
    //                     }
    // }
    
    
    
    public function distributor(Request $request)
    {
        try{
            $validator = Validator::make($request->all(), [
                // 'cost_of_establishment' => 'string',
            ]);
                    if ($validator->fails()) {
                        return response()->json([
                            'remark' => 'validation_error',
                            'status' => 'error',
                            'message' => ['error' => $validator->errors()],
                        ]);
                    }
                    
                        $distri = new distributor();
                        $distri->user_id = Auth::user()->id;
                        
                        $distri->cost_of_establishment = json_encode($request->cost_of_establishment);
                        $distri->cost_of_establishment_permanent = json_encode($request->cost_of_establishment_permanent);
                        $distri->cost_of_establishment_temporary = json_encode($request->cost_of_establishment_temporary);
                        
                        $distri->cost_storage_structure = json_encode($request->cost_storage_structure);
                        $distri->monthly_expenses_electricity = json_encode($request->monthly_expenses_electricity);
                        $distri->monthly_expenses_on_manpower = json_encode($request->monthly_expenses_on_manpower);
                        $distri->monthly_rent = json_encode($request->monthly_rent);
                        $distri->monthly_travelling_expense = json_encode($request->monthly_travelling_expense);
                        $distri->annual_interest_cost_on_capital = json_encode($request->annual_interest_cost_on_capital);
                        $distri->any_other_fixed_cost = json_encode($request->any_other_fixed_cost);
                        $distri->annual_interest_cost_on_working_capital = json_encode($request->annual_interest_cost_on_working_capital);
                        $distri->purchase_from_farmer_at_village_level = json_encode($request->purchase_from_farmer_at_village_level);
                        $distri->purchase_from_farmer_at_local_mandi = json_encode($request->purchase_from_farmer_at_local_mandi);
                        $distri->purchase_from_commission_agent = json_encode($request->purchase_from_commission_agent);
                        $distri->purchase_from_primary_processor = json_encode($request->purchase_from_primary_processor);
                        $distri->purchase_from_secondary_processor = json_encode($request->purchase_from_secondary_processor);
                        $distri->purchase_from_tertiary_processor = json_encode($request->purchase_from_tertiary_processor);
                        $distri->any_other_channel = json_encode($request->any_other_channel);
                        $distri->most_prevalent_purchase_mechanism = json_encode($request->most_prevalent_purchase_mechanism);
                        $distri->duration_of_purchase_on_credit = json_encode($request->duration_of_purchase_on_credit);
                        $distri->duration_of_sale_on_credit = json_encode($request->duration_of_sale_on_credit);
                        $distri->any_other_information = json_encode($request->any_other_information);
                        $distri->average_purchase_price_a = json_encode($request->average_purchase_price_a);
                        $distri->average_purchase_price_b = json_encode($request->average_purchase_price_b);
                        $distri->average_purchase_price_c = json_encode($request->average_purchase_price_c);
                        $distri->average_purchase_price_d = json_encode($request->average_purchase_price_d);

                        $distri->transportation_cost = json_encode($request->transportation_cost);
                        $distri->loding_unloading_charge = json_encode($request->loding_unloading_charge);

                        $distri->primary_processing_cost = json_encode($request->primary_processing_cost);
                        $distri->drying_loss_or_any_other_loss = json_encode($request->drying_loss_or_any_other_loss);
                        $distri->establishment_cost = json_encode($request->establishment_cost);
                        $distri->marketing_cost = json_encode($request->marketing_cost);

                        $distri->stronge_cost = json_encode($request->stronge_cost);
                        $distri->any_other_cost = json_encode($request->any_other_cost);
                        $distri->selling_price_a = json_encode($request->selling_price_a);
                        $distri->selling_price_b = json_encode($request->selling_price_b);
                        $distri->selling_price_c = json_encode($request->selling_price_c);
                        $distri->selling_price_d = json_encode($request->selling_price_d);

                        $distri->quantum_handled_year = json_encode($request->quantum_handled_year);
                        $distri->purchase_and_selling_prices = json_encode($request->purchase_and_selling_prices);
                        $distri->government_support = json_encode($request->government_support);
                        $distri->market_demand = json_encode($request->market_demand);
                        $distri->niche_market = json_encode($request->niche_market);


                        $distri->availability_skilled_unskilled_labour = json_encode($request->availability_skilled_unskilled_labour);
                        $distri->infrastructure_and_support_services = json_encode($request->infrastructure_and_support_services);
                        $distri->quality_and_standard = json_encode($request->quality_and_standard);

                        $distri->competitor = json_encode($request->competitor);
                        $distri->cost_of_rinancial_resources = json_encode($request->cost_of_rinancial_resources);
                        $distri->social_factor = json_encode($request->social_factor);
                        
                        $distri->technological_factor = json_encode($request->technological_factor);
                        $distri->legal_factor = json_encode($request->legal_factor);
                        $distri->political_factor = json_encode($request->political_factor);

                        $distri->economic_factors = json_encode($request->economic_factors);
                        $distri->environmental_factor = json_encode($request->environmental_factor);
                        $distri->any_other = json_encode($request->any_other);
                        $distri->threat_social_factor = json_encode($request->threat_social_factor);
                        $distri->threat_technological_factor = json_encode($request->threat_technological_factor);
                        $distri->threat_legal_factor = json_encode($request->threat_legal_factor);
                        $distri->threat_political_factor = json_encode($request->threat_political_factor);
                        $distri->threat_economic_factors = json_encode($request->threat_economic_factors);
                        $distri->threat_environmental_factor = json_encode($request->threat_environmental_factor);
                        $distri->threat_any_other = json_encode($request->threat_any_other);                     
                        $distri->save();
                            
                    return response()->json([
                        'status' => true,
                        'message' => 'Distributor Data Created Successfully',
                    ], 200);
        }
            catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    
    
    public function fpoA(Request $request)
    {
        try{
            $validator = Validator::make($request->all(), [
                // 'average_purchase_price_a' => 'string',
            ]);
                    if ($validator->fails()) {
                        return response()->json([
                            'remark' => 'validation_error',
                            'status' => 'error',
                            'message' => ['error' => $validator->errors()],
                        ]);
                    }
                    
                        $fpoAs = new fpoA();
                        $fpoAs->user_id = Auth::user()->id;
                        $fpoAs->potential_marketable_and_marketed_surplus = json_encode($request->potential_marketable_and_marketed_surplus);
                        $fpoAs->extent_and_status_allied_agriculture_sector = json_encode($request->extent_and_status_allied_agriculture_sector);
                        $fpoAs->equity_share = json_encode($request->equity_share);
                        $fpoAs->equity_grant = json_encode($request->equity_grant);
                        $fpoAs->promotional_and_development = json_encode($request->promotional_and_development);
                        $fpoAs->interest_and_capital_subsidies = json_encode($request->interest_and_capital_subsidies);
                        $fpoAs->csr_fund = json_encode($request->csr_fund);
                        $fpoAs->donations_awards = json_encode($request->donations_awards);
                        $fpoAs->supply_credit = json_encode($request->supply_credit);
                        $fpoAs->input_credit = json_encode($request->input_credit);
                        $fpoAs->director_member_debt = json_encode($request->director_member_debt);
                        $fpoAs->reserve_and_surplus_form_busi = json_encode($request->reserve_and_surplus_form_busi);
                        $fpoAs->loan_and_advances = json_encode($request->loan_and_advances);
                        $fpoAs->bdos = json_encode($request->bdos);
                        $fpoAs->ceo = json_encode($request->ceo);
                        $fpoAs->managers = json_encode($request->managers);
                        $fpoAs->accountant = json_encode($request->accountant);
                        $fpoAs->supporting_staff = json_encode($request->supporting_staff);
                        $fpoAs->technologies_before_the_farm_link = json_encode($request->technologies_before_the_farm_link);
                        $fpoAs->technologies_farm_and_producer_link = json_encode($request->technologies_farm_and_producer_link);
                        $fpoAs->technologies_after_farm_link = json_encode($request->technologies_after_farm_link);
                        $fpoAs->flow_informat_on_and_knowledge_across = json_encode($request->flow_informat_on_and_knowledge_across);
                        $fpoAs->flow_of_information_of_actors = json_encode($request->flow_of_information_of_actors_and);
                        $fpoAs->brand_development_process_innovation_patent_gI_Indicator = json_encode($request->brand_development_process_innovation_patent_gI_Indicator);
                        $fpoAs->b2b_b2c_fpos = json_encode($request->b2b_b2c_fpos);
                        $fpoAs->corporate_linkages = json_encode($request->corporate_linkages);
                        $fpoAs->future_marketing = json_encode($request->future_marketing);
                        $fpoAs->contract_farming = json_encode($request->contract_farming);
                        $fpoAs->fpo_federation = json_encode($request->fpo_federation);
                        $fpoAs->inbound_infrastructure_and_services = json_encode($request->inbound_infrastructure_and_services);
                        $fpoAs->processing_infrastructure = json_encode($request->processing_infrastructure);
                        $fpoAs->outbound_infrastructure_and_services = json_encode($request->outbound_infrastructure_and_services);
                        $fpoAs->save();
                            
                    return response()->json([
                        'status' => true,
                        'message' => 'fpoA Data Created Successfully',
                    ], 200);
        }
            catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    
    public function fpoB(Request $request)
    {
        try{
            $validator = Validator::make($request->all(), [
                // 'ability_to_formulate_strategies' => 'string',
            ]);
                    if ($validator->fails()) {
                        return response()->json([
                            'remark' => 'validation_error',
                            'status' => 'error',
                            'message' => ['error' => $validator->errors()],
                        ]);
                    }
                    
                        $fpoBs = new fpoB();
                        $fpoBs->user_id = Auth::user()->id;
                        $fpoBs->ability_to_formulate_strategies = json_encode($request->ability_to_formulate_strategies);
                        $fpoBs->ability_to_innovate_process_method = json_encode($request->ability_to_innovate_process_method);

                        $fpoBs->ability_to_innovate_product_main = json_encode($request->ability_to_innovate_product_main);
                        $fpoBs->ability_to_innovate_technique = json_encode($request->ability_to_innovate_technique);
                        $fpoBs->ability_to_reduce_processing_cost = json_encode($request->ability_to_reduce_processing_cost);
                        $fpoBs->ability_to_deliver_on_time = json_encode($request->ability_to_deliver_on_time);
                        $fpoBs->ability_to_extent_quality_product = json_encode($request->ability_to_extent_quality_product);

                        $fpoBs->participation = json_encode($request->participation);
                        $fpoBs->status_of_statutory_and_legal_compliance = json_encode($request->status_of_statutory_and_legal_compliance);
                        $fpoBs->consensus_oriented = json_encode($request->consensus_oriented);
                        $fpoBs->equity_and_inclusiveness = json_encode($request->equity_and_inclusiveness);
                        $fpoBs->effectiveness_and_efficiency = json_encode($request->effectiveness_and_efficiency);
                        $fpoBs->accountability = json_encode($request->accountability);
                        $fpoBs->transparency = json_encode($request->transparency);
                        $fpoBs->responsiveness = json_encode($request->responsiveness);
                        $fpoBs->awareness_about_calculative_risk_taking_capacity = json_encode($request->awareness_about_calculative_risk_taking_capacity);
                        $fpoBs->ability_take_decision_per_the_calculative_risk = json_encode($request->ability_take_decision_per_the_calculative_risk);
                        $fpoBs->ability_collaboration_with_other_vCAs = json_encode($request->ability_collaboration_with_other_vCAs);
                        $fpoBs->ability_to_extend_cheaper_inputs = json_encode($request->ability_to_extend_cheaper_inputs);
                        $fpoBs->ability_to_extend_premimus_price = json_encode($request->ability_to_extend_premimus_price);
                        $fpoBs->ability_to_reduce_marketing_cost = json_encode($request->ability_to_reduce_marketing_cost);
                        $fpoBs->ability_to_reduce_bargaining_cost = json_encode($request->ability_to_reduce_bargaining_cost);
                        $fpoBs->ability_to_reduce_delivering_cost = json_encode($request->ability_to_reduce_delivering_cost);
                      
                        $fpoBs->save();
                            
                    return response()->json([
                        'status' => true,
                        'message' => 'fpoB Data Created Successfully',
                    ], 200);
        }
            catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    

}
